# Lowdefy Contributor Guide

- [Starting the Lowdefy server](#starting-the-lowdefy-server)
- [Asking a question](#asking-a-question)
- [Reporting bugs](#reporting-bugs)
- [Suggesting features](#suggesting-features)
- [Improving the documentation](#improving-the-documentation)
- [Responding to questions](#responding-to-questions)
- [Contributing code](#contributing-code)

## Starting the Lowdefy server

Run Lowdefy servers locally by adding your Lowdefy config to the `app/..` folder. Use one of the following scripts to the server:

- `yarn start`: Starts the production server.
- `yarn start:dev`: Starts the production server in next development mode, useful for debugging Lowdefy code changes.
- `yarn start:server-dev`: Starts the development server in next production mode, useful for developing your Lowdefy config locally.

> `yarn install` and `yarn build` should be executed manually during development, this allows you to build only the package you are working on. Server needs to be restarted after package rebuild.

## Asking a question

If you aren't sure how something works, or you are stuck with something, ask a question in our [Community forum](https://github.com/lowdefy/lowdefy/discussions). This will help others with the same questions, and help us improve.

## Reporting bugs

If you encounter a bug, you can file an issue on Github. Please first search to see if a similar bug has already been reported. If it has, you can add additional information, or add a 👍 reaction to indicate your agreement.

When filing an issue, please add as much information as you can, especially with regards to how to reproduce the bug. This will help us narrow down the issue and fix it faster. Adding some example configuration, or a link to a project that reproduces the issue would be best.

If your issue is a question or configuration problem, we might convert the issue into a discussion.

## Suggesting features

We would love to hear your ideas on how to make Lowdefy better. Please share them with us in our [Community forum](https://github.com/lowdefy/lowdefy/discussions), and upvote ideas that you would like to see happen. We also have a [new connections voting board](https://github.com/lowdefy/lowdefy/discussions/309), where you can vote on which connections should be implemented next.

## Improving the documentation

You can improve the documentation by providing feedback at the bottom of the page, or by starting a [discussion](https://github.com/lowdefy/lowdefy/discussions/categories/docs).

You can also use the "Edit this page on Github" link to make changes and create a pull request with your suggested changes.

## Contributing code

If you would like to contribute to the project, please contact us at hello@lowdefy.com and we will help you get started.
