export default ({ isDark, base }) => ({
    plugins: "mapomedia preview paste importcss searchreplace autolink directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor insertdatetime advlist lists wordcount textpattern noneditable help charmap quickbars emoticons",
    menubar: "file edit view insert format tools table help",
    menu: {
        insert: {
            title: "Insert",
            items: "link mapomedia media template codesample inserttable | charmap emoticons hr | pagebreak nonbreaking anchor | insertdatetime",
        },
    },
    toolbar: "undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview | mapomedia media template link anchor codesample | ltr rtl",
    toolbar_sticky: true,
    image_advtab: true,
    importcss_append: true,
    template_cdate_format: "[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]",
    template_mdate_format: "[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]",
    height: 400,
    image_caption: true,
    quickbars_insert_toolbar: "mapomedia quicktable",
    quickbars_selection_toolbar: "bold italic | quicklink h2 h3 blockquote mapomedia quicktable",
    noneditable_noneditable_class: "mceNonEditable",
    toolbar_mode: "sliding",
    contextmenu: "link mapomedia table",
    skin_url: isDark ? `${base}mapo/tinymce-skins/mapo-dark` : `${base}mapo/tinymce-skins/mapo-light`,
    content_style: "body { font-family:Helvetica,Arial,sans-serif; font-size:14px }",
});
