/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : HoloLens_20.h
    Date                : 10.03.2019
    Font size in bytes  : 0x24B2, 9394
    Font width          : 21
    Font height         : 31
    Font first char     : 0x0B
    Font last char      : 0xFF
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#include "FontDesc.h"

#ifndef HoloLens_20_FONT_H
#define HoloLens_20_FONT_H

#define HoloLens_20_WIDTH  21
#define HoloLens_20_HEIGHT 31

static unsigned char const HoloLens_20_Bytes[] = {
    0x06, 0x0D, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x0C, 0x0A, 0x11, 0x0B, 0x03, 0x06, 0x06, 0x08, 0x0B, 0x03, 0x06, 0x03, 0x07, 0x0A, 0x06, 0x0A, 0x0A, 0x0B, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x03, 0x03, 0x0B, 0x0B, 0x0B, 0x09, 0x13, 0x0E, 0x0B, 0x0D, 0x0C, 0x0B, 0x0B, 0x0D, 0x0C, 0x03, 0x09, 0x0D, 0x0B, 0x0F, 0x0C, 0x0E, 0x0B, 0x0E, 0x0C, 0x0C, 0x0D, 0x0C, 0x0E, 0x14, 0x0E, 0x0D, 0x0A, 0x05, 0x07,
    0x05, 0x08, 0x0C, 0x05, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x05, 0x0A, 0x0A, 0x03, 0x04, 0x0A, 0x03, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x06, 0x09, 0x06, 0x0A, 0x0B, 0x0F, 0x0B, 0x0B, 0x09, 0x07, 0x03, 0x07, 0x08, 0x06, 0x0B, 0x00, 0x05, 0x0B, 0x08, 0x0E, 0x09, 0x09, 0x07, 0x18, 0x0D, 0x07, 0x13, 0x00, 0x0B, 0x00, 0x00, 0x05, 0x05, 0x08, 0x08, 0x08, 0x0B, 0x15, 0x08, 0x0F, 0x0A, 0x07, 0x13, 0x00, 0x0A, 0x0D, 0x00, 0x05, 0x0B, 0x0B, 0x0B, 0x0C, 0x04, 0x0B, 0x08, 0x10, 0x07, 0x0B, 0x0C, 0x07, 0x10,
    0x0C, 0x07, 0x0C, 0x07, 0x07, 0x07, 0x0C, 0x0C, 0x04, 0x06, 0x06, 0x07, 0x0B, 0x10, 0x11, 0x10, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x05, 0x06, 0x06, 0x06, 0x0D, 0x0D, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0B, 0x0F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x11, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x04, 0x06, 0x06, 0x06, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x00,
    0xFE, 0xFF, 0x03, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0x01, 0x80, 0x00, 0xC0, 0x00, 0x40, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xC0, 0xFF, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x7C, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0x30,
    0x00, 0x10, 0x00, 0x18, 0x00, 0x08, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x06, 0x00, 0x02, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF,
    0xFF, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x10, 0x00, 0x18, 0x00, 0x08, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0x0C, 0x00,
    0x04, 0x00, 0x06, 0x00, 0x02, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x10, 0x00, 0x18, 0x00, 0x08, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x01, 0x80, 0x01, 0x80, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F,
    0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x06, 0x00, 0x02, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x10, 0x00, 0x18, 0x00, 0x08, 0x00, 0xFC, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0x03, 0x00, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0xF0, 0xFF, 0x1F, 0x00, 0xF8, 0xFF, 0x0F, 0x00, 0xF0, 0x7F, 0x06, 0x00, 0xF8, 0x3F, 0x03, 0x00, 0xFC, 0x9F, 0x01,
    0x00, 0x3E, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0xC0, 0xD8, 0x01, 0x00, 0x60, 0xFF, 0x00, 0x00, 0xF8, 0x7F, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xC0, 0x9F, 0x1D, 0x00, 0xE0, 0xF6, 0x0F, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xF8, 0x7F, 0x00, 0x00, 0xFC, 0x19, 0x00, 0x00, 0x6E, 0x0C, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1E, 0x0C, 0x00, 0x80, 0x1F, 0x0E, 0x00, 0xE0, 0x1F, 0x0F, 0x00,
    0x70, 0x0E, 0x07, 0x00, 0xFE, 0xFF, 0x0F, 0x00, 0xFF, 0xFF, 0x07, 0x00, 0x0E, 0xE3, 0x00, 0x00, 0x8F, 0x7F, 0x00, 0x00, 0xC7, 0x1F, 0x00, 0x00, 0xC3, 0x07, 0x00, 0x80, 0x07, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x86, 0xE1, 0x00, 0x00, 0xFF, 0x38, 0x00, 0x00, 0x3F, 0x07, 0x00, 0x00, 0xEF, 0x01, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0xE7, 0x01, 0x00, 0xC0, 0xF9, 0x01, 0x00, 0x38, 0xFE, 0x01, 0x00, 0x0E, 0xC3, 0x00, 0x00, 0x81, 0x61, 0x00, 0x00,
    0xC0, 0x3F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x78, 0xFE, 0x01, 0x00, 0xFE, 0xE3, 0x00, 0x00, 0xFF, 0x60, 0x00, 0x80, 0xF1, 0x31, 0x00, 0xC0, 0xFF, 0x1D, 0x00, 0xE0, 0xE7, 0x07, 0x00, 0xE0, 0xF1, 0x07, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x9C, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0xC0, 0xFF, 0x3F, 0x00, 0xF8, 0x01, 0x7E, 0x00, 0x1C,
    0x00, 0x38, 0x00, 0x02, 0x00, 0x10, 0x00, 0x01, 0x00, 0x08, 0x80, 0x03, 0x00, 0x07, 0xC0, 0x0F, 0xF0, 0x03, 0x80, 0xFF, 0x7F, 0x00, 0x00, 0xFF, 0x0F, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x00, 0xFF,
    0x03, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x30, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x7E, 0x00, 0x00, 0xE0, 0x07,
    0x00, 0x00, 0x7E, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0x1E, 0xF0, 0x00, 0x00, 0x03, 0x60, 0x00, 0x80, 0x01, 0x30, 0x00, 0xC0, 0x03, 0x1E, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xE0, 0xFF, 0x03, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xC0, 0x00, 0x06, 0x00, 0x70, 0x80, 0x03,
    0x00, 0x3C, 0xE0, 0x01, 0x00, 0x0E, 0xF8, 0x00, 0x00, 0x03, 0x6E, 0x00, 0x80, 0x81, 0x33, 0x00, 0xC0, 0xF1, 0x18, 0x00, 0xE0, 0x3F, 0x0C, 0x00, 0xE0, 0x0F, 0x06, 0x00, 0xE0, 0x01, 0x03, 0x00, 0x30, 0x60, 0x00, 0x00, 0x1C, 0x70, 0x00, 0x00, 0x0F, 0x78, 0x00, 0x80, 0x03, 0x38, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x18, 0x0C, 0x00, 0xF0, 0x1F, 0x07, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0xF0, 0xFE, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00,
    0x00, 0xDE, 0x00, 0x00, 0x80, 0x67, 0x00, 0x00, 0xF0, 0x31, 0x00, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x1E, 0x03, 0x00, 0xF0, 0x8F, 0x03, 0x00, 0xF8, 0xC7, 0x03, 0x00, 0xBC, 0xC1, 0x01, 0x00, 0xC6, 0xC0, 0x00, 0x00, 0x63, 0x60, 0x00, 0x80, 0x71, 0x38, 0x00, 0xC0, 0xF8, 0x1F, 0x00, 0x60, 0xF8, 0x07, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x80, 0x7F, 0x00, 0x00, 0xF0, 0xFF, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00,
    0xEF, 0x78, 0x00, 0x80, 0x31, 0x30, 0x00, 0xC0, 0x18, 0x18, 0x00, 0xE0, 0x1C, 0x0E, 0x00, 0xF0, 0xFE, 0x07, 0x00, 0x70, 0xFE, 0x01, 0x00, 0x30, 0x3E, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x20, 0x00, 0xC0, 0x00, 0x1E, 0x00, 0x60, 0xE0, 0x0F, 0x00, 0x30, 0xFC, 0x03, 0x00, 0xD8, 0x3F, 0x00, 0x00, 0xFC, 0x03, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xC7, 0x0F, 0x00, 0xC0, 0xFF, 0x0F, 0x00, 0xF0, 0x1F, 0x07, 0x00, 0x18,
    0x0F, 0x03, 0x00, 0x8C, 0x87, 0x01, 0x00, 0xFE, 0xE3, 0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, 0x8E, 0x1F, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x1F, 0x03, 0x00, 0xE0, 0x9F, 0x03, 0x00, 0xF8, 0xDF, 0x03, 0x00, 0x1C, 0xCE, 0x01, 0x00, 0x06, 0xC6, 0x00, 0x00, 0x03, 0x73, 0x00, 0x80, 0xC7, 0x3D, 0x00, 0x80, 0xFF, 0x0F, 0x00, 0xC0, 0xFF, 0x03, 0x00, 0x80, 0x7F, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x80, 0x81, 0x01, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x60, 0x60, 0x02, 0x00, 0x30, 0xF0, 0x01, 0x00, 0x18,
    0x78, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x38, 0x07, 0x00, 0x00, 0x0C, 0x03, 0x00, 0x00, 0x86, 0x01, 0x00, 0x80, 0xC3, 0x01, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x80, 0x19, 0x00, 0x00, 0xC0, 0x0C, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x30, 0x03, 0x00, 0x00, 0x98, 0x01, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x80, 0x19, 0x00, 0x00, 0xC0, 0x0C,
    0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0E, 0x07, 0x00, 0x00, 0x86, 0x01, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x80, 0x73, 0x00, 0x00, 0x80, 0x19, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x0E, 0xCE, 0x00, 0x00, 0x83, 0x67, 0x00, 0x80, 0xE3, 0x33, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xC0, 0x03, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0x00, 0x80, 0xFF, 0x03, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0x7C, 0xC0, 0x03, 0x00, 0x8F, 0x8F, 0x03, 0x80, 0xF1, 0x8F, 0x01, 0x60, 0xFC, 0x8F, 0x01, 0x30, 0x0F, 0xC7, 0x00, 0x88, 0x03, 0x43, 0x00, 0xC4, 0xC0, 0x21, 0x00, 0xE2, 0xFC, 0x10, 0x00, 0xF1, 0x7F, 0x08, 0x80, 0xF9, 0x3F, 0x04, 0xC0, 0xFC, 0x18, 0x03, 0xC0, 0x02, 0x8E, 0x01, 0xE0, 0xC1, 0x43, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0xE0, 0x7F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x3E, 0x00,
    0x00, 0xC0, 0x1F, 0x00, 0x00, 0xFC, 0x03, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xF8, 0x37, 0x00, 0x00, 0x7C, 0x18, 0x00, 0x00, 0x3E, 0x0C, 0x00, 0x00, 0xFF, 0x06, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x18, 0x0C, 0x00, 0x70, 0x0E, 0x06, 0x00, 0xF8, 0x8F, 0x03, 0x00, 0xF8, 0xFF, 0x01, 0x00,
    0x78, 0x7F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x07, 0x00, 0xE0, 0xC1, 0x03, 0x00, 0x38, 0x80, 0x03, 0x00, 0x0C, 0x80, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x03, 0x60, 0x00, 0x80, 0x03, 0x38, 0x00, 0xC0, 0x01, 0x1C, 0x00, 0xC0, 0x83, 0x07, 0x00, 0xC0, 0xC1, 0x01, 0x00, 0xC0, 0x60, 0x00, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0x01, 0x30, 0x00, 0xC0, 0x00, 0x18, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x30,
    0x00, 0x06, 0x00, 0x38, 0x80, 0x03, 0x00, 0x38, 0xE0, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0x18, 0x06, 0x03, 0x00, 0x0C, 0x83, 0x01, 0x00, 0x86, 0xC1, 0x00, 0x00, 0xC3, 0x60, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x18, 0x0C, 0x00, 0x30, 0x00, 0x06, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x80, 0x61,
    0x00, 0x00, 0xC0, 0x30, 0x00, 0x00, 0x60, 0x18, 0x00, 0x00, 0x30, 0x0C, 0x00, 0x00, 0x18, 0x06, 0x00, 0x00, 0x0C, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x80, 0xFF, 0x0F, 0x00, 0xC0, 0x83, 0x07, 0x00, 0x70, 0x00, 0x07, 0x00, 0x18, 0x00, 0x03, 0x00, 0x0C, 0x86, 0x01, 0x00, 0x06, 0xC3, 0x00, 0x00, 0x87, 0x71, 0x00, 0x80, 0xC3, 0x38, 0x00, 0x80, 0xE7, 0x1F, 0x00, 0x80, 0xF3, 0x0F, 0x00, 0x80, 0xF9, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF,
    0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x38, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x07,
    0x00, 0xF0, 0xFF, 0x01, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xC0, 0xF1, 0x00, 0x00, 0x70, 0xF0, 0x00, 0x00, 0x1C, 0xF0, 0x00, 0x00, 0x06, 0xE0, 0x00, 0x00, 0x01, 0x60, 0x00, 0x00, 0x00, 0x20, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00,
    0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xFC, 0x03, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00,
    0xFC, 0xFF, 0x01, 0x00, 0x7C, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0xE0, 0x03, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x80, 0xFF, 0x0F, 0x00, 0xC0, 0x83, 0x07, 0x00, 0x70, 0x00, 0x07, 0x00, 0x18, 0x00, 0x03, 0x00, 0x0C, 0x80, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x03, 0x60, 0x00, 0x80, 0x03, 0x38, 0x00, 0x80, 0x07, 0x0F, 0x00, 0xC0,
    0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0xC1, 0x00, 0x00, 0xC0, 0x60, 0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x30, 0x18, 0x00, 0x00, 0x38, 0x0E, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x07, 0x00, 0xE0, 0xC1, 0x03, 0x00, 0x38, 0x80, 0x03, 0x00, 0x0C, 0x80, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x03,
    0x68, 0x00, 0x80, 0x01, 0x3E, 0x00, 0xC0, 0x01, 0x1F, 0x00, 0xC0, 0x83, 0x07, 0x00, 0xE0, 0xFF, 0x07, 0x00, 0xE0, 0xFF, 0x07, 0x00, 0xC0, 0x1F, 0x03, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0x60, 0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x30, 0x18, 0x00, 0x00, 0x18, 0x1C, 0x00, 0x00, 0x0C, 0x1E, 0x00, 0x00, 0x8E, 0x7F, 0x00, 0x00, 0xFF, 0x7E, 0x00, 0x00, 0x7F, 0x3C, 0x00, 0x00, 0x0F, 0x10, 0x00, 0x80, 0x87, 0x01, 0x00, 0xE0, 0xC7, 0x03, 0x00, 0xF0, 0xE3,
    0x01, 0x00, 0x9C, 0xC3, 0x01, 0x00, 0x86, 0xE1, 0x00, 0x00, 0xC3, 0x60, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x70, 0x18, 0x00, 0xE0, 0x30, 0x0E, 0x00, 0xE0, 0xF8, 0x03, 0x00, 0x70, 0xF8, 0x01, 0x00, 0x30, 0x78, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00,
    0x00, 0x60, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x00, 0x00, 0xF8, 0xFF, 0x01, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x07, 0x00, 0xF8, 0xFF, 0x01, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x80, 0x7F, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFC, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xF8, 0x00,
    0x00, 0x80, 0x7F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0xC0, 0xFF, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0xE0, 0x07, 0x00,
    0x00, 0xFE, 0x03, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x40, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x70, 0x00, 0x07, 0x00, 0xF0, 0xE0, 0x01, 0x00, 0xF0, 0x78, 0x00, 0x00, 0xF0, 0x1E, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xDE, 0x03, 0x00, 0x80, 0xC7, 0x03, 0x00, 0xE0, 0xC1, 0x03, 0x00, 0x38, 0x80, 0x03, 0x00, 0x0C, 0x80, 0x01, 0x00, 0x02, 0x80, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0xC0,
    0x07, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0xFF, 0x01, 0x00, 0xC0, 0xFF, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x80, 0x03, 0x00, 0x0C, 0xE0, 0x01, 0x00, 0x06, 0xFC, 0x00, 0x00, 0x83, 0x6F, 0x00, 0x80, 0xE1, 0x33, 0x00, 0xC0, 0x7C, 0x18, 0x00, 0x60, 0x1F, 0x0C, 0x00, 0xF0, 0x03, 0x06, 0x00, 0x78, 0x00, 0x03, 0x00, 0x1C, 0x80, 0x01, 0x00, 0xFE,
    0xFF, 0x1F, 0x00, 0xFF, 0xFF, 0x0F, 0x80, 0xFF, 0xFF, 0x07, 0xC0, 0x00, 0x00, 0x03, 0x60, 0x00, 0x80, 0x01, 0x10, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x18, 0x00, 0x60, 0x00, 0x80, 0x01, 0x30, 0x00, 0xC0, 0x00, 0xF8, 0xFF, 0x7F, 0x00, 0xFC, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0x1F, 0x00, 0x20, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xF0, 0x01,
    0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x20, 0x1E,
    0x00, 0x00, 0x98, 0x1F, 0x00, 0x00, 0xEE, 0x0F, 0x00, 0x00, 0x73, 0x06, 0x00, 0x80, 0x19, 0x03, 0x00, 0xC0, 0x8C, 0x01, 0x00, 0x60, 0xE6, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xC0, 0xC1, 0x01, 0x00, 0x60, 0xC0, 0x00, 0x00, 0x30, 0x60, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x80, 0xFF, 0x00,
    0x00, 0xE0, 0xFF, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x0C, 0x18, 0x00, 0x00, 0x06, 0x0C, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x41, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x06, 0x0C, 0x00, 0x00, 0x03, 0x06, 0x00, 0x80, 0x83, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0xFE, 0x0F, 0x00,
    0x00, 0x37, 0x07, 0x00, 0x80, 0x19, 0x03, 0x00, 0xC0, 0x8C, 0x01, 0x00, 0xE0, 0xC6, 0x00, 0x00, 0xF0, 0x73, 0x00, 0x00, 0xF0, 0x19, 0x00, 0x00, 0xF0, 0x04, 0x00, 0x00, 0x06, 0x00, 0x00, 0xE0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0x66, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x06, 0x00, 0xF0, 0x1F, 0x07, 0x00, 0xFC, 0x9F, 0x03, 0x00, 0x0E, 0x8E, 0x01, 0x00, 0x03, 0xC6, 0x00, 0x80, 0x01, 0x63, 0x00, 0xC0, 0xC1, 0x39, 0x00, 0xE0, 0xFF, 0x1F, 0x00, 0xF0, 0xFF, 0x07, 0x00,
    0xF8, 0xFF, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0x80, 0x03, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x30, 0xFF, 0x07, 0x00, 0x98, 0xFF, 0x03, 0x00, 0xCC, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0xF3, 0xFF, 0x0F, 0x80, 0xF9, 0xFF, 0x07, 0xC0, 0xFC, 0xFF, 0x01, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0x00,
    0x0E, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xE0, 0x1E, 0x00, 0x00, 0x38, 0x1E, 0x00, 0x00, 0x0C, 0x1E, 0x00, 0x00, 0x02, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xE0, 0x7F, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06,
    0x00, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x80, 0xFF, 0x03, 0x00, 0x80, 0xFF, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0xC0, 0xFF, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0x07, 0x07, 0x00, 0x80, 0x01, 0x03, 0x00, 0xC0, 0x80, 0x01, 0x00, 0xE0, 0xE0, 0x00, 0x00, 0xF0, 0x7F,
    0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFE, 0xFF, 0x01, 0x00, 0xFF, 0xFF, 0x00, 0x80, 0xFF, 0x7F, 0x00, 0xC0, 0xC1, 0x01, 0x00, 0x60, 0xC0, 0x00, 0x00, 0x30, 0x60, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x0C, 0x18, 0x00, 0x00, 0x0E, 0x0E, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x80, 0xFF, 0x7F,
    0x00, 0xC0, 0xFF, 0x3F, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x8F, 0x01, 0x00, 0x80, 0xC7, 0x00, 0x00, 0xE0, 0xE7, 0x00, 0x00, 0x30, 0x63, 0x00, 0x00, 0x98, 0x31, 0x00, 0x00, 0xCC, 0x19, 0x00, 0x00, 0xCE, 0x0F, 0x00, 0x00, 0xE6, 0x03, 0x00, 0x00, 0xE3, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, 0xFF, 0x3F, 0x00, 0x00, 0x0C, 0x18, 0x00,
    0x00, 0x06, 0x0C, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x80, 0xFF, 0x01, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x80, 0xFF, 0x03, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00,
    0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0xFF, 0x01, 0x00, 0xE0, 0x1F, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x3C, 0x1E, 0x00, 0x00, 0xBC, 0x07, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00,
    0x38, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xC0, 0x7B, 0x00, 0x00, 0xF0, 0x78, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x80, 0x3F, 0x60, 0x00, 0x00, 0x7F, 0x38, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0xC0, 0x01, 0x00, 0x60, 0xF0, 0x00, 0x00, 0x30, 0x7C, 0x00, 0x00, 0x18, 0x37, 0x00, 0x00, 0xCC,
    0x19, 0x00, 0x00, 0x76, 0x0C, 0x00, 0x00, 0x1F, 0x06, 0x00, 0x80, 0x07, 0x03, 0x00, 0xC0, 0x81, 0x01, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xFF, 0xFF, 0x03, 0xC0, 0xFF, 0xFF, 0x03, 0xE0, 0x1F, 0xFF, 0x01, 0x30, 0x00, 0xC0, 0x00, 0x18, 0x00, 0x60, 0x00, 0xFC, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0x1F, 0x00, 0xFF, 0xFF, 0x0F, 0x80, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x1F, 0xFF, 0x01, 0xF0, 0xFF, 0xFF, 0x00, 0xF0, 0xFF, 0x3F, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x0C,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0x20, 0x00, 0x08, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0x80, 0x0D, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xFE, 0x3F, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xD9, 0x1C, 0x00, 0x60, 0x6C, 0x0C, 0x00, 0x30, 0x06, 0x06,
    0x00, 0x38, 0x80, 0x03, 0x00, 0x7C, 0xF0, 0x01, 0x00, 0x3C, 0x78, 0x00, 0x00, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0C, 0xFC, 0x03, 0x00, 0xFE, 0xFF, 0x01, 0xE0, 0xFF, 0x3F, 0x00, 0xF8, 0x7F, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00,
    0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x03, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x84, 0x00, 0x00, 0xC0, 0xFF, 0x03, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0xF0, 0xFF, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x30,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xC0, 0x18, 0x08, 0x00, 0x20, 0x08, 0x06, 0x00, 0x30, 0xC6, 0x03, 0x00, 0xF8, 0xF3, 0x00, 0x00, 0xF8, 0x1E, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0xBC, 0x0F, 0x00, 0x80, 0xE7, 0x0F, 0x00, 0xE0, 0x31, 0x06, 0x00, 0x30, 0x08, 0x02, 0x00, 0x08, 0x8C, 0x01, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00,
    0x1F, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x60, 0x0C, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x06, 0x00, 0x80, 0x1F, 0x0F, 0x00, 0xC0, 0x8F, 0x07, 0x00, 0x71, 0x0E, 0x07, 0x80, 0x19, 0x86, 0x03, 0xC0, 0x0D, 0x83, 0x01, 0xC0, 0x86, 0xC1, 0x00, 0x70, 0xC3, 0x61, 0x00, 0x98, 0xC3, 0x38, 0x00, 0x84, 0xE3, 0x0F, 0x00, 0xC0, 0xE1, 0x07, 0x00, 0xC0, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
    0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xE0, 0x0E, 0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0x0F, 0x78, 0x00, 0x80, 0x03, 0x38, 0x00, 0xC0, 0x00, 0x18, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x70, 0x00, 0x07, 0x00, 0x78, 0xC0, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x18, 0x0C,
    0x00, 0x30, 0x0C, 0x06, 0x00, 0x18, 0x06, 0x03, 0x00, 0x0C, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x70, 0x00, 0x80, 0x01, 0x3C, 0x00, 0xC4, 0x80, 0x1F, 0x00, 0x66, 0xF0, 0x0D, 0x00, 0x37, 0x7C, 0x06, 0x00, 0x9B, 0x0F, 0x03, 0xC0, 0xED, 0x83, 0x01, 0x60, 0x7E, 0xC0, 0x00, 0x10, 0x0F, 0x60, 0x00, 0x80, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x0F, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0E, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x03, 0x00, 0x08, 0x8F,
    0x01, 0x00, 0xCC, 0xCF, 0x01, 0x00, 0x6E, 0xC6, 0x00, 0x00, 0x36, 0x63, 0x00, 0x80, 0x9B, 0x33, 0x00, 0xC0, 0x9C, 0x1F, 0x00, 0x20, 0xCC, 0x07, 0x00, 0x00, 0xC6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x80, 0x31, 0x00, 0x00, 0xC0, 0x1D, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x0C, 0x18,
    0x00, 0x00, 0x06, 0x0C, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xE0, 0x7F, 0x00, 0x00, 0x70, 0x73, 0x00, 0x00, 0x98, 0x31, 0x00, 0x00, 0xCC, 0x18, 0x00, 0x00, 0x6E, 0x0C, 0x00, 0x00, 0x3F, 0x07, 0x00, 0x00, 0x9F, 0x01, 0x00, 0x00, 0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 0x00, 0x80, 0x18, 0x3C, 0x00, 0xC0, 0x0C, 0x1F, 0x00, 0xE0, 0xC6, 0x0D, 0x00, 0x60, 0x73, 0x06, 0x00, 0xB8, 0x1D, 0x03, 0x00, 0xCC, 0x87, 0x01, 0x00, 0xE2, 0xC1, 0x00,
    0x00, 0x70, 0x60, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xE6, 0x03, 0x00, 0x00, 0xC3, 0x07, 0x00, 0x80, 0x81, 0xFF, 0x01, 0x00, 0x80, 0xFF, 0x00, 0x60, 0xE0, 0x7F, 0x00, 0x30, 0x7C, 0x00, 0x00, 0x98, 0x0F, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xFF, 0x0F, 0x00, 0x98, 0xFF, 0x07, 0x00, 0xCC, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00,
    0x00, 0xFF, 0x01, 0x00, 0xC0, 0xFF, 0x07, 0x00, 0xE0, 0xF0, 0x03, 0x00, 0x30, 0x7F, 0x00, 0x00, 0xF8, 0x33, 0x00, 0x00, 0x3F, 0x18, 0x00, 0x80, 0x0F, 0x0E, 0x00, 0x00, 0x06, 0x03, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x86, 0x01, 0x00, 0xF8, 0xE3, 0x00, 0x00, 0xFE, 0x3F, 0x00, 0x80, 0xFF, 0x1F, 0x00, 0xC0, 0xE1, 0x0D, 0x00, 0x60, 0x30, 0x06, 0x00, 0x30, 0x18, 0x07, 0x00, 0x38, 0x0C, 0x03, 0x00, 0x3C, 0x80, 0x01, 0x00, 0x1C, 0xE0, 0x00, 0x00, 0x0C, 0x70, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00,
    0xFE, 0x07, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x80, 0x73, 0x00, 0x00, 0xC0, 0x30, 0x00, 0x00, 0xE0, 0x1C, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x02, 0x01, 0x00, 0x70, 0xD8, 0x00, 0x00, 0x78, 0x6C, 0x00, 0x00, 0xF8, 0x36, 0x00, 0x00, 0xF0, 0x1B, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xBF, 0x01, 0x00, 0xE0, 0xDB, 0x00, 0x00, 0x78, 0x6C, 0x00, 0x00, 0x1C, 0x36, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0xF8, 0x07, 0xC0, 0x3F, 0xFC, 0x03, 0xE0, 0x1F, 0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x70, 0x3F, 0x0C, 0x00, 0xFE, 0x3F, 0x0E, 0x00, 0x7F, 0x3C, 0x0F, 0x80, 0x79, 0x1C, 0x06, 0xC0, 0x78, 0x1C, 0x03, 0xE0, 0x78, 0xFE, 0x01, 0x60, 0xF8, 0x7F, 0x00, 0x30, 0xF8, 0x1C, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00,
    0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0x0E, 0x0E, 0x00, 0x80, 0x01, 0x0C, 0x00, 0x40, 0x7C, 0x04, 0x00, 0x30, 0x7F, 0x06, 0x00, 0xC8, 0x7F, 0x02, 0x00, 0x64, 0x30, 0x01, 0x00, 0x12, 0x90, 0x00, 0x00, 0x19, 0x4C, 0x00, 0x80, 0x0D, 0x36, 0x00, 0x80, 0x04, 0x09, 0x00, 0xC0, 0x00, 0x06, 0x00, 0xC0, 0xC1, 0x01, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0x64, 0x02, 0x00, 0x00, 0x7B, 0x01, 0x00, 0x80, 0xBD, 0x00,
    0x00, 0x40, 0x52, 0x00, 0x00, 0xE0, 0x2F, 0x00, 0x00, 0xF0, 0x17, 0x00, 0x00, 0xF0, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x78, 0x0F, 0x00, 0x00, 0x4C, 0x06, 0x00, 0x00, 0x72, 0x02, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x80, 0xF7, 0x00, 0x00, 0xC0, 0x60, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00,
    0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x70, 0x70, 0x00, 0x00, 0x0C, 0x60, 0x00, 0x00, 0xF2, 0x2F, 0x00, 0x80, 0xF9, 0x37, 0x00, 0x40, 0xFC, 0x13, 0x00, 0x20, 0x22, 0x08, 0x00,
    0x10, 0x71, 0x04, 0x00, 0x88, 0x7F, 0x02, 0x00, 0xCC, 0xBF, 0x01, 0x00, 0xC4, 0x51, 0x00, 0x00, 0x06, 0x30, 0x00, 0x00, 0x0E, 0x0E, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x61, 0x00, 0x00, 0xC0, 0x30, 0x00, 0x00, 0x60, 0x18, 0x00, 0x00, 0x30, 0x0C, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x03, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x80, 0x61, 0x00, 0x00, 0xC0, 0x30, 0x00, 0x00, 0x60, 0x18, 0x00, 0x40, 0x08, 0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 0x98, 0x03, 0x00, 0x00, 0xE4,
    0x01, 0x00, 0x00, 0xBE, 0x00, 0x00, 0x00, 0x4F, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x60, 0x0C, 0x00, 0x00, 0xB0, 0x06, 0x00, 0x00, 0x48, 0x02, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0xEE, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x07, 0x00, 0xFC, 0xFF, 0x03, 0x00, 0xFE,
    0xFF, 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xC0, 0x03, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0xFC, 0x03, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x0F, 0x80, 0xFF, 0xFF, 0x07, 0xC0, 0xFF, 0xFF, 0x03, 0x60, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0xFF, 0x00, 0xF8, 0xFF, 0x7F, 0x00, 0xFC, 0xFF, 0x3F, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x00, 0x80, 0xBF, 0x00, 0x00, 0xC0, 0x5F, 0x00, 0x00, 0x20, 0x28, 0x00, 0x00, 0xF0, 0x17, 0x00, 0x00, 0xF8, 0x0B, 0x00,
    0x00, 0xF8, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x30, 0x18, 0x00, 0x00, 0x78, 0x0F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x72, 0x02, 0x00, 0x00, 0x93, 0x01, 0x00, 0x80, 0xF7, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x02, 0x00, 0xFC, 0x81, 0x01, 0x00, 0xFE, 0x60, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0xE0, 0x00, 0x00,
    0x00, 0x38, 0x06, 0x00, 0x00, 0x86, 0x03, 0x00, 0xC0, 0x71, 0x01, 0x00, 0x70, 0xFC, 0x01, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x03, 0x7F, 0x00, 0x80, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0xF8, 0x03, 0x03, 0x00, 0xFC, 0xC1, 0x00, 0x00, 0xFE, 0x38, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x80, 0x23, 0x04, 0x00, 0xE0, 0x18, 0x03, 0x00, 0x18, 0xCC, 0x01, 0x00, 0x06, 0xF2, 0x00, 0x00,
    0x01, 0x5F, 0x00, 0x00, 0x80, 0x27, 0x00, 0x00, 0x80, 0x11, 0x00, 0x40, 0x04, 0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 0x58, 0x03, 0x02, 0x00, 0x24, 0x81, 0x01, 0x00, 0xFE, 0x60, 0x00, 0x00, 0x77, 0x1C, 0x00, 0x00, 0x1B, 0x07, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x06, 0x03, 0x00, 0xC0, 0xC1, 0x01, 0x00, 0x70, 0xB8, 0x00, 0x00, 0x0C, 0xFE, 0x00, 0x00, 0x03, 0x7F, 0x00, 0x80, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x1F, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x30, 0x3F, 0x0E, 0x00, 0x98, 0x0F, 0x06, 0x00, 0xCC, 0x81, 0x03, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x04, 0xFF, 0x01, 0x00, 0xE6, 0xDF, 0x00, 0x00, 0xF7, 0x61, 0x00, 0x80, 0xFB, 0x30, 0x00, 0x00, 0xFD, 0x1B, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0xE0, 0x1F, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00,
    0x1F, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xFC, 0x01, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0xA0, 0x7F, 0x03, 0x00, 0xDC, 0x87, 0x01, 0x00, 0xEE, 0xC3, 0x00, 0x00, 0xF3, 0x6F, 0x00, 0x80, 0xE0, 0x3F, 0x00, 0x00, 0x80, 0x7F, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF1, 0x1F, 0x00, 0xC0, 0xFE, 0x0D,
    0x00, 0x70, 0x1F, 0x06, 0x00, 0x98, 0x0F, 0x03, 0x00, 0xDC, 0xBF, 0x01, 0x00, 0x8C, 0xFF, 0x00, 0x00, 0x04, 0xFE, 0x01, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x08, 0xFC, 0x03, 0x00, 0xC6, 0x7F, 0x00, 0x00, 0xF9, 0x37, 0x00, 0x80, 0x7D, 0x18, 0x00, 0xC0, 0x3E, 0x0C, 0x00, 0x40, 0xFF, 0x06, 0x00, 0x30, 0xFE, 0x03, 0x00, 0x08, 0xF8, 0x07, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xC0, 0x07,
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x18, 0xFF, 0x01, 0x00, 0xEC, 0xDF, 0x00, 0x00, 0xF6, 0x61, 0x00, 0x00, 0xF8, 0x30, 0x00, 0x80, 0xFD, 0x1B, 0x00, 0xC0, 0xF8, 0x0F, 0x00, 0x60, 0xE0, 0x1F, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0xFC, 0x01, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0xB0, 0x7F, 0x03, 0x00,
    0xFC, 0x87, 0x01, 0x00, 0xF2, 0xC3, 0x00, 0x00, 0xFF, 0x6F, 0x00, 0x00, 0xE3, 0x3F, 0x00, 0x00, 0x80, 0x7F, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0x3E, 0x03, 0x00, 0xC0, 0x8F, 0x01, 0x00, 0xE0, 0xC1, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00,
    0x86, 0xC1, 0x00, 0x00, 0xC3, 0x60, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x18, 0x0C, 0x00, 0x30, 0x0C, 0x06, 0x00, 0x18, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x80, 0x07, 0x0F, 0x00, 0xE0, 0x00, 0x0E, 0x00, 0x30, 0x00, 0x46, 0x00, 0x18, 0x00, 0x2F, 0x00, 0x0C, 0x80, 0x1F, 0x00, 0x0E, 0xE0, 0x0E, 0x00, 0x07, 0x70, 0x03, 0x00, 0x0F, 0x1E, 0x00, 0x00, 0x07, 0x0F, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x10, 0xC3, 0x60, 0x00, 0x98, 0x61, 0x30, 0x00, 0xDC, 0x30, 0x18, 0x00, 0x6E, 0x18, 0x0C, 0x00, 0x34, 0x0C, 0x06, 0x00, 0x18, 0x06, 0x03, 0x00, 0x0C, 0x83, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0x30, 0x0C, 0x06, 0x00, 0x1A, 0x06, 0x03, 0xC0, 0x0D, 0x83, 0x01, 0xE0, 0x86, 0xC1, 0x00, 0x30, 0xC3, 0x60, 0x00, 0x88, 0x61,
    0x30, 0x00, 0xC0, 0x30, 0x18, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x80, 0xFE, 0xFF, 0x00, 0x60, 0xC3, 0x60, 0x00, 0xB8, 0x61, 0x30, 0x00, 0xCC, 0x30, 0x18, 0x00, 0x6E, 0x18, 0x0C, 0x00, 0x36, 0x0C, 0x06, 0x00, 0x1A, 0x06, 0x03, 0x00, 0x0C, 0x83, 0x01, 0x00, 0x06, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0x36, 0x0C, 0x06, 0x00, 0x1B, 0x06, 0x03, 0x80, 0x0D, 0x83,
    0x01, 0x00, 0x86, 0xC1, 0x00, 0x60, 0xC3, 0x60, 0x00, 0xB0, 0x61, 0x30, 0x00, 0xD8, 0x30, 0x18, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x00, 0x80, 0xF9, 0xFF, 0x03, 0xC0, 0xFD, 0xFF, 0x01, 0xE0, 0xFE, 0xFF, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 0xFF, 0x1F, 0x00, 0xEE, 0xFF, 0x0F, 0x00, 0xF7, 0xFF, 0x07, 0x80, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x70, 0xFF, 0x7F, 0x00, 0x98, 0xFF, 0x3F, 0x00, 0xDC, 0xFF, 0x1F, 0x00, 0x0C, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0xFD, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0x00, 0x60, 0xFF, 0x7F, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0x86, 0xC1, 0x00, 0x00, 0xC3, 0x60, 0x00, 0x80, 0x61, 0x30, 0x00, 0xC0, 0x00, 0x18, 0x00, 0xE0, 0x00, 0x0E, 0x00, 0xE0, 0x80, 0x03, 0x00, 0xF0, 0xFF, 0x01, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE8, 0xFF, 0x0F, 0x00, 0xE6, 0x03, 0x00, 0x00, 0xE1, 0x07, 0x00, 0x80, 0xC1, 0x07, 0x00, 0xC0, 0x80, 0x0F, 0x00, 0x40, 0x80, 0x1F, 0x00, 0x30, 0x00, 0x1F, 0x00, 0xC8, 0xFF, 0x1F, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xFE, 0x3F, 0x00, 0x00, 0x0F, 0x1E, 0x00, 0xC4, 0x01, 0x1C, 0x00, 0x66, 0x00, 0x0C, 0x00, 0x37, 0x00, 0x06, 0x80, 0x1B, 0x00, 0x03, 0x00,
    0x0D, 0x80, 0x01, 0x00, 0x0E, 0xE0, 0x00, 0x00, 0x1E, 0x3C, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0x1E, 0x3C, 0x00, 0x80, 0x03, 0x38, 0x00, 0xD0, 0x00, 0x18, 0x00, 0x6E, 0x00, 0x0C, 0x00, 0x37, 0x00, 0x06, 0x80, 0x19, 0x00, 0x03, 0x40, 0x1C, 0xC0, 0x01, 0x00, 0x3C, 0x78, 0x00, 0x00, 0xFE, 0x3F, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x3C, 0x78, 0x00, 0x40, 0x07, 0x70, 0x00, 0xB0, 0x01, 0x30, 0x00, 0xDC, 0x00, 0x18, 0x00, 0x66, 0x00, 0x0C, 0x00, 0x37, 0x00, 0x06, 0x00, 0x3B, 0x80, 0x03, 0x00, 0x79, 0xF0, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0xF0, 0xFF, 0x01, 0x00, 0x79, 0xF0, 0x00, 0xC0, 0x0E, 0xE0, 0x00, 0x20, 0x03,
    0x60, 0x00, 0xB0, 0x01, 0x30, 0x00, 0xD8, 0x00, 0x18, 0x00, 0x68, 0x00, 0x0C, 0x00, 0x76, 0x00, 0x07, 0x00, 0xF1, 0xE0, 0x01, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x80, 0xFF, 0x03, 0x00, 0xE0, 0xFF, 0x03, 0x00, 0xF0, 0xE0, 0x01, 0x80, 0x1D, 0xC0, 0x01, 0xC0, 0x06, 0xC0, 0x00, 0x60, 0x03, 0x60, 0x00, 0x80, 0x01, 0x30, 0x00, 0xD8, 0x00, 0x18, 0x00, 0xEC, 0x00, 0x0E, 0x00, 0xE6, 0xC1, 0x03, 0x00, 0xF0, 0xFF,
    0x01, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x8E, 0x03, 0x00, 0x00, 0xEF, 0x01, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x78, 0x0F, 0x00, 0x00, 0x1C, 0x07, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x04, 0x00, 0xE0, 0xFF, 0x03, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x3C, 0x78, 0x00, 0x00, 0x07, 0x76, 0x00, 0x80, 0x81, 0x39, 0x00, 0xC0, 0x60, 0x18,
    0x00, 0x60, 0x18, 0x0C, 0x00, 0x70, 0x06, 0x06, 0x00, 0xB8, 0x81, 0x03, 0x00, 0x78, 0xF0, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x80, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0xF8, 0xFF, 0x01, 0x40, 0x00, 0xC0, 0x01, 0x60, 0x00, 0xC0, 0x00, 0x70, 0x00, 0x60, 0x00, 0x38, 0x00, 0x30, 0x00, 0x10, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0E, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0xF8, 0xFF, 0x01, 0x00, 0xFC, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xFF, 0x0F, 0x00, 0x80, 0xFF, 0x1F, 0x00, 0xC0, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x04, 0x00, 0x06, 0x80, 0x03, 0x00, 0x03, 0xC0, 0x01, 0x80, 0x01, 0x60, 0x00, 0xC0, 0x00, 0x10, 0x00, 0x70, 0x00, 0x80, 0xFF, 0x1F, 0x00, 0xC0, 0xFF, 0x0F, 0x00, 0xE0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x7F, 0x00, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0xFE, 0x7F, 0x00, 0x40, 0x00, 0x70, 0x00, 0x30, 0x00, 0x30, 0x00, 0x1C, 0x00, 0x18, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x07, 0x00, 0x06, 0x00,
    0x03, 0x80, 0x03, 0x00, 0xFD, 0xFF, 0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x03, 0x00, 0xE0, 0xFF, 0x07, 0x00, 0xF6, 0xFF, 0x03, 0x00, 0x03, 0x80, 0x03, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x1C, 0x00, 0xEC, 0xFF, 0x07, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0xF8, 0x7F, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00,
    0x3E, 0x00, 0x00, 0x08, 0xFC, 0x0F, 0x00, 0x07, 0xFC, 0x07, 0x80, 0x03, 0xFF, 0x03, 0xC0, 0xE0, 0x03, 0x00, 0x20, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0x03, 0x00, 0xFC, 0xFF, 0x01, 0x00, 0x30, 0x18, 0x00, 0x00, 0x18, 0x0C, 0x00, 0x00, 0x0C, 0x06, 0x00, 0x00, 0x06, 0x03, 0x00, 0x00, 0xC7, 0x01, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x80, 0x0F, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0xFF, 0x3F, 0x00, 0xC0, 0xFF, 0x1F, 0x00, 0xE0, 0x00, 0x06, 0x00, 0x30, 0x00, 0x07, 0x00, 0x18, 0x8F, 0x03, 0x00, 0xFC, 0x8F, 0x01, 0x00, 0xFE, 0xC7, 0x00, 0x00, 0x1E, 0x7F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC4, 0x03, 0x00, 0x00, 0xF3, 0x03, 0x00, 0xC4, 0xFD, 0x01, 0x00, 0x66, 0xCE, 0x00, 0x00, 0x37, 0x63, 0x00, 0x80, 0x9B, 0x31, 0x00, 0x00, 0xCD, 0x1C, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0xFE,
    0x07, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x78, 0x00, 0x00, 0x60, 0x7E, 0x00, 0x00, 0xB8, 0x3F, 0x00, 0x00, 0xCC, 0x19, 0x00, 0x80, 0x66, 0x0C, 0x00, 0x70, 0x33, 0x06, 0x00, 0xB8, 0x99, 0x03, 0x00, 0xCC, 0xFF, 0x01, 0x00, 0xC2, 0xFF, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0F, 0x00, 0x00, 0xCC, 0x0F, 0x00, 0x40, 0xF7, 0x07, 0x00, 0xB0, 0x39, 0x03, 0x00, 0xDC, 0x8C, 0x01, 0x00, 0x66, 0xC6, 0x00, 0x00, 0x37, 0x73, 0x00, 0x00, 0xFB, 0x3F,
    0x00, 0x00, 0xF9, 0x1F, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2, 0x01, 0x00, 0x80, 0xF9, 0x01, 0x00, 0xE8, 0xFE, 0x00, 0x00, 0x36, 0x67, 0x00, 0x00, 0x99, 0x31, 0x00, 0x80, 0xCD, 0x18, 0x00, 0xC0, 0x66, 0x0E, 0x00, 0x40, 0xFF, 0x07, 0x00, 0x30, 0xFF, 0x03, 0x00, 0x08, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3C, 0x00, 0x00, 0x30, 0x3F, 0x00, 0x80, 0xDD, 0x1F, 0x00, 0xC0, 0xE6, 0x0C, 0x00, 0x60, 0x33, 0x06, 0x00, 0x80, 0x19, 0x03, 0x00, 0xD8, 0xCC, 0x01,
    0x00, 0xEC, 0xFF, 0x00, 0x00, 0xE6, 0x7F, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x07, 0x00, 0x00, 0xE6, 0x07, 0x00, 0x80, 0xFB, 0x03, 0x00, 0xCC, 0x9C, 0x01, 0x00, 0x6F, 0xC6, 0x00, 0x80, 0x34, 0x63, 0x00, 0xC0, 0x9B, 0x39, 0x00, 0xC0, 0xFC, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF1, 0x00, 0x00, 0xC0, 0xFC, 0x00, 0x00, 0x70, 0x7F, 0x00, 0x00, 0x98, 0x33, 0x00, 0x00, 0xCC, 0x18, 0x00, 0x00, 0x66, 0x0E, 0x00,
    0x00, 0xFF, 0x03, 0x00, 0x00, 0xFF, 0x01, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0xE0, 0xE6, 0x00, 0x00, 0x30, 0x63, 0x00, 0x00, 0x98, 0x31, 0x00, 0x00, 0xDC, 0x18, 0x00, 0x00, 0x7E, 0x0E, 0x00, 0x00, 0x3E, 0x03, 0x00, 0x00, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x1C, 0x1C, 0x01, 0x00, 0x06, 0xBC, 0x00, 0x00, 0x03, 0x7E, 0x00, 0x80, 0x01, 0x3B, 0x00, 0xC0, 0xC1, 0x0D, 0x00, 0xC0, 0x60, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x10, 0xFF, 0x07, 0x00, 0x98, 0x9B, 0x03, 0x00, 0xDC, 0x8C, 0x01, 0x00, 0x6E, 0xC6, 0x00, 0x00, 0x74, 0x63, 0x00, 0x00, 0xF8, 0x39, 0x00, 0x00, 0xF8, 0x0C, 0x00, 0x00, 0x78, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0x74, 0x73, 0x00, 0x80, 0x9B, 0x31, 0x00, 0xC0, 0xCD, 0x18, 0x00, 0x60, 0x6E, 0x0C, 0x00, 0x10, 0x3F, 0x07, 0x00, 0x00, 0x9F, 0x01, 0x00, 0x00,
    0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xFD, 0x1F, 0x00, 0xC0, 0x6E, 0x0E, 0x00, 0x70, 0x33, 0x06, 0x00, 0x98, 0x19, 0x03, 0x00, 0xDC, 0x8D, 0x01, 0x00, 0xEC, 0xE7, 0x00, 0x00, 0xE4, 0x33, 0x00, 0x00, 0xE0, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x60, 0xFE, 0x03, 0x00, 0xB0, 0xFF, 0x03, 0x00, 0xD8, 0xCD, 0x01, 0x00, 0x60, 0xC6, 0x00, 0x00, 0x30, 0x63, 0x00, 0x00, 0xBB, 0x31, 0x00, 0x80, 0xFD, 0x1C, 0x00, 0xC0, 0x7C,
    0x06, 0x00, 0x00, 0x3C, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0xDC, 0xFF, 0x01, 0x00, 0xEE, 0xFF, 0x00, 0x00, 0xF4, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x1F, 0x00, 0xE0, 0xFE, 0x0F, 0x00, 0x70, 0xFF, 0x07, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0xF7, 0x7F, 0x00, 0x80, 0xF9, 0x3F, 0x00, 0xC0, 0xFD, 0x1F, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF6, 0x7F,
    0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0xD4, 0xFF, 0x01, 0x00, 0xEA, 0xE0, 0x00, 0x00, 0x37, 0x60, 0x00, 0x80, 0x1B, 0x30, 0x00, 0xC0, 0x1F, 0x1C, 0x00, 0xA0, 0xFF, 0x0F, 0x00, 0x90, 0xFF, 0x03, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF4, 0x7F, 0x00, 0x00, 0xFB, 0x3F, 0x00, 0x80, 0x1C, 0x00, 0x00, 0xC0, 0x06, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0xA0, 0x03, 0x00,
    0x00, 0xD8, 0xFF, 0x01, 0x00, 0xC4, 0xFF, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x10, 0xFF, 0x07, 0x00, 0x98, 0x83, 0x03, 0x00, 0xDC, 0x80, 0x01, 0x00, 0x6E, 0xC0, 0x00, 0x00, 0x74, 0x70, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0x74, 0x70, 0x00, 0x80, 0x1B, 0x30, 0x00, 0xC0, 0x0D, 0x18, 0x00,
    0x60, 0x0E, 0x0E, 0x00, 0x10, 0xFF, 0x07, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xFD, 0x1F, 0x00, 0xC0, 0x0E, 0x0E, 0x00, 0x70, 0x03, 0x06, 0x00, 0x98, 0x01, 0x03, 0x00, 0xDC, 0xC1, 0x01, 0x00, 0xEC, 0xFF, 0x00, 0x00, 0xE4, 0x3F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x40, 0xFE, 0x03, 0x00, 0xB0, 0xFF, 0x03, 0x00, 0xC8, 0xC1, 0x01, 0x00, 0x6C, 0xC0, 0x00, 0x00,
    0x36, 0x60, 0x00, 0x00, 0x3A, 0x38, 0x00, 0x80, 0xFD, 0x1F, 0x00, 0x40, 0xFC, 0x07, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xCC, 0x7F, 0x00, 0x00, 0xF6, 0x7F, 0x00, 0x00, 0x3B, 0x38, 0x00, 0x00, 0x0C, 0x18, 0x00, 0x00, 0x06, 0x0C, 0x00, 0x60, 0x07, 0x07, 0x00, 0xB0, 0xFF, 0x03, 0x00, 0x98, 0xFF, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x80,
    0x6D, 0x00, 0x00, 0xC0, 0x36, 0x00, 0x00, 0x60, 0x1B, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x02, 0x00, 0x80, 0xFF, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0x70, 0x7C, 0x00, 0x00, 0x18, 0x37, 0x00, 0x00, 0xEC, 0x18, 0x00, 0x00, 0x3E, 0x0E, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x40, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x40, 0xFC,
    0x1F, 0x00, 0x60, 0x00, 0x0E, 0x00, 0x70, 0x00, 0x06, 0x00, 0x38, 0x00, 0x03, 0x00, 0x10, 0xC0, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x80, 0xFF, 0x03, 0x00, 0x10, 0xC0, 0x01, 0x00, 0x0E, 0xC0, 0x00, 0x00, 0x07, 0x60, 0x00, 0x80, 0x01, 0x38, 0x00, 0x40, 0xFC, 0x1F, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xE0, 0x7F,
    0x00, 0x00, 0xF4, 0x7F, 0x00, 0x00, 0x03, 0x38, 0x00, 0xC0, 0x01, 0x18, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x70, 0x00, 0x07, 0x00, 0xB0, 0xFF, 0x03, 0x00, 0xD0, 0xFF, 0x01, 0x00, 0xE0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x0F, 0x00, 0x80, 0xFD, 0x0F, 0x00, 0xC0, 0xFE, 0x0F, 0x00, 0x60, 0x00, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x0C, 0xE0, 0x00, 0x00, 0xF6, 0x7F, 0x00, 0x00, 0xFB, 0x3F, 0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x1F, 0xC0,
    0x00, 0x80, 0x3F, 0x60, 0x00, 0x00, 0x7F, 0x38, 0x00, 0x08, 0xFC, 0x1F, 0x00, 0x07, 0xF8, 0x03, 0x80, 0x03, 0x7F, 0x00, 0xC0, 0xF0, 0x07, 0x00, 0x20, 0xFE, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x1F, 0x00, 0xFF, 0xFF, 0x0F, 0x80, 0xFF, 0xFF, 0x07, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x06, 0x0C, 0x00, 0x00, 0x03, 0x06, 0x00, 0x80, 0x83, 0x03, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0xC0, 0x7F, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x7C, 0x00, 0x03, 0xC0, 0xFE, 0x80, 0x01, 0x60, 0xFC, 0xE1, 0x00, 0x30, 0xF0, 0x7F, 0x00, 0x00, 0xE0, 0x0F, 0x00, 0x0C, 0xFC, 0x01, 0x00, 0xC6, 0x1F, 0x00, 0x00, 0xFB, 0x03, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00};

static struct fontDesc_t const HoloLens_20_Desc = {
    sizeof(HoloLens_20_Bytes), // total Size
    21,                        // width in pixel
    31,                        // height in pixel
    1,                         // bits per pixel
    0x0B,                      // Code of first char
    0xFF,                      // Code of last char
    HoloLens_20_Bytes          // Data
};

#endif
