import { NextResponse } from 'next/server';

import { voiceMap } from '@/utils/voices';

const axios = require('axios');

interface Voice {
  FriendlyName: string;
  Gender: string;
  Locale: string;
  Name: string;
  ShortName: string;
  Status: string;
  SuggestedCodec: string;
  VoiceTag: {
    ContentCategories: string[];
    VoicePersonalities: string[];
  };
}

const cachedVoiceList: Voice[] = [
  {
    FriendlyName: 'Microsoft Adri Online (Natural) - Afrikaans (South Africa)',
    Gender: 'Female',
    Locale: 'af-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (af-ZA, AdriNeural)',
    ShortName: 'af-ZA-AdriNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Willem Online (Natural) - Afrikaans (South Africa)',
    Gender: 'Male',
    Locale: 'af-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (af-ZA, WillemNeural)',
    ShortName: 'af-ZA-WillemNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Anila Online (Natural) - Albanian (Albania)',
    Gender: 'Female',
    Locale: 'sq-AL',
    Name: 'Microsoft Server Speech Text to Speech Voice (sq-AL, AnilaNeural)',
    ShortName: 'sq-AL-AnilaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ilir Online (Natural) - Albanian (Albania)',
    Gender: 'Male',
    Locale: 'sq-AL',
    Name: 'Microsoft Server Speech Text to Speech Voice (sq-AL, IlirNeural)',
    ShortName: 'sq-AL-IlirNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ameha Online (Natural) - Amharic (Ethiopia)',
    Gender: 'Male',
    Locale: 'am-ET',
    Name: 'Microsoft Server Speech Text to Speech Voice (am-ET, AmehaNeural)',
    ShortName: 'am-ET-AmehaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mekdes Online (Natural) - Amharic (Ethiopia)',
    Gender: 'Female',
    Locale: 'am-ET',
    Name: 'Microsoft Server Speech Text to Speech Voice (am-ET, MekdesNeural)',
    ShortName: 'am-ET-MekdesNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Amina Online (Natural) - Arabic (Algeria)',
    Gender: 'Female',
    Locale: 'ar-DZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-DZ, AminaNeural)',
    ShortName: 'ar-DZ-AminaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ismael Online (Natural) - Arabic (Algeria)',
    Gender: 'Male',
    Locale: 'ar-DZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-DZ, IsmaelNeural)',
    ShortName: 'ar-DZ-IsmaelNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ali Online (Natural) - Arabic (Bahrain)',
    Gender: 'Male',
    Locale: 'ar-BH',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-BH, AliNeural)',
    ShortName: 'ar-BH-AliNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Laila Online (Natural) - Arabic (Bahrain)',
    Gender: 'Female',
    Locale: 'ar-BH',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-BH, LailaNeural)',
    ShortName: 'ar-BH-LailaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Salma Online (Natural) - Arabic (Egypt)',
    Gender: 'Female',
    Locale: 'ar-EG',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-EG, SalmaNeural)',
    ShortName: 'ar-EG-SalmaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Shakir Online (Natural) - Arabic (Egypt)',
    Gender: 'Male',
    Locale: 'ar-EG',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-EG, ShakirNeural)',
    ShortName: 'ar-EG-ShakirNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Bassel Online (Natural) - Arabic (Iraq)',
    Gender: 'Male',
    Locale: 'ar-IQ',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-IQ, BasselNeural)',
    ShortName: 'ar-IQ-BasselNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rana Online (Natural) - Arabic (Iraq)',
    Gender: 'Female',
    Locale: 'ar-IQ',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-IQ, RanaNeural)',
    ShortName: 'ar-IQ-RanaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sana Online (Natural) - Arabic (Jordan)',
    Gender: 'Female',
    Locale: 'ar-JO',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-JO, SanaNeural)',
    ShortName: 'ar-JO-SanaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Taim Online (Natural) - Arabic (Jordan)',
    Gender: 'Male',
    Locale: 'ar-JO',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-JO, TaimNeural)',
    ShortName: 'ar-JO-TaimNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Fahed Online (Natural) - Arabic (Kuwait)',
    Gender: 'Male',
    Locale: 'ar-KW',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-KW, FahedNeural)',
    ShortName: 'ar-KW-FahedNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Noura Online (Natural) - Arabic (Kuwait)',
    Gender: 'Female',
    Locale: 'ar-KW',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-KW, NouraNeural)',
    ShortName: 'ar-KW-NouraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Layla Online (Natural) - Arabic (Lebanon)',
    Gender: 'Female',
    Locale: 'ar-LB',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-LB, LaylaNeural)',
    ShortName: 'ar-LB-LaylaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rami Online (Natural) - Arabic (Lebanon)',
    Gender: 'Male',
    Locale: 'ar-LB',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-LB, RamiNeural)',
    ShortName: 'ar-LB-RamiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Iman Online (Natural) - Arabic (Libya)',
    Gender: 'Female',
    Locale: 'ar-LY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-LY, ImanNeural)',
    ShortName: 'ar-LY-ImanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Omar Online (Natural) - Arabic (Libya)',
    Gender: 'Male',
    Locale: 'ar-LY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-LY, OmarNeural)',
    ShortName: 'ar-LY-OmarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jamal Online (Natural) - Arabic (Morocco)',
    Gender: 'Male',
    Locale: 'ar-MA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-MA, JamalNeural)',
    ShortName: 'ar-MA-JamalNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mouna Online (Natural) - Arabic (Morocco)',
    Gender: 'Female',
    Locale: 'ar-MA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-MA, MounaNeural)',
    ShortName: 'ar-MA-MounaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Abdullah Online (Natural) - Arabic (Oman)',
    Gender: 'Male',
    Locale: 'ar-OM',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-OM, AbdullahNeural)',
    ShortName: 'ar-OM-AbdullahNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Aysha Online (Natural) - Arabic (Oman)',
    Gender: 'Female',
    Locale: 'ar-OM',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-OM, AyshaNeural)',
    ShortName: 'ar-OM-AyshaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Amal Online (Natural) - Arabic (Qatar)',
    Gender: 'Female',
    Locale: 'ar-QA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-QA, AmalNeural)',
    ShortName: 'ar-QA-AmalNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Moaz Online (Natural) - Arabic (Qatar)',
    Gender: 'Male',
    Locale: 'ar-QA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-QA, MoazNeural)',
    ShortName: 'ar-QA-MoazNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Hamed Online (Natural) - Arabic (Saudi Arabia)',
    Gender: 'Male',
    Locale: 'ar-SA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-SA, HamedNeural)',
    ShortName: 'ar-SA-HamedNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Zariyah Online (Natural) - Arabic (Saudi Arabia)',
    Gender: 'Female',
    Locale: 'ar-SA',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-SA, ZariyahNeural)',
    ShortName: 'ar-SA-ZariyahNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Amany Online (Natural) - Arabic (Syria)',
    Gender: 'Female',
    Locale: 'ar-SY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-SY, AmanyNeural)',
    ShortName: 'ar-SY-AmanyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Laith Online (Natural) - Arabic (Syria)',
    Gender: 'Male',
    Locale: 'ar-SY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-SY, LaithNeural)',
    ShortName: 'ar-SY-LaithNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Hedi Online (Natural) - Arabic (Tunisia)',
    Gender: 'Male',
    Locale: 'ar-TN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-TN, HediNeural)',
    ShortName: 'ar-TN-HediNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Reem Online (Natural) - Arabic (Tunisia)',
    Gender: 'Female',
    Locale: 'ar-TN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-TN, ReemNeural)',
    ShortName: 'ar-TN-ReemNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Fatima Online (Natural) - Arabic (United Arab Emirates)',
    Gender: 'Female',
    Locale: 'ar-AE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-AE, FatimaNeural)',
    ShortName: 'ar-AE-FatimaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Hamdan Online (Natural) - Arabic (United Arab Emirates)',
    Gender: 'Male',
    Locale: 'ar-AE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-AE, HamdanNeural)',
    ShortName: 'ar-AE-HamdanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Maryam Online (Natural) - Arabic (Yemen)',
    Gender: 'Female',
    Locale: 'ar-YE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-YE, MaryamNeural)',
    ShortName: 'ar-YE-MaryamNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Saleh Online (Natural) - Arabic (Yemen)',
    Gender: 'Male',
    Locale: 'ar-YE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ar-YE, SalehNeural)',
    ShortName: 'ar-YE-SalehNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Babek Online (Natural) - Azerbaijani (Azerbaijan)',
    Gender: 'Male',
    Locale: 'az-AZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (az-AZ, BabekNeural)',
    ShortName: 'az-AZ-BabekNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Banu Online (Natural) - Azerbaijani (Azerbaijan)',
    Gender: 'Female',
    Locale: 'az-AZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (az-AZ, BanuNeural)',
    ShortName: 'az-AZ-BanuNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nabanita Online (Natural) - Bangla (Bangladesh)',
    Gender: 'Female',
    Locale: 'bn-BD',
    Name: 'Microsoft Server Speech Text to Speech Voice (bn-BD, NabanitaNeural)',
    ShortName: 'bn-BD-NabanitaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Pradeep Online (Natural) - Bangla (Bangladesh)',
    Gender: 'Male',
    Locale: 'bn-BD',
    Name: 'Microsoft Server Speech Text to Speech Voice (bn-BD, PradeepNeural)',
    ShortName: 'bn-BD-PradeepNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Bashkar Online (Natural) - Bangla (India)',
    Gender: 'Male',
    Locale: 'bn-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (bn-IN, BashkarNeural)',
    ShortName: 'bn-IN-BashkarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Tanishaa Online (Natural) - Bengali (India)',
    Gender: 'Female',
    Locale: 'bn-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (bn-IN, TanishaaNeural)',
    ShortName: 'bn-IN-TanishaaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Goran Online (Natural) - Bosnian (Bosnia)',
    Gender: 'Male',
    Locale: 'bs-BA',
    Name: 'Microsoft Server Speech Text to Speech Voice (bs-BA, GoranNeural)',
    ShortName: 'bs-BA-GoranNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Vesna Online (Natural) - Bosnian (Bosnia)',
    Gender: 'Female',
    Locale: 'bs-BA',
    Name: 'Microsoft Server Speech Text to Speech Voice (bs-BA, VesnaNeural)',
    ShortName: 'bs-BA-VesnaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Borislav Online (Natural) - Bulgarian (Bulgaria)',
    Gender: 'Male',
    Locale: 'bg-BG',
    Name: 'Microsoft Server Speech Text to Speech Voice (bg-BG, BorislavNeural)',
    ShortName: 'bg-BG-BorislavNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Kalina Online (Natural) - Bulgarian (Bulgaria)',
    Gender: 'Female',
    Locale: 'bg-BG',
    Name: 'Microsoft Server Speech Text to Speech Voice (bg-BG, KalinaNeural)',
    ShortName: 'bg-BG-KalinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nilar Online (Natural) - Burmese (Myanmar)',
    Gender: 'Female',
    Locale: 'my-MM',
    Name: 'Microsoft Server Speech Text to Speech Voice (my-MM, NilarNeural)',
    ShortName: 'my-MM-NilarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Thiha Online (Natural) - Burmese (Myanmar)',
    Gender: 'Male',
    Locale: 'my-MM',
    Name: 'Microsoft Server Speech Text to Speech Voice (my-MM, ThihaNeural)',
    ShortName: 'my-MM-ThihaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Enric Online (Natural) - Catalan (Spain)',
    Gender: 'Male',
    Locale: 'ca-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (ca-ES, EnricNeural)',
    ShortName: 'ca-ES-EnricNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Joana Online (Natural) - Catalan (Spain)',
    Gender: 'Female',
    Locale: 'ca-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (ca-ES, JoanaNeural)',
    ShortName: 'ca-ES-JoanaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft HiuGaai Online (Natural) - Chinese (Cantonese Traditional)',
    Gender: 'Female',
    Locale: 'zh-HK',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-HK, HiuGaaiNeural)',
    ShortName: 'zh-HK-HiuGaaiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft HiuMaan Online (Natural) - Chinese (Hong Kong)',
    Gender: 'Female',
    Locale: 'zh-HK',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-HK, HiuMaanNeural)',
    ShortName: 'zh-HK-HiuMaanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft WanLung Online (Natural) - Chinese (Hong Kong)',
    Gender: 'Male',
    Locale: 'zh-HK',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-HK, WanLungNeural)',
    ShortName: 'zh-HK-WanLungNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Xiaoxiao Online (Natural) - Chinese (Mainland)',
    Gender: 'Female',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoxiaoNeural)',
    ShortName: 'zh-CN-XiaoxiaoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Warm'],
    },
  },
  {
    FriendlyName: 'Microsoft Xiaoyi Online (Natural) - Chinese (Mainland)',
    Gender: 'Female',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speec h Voice (zh-CN, XiaoyiNeural)',
    ShortName: 'zh-CN-XiaoyiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Cartoon', 'Novel'],
      VoicePersonalities: ['Lively'],
    },
  },
  {
    FriendlyName: 'Microsoft Yunjian Online (Natural) - Chinese (Mainland)',
    Gender: 'Male',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN, YunjianNeural)',
    ShortName: 'zh-CN-YunjianNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Sports', ' Novel'],
      VoicePersonalities: ['Passion'],
    },
  },
  {
    FriendlyName: 'Microsoft Yunxi Online (Natural) - Chinese (Mainland)',
    Gender: 'Male',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN, YunxiNeural)',
    ShortName: 'zh-CN-YunxiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Novel'],
      VoicePersonalities: ['Lively', 'Sunshine'],
    },
  },
  {
    FriendlyName: 'Microsoft Yunxia Online (Natural) - Chinese (Mainland)',
    Gender: 'Male',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN, YunxiaNeural)',
    ShortName: 'zh-CN-YunxiaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Cartoon', 'Novel'],
      VoicePersonalities: ['Cute'],
    },
  },
  {
    FriendlyName: 'Microsoft Yunyang Online (Natural) - Chinese (Mainland)',
    Gender: 'Male',
    Locale: 'zh-CN',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN, YunyangNeural)',
    ShortName: 'zh-CN-YunyangNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News'],
      VoicePersonalities: ['Professional', 'Reliable'],
    },
  },
  {
    FriendlyName: 'Microsoft Xiaobei Online (Natural) - Chinese (Northeastern Mandarin)',
    Gender: 'Female',
    Locale: 'zh-CN-liaoning',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN-liaoning, XiaobeiNeural)',
    ShortName: 'zh-CN-liaoning-XiaobeiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Dialect'],
      VoicePersonalities: ['Humorous'],
    },
  },
  {
    FriendlyName: 'Microsoft HsiaoChen Online (Natural) - Chinese (Taiwan)',
    Gender: 'Female',
    Locale: 'zh-TW',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-TW, HsiaoChenNeural)',
    ShortName: 'zh-TW-HsiaoChenNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft YunJhe Online (Natural) - Chinese (Taiwan)',
    Gender: 'Male',
    Locale: 'zh-TW',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-TW, YunJheNeural)',
    ShortName: 'zh-TW-YunJheNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft HsiaoYu Online (Natural) - Chinese (Taiwanese Mandarin)',
    Gender: 'Female',
    Locale: 'zh-TW',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-TW, HsiaoYuNeural)',
    ShortName: 'zh-TW-HsiaoYuNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Xiaoni Online (Natural) - Chinese (Zhongyuan Mandarin Shaanxi)',
    Gender: 'Female',
    Locale: 'zh-CN-shaanxi',
    Name: 'Microsoft Server Speech Text to Speech Voice (zh-CN-shaanxi, XiaoniNeural)',
    ShortName: 'zh-CN-shaanxi-XiaoniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Dialect'],
      VoicePersonalities: ['Bright'],
    },
  },
  {
    FriendlyName: 'Microsoft Gabrijela Online (Natural) - Croatian (Croatia)',
    Gender: 'Female',
    Locale: 'hr-HR',
    Name: 'Microsoft Server Speech Text to Speech Voice (hr-HR, GabrijelaNeural)',
    ShortName: 'hr-HR-GabrijelaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Srecko Online (Natural) - Croatian (Croatia)',
    Gender: 'Male',
    Locale: 'hr-HR',
    Name: 'Microsoft Server Speech Text to Speech Voice (hr-HR, SreckoNeural)',
    ShortName: 'hr-HR-SreckoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Antonin Online (Natural) - Czech (Czech)',
    Gender: 'Male',
    Locale: 'cs-CZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (cs-CZ, AntoninNeural)',
    ShortName: 'cs-CZ-AntoninNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Vlasta Online (Natural) - Czech (Czech)',
    Gender: 'Female',
    Locale: 'cs-CZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (cs-CZ, VlastaNeural)',
    ShortName: 'cs-CZ-VlastaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Christel Online (Natural) - Danish (Denmark)',
    Gender: 'Female',
    Locale: 'da-DK',
    Name: 'Microsoft Server Speech Text to Speech Voice (da-DK, ChristelNeural)',
    ShortName: 'da-DK-ChristelNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jeppe Online (Natural) - Danish (Denmark)',
    Gender: 'Male',
    Locale: 'da-DK',
    Name: 'Microsoft Server Speech Text to Speech Voice (da-DK, JeppeNeural)',
    ShortName: 'da-DK-JeppeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Arnaud Online (Natural) - Dutch (Belgium)',
    Gender: 'Male',
    Locale: 'nl-BE',
    Name: 'Microsoft Server Speech Text to Speech Voice (nl-BE, ArnaudNeural)',
    ShortName: 'nl-BE-ArnaudNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dena Online (Natural) - Dutch (Belgium)',
    Gender: 'Female',
    Locale: 'nl-BE',
    Name: 'Microsoft Server Speech Text to Speech Voice (nl-BE, DenaNeural)',
    ShortName: 'nl-BE-DenaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Colette Online (Natural) - Dutch (Netherlands)',
    Gender: 'Female',
    Locale: 'nl-NL',
    Name: 'Microsoft Server Speech Text to Speech Voice (nl-NL, ColetteNeural)',
    ShortName: 'nl-NL-ColetteNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Fenna Online (Natural) - Dutch (Netherlands)',
    Gender: 'Female',
    Locale: 'nl-NL',
    Name: 'Microsoft Server Speech Text to Speech Voice (nl-NL, FennaNeural)',
    ShortName: 'nl-NL-FennaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Maarten Online (Natural) - Dutch (Netherlands)',
    Gender: 'Male',
    Locale: 'nl-NL',
    Name: 'Microsoft Server Speech Text to Speech Voice (nl-NL, MaartenNeural)',
    ShortName: 'nl-NL-MaartenNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Natasha Online (Natural) - English (Australia)',
    Gender: 'Female',
    Locale: 'en-AU',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-AU, NatashaNeural)',
    ShortName: 'en-AU-NatashaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft William Online (Natural) - English (Australia)',
    Gender: 'Male',
    Locale: 'en-AU',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-AU, WilliamNeural)',
    ShortName: 'en-AU-WilliamNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Clara Online (Natural) - English (Canada)',
    Gender: 'Female',
    Locale: 'en-CA',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-CA, ClaraNeural)',
    ShortName: 'en-CA-ClaraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Liam Online (Natural) - English (Canada)',
    Gender: 'Male',
    Locale: 'en-CA',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-CA, LiamNeural)',
    ShortName: 'en-CA-LiamNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sam Online (Natural) - English (Hongkong)',
    Gender: 'Male',
    Locale: 'en-HK',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-HK, SamNeural)',
    ShortName: 'en-HK-SamNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Yan Online (Natural) - English (Hongkong)',
    Gender: 'Female',
    Locale: 'en-HK',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-HK, YanNeural)',
    ShortName: 'en-HK-YanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Neerja Online (Natural) - English (India) (Preview)',
    Gender: 'Female',
    Locale: 'en-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-IN, NeerjaExpressiveNeural)',
    ShortName: 'en-IN-NeerjaExpressiveNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Neerja Online (Natural) - English (India)',
    Gender: 'Female',
    Locale: 'en-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-IN, NeerjaNeural)',
    ShortName: 'en-IN-NeerjaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Prabhat Online (Natural) - English (India)',
    Gender: 'Male',
    Locale: 'en-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-IN, PrabhatNeural)',
    ShortName: 'en-IN-PrabhatNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Connor Online (Natural) - English (Ireland)',
    Gender: 'Male',
    Locale: 'en-IE',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-IE, ConnorNeural)',
    ShortName: 'en-IE-ConnorNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Emily Online (Natural) - English (Ireland)',
    Gender: 'Female',
    Locale: 'en-IE',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-IE, EmilyNeural)',
    ShortName: 'en-IE-EmilyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Asilia Online (Natural) - English (Kenya)',
    Gender: 'Female',
    Locale: 'en-KE',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-KE, AsiliaNeural)',
    ShortName: 'en-KE-AsiliaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Chilemba Online (Natural) - English (Kenya)',
    Gender: 'Male',
    Locale: 'en-KE',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-KE, ChilembaNeural)',
    ShortName: 'en-KE-ChilembaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mitchell Online (Natural) - English (New Zealand)',
    Gender: 'Male',
    Locale: 'en-NZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-NZ, MitchellNeural)',
    ShortName: 'en-NZ-MitchellNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Molly Online (Natural) - English (New Zealand)',
    Gender: 'Female',
    Locale: 'en-NZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-NZ, MollyNeural)',
    ShortName: 'en-NZ-MollyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Abeo Online (Natural) - English (Nigeria)',
    Gender: 'Male',
    Locale: 'en-NG',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-NG, AbeoNeural)',
    ShortName: 'en-NG-AbeoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ezinne Online (Natural) - English (Nigeria)',
    Gender: 'Female',
    Locale: 'en-NG',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-NG, EzinneNeural)',
    ShortName: 'en-NG-EzinneNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft James Online (Natural) - English (Philippines)',
    Gender: 'Male',
    Locale: 'en-PH',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-PH, JamesNeural)',
    ShortName: 'en-PH-JamesNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rosa Online (Natural) - English (Philippines)',
    Gender: 'Female',
    Locale: 'en-PH',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-PH, RosaNeural)',
    ShortName: 'en-PH-RosaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Luna Online (Natural) - English (Singapore)',
    Gender: 'Female',
    Locale: 'en-SG',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-SG, LunaNeural)',
    ShortName: 'en-SG-LunaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Wayne Online (Natural) - English (Singapore)',
    Gender: 'Male',
    Locale: 'en-SG',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-SG, WayneNeural)',
    ShortName: 'en-SG-WayneNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Leah Online (Natural) - English (South Africa)',
    Gender: 'Female',
    Locale: 'en-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-ZA, LeahNeural)',
    ShortName: 'en-ZA-LeahNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Luke Online (Natural) - English (South Africa)',
    Gender: 'Male',
    Locale: 'en-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-ZA, LukeNeural)',
    ShortName: 'en-ZA-LukeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Elimu Online (Natural) - English (Tanzania)',
    Gender: 'Male',
    Locale: 'en-TZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-TZ, ElimuNeural)',
    ShortName: 'en-TZ-ElimuNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Imani Online (Natural) - English (Tanzania)',
    Gender: 'Female',
    Locale: 'en-TZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-TZ, ImaniNeural)',
    ShortName: 'en-TZ-ImaniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Libby Online (Natural) - English (United Kingdom)',
    Gender: 'Female',
    Locale: 'en-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-GB, LibbyNeural)',
    ShortName: 'en-GB-LibbyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Maisie Online (Natural) - English (United Kingdom)',
    Gender: 'Female',
    Locale: 'en-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-GB, MaisieNeural)',
    ShortName: 'en-GB-MaisieNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ryan Online (Natural) - English (United Kingdom)',
    Gender: 'Male',
    Locale: 'en-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-GB, RyanNeural)',
    ShortName: 'en-GB-RyanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sonia Online (Natural) - English (United Kingdom)',
    Gender: 'Female',
    Locale: 'en-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-GB, SoniaNeural)',
    ShortName: 'en-GB-SoniaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Thomas Online (Natural) - English (United Kingdom)',
    Gender: 'Male',
    Locale: 'en-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-GB, ThomasNeural)',
    ShortName: 'en-GB-ThomasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Aria Online (Natural) - English (United States)',
    Gender: 'Female',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, AriaNeural)',
    ShortName: 'en-US-AriaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Positive', 'Confident'],
    },
  },
  {
    FriendlyName: 'Microsoft Ana Online (Natural) - English (United States)',
    Gender: 'Female',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, AnaNeural)',
    ShortName: 'en-US-AnaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Cartoon', 'Conversation'],
      VoicePersonalities: ['Cute'],
    },
  },
  {
    FriendlyName: 'Microsoft Christopher Online (Natural) - English (United States)',
    Gender: 'Male',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, ChristopherNeural)',
    ShortName: 'en-US-ChristopherNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Reliable', 'Authority'],
    },
  },
  {
    FriendlyName: 'Microsoft Eric Online (Natural) - English (United States)',
    Gender: 'Male',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, EricNeural)',
    ShortName: 'en-US-EricNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Rational'],
    },
  },
  {
    FriendlyName: 'Microsoft Guy Online (Natural) - English (United States)',
    Gender: 'Male',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, GuyNeural)',
    ShortName: 'en-US-GuyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Passion'],
    },
  },
  {
    FriendlyName: 'Microsoft Jenny Online (Natural) - English (United States)',
    Gender: 'Female',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, JennyNeural)',
    ShortName: 'en-US-JennyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['Conversation', 'News'],
      VoicePersonalities: ['Friendly', 'Considerate', 'Comfort'],
    },
  },
  {
    FriendlyName: 'Microsoft Michelle Online (Natural) - English (United States)',
    Gender: 'Female',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, MichelleNeural)',
    ShortName: 'en-US-MichelleNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Friendly', 'Pleasant'],
    },
  },
  {
    FriendlyName: 'Microsoft Roger Online (Natural) - English (United States)',
    Gender: 'Male',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, RogerNeural)',
    ShortName: 'en-US-RogerNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Lively'],
    },
  },
  {
    FriendlyName: 'Microsoft Steffan Online (Natural) - English (United States)',
    Gender: 'Male',
    Locale: 'en-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (en-US, SteffanNeural)',
    ShortName: 'en-US-SteffanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['News', 'Novel'],
      VoicePersonalities: ['Rational'],
    },
  },
  {
    FriendlyName: 'Microsoft Anu Online (Natural) - Estonian (Estonia)',
    Gender: 'Female',
    Locale: 'et-EE',
    Name: 'Microsoft Server Speech Text to Speech Voice (et-EE, AnuNeural)',
    ShortName: 'et-EE-AnuNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Kert Online (Natural) - Estonian (Estonia)',
    Gender: 'Male',
    Locale: 'et-EE',
    Name: 'Microsoft Server Speech Text to Speech Voice (et-EE, KertNeural)',
    ShortName: 'et-EE-KertNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Angelo Online (Natural) - Filipino (Philippines)',
    Gender: 'Male',
    Locale: 'fil-PH',
    Name: 'Microsoft Server Speech Text to Speech Voice (fil-PH, AngeloNeural)',
    ShortName: 'fil-PH-AngeloNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Blessica Online (Natural) - Filipino (Philippines)',
    Gender: 'Female',
    Locale: 'fil-PH',
    Name: 'Microsoft Server Speech Text to Speech Voice (fil-PH, BlessicaNeural)',
    ShortName: 'fil-PH-BlessicaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Harri Online (Natural) - Finnish (Finland)',
    Gender: 'Male',
    Locale: 'fi-FI',
    Name: 'Microsoft Server Speech Text to Speech Voice (fi-FI, HarriNeural)',
    ShortName: 'fi-FI-HarriNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Noora Online (Natural) - Finnish (Finland)',
    Gender: 'Female',
    Locale: 'fi-FI',
    Name: 'Microsoft Server Speech Text to Speech Voice (fi-FI, NooraNeural)',
    ShortName: 'fi-FI-NooraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Charline Online (Natural) - French (Belgium)',
    Gender: 'Female',
    Locale: 'fr-BE',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-BE, CharlineNeural)',
    ShortName: 'fr-BE-CharlineNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gerard Online (Natural) - French (Belgium)',
    Gender: 'Male',
    Locale: 'fr-BE',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-BE, GerardNeural)',
    ShortName: 'fr-BE-GerardNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Antoine Online (Natural) - French (Canada)',
    Gender: 'Male',
    Locale: 'fr-CA',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-CA, AntoineNeural)',
    ShortName: 'fr-CA-AntoineNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jean Online (Natural) - French (Canada)',
    Gender: 'Male',
    Locale: 'fr-CA',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-CA, JeanNeural)',
    ShortName: 'fr-CA-JeanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sylvie Online (Natural) - French (Canada)',
    Gender: 'Female',
    Locale: 'fr-CA',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-CA, SylvieNeural)',
    ShortName: 'fr-CA-SylvieNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Denise Online (Natural) - French (France)',
    Gender: 'Female',
    Locale: 'fr-FR',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-FR, DeniseNeural)',
    ShortName: 'fr-FR-DeniseNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Eloise Online (Natural) - French (France)',
    Gender: 'Female',
    Locale: 'fr-FR',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-FR, EloiseNeural)',
    ShortName: 'fr-FR-EloiseNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Henri Online (Natural) - French (France)',
    Gender: 'Male',
    Locale: 'fr-FR',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-FR, HenriNeural)',
    ShortName: 'fr-FR-HenriNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ariane Online (Natural) - French (Switzerland)',
    Gender: 'Female',
    Locale: 'fr-CH',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-CH, ArianeNeural)',
    ShortName: 'fr-CH-ArianeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Fabrice Online (Natural) - French (Switzerland)',
    Gender: 'Male',
    Locale: 'fr-CH',
    Name: 'Microsoft Server Speech Text to Speech Voice (fr-CH, FabriceNeural)',
    ShortName: 'fr-CH-FabriceNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Roi Online (Natural) - Galician (Spain)',
    Gender: 'Male',
    Locale: 'gl-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (gl-ES, RoiNeural)',
    ShortName: 'gl-ES-RoiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sabela Online (Natural) - Galician (Spain)',
    Gender: 'Female',
    Locale: 'gl-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (gl-ES, SabelaNeural)',
    ShortName: 'gl-ES-SabelaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Eka Online (Natural) - Georgian (Georgia)',
    Gender: 'Female',
    Locale: 'ka-GE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ka-GE, EkaNeural)',
    ShortName: 'ka-GE-EkaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Giorgi Online (Natural) - Georgian (Georgia)',
    Gender: 'Male',
    Locale: 'ka-GE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ka-GE, GiorgiNeural)',
    ShortName: 'ka-GE-GiorgiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ingrid Online (Natural) - German (Austria)',
    Gender: 'Female',
    Locale: 'de-AT',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-AT, IngridNeural)',
    ShortName: 'de-AT-IngridNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jonas Online (Natural) - German (Austria)',
    Gender: 'Male',
    Locale: 'de-AT',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-AT, JonasNeural)',
    ShortName: 'de-AT-JonasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Amala Online (Natural) - German (Germany)',
    Gender: 'Female',
    Locale: 'de-DE',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-DE, AmalaNeural)',
    ShortName: 'de-DE-AmalaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Conrad Online (Natural) - German (Germany)',
    Gender: 'Male',
    Locale: 'de-DE',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-DE, ConradNeural)',
    ShortName: 'de-DE-ConradNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Katja Online (Natural) - German (Germany)',
    Gender: 'Female',
    Locale: 'de-DE',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-DE, KatjaNeural)',
    ShortName: 'de-DE-KatjaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Killian Online (Natural) - German (Germany)',
    Gender: 'Male',
    Locale: 'de-DE',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-DE, KillianNeural)',
    ShortName: 'de-DE-KillianNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jan Online (Natural) - German (Switzerland)',
    Gender: 'Male',
    Locale: 'de-CH',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-CH, JanNeural)',
    ShortName: 'de-CH-JanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Leni Online (Natural) - German (Switzerland)',
    Gender: 'Female',
    Locale: 'de-CH',
    Name: 'Microsoft Server Speech Text to Speech Voice (de-CH, LeniNeural)',
    ShortName: 'de-CH-LeniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Athina Online (Natural) - Greek (Greece)',
    Gender: 'Female',
    Locale: 'el-GR',
    Name: 'Microsoft Server Speech Text to Speech Voice (el-GR, AthinaNeural)',
    ShortName: 'el-GR-AthinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nestoras Online (Natural) - Greek (Greece)',
    Gender: 'Male',
    Locale: 'el-GR',
    Name: 'Microsoft Server Speech Text to Speech Voice (el-GR, NestorasNeural)',
    ShortName: 'el-GR-NestorasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dhwani Online (Natural) - Gujarati (India)',
    Gender: 'Female',
    Locale: 'gu-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (gu-IN, DhwaniNeural)',
    ShortName: 'gu-IN-DhwaniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Niranjan Online (Natural) - Gujarati (India)',
    Gender: 'Male',
    Locale: 'gu-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (gu-IN, NiranjanNeural)',
    ShortName: 'gu-IN-NiranjanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Avri Online (Natural) - Hebrew (Israel)',
    Gender: 'Male',
    Locale: 'he-IL',
    Name: 'Microsoft Server Speech Text to Speech Voice (he-IL, AvriNeural)',
    ShortName: 'he-IL-AvriNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Hila Online (Natural) - Hebrew (Israel)',
    Gender: 'Female',
    Locale: 'he-IL',
    Name: 'Microsoft Server Speech Text to Speech Voice (he-IL, HilaNeural)',
    ShortName: 'he-IL-HilaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Madhur Online (Natural) - Hindi (India)',
    Gender: 'Male',
    Locale: 'hi-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (hi-IN, MadhurNeural)',
    ShortName: 'hi-IN-MadhurNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Swara Online (Natural) - Hindi (India)',
    Gender: 'Female',
    Locale: 'hi-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (hi-IN, SwaraNeural)',
    ShortName: 'hi-IN-SwaraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Noemi Online (Natural) - Hungarian (Hungary)',
    Gender: 'Female',
    Locale: 'hu-HU',
    Name: 'Microsoft Server Speech Text to Speech Voice (hu-HU, NoemiNeural)',
    ShortName: 'hu-HU-NoemiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Tamas Online (Natural) - Hungarian (Hungary)',
    Gender: 'Male',
    Locale: 'hu-HU',
    Name: 'Microsoft Server Speech Text to Speech Voice (hu-HU, TamasNeural)',
    ShortName: 'hu-HU-TamasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gudrun Online (Natural) - Icelandic (Iceland)',
    Gender: 'Female',
    Locale: 'is-IS',
    Name: 'Microsoft Server Speech Text to Speech Voice (is-IS, GudrunNeural)',
    ShortName: 'is-IS-GudrunNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gunnar Online (Natural) - Icelandic (Iceland)',
    Gender: 'Male',
    Locale: 'is-IS',
    Name: 'Microsoft Server Speech Text to Speech Voice (is-IS, GunnarNeural)',
    ShortName: 'is-IS-GunnarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ardi Online (Natural) - Indonesian (Indonesia)',
    Gender: 'Male',
    Locale: 'id-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (id-ID, ArdiNeural)',
    ShortName: 'id-ID-ArdiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gadis Online (Natural) - Indonesian (Indonesia)',
    Gender: 'Female',
    Locale: 'id-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (id-ID, GadisNeural)',
    ShortName: 'id-ID-GadisNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Colm Online (Natural) - Irish (Ireland)',
    Gender: 'Male',
    Locale: 'ga-IE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ga-IE, ColmNeural)',
    ShortName: 'ga-IE-ColmNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Orla Online (Natural) - Irish (Ireland)',
    Gender: 'Female',
    Locale: 'ga-IE',
    Name: 'Microsoft Server Speech Text to Speech Voice (ga-IE, OrlaNeural)',
    ShortName: 'ga-IE-OrlaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Diego Online (Natural) - Italian (Italy)',
    Gender: 'Male',
    Locale: 'it-IT',
    Name: 'Microsoft Server Speech Text to Speech Voice (it-IT, DiegoNeural)',
    ShortName: 'it-IT-DiegoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Elsa Online (Natural) - Italian (Italy)',
    Gender: 'Female',
    Locale: 'it-IT',
    Name: 'Microsoft Server Speech Text to Speech Voice (it-IT, ElsaNeural)',
    ShortName: 'it-IT-ElsaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Isabella Online (Natural) - Italian (Italy)',
    Gender: 'Female',
    Locale: 'it-IT',
    Name: 'Microsoft Server Speech Text to Speech Voice (it-IT, IsabellaNeural)',
    ShortName: 'it-IT-IsabellaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Keita Online (Natural) - Japanese (Japan)',
    Gender: 'Male',
    Locale: 'ja-JP',
    Name: 'Microsoft Server Speech Text to Speech Voice (ja-JP, KeitaNeural)',
    ShortName: 'ja-JP-KeitaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nanami Online (Natural) - Japanese (Japan)',
    Gender: 'Female',
    Locale: 'ja-JP',
    Name: 'Microsoft Server Speech Text to Speech Voice (ja-JP, NanamiNeural)',
    ShortName: 'ja-JP-NanamiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dimas Online (Natural) - Javanese (Indonesia)',
    Gender: 'Male',
    Locale: 'jv-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (jv-ID, DimasNeural)',
    ShortName: 'jv-ID-DimasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Siti Online (Natural) - Javanese (Indonesia)',
    Gender: 'Female',
    Locale: 'jv-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (jv-ID, SitiNeural)',
    ShortName: 'jv-ID-SitiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gagan Online (Natural) - Kannada (India)',
    Gender: 'Male',
    Locale: 'kn-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (kn-IN, GaganNeural)',
    ShortName: 'kn-IN-GaganNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sapna Online (Natural) - Kannada (India)',
    Gender: 'Female',
    Locale: 'kn-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (kn-IN, SapnaNeural)',
    ShortName: 'kn-IN-SapnaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Aigul Online (Natural) - Kazakh (Kazakhstan)',
    Gender: 'Female',
    Locale: 'kk-KZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (kk-KZ, AigulNeural)',
    ShortName: 'kk-KZ-AigulNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Daulet Online (Natural) - Kazakh (Kazakhstan)',
    Gender: 'Male',
    Locale: 'kk-KZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (kk-KZ, DauletNeural)',
    ShortName: 'kk-KZ-DauletNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Piseth Online (Natural) - Khmer (Cambodia)',
    Gender: 'Male',
    Locale: 'km-KH',
    Name: 'Microsoft Server Speech Text to Speech Voice (km-KH, PisethNeural)',
    ShortName: 'km-KH-PisethNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sreymom Online (Natural) - Khmer (Cambodia)',
    Gender: 'Female',
    Locale: 'km-KH',
    Name: 'Microsoft Server Speech Text to Speech Voice (km-KH, SreymomNeural)',
    ShortName: 'km-KH-SreymomNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft InJoon Online (Natural) - Korean (Korea)',
    Gender: 'Male',
    Locale: 'ko-KR',
    Name: 'Microsoft Server Speech Text to Speech Voice (ko-KR, InJoonNeural)',
    ShortName: 'ko-KR-InJoonNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft SunHi Online (Natural) - Korean (Korea)',
    Gender: 'Female',
    Locale: 'ko-KR',
    Name: 'Microsoft Server Speech Text to Speech Voice (ko-KR, SunHiNeural)',
    ShortName: 'ko-KR-SunHiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Chanthavong Online (Natural) - Lao (Laos)',
    Gender: 'Male',
    Locale: 'lo-LA',
    Name: 'Microsoft Server Speech Text to Speech Voice (lo-LA, ChanthavongNeural)',
    ShortName: 'lo-LA-ChanthavongNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Keomany Online (Natural) - Lao (Laos)',
    Gender: 'Female',
    Locale: 'lo-LA',
    Name: 'Microsoft Server Speech Text to Speech Voice (lo-LA, KeomanyNeural)',
    ShortName: 'lo-LA-KeomanyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Everita Online (Natural) - Latvian (Latvia)',
    Gender: 'Female',
    Locale: 'lv-LV',
    Name: 'Microsoft Server Speech Text to Speech Voice (lv-LV, EveritaNeural)',
    ShortName: 'lv-LV-EveritaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nils Online (Natural) - Latvian (Latvia)',
    Gender: 'Male',
    Locale: 'lv-LV',
    Name: 'Microsoft Server Speech Text to Speech Voice (lv-LV, NilsNeural)',
    ShortName: 'lv-LV-NilsNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Leonas Online (Natural) - Lithuanian (Lithuania)',
    Gender: 'Male',
    Locale: 'lt-LT',
    Name: 'Microsoft Server Speech Text to Speech Voice (lt-LT, LeonasNeural)',
    ShortName: 'lt-LT-LeonasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ona Online (Natural) - Lithuanian (Lithuania)',
    Gender: 'Female',
    Locale: 'lt-LT',
    Name: 'Microsoft Server Speech Text to Speech Voice (lt-LT, OnaNeural)',
    ShortName: 'lt-LT-OnaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName:
      'Microsoft Aleksandar Online (Natural) - Macedonian (Republic of North Macedonia)',
    Gender: 'Male',
    Locale: 'mk-MK',
    Name: 'Microsoft Server Speech Text to Speech Voice (mk-MK, AleksandarNeural)',
    ShortName: 'mk-MK-AleksandarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Marija Online (Natural) - Macedonian (Republic of North Macedonia)',
    Gender: 'Female',
    Locale: 'mk-MK',
    Name: 'Microsoft Server Speech Text to Speech Voice (mk-MK, MarijaNeural)',
    ShortName: 'mk-MK-MarijaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Osman Online (Natural) - Malay (Malaysia)',
    Gender: 'Male',
    Locale: 'ms-MY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ms-MY, OsmanNeural)',
    ShortName: 'ms-MY-OsmanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Yasmin Online (Natural) - Malay (Malaysia)',
    Gender: 'Female',
    Locale: 'ms-MY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ms-MY, YasminNeural)',
    ShortName: 'ms-MY-YasminNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Midhun Online (Natural) - Malayalam (India)',
    Gender: 'Male',
    Locale: 'ml-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ml-IN, MidhunNeural)',
    ShortName: 'ml-IN-MidhunNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sobhana Online (Natural) - Malayalam (India)',
    Gender: 'Female',
    Locale: 'ml-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ml-IN, SobhanaNeural)',
    ShortName: 'ml-IN-SobhanaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Grace Online (Natural) - Maltese (Malta)',
    Gender: 'Female',
    Locale: 'mt-MT',
    Name: 'Microsoft Server Speech Text to Speech Voice (mt-MT, GraceNeural)',
    ShortName: 'mt-MT-GraceNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Joseph Online (Natural) - Maltese (Malta)',
    Gender: 'Male',
    Locale: 'mt-MT',
    Name: 'Microsoft Server Speech Text to Speech Voice (mt-MT, JosephNeural)',
    ShortName: 'mt-MT-JosephNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Aarohi Online (Natural) - Marathi (India)',
    Gender: 'Female',
    Locale: 'mr-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (mr-IN, AarohiNeural)',
    ShortName: 'mr-IN-AarohiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Manohar Online (Natural) - Marathi (India)',
    Gender: 'Male',
    Locale: 'mr-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (mr-IN, ManoharNeural)',
    ShortName: 'mr-IN-ManoharNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Bataa Online (Natural) - Mongolian (Mongolia)',
    Gender: 'Male',
    Locale: 'mn-MN',
    Name: 'Microsoft Server Speech Text to Speech Voice (mn-MN, BataaNeural)',
    ShortName: 'mn-MN-BataaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Yesui Online (Natural) - Mongolian (Mongolia)',
    Gender: 'Female',
    Locale: 'mn-MN',
    Name: 'Microsoft Server Speech Text to Speech Voice (mn-MN, YesuiNeural)',
    ShortName: 'mn-MN-YesuiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Hemkala Online (Natural) - Nepali (Nepal)',
    Gender: 'Female',
    Locale: 'ne-NP',
    Name: 'Microsoft Server Speech Text to Speech Voice (ne-NP, HemkalaNeural)',
    ShortName: 'ne-NP-HemkalaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sagar Online (Natural) - Nepali (Nepal)',
    Gender: 'Male',
    Locale: 'ne-NP',
    Name: 'Microsoft Server Speech Text to Speech Voice (ne-NP, SagarNeural)',
    ShortName: 'ne-NP-SagarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Finn Online (Natural) - Norwegian (Bokmål Norway)',
    Gender: 'Male',
    Locale: 'nb-NO',
    Name: 'Microsoft Server Speech Text to Speech Voice (nb-NO, FinnNeural)',
    ShortName: 'nb-NO-FinnNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Pernille Online (Natural) - Norwegian (Bokmål, Norway)',
    Gender: 'Female',
    Locale: 'nb-NO',
    Name: 'Microsoft Server Speech Text to Speech Voice (nb-NO, PernilleNeural)',
    ShortName: 'nb-NO-PernilleNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft GulNawaz Online (Natural) - Pashto (Afghanistan)',
    Gender: 'Male',
    Locale: 'ps-AF',
    Name: 'Microsoft Server Speech Text to Speech Voice (ps-AF, GulNawazNeural)',
    ShortName: 'ps-AF-GulNawazNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Latifa Online (Natural) - Pashto (Afghanistan)',
    Gender: 'Female',
    Locale: 'ps-AF',
    Name: 'Microsoft Server Speech Text to Speech Voice (ps-AF, LatifaNeural)',
    ShortName: 'ps-AF-LatifaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dilara Online (Natural) - Persian (Iran)',
    Gender: 'Female',
    Locale: 'fa-IR',
    Name: 'Microsoft Server Speech Text to Speech Voice (fa-IR, DilaraNeural)',
    ShortName: 'fa-IR-DilaraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Farid Online (Natural) - Persian (Iran)',
    Gender: 'Male',
    Locale: 'fa-IR',
    Name: 'Microsoft Server Speech Text to Speech Voice (fa-IR, FaridNeural)',
    ShortName: 'fa-IR-FaridNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Marek Online (Natural) - Polish (Poland)',
    Gender: 'Male',
    Locale: 'pl-PL',
    Name: 'Microsoft Server Speech Text to Speech Voice (pl-PL, MarekNeural)',
    ShortName: 'pl-PL-MarekNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Zofia Online (Natural) - Polish (Poland)',
    Gender: 'Female',
    Locale: 'pl-PL',
    Name: 'Microsoft Server Speech Text to Speech Voice (pl-PL, ZofiaNeural)',
    ShortName: 'pl-PL-ZofiaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Antonio Online (Natural) - Portuguese (Brazil)',
    Gender: 'Male',
    Locale: 'pt-BR',
    Name: 'Microsoft Server Speech Text to Speech Voice (pt-BR, AntonioNeural)',
    ShortName: 'pt-BR-AntonioNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Francisca Online (Natural) - Portuguese (Brazil)',
    Gender: 'Female',
    Locale: 'pt-BR',
    Name: 'Microsoft Server Speech Text to Speech Voice (pt-BR, FranciscaNeural)',
    ShortName: 'pt-BR-FranciscaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Duarte Online (Natural) - Portuguese (Portugal)',
    Gender: 'Male',
    Locale: 'pt-PT',
    Name: 'Microsoft Server Speech Text to Speech Voice (pt-PT, DuarteNeural)',
    ShortName: 'pt-PT-DuarteNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Raquel Online (Natural) - Portuguese (Portugal)',
    Gender: 'Female',
    Locale: 'pt-PT',
    Name: 'Microsoft Server Speech Text to Speech Voice (pt-PT, RaquelNeural)',
    ShortName: 'pt-PT-RaquelNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Alina Online (Natural) - Romanian (Romania)',
    Gender: 'Female',
    Locale: 'ro-RO',
    Name: 'Microsoft Server Speech Text to Speech Voice (ro-RO, AlinaNeural)',
    ShortName: 'ro-RO-AlinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Emil Online (Natural) - Romanian (Romania)',
    Gender: 'Male',
    Locale: 'ro-RO',
    Name: 'Microsoft Server Speech Text to Speech Voice (ro-RO, EmilNeural)',
    ShortName: 'ro-RO-EmilNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dmitry Online (Natural) - Russian (Russia)',
    Gender: 'Male',
    Locale: 'ru-RU',
    Name: 'Microsoft Server Speech Text to Speech Voice (ru-RU, DmitryNeural)',
    ShortName: 'ru-RU-DmitryNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Svetlana Online (Natural) - Russian (Russia)',
    Gender: 'Female',
    Locale: 'ru-RU',
    Name: 'Microsoft Server Speech Text to Speech Voice (ru-RU, SvetlanaNeural)',
    ShortName: 'ru-RU-SvetlanaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nicholas Online (Natural) - Serbian (Serbia)',
    Gender: 'Male',
    Locale: 'sr-RS',
    Name: 'Microsoft Server Speech Text to Speech Voice (sr-RS, NicholasNeural)',
    ShortName: 'sr-RS-NicholasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sophie Online (Natural) - Serbian (Serbia)',
    Gender: 'Female',
    Locale: 'sr-RS',
    Name: 'Microsoft Server Speech Text to Speech Voice (sr-RS, SophieNeural)',
    ShortName: 'sr-RS-SophieNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sameera Online (Natural) - Sinhala (Sri Lanka)',
    Gender: 'Male',
    Locale: 'si-LK',
    Name: 'Microsoft Server Speech Text to Speech Voice (si-LK, SameeraNeural)',
    ShortName: 'si-LK-SameeraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Thilini Online (Natural) - Sinhala (Sri Lanka)',
    Gender: 'Female',
    Locale: 'si-LK',
    Name: 'Microsoft Server Speech Text to Speech Voice (si-LK, ThiliniNeural)',
    ShortName: 'si-LK-ThiliniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Lukas Online (Natural) - Slovak (Slovakia)',
    Gender: 'Male',
    Locale: 'sk-SK',
    Name: 'Microsoft Server Speech Text to Speech Voice (sk-SK, LukasNeural)',
    ShortName: 'sk-SK-LukasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Viktoria Online (Natural) - Slovak (Slovakia)',
    Gender: 'Female',
    Locale: 'sk-SK',
    Name: 'Microsoft Server Speech Text to Speech Voice (sk-SK, ViktoriaNeural)',
    ShortName: 'sk-SK-ViktoriaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Petra Online (Natural) - Slovenian (Slovenia)',
    Gender: 'Female',
    Locale: 'sl-SI',
    Name: 'Microsoft Server Speech Text to Speech Voice (sl-SI, PetraNeural)',
    ShortName: 'sl-SI-PetraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rok Online (Natural) - Slovenian (Slovenia)',
    Gender: 'Male',
    Locale: 'sl-SI',
    Name: 'Microsoft Server Speech Text to Speech Voice (sl-SI, RokNeural)',
    ShortName: 'sl-SI-RokNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Muuse Online (Natural) - Somali (Somalia)',
    Gender: 'Male',
    Locale: 'so-SO',
    Name: 'Microsoft Server Speech Text to Speech Voice (so-SO, MuuseNeural)',
    ShortName: 'so-SO-MuuseNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ubax Online (Natural) - Somali (Somalia)',
    Gender: 'Female',
    Locale: 'so-SO',
    Name: 'Microsoft Server Speech Text to Speech Voice (so-SO, UbaxNeural)',
    ShortName: 'so-SO-UbaxNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Elena Online (Natural) - Spanish (Argentina)',
    Gender: 'Female',
    Locale: 'es-AR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-AR, ElenaNeural)',
    ShortName: 'es-AR-ElenaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Tomas Online (Natural) - Spanish (Argentina)',
    Gender: 'Male',
    Locale: 'es-AR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-AR, TomasNeural)',
    ShortName: 'es-AR-TomasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Marcelo Online (Natural) - Spanish (Bolivia)',
    Gender: 'Male',
    Locale: 'es-BO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-BO, MarceloNeural)',
    ShortName: 'es-BO-MarceloNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sofia Online (Natural) - Spanish (Bolivia)',
    Gender: 'Female',
    Locale: 'es-BO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-BO, SofiaNeural)',
    ShortName: 'es-BO-SofiaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Catalina Online (Natural) - Spanish (Chile)',
    Gender: 'Female',
    Locale: 'es-CL',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CL, CatalinaNeural)',
    ShortName: 'es-CL-CatalinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Lorenzo Online (Natural) - Spanish (Chile)',
    Gender: 'Male',
    Locale: 'es-CL',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CL, LorenzoNeural)',
    ShortName: 'es-CL-LorenzoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gonzalo Online (Natural) - Spanish (Colombia)',
    Gender: 'Male',
    Locale: 'es-CO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CO, GonzaloNeural)',
    ShortName: 'es-CO-GonzaloNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Salome Online (Natural) - Spanish (Colombia)',
    Gender: 'Female',
    Locale: 'es-CO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CO, SalomeNeural)',
    ShortName: 'es-CO-SalomeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Juan Online (Natural) - Spanish (Costa Rica)',
    Gender: 'Male',
    Locale: 'es-CR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CR, JuanNeural)',
    ShortName: 'es-CR-JuanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Maria Online (Natural) - Spanish (Costa Rica)',
    Gender: 'Female',
    Locale: 'es-CR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CR, MariaNeural)',
    ShortName: 'es-CR-MariaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Belkys Online (Natural) - Spanish (Cuba)',
    Gender: 'Female',
    Locale: 'es-CU',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CU, BelkysNeural)',
    ShortName: 'es-CU-BelkysNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Manuel Online (Natural) - Spanish (Cuba)',
    Gender: 'Male',
    Locale: 'es-CU',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-CU, ManuelNeural)',
    ShortName: 'es-CU-ManuelNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Emilio Online (Natural) - Spanish (Dominican Republic)',
    Gender: 'Male',
    Locale: 'es-DO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-DO, EmilioNeural)',
    ShortName: 'es-DO-EmilioNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ramona Online (Natural) - Spanish (Dominican Republic)',
    Gender: 'Female',
    Locale: 'es-DO',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-DO, RamonaNeural)',
    ShortName: 'es-DO-RamonaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Andrea Online (Natural) - Spanish (Ecuador)',
    Gender: 'Female',
    Locale: 'es-EC',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-EC, AndreaNeural)',
    ShortName: 'es-EC-AndreaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Luis Online (Natural) - Spanish (Ecuador)',
    Gender: 'Male',
    Locale: 'es-EC',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-EC, LuisNeural)',
    ShortName: 'es-EC-LuisNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Lorena Online (Natural) - Spanish (El Salvador)',
    Gender: 'Female',
    Locale: 'es-SV',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-SV, LorenaNeural)',
    ShortName: 'es-SV-LorenaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rodrigo Online (Natural) - Spanish (El Salvador)',
    Gender: 'Male',
    Locale: 'es-SV',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-SV, RodrigoNeural)',
    ShortName: 'es-SV-RodrigoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Javier Online (Natural) - Spanish (Equatorial Guinea)',
    Gender: 'Male',
    Locale: 'es-GQ',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-GQ, JavierNeural)',
    ShortName: 'es-GQ-JavierNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Teresa Online (Natural) - Spanish (Equatorial Guinea)',
    Gender: 'Female',
    Locale: 'es-GQ',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-GQ, TeresaNeural)',
    ShortName: 'es-GQ-TeresaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Andres Online (Natural) - Spanish (Guatemala)',
    Gender: 'Male',
    Locale: 'es-GT',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-GT, AndresNeural)',
    ShortName: 'es-GT-AndresNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Marta Online (Natural) - Spanish (Guatemala)',
    Gender: 'Female',
    Locale: 'es-GT',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-GT, MartaNeural)',
    ShortName: 'es-GT-MartaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Carlos Online (Natural) - Spanish (Honduras)',
    Gender: 'Male',
    Locale: 'es-HN',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-HN, CarlosNeural)',
    ShortName: 'es-HN-CarlosNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Karla Online (Natural) - Spanish (Honduras)',
    Gender: 'Female',
    Locale: 'es-HN',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-HN, KarlaNeural)',
    ShortName: 'es-HN-KarlaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Dalia Online (Natural) - Spanish (Mexico)',
    Gender: 'Female',
    Locale: 'es-MX',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-MX, DaliaNeural)',
    ShortName: 'es-MX-DaliaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jorge Online (Natural) - Spanish (Mexico)',
    Gender: 'Male',
    Locale: 'es-MX',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-MX, JorgeNeural)',
    ShortName: 'es-MX-JorgeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Federico Online (Natural) - Spanish (Nicaragua)',
    Gender: 'Male',
    Locale: 'es-NI',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-NI, FedericoNeural)',
    ShortName: 'es-NI-FedericoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Yolanda Online (Natural) - Spanish (Nicaragua)',
    Gender: 'Female',
    Locale: 'es-NI',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-NI, YolandaNeural)',
    ShortName: 'es-NI-YolandaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Margarita Online (Natural) - Spanish (Panama)',
    Gender: 'Female',
    Locale: 'es-PA',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PA, MargaritaNeural)',
    ShortName: 'es-PA-MargaritaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Roberto Online (Natural) - Spanish (Panama)',
    Gender: 'Male',
    Locale: 'es-PA',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PA, RobertoNeural)',
    ShortName: 'es-PA-RobertoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mario Online (Natural) - Spanish (Paraguay)',
    Gender: 'Male',
    Locale: 'es-PY',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PY, MarioNeural)',
    ShortName: 'es-PY-MarioNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Tania Online (Natural) - Spanish (Paraguay)',
    Gender: 'Female',
    Locale: 'es-PY',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PY, TaniaNeural)',
    ShortName: 'es-PY-TaniaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Alex Online (Natural) - Spanish (Peru)',
    Gender: 'Male',
    Locale: 'es-PE',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PE, AlexNeural)',
    ShortName: 'es-PE-AlexNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Camila Online (Natural) - Spanish (Peru)',
    Gender: 'Female',
    Locale: 'es-PE',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PE, CamilaNeural)',
    ShortName: 'es-PE-CamilaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Karina Online (Natural) - Spanish (Puerto Rico)',
    Gender: 'Female',
    Locale: 'es-PR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PR, KarinaNeural)',
    ShortName: 'es-PR-KarinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Victor Online (Natural) - Spanish (Puerto Rico)',
    Gender: 'Male',
    Locale: 'es-PR',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-PR, VictorNeural)',
    ShortName: 'es-PR-VictorNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Alvaro Online (Natural) - Spanish (Spain)',
    Gender: 'Male',
    Locale: 'es-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-ES, AlvaroNeural)',
    ShortName: 'es-ES-AlvaroNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Elvira Online (Natural) - Spanish (Spain)',
    Gender: 'Female',
    Locale: 'es-ES',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-ES, ElviraNeural)',
    ShortName: 'es-ES-ElviraNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Alonso Online (Natural) - Spanish (United States)',
    Gender: 'Male',
    Locale: 'es-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-US, AlonsoNeural)',
    ShortName: 'es-US-AlonsoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Paloma Online (Natural) - Spanish (United States)',
    Gender: 'Female',
    Locale: 'es-US',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-US, PalomaNeural)',
    ShortName: 'es-US-PalomaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mateo Online (Natural) - Spanish (Uruguay)',
    Gender: 'Male',
    Locale: 'es-UY',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-UY, MateoNeural)',
    ShortName: 'es-UY-MateoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Valentina Online (Natural) - Spanish (Uruguay)',
    Gender: 'Female',
    Locale: 'es-UY',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-UY, ValentinaNeural)',
    ShortName: 'es-UY-ValentinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Paola Online (Natural) - Spanish (Venezuela)',
    Gender: 'Female',
    Locale: 'es-VE',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-VE, PaolaNeural)',
    ShortName: 'es-VE-PaolaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sebastian Online (Natural) - Spanish (Venezuela)',
    Gender: 'Male',
    Locale: 'es-VE',
    Name: 'Microsoft Server Speech Text to Speech Voice (es-VE, SebastianNeural)',
    ShortName: 'es-VE-SebastianNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Jajang Online (Natural) - Sundanese (Indonesia)',
    Gender: 'Male',
    Locale: 'su-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (su-ID, JajangNeural)',
    ShortName: 'su-ID-JajangNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Tuti Online (Natural) - Sundanese (Indonesia)',
    Gender: 'Female',
    Locale: 'su-ID',
    Name: 'Microsoft Server Speech Text to Speech Voice (su-ID, TutiNeural)',
    ShortName: 'su-ID-TutiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rafiki Online (Natural) - Swahili (Kenya)',
    Gender: 'Male',
    Locale: 'sw-KE',
    Name: 'Microsoft Server Speech Text to Speech Voice (sw-KE, RafikiNeural)',
    ShortName: 'sw-KE-RafikiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Zuri Online (Natural) - Swahili (Kenya)',
    Gender: 'Female',
    Locale: 'sw-KE',
    Name: 'Microsoft Server Speech Text to Speech Voice (sw-KE, ZuriNeural)',
    ShortName: 'sw-KE-ZuriNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Daudi Online (Natural) - Swahili (Tanzania)',
    Gender: 'Male',
    Locale: 'sw-TZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (sw-TZ, DaudiNeural)',
    ShortName: 'sw-TZ-DaudiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Rehema Online (Natural) - Swahili (Tanzania)',
    Gender: 'Female',
    Locale: 'sw-TZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (sw-TZ, RehemaNeural)',
    ShortName: 'sw-TZ-RehemaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mattias Online (Natural) - Swedish (Sweden)',
    Gender: 'Male',
    Locale: 'sv-SE',
    Name: 'Microsoft Server Speech Text to Speech Voice (sv-SE, MattiasNeural)',
    ShortName: 'sv-SE-MattiasNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sofie Online (Natural) - Swedish (Sweden)',
    Gender: 'Female',
    Locale: 'sv-SE',
    Name: 'Microsoft Server Speech Text to Speech Voice (sv-SE, SofieNeural)',
    ShortName: 'sv-SE-SofieNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Pallavi Online (Natural) - Tamil (India)',
    Gender: 'Female',
    Locale: 'ta-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-IN, PallaviNeural)',
    ShortName: 'ta-IN-PallaviNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Valluvar Online (Natural) - Tamil (India)',
    Gender: 'Male',
    Locale: 'ta-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-IN, ValluvarNeural)',
    ShortName: 'ta-IN-ValluvarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Kani Online (Natural) - Tamil (Malaysia)',
    Gender: 'Female',
    Locale: 'ta-MY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-MY, KaniNeural)',
    ShortName: 'ta-MY-KaniNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Surya Online (Natural) - Tamil (Malaysia)',
    Gender: 'Male',
    Locale: 'ta-MY',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-MY, SuryaNeural)',
    ShortName: 'ta-MY-SuryaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Anbu Online (Natural) - Tamil (Singapore)',
    Gender: 'Male',
    Locale: 'ta-SG',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-SG, AnbuNeural)',
    ShortName: 'ta-SG-AnbuNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Venba Online (Natural) - Tamil (Singapore)',
    Gender: 'Female',
    Locale: 'ta-SG',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-SG, VenbaNeural)',
    ShortName: 'ta-SG-VenbaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Kumar Online (Natural) - Tamil (Sri Lanka)',
    Gender: 'Male',
    Locale: 'ta-LK',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-LK, KumarNeural)',
    ShortName: 'ta-LK-KumarNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Saranya Online (Natural) - Tamil (Sri Lanka)',
    Gender: 'Female',
    Locale: 'ta-LK',
    Name: 'Microsoft Server Speech Text to Speech Voice (ta-LK, SaranyaNeural)',
    ShortName: 'ta-LK-SaranyaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Mohan Online (Natural) - Telugu (India)',
    Gender: 'Male',
    Locale: 'te-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (te-IN, MohanNeural)',
    ShortName: 'te-IN-MohanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Shruti Online (Natural) - Telugu (India)',
    Gender: 'Female',
    Locale: 'te-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (te-IN, ShrutiNeural)',
    ShortName: 'te-IN-ShrutiNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Niwat Online (Natural) - Thai (Thailand)',
    Gender: 'Male',
    Locale: 'th-TH',
    Name: 'Microsoft Server Speech Text to Speech Voice (th-TH, NiwatNeural)',
    ShortName: 'th-TH-NiwatNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Premwadee Online (Natural) - Thai (Thailand)',
    Gender: 'Female',
    Locale: 'th-TH',
    Name: 'Microsoft Server Speech Text to Speech Voice (th-TH, PremwadeeNeural)',
    ShortName: 'th-TH-PremwadeeNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ahmet Online (Natural) - Turkish (Turkey)',
    Gender: 'Male',
    Locale: 'tr-TR',
    Name: 'Microsoft Server Speech Text to Speech Voice (tr-TR, AhmetNeural)',
    ShortName: 'tr-TR-AhmetNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Emel Online (Natural) - Turkish (Turkey)',
    Gender: 'Female',
    Locale: 'tr-TR',
    Name: 'Microsoft Server Speech Text to Speech Voice (tr-TR, EmelNeural)',
    ShortName: 'tr-TR-EmelNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Ostap Online (Natural) - Ukrainian (Ukraine)',
    Gender: 'Male',
    Locale: 'uk-UA',
    Name: 'Microsoft Server Speech Text to Speech Voice (uk-UA, OstapNeural)',
    ShortName: 'uk-UA-OstapNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Polina Online (Natural) - Ukrainian (Ukraine)',
    Gender: 'Female',
    Locale: 'uk-UA',
    Name: 'Microsoft Server Speech Text to Speech Voice (uk-UA, PolinaNeural)',
    ShortName: 'uk-UA-PolinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Gul Online (Natural) - Urdu (India)',
    Gender: 'Female',
    Locale: 'ur-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ur-IN, GulNeural)',
    ShortName: 'ur-IN-GulNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Salman Online (Natural) - Urdu (India)',
    Gender: 'Male',
    Locale: 'ur-IN',
    Name: 'Microsoft Server Speech Text to Speech Voice (ur-IN, SalmanNeural)',
    ShortName: 'ur-IN-SalmanNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Asad Online (Natural) - Urdu (Pakistan)',
    Gender: 'Male',
    Locale: 'ur-PK',
    Name: 'Microsoft Server Speech Text to Speech Voice (ur-PK, AsadNeural)',
    ShortName: 'ur-PK-AsadNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Uzma Online (Natural) - Urdu (Pakistan)',
    Gender: 'Female',
    Locale: 'ur-PK',
    Name: 'Microsoft Server Speech Text to Speech Voice (ur-PK, UzmaNeural)',
    ShortName: 'ur-PK-UzmaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Madina Online (Natural) - Uzbek (Uzbekistan)',
    Gender: 'Female',
    Locale: 'uz-UZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (uz-UZ, MadinaNeural)',
    ShortName: 'uz-UZ-MadinaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Sardor Online (Natural) - Uzbek (Uzbekistan)',
    Gender: 'Male',
    Locale: 'uz-UZ',
    Name: 'Microsoft Server Speech Text to Speech Voice (uz-UZ, SardorNeural)',
    ShortName: 'uz-UZ-SardorNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft HoaiMy Online (Natural) - Vietnamese (Vietnam)',
    Gender: 'Female',
    Locale: 'vi-VN',
    Name: 'Microsoft Server Speech Text to Speech Voice (vi-VN, HoaiMyNeural)',
    ShortName: 'vi-VN-HoaiMyNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft NamMinh Online (Natural) - Vietnamese (Vietnam)',
    Gender: 'Male',
    Locale: 'vi-VN',
    Name: 'Microsoft Server Speech Text to Speech Voice (vi-VN, NamMinhNeural)',
    ShortName: 'vi-VN-NamMinhNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Aled Online (Natural) - Welsh (United Kingdom)',
    Gender: 'Male',
    Locale: 'cy-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (cy-GB, AledNeural)',
    ShortName: 'cy-GB-AledNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Nia Online (Natural) - Welsh (United Kingdom)',
    Gender: 'Female',
    Locale: 'cy-GB',
    Name: 'Microsoft Server Speech Text to Speech Voice (cy-GB, NiaNeural)',
    ShortName: 'cy-GB-NiaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Thando Online (Natural) - Zulu (South Africa)',
    Gender: 'Female',
    Locale: 'zu-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (zu-ZA, ThandoNeural)',
    ShortName: 'zu-ZA-ThandoNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
  {
    FriendlyName: 'Microsoft Themba Online (Natural) - Zulu (South Africa)',
    Gender: 'Male',
    Locale: 'zu-ZA',
    Name: 'Microsoft Server Speech Text to Speech Voice (zu-ZA, ThembaNeural)',
    ShortName: 'zu-ZA-ThembaNeural',
    Status: 'GA',
    SuggestedCodec: 'audio-24khz-48kbitrate-mono-mp3',
    VoiceTag: {
      ContentCategories: ['General'],
      VoicePersonalities: ['Friendly', 'Positive'],
    },
  },
];

const convert = (voices: Voice[]) => {
  return voices.map((voice) => voiceMap[voice.ShortName]).filter((voice) => !!voice);
};

export const GET = async () => {
  const config = {
    method: 'get',
    url: 'https://speech.platform.bing.com/consumer/speech/synthesize/readaloud/voices/list?trustedclienttoken=6A5AA1D4EAFF4E9FB37E23D68491D6F4',
  };

  try {
    const response = await axios(config);
    return NextResponse.json({ data: convert(response.data) });
  } catch {
    return NextResponse.json({ data: convert(cachedVoiceList) });
  }
};
