# Resources and References

The design and development of LobeVidol rely heavily on outstanding projects within the community and ecosystem. Throughout the design and development process, we have utilized or referenced several excellent resources and guidelines. Below are some key reference resources for developers to consult during their development and learning journey:

1. **OpenAI API Guide**: We use OpenAI's API to obtain and process AI conversation data. You can check out the [OpenAI API Guide](https://platform.openai.com/docs/api-reference/introduction) for more details.

2. **OpenAI SDK**: We utilize OpenAI's Node.js SDK to interact with OpenAI's API. You can view the source code and documentation in the [OpenAI SDK](https://github.com/openai/openai-node) GitHub repository.

3. **AI SDK**: We use Vercel's AI SDK to obtain and process AI conversation data. You can refer to the documentation of the [AI SDK](https://sdk.vercel.ai/docs) for more information.

4. **Next.js Documentation**: Our project is built on Next.js, and you can check the [Next.js Documentation](https://nextjs.org/docs) for more information about Next.js.

5. **Three VRM**: We use Three.js and VRM to display 3D characters. You can find more information about Three VRM in the [Three VRM](https://github.com/pixiv/three-vrm) GitHub repository.

6. **mmd-parser**: We use mmd-parser to parse MMD files, allowing characters to dance to music. You can learn more about mmd-parser in the [mmd-parser](https://github.com/takahirox/mmd-parser) GitHub repository.

We will continue to update and expand this list to provide developers with more reference resources.
