# Directory Structure

The folder directory structure of LobeVidol is as follows:

```bash
src
├── app        # Code related to the main application logic and state management
├── components # Reusable UI components
├── constants  # Definitions for constants, such as action types, route names, etc.
├── features   # Functional modules related to business features, such as Agent settings, plugin development pop-ups, and other reusable modules with business logic
├── hooks      # Custom utility hooks reused throughout the application
├── layout     # Layout components for the application, such as navigation bars, sidebars, etc.
├── locales    # Internationalization language files
├── lib        # General utility libraries, such as plugins, VMD animation implementations, etc.
├── panels     # Panel components for display
├── services   # Encapsulated backend service interfaces, such as HTTP requests
├── store      # Zustand store for state management
├── styles     # Global style files
├── types      # TypeScript type definition files
└── utils      # General utility functions
```
