<div align="center"><a name="readme-top"></a>

<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-logo/1.0.0/files/assets/logo-3d.webp">
<img height="120" src="https://gw.alipayobjects.com/zos/kitchen/qJ3l3EPsdW/split.svg">
<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-emoji-anim/1.0.0/files/assets/teddy-bear.webp">

# Lobe Vidol

Experience the magic of virtual idol creation with Lobe Vidol. Enjoy our exquisite UI design, support for MMD dance content, and seamless conversations with characters—all integrated into one cohesive platform.

<sup>Anyone can create a virtual idol</sup>

**English** · [简体中文](./README.zh-CN.md) · [日本語](./README.ja-JP.md) · [Docs][docs] · [Changelog](./CHANGELOG.md) · [Report Bug][github-issues-link] · [Request Feature][github-issues-link]

[![][github-release-shield]][github-release-link]
[![][vercel-shield]][vercel-link]
[![][discord-shield]][discord-link]
[![][github-releasedate-shield]][github-releasedate-link]
[![][github-action-test-shield]][github-action-test-link]
[![][github-action-release-shield]][github-action-release-link]<br/>
[![][github-contributors-shield]][github-contributors-link]
[![][github-forks-shield]][github-forks-link]
[![][github-stars-shield]][github-stars-link]
[![][github-issues-shield]][github-issues-link]
[![][github-license-shield]][github-license-link]<br>
[![][sponsor-shield]][sponsor-link]

![](https://github.com/lobehub/lobe-vidol/assets/17870709/90d7295f-9461-4765-a936-20720afb48c3)

</div>

> \[!NOTE]
> Lobe Vidol is currently in the early stages of development and is now open for Beta testing. We welcome you to join us and contribute!

<details>
<summary><kbd>Table of Contents</kbd></summary>

#### TOC

- [👋🏻 Getting Started & Community](#-getting-started--community)
- [✨ Feature Overview](#-feature-overview)
  - [1. **Smooth Conversational Experience**](#1-smooth-conversational-experience)
  - [2. **Background Context Setting**](#2-background-context-setting)
  - [3. **Rich Library of Actions and Poses**](#3-rich-library-of-actions-and-poses)
  - [4. **Elegant UI Design**](#4-elegant-ui-design)
  - [5. **Rich Character Editing Experience**](#5-rich-character-editing-experience)
  - [6. **MMD Dance Support**](#6-mmd-dance-support)
  - [7. **PMX Stage Loading Feature**](#7-pmx-stage-loading-feature)
  - [8. **Touch Response Feature**](#8-touch-response-feature)
  - [9. **Character Marketplace**](#9-character-marketplace)
  - [10. **Dance Marketplace**](#10-dance-marketplace)
  - [11. **TTS & STT Voice Conversations**](#11-tts--stt-voice-conversations)
- [📦 Ecosystem](#-ecosystem)
- [⌨️ Local Development](#️-local-development)
- [🤝 Contributing](#-contributing)
- [🩷 Community Sponsorship](#-community-sponsorship)
- [🔗 More Tools](#-more-tools)
  - [More Projects](#more-projects)
  - [Related Links](#related-links)

####

</details>

## 👋🏻 Getting Started & Community

Lobe Vidol is actively under development. If you have any requests or questions, feel free to submit \[issues]\[issues-link].

| [![][vercel-shield-badge]][vercel-link]   | No installation or registration required! Visit our website for a quick experience.                              |
| :---------------------------------------- | :--------------------------------------------------------------------------------------------------------------- |
| [![][discord-shield-badge]][discord-link] | Join our Discord community! This is where you can interact with developers and other enthusiastic LobeHub users. |

> \[!IMPORTANT]
>
> **Star the project** to receive all release notifications from GitHub without delay!～⭐️

<img width="1749" alt="star (1)" src="https://github.com/user-attachments/assets/73f96340-ef2b-4d9b-ab6f-71f30c0c02fb">

<details><summary><kbd>Star History</kbd></summary>
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=lobehub%2Flobe-vidol&theme=dark&type=Date">
    <img src="https://api.star-history.com/svg?repos=lobehub%2Flobe-vidol&type=Date">
  </picture>
</details>

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## ✨ Feature Overview

### 1. **Smooth Conversational Experience**

Streamed responses provide a smooth conversational experience. You can set the dialogue context by placing character actions and expressions in parentheses () and the ongoing events or scenes in square brackets \[] to create an immersive experience.

<img width="1291" alt="fluent chat experience" src="https://github.com/user-attachments/assets/6b3a2df4-c80e-4cb4-8d62-c6c5532d0f00">

### 2. **Background Context Setting**

You can enhance the dialogue by setting a background image that fits the context:

<img width="1318" alt="background setting" src="https://github.com/user-attachments/assets/e62b635c-168d-4f4e-8741-39aac0f7cfd3">

### 3. **Rich Library of Actions and Poses**

With a built-in library of Mixamo character actions and poses, you can have characters strike the desired poses or perform actions during conversations:

<img width="1323" alt="motions and postures" src="https://github.com/user-attachments/assets/95d9a42e-4215-45f2-8171-f631a91065c9">

### 4. **Elegant UI Design**

The meticulously designed interface features an elegant appearance and smooth interaction effects, supporting both light and dark themes, and is optimized for mobile devices. It also supports PWA, providing an experience closer to that of a native application.

<img width="1408" alt="ui design" src="https://github.com/user-attachments/assets/e55df3c0-4e7b-4b5d-b903-e5865498da7a">

### 5. **Rich Character Editing Experience**

Using the character editor, you can create your own virtual idol, set touch responses, upload VRM models to the site, and interact with them.

<img width="1291" alt="role edit" src="https://github.com/user-attachments/assets/3d319554-ae14-4932-b527-e220c910fd51">

### 6. **MMD Dance Support**

With the support of mmd-parser, you can dance with your favorite idols using vmd files; Just Dance!

<https://github.com/user-attachments/assets/c017be86-dbac-4ce1-9f00-a10248b58621>

### 7. **PMX Stage Loading Feature**

We have added a stage loading feature with a rich selection of stages, allowing characters to dance with different stage styles:

<img width="1317" alt="pmx stage" src="https://github.com/user-attachments/assets/ec436b96-c270-431a-acef-f140584e6938">

### 8. **Touch Response Feature**

By clicking on different body parts of the character, they will respond differently. You can also edit the character's touch responses to create unique interactive effects:

<https://github.com/user-attachments/assets/a283bca0-222c-4ac8-8757-8c56ce3873c2>

### 9. **Character Marketplace**

The LobeVidol character marketplace gathers a variety of meticulously designed characters, allowing you to experience different contexts and interactions, providing a unique companionship experience.
Our marketplace is not just a display platform but a collaborative space where everyone can contribute their imagination and share their personally designed characters.

> \[!TIP]
>
> With the character creation feature, you can easily submit your character creations to our platform. We emphasize that LobeVidol has established a sophisticated automated internationalization (i18n) workflow, which seamlessly converts your characters into multiple language versions. This means that regardless of the language your users speak, they can experience your characters without barriers.

<img width="1320" alt="discover" src="https://github.com/user-attachments/assets/9f155227-6856-4957-9f6e-a9b3f534df24">

### 10. **Dance Marketplace**

The LobeVidol dance marketplace features a rich collection of MMD dance resources, creating a wealth of visual experiences. You can combine different characters, stages, music, and dances to create a unique viewing experience.

<img width="1323" alt="Snipaste_2024-11-05_21-22-47" src="https://github.com/user-attachments/assets/684ba6ad-17a9-4af3-9943-fcaaee121216">

### 11. **TTS & STT Voice Conversations**

LobeVidol supports Text-to-Speech (TTS) and Speech-to-Text (STT) technologies, enabling our application to convert text information into clear voice output. Users can interact with our conversational assistant as if they were talking to a real person.
Users can choose from a variety of voices to match their assistant with the appropriate sound source. Additionally, for those who prefer auditory learning or want to obtain information while busy, TTS provides an excellent solution.

In LobeVidol, we have carefully selected a range of high-quality voice options (OpenAI Audio, Microsoft Edge Speech) to meet the needs of users from different regions and cultural backgrounds. Users can select suitable voices based on personal preferences or specific scenarios to achieve a personalized communication experience.

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 📦 Ecosystem

| NPM                               | Repository                              | Description                                                                                             | Version                                   |
| --------------------------------- | --------------------------------------- | ------------------------------------------------------------------------------------------------------- | ----------------------------------------- |
| [@lobehub/ui][lobe-ui-link]       | [lobehub/lobe-ui][lobe-ui-github]       | An open-source UI component library designed for building AIGC web applications                         | [![][lobe-ui-shield]][lobe-ui-link]       |
| [@lobehub/icons][lobe-icons-link] | [lobehub/lobe-icons][lobe-icons-github] | A collection of SVG logos and icons for mainstream AI / LLM models and companies                        | [![][lobe-icons-shield]][lobe-icons-link] |
| [@lobehub/tts][lobe-tts-link]     | [lobehub/lobe-tts][lobe-tts-github]     | A React Hooks library for AI TTS / STT voice synthesis / recognition                                    | [![][lobe-tts-shield]][lobe-tts-link]     |
| [@lobehub/lint][lobe-lint-link]   | [lobehub/lobe-lint][lobe-lint-github]   | LobeHub code style guidelines for ESlint, Stylelint, Commitlint, Prettier, Remark, and Semantic Release | [![][lobe-lint-shield]][lobe-lint-link]   |

- **[Vidol market](https://github.com/v-idol/vidol-chat-agents)** - This is the Market Index of Vidol Chat. Vidol accesses index.json from this repo to show users the list of available agents and dances.
- **[Vidol agent sample](https://github.com/v-idol/vidol-agent-sample)** - Vidol character data template
- **[Vidol dance sample](https://github.com/v-idol/vidol-dance-sample)** - Vidol dance data template

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## ⌨️ Local Development

You can use GitHub Codespaces for online development:

[![][github-codespace-shield]][github-codespace-link]

Or use the following commands for local development:

[![][bun-shield]][bun-link]

```bash
$ git clone https://github.com/lobehub/lobe-vidol.git
$ cd lobe-vidol
$ bun install
$ bun dev
```

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🤝 Contributing

We warmly welcome contributions in various forms. If you're interested in contributing code, please check out our GitHub [Issues][github-issues-link] and \[Projects]\[github-project-link] to showcase your creativity and skills.

[![][pr-welcome-shield]][pr-welcome-link]

<a href="https://github.com/lobehub/lobe-vidol/graphs/contributors" target="_blank">
  <table>
    <tr>
      <th colspan="2">
        <br><img src="https://contrib.rocks/image?repo=lobehub/lobe-vidol"><br><br>
      </th>
    </tr>
    <tr>
      <td>
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=light">
        </picture>
      </td>
      <td rowspan="2">
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-participants-growth/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=4x7&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-participants-growth/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=4x7&color_scheme=light">
        </picture>
      </td>
    </tr>
    <tr>
      <td>
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=new&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=new&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=light">
        </picture>
      </td>
    </tr>
  </table>
</a>

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🩷 Community Sponsorship

Every bit of support is incredibly valuable, coming together to form the brilliant galaxy we support! You are like a shooting star that lights up our path forward in an instant. Thank you for your trust — your support acts like a guiding star, repeatedly illuminating the way for the project.

<a href="https://opencollective.com/lobehub" target="_blank">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/lobehub/.github/blob/main/static/sponsor-dark.png?raw=true">
    <img src="https://github.com/lobehub/.github/blob/main/static/sponsor-light.png?raw=true">
  </picture>
</a>

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 🔗 More Tools

### More Projects

- **[🤖 Lobe Chat][lobe-chat] :** An open-source, extensible (Function Calling) plugin system, modern design ChatGPT/LLMs chat application and development framework. Supports one-click free deployment of your private ChatGPT/LLMs application.
- **[🅰️ Lobe SD Theme][lobe-theme]:** A modern theme for Stable Diffusion WebUI, featuring exquisite interface design, highly customizable UI, and efficiency-enhancing features.
- **[⛵️ Lobe Midjourney WebUI][lobe-midjourney-webui]:** Midjourney WebUI, capable of quickly generating a rich variety of images based on text prompts, inspiring creativity and enhancing dialogue.
- **[🌏 Lobe i18n][lobe-i18n]:** Lobe i18n is an automation tool for the i18n (internationalization) translation process powered by ChatGPT. It supports automatic splitting of large files, incremental updates, and customizable options for OpenAI models, API proxies, and temperature.

### Related Links

- **mmd-parser** - <https://github.com/takahirox/mmd-parser>
- **three-vrm** - <https://github.com/pixiv/three-vrm>
- **tts-vue** - <https://github.com/LokerL/tts-vue>

<div align="right">

[![][back-to-top]](#readme-top)

</div>

---

#### 📝 License

Copyright © 2024 [lobehub][profile-link]. <br />
This project is [Apache 2.0](./LICENSE) licensed.

[back-to-top]: https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square
[bun-link]: https://bun.sh
[bun-shield]: https://img.shields.io/badge/-speedup%20with%20bun-black?logo=bun&style=for-the-badge
[discord-link]: https://discord.gg/AYFPHvv2jT
[discord-shield]: https://img.shields.io/discord/1127171173982154893?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=flat-square
[discord-shield-badge]: https://img.shields.io/discord/1127171173982154893?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=for-the-badge
[github-action-release-link]: https://github.com/actions/workflows/lobehub/lobe-vidol/release.yml
[github-action-release-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-vidol/release.yml?label=release&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-action-test-link]: https://github.com/actions/workflows/lobehub/lobe-vidol/test.yml
[github-action-test-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-vidol/test.yml?label=test&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-codespace-link]: https://codespaces.new/lobehub/lobe-vidol
[github-codespace-shield]: https://github.com/codespaces/badge.svg
[github-contributors-link]: https://github.com/lobehub/lobe-vidol/graphs/contributors
[github-contributors-shield]: https://img.shields.io/github/contributors/lobehub/lobe-vidol?color=c4f042&labelColor=black&style=flat-square
[github-forks-link]: https://github.com/lobehub/lobe-vidol/network/members
[github-forks-shield]: https://img.shields.io/github/forks/lobehub/lobe-vidol?color=8ae8ff&labelColor=black&style=flat-square
[github-issues-link]: https://github.com/lobehub/lobe-vidol/issues
[github-issues-shield]: https://img.shields.io/github/issues/lobehub/lobe-vidol?color=ff80eb&labelColor=black&style=flat-square
[github-license-link]: https://github.com/lobehub/lobe-vidol/blob/main/LICENSE
[github-license-shield]: https://img.shields.io/github/license/lobehub/lobe-vidol?color=white&labelColor=black&style=flat-square
[github-release-link]: https://github.com/lobehub/lobe-vidol/releases
[github-release-shield]: https://img.shields.io/github/v/release/lobehub/lobe-vidol?color=369eff&labelColor=black&logo=github&style=flat-square
[github-releasedate-link]: https://github.com/lobehub/lobe-vidol/releases
[github-releasedate-shield]: https://img.shields.io/github/release-date/lobehub/lobe-vidol?labelColor=black&style=flat-square
[github-stars-link]: https://github.com/lobehub/lobe-vidol/network/stargazers
[github-stars-shield]: https://img.shields.io/github/stars/lobehub/lobe-vidol?color=ffcb47&labelColor=black&style=flat-square
[docs]: https://docs.vidol.chat
[lobe-chat]: https://github.com/lobehub/lobe-chat
[lobe-i18n]: https://github.com/lobehub/lobe-commit/tree/master/packages/lobe-i18n
[lobe-icons-github]: https://github.com/lobehub/lobe-icons
[lobe-icons-link]: https://www.npmjs.com/package/@lobehub/icons
[lobe-icons-shield]: https://img.shields.io/npm/v/@lobehub/icons?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-lint-github]: https://github.com/lobehub/lobe-lint
[lobe-lint-link]: https://www.npmjs.com/package/@lobehub/lint
[lobe-lint-shield]: https://img.shields.io/npm/v/@lobehub/lint?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-midjourney-webui]: https://github.com/lobehub/lobe-midjourney-webui
[lobe-theme]: https://github.com/lobehub/sd-webui-lobe-theme
[lobe-tts-github]: https://github.com/lobehub/lobe-tts
[lobe-tts-link]: https://www.npmjs.com/package/@lobehub/tts
[lobe-tts-shield]: https://img.shields.io/npm/v/@lobehub/tts?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-ui-github]: https://github.com/lobehub/lobe-ui
[lobe-ui-link]: https://www.npmjs.com/package/@lobehub/ui
[lobe-ui-shield]: https://img.shields.io/npm/v/@lobehub/ui?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[pr-welcome-link]: https://github.com/lobehub/lobe-vidol/pulls
[pr-welcome-shield]: https://img.shields.io/badge/%F0%9F%A4%AF%20PR%20WELCOME-%E2%86%92-ffcb47?labelColor=black&style=for-the-badge
[profile-link]: https://github.com/lobehub
[sponsor-link]: https://opencollective.com/lobehub 'Become 🩷 LobeHub Sponsor'
[sponsor-shield]: https://img.shields.io/badge/-Sponsor%20LobeHub-f04f88?logo=opencollective&logoColor=white&style=flat-square
[vercel-link]: https://vidol.lobehub.com
[vercel-shield]: https://img.shields.io/website?down_message=offline&label=vercel&labelColor=black&logo=vercel&style=flat-square&up_message=online&url=https%3A%2F%2Fvidol.lobehub.com
[vercel-shield-badge]: https://img.shields.io/website?down_message=offline&label=try%20lobechat&labelColor=black&logo=vercel&style=for-the-badge&up_message=online&url=https%3A%2F%2Fvidol.lobehub.com
