<div align="center"><a name="readme-top"></a>

<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-logo/1.0.0/files/assets/logo-3d.webp">
<img height="120" src="https://gw.alipayobjects.com/zos/kitchen/qJ3l3EPsdW/split.svg">
<img height="120" src="https://registry.npmmirror.com/@lobehub/assets-emoji-anim/1.0.0/files/assets/teddy-bear.webp">

# Lobe Vidol

Lobe Vidolと共に、バーチャルアイドル制作の魔法を体験し、洗練されたUIデザインを楽しみ、MMDに対応したダンスコンテンツをサポートし、キャラクターとのスムーズな対話を実現します — これらすべての機能がシームレスなプラットフォームに統合されています。

<sup>誰でもバーチャルアイドルを創造できます</sup>

[English](./README.md) · [简体中文](./README.zh-CN.md) · **日本語** · [文書][docs] · [変更履歴](./CHANGELOG.md) · [バグ報告][github-issues-link] · [機能リクエスト][github-issues-link]

[![][github-release-shield]][github-release-link]
[![][vercel-shield]][vercel-link]
[![][discord-shield]][discord-link]
[![][github-releasedate-shield]][github-releasedate-link]
[![][github-action-test-shield]][github-action-test-link]
[![][github-action-release-shield]][github-action-release-link]<br/>
[![][github-contributors-shield]][github-contributors-link]
[![][github-forks-shield]][github-forks-link]
[![][github-stars-shield]][github-stars-link]
[![][github-issues-shield]][github-issues-link]
[![][github-license-shield]][github-license-link]<br>
[![][sponsor-shield]][sponsor-link]

![](https://github.com/lobehub/lobe-vidol/assets/17870709/90d7295f-9461-4765-a936-20720afb48c3)

</div>

> \[!NOTE]
> Lobe Vidolは現在開発初期段階にあり、Betaテストを実施しています。ぜひご参加いただき、一緒に貢献しましょう！

<details>
<summary><kbd>目次</kbd></summary>

#### TOC

- [👋🏻 はじめに & コミュニケーション](#-はじめに--コミュニケーション)
- [✨ 特徴一覧](#-特徴一覧)
  - [1. **スムーズな対話体験**](#1-スムーズな対話体験)
  - [2. **背景設定**](#2-背景設定)
  - [3. **豊富なアクションとポーズライブラリ**](#3-豊富なアクションとポーズライブラリ)
  - [4. **洗練されたUIデザイン**](#4-洗練されたuiデザイン)
  - [5. **豊富なキャラクター編集体験**](#5-豊富なキャラクター編集体験)
  - [6. **MMDダンスサポート**](#6-mmdダンスサポート)
  - [7. \*\* PMXステージ読み込み機能 \*\*](#7--pmxステージ読み込み機能-)
  - [8. \*\* タッチレスポンス機能 \*\*](#8--タッチレスポンス機能-)
  - [9. \*\* キャラクターマーケット \*\*](#9--キャラクターマーケット-)
  - [10. \*\* ダンスマーケット \*\*](#10--ダンスマーケット-)
  - [11. \*\* TTS & STT音声会話 \*\*](#11--tts--stt音声会話-)
- [📦 エコシステム](#-エコシステム)
- [⌨️ ローカル開発](#️-ローカル開発)
- [🤝 貢献する](#-貢献する)
- [🩷 コミュニティスポンサー](#-コミュニティスポンサー)
- [🔗 その他のツール](#-その他のツール)
  - [その他のプロジェクト](#その他のプロジェクト)
  - [関連リンク](#関連リンク)

####

</details>

## 👋🏻 はじめに & コミュニケーション

LobeVidolは現在積極的に開発中です。ご要望や問題があれば、ぜひ\[issues]\[issues-link]を提出してください。

| [![][vercel-shield-badge]][vercel-link]   | インストールや登録は不要！私たちのウェブサイトにアクセスするだけで、すぐに体験できます           |
| :---------------------------------------- | :----------------------------------------------------------------------------------------------- |
| [![][discord-shield-badge]][discord-link] | 私たちのDiscordコミュニティに参加しましょう！ここでは、開発者や他のLobeHubファンと交流できます。 |

> \[!IMPORTANT]
>
> **プロジェクトをスターしてください**。そうすれば、GitHubからすべてのリリース通知を遅延なく受け取れます～⭐️

<img width="1749" alt="star (1)" src="https://github.com/user-attachments/assets/73f96340-ef2b-4d9b-ab6f-71f30c0c02fb">

<details><summary><kbd>スター履歴</kbd></summary>
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=lobehub%2Flobe-vidol&theme=dark&type=Date">
    <img src="https://api.star-history.com/svg?repos=lobehub%2Flobe-vidol&type=Date">
  </picture>
</details>

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## ✨ 特徴一覧

### 1. **スムーズな対話体験**

ストリーミングレスポンスにより、スムーズな対話体験が実現します。キャラクターの対話シーンを設定することで、キャラクターの動作や表情を（）内に、現在起こっている事やシーンを \[] 内に入れることで、臨場感を味わえます。

<img width="1291" alt="fluent chat experience" src="https://github.com/user-attachments/assets/6b3a2df4-c80e-4cb4-8d62-c6c5532d0f00">

### 2. **背景設定**

背景画像を設定することで、対話をより状況に合ったものにすることができます：

<img width="1318" alt="background setting" src="https://github.com/user-attachments/assets/e62b635c-168d-4f4e-8741-39aac0f7cfd3">

### 3. **豊富な動作とポーズライブラリ**

内蔵のMixamoキャラクター動作とポーズライブラリを使用して、対話中にキャラクターに希望のポーズや動作を取らせることができます：

<img width="1323" alt="motions and postures" src="https://github.com/user-attachments/assets/95d9a42e-4215-45f2-8171-f631a91065c9">

### 4. **洗練されたUIデザイン**

丁寧にデザインされたインターフェースは、エレガントな外観とスムーズなインタラクション効果を持ち、ライトとダークテーマをサポートし、モバイル端末にも対応しています。PWAをサポートし、ネイティブアプリに近い体験を提供します。

<img width="1408" alt="ui design" src="https://github.com/user-attachments/assets/e55df3c0-4e7b-4b5d-b903-e5865498da7a">

### 5. **豊富なキャラクター編集体験**

キャラクターエディタを使用して、自分だけのバーチャルアイドルを作成し、タッチ反応を設定し、VRMモデルをサイトにアップロードして彼らとインタラクションできます。

<img width="1291" alt="role edit" src="https://github.com/user-attachments/assets/3d319554-ae14-4932-b527-e220c910fd51">

### 6. **MMDダンスサポート**

mmd-parserのサポートを利用して、vmdファイルを使用してお気に入りのアイドルと一緒に踊ることができます；Just Dance!

<https://github.com/user-attachments/assets/c017be86-dbac-4ce1-9f00-a10248b58621>

### 7. **PMXステージロード機能**

ステージロード機能を追加し、豊富なステージ選択肢を内蔵しました。キャラクターが踊る際に異なるステージスタイルを組み合わせることができます：

<img width="1317" alt="pmx stage" src="https://github.com/user-attachments/assets/ec436b96-c270-431a-acef-f140584e6938">

### 8. **タッチ反応機能**

キャラクターの異なる身体部分をクリックすると、キャラクターが異なる反応を示します。また、キャラクターのタッチ反応を自分で編集して、ユニークなインタラクション効果を生み出すこともできます：

<https://github.com/user-attachments/assets/a283bca0-222c-4ac8-8757-8c56ce3873c2>

### 9. **キャラクターマーケット**

LobeVidolのキャラクターマーケットには、多くの精巧にデザインされたキャラクターが集まっています。これらのキャラクターは、さまざまな状況やインタラクション体験を提供し、特別な伴侶体験を提供します。
私たちのマーケットは、単なる展示プラットフォームではなく、協力の場でもあります。ここでは、誰もが自分の想像を貢献し、個別に設定したキャラクターを共有できます。

> \[!TIP]
>
> キャラクター作成機能を使用すると、簡単に自分のキャラクター作品をプラットフォームに提出できます。特に強調したいのは、LobeVidolが精密な自動化国際化（i18n）ワークフローを構築していることです。その強力な点は、あなたのキャラクターをシームレスに多言語バージョンに変換できることです。つまり、ユーザーがどの言語を使用していても、あなたのキャラクターを障害なく体験できます。

<img width="1320" alt="discover" src="https://github.com/user-attachments/assets/9f155227-6856-4957-9f6e-a9b3f534df24">

### 10. **ダンスマーケット**

LobeVidolのダンスマーケットには、豊富なMMDダンスリソースが追加されており、これらのダンスは豊かな視覚体験を構成します。異なるキャラクター、ステージ、音楽、ダンスを組み合わせて、ユニークな視聴体験を創造できます。

<img width="1323" alt="Snipaste_2024-11-05_21-22-47" src="https://github.com/user-attachments/assets/684ba6ad-17a9-4af3-9943-fcaaee121216">

### 11. **TTS & STT音声会話**

LobeVidolは、テキストから音声（Text-to-Speech、TTS）および音声からテキスト（Speech-to-Text、STT）技術をサポートしており、これによりアプリケーションはテキスト情報を明瞭な音声出力に変換できます。ユーザーは、まるで人と話しているかのように、私たちの対話アシスタントと交流できます。
ユーザーは多様な声の中から選択し、アシスタントに適した音源を組み合わせることができます。また、聴覚学習を好むユーザーや忙しい中で情報を得たいユーザーにとって、TTSは素晴らしい解決策を提供します。

LobeVidolでは、地域や文化的背景の異なるユーザーのニーズに応えるために、高品質な音声オプション（OpenAI Audio、Microsoft Edge Speech）を厳選しました。ユーザーは個人の好みや特定のシーンに応じて適切な音声を選択し、パーソナライズされた交流体験を得ることができます。

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## 📦 エコシステム

| NPM                               | リポジトリ                              | 説明                                                                                                 | バージョン                                |
| --------------------------------- | --------------------------------------- | ---------------------------------------------------------------------------------------------------- | ----------------------------------------- |
| [@lobehub/ui][lobe-ui-link]       | [lobehub/lobe-ui][lobe-ui-github]       | AIGC ウェブアプリケーションの構築のために設計されたオープンソース UI コンポーネントライブラリ        | [![][lobe-ui-shield]][lobe-ui-link]       |
| [@lobehub/icons][lobe-icons-link] | [lobehub/lobe-icons][lobe-icons-github] | 主流の AI / LLM モデルと企業の SVG ロゴおよびアイコンのコレクション                                  | [![][lobe-icons-shield]][lobe-icons-link] |
| [@lobehub/tts][lobe-tts-link]     | [lobehub/lobe-tts][lobe-tts-github]     | AI TTS / STT 音声合成 / 認識のための React Hooks ライブラリ                                          | [![][lobe-tts-shield]][lobe-tts-link]     |
| [@lobehub/lint][lobe-lint-link]   | [lobehub/lobe-lint][lobe-lint-github]   | LobeHub コードスタイルガイド ESlint、Stylelint、Commitlint、Prettier、Remark および Semantic Release | [![][lobe-lint-shield]][lobe-lint-link]   |

- **[Vidol market](https://github.com/v-idol/vidol-chat-agents)** - これは Vidol Chat のマーケットインデックスです。Vidol はこのリポジトリから index.json にアクセスして、利用可能なエージェントとダンスのリストをユーザーに表示します。
- **[Vidol agent sample](https://github.com/v-idol/vidol-agent-sample)** - Vidol キャラクターデータテンプレート
- **[Vidol dance sample](https://github.com/v-idol/vidol-dance-sample)** - Vidol ダンスデータテンプレート

<div align="right">

[![][back-to-top]](#readme-top)

</div>

## ⌨️ ローカル開発

GitHub Codespaces を使用してオンライン開発ができます：

[![][github-codespace-shield]][github-codespace-link]

または、以下のコマンドを使用してローカル開発を行うことができます：

[![][bun-shield]][bun-link]

```bash
$ git clone https://github.com/lobehub/lobe-vidol.git
$ cd lobe-vidol
$ bun install
$ bun dev
```

<div align="right">

[!\[\]\[back-to-top\]](#readme-top)

</div>

## 🤝 貢献の参加

私たちはさまざまな形の貢献を大歓迎します。コードの貢献に興味がある場合は、私たちの GitHub \[Issues]\[github-issues-link] と \[Projects]\[github-project-link] を確認し、あなたのアイデアを私たちに示してください。

\[!\[]\[pr-welcome-shield]]\[pr-welcome-link]

<a href="https://github.com/lobehub/lobe-vidol/graphs/contributors" target="_blank">
  <table>
    <tr>
      <th colspan="2">
        <br><img src="https://contrib.rocks/image?repo=lobehub/lobe-vidol"><br><br>
      </th>
    </tr>
    <tr>
      <td>
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=light">
        </picture>
      </td>
      <td rowspan="2">
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-participants-growth/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=4x7&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-participants-growth/thumbnail.png?activity=active&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=4x7&color_scheme=light">
        </picture>
      </td>
    </tr>
    <tr>
      <td>
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=new&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=dark">
          <img src="https://next.ossinsight.io/widgets/official/compose-org-active-contributors/thumbnail.png?activity=new&period=past_90_days&owner_id=131470832&repo_ids=784800776&image_size=2x3&color_scheme=light">
        </picture>
      </td>
    </tr>
  </table>
</a>

<div align="right">

[!\[\]\[back-to-top\]](#readme-top)

</div>

## 🩷 コミュニティの支援

あなたの支援は非常に貴重であり、私たちが支える輝かしい銀河を形成します！あなたは夜空を切り裂く流れ星のようで、私たちの前進の道を瞬時に照らします。私たちへの信頼に感謝します —— あなたの支援は星のように、プロジェクトの進むべき光を何度も指し示します。

<a href="https://opencollective.com/lobehub" target="_blank">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/lobehub/.github/blob/main/static/sponsor-dark.png?raw=true">
    <img  src="https://github.com/lobehub/.github/blob/main/static/sponsor-light.png?raw=true">
  </picture>
</a>

<div align="right">

[!\[\]\[back-to-top\]](#readme-top)

</div>

## 🔗 さらなるツール

### さらなるプロジェクト

- **\[🤖 Lobe Chat]\[lobe-chat] :** 拡張可能な（Function Calling）プラグインシステムをサポートするオープンソースの、モダンデザインの ChatGPT/LLMs チャットアプリケーションと開発フレームワーク。あなたのプライベート ChatGPT/LLMs アプリをワンクリックで無料デプロイできます。
- **\[🅰️ Lobe SD Theme]\[lobe-theme]:** Stable Diffusion WebUI のモダンテーマ、洗練されたインターフェースデザイン、高度にカスタマイズ可能な UI、および効率を向上させる機能。
- **\[⛵️ Lobe Midjourney WebUI]\[lobe-midjourney-webui]:** Midjourney WebUI、テキストプロンプトに基づいて迅速に多様な画像を生成し、創造性を刺激し、対話を強化します。
- **\[🌏 Lobe i18n]\[lobe-i18n]:** Lobe i18n は、ChatGPT によって駆動される i18n（国際化）翻訳プロセスの自動化ツールです。大きなファイルの自動分割、インクリメンタル更新、OpenAI モデル、API プロキシ、温度のカスタマイズオプションをサポートします。

### 関連リンク

- **mmd-parser** - <https://github.com/takahirox/mmd-parser>
- **three-vrm** - <https://github.com/pixiv/three-vrm>
- **tts-vue** - <https://github.com/LokerL/tts-vue>

<div align="right">

[!\[\]\[back-to-top\]](#readme-top)

</div>

---

#### 📝 ライセンス

Copyright © 2024 \[lobehub]\[profile-link]. <br />
このプロジェクトは [Apache 2.0](./LICENSE) ライセンスです。

[back-to-top]: https://img.shields.io/badge/-BACK_TO_TOP-black?style=flat-square
[bun-link]: https://bun.sh
[bun-shield]: https://img.shields.io/badge/-speedup%20with%20bun-black?logo=bun&style=for-the-badge
[discord-link]: https://discord.gg/AYFPHvv2jT
[discord-shield]: https://img.shields.io/discord/1127171173982154893?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=flat-square
[discord-shield-badge]: https://img.shields.io/discord/1127171173982154893?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=for-the-badge
[github-action-release-link]: https://github.com/actions/workflows/lobehub/lobe-vidol/release.yml
[github-action-release-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-vidol/release.yml?label=release&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-action-test-link]: https://github.com/actions/workflows/lobehub/lobe-vidol/test.yml
[github-action-test-shield]: https://img.shields.io/github/actions/workflow/status/lobehub/lobe-vidol/test.yml?label=test&labelColor=black&logo=githubactions&logoColor=white&style=flat-square
[github-codespace-link]: https://codespaces.new/lobehub/lobe-vidol
[github-codespace-shield]: https://github.com/codespaces/badge.svg
[github-contributors-link]: https://github.com/lobehub/lobe-vidol/graphs/contributors
[github-contributors-shield]: https://img.shields.io/github/contributors/lobehub/lobe-vidol?color=c4f042&labelColor=black&style=flat-square
[github-forks-link]: https://github.com/lobehub/lobe-vidol/network/members
[github-forks-shield]: https://img.shields.io/github/forks/lobehub/lobe-vidol?color=8ae8ff&labelColor=black&style=flat-square
[github-issues-link]: https://github.com/lobehub/lobe-vidol/issues
[github-issues-shield]: https://img.shields.io/github/issues/lobehub/lobe-vidol?color=ff80eb&labelColor=black&style=flat-square
[github-license-link]: https://github.com/lobehub/lobe-vidol/blob/main/LICENSE
[github-license-shield]: https://img.shields.io/github/license/lobehub/lobe-vidol?color=white&labelColor=black&style=flat-square
[github-release-link]: https://github.com/lobehub/lobe-vidol/releases
[github-release-shield]: https://img.shields.io/github/v/release/lobehub/lobe-vidol?color=369eff&labelColor=black&logo=github&style=flat-square
[github-releasedate-link]: https://github.com/lobehub/lobe-vidol/releases
[github-releasedate-shield]: https://img.shields.io/github/release-date/lobehub/lobe-vidol?labelColor=black&style=flat-square
[github-stars-link]: https://github.com/lobehub/lobe-vidol/network/stargazers
[github-stars-shield]: https://img.shields.io/github/stars/lobehub/lobe-vidol?color=ffcb47&labelColor=black&style=flat-square
[docs]: https://docs.vidol.chat
[lobe-chat]: https://github.com/lobehub/lobe-chat
[lobe-i18n]: https://github.com/lobehub/lobe-commit/tree/master/packages/lobe-i18n
[lobe-icons-github]: https://github.com/lobehub/lobe-icons
[lobe-icons-link]: https://www.npmjs.com/package/@lobehub/icons
[lobe-icons-shield]: https://img.shields.io/npm/v/@lobehub/icons?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-lint-github]: https://github.com/lobehub/lobe-lint
[lobe-lint-link]: https://www.npmjs.com/package/@lobehub/lint
[lobe-lint-shield]: https://img.shields.io/npm/v/@lobehub/lint?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-midjourney-webui]: https://github.com/lobehub/lobe-midjourney-webui
[lobe-theme]: https://github.com/lobehub/sd-webui-lobe-theme
[lobe-tts-github]: https://github.com/lobehub/lobe-tts
[lobe-tts-link]: https://www.npmjs.com/package/@lobehub/tts
[lobe-tts-shield]: https://img.shields.io/npm/v/@lobehub/tts?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[lobe-ui-github]: https://github.com/lobehub/lobe-ui
[lobe-ui-link]: https://www.npmjs.com/package/@lobehub/ui
[lobe-ui-shield]: https://img.shields.io/npm/v/@lobehub/ui?color=369eff&labelColor=black&logo=npm&logoColor=white&style=flat-square
[pr-welcome-link]: https://github.com/lobehub/lobe-vidol/pulls
[pr-welcome-shield]: https://img.shields.io/badge/%F0%9F%A4%AF%20PR%20WELCOME-%E2%86%92-ffcb47?labelColor=black&style=for-the-badge
[profile-link]: https://github.com/lobehub
[sponsor-link]: https://opencollective.com/lobehub 'Become 🩷 LobeHub Sponsor'
[sponsor-shield]: https://img.shields.io/badge/-Sponsor%20LobeHub-f04f88?logo=opencollective&logoColor=white&style=flat-square
[vercel-link]: https://vidol.lobehub.com
[vercel-shield]: https://img.shields.io/website?down_message=offline&label=vercel&labelColor=black&logo=vercel&style=flat-square&up_message=online&url=https%3A%2F%2Fvidol.lobehub.com
[vercel-shield-badge]: https://img.shields.io/website?down_message=offline&label=try%20lobechat&labelColor=black&logo=vercel&style=for-the-badge&up_message=online&url=https%3A%2F%2Fvidol.lobehub.com
