match .. case 用法

```scala
def main(args: Array[String]): Unit = {
    var list = new ArrayBuffer[Int]()

    for (i<- 1 to 100) {
      i match {
        case 10 => println(10)
        case 20 => println(20)
        // 增加守卫条件
        case _ if(i%2 == 0) => list.append(i)
        case _ if(i%23 == 0) => println(i)
        case _ =>
      }
    }

    println(list)
  }
```

十分灵活强大

## case class 样例类

```scala
// 抽象类
  abstract class Person
  // 样例类
  case class Student(name:String, age:Int, no:Int) extends Person
  case class Teacher(name:String, age:Int, no:Int) extends Person
  case class Nobody(name:String) extends Person

  def main(args: Array[String]): Unit = {
    // case class 会自动生成apply方法，省去new操作
    val p:Person = Student("jack", 20, 1)
    // match case
    p match {
      case Student(name, age, no) => println("Student name: " + name + " age: " + age + " No: "+ no)
      case Teacher(name, age, no) => println("Teacher name: " + name + " age: " + age + " No: "+ no)
      case Nobody(name) => println("Nobody name: " + name)
    }
  }

```

TODO….

