# UNIX网络编程 卷1：套接字联网API（第3版）

![](http://img4.douban.com/mpic/s4437258.jpg)

# 时间安排

10月10-11月中旬

- ~~早上地铁(30min)~~ (搬家了比较近) 
- 中午12点后(20min)
- ~~下班地铁(10min)~~
- 晚上(3h)

**总计：4h**

- 每天1章节： 共计1个月泛读。
- 每天列好学习计划和其他安排。

# 章节目录学习计划

## 第一部分 简介和tcp/ip
### 第1章 简介	2

- [x] 1.1 概述	2
- [x] 1.2 一个简单的时间获取客户程序	5
- [x] 1.3 协议无关性	9
- [x] 1.4 错误处理：包裹函数	10
- [x] 1.5 一个简单的时间获取服务器程序	12
- [x] 1.6 本书中客户/服务器程序示例索引表	14
- [x] 1.7 osi模型	16
- [x] 1.8 bsd网络支持历史	17
- [x] 1.9 测试用网络及主机	19
- [x] 1.10 unix标准	22
- [x] 1.11 64位体系结构	24
- [x] 1.12 小结 25
- [x] 习题	25

### 第2章 传输层：tcp、udp和sctp	27

- [x] 2.1 概述	27
- [x] 2.2 总图	27
- [x] 2.3 用户数据报协议（udp）	29
- [x] 2.4 传输控制协议（tcp）	30
- [x] 2.5 流控制传输协议（sctp）	31
- [x] 2.6 tcp连接的建立和终止	31
- [x] 2.7 time_wait状态	37
- [x] 2.8 sctp关联的建立和终止	38
- [x] 2.9 端口号	42
- [x] 2.10 tcp端口号与并发服务器	43
- [x] 2.11 缓冲区大小及限制	45
- [x] 2.12 标准因特网服务	50
- [x] 2.13 常见因特网应用的协议使用	51
- [x] 2.14 小结	52

## 第二部分 基本套接字编程

### 第3章 套接字编程简介	56

- [x] 3.1 概述	56
- [x] 3.2 套接字地址结构	56
- [x] 3.3 值—结果参数	61
- [x] 3.4 字节排序函数	63
- [x] 3.5 字节操纵函数	66
- [x] 3.6 inet_aton、inet_addr和inet_ntoa函数	67
- [x] 3.7 inet_pton和inet_ntop函数	68
- [x] 3.8 sock_ntop和相关函数	70
- [x] 3.9 readn、writen和readline函数	72
- [x] 3.10 小结	76

### 第4章 基本tcp套接字编程	77

- [x] 4.1 概述	77
- [x] 4.2 socket函数	77
- [x] 4.3 connect函数	80
- [x] 4.4 bind函数	81
- [x] 4.5 listen函数	84
- [x] 4.6 accept函数	88
- [x] 4.7 fork和exec函数	90
- [x] 4.8 并发服务器	91
- [x] 4.9 close函数	93
- [x] 4.10 getsockname和getpeername函数	94
- [x] 4.11 小结	96

### 第5章 tcp客户/服务器程序示例	97

- [x] 5.1 概述	97
- [x] 5.2 tcp回射服务器程序：main函数	97
- [x] 5.3 tcp回射服务器程序：str_echo函数	98
- [x] 5.4 tcp回射客户程序：main函数	99
- [x] 5.5 tcp回射客户程序：str_cli函数	100
- [x] 5.6 正常启动	101
- [x] 5.7 正常终止	102
- [x] 5.8 posix信号处理	103 (这里尚不明晰)
- [x] 5.9 处理sigchld信号	106  (这里尚不明晰)
- [x] 5.10 wait和waitpid函数	108 (这里尚不明晰)
- [ ] 5.11 accept返回前连接中止	111
- [ ] 5.12 服务器进程终止	112
- [ ] 5.13 sigpipe信号	113
- [ ] 5.14 服务器主机崩溃	114
- [ ] 5.15 服务器主机崩溃后重启	115
- [ ] 5.16 服务器主机关机	116
- [ ] 5.17 tcp程序例子小结	116
- [ ] 5.18 数据格式	117
- [ ] 5.19 小结	120
- [ ] 习题	120

### 第6章 i/o复用：select和poll函数	122

- [ ] 6.1 概述	122
- [ ] 6.2 i/o模型	122
- [ ] 6.3 select函数	127
- [ ] 6.4 str_cli函数（修订版）	132
- [ ] 6.5 批量输入	133
- [ ] 6.6 shutdown函数	136
- [ ] 6.7 str_cli函数（再修订版）	137
- [ ] 6.8 tcp回射服务器程序（修订版）	138
- [ ] 6.9 pselect函数	142
- [ ] 6.10 poll函数	144
- [ ] 6.11 tcp回射服务器程序（再修订版）	146
- [ ] 6.12 小结	148
- [ ] 习题	149

### 第7章 套接字选项	150

- [ ] 7.1 概述	150
- [ ] 7.2 getsockopt和setsockopt函数	150
- [ ] 7.3 检查选项是否受支持并获取默认值	152
- [ ] 7.4 套接字状态	156
- [ ] 7.5 通用套接字选项	156
- [ ] 7.6 ipv4套接字选项	168
- [ ] 7.7 icmpv6套接字选项	169
- [ ] 7.8 ipv6套接字选项	169
- [ ] 7.9 tcp套接字选项	171
- [ ] 7.10 sctp套接字选项	173
- [ ] 7.11 fcntl函数	182
- [ ] 7.12 小结	184
- [ ] 习题	184

### 第8章 基本udp套接字编程	186

- [ ] 8.1 概述	186
- [ ] 8.2 recvfrom和sendto函数	187
- [ ] 8.3 udp回射服务器程序：main函数	187
- [ ] 8.4 udp回射服务器程序：dg_echo函数	188
- [ ] 8.5 udp回射客户程序：main函数	190
- [ ] 8.6 udp回射客户程序：dg_cli函数	190
- [ ] 8.7 数据报的丢失	191
- [ ] 8.8 验证接收到的响应	191
- [ ] 8.9 服务器进程未运行	193
- [ ] 8.10 udp程序例子小结	194
- [ ] 8.11 udp的connect函数	196
- [ ] 8.12 dg_cli函数（修订版）	199
- [ ] 8.13 udp缺乏流量控制	200
- [ ] 8.14 udp中的外出接口的确定	203
- [ ] 8.15 使用select函数的tcp和udp回射服务器程序	204
- [ ] 8.16 小结	206
- [ ] 习题	207

### 第9章 基本sctp套接字编程	208

- [ ] 9.1 概述	208
- [ ] 9.2 接口模型	208
- [ ] 9.3 sctp_bindx函数	212
- [ ] 9.4 sctp_connectx函数	213
- [ ] 9.5 sctp_getpaddrs函数	213
- [ ] 9.6 sctp_freepaddrs函数	213
- [ ] 9.7 sctp_getladdrs函数	214
- [ ] 9.8 sctp_freeladdrs函数	214
- [ ] 9.9 sctp_sendmsg函数	214
- [ ] 9.10 sctp_recvmsg函数	215
- [ ] 9.11 sctp_opt_info函数	215
- [ ] 9.12 sctp_peeloff函数	216
- [ ] 9.13 shutdown函数	216
- [ ] 9.14 通知	217
- [ ] 9.15 小结	221
- [ ] 习题	222

### 第10章 sctp客户/服务器程序例子	223

- [ ] 10.1 概述	223
- [ ] 10.2 sctp一到多式流分回射服务器程序：main函数	223
- [ ] 10.3 sctp一到多式流分回射客户程序：main函数	225
- [ ] 10.4 sctp流分回射客户程序：sctpstr_cli函数	226
- [ ] 10.5 探究头端阻塞	228
- [ ] 10.6 控制流的数目	233
- [ ] 10.7 控制终结	233
- [ ] 10.8 小结	234
- [ ] 习题	235

### 第11章 名字与地址转换	236

- [ ] 11.1 概述	236
- [ ] 11.2 域名系统	236
- [ ] 11.3 gethostbyname函数	239
- [ ] 11.4 gethostbyaddr函数	242
- [ ] 11.5 getservbyname和getservbyport函数	242
- [ ] 11.6 getaddrinfo函数	245
- [ ] 11.7 gai_strerror函数	250
- [ ] 11.8 freeaddrinfo函数	251
- [ ] 11.9 getaddrinfo函数：ipv6	251
- [ ] 11.10 getaddrinfo函数：例子	253
- [ ] 11.11 host_serv函数	254
- [ ] 11.12 tcp_connect函数	254
- [ ] 11.13 tcp_listen函数	257
- [ ] 11.14 udp_client函数	261
- [ ] 11.15 udp_connect函数	263
- [ ] 11.16 udp_server函数	264
- [ ] 11.17 getnameinfo函数	266
- [ ] 11.18 可重入函数	267
- [ ] 11.19 gethostbyname_r和gethostbyaddr_r函数	270
- [ ] 11.20 作废的ipv6地址解析函数	271
- [ ] 11.21 其他网络相关信息	272
- [ ] 11.22 小结	273
- [ ] 习题	274

## 第三部分 高级套接字编程

### 第12章 ipv4与ipv6的互操作性	278

- [ ] 12.1 概述	278
- [ ] 12.2 ipv4客户与ipv6服务器	278
- [ ] 12.3 ipv6客户与ipv4服务器	281
- [ ] 12.4 ipv6地址测试宏	283
- [ ] 12.5 源代码可移植性	284
- [ ] 12.6 小结	284
- [ ] 习题	285

### 第13章 守护进程和inetd超级服务器	286

- [ ] 13.1 概述	286
- [ ] 13.2 syslogd守护进程	286
- [ ] 13.3 syslog函数	287
- [ ] 13.4 daemon_init函数	289
- [ ] 13.5 inetd守护进程	293
- [ ] 13.6 daemon_inetd函数	297
- [ ] 13.7 小结	299
- [ ] 习题	299

### 第14章 高级i/o函数	300

- [ ] 14.1 概述	300
- [ ] 14.2 套接字超时	300
- [ ] 14.3 recv和send函数	305
- [ ] 14.4 readv和writev函数	306
- [ ] 14.5 recvmsg和sendmsg函数	307
- [ ] 14.6 辅助数据	310
- [ ] 14.7 排队的数据量	313
- [ ] 14.8 套接字和标准i/o	313
- [ ] 14.9 高级轮询技术	316
- [ ] 14.10 t/tcp：事务目的tcp	320
- [ ] 14.11 小结	322
- [ ] 习题	323

### 第15章 unix域协议	324

- [ ] 15.1 概述	324
- [ ] 15.2 unix域套接字地址结构	324
- [ ] 15.3 socketpair函数	326
- [ ] 15.4 套接字函数	327
- [ ] 15.5 unix域字节流客户/服务器程序	327
- [ ] 15.6 unix域数据报客户/服务器程序	329
- [ ] 15.7 描述符传递	330
- [ ] 15.8 接收发送者的凭证	337
- [ ] 15.9 小结	340
- [ ] 习题	340

### 第16章 非阻塞式i/o	341

- [ ] 16.1 概述	341
- [ ] 16.2 非阻塞读和写：str_cli函数（修订版）	342
- [ ] 16.3 非阻塞connect	351
- [ ] 16.4 非阻塞connect：时间获取客户程序	352
- [ ] 16.5 非阻塞connect：web客户程序	354
- [ ] 16.6 非阻塞accept	362
- [ ] 16.7 小结	363
- [ ] 习题	363

### 第17章 ioctl操作	365

- [ ] 17.1 概述	365
- [ ] 17.2 ioctl函数	365
- [ ] 17.3 套接字操作	366
- [ ] 17.4 文件操作	367
- [ ] 17.5 接口配置	367
- [ ] 17.6 get_ifi_info函数	369
- [ ] 17.7 接口操作	378
- [ ] 17.8 arp高速缓存操作	378
- [ ] 17.9 路由表操作	380
- [ ] 17.10 小结	381
- [ ] 习题	381

### 第18章 路由套接字	382

- [ ] 18.1 概述	382
- [ ] 18.2 数据链路套接字地址结构	382
- [ ] 18.3 读和写	383
- [ ] 18.4 sysctl操作	390
- [ ] 18.5 get_ifi_info函数	394
- [ ] 18.6 接口名字和索引函数	397
- [ ] 18.7 小结	401
- [ ] 习题	401

### 第19章 密钥管理套接字	402

- [ ] 19.1 概述	402
- [ ] 19.2 读和写	403
- [ ] 19.3 倾泻安全关联数据库	404
- [ ] 19.4 创建静态安全关联	407
- [ ] 19.5 动态维护安全关联	412
- [ ] 19.6 小结	415
- [ ] 习题	416

### 第20章 广播	417

- [ ] 20.1 概述	417
- [ ] 20.2 广播地址	418
- [ ] 20.3 单播和广播的比较	419
- [ ] 20.4 使用广播的dg_cli函数	422
- [ ] 20.5 竞争状态	424
- [ ] 20.6 小结	431
- [ ] 习题	432

### 第21章 多播	433

- [ ] 21.1 概述	433
- [ ] 21.2 多播地址	433
- [ ] 21.3 局域网上多播和广播的比较	436
- [ ] 21.4 广域网上的多播	438
- [ ] 21.5 源特定多播	440
- [ ] 21.6 多播套接字选项	441
- [ ] 21.7 mcast_join和相关函数	445
- [ ] 21.8 使用多播的dg_cli函数	450
- [ ] 21.9 接收ip多播基础设施会话声明	451
- [ ] 21.10 发送和接收	454
- [ ] 21.11 sntp：简单网络时间协议	457
- [ ] 21.12 小结	461
- [ ] 习题	461

### 第22章 高级udp套接字编程	462

- [ ] 22.1 概述	462
- [ ] 22.2 接收标志、目的ip地址和接口索引	462
- [ ] 22.3 数据报截断	467
- [ ] 22.4 何时用udp代替tcp	467
- [ ] 22.5 给udp应用增加可靠性	469
- [ ] 22.6 捆绑接口地址	478
- [ ] 22.7 并发udp服务器	482
- [ ] 22.8 ipv6分组信息	483
- [ ] 22.9 ipv6路径mtu控制	486
- [ ] 22.10 小结	487
- [ ] 习题	488

### 第23章 高级sctp套接字编程	489

- [ ] 23.1 概述	489
- [ ] 23.2 自动关闭的一到多式服务器程序	489
- [ ] 23.3 部分递送	490
- [ ] 23.4 通知	492
- [ ] 23.5 无序的数据	495
- [ ] 23.6 捆绑地址子集	496
- [ ] 23.7 确定对端和本端地址信息	497
- [ ] 23.8 给定ip地址找出关联id	500
- [ ] 23.9 心搏和地址不可达	501
- [ ] 23.10 关联剥离	502
- [ ] 23.11 定时控制	503
- [ ] 23.12 何时改用sctp代替tcp	505
- [ ] 23.13 小结	506
- [ ] 习题	506

### 第24章 带外数据	507

- [ ] 24.1 概述	507
- [ ] 24.2 tcp带外数据	507
- [ ] 24.3 sockatmark函数	513
- [ ] 24.4 tcp带外数据小结	519
- [ ] 24.5 客户/服务器心搏函数	520
- [ ] 24.6 小结	524
- [ ] 习题	524

### 第25章 信号驱动式i/o	525

- [ ] 25.1 概述	525
- [ ] 25.2 套接字的信号驱动式i/o	525
- [ ] 25.3 使用sigio的udp回射服务器程序	527
- [ ] 25.4 小结	532
- [ ] 习题	533

### 第26章 线程	534

- [ ] 26.1 概述	534
- [ ] 26.2 基本线程函数：创建和终止	535
- [ ] 26.3 使用线程的str_cli函数	537
- [ ] 26.4 使用线程的tcp回射服务器程序	538
- [ ] 26.5 线程特定数据	542
- [ ] 26.6 web客户与同时连接	549
- [ ] 26.7 互斥锁	552
- [ ] 26.8 条件变量	555
- [ ] 26.9 web客户与同时连接（续）	558
- [ ] 26.10 小结	560
- [ ] 习题	560

### 第27章 ip选项	561

- [ ] 27.1 概述	561
- [ ] 27.2 ipv4选项	561
- [ ] 27.3 ipv4源路径选项	562
- [ ] 27.4 ipv6扩展首部	569
- [ ] 27.5 ipv6步跳选项和目的地选项	569
- [ ] 27.6 ipv6路由首部	573
- [ ] 27.7 ipv6粘附选项	577
- [ ] 27.8 历史性ipv6高级api	578
- [ ] 27.9 小结	579
- [ ] 习题	579

### 第28章 原始套接字	580

- [ ] 28.1 概述	580
- [ ] 28.2 原始套接字创建	580
- [ ] 28.3 原始套接字输出	581
- [ ] 28.4 原始套接字输入	582
- [ ] 28.5 ping程序	584
- [ ] 28.6 traceroute程序	596
- [ ] 28.7 一个icmp消息守护程序	608
- [ ] 28.8 小结	622
- [ ] 习题	622

### 第29章 数据链路访问	623

- [ ] 29.1 概述	623
- [ ] 29.2 bpf：bsd分组过滤器	623
- [ ] 29.3 dlpi：数据链路提供者接口	625
- [ ] 29.4 linux：sock_packet和
- [ ] pf_packet	626
- [ ] 29.5 libpcap：分组捕获函数库	627
- [ ] 29.6 libnet：分组构造与输出函数库	627
- [ ] 29.7 检查udp的校验和字段	628
- [ ] 29.8 小结	645
- [ ] 习题	645

### 第30章 客户/服务器程序设计范式	646

- [ ] 30.1 概述	646
- [ ] 30.2 tcp客户程序设计范式	648
- [ ] 30.3 tcp测试用客户程序	649
- [ ] 30.4 tcp迭代服务器程序	650
- [ ] 30.5 tcp并发服务器程序，每个客户一个子进程	650
- [ ] 30.6 tcp预先派生子进程服务器程序，accept无上锁保护	653
- [ ] 30.7 tcp预先派生子进程服务器程序，accept使用文件上锁保护	659
- [ ] 30.8 tcp预先派生子进程服务器程序，accept使用线程上锁保护	662
- [ ] 30.9 tcp预先派生子进程服务器程序，传递描述符	663
- [ ] 30.10 tcp并发服务器程序，每个客户一个线程	667
- [ ] 30.11 tcp预先创建线程服务器程序，每个线程各自accept	669
- [ ] 30.12 tcp预先创建线程服务器程序，主线程统一accept	671
- [ ] 30.13 小结	673
- [ ] 习题	674

### 第31章 流	675

- [ ] 31.1 概述	675
- [ ] 31.2 概貌	675
- [ ] 31.3 getmsg和putmsg函数	678
- [ ] 31.4 getpmsg和putpmsg函数	679
- [ ] 31.5 ioctl函数	680
- [ ] 31.6 tpi：传输提供者接口	680
- [ ] 31.7 小结	689
- [ ] 习题	689

- [ ] 附录a ipv4、ipv6、icmpv4和
- [ ] icmpv6	690
- [ ] 附录b 虚拟网络	704
- [ ] 附录c 调试技术	708
- [ ] 附录d 杂凑的源代码	714
- [ ] 附录e 精选习题答案	726

# 涉及其他书籍：
- 《C Primer Plus》
- 《深入C指针》
- 《图解TCP/IP》
- 《Linux私房菜》

# 涉及知识点：
- TCP/IP 协议
- C
- Linux
