了解linux目录结构是至关重要的，查看目录结构的命令就是`ls`，如果想以树形结构展示，可以执行如下命令：

	ls -R | grep ":$" | sed -e 's/:$//' -e 's/[^-][^\/]*\//--/g' -e 's/^/   /' -e 's/-/|/' 

或者安装`tree`工具

RHEL/CentOS and Fedora linux:

	yum install tree -y

Debian/Ubuntu:

	sudo apt-get install tree -y

`tree`命令键入即可

其命令参数如下

	-A 使用ASNI绘图字符显示树状图而非以ASCII字符组合。
	-C 在文件和目录清单加上色彩，便于区分各种类型。
	-D 列出文件或目录的更改时间。
	-g 列出文件或目录的所属群组名称，没有对应的名称时，则显示群组识别码。
	-i 不以阶梯状列出文件或目录名称。
	-I 不显示符合范本样式的文件或目录名称。
	-l 如遇到性质为符号连接的目录，直接列出该连接所指向的原始目录。
	-n 不在文件和目录清单加上色彩。
	-N 直接列出文件和目录名称，包括控制字符。
	-p 列出权限标示。
	-P 只显示符合范本样式的文件或目录名称。
	-q 用"?"号取代控制字符，列出文件和目录名称。
	-s 列出文件或目录大小。
	-u 列出文件或目录的拥有者名称，没有对应的名称时，则显示用户识别码。
	-x 将范围局限在现行的文件系统中，若指定目录下的某些子目录，其存放于另一个文件系统上，则将该子目录予以排除在寻找范围外。

# 一.根目录
linux中所有目录都是由根目录(/)开始

![](http://images.cnblogs.com/cnblogs_com/peida/linux目录树.png)

图片来自：http://www.cnblogs.com/peida/archive/2012/11/21/2780075.html

根目录(/)下应该包含如下子目录：

- /bin: 执行档目录，主要有：cat,chmod, chown, date, mv, mkdir, cp, bash等等常用的指令。
- /boot：主要放置开机会使用到的文件
- /dev: 必要设备, 例如：dev/null, /dev/zero, /dev/tty , /dev/lp*, / dev/hd*, /dev/sd*等等
- /etc: 系统主要的设定档几乎都放置在这个目录内，例如人员的帐号密码档、各种服务的启始档等等。 一般来说，这个目录下的各档案属性是可以让一般使用者查阅的，但是只有root有权力修改。 FHS**建议不要放置可执行档(binary)在这个目录中**。 比较重要的档案有：/etc/inittab, /etc/init.d/, /etc/modprobe.conf, /etc/X11/, /etc/fstab, /etc/sysconfig/等等。 另外，其下重要的目录有：**/etc/init.d/ ：所有服务的预设启动script都是放在这里的**，例如要启动或者关闭iptables的话： /etc/init.d/iptables start、/etc/init.d/ iptables stop
- /home: 这是系统预设的使用者家目录(home directory)。 在你新增一个一般使用者帐号时，预设的使用者家目录都会规范到这里来。比较重要的是，家目录有两种代号： 
**~ ：代表当前使用者的家目录**，而 ~guest：则代表用户名为guest的家目录。
- /lib: /lib放置的则是在开机时会用到的函式库，以及在/bin或/sbin底下的指令会呼叫的函式库
- /media: 软碟、光碟、DVD等等装置都暂时挂载于此。 常见的档名有：/media/floppy, /media/cdrom等等。
- /mnt: 临时挂载的文件系统
- /opt: 可选应用软件包。
- /root: root家目录
- /sbin: 必要的系统二进制文件，例如： init、 ip、 mount。**sbin目录下的命令，普通用户都执行不了**。
- /tmp: 临时文件
- /usr: 默认软件都会存于该目录下
- /var: 变量文件,在正常运行的系统中其内容不断变化的文件，如日志，脱机文件和临时电子邮件文件。

# 二./etc目录

- /etc/rc;/etc/rc.d;/etc/rc*.d: 启动、或改变运行级时运行的scripts或scripts的目录.
- /etc/hosts: 本地域名解析文件
- /etc/sysconfig/network: IP、掩码、网关、主机名配置
- /etc/resolv.conf: DNS服务器配置
- /etc/fstab: 开机自动挂载系统，所有分区开机都会自动挂载
- /etc/inittab: 设定系统启动时Init进程将把系统设置成什么样的runlevel及加载相关的启动文件配置
- /etc/exports: 设置NFS系统用的配置文件路径
- /etc/init.d: 这个目录来存放系统启动脚本
- /etc/profile, /etc/csh.login,  /etc/csh.cshrc: 全局系统环境配置变量
- /etc/issue: 认证前的输出信息，默认输出版本内核信息
- /etc/motd: 设置认证后的输出信息，
- /etc/mtab: 当前安装的文件系统列表.由scripts初始化，并由mount 命令自动更新.需要一个当前安装的文件系统的列表时使用，例如df 命令
- /etc/group: 类似/etc/passwd ，但说明的不是用户而是组.
- /etc/passwd: 用户数据库，其中的域给出了用户名、真实姓名、家目录、加密的口令和用户的其他信息.
- /etc/shadow: 在安装了影子口令软件的系统上的影子口令文件.影子口令文件将/etc/passwd 文件中的加密口令移动到/etc/shadow 中，而后者只对root可读.这使破译口令更困难.
- /etc/sudoers: 可以sudo命令的配置文件
- /etc/syslog.conf: 系统日志参数配置
- /etc/login.defs: 设置用户帐号限制的文件
- /etc/securetty: 确认安全终端，即哪个终端允许root登录.一般只列出虚拟控制台，这样就不可能(至少很困难)通过modem或网络闯入系统并得到超级用户特权.
- /etc/printcap: 类似/etc/termcap ，但针对打印机.语法不同.
- /etc/shells: 列出可信任的shell.chsh 命令允许用户在本文件指定范围内改变登录shell.提供一台机器FTP服务的服务进程ftpd 检查用户shell是否列在 /etc/shells 文件中，如果不是将不允许该用户登录.
- /etc/opt/: /opt/的配置文件
- /etc/X11/: X_Window系统(版本11)的配置文件
- /etc/sgml/: SGML的配置文件
- /etc/xml/: XML的配置文件
- /etc/skel/: 默认创建用户时，把该目录拷贝到家目录下

# 三. /usr 目录
![](http://beginman.qiniudn.com/linux_file3.png)

# 四. /var 目录
![](http://beginman.qiniudn.com/linux_file4.png)

# 五. /proc/目录
虚拟文件系统，将内核与进程状态归档为文本文件（系统信息都存放这目录下）。
例如：uptime、 network。在Linux中，对应Procfs格式挂载。该目录下文件只能看不能改（包括root）

![](http://beginman.qiniudn.com/linux_file5.png)

图片截自：[linux目录结构详细介绍](http://yangrong.blog.51cto.com/6945369/1288072)



