# 一.用户与群组
首先要明白一点：**linux是多人多任务的系统**，所以才有用户和群组的概念，Linux通过用户，群组来约定文档的权限，在 Linux 里面,任何一个档案都具有『User, Group 及 Others』三 种身份的个别权限。

![](http://7fvf56.com1.z0.glb.clouddn.com/linux_user_group.png)

# 二.linux文件权限
使用命令`ls -al`输出如下：

![](http://7fvf56.com1.z0.glb.clouddn.com/linux_file.png)

文件的类型与权限是这节最重要的，共有10个字符表示, 如下图：

![](http://7fvf56.com1.z0.glb.clouddn.com/linux_file2.png)

## 1.文档类型
第一个字符如:`d`表示文档的类型

- `d`: 表示目录
- `-`: 表示文件
- `l`: 表示连接档
- `b`: 表示接口设备
- `c`: 表示串行端口设备，如键盘，鼠标

## 2.文件权限

	[-][rwx][r-x][r--]
	1 234 567 890

1 为:代表这个文件名为目彔戒档案,本例中为档案(-);

234 为:拥有者的权限,本例中为可读、可写、可执行(rwx); 

567 为:同群组用户权力,本例中为可读可执行(rx);

890 为:其他用户权力,本例中为可读(r)

# 三.改变文件属性和权限

- `chgrp`: 改变文档所属群组
- `chown`: 改变文档拥有者
- `chmod`: 改变文档的权限, SUID, SGID, SBIT 等

## 1. chgrp
chgrp（change group）:更改文档群组，**注意要改变的群组必须在/etc/group中**， 命令如下：

	chgrp [-R] dirname/filename ...

其中：`R`: 递归， 如下实例：

	chgrp -R beginman tmp/
	ls -l tmp/  
	-rw-r--r-- 1 root beginman 14404 Dec 29  2014 tomic.txt

## 2. chown
chown(change owner): 更改文档拥有者， 同上要更改的用户必须存在`/etc/passwd `中

	chown [-R] 账号名称 文件或目录
	chown [-R] 账号名称:组名 文件或目录

如下实例：

	chown -R beginman tmp/
	ls -l tmp/
	-rw-r--r-- 1 beginman beginman 14404 Dec 29  2014 atomic

可以同时更改拥有者和群组，如下实例：

	chown -R root:root tmp/
	-rw-r--r-- 1 root root 14404 Dec 29  2014 atomic

或者使用`chown user.group file` 用小数点形式也可。**注意：复制行为(cp)会复制执行者的属性和权限**

## 3. chmod
chmod(change mode): 改过权限，通过**数字或符号的形式表示权限**

### 数字类型

- r : 4
- w : 2
- x : 1

每种身份(owner/group/others)各自的三个权限(r/w/x)分数是需要累加的,例如当权限为: 

	[- rwxrwx---] 分数则是:
	owner = rwx = 4+2+1 = 7 
	group = rwx = 4+2+1 = 7 
	others= --- = 0+0+0 = 0

那么对应chmod语法如下：

	chmod [-R] 数字类型表示 文件或目录

如我们让一个shell脚本可执行：

	chmod 755 myshell.sh

如果希望文件不被其他人看到则：

	chmod 740 myshell.sh

### 符号类型

- 身份：user: u,  group: g,  other: o 表示三种不同身份权限
- 操作：+(add), -(remove), =(set) 进行权限操作
- 权限：r,w,x

假如我们要设定一个文件的权限成为:

    -rwxr-xr-x
    user (u):具有可读、可写、可执行的权限;
	group/others (g/o):具有可读不执行的权限

	chmod u=rwx,go=rx myshell.sh

**注意中间没有空格**

如果想增加每个人均可写，则可以：

	chmod a+w .bashrc

如果要去掉每个人的可执行权限，则可以：

	chmod a-x .bashrc

如果想只让自己可执行，其他人都无权限，则可以：

	chmod u=xwr,go=wr a.sh  

# 四.权限的意义
## 1.权限与文件

文件则包含数据，如文本文件，数据库文件，二进制可执行文件等，对于权限来说，它表示如下：

- r: 可读
- w: 可写(但不能删除该文件)
- x: 具有被系统执行的权限（完全由x决定，而不是通过扩展名如.exe,.sh来决定的）

w 权限时,你可以具有写入/编辑/新增/修改文件的内容的权限, 但并无删除该文件本身的权限

## 2.权限与目录

- r: 读取目录结构的权限
- w: 新建/删除/更改/移动 文件或目录的权限
- x: 目录不可以被执行,目录`x` 代表的是用户能否进入该目录成为工作目录的用途! 

比如：

	drwxr--r-- 3 root root 4096 Jun 25 08:35 .ssh

对于非root用户只有读的权限，即`ls path to .ssh/`， 没有进入(`x`)该目录的权限, 也不能操纵该目录

**注意：如果在某个用户的工作目录下新建文件，则该用户可以删除和更改权限**， 如下实例：

	# 以root身份切换到beginman工作区建立文件a.py
	cd /home/beginman

	[root@iviZ beginman]# >a.py
	[root@iviZ beginman]# ll a.py
    -rw-r--r-- 1 root root 0 Jul  9 09:45 a.py  

    # 切换beginman身份并在其工作区下建立b.py
    su beginman
    [beginman@iviZ ~]$ >b.py
	[beginman@iviZ ~]$ ll *.py
    -rw-r--r-- 1 root     root     0 Jul  9 09:45 a.py
    -rw-rw-r-- 1 beginman beginman 0 Jul  9 09:46 b.py   

    # 对于a.py来说，文件拥有者和群组都是root，且权限为rw-r--r--, 则对于beginman为other, 不可写入
    # 但是可以删除和移动，更名等操纵
    [beginman@iviZ ~]$ chmod 775 a.py 

    [beginman@iviZ ~]$ ll *.py
    -rwxrwxr-x 1 beginman beginman 0 Jul  9 09:47 aa.py
    -rw-rw-r-- 1 beginman beginman 0 Jul  9 09:46 b.py  




