命令：

- ps
- pgrep
- lsof
- pmap PID : 分析线程堆栈
- pstree

更多可参考：[进程和作业管理](http://man.linuxde.net/sub/%E8%BF%9B%E7%A8%8B%E5%92%8C%E4%BD%9C%E4%B8%9A%E7%AE%A1%E7%90%86)

# ps

查询属于某个用户的进程：

```bash
$ ps -ef |grep ponn
# 或者：
$ ps -lu ponn
```

`ps -ajx`: 以完整的格式显示所有的进程


# pgrep

通过名字查询进程

```bash
$ pgrep jupyter
14578
```



# lsof

```bash
# 查看端口占用的进程状态：
$ lsof -i:3306  

# 查看某一用户的进程所打开的文件
$ lsof -u username

# 查看某一个进程当前打开的文件
$ lsof -c processname

# PID打开的文件
$ lsof -p 22233

# 查询指定目录下被进程开启的文件（使用+D 递归目录）
$ lsof +d mydir1/
```


# pstree

树状图展示进程之间派生关系

常用选项:

-a 显示每个程序的完整指令，包含路径，参数或是常驻服务的标示。
-h 列出树状图时，特别标明现在执行的程序。

如：

```bash
$ pstree 14578
jupyter-noteboo─┬─13*[python───8*[{python}]]
                ├─2*[python───11*[{python}]]
                ├─python───12*[{python}]
                └─2*[{jupyter-noteboo}]
                
```

