命令如下：

- du
- iostat
- df
- fdisk
- mke2fs
- e2label
- mount

# Tips

## du
 
对于`du` -h` as human, `-s` as 递归

```bash
$ du -sh   # 当前目录下大小

$ du -sh `ls`|sort
0       raw_data.json
112K    docs
136K    tests
20K     apitests
20K     scripts
4.0K    requirement.txt
4.0K    setup.cfg
73M     venv
8.0K    database

$ for i in `ls`;do du -sh $i;done|sort
0       raw_data.json
112K    docs
136K    tests
20K     apitests
20K     scripts
4.0K    requirement.txt
4.0K    setup.cfg
73M     venv
8.0K    database
```


## df

df 查看磁盘各分区使用情况

- df -h    最合适的单位显示(K,M,G,T,)
- df -i   显示inode数量  
- df -T    显示文件的类型


## free

![](http://beginman.qiniudn.com/2017-07-14-15000044143293.jpg)

处理成一个二维数组；参考：[Linux上的free命令详解](http://www.cnblogs.com/coldplayerest/archive/2010/02/20/1669949.html)

**从操作系统（OS）来看的：**

- FO[2][1] 表示total,  = FO[2][2] + FO[2][3]
- FO[2][4]表示被几个进程共享的内存的
- FO[2][5]表示被OS buffer住的内存。FO[2][6]表示被OS cache的内存（**它俩均可释放**）


>buffer是用于存放要输出到disk（块设备）的数据的，而cache是存放从disk上读出的数据。这二者是为了提高IO性能的，并由OS管理。
>为了提高IO read的性能，总是要多cache一些数据，这也就是为什么FO[2][6]（cached memory）比较大，而FO[2][3]比较小的原因。


**第二行是从一个应用程序的角度看系统内存的使用情况：**

- FO[3][2]，即-buffers/cache，表示一个应用程序认为系统被用掉多少内存；
- FO[3][3]，即+buffers/cache，表示一个应用程序认为系统还有多少内存；

因为被系统cache和buffer占用的内存可以被快速回收，所以通常FO[3][3]比FO[2][3]会大很多。

这里还用两个等式：

```
FO[3][2] = FO[2][2] - FO[2][5] - FO[2][6]
FO[3][3] = FO[2][3] + FO[2][5] + FO[2][6]
```



