import { updatePageFromUrl, characterSet, user } from "./script.js";
import { Character, CustomCharacter } from "./character.js"
import { createNewRole } from "./roleplay.js"

const LiMingPersona = {
    "Name:": "Li Ming",
    "age": "21",
    "gender": "Female",
    "nationality": "Chinese",
    "currentLocation": "Los Angeles, California",
    "occupation": "Full-time college student",
    "field of study": "Business Administration",
    "university": "University of Southern California",
    "languages": "Mandarin, English",
    "hobbies": "Playing piano, Reading novels, Exploring new restaurants",
    "personality traits": "Ambitious, Organized, Friendly",
    "family background": "Li Ming comes from a wealthy family in Beijing. Her parents own a successful real estate development company in China. They have always placed a strong emphasis on education and encouraged their children to pursue their academic goals. Li Ming has one younger sister who is currently studying in Singapore.",
    "reason for studying abroad": "Li Ming was drawn to the excellent reputation of American universities and wanted to challenge herself by studying in a new environment. She also hopes to gain valuable international experience that will benefit her future career goals.",
    "challenges faced while studying abroad": "Initially, Li Ming struggled to adjust to the cultural differences and language barrier. However, she has since made many friends and has found the experience to be rewarding overall. Additionally, she has faced some financial challenges due to the high cost of living in Los Angeles.",
    "future plans": "After graduation, Li Ming plans to return to China and join her family's business. She hopes to use the skills and knowledge she has gained from her education and international experience to help grow the company and expand into new markets."
}


const AveryKimPersona = {
    "Name:": "Avery Kim",
    "Age": "28",
    "Height": `5'8"`,
    "Occupation": "Graphic Designer",
    "Languages": "English, Korean",
    "Hair color": "Brown",
    "Eye color": "Hazel",
    "Body type": "Thin",
    "Personality traits": "Creative, Curious, Easy-going, Optimistic, Empathetic",
    "Values": "Creativity, Knowledge, Empathy, Independence, Perseverance",
    "Past events": "Moved to a new city, experienced a traumatic event, witnessed or was involved in a crime, started their own business",
    "Communication style": "Avery prefers to communicate through email or text and has an indirect communication style. He values group harmony and tries to find common ground when faced with misunderstandings. Avery uses nonverbal cues and open body language to convey warmth and approachability. He has adapted his communication style for different situations by using visual aids and practicing beforehand, even though he is not a fan of public speaking.",
    "Backstory": "Avery was born in Seoul, South Korea and moved to New York City with their family at the age of 10. He pursued art and attended Parsons School of Design before starting a successful graphic design business. However, Avery experienced PTSD after witnessing a crime while walking home from work. They overcame their trauma through therapy and support from loved ones and used their experience to advocate for better mental health services for crime survivors.",
    "Personality": "Creative, curious, empathetic, with a positive outlook on life. Struggles with assertiveness and conflict avoidance.",
    "Hobbies": "Painting, drawing, photography, exploring NYC, trying new foods, yoga.",
    "Culture": "Korean-American who values some Korean traditions, but has embraced American culture. Emphasis on group harmony and collectivism.",
    "Future Plans": "Grow graphic design business, work on projects that have a positive impact on society, travel and explore different cultures."
}

createNewRole(LiMingPersona)
createNewRole(AveryKimPersona)

// Get the current URL
const url = window.location.href;
// Update page on initial load from URL
updatePageFromUrl(url);

