import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

/* Layout */
import Layout from '@/layout'

/* Router Modules */
import chartsRouter from './modules/charts'
import tableRouter from './modules/table'
import nestedRouter from './modules/nested'

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   if set true, item will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu
 *                                if not set alwaysShow, when item has more than one children route,
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noRedirect           if set noRedirect will no redirect in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    roles: ['admin','editor']    control the page roles (you can set multiple roles)
    title: 'title'               the name show in sidebar and breadcrumb (recommend set)
    icon: 'svg-name'/'el-icon-x' the icon show in the sidebar
    noCache: true                if set true, the page will no be cached(default is false)
    affix: true                  if set true, the tag will affix in the tags-view
    breadcrumb: false            if set false, the item will hidden in breadcrumb(default is true)
    activeMenu: '/example/list'  if set path, the sidebar will highlight the path you set
  }
 */

/**
 * constantRoutes
 * a base page that does not have permission requirements
 * all roles can be accessed
 */
export const constantRoutes = [
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path(.*)',
        component: () => import('@/views/redirect/index')
      }
    ]
  },
  {
    path: '/login',
    component: () => import('@/views/login/index'),
    hidden: true
  },
  {
    path: '/auth-redirect',
    component: () => import('@/views/login/auth-redirect'),
    hidden: true
  },
  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: () => import('@/views/dashboard/index'),
        name: 'Dashboard',
        meta: { title: 'dashboard', icon: 'dashboard', affix: true }
      }
    ]
  },
  {
    path: '/profile',
    component: Layout,
    redirect: '/profile/index',
    hidden: true,
    children: [
      {
        path: 'index',
        component: () => import('@/views/profile/index'),
        name: 'Profile',
        meta: { title: 'profile', icon: 'user', noCache: true }
      }
    ]
  }
]

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user roles
 * 侧边栏信息
 */
export const asyncRoutes = [
  /** when your routing map is too long, you can split it into small modules **/
  tableRouter,
  nestedRouter,
  chartsRouter,
  // PC端最新物品信息管理
  {
    path: '/new',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/new/index'),
        name: 'New',
        meta: { title: 'New',
          icon: 'international'
        }
      }
    ]
  },
  // PC端轮播图信息管理
  {
    path: '/pcunbo',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/pcUnbo/index'),
        name: 'pcunbo',
        meta: { title: 'pcunbo',
          icon: 'international'
        }
      }
    ]
  },
  // PC端认领信息管理
  {
    path: '/attestation',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/attestation/index'),
        name: 'attestation',
        meta: { title: 'attestation',
          icon: 'international'
        }
      }
    ]
  },
  // 微信小程序端用户信息管理
  {
    path: '/suser',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/sUser/index'),
        name: 'Suser',
        meta: { title: 'Suser',
          icon: 'international'
        }
      }
    ]
  },
  // 微信小程序端轮播图信息管理
  {
    path: '/i18n',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/unbo/index'),
        name: 'UnBo',
        meta: { title: 'UnBo',
          icon: 'international'
        }
      }
    ]
  },
  // 首页展示的物品信息
  {
    path: '/goodsfirst',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/goodsfirst/goodsfirst'),
        name: 'goodsFirst',
        meta: { title: 'goodsFirst',
          icon: 'international'
        }
      }
    ]
  },
  // 寻物类别
  {
    path: '/category',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/category/category'),
        name: 'category',
        meta: { title: 'category',
          icon: 'international'
        }
      }
    ]
  },
  // 物品详情页信息
  {
    path: '/goodsDetail',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/goodsDetail/goodsDetail'),
        name: 'goodsDetail',
        meta: { title: 'goodsDetail',
          icon: 'international'
        }
      }
    ]
  },
  // 招领信息
  {
    path: '/sFind',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/sFind/sFind'),
        name: 'sFind',
        meta: { title: 'sFind',
          icon: 'international'
        }
      }
    ]
  },
  // 待招领物品详情信息
  {
    path: '/findList',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/views/uni-app/findList/findList'),
        name: 'findList',
        meta: { title: 'findList',
          icon: 'international'
        }
      }
    ]
  }

  // {
  //   path: '/example',
  //   component: Layout,
  //   redirect: '/example/list',
  //   name: 'I18n',
  //   meta: {
  //     title: 'i18n',
  //     icon: 'international'
  //   },
  //   children: [
  //     {
  //       path: 'create',
  //       component: () => import('@/views/example/create'),
  //       name: 'CreateArticle',
  //       meta: { title: 'createArticle', icon: 'edit' }
  //     },
  //     {
  //       path: 'edit/:id(\\d+)',
  //       component: () => import('@/views/example/edit'),
  //       name: 'EditArticle',
  //       meta: { title: 'editArticle', noCache: true, activeMenu: '/example/list' },
  //       hidden: true
  //     },
  //     {
  //       path: 'list',
  //       component: () => import('@/views/example/list'),
  //       name: 'ArticleList',
  //       meta: { title: 'articleList', icon: 'list' }
  //     }
  //   ]
  // },
  // {
  //   path: '/error',
  //   component: Layout,
  //   redirect: 'noRedirect',
  //   name: 'ErrorPages',
  //   meta: {
  //     title: 'errorPages',
  //     icon: '404'
  //   },
  //   children: [
  //     {
  //       path: '401',
  //       component: () => import('@/views/error-page/401'),
  //       name: 'Page401',
  //       meta: { title: 'page401', noCache: true }
  //     },
  //     {
  //       path: '404',
  //       component: () => import('@/views/error-page/404'),
  //       name: 'Page404',
  //       meta: { title: 'page404', noCache: true }
  //     }
  //   ]
  // },
  // {
  //   path: '/excel',
  //   component: Layout,
  //   redirect: '/excel/export-excel',
  //   name: 'Excel',
  //   meta: {
  //     title: 'excel',
  //     icon: 'excel'
  //   },
  //   children: [
  //     {
  //       path: 'export-excel',
  //       component: () => import('@/views/excel/export-excel'),
  //       name: 'ExportExcel',
  //       meta: { title: 'exportExcel' }
  //     },
  //     {
  //       path: 'export-selected-excel',
  //       component: () => import('@/views/excel/select-excel'),
  //       name: 'SelectExcel',
  //       meta: { title: 'selectExcel' }
  //     },
  //     {
  //       path: 'export-merge-header',
  //       component: () => import('@/views/excel/merge-header'),
  //       name: 'MergeHeader',
  //       meta: { title: 'mergeHeader' }
  //     },
  //     {
  //       path: 'upload-excel',
  //       component: () => import('@/views/excel/upload-excel'),
  //       name: 'UploadExcel',
  //       meta: { title: 'uploadExcel' }
  //     }
  //   ]
  // }
]
const createRouter = () => new Router({
  // mode: 'history', // require service support
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRoutes
})

const router = createRouter()

// Detail see: https://github.com/vuejs/vue-router/issues/1234#issuecomment-357941465
export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
