<?php

/*
 * This file is part of the `liip/LiipImagineBundle` project.
 *
 * (c) https://github.com/liip/LiipImagineBundle/graphs/contributors
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

namespace Liip\ImagineBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Compiler pass to register post_processors tagged with liip_imagine.filter.post_processor.
 *
 * @author Konstantin Tjuterev <kostik.lv@gmail.com>
 */
class PostProcessorsCompilerPass extends AbstractCompilerPass
{
    public function process(ContainerBuilder $container): void
    {
        $tags = $container->findTaggedServiceIds('liip_imagine.filter.post_processor');

        if (\count($tags) > 0 && $container->hasDefinition('liip_imagine.filter.manager')) {
            $manager = $container->getDefinition('liip_imagine.filter.manager');

            foreach ($tags as $id => $tag) {
                $manager->addMethodCall('addPostProcessor', [$tag[0]['post_processor'] ?? $id, new Reference($id)]);
                $this->log($container, 'Registered filter post-processor: %s', $id);
            }
        }
    }
}
