## A List of companies that use formal verification methods in software engineering

If you see a company on the list that doesn't exist anymore, or does not use formal methods anymore,
please send a pull request with an explanation. The same goes if you're currently working at, or know a company that uses formal methods but is not on the list. Please include the website, github (if applicable), locations, and sector.
If the company is hiring please include a link to the ad.

| Name | Location | Sector | Source |
| :--- | :------- | :----- | :----- |
[Amazon](https://www.amazon.com/) | USA | eCommerce, Cloud computing | ```TLA+``` [How Amazon Web Services Uses Formal Methods](https://cacm.acm.org/magazines/2015/4/184701-how-amazon-web-services-uses-formal-methods/abstract), [Use of Formal Methods at Amazon Web Services](http://lamport.azurewebsites.net/tla/amazon.html), ```CBMC``` [Model Checking Boot Code from AWS Data Centers](http://www.kroening.com/papers/cav2018-aws.pdf), ```Dafny``` [AWS Encryption SDK](https://github.com/aws/aws-encryption-sdk-dafny)
[Airbus](http://www.airbus.com/) | France |  | ```Astrée```: "In 2003, Astrée proved the absence of any runtime errors in the primary flight-control software of an Airbus model. The system’s 132,000 lines of C code were analyzed completely automatically in only 80 minutes on a 2.8GHz 32-bit PC using 300MB of memory (and in only 50 minutes on an AMD Athlon 64 using 580MB of memory). Since then, Airbus France has been using Astrée in the development of safety-critical software for vari­ous plane series, including the A380.", ```Coq``` ([Interview with Xavier Leroy](https://www.cs.cmu.edu/~popl-interviews/leroy.html)), `CAVEAT`, a C-verifier developed by CEA and [used by Airbus](https://www.researchgate.net/publication/3965267)., `Frama-C` ([Industrial use of a safe and efficient formal method based software engineering process in avionics](https://www.erts2020.org/inc/telechargerPdf.php?pdf=ERTS2020_paper_54.pdf)).
[Altran](https://www.altran.com/us/en/) | France, Paris |  | ```SPARK``` [SPARK contributors](http://www.spark-2014.org/contributors)
[Apple](https://www.apple.com/) | Santa Clara Valley, California, USA | Hardware and Software |
[Arm](https://www.arm.com/company) | Austin, Texas, & San Jose, California, USA | Hardware | ```ACL2``` [Verification of Arithmetic Hardware](https://ieeexplore.ieee.org/document/9974354), [Verifying against the official ARM specification](https://alastairreid.github.io/using-armarm/), ```TLA+``` [Linux Kernel](https://git.kernel.org/pub/scm/linux/kernel/git/cmarinas/kernel-tla.git/about/)
[AdaCore](http://www.adacore.com/company) | USA, New York | ? | ?
[Alacris](https://alacris.io/) | ? | Blockchain | |
[BAE Systems](http://www.baesystems.com/en/home) | | | ```Coq``` [Reddit](https://www.reddit.com/r/Coq/comments/7ajnct/coq_in_industry/dpavptl/)
[BedRock Systems](https://www.bedrocksystems.com/) | Boston & Bay Area, USA; Berlin & Munich, Germany | Systems Security, Trustworthy Compute | ```Coq```, ```C++```, [github](https://github.com/bedrocksystems)
[The Boeing Company](http://www.boeing.com/) | USA | Aerospace, Defense |```Coq``` (no proof), ```Ivory``` ([source](https://github.com/GaloisInc/ivory/tree/master/ivory-paper))
[Bosch](https://www.bosch.com/) | Germany | Automotive | [Astrée](https://www.absint.com/bosch_as.htm)
[Centaur Technology](https://centtech.com/) | USA | Hardware | ``ACL2`` | ```ACL2``` [Industrial Use of ACL2]
[Cog Systems](https://cog.systems/) | Australia, New South Wales, Sydney | | [Site](https://cog.systems/d4-secure-sdk/)
[Data61](https://www.csiro.au/) | Australia | | ``` Isabelle/HOL``` ([The seL4 verification project](http://ts.data61.csiro.au/projects/seL4-verification/))
[Draper](https://www.draper.com/) | USA | Defense, Space | [```Coq```](https://github.com/draperlaboratory/parts), [```Z3```](https://github.com/draperlaboratory/cbat_tools)
[Ethereum](https://ethereum.org/) | Switzerland | | ```Why3``` [Dev Update: Formal Methods](https://blog.ethereum.org/2016/09/01/formal-methods-roadmap/), ```Isabelle/HOL``` [A Lem formalization of EVM and some Isabelle/HOL proofs](https://github.com/pirapira/eth-isabelle), ```Coq``` [Formal Verification of Ethereum Contracts](https://github.com/pirapira/ethereum-formal-verification-overview)
[EdgeSecurity](https://www.edgesecurity.com/) | | Software | `Tamarin` [WireGuard](https://www.wireguard.com/formal-verification/)
[eSpark Learning](https://www.esparklearning.com/) | USA, IL, Chicago | Education | ```TLA+``` [Formal Methods in Practice: Using TLA+ at eSpark Learning](https://medium.com/espark-engineering-blog/formal-methods-in-practice-8f20d72bce4f)
[Elastic](https://www.elastic.co/) | Global | Search & analytics software | ```TLA+``` ```Isabelle/HOL``` [elasticsearch-formal-models repository](https://github.com/elastic/elasticsearch-formal-models) [conference talk](https://www.elastic.co/elasticon/conf/2018/sf/reliable-by-design-applying-formal-methods-to-distributed-systems) and [current open positions](https://www.elastic.co/about/careers#engineering)
European Space Agency | | | `TLA+` ([Formal Development of a Network-Centric RTOS](https://www.springer.com/gp/book/9781441997357): `The European Space Agency's Rosetta spacecraft, which flew to a comet, used a real-time operating system called Virtuoso to control some of its instruments.  The next version of that operating system, called OpenComRTOS, was developed using TLA+`)
[Facebook](https://www.facebook.com/) | USA |  | ```INFER``` [Moving Fast with Software Verification](https://research.fb.com/wp-content/uploads/2016/11/publication00124_download0001.pdf) ```Zoncolan``` [How Facebook uses static analysis to detect and prevent security issues](https://engineering.fb.com/security/zoncolan/)
[FireEye](https://www.fireeye.com/) | Dresden, Germany (team defunct) | Security | ```Coq``` [Job announcement: formal methods engineer and scientific developer at FireEye](https://coq-club.inria.narkive.com/KjBqxSSI/job-announcement-formal-methods-engineer-and-scientific-developer-at-fireeye)
[FinProof](https://finproof.io/v2/) | Russia, SPb | Finance (Blockchain) | ```Coq```, ```Agda```
[Formal Land](https://formal.land/) | Global | Software | ```Coq``` [Verification of the Tezos blockchain](https://formal-land.gitlab.io/coq-tezos-of-ocaml/)
[Formal Vindications](https://formalv.com/) | Barcelona, Spain | Law | ```Coq``` [Formalized datetime software](https://gitlab.com/formalv/formalv)
[Galois](https://galois.com) | Portland, Oregon, USA | Consulting/Research | ```Coq``` (?)
[genua GmbH](https://www.genua.de/en/about-us.html) | Germany | | `CPAchecker` [Another Path for Software Quality? Automated Software Verification and OpenBSD](https://doi.asiabsdcon.org/10.25263/asiabsdcon2019/p10b) and [Application of Software Verificationto OpenBSD Network Modules](https://moritzbuhl.de/bachelor-thesis/)
[Google](https://google.com/) | CA, USA | Cloud computing, Computer software, AI | ```Coq``` ([Simple High-Level Code For Cryptographic Arithmetic – With Proofs, Without Compromises](http://adam.chlipala.net/papers/FiatCryptoSP19/FiatCryptoSP19.pdf) (Chromium)), [Formal Modeling and Analysis of Google’s Megastore in Real-Time Maude](https://www.researchgate.net/publication/267120559_Formal_Modeling_and_Analysis_of_Google's_Megastore_in_Real-Time_Maude)
[Grammatech](https://www.grammatech.com/about) | | | ```Frama-C``` [C Library annotations in ACSL for Frama-C: experience report](http://annotationsforall.org/resources/links/GT-libc-experience-report.pdf)
[Green Hills Software](https://www.ghs.com/) | USA | Aerospace | ```ACL2``` [Industrial Use of ACL2](http://www.cs.man.ac.uk/~regerg/arcade/papers/paper_12.pdf)
[Kestrel Institute](https://www.kestrel.edu) | USA | Computer Science Research | Mostly [ACL2](https://www.cs.utexas.edu/users/moore/acl2/), some [Isabelle/HOL](https://isabelle.in.tum.de), a little of [PVS](https://pvs.csl.sri.com) and [Coq](https://coq.inria.fr). See the [web site](https://www.kestrel.edu), particularly [project pages](https://www.kestrel.edu/research) and [people pages](https://www.kestrel.edu/people), for details and publications.
IBM | USA | ? | ```SPIN/Promela``` [Paul E. McKenney's Journal](https://paulmck.livejournal.com/tag/promela), [What is RCU, Fundamentally?](https://lwn.net/Articles/262464/) (Linux Kernel, RCU), ```Coq``` [Q*Cert](https://researcher.watson.ibm.com/researcher/view_group.php?id=8299)
[IGE+XAO](https://www.ige-xao.com/en/) | Europe | Computer Aided Design | ```Coq``` [Experience Report: Smuggling a Little Bit of Coq Inside a CAD Development Context](https://coq-workshop.gitlab.io/2020/#talk-2-2-1) Coq is used to verify the following: (i) domain-specific algorithms (application of "patches" to electrical design documents) (ii) graph algorithms (A* search, length-preserving tree layout, B&B TSP, ...) (iii) data structures (union-find, priority queues, ...) (iv) programming language related questions (custom language type inference) (v) small research projects
[Intel](https://www.intel.com/) | USA | Hardware | `Prover` ([Fifteen Years of Formal Property Verification in Intel](https://link.springer.com/chapter/10.1007%2F978-3-540-69850-0_8?LI=true)), `HOL Light` ([Formal verification of IA-64 division algorithms](https://www.cl.cam.ac.uk/~jrh13/papers/hol00.html)), `TLA+` ([Pre-RTL formal Verification: An Intel Experience](https://dl.acm.org/doi/10.1145/1391469.1391675))
[Informal Systems](https://informal.systems) | Toronto, Vienna, Lausanne, Berlin | Blockchain, Distributed Systems | `TLA+` [Apalache, Symbolic Model Checker for TLA+](https://github.com/informalsystems/apalache), `Rust` [Tendermint BFT Consensus](https://github.com/informalsystems/tendermint-rs) and [Interblockchain Communication protocol](https://github.com/informalsystems/ibc-rs) in Rust with TLA+ specs, [Model Based Testing with TLA+ and Apalache](https://www.youtube.com/watch?v=aveoIMphzW8)
[InfoTecs](https://infotecs.ru/) | Russia, Moscow |  |  ```TLA+```, ```Coq```, [Construction and formal verification of a fault-tolerant distributed mutual exclusion algorithm](https://dl.acm.org/citation.cfm?doid=3123569.3123571), [Построение и верификация отказоустойчивого алгоритма распределенной блокировки](https://osday.ru/presentations/day1/Shishkin.pdf)
[ISP RAS](http://ispras.ru/) | Moscow, Russia | Operating systems; hardware | ```Frama-C```, ```Jessie```, ```Why3``` [Astraver](https://forge.ispras.ru/projects/astraver), [Linux kernel library functions formally verified](https://github.com/evdenis/verker); ```SPIN/Promela```, ```Microtesk``` [Site](http://microtesk.org/); ```Event-B``` [Моделирование и верификация политик безопасности управления доступом в операционных системах](http://www.ispras.ru/publications/2018/security_policy_modeling_and_verification/), [part of the Event-B specification](https://github.com/17451k/base-model); ```Isabelle/HOL``` [Formal specification of the Cap9 kernel](https://github.com/Daohub-io/cap9-spec)
[Kernkonzept GmbH](https://www.kernkonzept.com/) | Germany | Operating systems | `L4Re` ([source](https://www.kernkonzept.com/l4re.html))
[Kaspersky](https://www.kaspersky.com) | Moscow, Russia | Security/AV | Alloy, TLA, `Event-B` ([source](http://www.mathnet.ru/php/archive.phtml?wshow=paper&jrnid=tisp&paperid=556&option_lang=eng)),  ```Ivory``` ([source](https://ruhaskell.org/posts/talks/2016/08/18/ivory-high-performance-code-for-haskell.html))
[Machine Zone Inc.](https://www.mz.com/) | Russia | Mobile gaming software, Real-time computing, Cloud-based networking  | ```TLA+``` [Twitter](https://twitter.com/levwalkin/status/827129877186752513)
[Microsoft](https://www.microsoft.com/) | Redmond, USA | Software development | ```TLA+``` [TLA+ Proofs](https://www.microsoft.com/en-us/research/publication/tla-proofs/), [Thinking for Programmers](https://channel9.msdn.com/Events/Build/2014/3-642#time=21m46s), [High-level TLA+ specifications for the five consistency levels offered by Azure Cosmos DB](https://github.com/Azure/azure-cosmos-tla), ```Microsoft’s Static Driver Verifier``` [Thorough static analysis of device drivers](https://www.microsoft.com/en-us/research/publication/thorough-static-analysis-of-device-drivers/) ```Clousot``` [Static contrace checking with Abstract Interpretation](https://www.microsoft.com/en-us/research/publication/clousot-static-contract-checking-with-abstract-interpretation/), [Formal Methods and Tools for Distributed Systems](https://researchweek.comp.nus.edu.sg/slides/Thomas%20Ball.pdf), [Formal Methods at Scale in Microsoft](https://softwarecentricsystems.com/wp-content/uploads/2017/10/Thomas-Ball.pdf)
MongoDB | New York, USA | Software development | ```TLA+``` [TLA+ Spec of a simplified part of MongoDB replication system](https://github.com/visualzhou/mongo-repl-tla)
NASA | USA | Space | ```PVS``` [NASA Langley Formal Methods Research Program](https://shemesh.larc.nasa.gov/fm/). ```JPF``` [Java Pathfinder](https://en.wikipedia.org/wiki/Java_Pathfinder),  [Robust Software Engineering Group](https://ti.arc.nasa.gov/tech/rse/),  ```Model Checking``` [Jet Propulsion Laboratory](https://lars-lab.jpl.nasa.gov/projects.html), ```SPIN/Promela``` [Inspiring Applications of Spin](http://spinroot.com/spin/success.html), ```PVS``` ([source](https://www.eeweb.com/profile/adarbari/articles/a-brief-history-of-formal-verification))
[Nomadic Labs](https://nomadic-labs.com/) | Paris, France | blockchain | ```Coq``` [page on software verification](https://nomadic-labs.com/software_verification.html)
[Oracle](https://www.oracle.com/) | Redwood Shores, CA, USA | Enterprise software, Cloud computing, Computer hardware | `ACL2` ([Proving Theorems about Java and the JVM with ACL2](https://www.cs.utexas.edu/users/moore/publications/marktoberdorf-02/index.html))
[Particular Software](https://particular.net/) | | | ```TLA+``` [TLA+ Specifications for NServiceBus](https://github.com/tmasternak/NServiceBus.ModelChecking)
PingCAP | | | ```TLA+``` [TLA+ in TiDB](https://github.com/pingcap/tla-plus)
[Prover Technology](https://www.prover.com/) | Europe | Railway | `Model checking`
[Rusbitech](https://rusbitech.ru/) (РусБиТех) | Russia, Moscow | Системное ПО | `Frama-C`, `Event-B` ([Моделирование и верификация политик безопасности управления доступом в операционных системах](https://www.ispras.ru/publications/2018/security_policy_modeling_and_verification/)) |
[Rockwell Collins](https://www.rockwellcollins.com/) | USA, Cedar Rapids, Iowa | High Assurance Systems | [Formal Methods in the Aerospace Industry: Follow the Money](http://www.jaist.ac.jp/icfem2012/Cofer-ICFEM2012.pdf)
[Serokell](https://serokell.io/#tech) | Tallinn, Estonia | Fintech, blockchain, IoT, machine learning, formal verification | `Agda`
[Synopsis](https://www.synopsys.com/) | ? | ? | [Site](https://www.synopsys.com/verification.html)
[Systerel](https://www.systerel.fr/) | France | Software, Consulting, Service | [S3](https://www.systerel.fr/en/innovation/products/systerel-smart-solver/) a model checker for a synchrone language, [B method](https://www.systerel.fr/en/expertise/formal-methods/b-method/), [Event-b/Rodin](https://www.systerel.fr/en/expertise/formal-methods/rodin-platform/).  [Recruiting](https://www.systerel.fr/actualites/type-offres/offres-emploi/).
[SiFive](https://www.sifive.com) | USA, San Francisco Bay Area | Hardware | ```Coq``` [LinkedIn](https://www.linkedin.com/jobs/view/coq-proof-assistant-based-formal-verification-at-sifive-800018056/)
[Statebox](https://statebox.org/) | Amsterdam, Netherlands | Blockchain | ```Idris``` ([github](https://github.com/statebox))
[Sukhoi](https://www.sukhoi.org/) | Russia, Moscow | Aerospace and defense | [```ANSYS SCADE Suite```](https://www.ansys.com/products/embedded-software/ansys-scade-suite) (source - [A Formally Verified Compiler for Lustre](http://www.tbrk.org/papers/pldi17-slides.pdf))
[Thales](https://www.thalesgroup.com/en) | | | `Frama-C` ([A Bottom-Up Formal Verification Approach for Common Criteria Certification: Application to JavaCard Virtual Machine](https://nikolai-kosmatov.eu/publications/djoudi_hkkomff_erts_2022.pdf)) |
[TrustInSoft](https://trust-in-soft.com/) | USA, CA, San Francisco | - | ```TrustInSoft Analyzer``` [Site](https://trust-in-soft.com/polarssl-verification-kit/)
[Trustworthy Systems](https://ts.data61.csiro.au/) | Australia, Sydney  |  | ```Isabelle/HOL```, ```Coq``` [Site](https://ts.data61.csiro.au/projects/TS/l4.verified/)
[Two Six Technologies](https://twosixtech.com/) | USA | Defense research | ```Isabelle/HOL```, Hardware verification ([example](https://github.com/twosixlabs/ReWire)), ```Coq``` ([example](https://github.com/twosixlabs/coq-operads))
[JetBrains Research](https://jetbrains.org) | Saint Petersburg, Russia | - | `Coq` ([source](https://research.jetbrains.org/ru/groups/group-for-dependent-types-and-hott))
[МЦСТ](http://www.mcst.ru/) | Moscow, Russia | ? | ```SPIN/Promela``` [Методы и средства верификации протоколов когерентности памяти](https://www.youtube.com/watch?v=67eD3hLmU_8&t=43s)
[T-Platforms](https://www.t-platforms.ru/) | Moscow, Russia | - | ```Coq```, ```SPIN/Promela```, ```TLA+```, ```McErlang```, ```mCRL2``` [Employee CV](https://ru.linkedin.com/in/evgeniy-shishkin-9b1b67b3)
CERN | Genève, Switzerland | | ```mCRL2``` [Control Software of the CMS Experiment at CERN’s Large Hadron Collider](https://www.mcrl2.org/web/user_manual/showcases/CMS.html)
[Yandex](https://yandex.com/company/) | | Software | `TLA+` [ClickHouse Replication Algorithm](https://github.com/VadimPlh/Arrival/), [lock-free Memory Allocator](https://github.com/duremar/spec)
[Zilliqa](https://zilliqa.com/) | Singapore | Blockchain | ```Coq``` [scilla-coq project](https://github.com/Zilliqa/scilla-coq)
[Waves](https://wavesprotocol.org/) | | Blockchain | ???

### See also

* [Formal Methods Companies](http://formalmethods.wikia.com/wiki/Companies) (outdated)
* Open vacancies on [indeed.com](https://www.indeed.com/q-Logic-Formal-Verification-jobs.html)
* Formal Methods:  Practice and Experience - Jim Woodcock, Peter Gorm Larsen, Juan Bicarregui, John Fitzgerald
* http://alloytools.org/citations/case-studies.html
* [Overview of formal methods in software engineering](https://www.foi.se/rest-api/report/FOI-R--4156--SE)
* TLA+ https://news.ycombinator.com/item?id=9601770
* [System specifications written in Promela](http://www.pamelazave.com/compare.html)
