---
published: 2018-04-08
id: 47
author: pushtaev
sequence: fsm
---

# BNF of BNF

Since BNF is a context-free language itself, you can represent its syntax with a BNF :).

```text
<syntax>         ::= <rule> | <rule> <syntax>
<rule>           ::= <opt-whitespace> "<" <rule-name>
                     ">" <opt-whitespace>
                     "::=" <opt-whitespace> <expression>
                     <line-end>
<opt-whitespace> ::= " " <opt-whitespace> | ""
<expression>     ::= <list> | <list> <opt-whitespace>
                     "|" <opt-whitespace> <expression>
<line-end>       ::= <opt-whitespace> <EOL> |
                     <line-end> <line-end>
<list>           ::= <term> |
                     <term> <opt-whitespace> <list>
<term>           ::= <literal> | "<" <rule-name> ">"
<literal>        ::= '"' <text1> '"' | "'" <text2> "'"
<text1>          ::= "" | <character1> <text1>
<text2>          ::= "" | <character2> <text2>
<character>      ::= <letter> | <digit> | <symbol>
<letter>         ::= "A" | "B" | "C" | "D" | "E" | "F" |
                     "G" | "H" | "I" | "J" | "K" | "L" |
                     "M" | "N" | "O" | "P" | "Q" | "R" |
                     "S" | "T" | "U" | "V" | "W" | "X" |
                     "Y" | "Z" | "a" | "b" | "c" | "d" |
                     "e" | "f" | "g" | "h" | "i" | "j" |
                     "k" | "l" | "m" | "n" | "o" | "p" |
                     "q" | "r" | "s" | "t" | "u" | "v" |
                     "w" | "x" | "y" | "z"
<digit>          ::= "0" | "1" | "2" | "3" | "4" | "5" |
                     "6" | "7" | "8" | "9"
symbol>         ::=  "|" | " " | "!" | "#" | "$" | "%" |
                     "&" | "(" | ")" | "*" | "+" | "," |
                     "-" | "." | "/" | ":" | ";" | ">" |
                     "=" | "<" | "?" | "@" | "[" | "\" |
                     "]" | "^" | "_" | "`" | "{" | "}" |
                     "~"
<character1>     ::= <character> | "'"
<character2>     ::= <character> | '"'
<rule-name>      ::= <letter> | <rule-name> <rule-char>
<rule-char>      ::= <letter> | <digit> | "-"
```
