import re
from collections import defaultdict
from pathlib import Path

base_url = 'https://developer.mozilla.org/en-US/docs/Web/API/'
doc_base_url = 'https://pkg.go.dev/github.com/life4/gweb/{package}#{obj}'
link = re.escape(f'// {base_url}')
rex = re.compile(rf'(?:{link}([a-zA-Z/-]+))+\nfunc \([a-z]+ \*?([a-zA-Z]+)\) ([a-zA-Z]+)')

refs: dict = defaultdict(list)
for path in Path().glob('*/*.go'):
    content = path.read_text()
    for match in rex.findall(content):
        *links, struct, func = match
        for link in links:
            refs[link].append((path.parent.name, f'{struct}.{func}'))

print("""
# Reference

Below is the mapping of web API to gweb functions.
This file is autogenerated, so some references may be missed.

| Web API | gweb |
| ------- | ---- |
""".strip())
for ref, objects in sorted(refs.items()):
    url = base_url + ref
    ref = ref.replace('/', '.')
    for package, obj in objects:
        doc_url = doc_base_url.format(package=package, obj=obj)
        print(f'| [{ref}]({url}) | [{obj}]({doc_url}) |')
