### 1. Chip

#### 1.1 Chip Info

Chip Name: STM32F407ZGT6.

Extern Oscillator: 8MHz.

UART Pin: TX/RX PA9/PA10.

SPI Pin: SCK/MISO/MOSI/CS  PA5/PA6/PA7/PA4.

### 2. Development and Debugging

#### 2.1 Integrated Development Environment

LibDriver provides both Keil and IAR integrated development environment projects.

MDK is the Keil ARM project and your Keil version must be 5 or higher.Keil ARM project needs STMicroelectronics STM32F4 Series Device Family Pack and you can download from https://www.keil.com/dd2/stmicroelectronics/stm32f407zgtx.

EW is the IAR ARM project and your IAR version must be 9 or higher.

#### 2.2 Serial Port Parameter

Baud Rate: 115200.

Data Bits : 8.

Stop Bits: 1.

Parity: None.

Flow Control: None.

#### 2.3 Serial Port Assistant

We use '\n' to wrap lines.If your serial port assistant displays exceptions (e.g. the displayed content does not divide lines), please modify the configuration of your serial port assistant or replace one that supports '\n' parsing.

### 3. GT30L32S4W

#### 3.1 Command Instruction

1. Show gt30l32s4w chip and driver information.

   ```shell
   gt30l32s4w (-i | --information)
   ```

2. Show gt30l32s4w help.

   ```shell
   gt30l32s4w (-h | --help)
   ```

3. Show gt30l32s4w pin connections of the current board.

   ```shell
   gt30l32s4w (-p | --port)
   ```

5. Run gt30l32s4w read test.

   ```shell
   gt30l32s4w (-t read | --test=read)
   ```

5. Run gt30l32s4w read function, font is the set font, ch is the set char, type is the set font type.

   ```shell
   gt30l32s4w (-e read | --example=read) [--font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>] [--ch=<char>] [--type=<arial | times>]
   ```

#### 3.2 Command Encoding

Command encoding must be ASCII, GBK or GBK2312.

#### 3.3 Command Example

```shell
gt30l32s4w -i

gt30l32s4w: chip is Genitop GT30L32S4W.
gt30l32s4w: manufacturer is Genitop.
gt30l32s4w: interface is SPI.
gt30l32s4w: driver version is 1.0.
gt30l32s4w: min supply voltage is 2.7V.
gt30l32s4w: max supply voltage is 3.3V.
gt30l32s4w: max current is 20.00mA.
gt30l32s4w: max temperature is 85.0C.
gt30l32s4w: min temperature is -40.0C.
```

```shell
gt30l32s4w -p

gt30l32s4w: SCK connected to GPIOA PIN5.
gt30l32s4w: MISO connected to GPIOA PIN6.
gt30l32s4w: MOSI connected to GPIOA PIN7.
gt30l32s4w: CS connected to GPIOA PIN4.
```

```shell
gt30l32s4w -t read

gt30l32s4w: chip is Genitop GT30L32S4W.
gt30l32s4w: manufacturer is Genitop.
gt30l32s4w: interface is SPI.
gt30l32s4w: driver version is 1.0.
gt30l32s4w: min supply voltage is 2.7V.
gt30l32s4w: max supply voltage is 3.3V.
gt30l32s4w: max current is 20.00mA.
gt30l32s4w: max temperature is 85.0C.
gt30l32s4w: min temperature is -40.0C.
gt30l32s4w: start read test.
gt30l32s4w: normal read test.
gt30l32s4w: gt30l32s4w_read_char_12x12 test.
            ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############            
gt30l32s4w: gt30l32s4w_read_char_15x16 test.
                  ######                     
                     ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######                     
gt30l32s4w: gt30l32s4w_read_char_24x24 test.
                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ##################                        
gt30l32s4w: gt30l32s4w_read_char_32x32 test.
                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ######                                                
gt30l32s4w: gt30l32s4w_read_char_extend_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_char_extend_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_char_special_8x16 test.
                        
                        
                        
                        
                        
               #########
         ###############
   #####################
   #####################
         ###############
               #########
                        
                        
                        
                        
                        
gt30l32s4w: gt30l32s4w_read_char_extend_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_char_extend_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_5x7 test.
      #########
      #########
      #########
      #########
               
               
      #########
gt30l32s4w: gt30l32s4w_read_ascii_7x8 test.
      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############
                     
gt30l32s4w: gt30l32s4w_read_ascii_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_ascii_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_ascii_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_ascii_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_arial_12 test.
                     
                     
                     
   ##################
#####################
            #########
         ############
      ###############
      ###############
                     
      ###############
      ###############
gt30l32s4w: gt30l32s4w_read_ascii_times_12 test.
               
               
               
   ############
###############
###############
         ######
      #########
   ############
   ############
               
   ############
gt30l32s4w: gt30l32s4w_read_ascii_arial_16 test.
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
                  ############
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
gt30l32s4w: gt30l32s4w_read_ascii_times_16 test.
                     
                     
                     
                     
      ###############
   ##################
   ##################
               ######
            #########
            #########
         ############
         ############
         ############
                     
         ############
                     
gt30l32s4w: gt30l32s4w_read_ascii_arial_24 test.
                                             
                                             
                                             
                                             
                                             
                                             
               ##############################
         ####################################
      #######################################
   #####################      ###############
   #####################         ############
                                 ############
                              ###############
                           ##################
                        #####################
                     ########################
                  ###########################
                  ###########################
                  ###########################
                                             
                  ###########################
                  ###########################
                  ###########################
                                             
gt30l32s4w: gt30l32s4w_read_ascii_times_24 test.
                              
                              
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
   ###########################
                     #########
                  ######      
                  ######      
                  ######      
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
                              
                              
gt30l32s4w: gt30l32s4w_read_ascii_arial_32 test.
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                     ###########################            
               #################################            
            ################################################
         ###############               #####################
      ##################                  ##################
      ##################                     ###############
                                             ###############
                                             ###############
                                          ##################
                                       #####################
                                 ###########################
                              ##################            
                           #####################            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
gt30l32s4w: gt30l32s4w_read_ascii_times_32 test.
                                          
                                          
                                          
                                          
                                          
                                          
                                          
            ##############################
      ####################################
      ####################################
   #####################   ###############
   #####################   ###############
   #####################   ###############
      ##################   ###############
                           ###############
                        ##################
                        ##################
                     #####################
                     ###                  
                     ###                  
                  ######                  
                  ######                  
                  ######                  
                                          
                                          
               #########                  
               #########                  
               #########                  
                                          
                                          
                                          
                                          
gt30l32s4w: fast read test.
gt30l32s4w: gt30l32s4w_read_char_12x12 test.
            ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############            
gt30l32s4w: gt30l32s4w_read_char_15x16 test.
                  ######                     
                     ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######                     
gt30l32s4w: gt30l32s4w_read_char_24x24 test.
                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ##################                        
gt30l32s4w: gt30l32s4w_read_char_32x32 test.
                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ######                                                
gt30l32s4w: gt30l32s4w_read_char_extend_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_char_extend_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_char_special_8x16 test.
                        
                        
                        
                        
                        
               #########
         ###############
   #####################
   #####################
         ###############
               #########
                        
                        
                        
                        
                        
gt30l32s4w: gt30l32s4w_read_char_extend_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_char_extend_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_5x7 test.
      #########
      #########
      #########
      #########
               
               
      #########
gt30l32s4w: gt30l32s4w_read_ascii_7x8 test.
      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############
                     
gt30l32s4w: gt30l32s4w_read_ascii_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_ascii_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_ascii_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_ascii_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_arial_12 test.
                     
                     
                     
   ##################
#####################
            #########
         ############
      ###############
      ###############
                     
      ###############
      ###############
gt30l32s4w: gt30l32s4w_read_ascii_times_12 test.
               
               
               
   ############
###############
###############
         ######
      #########
   ############
   ############
               
   ############
gt30l32s4w: gt30l32s4w_read_ascii_arial_16 test.
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
                  ############
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
gt30l32s4w: gt30l32s4w_read_ascii_times_16 test.
                     
                     
                     
                     
      ###############
   ##################
   ##################
               ######
            #########
            #########
         ############
         ############
         ############
                     
         ############
                     
gt30l32s4w: gt30l32s4w_read_ascii_arial_24 test.
                                             
                                             
                                             
                                             
                                             
                                             
               ##############################
         ####################################
      #######################################
   #####################      ###############
   #####################         ############
                                 ############
                              ###############
                           ##################
                        #####################
                     ########################
                  ###########################
                  ###########################
                  ###########################
                                             
                  ###########################
                  ###########################
                  ###########################
                                             
gt30l32s4w: gt30l32s4w_read_ascii_times_24 test.
                              
                              
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
   ###########################
                     #########
                  ######      
                  ######      
                  ######      
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
                              
                              
gt30l32s4w: gt30l32s4w_read_ascii_arial_32 test.
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                     ###########################            
               #################################            
            ################################################
         ###############               #####################
      ##################                  ##################
      ##################                     ###############
                                             ###############
                                             ###############
                                          ##################
                                       #####################
                                 ###########################
                              ##################            
                           #####################            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
gt30l32s4w: gt30l32s4w_read_ascii_times_32 test.
                                          
                                          
                                          
                                          
                                          
                                          
                                          
            ##############################
      ####################################
      ####################################
   #####################   ###############
   #####################   ###############
   #####################   ###############
      ##################   ###############
                           ###############
                        ##################
                        ##################
                     #####################
                     ###                  
                     ###                  
                  ######                  
                  ######                  
                  ######                  
                                          
                                          
               #########                  
               #########                  
               #########                  
                                          
                                          
                                          
                                          
gt30l32s4w: finish read test.
```

```shell
gt30l32s4w -e read --font=12 --ch=字

            ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############   
```

```shell
gt30l32s4w -e read --font=12 --ch=!

                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
```

```shell
gt30l32s4w -e read --font=16 --ch=字

                      ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######  
```

```shell
gt30l32s4w -e read --font=16 --ch=!

                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
```

```shell
gt30l32s4w -e read --font=24 --ch=字

                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ##################   
```

```shell
gt30l32s4w -e read --font=24 --ch=!
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############   
```

```shell
gt30l32s4w -e read --font=32 --ch=字

                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ######   
```

```shell
gt30l32s4w -e read --font=32 --ch=!
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############     
```

```shell
gt30l32s4w -e read --font=ascii-7 --ch=!

      #########
      #########
      #########
      #########
               
               
      #########
```

```shell
gt30l32s4w -e read --font=ascii-8 --ch=!

      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############
                     
```

```shell
gt30l32s4w -e read --font=ascii-12 --ch=! --type=arial
         
         
         
#########
#########
#########
#########
#########
#########
         
#########
#########
```

```shell
gt30l32s4w -e read --font=ascii-16 --ch=! --type=arial
            
            
            
   #########
   #########
   #########
   #########
   #########
   #########
   #########
   #########
   #########
            
   #########
   #########
```

```shell
gt30l32s4w -e read --font=ascii-24 --ch=! --type=arial
                     
                     
                     
                     
                     
                     
      ###############
      ###############
      ###############
      ###############
      ###############
      ###############
      ###############
      ###############
      ###############
      ###############
         ############
         ############
         ############
                     
      ###############
      ###############
      ###############
```

```shell
gt30l32s4w -e read --font=ascii-32 --ch=! --type=arial
                              
                              
                              
                              
                              
                              
                              
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
         ###############      
            ############      
            ############      
            ############      
            ############      
            ############      
            ############      
                              
                              
         ###############      
         ###############      
         ###############      
         ###############   
```

```shell
gt30l32s4w -h

Usage:
  gt30l32s4w (-i | --information)
  gt30l32s4w (-h | --help)
  gt30l32s4w (-p | --port)
  gt30l32s4w (-t read | --test=read)
  gt30l32s4w (-e read | --example=read) [--font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>]
             [--ch=<char>] [--type=<arial | times>]

Options:
      --ch=<char>                Set the display char, char is the display char.([default: A])
  -e <read>, --example=<read>    Run the driver example.
      --font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>
                                 Set display font.([default: 32])
  -h, --help                     Show the help.
  -i, --information              Show the chip information.
  -p, --port                     Display the pin connections of the current board.
  -t <read>, --test=<read>       Run the driver test.
      --type=<arial | times>     Set font type.([default: arial])
```

