### 1. Board

#### 1.1 Board Info

Chip Name: Raspberry Pi 4B.

SPI Pin: SCLK/MOSI/MISO/CS GPIO11/GPIO10/GPIO9/GPIO8.

### 2. Install

#### 2.1 Dependencies

Install the necessary dependencies.

```shell
sudo apt-get install libgpiod-dev pkg-config cmake -y
```

#### 2.2 Makefile

Build the project.

```shell
make
```

Install the project and this is optional.

```shell
sudo make install
```

Uninstall the project and this is optional.

```shell
sudo make uninstall
```

#### 2.3 CMake

Build the project.

```shell
mkdir build && cd build 
cmake .. 
make
```

Install the project and this is optional.

```shell
sudo make install
```

Uninstall the project and this is optional.

```shell
sudo make uninstall
```

Test the project and this is optional.

```shell
make test
```

Find the compiled library in CMake. 

```cmake
find_package(gt30l32s4w REQUIRED)
```

### 3. GT30L32S4W

#### 3.1 Command Instruction

1. Show gt30l32s4w chip and driver information.

   ```shell
   gt30l32s4w (-i | --information)
   ```

2. Show gt30l32s4w help.

   ```shell
   gt30l32s4w (-h | --help)
   ```

3. Show gt30l32s4w pin connections of the current board.

   ```shell
   gt30l32s4w (-p | --port)
   ```

5. Run gt30l32s4w read test.

   ```shell
   gt30l32s4w (-t read | --test=read)
   ```

5. Run gt30l32s4w read function, font is the set font, ch is the set char, type is the set font type.

   ```shell
   gt30l32s4w (-e read | --example=read) [--font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>] [--ch=<char>] [--type=<arial | times>]
   ```

#### 3.2 Command Encoding

Command encoding must be ASCII, GBK or GBK2312.

#### 3.3 Command Example

```shell
./gt30l32s4w -i

gt30l32s4w: chip is Genitop GT30L32S4W.
gt30l32s4w: manufacturer is Genitop.
gt30l32s4w: interface is SPI.
gt30l32s4w: driver version is 1.0.
gt30l32s4w: min supply voltage is 2.7V.
gt30l32s4w: max supply voltage is 3.3V.
gt30l32s4w: max current is 20.00mA.
gt30l32s4w: max temperature is 85.0C.
gt30l32s4w: min temperature is -40.0C.
```

```shell
./gt30l32s4w -p

gt30l32s4w: SCK connected to GPIO11(BCM).
gt30l32s4w: MISO connected to GPIO9(BCM).
gt30l32s4w: MOSI connected to GPIO10(BCM).
gt30l32s4w: CS connected to GPIO8(BCM).
```

```shell
./gt30l32s4w -t read

gt30l32s4w: chip is Genitop GT30L32S4W.
gt30l32s4w: manufacturer is Genitop.
gt30l32s4w: interface is SPI.
gt30l32s4w: driver version is 1.0.
gt30l32s4w: min supply voltage is 2.7V.
gt30l32s4w: max supply voltage is 3.3V.
gt30l32s4w: max current is 20.00mA.
gt30l32s4w: max temperature is 85.0C.
gt30l32s4w: min temperature is -40.0C.
gt30l32s4w: start read test.
gt30l32s4w: normal read test.
gt30l32s4w: gt30l32s4w_read_char_12x12 test.
            ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############            
gt30l32s4w: gt30l32s4w_read_char_15x16 test.
                  ######                     
                     ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######                     
gt30l32s4w: gt30l32s4w_read_char_24x24 test.
                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ##################                        
gt30l32s4w: gt30l32s4w_read_char_32x32 test.
                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ######                                                
gt30l32s4w: gt30l32s4w_read_char_extend_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_char_extend_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_char_special_8x16 test.
                        
                        
                        
                        
                        
               #########
         ###############
   #####################
   #####################
         ###############
               #########
                        
                        
                        
                        
                        
gt30l32s4w: gt30l32s4w_read_char_extend_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_char_extend_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_5x7 test.
      #########
      #########
      #########
      #########
               
               
      #########
gt30l32s4w: gt30l32s4w_read_ascii_7x8 test.
      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############
                     
gt30l32s4w: gt30l32s4w_read_ascii_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_ascii_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_ascii_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_ascii_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_arial_12 test.
                     
                     
                     
   ##################
#####################
            #########
         ############
      ###############
      ###############
                     
      ###############
      ###############
gt30l32s4w: gt30l32s4w_read_ascii_times_12 test.
               
               
               
   ############
###############
###############
         ######
      #########
   ############
   ############
               
   ############
gt30l32s4w: gt30l32s4w_read_ascii_arial_16 test.
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
                  ############
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
gt30l32s4w: gt30l32s4w_read_ascii_times_16 test.
                     
                     
                     
                     
      ###############
   ##################
   ##################
               ######
            #########
            #########
         ############
         ############
         ############
                     
         ############
                     
gt30l32s4w: gt30l32s4w_read_ascii_arial_24 test.
                                             
                                             
                                             
                                             
                                             
                                             
               ##############################
         ####################################
      #######################################
   #####################      ###############
   #####################         ############
                                 ############
                              ###############
                           ##################
                        #####################
                     ########################
                  ###########################
                  ###########################
                  ###########################
                                             
                  ###########################
                  ###########################
                  ###########################
                                             
gt30l32s4w: gt30l32s4w_read_ascii_times_24 test.
                              
                              
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
   ###########################
                     #########
                  ######      
                  ######      
                  ######      
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
                              
                              
gt30l32s4w: gt30l32s4w_read_ascii_arial_32 test.
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                     ###########################            
               #################################            
            ################################################
         ###############               #####################
      ##################                  ##################
      ##################                     ###############
                                             ###############
                                             ###############
                                          ##################
                                       #####################
                                 ###########################
                              ##################            
                           #####################            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
gt30l32s4w: gt30l32s4w_read_ascii_times_32 test.
                                          
                                          
                                          
                                          
                                          
                                          
                                          
            ##############################
      ####################################
      ####################################
   #####################   ###############
   #####################   ###############
   #####################   ###############
      ##################   ###############
                           ###############
                        ##################
                        ##################
                     #####################
                     ###                  
                     ###                  
                  ######                  
                  ######                  
                  ######                  
                                          
                                          
               #########                  
               #########                  
               #########                  
                                          
                                          
                                          
                                          
gt30l32s4w: fast read test.
gt30l32s4w: gt30l32s4w_read_char_12x12 test.
            ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############            
gt30l32s4w: gt30l32s4w_read_char_15x16 test.
                  ######                     
                     ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######                     
gt30l32s4w: gt30l32s4w_read_char_24x24 test.
                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ##################                        
gt30l32s4w: gt30l32s4w_read_char_32x32 test.
                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ######                                                
gt30l32s4w: gt30l32s4w_read_char_extend_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_char_extend_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_char_special_8x16 test.
                        
                        
                        
                        
                        
               #########
         ###############
   #####################
   #####################
         ###############
               #########
                        
                        
                        
                        
                        
gt30l32s4w: gt30l32s4w_read_char_extend_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_char_extend_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_5x7 test.
      #########
      #########
      #########
      #########
               
               
      #########
gt30l32s4w: gt30l32s4w_read_ascii_7x8 test.
      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############
                     
gt30l32s4w: gt30l32s4w_read_ascii_6x12 test.
                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                  
                  
gt30l32s4w: gt30l32s4w_read_ascii_8x16 test.
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
gt30l32s4w: gt30l32s4w_read_ascii_12x24 test.
                                    
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
                                    
gt30l32s4w: gt30l32s4w_read_ascii_16x32 test.
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
                                                
                                                
gt30l32s4w: gt30l32s4w_read_ascii_arial_12 test.
                     
                     
                     
   ##################
#####################
            #########
         ############
      ###############
      ###############
                     
      ###############
      ###############
gt30l32s4w: gt30l32s4w_read_ascii_times_12 test.
               
               
               
   ############
###############
###############
         ######
      #########
   ############
   ############
               
   ############
gt30l32s4w: gt30l32s4w_read_ascii_arial_16 test.
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
                  ############
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
gt30l32s4w: gt30l32s4w_read_ascii_times_16 test.
                     
                     
                     
                     
      ###############
   ##################
   ##################
               ######
            #########
            #########
         ############
         ############
         ############
                     
         ############
                     
gt30l32s4w: gt30l32s4w_read_ascii_arial_24 test.
                                             
                                             
                                             
                                             
                                             
                                             
               ##############################
         ####################################
      #######################################
   #####################      ###############
   #####################         ############
                                 ############
                              ###############
                           ##################
                        #####################
                     ########################
                  ###########################
                  ###########################
                  ###########################
                                             
                  ###########################
                  ###########################
                  ###########################
                                             
gt30l32s4w: gt30l32s4w_read_ascii_times_24 test.
                              
                              
                              
                              
                              
         ###############      
      ##################      
   ###########################
   ###########################
   ###########################
                     #########
                  ######      
                  ######      
                  ######      
               #########      
            ############      
            ############      
            ############      
                              
            ############      
            ############      
                              
                              
                              
gt30l32s4w: gt30l32s4w_read_ascii_arial_32 test.
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                                                            
                     ###########################            
               #################################            
            ################################################
         ###############               #####################
      ##################                  ##################
      ##################                     ###############
                                             ###############
                                             ###############
                                          ##################
                                       #####################
                                 ###########################
                              ##################            
                           #####################            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
                        ########################            
                        ########################            
                        ########################            
                        ########################            
                                                            
                                                            
gt30l32s4w: gt30l32s4w_read_ascii_times_32 test.
                                          
                                          
                                          
                                          
                                          
                                          
                                          
            ##############################
      ####################################
      ####################################
   #####################   ###############
   #####################   ###############
   #####################   ###############
      ##################   ###############
                           ###############
                        ##################
                        ##################
                     #####################
                     ###                  
                     ###                  
                  ######                  
                  ######                  
                  ######                  
                                          
                                          
               #########                  
               #########                  
               #########                  
                                          
                                          
                                          
                                          
gt30l32s4w: finish read test.
```

```shell
./gt30l32s4w -e read --font=12 --ch=字

             ############            
               #########            
####################################
########################      ######
                                    
      ##############################
                     ###            
                  ######            
####################################
               #########            
               #########            
         ###############  
```

```shell
./gt30l32s4w -e read --font=12 --ch=!

                  
      ############
      ############
      ############
      ############
      ############
                  
                  
      ############
                  
                                   
```

```shell
./gt30l32s4w -e read --font=16 --ch=字

                   ######                     
                     ###                     
   ##########################################
   #####################                  ###
########################               ######
         ####################################
                           ##################
                        #####################
                     ###                     
#############################################
                     ###                     
                     ###                     
                     ###                     
                     ###                     
               #########                     
                  ######  
```

```shell
./gt30l32s4w -e read --font=16 --ch=!


         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############

```

```shell
./gt30l32s4w -e read --font=24 --ch=字

                              ##################                        
                                 ###############                        
                                    ############                        
         ###############            ############            ############
         ###############################################################
      ##################                                    ############
      ##################                                 ###############
   #####################                        ########################
               #########################################################
                                             ###########################
                                          ######                        
                                 ###############                        
                                 ###############                        
                                 ###############            ############
   #####################################################################
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                                 ###############                        
                        ########################                        
                              ##################                        
                              ################## 
```

```shell
./gt30l32s4w -e read --font=24 --ch=!

                                     
                                    
                                    
         ###############            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
      ##################            
         ###############            
         ###############            
         ###############            
         ###############            
                                    
                                    
         ###############            
      ##################            
         ###############            
                                    
                                    
```

```shell
./gt30l32s4w -e read --font=32 --ch=字

                                       #########                                                
                                          ######                                                
                                          ##############################                        
            ############                     ###########################                        
            ############                     ###                                 ###############
            ####################################################################################
         ###############                                                         ###############
         ###############                                                      ##################
      ##################                                                   #####################
   #####################                                                                        
   #####################                                             ###                        
                  ##############################################################################
                                                               #################################
                                                            ############                        
                                             ###         ###############                        
                                             ###########################                        
                                             ###########################               #########
                                             ###########################            ############
################################################################################################
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                                             ###########################                        
                              ##########################################                        
                                       #################################                        
                                          ######                                                
                                          ###### 
```

```shell
./gt30l32s4w -e read --font=32 --ch=!

                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
      ##################                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
         ###############                        
                                                
                                                
                                                
         ###############                        
      ##################                        
      ##################                        
         ###############                        
                                                
                                                
     
```

```shell
./gt30l32s4w -e read --font=ascii-7 --ch=!

      #########
      #########
      #########
      #########
               
               
      #########
```

```shell
./gt30l32s4w -e read --font=ascii-8 --ch=!

      ###############
   ##################
   ##################
      ###############
      ###############
                     
      ###############                   
```

```shell
./gt30l32s4w -e read --font=ascii-12 --ch=! --type=times
            
            
            
   #########
   #########
   #########
   #########
   #########
   #########
   #########
            
   #########
```

```shell
./gt30l32s4w -e read --font=ascii-16 --ch=! --type=times
               
               
               
               
      #########
      #########
      #########
      #########
      #########
      #########
      #########
      #########
      #########
               
      #########
               
```

```shell
./gt30l32s4w -e read --font=ascii-24 --ch=! --type=times
                        
                        
                        
                        
                        
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
         ###############
                        
                        
         ###############
         ###############
                        
                        
```

```shell
./gt30l32s4w -e read --font=ascii-32 --ch=! --type=times
                                 
                                 
                                 
                                 
                                 
                                 
                                 
            ############         
            ############         
            ############         
            ############         
            ############         
            ############         
            ############         
            ############         
            ############         
               #########         
               #########         
               #########         
               #########         
               #########         
               #########         
                                 
                                 
                                 
            ############         
            ############         
            ############         
                                 
                                 
```

```shell
./gt30l32s4w -h

Usage:
  gt30l32s4w (-i | --information)
  gt30l32s4w (-h | --help)
  gt30l32s4w (-p | --port)
  gt30l32s4w (-t read | --test=read)
  gt30l32s4w (-e read | --example=read) [--font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>]
             [--ch=<char>] [--type=<arial | times>]

Options:
      --ch=<char>                Set the display char, char is the display char.([default: A])
  -e <read>, --example=<read>    Run the driver example.
      --font=<12 | 16 | 24 | 32 | ascii-7 | ascii-8 | ascii-12 | ascii-16 | ascii-24 | ascii-32>
                                 Set display font.([default: 32])
  -h, --help                     Show the help.
  -i, --information              Show the chip information.
  -p, --port                     Display the pin connections of the current board.
  -t <read>, --test=<read>       Run the driver test.
      --type=<arial | times>     Set font type.([default: arial])
```
