'use strict';
'require view';
'require form';
'require uci';

return view.extend({
    render: function () {
        var m, s, o, ro, as;

        m = new form.Map('chirpstack-mqtt-forwarder', _('ChirpStack MQTT Forwarder'), _('ChirpStack MQTT Forwarder forwards data received by the ChirpStack Concentratord to a MQTT broker.'));
        m.tabbed = true;

        s = m.section(form.TypedSection, 'mqtt', _('MQTT configuration'));
        s.anonymous = true;

        // topic prefix
        o = s.option(form.Value, 'topic_prefix', _('Topic prefix'), _('Specify the topic you want to use (e.g. \'eu868\'), without trailing slash.'));
        o.optional = true;
        o.validate = function (section_id, value) {
            if (value.match(/^[a-zA-Z0-9\_\-\/\$]*$/)) {
                return true;
            }

            return "Enter a valid MQTT prefix.";
        };

        // json encoding
        s.option(form.Flag, 'json', _('Use JSON'), _('Use JSON encoding instead of Protobuf (binary). Use this only for debugging purposes.'));

        // server
        o = s.option(form.Value, 'server', _('Server'), _('MQTT server (e.g. scheme://host:port where scheme is tcp, ssl, ws, wss).'));
        o.validate = function (section_id, value) {
            if (value.match(/^(tcp|ssl|ws|wss):\/\/[\w\.\-]+:[\d]+$/)) {
                return true;
            }

            return "Enter a valid MQTT server address.";
        };

        // username
        o = s.option(form.Value, 'username', _('Username'), _('Connect with the given username.'));
        o.optional = true;

        // password
        o = s.option(form.Value, 'password', _('Password'), _('Connect with the given password.'))
        o.optional = true;
        o.password = true;

        // ca certificate
        o = s.option(form.TextValue, 'ca_cert', _('CA certificate'));
        o.optional = true;
        o.cols = 80;

        // tls cert
        o = s.option(form.TextValue, 'tls_cert', _('TLS certificate'));
        o.optional = true;
        o.cols = 80;

        o = s.option(form.TextValue, 'tls_key', _('TLS key-file'));
        o.optional = true;
        o.cols = 80;

        // QoS
        o = s.option(form.ListValue, 'qos', _('QoS'), _('Note: an increase of this value will decrease the performance.'));
        o.value(0, 0);
        o.value(1, 1);
        o.value(2, 2);

        // clean session
        s.option(form.Flag, 'clean_session', _('Clean session'), _('By setting this flag you are indicating that no messages saved by the broker for this client should be delivered.'));

        // client id
        o = s.option(form.Value, 'client_id', _('Client ID'), _('A client id must be no longer than 23 characters. If left blank, a random id will be generated by ChirpStack.'));
        o.optional = true;
        o.validate = function (section_id, value) {
            if (value.match(/^[a-zA-Z0-9]{0,23}$/)) {
                return true;
            }

            return "Enter a valid Client ID";
        };

        return m.render();
    }
});