# Alfred Workflows [![Lists](https://img.shields.io/badge/-more%20lists-0a0a0a.svg?style=flat&colorA=0a0a0a)](https://github.com/learn-anything/curated-lists)

_Please read [contribution guidelines](contributing.md) before contributing._

- [Collections](#collections)
- [Design](#design)
- [Developer](#developer)
- [Documentation](#documentation)
- [Learn](#learn)
- [Fun](#fun)
- [Libraries](#libraries)
- [macOS](#macos)
- [Music](#music)
- [Productivity](#productivity)
- [Remote](#remote)
- [Social](#social)
- [Translation](#translation)
- [Travel](#travel)
- [Utility](#utility)
- [Web](#web)
- [Writing](#writing)
- [Meta](#meta)
- [Related](#related)

## Collections

- [Small Workflows by Nikita](https://github.com/nikitavoloboev/small-workflows)
- [Vitor's Workflows](https://github.com/vitorgalvao/alfred-workflows)
- [Collection of Alfred workflows](https://github.com/msoedov/Alfred-collection)
- [Robb Knight's workflows](https://github.com/rknightuk/alfred-workflows)
- [Alfred Workflows (Rust)](https://github.com/rust-playground/alfred-workflows-rs)

## Design

- [Flat UI Colors](https://github.com/mi-ca/alfredapp_flatuicolors_workflow) - Get flat color hexa codes from [flatuicolors.com](https://flatuicolors.com).
- [Material Design Icons](https://github.com/importre/alfred-mdi) - Find [Material Design Icons](https://github.com/google/material-design-icons).

## Developer

- [AWS Console Services](https://github.com/rkoval/alfred-aws-console-services-workflow) - Search AWS console Services.
- [Can I use?](https://github.com/willfarrell/alfred-caniuse-workflow) - Search [can I use](https://caniuse.com) website.
- [CircleCI](https://github.com/lorentzca/alfred-circleci-workflow/) - Show [CircleCI](https://circleci.com/) Build Statuses.
- [Dash](https://github.com/Kapeli/Dash-Alfred-Workflow) - Search though any [Dash](https://kapeli.com/dash) docset that you have downloaded.
- [Devdocs](https://github.com/yannickglt/alfred-devdocs) - Search through [devdocs.io](http://devdocs.io/)
- [DNS Lookups](https://github.com/phallstrom/AlfredDig) - Perform DNS lookups using dig and optionally copy a specific result to the clipboard.
- [Docker](https://github.com/anmolnagpal/alfred-docker-workflows) - Search/Stop/Remove docker containers.
- [Errnum](https://github.com/deanishe/alfred-errnum) - Search macOS errors.
- [Git Ignore Templates](https://github.com/importre/alfred-gi) - Find `*.gitignore files`.
- [GitHub Gists](https://github.com/danielecook/gist-alfred) - Search through GitHub gists
- [GitHub Integration](https://github.com/gharlan/alfred-github-workflow) - Fully featured workflow to inteact with GitHub.
- [GitHub Jump](https://github.com/lox/alfred-github-jump) - Search your and your GitHub starred repositories.
- [GitHub Repo Search](https://github.com/anoff/alfred-github) - Find projects on GitHub.
- [HTTP Status Codes](https://github.com/ilstar/http_status_code) - Check out HTTP status code quickly.
- [Httpstat](https://github.com/leozhang2018/alfred-httpstat) - Httpstat visualizes.
- [Hoogle](https://github.com/meck/alfred-hoogle) - Search [Hoogle](https://hoogle.haskell.org/).
- [iTerm TTY switch](https://github.com/isometry/alfred-tty) - Quickly switch between or close iTerm windows, tabs and panes based on title and tty name.
- [Network Tools](https://github.com/fniephaus/alfred-network) - Collection of some useful network commands.
- [Npms](https://github.com/sindresorhus/alfred-npms) - Search for npm packages with [npms.io](https://npms.io).
- [React Launcher](https://github.com/winkerVSbecks/alfred-react-launcher) - Access the React & React Native Documentation.
- [Open in Jetbrains](https://github.com/bchatard/alfred-jetbrains) - Open project with one of JetBrains' product.
- [Package managers](https://github.com/willfarrell/alfred-pkgman-workflow) - Quick package/plugin/component (repo) lookup for your favourite package managers.
- [Pipe](https://github.com/isometry/alfred-pipe) - Easy transformation of the current contents of the clipboard by piping through arbitrary shell one-liners.
- [Pod Search](https://github.com/BenchR267/Pod-Search-Alfred) - Search through [Cocoapods](htts://cocoapods.org).
- [Repos](https://github.com/deanishe/alfred-repos) - Browse, search and open Git repositories.
- [Secure SHell](https://github.com/deanishe/alfred-ssh) - Open SSH/SFTP/mosh connections.
- [SemaphoreCI](https://github.com/renuo/semaphoreci-workflow) - Show [SemaphoreCI](https://semaphoreci.com/renuo) build statuses.
- [Shell Variables](https://github.com/hug33k/Alfred-ShellVariables) - Search your shell's variables.
- [SnippetsLab](https://www.renfei.org/snippets-lab/manual/mac/tips-and-tricks/alfred-integration.html) - Search through [SnippetsLab](https://www.renfei.org/snippets-lab/) app.
- [Stack Overflow](https://github.com/deanishe/alfred-stackoverflow) - Search [StackOverflow.com](https://stackoveflow.com).
- [Swift Evolution](https://github.com/attaswift/alfred-swift-evolution) - Look up Swift evolution proposals.
- [TLDR](https://github.com/cs1707/tldr-alfred) - Search [TLDR](https://github.com/tldr-pages/tldr) pages
- [Tower](https://github.com/cjlucas/tower-alfred-workflow) - Search/Open Tower git repositories.
- [Transmit](https://github.com/bigluck/alfred2-transmit) - Open Transmit Bookmarks.
- [Travis](https://github.com/fniephaus/alfred-travis-ci) - Quickly check build statuses on [Travis](https://travis-ci.org).
- [VM Control](https://github.com/fniephaus/alfred-vmcontrol) - Control your Parallels and Virtual Box virtual machines.
- [GCP shortcuts](https://github.com/jarlefosen/alfred-gcloud-shortcuts) - Shortcuts for opening Google Cloud Platform products in the browser.
- [Rustdoc](https://github.com/fanzeyi/alfred-rustdoc) - Uses rustdoc's search index to provide local search result.
- [alfred-crates](https://github.com/FGRibreau/alfred-crates) - Workflow for searching Rust crates.
- [String Operations](https://github.com/fatih-yavuz/alfred-string-operations) - Perform string manipulation to the clipboard content.
- [alfred-fkill](https://github.com/SamVerschueren/alfred-fkill) - Fabulously search and kill processes.

## Documentation

- [D2](https://github.com/nire0510/d2) - Quick access to popular libraries, framewoks & tools online developer documentation.
- [Elasticsearch Documentation](https://github.com/spinscale/alfred-workflow-elastic-docs) - Search Elasticsearch documentation.
- [MDN search](https://github.com/klaascuvelier/alfred-mdn) - Search MDN documentation.
- [React Launcher](https://github.com/winkerVSbecks/alfred-react-launcher) - Access the React & React Native documentation and community links.
- [Flutter Documentation](https://github.com/Sh1d0w/alfred-flutter-docs) - Search Flutter documentation.

## Learn

- [Goodreads](https://github.com/deanishe/alfred-goodreads) - Search [Goodreads](https://www.goodreads.com) for books.
- [LeetCode Search](https://github.com/TooSchoolForCool/LeetCode-Search) - Search algorithm problems in [LeetCode](https://leetcode.com/) with custom options.
- [Papers 3](https://github.com/wookayin/alfred-papers3-workflow) - Search Papers3 items.
- [Wolfram Alpha Suggest](https://github.com/AkikoZ/alfred-web-search-suggest#wolframalpha) - Supports direct term suggestions.

## Fun

- [Birthday](https://github.com/nikitavoloboev/small-workflows/tree/master/birthday) - Showcase how much time passed since your birthday.
- [Dongers](https://github.com/frdmn/alfred-dongers) - List unicode emoticons easily.
- [Figlet](https://github.com/importre/alfred-figlet) - Asciify plain text using [figlet.js](https://github.com/patorjk/figlet.js)

## Libraries

- [Alfred Footman](https://github.com/meck/alfred-footman) - Write workflows in Haskell
- [Alfred Workflow](https://github.com/deanishe/alfred-workflow) - Write workflows in Python.
- [Alfy](https://github.com/sindresorhus/alfy) - Write workflows in Node.js.
- [AwGo](https://github.com/deanishe/awgo) - Write workflows in Go.
- [Alfred Rust](https://github.com/lilyball/alfred-rs)
- [Alfred Rust 2](https://github.com/spamwax/alfred-workflow)

## macOS

- [DarkOrLight](https://github.com/BaksiLi/AlfredWorkflows/tree/master/Index/DarkOrLight) - Change macOS theme to Dark/Light with one click.
- [macOS App Search](https://github.com/nkcmr/alfred-apple-app-search) - Search macOS app store.
- [NightShift](https://github.com/shmulvad/alfred-nightshift) - Quickly turn on/off Night Shift or set the warm strength to a custom value.

## Music

- [Discogs Explorer](https://github.com/dotson/Discogs-Explorer) - Explore the [Discogs.com](https://www.discogs.com) database.
- [MPD](https://github.com/deanishe/alfred-mpd) - Control MPD music player.
- [Play Song](https://github.com/caleb531/play-song) - Quickly and easily play music in iTunes.
- [Spotify Mini Player](https://github.com/vdesabou/alfred-spotify-mini-player) - Fully control Spotify.

## Productivity

- [Awesome Lists](https://github.com/nikitavoloboev/alfred-awesome-lists) - Browse all awesome lists in seconds inside Alfred.
- [Firefox Assistant](https://github.com/deanishe/alfred-firefox) - Search and control Firefox from Alfred.
- [Chromium Assistant](https://github.com/jopemachine/alfred-chromium-workflow) - Search and control Chromium based browsers from Alfred.
- [Drive](https://github.com/azai91/alfred-drive-workflow)- Search Google Drive.
- [EggTimer](https://www.alfredforum.com/topic/275-eggtimer-v2-updated-to-20-final/) - Quickly set timers to notify you of things.
- [Fast Menu Bar Search](https://github.com/ascandroli/menudump/releases/download/1.8.0/Menu.Bar.Search-v1_8.alfredworkflow) - Search through currently active app's menu bar actions quickly.
- [Hastebin](https://github.com/jvandyke/alfred-hastebin) - Create [Hastebin](https://hastebin.com) snippet from selected text.
- [Join Zoom Meeting](https://github.com/aurooba/alfred-workflow-zoom-meetings) - Join Zoom meetings easily without a new tab opening in your browser.
- [Keyboard Maestro](https://github.com/iansinnott/alfred-maestro) - Search through [Keyboard Maestro](https://www.keyboardmaestro.com/main/) macros.
- [Learn Anything](https://github.com/nikitavoloboev/alfred-learn-anything) - Search [Learn Anything](https://learn-anything.xyz/) Website.
- [Machine Clean](http://www.packal.org/workflow/machineclean) - Freeze keyboard input for some time to clean your keyboard.
- [MailTo](https://github.com/deanishe/alfred-mailto) - Search through your contact list to send emails to one or multiple people.
- [My Mind](https://github.com/nikitavoloboev/alfred-my-mind) - Search through bookmarks, notes and various websites quickly.
- [Apple Notes](https://github.com/surrealroad/alfred-notes) - Make new notes or search notes from macOS Notes app.
- [Pocket](https://github.com/fniephaus/alfred-pocket) - Manage your Pocket list.
- [Recent Downloads](https://github.com/ddjfreedom/recent-downloads-alfred-v2) - Browse through your Downloads directory or any other directory you specify.
- [Safari Assistant](https://github.com/deanishe/alfred-safari-assistant) - Search through your Safari history, bookmarks, reading list.
- [Searchio](https://github.com/deanishe/alfred-searchio) - Auto-suggest search results from multiple search engines and languages.
- [Taskpaper](https://github.com/robwalton/alfred-taskpaper-workflow) - Search and create tasks in [TaskPaper 3](https://www.taskpaper.com/).
- [Timezone](https://github.com/lox/alfred-timezone) - Quickly search through cities and timezones to find out what time it is in different places.
- [TinyPNG](https://github.com/shmulvad/alfred-tinypng) - Compress PNG and JPG images using TinyPNG in Alfred.
- [Toggl](https://github.com/jason0x43/alfred-toggl) - Operate [Toggl](https://toggl.com).
- [Uninstall with Clean my Mac 3](http://www.packal.org/workflow/uninstall-cleanmymac-3) - Uninstall applications quickly using [Clean my Mac](https://macpaw.com/cleanmymac).
- [Weather](https://github.com/jason0x43/alfred-weather) - Get latest weather for the day, week.
- [Web Searches](https://github.com/nikitavoloboev/alfred-web-searches) - Search through any website on the web.
- [Say-workflow](https://github.com/BaksiLi/AlfredWorkflows/tree/master/Index/say-workflow) - Read out something swiftly, a good reference for pronunciation.
- [iMessage 2FA](https://github.com/squatto/alfred-imessage-2fa) - Find two-factor authentication codes in your recent iMessage messages.
- [Things](https://github.com/xilopaint/alfred-things) - Interact with Things 3 using Alfred.
- [Todoist](https://github.com/moranje/alfred-workflow-todoist) - Manage Todoist tasks with Alfred.
- [Hue Timer](https://github.com/fatih-yavuz/alfred-timer-workflow) - Start a timer, which blinks the lights when the time is up.
- [Mailsy](https://github.com/BalliAsghar/mailsy-alfred) - Quickly generate a disposable email.

## Remote

- [Keynote Remote](https://github.com/gabamnml/Keynote-remote)
- [Unlock Your Mac](https://github.com/gabamnml/unlock-your-mac)

## Social

- [Telegram](https://github.com/Jamesits/alfred-workflow-telegram) - Search for stickers and quickly operate Telegram.

## Translation

- [Google Translate](http://www.packal.org/workflow/translate) - Utilize any of Google Translate's languages and see results for multiple languages.
- [Linguee](https://github.com/alexander-heimbuch/linguee-alfred-workflow) - Translate German-English and vice versa with [linguee.de](https://www.linguee.de)
- [Polyglot](https://github.com/nikersify/alfred-polyglot) - Translate text using Google Translate.
- [Translate ger-en en-ger + 8 others](https://github.com/dennis-tra/alfred-dict.cc-workflow) - Quickly translate from German > English and vice versa + 8 other languages.
- [Translate ru-en en-ru](https://github.com/podgorniy/alfred-translate) - Quickly translate from Russion > English and vice versa.
- [Convert en-ko](https://github.com/738/alfred-inko) - Convert misspelled English characters into Korean letters (& vice versa)

## Travel

- [Airports](https://github.com/jeeftor/alfredAirports) - Search for Airports from the [Our Airports](http://ourairports.com/data/) data set.

## Utility

- [About This Mac](https://www.alfredforum.com/topic/2025-about-this-mac/) - Shows "about this mac" info.
- [AbuseIPDB](https://github.com/slunak/abuseipdb-alfred-workflow) - Query IP address against [AbuseIPDB](https://www.abuseipdb.com/) database.
- [Search Notes App](https://github.com/sballin/alfred-search-notes-app) - Use Alfred to quickly open notes in iCloud/Apple Notes.
- [AirPlay Mirroring On/Off](https://www.alfredforum.com/topic/2292-airplay-mirroring-onoff/) - Activate and deactivate AirPlay Mirroring from Mac to Apple TV.
- [Airport Searching](https://github.com/jeeftor/alfredAirports) - Search for Airports from the [Our Airports](http://ourairports.com/data/) data set.
- [Audio Device](https://github.com/mikegrb/Alfred-Audio-Device) - Audio Device Input / Output Switching
- [Battery](https://github.com/BenziAhamed/alfred-battery) - Display battery levels of your Apple devices.
- [Currency Conversion](https://github.com/jeppestaerk/alfred-currency-conversion) - See foreign exchange rates and currency conversion.
- [Brightness](https://github.com/fniephaus/alfred-brightness) - Adjust your display's brightness.
- [Cheatsheet](https://github.com/mutdmour/alfred-workflow-cheatsheet) - Gets keyboard shortcuts for applications, websites, and tools...
- [Convert](https://github.com/deanishe/alfred-convert) - Convert between different units.
- [Copy Safari Tabs](https://www.alfredforum.com/topic/9093-copy-safari-tabs/) - Copies all open Safari tabs as markdown list into clipboard.
- [Crypto Tracker](https://github.com/rhlsthrm/alfred-crypto-tracker) - Quickly check cryptocurrency prices.
- [Currency Convert](https://github.com/jin5354/alfred3-workflow-CurrencyConvert) - Convert currency conveniently.
- [Date calculator](https://github.com/LeEnno/alfred-date-calculator) - Display or calculate with current date and time.
- [Display calendar](https://github.com/owenwater/alfred-cal) - Displays a monthly calendar.
- [DownVid](https://www.alfredforum.com/topic/2045-downvid-%E2%80%94-download-videos-from-popular-sources/) - Download videos from a [plethora of video sources](https://rg3.github.io/youtube-dl/supportedsites.html), even when embedded to other pages.
- [Emoji Search](https://github.com/jsumners/alfred-emoji) - Search and copy emojis.
- [Encode/Decode](https://github.com/willfarrell/alfred-encode-decode-workflow) - Encoding and decoding a sting into multiple variations.
- [Fakeum](https://github.com/deanishe/alfred-fakeum) - Generate fake test data.
- [File Creator](https://github.com/SteliosHa/Alfred_File_Creator) - Create files of certain types quickly.
- [Flush](https://github.com/joshtronic/alfred-workflow-flush) - Flush DNS/Memcached.
- [Folder2ISO](https://github.com/josefglatz/folder2iso-alfredworkflow) - Makes an image file for each selected folder in OS X Finder.
- [Font Awesome](https://github.com/ruedap/alfred-font-awesome-workflow) - Search for [Font Awesome](http://fontawesome.io/icons/) icons.
- [Get App Icon](https://www.alfredforum.com/topic/5874-16-get-app-icon/) - Extracts icon from selected app or downloads from App store/mac app store.
- [Google Calendar](https://github.com/deanishe/alfred-gcal) - View Google Calendar events.
- [Google Similar Images](https://github.com/deanishe/alfred-similar-image-search) - Make Google image searches on localfiles.
- [Haskell Text Converter](http://www.packal.org/workflow/haskell-text-converter) - Converts text to different type and does line numbering .
- [Hide Desktop](http://www.packal.org/workflow/hide-desktop) - Hide and Unhide Desktop.
- [IMDB](https://github.com/KevinRamsunder/alfred3-imdb-workflow) - Search IMDB.
- [JSON Beautifier In FeHelper](https://github.com/hanjm/alfred-json-beautifier-in-fehelper-workflow) - View clipboard/input JSON in FeHelper.
- [Karabiner Elements Profile Switcher](https://github.com/awinecki/karabiner-elements-profile-switcher) - Handy profile switcher for Karabiner Elements.
- [KPass](https://github.com/Angoll/KPass) - KeePassXC Integration to retrieve passwords.
- [Layout](https://github.com/untoldwind/alfred2-layout) - Powerful window manager with many options (Looking for new owner/maintainer)
- [Lorem Ipsum](https://github.com/tillkruss/alfred-lorem-ipsum) - Create ultra-fast Lorem Ipsum text.
- [Mac App Store Search](http://www.packal.org/workflow/mac-app-store-search) - Search the Mac App Store.
- [Mac Window Layout Tiles](https://github.com/jknight/MacWindowLayoutTiles) - Keyboard shortcuts to position and size windows
- [Monitor Resolutions](https://github.com/taylorludwig/Resolutions-Alfred) - Change resolutions on primary monitor.
- [Network Locations](https://github.com/deanishe/alfred-network-location) - List, filter and activate network locations.
- [Number System Converter](https://github.com/obstschale/NSC) - Convert numbers into other number systems.
- [Open Windows](https://github.com/jnewland/alfred-open-windows) - Switch between open windows of the currently focused application.
- [PDF Tools](https://github.com/xilopaint/alfred-pdf-tools) - Optimize, encrypt and manipulate PDF files.
- [Pinboard search](https://github.com/spamwax/alfred-pinboard-rs) - Manage, post and preview your bookmarks on [Pinboard](https://pinboard.in/).
- [Process Control](https://github.com/vitorgalvao/alfred-workflows/tree/master/ProcessControl) - Search through currently active processes and kill ones that are misbehaving quickly.
- [Pwgen](https://github.com/deanishe/alfred-pwgen) - Generate secure passwords.
- [QR code creator](https://github.com/wensonsmith/QRcodeCreator) - Create QR code from tex.
- [Rsync Folders](https://github.com/Acidham/rsync-folders) - Keep a set of folders in sync with their target folders via rsync.
- [RunCommand](https://github.com/vitorgalvao/alfred-workflows/tree/master/RunCommand) - Run shell commands on selected files/directories.
- [Screensharing](https://github.com/pstadler/alfred-screensharing) - Hosts with Screen Sharing enabled will be automatically discovered.
- [Shhhhh!](https://github.com/skotzko/shhhhh) - Close all open system alerts (iCal, etc) without touching the mouse.
- [Show network info](https://github.com/jeppestaerk/alfred-show-network-info) - Get your network information.
- [Speak](https://github.com/mklement0/speak.awf) - Use OS X's TTS (text-to-speech) feature to speak text aloud.
- [Bluetooth Controller](https://github.com/vegardinho/alfred_bluetooth_controller) - Manage bluetooth settings and connections.
- [Bluetooth Switch](https://github.com/uchida/alfred-switch-bluetooth) - Quickly connect / disconnect Bluetooth devices.
- [Syntax highlight code](https://github.com/importre/alfred-hl) - Highlight code in the clipboard using [highlight.js](https://highlightjs.org/).
- [Tidy](https://github.com/importre/alfred-tidy) - Beautify JSON/XML in clipboard.
- [Time Machine](http://www.packal.org/workflow/time-machine) - Inspect and control Time Machine.
- [TimeZones](http://geekzone.philosophicalzombie.net/post/45823505821/alfred-workflow-timezones-a-customizable-world) - Displays a customised world clock.
- [Toggle Hidden Files](http://www.packal.org/workflow/toggle-hidden-files) - Show and hide hidden system files in Finder with one click.
- [Top Process](https://github.com/zhaocai/alfred2-top-workflow) - Can find Top Processes Based Memory, CPU, and IO Usage and get a glance of system status.
- [Unicode Symbols Search](https://github.com/bevesce/unicode-symbols-search) - Quickly search through all Unicode symbols.
- [Units](http://units.dnsu.ch) - Do quick unit conversions.
- [Upload Files](https://www.alfredforum.com/topic/5233-uploadfile-—-upload-files-and-directories-for-easy-sharing/) - Quickly upload local files to share with [transfer.sh](https://transfer.sh).
- [UUID generator](http://www.packal.org/workflow/uuid-generator-0) - Generates random UUID and copy to clipboard or paste to most front app.
- [Various Screenshots](https://github.com/vookimedlo/alfred-various-screenshots) - Taking various screenshots.
- [Viscosity](https://github.com/deanishe/alfred-viscosity) - Manage Viscosity VPN connections.
- [WatchList](https://github.com/vitorgalvao/alfred-workflows/tree/master/WatchList) - Play and manage local audiovisual content and streams.
- [WebScreenshot](https://github.com/vitorgalvao/alfred-workflows/tree/master/WebScreenshot) - Take screenshots with a keyboard shortcut and upload them directly to [Imgur](https://imgur.com/).
- [Workflow Directory Search](https://github.com/jeeftor/AlfredWorkflowDirectory) - Quckly open any Alfred Workflow directory in your Terminal, Finder.
- [Notion Search](https://github.com/wrjlewis/notion-search-alfred-workflow) - Alfred workflow to search Notion with instant results.
- [Swift Windows Switcher](https://github.com/mandrigin/AlfredSwitchWindows) - Enumerate and switch between windows on macOS.
- [Video Conferences](https://www.deanishe.net/post/2020/05/workflow-video-conferences/) - Shows upcoming calendar events that are video conferences, and opens the links to them.

## Web

- [HackerBoard](https://github.com/vitorgalvao/alfred-workflows/tree/master/HackerBoard) - Front page news from Hacker News and Pinboard.
- [Product Hunt](https://github.com/loris/alfred-producthunt-workflow) - Get today's hunts from [Product Hunt](https://www.producthunt.com/).
- [Reddit search](https://github.com/deanishe/alfred-reddit) - Find subreddits and browse hot posts from [Reddit](http://reddit.com).

## Writing

- [LaTeX Symbols](https://github.com/wookayin/alfred-latex-symbols-workflow) - Find LaTeX commands for symbols.
- [SynArt](https://github.com/vitorgalvao/alfred-workflows/tree/master/SynAnt) - Search for synonyms and antonms.
- [Bear](https://github.com/drgrib/alfred-bear) - Streamlined note searching and creation for Bear using Alfred.
- [Ulysses](https://github.com/robwalton/alfred-ulysses-workflow) - Search for sheets or groups from [Ulysses](https://ulyssesapp.com/).

## Meta

- [Search Alfred Workflows](https://github.com/Acidham/search-alfred-workflows) - Alfred Workflows help to search in Title, Keyword, Description of a workflow and open it in various actions.
- [Alfred Keywords](https://github.com/pochemuto/alfred-help-workflow) - Search through Alfred workflow keywords.

## Related

- [Pacmax](https://pacmax.org/) - Explore & Share Great Alfred Packages.
- [Packal](http://www.packal.org/) - Repository of user submitted workflows and themes (unmaintained).
- [Alfred Workflows](https://github.com/zenorocha/alfred-workflows)
- [Awesome Alfred Workflows](https://github.com/derimagia/awesome-alfred-workflows)
- [Awesome Alfred Workflows 2](https://github.com/alfred-workflows/awesome-alfred-workflows)

## GitHub badge

If you have made a workflow of your own and published it on GitHub, it would be awesome if you added a badge to your workflow that links to this list.

[![Workflows](https://img.shields.io/badge/-more%20workflows-0a0a0a.svg?style=flat&colorA=0a0a0a)](https://github.com/learn-anything/alfred-workflows)

`[![Workflows](https://img.shields.io/badge/-more%20workflows-0a0a0a.svg?style=flat&colorA=0a0a0a)](https://github.com/learn-anything/alfred-workflows)`

[![CC4](https://img.shields.io/badge/license-CC4-0a0a0a.svg?style=flat&colorA=0a0a0a)](https://creativecommons.org/licenses/by/4.0/)
[![Lists](https://img.shields.io/badge/-more%20lists-0a0a0a.svg?style=flat&colorA=0a0a0a)](https://github.com/learn-anything/curated-lists)
[![Contribute](https://img.shields.io/badge/-contribute-0a0a0a.svg?style=flat&colorA=0a0a0a)](contributing.md)
[![Twitter](http://bit.ly/latwitt)](https://twitter.com/learnanything_)
