
/***********************************/
/*http://www.layabox.com  2017/3/23*/
/***********************************/
var Laya=window.Laya=(function(window,document){
	var Laya={
		__internals:[],
		__packages:{},
		__classmap:{'Object':Object,'Function':Function,'Array':Array,'String':String},
		__sysClass:{'object':'Object','array':'Array','string':'String','dictionary':'Dictionary'},
		__propun:{writable: true,enumerable: false,configurable: true},
		__presubstr:String.prototype.substr,
		__substr:function(ofs,sz){return arguments.length==1?Laya.__presubstr.call(this,ofs):Laya.__presubstr.call(this,ofs,sz>0?sz:(this.length+sz));},
		__init:function(_classs){_classs.forEach(function(o){o.__init$ && o.__init$();});},
		__isClass:function(o){return o && (o.__isclass || o==Object || o==String || o==Array);},
		__newvec:function(sz,value){
			var d=[];
			d.length=sz;
			for(var i=0;i<sz;i++) d[i]=value;
			return d;
		},
		__extend:function(d,b){
			for (var p in b){
				if (!b.hasOwnProperty(p)) continue;
				var gs=Object.getOwnPropertyDescriptor(b, p);
				var g = gs.get, s = gs.set; 
				if ( g || s ) {
					if ( g && s)
						Object.defineProperty(d,p,gs);
					else{
						g && Object.defineProperty(d, p, g);
						s && Object.defineProperty(d, p, s);
					}
				}
				else d[p] = b[p];
			}
			function __() { Laya.un(this,'constructor',d); }__.prototype=b.prototype;d.prototype=new __();Laya.un(d.prototype,'__imps',Laya.__copy({},b.prototype.__imps));
		},
		__copy:function(dec,src){
			if(!src) return null;
			dec=dec||{};
			for(var i in src) dec[i]=src[i];
			return dec;
		},
		__package:function(name,o){
			if(Laya.__packages[name]) return;
			Laya.__packages[name]=true;
			var p=window,strs=name.split('.');
			if(strs.length>1){
				for(var i=0,sz=strs.length-1;i<sz;i++){
					var c=p[strs[i]];
					p=c?c:(p[strs[i]]={});
				}
			}
			p[strs[strs.length-1]] || (p[strs[strs.length-1]]=o||{});
		},
		__hasOwnProperty:function(name,o){
			o=o ||this;
		    function classHas(name,o){
				if(Object.hasOwnProperty.call(o.prototype,name)) return true;
				var s=o.prototype.__super;
				return s==null?null:classHas(name,s);
			}
			return (Object.hasOwnProperty.call(o,name)) || classHas(name,o.__class);
		},
		__typeof:function(o,value){
			if(!o || !value) return false;
			if(value===String) return (typeof o==='string');
			if(value===Number) return (typeof o==='number');
			if(value.__interface__) value=value.__interface__;
			else if(typeof value!='string')  return (o instanceof value);
			return (o.__imps && o.__imps[value]) || (o.__class==value);
		},
		__as:function(value,type){
			return (this.__typeof(value,type))?value:null;
		},		
		interface:function(name,_super){
			Laya.__package(name,{});
			var ins=Laya.__internals;
			var a=ins[name]=ins[name] || {self:name};
			if(_super)
			{
				var supers=_super.split(',');
				a.extend=[];
				for(var i=0;i<supers.length;i++){
					var nm=supers[i];
					ins[nm]=ins[nm] || {self:nm};
					a.extend.push(ins[nm]);
				}
			}
			var o=window,words=name.split('.');
			for(var i=0;i<words.length-1;i++) o=o[words[i]];
			o[words[words.length-1]]={__interface__:name};
		},
		class:function(o,fullName,_super,miniName){
			_super && Laya.__extend(o,_super);
			if(fullName){
				Laya.__package(fullName,o);
				Laya.__classmap[fullName]=o;
				if(fullName.indexOf('.')>0){
					if(fullName.indexOf('laya.')==0){
						var paths=fullName.split('.');
						miniName=miniName || paths[paths.length-1];
						if(Laya[miniName]) console.log("Warning!,this class["+miniName+"] already exist:",Laya[miniName]);
						Laya[miniName]=o;
					}
				}
				else {
					if(fullName=="Main")
						window.Main=o;
					else{
						if(Laya[fullName]){
							console.log("Error!,this class["+fullName+"] already exist:",Laya[fullName]);
						}
						Laya[fullName]=o;
					}
				}
			}
			var un=Laya.un,p=o.prototype;
			un(p,'hasOwnProperty',Laya.__hasOwnProperty);
			un(p,'__class',o);
			un(p,'__super',_super);
			un(p,'__className',fullName);
			un(o,'__super',_super);
			un(o,'__className',fullName);
			un(o,'__isclass',true);
			un(o,'super',function(o){this.__super.call(o);});
		},
		imps:function(dec,src){
			if(!src) return null;
			var d=dec.__imps|| Laya.un(dec,'__imps',{});
			function __(name){
				var c,exs;
				if(! (c=Laya.__internals[name]) ) return;
				d[name]=true;
				if(!(exs=c.extend)) return;
				for(var i=0;i<exs.length;i++){
					__(exs[i].self);
				}
			}
			for(var i in src) __(i);
		},
        superSet:function(clas,o,prop,value){
            var fun = clas.prototype["_$set_"+prop];
            fun && fun.call(o,value);
        },
        superGet:function(clas,o,prop){
            var fun = clas.prototype["_$get_"+prop];
           	return fun?fun.call(o):null;
        },
		getset:function(isStatic,o,name,getfn,setfn){
			if(!isStatic){
				getfn && Laya.un(o,'_$get_'+name,getfn);
				setfn && Laya.un(o,'_$set_'+name,setfn);
			}
			else{
				getfn && (o['_$GET_'+name]=getfn);
				setfn && (o['_$SET_'+name]=setfn);
			}
			if(getfn && setfn) 
				Object.defineProperty(o,name,{get:getfn,set:setfn,enumerable:false});
			else{
				getfn && Object.defineProperty(o,name,{get:getfn,enumerable:false});
				setfn && Object.defineProperty(o,name,{set:setfn,enumerable:false});
			}
		},
		static:function(_class,def){
				for(var i=0,sz=def.length;i<sz;i+=2){
					if(def[i]=='length') 
						_class.length=def[i+1].call(_class);
					else{
						function tmp(){
							var name=def[i];
							var getfn=def[i+1];
							Object.defineProperty(_class,name,{
								get:function(){delete this[name];return this[name]=getfn.call(this);},
								set:function(v){delete this[name];this[name]=v;},enumerable: true,configurable: true});
						}
						tmp();
					}
				}
		},		
		un:function(obj,name,value){
			value || (value=obj[name]);
			Laya.__propun.value=value;
			Object.defineProperty(obj, name, Laya.__propun);
			return value;
		},
		uns:function(obj,names){
			names.forEach(function(o){Laya.un(obj,o)});
		}
	};

    window.console=window.console || ({log:function(){}});
	window.trace=window.console.log;
	Error.prototype.throwError=function(){throw arguments;};
	//String.prototype.substr=Laya.__substr;
	Object.defineProperty(Array.prototype,'fixed',{enumerable: false});

	return Laya;
})(window,document);

(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;
Laya.interface('laya.ui.IItem');
Laya.interface('laya.d3.core.IClone');
Laya.interface('laya.runtime.IMarket');
Laya.interface('laya.filters.IFilter');
Laya.interface('laya.display.ILayout');
Laya.interface('laya.resource.IDispose');
Laya.interface('laya.resource.IDestroy');
Laya.interface('laya.runtime.IConchNode');
Laya.interface('laya.webgl.shapes.IShape');
Laya.interface('laya.d3.graphics.IVertex');
Laya.interface('laya.webgl.submit.ISubmit');
Laya.interface('laya.filters.IFilterAction');
Laya.interface('laya.d3.core.scene.ITreeNode');
Laya.interface('laya.webgl.text.ICharSegment');
Laya.interface('laya.runtime.ICPlatformClass');
Laya.interface('laya.resource.ICreateResource');
Laya.interface('laya.d3.core.render.IRenderable');
Laya.interface('laya.webgl.canvas.save.ISaveData');
Laya.interface('laya.webgl.resource.IMergeAtlasBitmap');
Laya.interface('laya.filters.IFilterActionGL','laya.filters.IFilterAction');
/**
*@private
*/
//class laya.utils.RunDriver
var RunDriver=(function(){
	function RunDriver(){}
	__class(RunDriver,'laya.utils.RunDriver');
	RunDriver.FILTER_ACTIONS=[];
	RunDriver.pixelRatio=-1;
	RunDriver._charSizeTestDiv=null;
	RunDriver.now=function(){
		return Date.now();
	}

	RunDriver.getWindow=function(){
		return window;
	}

	RunDriver.getPixelRatio=function(){
		if (RunDriver.pixelRatio < 0){
			var ctx=Browser.context;
			var backingStore=ctx.backingStorePixelRatio || ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
			RunDriver.pixelRatio=(Browser.window.devicePixelRatio || 1)/ backingStore;
			if (RunDriver.pixelRatio < 1)RunDriver.pixelRatio=1;
		}
		return RunDriver.pixelRatio;
	}

	RunDriver.getIncludeStr=function(name){
		return null;
	}

	RunDriver.createShaderCondition=function(conditionScript){
		var fn="(function() {return "+conditionScript+";})";
		return Browser.window.eval(fn);
	}

	RunDriver.fontMap=[];
	RunDriver.measureText=function(txt,font){
		var isChinese=RunDriver.hanzi.test(txt);
		if (isChinese && RunDriver.fontMap[font]){
			return RunDriver.fontMap[font];
		};
		var ctx=Browser.context;
		ctx.font=font;
		var r=ctx.measureText(txt);
		if (isChinese)RunDriver.fontMap[font]=r;
		return r;
	}

	RunDriver.getWebGLContext=function(canvas){
	};

	RunDriver.beginFlush=function(){
	};

	RunDriver.endFinish=function(){
	};

	RunDriver.addToAtlas=null;
	RunDriver.flashFlushImage=function(atlasWebGLCanvas){
	};

	RunDriver.drawToCanvas=function(sprite,_renderType,canvasWidth,canvasHeight,offsetX,offsetY){
		var canvas=HTMLCanvas.create("2D");
		var context=new RenderContext(canvasWidth,canvasHeight,canvas);
		RenderSprite.renders[_renderType]._fun(sprite,context,offsetX,offsetY);
		return canvas;
	}

	RunDriver.createParticleTemplate2D=null;
	RunDriver.createGLTextur=null;
	RunDriver.createWebGLContext2D=null;
	RunDriver.changeWebGLSize=function(w,h){
	};

	RunDriver.createRenderSprite=function(type,next){
		return new RenderSprite(type,next);
	}

	RunDriver.createFilterAction=function(type){
		return new ColorFilterAction();
	}

	RunDriver.createGraphics=function(){
		return new Graphics();
	}

	RunDriver.clear=function(value){
		Render._context.ctx.clear();
	}

	RunDriver.clearAtlas=function(value){
	};

	RunDriver.isAtlas=function(bitmap){
		return false;
	}

	RunDriver.addTextureToAtlas=function(value){
	};

	RunDriver.getTexturePixels=function(value,x,y,width,height){
		return null;
	}

	RunDriver.skinAniSprite=function(){
		return null;
	}

	RunDriver.update3DLoop=function(){
	};

	__static(RunDriver,
	['hanzi',function(){return this.hanzi=new RegExp("^[\u4E00-\u9FA5]$");}
	]);
	return RunDriver;
})()


/**
*<code>Laya</code> 是全局对象的引用入口集。
*Laya类引用了一些常用的全局对象，比如Laya.stage：舞台，Laya.timer：时间管理器，Laya.loader：加载管理器，使用时注意大小写。
*/
//class Laya
var ___Laya=(function(){
	//function Laya(){}
	/**
	*表示是否捕获全局错误并弹出提示。默认为false。
	*适用于移动设备等不方便调试的时候，设置为true后，如有未知错误，可以弹窗抛出详细错误堆栈。
	*/
	__getset(1,Laya,'alertGlobalError',null,function(value){
		var erralert=0;
		if (value){
			Browser.window.onerror=function (msg,url,line,column,detail){
				if (erralert++< 5 && detail)
					alert("出错啦，请把此信息截图给研发商\n"+msg+"\n"+detail.stack||detail);
			}
			}else {
			Browser.window.onerror=null;
		}
	});

	Laya.init=function(width,height,__plugins){
		var plugins=[];for(var i=2,sz=arguments.length;i<sz;i++)plugins.push(arguments[i]);
		if (Laya._isinit)return;
		ArrayBuffer.prototype.slice || (ArrayBuffer.prototype.slice=Laya._arrayBufferSlice);
		Laya._isinit=true;
		Browser.__init__();
		Context.__init__();
		Graphics.__init__();
		Laya.timer=new Timer();
		Laya.scaleTimer=new Timer();
		Laya.loader=new LoaderManager();
		WeakObject.__init__();
		for (var i=0,n=plugins.length;i < n;i++){
			if (plugins[i].enable)plugins[i].enable();
		}
		Font.__init__();
		Style.__init__();
		ResourceManager.__init__();
		CacheManager.beginCheck();
		Laya._currentStage=Laya.stage=new Stage();
		Laya.stage.conchModel && Laya.stage.conchModel.setRootNode();
		Laya.getUrlPath();
		Laya.render=new Render(0,0);
		Laya.stage.size(width,height);
		RenderSprite.__init__();
		KeyBoardManager.__init__();
		MouseManager.instance.__init__(Laya.stage,Render.canvas);
		Input.__init__();
		SoundManager.autoStopMusic=true;
		LocalStorage.__init__();
		return Render.canvas;
	}

	Laya.getUrlPath=function(){
		var location=Browser.window.location;
		var pathName=location.pathname;
		pathName=pathName.charAt(2)==':' ? pathName.substring(1):pathName;
		URL.rootPath=URL.basePath=URL.getPath(location.protocol=="file:" ? pathName :location.protocol+"//"+location.host+location.pathname);
	}

	Laya._arrayBufferSlice=function(start,end){
		var arr=this;
		var arrU8List=new Uint8Array(arr,start,end-start);
		var newU8List=new Uint8Array(arrU8List.length);
		newU8List.set(arrU8List);
		return newU8List.buffer;
	}

	Laya.stage=null;
	Laya.timer=null;
	Laya.scaleTimer=null;
	Laya.loader=null;
	Laya.version="1.7.13beta";
	Laya.render=null;
	Laya._currentStage=null;
	Laya._isinit=false;
	__static(Laya,
	['conchMarket',function(){return this.conchMarket=window.conch?conchMarket:null;},'PlatformClass',function(){return this.PlatformClass=window.PlatformClass;}
	]);
	return Laya;
})()


/**
*<code>EventDispatcher</code> 类是可调度事件的所有类的基类。
*/
//class laya.events.EventDispatcher
var EventDispatcher=(function(){
	var EventHandler;
	function EventDispatcher(){
		/**@private */
		this._$0__events=null;
	}

	__class(EventDispatcher,'laya.events.EventDispatcher');
	var __proto=EventDispatcher.prototype;
	/**
	*检查 EventDispatcher 对象是否为特定事件类型注册了任何侦听器。
	*@param type 事件的类型。
	*@return 如果指定类型的侦听器已注册，则值为 true；否则，值为 false。
	*/
	__proto.hasListener=function(type){
		var listener=this._$0__events && this._$0__events[type];
		return !!listener;
	}

	/**
	*派发事件。
	*@param type 事件类型。
	*@param data （可选）回调数据。<b>注意：</b>如果是需要传递多个参数 p1,p2,p3,...可以使用数组结构如：[p1,p2,p3,...] ；如果需要回调单个参数 p ，且 p 是一个数组，则需要使用结构如：[p]，其他的单个参数 p ，可以直接传入参数 p。
	*@return 此事件类型是否有侦听者，如果有侦听者则值为 true，否则值为 false。
	*/
	__proto.event=function(type,data){
		if (!this._$0__events || !this._$0__events[type])return false;
		var listeners=this._$0__events[type];
		if (listeners.run){
			if (listeners.once)delete this._$0__events[type];
			data !=null ? listeners.runWith(data):listeners.run();
			}else {
			for (var i=0,n=listeners.length;i < n;i++){
				var listener=listeners[i];
				if (listener){
					(data !=null)? listener.runWith(data):listener.run();
				}
				if (!listener || listener.once){
					listeners.splice(i,1);
					i--;
					n--;
				}
			}
			if (listeners.length===0 && this._$0__events)delete this._$0__events[type];
		}
		return true;
	}

	/**
	*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知。
	*@param type 事件的类型。
	*@param caller 事件侦听函数的执行域。
	*@param listener 事件侦听函数。
	*@param args （可选）事件侦听函数的回调参数。
	*@return 此 EventDispatcher 对象。
	*/
	__proto.on=function(type,caller,listener,args){
		return this._createListener(type,caller,listener,args,false);
	}

	/**
	*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知，此侦听事件响应一次后自动移除。
	*@param type 事件的类型。
	*@param caller 事件侦听函数的执行域。
	*@param listener 事件侦听函数。
	*@param args （可选）事件侦听函数的回调参数。
	*@return 此 EventDispatcher 对象。
	*/
	__proto.once=function(type,caller,listener,args){
		return this._createListener(type,caller,listener,args,true);
	}

	/**@private */
	__proto._createListener=function(type,caller,listener,args,once,offBefore){
		(offBefore===void 0)&& (offBefore=true);
		offBefore && this.off(type,caller,listener,once);
		var handler=EventHandler.create(caller || this,listener,args,once);
		this._$0__events || (this._$0__events={});
		var events=this._$0__events;
		if (!events[type])events[type]=handler;
		else {
			if (!events[type].run)events[type].push(handler);
			else events[type]=[events[type],handler];
		}
		return this;
	}

	/**
	*从 EventDispatcher 对象中删除侦听器。
	*@param type 事件的类型。
	*@param caller 事件侦听函数的执行域。
	*@param listener 事件侦听函数。
	*@param onceOnly （可选）如果值为 true ,则只移除通过 once 方法添加的侦听器。
	*@return 此 EventDispatcher 对象。
	*/
	__proto.off=function(type,caller,listener,onceOnly){
		(onceOnly===void 0)&& (onceOnly=false);
		if (!this._$0__events || !this._$0__events[type])return this;
		var listeners=this._$0__events[type];
		if (listener !=null){
			if (listeners.run){
				if ((!caller || listeners.caller===caller)&& listeners.method===listener && (!onceOnly || listeners.once)){
					delete this._$0__events[type];
					listeners.recover();
				}
				}else {
				var count=0;
				for (var i=0,n=listeners.length;i < n;i++){
					var item=listeners[i];
					if (item && (!caller || item.caller===caller)&& item.method===listener && (!onceOnly || item.once)){
						count++;
						listeners[i]=null;
						item.recover();
					}
				}
				if (count===n)delete this._$0__events[type];
			}
		}
		return this;
	}

	/**
	*从 EventDispatcher 对象中删除指定事件类型的所有侦听器。
	*@param type （可选）事件类型，如果值为 null，则移除本对象所有类型的侦听器。
	*@return 此 EventDispatcher 对象。
	*/
	__proto.offAll=function(type){
		var events=this._$0__events;
		if (!events)return this;
		if (type){
			this._recoverHandlers(events[type]);
			delete events[type];
			}else {
			for (var name in events){
				this._recoverHandlers(events[name]);
			}
			this._$0__events=null;
		}
		return this;
	}

	__proto._recoverHandlers=function(arr){
		if (!arr)return;
		if (arr.run){
			arr.recover();
			}else {
			for (var i=arr.length-1;i >-1;i--){
				if (arr[i]){
					arr[i].recover();
					arr[i]=null;
				}
			}
		}
	}

	/**
	*检测指定事件类型是否是鼠标事件。
	*@param type 事件的类型。
	*@return 如果是鼠标事件，则值为 true;否则，值为 false。
	*/
	__proto.isMouseEvent=function(type){
		return EventDispatcher.MOUSE_EVENTS[type];
	}

	__static(EventDispatcher,
	['MOUSE_EVENTS',function(){return this.MOUSE_EVENTS={"rightmousedown":true,"rightmouseup":true,"rightclick":true,"mousedown":true,"mouseup":true,"mousemove":true,"mouseover":true,"mouseout":true,"click":true,"doubleclick":true};}
	]);
	EventDispatcher.__init$=function(){
		Object.defineProperty(laya.events.EventDispatcher.prototype,"_events",{enumerable:false,writable:true});
		/**@private */
		//class EventHandler extends laya.utils.Handler
		EventHandler=(function(_super){
			function EventHandler(caller,method,args,once){
				EventHandler.__super.call(this,caller,method,args,once);
			}
			__class(EventHandler,'',_super);
			var __proto=EventHandler.prototype;
			__proto.recover=function(){
				if (this._id > 0){
					this._id=0;
					EventHandler._pool.push(this.clear());
				}
			}
			EventHandler.create=function(caller,method,args,once){
				(once===void 0)&& (once=true);
				if (EventHandler._pool.length)return EventHandler._pool.pop().setTo(caller,method,args,once);
				return new EventHandler(caller,method,args,once);
			}
			EventHandler._pool=[];
			return EventHandler;
		})(Handler)
	}

	return EventDispatcher;
})()


/**
*<p><code>Handler</code> 是事件处理器类。</p>
*<p>推荐使用 Handler.create()方法从对象池创建，减少对象创建消耗。创建的 Handler 对象不再使用后，可以使用 Handler.recover()将其回收到对象池，回收后不要再使用此对象，否则会导致不可预料的错误。</p>
*<p><b>注意：</b>由于鼠标事件也用本对象池，不正确的回收及调用，可能会影响鼠标事件的执行。</p>
*/
//class laya.utils.Handler
var Handler=(function(){
	function Handler(caller,method,args,once){
		/**执行域(this)。*/
		//this.caller=null;
		/**处理方法。*/
		//this.method=null;
		/**参数。*/
		//this.args=null;
		/**表示是否只执行一次。如果为true，回调后执行recover()进行回收，回收后会被再利用，默认为false 。*/
		this.once=false;
		/**@private */
		this._id=0;
		(once===void 0)&& (once=false);
		this.setTo(caller,method,args,once);
	}

	__class(Handler,'laya.utils.Handler');
	var __proto=Handler.prototype;
	/**
	*设置此对象的指定属性值。
	*@param caller 执行域(this)。
	*@param method 回调方法。
	*@param args 携带的参数。
	*@param once 是否只执行一次，如果为true，执行后执行recover()进行回收。
	*@return 返回 handler 本身。
	*/
	__proto.setTo=function(caller,method,args,once){
		this._id=Handler._gid++;
		this.caller=caller;
		this.method=method;
		this.args=args;
		this.once=once;
		return this;
	}

	/**
	*执行处理器。
	*/
	__proto.run=function(){
		if (this.method==null)return null;
		var id=this._id;
		var result=this.method.apply(this.caller,this.args);
		this._id===id && this.once && this.recover();
		return result;
	}

	/**
	*执行处理器，携带额外数据。
	*@param data 附加的回调数据，可以是单数据或者Array(作为多参)。
	*/
	__proto.runWith=function(data){
		if (this.method==null)return null;
		var id=this._id;
		if (data==null)
			var result=this.method.apply(this.caller,this.args);
		else if (!this.args && !data.unshift)result=this.method.call(this.caller,data);
		else if (this.args)result=this.method.apply(this.caller,this.args.concat(data));
		else result=this.method.apply(this.caller,data);
		this._id===id && this.once && this.recover();
		return result;
	}

	/**
	*清理对象引用。
	*/
	__proto.clear=function(){
		this.caller=null;
		this.method=null;
		this.args=null;
		return this;
	}

	/**
	*清理并回收到 Handler 对象池内。
	*/
	__proto.recover=function(){
		if (this._id > 0){
			this._id=0;
			Handler._pool.push(this.clear());
		}
	}

	Handler.create=function(caller,method,args,once){
		(once===void 0)&& (once=true);
		if (Handler._pool.length)return Handler._pool.pop().setTo(caller,method,args,once);
		return new Handler(caller,method,args,once);
	}

	Handler._pool=[];
	Handler._gid=1;
	return Handler;
})()


//class vrModule.VRScene2
var VRScene2=(function(){
	function VRScene2(){
		Laya3D.init(0,0,true);
		Laya.stage.scaleMode="full";
		Laya.stage.screenMode="none";
		Stat.show();
		var scene=Laya.stage.addChild(Scene.load("../../../../res/threeDimen/scene/Arena/Arena.ls"));
		var vrCamera=scene.addChild(new VRCamera(0.03,0,0,0.1,100));
		vrCamera.transform.translate(new Vector3(0,2,0));
		vrCamera.clearFlag=1;
		vrCamera.addComponent(VRCameraMoveScript);
		var skyBox=new SkyBox();
		skyBox.textureCube=TextureCube.load("../../../../res/threeDimen/skyBox/skyBox2/skyCube.ltc");
		vrCamera.sky=skyBox;
	}

	__class(VRScene2,'vrModule.VRScene2');
	return VRScene2;
})()


/**
*Config 用于配置一些全局参数。如需更改，请在初始化引擎之前设置。
*/
//class Config
var Config=(function(){
	function Config(){}
	__class(Config,'Config');
	Config.WebGLTextCacheCount=500;
	Config.atlasEnable=false;
	Config.showCanvasMark=false;
	Config.animationInterval=50;
	Config.isAntialias=false;
	Config.isAlpha=false;
	Config.premultipliedAlpha=true;
	Config.isStencil=true;
	Config.preserveDrawingBuffer=false;
	return Config;
})()


/**
*<code>BitmapFont</code> 是位图字体类，用于定义位图字体信息。
*/
//class laya.display.BitmapFont
var BitmapFont=(function(){
	function BitmapFont(){
		this._texture=null;
		this._fontCharDic={};
		this._fontWidthMap={};
		this._complete=null;
		this._path=null;
		this._maxWidth=0;
		this._spaceWidth=10;
		this._padding=null;
		/**当前位图字体字号。*/
		this.fontSize=12;
		/**表示是否根据实际使用的字体大小缩放位图字体大小。*/
		this.autoScaleSize=false;
		/**字符间距（以像素为单位）。*/
		this.letterSpacing=0;
	}

	__class(BitmapFont,'laya.display.BitmapFont');
	var __proto=BitmapFont.prototype;
	/**
	*通过指定位图字体文件路径，加载位图字体文件，加载完成后会自动解析。
	*@param path 位图字体文件的路径。
	*@param complete 加载并解析完成的回调。
	*/
	__proto.loadFont=function(path,complete){
		this._path=path;
		this._complete=complete;
		Laya.loader.load([{url:this._path,type:"xml"},{url:this._path.replace(".fnt",".png"),type:"image"}],Handler.create(this,this.onLoaded));
	}

	/**
	*@private
	*/
	__proto.onLoaded=function(){
		this.parseFont(Loader.getRes(this._path),Loader.getRes(this._path.replace(".fnt",".png")));
		this._complete && this._complete.run();
	}

	/**
	*解析字体文件。
	*@param xml 字体文件XML。
	*@param texture 字体的纹理。
	*/
	__proto.parseFont=function(xml,texture){
		if (xml==null || texture==null)return;
		this._texture=texture;
		var tX=0;
		var tScale=1;
		var tInfo=xml.getElementsByTagName("info");
		if (!tInfo[0].getAttributeNode){
			return this.parseFont2(xml,texture);
		}
		this.fontSize=parseInt(tInfo[0].getAttributeNode("size").nodeValue);
		var tPadding=tInfo[0].getAttributeNode("padding").nodeValue;
		var tPaddingArray=tPadding.split(",");
		this._padding=[parseInt(tPaddingArray[0]),parseInt(tPaddingArray[1]),parseInt(tPaddingArray[2]),parseInt(tPaddingArray[3])];
		var chars;
		chars=xml.getElementsByTagName("char");
		var i=0;
		for (i=0;i < chars.length;i++){
			var tAttribute=chars[i];
			var tId=parseInt(tAttribute.getAttributeNode("id").nodeValue);
			var xOffset=parseInt(tAttribute.getAttributeNode("xoffset").nodeValue)/ tScale;
			var yOffset=parseInt(tAttribute.getAttributeNode("yoffset").nodeValue)/ tScale;
			var xAdvance=parseInt(tAttribute.getAttributeNode("xadvance").nodeValue)/ tScale;
			var region=new Rectangle();
			region.x=parseInt(tAttribute.getAttributeNode("x").nodeValue);
			region.y=parseInt(tAttribute.getAttributeNode("y").nodeValue);
			region.width=parseInt(tAttribute.getAttributeNode("width").nodeValue);
			region.height=parseInt(tAttribute.getAttributeNode("height").nodeValue);
			var tTexture=Texture.create(texture,region.x,region.y,region.width,region.height,xOffset,yOffset);
			this._maxWidth=Math.max(this._maxWidth,xAdvance+this.letterSpacing);
			this._fontCharDic[tId]=tTexture;
			this._fontWidthMap[tId]=xAdvance;
		}
	}

	/**
	*解析字体文件。
	*@param xml 字体文件XML。
	*@param texture 字体的纹理。
	*/
	__proto.parseFont2=function(xml,texture){
		if (xml==null || texture==null)return;
		this._texture=texture;
		var tX=0;
		var tScale=1;
		var tInfo=xml.getElementsByTagName("info");
		this.fontSize=parseInt(tInfo[0].attributes["size"].nodeValue);
		var tPadding=tInfo[0].attributes["padding"].nodeValue;
		var tPaddingArray=tPadding.split(",");
		this._padding=[parseInt(tPaddingArray[0]),parseInt(tPaddingArray[1]),parseInt(tPaddingArray[2]),parseInt(tPaddingArray[3])];
		var chars=xml.getElementsByTagName("char");
		var i=0;
		for (i=0;i < chars.length;i++){
			var tAttribute=chars[i].attributes;
			var tId=parseInt(tAttribute["id"].nodeValue);
			var xOffset=parseInt(tAttribute["xoffset"].nodeValue)/ tScale;
			var yOffset=parseInt(tAttribute["yoffset"].nodeValue)/ tScale;
			var xAdvance=parseInt(tAttribute["xadvance"].nodeValue)/ tScale;
			var region=new Rectangle();
			region.x=parseInt(tAttribute["x"].nodeValue);
			region.y=parseInt(tAttribute["y"].nodeValue);
			region.width=parseInt(tAttribute["width"].nodeValue);
			region.height=parseInt(tAttribute["height"].nodeValue);
			var tTexture=Texture.create(texture,region.x,region.y,region.width,region.height,xOffset,yOffset);
			this._maxWidth=Math.max(this._maxWidth,xAdvance+this.letterSpacing);
			this._fontCharDic[tId]=tTexture;
			this._fontWidthMap[tId]=xAdvance;
		}
	}

	/**
	*获取指定字符的字体纹理对象。
	*@param char 字符。
	*@return 指定的字体纹理对象。
	*/
	__proto.getCharTexture=function(char){
		return this._fontCharDic[char.charCodeAt(0)];
	}

	/**
	*销毁位图字体，调用Text.unregisterBitmapFont 时，默认会销毁。
	*/
	__proto.destroy=function(){
		if (this._texture){
			for (var p in this._fontCharDic){
				var tTexture=this._fontCharDic[p];
				if (tTexture)tTexture.destroy();
			}
			this._texture.destroy();
			this._fontCharDic=null;
			this._fontWidthMap=null;
			this._texture=null;
		}
	}

	/**
	*设置空格的宽（如果字体库有空格，这里就可以不用设置了）。
	*@param spaceWidth 宽度，单位为像素。
	*/
	__proto.setSpaceWidth=function(spaceWidth){
		this._spaceWidth=spaceWidth;
	}

	/**
	*获取指定字符的宽度。
	*@param char 字符。
	*@return 宽度。
	*/
	__proto.getCharWidth=function(char){
		var code=char.charCodeAt(0);
		if (this._fontWidthMap[code])return this._fontWidthMap[code]+this.letterSpacing;
		if (char==" ")return this._spaceWidth+this.letterSpacing;
		return 0;
	}

	/**
	*获取指定文本内容的宽度。
	*@param text 文本内容。
	*@return 宽度。
	*/
	__proto.getTextWidth=function(text){
		var tWidth=0;
		for (var i=0,n=text.length;i < n;i++){
			tWidth+=this.getCharWidth(text.charAt(i));
		}
		return tWidth;
	}

	/**
	*获取最大字符宽度。
	*/
	__proto.getMaxWidth=function(){
		return this._maxWidth;
	}

	/**
	*获取最大字符高度。
	*/
	__proto.getMaxHeight=function(){
		return this.fontSize;
	}

	/**
	*@private
	*将指定的文本绘制到指定的显示对象上。
	*/
	__proto.drawText=function(text,sprite,drawX,drawY,align,width){
		var tWidth=this.getTextWidth(text);
		var tTexture;
		var dx=0;
		align==="center" && (dx=(width-tWidth)/ 2);
		align==="right" && (dx=(width-tWidth));
		var tX=0;
		for (var i=0,n=text.length;i < n;i++){
			tTexture=this.getCharTexture(text.charAt(i));
			if (tTexture){
				sprite.graphics.drawTexture(tTexture,drawX+tX+dx,drawY);
				tX+=this.getCharWidth(text.charAt(i));
			}
		}
	}

	return BitmapFont;
})()


/**
*@private
*<code>Style</code> 类是元素样式定义类。
*/
//class laya.display.css.Style
var Style=(function(){
	function Style(){
		/**透明度。*/
		this.alpha=1;
		/**表示是否显示。*/
		this.visible=true;
		/**表示滚动区域。*/
		this.scrollRect=null;
		/**混合模式。*/
		this.blendMode=null;
		/**@private */
		this._type=0;
		this._tf=Style._TF_EMPTY;
	}

	__class(Style,'laya.display.css.Style');
	var __proto=Style.prototype;
	__proto.getTransform=function(){
		return this._tf;
	}

	__proto.setTransform=function(value){
		this._tf=value==='none' || !value ? Style._TF_EMPTY :value;
	}

	__proto.setTranslateX=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.translateX=value;
	}

	__proto.setTranslateY=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.translateY=value;
	}

	__proto.setScaleX=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.scaleX=value;
	}

	__proto.setScale=function(x,y){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.scaleX=x;
		this._tf.scaleY=y;
	}

	__proto.setScaleY=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.scaleY=value;
	}

	__proto.setRotate=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.rotate=value;
	}

	__proto.setSkewX=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.skewX=value;
	}

	__proto.setSkewY=function(value){
		this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
		this._tf.skewY=value;
	}

	/**销毁此对象。*/
	__proto.destroy=function(){
		this.scrollRect=null;
	}

	/**@private */
	__proto.render=function(sprite,context,x,y){}
	/**@private */
	__proto.getCSSStyle=function(){
		return CSSStyle.EMPTY;
	}

	/**@private */
	__proto._enableLayout=function(){
		return false;
	}

	/**X 轴缩放值。*/
	__getset(0,__proto,'scaleX',function(){
		return this._tf.scaleX;
		},function(value){
		this.setScaleX(value);
	});

	/**元素应用的 2D 或 3D 转换的值。该属性允许我们对元素进行旋转、缩放、移动或倾斜。*/
	__getset(0,__proto,'transform',function(){
		return this.getTransform();
		},function(value){
		this.setTransform(value);
	});

	/**定义转换，只是用 X 轴的值。*/
	__getset(0,__proto,'translateX',function(){
		return this._tf.translateX;
		},function(value){
		this.setTranslateX(value);
	});

	/**定义转换，只是用 Y 轴的值。*/
	__getset(0,__proto,'translateY',function(){
		return this._tf.translateY;
		},function(value){
		this.setTranslateY(value);
	});

	/**Y 轴缩放值。*/
	__getset(0,__proto,'scaleY',function(){
		return this._tf.scaleY;
		},function(value){
		this.setScaleY(value);
	});

	/**表示元素是否显示为块级元素。*/
	__getset(0,__proto,'block',function(){
		return (this._type & 0x1)!=0;
	});

	/**定义沿着 Y 轴的 2D 倾斜转换。*/
	__getset(0,__proto,'skewY',function(){
		return this._tf.skewY;
		},function(value){
		this.setSkewY(value);
	});

	/**定义旋转角度。*/
	__getset(0,__proto,'rotate',function(){
		return this._tf.rotate;
		},function(value){
		this.setRotate(value);
	});

	/**定义沿着 X 轴的 2D 倾斜转换。*/
	__getset(0,__proto,'skewX',function(){
		return this._tf.skewX;
		},function(value){
		this.setSkewX(value);
	});

	/**表示元素的左内边距。*/
	__getset(0,__proto,'paddingLeft',function(){
		return 0;
	});

	/**表示元素的上内边距。*/
	__getset(0,__proto,'paddingTop',function(){
		return 0;
	});

	/**是否为绝对定位。*/
	__getset(0,__proto,'absolute',function(){
		return true;
	});

	Style.__init__=function(){
		Style._TF_EMPTY=new TransformInfo();
		Style.EMPTY=new Style();
	}

	Style.EMPTY=null;
	Style._TF_EMPTY=null;
	return Style;
})()


/**
*@private
*<code>Font</code> 类是字体显示定义类。
*/
//class laya.display.css.Font
var Font=(function(){
	function Font(src){
		this._type=0;
		this._weight=0;
		this._decoration=null;
		this._text=null;
		/**
		*首行缩进 （以像素为单位）。
		*/
		this.indent=0;
		this._color=Color.create(Font.defaultColor);
		this.family=Font.defaultFamily;
		this.stroke=Font._STROKE;
		this.size=Font.defaultSize;
		src && src!==Font.EMPTY && src.copyTo(this);
	}

	__class(Font,'laya.display.css.Font');
	var __proto=Font.prototype;
	/**
	*字体样式字符串。
	*/
	__proto.set=function(value){
		this._text=null;
		var strs=value.split(' ');
		for (var i=0,n=strs.length;i < n;i++){
			var str=strs[i];
			switch (str){
				case 'italic':
					this.italic=true;
					continue ;
				case 'bold':
					this.bold=true;
					continue ;
				}
			if (str.indexOf('px')> 0){
				this.size=parseInt(str);
				this.family=strs[i+1];
				i++;
				continue ;
			}
		}
	}

	/**
	*返回字体样式字符串。
	*@return 字体样式字符串。
	*/
	__proto.toString=function(){
		this._text=""
		this.italic && (this._text+="italic ");
		this.bold && (this._text+="bold ");
		return this._text+=this.size+"px "+this.family;
	}

	/**
	*将当前的属性值复制到传入的 <code>Font</code> 对象。
	*@param dec 一个 Font 对象。
	*/
	__proto.copyTo=function(dec){
		dec._type=this._type;
		dec._text=this._text;
		dec._weight=this._weight;
		dec._color=this._color;
		dec.family=this.family;
		dec.stroke=this.stroke !=Font._STROKE ? this.stroke.slice():Font._STROKE;
		dec.indent=this.indent;
		dec.size=this.size;
	}

	/**
	*表示是否为密码格式。
	*/
	__getset(0,__proto,'password',function(){
		return (this._type & 0x400)!==0;
		},function(value){
		value ? (this._type |=0x400):(this._type &=~0x400);
	});

	/**
	*表示颜色字符串。
	*/
	__getset(0,__proto,'color',function(){
		return this._color.strColor;
		},function(value){
		this._color=Color.create(value);
	});

	/**
	*表示是否为斜体。
	*/
	__getset(0,__proto,'italic',function(){
		return (this._type & 0x200)!==0;
		},function(value){
		value ? (this._type |=0x200):(this._type &=~0x200);
	});

	/**
	*表示是否为粗体。
	*/
	__getset(0,__proto,'bold',function(){
		return (this._type & 0x800)!==0;
		},function(value){
		value ? (this._type |=0x800):(this._type &=~0x800);
	});

	/**
	*文本的粗细。
	*/
	__getset(0,__proto,'weight',function(){
		return ""+this._weight;
		},function(value){
		var weight=0;
		switch (value){
			case 'normal':
				break ;
			case 'bold':
				this.bold=true;
				weight=700;
				break ;
			case 'bolder':
				weight=800;
				break ;
			case 'lighter':
				weight=100;
				break ;
			default :
				weight=parseInt(value);
			}
		this._weight=weight;
		this._text=null;
	});

	/**
	*规定添加到文本的修饰。
	*/
	__getset(0,__proto,'decoration',function(){
		return this._decoration ? this._decoration.value :"none";
		},function(value){
		var strs=value.split(' ');
		this._decoration || (this._decoration={});
		switch (strs[0]){
			case '_':
				this._decoration.type='underline'
				break ;
			case '-':
				this._decoration.type='line-through'
				break ;
			case 'overline':
				this._decoration.type='overline'
				break ;
			default :
				this._decoration.type=strs[0];
			}
		strs[1] && (this._decoration.color=Color.create(strs));
		this._decoration.value=value;
	});

	Font.__init__=function(){
		Font.EMPTY=new Font(null);
	}

	Font.EMPTY=null;
	Font.defaultColor="#000000";
	Font.defaultSize=12;
	Font.defaultFamily="Arial";
	Font.defaultFont="12px Arial";
	Font._ITALIC=0x200;
	Font._PASSWORD=0x400;
	Font._BOLD=0x800;
	__static(Font,
	['_STROKE',function(){return this._STROKE=[0,"#000000"];}
	]);
	return Font;
})()


/**
*@private
*/
//class laya.display.css.TransformInfo
var TransformInfo=(function(){
	function TransformInfo(){
		this.translateX=0;
		this.translateY=0;
		this.scaleX=1;
		this.scaleY=1;
		this.rotate=0;
		this.skewX=0;
		this.skewY=0;
	}

	__class(TransformInfo,'laya.display.css.TransformInfo');
	return TransformInfo;
})()


/**
*<code>Graphics</code> 类用于创建绘图显示对象。Graphics可以同时绘制多个位图或者矢量图，还可以结合save，restore，transform，scale，rotate，translate，alpha等指令对绘图效果进行变化。
*Graphics以命令流方式存储，可以通过cmds属性访问所有命令流。Graphics是比Sprite更轻量级的对象，合理使用能提高应用性能(比如把大量的节点绘图改为一个节点的Graphics命令集合，能减少大量节点创建消耗)。
*@see laya.display.Sprite#graphics
*/
//class laya.display.Graphics
var Graphics=(function(){
	function Graphics(){
		/**@private */
		//this._sp=null;
		/**@private */
		this._one=null;
		/**@private */
		this._cmds=null;
		/**@private */
		//this._vectorgraphArray=null;
		/**@private */
		//this._graphicBounds=null;
		this._render=this._renderEmpty;
		if (Render.isConchNode){
			var _this_=this;
			_this_._nativeObj=new (window)._conchGraphics();
			_this_.id=_this_._nativeObj.conchID;
		}
	}

	__class(Graphics,'laya.display.Graphics');
	var __proto=Graphics.prototype;
	/**
	*<p>销毁此对象。</p>
	*/
	__proto.destroy=function(){
		this.clear();
		if (this._graphicBounds)this._graphicBounds.destroy();
		this._graphicBounds=null;
		this._vectorgraphArray=null;
		this._sp && (this._sp._renderType=0);
		this._sp=null;
	}

	/**
	*<p>清空绘制命令。</p>
	*@param recoverCmds 是否回收绘图指令
	*/
	__proto.clear=function(recoverCmds){
		(recoverCmds===void 0)&& (recoverCmds=false);
		var i=0,len=0;
		if (recoverCmds){
			var tCmd=this._one;
			if (this._cmds){
				len=this._cmds.length;
				for (i=0;i < len;i++){
					tCmd=this._cmds[i];
					if (tCmd && (tCmd.callee===Render._context._drawTexture || tCmd.callee===Render._context._drawTextureWithTransform)){
						tCmd[0]=null;
						Graphics._cache.push(tCmd);
					}
				}
				this._cmds.length=0;
				}else if (tCmd){
				if (tCmd && (tCmd.callee===Render._context._drawTexture || tCmd.callee===Render._context._drawTextureWithTransform)){
					tCmd[0]=null;
					Graphics._cache.push(tCmd);
				}
			}
			}else {
			this._cmds=null;
		}
		this._one=null;
		this._render=this._renderEmpty;
		this._sp && (this._sp._renderType &=~0x01 & ~0x200);
		this._repaint();
		if (this._vectorgraphArray){
			for (i=0,len=this._vectorgraphArray.length;i < len;i++){
				VectorGraphManager.getInstance().deleteShape(this._vectorgraphArray[i]);
			}
			this._vectorgraphArray.length=0;
		}
	}

	/**@private */
	__proto._clearBoundsCache=function(){
		if (this._graphicBounds)this._graphicBounds.reset();
	}

	/**@private */
	__proto._initGraphicBounds=function(){
		if (!this._graphicBounds){
			this._graphicBounds=new GraphicsBounds();
			this._graphicBounds._graphics=this;
		}
	}

	/**
	*@private
	*重绘此对象。
	*/
	__proto._repaint=function(){
		this._clearBoundsCache();
		this._sp && this._sp.repaint();
	}

	/**@private */
	__proto._isOnlyOne=function(){
		return !this._cmds || this._cmds.length===0;
	}

	/**
	*获取位置及宽高信息矩阵(比较耗CPU，频繁使用会造成卡顿，尽量少用)。
	*@param realSize （可选）使用图片的真实大小，默认为false
	*@return 位置与宽高组成的 一个 Rectangle 对象。
	*/
	__proto.getBounds=function(realSize){
		(realSize===void 0)&& (realSize=false);
		this._initGraphicBounds();
		return this._graphicBounds.getBounds(realSize);
	}

	/**
	*@private
	*@param realSize （可选）使用图片的真实大小，默认为false
	*获取端点列表。
	*/
	__proto.getBoundPoints=function(realSize){
		(realSize===void 0)&& (realSize=false);
		this._initGraphicBounds();
		return this._graphicBounds.getBoundPoints(realSize);
	}

	__proto._addCmd=function(a){
		this._cmds=this._cmds || [];
		a.callee=a.shift();
		this._cmds.push(a);
	}

	__proto.setFilters=function(fs){
		this._saveToCmd(Render._context._setFilters,fs);
	}

	/**
	*绘制纹理。
	*@param tex 纹理。
	*@param x （可选）X轴偏移量。
	*@param y （可选）Y轴偏移量。
	*@param width （可选）宽度。
	*@param height （可选）高度。
	*@param m （可选）矩阵信息。
	*@param alpha （可选）透明度。
	*/
	__proto.drawTexture=function(tex,x,y,width,height,m,alpha){
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		(alpha===void 0)&& (alpha=1);
		if (!tex || alpha < 0.01)return null;
		if (!width)width=tex.sourceWidth;
		if (!height)height=tex.sourceHeight;
		alpha=alpha < 0 ? 0 :(alpha > 1 ? 1 :alpha);
		var wRate=width / tex.sourceWidth;
		var hRate=height / tex.sourceHeight;
		width=tex.width *wRate;
		height=tex.height *hRate;
		if (tex.loaded && (width <=0 || height <=0))return null;
		x+=tex.offsetX *wRate;
		y+=tex.offsetY *hRate;
		this._sp && (this._sp._renderType |=0x200);
		var args;
		if (Graphics._cache.length){
			args=Graphics._cache.pop();
			args[0]=tex;
			args[1]=x;
			args[2]=y;
			args[3]=width;
			args[4]=height;
			args[5]=m;
			args[6]=alpha;
			}else {
			args=[tex,x,y,width,height,m,alpha];
		}
		args.callee=(m || alpha !=1)? Render._context._drawTextureWithTransform :Render._context._drawTexture;
		if (this._one==null && !m && alpha==1){
			this._one=args;
			this._render=this._renderOneImg;
			}else {
			this._saveToCmd(args.callee,args);
		}
		if (!tex.loaded){
			tex.once("loaded",this,this._textureLoaded,[tex,args]);
		}
		this._repaint();
		return args;
	}

	/**
	*@private 清理贴图并替换为最新的
	*@param tex
	*/
	__proto.cleanByTexture=function(tex,x,y,width,height){
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		if (!tex)return this.clear();
		if (this._one && this._render===this._renderOneImg){
			if (!width)width=tex.sourceWidth;
			if (!height)height=tex.sourceHeight;
			var wRate=width / tex.sourceWidth;
			var hRate=height / tex.sourceHeight;
			width=tex.width *wRate;
			height=tex.height *hRate;
			x+=tex.offsetX *wRate;
			y+=tex.offsetY *hRate;
			this._one[0]=tex;
			this._one[1]=x;
			this._one[2]=y;
			this._one[3]=width;
			this._one[4]=height;
			}else {
			this.clear();
			tex && this.drawTexture(tex,x,y,width,height);
		}
	}

	/**
	*批量绘制同样纹理。
	*@param tex 纹理。
	*@param pos 绘制坐标。
	*/
	__proto.drawTextures=function(tex,pos){
		if (!tex)return;
		this._saveToCmd(Render._context._drawTextures,[tex,pos]);
	}

	/**
	*用texture填充。
	*@param tex 纹理。
	*@param x X轴偏移量。
	*@param y Y轴偏移量。
	*@param width （可选）宽度。
	*@param height （可选）高度。
	*@param type （可选）填充类型 repeat|repeat-x|repeat-y|no-repeat
	*@param offset （可选）贴图纹理偏移
	*/
	__proto.fillTexture=function(tex,x,y,width,height,type,offset){
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		(type===void 0)&& (type="repeat");
		if (!tex)return;
		var args=[tex,x,y,width,height,type,offset || Point.EMPTY,{}];
		if (!tex.loaded){
			tex.once("loaded",this,this._textureLoaded,[tex,args]);
		}
		this._saveToCmd(Render._context._fillTexture,args);
	}

	__proto._textureLoaded=function(tex,param){
		param[3]=param[3] || tex.width;
		param[4]=param[4] || tex.height;
		this._repaint();
	}

	/**
	*@private
	*保存到命令流。
	*/
	__proto._saveToCmd=function(fun,args){
		this._sp && (this._sp._renderType |=0x200);
		if (this._one==null){
			this._one=args;
			this._render=this._renderOne;
			}else {
			this._sp && (this._sp._renderType &=~0x01);
			this._render=this._renderAll;
			(this._cmds || (this._cmds=[])).length===0 && this._cmds.push(this._one);
			this._cmds.push(args);
		}
		args.callee=fun;
		this._repaint();
		return args;
	}

	/**
	*设置剪裁区域，超出剪裁区域的坐标不显示。
	*@param x X 轴偏移量。
	*@param y Y 轴偏移量。
	*@param width 宽度。
	*@param height 高度。
	*/
	__proto.clipRect=function(x,y,width,height){
		this._saveToCmd(Render._context._clipRect,[x,y,width,height]);
	}

	/**
	*在画布上绘制文本。
	*@param text 在画布上输出的文本。
	*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
	*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
	*@param font 定义字号和字体，比如"20px Arial"。
	*@param color 定义文本颜色，比如"#ff0000"。
	*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
	*/
	__proto.fillText=function(text,x,y,font,color,textAlign,underLine){
		(underLine===void 0)&& (underLine=0);
		this._saveToCmd(Render._context._fillText,[text,x,y,font || Font.defaultFont,color,textAlign]);
	}

	/**
	*在画布上绘制“被填充且镶边的”文本。
	*@param text 在画布上输出的文本。
	*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
	*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
	*@param font 定义字体和字号，比如"20px Arial"。
	*@param fillColor 定义文本颜色，比如"#ff0000"。
	*@param borderColor 定义镶边文本颜色。
	*@param lineWidth 镶边线条宽度。
	*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
	*/
	__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
		this._saveToCmd(Render._context._fillBorderText,[text,x,y,font || Font.defaultFont,fillColor,borderColor,lineWidth,textAlign]);
	}

	/**
	*在画布上绘制文本（没有填色）。文本的默认颜色是黑色。
	*@param text 在画布上输出的文本。
	*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
	*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
	*@param font 定义字体和字号，比如"20px Arial"。
	*@param color 定义文本颜色，比如"#ff0000"。
	*@param lineWidth 线条宽度。
	*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
	*/
	__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
		this._saveToCmd(Render._context._strokeText,[text,x,y,font || Font.defaultFont,color,lineWidth,textAlign]);
	}

	/**
	*设置透明度。
	*@param value 透明度。
	*/
	__proto.alpha=function(value){
		value=value < 0 ? 0 :(value > 1 ? 1 :value);
		this._saveToCmd(Render._context._alpha,[value]);
	}

	/**
	*设置当前透明度。
	*@param value 透明度。
	*/
	__proto.setAlpha=function(value){
		value=value < 0 ? 0 :(value > 1 ? 1 :value);
		this._saveToCmd(Render._context._setAlpha,[value]);
	}

	/**
	*替换绘图的当前转换矩阵。
	*@param mat 矩阵。
	*@param pivotX （可选）水平方向轴心点坐标。
	*@param pivotY （可选）垂直方向轴心点坐标。
	*/
	__proto.transform=function(matrix,pivotX,pivotY){
		(pivotX===void 0)&& (pivotX=0);
		(pivotY===void 0)&& (pivotY=0);
		this._saveToCmd(Render._context._transform,[matrix,pivotX,pivotY]);
	}

	/**
	*旋转当前绘图。(推荐使用transform，性能更高)
	*@param angle 旋转角度，以弧度计。
	*@param pivotX （可选）水平方向轴心点坐标。
	*@param pivotY （可选）垂直方向轴心点坐标。
	*/
	__proto.rotate=function(angle,pivotX,pivotY){
		(pivotX===void 0)&& (pivotX=0);
		(pivotY===void 0)&& (pivotY=0);
		this._saveToCmd(Render._context._rotate,[angle,pivotX,pivotY]);
	}

	/**
	*缩放当前绘图至更大或更小。(推荐使用transform，性能更高)
	*@param scaleX 水平方向缩放值。
	*@param scaleY 垂直方向缩放值。
	*@param pivotX （可选）水平方向轴心点坐标。
	*@param pivotY （可选）垂直方向轴心点坐标。
	*/
	__proto.scale=function(scaleX,scaleY,pivotX,pivotY){
		(pivotX===void 0)&& (pivotX=0);
		(pivotY===void 0)&& (pivotY=0);
		this._saveToCmd(Render._context._scale,[scaleX,scaleY,pivotX,pivotY]);
	}

	/**
	*重新映射画布上的 (0,0)位置。
	*@param x 添加到水平坐标（x）上的值。
	*@param y 添加到垂直坐标（y）上的值。
	*/
	__proto.translate=function(x,y){
		this._saveToCmd(Render._context._translate,[x,y]);
	}

	/**
	*保存当前环境的状态。
	*/
	__proto.save=function(){
		this._saveToCmd(Render._context._save,[]);
	}

	/**
	*返回之前保存过的路径状态和属性。
	*/
	__proto.restore=function(){
		this._saveToCmd(Render._context._restore,[]);
	}

	/**
	*@private
	*替换文本内容。
	*@param text 文本内容。
	*@return 替换成功则值为true，否则值为flase。
	*/
	__proto.replaceText=function(text){
		this._repaint();
		var cmds=this._cmds;
		if (!cmds){
			if (this._one && this._isTextCmd(this._one.callee)){
				if (this._one[0].toUpperCase)this._one[0]=text;
				else this._one[0].setText(text);
				return true;
			}
			}else {
			for (var i=cmds.length-1;i >-1;i--){
				if (this._isTextCmd(cmds[i].callee)){
					if (cmds[i][0].toUpperCase)cmds[i][0]=text;
					else cmds[i][0].setText(text);
					return true;
				}
			}
		}
		return false;
	}

	/**@private */
	__proto._isTextCmd=function(fun){
		return fun===Render._context._fillText || fun===Render._context._fillBorderText || fun===Render._context._strokeText;
	}

	/**
	*@private
	*替换文本颜色。
	*@param color 颜色。
	*/
	__proto.replaceTextColor=function(color){
		this._repaint();
		var cmds=this._cmds;
		if (!cmds){
			if (this._one && this._isTextCmd(this._one.callee)){
				this._one[4]=color;
				if (!this._one[0].toUpperCase)this._one[0].changed=true;
			}
			}else {
			for (var i=cmds.length-1;i >-1;i--){
				if (this._isTextCmd(cmds[i].callee)){
					cmds[i][4]=color;
					if (!cmds[i][0].toUpperCase)cmds[i][0].changed=true;
				}
			}
		}
	}

	/**
	*加载并显示一个图片。
	*@param url 图片地址。
	*@param x （可选）显示图片的x位置。
	*@param y （可选）显示图片的y位置。
	*@param width （可选）显示图片的宽度，设置为0表示使用图片默认宽度。
	*@param height （可选）显示图片的高度，设置为0表示使用图片默认高度。
	*@param complete （可选）加载完成回调。
	*/
	__proto.loadImage=function(url,x,y,width,height,complete){
		var _$this=this;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		var tex=Loader.getRes(url);
		if (tex)onloaded(tex);
		else Laya.loader.load(url,Handler.create(null,onloaded),null,"image");
		function onloaded (tex){
			if (tex){
				_$this.drawTexture(tex,x,y,width,height);
				if (complete !=null)complete.call(_$this._sp,tex);
			}
		}
	}

	/**
	*@private
	*/
	__proto._renderEmpty=function(sprite,context,x,y){}
	/**
	*@private
	*/
	__proto._renderAll=function(sprite,context,x,y){
		var cmds=this._cmds,cmd;
		for (var i=0,n=cmds.length;i < n;i++){
			(cmd=cmds[i]).callee.call(context,x,y,cmd);
		}
	}

	/**
	*@private
	*/
	__proto._renderOne=function(sprite,context,x,y){
		this._one.callee.call(context,x,y,this._one);
	}

	/**
	*@private
	*/
	__proto._renderOneImg=function(sprite,context,x,y){
		this._one.callee.call(context,x,y,this._one);
		if (sprite._renderType!==2305){
			sprite._renderType |=0x01;
		}
	}

	/**
	*绘制一条线。
	*@param fromX X轴开始位置。
	*@param fromY Y轴开始位置。
	*@param toX X轴结束位置。
	*@param toY Y轴结束位置。
	*@param lineColor 颜色。
	*@param lineWidth （可选）线条宽度。
	*/
	__proto.drawLine=function(fromX,fromY,toX,toY,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var tId=0;
		if (Render.isWebGL){
			tId=VectorGraphManager.getInstance().getId();
			if (this._vectorgraphArray==null)this._vectorgraphArray=[];
			this._vectorgraphArray.push(tId);
		};
		var offset=lineWidth % 2===0 ? 0 :0.5;
		var arr=[fromX+offset,fromY+offset,toX+offset,toY+offset,lineColor,lineWidth,tId];
		this._saveToCmd(Render._context._drawLine,arr);
	}

	/**
	*绘制一系列线段。
	*@param x 开始绘制的X轴位置。
	*@param y 开始绘制的Y轴位置。
	*@param points 线段的点集合。格式:[x1,y1,x2,y2,x3,y3...]。
	*@param lineColor 线段颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）线段宽度。
	*/
	__proto.drawLines=function(x,y,points,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var tId=0;
		if (!points || points.length < 4)return;
		if (Render.isWebGL){
			tId=VectorGraphManager.getInstance().getId();
			if (this._vectorgraphArray==null)this._vectorgraphArray=[];
			this._vectorgraphArray.push(tId);
		};
		var offset=lineWidth % 2===0 ? 0 :0.5;
		var arr=[x+offset,y+offset,points,lineColor,lineWidth,tId];
		this._saveToCmd(Render._context._drawLines,arr);
	}

	/**
	*绘制一系列曲线。
	*@param x 开始绘制的 X 轴位置。
	*@param y 开始绘制的 Y 轴位置。
	*@param points 线段的点集合，格式[startx,starty,ctrx,ctry,startx,starty...]。
	*@param lineColor 线段颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）线段宽度。
	*/
	__proto.drawCurves=function(x,y,points,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var arr=[x,y,points,lineColor,lineWidth];
		this._saveToCmd(Render._context._drawCurves,arr);
	}

	/**
	*绘制矩形。
	*@param x 开始绘制的 X 轴位置。
	*@param y 开始绘制的 Y 轴位置。
	*@param width 矩形宽度。
	*@param height 矩形高度。
	*@param fillColor 填充颜色，或者填充绘图的渐变对象。
	*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）边框宽度。
	*/
	__proto.drawRect=function(x,y,width,height,fillColor,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var offset=lineColor ? lineWidth / 2 :0;
		var lineOffset=lineColor ? lineWidth :0;
		var arr=[x+offset,y+offset,width-lineOffset,height-lineOffset,fillColor,lineColor,lineWidth];
		this._saveToCmd(Render._context._drawRect,arr);
	}

	/**
	*绘制圆形。
	*@param x 圆点X 轴位置。
	*@param y 圆点Y 轴位置。
	*@param radius 半径。
	*@param fillColor 填充颜色，或者填充绘图的渐变对象。
	*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）边框宽度。
	*/
	__proto.drawCircle=function(x,y,radius,fillColor,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var offset=lineColor ? lineWidth / 2 :0;
		var tId=0;
		if (Render.isWebGL){
			tId=VectorGraphManager.getInstance().getId();
			if (this._vectorgraphArray==null)this._vectorgraphArray=[];
			this._vectorgraphArray.push(tId);
		};
		var arr=[x,y,radius-offset,fillColor,lineColor,lineWidth,tId];
		this._saveToCmd(Render._context._drawCircle,arr);
	}

	/**
	*绘制扇形。
	*@param x 开始绘制的 X 轴位置。
	*@param y 开始绘制的 Y 轴位置。
	*@param radius 扇形半径。
	*@param startAngle 开始角度。
	*@param endAngle 结束角度。
	*@param fillColor 填充颜色，或者填充绘图的渐变对象。
	*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）边框宽度。
	*/
	__proto.drawPie=function(x,y,radius,startAngle,endAngle,fillColor,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var offset=lineColor ? lineWidth / 2 :0;
		var lineOffset=lineColor ? lineWidth :0;
		var tId=0;
		if (Render.isWebGL){
			tId=VectorGraphManager.getInstance().getId();
			if (this._vectorgraphArray==null)this._vectorgraphArray=[];
			this._vectorgraphArray.push(tId);
		};
		var arr=[x+offset,y+offset,radius-lineOffset,startAngle,endAngle,fillColor,lineColor,lineWidth,tId];
		arr[3]=Utils.toRadian(startAngle);
		arr[4]=Utils.toRadian(endAngle);
		this._saveToCmd(Render._context._drawPie,arr);
	}

	/**
	*绘制多边形。
	*@param x 开始绘制的 X 轴位置。
	*@param y 开始绘制的 Y 轴位置。
	*@param points 多边形的点集合。
	*@param fillColor 填充颜色，或者填充绘图的渐变对象。
	*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
	*@param lineWidth （可选）边框宽度。
	*/
	__proto.drawPoly=function(x,y,points,fillColor,lineColor,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var tId=0;
		var tIsConvexPolygon=false;
		if (Render.isWebGL){
			tId=VectorGraphManager.getInstance().getId();
			if (this._vectorgraphArray==null)this._vectorgraphArray=[];
			this._vectorgraphArray.push(tId);
			if (points.length > 6){
				tIsConvexPolygon=false;
				}else {
				tIsConvexPolygon=true;
			}
		};
		var offset=lineColor ? (lineWidth % 2===0 ? 0 :0.5):0;
		var arr=[x+offset,y+offset,points,fillColor,lineColor,lineWidth,tId,tIsConvexPolygon];
		this._saveToCmd(Render._context._drawPoly,arr);
	}

	/**
	*绘制路径。
	*@param x 开始绘制的 X 轴位置。
	*@param y 开始绘制的 Y 轴位置。
	*@param paths 路径集合，路径支持以下格式：[["moveTo",x,y],["lineTo",x,y,x,y,x,y],["arcTo",x1,y1,x2,y2,r],["closePath"]]。
	*@param brush （可选）刷子定义，支持以下设置{fillStyle}。
	*@param pen （可选）画笔定义，支持以下设置{strokeStyle,lineWidth,lineJoin,lineCap,miterLimit}。
	*/
	__proto.drawPath=function(x,y,paths,brush,pen){
		var arr=[x,y,paths,brush,pen];
		this._saveToCmd(Render._context._drawPath,arr);
	}

	/**
	*@private
	*命令流。存储了所有绘制命令。
	*/
	__getset(0,__proto,'cmds',function(){
		return this._cmds;
		},function(value){
		this._sp && (this._sp._renderType |=0x200);
		this._cmds=value;
		this._render=this._renderAll;
		this._repaint();
	});

	Graphics.__init__=function(){
		if (Render.isConchNode){
			var from=laya.display.Graphics.prototype;
			var to=Browser.window.ConchGraphics.prototype;
			var list=["clear","destroy","alpha","rotate","transform","scale","translate","save","restore","clipRect","blendMode","fillText","fillBorderText","_fands","drawRect","drawCircle","drawPie","drawPoly","drawPath","drawImageM","drawLine","drawLines","_drawPs","drawCurves","replaceText","replaceTextColor","_fillImage","fillTexture","setSkinMesh","drawParticle","drawImageS"];
			for (var i=0,len=list.length;i <=len;i++){
				var temp=list[i];
				from[temp]=to[temp];
			}
			from._saveToCmd=null;
			if (to.drawImageS){
				from.drawTextures=function (tex,pos){
					if (!tex)return;
					if (!(tex.loaded && tex.bitmap && tex.source)){
						return;
					};
					var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
					this.drawImageS(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,tex.offsetX,tex.offsetY,tex.width,tex.height,pos);
				}
			}
			from.drawTexture=function (tex,x,y,width,height,m,alpha){
				(x===void 0)&& (x=0);
				(y===void 0)&& (y=0);
				(width===void 0)&& (width=0);
				(height===void 0)&& (height=0);
				(alpha===void 0)&& (alpha=1);
				if (!tex)return;
				if (!tex.loaded){
					tex.once("loaded",this,function(){
						this.drawTexture(tex,x,y,width,height,m);
					});
					return;
				}
				if (!(tex.loaded && tex.bitmap && tex.source)){
					return;
				}
				if (!width)width=tex.sourceWidth;
				if (!height)height=tex.sourceHeight;
				alpha=alpha < 0 ? 0 :(alpha > 1 ? 1 :alpha);
				width=width-tex.sourceWidth+tex.width;
				height=height-tex.sourceHeight+tex.height;
				if (width <=0 || height <=0)return;
				x+=tex.offsetX;
				y+=tex.offsetY;
				var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
				this.drawImageM(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x,y,width,height,m,alpha);
				this._repaint();
			}
			from.fillTexture=function (tex,x,y,width,height,type,offset){
				(width===void 0)&& (width=0);
				(height===void 0)&& (height=0);
				(type===void 0)&& (type="repeat");
				if (!tex)return;
				if (tex.loaded){
					var ctxi=Render._context.ctx;
					var w=tex.bitmap.width,h=tex.bitmap.height,uv=tex.uv;
					var pat;
					if (tex.uv !=Texture.DEF_UV){
						pat=ctxi.createPattern(tex.bitmap.source,type,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h);
						}else {
						pat=ctxi.createPattern(tex.bitmap.source,type);
					};
					var sX=0,sY=0;
					if (offset){
						x+=offset.x % tex.width;
						y+=offset.y % tex.height;
						sX-=offset.x % tex.width;
						sY-=offset.y % tex.height;
					}
					this._fillImage(pat,x,y,sX,sY,width,height);
				}
			}
		}
	}

	Graphics._cache=[];
	return Graphics;
})()


/**
*@private
*Graphic bounds数据类
*/
//class laya.display.GraphicsBounds
var GraphicsBounds=(function(){
	function GraphicsBounds(){
		/**@private */
		//this._temp=null;
		/**@private */
		//this._bounds=null;
		/**@private */
		//this._rstBoundPoints=null;
		/**@private */
		this._cacheBoundsType=false;
		/**@private */
		//this._graphics=null;
	}

	__class(GraphicsBounds,'laya.display.GraphicsBounds');
	var __proto=GraphicsBounds.prototype;
	/**
	*销毁
	*/
	__proto.destroy=function(){
		this._graphics=null;
		this._temp=null;
		this._rstBoundPoints=null;
		this._bounds=null;
	}

	/**
	*重置数据
	*/
	__proto.reset=function(){
		this._temp && (this._temp.length=0);
	}

	/**
	*获取位置及宽高信息矩阵(比较耗CPU，频繁使用会造成卡顿，尽量少用)。
	*@param realSize （可选）使用图片的真实大小，默认为false
	*@return 位置与宽高组成的 一个 Rectangle 对象。
	*/
	__proto.getBounds=function(realSize){
		(realSize===void 0)&& (realSize=false);
		if (!this._bounds || !this._temp || this._temp.length < 1 || realSize !=this._cacheBoundsType){
			this._bounds=Rectangle._getWrapRec(this.getBoundPoints(realSize),this._bounds)
		}
		this._cacheBoundsType=realSize;
		return this._bounds;
	}

	/**
	*@private
	*@param realSize （可选）使用图片的真实大小，默认为false
	*获取端点列表。
	*/
	__proto.getBoundPoints=function(realSize){
		(realSize===void 0)&& (realSize=false);
		if (!this._temp || this._temp.length < 1 || realSize !=this._cacheBoundsType)
			this._temp=this._getCmdPoints(realSize);
		this._cacheBoundsType=realSize;
		return this._rstBoundPoints=Utils.copyArray(this._rstBoundPoints,this._temp);
	}

	__proto._getCmdPoints=function(realSize){
		(realSize===void 0)&& (realSize=false);
		var context=Render._context;
		var cmds=this._graphics.cmds;
		var rst;
		rst=this._temp || (this._temp=[]);
		rst.length=0;
		if (!cmds && this._graphics._one !=null){
			GraphicsBounds._tempCmds.length=0;
			GraphicsBounds._tempCmds.push(this._graphics._one);
			cmds=GraphicsBounds._tempCmds;
		}
		if (!cmds)
			return rst;
		var matrixs;
		matrixs=GraphicsBounds._tempMatrixArrays;
		matrixs.length=0;
		var tMatrix=GraphicsBounds._initMatrix;
		tMatrix.identity();
		var tempMatrix=GraphicsBounds._tempMatrix;
		var cmd;
		var tex;
		var wRate=NaN;
		var hRate=NaN;
		var oWidth=NaN;
		var oHeight=NaN;
		var offX=NaN;
		var offY=NaN;
		for (var i=0,n=cmds.length;i < n;i++){
			cmd=cmds[i];
			if (!cmd.callee)continue ;
			switch (cmd.callee){
				case context._save:
				case 7:
					matrixs.push(tMatrix);
					tMatrix=tMatrix.clone();
					break ;
				case context._restore:
				case 8:
					tMatrix=matrixs.pop();
					break ;
				case context._scale:
				case 5:
					tempMatrix.identity();
					tempMatrix.translate(-cmd[2],-cmd[3]);
					tempMatrix.scale(cmd[0],cmd[1]);
					tempMatrix.translate(cmd[2],cmd[3]);
					this._switchMatrix(tMatrix,tempMatrix);
					break ;
				case context._rotate:
				case 3:
					tempMatrix.identity();
					tempMatrix.translate(-cmd[1],-cmd[2]);
					tempMatrix.rotate(cmd[0]);
					tempMatrix.translate(cmd[1],cmd[2]);
					this._switchMatrix(tMatrix,tempMatrix);
					break ;
				case context._translate:
				case 6:
					tempMatrix.identity();
					tempMatrix.translate(cmd[0],cmd[1]);
					this._switchMatrix(tMatrix,tempMatrix);
					break ;
				case context._transform:
				case 4:
					tempMatrix.identity();
					tempMatrix.translate(-cmd[1],-cmd[2]);
					tempMatrix.concat(cmd[0]);
					tempMatrix.translate(cmd[1],cmd[2]);
					this._switchMatrix(tMatrix,tempMatrix);
					break ;
				case 16:
				case 24:
					GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
					break ;
				case 17:
					tMatrix.copyTo(tempMatrix);
					tempMatrix.concat(cmd[4]);
					GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tempMatrix);
					break ;
				case context._drawTexture:
					tex=cmd[0];
					if (realSize){
						if (cmd[3] && cmd[4]){
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
							}else {
							tex=cmd[0];
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),tMatrix);
						}
						}else {
						wRate=(cmd[3] || tex.sourceWidth)/ tex.width;
						hRate=(cmd[4] || tex.sourceHeight)/ tex.height;
						oWidth=wRate *tex.sourceWidth;
						oHeight=hRate *tex.sourceHeight;
						offX=tex.offsetX > 0 ? tex.offsetX :0;
						offY=tex.offsetY > 0 ? tex.offsetY :0;
						offX *=wRate;
						offY *=hRate;
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1]-offX,cmd[2]-offY,oWidth,oHeight),tMatrix);
					}
					break ;
				case context._fillTexture:
					if (cmd[3] && cmd[4]){
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
						}else {
						tex=cmd[0];
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),tMatrix);
					}
					break ;
				case context._drawTextureWithTransform:;
					var drawMatrix;
					if (cmd[5]){
						tMatrix.copyTo(tempMatrix);
						tempMatrix.concat(cmd[5]);
						drawMatrix=tempMatrix;
						}else {
						drawMatrix=tMatrix;
					}
					if (realSize){
						if (cmd[3] && cmd[4]){
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),drawMatrix);
							}else {
							tex=cmd[0];
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),drawMatrix);
						}
						}else {
						tex=cmd[0];
						wRate=(cmd[3] || tex.sourceWidth)/ tex.width;
						hRate=(cmd[4] || tex.sourceHeight)/ tex.height;
						oWidth=wRate *tex.sourceWidth;
						oHeight=hRate *tex.sourceHeight;
						offX=tex.offsetX > 0 ? tex.offsetX :0;
						offY=tex.offsetY > 0 ? tex.offsetY :0;
						offX *=wRate;
						offY *=hRate;
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1]-offX,cmd[2]-offY,oWidth,oHeight),drawMatrix);
					}
					break ;
				case context._drawRect:
				case 13:
					GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
					break ;
				case context._drawCircle:
				case context._fillCircle:
				case 14:
					GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0]-cmd[2],cmd[1]-cmd[2],cmd[2]+cmd[2],cmd[2]+cmd[2]),tMatrix);
					break ;
				case context._drawLine:
				case 20:
					GraphicsBounds._tempPoints.length=0;
					var lineWidth=NaN;
					lineWidth=cmd[5] *0.5;
					if (cmd[0]==cmd[2]){
						GraphicsBounds._tempPoints.push(cmd[0]+lineWidth,cmd[1],cmd[2]+lineWidth,cmd[3],cmd[0]-lineWidth,cmd[1],cmd[2]-lineWidth,cmd[3]);
						}else if (cmd[1]==cmd[3]){
						GraphicsBounds._tempPoints.push(cmd[0],cmd[1]+lineWidth,cmd[2],cmd[3]+lineWidth,cmd[0],cmd[1]-lineWidth,cmd[2],cmd[3]-lineWidth);
						}else {
						GraphicsBounds._tempPoints.push(cmd[0],cmd[1],cmd[2],cmd[3]);
					}
					GraphicsBounds._addPointArrToRst(rst,GraphicsBounds._tempPoints,tMatrix);
					break ;
				case context._drawCurves:
				case 22:
					GraphicsBounds._addPointArrToRst(rst,Bezier.I.getBezierPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
					break ;
				case context._drawPoly:
				case context._drawLines:
				case 18:
					GraphicsBounds._addPointArrToRst(rst,cmd[2],tMatrix,cmd[0],cmd[1]);
					break ;
				case context._drawPath:
				case 19:
					GraphicsBounds._addPointArrToRst(rst,this._getPathPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
					break ;
				case context._drawPie:
				case 15:
					GraphicsBounds._addPointArrToRst(rst,this._getPiePoints(cmd[0],cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
					break ;
				}
		}
		if (rst.length > 200){
			rst=Utils.copyArray(rst,Rectangle._getWrapRec(rst)._getBoundPoints());
		}else if (rst.length > 8)
		rst=GrahamScan.scanPList(rst);
		return rst;
	}

	__proto._switchMatrix=function(tMatix,tempMatrix){
		tempMatrix.concat(tMatix);
		tempMatrix.copyTo(tMatix);
	}

	__proto._getPiePoints=function(x,y,radius,startAngle,endAngle){
		var rst=GraphicsBounds._tempPoints;
		GraphicsBounds._tempPoints.length=0;
		rst.push(x,y);
		var delta=(endAngle-startAngle)% (2 *Math.PI);
		var segnum=10;
		var step=delta / segnum;
		var i=NaN;
		var angle=startAngle;
		for (i=0;i <=segnum;i++){
			rst.push(x+radius *Math.cos(angle),y+radius *Math.sin(angle));
			angle+=step;
		}
		return rst;
	}

	__proto._getPathPoints=function(paths){
		var i=0,len=0;
		var rst=GraphicsBounds._tempPoints;
		rst.length=0;
		len=paths.length;
		var tCMD;
		for (i=0;i < len;i++){
			tCMD=paths[i];
			if (tCMD.length > 1){
				rst.push(tCMD[1],tCMD[2]);
				if (tCMD.length > 3){
					rst.push(tCMD[3],tCMD[4]);
				}
			}
		}
		return rst;
	}

	GraphicsBounds._addPointArrToRst=function(rst,points,matrix,dx,dy){
		(dx===void 0)&& (dx=0);
		(dy===void 0)&& (dy=0);
		var i=0,len=0;
		len=points.length;
		for (i=0;i < len;i+=2){
			GraphicsBounds._addPointToRst(rst,points[i]+dx,points[i+1]+dy,matrix);
		}
	}

	GraphicsBounds._addPointToRst=function(rst,x,y,matrix){
		var _tempPoint=Point.TEMP;
		_tempPoint.setTo(x ? x :0,y ? y :0);
		matrix.transformPoint(_tempPoint);
		rst.push(_tempPoint.x,_tempPoint.y);
	}

	GraphicsBounds._tempPoints=[];
	GraphicsBounds._tempMatrixArrays=[];
	GraphicsBounds._tempCmds=[];
	__static(GraphicsBounds,
	['_tempMatrix',function(){return this._tempMatrix=new Matrix();},'_initMatrix',function(){return this._initMatrix=new Matrix();}
	]);
	return GraphicsBounds;
})()


/**
*<code>Event</code> 是事件类型的集合。一般当发生事件时，<code>Event</code> 对象将作为参数传递给事件侦听器。
*/
//class laya.events.Event
var Event=(function(){
	function Event(){
		/**事件类型。*/
		//this.type=null;
		/**原生浏览器事件。*/
		//this.nativeEvent=null;
		/**事件目标触发对象。*/
		//this.target=null;
		/**事件当前冒泡对象。*/
		//this.currentTarget=null;
		/**@private */
		//this._stoped=false;
		/**分配给触摸点的唯一标识号（作为 int）。*/
		//this.touchId=0;
		/**键盘值*/
		//this.keyCode=0;
		/**滚轮滑动增量*/
		//this.delta=0;
	}

	__class(Event,'laya.events.Event');
	var __proto=Event.prototype;
	/**
	*设置事件数据。
	*@param type 事件类型。
	*@param currentTarget 事件目标触发对象。
	*@param target 事件当前冒泡对象。
	*@return 返回当前 Event 对象。
	*/
	__proto.setTo=function(type,currentTarget,target){
		this.type=type;
		this.currentTarget=currentTarget;
		this.target=target;
		return this;
	}

	/**
	*阻止对事件流中当前节点的后续节点中的所有事件侦听器进行处理。此方法不会影响当前节点 (currentTarget)中的任何事件侦听器。
	*/
	__proto.stopPropagation=function(){
		this._stoped=true;
	}

	/**鼠标在 Stage 上的 Y 轴坐标*/
	__getset(0,__proto,'stageY',function(){
		return Laya.stage.mouseY;
	});

	/**
	*包含按下或释放的键的字符代码值。字符代码值为英文键盘值。
	*/
	__getset(0,__proto,'charCode',function(){
		return this.nativeEvent.charCode;
	});

	/**
	*触摸点列表。
	*/
	__getset(0,__proto,'touches',function(){
		var arr=this.nativeEvent.touches;
		if (arr){
			var stage=Laya.stage;
			for (var i=0,n=arr.length;i < n;i++){
				var e=arr[i];
				var point=Point.TEMP;
				point.setTo(e.clientX,e.clientY);
				stage._canvasTransform.invertTransformPoint(point);
				stage.transform.invertTransformPoint(point);
				e.stageX=point.x;
				e.stageY=point.y;
			}
		}
		return arr;
	});

	/**
	*表示键在键盘上的位置。这对于区分在键盘上多次出现的键非常有用。<br>
	*例如，您可以根据此属性的值来区分左 Shift 键和右 Shift 键：左 Shift 键的值为 KeyLocation.LEFT，右 Shift 键的值为 KeyLocation.RIGHT。另一个示例是区分标准键盘 (KeyLocation.STANDARD)与数字键盘 (KeyLocation.NUM_PAD)上按下的数字键。
	*/
	__getset(0,__proto,'keyLocation',function(){
		return this.nativeEvent.keyLocation;
	});

	/**
	*表示 Ctrl 键是处于活动状态 (true)还是非活动状态 (false)。
	*/
	__getset(0,__proto,'ctrlKey',function(){
		return this.nativeEvent.ctrlKey;
	});

	/**
	*表示 Alt 键是处于活动状态 (true)还是非活动状态 (false)。
	*/
	__getset(0,__proto,'altKey',function(){
		return this.nativeEvent.altKey;
	});

	/**
	*表示 Shift 键是处于活动状态 (true)还是非活动状态 (false)。
	*/
	__getset(0,__proto,'shiftKey',function(){
		return this.nativeEvent.shiftKey;
	});

	/**鼠标在 Stage 上的 X 轴坐标*/
	__getset(0,__proto,'stageX',function(){
		return Laya.stage.mouseX;
	});

	Event.MOUSE_DOWN="mousedown";
	Event.MOUSE_UP="mouseup";
	Event.CLICK="click";
	Event.RIGHT_MOUSE_DOWN="rightmousedown";
	Event.RIGHT_MOUSE_UP="rightmouseup";
	Event.RIGHT_CLICK="rightclick";
	Event.MOUSE_MOVE="mousemove";
	Event.MOUSE_OVER="mouseover";
	Event.MOUSE_OUT="mouseout";
	Event.MOUSE_WHEEL="mousewheel";
	Event.ROLL_OVER="mouseover";
	Event.ROLL_OUT="mouseout";
	Event.DOUBLE_CLICK="doubleclick";
	Event.CHANGE="change";
	Event.CHANGED="changed";
	Event.RESIZE="resize";
	Event.ADDED="added";
	Event.REMOVED="removed";
	Event.DISPLAY="display";
	Event.UNDISPLAY="undisplay";
	Event.ERROR="error";
	Event.COMPLETE="complete";
	Event.LOADED="loaded";
	Event.PROGRESS="progress";
	Event.INPUT="input";
	Event.RENDER="render";
	Event.OPEN="open";
	Event.MESSAGE="message";
	Event.CLOSE="close";
	Event.KEY_DOWN="keydown";
	Event.KEY_PRESS="keypress";
	Event.KEY_UP="keyup";
	Event.FRAME="enterframe";
	Event.DRAG_START="dragstart";
	Event.DRAG_MOVE="dragmove";
	Event.DRAG_END="dragend";
	Event.ENTER="enter";
	Event.SELECT="select";
	Event.BLUR="blur";
	Event.FOCUS="focus";
	Event.VISIBILITY_CHANGE="visibilitychange";
	Event.FOCUS_CHANGE="focuschange";
	Event.PLAYED="played";
	Event.PAUSED="paused";
	Event.STOPPED="stopped";
	Event.START="start";
	Event.END="end";
	Event.ENABLE_CHANGED="enablechanged";
	Event.ACTIVE_IN_HIERARCHY_CHANGED="activeinhierarchychanged";
	Event.COMPONENT_ADDED="componentadded";
	Event.COMPONENT_REMOVED="componentremoved";
	Event.LAYER_CHANGED="layerchanged";
	Event.HIERARCHY_LOADED="hierarchyloaded";
	Event.RECOVERED="recovered";
	Event.RELEASED="released";
	Event.LINK="link";
	Event.LABEL="label";
	Event.FULL_SCREEN_CHANGE="fullscreenchange";
	Event.DEVICE_LOST="devicelost";
	Event.MESH_CHANGED="meshchanged";
	Event.MATERIAL_CHANGED="materialchanged";
	Event.WORLDMATRIX_NEEDCHANGE="worldmatrixneedchanged";
	Event.ANIMATION_CHANGED="animationchanged";
	Event.TRIGGER_ENTER="triggerenter";
	Event.TRIGGER_STAY="triggerstay";
	Event.TRIGGER_EXIT="triggerexit";
	Event.TRAIL_Filter_CHANGE="trailfilterchange";
	__static(Event,
	['EMPTY',function(){return this.EMPTY=new Event();}
	]);
	return Event;
})()


/**
*<p><code>KeyBoardManager</code> 是键盘事件管理类。该类从浏览器中接收键盘事件，并派发该事件。</p>
*<p>派发事件时若 Stage.focus 为空则只从 Stage 上派发该事件，否则将从 Stage.focus 对象开始一直冒泡派发该事件。所以在 Laya.stage 上监听键盘事件一定能够收到，如果在其他地方监听，则必须处在Stage.focus的冒泡链上才能收到该事件。</p>
*<p>用户可以通过代码 Laya.stage.focus=someNode 的方式来设置focus对象。</p>
*<p>用户可统一的根据事件对象中 e.keyCode 来判断按键类型，该属性兼容了不同浏览器的实现。</p>
*/
//class laya.events.KeyBoardManager
var KeyBoardManager=(function(){
	function KeyBoardManager(){}
	__class(KeyBoardManager,'laya.events.KeyBoardManager');
	KeyBoardManager.__init__=function(){
		KeyBoardManager._addEvent("keydown");
		KeyBoardManager._addEvent("keypress");
		KeyBoardManager._addEvent("keyup");
	}

	KeyBoardManager._addEvent=function(type){
		Browser.document.addEventListener(type,function(e){
			laya.events.KeyBoardManager._dispatch(e,type);
		},true);
	}

	KeyBoardManager._dispatch=function(e,type){
		if (!KeyBoardManager.enabled)return;
		KeyBoardManager._event._stoped=false;
		KeyBoardManager._event.nativeEvent=e;
		KeyBoardManager._event.keyCode=e.keyCode || e.which || e.charCode;
		if (type==="keydown")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=true;
		else if (type==="keyup")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=null;
		var target=(Laya.stage.focus && (Laya.stage.focus.event !=null)&& Laya.stage.focus.displayedInStage)? Laya.stage.focus :Laya.stage;
		var ct=target;
		while (ct){
			ct.event(type,KeyBoardManager._event.setTo(type,ct,target));
			ct=ct.parent;
		}
	}

	KeyBoardManager.hasKeyDown=function(key){
		return KeyBoardManager._pressKeys[key];
	}

	KeyBoardManager._pressKeys={};
	KeyBoardManager.enabled=true;
	__static(KeyBoardManager,
	['_event',function(){return this._event=new Event();}
	]);
	return KeyBoardManager;
})()


/**
*<p><code>MouseManager</code> 是鼠标、触摸交互管理器。</p>
*<p>鼠标事件流包括捕获阶段、目标阶段、冒泡阶段。<br/>
*捕获阶段：此阶段引擎会从stage开始递归检测stage及其子对象，直到找到命中的目标对象或者未命中任何对象；<br/>
*目标阶段：找到命中的目标对象；<br/>
*冒泡阶段：事件离开目标对象，按节点层级向上逐层通知，直到到达舞台的过程。</p>
*/
//class laya.events.MouseManager
var MouseManager=(function(){
	function MouseManager(){
		/**canvas 上的鼠标X坐标。*/
		this.mouseX=0;
		/**canvas 上的鼠标Y坐标。*/
		this.mouseY=0;
		/**是否禁用除 stage 以外的鼠标事件检测。*/
		this.disableMouseEvent=false;
		/**鼠标按下的时间。单位为毫秒。*/
		this.mouseDownTime=0;
		/**鼠标移动精度。*/
		this.mouseMoveAccuracy=2;
		this._stage=null;
		this._target=null;
		this._lastMoveTimer=0;
		this._isLeftMouse=false;
		this._eventList=[];
		this._touchIDs={};
		this._id=1;
		this._tTouchID=0;
		this._event=new Event();
		this._matrix=new Matrix();
		this._point=new Point();
		this._rect=new Rectangle();
		this._prePoint=new Point();
		this._curTouchID=NaN;
	}

	__class(MouseManager,'laya.events.MouseManager');
	var __proto=MouseManager.prototype;
	/**
	*@private
	*初始化。
	*/
	__proto.__init__=function(stage,canvas){
		var _$this=this;
		this._stage=stage;
		var _this=this;
		var list=this._eventList;
		canvas.oncontextmenu=function (e){
			if (MouseManager.enabled)return false;
		}
		canvas.addEventListener('mousedown',function(e){
			if (MouseManager.enabled){
				if(!Browser.onIE)e.preventDefault();
				list.push(e);
				_this.mouseDownTime=Browser.now();
			}
		});
		canvas.addEventListener('mouseup',function(e){
			if (MouseManager.enabled){
				e.preventDefault();
				list.push(e);
				_this.mouseDownTime=-Browser.now();
			}
		},true);
		canvas.addEventListener('mousemove',function(e){
			if (MouseManager.enabled){
				e.preventDefault();
				var now=Browser.now();
				if (now-_this._lastMoveTimer < 10)return;
				_this._lastMoveTimer=now;
				list.push(e);
			}
		},true);
		canvas.addEventListener("mouseout",function(e){
			if (MouseManager.enabled)list.push(e);
		})
		canvas.addEventListener("mouseover",function(e){
			if (MouseManager.enabled)list.push(e);
		})
		canvas.addEventListener("touchstart",function(e){
			if (MouseManager.enabled){
				list.push(e);
				if (!MouseManager._isFirstTouch&&!Input.isInputting)e.preventDefault();
				_this.mouseDownTime=Browser.now();
			}
		});
		canvas.addEventListener("touchend",function(e){
			if (MouseManager.enabled){
				if (!MouseManager._isFirstTouch&&!Input.isInputting)e.preventDefault();
				MouseManager._isFirstTouch=false;
				list.push(e);
				_this.mouseDownTime=-Browser.now();
				}else {
				_$this._curTouchID=NaN;
			}
		},true);
		canvas.addEventListener("touchmove",function(e){
			if (MouseManager.enabled){
				e.preventDefault();
				list.push(e);
			}
		},true);
		canvas.addEventListener("touchcancel",function(e){
			if (MouseManager.enabled){
				e.preventDefault();
				list.push(e);
				}else {
				_$this._curTouchID=NaN;
			}
		},true);
		canvas.addEventListener('mousewheel',function(e){
			if (MouseManager.enabled)list.push(e);
		});
		canvas.addEventListener('DOMMouseScroll',function(e){
			if (MouseManager.enabled)list.push(e);
		});
	}

	__proto.initEvent=function(e,nativeEvent){
		var _this=this;
		_this._event._stoped=false;
		_this._event.nativeEvent=nativeEvent || e;
		_this._target=null;
		this._point.setTo(e.pageX || e.clientX,e.pageY || e.clientY);
		this._stage._canvasTransform.invertTransformPoint(this._point);
		_this.mouseX=this._point.x;
		_this.mouseY=this._point.y;
		_this._event.touchId=e.identifier || 0;
		this._tTouchID=_this._event.touchId;
		var evt;
		evt=TouchManager.I._event;
		evt._stoped=false;
		evt.nativeEvent=_this._event.nativeEvent;
		evt.touchId=_this._event.touchId;
	}

	__proto.checkMouseWheel=function(e){
		this._event.delta=e.wheelDelta ? e.wheelDelta *0.025 :-e.detail;
		var _lastOvers=TouchManager.I.getLastOvers();
		for (var i=0,n=_lastOvers.length;i < n;i++){
			var ele=_lastOvers[i];
			ele.event("mousewheel",this._event.setTo("mousewheel",ele,this._target));
		}
	}

	// _stage.event(Event.MOUSE_WHEEL,_event.setTo(Event.MOUSE_WHEEL,_stage,_target));
	__proto.onMouseMove=function(ele){
		TouchManager.I.onMouseMove(ele,this._tTouchID);
	}

	__proto.onMouseDown=function(ele){
		if (Input.isInputting && Laya.stage.focus && Laya.stage.focus["focus"] && !Laya.stage.focus.contains(this._target)){
			var pre_input=Laya.stage.focus['_tf'] || Laya.stage.focus;
			var new_input=ele['_tf'] || ele;
			if ((new_input instanceof laya.display.Input )&& new_input.multiline==pre_input.multiline)
				pre_input['_focusOut']();
			else
			pre_input.focus=false;
		}
		TouchManager.I.onMouseDown(ele,this._tTouchID,this._isLeftMouse);
	}

	__proto.onMouseUp=function(ele){
		TouchManager.I.onMouseUp(ele,this._tTouchID,this._isLeftMouse);
	}

	__proto.check=function(sp,mouseX,mouseY,callBack){
		this._point.setTo(mouseX,mouseY);
		sp.fromParentPoint(this._point);
		mouseX=this._point.x;
		mouseY=this._point.y;
		var scrollRect=sp.scrollRect;
		if (scrollRect){
			this._rect.setTo(scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
			if (!this._rect.contains(mouseX,mouseY))return false;
		}
		if (!this.disableMouseEvent){
			if (sp.hitTestPrior && !sp.mouseThrough && !this.hitTest(sp,mouseX,mouseY)){
				return false;
			}
			for (var i=sp._childs.length-1;i >-1;i--){
				var child=sp._childs[i];
				if (!child.destroyed && child.mouseEnabled && child.visible){
					if (this.check(child,mouseX,mouseY,callBack))return true;
				}
			}
		};
		var isHit=(sp.hitTestPrior && !sp.mouseThrough && !this.disableMouseEvent)? true :this.hitTest(sp,mouseX,mouseY);
		if (isHit){
			this._target=sp;
			callBack.call(this,sp);
			}else if (callBack===this.onMouseUp && sp===this._stage){
			this._target=this._stage;
			callBack.call(this,this._target);
		}
		return isHit;
	}

	__proto.hitTest=function(sp,mouseX,mouseY){
		var isHit=false;
		if (sp.scrollRect){
			mouseX-=sp.scrollRect.x;
			mouseY-=sp.scrollRect.y;
		}
		if ((sp.hitArea instanceof laya.utils.HitArea )){
			return sp.hitArea.isHit(mouseX,mouseY);
		}
		if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || sp.hitArea){
			if (!sp.mouseThrough){
				var hitRect=this._rect;
				if (sp.hitArea)hitRect=sp.hitArea;
				else hitRect.setTo(0,0,sp.width,sp.height);
				isHit=hitRect.contains(mouseX,mouseY);
				}else {
				isHit=sp.getGraphicBounds().contains(mouseX,mouseY);
			}
		}
		return isHit;
	}

	/**
	*执行事件处理。
	*/
	__proto.runEvent=function(){
		var len=this._eventList.length;
		if (!len)return;
		var _this=this;
		var i=0,j=0,n=0,touch;
		while (i < len){
			var evt=this._eventList[i];
			if (evt.type!=='mousemove')this._prePoint.x=this._prePoint.y=-1000000;
			switch (evt.type){
				case 'mousedown':
					this._touchIDs[0]=this._id++;
					if (!MouseManager._isTouchRespond){
						_this._isLeftMouse=evt.button===0;
						_this.initEvent(evt);
						_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
					}else
					MouseManager._isTouchRespond=false;
					break ;
				case 'mouseup':
					_this._isLeftMouse=evt.button===0;
					_this.initEvent(evt);
					_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
					break ;
				case 'mousemove':
					if ((Math.abs(this._prePoint.x-evt.clientX)+Math.abs(this._prePoint.y-evt.clientY))>=this.mouseMoveAccuracy){
						this._prePoint.x=evt.clientX;
						this._prePoint.y=evt.clientY;
						_this.initEvent(evt);
						_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
					}
					break ;
				case "touchstart":
					MouseManager._isTouchRespond=true;
					_this._isLeftMouse=true;
					var touches=evt.changedTouches;
					for (j=0,n=touches.length;j < n;j++){
						touch=touches[j];
						if (MouseManager.multiTouchEnabled || isNaN(this._curTouchID)){
							this._curTouchID=touch.identifier;
							if (this._id % 200===0)this._touchIDs={};
							this._touchIDs[touch.identifier]=this._id++;
							_this.initEvent(touch,evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
						}
					}
					break ;
				case "touchend":
				case "touchcancel":
					MouseManager._isTouchRespond=true;
					_this._isLeftMouse=true;
					var touchends=evt.changedTouches;
					for (j=0,n=touchends.length;j < n;j++){
						touch=touchends[j];
						if (MouseManager.multiTouchEnabled || touch.identifier==this._curTouchID){
							this._curTouchID=NaN;
							_this.initEvent(touch,evt);
							var isChecked=false;
							isChecked=_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
							if (!isChecked){
								_this.onMouseUp(null);
							}
						}
					}
					break ;
				case "touchmove":;
					var touchemoves=evt.changedTouches;
					for (j=0,n=touchemoves.length;j < n;j++){
						touch=touchemoves[j];
						if (MouseManager.multiTouchEnabled || touch.identifier==this._curTouchID){
							_this.initEvent(touch,evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
						}
					}
					break ;
				case "wheel":
				case "mousewheel":
				case "DOMMouseScroll":
					_this.checkMouseWheel(evt);
					break ;
				case "mouseout":
					TouchManager.I.stageMouseOut();
					break ;
				case "mouseover":
					_this._stage.event("mouseover",_this._event.setTo("mouseover",_this._stage,_this._stage));
					break ;
				}
			i++;
		}
		this._eventList.length=0;
	}

	MouseManager.enabled=true;
	MouseManager.multiTouchEnabled=true;
	MouseManager._isTouchRespond=false;
	MouseManager._isFirstTouch=true;
	__static(MouseManager,
	['instance',function(){return this.instance=new MouseManager();}
	]);
	return MouseManager;
})()


/**
*@private
*Touch事件管理类，处理多点触控下的鼠标事件
*/
//class laya.events.TouchManager
var TouchManager=(function(){
	function TouchManager(){
		/**
		*当前over的touch表
		*/
		this.preOvers=[];
		/**
		*当前down的touch表
		*/
		this.preDowns=[];
		this.preRightDowns=[];
		/**
		*是否启用
		*/
		this.enable=true;
		this._lastClickTime=0;
		this._event=new Event();
	}

	__class(TouchManager,'laya.events.TouchManager');
	var __proto=TouchManager.prototype;
	__proto._clearTempArrs=function(){
		TouchManager._oldArr.length=0;
		TouchManager._newArr.length=0;
		TouchManager._tEleArr.length=0;
	}

	/**
	*从touch表里查找对应touchID的数据
	*@param touchID touch ID
	*@param arr touch表
	*@return
	*
	*/
	__proto.getTouchFromArr=function(touchID,arr){
		var i=0,len=0;
		len=arr.length;
		var tTouchO;
		for (i=0;i < len;i++){
			tTouchO=arr[i];
			if (tTouchO.id==touchID){
				return tTouchO;
			}
		}
		return null;
	}

	/**
	*从touch表里移除一个元素
	*@param touchID touch ID
	*@param arr touch表
	*
	*/
	__proto.removeTouchFromArr=function(touchID,arr){
		var i=0;
		for (i=arr.length-1;i >=0;i--){
			if (arr[i].id==touchID){
				arr.splice(i,1);
			}
		}
	}

	/**
	*创建一个touch数据
	*@param ele 当前的根节点
	*@param touchID touchID
	*@return
	*
	*/
	__proto.createTouchO=function(ele,touchID){
		var rst;
		rst=Pool.getItem("TouchData")|| {};
		rst.id=touchID;
		rst.tar=ele;
		return rst;
	}

	/**
	*处理touchStart
	*@param ele 根节点
	*@param touchID touchID
	*@param isLeft （可选）是否为左键
	*/
	__proto.onMouseDown=function(ele,touchID,isLeft){
		(isLeft===void 0)&& (isLeft=false);
		if (!this.enable)
			return;
		var preO;
		var tO;
		var arrs;
		preO=this.getTouchFromArr(touchID,this.preOvers);
		arrs=this.getEles(ele,null,TouchManager._tEleArr);
		if (!preO){
			tO=this.createTouchO(ele,touchID);
			this.preOvers.push(tO);
			}else {
			preO.tar=ele;
		}
		if (Browser.onMobile)
			this.sendEvents(arrs,"mouseover",touchID);
		var preDowns;
		preDowns=isLeft ? this.preDowns :this.preRightDowns;
		preO=this.getTouchFromArr(touchID,preDowns);
		if (!preO){
			tO=this.createTouchO(ele,touchID);
			preDowns.push(tO);
			}else {
			preO.tar=ele;
		}
		this.sendEvents(arrs,isLeft ? "mousedown" :"rightmousedown",touchID);
		this._clearTempArrs();
	}

	/**
	*派发事件。
	*@param eles 对象列表。
	*@param type 事件类型。
	*@param touchID （可选）touchID，默认为0。
	*/
	__proto.sendEvents=function(eles,type,touchID){
		(touchID===void 0)&& (touchID=0);
		var i=0,len=0;
		len=eles.length;
		this._event._stoped=false;
		var _target;
		_target=eles[0];
		var tE;
		for (i=0;i < len;i++){
			tE=eles[i];
			if (tE.destroyed)return;
			tE.event(type,this._event.setTo(type,tE,_target));
			if (this._event._stoped)
				break ;
		}
	}

	/**
	*获取对象列表。
	*@param start 起始节点。
	*@param end 结束节点。
	*@param rst 返回值。如果此值不为空，则将其赋值为计算结果，从而避免创建新数组；如果此值为空，则创建新数组返回。
	*@return Array 返回节点列表。
	*/
	__proto.getEles=function(start,end,rst){
		if (!rst){
			rst=[];
			}else {
			rst.length=0;
		}
		while (start && start !=end){
			rst.push(start);
			start=start.parent;
		}
		return rst;
	}

	/**
	*touchMove时处理out事件和over时间。
	*@param eleNew 新的根节点。
	*@param elePre 旧的根节点。
	*@param touchID （可选）touchID，默认为0。
	*/
	__proto.checkMouseOutAndOverOfMove=function(eleNew,elePre,touchID){
		(touchID===void 0)&& (touchID=0);
		if (elePre==eleNew)
			return;
		var tar;
		var arrs;
		var i=0,len=0;
		if (elePre.contains(eleNew)){
			arrs=this.getEles(eleNew,elePre,TouchManager._tEleArr);
			this.sendEvents(arrs,"mouseover",touchID);
			}else if (eleNew.contains(elePre)){
			arrs=this.getEles(elePre,eleNew,TouchManager._tEleArr);
			this.sendEvents(arrs,"mouseout",touchID);
			}else {
			arrs=TouchManager._tEleArr;
			arrs.length=0;
			var oldArr;
			oldArr=this.getEles(elePre,null,TouchManager._oldArr);
			var newArr;
			newArr=this.getEles(eleNew,null,TouchManager._newArr);
			len=oldArr.length;
			var tIndex=0;
			for (i=0;i < len;i++){
				tar=oldArr[i];
				tIndex=newArr.indexOf(tar);
				if (tIndex >=0){
					newArr.splice(tIndex,newArr.length-tIndex);
					break ;
					}else {
					arrs.push(tar);
				}
			}
			if (arrs.length > 0){
				this.sendEvents(arrs,"mouseout",touchID);
			}
			if (newArr.length > 0){
				this.sendEvents(newArr,"mouseover",touchID);
			}
		}
	}

	/**
	*处理TouchMove事件
	*@param ele 根节点
	*@param touchID touchID
	*
	*/
	__proto.onMouseMove=function(ele,touchID){
		if (!this.enable)
			return;
		var preO;
		preO=this.getTouchFromArr(touchID,this.preOvers);
		var arrs;
		var tO;
		if (!preO){
			arrs=this.getEles(ele,null,TouchManager._tEleArr);
			this.sendEvents(arrs,"mouseover",touchID);
			this.preOvers.push(this.createTouchO(ele,touchID));
			}else {
			this.checkMouseOutAndOverOfMove(ele,preO.tar);
			preO.tar=ele;
			arrs=this.getEles(ele,null,TouchManager._tEleArr);
		}
		this.sendEvents(arrs,"mousemove",touchID);
		this._clearTempArrs();
	}

	__proto.getLastOvers=function(){
		TouchManager._tEleArr.length=0;
		if (this.preOvers.length > 0 && this.preOvers[0].tar){
			return this.getEles(this.preOvers[0].tar,null,TouchManager._tEleArr);
		}
		TouchManager._tEleArr.push(Laya.stage);
		return TouchManager._tEleArr;
	}

	__proto.stageMouseOut=function(){
		var lastOvers;
		lastOvers=this.getLastOvers();
		this.preOvers.length=0;
		this.sendEvents(lastOvers,"mouseout",0);
	}

	/**
	*处理TouchEnd事件
	*@param ele 根节点
	*@param touchID touchID
	*@param isLeft 是否为左键
	*/
	__proto.onMouseUp=function(ele,touchID,isLeft){
		(isLeft===void 0)&& (isLeft=false);
		if (!this.enable)
			return;
		var preO;
		var tO;
		var arrs;
		var oldArr;
		var i=0,len=0;
		var tar;
		var sendArr;
		var onMobile=Browser.onMobile;
		arrs=this.getEles(ele,null,TouchManager._tEleArr);
		this.sendEvents(arrs,isLeft ? "mouseup" :"rightmouseup",touchID);
		var preDowns;
		preDowns=isLeft ? this.preDowns :this.preRightDowns;
		preO=this.getTouchFromArr(touchID,preDowns);
		if (!preO){
			}else {
			var isDouble=false;
			var now=Browser.now();
			isDouble=now-this._lastClickTime < 300;
			this._lastClickTime=now;
			if (ele==preO.tar){
				sendArr=arrs;
				}else {
				oldArr=this.getEles(preO.tar,null,TouchManager._oldArr);
				sendArr=TouchManager._newArr;
				sendArr.length=0;
				len=oldArr.length;
				for (i=0;i < len;i++){
					tar=oldArr[i];
					if (arrs.indexOf(tar)>=0){
						sendArr.push(tar);
					}
				}
			}
			if (sendArr.length > 0){
				this.sendEvents(sendArr,isLeft ? "click" :"rightclick",touchID);
			}
			if (isLeft && isDouble){
				this.sendEvents(sendArr,"doubleclick",touchID);
			}
			this.removeTouchFromArr(touchID,preDowns);
			preO.tar=null;
			Pool.recover("TouchData",preO);
		}
		preO=this.getTouchFromArr(touchID,this.preOvers);
		if (!preO){
			}else {
			if (onMobile){
				sendArr=this.getEles(preO.tar,null,sendArr);
				if (sendArr && sendArr.length > 0){
					this.sendEvents(sendArr,"mouseout",touchID);
				}
				this.removeTouchFromArr(touchID,this.preOvers);
				preO.tar=null;
				Pool.recover("TouchData",preO);
			}
		}
		this._clearTempArrs();
	}

	TouchManager._oldArr=[];
	TouchManager._newArr=[];
	TouchManager._tEleArr=[];
	__static(TouchManager,
	['I',function(){return this.I=new TouchManager();}
	]);
	return TouchManager;
})()


/**
*<code>Filter</code> 是滤镜基类。
*/
//class laya.filters.Filter
var Filter=(function(){
	function Filter(){
		/**@private */
		this._action=null;
	}

	__class(Filter,'laya.filters.Filter');
	var __proto=Filter.prototype;
	Laya.imps(__proto,{"laya.filters.IFilter":true})
	/**@private */
	__proto.callNative=function(sp){}
	/**@private 滤镜类型。*/
	__getset(0,__proto,'type',function(){return-1});
	/**@private 滤镜动作。*/
	__getset(0,__proto,'action',function(){return this._action });
	Filter.BLUR=0x10;
	Filter.COLOR=0x20;
	Filter.GLOW=0x08;
	Filter._filterStart=null;
	Filter._filterEnd=null;
	Filter._EndTarget=null;
	Filter._recycleScope=null;
	Filter._filter=null;
	Filter._useSrc=null;
	Filter._endSrc=null;
	Filter._useOut=null;
	Filter._endOut=null;
	return Filter;
})()


/**
*@private
*<code>ColorFilterAction</code> 是一个颜色滤镜应用类。
*/
//class laya.filters.ColorFilterAction
var ColorFilterAction=(function(){
	function ColorFilterAction(){
		this.data=null;
	}

	__class(ColorFilterAction,'laya.filters.ColorFilterAction');
	var __proto=ColorFilterAction.prototype;
	Laya.imps(__proto,{"laya.filters.IFilterAction":true})
	/**
	*给指定的对象应用颜色滤镜。
	*@param srcCanvas 需要应用画布对象。
	*@return 应用了滤镜后的画布对象。
	*/
	__proto.apply=function(srcCanvas){
		var ctx=srcCanvas.ctx.ctx;
		var canvas=srcCanvas.ctx.ctx.canvas;
		if (canvas.width==0 || canvas.height==0)return canvas;
		var imgdata=ctx.getImageData(0,0,canvas.width,canvas.height);
		var data=imgdata.data;
		var nData;
		for (var i=0,n=data.length;i < n;i+=4){
			nData=this.getColor(data[i],data[i+1],data[i+2],data[i+3]);
			if (data[i+3]==0)continue ;
			data[i]=nData[0];
			data[i+1]=nData[1];
			data[i+2]=nData[2];
			data[i+3]=nData[3];
		}
		ctx.putImageData(imgdata,0,0);
		return srcCanvas;
	}

	__proto.getColor=function(red,green,blue,alpha){
		var rst=[];
		if (this.data._mat && this.data._alpha){
			var mat=this.data._mat;
			var tempAlpha=this.data._alpha;
			rst[0]=mat[0] *red+mat[1] *green+mat[2] *blue+mat[3] *alpha+tempAlpha[0];
			rst[1]=mat[4] *red+mat[5] *green+mat[6] *blue+mat[7] *alpha+tempAlpha[1];
			rst[2]=mat[8] *red+mat[9] *green+mat[10] *blue+mat[11] *alpha+tempAlpha[2];
			rst[3]=mat[12] *red+mat[13] *green+mat[14] *blue+mat[15] *alpha+tempAlpha[3];
		}
		return rst;
	}

	return ColorFilterAction;
})()


/**
*@private
*/
//class laya.maths.Arith
var Arith=(function(){
	function Arith(){}
	__class(Arith,'laya.maths.Arith');
	Arith.formatR=function(r){
		if (r > Math.PI)r-=Math.PI *2;
		if (r <-Math.PI)r+=Math.PI *2;
		return r;
	}

	Arith.isPOT=function(w,h){
		return (w > 0 && (w & (w-1))===0 && h > 0 && (h & (h-1))===0);
	}

	Arith.setMatToArray=function(mat,array){
		mat.a,mat.b,0,0,mat.c,mat.d,0,0,0,0,1,0,mat.tx+20,mat.ty+20,0,1
		array[0]=mat.a;
		array[1]=mat.b;
		array[4]=mat.c;
		array[5]=mat.d;
		array[12]=mat.tx;
		array[13]=mat.ty;
	}

	return Arith;
})()


/**
*@private
*计算贝塞尔曲线的工具类。
*/
//class laya.maths.Bezier
var Bezier=(function(){
	function Bezier(){
		/**@private */
		this._controlPoints=[new Point(),new Point(),new Point()];
		this._calFun=this.getPoint2;
	}

	__class(Bezier,'laya.maths.Bezier');
	var __proto=Bezier.prototype;
	/**@private */
	__proto._switchPoint=function(x,y){
		var tPoint=this._controlPoints.shift();
		tPoint.setTo(x,y);
		this._controlPoints.push(tPoint);
	}

	/**
	*计算二次贝塞尔点。
	*@param t
	*@param rst
	*
	*/
	__proto.getPoint2=function(t,rst){
		var p1=this._controlPoints[0];
		var p2=this._controlPoints[1];
		var p3=this._controlPoints[2];
		var lineX=Math.pow((1-t),2)*p1.x+2 *t *(1-t)*p2.x+Math.pow(t,2)*p3.x;
		var lineY=Math.pow((1-t),2)*p1.y+2 *t *(1-t)*p2.y+Math.pow(t,2)*p3.y;
		rst.push(lineX,lineY);
	}

	/**
	*计算三次贝塞尔点
	*@param t
	*@param rst
	*
	*/
	__proto.getPoint3=function(t,rst){
		var p1=this._controlPoints[0];
		var p2=this._controlPoints[1];
		var p3=this._controlPoints[2];
		var p4=this._controlPoints[3];
		var lineX=Math.pow((1-t),3)*p1.x+3 *p2.x *t *(1-t)*(1-t)+3 *p3.x *t *t *(1-t)+p4.x *Math.pow(t,3);
		var lineY=Math.pow((1-t),3)*p1.y+3 *p2.y *t *(1-t)*(1-t)+3 *p3.y *t *t *(1-t)+p4.y *Math.pow(t,3);
		rst.push(lineX,lineY);
	}

	/**
	*计算贝塞尔点序列
	*@param count
	*@param rst
	*
	*/
	__proto.insertPoints=function(count,rst){
		var i=NaN;
		count=count > 0 ? count :5;
		var dLen=NaN;
		dLen=1 / count;
		for (i=0;i <=1;i+=dLen){
			this._calFun(i,rst);
		}
	}

	/**
	*获取贝塞尔曲线上的点。
	*@param pList 控制点[x0,y0,x1,y1...]
	*@param inSertCount 每次曲线的插值数量
	*@return
	*
	*/
	__proto.getBezierPoints=function(pList,inSertCount,count){
		(inSertCount===void 0)&& (inSertCount=5);
		(count===void 0)&& (count=2);
		var i=0,len=0;
		len=pList.length;
		if (len < (count+1)*2)return [];
		var rst;
		rst=[];
		switch (count){
			case 2:
				this._calFun=this.getPoint2;
				break ;
			case 3:
				this._calFun=this.getPoint3;
				break ;
			default :
				return [];
			}
		while (this._controlPoints.length <=count){
			this._controlPoints.push(new Point());
		}
		for (i=0;i < count *2;i+=2){
			this._switchPoint(pList[i],pList[i+1]);
		}
		for (i=count *2;i < len;i+=2){
			this._switchPoint(pList[i],pList[i+1]);
			if ((i / 2)% count==0)
				this.insertPoints(inSertCount,rst);
		}
		return rst;
	}

	__static(Bezier,
	['I',function(){return this.I=new Bezier();}
	]);
	return Bezier;
})()


/**
*@private
*凸包算法。
*/
//class laya.maths.GrahamScan
var GrahamScan=(function(){
	function GrahamScan(){}
	__class(GrahamScan,'laya.maths.GrahamScan');
	GrahamScan.multiply=function(p1,p2,p0){
		return ((p1.x-p0.x)*(p2.y-p0.y)-(p2.x-p0.x)*(p1.y-p0.y));
	}

	GrahamScan.dis=function(p1,p2){
		return (p1.x-p2.x)*(p1.x-p2.x)+(p1.y-p2.y)*(p1.y-p2.y);
	}

	GrahamScan._getPoints=function(count,tempUse,rst){
		(tempUse===void 0)&& (tempUse=false);
		if (!GrahamScan._mPointList)GrahamScan._mPointList=[];
		while (GrahamScan._mPointList.length < count)GrahamScan._mPointList.push(new Point());
		if (!rst)rst=[];
		rst.length=0;
		if (tempUse){
			GrahamScan.getFrom(rst,GrahamScan._mPointList,count);
			}else {
			GrahamScan.getFromR(rst,GrahamScan._mPointList,count);
		}
		return rst;
	}

	GrahamScan.getFrom=function(rst,src,count){
		var i=0;
		for (i=0;i < count;i++){
			rst.push(src[i]);
		}
		return rst;
	}

	GrahamScan.getFromR=function(rst,src,count){
		var i=0;
		for (i=0;i < count;i++){
			rst.push(src.pop());
		}
		return rst;
	}

	GrahamScan.pListToPointList=function(pList,tempUse){
		(tempUse===void 0)&& (tempUse=false);
		var i=0,len=pList.length / 2,rst=GrahamScan._getPoints(len,tempUse,GrahamScan._tempPointList);
		for (i=0;i < len;i++){
			rst[i].setTo(pList[i+i],pList[i+i+1]);
		}
		return rst;
	}

	GrahamScan.pointListToPlist=function(pointList){
		var i=0,len=pointList.length,rst=GrahamScan._temPList,tPoint;
		rst.length=0;
		for (i=0;i < len;i++){
			tPoint=pointList[i];
			rst.push(tPoint.x,tPoint.y);
		}
		return rst;
	}

	GrahamScan.scanPList=function(pList){
		return Utils.copyArray(pList,GrahamScan.pointListToPlist(GrahamScan.scan(GrahamScan.pListToPointList(pList,true))));
	}

	GrahamScan.scan=function(PointSet){
		var i=0,j=0,k=0,top=2,tmp,n=PointSet.length,ch;
		var _tmpDic={};
		var key;
		ch=GrahamScan._temArr;
		ch.length=0;
		n=PointSet.length;
		for (i=n-1;i >=0;i--){
			tmp=PointSet[i];
			key=tmp.x+"_"+tmp.y;
			if (!_tmpDic.hasOwnProperty(key)){
				_tmpDic[key]=true;
				ch.push(tmp);
			}
		}
		n=ch.length;
		Utils.copyArray(PointSet,ch);
		for (i=1;i < n;i++)
		if ((PointSet[i].y < PointSet[k].y)|| ((PointSet[i].y==PointSet[k].y)&& (PointSet[i].x < PointSet[k].x)))
			k=i;
		tmp=PointSet[0];
		PointSet[0]=PointSet[k];
		PointSet[k]=tmp;
		for (i=1;i < n-1;i++){
			k=i;
			for (j=i+1;j < n;j++)
			if ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])> 0)|| ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])==0)&& (GrahamScan.dis(PointSet[0],PointSet[j])< GrahamScan.dis(PointSet[0],PointSet[k]))))
				k=j;
			tmp=PointSet[i];
			PointSet[i]=PointSet[k];
			PointSet[k]=tmp;
		}
		ch=GrahamScan._temArr;
		ch.length=0;
		if (PointSet.length < 3){
			return Utils.copyArray(ch,PointSet);
		}
		ch.push(PointSet[0],PointSet[1],PointSet[2]);
		for (i=3;i < n;i++){
			while (ch.length >=2 && GrahamScan.multiply(PointSet[i],ch[ch.length-1],ch[ch.length-2])>=0)ch.pop();
			PointSet[i] && ch.push(PointSet[i]);
		}
		return ch;
	}

	GrahamScan._mPointList=null;
	GrahamScan._tempPointList=[];
	GrahamScan._temPList=[];
	GrahamScan._temArr=[];
	return GrahamScan;
})()


/**
*@private
*<code>MathUtil</code> 是一个数据处理工具类。
*/
//class laya.maths.MathUtil
var MathUtil=(function(){
	function MathUtil(){}
	__class(MathUtil,'laya.maths.MathUtil');
	MathUtil.subtractVector3=function(l,r,o){
		o[0]=l[0]-r[0];
		o[1]=l[1]-r[1];
		o[2]=l[2]-r[2];
	}

	MathUtil.lerp=function(left,right,amount){
		return left *(1-amount)+right *amount;
	}

	MathUtil.scaleVector3=function(f,b,e){
		e[0]=f[0] *b;
		e[1]=f[1] *b;
		e[2]=f[2] *b;
	}

	MathUtil.lerpVector3=function(l,r,t,o){
		var ax=l[0],ay=l[1],az=l[2];
		o[0]=ax+t *(r[0]-ax);
		o[1]=ay+t *(r[1]-ay);
		o[2]=az+t *(r[2]-az);
	}

	MathUtil.lerpVector4=function(l,r,t,o){
		var ax=l[0],ay=l[1],az=l[2],aw=l[3];
		o[0]=ax+t *(r[0]-ax);
		o[1]=ay+t *(r[1]-ay);
		o[2]=az+t *(r[2]-az);
		o[3]=aw+t *(r[3]-aw);
	}

	MathUtil.slerpQuaternionArray=function(a,Offset1,b,Offset2,t,out,Offset3){
		var ax=a[Offset1+0],ay=a[Offset1+1],az=a[Offset1+2],aw=a[Offset1+3],bx=b[Offset2+0],by=b[Offset2+1],bz=b[Offset2+2],bw=b[Offset2+3];
		var omega,cosom,sinom,scale0,scale1;
		cosom=ax *bx+ay *by+az *bz+aw *bw;
		if (cosom < 0.0){
			cosom=-cosom;
			bx=-bx;
			by=-by;
			bz=-bz;
			bw=-bw;
		}
		if ((1.0-cosom)> 0.000001){
			omega=Math.acos(cosom);
			sinom=Math.sin(omega);
			scale0=Math.sin((1.0-t)*omega)/ sinom;
			scale1=Math.sin(t *omega)/ sinom;
			}else {
			scale0=1.0-t;
			scale1=t;
		}
		out[Offset3+0]=scale0 *ax+scale1 *bx;
		out[Offset3+1]=scale0 *ay+scale1 *by;
		out[Offset3+2]=scale0 *az+scale1 *bz;
		out[Offset3+3]=scale0 *aw+scale1 *bw;
		return out;
	}

	MathUtil.getRotation=function(x0,y0,x1,y1){
		return Math.atan2(y1-y0,x1-x0)/ Math.PI *180;
	}

	MathUtil.sortBigFirst=function(a,b){
		if (a==b)
			return 0;
		return b > a ? 1 :-1;
	}

	MathUtil.sortSmallFirst=function(a,b){
		if (a==b)
			return 0;
		return b > a ?-1 :1;
	}

	MathUtil.sortNumBigFirst=function(a,b){
		return parseFloat(b)-parseFloat(a);
	}

	MathUtil.sortNumSmallFirst=function(a,b){
		return parseFloat(a)-parseFloat(b);
	}

	MathUtil.sortByKey=function(key,bigFirst,forceNum){
		(bigFirst===void 0)&& (bigFirst=false);
		(forceNum===void 0)&& (forceNum=true);
		var _sortFun;
		if (bigFirst){
			_sortFun=forceNum ? MathUtil.sortNumBigFirst :MathUtil.sortBigFirst;
			}else {
			_sortFun=forceNum ? MathUtil.sortNumSmallFirst :MathUtil.sortSmallFirst;
		}
		return function (a,b){
			return _sortFun(a[key],b[key]);
		}
	}

	return MathUtil;
})()


/**
*<p> <code>Matrix</code> 类表示一个转换矩阵，它确定如何将点从一个坐标空间映射到另一个坐标空间。</p>
*<p>您可以对一个显示对象执行不同的图形转换，方法是设置 Matrix 对象的属性，将该 Matrix 对象应用于 Transform 对象的 matrix 属性，然后应用该 Transform 对象作为显示对象的 transform 属性。这些转换函数包括平移（x 和 y 重新定位）、旋转、缩放和倾斜。</p>
*/
//class laya.maths.Matrix
var Matrix=(function(){
	function Matrix(a,b,c,d,tx,ty){
		/**缩放或旋转图像时影响像素沿 x 轴定位的值。*/
		//this.a=NaN;
		/**旋转或倾斜图像时影响像素沿 y 轴定位的值。*/
		//this.b=NaN;
		/**旋转或倾斜图像时影响像素沿 x 轴定位的值。*/
		//this.c=NaN;
		/**缩放或旋转图像时影响像素沿 y 轴定位的值。*/
		//this.d=NaN;
		/**沿 x 轴平移每个点的距离。*/
		//this.tx=NaN;
		/**沿 y 轴平移每个点的距离。*/
		//this.ty=NaN;
		/**@private 表示此对象是否在对象池中。*/
		this.inPool=false;
		/**@private 是否有改变矩阵的值。*/
		this.bTransform=false;
		(a===void 0)&& (a=1);
		(b===void 0)&& (b=0);
		(c===void 0)&& (c=0);
		(d===void 0)&& (d=1);
		(tx===void 0)&& (tx=0);
		(ty===void 0)&& (ty=0);
		this.a=a;
		this.b=b;
		this.c=c;
		this.d=d;
		this.tx=tx;
		this.ty=ty;
		this._checkTransform();
	}

	__class(Matrix,'laya.maths.Matrix');
	var __proto=Matrix.prototype;
	/**
	*将本矩阵设置为单位矩阵。
	*@return 返回当前矩形。
	*/
	__proto.identity=function(){
		this.a=this.d=1;
		this.b=this.tx=this.ty=this.c=0;
		this.bTransform=false;
		return this;
	}

	/**@private */
	__proto._checkTransform=function(){
		return this.bTransform=(this.a!==1 || this.b!==0 || this.c!==0 || this.d!==1);
	}

	/**
	*设置沿 x 、y 轴平移每个点的距离。
	*@param x 沿 x 轴平移每个点的距离。
	*@param y 沿 y 轴平移每个点的距离。
	*@return 返回对象本身
	*/
	__proto.setTranslate=function(x,y){
		this.tx=x;
		this.ty=y;
		return this;
	}

	/**
	*沿 x 和 y 轴平移矩阵，平移的变化量由 x 和 y 参数指定。
	*@param x 沿 x 轴向右移动的量（以像素为单位）。
	*@param y 沿 y 轴向下移动的量（以像素为单位）。
	*@return 返回此矩形对象。
	*/
	__proto.translate=function(x,y){
		this.tx+=x;
		this.ty+=y;
		return this;
	}

	/**
	*对矩阵应用缩放转换。
	*@param x 用于沿 x 轴缩放对象的乘数。
	*@param y 用于沿 y 轴缩放对象的乘数。
	*/
	__proto.scale=function(x,y){
		this.a *=x;
		this.d *=y;
		this.c *=x;
		this.b *=y;
		this.tx *=x;
		this.ty *=y;
		this.bTransform=true;
	}

	/**
	*对 Matrix 对象应用旋转转换。
	*@param angle 以弧度为单位的旋转角度。
	*/
	__proto.rotate=function(angle){
		var cos=Math.cos(angle);
		var sin=Math.sin(angle);
		var a1=this.a;
		var c1=this.c;
		var tx1=this.tx;
		this.a=a1 *cos-this.b *sin;
		this.b=a1 *sin+this.b *cos;
		this.c=c1 *cos-this.d *sin;
		this.d=c1 *sin+this.d *cos;
		this.tx=tx1 *cos-this.ty *sin;
		this.ty=tx1 *sin+this.ty *cos;
		this.bTransform=true;
	}

	/**
	*对 Matrix 对象应用倾斜转换。
	*@param x 沿着 X 轴的 2D 倾斜弧度。
	*@param y 沿着 Y 轴的 2D 倾斜弧度。
	*@return 当前 Matrix 对象。
	*/
	__proto.skew=function(x,y){
		var tanX=Math.tan(x);
		var tanY=Math.tan(y);
		var a1=this.a;
		var b1=this.b;
		this.a+=tanY *this.c;
		this.b+=tanY *this.d;
		this.c+=tanX *a1;
		this.d+=tanX *b1;
		return this;
	}

	/**
	*对指定的点应用当前矩阵的逆转化并返回此点。
	*@param out 待转化的点 Point 对象。
	*@return 返回out
	*/
	__proto.invertTransformPoint=function(out){
		var a1=this.a;
		var b1=this.b;
		var c1=this.c;
		var d1=this.d;
		var tx1=this.tx;
		var n=a1 *d1-b1 *c1;
		var a2=d1 / n;
		var b2=-b1 / n;
		var c2=-c1 / n;
		var d2=a1 / n;
		var tx2=(c1 *this.ty-d1 *tx1)/ n;
		var ty2=-(a1 *this.ty-b1 *tx1)/ n;
		return out.setTo(a2 *out.x+c2 *out.y+tx2,b2 *out.x+d2 *out.y+ty2);
	}

	/**
	*将 Matrix 对象表示的几何转换应用于指定点。
	*@param out 用来设定输出结果的点。
	*@return 返回out
	*/
	__proto.transformPoint=function(out){
		return out.setTo(this.a *out.x+this.c *out.y+this.tx,this.b *out.x+this.d *out.y+this.ty);
	}

	/**
	*将 Matrix 对象表示的几何转换应用于指定点，忽略tx、ty。
	*@param out 用来设定输出结果的点。
	*@return 返回out
	*/
	__proto.transformPointN=function(out){
		return out.setTo(this.a *out.x+this.c *out.y ,this.b *out.x+this.d *out.y);
	}

	/**
	*@private
	*将 Matrix 对象表示的几何转换应用于指定点。
	*@param data 点集合。
	*@param out 存储应用转化的点的列表。
	*@return 返回out数组
	*/
	__proto.transformPointArray=function(data,out){
		var len=data.length;
		for (var i=0;i < len;i+=2){
			var x=data[i],y=data[i+1];
			out[i]=this.a *x+this.c *y+this.tx;
			out[i+1]=this.b *x+this.d *y+this.ty;
		}
		return out;
	}

	/**
	*@private
	*将 Matrix 对象表示的几何缩放转换应用于指定点。
	*@param data 点集合。
	*@param out 存储应用转化的点的列表。
	*@return 返回out数组
	*/
	__proto.transformPointArrayScale=function(data,out){
		var len=data.length;
		for (var i=0;i < len;i+=2){
			var x=data[i],y=data[i+1];
			out[i]=this.a *x+this.c *y;
			out[i+1]=this.b *x+this.d *y;
		}
		return out;
	}

	/**
	*获取 X 轴缩放值。
	*@return X 轴缩放值。
	*/
	__proto.getScaleX=function(){
		return this.b===0 ? this.a :Math.sqrt(this.a *this.a+this.b *this.b);
	}

	/**
	*获取 Y 轴缩放值。
	*@return Y 轴缩放值。
	*/
	__proto.getScaleY=function(){
		return this.c===0 ? this.d :Math.sqrt(this.c *this.c+this.d *this.d);
	}

	/**
	*执行原始矩阵的逆转换。
	*@return 当前矩阵对象。
	*/
	__proto.invert=function(){
		var a1=this.a;
		var b1=this.b;
		var c1=this.c;
		var d1=this.d;
		var tx1=this.tx;
		var n=a1 *d1-b1 *c1;
		this.a=d1 / n;
		this.b=-b1 / n;
		this.c=-c1 / n;
		this.d=a1 / n;
		this.tx=(c1 *this.ty-d1 *tx1)/ n;
		this.ty=-(a1 *this.ty-b1 *tx1)/ n;
		return this;
	}

	/**
	*将 Matrix 的成员设置为指定值。
	*@param a 缩放或旋转图像时影响像素沿 x 轴定位的值。
	*@param b 旋转或倾斜图像时影响像素沿 y 轴定位的值。
	*@param c 旋转或倾斜图像时影响像素沿 x 轴定位的值。
	*@param d 缩放或旋转图像时影响像素沿 y 轴定位的值。
	*@param tx 沿 x 轴平移每个点的距离。
	*@param ty 沿 y 轴平移每个点的距离。
	*@return 当前矩阵对象。
	*/
	__proto.setTo=function(a,b,c,d,tx,ty){
		this.a=a,this.b=b,this.c=c,this.d=d,this.tx=tx,this.ty=ty;
		return this;
	}

	/**
	*将指定矩阵与当前矩阵连接，从而将这两个矩阵的几何效果有效地结合在一起。
	*@param matrix 要连接到源矩阵的矩阵。
	*@return 当前矩阵。
	*/
	__proto.concat=function(matrix){
		var a=this.a;
		var c=this.c;
		var tx=this.tx;
		this.a=a *matrix.a+this.b *matrix.c;
		this.b=a *matrix.b+this.b *matrix.d;
		this.c=c *matrix.a+this.d *matrix.c;
		this.d=c *matrix.b+this.d *matrix.d;
		this.tx=tx *matrix.a+this.ty *matrix.c+matrix.tx;
		this.ty=tx *matrix.b+this.ty *matrix.d+matrix.ty;
		return this;
	}

	/**
	*@private
	*对矩阵应用缩放转换。反向相乘
	*@param x 用于沿 x 轴缩放对象的乘数。
	*@param y 用于沿 y 轴缩放对象的乘数。
	*/
	__proto.scaleEx=function(x,y){
		var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
		if (bb!==0 || bc!==0){
			this.a=x *ba;
			this.b=x *bb;
			this.c=y *bc;
			this.d=y *bd;
			}else {
			this.a=x *ba;
			this.b=0 *bd;
			this.c=0 *ba;
			this.d=y *bd;
		}
		this.bTransform=true;
	}

	/**
	*@private
	*对 Matrix 对象应用旋转转换。反向相乘
	*@param angle 以弧度为单位的旋转角度。
	*/
	__proto.rotateEx=function(angle){
		var cos=Math.cos(angle);
		var sin=Math.sin(angle);
		var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
		if (bb!==0 || bc!==0){
			this.a=cos *ba+sin *bc;
			this.b=cos *bb+sin *bd;
			this.c=-sin *ba+cos *bc;
			this.d=-sin *bb+cos *bd;
			}else {
			this.a=cos *ba;
			this.b=sin *bd;
			this.c=-sin *ba;
			this.d=cos *bd;
		}
		this.bTransform=true;
	}

	/**
	*返回此 Matrix 对象的副本。
	*@return 与原始实例具有完全相同的属性的新 Matrix 实例。
	*/
	__proto.clone=function(){
		var dec=Matrix.create();
		dec.a=this.a;
		dec.b=this.b;
		dec.c=this.c;
		dec.d=this.d;
		dec.tx=this.tx;
		dec.ty=this.ty;
		dec.bTransform=this.bTransform;
		return dec;
	}

	/**
	*将当前 Matrix 对象中的所有矩阵数据复制到指定的 Matrix 对象中。
	*@param dec 要复制当前矩阵数据的 Matrix 对象。
	*@return 已复制当前矩阵数据的 Matrix 对象。
	*/
	__proto.copyTo=function(dec){
		dec.a=this.a;
		dec.b=this.b;
		dec.c=this.c;
		dec.d=this.d;
		dec.tx=this.tx;
		dec.ty=this.ty;
		dec.bTransform=this.bTransform;
		return dec;
	}

	/**
	*返回列出该 Matrix 对象属性的文本值。
	*@return 一个字符串，它包含 Matrix 对象的属性值：a、b、c、d、tx 和 ty。
	*/
	__proto.toString=function(){
		return this.a+","+this.b+","+this.c+","+this.d+","+this.tx+","+this.ty;
	}

	/**
	*销毁此对象。
	*/
	__proto.destroy=function(){
		if (this.inPool)return;
		var cache=Matrix._cache;
		this.inPool=true;
		cache._length || (cache._length=0);
		cache[cache._length++]=this;
		this.a=this.d=1;
		this.b=this.c=this.tx=this.ty=0;
		this.bTransform=false;
	}

	Matrix.mul=function(m1,m2,out){
		var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
		var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
		if (bb!==0 || bc!==0){
			out.a=aa *ba+ab *bc;
			out.b=aa *bb+ab *bd;
			out.c=ac *ba+ad *bc;
			out.d=ac *bb+ad *bd;
			out.tx=ba *atx+bc *aty+btx;
			out.ty=bb *atx+bd *aty+bty;
			}else {
			out.a=aa *ba;
			out.b=ab *bd;
			out.c=ac *ba;
			out.d=ad *bd;
			out.tx=ba *atx+btx;
			out.ty=bd *aty+bty;
		}
		return out;
	}

	Matrix.mul16=function(m1,m2,out){
		var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
		var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
		if (bb!==0 || bc!==0){
			out[0]=aa *ba+ab *bc;
			out[1]=aa *bb+ab *bd;
			out[4]=ac *ba+ad *bc;
			out[5]=ac *bb+ad *bd;
			out[12]=ba *atx+bc *aty+btx;
			out[13]=bb *atx+bd *aty+bty;
			}else {
			out[0]=aa *ba;
			out[1]=ab *bd;
			out[4]=ac *ba;
			out[5]=ad *bd;
			out[12]=ba *atx+btx;
			out[13]=bd *aty+bty;
		}
		return out;
	}

	Matrix.mulPre=function(m1,ba,bb,bc,bd,btx,bty,out){
		var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
		if (bb!==0 || bc!==0){
			out.a=aa *ba+ab *bc;
			out.b=aa *bb+ab *bd;
			out.c=ac *ba+ad *bc;
			out.d=ac *bb+ad *bd;
			out.tx=ba *atx+bc *aty+btx;
			out.ty=bb *atx+bd *aty+bty;
			}else {
			out.a=aa *ba;
			out.b=ab *bd;
			out.c=ac *ba;
			out.d=ad *bd;
			out.tx=ba *atx+btx;
			out.ty=bd *aty+bty;
		}
		return out;
	}

	Matrix.mulPos=function(m1,aa,ab,ac,ad,atx,aty,out){
		var ba=m1.a,bb=m1.b,bc=m1.c,bd=m1.d,btx=m1.tx,bty=m1.ty;
		if (bb!==0 || bc!==0){
			out.a=aa *ba+ab *bc;
			out.b=aa *bb+ab *bd;
			out.c=ac *ba+ad *bc;
			out.d=ac *bb+ad *bd;
			out.tx=ba *atx+bc *aty+btx;
			out.ty=bb *atx+bd *aty+bty;
			}else {
			out.a=aa *ba;
			out.b=ab *bd;
			out.c=ac *ba;
			out.d=ad *bd;
			out.tx=ba *atx+btx;
			out.ty=bd *aty+bty;
		}
		return out;
	}

	Matrix.preMul=function(parent,self,out){
		var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
		var na=self.a,nb=self.b,nc=self.c,nd=self.d,ntx=self.tx,nty=self.ty;
		out.a=na *pa;
		out.b=out.c=0;
		out.d=nd *pd;
		out.tx=ntx *pa+parent.tx;
		out.ty=nty *pd+parent.ty;
		if (nb!==0 || nc!==0 || pb!==0 || pc!==0){
			out.a+=nb *pc;
			out.d+=nc *pb;
			out.b+=na *pb+nb *pd;
			out.c+=nc *pa+nd *pc;
			out.tx+=nty *pc;
			out.ty+=ntx *pb;
		}
		return out;
	}

	Matrix.preMulXY=function(parent,x,y,out){
		var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
		out.a=pa;
		out.b=pb;
		out.c=pc;
		out.d=pd;
		out.tx=x *pa+parent.tx+y *pc;
		out.ty=y *pd+parent.ty+x *pb;
		return out;
	}

	Matrix.create=function(){
		var cache=Matrix._cache;
		var mat=!cache._length ? (new Matrix()):cache[--cache._length];
		mat.inPool=false;
		return mat;
	}

	Matrix._cache=[];
	__static(Matrix,
	['EMPTY',function(){return this.EMPTY=new Matrix();},'TEMP',function(){return this.TEMP=new Matrix();}
	]);
	return Matrix;
})()


/**
*<code>Point</code> 对象表示二维坐标系统中的某个位置，其中 x 表示水平轴，y 表示垂直轴。
*/
//class laya.maths.Point
var Point=(function(){
	function Point(x,y){
		/**该点的水平坐标。*/
		//this.x=NaN;
		/**该点的垂直坐标。*/
		//this.y=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		this.x=x;
		this.y=y;
	}

	__class(Point,'laya.maths.Point');
	var __proto=Point.prototype;
	/**
	*将 <code>Point</code> 的成员设置为指定值。
	*@param x 水平坐标。
	*@param y 垂直坐标。
	*@return 当前 Point 对象。
	*/
	__proto.setTo=function(x,y){
		this.x=x;
		this.y=y;
		return this;
	}

	/**
	*计算当前点和目标点(x，y)的距离。
	*@param x 水平坐标。
	*@param y 垂直坐标。
	*@return 返回当前点和目标点之间的距离。
	*/
	__proto.distance=function(x,y){
		return Math.sqrt((this.x-x)*(this.x-x)+(this.y-y)*(this.y-y));
	}

	/**返回包含 x 和 y 坐标的值的字符串。*/
	__proto.toString=function(){
		return this.x+","+this.y;
	}

	/**
	*标准化向量。
	*/
	__proto.normalize=function(){
		var d=Math.sqrt(this.x *this.x+this.y *this.y);
		if (d > 0){
			var id=1.0 / d;
			this.x *=id;
			this.y *=id;
		}
	}

	__static(Point,
	['TEMP',function(){return this.TEMP=new Point();},'EMPTY',function(){return this.EMPTY=new Point();}
	]);
	return Point;
})()


/**
*<p><code>Rectangle</code> 对象是按其位置（由它左上角的点 (x,y)确定）以及宽度和高度定义的区域。</p>
*<p>Rectangle 类的 x、y、width 和 height 属性相互独立；更改一个属性的值不会影响其他属性。</p>
*/
//class laya.maths.Rectangle
var Rectangle=(function(){
	function Rectangle(x,y,width,height){
		/**矩形左上角的 X 轴坐标。*/
		//this.x=NaN;
		/**矩形左上角的 Y 轴坐标。*/
		//this.y=NaN;
		/**矩形的宽度。*/
		//this.width=NaN;
		/**矩形的高度。*/
		//this.height=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
	}

	__class(Rectangle,'laya.maths.Rectangle');
	var __proto=Rectangle.prototype;
	/**
	*将 Rectangle 的属性设置为指定值。
	*@param x x 矩形左上角的 X 轴坐标。
	*@param y x 矩形左上角的 Y 轴坐标。
	*@param width 矩形的宽度。
	*@param height 矩形的高。
	*@return 返回属性值修改后的矩形对象本身。
	*/
	__proto.setTo=function(x,y,width,height){
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
		return this;
	}

	/**
	*复制 source 对象的属性值到此矩形对象中。
	*@param sourceRect 源 Rectangle 对象。
	*@return 返回属性值修改后的矩形对象本身。
	*/
	__proto.copyFrom=function(source){
		this.x=source.x;
		this.y=source.y;
		this.width=source.width;
		this.height=source.height;
		return this;
	}

	/**
	*确定由此 Rectangle 对象定义的矩形区域内是否包含指定的点。
	*@param x 点的 X 轴坐标值（水平位置）。
	*@param y 点的 Y 轴坐标值（垂直位置）。
	*@return 如果 Rectangle 对象包含指定的点，则值为 true；否则为 false。
	*/
	__proto.contains=function(x,y){
		if (this.width <=0 || this.height <=0)return false;
		if (x >=this.x && x < this.right){
			if (y >=this.y && y < this.bottom){
				return true;
			}
		}
		return false;
	}

	/**
	*确定在 rect 参数中指定的对象是否与此 Rectangle 对象相交。此方法检查指定的 Rectangle 对象的 x、y、width 和 height 属性，以查看它是否与此 Rectangle 对象相交。
	*@param rect Rectangle 对象。
	*@return 如果传入的矩形对象与此对象相交，则返回 true 值，否则返回 false。
	*/
	__proto.intersects=function(rect){
		return !(rect.x > (this.x+this.width)|| (rect.x+rect.width)< this.x || rect.y > (this.y+this.height)|| (rect.y+rect.height)< this.y);
	}

	/**
	*如果在 rect 参数中指定的 Rectangle 对象与此 Rectangle 对象相交，则返回交集区域作为 Rectangle 对象。如果矩形不相交，则此方法返回null。
	*@param rect 待比较的矩形区域。
	*@param out （可选）待输出的矩形区域。如果为空则创建一个新的。建议：尽量复用对象，减少对象创建消耗。
	*@return 返回相交的矩形区域对象。
	*/
	__proto.intersection=function(rect,out){
		if (!this.intersects(rect))return null;
		out || (out=new Rectangle());
		out.x=Math.max(this.x,rect.x);
		out.y=Math.max(this.y,rect.y);
		out.width=Math.min(this.right,rect.right)-out.x;
		out.height=Math.min(this.bottom,rect.bottom)-out.y;
		return out;
	}

	/**
	*<p>矩形联合，通过填充两个矩形之间的水平和垂直空间，将这两个矩形组合在一起以创建一个新的 Rectangle 对象。</p>
	*<p>注意：union()方法忽略高度或宽度值为 0 的矩形，如：var rect2:Rectangle=new Rectangle(300,300,50,0);</p>
	*@param 要添加到此 Rectangle 对象的 Rectangle 对象。
	*@param out 用于存储输出结果的矩形对象。如果为空，则创建一个新的。建议：尽量复用对象，减少对象创建消耗。Rectangle.TEMP对象用于对象复用。
	*@return 充当两个矩形的联合的新 Rectangle 对象。
	*/
	__proto.union=function(source,out){
		out || (out=new Rectangle());
		this.clone(out);
		if (source.width <=0 || source.height <=0)return out;
		out.addPoint(source.x,source.y);
		out.addPoint(source.right,source.bottom);
		return this;
	}

	/**
	*返回一个 Rectangle 对象，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
	*@param out （可选）用于存储结果的矩形对象。如果为空，则创建一个新的。建议：尽量复用对象，减少对象创建消耗。。Rectangle.TEMP对象用于对象复用。
	*@return Rectangle 对象，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
	*/
	__proto.clone=function(out){
		out || (out=new Rectangle());
		out.x=this.x;
		out.y=this.y;
		out.width=this.width;
		out.height=this.height;
		return out;
	}

	/**
	*当前 Rectangle 对象的水平位置 x 和垂直位置 y 以及高度 width 和宽度 height 以逗号连接成的字符串。
	*/
	__proto.toString=function(){
		return this.x+","+this.y+","+this.width+","+this.height;
	}

	/**
	*检测传入的 Rectangle 对象的属性是否与当前 Rectangle 对象的属性 x、y、width、height 属性值都相等。
	*@param rect 待比较的 Rectangle 对象。
	*@return 如果判断的属性都相等，则返回 true ,否则返回 false。
	*/
	__proto.equals=function(rect){
		if (!rect || rect.x!==this.x || rect.y!==this.y || rect.width!==this.width || rect.height!==this.height)return false;
		return true;
	}

	/**
	*<p>为当前矩形对象加一个点，以使当前矩形扩展为包含当前矩形和此点的最小矩形。</p>
	*<p>此方法会修改本对象。</p>
	*@param x 点的 X 坐标。
	*@param y 点的 Y 坐标。
	*@return 返回此 Rectangle 对象。
	*/
	__proto.addPoint=function(x,y){
		this.x > x && (this.width+=this.x-x,this.x=x);
		this.y > y && (this.height+=this.y-y,this.y=y);
		if (this.width < x-this.x)this.width=x-this.x;
		if (this.height < y-this.y)this.height=y-this.y;
		return this;
	}

	/**
	*@private
	*返回代表当前矩形的顶点数据。
	*@return 顶点数据。
	*/
	__proto._getBoundPoints=function(){
		var rst=Rectangle._temB;
		rst.length=0;
		if (this.width==0 || this.height==0)return rst;
		rst.push(this.x,this.y,this.x+this.width,this.y,this.x,this.y+this.height,this.x+this.width,this.y+this.height);
		return rst;
	}

	/**
	*确定此 Rectangle 对象是否为空。
	*@return 如果 Rectangle 对象的宽度或高度小于等于 0，则返回 true 值，否则返回 false。
	*/
	__proto.isEmpty=function(){
		if (this.width <=0 || this.height <=0)return true;
		return false;
	}

	/**此矩形右侧的 X 轴坐标。 x 和 width 属性的和。*/
	__getset(0,__proto,'right',function(){
		return this.x+this.width;
	});

	/**此矩形底端的 Y 轴坐标。y 和 height 属性的和。*/
	__getset(0,__proto,'bottom',function(){
		return this.y+this.height;
	});

	Rectangle._getBoundPointS=function(x,y,width,height){
		var rst=Rectangle._temA;
		rst.length=0;
		if (width==0 || height==0)return rst;
		rst.push(x,y,x+width,y,x,y+height,x+width,y+height);
		return rst;
	}

	Rectangle._getWrapRec=function(pointList,rst){
		if (!pointList || pointList.length < 1)return rst ? rst.setTo(0,0,0,0):Rectangle.TEMP.setTo(0,0,0,0);
		rst=rst ? rst :new Rectangle();
		var i,len=pointList.length,minX,maxX,minY,maxY,tPoint=Point.TEMP;
		minX=minY=99999;
		maxX=maxY=-minX;
		for (i=0;i < len;i+=2){
			tPoint.x=pointList[i];
			tPoint.y=pointList[i+1];
			minX=minX < tPoint.x ? minX :tPoint.x;
			minY=minY < tPoint.y ? minY :tPoint.y;
			maxX=maxX > tPoint.x ? maxX :tPoint.x;
			maxY=maxY > tPoint.y ? maxY :tPoint.y;
		}
		return rst.setTo(minX,minY,maxX-minX,maxY-minY);
	}

	Rectangle._temB=[];
	Rectangle._temA=[];
	__static(Rectangle,
	['EMPTY',function(){return this.EMPTY=new Rectangle();},'TEMP',function(){return this.TEMP=new Rectangle();}
	]);
	return Rectangle;
})()


/**
*<code>SoundManager</code> 是一个声音管理类。提供了对背景音乐、音效的播放控制方法。
*引擎默认有两套声音方案：WebAudio和H5Audio
*播放音效，优先使用WebAudio播放声音，如果WebAudio不可用，则用H5Audio播放，H5Audio在部分机器上有兼容问题（比如不能混音，播放有延迟等）。
*播放背景音乐，则使用H5Audio播放（使用WebAudio会增加特别大的内存，并且要等加载完毕后才能播放，有延迟）
*建议背景音乐用mp3类型，音效用wav或者mp3类型（如果打包为app，音效只能用wav格式）。
*详细教程及声音格式请参考：http://ldc.layabox.com/doc/?nav=ch-as-1-7-0
*/
//class laya.media.SoundManager
var SoundManager=(function(){
	function SoundManager(){}
	__class(SoundManager,'laya.media.SoundManager');
	__getset(1,SoundManager,'useAudioMusic',function(){
		return SoundManager._useAudioMusic;
		},function(value){
		SoundManager._useAudioMusic=value;
		if (value)SoundManager._musicClass=AudioSound;
	});

	/**
	*失去焦点后是否自动停止背景音乐。
	*@param v Boolean 失去焦点后是否自动停止背景音乐。
	*
	*/
	/**
	*失去焦点后是否自动停止背景音乐。
	*/
	__getset(1,SoundManager,'autoStopMusic',function(){
		return SoundManager._autoStopMusic;
		},function(v){
		Laya.stage.off("blur",null,SoundManager._stageOnBlur);
		Laya.stage.off("focus",null,SoundManager._stageOnFocus);
		Laya.stage.off("visibilitychange",null,SoundManager._visibilityChange);
		SoundManager._autoStopMusic=v;
		if (v){
			Laya.stage.on("blur",null,SoundManager._stageOnBlur);
			Laya.stage.on("focus",null,SoundManager._stageOnFocus);
			Laya.stage.on("visibilitychange",null,SoundManager._visibilityChange);
		}
	});

	/**
	*背景音乐和所有音效是否静音。
	*/
	__getset(1,SoundManager,'muted',function(){
		return SoundManager._muted;
		},function(value){
		if (value){
			SoundManager.stopAllSound();
		}
		SoundManager.musicMuted=value;
		SoundManager._muted=value;
	});

	/**
	*背景音乐（不包括音效）是否静音。
	*/
	__getset(1,SoundManager,'musicMuted',function(){
		return SoundManager._musicMuted;
		},function(value){
		if (value){
			if (SoundManager._tMusic)
				SoundManager.stopSound(SoundManager._tMusic);
			SoundManager._musicMuted=value;
			}else {
			SoundManager._musicMuted=value;
			if (SoundManager._tMusic){
				SoundManager.playMusic(SoundManager._tMusic);
			}
		}
	});

	/**
	*所有音效（不包括背景音乐）是否静音。
	*/
	__getset(1,SoundManager,'soundMuted',function(){
		return SoundManager._soundMuted;
		},function(value){
		SoundManager._soundMuted=value;
	});

	SoundManager.addChannel=function(channel){
		if (SoundManager._channels.indexOf(channel)>=0)return;
		SoundManager._channels.push(channel);
	}

	SoundManager.removeChannel=function(channel){
		var i=0;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			if (SoundManager._channels[i]==channel){
				SoundManager._channels.splice(i,1);
			}
		}
	}

	SoundManager.disposeSoundIfNotUsed=function(url){
		var i=0;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			if (SoundManager._channels[i].url==url){
				return;
			}
		}
		SoundManager.destroySound(url);
	}

	SoundManager._visibilityChange=function(){
		if (Laya.stage.isVisibility){
			SoundManager._stageOnFocus();
			}else {
			SoundManager._stageOnBlur();
		}
	}

	SoundManager._stageOnBlur=function(){
		SoundManager._isActive=false;
		if (SoundManager._musicChannel){
			if (!SoundManager._musicChannel.isStopped){
				SoundManager._blurPaused=true;
				SoundManager._musicLoops=SoundManager._musicChannel.loops;
				SoundManager._musicCompleteHandler=SoundManager._musicChannel.completeHandler;
				SoundManager._musicPosition=SoundManager._musicChannel.position;
				SoundManager._musicChannel.stop();
				Laya.stage.once("mousedown",null,SoundManager._stageOnFocus);
			}
		}
		SoundManager.stopAllSound();
	}

	SoundManager._stageOnFocus=function(){
		SoundManager._isActive=true;
		Laya.stage.off("mousedown",null,SoundManager._stageOnFocus);
		if (SoundManager._blurPaused){
			if (SoundManager._tMusic){
				SoundManager.playMusic(SoundManager._tMusic,SoundManager._musicLoops,SoundManager._musicCompleteHandler,SoundManager._musicPosition);
			}
			SoundManager._blurPaused=false;
		}
	}

	SoundManager.playSound=function(url,loops,complete,soundClass,startTime){
		(loops===void 0)&& (loops=1);
		(startTime===void 0)&& (startTime=0);
		if (!SoundManager._isActive || !url)return null;
		if (SoundManager._muted)return null;
		url=URL.formatURL(url);
		if (url==SoundManager._tMusic){
			if (SoundManager._musicMuted)return null;
			}else {
			if (Render.isConchApp){
				var ext=Utils.getFileExtension(url);
				if (ext !="wav" && ext !="ogg"){
					alert("The sound only supports wav or ogg format,for optimal performance reason,please refer to the official website document.");
					return null;
				}
			}
			if (SoundManager._soundMuted)return null;
		};
		var tSound=Laya.loader.getRes(url);
		if (!soundClass)soundClass=SoundManager._soundClass;
		if (!tSound){
			tSound=new soundClass();
			tSound.load(url);
			Loader.cacheRes(url,tSound);
		};
		var channel;
		channel=tSound.play(startTime,loops);
		if (!channel)return null;
		channel.url=url;
		channel.volume=(url==SoundManager._tMusic)? SoundManager.musicVolume :SoundManager.soundVolume;
		channel.completeHandler=complete;
		return channel;
	}

	SoundManager.destroySound=function(url){
		var tSound=Laya.loader.getRes(url);
		if (tSound){
			Loader.clearRes(url);
			tSound.dispose();
		}
	}

	SoundManager.playMusic=function(url,loops,complete,startTime){
		(loops===void 0)&& (loops=0);
		(startTime===void 0)&& (startTime=0);
		url=URL.formatURL(url);
		SoundManager._tMusic=url;
		if (SoundManager._musicChannel)SoundManager._musicChannel.stop();
		return SoundManager._musicChannel=SoundManager.playSound(url,loops,complete,SoundManager._musicClass,startTime);
	}

	SoundManager.stopSound=function(url){
		url=URL.formatURL(url);
		var i=0;
		var channel;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			channel=SoundManager._channels[i];
			if (channel.url==url){
				channel.stop();
			}
		}
	}

	SoundManager.stopAll=function(){
		SoundManager._tMusic=null;
		var i=0;
		var channel;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			channel=SoundManager._channels[i];
			channel.stop();
		}
	}

	SoundManager.stopAllSound=function(){
		var i=0;
		var channel;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			channel=SoundManager._channels[i];
			if (channel.url !=SoundManager._tMusic){
				channel.stop();
			}
		}
	}

	SoundManager.stopMusic=function(){
		if (SoundManager._musicChannel)SoundManager._musicChannel.stop();
		SoundManager._tMusic=null;
	}

	SoundManager.setSoundVolume=function(volume,url){
		if (url){
			url=URL.formatURL(url);
			SoundManager._setVolume(url,volume);
			}else {
			SoundManager.soundVolume=volume;
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url !=SoundManager._tMusic){
					channel.volume=volume;
				}
			}
		}
	}

	SoundManager.setMusicVolume=function(volume){
		SoundManager.musicVolume=volume;
		SoundManager._setVolume(SoundManager._tMusic,volume);
	}

	SoundManager._setVolume=function(url,volume){
		url=URL.formatURL(url);
		var i=0;
		var channel;
		for (i=SoundManager._channels.length-1;i >=0;i--){
			channel=SoundManager._channels[i];
			if (channel.url==url){
				channel.volume=volume;
			}
		}
	}

	SoundManager.musicVolume=1;
	SoundManager.soundVolume=1;
	SoundManager.playbackRate=1;
	SoundManager._useAudioMusic=true;
	SoundManager._muted=false;
	SoundManager._soundMuted=false;
	SoundManager._musicMuted=false;
	SoundManager._tMusic=null;
	SoundManager._musicChannel=null;
	SoundManager._channels=[];
	SoundManager._autoStopMusic=false;
	SoundManager._blurPaused=false;
	SoundManager._isActive=true;
	SoundManager._musicLoops=0;
	SoundManager._musicPosition=0;
	SoundManager._musicCompleteHandler=null;
	SoundManager._soundClass=null;
	SoundManager._musicClass=null;
	SoundManager.autoReleaseSound=true;
	return SoundManager;
})()


/**
*<p> <code>LocalStorage</code> 类用于没有时间限制的数据存储。</p>
*/
//class laya.net.LocalStorage
var LocalStorage=(function(){
	var Storage;
	function LocalStorage(){}
	__class(LocalStorage,'laya.net.LocalStorage');
	LocalStorage.__init__=function(){
		if (!LocalStorage._baseClass){
			LocalStorage._baseClass=Storage;
			Storage.init();
		}
		LocalStorage.items=LocalStorage._baseClass.items;
		LocalStorage.support=LocalStorage._baseClass.support;
	}

	LocalStorage.setItem=function(key,value){
		LocalStorage._baseClass.setItem(key,value);
	}

	LocalStorage.getItem=function(key){
		return LocalStorage._baseClass.getItem(key);
	}

	LocalStorage.setJSON=function(key,value){
		LocalStorage._baseClass.setJSON(key,value);
	}

	LocalStorage.getJSON=function(key){
		return LocalStorage._baseClass.getJSON(key);
	}

	LocalStorage.removeItem=function(key){
		LocalStorage._baseClass.removeItem(key);
	}

	LocalStorage.clear=function(){
		LocalStorage._baseClass.clear();
	}

	LocalStorage._baseClass=null;
	LocalStorage.items=null;
	LocalStorage.support=false;
	LocalStorage.__init$=function(){
		//class Storage
		Storage=(function(){
			function Storage(){}
			__class(Storage,'');
			Storage.init=function(){
				try{Storage.items=window.localStorage;Storage.setItem('laya','1');Storage.removeItem('laya');Storage.support=true;}catch(e){}if(!Storage.support)console.log('LocalStorage is not supprot or browser is private mode.');
			}
			Storage.setItem=function(key,value){
				try {
					Storage.support && Storage.items.setItem(key,value);
					}catch (e){
					console.warn("set localStorage failed",e);
				}
			}
			Storage.getItem=function(key){
				return Storage.support ? Storage.items.getItem(key):null;
			}
			Storage.setJSON=function(key,value){
				try {
					Storage.support && Storage.items.setItem(key,JSON.stringify(value));
					}catch (e){
					console.warn("set localStorage failed",e);
				}
			}
			Storage.getJSON=function(key){
				return JSON.parse(Storage.support ? Storage.items.getItem(key):null);
			}
			Storage.removeItem=function(key){
				Storage.support && Storage.items.removeItem(key);
			}
			Storage.clear=function(){
				Storage.support && Storage.items.clear();
			}
			Storage.items=null;
			Storage.support=false;
			return Storage;
		})()
	}

	return LocalStorage;
})()


/**
*@private
*/
//class laya.net.TTFLoader
var TTFLoader=(function(){
	function TTFLoader(){
		this.fontName=null;
		this.complete=null;
		this._fontTxt=null;
		this._url=null;
		this._div=null;
		this._txtWidth=NaN;
	}

	__class(TTFLoader,'laya.net.TTFLoader');
	var __proto=TTFLoader.prototype;
	__proto.load=function(fontPath){
		this._url=fontPath;
		var tArr=fontPath.split(".ttf")[0].split("/");
		this.fontName=tArr[tArr.length-1];
		if (Browser.window.FontFace){
			this._loadWithFontFace()
		}
		else {
			this._loadWithCSS();
		}
	}

	__proto._complete=function(){
		Laya.timer.clear(this,this._complete);
		Laya.timer.clear(this,this._checkComplete);
		if (this._div && this._div.parentNode){
			this._div.parentNode.removeChild(this._div);
			this._div=null;
		}
		if (this.complete){
			this.complete.runWith(this);
			this.complete=null;
		}
	}

	__proto._checkComplete=function(){
		if (RunDriver.measureText("LayaTTFFont",this._fontTxt).width !=this._txtWidth){
			this._complete();
		}
	}

	__proto._loadWithFontFace=function(){
		var fontFace=new Browser.window.FontFace(this.fontName,"url('"+this._url+"')");
		Browser.window.document.fonts.add(fontFace);
		var self=this;
		fontFace.loaded.then((function(){
			self._complete()
		}));
		fontFace.load();
	}

	__proto._createDiv=function(){
		this._div=Browser.createElement("div");
		this._div.innerHTML="laya";
		var _style=this._div.style;
		_style.fontFamily=this.fontName;
		_style.position="absolute";
		_style.left="-100px";
		_style.top="-100px";
		Browser.document.body.appendChild(this._div);
	}

	__proto._loadWithCSS=function(){
		var _$this=this;
		var fontStyle=Browser.createElement("style");
		fontStyle.type="text/css";
		Browser.document.body.appendChild(fontStyle);
		fontStyle.textContent="@font-face { font-family:'"+this.fontName+"'; src:url('"+this._url+"');}";
		this._fontTxt="40px "+this.fontName;
		this._txtWidth=RunDriver.measureText("LayaTTFFont",this._fontTxt).width;
		var self=this;
		fontStyle.onload=function (){
			Laya.timer.once(10000,self,_$this._complete);
		};
		Laya.timer.loop(20,this,this._checkComplete);
		this._createDiv();
	}

	TTFLoader._testString="LayaTTFFont";
	return TTFLoader;
})()


/**
*<p> <code>URL</code> 类用于定义地址信息。</p>
*/
//class laya.net.URL
var URL=(function(){
	function URL(url){
		/**@private */
		this._url=null;
		/**@private */
		this._path=null;
		this._url=URL.formatURL(url);
		this._path=URL.getPath(url);
	}

	__class(URL,'laya.net.URL');
	var __proto=URL.prototype;
	/**地址的路径。*/
	__getset(0,__proto,'path',function(){
		return this._path;
	});

	/**格式化后的地址。*/
	__getset(0,__proto,'url',function(){
		return this._url;
	});

	URL.formatURL=function(url,base){
		if (!url)return "null path";
		if (url.indexOf(":")> 0)return url;
		if (URL.customFormat !=null)url=URL.customFormat(url,base);
		var char1=url.charAt(0);
		if (char1==="."){
			return URL.formatRelativePath((base || URL.basePath)+url);
			}else if (char1==='~'){
			return URL.rootPath+url.substring(1);
			}else if (char1==="d"){
			if (url.indexOf("data:image")===0)return url;
			}else if (char1==="/"){
			return url;
		}
		return (base || URL.basePath)+url;
	}

	URL.formatRelativePath=function(value){
		var parts=value.split("/");
		for (var i=0,len=parts.length;i < len;i++){
			if (parts[i]=='..'){
				parts.splice(i-1,2);
				i-=2;
			}
		}
		return parts.join('/');
	}

	URL.isAbsolute=function(url){
		return url.indexOf(":")> 0 || url.charAt(0)=='/';
	}

	URL.getPath=function(url){
		var ofs=url.lastIndexOf('/');
		return ofs > 0 ? url.substr(0,ofs+1):"";
	}

	URL.getFileName=function(url){
		var ofs=url.lastIndexOf('/');
		return ofs > 0 ? url.substr(ofs+1):url;
	}

	URL.version={};
	URL.basePath="";
	URL.rootPath="";
	URL.customFormat=function(url){
		var newUrl=URL.version[url];
		if (!Render.isConchApp && newUrl)url+="?v="+newUrl;
		return url;
	}

	return URL;
})()


/**
*@private
*<code>Render</code> 是渲染管理类。它是一个单例，可以使用 Laya.render 访问。
*/
//class laya.renders.Render
var Render=(function(){
	function Render(width,height){
		/**@private */
		this._timeId=0;
		var style=Render._mainCanvas.source.style;
		style.position='absolute';
		style.top=style.left="0px";
		style.background="#000000";
		Render._mainCanvas.source.id="layaCanvas";
		var isWebGl=laya.renders.Render.isWebGL;
		Render._mainCanvas.source.width=width;
		Render._mainCanvas.source.height=height;
		isWebGl && Render.WebGL.init(Render._mainCanvas,width,height);
		Browser.container.appendChild(Render._mainCanvas.source);
		Render._context=new RenderContext(width,height,isWebGl ? null :Render._mainCanvas);
		Render._context.ctx.setIsMainContext();
		Browser.window.requestAnimationFrame(loop);
		function loop (){
			Laya.stage._loop();
			Browser.window.requestAnimationFrame(loop);
		}
		Laya.stage.on("visibilitychange",this,this._onVisibilitychange);
	}

	__class(Render,'laya.renders.Render');
	var __proto=Render.prototype;
	/**@private */
	__proto._onVisibilitychange=function(){
		if (!Laya.stage.isVisibility){
			this._timeId=Browser.window.setInterval(this._enterFrame,1000);
			}else if (this._timeId !=0){
			Browser.window.clearInterval(this._timeId);
		}
	}

	/**@private */
	__proto._enterFrame=function(e){
		Laya.stage._loop();
	}

	/**目前使用的渲染器。*/
	__getset(1,Render,'context',function(){
		return Render._context;
	});

	/**渲染使用的原生画布引用。 */
	__getset(1,Render,'canvas',function(){
		return Render._mainCanvas.source;
	});

	Render._context=null;
	Render._mainCanvas=null;
	Render.WebGL=null;
	Render.isConchNode=false;
	Render.isConchApp=false;
	Render.isConchWebGL=false;
	Render.isWebGL=false;
	Render.is3DMode=false;
	Render.optimizeTextureMemory=function(url,texture){
		return true;
	}

	Render.__init$=function(){
		window.ConchRenderType=window.ConchRenderType||1;
		window.ConchRenderType|=(!window.conch?0:0x04);;{
			Render.isConchNode=(window.ConchRenderType & 5)==5;
			Render.isConchApp=(window.ConchRenderType & 0x04)==0x04;
			Render.isConchWebGL=window.ConchRenderType==6;
		};;
	}

	return Render;
})()


/**
*@private
*渲染环境
*/
//class laya.renders.RenderContext
var RenderContext=(function(){
	function RenderContext(width,height,canvas){
		/**全局x坐标 */
		this.x=0;
		/**全局y坐标 */
		this.y=0;
		/**当前使用的画布 */
		//this.canvas=null;
		/**当前使用的画布上下文 */
		//this.ctx=null;
		this._drawTexture=function(x,y,args){
			if (args[0].loaded)this.ctx.drawTexture(args[0],args[1],args[2],args[3],args[4],x,y);
		}
		this._fillTexture=function(x,y,args){
			if (args[0].loaded)this.ctx.fillTexture(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
		}
		this._drawTextureWithTransform=function(x,y,args){
			if (args[0].loaded)this.ctx.drawTextureWithTransform(args[0],args[1],args[2],args[3],args[4],args[5],x,y,args[6]);
		}
		this._fillQuadrangle=function(x,y,args){
			this.ctx.fillQuadrangle(args[0],args[1],args[2],args[3],args[4]);
		}
		this._drawRect=function(x,y,args){
			var ctx=this.ctx;
			if (args[4] !=null){
				ctx.fillStyle=args[4];
				ctx.fillRect(x+args[0],y+args[1],args[2],args[3],null);
			}
			if (args[5] !=null){
				ctx.strokeStyle=args[5];
				ctx.lineWidth=args[6];
				ctx.strokeRect(x+args[0],y+args[1],args[2],args[3],args[6]);
			}
		}
		//矢量方法
		this._drawPie=function(x,y,args){
			var ctx=this.ctx;
			Render.isWebGL && ctx.setPathId(args[8]);
			ctx.beginPath();
			if (Render.isWebGL){
				ctx.movePath(args[0]+x,args[1]+y);
				ctx.moveTo(0,0);
				}else {
				ctx.moveTo(x+args[0],y+args[1]);
			}
			ctx.arc(x+args[0],y+args[1],args[2],args[3],args[4]);
			ctx.closePath();
			this._fillAndStroke(args[5],args[6],args[7],true);
		}
		this._clipRect=function(x,y,args){
			this.ctx.clipRect(x+args[0],y+args[1],args[2],args[3]);
		}
		this._fillRect=function(x,y,args){
			this.ctx.fillRect(x+args[0],y+args[1],args[2],args[3],args[4]);
		}
		this._drawCircle=function(x,y,args){
			var ctx=this.ctx;
			Render.isWebGL && ctx.setPathId(args[6]);
			Stat.drawCall++;
			ctx.beginPath();
			Render.isWebGL && ctx.movePath(args[0]+x,args[1]+y);
			ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
			ctx.closePath();
			this._fillAndStroke(args[3],args[4],args[5],true);
		}
		this._fillCircle=function(x,y,args){
			Stat.drawCall++;
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.fillStyle=args[3];
			ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
			ctx.fill();
		}
		this._setShader=function(x,y,args){
			this.ctx.setShader(args[0]);
		}
		this._drawLine=function(x,y,args){
			var ctx=this.ctx;
			Render.isWebGL && ctx.setPathId(args[6]);
			ctx.beginPath();
			ctx.strokeStyle=args[4];
			ctx.lineWidth=args[5];
			if (Render.isWebGL){
				ctx.movePath(x,y);
				ctx.moveTo(args[0],args[1]);
				ctx.lineTo(args[2],args[3]);
				}else {
				ctx.moveTo(x+args[0],y+args[1]);
				ctx.lineTo(x+args[2],y+args[3]);
			}
			ctx.stroke();
		}
		this._drawLines=function(x,y,args){
			var ctx=this.ctx;
			Render.isWebGL && ctx.setPathId(args[5]);
			ctx.beginPath();
			x+=args[0],y+=args[1];
			Render.isWebGL && ctx.movePath(x,y);
			ctx.strokeStyle=args[3];
			ctx.lineWidth=args[4];
			var points=args[2];
			var i=2,n=points.length;
			if (Render.isWebGL){
				ctx.moveTo(points[0],points[1]);
				while (i < n){
					ctx.lineTo(points[i++],points[i++]);
				}
				}else {
				ctx.moveTo(x+points[0],y+points[1]);
				while (i < n){
					ctx.lineTo(x+points[i++],y+points[i++]);
				}
			}
			ctx.stroke();
		}
		this._drawLinesWebGL=function(x,y,args){
			this.ctx.drawLines(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4]);
		}
		//x:Number,y:Number,points:Array,lineColor:String,lineWidth:Number=1
		this._drawCurves=function(x,y,args){
			this.ctx.drawCurves(x,y,args);
		}
		this._draw=function(x,y,args){
			args[0].call(null,this,x,y);
		}
		this._transformByMatrix=function(x,y,args){
			this.ctx.transformByMatrix(args[0]);
		}
		this._setTransform=function(x,y,args){
			this.ctx.setTransform(args[0],args[1],args[2],args[3],args[4],args[5]);
		}
		this._setTransformByMatrix=function(x,y,args){
			this.ctx.setTransformByMatrix(args[0]);
		}
		this._save=function(x,y,args){
			this.ctx.save();
		}
		this._restore=function(x,y,args){
			this.ctx.restore();
		}
		this._translate=function(x,y,args){
			this.ctx.translate(args[0],args[1]);
		}
		this._transform=function(x,y,args){
			this.ctx.translate(args[1]+x,args[2]+y);
			var mat=args[0];
			this.ctx.transform(mat.a,mat.b,mat.c,mat.d,mat.tx,mat.ty);
			this.ctx.translate(-x-args[1],-y-args[2]);
		}
		this._rotate=function(x,y,args){
			this.ctx.translate(args[1]+x,args[2]+y);
			this.ctx.rotate(args[0]);
			this.ctx.translate(-x-args[1],-y-args[2]);
		}
		this._scale=function(x,y,args){
			this.ctx.translate(args[2]+x,args[3]+y);
			this.ctx.scale(args[0],args[1]);
			this.ctx.translate(-x-args[2],-y-args[3]);
		}
		this._alpha=function(x,y,args){
			this.ctx.globalAlpha *=args[0];
		}
		this._setAlpha=function(x,y,args){
			this.ctx.globalAlpha=args[0];
		}
		this._fillText=function(x,y,args){
			this.ctx.fillText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5]);
		}
		this._strokeText=function(x,y,args){
			this.ctx.strokeText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6]);
		}
		this._fillBorderText=function(x,y,args){
			this.ctx.fillBorderText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
		}
		this._blendMode=function(x,y,args){
			this.ctx.globalCompositeOperation=args[0];
		}
		this._beginClip=function(x,y,args){
			this.ctx.beginClip && this.ctx.beginClip(x+args[0],y+args[1],args[2],args[3]);
		}
		this._setIBVB=function(x,y,args){
			this.ctx.setIBVB(args[0]+x,args[1]+y,args[2],args[3],args[4],args[5],args[6],args[7]);
		}
		this._fillTrangles=function(x,y,args){
			this.ctx.fillTrangles(args[0],args[1]+x,args[2]+y,args[3],args[4]);
		}
		//x:Number,y:Number,paths:Array,brush:Object=null,pen:Object=null
		this._drawPath=function(x,y,args){
			var ctx=this.ctx;
			Render.isWebGL && ctx.setPathId(-1);
			ctx.beginPath();
			x+=args[0],y+=args[1];
			Render.isWebGL && ctx.movePath(x,y);
			var paths=args[2];
			for (var i=0,n=paths.length;i < n;i++){
				var path=paths[i];
				switch (path[0]){
					case "moveTo":
						Render.isWebGL ? ctx.moveTo(path[1],path[2]):ctx.moveTo(x+path[1],y+path[2]);
						break ;
					case "lineTo":
						Render.isWebGL ? ctx.lineTo(path[1],path[2]):ctx.lineTo(x+path[1],y+path[2]);
						break ;
					case "arcTo":
						Render.isWebGL ? ctx.arcTo(path[1],path[2],path[3],path[4],path[5]):ctx.arcTo(x+path[1],y+path[2],x+path[3],y+path[4],path[5]);
						break ;
					case "closePath":
						ctx.closePath();
						break ;
					}
			};
			var brush=args[3];
			if (brush !=null){
				ctx.fillStyle=brush.fillStyle;
				ctx.fill();
			};
			var pen=args[4];
			if (pen !=null){
				ctx.strokeStyle=pen.strokeStyle;
				ctx.lineWidth=pen.lineWidth || 1;
				ctx.lineJoin=pen.lineJoin;
				ctx.lineCap=pen.lineCap;
				ctx.miterLimit=pen.miterLimit;
				ctx.stroke();
			}
		}
		// polygon(x:Number,y:Number,r:Number,edges:Number,color:uint,borderWidth:int=2,borderColor:uint=0)
		this.drawPoly=function(x,y,args){
			this.ctx.drawPoly(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4],args[5],args[6]);
		}
		//x:Number,y:Number,points:Array,fillColor:String,lineColor:String=null,lineWidth:Number=1
		this._drawPoly=function(x,y,args){
			var ctx=this.ctx;
			var points=args[2];
			var i=2,n=points.length;
			if (Render.isWebGL){
				ctx.setPathId(args[6]);
				ctx.beginPath();
				x+=args[0],y+=args[1];
				ctx.movePath(x,y);
				ctx.moveTo(points[0],points[1]);
				while (i < n){
					ctx.lineTo(points[i++],points[i++]);
				}
				}else {
				ctx.beginPath();
				x+=args[0],y+=args[1];
				ctx.moveTo(x+points[0],y+points[1]);
				while (i < n){
					ctx.lineTo(x+points[i++],y+points[i++]);
				}
			}
			ctx.closePath();
			this._fillAndStroke(args[3],args[4],args[5],args[7]);
		}
		this._drawSkin=function(x,y,args){
			var tSprite=args[0];
			if (tSprite){
				var ctx=this.ctx;
				tSprite.render(ctx,x,y);
			}
		}
		this._drawParticle=function(x,y,args){
			this.ctx.drawParticle(x+this.x,y+this.y,args[0]);
		}
		this._setFilters=function(x,y,args){
			this.ctx.setFilters(args);
		}
		if (canvas){
			this.ctx=canvas.getContext('2d');
			}else {
			canvas=HTMLCanvas.create("3D");
			this.ctx=RunDriver.createWebGLContext2D(canvas);
			canvas._setContext(this.ctx);
		}
		canvas.size(width,height);
		this.canvas=canvas;
	}

	__class(RenderContext,'laya.renders.RenderContext');
	var __proto=RenderContext.prototype;
	/**销毁当前渲染环境*/
	__proto.destroy=function(){
		if (this.canvas){
			this.canvas.destroy();
			this.canvas=null;
			this.ctx=null;
		}
		if (this.ctx){
			this.ctx.destroy();
			this.ctx=null;
		}
	}

	__proto.drawTexture=function(tex,x,y,width,height){
		if (tex.loaded)this.ctx.drawTexture(tex,x,y,width,height,this.x,this.y);
	}

	__proto._drawTextures=function(x,y,args){
		if (args[0].loaded)this.ctx.drawTextures(args[0],args[1],x+this.x,y+this.y);
	}

	__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,alpha){
		if (tex.loaded)this.ctx.drawTextureWithTransform(tex,x,y,width,height,m,this.x,this.y,alpha);
	}

	__proto.fillQuadrangle=function(tex,x,y,point4,m){
		this.ctx.fillQuadrangle(tex,x,y,point4,m);
	}

	__proto.drawCanvas=function(canvas,x,y,width,height){
		this.ctx.drawCanvas(canvas,x+this.x,y+this.y,width,height);
	}

	__proto.drawRect=function(x,y,width,height,color,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var ctx=this.ctx;
		ctx.strokeStyle=color;
		ctx.lineWidth=lineWidth;
		ctx.strokeRect(x+this.x,y+this.y,width,height,lineWidth);
	}

	__proto._fillAndStroke=function(fillColor,strokeColor,lineWidth,isConvexPolygon){
		(isConvexPolygon===void 0)&& (isConvexPolygon=false);
		var ctx=this.ctx;
		if (fillColor !=null){
			ctx.fillStyle=fillColor;
			if (Render.isWebGL){
				ctx.fill(isConvexPolygon);
				}else {
				ctx.fill();
			}
		}
		if (strokeColor !=null && lineWidth > 0){
			ctx.strokeStyle=strokeColor;
			ctx.lineWidth=lineWidth;
			ctx.stroke();
		}
	}

	//ctx.translate(-x-args[0],-y-args[1]);
	__proto.clipRect=function(x,y,width,height){
		this.ctx.clipRect(x+this.x,y+this.y,width,height);
	}

	__proto.fillRect=function(x,y,width,height,fillStyle){
		this.ctx.fillRect(x+this.x,y+this.y,width,height,fillStyle);
	}

	__proto.drawCircle=function(x,y,radius,color,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		Stat.drawCall++;
		var ctx=this.ctx;
		ctx.beginPath();
		ctx.strokeStyle=color;
		ctx.lineWidth=lineWidth;
		ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
		ctx.stroke();
	}

	__proto.fillCircle=function(x,y,radius,color){
		Stat.drawCall++;
		var ctx=this.ctx;
		ctx.beginPath();
		ctx.fillStyle=color;
		ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
		ctx.fill();
	}

	__proto.setShader=function(shader){
		this.ctx.setShader(shader);
	}

	__proto.drawLine=function(fromX,fromY,toX,toY,color,lineWidth){
		(lineWidth===void 0)&& (lineWidth=1);
		var ctx=this.ctx;
		ctx.beginPath();
		ctx.strokeStyle=color;
		ctx.lineWidth=lineWidth;
		ctx.moveTo(this.x+fromX,this.y+fromY);
		ctx.lineTo(this.x+toX,this.y+toY);
		ctx.stroke();
	}

	__proto.clear=function(){
		this.ctx.clear();
	}

	__proto.transformByMatrix=function(value){
		this.ctx.transformByMatrix(value);
	}

	__proto.setTransform=function(a,b,c,d,tx,ty){
		this.ctx.setTransform(a,b,c,d,tx,ty);
	}

	__proto.setTransformByMatrix=function(value){
		this.ctx.setTransformByMatrix(value);
	}

	__proto.save=function(){
		this.ctx.save();
	}

	__proto.restore=function(){
		this.ctx.restore();
	}

	__proto.translate=function(x,y){
		this.ctx.translate(x,y);
	}

	__proto.transform=function(a,b,c,d,tx,ty){
		this.ctx.transform(a,b,c,d,tx,ty);
	}

	__proto.rotate=function(angle){
		this.ctx.rotate(angle);
	}

	__proto.scale=function(scaleX,scaleY){
		this.ctx.scale(scaleX,scaleY);
	}

	__proto.alpha=function(value){
		this.ctx.globalAlpha *=value;
	}

	__proto.setAlpha=function(value){
		this.ctx.globalAlpha=value;
	}

	__proto.fillWords=function(words,x,y,font,color,underLine){
		(underLine===void 0)&& (underLine=0);
		this.ctx.fillWords(words,x,y,font,color,underLine);
	}

	/***@private */
	__proto.fillBorderWords=function(words,x,y,font,fillColor,borderColor,lineWidth){
		this.ctx.fillBorderWords(words,x,y,font,fillColor,borderColor,lineWidth);
	}

	__proto.fillText=function(text,x,y,font,color,textAlign){
		this.ctx.fillText(text,x+this.x,y+this.y,font,color,textAlign);
	}

	__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
		this.ctx.strokeText(text,x+this.x,y+this.y,font,color,lineWidth,textAlign);
	}

	__proto.blendMode=function(type){
		this.ctx.globalCompositeOperation=type;
	}

	__proto.flush=function(){
		this.ctx.flush && this.ctx.flush();
	}

	__proto.addRenderObject=function(o){
		this.ctx.addRenderObject(o);
	}

	__proto.beginClip=function(x,y,w,h){
		this.ctx.beginClip && this.ctx.beginClip(x,y,w,h);
	}

	__proto.endClip=function(){
		this.ctx.endClip && this.ctx.endClip();
	}

	__proto.fillTrangles=function(x,y,args){
		this.ctx.fillTrangles(args[0],args[1],args[2],args[3],args.length > 4 ? args[4] :null);
	}

	__static(RenderContext,
	['PI2',function(){return this.PI2=2 *Math.PI;}
	]);
	return RenderContext;
})()


/**
*@private
*精灵渲染器
*/
//class laya.renders.RenderSprite
var RenderSprite=(function(){
	function RenderSprite(type,next){
		/**@private */
		//this._next=null;
		/**@private */
		//this._fun=null;
		this._next=next || RenderSprite.NORENDER;
		switch (type){
			case 0:
				this._fun=this._no;
				return;
			case 0x01:
				this._fun=this._image;
				return;
			case 0x02:
				this._fun=this._alpha;
				return;
			case 0x04:
				this._fun=this._transform;
				return;
			case 0x08:
				this._fun=this._blend;
				return;
			case 0x10:
				this._fun=this._canvas;
				return;
			case 0x40:
				this._fun=this._mask;
				return;
			case 0x80:
				this._fun=this._clip;
				return;
			case 0x100:
				this._fun=this._style;
				return;
			case 0x200:
				this._fun=this._graphics;
				return;
			case 0x800:
				this._fun=this._childs;
				return;
			case 0x400:
				this._fun=this._custom;
				return;
			case 0x01 | 0x200:
				this._fun=this._image2;
				return;
			case 0x01 | 0x04 | 0x200:
				this._fun=this._image2;
				return;
			case 0x20:
				this._fun=Filter._filter;
				return;
			case 0x11111:
				this._fun=RenderSprite._initRenderFun;
				return;
			}
		this.onCreate(type);
	}

	__class(RenderSprite,'laya.renders.RenderSprite');
	var __proto=RenderSprite.prototype;
	__proto.onCreate=function(type){}
	__proto._style=function(sprite,context,x,y){
		sprite._style.render(sprite,context,x,y);
		var next=this._next;
		next._fun.call(next,sprite,context,x,y);
	}

	__proto._no=function(sprite,context,x,y){}
	__proto._custom=function(sprite,context,x,y){
		sprite.customRender(context,x,y);
		var tf=sprite._style._tf;
		this._next._fun.call(this._next,sprite,context,x-tf.translateX,y-tf.translateY);
	}

	__proto._clip=function(sprite,context,x,y){
		var next=this._next;
		if (next==RenderSprite.NORENDER)return;
		var r=sprite._style.scrollRect;
		context.ctx.save();
		context.ctx.clipRect(x,y,r.width,r.height);
		next._fun.call(next,sprite,context,x-r.x,y-r.y);
		context.ctx.restore();
	}

	__proto._blend=function(sprite,context,x,y){
		var style=sprite._style;
		if (style.blendMode){
			context.ctx.globalCompositeOperation=style.blendMode;
		};
		var next=this._next;
		next._fun.call(next,sprite,context,x,y);
		context.ctx.globalCompositeOperation="source-over";
	}

	__proto._mask=function(sprite,context,x,y){
		var next=this._next;
		next._fun.call(next,sprite,context,x,y);
		var mask=sprite.mask;
		if (mask){
			context.ctx.globalCompositeOperation="destination-in";
			if (mask.numChildren > 0 || !mask.graphics._isOnlyOne()){
				mask.cacheAsBitmap=true;
			}
			mask.render(context,x-sprite.pivotX,y-sprite.pivotY);
		}
		context.ctx.globalCompositeOperation="source-over";
	}

	__proto._graphics=function(sprite,context,x,y){
		var tf=sprite._style._tf;
		sprite._graphics && sprite._graphics._render(sprite,context,x-tf.translateX,y-tf.translateY);
		var next=this._next;
		next._fun.call(next,sprite,context,x,y);
	}

	__proto._image=function(sprite,context,x,y){
		var style=sprite._style;
		context.ctx.drawTexture2(x,y,style._tf.translateX,style._tf.translateY,sprite.transform,style.alpha,style.blendMode,sprite._graphics._one);
	}

	__proto._image2=function(sprite,context,x,y){
		var tf=sprite._style._tf;
		context.ctx.drawTexture2(x,y,tf.translateX,tf.translateY,sprite.transform,1,null,sprite._graphics._one);
	}

	__proto._alpha=function(sprite,context,x,y){
		var style=sprite._style;
		var alpha;
		if ((alpha=style.alpha)> 0.01 || sprite._needRepaint()){
			var temp=context.ctx.globalAlpha;
			context.ctx.globalAlpha *=alpha;
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
			context.ctx.globalAlpha=temp;
		}
	}

	__proto._transform=function(sprite,context,x,y){
		var transform=sprite.transform,_next=this._next;
		if (transform && _next !=RenderSprite.NORENDER){
			context.save();
			context.transform(transform.a,transform.b,transform.c,transform.d,transform.tx+x,transform.ty+y);
			_next._fun.call(_next,sprite,context,0,0);
			context.restore();
		}else
		_next._fun.call(_next,sprite,context,x,y);
	}

	__proto._childs=function(sprite,context,x,y){
		var style=sprite._style;
		var tf=style._tf;
		x=x-tf.translateX+style.paddingLeft;
		y=y-tf.translateY+style.paddingTop;
		if (style._calculation){
			var words=sprite._getWords();
			if (words){
				var tStyle=style;
				if (tStyle){
					if (tStyle.stroke){
						context.fillBorderWords(words,x,y,tStyle.font,tStyle.color,tStyle.strokeColor,tStyle.stroke);
						}else{
						context.fillWords(words,x,y,tStyle.font,tStyle.color,tStyle.underLine);
					}
				}
			}
		};
		var childs=sprite._childs,n=childs.length,ele;
		if (sprite.viewport || (sprite.optimizeScrollRect && sprite._style.scrollRect)){
			var rect=sprite.viewport || sprite._style.scrollRect;
			var left=rect.x;
			var top=rect.y;
			var right=rect.right;
			var bottom=rect.bottom;
			var _x=NaN,_y=NaN;
			for (i=0;i < n;++i){
				if ((ele=childs [i]).visible && ((_x=ele._x)< right && (_x+ele.width)> left && (_y=ele._y)< bottom && (_y+ele.height)> top)){
					ele.render(context,x,y);
				}
			}
			}else {
			for (var i=0;i < n;++i)
			(ele=(childs [i]))._style.visible && ele.render(context,x,y);
		}
	}

	//}
	__proto._canvas=function(sprite,context,x,y){
		var _cacheCanvas=sprite._$P.cacheCanvas;
		if (!_cacheCanvas){
			this._next._fun.call(this._next,sprite,context,x,y);
			return;
		}
		_cacheCanvas.type==='bitmap' ? (Stat.canvasBitmap++):(Stat.canvasNormal++);
		var tx=_cacheCanvas.ctx;
		if (sprite._needRepaint()|| !tx){
			this._canvas_repaint(sprite,context,x,y);
		}
		else{
			var tRec=_cacheCanvas._cacheRec;
			context.drawCanvas(tx.canvas,x+tRec.x,y+tRec.y,tRec.width,tRec.height);
		}
	}

	__proto._canvas_repaint=function(sprite,context,x,y){
		var _cacheCanvas=sprite._$P.cacheCanvas;
		var _next=this._next;
		if (!_cacheCanvas){
			_next._fun.call(_next,sprite,tx,x,y);
			return;
		};
		var tx=_cacheCanvas.ctx;
		var _repaint=sprite._needRepaint()|| (!tx);
		var canvas;
		var left;
		var top;
		var tRec;
		var tCacheType=_cacheCanvas.type;
		tCacheType==='bitmap' ? (Stat.canvasBitmap++):(Stat.canvasNormal++);
		if (_repaint){
			if (!_cacheCanvas._cacheRec)
				_cacheCanvas._cacheRec=new Rectangle();
			var w,h;
			if (!Render.isWebGL || tCacheType==="bitmap"){
				tRec=sprite.getSelfBounds();
				tRec.x=tRec.x-sprite.pivotX;
				tRec.y=tRec.y-sprite.pivotY;
				tRec.x=tRec.x-16;
				tRec.y=tRec.y-16;
				tRec.width=tRec.width+32;
				tRec.height=tRec.height+32;
				tRec.x=Math.floor(tRec.x+x)-x;
				tRec.y=Math.floor(tRec.y+y)-y;
				tRec.width=Math.floor(tRec.width);
				tRec.height=Math.floor(tRec.height);
				_cacheCanvas._cacheRec.copyFrom(tRec);
				}else{
				_cacheCanvas._cacheRec.setTo(-sprite.pivotX,-sprite.pivotY,1,1);
			}
			tRec=_cacheCanvas._cacheRec;
			var scaleX=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleX;
			var scaleY=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleY;
			if (!Render.isWebGL){
				var chainScaleX=1;
				var chainScaleY=1;
				var tar;
				tar=sprite;
				while (tar && tar !=Laya.stage){
					chainScaleX *=tar.scaleX;
					chainScaleY *=tar.scaleY;
					tar=tar.parent;
				}
				if (Render.isWebGL){
					if (chainScaleX < 1)scaleX *=chainScaleX;
					if (chainScaleY < 1)scaleY *=chainScaleY;
					}else {
					if (chainScaleX > 1)scaleX *=chainScaleX;
					if (chainScaleY > 1)scaleY *=chainScaleY;
				}
			}
			if (sprite.scrollRect){
				var scrollRect=sprite.scrollRect;
				tRec.x-=scrollRect.x;
				tRec.y-=scrollRect.y;
			}
			w=tRec.width *scaleX;
			h=tRec.height *scaleY;
			left=tRec.x;
			top=tRec.y;
			if (Render.isWebGL && tCacheType==='bitmap' && (w > 2048 || h > 2048)){
				console.warn("cache bitmap size larger than 2048,cache ignored");
				if (_cacheCanvas.ctx){
					Pool.recover("RenderContext",_cacheCanvas.ctx);
					_cacheCanvas.ctx.canvas.size(0,0);
					_cacheCanvas.ctx=null;
				}
				_next._fun.call(_next,sprite,context,x,y);
				return;
			}
			if (!tx){
				tx=_cacheCanvas.ctx=Pool.getItem("RenderContext")|| new RenderContext(w,h,HTMLCanvas.create("AUTO"));
			}
			tx.ctx.sprite=sprite;
			canvas=tx.canvas;
			canvas.clear();
			(canvas.width !=w || canvas.height !=h)&& canvas.size(w,h);
			if (tCacheType==='bitmap')canvas.context.asBitmap=true;
			else if(tCacheType==='normal')canvas.context.asBitmap=false;
			var t;
			if (scaleX !=1 || scaleY !=1){
				var ctx=(tx).ctx;
				ctx.save();
				ctx.scale(scaleX,scaleY);
				if (!Render.isConchWebGL && Render.isConchApp){
					t=sprite._$P.cf;
					t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
				}
				_next._fun.call(_next,sprite,tx,-left,-top);
				ctx.restore();
				if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
				}else {
				ctx=(tx).ctx;
				if (!Render.isConchWebGL && Render.isConchApp){
					t=sprite._$P.cf;
					t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
				}
				_next._fun.call(_next,sprite,tx,-left,-top);
				if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
			}
			if (sprite._$P.staticCache)_cacheCanvas.reCache=false;
			Stat.canvasReCache++;
			}else {
			tRec=_cacheCanvas._cacheRec;
			left=tRec.x;
			top=tRec.y;
			canvas=tx.canvas;
		}
		context.drawCanvas(canvas,x+left,y+top,tRec.width,tRec.height);
	}

	RenderSprite.__init__=function(){
		var i=0,len=0;
		var initRender;
		initRender=RunDriver.createRenderSprite(0x11111,null);
		len=RenderSprite.renders.length=0x800 *2;
		for (i=0;i < len;i++)
		RenderSprite.renders[i]=initRender;
		RenderSprite.renders[0]=RunDriver.createRenderSprite(0,null);
		function _initSame (value,o){
			var n=0;
			for (var i=0;i < value.length;i++){
				n |=value[i];
				RenderSprite.renders[n]=o;
			}
		}
		_initSame([0x01,0x200,0x04,0x02],new RenderSprite(0x01,null));
		RenderSprite.renders[0x01 | 0x200]=RunDriver.createRenderSprite(0x01 | 0x200,null);
		RenderSprite.renders[0x01 | 0x04 | 0x200]=new RenderSprite(0x01 | 0x04 | 0x200,null);
	}

	RenderSprite._initRenderFun=function(sprite,context,x,y){
		var type=sprite._renderType;
		var r=RenderSprite.renders[type]=RenderSprite._getTypeRender(type);
		r._fun(sprite,context,x,y);
	}

	RenderSprite._getTypeRender=function(type){
		var rst=null;
		var tType=0x800;
		while (tType > 1){
			if (tType & type)
				rst=RunDriver.createRenderSprite(tType,rst);
			tType=tType >> 1;
		}
		return rst;
	}

	RenderSprite.IMAGE=0x01;
	RenderSprite.ALPHA=0x02;
	RenderSprite.TRANSFORM=0x04;
	RenderSprite.BLEND=0x08;
	RenderSprite.CANVAS=0x10;
	RenderSprite.FILTERS=0x20;
	RenderSprite.MASK=0x40;
	RenderSprite.CLIP=0x80;
	RenderSprite.STYLE=0x100;
	RenderSprite.GRAPHICS=0x200;
	RenderSprite.CUSTOM=0x400;
	RenderSprite.CHILDS=0x800;
	RenderSprite.INIT=0x11111;
	RenderSprite.renders=[];
	__static(RenderSprite,
	['NORENDER',function(){return this.NORENDER=new RenderSprite(0,null);}
	]);
	return RenderSprite;
})()


/**
*@private
*Context扩展类
*/
//class laya.resource.Context
var Context=(function(){
	function Context(){
		/***@private */
		//this._canvas=null;
		this._repaint=false;
	}

	__class(Context,'laya.resource.Context');
	var __proto=Context.prototype;
	__proto.replaceReset=function(){
		var i=0,len=0;
		len=Context.replaceKeys.length;
		var key;
		for (i=0;i < len;i++){
			key=Context.replaceKeys[i];
			this[Context.newKeys[i]]=this[key];
		}
	}

	__proto.replaceResotre=function(){
		this.__restore();
		this.__reset();
	}

	__proto.setIsMainContext=function(){}
	__proto.drawTextures=function(tex,pos,tx,ty){
		Stat.drawCall+=pos.length / 2;
		var w=tex.width;
		var h=tex.height;
		for (var i=0,sz=pos.length;i < sz;i+=2){
			this.drawTexture(tex,pos[i],pos[i+1],w,h,tx,ty);
		}
	}

	/***@private */
	__proto.drawCanvas=function(canvas,x,y,width,height){
		Stat.drawCall++;
		this.drawImage(canvas.source,x,y,width,height);
	}

	/***@private */
	__proto.fillRect=function(x,y,width,height,style){
		Stat.drawCall++;
		style && (this.fillStyle=style);
		this.__fillRect(x,y,width,height);
	}

	/***@private */
	__proto.fillText=function(text,x,y,font,color,textAlign){
		Stat.drawCall++;
		if (arguments.length > 3 && font !=null){
			this.font=font;
			this.fillStyle=color;
			this.textAlign=textAlign;
			this.textBaseline="top";
		}
		this.__fillText(text,x,y);
	}

	/***@private */
	__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
		Stat.drawCall++;
		this.font=font;
		this.fillStyle=fillColor;
		this.textBaseline="top";
		this.strokeStyle=borderColor;
		this.lineWidth=lineWidth;
		this.textAlign=textAlign;
		this.__strokeText(text,x,y);
		this.__fillText(text,x,y);
	}

	/***@private */
	__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
		Stat.drawCall++;
		if (arguments.length > 3 && font !=null){
			this.font=font;
			this.strokeStyle=color;
			this.lineWidth=lineWidth;
			this.textAlign=textAlign;
			this.textBaseline="top";
		}
		this.__strokeText(text,x,y);
	}

	/***@private */
	__proto.transformByMatrix=function(value){
		this.transform(value.a,value.b,value.c,value.d,value.tx,value.ty);
	}

	/***@private */
	__proto.setTransformByMatrix=function(value){
		this.setTransform(value.a,value.b,value.c,value.d,value.tx,value.ty);
	}

	/***@private */
	__proto.clipRect=function(x,y,width,height){
		Stat.drawCall++;
		this.beginPath();
		this.rect(x,y,width,height);
		this.clip();
	}

	/***@private */
	__proto.drawTexture=function(tex,x,y,width,height,tx,ty){
		Stat.drawCall++;
		var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
		this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx,y+ty,width,height);
	}

	/***@private */
	__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,tx,ty,alpha){
		Stat.drawCall++;
		var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
		this.save();
		alpha !=1 && (this.globalAlpha *=alpha);
		if (m){
			this.transform(m.a,m.b,m.c,m.d,m.tx+tx,m.ty+ty);
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x ,y,width,height);
			}else {
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx ,y+ty,width,height);
		}
		this.restore();
	}

	/***@private */
	__proto.drawTexture2=function(x,y,pivotX,pivotY,m,alpha,blendMode,args2){
		'use strict';
		var tex=args2[0];
		if (!(tex.loaded && tex.bitmap && tex.source)){
			return;
		}
		Stat.drawCall++;
		var alphaChanged=alpha!==1;
		if (alphaChanged){
			var temp=this.globalAlpha;
			this.globalAlpha *=alpha;
		};
		var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
		if (m){
			this.save();
			this.transform(m.a,m.b,m.c,m.d,m.tx+x,m.ty+y);
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX ,args2[2]-pivotY,args2[3],args2[4]);
			this.restore();
			}else {
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX+x ,args2[2]-pivotY+y,args2[3],args2[4]);
		}
		if (alphaChanged)this.globalAlpha=temp;
	}

	__proto.fillTexture=function(texture,x,y,width,height,type,offset,other){
		if (!other.pat){
			if (texture.uv !=Texture.DEF_UV){
				var canvas=new HTMLCanvas("2D");
				canvas.getContext('2d');
				canvas.size(texture.width,texture.height);
				canvas.context.drawTexture(texture,0,0,texture.width,texture.height,0,0);
				texture=new Texture(canvas);
			}
			other.pat=this.createPattern(texture.bitmap.source,type);
		};
		var oX=x,oY=y;
		var sX=0,sY=0;
		if (offset){
			oX+=offset.x % texture.width;
			oY+=offset.y % texture.height;
			sX-=offset.x % texture.width;
			sY-=offset.y % texture.height;
		}
		this.translate(oX,oY);
		this.fillRect(sX,sY,width,height,other.pat);
		this.translate(-oX,-oY);
	}

	/***@private */
	__proto.flush=function(){
		return 0;
	}

	/***@private */
	__proto.fillWords=function(words,x,y,font,color,underLine){
		font && (this.font=font);
		color && (this.fillStyle=color);
		var _this=this;
		this.textBaseline="top";
		this.textAlign='left';
		for (var i=0,n=words.length;i < n;i++){
			var a=words[i];
			this.__fillText(a.char,a.x+x,a.y+y);
			if (underLine===1){
				var tHeight=a.height;
				var dX=a.style.letterSpacing*0.5;
				if (!dX)dX=0;
				this.beginPath();
				this.strokeStyle=color;
				this.lineWidth=1;
				this.moveTo(x+a.x-dX+0.5,y+a.y+tHeight+0.5);
				this.lineTo(x+a.x+a.width+dX+0.5,y+a.y+tHeight+0.5);
				this.stroke();
			}
		}
	}

	/***@private */
	__proto.fillBorderWords=function(words,x,y,font,color,borderColor,lineWidth){
		font && (this.font=font);
		color && (this.fillStyle=color);
		this.textBaseline="top";
		this.lineWidth=lineWidth;
		this.textAlign='left';
		this.strokeStyle=borderColor;
		for (var i=0,n=words.length;i < n;i++){
			var a=words[i];
			this.__strokeText(a.char,a.x+x,a.y+y);
			this.__fillText(a.char,a.x+x,a.y+y);
		}
	}

	/***@private */
	__proto.destroy=function(){
		this.canvas.width=this.canvas.height=0;
	}

	/***@private */
	__proto.clear=function(){
		this.clearRect(0,0,this._canvas.width,this._canvas.height);
		this._repaint=false;
	}

	__proto.drawCurves=function(x,y,args){
		this.beginPath();
		this.strokeStyle=args[3];
		this.lineWidth=args[4];
		var points=args[2];
		x+=args[0],y+=args[1];
		this.moveTo(x+points[0],y+points[1]);
		var i=2,n=points.length;
		while (i < n){
			this.quadraticCurveTo(x+points[i++],y+points[i++],x+points[i++],y+points[i++]);
		}
		this.stroke();
	}

	Context.__init__=function(to){
		var from=laya.resource.Context.prototype;
		to=to || CanvasRenderingContext2D.prototype;
		to.__fillText=to.fillText;
		to.__fillRect=to.fillRect;
		to.__strokeText=to.strokeText;
		var funs=['drawTextures','fillWords','fillBorderWords','setIsMainContext','fillRect','strokeText','fillTexture','fillText','transformByMatrix','setTransformByMatrix','clipRect','drawTexture','drawTexture2','drawTextureWithTransform','flush','clear','destroy','drawCanvas','fillBorderText','drawCurves'];
		funs.forEach(function(i){
			to[i]=from[i];
		});
	}

	Context.replaceCanvasGetSet=function(tar,key){
		var oldO=Object.getOwnPropertyDescriptor(tar,key);
		if (!oldO||!oldO.configurable)return false;
		var newO={};
		var tkey;
		for (tkey in oldO){
			if (tkey !="set"){
				newO[tkey]=oldO[tkey];
			}
		};
		var preFun=oldO["set"];
		newO["set"]=function (v){
			var _self=this;
			preFun.call(_self,v);
			var _ct=_self.getContext("2d");
			if (_ct && "__reset" in _ct){
				_ct.__reset();
			}
		}
		Object.defineProperty(tar,key,newO);
		return true;
	}

	Context.replaceGetSet=function(tar,key){
		var oldO=Object.getOwnPropertyDescriptor(tar,key);
		if (!oldO||!oldO.configurable)return false;
		var newO={};
		var tkey;
		for (tkey in oldO){
			if (tkey !="set"){
				newO[tkey]=oldO[tkey];
			}
		};
		var preFun=oldO["set"];
		var dataKey="___"+key+"__";
		Context.newKeys.push(dataKey);
		newO["set"]=function (v){
			var _self=this;
			if (v !=_self[dataKey]){
				_self[dataKey]=v;
				preFun.call(_self,v);
			}
		}
		Object.defineProperty(tar,key,newO);
		return true;
	}

	Context.newKeys=[];
	__static(Context,
	['_default',function(){return this._default=new Context();},'replaceKeys',function(){return this.replaceKeys=["font","fillStyle","textBaseline"];}
	]);
	return Context;
})()


/**
*@private
*<code>ResourceManager</code> 是资源管理类。它用于资源的载入、获取、销毁。
*/
//class laya.resource.ResourceManager
var ResourceManager=(function(){
	function ResourceManager(name){
		/**唯一标识ID。*/
		this._id=0;
		/**名字。*/
		this._name=null;
		/**所管理资源。*/
		this._resources=null;
		/**所管理资源的累计内存,以字节为单位。*/
		this._memorySize=0;
		/**垃圾回收比例，范围是0到1。*/
		this._garbageCollectionRate=NaN;
		/**自动释放机制中内存是否溢出。*/
		this._isOverflow=false;
		/**是否启用自动释放机制。*/
		this.autoRelease=false;
		/**自动释放机制的内存触发上限,以字节为单位。*/
		this.autoReleaseMaxSize=0;
		this._id=++ResourceManager._uniqueIDCounter;
		this._name=name ? name :"Content Manager";
		ResourceManager._isResourceManagersSorted=false;
		this._memorySize=0;
		this._isOverflow=false;
		this.autoRelease=false;
		this.autoReleaseMaxSize=1024 *1024 *512;
		this._garbageCollectionRate=0.2;
		ResourceManager._resourceManagers.push(this);
		this._resources=[];
	}

	__class(ResourceManager,'laya.resource.ResourceManager');
	var __proto=ResourceManager.prototype;
	Laya.imps(__proto,{"laya.resource.IDispose":true})
	/**
	*获取指定索引的资源 Resource 对象。
	*@param 索引。
	*@return 资源 Resource 对象。
	*/
	__proto.getResourceByIndex=function(index){
		return this._resources[index];
	}

	/**
	*获取此管理器所管理的资源个数。
	*@return 资源个数。
	*/
	__proto.getResourcesLength=function(){
		return this._resources.length;
	}

	/**
	*添加指定资源。
	*@param resource 需要添加的资源 Resource 对象。
	*@return 是否添加成功。
	*/
	__proto.addResource=function(resource){
		if (resource.resourceManager)
			resource.resourceManager.removeResource(resource);
		var index=this._resources.indexOf(resource);
		if (index===-1){
			resource._resourceManager=this;
			this._resources.push(resource);
			this.addSize(resource.memorySize);
			return true;
		}
		return false;
	}

	/**
	*移除指定资源。
	*@param resource 需要移除的资源 Resource 对象
	*@return 是否移除成功。
	*/
	__proto.removeResource=function(resource){
		var index=this._resources.indexOf(resource);
		if (index!==-1){
			this._resources.splice(index,1);
			resource._resourceManager=null;
			this._memorySize-=resource.memorySize;
			return true;
		}
		return false;
	}

	/**
	*卸载此资源管理器载入的资源。
	*/
	__proto.unload=function(){
		var tempResources=this._resources.slice(0,this._resources.length);
		for (var i=0;i < tempResources.length;i++){
			var resource=tempResources[i];
			resource.destroy();
		}
		tempResources.length=0;
	}

	/**释放资源。*/
	__proto.dispose=function(){
		if (this===ResourceManager._systemResourceManager)
			throw new Error("systemResourceManager不能被释放！");
		ResourceManager._resourceManagers.splice(ResourceManager._resourceManagers.indexOf(this),1);
		ResourceManager._isResourceManagersSorted=false;
		var tempResources=this._resources.slice(0,this._resources.length);
		for (var i=0;i < tempResources.length;i++){
			var resource=tempResources[i];
			resource.resourceManager.removeResource(resource);
			resource.destroy();
		}
		tempResources.length=0;
	}

	/**
	*增加内存。
	*@param add 需要增加的内存大小。
	*/
	__proto.addSize=function(add){
		if (add){
			if (this.autoRelease && add > 0)
				((this._memorySize+add)> this.autoReleaseMaxSize)&& (this.garbageCollection((1-this._garbageCollectionRate)*this.autoReleaseMaxSize));
			this._memorySize+=add;
		}
	}

	/**
	*垃圾回收。
	*@param reserveSize 保留尺寸。
	*/
	__proto.garbageCollection=function(reserveSize){
		var all=this._resources;
		all=all.slice();
		all.sort(function(a,b){
			if (!a || !b)
				throw new Error("a或b不能为空！");
			if (a.released && b.released)
				return 0;
			else if (a.released)
			return 1;
			else if (b.released)
			return-1;
			return a._lastUseFrameCount-b._lastUseFrameCount;
		});
		var currentFrameCount=Stat.loopCount;
		for (var i=0,n=all.length;i < n;i++){
			var resou=all[i];
			if (currentFrameCount-resou._lastUseFrameCount > 1){
				resou.releaseResource();
				}else {
				if (this._memorySize >=reserveSize)
					this._isOverflow=true;
				return;
			}
			if (this._memorySize < reserveSize){
				this._isOverflow=false;
				return;
			}
		}
	}

	/**
	*唯一标识 ID 。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	/**
	*名字。
	*/
	__getset(0,__proto,'name',function(){
		return this._name;
		},function(value){
		if ((value || value!=="")&& this._name!==value){
			this._name=value;
			ResourceManager._isResourceManagersSorted=false;
		}
	});

	/**
	*此管理器所管理资源的累计内存，以字节为单位。
	*/
	__getset(0,__proto,'memorySize',function(){
		return this._memorySize;
	});

	/**
	*系统资源管理器。
	*/
	__getset(1,ResourceManager,'systemResourceManager',function(){
		return ResourceManager._systemResourceManager;
	});

	ResourceManager.__init__=function(){
		ResourceManager.currentResourceManager=ResourceManager.systemResourceManager;
	}

	ResourceManager.getLoadedResourceManagerByIndex=function(index){
		return ResourceManager._resourceManagers[index];
	}

	ResourceManager.getLoadedResourceManagersCount=function(){
		return ResourceManager._resourceManagers.length;
	}

	ResourceManager.recreateContentManagers=function(force){
		(force===void 0)&& (force=false);
		var temp=ResourceManager.currentResourceManager;
		for (var i=0;i < ResourceManager._resourceManagers.length;i++){
			ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
			for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
				ResourceManager.currentResourceManager._resources[j].releaseResource(force);
				ResourceManager.currentResourceManager._resources[j].activeResource(force);
			}
		}
		ResourceManager.currentResourceManager=temp;
	}

	ResourceManager.releaseContentManagers=function(force){
		(force===void 0)&& (force=false);
		var temp=ResourceManager.currentResourceManager;
		for (var i=0;i < ResourceManager._resourceManagers.length;i++){
			ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
			for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
				var resource=ResourceManager.currentResourceManager._resources[j];
				(!resource.released)&& (resource.releaseResource(force));
			}
		}
		ResourceManager.currentResourceManager=temp;
	}

	ResourceManager._uniqueIDCounter=0;
	ResourceManager._isResourceManagersSorted=false;
	ResourceManager._resourceManagers=[];
	__static(ResourceManager,
	['_systemResourceManager',function(){return this._systemResourceManager=new ResourceManager("System Resource Manager");},'currentResourceManager',function(){return this.currentResourceManager=ResourceManager._systemResourceManager;}
	]);
	return ResourceManager;
})()


/**
*@private
*/
//class laya.system.System
var System=(function(){
	function System(){}
	__class(System,'laya.system.System');
	System.changeDefinition=function(name,classObj){
		Laya[name]=classObj;
		var str=name+"=classObj";
		eval(str);
	}

	System.__init__=function(){
		if (Render.isConchApp){
			conch.disableConchResManager();
			conch.disableConchAutoRestoreLostedDevice();
		}
	}

	return System;
})()


SoundManager;
/**
*<code>Browser</code> 是浏览器代理类。封装浏览器及原生 js 提供的一些功能。
*/
//class laya.utils.Browser
var Browser=(function(){
	function Browser(){}
	__class(Browser,'laya.utils.Browser');
	/**设备像素比。*/
	__getset(1,Browser,'pixelRatio',function(){
		Browser.__init__();
		if (Browser.userAgent.indexOf("Mozilla/6.0(Linux; Android 6.0; HUAWEI NXT-AL10 Build/HUAWEINXT-AL10)")>-1)return 2;
		return RunDriver.getPixelRatio();
	});

	/**浏览器窗口物理高度，其值等于clientHeight *pixelRatio，并且浏览器发生反转之后，宽高会互换。*/
	__getset(1,Browser,'height',function(){
		Browser.__init__();
		return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientWidth :Browser.clientHeight)*Browser.pixelRatio;
	});

	/**
	*浏览器窗口可视宽度。
	*通过分析浏览器信息获得。浏览器多个属性值优先级为：window.innerWidth(包含滚动条宽度)> document.body.clientWidth(不包含滚动条宽度)，如果前者为0或为空，则选择后者。
	*/
	__getset(1,Browser,'clientWidth',function(){
		Browser.__init__();
		return Browser.window.innerWidth || Browser.document.body.clientWidth;
	});

	/**浏览器原生 window 对象的引用。*/
	__getset(1,Browser,'window',function(){
		Browser.__init__();
		return Browser._window;
	});

	/**
	*浏览器窗口可视高度。
	*通过分析浏览器信息获得。浏览器多个属性值优先级为：window.innerHeight(包含滚动条高度)> document.body.clientHeight(不包含滚动条高度)> document.documentElement.clientHeight(不包含滚动条高度)，如果前者为0或为空，则选择后者。
	*/
	__getset(1,Browser,'clientHeight',function(){
		Browser.__init__();
		return Browser.window.innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight;
	});

	/**浏览器窗口物理宽度，其值等于clientWidth *pixelRatio，并且浏览器发生反转之后，宽高会互换。*/
	__getset(1,Browser,'width',function(){
		Browser.__init__();
		return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientHeight :Browser.clientWidth)*Browser.pixelRatio;
	});

	/**画布容器，用来盛放画布的容器。方便对画布进行控制*/
	__getset(1,Browser,'container',function(){
		Browser.__init__();
		if (!Browser._container){
			Browser._container=Browser.createElement("div");
			Browser._container.id="layaContainer";
			Browser.document.body.appendChild(Browser._container);
		}
		return Browser._container;
		},function(value){
		Browser._container=value;
	});

	/**浏览器原生 document 对象的引用。*/
	__getset(1,Browser,'document',function(){
		Browser.__init__();
		return Browser._document;
	});

	Browser.__init__=function(){
		SoundManager;
		if (Browser._window)return;
		Browser._window=RunDriver.getWindow();
		Browser._document=Browser.window.document;
		Browser._window.addEventListener('message',function(e){
			laya.utils.Browser._onMessage(e);
		},false);
		Browser.document.__createElement=Browser.document.createElement;
		window.requestAnimationFrame=window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (c){return window.setTimeout(c,1000 / 60);};;
		Browser.userAgent=Browser.window.navigator.userAgent;
		Browser.u=Browser.userAgent;
		Browser.onIOS=!!Browser.u.match(/\(i[^;]+;(U;)? CPU.+Mac OS X/);
		Browser.onMobile=Browser.u.indexOf("Mobile")>-1;
		Browser.onIPhone=Browser.u.indexOf("iPhone")>-1;
		Browser.onIPad=Browser.u.indexOf("iPad")>-1;
		Browser.onAndriod=Browser.u.indexOf('Android')>-1 || Browser.u.indexOf('Adr')>-1;
		Browser.onWP=Browser.u.indexOf("Windows Phone")>-1;
		Browser.onQQBrowser=Browser.u.indexOf("QQBrowser")>-1;
		Browser.onMQQBrowser=Browser.u.indexOf("MQQBrowser")>-1 || (Browser.u.indexOf("Mobile")>-1 && Browser.u.indexOf("QQ")>-1);
		Browser.onIE=!!Browser.window.ActiveXObject || "ActiveXObject" in Browser.window;
		Browser.onWeiXin=Browser.u.indexOf('MicroMessenger')>-1;
		Browser.onPC=!Browser.onMobile;
		Browser.onSafari=!!Browser.u.match(/Version\/\d+\.\d\x20Mobile\/\S+\x20Safari/);
		Browser.onFirefox=Browser.u.indexOf('Firefox')>-1;
		Browser.onEdge=Browser.u.indexOf('Edge')>-1;
		Browser.onMiniGame=Browser.u.indexOf('MiniGame')>-1;
		Browser.httpProtocol=Browser.window.location.protocol=="http:";
		Browser.webAudioEnabled=Browser.window["AudioContext"] || Browser.window["webkitAudioContext"] || Browser.window["mozAudioContext"] ? true :false;
		Browser.soundType=Browser.webAudioEnabled ? "WEBAUDIOSOUND" :"AUDIOSOUND";
		Sound=Browser.webAudioEnabled?WebAudioSound:AudioSound;;
		if (Browser.webAudioEnabled)WebAudioSound.initWebAudio();;
		AudioSound._initMusicAudio();
		Browser.enableTouch=(('ontouchstart' in window)|| window.DocumentTouch && document instanceof DocumentTouch);
		window.focus();
		SoundManager._soundClass=Sound;;
		Render._mainCanvas=Render._mainCanvas || HTMLCanvas.create('2D');
		if (Browser.canvas)return;
		Browser.canvas=HTMLCanvas.create('2D');
		Browser.context=Browser.canvas.getContext('2d');
	}

	Browser._onMessage=function(e){
		if (!e.data)return;
		if (e.data.name=="size"){
			Browser.window.innerWidth=e.data.width;
			Browser.window.innerHeight=e.data.height;
			Browser.window.__innerHeight=e.data.clientHeight;
			if (!Browser.document.createEvent){
				console.warn("no document.createEvent");
				return;
			};
			var evt=Browser.document.createEvent("HTMLEvents");
			evt.initEvent("resize",false,false);
			Browser.window.dispatchEvent(evt);
			return;
		}
	}

	Browser.createElement=function(type){
		Browser.__init__();
		return Browser.document.__createElement(type);
	}

	Browser.getElementById=function(type){
		Browser.__init__();
		return Browser.document.getElementById(type);
	}

	Browser.removeElement=function(ele){
		if (ele && ele.parentNode)ele.parentNode.removeChild(ele);
	}

	Browser.now=function(){
		return RunDriver.now();
	}

	Browser._window=null;
	Browser._document=null;
	Browser._container=null;
	Browser.userAgent=null;
	Browser.u=null;
	Browser.onIOS=false;
	Browser.onMobile=false;
	Browser.onIPhone=false;
	Browser.onIPad=false;
	Browser.onAndriod=false;
	Browser.onAndroid=false;
	Browser.onWP=false;
	Browser.onQQBrowser=false;
	Browser.onMQQBrowser=false;
	Browser.onSafari=false;
	Browser.onFirefox=false;
	Browser.onEdge=false;
	Browser.onIE=false;
	Browser.onWeiXin=false;
	Browser.onMiniGame=false;
	Browser.onPC=false;
	Browser.httpProtocol=false;
	Browser.webAudioEnabled=false;
	Browser.soundType=null;
	Browser.enableTouch=false;
	Browser.canvas=null;
	Browser.context=null;
	Browser.__init$=function(){
		AudioSound;
		WebAudioSound;
	}

	return Browser;
})()


/**
*<p> <code>Byte</code> 类提供用于优化读取、写入以及处理二进制数据的方法和属性。</p>
*<p><b>注意：</b> <code>Byte</code> 类适用于需要在字节层访问数据的高级开发人员。</p>
*/
//class laya.utils.Byte
var Byte=(function(){
	function Byte(data){
		/**
		*@private
		*是否为小端数据。
		*/
		this._xd_=true;
		this._allocated_=8;
		/**
		*@private
		*原始数据。
		*/
		//this._d_=null;
		/**
		*@private
		*DataView
		*/
		//this._u8d_=null;
		/**@private */
		this._pos_=0;
		/**@private */
		this._length=0;
		if (data){
			this._u8d_=new Uint8Array(data);
			this._d_=new DataView(this._u8d_.buffer);
			this._length=this._d_.byteLength;
			}else {
			this.___resizeBuffer(this._allocated_);
		}
	}

	__class(Byte,'laya.utils.Byte');
	var __proto=Byte.prototype;
	/**@private */
	__proto.___resizeBuffer=function(len){
		try {
			var newByteView=new Uint8Array(len);
			if (this._u8d_ !=null){
				if (this._u8d_.length <=len)newByteView.set(this._u8d_);
				else newByteView.set(this._u8d_.subarray(0,len));
			}
			this._u8d_=newByteView;
			this._d_=new DataView(newByteView.buffer);
			}catch (err){
			throw "___resizeBuffer err:"+len;
		}
	}

	/**
	*<p>常用于解析固定格式的字节流。</p>
	*<p>先从字节流的当前字节偏移位置处读取一个 <code>Uint16</code> 值，然后以此值为长度，读取此长度的字符串。</p>
	*@return 读取的字符串。
	*/
	__proto.getString=function(){
		return this.rUTF(this.getUint16());
	}

	/**
	*从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Float32Array</code> 对象并返回此对象。
	*@param start 开始位置。
	*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
	*@return 读取的 Float32Array 对象。
	*/
	__proto.getFloat32Array=function(start,len){
		var end=start+len;
		end=(end > this._length)? this._length :end;
		var v=new Float32Array(this._d_.buffer.slice(start,end));
		this._pos_=end;
		return v;
	}

	/**
	*从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Uint8Array</code> 对象并返回此对象。
	*@param start 开始位置。
	*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
	*@return 读取的 Uint8Array 对象。
	*/
	__proto.getUint8Array=function(start,len){
		var end=start+len;
		end=(end > this._length)? this._length :end;
		var v=new Uint8Array(this._d_.buffer.slice(start,end));
		this._pos_=end;
		return v;
	}

	/**
	*从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Int16Array</code> 对象并返回此对象。
	*@param start 开始读取的字节偏移量位置。
	*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
	*@return 读取的 Uint8Array 对象。
	*/
	__proto.getInt16Array=function(start,len){
		var end=start+len;
		end=(end > this._length)? this._length :end;
		var v=new Int16Array(this._d_.buffer.slice(start,end));
		this._pos_=end;
		return v;
	}

	/**
	*从字节流的当前字节偏移位置处读取一个 IEEE 754 单精度（32 位）浮点数。
	*@return 单精度（32 位）浮点数。
	*/
	__proto.getFloat32=function(){
		if (this._pos_+4 > this._length)throw "getFloat32 error - Out of bounds";
		var v=this._d_.getFloat32(this._pos_,this._xd_);
		this._pos_+=4;
		return v;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 IEEE 754 双精度（64 位）浮点数。
	*@return 双精度（64 位）浮点数。
	*/
	__proto.getFloat64=function(){
		if (this._pos_+8 > this._length)throw "getFloat64 error - Out of bounds";
		var v=this._d_.getFloat64(this._pos_,this._xd_);
		this._pos_+=8;
		return v;
	}

	/**
	*在字节流的当前字节偏移量位置处写入一个 IEEE 754 单精度（32 位）浮点数。
	*@param value 单精度（32 位）浮点数。
	*/
	__proto.writeFloat32=function(value){
		this.ensureWrite(this._pos_+4);
		this._d_.setFloat32(this._pos_,value,this._xd_);
		this._pos_+=4;
	}

	/**
	*在字节流的当前字节偏移量位置处写入一个 IEEE 754 双精度（64 位）浮点数。
	*@param value 双精度（64 位）浮点数。
	*/
	__proto.writeFloat64=function(value){
		this.ensureWrite(this._pos_+8);
		this._d_.setFloat64(this._pos_,value,this._xd_);
		this._pos_+=8;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 Int32 值。
	*@return Int32 值。
	*/
	__proto.getInt32=function(){
		if (this._pos_+4 > this._length)throw "getInt32 error - Out of bounds";
		var float=this._d_.getInt32(this._pos_,this._xd_);
		this._pos_+=4;
		return float;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 Uint32 值。
	*@return Uint32 值。
	*/
	__proto.getUint32=function(){
		if (this._pos_+4 > this._length)throw "getUint32 error - Out of bounds";
		var v=this._d_.getUint32(this._pos_,this._xd_);
		this._pos_+=4;
		return v;
	}

	/**
	*在字节流的当前字节偏移量位置处写入指定的 Int32 值。
	*@param value 需要写入的 Int32 值。
	*/
	__proto.writeInt32=function(value){
		this.ensureWrite(this._pos_+4);
		this._d_.setInt32(this._pos_,value,this._xd_);
		this._pos_+=4;
	}

	/**
	*在字节流的当前字节偏移量位置处写入 Uint32 值。
	*@param value 需要写入的 Uint32 值。
	*/
	__proto.writeUint32=function(value){
		this.ensureWrite(this._pos_+4);
		this._d_.setUint32(this._pos_,value,this._xd_);
		this._pos_+=4;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 Int16 值。
	*@return Int16 值。
	*/
	__proto.getInt16=function(){
		if (this._pos_+2 > this._length)throw "getInt16 error - Out of bounds";
		var us=this._d_.getInt16(this._pos_,this._xd_);
		this._pos_+=2;
		return us;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 Uint16 值。
	*@return Uint16 值。
	*/
	__proto.getUint16=function(){
		if (this._pos_+2 > this._length)throw "getUint16 error - Out of bounds";
		var us=this._d_.getUint16(this._pos_,this._xd_);
		this._pos_+=2;
		return us;
	}

	/**
	*在字节流的当前字节偏移量位置处写入指定的 Uint16 值。
	*@param value 需要写入的Uint16 值。
	*/
	__proto.writeUint16=function(value){
		this.ensureWrite(this._pos_+2);
		this._d_.setUint16(this._pos_,value,this._xd_);
		this._pos_+=2;
	}

	/**
	*在字节流的当前字节偏移量位置处写入指定的 Int16 值。
	*@param value 需要写入的 Int16 值。
	*/
	__proto.writeInt16=function(value){
		this.ensureWrite(this._pos_+2);
		this._d_.setInt16(this._pos_,value,this._xd_);
		this._pos_+=2;
	}

	/**
	*从字节流的当前字节偏移量位置处读取一个 Uint8 值。
	*@return Uint8 值。
	*/
	__proto.getUint8=function(){
		if (this._pos_+1 > this._length)throw "getUint8 error - Out of bounds";
		return this._d_.getUint8(this._pos_++);
	}

	/**
	*在字节流的当前字节偏移量位置处写入指定的 Uint8 值。
	*@param value 需要写入的 Uint8 值。
	*/
	__proto.writeUint8=function(value){
		this.ensureWrite(this._pos_+1);
		this._d_.setUint8(this._pos_,value);
		this._pos_++;
	}

	/**
	*@private
	*从字节流的指定字节偏移量位置处读取一个 Uint8 值。
	*@param pos 字节读取位置。
	*@return Uint8 值。
	*/
	__proto._getUInt8=function(pos){
		return this._d_.getUint8(pos);
	}

	/**
	*@private
	*从字节流的指定字节偏移量位置处读取一个 Uint16 值。
	*@param pos 字节读取位置。
	*@return Uint16 值。
	*/
	__proto._getUint16=function(pos){
		return this._d_.getUint16(pos,this._xd_);
	}

	/**
	*@private
	*使用 getFloat32()读取6个值，用于创建并返回一个 Matrix 对象。
	*@return Matrix 对象。
	*/
	__proto._getMatrix=function(){
		var rst=new Matrix(this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32());
		return rst;
	}

	/**
	*@private
	*读取指定长度的 UTF 型字符串。
	*@param len 需要读取的长度。
	*@return 读取的字符串。
	*/
	__proto.rUTF=function(len){
		var v="",max=this._pos_+len,c=0,c2=0,c3=0,f=String.fromCharCode;
		var u=this._u8d_,i=0;
		while (this._pos_ < max){
			c=u[this._pos_++];
			if (c < 0x80){
				if (c !=0){
					v+=f(c);
				}
				}else if (c < 0xE0){
				v+=f(((c & 0x3F)<< 6)| (u[this._pos_++] & 0x7F));
				}else if (c < 0xF0){
				c2=u[this._pos_++];
				v+=f(((c & 0x1F)<< 12)| ((c2 & 0x7F)<< 6)| (u[this._pos_++] & 0x7F));
				}else {
				c2=u[this._pos_++];
				c3=u[this._pos_++];
				v+=f(((c & 0x0F)<< 18)| ((c2 & 0x7F)<< 12)| ((c3 << 6)& 0x7F)| (u[this._pos_++] & 0x7F));
			}
			i++;
		}
		return v;
	}

	/**
	*@private
	*读取 <code>len</code> 参数指定的长度的字符串。
	*@param len 要读取的字符串的长度。
	*@return 指定长度的字符串。
	*/
	__proto.getCustomString=function(len){
		var v="",ulen=0,c=0,c2=0,f=String.fromCharCode;
		var u=this._u8d_,i=0;
		while (len > 0){
			c=u[this._pos_];
			if (c < 0x80){
				v+=f(c);
				this._pos_++;
				len--;
				}else {
				ulen=c-0x80;
				this._pos_++;
				len-=ulen;
				while (ulen > 0){
					c=u[this._pos_++];
					c2=u[this._pos_++];
					v+=f((c2 << 8)| c);
					ulen--;
				}
			}
		}
		return v;
	}

	/**
	*清除字节数组的内容，并将 length 和 pos 属性重置为 0。调用此方法将释放 Byte 实例占用的内存。
	*/
	__proto.clear=function(){
		this._pos_=0;
		this.length=0;
	}

	/**
	*@private
	*获取此对象的 ArrayBuffer 引用。
	*@return
	*/
	__proto.__getBuffer=function(){
		return this._d_.buffer;
	}

	/**
	*<p>将 UTF-8 字符串写入字节流。类似于 writeUTF()方法，但 writeUTFBytes()不使用 16 位长度的字为字符串添加前缀。</p>
	*<p>对应的读取方法为： getUTFBytes 。</p>
	*@param value 要写入的字符串。
	*/
	__proto.writeUTFBytes=function(value){
		value=value+"";
		for (var i=0,sz=value.length;i < sz;i++){
			var c=value.charCodeAt(i);
			if (c <=0x7F){
				this.writeByte(c);
				}else if (c <=0x7FF){
				this.ensureWrite(this._pos_+2);
				this._u8d_.set([0xC0 | (c >> 6),0x80 | (c & 0x3F)],this._pos_);
				this._pos_+=2;
				}else if (c <=0xFFFF){
				this.ensureWrite(this._pos_+3);
				this._u8d_.set([0xE0 | (c >> 12),0x80 | ((c >> 6)& 0x3F),0x80 | (c & 0x3F)],this._pos_);
				this._pos_+=3;
				}else {
				this.ensureWrite(this._pos_+4);
				this._u8d_.set([0xF0 | (c >> 18),0x80 | ((c >> 12)& 0x3F),0x80 | ((c >> 6)& 0x3F),0x80 | (c & 0x3F)],this._pos_);
				this._pos_+=4;
			}
		}
	}

	/**
	*<p>将 UTF-8 字符串写入字节流。先写入以字节表示的 UTF-8 字符串长度（作为 16 位整数），然后写入表示字符串字符的字节。</p>
	*<p>对应的读取方法为： getUTFString 。</p>
	*@param value 要写入的字符串值。
	*/
	__proto.writeUTFString=function(value){
		var tPos=this.pos;
		this.writeUint16(1);
		this.writeUTFBytes(value);
		var dPos=this.pos-tPos-2;
		if (dPos >=65536){
			throw "writeUTFString byte len more than 65536";
		}
		this._d_.setUint16(tPos,dPos,this._xd_);
	}

	/**
	*@private
	*读取 UTF-8 字符串。
	*@return 读取的字符串。
	*/
	__proto.readUTFString=function(){
		return this.readUTFBytes(this.getUint16());
	}

	/**
	*<p>从字节流中读取一个 UTF-8 字符串。假定字符串的前缀是一个无符号的短整型（以此字节表示要读取的长度）。</p>
	*<p>对应的写入方法为： writeUTFString 。</p>
	*@return 读取的字符串。
	*/
	__proto.getUTFString=function(){
		return this.readUTFString();
	}

	/**
	*@private
	*读字符串，必须是 writeUTFBytes 方法写入的字符串。
	*@param len 要读的buffer长度，默认将读取缓冲区全部数据。
	*@return 读取的字符串。
	*/
	__proto.readUTFBytes=function(len){
		(len===void 0)&& (len=-1);
		if (len==0)return "";
		var lastBytes=this.bytesAvailable;
		if (len > lastBytes)throw "readUTFBytes error - Out of bounds";
		len=len > 0 ? len :lastBytes;
		return this.rUTF(len);
	}

	/**
	*<p>从字节流中读取一个由 length 参数指定的长度的 UTF-8 字节序列，并返回一个字符串。</p>
	*<p>一般读取的是由 writeUTFBytes 方法写入的字符串。</p>
	*@param len 要读的buffer长度，默认将读取缓冲区全部数据。
	*@return 读取的字符串。
	*/
	__proto.getUTFBytes=function(len){
		(len===void 0)&& (len=-1);
		return this.readUTFBytes(len);
	}

	/**
	*<p>在字节流中写入一个字节。</p>
	*<p>使用参数的低 8 位。忽略高 24 位。</p>
	*@param value
	*/
	__proto.writeByte=function(value){
		this.ensureWrite(this._pos_+1);
		this._d_.setInt8(this._pos_,value);
		this._pos_+=1;
	}

	/**
	*@private
	*从字节流中读取带符号的字节。
	*/
	__proto.readByte=function(){
		if (this._pos_+1 > this._length)throw "readByte error - Out of bounds";
		return this._d_.getInt8(this._pos_++);
	}

	/**
	*<p>从字节流中读取带符号的字节。</p>
	*<p>返回值的范围是从-128 到 127。</p>
	*@return 介于-128 和 127 之间的整数。
	*/
	__proto.getByte=function(){
		return this.readByte();
	}

	/**
	*<p>保证该字节流的可用长度不小于 <code>lengthToEnsure</code> 参数指定的值。</p>
	*@param lengthToEnsure 指定的长度。
	*/
	__proto.ensureWrite=function(lengthToEnsure){
		if (this._length < lengthToEnsure)this._length=lengthToEnsure;
		if (this._allocated_ < lengthToEnsure)this.length=lengthToEnsure;
	}

	/**
	*<p>将指定 arraybuffer 对象中的以 offset 为起始偏移量， length 为长度的字节序列写入字节流。</p>
	*<p>如果省略 length 参数，则使用默认长度 0，该方法将从 offset 开始写入整个缓冲区；如果还省略了 offset 参数，则写入整个缓冲区。</p>
	*<p>如果 offset 或 length 小于0，本函数将抛出异常。</p>
	*$NEXTBIG 由于没有判断length和arraybuffer的合法性，当开发者填写了错误的length值时，会导致写入多余的空白数据甚至内存溢出，为了避免影响开发者正在使用此方法的功能，下个重大版本会修复这些问题。
	*@param arraybuffer 需要写入的 Arraybuffer 对象。
	*@param offset Arraybuffer 对象的索引的偏移量（以字节为单位）
	*@param length 从 Arraybuffer 对象写入到 Byte 对象的长度（以字节为单位）
	*/
	__proto.writeArrayBuffer=function(arraybuffer,offset,length){
		(offset===void 0)&& (offset=0);
		(length===void 0)&& (length=0);
		if (offset < 0 || length < 0)throw "writeArrayBuffer error - Out of bounds";
		if (length==0)length=arraybuffer.byteLength-offset;
		this.ensureWrite(this._pos_+length);
		var uint8array=new Uint8Array(arraybuffer);
		this._u8d_.set(uint8array.subarray(offset,offset+length),this._pos_);
		this._pos_+=length;
	}

	/**
	*获取此对象的 ArrayBuffer 数据，数据只包含有效数据部分。
	*/
	__getset(0,__proto,'buffer',function(){
		var rstBuffer=this._d_.buffer;
		if (rstBuffer.byteLength==this.length)return rstBuffer;
		return rstBuffer.slice(0,this.length);
	});

	/**
	*<p> <code>Byte</code> 实例的字节序。取值为：<code>BIG_ENDIAN</code> 或 <code>BIG_ENDIAN</code> 。</p>
	*<p>主机字节序，是 CPU 存放数据的两种不同顺序，包括小端字节序和大端字节序。通过 <code>getSystemEndian</code> 可以获取当前系统的字节序。</p>
	*<p> <code>BIG_ENDIAN</code> ：大端字节序，地址低位存储值的高位，地址高位存储值的低位。有时也称之为网络字节序。<br/>
	*<code>LITTLE_ENDIAN</code> ：小端字节序，地址低位存储值的低位，地址高位存储值的高位。</p>
	*/
	__getset(0,__proto,'endian',function(){
		return this._xd_ ? "littleEndian" :"bigEndian";
		},function(endianStr){
		this._xd_=(endianStr=="littleEndian");
	});

	/**
	*<p> <code>Byte</code> 对象的长度（以字节为单位）。</p>
	*<p>如果将长度设置为大于当前长度的值，则用零填充字节数组的右侧；如果将长度设置为小于当前长度的值，将会截断该字节数组。</p>
	*<p>如果要设置的长度大于当前已分配的内存空间的字节长度，则重新分配内存空间，大小为以下两者较大者：要设置的长度、当前已分配的长度的2倍，并将原有数据拷贝到新的内存空间中；如果要设置的长度小于当前已分配的内存空间的字节长度，也会重新分配内存空间，大小为要设置的长度，并将原有数据从头截断为要设置的长度存入新的内存空间中。</p>
	*/
	__getset(0,__proto,'length',function(){
		return this._length;
		},function(value){
		if (this._allocated_ < value)
			this.___resizeBuffer(this._allocated_=Math.floor(Math.max(value,this._allocated_ *2)));
		else if (this._allocated_ > value)
		this.___resizeBuffer(this._allocated_=value);
		this._length=value;
	});

	/**
	*移动或返回 Byte 对象的读写指针的当前位置（以字节为单位）。下一次调用读取方法时将在此位置开始读取，或者下一次调用写入方法时将在此位置开始写入。
	*/
	__getset(0,__proto,'pos',function(){
		return this._pos_;
		},function(value){
		this._pos_=value;
	});

	/**
	*可从字节流的当前位置到末尾读取的数据的字节数。
	*/
	__getset(0,__proto,'bytesAvailable',function(){
		return this._length-this._pos_;
	});

	Byte.getSystemEndian=function(){
		if (!Byte._sysEndian){
			var buffer=new ArrayBuffer(2);
			new DataView(buffer).setInt16(0,256,true);
			Byte._sysEndian=(new Int16Array(buffer))[0]===256 ? "littleEndian" :"bigEndian";
		}
		return Byte._sysEndian;
	}

	Byte.BIG_ENDIAN="bigEndian";
	Byte.LITTLE_ENDIAN="littleEndian";
	Byte._sysEndian=null;
	return Byte;
})()


/**
*@private
*对象缓存统一管理类
*/
//class laya.utils.CacheManager
var CacheManager=(function(){
	function CacheManager(){}
	__class(CacheManager,'laya.utils.CacheManager');
	CacheManager.regCacheByFunction=function(disposeFunction,getCacheListFunction){
		CacheManager.unRegCacheByFunction(disposeFunction,getCacheListFunction);
		var cache;
		cache={tryDispose:disposeFunction,getCacheList:getCacheListFunction};
		CacheManager._cacheList.push(cache);
	}

	CacheManager.unRegCacheByFunction=function(disposeFunction,getCacheListFunction){
		var i=0,len=0;
		len=CacheManager._cacheList.length;
		for (i=0;i < len;i++){
			if (CacheManager._cacheList[i].tryDispose==disposeFunction && CacheManager._cacheList[i].getCacheList==getCacheListFunction){
				CacheManager._cacheList.splice(i,1);
				return;
			}
		}
	}

	CacheManager.forceDispose=function(){
		var i=0,len=CacheManager._cacheList.length;
		for (i=0;i < len;i++){
			CacheManager._cacheList[i].tryDispose(true);
		}
	}

	CacheManager.beginCheck=function(waitTime){
		(waitTime===void 0)&& (waitTime=15000);
		Laya.timer.loop(waitTime,null,CacheManager._checkLoop);
	}

	CacheManager.stopCheck=function(){
		Laya.timer.clear(null,CacheManager._checkLoop);
	}

	CacheManager._checkLoop=function(){
		var cacheList=CacheManager._cacheList;
		if (cacheList.length < 1)return;
		var tTime=Browser.now();
		var count=0;
		var len=0;
		len=count=cacheList.length;
		while (count > 0){
			CacheManager._index++;
			CacheManager._index=CacheManager._index % len;
			cacheList[CacheManager._index].tryDispose(false);
			if (Browser.now()-tTime > CacheManager.loopTimeLimit)break ;
			count--;
		}
	}

	CacheManager.loopTimeLimit=2;
	CacheManager._cacheList=[];
	CacheManager._index=0;
	return CacheManager;
})()


/**
*<code>ClassUtils</code> 是一个类工具类。
*/
//class laya.utils.ClassUtils
var ClassUtils=(function(){
	function ClassUtils(){}
	__class(ClassUtils,'laya.utils.ClassUtils');
	ClassUtils.regClass=function(className,classDef){
		ClassUtils._classMap[className]=classDef;
	}

	ClassUtils.getRegClass=function(className){
		return ClassUtils._classMap[className];
	}

	ClassUtils.getInstance=function(className){
		var compClass=ClassUtils.getClass(className);
		if (compClass)
			return new compClass();
		else
		console.warn("[error] Undefined class:",className);
		return null;
	}

	ClassUtils.createByJson=function(json,node,root,customHandler,instanceHandler){
		if ((typeof json=='string'))
			json=JSON.parse(json);
		var props=json.props;
		if (!node){
			node=instanceHandler ? instanceHandler.runWith(json):ClassUtils.getInstance(props.runtime || json.type);
			if (!node)
				return null;
		};
		var child=json.child;
		if (child){
			for (var i=0,n=child.length;i < n;i++){
				var data=child[i];
				if ((data.props.name==="render" || data.props.renderType==="render")&& node["_$set_itemRender"])
					node.itemRender=data;
				else {
					if (data.type=="Graphic"){
						ClassUtils.addGraphicsToSprite(data,node);
						}else if (ClassUtils.isDrawType(data.type)){
						ClassUtils.addGraphicToSprite(data,node,true);
						}else {
						var tChild=ClassUtils.createByJson(data,null,root,customHandler,instanceHandler)
						if (data.type=="Script"){
							if (tChild.hasOwnProperty("owner")){
								tChild["owner"]=node;
								}else if (tChild.hasOwnProperty("target")){
								tChild["target"]=node;
							}
							}else if (data.props.renderType=="mask"){
							node.mask=tChild;
							}else {
							node.addChild(tChild);
						}
					}
				}
			}
		}
		if (props){
			for (var prop in props){
				var value=props[prop];
				if (prop==="var" && root){
					root[value]=node;
					}else if ((value instanceof Array)&& (typeof (node[prop])=='function')){
					node[prop].apply(node,value);
					}else {
					node[prop]=value;
				}
			}
		}
		if (customHandler && json.customProps){
			customHandler.runWith([node,json]);
		}
		if (node["created"])
			node.created();
		return node;
	}

	ClassUtils.addGraphicsToSprite=function(graphicO,sprite){
		var graphics;
		graphics=graphicO.child;
		if (!graphics || graphics.length < 1)
			return;
		var g;
		g=ClassUtils._getGraphicsFromSprite(graphicO,sprite);
		var ox=0;
		var oy=0;
		if (graphicO.props){
			ox=ClassUtils._getObjVar(graphicO.props,"x",0);
			oy=ClassUtils._getObjVar(graphicO.props,"y",0);
		}
		if (ox !=0 && oy !=0){
			g.translate(ox,oy);
		};
		var i=0,len=0;
		len=graphics.length;
		for (i=0;i < len;i++){
			ClassUtils._addGraphicToGraphics(graphics[i],g);
		}
		if (ox !=0 && oy !=0){
			g.translate(-ox,-oy);
		}
	}

	ClassUtils.addGraphicToSprite=function(graphicO,sprite,isChild){
		(isChild===void 0)&& (isChild=false);
		var g;
		g=isChild ? ClassUtils._getGraphicsFromSprite(graphicO,sprite):sprite.graphics;
		ClassUtils._addGraphicToGraphics(graphicO,g);
	}

	ClassUtils._getGraphicsFromSprite=function(dataO,sprite){
		var g;
		if (!dataO || !dataO.props)
			return sprite.graphics;
		var propsName;
		propsName=dataO.props.renderType;
		switch (propsName){
			case "hit":
			case "unHit":;
				var hitArea;
				if (!sprite.hitArea){
					sprite.hitArea=new HitArea();
				}
				hitArea=sprite.hitArea;
				if (!hitArea[propsName]){
					hitArea[propsName]=new Graphics();
				}
				g=hitArea[propsName];
				break ;
			default :
			}
		if (!g)
			g=sprite.graphics;
		return g;
	}

	ClassUtils._getTransformData=function(propsO){
		var m;
		if (propsO.hasOwnProperty("pivotX")|| propsO.hasOwnProperty("pivotY")){
			m=m || new Matrix();
			m.translate(-ClassUtils._getObjVar(propsO,"pivotX",0),-ClassUtils._getObjVar(propsO,"pivotY",0));
		};
		var sx=ClassUtils._getObjVar(propsO,"scaleX",1),sy=ClassUtils._getObjVar(propsO,"scaleY",1);
		var rotate=ClassUtils._getObjVar(propsO,"rotation",0);
		var skewX=ClassUtils._getObjVar(propsO,"skewX",0);
		var skewY=ClassUtils._getObjVar(propsO,"skewY",0);
		if (sx !=1 || sy !=1 || rotate !=0){
			m=m || new Matrix();
			m.scale(sx,sy);
			m.rotate(rotate *0.0174532922222222);
		}
		return m;
	}

	ClassUtils._addGraphicToGraphics=function(graphicO,graphic){
		var propsO;
		propsO=graphicO.props;
		if (!propsO)
			return;
		var drawConfig;
		drawConfig=ClassUtils.DrawTypeDic[graphicO.type];
		if (!drawConfig)
			return;
		var g;
		g=graphic;
		var m;
		var params=ClassUtils._getParams(propsO,drawConfig[1],drawConfig[2],drawConfig[3]);
		m=ClassUtils._tM;
		if (m || ClassUtils._alpha !=1){
			g.save();
			if (m)
				g.transform(m);
			if (ClassUtils._alpha !=1)
				g.alpha(ClassUtils._alpha);
		}
		g[drawConfig[0]].apply(g,params);
		if (m || ClassUtils._alpha !=1){
			g.restore();
		}
	}

	ClassUtils._adptLineData=function(params){
		params[2]=parseFloat(params[0])+parseFloat(params[2]);
		params[3]=parseFloat(params[1])+parseFloat(params[3]);
		return params;
	}

	ClassUtils._adptTextureData=function(params){
		params[0]=Loader.getRes(params[0]);
		return params;
	}

	ClassUtils._adptLinesData=function(params){
		params[2]=ClassUtils._getPointListByStr(params[2]);
		return params;
	}

	ClassUtils.isDrawType=function(type){
		if (type=="Image")
			return false;
		return ClassUtils.DrawTypeDic.hasOwnProperty(type);
	}

	ClassUtils._getParams=function(obj,params,xPos,adptFun){
		(xPos===void 0)&& (xPos=0);
		var rst;
		rst=ClassUtils._temParam;
		rst.length=params.length;
		var i=0,len=0;
		len=params.length;
		for (i=0;i < len;i++){
			rst[i]=ClassUtils._getObjVar(obj,params[i][0],params[i][1]);
		}
		ClassUtils._alpha=ClassUtils._getObjVar(obj,"alpha",1);
		var m;
		m=ClassUtils._getTransformData(obj);
		if (m){
			if (!xPos)xPos=0;
			m.translate(rst[xPos],rst[xPos+1]);
			rst[xPos]=rst[xPos+1]=0;
			ClassUtils._tM=m;
			}else {
			ClassUtils._tM=null;
		}
		if (adptFun && ClassUtils[adptFun]){
			rst=ClassUtils[adptFun](rst);
		}
		return rst;
	}

	ClassUtils._getPointListByStr=function(str){
		var pointArr;
		pointArr=str.split(",");
		var i=0,len=0;
		len=pointArr.length;
		for (i=0;i < len;i++){
			pointArr[i]=parseFloat(pointArr[i]);
		}
		return pointArr;
	}

	ClassUtils._getObjVar=function(obj,key,noValue){
		if (obj.hasOwnProperty(key)){
			return obj[key];
		}
		return noValue;
	}

	ClassUtils._temParam=[];
	ClassUtils.getClass=function(className){
		var classObject=ClassUtils._classMap[className] || className;
		if ((typeof classObject=='string'))
			return Laya["__classmap"][classObject];
		return classObject;
	}

	ClassUtils._tM=null;
	ClassUtils._alpha=NaN;
	__static(ClassUtils,
	['DrawTypeDic',function(){return this.DrawTypeDic={"Rect":["drawRect",[["x",0],["y",0],["width",0],["height",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Circle":["drawCircle",[["x",0],["y",0],["radius",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Pie":["drawPie",[["x",0],["y",0],["radius",0],["startAngle",0],["endAngle",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Image":["drawTexture",[["x",0],["y",0],["width",0],["height",0]]],"Texture":["drawTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0]],1,"_adptTextureData"],"FillTexture":["fillTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0],["repeat",null]],1,"_adptTextureData"],"FillText":["fillText",[["text",""],["x",0],["y",0],["font",null],["color",null],["textAlign",null]],1],"Line":["drawLine",[["x",0],["y",0],["toX",0],["toY",0],["lineColor",null],["lineWidth",0]],0,"_adptLineData"],"Lines":["drawLines",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Curves":["drawCurves",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Poly":["drawPoly",[["x",0],["y",0],["points",""],["fillColor",null],["lineColor",null],["lineWidth",1]],0,"_adptLinesData"]};},'_classMap',function(){return this._classMap={'Sprite':'laya.display.Sprite','Text':'laya.display.Text','Animation':'laya.display.Animation','Skeleton':'laya.ani.bone.Skeleton','Particle2D':'laya.particle.Particle2D','div':'laya.html.dom.HTMLDivElement','p':'laya.html.dom.HTMLElement','img':'laya.html.dom.HTMLImageElement','span':'laya.html.dom.HTMLElement','br':'laya.html.dom.HTMLBrElement','style':'laya.html.dom.HTMLStyleElement','font':'laya.html.dom.HTMLElement','a':'laya.html.dom.HTMLElement','#text':'laya.html.dom.HTMLElement'};}
	]);
	return ClassUtils;
})()


/**
*@private
*<code>Color</code> 是一个颜色值处理类。
*/
//class laya.utils.Color
var Color=(function(){
	function Color(str){
		/**@private */
		this._color=[];
		/**字符串型颜色值。*/
		//this.strColor=null;
		/**uint 型颜色值。*/
		//this.numColor=0;
		//this._drawStyle=null;
		if ((typeof str=='string')){
			this.strColor=str;
			if (str===null)str="#000000";
			str.charAt(0)=='#' && (str=str.substr(1));
			var len=str.length;
			if (len==3 || len==4){
				var temp="";
				for (var i=0;i < len;i++){
					temp+=(str[i]+str[i]);
				}
				str=temp;
			};
			var color=this.numColor=parseInt(str,16);
			var flag=(str.length==8);
			if (flag){
				this._color=[parseInt(str.substr(0,2),16)/ 255,((0x00FF0000 & color)>> 16)/ 255,((0x0000FF00 & color)>> 8)/ 255,(0x000000FF & color)/ 255];
				return;
			}
			}else {
			color=this.numColor=str;
			this.strColor=Utils.toHexColor(color);
		}
		this._color=[((0xFF0000 & color)>> 16)/ 255,((0xFF00 & color)>> 8)/ 255,(0xFF & color)/ 255,1];
		(this._color).__id=++Color._COLODID;
	}

	__class(Color,'laya.utils.Color');
	Color._initDefault=function(){
		Color._DEFAULT={};
		for (var i in Color._COLOR_MAP)Color._SAVE[i]=Color._DEFAULT[i]=new Color(Color._COLOR_MAP[i]);
		return Color._DEFAULT;
	}

	Color._initSaveMap=function(){
		Color._SAVE_SIZE=0;
		Color._SAVE={};
		for (var i in Color._DEFAULT)Color._SAVE[i]=Color._DEFAULT[i];
	}

	Color.create=function(str){
		var color=Color._SAVE[str+""];
		if (color !=null)return color;
		(Color._SAVE_SIZE < 1000)|| Color._initSaveMap();
		return Color._SAVE[str+""]=new Color(str);
	}

	Color._SAVE={};
	Color._SAVE_SIZE=0;
	Color._COLODID=1;
	__static(Color,
	['_COLOR_MAP',function(){return this._COLOR_MAP={"white":'#FFFFFF',"red":'#FF0000',"green":'#00FF00',"blue":'#0000FF',"black":'#000000',"yellow":'#FFFF00','gray':'#AAAAAA'};},'_DEFAULT',function(){return this._DEFAULT=Color._initDefault();}
	]);
	return Color;
})()


/**
*@private
*<code>Dragging</code> 类是触摸滑动控件。
*/
//class laya.utils.Dragging
var Dragging=(function(){
	function Dragging(){
		/**被拖动的对象。*/
		//this.target=null;
		/**缓动衰减系数。*/
		this.ratio=0.92;
		/**单帧最大偏移量。*/
		this.maxOffset=60;
		/**滑动范围。*/
		//this.area=null;
		/**表示拖动是否有惯性。*/
		//this.hasInertia=false;
		/**橡皮筋最大值。*/
		//this.elasticDistance=NaN;
		/**橡皮筋回弹时间，单位为毫秒。*/
		//this.elasticBackTime=NaN;
		/**事件携带数据。*/
		//this.data=null;
		this._dragging=false;
		this._clickOnly=true;
		//this._elasticRateX=NaN;
		//this._elasticRateY=NaN;
		//this._lastX=NaN;
		//this._lastY=NaN;
		//this._offsetX=NaN;
		//this._offsetY=NaN;
		//this._offsets=null;
		//this._disableMouseEvent=false;
		//this._tween=null;
		//this._parent=null;
	}

	__class(Dragging,'laya.utils.Dragging');
	var __proto=Dragging.prototype;
	/**
	*开始拖拽。
	*@param target 待拖拽的 <code>Sprite</code> 对象。
	*@param area 滑动范围。
	*@param hasInertia 拖动是否有惯性。
	*@param elasticDistance 橡皮筋最大值。
	*@param elasticBackTime 橡皮筋回弹时间，单位为毫秒。
	*@param data 事件携带数据。
	*@param disableMouseEvent 鼠标事件是否有效。
	*@param ratio 惯性阻尼系数
	*/
	__proto.start=function(target,area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio){
		(ratio===void 0)&& (ratio=0.92);
		this.clearTimer();
		this.target=target;
		this.area=area;
		this.hasInertia=hasInertia;
		this.elasticDistance=area ? elasticDistance :0;
		this.elasticBackTime=elasticBackTime;
		this.data=data;
		this._disableMouseEvent=disableMouseEvent;
		this.ratio=ratio;
		if (target.globalScaleX !=1 || target.globalScaleY !=1){
			this._parent=target.parent;
			}else {
			this._parent=Laya.stage;
		}
		this._clickOnly=true;
		this._dragging=true;
		this._elasticRateX=this._elasticRateY=1;
		this._lastX=this._parent.mouseX;
		this._lastY=this._parent.mouseY;
		Laya.stage.on("mouseup",this,this.onStageMouseUp);
		Laya.stage.on("mouseout",this,this.onStageMouseUp);
		Laya.timer.frameLoop(1,this,this.loop);
	}

	/**
	*清除计时器。
	*/
	__proto.clearTimer=function(){
		Laya.timer.clear(this,this.loop);
		Laya.timer.clear(this,this.tweenMove);
		if (this._tween){
			this._tween.recover();
			this._tween=null;
		}
	}

	/**
	*停止拖拽。
	*/
	__proto.stop=function(){
		if (this._dragging){
			MouseManager.instance.disableMouseEvent=false;
			Laya.stage.off("mouseup",this,this.onStageMouseUp);
			Laya.stage.off("mouseout",this,this.onStageMouseUp);
			this._dragging=false;
			this.target && this.area && this.backToArea();
			this.clear();
		}
	}

	/**
	*拖拽的循环处理函数。
	*/
	__proto.loop=function(){
		var point=this._parent.getMousePoint();
		var mouseX=point.x;
		var mouseY=point.y;
		var offsetX=mouseX-this._lastX;
		var offsetY=mouseY-this._lastY;
		if (this._clickOnly){
			if (Math.abs(offsetX *Laya.stage._canvasTransform.getScaleX())> 1 || Math.abs(offsetY *Laya.stage._canvasTransform.getScaleY())> 1){
				this._clickOnly=false;
				this._offsets || (this._offsets=[]);
				this._offsets.length=0;
				this.target.event("dragstart",this.data);
				MouseManager.instance.disableMouseEvent=this._disableMouseEvent;
				this.target._set$P("$_MOUSEDOWN",false);
			}else return;
			}else {
			this._offsets.push(offsetX,offsetY);
		}
		if (offsetX===0 && offsetY===0)return;
		this._lastX=mouseX;
		this._lastY=mouseY;
		this.target.x+=offsetX *this._elasticRateX;
		this.target.y+=offsetY *this._elasticRateY;
		this.area && this.checkArea();
		this.target.event("dragmove",this.data);
	}

	/**
	*拖拽区域检测。
	*/
	__proto.checkArea=function(){
		if (this.elasticDistance <=0){
			this.backToArea();
			}else {
			if (this.target.x < this.area.x){
				var offsetX=this.area.x-this.target.x;
				}else if (this.target.x > this.area.x+this.area.width){
				offsetX=this.target.x-this.area.x-this.area.width;
				}else {
				offsetX=0;
			}
			this._elasticRateX=Math.max(0,1-(offsetX / this.elasticDistance));
			if (this.target.y < this.area.y){
				var offsetY=this.area.y-this.target.y;
				}else if (this.target.y > this.area.y+this.area.height){
				offsetY=this.target.y-this.area.y-this.area.height;
				}else {
				offsetY=0;
			}
			this._elasticRateY=Math.max(0,1-(offsetY / this.elasticDistance));
		}
	}

	/**
	*移动至设定的拖拽区域。
	*/
	__proto.backToArea=function(){
		this.target.x=Math.min(Math.max(this.target.x,this.area.x),this.area.x+this.area.width);
		this.target.y=Math.min(Math.max(this.target.y,this.area.y),this.area.y+this.area.height);
	}

	/**
	*舞台的抬起事件侦听函数。
	*@param e Event 对象。
	*/
	__proto.onStageMouseUp=function(e){
		MouseManager.instance.disableMouseEvent=false;
		Laya.stage.off("mouseup",this,this.onStageMouseUp);
		Laya.stage.off("mouseout",this,this.onStageMouseUp);
		Laya.timer.clear(this,this.loop);
		if (this._clickOnly || !this.target)return;
		if (this.hasInertia){
			if (this._offsets.length < 1){
				this._offsets.push(this._parent.mouseX-this._lastX,this._parent.mouseY-this._lastY);
			}
			this._offsetX=this._offsetY=0;
			var len=this._offsets.length;
			var n=Math.min(len,6);
			var m=this._offsets.length-n;
			for (var i=len-1;i > m;i--){
				this._offsetY+=this._offsets[i--];
				this._offsetX+=this._offsets[i];
			}
			this._offsetX=this._offsetX / n *2;
			this._offsetY=this._offsetY / n *2;
			if (Math.abs(this._offsetX)> this.maxOffset)this._offsetX=this._offsetX > 0 ? this.maxOffset :-this.maxOffset;
			if (Math.abs(this._offsetY)> this.maxOffset)this._offsetY=this._offsetY > 0 ? this.maxOffset :-this.maxOffset;
			Laya.timer.frameLoop(1,this,this.tweenMove);
			}else if (this.elasticDistance > 0){
			this.checkElastic();
			}else {
			this.clear();
		}
	}

	/**
	*橡皮筋效果检测。
	*/
	__proto.checkElastic=function(){
		var tx=NaN;
		var ty=NaN;
		if (this.target.x < this.area.x)tx=this.area.x;
		else if (this.target.x > this.area.x+this.area.width)tx=this.area.x+this.area.width;
		if (this.target.y < this.area.y)ty=this.area.y;
		else if (this.target.y > this.area.y+this.area.height)ty=this.area.y+this.area.height;
		if (!isNaN(tx)|| !isNaN(ty)){
			var obj={};
			if (!isNaN(tx))obj.x=tx;
			if (!isNaN(ty))obj.y=ty;
			this._tween=Tween.to(this.target,obj,this.elasticBackTime,Ease.sineOut,Handler.create(this,this.clear),0,false,false);
			}else {
			this.clear();
		}
	}

	/**
	*移动。
	*/
	__proto.tweenMove=function(){
		this._offsetX *=this.ratio *this._elasticRateX;
		this._offsetY *=this.ratio *this._elasticRateY;
		this.target.x+=this._offsetX;
		this.target.y+=this._offsetY;
		this.area && this.checkArea();
		this.target.event("dragmove",this.data);
		if ((Math.abs(this._offsetX)< 1 && Math.abs(this._offsetY)< 1)|| this._elasticRateX < 0.5 || this._elasticRateY < 0.5){
			Laya.timer.clear(this,this.tweenMove);
			if (this.elasticDistance > 0)this.checkElastic();
			else this.clear();
		}
	}

	/**
	*结束拖拽。
	*/
	__proto.clear=function(){
		if (this.target){
			this.clearTimer();
			var sp=this.target;
			this.target=null;
			this._parent=null;
			sp.event("dragend",this.data);
		}
	}

	return Dragging;
})()


/**
*<code>Ease</code> 类定义了缓动函数，以便实现 <code>Tween</code> 动画的缓动效果。
*/
//class laya.utils.Ease
var Ease=(function(){
	function Ease(){}
	__class(Ease,'laya.utils.Ease');
	Ease.linearNone=function(t,b,c,d){
		return c *t / d+b;
	}

	Ease.linearIn=function(t,b,c,d){
		return c *t / d+b;
	}

	Ease.linearInOut=function(t,b,c,d){
		return c *t / d+b;
	}

	Ease.linearOut=function(t,b,c,d){
		return c *t / d+b;
	}

	Ease.bounceIn=function(t,b,c,d){
		return c-Ease.bounceOut(d-t,0,c,d)+b;
	}

	Ease.bounceInOut=function(t,b,c,d){
		if (t < d *0.5)return Ease.bounceIn(t *2,0,c,d)*.5+b;
		else return Ease.bounceOut(t *2-d,0,c,d)*.5+c *.5+b;
	}

	Ease.bounceOut=function(t,b,c,d){
		if ((t /=d)< (1 / 2.75))return c *(7.5625 *t *t)+b;
		else if (t < (2 / 2.75))return c *(7.5625 *(t-=(1.5 / 2.75))*t+.75)+b;
		else if (t < (2.5 / 2.75))return c *(7.5625 *(t-=(2.25 / 2.75))*t+.9375)+b;
		else return c *(7.5625 *(t-=(2.625 / 2.75))*t+.984375)+b;
	}

	Ease.backIn=function(t,b,c,d,s){
		(s===void 0)&& (s=1.70158);
		return c *(t /=d)*t *((s+1)*t-s)+b;
	}

	Ease.backInOut=function(t,b,c,d,s){
		(s===void 0)&& (s=1.70158);
		if ((t /=d *0.5)< 1)return c *0.5 *(t *t *(((s *=(1.525))+1)*t-s))+b;
		return c / 2 *((t-=2)*t *(((s *=(1.525))+1)*t+s)+2)+b;
	}

	Ease.backOut=function(t,b,c,d,s){
		(s===void 0)&& (s=1.70158);
		return c *((t=t / d-1)*t *((s+1)*t+s)+1)+b;
	}

	Ease.elasticIn=function(t,b,c,d,a,p){
		(a===void 0)&& (a=0);
		(p===void 0)&& (p=0);
		var s;
		if (t==0)return b;
		if ((t /=d)==1)return b+c;
		if (!p)p=d *.3;
		if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
			a=c;
			s=p / 4;
		}else s=p / Ease.PI2 *Math.asin(c / a);
		return-(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
	}

	Ease.elasticInOut=function(t,b,c,d,a,p){
		(a===void 0)&& (a=0);
		(p===void 0)&& (p=0);
		var s;
		if (t==0)return b;
		if ((t /=d *0.5)==2)return b+c;
		if (!p)p=d *(.3 *1.5);
		if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
			a=c;
			s=p / 4;
		}else s=p / Ease.PI2 *Math.asin(c / a);
		if (t < 1)return-.5 *(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
		return a *Math.pow(2,-10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p)*.5+c+b;
	}

	Ease.elasticOut=function(t,b,c,d,a,p){
		(a===void 0)&& (a=0);
		(p===void 0)&& (p=0);
		var s;
		if (t==0)return b;
		if ((t /=d)==1)return b+c;
		if (!p)p=d *.3;
		if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
			a=c;
			s=p / 4;
		}else s=p / Ease.PI2 *Math.asin(c / a);
		return (a *Math.pow(2,-10 *t)*Math.sin((t *d-s)*Ease.PI2 / p)+c+b);
	}

	Ease.strongIn=function(t,b,c,d){
		return c *(t /=d)*t *t *t *t+b;
	}

	Ease.strongInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
		return c *0.5 *((t-=2)*t *t *t *t+2)+b;
	}

	Ease.strongOut=function(t,b,c,d){
		return c *((t=t / d-1)*t *t *t *t+1)+b;
	}

	Ease.sineInOut=function(t,b,c,d){
		return-c *0.5 *(Math.cos(Math.PI *t / d)-1)+b;
	}

	Ease.sineIn=function(t,b,c,d){
		return-c *Math.cos(t / d *Ease.HALF_PI)+c+b;
	}

	Ease.sineOut=function(t,b,c,d){
		return c *Math.sin(t / d *Ease.HALF_PI)+b;
	}

	Ease.quintIn=function(t,b,c,d){
		return c *(t /=d)*t *t *t *t+b;
	}

	Ease.quintInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
		return c *0.5 *((t-=2)*t *t *t *t+2)+b;
	}

	Ease.quintOut=function(t,b,c,d){
		return c *((t=t / d-1)*t *t *t *t+1)+b;
	}

	Ease.quartIn=function(t,b,c,d){
		return c *(t /=d)*t *t *t+b;
	}

	Ease.quartInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t+b;
		return-c *0.5 *((t-=2)*t *t *t-2)+b;
	}

	Ease.quartOut=function(t,b,c,d){
		return-c *((t=t / d-1)*t *t *t-1)+b;
	}

	Ease.cubicIn=function(t,b,c,d){
		return c *(t /=d)*t *t+b;
	}

	Ease.cubicInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return c *0.5 *t *t *t+b;
		return c *0.5 *((t-=2)*t *t+2)+b;
	}

	Ease.cubicOut=function(t,b,c,d){
		return c *((t=t / d-1)*t *t+1)+b;
	}

	Ease.quadIn=function(t,b,c,d){
		return c *(t /=d)*t+b;
	}

	Ease.quadInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return c *0.5 *t *t+b;
		return-c *0.5 *((--t)*(t-2)-1)+b;
	}

	Ease.quadOut=function(t,b,c,d){
		return-c *(t /=d)*(t-2)+b;
	}

	Ease.expoIn=function(t,b,c,d){
		return (t==0)? b :c *Math.pow(2,10 *(t / d-1))+b-c *0.001;
	}

	Ease.expoInOut=function(t,b,c,d){
		if (t==0)return b;
		if (t==d)return b+c;
		if ((t /=d *0.5)< 1)return c *0.5 *Math.pow(2,10 *(t-1))+b;
		return c *0.5 *(-Math.pow(2,-10 *--t)+2)+b;
	}

	Ease.expoOut=function(t,b,c,d){
		return (t==d)? b+c :c *(-Math.pow(2,-10 *t / d)+1)+b;
	}

	Ease.circIn=function(t,b,c,d){
		return-c *(Math.sqrt(1-(t /=d)*t)-1)+b;
	}

	Ease.circInOut=function(t,b,c,d){
		if ((t /=d *0.5)< 1)return-c *0.5 *(Math.sqrt(1-t *t)-1)+b;
		return c *0.5 *(Math.sqrt(1-(t-=2)*t)+1)+b;
	}

	Ease.circOut=function(t,b,c,d){
		return c *Math.sqrt(1-(t=t / d-1)*t)+b;
	}

	__static(Ease,
	['HALF_PI',function(){return this.HALF_PI=Math.PI *0.5;},'PI2',function(){return this.PI2=Math.PI *2;}
	]);
	return Ease;
})()


/**
*鼠标点击区域，可以设置绘制一系列矢量图作为点击区域和非点击区域（目前只支持圆形，矩形，多边形）
*/
//class laya.utils.HitArea
var HitArea=(function(){
	function HitArea(){
		/**@private */
		this._hit=null;
		/**@private */
		this._unHit=null;
	}

	__class(HitArea,'laya.utils.HitArea');
	var __proto=HitArea.prototype;
	/**
	*是否包含某个点
	*@param x x坐标
	*@param y y坐标
	*@return 是否点击到
	*/
	__proto.isHit=function(x,y){
		if (!HitArea.isHitGraphic(x,y,this.hit))return false;
		return !HitArea.isHitGraphic(x,y,this.unHit);
	}

	/**
	*检测对象是否包含指定的点。
	*@param x 点的 X 轴坐标值（水平位置）。
	*@param y 点的 Y 轴坐标值（垂直位置）。
	*@return 如果包含指定的点，则值为 true；否则为 false。
	*/
	__proto.contains=function(x,y){
		return this.isHit(x,y);
	}

	/**
	*可点击区域，可以设置绘制一系列矢量图作为点击区域（目前只支持圆形，矩形，多边形）
	*/
	__getset(0,__proto,'hit',function(){
		if (!this._hit)this._hit=new Graphics();
		return this._hit;
		},function(value){
		this._hit=value;
	});

	/**
	*不可点击区域，可以设置绘制一系列矢量图作为非点击区域（目前只支持圆形，矩形，多边形）
	*/
	__getset(0,__proto,'unHit',function(){
		if (!this._unHit)this._unHit=new Graphics();
		return this._unHit;
		},function(value){
		this._unHit=value;
	});

	HitArea.isHitGraphic=function(x,y,graphic){
		if (!graphic)return false;
		var cmds;
		cmds=graphic.cmds;
		if (!cmds && graphic._one){
			cmds=HitArea._cmds;
			cmds.length=1;
			cmds[0]=graphic._one;
		}
		if (!cmds)return false;
		var i=0,len=0;
		len=cmds.length;
		var cmd;
		for (i=0;i < len;i++){
			cmd=cmds[i];
			if (!cmd)continue ;
			var context=Render._context;
			switch (cmd.callee){
				case context._translate:
				case 6:
					x-=cmd[0];
					y-=cmd[1];
				default :
				}
			if (HitArea.isHitCmd(x,y,cmd))return true;
		}
		return false;
	}

	HitArea.isHitCmd=function(x,y,cmd){
		if (!cmd)return false;
		var context=Render._context;
		var rst=false;
		switch (cmd["callee"]){
			case context._drawRect:
			case 13:
				HitArea._rec.setTo(cmd[0],cmd[1],cmd[2],cmd[3]);
				rst=HitArea._rec.contains(x,y);
				break ;
			case context._drawCircle:
			case context._fillCircle:
			case 14:;
				var d=NaN;
				x-=cmd[0];
				y-=cmd[1];
				d=x *x+y *y;
				rst=d < cmd[2] *cmd[2];
				break ;
			case context._drawPoly:
			case 18:
				x-=cmd[0];
				y-=cmd[1];
				rst=HitArea.ptInPolygon(x,y,cmd[2]);
				break ;
			default :
				break ;
			}
		return rst;
	}

	HitArea.ptInPolygon=function(x,y,areaPoints){
		var p;
		p=HitArea._ptPoint;
		p.setTo(x,y);
		var nCross=0;
		var p1x=NaN,p1y=NaN,p2x=NaN,p2y=NaN;
		var len=0;
		len=areaPoints.length;
		for (var i=0;i < len;i+=2){
			p1x=areaPoints[i];
			p1y=areaPoints[i+1];
			p2x=areaPoints[(i+2)% len];
			p2y=areaPoints[(i+3)% len];
			if (p1y==p2y)
				continue ;
			if (p.y < Math.min(p1y,p2y))
				continue ;
			if (p.y >=Math.max(p1y,p2y))
				continue ;
			var tx=(p.y-p1y)*(p2x-p1x)/ (p2y-p1y)+p1x;
			if (tx > p.x){
				nCross++;
			}
		}
		return (nCross % 2==1);
	}

	HitArea._cmds=[];
	__static(HitArea,
	['_rec',function(){return this._rec=new Rectangle();},'_ptPoint',function(){return this._ptPoint=new Point();}
	]);
	return HitArea;
})()


/**
*@private
*<code>HTMLChar</code> 是一个 HTML 字符类。
*/
//class laya.utils.HTMLChar
var HTMLChar=(function(){
	function HTMLChar(char,w,h,style){
		//this._sprite=null;
		//this._x=NaN;
		//this._y=NaN;
		//this._w=NaN;
		//this._h=NaN;
		/**表示是否是正常单词(英文|.|数字)。*/
		//this.isWord=false;
		/**字符。*/
		//this.char=null;
		/**字符数量。*/
		//this.charNum=NaN;
		/**CSS 样式。*/
		//this.style=null;
		this.char=char;
		this.charNum=char.charCodeAt(0);
		this._x=this._y=0;
		this.width=w;
		this.height=h;
		this.style=style;
		this.isWord=!HTMLChar._isWordRegExp.test(char);
	}

	__class(HTMLChar,'laya.utils.HTMLChar');
	var __proto=HTMLChar.prototype;
	Laya.imps(__proto,{"laya.display.ILayout":true})
	/**
	*设置与此对象绑定的显示对象 <code>Sprite</code> 。
	*@param sprite 显示对象 <code>Sprite</code> 。
	*/
	__proto.setSprite=function(sprite){
		this._sprite=sprite;
	}

	/**
	*获取与此对象绑定的显示对象 <code>Sprite</code>。
	*@return
	*/
	__proto.getSprite=function(){
		return this._sprite;
	}

	/**@private */
	__proto._isChar=function(){
		return true;
	}

	/**@private */
	__proto._getCSSStyle=function(){
		return this.style;
	}

	/**
	*宽度。
	*/
	__getset(0,__proto,'width',function(){
		return this._w;
		},function(value){
		this._w=value;
	});

	/**
	*此对象存储的 X 轴坐标值。
	*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 x 的值。
	*/
	__getset(0,__proto,'x',function(){
		return this._x;
		},function(value){
		if (this._sprite){
			this._sprite.x=value;
		}
		this._x=value;
	});

	/**
	*此对象存储的 Y 轴坐标值。
	*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 y 的值。
	*/
	__getset(0,__proto,'y',function(){
		return this._y;
		},function(value){
		if (this._sprite){
			this._sprite.y=value;
		}
		this._y=value;
	});

	/**
	*高度。
	*/
	__getset(0,__proto,'height',function(){
		return this._h;
		},function(value){
		this._h=value;
	});

	__static(HTMLChar,
	['_isWordRegExp',function(){return this._isWordRegExp=new RegExp("[\\w\.]","");}
	]);
	return HTMLChar;
})()


/**
*<p> <code>Pool</code> 是对象池类，用于对象的存贮、重复使用。</p>
*<p>合理使用对象池，可以有效减少对象创建的开销，避免频繁的垃圾回收，从而优化游戏流畅度。</p>
*/
//class laya.utils.Pool
var Pool=(function(){
	function Pool(){}
	__class(Pool,'laya.utils.Pool');
	Pool.getPoolBySign=function(sign){
		return Pool._poolDic[sign] || (Pool._poolDic[sign]=[]);
	}

	Pool.clearBySign=function(sign){
		if (Pool._poolDic[sign])Pool._poolDic[sign].length=0;
	}

	Pool.recover=function(sign,item){
		if (item["__InPool"])return;
		item["__InPool"]=true;
		Pool.getPoolBySign(sign).push(item);
	}

	Pool.getItemByClass=function(sign,cls){
		var pool=Pool.getPoolBySign(sign);
		var rst=pool.length ? pool.pop():new cls();
		rst["__InPool"]=false;
		return rst;
	}

	Pool.getItemByCreateFun=function(sign,createFun){
		var pool=Pool.getPoolBySign(sign);
		var rst=pool.length ? pool.pop():createFun();
		rst["__InPool"]=false;
		return rst;
	}

	Pool.getItem=function(sign){
		var pool=Pool.getPoolBySign(sign);
		var rst=pool.length ? pool.pop():null;
		if (rst){
			rst["__InPool"]=false;
		}
		return rst;
	}

	Pool._poolDic={};
	Pool.InPoolSign="__InPool";
	return Pool;
})()


/**
*<p> <code>Stat</code> 是一个性能统计面板，可以实时更新相关的性能参数。</p>
*<p>参与统计的性能参数如下（所有参数都是每大约1秒进行更新）：<br/>
*FPS(Canvas)/FPS(WebGL)：Canvas 模式或者 WebGL 模式下的帧频，也就是每秒显示的帧数，值越高、越稳定，感觉越流畅；<br/>
*Sprite：统计所有渲染节点（包括容器）数量，它的大小会影响引擎进行节点遍历、数据组织和渲染的效率。其值越小，游戏运行效率越高；<br/>
*DrawCall：此值是决定性能的重要指标，其值越小，游戏运行效率越高。Canvas模式下表示每大约1秒的图像绘制次数；WebGL模式下表示每大约1秒的渲染提交批次，每次准备数据并通知GPU渲染绘制的过程称为1次DrawCall，在每次DrawCall中除了在通知GPU的渲染上比较耗时之外，切换材质与shader也是非常耗时的操作；<br/>
*CurMem：Canvas模式下，表示内存占用大小，值越小越好，过高会导致游戏闪退；WebGL模式下，表示内存与显存的占用，值越小越好；<br/>
*Shader：是 WebGL 模式独有的性能指标，表示每大约1秒 Shader 提交次数，值越小越好；<br/>
*Canvas：由三个数值组成，只有设置 CacheAs 后才会有值，默认为0/0/0。从左到右数值的意义分别为：每帧重绘的画布数量 / 缓存类型为"normal"类型的画布数量 / 缓存类型为"bitmap"类型的画布数量。</p>
*/
//class laya.utils.Stat
var Stat=(function(){
	function Stat(){}
	__class(Stat,'laya.utils.Stat');
	/**
	*点击性能统计显示区域的处理函数。
	*/
	__getset(1,Stat,'onclick',null,function(fn){
		if (Stat._sp){
			Stat._sp.on("click",Stat._sp,fn);
		}
		if (Stat._canvas){
			Stat._canvas.source.onclick=fn;
			Stat._canvas.source.style.pointerEvents='';
		}
	});

	Stat.show=function(x,y){
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		if (Render.isConchApp){
			Browser.window.conch.showFPS && Browser.window.conch.showFPS(x,y);
			return;
		}
		if (!Browser.onMiniGame)Stat._useCanvas=true;
		Stat._show=true;
		Stat._fpsData.length=60;
		Stat._view[0]={title:"FPS(Canvas)",value:"_fpsStr",color:"yellow",units:"int"};
		Stat._view[1]={title:"Sprite",value:"_spriteStr",color:"white",units:"int"};
		Stat._view[2]={title:"DrawCall",value:"drawCall",color:"white",units:"int"};
		Stat._view[3]={title:"CurMem",value:"currentMemorySize",color:"yellow",units:"M"};
		if (Render.isWebGL){
			Stat._view[4]={title:"Shader",value:"shaderCall",color:"white",units:"int"};
			if (!Render.is3DMode){
				Stat._view[0].title="FPS(WebGL)";
				Stat._view[5]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
				}else {
				Stat._view[0].title="FPS(3D)";
				Stat._view[5]={title:"TriFaces",value:"trianglesFaces",color:"white",units:"int"};
				Stat._view[6]={title:"treeNodeColl",value:"treeNodeCollision",color:"white",units:"int"};
				Stat._view[7]={title:"treeSpriteColl",value:"treeSpriteCollision",color:"white",units:"int"};
			}
			}else {
			Stat._view[4]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
		}
		if (Stat._useCanvas){
			Stat.createUIPre(x,y);
		}else
		Stat.createUI(x,y);
		Stat.enable();
	}

	Stat.createUIPre=function(x,y){
		var pixel=Browser.pixelRatio;
		Stat._width=pixel *130;
		Stat._vx=pixel *75;
		Stat._height=pixel *(Stat._view.length *12+3 *pixel)+4;
		Stat._fontSize=12 *pixel;
		for (var i=0;i < Stat._view.length;i++){
			Stat._view[i].x=4;
			Stat._view[i].y=i *Stat._fontSize+2 *pixel;
		}
		if (!Stat._canvas){
			Stat._canvas=new HTMLCanvas('2D');
			Stat._canvas.size(Stat._width,Stat._height);
			Stat._ctx=Stat._canvas.getContext('2d');
			Stat._ctx.textBaseline="top";
			Stat._ctx.font=Stat._fontSize+"px Sans-serif";
			Stat._canvas.source.style.cssText="pointer-events:none;background:rgba(150,150,150,0.8);z-index:100000;position: absolute;direction:ltr;left:"+x+"px;top:"+y+"px;width:"+(Stat._width / pixel)+"px;height:"+(Stat._height / pixel)+"px;";
		}
		Stat._first=true;
		Stat.loop();
		Stat._first=false;
		Browser.container.appendChild(Stat._canvas.source);
	}

	Stat.createUI=function(x,y){
		var stat=Stat._sp;
		var pixel=Browser.pixelRatio;
		if (!stat){
			stat=new Sprite();
			Stat._leftText=new Text();
			Stat._leftText.pos(5,5);
			Stat._leftText.color="#ffffff";
			stat.addChild(Stat._leftText);
			Stat._txt=new Text();
			Stat._txt.pos(80*pixel,5);
			Stat._txt.color="#ffffff";
			stat.addChild(Stat._txt);
			Stat._sp=stat;
		}
		stat.pos(x,y);
		var text="";
		for (var i=0;i < Stat._view.length;i++){
			var one=Stat._view[i];
			text+=one.title+"\n";
		}
		Stat._leftText.text=text;
		var width=pixel *138;
		var height=pixel *(Stat._view.length *12+3 *pixel)+4;
		Stat._txt.fontSize=Stat._fontSize *pixel;
		Stat._leftText.fontSize=Stat._fontSize *pixel;
		stat.size(width,height);
		stat.graphics.clear();
		stat.graphics.setAlpha(0.5);
		stat.graphics.drawRect(0,0,width,height,"#999999");
		stat.graphics.setAlpha(1);
		Stat.loop();
	}

	Stat.enable=function(){
		Laya.timer.frameLoop(1,Stat,Stat.loop);
	}

	Stat.hide=function(){
		Stat._show=false;
		Laya.timer.clear(Stat,Stat.loop);
		if (Stat._canvas){
			Browser.removeElement(Stat._canvas.source);
		}
	}

	Stat.clear=function(){
		Stat.trianglesFaces=Stat.drawCall=Stat.shaderCall=Stat.spriteCount=Stat.spriteRenderUseCacheCount=Stat.treeNodeCollision=Stat.treeSpriteCollision=Stat.canvasNormal=Stat.canvasBitmap=Stat.canvasReCache=0;
	}

	Stat.loop=function(){
		Stat._count++;
		var timer=Browser.now();
		if (timer-Stat._timer < 1000)return;
		var count=Stat._count;
		Stat.FPS=Math.round((count *1000)/ (timer-Stat._timer));
		if (Stat._show){
			Stat.trianglesFaces=Math.round(Stat.trianglesFaces / count);
			if (!Stat._useCanvas){
				Stat.drawCall=Math.round(Stat.drawCall / count)-2;
				Stat.shaderCall=Math.round(Stat.shaderCall / count)-4;
				Stat.spriteCount=Math.round(Stat.spriteCount / count)-4;
				}else{
				Stat.drawCall=Math.round(Stat.drawCall / count)-2;
				Stat.shaderCall=Math.round(Stat.shaderCall / count);
				Stat.spriteCount=Math.round(Stat.spriteCount / count)-1;
			}
			Stat.spriteRenderUseCacheCount=Math.round(Stat.spriteRenderUseCacheCount / count);
			Stat.canvasNormal=Math.round(Stat.canvasNormal / count);
			Stat.canvasBitmap=Math.round(Stat.canvasBitmap / count);
			Stat.canvasReCache=Math.ceil(Stat.canvasReCache / count);
			Stat.treeNodeCollision=Math.round(Stat.treeNodeCollision / count);
			Stat.treeSpriteCollision=Math.round(Stat.treeSpriteCollision / count);
			var delay=Stat.FPS > 0 ? Math.floor(1000 / Stat.FPS).toString():" ";
			Stat._fpsStr=Stat.FPS+(Stat.renderSlow ? " slow" :"")+" "+delay;
			Stat._spriteStr=Stat.spriteCount+(Stat.spriteRenderUseCacheCount ? ("/"+Stat.spriteRenderUseCacheCount):'');
			Stat._canvasStr=Stat.canvasReCache+"/"+Stat.canvasNormal+"/"+Stat.canvasBitmap;
			Stat.currentMemorySize=ResourceManager.systemResourceManager.memorySize;
			if (Stat._useCanvas){
				Stat.renderInfoPre();
			}else
			Stat.renderInfo();
			Stat.clear();
		}
		Stat._count=0;
		Stat._timer=timer;
	}

	Stat.renderInfoPre=function(){
		if (Stat._canvas){
			var ctx=Stat._ctx;
			ctx.clearRect(Stat._first ? 0 :Stat._vx,0,Stat._width,Stat._height);
			for (var i=0;i < Stat._view.length;i++){
				var one=Stat._view[i];
				if (Stat._first){
					ctx.fillStyle="white";
					ctx.fillText(one.title,one.x,one.y,null,null,null);
				}
				ctx.fillStyle=one.color;
				var value=Stat[one.value];
				(one.units=="M")&& (value=Math.floor(value / (1024 *1024)*100)/ 100+" M");
				ctx.fillText(value+"",one.x+Stat._vx,one.y,null,null,null);
			}
		}
	}

	Stat.renderInfo=function(){
		var text="";
		for (var i=0;i < Stat._view.length;i++){
			var one=Stat._view[i];
			var value=Stat[one.value];
			(one.units=="M")&& (value=Math.floor(value / (1024 *1024)*100)/ 100+" M");
			(one.units=="K")&& (value=Math.floor(value / (1024)*100)/ 100+" K");
			text+=value+"\n";
		}
		Stat._txt.text=text;
	}

	Stat.FPS=0;
	Stat.loopCount=0;
	Stat.shaderCall=0;
	Stat.drawCall=0;
	Stat.trianglesFaces=0;
	Stat.spriteCount=0;
	Stat.spriteRenderUseCacheCount=0;
	Stat.treeNodeCollision=0;
	Stat.treeSpriteCollision=0;
	Stat.canvasNormal=0;
	Stat.canvasBitmap=0;
	Stat.canvasReCache=0;
	Stat.renderSlow=false;
	Stat.currentMemorySize=0;
	Stat._fpsStr=null;
	Stat._canvasStr=null;
	Stat._spriteStr=null;
	Stat._fpsData=[];
	Stat._timer=0;
	Stat._count=0;
	Stat._view=[];
	Stat._fontSize=12;
	Stat._txt=null;
	Stat._leftText=null;
	Stat._sp=null;
	Stat._show=false;
	Stat._useCanvas=false;
	Stat._canvas=null;
	Stat._ctx=null;
	Stat._first=false;
	Stat._vx=NaN;
	Stat._width=0;
	Stat._height=100;
	return Stat;
})()


/**
*@private
*<code>StringKey</code> 类用于存取字符串对应的数字。
*/
//class laya.utils.StringKey
var StringKey=(function(){
	function StringKey(){
		this._strsToID={};
		this._idToStrs=[];
		this._length=0;
	}

	__class(StringKey,'laya.utils.StringKey');
	var __proto=StringKey.prototype;
	/**
	*添加一个字符。
	*@param str 字符，将作为key 存储相应生成的数字。
	*@return 此字符对应的数字。
	*/
	__proto.add=function(str){
		var index=this._strsToID[str];
		if (index !=null)return index;
		this._idToStrs[this._length]=str;
		return this._strsToID[str]=this._length++;
	}

	/**
	*获取指定字符对应的ID。
	*@param str 字符。
	*@return 此字符对应的ID。
	*/
	__proto.getID=function(str){
		var index=this._strsToID[str];
		return index==null ?-1 :index;
	}

	/**
	*根据指定ID获取对应字符。
	*@param id ID。
	*@return 此id对应的字符。
	*/
	__proto.getName=function(id){
		var str=this._idToStrs[id];
		return str==null ? undefined :str;
	}

	return StringKey;
})()


/**
*<code>Timer</code> 是时钟管理类。它是一个单例，不要手动实例化此类，应该通过 Laya.timer 访问。
*/
//class laya.utils.Timer
var Timer=(function(){
	var TimerHandler;
	function Timer(){
		/**两帧之间的时间间隔,单位毫秒。*/
		this._delta=0;
		/**时针缩放。*/
		this.scale=1;
		/**当前的帧数。*/
		this.currFrame=0;
		/**@private */
		this._mid=1;
		/**@private */
		this._map=[];
		/**@private */
		this._laters=[];
		/**@private */
		this._handlers=[];
		/**@private */
		this._temp=[];
		/**@private */
		this._count=0;
		this.currTimer=this._now();
		this._lastTimer=this._now();
		this._init();
	}

	__class(Timer,'laya.utils.Timer');
	var __proto=Timer.prototype;
	/**@private */
	__proto._init=function(){
		Laya.timer && Laya.timer.frameLoop(1,this,this._update);
	}

	/**@private */
	__proto._now=function(){
		return Date.now();
	}

	/**
	*@private
	*帧循环处理函数。
	*/
	__proto._update=function(){
		if (this.scale <=0){
			this._lastTimer=this._now();
			return;
		};
		var frame=this.currFrame=this.currFrame+this.scale;
		var now=this._now();
		this._delta=(now-this._lastTimer)*this.scale;
		var timer=this.currTimer=this.currTimer+this._delta;
		this._lastTimer=now;
		var handlers=this._handlers;
		this._count=0;
		for (i=0,n=handlers.length;i < n;i++){
			handler=handlers[i];
			if (handler.method!==null){
				var t=handler.userFrame ? frame :timer;
				if (t >=handler.exeTime){
					if (handler.repeat){
						if (!handler.jumpFrame){
							handler.exeTime+=handler.delay;
							handler.run(false);
							if (t > handler.exeTime){
								handler.exeTime+=Math.ceil((t-handler.exeTime)/ handler.delay)*handler.delay;
							}
							}else {
							while (t >=handler.exeTime){
								handler.exeTime+=handler.delay;
								handler.run(false);
							}
						}
						}else {
						handler.run(true);
					}
				}
				}else {
				this._count++;
			}
		}
		if (this._count > 30 || frame % 200===0)this._clearHandlers();
		var laters=this._laters;
		for (var i=0,n=laters.length-1;i <=n;i++){
			var handler=laters[i];
			if (handler.method!==null){
				this._map[handler.key]=null;
				handler.run(false);
			}
			this._recoverHandler(handler);
			i===n && (n=laters.length-1);
		}
		laters.length=0;
	}

	/**@private */
	__proto._clearHandlers=function(){
		var handlers=this._handlers;
		for (var i=0,n=handlers.length;i < n;i++){
			var handler=handlers[i];
			if (handler.method!==null)this._temp.push(handler);
			else this._recoverHandler(handler);
		}
		this._handlers=this._temp;
		this._temp=handlers;
		this._temp.length=0;
	}

	/**@private */
	__proto._recoverHandler=function(handler){
		if(this._map[handler.key]==handler)this._map[handler.key]=null;
		handler.clear();
		Timer._pool.push(handler);
	}

	/**@private */
	__proto._create=function(useFrame,repeat,delay,caller,method,args,coverBefore){
		if (!delay){
			method.apply(caller,args);
			return null;
		}
		if (coverBefore){
			var handler=this._getHandler(caller,method);
			if (handler){
				handler.repeat=repeat;
				handler.userFrame=useFrame;
				handler.delay=delay;
				handler.caller=caller;
				handler.method=method;
				handler.args=args;
				handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer+this._now()-this._lastTimer);
				return handler;
			}
		}
		handler=Timer._pool.length > 0 ? Timer._pool.pop():new TimerHandler();
		handler.repeat=repeat;
		handler.userFrame=useFrame;
		handler.delay=delay;
		handler.caller=caller;
		handler.method=method;
		handler.args=args;
		handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer+this._now()-this._lastTimer)+1;
		this._indexHandler(handler);
		this._handlers.push(handler);
		return handler;
	}

	/**@private */
	__proto._indexHandler=function(handler){
		var caller=handler.caller;
		var method=handler.method;
		var cid=caller ? caller.$_GID || (caller.$_GID=Utils.getGID()):0;
		var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
		handler.key=cid+mid;
		this._map[handler.key]=handler;
	}

	/**
	*定时执行一次。
	*@param delay 延迟时间(单位为毫秒)。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*@param args 回调参数。
	*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
	*/
	__proto.once=function(delay,caller,method,args,coverBefore){
		(coverBefore===void 0)&& (coverBefore=true);
		this._create(false,false,delay,caller,method,args,coverBefore);
	}

	/**
	*定时重复执行。
	*@param delay 间隔时间(单位毫秒)。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*@param args 回调参数。
	*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
	*@param jumpFrame 时钟是否跳帧。基于时间的循环回调，单位时间间隔内，如能执行多次回调，出于性能考虑，引擎默认只执行一次，设置jumpFrame=true后，则回调会连续执行多次
	*/
	__proto.loop=function(delay,caller,method,args,coverBefore,jumpFrame){
		(coverBefore===void 0)&& (coverBefore=true);
		(jumpFrame===void 0)&& (jumpFrame=false);
		var handler=this._create(false,true,delay,caller,method,args,coverBefore);
		if (handler)handler.jumpFrame=jumpFrame;
	}

	/**
	*定时执行一次(基于帧率)。
	*@param delay 延迟几帧(单位为帧)。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*@param args 回调参数。
	*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
	*/
	__proto.frameOnce=function(delay,caller,method,args,coverBefore){
		(coverBefore===void 0)&& (coverBefore=true);
		this._create(true,false,delay,caller,method,args,coverBefore);
	}

	/**
	*定时重复执行(基于帧率)。
	*@param delay 间隔几帧(单位为帧)。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*@param args 回调参数。
	*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
	*/
	__proto.frameLoop=function(delay,caller,method,args,coverBefore){
		(coverBefore===void 0)&& (coverBefore=true);
		this._create(true,true,delay,caller,method,args,coverBefore);
	}

	/**返回统计信息。*/
	__proto.toString=function(){
		return "callLater:"+this._laters.length+" handlers:"+this._handlers.length+" pool:"+Timer._pool.length;
	}

	/**
	*清理定时器。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*/
	__proto.clear=function(caller,method){
		var handler=this._getHandler(caller,method);
		if (handler){
			this._map[handler.key]=null;handler.key=0;
			handler.clear();
		}
	}

	/**
	*清理对象身上的所有定时器。
	*@param caller 执行域(this)。
	*/
	__proto.clearAll=function(caller){
		if (!caller)return;
		for (var i=0,n=this._handlers.length;i < n;i++){
			var handler=this._handlers[i];
			if (handler.caller===caller){
				this._map[handler.key]=null;handler.key=0;
				handler.clear();
			}
		}
	}

	/**@private */
	__proto._getHandler=function(caller,method){
		var cid=caller ? caller.$_GID || (caller.$_GID=Utils.getGID()):0;
		var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
		return this._map[cid+mid];
	}

	/**
	*延迟执行。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*@param args 回调参数。
	*/
	__proto.callLater=function(caller,method,args){
		if (this._getHandler(caller,method)==null){
			if (Timer._pool.length)
				var handler=Timer._pool.pop();
			else handler=new TimerHandler();
			handler.caller=caller;
			handler.method=method;
			handler.args=args;
			this._indexHandler(handler);
			this._laters.push(handler);
		}
	}

	/**
	*立即执行 callLater 。
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*/
	__proto.runCallLater=function(caller,method){
		var handler=this._getHandler(caller,method);
		if (handler && handler.method !=null){
			this._map[handler.key]=null;
			handler.run(true);
		}
	}

	/**
	*立即提前执行定时器，执行之后从队列中删除
	*@param caller 执行域(this)。
	*@param method 定时器回调函数。
	*/
	__proto.runTimer=function(caller,method){
		this.runCallLater(caller,method);
	}

	/**
	*两帧之间的时间间隔,单位毫秒。
	*/
	__getset(0,__proto,'delta',function(){
		return this._delta;
	});

	Timer._pool=[];
	Timer.__init$=function(){
		/**@private */
		//class TimerHandler
		TimerHandler=(function(){
			function TimerHandler(){
				this.key=0;
				this.repeat=false;
				this.delay=0;
				this.userFrame=false;
				this.exeTime=0;
				this.caller=null;
				this.method=null;
				this.args=null;
				this.jumpFrame=false;
			}
			__class(TimerHandler,'');
			var __proto=TimerHandler.prototype;
			__proto.clear=function(){
				this.caller=null;
				this.method=null;
				this.args=null;
			}
			__proto.run=function(withClear){
				var caller=this.caller;
				if (caller && caller.destroyed)return this.clear();
				var method=this.method;
				var args=this.args;
				withClear && this.clear();
				if (method==null)return;
				args ? method.apply(caller,args):method.call(caller);
			}
			return TimerHandler;
		})()
	}

	return Timer;
})()


/**
*<code>Tween</code> 是一个缓动类。使用此类能够实现对目标对象属性的渐变。
*/
//class laya.utils.Tween
var Tween=(function(){
	function Tween(){
		/**@private */
		//this._complete=null;
		/**@private */
		//this._target=null;
		/**@private */
		//this._ease=null;
		/**@private */
		//this._props=null;
		/**@private */
		//this._duration=0;
		/**@private */
		//this._delay=0;
		/**@private */
		//this._startTimer=0;
		/**@private */
		//this._usedTimer=0;
		/**@private */
		//this._usedPool=false;
		/**@private 唯一标识，TimeLintLite用到*/
		this.gid=0;
		/**更新回调，缓动数值发生变化时，回调变化的值*/
		//this.update=null;
	}

	__class(Tween,'laya.utils.Tween');
	var __proto=Tween.prototype;
	/**
	*缓动对象的props属性到目标值。
	*@param target 目标对象(即将更改属性值的对象)。
	*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
	*@param duration 花费的时间，单位毫秒。
	*@param ease 缓动类型，默认为匀速运动。
	*@param complete 结束回调函数。
	*@param delay 延迟执行时间。
	*@param coverBefore 是否覆盖之前的缓动。
	*@return 返回Tween对象。
	*/
	__proto.to=function(target,props,duration,ease,complete,delay,coverBefore){
		(delay===void 0)&& (delay=0);
		(coverBefore===void 0)&& (coverBefore=false);
		return this._create(target,props,duration,ease,complete,delay,coverBefore,true,false,true);
	}

	/**
	*从props属性，缓动到当前状态。
	*@param target 目标对象(即将更改属性值的对象)。
	*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
	*@param duration 花费的时间，单位毫秒。
	*@param ease 缓动类型，默认为匀速运动。
	*@param complete 结束回调函数。
	*@param delay 延迟执行时间。
	*@param coverBefore 是否覆盖之前的缓动。
	*@return 返回Tween对象。
	*/
	__proto.from=function(target,props,duration,ease,complete,delay,coverBefore){
		(delay===void 0)&& (delay=0);
		(coverBefore===void 0)&& (coverBefore=false);
		return this._create(target,props,duration,ease,complete,delay,coverBefore,false,false,true);
	}

	/**@private */
	__proto._create=function(target,props,duration,ease,complete,delay,coverBefore,isTo,usePool,runNow){
		if (!target)throw new Error("Tween:target is null");
		this._target=target;
		this._duration=duration;
		this._ease=ease || props.ease || Tween.easeNone;
		this._complete=complete || props.complete;
		this._delay=delay;
		this._props=[];
		this._usedTimer=0;
		this._startTimer=Browser.now();
		this._usedPool=usePool;
		this.update=props.update;
		var gid=(target.$_GID || (target.$_GID=Utils.getGID()));
		if (!Tween.tweenMap[gid]){
			Tween.tweenMap[gid]=[this];
			}else {
			if (coverBefore)Tween.clearTween(target);
			Tween.tweenMap[gid].push(this);
		}
		if (runNow){
			if (delay <=0)this.firstStart(target,props,isTo);
			else Laya.scaleTimer.once(delay,this,this.firstStart,[target,props,isTo]);
			}else {
			this._initProps(target,props,isTo);
		}
		return this;
	}

	__proto.firstStart=function(target,props,isTo){
		if (target.destroyed){
			this.clear();
			return;
		}
		this._initProps(target,props,isTo);
		this._beginLoop();
	}

	__proto._initProps=function(target,props,isTo){
		for (var p in props){
			if ((typeof (target[p])=='number')){
				var start=isTo ? target[p] :props[p];
				var end=isTo ? props[p] :target[p];
				this._props.push([p,start,end-start]);
				if (!isTo)target[p]=start;
			}
		}
	}

	__proto._beginLoop=function(){
		Laya.scaleTimer.frameLoop(1,this,this._doEase);
	}

	/**执行缓动**/
	__proto._doEase=function(){
		this._updateEase(Browser.now());
	}

	/**@private */
	__proto._updateEase=function(time){
		var target=this._target;
		if (!target)return;
		if (target.destroyed)return Tween.clearTween(target);
		var usedTimer=this._usedTimer=time-this._startTimer-this._delay;
		if (usedTimer < 0)return;
		if (usedTimer >=this._duration)return this.complete();
		var ratio=usedTimer > 0 ? this._ease(usedTimer,0,1,this._duration):0;
		var props=this._props;
		for (var i=0,n=props.length;i < n;i++){
			var prop=props[i];
			target[prop[0]]=prop[1]+(ratio *prop[2]);
		}
		if (this.update)this.update.run();
	}

	/**
	*立即结束缓动并到终点。
	*/
	__proto.complete=function(){
		if (!this._target)return;
		Laya.scaleTimer.runTimer(this,this.firstStart);
		var target=this._target;
		var props=this._props;
		var handler=this._complete;
		for (var i=0,n=props.length;i < n;i++){
			var prop=props[i];
			target[prop[0]]=prop[1]+prop[2];
		}
		if (this.update)this.update.run();
		this.clear();
		handler && handler.run();
	}

	/**
	*暂停缓动，可以通过resume或restart重新开始。
	*/
	__proto.pause=function(){
		Laya.scaleTimer.clear(this,this._beginLoop);
		Laya.scaleTimer.clear(this,this._doEase);
	}

	/**
	*设置开始时间。
	*@param startTime 开始时间。
	*/
	__proto.setStartTime=function(startTime){
		this._startTimer=startTime;
	}

	/**
	*停止并清理当前缓动。
	*/
	__proto.clear=function(){
		if (this._target){
			this._remove();
			this._clear();
		}
	}

	/**
	*@private
	*/
	__proto._clear=function(){
		this.pause();
		Laya.scaleTimer.clear(this,this.firstStart);
		this._complete=null;
		this._target=null;
		this._ease=null;
		this._props=null;
		if (this._usedPool){
			this.update=null;
			Pool.recover("tween",this);
		}
	}

	/**回收到对象池。*/
	__proto.recover=function(){
		this._usedPool=true;
		this._clear();
	}

	__proto._remove=function(){
		var tweens=Tween.tweenMap[this._target.$_GID];
		if (tweens){
			for (var i=0,n=tweens.length;i < n;i++){
				if (tweens[i]===this){
					tweens.splice(i,1);
					break ;
				}
			}
		}
	}

	/**
	*重新开始暂停的缓动。
	*/
	__proto.restart=function(){
		this.pause();
		this._usedTimer=0;
		this._startTimer=Browser.now();
		var props=this._props;
		for (var i=0,n=props.length;i < n;i++){
			var prop=props[i];
			this._target[prop[0]]=prop[1];
		}
		Laya.scaleTimer.once(this._delay,this,this._beginLoop);
	}

	/**
	*恢复暂停的缓动。
	*/
	__proto.resume=function(){
		if (this._usedTimer >=this._duration)return;
		this._startTimer=Browser.now()-this._usedTimer-this._delay;
		this._beginLoop();
	}

	/**设置当前执行比例**/
	__getset(0,__proto,'progress',null,function(v){
		var uTime=v *this._duration;
		this._startTimer=Browser.now()-this._delay-uTime;
	});

	Tween.to=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
		(delay===void 0)&& (delay=0);
		(coverBefore===void 0)&& (coverBefore=false);
		(autoRecover===void 0)&& (autoRecover=true);
		return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,true,autoRecover,true);
	}

	Tween.from=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
		(delay===void 0)&& (delay=0);
		(coverBefore===void 0)&& (coverBefore=false);
		(autoRecover===void 0)&& (autoRecover=true);
		return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,false,autoRecover,true);
	}

	Tween.clearAll=function(target){
		if (!target || !target.$_GID)return;
		var tweens=Tween.tweenMap[target.$_GID];
		if (tweens){
			for (var i=0,n=tweens.length;i < n;i++){
				tweens[i]._clear();
			}
			tweens.length=0;
		}
	}

	Tween.clear=function(tween){
		tween.clear();
	}

	Tween.clearTween=function(target){
		Tween.clearAll(target);
	}

	Tween.easeNone=function(t,b,c,d){
		return c *t / d+b;
	}

	Tween.tweenMap={};
	return Tween;
})()


/**
*<code>Utils</code> 是工具类。
*/
//class laya.utils.Utils
var Utils=(function(){
	function Utils(){}
	__class(Utils,'laya.utils.Utils');
	Utils.toRadian=function(angle){
		return angle *Utils._pi2;
	}

	Utils.toAngle=function(radian){
		return radian *Utils._pi;
	}

	Utils.toHexColor=function(color){
		if (color < 0 || isNaN(color))return null;
		var str=color.toString(16);
		while (str.length < 6)str="0"+str;
		return "#"+str;
	}

	Utils.getGID=function(){
		return Utils._gid++;
	}

	Utils.concatArray=function(source,array){
		if (!array)return source;
		if (!source)return array;
		var i=0,len=array.length;
		for (i=0;i < len;i++){
			source.push(array[i]);
		}
		return source;
	}

	Utils.clearArray=function(array){
		if (!array)return array;
		array.length=0;
		return array;
	}

	Utils.copyArray=function(source,array){
		source || (source=[]);
		if (!array)return source;
		source.length=array.length;
		var i=0,len=array.length;
		for (i=0;i < len;i++){
			source[i]=array[i];
		}
		return source;
	}

	Utils.getGlobalRecByPoints=function(sprite,x0,y0,x1,y1){
		var newLTPoint;
		newLTPoint=new Point(x0,y0);
		newLTPoint=sprite.localToGlobal(newLTPoint);
		var newRBPoint;
		newRBPoint=new Point(x1,y1);
		newRBPoint=sprite.localToGlobal(newRBPoint);
		return Rectangle._getWrapRec([newLTPoint.x,newLTPoint.y,newRBPoint.x,newRBPoint.y]);
	}

	Utils.getGlobalPosAndScale=function(sprite){
		return Utils.getGlobalRecByPoints(sprite,0,0,1,1);
	}

	Utils.bind=function(fun,scope){
		var rst=fun;
		rst=fun.bind(scope);;
		return rst;
	}

	Utils.measureText=function(txt,font){
		return RunDriver.measureText(txt,font);
	}

	Utils.updateOrder=function(array){
		if (!array || array.length < 2)return false;
		var i=1,j=0,len=array.length,key=NaN,c;
		while (i < len){
			j=i;
			c=array[j];
			key=array[j]._zOrder;
			while (--j >-1){
				if (array[j]._zOrder > key)array[j+1]=array[j];
				else break ;
			}
			array[j+1]=c;
			i++;
		};
		var model=c.parent.conchModel;
		if (model){
			if (model.updateZOrder !=null){
				model.updateZOrder();
				}else {
				for (i=0;i < len;i++){
					model.removeChild(array[i].conchModel);
				}
				for (i=0;i < len;i++){
					model.addChildAt(array[i].conchModel,i);
				}
			}
		}
		return true;
	}

	Utils.transPointList=function(points,x,y){
		var i=0,len=points.length;
		for (i=0;i < len;i+=2){
			points[i]+=x;
			points[i+1]+=y;
		}
	}

	Utils.parseInt=function(str,radix){
		(radix===void 0)&& (radix=0);
		var result=Browser.window.parseInt(str,radix);
		if (isNaN(result))return 0;
		return result;
	}

	Utils.getFileExtension=function(path){
		Utils._extReg.lastIndex=path.lastIndexOf(".");
		var result=Utils._extReg.exec(path);
		if (result && result.length > 1){
			return result[1].toLowerCase();
		}
		return null;
	}

	Utils.getTransformRelativeToWindow=function(coordinateSpace,x,y){
		var stage=Laya.stage;
		var globalTransform=laya.utils.Utils.getGlobalPosAndScale(coordinateSpace);
		var canvasMatrix=stage._canvasTransform.clone();
		var canvasLeft=canvasMatrix.tx;
		var canvasTop=canvasMatrix.ty;
		canvasMatrix.rotate(-Math.PI / 180 *Laya.stage.canvasDegree);
		canvasMatrix.scale(Laya.stage.clientScaleX,Laya.stage.clientScaleY);
		var perpendicular=(Laya.stage.canvasDegree % 180 !=0);
		var tx=NaN,ty=NaN;
		if (perpendicular){
			tx=y+globalTransform.y;
			ty=x+globalTransform.x;
			tx *=canvasMatrix.d;
			ty *=canvasMatrix.a;
			if (Laya.stage.canvasDegree==90){
				tx=canvasLeft-tx;
				ty+=canvasTop;
			}
			else {
				tx+=canvasLeft;
				ty=canvasTop-ty;
			}
		}
		else {
			tx=x+globalTransform.x;
			ty=y+globalTransform.y;
			tx *=canvasMatrix.a;
			ty *=canvasMatrix.d;
			tx+=canvasLeft;
			ty+=canvasTop;
		};
		var domScaleX=NaN,domScaleY=NaN;
		if (perpendicular){
			domScaleX=canvasMatrix.d *globalTransform.height;
			domScaleY=canvasMatrix.a *globalTransform.width;
			}else {
			domScaleX=canvasMatrix.a *globalTransform.width;
			domScaleY=canvasMatrix.d *globalTransform.height;
		}
		return {x:tx,y:ty,scaleX:domScaleX,scaleY:domScaleY};
	}

	Utils.fitDOMElementInArea=function(dom,coordinateSpace,x,y,width,height){
		if (!dom._fitLayaAirInitialized){
			dom._fitLayaAirInitialized=true;
			dom.style.transformOrigin=dom.style.webKittransformOrigin="left top";
			dom.style.position="absolute"
		};
		var transform=Utils.getTransformRelativeToWindow(coordinateSpace,x,y);
		dom.style.transform=dom.style.webkitTransform="scale("+transform.scaleX+","+transform.scaleY+") rotate("+(Laya.stage.canvasDegree)+"deg)";
		dom.style.width=width+'px';
		dom.style.height=height+'px';
		dom.style.left=transform.x+'px';
		dom.style.top=transform.y+'px';
	}

	Utils.isOkTextureList=function(textureList){
		if (!textureList)return false;
		var i=0,len=textureList.length;
		var tTexture;
		for (i=0;i < len;i++){
			tTexture=textureList[i];
			if (!tTexture.source)return false;
		}
		return true;
	}

	Utils.isOKCmdList=function(cmds){
		if (!cmds)return false;
		var i=0,len=cmds.length;
		var context=Render._context;
		var cmd;
		var tex;
		for (i=0;i < len;i++){
			cmd=cmds[i];
			switch(cmd.callee){
				case context._drawTexture:
				case context._fillTexture:
				case context._drawTextureWithTransform:
					tex=cmd[0];
					if (!tex || !tex.source)return false;
				}
		}
		return true;
	}

	Utils._gid=1;
	Utils.parseXMLFromString=function(value){
		var rst;
		value=value.replace(/>\s+</g,'><');
		rst=(new DOMParser()).parseFromString(value,'text/xml');
		if (rst.firstChild.textContent.indexOf("This page contains the following errors")>-1){
			throw new Error(rst.firstChild.firstChild.textContent);
		}
		return rst;
	}

	__static(Utils,
	['_pi',function(){return this._pi=180 / Math.PI;},'_pi2',function(){return this._pi2=Math.PI / 180;},'_extReg',function(){return this._extReg=/\.(\w+)\??/g;}
	]);
	return Utils;
})()


/**
*@private
*/
//class laya.utils.VectorGraphManager
var VectorGraphManager=(function(){
	function VectorGraphManager(){
		this.useDic={};
		this.shapeDic={};
		this.shapeLineDic={};
		this._id=0;
		this._checkKey=false;
		this._freeIdArray=[];
		if (Render.isWebGL){
			CacheManager.regCacheByFunction(Utils.bind(this.startDispose,this),Utils.bind(this.getCacheList,this));
		}
	}

	__class(VectorGraphManager,'laya.utils.VectorGraphManager');
	var __proto=VectorGraphManager.prototype;
	/**
	*得到个空闲的ID
	*@return
	*/
	__proto.getId=function(){
		return this._id++;
	}

	/**
	*添加一个图形到列表中
	*@param id
	*@param shape
	*/
	__proto.addShape=function(id,shape){
		this.shapeDic[id]=shape;
		if (!this.useDic[id]){
			this.useDic[id]=true;
		}
	}

	/**
	*添加一个线图形到列表中
	*@param id
	*@param Line
	*/
	__proto.addLine=function(id,Line){
		this.shapeLineDic[id]=Line;
		if (!this.shapeLineDic[id]){
			this.shapeLineDic[id]=true;
		}
	}

	/**
	*检测一个对象是否在使用中
	*@param id
	*/
	__proto.getShape=function(id){
		if (this._checkKey){
			if (this.useDic[id] !=null){
				this.useDic[id]=true;
			}
		}
	}

	/**
	*删除一个图形对象
	*@param id
	*/
	__proto.deleteShape=function(id){
		if (this.shapeDic[id]){
			this.shapeDic[id]=null;
			delete this.shapeDic[id];
		}
		if (this.shapeLineDic[id]){
			this.shapeLineDic[id]=null;
			delete this.shapeLineDic[id];
		}
		if (this.useDic[id] !=null){
			delete this.useDic[id];
		}
	}

	/**
	*得到缓存列表
	*@return
	*/
	__proto.getCacheList=function(){
		var str;
		var list=[];
		for (str in this.shapeDic){
			list.push(this.shapeDic[str]);
		}
		for (str in this.shapeLineDic){
			list.push(this.shapeLineDic[str]);
		}
		return list;
	}

	/**
	*开始清理状态，准备销毁
	*/
	__proto.startDispose=function(key){
		var str;
		for (str in this.useDic){
			this.useDic[str]=false;
		}
		this._checkKey=true;
	}

	/**
	*确认销毁
	*/
	__proto.endDispose=function(){
		if (this._checkKey){
			var str;
			for (str in this.useDic){
				if (!this.useDic[str]){
					this.deleteShape(str);
				}
			}
			this._checkKey=false;
		}
	}

	VectorGraphManager.getInstance=function(){
		return VectorGraphManager.instance=VectorGraphManager.instance|| new VectorGraphManager();
	}

	VectorGraphManager.instance=null;
	return VectorGraphManager;
})()


/**
*封装弱引用WeakMap
*如果支持WeakMap，则使用WeakMap，如果不支持，则用Object代替
*注意：如果采用Object，为了防止内存泄漏，则采用定时清理缓存策略
*/
//class laya.utils.WeakObject
var WeakObject=(function(){
	function WeakObject(){
		/**@private */
		this._obj=null;
		this._obj=WeakObject.supportWeakMap ? new Browser.window.WeakMap():{};
		if (!WeakObject.supportWeakMap)WeakObject._maps.push(this);
	}

	__class(WeakObject,'laya.utils.WeakObject');
	var __proto=WeakObject.prototype;
	/**
	*设置缓存
	*@param key kye对象，可被回收
	*@param value object对象，可被回收
	*/
	__proto.set=function(key,value){
		if (key==null)return;
		if (WeakObject.supportWeakMap){
			var objKey=key;
			if ((typeof key=='string')|| (typeof key=='number')){
				objKey=WeakObject._keys[key];
				if (!objKey)objKey=WeakObject._keys[key]={k:key};
			}
			this._obj.set(objKey,value);
			}else {
			if ((typeof key=='string')|| (typeof key=='number')){
				this._obj[key]=value;
				}else {
				key.$_GID || (key.$_GID=Utils.getGID());
				this._obj[key.$_GID]=value;
			}
		}
	}

	/**
	*获取缓存
	*@param key kye对象，可被回收
	*/
	__proto.get=function(key){
		if (key==null)return null;
		if (WeakObject.supportWeakMap){
			var objKey=((typeof key=='string')|| (typeof key=='number'))? WeakObject._keys[key] :key;
			if (!objKey)return null;
			return this._obj.get(objKey);
			}else {
			if ((typeof key=='string')|| (typeof key=='number'))return this._obj[key];
			return this._obj[key.$_GID];
		}
	}

	/**
	*删除缓存
	*/
	__proto.del=function(key){
		if (key==null)return;
		if (WeakObject.supportWeakMap){
			var objKey=((typeof key=='string')|| (typeof key=='number'))? WeakObject._keys[key] :key;
			if (!objKey)return;
			this._obj.delete(objKey);
			}else {
			if ((typeof key=='string')|| (typeof key=='number'))delete this._obj[key];
			else delete this._obj[this._obj.$_GID];
		}
	}

	/**
	*是否有缓存
	*/
	__proto.has=function(key){
		if (key==null)return false;
		if (WeakObject.supportWeakMap){
			var objKey=((typeof key=='string')|| (typeof key=='number'))? WeakObject._keys[key] :key;
			return this._obj.has(objKey);
			}else {
			if ((typeof key=='string')|| (typeof key=='number'))return this._obj[key] !=null;
			return this._obj[this._obj.$_GID] !=null;
		}
	}

	WeakObject.__init__=function(){
		WeakObject.supportWeakMap=Browser.window.WeakMap !=null;
		if (!WeakObject.supportWeakMap)Laya.timer.loop(WeakObject.delInterval,null,WeakObject.clearCache);
	}

	WeakObject.clearCache=function(){
		for (var i=0,n=WeakObject._maps.length;i < n;i++){
			var obj=WeakObject._maps[i];
			obj._obj={};
		}
	}

	WeakObject.supportWeakMap=false;
	WeakObject.delInterval=5 *60 *1000;
	WeakObject._keys={};
	WeakObject._maps=[];
	__static(WeakObject,
	['I',function(){return this.I=new WeakObject();}
	]);
	return WeakObject;
})()


/**
*@private
*/
//class laya.utils.WordText
var WordText=(function(){
	function WordText(){
		this.id=NaN;
		this.save=[];
		this.toUpperCase=null;
		this.changed=false;
		this._text=null;
	}

	__class(WordText,'laya.utils.WordText');
	var __proto=WordText.prototype;
	__proto.setText=function(txt){
		this.changed=true;
		this._text=txt;
	}

	__proto.toString=function(){
		return this._text;
	}

	__proto.charCodeAt=function(i){
		return this._text ? this._text.charCodeAt(i):NaN;
	}

	__proto.charAt=function(i){
		return this._text ? this._text.charAt(i):null;
	}

	__getset(0,__proto,'length',function(){
		return this._text ? this._text.length :0;
	});

	return WordText;
})()


/**
*@private
*@author ...
*/
//class laya.ani.AnimationContent
var AnimationContent=(function(){
	function AnimationContent(){
		this.nodes=null;
		this.name=null;
		this.playTime=NaN;
		this.bone3DMap=null;
		this.totalKeyframeDatasLength=0;
	}

	__class(AnimationContent,'laya.ani.AnimationContent');
	return AnimationContent;
})()


/**
*@private
*@author ...
*/
//class laya.ani.AnimationNodeContent
var AnimationNodeContent=(function(){
	function AnimationNodeContent(){
		this.name=null;
		this.parentIndex=0;
		this.parent=null;
		this.keyframeWidth=0;
		this.lerpType=0;
		this.interpolationMethod=null;
		this.childs=null;
		this.keyFrame=null;
		//=new Vector.<KeyFramesContent>;
		this.playTime=NaN;
		this.extenData=null;
		this.dataOffset=0;
	}

	__class(AnimationNodeContent,'laya.ani.AnimationNodeContent');
	return AnimationNodeContent;
})()


/**
*@private
*/
//class laya.ani.AnimationParser01
var AnimationParser01=(function(){
	function AnimationParser01(){}
	__class(AnimationParser01,'laya.ani.AnimationParser01');
	AnimationParser01.parse=function(templet,reader){
		var data=reader.__getBuffer();
		var i=0,j=0,k=0,n=0,l=0,m=0,o=0;
		var aniClassName=reader.readUTFString();
		templet._aniClassName=aniClassName;
		var strList=reader.readUTFString().split("\n");
		var aniCount=reader.getUint8();
		var publicDataPos=reader.getUint32();
		var publicExtDataPos=reader.getUint32();
		var publicData;
		if (publicDataPos > 0)
			publicData=data.slice(publicDataPos,publicExtDataPos);
		var publicRead=new Byte(publicData);
		if (publicExtDataPos > 0)
			templet._publicExtData=data.slice(publicExtDataPos,data.byteLength);
		templet._useParent=!!reader.getUint8();
		templet._anis.length=aniCount;
		for (i=0;i < aniCount;i++){
			var ani=templet._anis[i]=new AnimationContent();
			{};
			ani.nodes=new Array;
			var name=ani.name=strList[reader.getUint16()];
			templet._aniMap[name]=i;
			ani.bone3DMap={};
			ani.playTime=reader.getFloat32();
			var boneCount=ani.nodes.length=reader.getUint8();
			ani.totalKeyframeDatasLength=0;
			for (j=0;j < boneCount;j++){
				var node=ani.nodes[j]=new AnimationNodeContent();
				{};
				node.childs=[];
				var nameIndex=reader.getInt16();
				if (nameIndex >=0){
					node.name=strList[nameIndex];
					ani.bone3DMap[node.name]=j;
				}
				node.keyFrame=new Array;
				node.parentIndex=reader.getInt16();
				node.parentIndex==-1 ? node.parent=null :node.parent=ani.nodes[node.parentIndex]
				node.lerpType=reader.getUint8();
				var keyframeParamsOffset=reader.getUint32();
				publicRead.pos=keyframeParamsOffset;
				var keyframeDataCount=node.keyframeWidth=publicRead.getUint16();
				ani.totalKeyframeDatasLength+=keyframeDataCount;
				if (node.lerpType===0 || node.lerpType===1){
					node.interpolationMethod=[];
					node.interpolationMethod.length=keyframeDataCount;
					for (k=0;k < keyframeDataCount;k++)
					node.interpolationMethod[k]=AnimationTemplet.interpolation[publicRead.getUint8()];
				}
				if (node.parent !=null)
					node.parent.childs.push(node);
				var privateDataLen=reader.getUint16();
				if (privateDataLen > 0){
					node.extenData=data.slice(reader.pos,reader.pos+privateDataLen);
					reader.pos+=privateDataLen;
				};
				var keyframeCount=reader.getUint16();
				node.keyFrame.length=keyframeCount;
				var startTime=0;
				var keyFrame;
				for (k=0,n=keyframeCount;k < n;k++){
					keyFrame=node.keyFrame[k]=new KeyFramesContent();
					{};
					keyFrame.duration=reader.getFloat32();
					keyFrame.startTime=startTime;
					if (node.lerpType===2){
						keyFrame.interpolationData=[];
						var interDataLength=reader.getUint8();
						var lerpType=0;
						lerpType=reader.getFloat32();
						switch (lerpType){
							case 254:
								keyFrame.interpolationData.length=keyframeDataCount;
								for (o=0;o < keyframeDataCount;o++)
								keyFrame.interpolationData[o]=0;
								break ;
							case 255:
								keyFrame.interpolationData.length=keyframeDataCount;
								for (o=0;o < keyframeDataCount;o++)
								keyFrame.interpolationData[o]=5;
								break ;
							default :
								keyFrame.interpolationData.push(lerpType);
								for (m=1;m < interDataLength;m++){
									keyFrame.interpolationData.push(reader.getFloat32());
								}
							}
					}
					keyFrame.data=new Float32Array(keyframeDataCount);
					for (l=0;l < keyframeDataCount;l++){
						keyFrame.data[l]=reader.getFloat32();
						if (keyFrame.data[l] >-0.00000001 && keyFrame.data[l] < 0.00000001)keyFrame.data[l]=0;
					}
					startTime+=keyFrame.duration;
				}
				keyFrame.startTime=ani.playTime;
				node.playTime=ani.playTime;
				templet._calculateKeyFrame(node,keyframeCount,keyframeDataCount);
			}
		}
	}

	return AnimationParser01;
})()


/**
*@private
*/
//class laya.ani.AnimationParser02
var AnimationParser02=(function(){
	function AnimationParser02(){}
	__class(AnimationParser02,'laya.ani.AnimationParser02');
	AnimationParser02.READ_DATA=function(){
		AnimationParser02._DATA.offset=AnimationParser02._reader.getUint32();
		AnimationParser02._DATA.size=AnimationParser02._reader.getUint32();
	}

	AnimationParser02.READ_BLOCK=function(){
		var count=AnimationParser02._BLOCK.count=AnimationParser02._reader.getUint16();
		var blockStarts=AnimationParser02._BLOCK.blockStarts=[];
		var blockLengths=AnimationParser02._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationParser02._reader.getUint32());
			blockLengths.push(AnimationParser02._reader.getUint32());
		}
	}

	AnimationParser02.READ_STRINGS=function(){
		var offset=AnimationParser02._reader.getUint32();
		var count=AnimationParser02._reader.getUint16();
		var prePos=AnimationParser02._reader.pos;
		AnimationParser02._reader.pos=offset+AnimationParser02._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationParser02._strings[i]=AnimationParser02._reader.readUTFString();
		AnimationParser02._reader.pos=prePos;
	}

	AnimationParser02.parse=function(templet,reader){
		AnimationParser02._templet=templet;
		AnimationParser02._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationParser02.READ_DATA();
		AnimationParser02.READ_BLOCK();
		AnimationParser02.READ_STRINGS();
		for (var i=0,n=AnimationParser02._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationParser02._strings[index];
			var fn=AnimationParser02["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
	}

	AnimationParser02.READ_ANIMATIONS=function(){
		var reader=AnimationParser02._reader;
		var arrayBuffer=reader.__getBuffer();
		var i=0,j=0,k=0,n=0,l=0;
		var keyframeWidth=reader.getUint16();
		var interpolationMethod=[];
		interpolationMethod.length=keyframeWidth;
		for (i=0;i < keyframeWidth;i++)
		interpolationMethod[i]=AnimationTemplet.interpolation[reader.getByte()];
		var aniCount=reader.getUint8();
		AnimationParser02._templet._anis.length=aniCount;
		for (i=0;i < aniCount;i++){
			var ani=AnimationParser02._templet._anis[i]=
			{};
			ani.nodes=new Array;
			var aniName=ani.name=AnimationParser02._strings[reader.getUint16()];
			AnimationParser02._templet._aniMap[aniName]=i;
			ani.bone3DMap={};
			ani.playTime=reader.getFloat32();
			var boneCount=ani.nodes.length=reader.getInt16();
			ani.totalKeyframeDatasLength=0;
			for (j=0;j < boneCount;j++){
				var node=ani.nodes[j]=
				{};
				node.keyframeWidth=keyframeWidth;
				node.childs=[];
				var nameIndex=reader.getUint16();
				if (nameIndex >=0){
					node.name=AnimationParser02._strings[nameIndex];
					ani.bone3DMap[node.name]=j;
				}
				node.keyFrame=new Array;
				node.parentIndex=reader.getInt16();
				node.parentIndex==-1 ? node.parent=null :node.parent=ani.nodes[node.parentIndex]
				ani.totalKeyframeDatasLength+=keyframeWidth;
				node.interpolationMethod=interpolationMethod;
				if (node.parent !=null)
					node.parent.childs.push(node);
				var keyframeCount=reader.getUint16();
				node.keyFrame.length=keyframeCount;
				var keyFrame=null,lastKeyFrame=null;
				for (k=0,n=keyframeCount;k < n;k++){
					keyFrame=node.keyFrame[k]=
					{};
					keyFrame.startTime=reader.getFloat32();
					(lastKeyFrame)&& (lastKeyFrame.duration=keyFrame.startTime-lastKeyFrame.startTime);
					var offset=AnimationParser02._DATA.offset;
					var keyframeDataOffset=reader.getUint32();
					var keyframeDataLength=keyframeWidth *4;
					var keyframeArrayBuffer=arrayBuffer.slice(offset+keyframeDataOffset,offset+keyframeDataOffset+keyframeDataLength);
					keyFrame.data=new Float32Array(keyframeArrayBuffer);
					lastKeyFrame=keyFrame;
				}
				keyFrame.duration=0;
				node.playTime=ani.playTime;
				AnimationParser02._templet._calculateKeyFrame(node,keyframeCount,keyframeWidth);
			}
		}
	}

	AnimationParser02._templet=null;
	AnimationParser02._reader=null;
	AnimationParser02._strings=[];
	__static(AnimationParser02,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationParser02;
})()


/**
*@private
*/
//class laya.ani.AnimationState
var AnimationState=(function(){
	function AnimationState(){}
	__class(AnimationState,'laya.ani.AnimationState');
	AnimationState.stopped=0;
	AnimationState.paused=1;
	AnimationState.playing=2;
	return AnimationState;
})()


/**
*@private
*canvas mesh渲染器
*/
//class laya.ani.bone.canvasmesh.CanvasMeshRender
var CanvasMeshRender=(function(){
	function CanvasMeshRender(){
		/**
		*mesh数据
		*/
		this.mesh=null;
		/**
		*矩阵
		*/
		this.transform=null;
		/**
		*绘图环境
		*/
		this.context=null;
		/**
		*绘制mesh的模式 0:顶点索引模式 1：无顶点索引模式
		*/
		this.mode=0;
	}

	__class(CanvasMeshRender,'laya.ani.bone.canvasmesh.CanvasMeshRender');
	var __proto=CanvasMeshRender.prototype;
	/**
	*将mesh数据渲染到context上面
	*@param context
	*
	*/
	__proto.renderToContext=function(context){
		this.context=context.ctx||context;
		if (this.mesh){
			if (this.mode==0){
				this._renderWithIndexes(this.mesh);
				}else{
				this._renderNoIndexes(this.mesh);
			}
		}
	}

	/**
	*无顶点索引的模式
	*@param mesh
	*
	*/
	__proto._renderNoIndexes=function(mesh){
		var i=0,len=mesh.vertices.length / 2;
		var index=0;
		for (i=0;i < len-2;i++){
			index=i *2;
			this._renderDrawTriangle(mesh,index,(index+2),(index+4));
		}
	}

	/**
	*使用顶点索引模式绘制
	*@param mesh
	*
	*/
	__proto._renderWithIndexes=function(mesh){
		var indexes=mesh.indexes;
		var i=0,len=indexes.length;
		for (i=0;i < len;i+=3){
			var index0=indexes[i] *2;
			var index1=indexes[i+1] *2;
			var index2=indexes[i+2] *2;
			this._renderDrawTriangle(mesh,index0,index1,index2);
		}
	}

	/**
	*绘制三角形
	*@param mesh mesh
	*@param index0 顶点0
	*@param index1 顶点1
	*@param index2 顶点2
	*
	*/
	__proto._renderDrawTriangle=function(mesh,index0,index1,index2){
		var context=this.context;
		var uvs=mesh.uvs;
		var vertices=mesh.vertices;
		var texture=mesh.texture;
		var source=texture.bitmap;
		var textureSource=source.source;
		var textureWidth=texture.width;
		var textureHeight=texture.height;
		var sourceWidth=source.width;
		var sourceHeight=source.height;
		var u0=NaN;
		var u1=NaN;
		var u2=NaN;
		var v0=NaN;
		var v1=NaN;
		var v2=NaN;
		if (mesh.useUvTransform){
			var ut=mesh.uvTransform;
			u0=((uvs[index0] *ut.a)+(uvs[index0+1] *ut.c)+ut.tx)*sourceWidth;
			u1=((uvs[index1] *ut.a)+(uvs[index1+1] *ut.c)+ut.tx)*sourceWidth;
			u2=((uvs[index2] *ut.a)+(uvs[index2+1] *ut.c)+ut.tx)*sourceWidth;
			v0=((uvs[index0] *ut.b)+(uvs[index0+1] *ut.d)+ut.ty)*sourceHeight;
			v1=((uvs[index1] *ut.b)+(uvs[index1+1] *ut.d)+ut.ty)*sourceHeight;
			v2=((uvs[index2] *ut.b)+(uvs[index2+1] *ut.d)+ut.ty)*sourceHeight;
		}
		else {
			u0=uvs[index0] *sourceWidth;
			u1=uvs[index1] *sourceWidth;
			u2=uvs[index2] *sourceWidth;
			v0=uvs[index0+1] *sourceHeight;
			v1=uvs[index1+1] *sourceHeight;
			v2=uvs[index2+1] *sourceHeight;
		};
		var x0=vertices[index0];
		var x1=vertices[index1];
		var x2=vertices[index2];
		var y0=vertices[index0+1];
		var y1=vertices[index1+1];
		var y2=vertices[index2+1];
		if (mesh.canvasPadding > 0){
			var paddingX=mesh.canvasPadding;
			var paddingY=mesh.canvasPadding;
			var centerX=(x0+x1+x2)/ 3;
			var centerY=(y0+y1+y2)/ 3;
			var normX=x0-centerX;
			var normY=y0-centerY;
			var dist=Math.sqrt((normX *normX)+(normY *normY));
			x0=centerX+((normX / dist)*(dist+paddingX));
			y0=centerY+((normY / dist)*(dist+paddingY));
			normX=x1-centerX;
			normY=y1-centerY;
			dist=Math.sqrt((normX *normX)+(normY *normY));
			x1=centerX+((normX / dist)*(dist+paddingX));
			y1=centerY+((normY / dist)*(dist+paddingY));
			normX=x2-centerX;
			normY=y2-centerY;
			dist=Math.sqrt((normX *normX)+(normY *normY));
			x2=centerX+((normX / dist)*(dist+paddingX));
			y2=centerY+((normY / dist)*(dist+paddingY));
		}
		context.save();
		if (this.transform){
			var mt=this.transform;
			context.transform(mt.a,mt.b,mt.c,mt.d,mt.tx,mt.ty);
		}
		context.beginPath();
		context.moveTo(x0,y0);
		context.lineTo(x1,y1);
		context.lineTo(x2,y2);
		context.closePath();
		context.clip();
		var delta=(u0 *v1)+(v0 *u2)+(u1 *v2)-(v1 *u2)-(v0 *u1)-(u0 *v2);
		var dDelta=1 / delta;
		var deltaA=(x0 *v1)+(v0 *x2)+(x1 *v2)-(v1 *x2)-(v0 *x1)-(x0 *v2);
		var deltaB=(u0 *x1)+(x0 *u2)+(u1 *x2)-(x1 *u2)-(x0 *u1)-(u0 *x2);
		var deltaC=(u0 *v1 *x2)+(v0 *x1 *u2)+(x0 *u1 *v2)-(x0 *v1 *u2)-(v0 *u1 *x2)-(u0 *x1 *v2);
		var deltaD=(y0 *v1)+(v0 *y2)+(y1 *v2)-(v1 *y2)-(v0 *y1)-(y0 *v2);
		var deltaE=(u0 *y1)+(y0 *u2)+(u1 *y2)-(y1 *u2)-(y0 *u1)-(u0 *y2);
		var deltaF=(u0 *v1 *y2)+(v0 *y1 *u2)+(y0 *u1 *v2)-(y0 *v1 *u2)-(v0 *u1 *y2)-(u0 *y1 *v2);
		context.transform(deltaA *dDelta,deltaD *dDelta,deltaB *dDelta,deltaE*dDelta,deltaC *dDelta,deltaF *dDelta);
		context.drawImage(textureSource,texture.uv[0]*sourceWidth,texture.uv[1]*sourceHeight,textureWidth,textureHeight,texture.uv[0]*sourceWidth,texture.uv[1]*sourceHeight,textureWidth,textureHeight);
		context.restore();
	}

	return CanvasMeshRender;
})()


/**
*@private
*/
//class laya.ani.bone.canvasmesh.MeshData
var MeshData=(function(){
	function MeshData(){
		/**
		*纹理
		*/
		this.texture=null;
		/**
		*uv数据
		*/
		this.uvs=[0,0,1,0,1,1,0,1];
		/**
		*顶点数据
		*/
		this.vertices=[0,0,100,0,100,100,0,100];
		/**
		*顶点索引
		*/
		this.indexes=[0,1,3,3,1,2];
		/**
		*uv变换矩阵
		*/
		this.uvTransform=null;
		/**
		*是否有uv变化矩阵
		*/
		this.useUvTransform=false;
		/**
		*扩展像素,用来去除黑边
		*/
		this.canvasPadding=1;
	}

	__class(MeshData,'laya.ani.bone.canvasmesh.MeshData');
	var __proto=MeshData.prototype;
	/**
	*计算mesh的Bounds
	*@return
	*
	*/
	__proto.getBounds=function(){
		return Rectangle._getWrapRec(this.vertices);
	}

	return MeshData;
})()


/**
*@private
*@author ...
*/
//class laya.ani.KeyFramesContent
var KeyFramesContent=(function(){
	function KeyFramesContent(){
		this.startTime=NaN;
		this.duration=NaN;
		this.interpolationData=null;
		//私有插值方式 [type0(插值类型),Data0(插值数据,可为空)，type1(插值类型),Data1(插值数据,可为空)] 注意：254全线性插值，255全不插值
		this.data=null;
		//=new Float32Array();
		this.nextData=null;
	}

	__class(KeyFramesContent,'laya.ani.KeyFramesContent');
	return KeyFramesContent;
})()


/**
*@private
*...
*@author ww
*/
//class laya.ani.math.BezierLerp
var BezierLerp=(function(){
	function BezierLerp(){}
	__class(BezierLerp,'laya.ani.math.BezierLerp');
	BezierLerp.getBezierRate=function(t,px0,py0,px1,py1){
		var key=BezierLerp._getBezierParamKey(px0,py0,px1,py1);
		var vKey=key *100+t;
		if (BezierLerp._bezierResultCache[vKey])return BezierLerp._bezierResultCache[vKey];
		var points=BezierLerp._getBezierPoints(px0,py0,px1,py1,key);
		var i=0,len=0;
		len=points.length;
		for (i=0;i < len;i+=2){
			if (t <=points[i]){
				BezierLerp._bezierResultCache[vKey]=points[i+1];
				return points[i+1];
			}
		}
		BezierLerp._bezierResultCache[vKey]=1;
		return 1;
	}

	BezierLerp._getBezierParamKey=function(px0,py0,px1,py1){
		return (((px0 *100+py0)*100+px1)*100+py1)*100;
	}

	BezierLerp._getBezierPoints=function(px0,py0,px1,py1,key){
		if (BezierLerp._bezierPointsCache[key])return BezierLerp._bezierPointsCache[key];
		var controlPoints;
		controlPoints=[0,0,px0,py0,px1,py1,1,1];
		var bz;
		bz=new Bezier();
		var points;
		points=bz.getBezierPoints(controlPoints,100,3);
		BezierLerp._bezierPointsCache[key]=points;
		return points;
	}

	BezierLerp._bezierResultCache={};
	BezierLerp._bezierPointsCache={};
	return BezierLerp;
})()


/**
*@private
*/
//class laya.d3.animation.AnimationClipParser01
var AnimationClipParser01=(function(){
	function AnimationClipParser01(){}
	__class(AnimationClipParser01,'laya.d3.animation.AnimationClipParser01');
	AnimationClipParser01.READ_DATA=function(){
		AnimationClipParser01._DATA.offset=AnimationClipParser01._reader.getUint32();
		AnimationClipParser01._DATA.size=AnimationClipParser01._reader.getUint32();
	}

	AnimationClipParser01.READ_BLOCK=function(){
		var count=AnimationClipParser01._BLOCK.count=AnimationClipParser01._reader.getUint16();
		var blockStarts=AnimationClipParser01._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser01._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser01._reader.getUint32());
			blockLengths.push(AnimationClipParser01._reader.getUint32());
		}
	}

	AnimationClipParser01.READ_STRINGS=function(){
		var offset=AnimationClipParser01._reader.getUint32();
		var count=AnimationClipParser01._reader.getUint16();
		var prePos=AnimationClipParser01._reader.pos;
		AnimationClipParser01._reader.pos=offset+AnimationClipParser01._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser01._strings[i]=AnimationClipParser01._reader.readUTFString();
		AnimationClipParser01._reader.pos=prePos;
	}

	AnimationClipParser01.parse=function(clip,reader){
		AnimationClipParser01._animationClip=clip;
		AnimationClipParser01._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationClipParser01.READ_DATA();
		AnimationClipParser01.READ_BLOCK();
		AnimationClipParser01.READ_STRINGS();
		for (var i=0,n=AnimationClipParser01._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser01._strings[index];
			var fn=AnimationClipParser01["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
	}

	AnimationClipParser01.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser01._reader;
		var buffer=reader.__getBuffer();
		var lengthTypes=[];
		var lenghthTypeCount=reader.getUint8();
		lengthTypes.length=lenghthTypeCount;
		for (i=0;i < lenghthTypeCount;i++)
		lengthTypes[i]=reader.getUint16();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser01._animationClip;
		clip.name=AnimationClipParser01._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes=new Array;
		nodes.length=nodeCount;
		var publicDatas=clip._publicClipDatas=[];
		publicDatas.length=nodeCount;
		var nodesMap=clip._nodesMap={};
		var cachePropertyToNodeIndex=0,unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i]=new KeyframeNode();
			var pathLength=reader.getUint16();
			var path=node.path=[];
			path.length=pathLength;
			for (j=0;j < pathLength;j++)
			path[j]=AnimationClipParser01._strings[reader.getUint16()];
			var nodePath=path.join("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			var componentTypeStrIndex=reader.getInt16();
			(componentTypeStrIndex!==-1)&& (node.componentType=AnimationClipParser01._strings[componentTypeStrIndex]);
			var propertyNameID=AnimationNode._propertyIndexDic[AnimationClipParser01._strings[reader.getUint16()]];
			if (propertyNameID !=null){
				var isTransformProperty=propertyNameID < 4;
				var cacheProperty=!isTransformProperty || (isTransformProperty && path[0]==="");
				node._cacheProperty=cacheProperty;
				if (cacheProperty)
					cachePropertyToNodeIndex++;
				else
				unCachePropertyToNodeIndex++;
				node.propertyNameID=propertyNameID;
				}else {
				throw new Error("AnimationClipParser01:unknown property name.");
			};
			var dataLength=lengthTypes[reader.getUint8()];
			node.keyFrameWidth=dataLength / 4;
			var keyFrames=node.keyFrames=[];
			var keyframeCount=keyFrames.length=reader.getUint16();
			var lastKeyFrame=null;
			var startTime=NaN;
			for (j=0;j < keyframeCount;j++){
				var keyFrame=keyFrames[j]=new Keyframe();
				startTime=keyFrame.startTime=startTimeTypes[reader.getUint16()];
				var offset=reader.pos;
				keyFrame.inTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.outTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.data=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				if (lastKeyFrame){
					lastKeyFrame.next=keyFrame;
					lastKeyFrame.duration=startTime-lastKeyFrame.startTime;
				}
				lastKeyFrame=keyFrame;
			}
			keyFrame.next=null;
			keyFrame.duration=clipDur-startTime;
		};
		var nodeToCachePropertyMap=clip._nodeToCachePropertyMap=new Int32Array(nodeCount);
		var cachePropertyToNodeMap=clip._cachePropertyMap=new Int32Array(cachePropertyToNodeIndex);
		var unCachePropertyToNodeMap=clip._unCachePropertyMap=new Int32Array(unCachePropertyToNodeIndex);
		cachePropertyToNodeIndex=unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i];
			if (node._cacheProperty){
				nodeToCachePropertyMap[i]=cachePropertyToNodeIndex;
				cachePropertyToNodeMap[cachePropertyToNodeIndex++]=i;
				}else {
				unCachePropertyToNodeMap[unCachePropertyToNodeIndex++]=i;
			}
		}
	}

	AnimationClipParser01._animationClip=null;
	AnimationClipParser01._reader=null;
	AnimationClipParser01._strings=[];
	__static(AnimationClipParser01,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser01;
})()


/**
*@private
*/
//class laya.d3.animation.AnimationClipParser02
var AnimationClipParser02=(function(){
	function AnimationClipParser02(){}
	__class(AnimationClipParser02,'laya.d3.animation.AnimationClipParser02');
	AnimationClipParser02.READ_DATA=function(){
		AnimationClipParser02._DATA.offset=AnimationClipParser02._reader.getUint32();
		AnimationClipParser02._DATA.size=AnimationClipParser02._reader.getUint32();
	}

	AnimationClipParser02.READ_BLOCK=function(){
		var count=AnimationClipParser02._BLOCK.count=AnimationClipParser02._reader.getUint16();
		var blockStarts=AnimationClipParser02._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser02._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser02._reader.getUint32());
			blockLengths.push(AnimationClipParser02._reader.getUint32());
		}
	}

	AnimationClipParser02.READ_STRINGS=function(){
		var offset=AnimationClipParser02._reader.getUint32();
		var count=AnimationClipParser02._reader.getUint16();
		var prePos=AnimationClipParser02._reader.pos;
		AnimationClipParser02._reader.pos=offset+AnimationClipParser02._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser02._strings[i]=AnimationClipParser02._reader.readUTFString();
		AnimationClipParser02._reader.pos=prePos;
	}

	AnimationClipParser02.parse=function(clip,reader){
		AnimationClipParser02._animationClip=clip;
		AnimationClipParser02._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationClipParser02.READ_DATA();
		AnimationClipParser02.READ_BLOCK();
		AnimationClipParser02.READ_STRINGS();
		for (var i=0,n=AnimationClipParser02._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser02._strings[index];
			var fn=AnimationClipParser02["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
	}

	AnimationClipParser02.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser02._reader;
		var buffer=reader.__getBuffer();
		var lengthTypes=[];
		var lenghthTypeCount=reader.getUint8();
		lengthTypes.length=lenghthTypeCount;
		for (i=0;i < lenghthTypeCount;i++)
		lengthTypes[i]=reader.getUint16();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser02._animationClip;
		clip.name=AnimationClipParser02._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes=new Array;
		nodes.length=nodeCount;
		var publicDatas=clip._publicClipDatas=[];
		publicDatas.length=nodeCount;
		var nodesMap=clip._nodesMap={};
		var cachePropertyToNodeIndex=0,unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i]=new KeyframeNode();
			var pathLength=reader.getUint16();
			var path=node.path=[];
			path.length=pathLength;
			for (j=0;j < pathLength;j++)
			path[j]=AnimationClipParser02._strings[reader.getUint16()];
			var nodePath=path.join("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			var componentTypeStrIndex=reader.getInt16();
			(componentTypeStrIndex!==-1)&& (node.componentType=AnimationClipParser02._strings[componentTypeStrIndex]);
			var propertyNameID=AnimationNode._propertyIndexDic[AnimationClipParser02._strings[reader.getUint16()]];
			if (propertyNameID !=null){
				var isTransformProperty=propertyNameID < 4;
				var cacheProperty=!isTransformProperty || (isTransformProperty && path[0]==="");
				node._cacheProperty=cacheProperty;
				if (cacheProperty)
					cachePropertyToNodeIndex++;
				else
				unCachePropertyToNodeIndex++;
				node.propertyNameID=propertyNameID;
				}else {
				throw new Error("AnimationClipParser02:unknown property name.");
			};
			var dataLength=lengthTypes[reader.getUint8()];
			node.keyFrameWidth=dataLength / 4;
			var keyFrames=node.keyFrames=[];
			var keyframeCount=keyFrames.length=reader.getUint16();
			var lastKeyFrame=null;
			var startTime=NaN;
			for (j=0;j < keyframeCount;j++){
				var keyFrame=keyFrames[j]=new Keyframe();
				startTime=keyFrame.startTime=startTimeTypes[reader.getUint16()];
				var offset=reader.pos;
				keyFrame.inTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.outTangent=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				offset=reader.pos;
				keyFrame.data=new Float32Array(buffer.slice(offset,offset+dataLength));
				reader.pos+=dataLength;
				if (lastKeyFrame){
					lastKeyFrame.next=keyFrame;
					lastKeyFrame.duration=startTime-lastKeyFrame.startTime;
				}
				lastKeyFrame=keyFrame;
			}
			keyFrame.next=null;
			keyFrame.duration=clipDur-startTime;
		};
		var eventCount=reader.getUint16();
		for (i=0;i < eventCount;i++){
			var event=new AnimationEvent();
			event.time=reader.getFloat32();
			event.eventName=AnimationClipParser02._strings[reader.getUint16()];
			var params;
			var paramCount=reader.getUint16();
			(paramCount > 0)&& (event.params=params=[]);
			for (j=0;j < paramCount;j++){
				var type=reader.getByte();
				switch (type){
					case 0:
						params.push(!!reader.getByte());
						break ;
					case 1:
						params.push(reader.getInt32());
						break ;
					case 2:
						params.push(reader.getFloat32());
						break ;
					case 3:
						params.push(AnimationClipParser02._strings[reader.getUint16()]);
						break ;
					default :
						throw new Error("unknown type.");
					}
			}
			clip.addEvent(event);
		};
		var nodeToCachePropertyMap=clip._nodeToCachePropertyMap=new Int32Array(nodeCount);
		var cachePropertyToNodeMap=clip._cachePropertyMap=new Int32Array(cachePropertyToNodeIndex);
		var unCachePropertyToNodeMap=clip._unCachePropertyMap=new Int32Array(unCachePropertyToNodeIndex);
		cachePropertyToNodeIndex=unCachePropertyToNodeIndex=0;
		for (i=0;i < nodeCount;i++){
			node=nodes[i];
			if (node._cacheProperty){
				nodeToCachePropertyMap[i]=cachePropertyToNodeIndex;
				cachePropertyToNodeMap[cachePropertyToNodeIndex++]=i;
				}else {
				unCachePropertyToNodeMap[unCachePropertyToNodeIndex++]=i;
			}
		}
	}

	AnimationClipParser02._animationClip=null;
	AnimationClipParser02._reader=null;
	AnimationClipParser02._strings=[];
	__static(AnimationClipParser02,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser02;
})()


/**
*<code>AnimationEvent</code> 类用于实现动画事件。
*/
//class laya.d3.animation.AnimationEvent
var AnimationEvent=(function(){
	function AnimationEvent(){
		/**事件触发时间。*/
		this.time=NaN;
		/**事件触发名称。*/
		this.eventName=null;
		/**事件触发参数。*/
		this.params=null;
	}

	__class(AnimationEvent,'laya.d3.animation.AnimationEvent');
	return AnimationEvent;
})()


/**
*<code>BoneNode</code> 类用于实现骨骼节点。
*/
//class laya.d3.animation.AnimationNode
var AnimationNode=(function(){
	function AnimationNode(){
		/**@private */
		//this._childs=null;
		/**@private */
		//this._parent=null;
		/**@private [只读]*/
		//this.transform=null;
		/**节点名称。 */
		//this.name=null;
		this._childs=[];
		this.transform=new AnimationTransform3D(this);
	}

	__class(AnimationNode,'laya.d3.animation.AnimationNode');
	var __proto=AnimationNode.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*添加子节点。
	*@param child 子节点。
	*/
	__proto.addChild=function(child){
		child._parent=this;
		child.transform.setParent(this.transform);
		this._childs.push(child);
	}

	/**
	*移除子节点。
	*@param child 子节点。
	*/
	__proto.removeChild=function(child){
		var index=this._childs.indexOf(child);
		(index!==-1)&& (this._childs.splice(index,1));
	}

	/**
	*根据名字获取子节点。
	*@param name 名字。
	*/
	__proto.getChildByName=function(name){
		for (var i=0,n=this._childs.length;i < n;i++){
			var child=this._childs[i];
			if (child.name===name)
				return child;
		}
		return null;
	}

	/**
	*根据索引获取子节点。
	*@param index 索引。
	*/
	__proto.getChildByIndex=function(index){
		return this._childs[index];
	}

	/**
	*获取子节点的个数。
	*/
	__proto.getChildCount=function(){
		return this._childs.length;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destNode=destObject;
		destNode.name=this.name;
		for (var i=0,n=this._childs.length;i < n;i++){
			var child=this._childs[i];
			var destChild=child.clone();
			destNode.addChild(destChild);
			var transform=child.transform;
			var destTransform=destChild.transform;
			destTransform.setLocalPosition(transform.getLocalPosition());
			destTransform.setLocalRotation(transform.getLocalRotation());
			destTransform.setLocalScale(transform.getLocalScale());
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	AnimationNode.__init__=function(){
		AnimationNode.registerAnimationNodeProperty("localPosition",AnimationNode._getLocalPosition,AnimationNode._setLocalPosition);
		AnimationNode.registerAnimationNodeProperty("localRotation",AnimationNode._getLocalRotation,AnimationNode._setLocalRotation);
		AnimationNode.registerAnimationNodeProperty("localScale",AnimationNode._getLocalScale,AnimationNode._setLocalScale);
		AnimationNode.registerAnimationNodeProperty("localRotationEuler",AnimationNode._getLocalRotationEuler,AnimationNode._setLocalRotationEuler);
		AnimationNode.registerAnimationNodeProperty("particleRender.sharedMaterial.tintColor",AnimationNode._getParticleRenderSharedMaterialTintColor,AnimationNode._setParticleRenderSharedMaterialTintColor);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.tilingOffset",AnimationNode._getMeshRenderSharedMaterialTilingOffset,AnimationNode._setMeshRenderSharedMaterialTilingOffset);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.albedoColor",AnimationNode._getMeshRenderSharedMaterialAlbedo,AnimationNode._setMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.tilingOffset",AnimationNode._getSkinnedMeshRenderSharedMaterialTilingOffset,AnimationNode._setSkinnedMeshRenderSharedMaterialTilingOffset);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.albedoColor",AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo,AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("meshRender.sharedMaterial.albedo",AnimationNode._getMeshRenderSharedMaterialAlbedo,AnimationNode._setMeshRenderSharedMaterialAlbedo);
		AnimationNode.registerAnimationNodeProperty("skinnedMeshRender.sharedMaterial.albedo",AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo,AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo);
	}

	AnimationNode.registerAnimationNodeProperty=function(propertyName,getFunc,setFunc){
		if (AnimationNode._propertyIndexDic[propertyName]){
			throw new Error("AnimationNode: this propertyName has registered.");
			}else {
			AnimationNode._propertyIndexDic[propertyName]=AnimationNode._propertyIDCounter;
			AnimationNode._propertyGetFuncs[AnimationNode._propertyIDCounter]=getFunc;
			AnimationNode._propertySetFuncs[AnimationNode._propertyIDCounter]=setFunc;
			AnimationNode._propertyIDCounter++;
		}
	}

	AnimationNode._getLocalPosition=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalPosition();
		else
		return sprite3D._transform.localPosition.elements;
	}

	AnimationNode._setLocalPosition=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalPosition(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localPosition=spriteTransform.localPosition;
			localPosition.elements=value;
			spriteTransform.localPosition=localPosition;
		}
	}

	AnimationNode._getLocalRotation=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalRotation();
		else
		return sprite3D._transform.localRotation.elements;
	}

	AnimationNode._setLocalRotation=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalRotation(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localRotation=spriteTransform.localRotation;
			localRotation.elements=value;
			spriteTransform.localRotation=localRotation;
		}
	}

	AnimationNode._getLocalScale=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalScale();
		else
		return sprite3D._transform.localScale.elements;
	}

	AnimationNode._setLocalScale=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalScale(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localScale=spriteTransform.localScale;
			localScale.elements=value;
			spriteTransform.localScale=localScale;
		}
	}

	AnimationNode._getLocalRotationEuler=function(animationNode,sprite3D){
		if (animationNode)
			return animationNode.transform.getLocalRotationEuler();
		else
		return sprite3D._transform.localRotationEuler.elements;
	}

	AnimationNode._setLocalRotationEuler=function(animationNode,sprite3D,value){
		if (animationNode){
			animationNode.transform.setLocalRotationEuler(value);
			}else {
			var spriteTransform=sprite3D._transform;
			var localRotationEuler=spriteTransform.localRotationEuler;
			localRotationEuler.elements=value;
			spriteTransform.localRotationEuler=localRotationEuler;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.tilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.tilingOffset.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D,value){
		var material,tilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				tilingOffset=material.tilingOffset;
				tilingOffset.elements=value;
				material.tilingOffset=tilingOffset;
			}
			}else {
			material=(sprite3D).meshRender.material;
			tilingOffset=material.tilingOffset;
			tilingOffset.elements=value;
			material.tilingOffset=tilingOffset;
		}
	}

	AnimationNode._getMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.sharedMaterial;
				return material.albedoColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).meshRender.sharedMaterial;
			return material.albedoColor.elements;
		}
	}

	AnimationNode._setMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D,value){
		var material,albedo;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).meshRender.material;
				albedo=material.albedoColor;
				albedo.elements=value;
				material.albedoColor=albedo;
			}
			}else {
			material=(sprite3D).meshRender.material;
			albedo=material.albedoColor;
			albedo.elements=value;
			material.albedoColor=albedo;
		}
	}

	AnimationNode._getSkinnedMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.sharedMaterial;
				return material.tilingOffset.elements;
			}else
			return null;
			}else {
			material=(sprite3D).skinnedMeshRender.sharedMaterial;
			return material.tilingOffset.elements;
		}
	}

	AnimationNode._setSkinnedMeshRenderSharedMaterialTilingOffset=function(animationNode,sprite3D,value){
		var material,tilingOffset;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.material;
				tilingOffset=material.tilingOffset;
				tilingOffset.elements=value;
				material.tilingOffset=tilingOffset;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.material;
			tilingOffset=material.tilingOffset;
			tilingOffset.elements=value;
			material.tilingOffset=tilingOffset;
		}
	}

	AnimationNode._getSkinnedMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.sharedMaterial;
				return material.albedoColor.elements;
				}else {
				return null;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.sharedMaterial;
			return material.albedoColor.elements;
		}
	}

	AnimationNode._setSkinnedMeshRenderSharedMaterialAlbedo=function(animationNode,sprite3D,value){
		var material,albedo;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).skinnedMeshRender.material;
				albedo=material.albedoColor;
				albedo.elements=value;
				material.albedoColor=albedo;
			}
			}else {
			material=(sprite3D).skinnedMeshRender.material;
			albedo=material.albedoColor;
			albedo.elements=value;
			material.albedoColor=albedo;
		}
	}

	AnimationNode._getParticleRenderSharedMaterialTintColor=function(animationNode,sprite3D){
		var material;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).particleRender.sharedMaterial;
				return material.tintColor.elements;
			}else
			return null;
			}else {
			material=(sprite3D).particleRender.sharedMaterial;
			return material.tintColor.elements;
		}
	}

	AnimationNode._setParticleRenderSharedMaterialTintColor=function(animationNode,sprite3D,value){
		var material,tintColor;
		if (animationNode){
			var entity=animationNode.transform._entity;
			if (entity){
				material=(entity.owner).particleRender.material;
				tintColor=material.tintColor;
				tintColor.elements=value;
				material.tintColor=tintColor;
			}
			}else {
			material=(sprite3D).particleRender.material;
			tintColor=material.tintColor;
			tintColor.elements=value;
			material.tintColor=tintColor;
		}
	}

	AnimationNode._propertyIDCounter=0;
	AnimationNode._propertyIndexDic={};
	AnimationNode._propertySetFuncs=[];
	AnimationNode._propertyGetFuncs=[];
	return AnimationNode;
})()


/**
*@private
*/
//class laya.d3.animation.Keyframe
var Keyframe=(function(){
	function Keyframe(){
		this.startTime=NaN;
		this.inTangent=null;
		this.outTangent=null;
		this.data=null;
		this.duration=NaN;
		this.next=null;
	}

	__class(Keyframe,'laya.d3.animation.Keyframe');
	return Keyframe;
})()


/**
*@private
*/
//class laya.d3.animation.KeyframeNode
var KeyframeNode=(function(){
	function KeyframeNode(){
		this._cacheProperty=false;
		this.path=null;
		this.componentType=null;
		//TODO:是否去掉
		this.propertyNameID=0;
		this.keyFrameWidth=0;
		this.defaultData=null;
		this.keyFrames=null;
	}

	__class(KeyframeNode,'laya.d3.animation.KeyframeNode');
	return KeyframeNode;
})()


/**
*<code>SplineCurvePositionVelocity</code> 类用于通过顶点和速度创建闪光插值。
*/
//class laya.d3.core.glitter.SplineCurvePositionVelocity
var SplineCurvePositionVelocity=(function(){
	function SplineCurvePositionVelocity(){
		this._tempVector30=new Vector3();
		this._tempVector31=new Vector3();
		this._tempVector32=new Vector3();
		this._a=new Vector3();
		this._b=new Vector3();
		this._c=new Vector3();
		this._d=new Vector3();
	}

	__class(SplineCurvePositionVelocity,'laya.d3.core.glitter.SplineCurvePositionVelocity');
	var __proto=SplineCurvePositionVelocity.prototype;
	/**
	*初始化插值所需信息。
	*@param position0 顶点0的位置。
	*@param velocity0 顶点0的速度。
	*@param position1 顶点1的位置。
	*@param velocity1 顶点1的速度。
	*/
	__proto.Init=function(position0,velocity0,position1,velocity1){
		position0.cloneTo(this._d);
		velocity0.cloneTo(this._c);
		Vector3.scale(position0,2.0,this._a);
		Vector3.scale(position1,2.0,this._tempVector30);
		Vector3.subtract(this._a,this._tempVector30,this._a);
		Vector3.add(this._a,velocity0,this._a);
		Vector3.add(this._a,velocity1,this._a);
		Vector3.scale(position1,3.0,this._b);
		Vector3.scale(position0,3.0,this._tempVector30);
		Vector3.subtract(this._b,this._tempVector30,this._b);
		Vector3.subtract(this._b,velocity1,this._b);
		Vector3.scale(velocity0,2.0,this._tempVector30);
		Vector3.subtract(this._b,this._tempVector30,this._b);
	}

	/**
	*初始化插值所需信息。
	*@param t 插值比例
	*@param out 输出结果
	*/
	__proto.Slerp=function(t,out){
		Vector3.scale(this._a,t *t *t,this._tempVector30);
		Vector3.scale(this._b,t *t,this._tempVector31);
		Vector3.scale(this._c,t,this._tempVector32);
		Vector3.add(this._tempVector30,this._tempVector31,out);
		Vector3.add(out,this._tempVector32,out);
		Vector3.add(out,this._d,out);
	}

	return SplineCurvePositionVelocity;
})()


/**
*<code>Layer</code> 类用于实现层。
*/
//class laya.d3.core.Layer
var Layer=(function(){
	function Layer(){
		/**@private 编号。*/
		//this._number=0;
		/**@private 蒙版值。*/
		//this._mask=0;
		/**@private 是否显示。*/
		//this._visible=false;
		/**@private 只读,不允许修改。*/
		//this._nonRigidbodyOffset=0;
		/**@private 只读,不允许修改。*/
		//this._colliders=null;
		/**名字。*/
		//this.name=null;
		this._visible=true;
		this._nonRigidbodyOffset=0;
		this._colliders=[];
	}

	__class(Layer,'laya.d3.core.Layer');
	var __proto=Layer.prototype;
	/**
	*@private
	*/
	__proto._binarySearchIndex=function(){
		var start=0;
		var end=Layer._collsionTestList.length-1;
		var mid=0;
		while (start <=end){
			mid=Math.floor((start+end)/ 2);
			var midValue=Layer._collsionTestList[mid];
			if (midValue==this._number)
				return mid;
			else if (midValue > this._number)
			end=mid-1;
			else
			start=mid+1;
		}
		return start;
	}

	/**
	*@private
	*/
	__proto._addCollider=function(collider){
		(this._colliders.length===0)&& (Layer._collsionTestList.splice(this._binarySearchIndex(),0,this._number));
		if (collider._isRigidbody){
			this._colliders.unshift(collider);
			this._nonRigidbodyOffset++;
			}else {
			this._colliders.push(collider);
		}
	}

	/**
	*@private
	*/
	__proto._removeCollider=function(collider){
		var index=this._colliders.indexOf(collider);
		if (index < this._nonRigidbodyOffset)
			this._nonRigidbodyOffset--;
		this._colliders.splice(index,1);
		(this._colliders.length===0)&& (Layer._collsionTestList.splice(Layer._collsionTestList.indexOf(this._number),1));
	}

	/**
	*获取编号。
	*@return 编号。
	*/
	__getset(0,__proto,'number',function(){
		return this._number;
	});

	/**
	*设置是否显示。
	*@param value 是否显示。
	*/
	/**
	*获取是否显示。
	*@return 是否显示。
	*/
	__getset(0,__proto,'visible',function(){
		return this._visible;
		},function(value){
		this._visible=value;
		if (value)
			Layer._visibleLayers=Layer._visibleLayers | this.mask;
		else
		Layer._visibleLayers=Layer._visibleLayers & ~this.mask;
	});

	/**
	*获取蒙版值。
	*@return 蒙版值。
	*/
	__getset(0,__proto,'mask',function(){
		return this._mask;
	});

	/**
	*设置Layer显示层。
	*@param value 显示层。
	*/
	/**
	*获取Layer显示层。
	*@return 显示层。
	*/
	__getset(1,Layer,'visibleLayers',function(){
		return Layer._visibleLayers;
		},function(value){
		Layer._visibleLayers=value;
		for (var i=0,n=Layer._layerList.length;i < n;i++){
			var layer=Layer._layerList[i];
			layer._visible=(layer._mask & Layer._visibleLayers)!==0;
		}
	});

	Layer.__init__=function(){
		Layer._layerList.length=31;
		for (var i=0;i < 31;i++){
			var layer=new Layer();
			Layer._layerList[i]=layer;
			if (i===0){
				layer.name="Default Layer";
				layer.visible=true;
				}else {
				layer.name="Layer-"+i;
				layer.visible=false;
			}
			layer._number=i;
			layer._mask=Math.pow(2,i);
		}
		Layer.currentCreationLayer=Layer._layerList[0];
	}

	Layer.getLayerByNumber=function(number){
		if (number < 0 || number > 30)
			throw new Error("无法返回指定Layer，该number超出范围！");
		return Layer._layerList[number];
	}

	Layer.getLayerByName=function(name){
		for (var i=0;i < 31;i++){
			if (Layer._layerList[i].name===name)
				return Layer._layerList[i];
		}
		throw new Error("无法返回指定Layer,该name不存在");
	}

	Layer.isVisible=function(mask){
		return (mask & Layer._currentCameraCullingMask & Layer._visibleLayers)!=0;
	}

	Layer._layerList=[];
	Layer._visibleLayers=2147483647;
	Layer._collsionTestList=[];
	Layer._currentCameraCullingMask=2147483647;
	Layer.maxCount=31;
	Layer.currentCreationLayer=null;
	return Layer;
})()


/**
*<code>Burst</code> 类用于粒子的爆裂描述。
*/
//class laya.d3.core.particleShuriKen.module.Burst
var Burst=(function(){
	function Burst(time,minCount,maxCount){
		/**@private 爆裂时间,单位为秒。*/
		this._time=NaN;
		/**@private 爆裂的最小数量。*/
		this._minCount=0;
		/**@private 爆裂的最大数量。*/
		this._maxCount=0;
		this._time=time;
		this._minCount=minCount;
		this._maxCount=maxCount;
	}

	__class(Burst,'laya.d3.core.particleShuriKen.module.Burst');
	var __proto=Burst.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destBurst=destObject;
		destBurst._time=this._time
		destBurst._minCount=this._minCount;
		destBurst._maxCount=this._maxCount;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destBurst=new this.constructor();
		this.cloneTo(destBurst);
		return destBurst;
	}

	/**
	*获取爆裂时间,单位为秒。
	*@return 爆裂时间,单位为秒。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
	});

	/**
	*获取爆裂的最小数量。
	*@return 爆裂的最小数量。
	*/
	__getset(0,__proto,'minCount',function(){
		return this._minCount;
	});

	/**
	*获取爆裂的最大数量。
	*@return 爆裂的最大数量。
	*/
	__getset(0,__proto,'maxCount',function(){
		return this._maxCount;
	});

	return Burst;
})()


/**
*<code>ColorOverLifetime</code> 类用于粒子的生命周期颜色。
*/
//class laya.d3.core.particleShuriKen.module.ColorOverLifetime
var ColorOverLifetime=(function(){
	function ColorOverLifetime(color){
		/**@private */
		this._color=null;
		/**是否启用。*/
		this.enbale=false;
		this._color=color;
	}

	__class(ColorOverLifetime,'laya.d3.core.particleShuriKen.module.ColorOverLifetime');
	var __proto=ColorOverLifetime.prototype;
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destColorOverLifetime=destObject;
		this._color.cloneTo(destColorOverLifetime._color);
		destColorOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destColor;
		switch (this._color.type){
			case 0:
				destColor=GradientColor.createByConstant(this._color.constant.clone());
				break ;
			case 1:
				destColor=GradientColor.createByGradient(this._color.gradient.clone());
				break ;
			case 2:
				destColor=GradientColor.createByRandomTwoConstant(this._color.constantMin.clone(),this._color.constantMax.clone());
				break ;
			case 3:
				destColor=GradientColor.createByRandomTwoGradient(this._color.gradientMin.clone(),this._color.gradientMax.clone());
				break ;
			};
		var destColorOverLifetime=new this.constructor(destColor);
		destColorOverLifetime.enbale=this.enbale;
		return destColorOverLifetime;
	}

	/**
	*获取颜色。
	*/
	__getset(0,__proto,'color',function(){
		return this._color;
	});

	return ColorOverLifetime;
})()


/**
*<code>Emission</code> 类用于粒子发射器。
*/
//class laya.d3.core.particleShuriKen.module.Emission
var Emission=(function(){
	function Emission(){
		/**@private */
		this._destroyed=false;
		/**@private 粒子发射速率,每秒发射的个数。*/
		this._emissionRate=0;
		/**@private 粒子的爆裂,不允许修改。*/
		this._bursts=null;
		/**是否启用。*/
		this.enbale=false;
		this._destroyed=false;
		this.emissionRate=10;
		this._bursts=[];
	}

	__class(Emission,'laya.d3.core.particleShuriKen.module.Emission');
	var __proto=Emission.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true,"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto._destroy=function(){
		this._bursts=null;
		this._destroyed=true;
	}

	/**
	*获取粒子爆裂个数。
	*@return 粒子爆裂个数。
	*/
	__proto.getBurstsCount=function(){
		return this._bursts.length;
	}

	/**
	*通过索引获取粒子爆裂。
	*@param index 爆裂索引。
	*@return 粒子爆裂。
	*/
	__proto.getBurstByIndex=function(index){
		return this._bursts[index];
	}

	/**
	*增加粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.addBurst=function(burst){
		var burstsCount=this._bursts.length;
		if (burstsCount > 0)
			for (var i=0;i < burstsCount;i++){
			if (this._bursts[i].time > burst.time)
				this._bursts.splice(i,0,burst);
		}
		this._bursts.push(burst);
	}

	/**
	*移除粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.removeBurst=function(burst){
		var index=this._bursts.indexOf(burst);
		if (index!==-1){
			this._bursts.splice(index,1);
		}
	}

	/**
	*通过索引移除粒子爆裂。
	*@param index 爆裂索引。
	*/
	__proto.removeBurstByIndex=function(index){
		this._bursts.splice(index,1);
	}

	/**
	*清空粒子爆裂。
	*/
	__proto.clearBurst=function(){
		this._bursts.length=0;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destEmission=destObject;
		var destBursts=destEmission._bursts;
		destBursts.length=this._bursts.length;
		for (var i=0,n=this._bursts.length;i < n;i++){
			var destBurst=destBursts[i];
			if (destBurst)
				this._bursts[i].cloneTo(destBurst);
			else
			destBursts[i]=this._bursts[i].clone();
		}
		destEmission._emissionRate=this._emissionRate;
		destEmission.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destEmission=new this.constructor();
		this.cloneTo(destEmission);
		return destEmission;
	}

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	/**
	*设置粒子发射速率。
	*@param emissionRate 粒子发射速率 (个/秒)。
	*/
	/**
	*获取粒子发射速率。
	*@return 粒子发射速率 (个/秒)。
	*/
	__getset(0,__proto,'emissionRate',function(){
		return this._emissionRate;
		},function(value){
		if (value < 0)
			throw new Error("ParticleBaseShape:emissionRate value must large or equal than 0.");
		this._emissionRate=value;
	});

	return Emission;
})()


/**
*<code>FrameOverTime</code> 类用于创建时间帧。
*/
//class laya.d3.core.particleShuriKen.module.FrameOverTime
var FrameOverTime=(function(){
	function FrameOverTime(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=0;
		/**@private */
		this._overTime=null;
		/**@private */
		this._constantMin=0;
		/**@private */
		this._constantMax=0;
		/**@private */
		this._overTimeMin=null;
		/**@private */
		this._overTimeMax=null;
	}

	__class(FrameOverTime,'laya.d3.core.particleShuriKen.module.FrameOverTime');
	var __proto=FrameOverTime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destFrameOverTime=destObject;
		destFrameOverTime._type=this._type;
		destFrameOverTime._constant=this._constant;
		this._overTime.cloneTo(destFrameOverTime._overTime);
		destFrameOverTime._constantMin=this._constantMin;
		destFrameOverTime._constantMax=this._constantMax;
		this._overTimeMin.cloneTo(destFrameOverTime._overTimeMin);
		this._overTimeMax.cloneTo(destFrameOverTime._overTimeMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrameOverTime=new this.constructor();
		this.cloneTo(destFrameOverTime);
		return destFrameOverTime;
	}

	/**
	*时间帧。
	*/
	__getset(0,__proto,'frameOverTimeData',function(){
		return this._overTime;
	});

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期旋转类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMin',function(){
		return this._overTimeMin;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMax',function(){
		return this._overTimeMax;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	FrameOverTime.createByConstant=function(constant){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	FrameOverTime.createByOverTime=function(overTime){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=1;
		rotationOverLifetime._overTime=overTime;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=2;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoOverTime=function(gradientFrameMin,gradientFrameMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=3;
		rotationOverLifetime._overTimeMin=gradientFrameMin;
		rotationOverLifetime._overTimeMax=gradientFrameMax;
		return rotationOverLifetime;
	}

	return FrameOverTime;
})()


/**
*<code>GradientRotation</code> 类用于创建渐变角速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientAngularVelocity
var GradientAngularVelocity=(function(){
	function GradientAngularVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantSeparate=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._gradientW=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
		/**@private */
		this._gradientWMin=null;
		/**@private */
		this._gradientWMax=null;
	}

	__class(GradientAngularVelocity,'laya.d3.core.particleShuriKen.module.GradientAngularVelocity');
	var __proto=GradientAngularVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientAngularVelocity=destObject;
		destGradientAngularVelocity._type=this._type;
		destGradientAngularVelocity._separateAxes=this._separateAxes;
		destGradientAngularVelocity._constant=this._constant;
		this._constantSeparate.cloneTo(destGradientAngularVelocity._constantSeparate);
		this._gradient.cloneTo(destGradientAngularVelocity._gradient);
		this._gradientX.cloneTo(destGradientAngularVelocity._gradientX);
		this._gradientY.cloneTo(destGradientAngularVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientAngularVelocity._gradientZ);
		destGradientAngularVelocity._constantMin=this._constantMin;
		destGradientAngularVelocity._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientAngularVelocity._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientAngularVelocity._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientAngularVelocity._gradientMin);
		this._gradientMax.cloneTo(destGradientAngularVelocity._gradientMax);
		this._gradientXMin.cloneTo(destGradientAngularVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientAngularVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientAngularVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientAngularVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientAngularVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientAngularVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientAngularVelocity=new this.constructor();
		this.cloneTo(destGradientAngularVelocity);
		return destGradientAngularVelocity;
	}

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*固定角速度。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*渐变角速度。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期角速度类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*分轴固定角速度。
	*/
	__getset(0,__proto,'constantSeparate',function(){
		return this._constantSeparate;
	});

	/**
	*渐变角角速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变角速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientW',function(){
		return this._gradientW;
	});

	/**
	*最小渐变角速度。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定角速度。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变角速度。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定角速度。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMin',function(){
		return this._gradientWMin;
	});

	/**
	*最小分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最大分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*最小渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*最大渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMax',function(){
		return this._gradientWMax;
	});

	/**
	*最小渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*最大渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientAngularVelocity.createByConstant=function(constant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constant=constant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByConstantSeparate=function(separateConstant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantSeparate=separateConstant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradient=function(gradient){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradient=gradient;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradientSeparate=function(gradientX,gradientY,gradientZ,gradientW){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientX=gradientX;
		gradientAngularVelocity._gradientY=gradientY;
		gradientAngularVelocity._gradientZ=gradientZ;
		gradientAngularVelocity._gradientW=gradientW;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constantMin=constantMin;
		gradientAngularVelocity._constantMax=constantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstantSeparate=function(separateConstantMin,separateConstantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantMinSeparate=separateConstantMin;
		gradientAngularVelocity._constantMaxSeparate=separateConstantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradientMin=gradientMin;
		gradientAngularVelocity._gradientMax=gradientMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax,gradientWMin,gradientWMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientXMin=gradientXMin;
		gradientAngularVelocity._gradientXMax=gradientXMax;
		gradientAngularVelocity._gradientYMin=gradientYMin;
		gradientAngularVelocity._gradientYMax=gradientYMax;
		gradientAngularVelocity._gradientZMin=gradientZMin;
		gradientAngularVelocity._gradientZMax=gradientZMax;
		gradientAngularVelocity._gradientWMin=gradientWMin;
		gradientAngularVelocity._gradientWMax=gradientWMax;
		return gradientAngularVelocity;
	}

	return GradientAngularVelocity;
})()


/**
*<code>GradientColor</code> 类用于创建渐变颜色。
*/
//class laya.d3.core.particleShuriKen.module.GradientColor
var GradientColor=(function(){
	function GradientColor(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
	}

	__class(GradientColor,'laya.d3.core.particleShuriKen.module.GradientColor');
	var __proto=GradientColor.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientColor=destObject;
		destGradientColor._type=this._type;
		this._constant.cloneTo(destGradientColor._constant);
		this._constantMin.cloneTo(destGradientColor._constantMin);
		this._constantMax.cloneTo(destGradientColor._constantMax);
		this._gradient.cloneTo(destGradientColor._gradient);
		this._gradientMin.cloneTo(destGradientColor._gradientMin);
		this._gradientMax.cloneTo(destGradientColor._gradientMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientColor=new this.constructor();
		this.cloneTo(destGradientColor);
		return destGradientColor;
	}

	/**
	*渐变颜色。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*固定颜色。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期颜色类型,0为固定颜色模式,1渐变模式,2为随机双固定颜色模式,3随机双渐变模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小渐变颜色。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小固定颜色。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变颜色。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大固定颜色。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	GradientColor.createByConstant=function(constant){
		var gradientColor=new GradientColor();
		gradientColor._type=0;
		gradientColor._constant=constant;
		return gradientColor;
	}

	GradientColor.createByGradient=function(gradient){
		var gradientColor=new GradientColor();
		gradientColor._type=1;
		gradientColor._gradient=gradient;
		return gradientColor;
	}

	GradientColor.createByRandomTwoConstant=function(minConstant,maxConstant){
		var gradientColor=new GradientColor();
		gradientColor._type=2;
		gradientColor._constantMin=minConstant;
		gradientColor._constantMax=maxConstant;
		return gradientColor;
	}

	GradientColor.createByRandomTwoGradient=function(minGradient,maxGradient){
		var gradientColor=new GradientColor();
		gradientColor._type=3;
		gradientColor._gradientMin=minGradient;
		gradientColor._gradientMax=maxGradient;
		return gradientColor;
	}

	return GradientColor;
})()


/**
*<code>GradientDataColor</code> 类用于创建颜色渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataColor
var GradientDataColor=(function(){
	function GradientDataColor(){
		/**@private */
		this._alphaCurrentLength=0;
		/**@private */
		this._rgbCurrentLength=0;
		/**@private 开发者禁止修改。*/
		this._alphaElements=null;
		/**@private 开发者禁止修改。*/
		this._rgbElements=null;
		this._alphaElements=new Float32Array(8);
		this._rgbElements=new Float32Array(16);
	}

	__class(GradientDataColor,'laya.d3.core.particleShuriKen.module.GradientDataColor');
	var __proto=GradientDataColor.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加Alpha渐变。
	*@param key 生命周期，范围为0到1。
	*@param value rgb值。
	*/
	__proto.addAlpha=function(key,value){
		if (this._alphaCurrentLength < 8){
			if ((this._alphaCurrentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataColor warning:the forth key is  be force set to 1.");
			}
			this._alphaElements[this._alphaCurrentLength++]=key;
			this._alphaElements[this._alphaCurrentLength++]=value;
			}else {
			console.log("GradientDataColor warning:data count must lessEqual than 4");
		}
	}

	/**
	*增加RGB渐变。
	*@param key 生命周期，范围为0到1。
	*@param value RGB值。
	*/
	__proto.addRGB=function(key,value){
		if (this._rgbCurrentLength < 16){
			if ((this._rgbCurrentLength===12)&& ((key!==1))){
				key=1;
				console.log("GradientDataColor warning:the forth key is  be force set to 1.");
			}
			this._rgbElements[this._rgbCurrentLength++]=key;
			this._rgbElements[this._rgbCurrentLength++]=value.x;
			this._rgbElements[this._rgbCurrentLength++]=value.y;
			this._rgbElements[this._rgbCurrentLength++]=value.z;
			}else {
			console.log("GradientDataColor warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataColor=destObject;
		var i=0,n=0;
		destGradientDataColor._alphaCurrentLength=this._alphaCurrentLength;
		var destAlphaElements=destGradientDataColor._alphaElements;
		destAlphaElements.length=this._alphaElements.length;
		for (i=0,n=this._alphaElements.length;i < n;i++)
		destAlphaElements[i]=this._alphaElements[i];
		destGradientDataColor._rgbCurrentLength=this._rgbCurrentLength;
		var destRGBElements=destGradientDataColor._rgbElements;
		destRGBElements.length=this._rgbElements.length;
		for (i=0,n=this._rgbElements.length;i < n;i++)
		destRGBElements[i]=this._rgbElements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataColor=new this.constructor();
		this.cloneTo(destGradientDataColor);
		return destGradientDataColor;
	}

	/**渐变Alpha数量。*/
	__getset(0,__proto,'alphaGradientCount',function(){
		return this._alphaCurrentLength / 2;
	});

	/**渐变RGB数量。*/
	__getset(0,__proto,'rgbGradientCount',function(){
		return this._rgbCurrentLength / 4;
	});

	return GradientDataColor;
})()


/**
*<code>GradientDataInt</code> 类用于创建整形渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataInt
var GradientDataInt=(function(){
	function GradientDataInt(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataInt,'laya.d3.core.particleShuriKen.module.GradientDataInt');
	var __proto=GradientDataInt.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加整形渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 整形值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("Warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("Warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataInt=destObject;
		destGradientDataInt._currentLength=this._currentLength;
		var destElements=destGradientDataInt._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++){
			destElements[i]=this._elements[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataInt=new this.constructor();
		this.cloneTo(destGradientDataInt);
		return destGradientDataInt;
	}

	/**整形渐变数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataInt;
})()


/**
*<code>GradientDataNumber</code> 类用于创建浮点渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataNumber
var GradientDataNumber=(function(){
	function GradientDataNumber(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataNumber,'laya.d3.core.particleShuriKen.module.GradientDataNumber');
	var __proto=GradientDataNumber.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加浮点渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 浮点值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataNumber warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("GradientDataNumber warning:data count must lessEqual than 4");
		}
	}

	/**
	*通过索引获取键。
	*@param index 索引。
	*@return value 键。
	*/
	__proto.getKeyByIndex=function(index){
		return this._elements[index *2];
	}

	/**
	*通过索引获取值。
	*@param index 索引。
	*@return value 值。
	*/
	__proto.getValueByIndex=function(index){
		return this._elements[index *2+1];
	}

	/**
	*获取平均值。
	*/
	__proto.getAverageValue=function(){
		var total=0;
		for (var i=0,n=this._currentLength-2;i < n;i+=2){
			var subValue=this._elements[i+1];
			subValue+=this._elements[i+3];
			subValue=subValue *(this._elements[i+2]-this._elements[i]);
		}
		return total / 2;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataNumber=destObject;
		destGradientDataNumber._currentLength=this._currentLength;
		var destElements=destGradientDataNumber._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++)
		destElements[i]=this._elements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataNumber=new this.constructor();
		this.cloneTo(destGradientDataNumber);
		return destGradientDataNumber;
	}

	/**渐变浮点数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataNumber;
})()


/**
*<code>GradientSize</code> 类用于创建渐变尺寸。
*/
//class laya.d3.core.particleShuriKen.module.GradientSize
var GradientSize=(function(){
	function GradientSize(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientSize,'laya.d3.core.particleShuriKen.module.GradientSize');
	var __proto=GradientSize.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*获取最大尺寸。
	*/
	__proto.getMaxSizeInGradient=function(){
		var i=0,n=0;
		var maxSize=-Number.MAX_VALUE;
		switch (this._type){
			case 0:
				if (this._separateAxes){
					for (i=0,n=this._gradientX.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientX.getValueByIndex(i));
					for (i=0,n=this._gradientY.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientY.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradient.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradient.getValueByIndex(i));
				}
				break ;
			case 1:
				if (this._separateAxes){
					maxSize=Math.max(this._constantMinSeparate.x,this._constantMaxSeparate.x);
					maxSize=Math.max(maxSize,this._constantMinSeparate.y);
					maxSize=Math.max(maxSize,this._constantMaxSeparate.y);
					}else {
					maxSize=Math.max(this._constantMin,this._constantMax);
				}
				break ;
			case 2:
				if (this._separateAxes){
					for (i=0,n=this._gradientXMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMin.getValueByIndex(i));
					for (i=0,n=this._gradientXMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMax.getValueByIndex(i));
					for (i=0,n=this._gradientYMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientYMin.getValueByIndex(i));
					for (i=0,n=this._gradientZMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientZMax.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradientMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMin.getValueByIndex(i));
					for (i=0,n=this._gradientMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMax.getValueByIndex(i));
				}
				break ;
			}
		return maxSize;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientSize=destObject;
		destGradientSize._type=this._type;
		destGradientSize._separateAxes=this._separateAxes;
		this._gradient.cloneTo(destGradientSize._gradient);
		this._gradientX.cloneTo(destGradientSize._gradientX);
		this._gradientY.cloneTo(destGradientSize._gradientY);
		this._gradientZ.cloneTo(destGradientSize._gradientZ);
		destGradientSize._constantMin=this._constantMin;
		destGradientSize._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientSize._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientSize._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientSize._gradientMin);
		this._gradientMax.cloneTo(destGradientSize._gradientMax);
		this._gradientXMin.cloneTo(destGradientSize._gradientXMin);
		this._gradientXMax.cloneTo(destGradientSize._gradientXMax);
		this._gradientYMin.cloneTo(destGradientSize._gradientYMin);
		this._gradientYMax.cloneTo(destGradientSize._gradientYMax);
		this._gradientZMin.cloneTo(destGradientSize._gradientZMin);
		this._gradientZMax.cloneTo(destGradientSize._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientSize=new this.constructor();
		this.cloneTo(destGradientSize);
		return destGradientSize;
	}

	/**
	*渐变尺寸Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*渐变尺寸。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期尺寸类型，0曲线模式，1随机双常量模式，2随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最小尺寸。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变尺寸X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变尺寸Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最大尺寸。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*渐变最小尺寸X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*渐变最大尺寸X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*渐变最小尺寸Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大尺寸Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小尺寸Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大尺寸Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientSize.createByGradient=function(gradient){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=false;
		gradientSize._gradient=gradient;
		return gradientSize;
	}

	GradientSize.createByGradientSeparate=function(gradientX,gradientY,gradientZ){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=true;
		gradientSize._gradientX=gradientX;
		gradientSize._gradientY=gradientY;
		gradientSize._gradientZ=gradientZ;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=false;
		gradientSize._constantMin=constantMin;
		gradientSize._constantMax=constantMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstantSeparate=function(constantMinSeparate,constantMaxSeparate){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=true;
		gradientSize._constantMinSeparate=constantMinSeparate;
		gradientSize._constantMaxSeparate=constantMaxSeparate;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=false;
		gradientSize._gradientMin=gradientMin;
		gradientSize._gradientMax=gradientMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=true;
		gradientSize._gradientXMin=gradientXMin;
		gradientSize._gradientXMax=gradientXMax;
		gradientSize._gradientYMin=gradientYMin;
		gradientSize._gradientYMax=gradientYMax;
		gradientSize._gradientZMin=gradientZMin;
		gradientSize._gradientZMax=gradientZMax;
		return gradientSize;
	}

	return GradientSize;
})()


/**
*<code>GradientVelocity</code> 类用于创建渐变速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientVelocity
var GradientVelocity=(function(){
	function GradientVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientVelocity,'laya.d3.core.particleShuriKen.module.GradientVelocity');
	var __proto=GradientVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientVelocity=destObject;
		destGradientVelocity._type=this._type;
		this._constant.cloneTo(destGradientVelocity._constant);
		this._gradientX.cloneTo(destGradientVelocity._gradientX);
		this._gradientY.cloneTo(destGradientVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientVelocity._gradientZ);
		this._constantMin.cloneTo(destGradientVelocity._constantMin);
		this._constantMax.cloneTo(destGradientVelocity._constantMax);
		this._gradientXMin.cloneTo(destGradientVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientVelocity=new this.constructor();
		this.cloneTo(destGradientVelocity);
		return destGradientVelocity;
	}

	/**
	*渐变速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**固定速度。*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期速度类型，0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最大速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**最小固定速度。*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最小速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**最大固定速度。*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*渐变最小速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientVelocity.createByConstant=function(constant){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=0;
		gradientVelocity._constant=constant;
		return gradientVelocity;
	}

	GradientVelocity.createByGradient=function(gradientX,gradientY,gradientZ){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=1;
		gradientVelocity._gradientX=gradientX;
		gradientVelocity._gradientY=gradientY;
		gradientVelocity._gradientZ=gradientZ;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=2;
		gradientVelocity._constantMin=constantMin;
		gradientVelocity._constantMax=constantMax;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoGradient=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=3;
		gradientVelocity._gradientXMin=gradientXMin;
		gradientVelocity._gradientXMax=gradientXMax;
		gradientVelocity._gradientYMin=gradientYMin;
		gradientVelocity._gradientYMax=gradientYMax;
		gradientVelocity._gradientZMin=gradientZMin;
		gradientVelocity._gradientZMax=gradientZMax;
		return gradientVelocity;
	}

	return GradientVelocity;
})()


/**
*<code>RotationOverLifetime</code> 类用于粒子的生命周期旋转。
*/
//class laya.d3.core.particleShuriKen.module.RotationOverLifetime
var RotationOverLifetime=(function(){
	function RotationOverLifetime(angularVelocity){
		/**@private */
		this._angularVelocity=null;
		/**是否启用*/
		this.enbale=false;
		this._angularVelocity=angularVelocity;
	}

	__class(RotationOverLifetime,'laya.d3.core.particleShuriKen.module.RotationOverLifetime');
	var __proto=RotationOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destRotationOverLifetime=destObject;
		this._angularVelocity.cloneTo(destRotationOverLifetime._angularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destAngularVelocity;
		switch (this._angularVelocity.type){
			case 0:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByConstantSeparate(this._angularVelocity.constantSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByConstant(this._angularVelocity.constant);
				break ;
			case 1:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByGradientSeparate(this._angularVelocity.gradientX.clone(),this._angularVelocity.gradientY.clone(),this._angularVelocity.gradientZ.clone(),this._angularVelocity.gradientW.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByGradient(this._angularVelocity.gradient.clone());
				break ;
			case 2:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstantSeparate(this._angularVelocity.constantMinSeparate.clone(),this._angularVelocity.constantMaxSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstant(this._angularVelocity.constantMin,this._angularVelocity.constantMax);
				break ;
			case 3:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradientSeparate(this._angularVelocity.gradientXMin.clone(),this._angularVelocity.gradientYMin.clone(),this._angularVelocity.gradientZMin.clone(),this._angularVelocity.gradientWMin.clone(),this._angularVelocity.gradientXMax.clone(),this._angularVelocity.gradientYMax.clone(),this._angularVelocity.gradientZMax.clone(),this._angularVelocity.gradientWMax.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradient(this._angularVelocity.gradientMin.clone(),this._angularVelocity.gradientMax.clone());
				break ;
			};
		var destRotationOverLifetime=new this.constructor(destAngularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
		return destRotationOverLifetime;
	}

	/**
	*获取角速度。
	*/
	__getset(0,__proto,'angularVelocity',function(){
		return this._angularVelocity;
	});

	return RotationOverLifetime;
})()


/**
*<code>BaseShape</code> 类用于粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.BaseShape
var BaseShape=(function(){
	function BaseShape(){
		/**是否启用。*/
		this.enable=false;
		/**随机方向。*/
		this.randomDirection=false;
	}

	__class(BaseShape,'laya.d3.core.particleShuriKen.module.shape.BaseShape');
	var __proto=BaseShape.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**@private */
	__proto._getShapeBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**@private */
	__proto._getSpeedBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*@private
	*/
	__proto._calculateProceduralBounds=function(boundBox,emitterPosScale,minMaxBounds){
		this._getShapeBoundBox(boundBox);
		var min=boundBox.min;
		var max=boundBox.max;
		Vector3.multiply(min,emitterPosScale,min);
		Vector3.multiply(max,emitterPosScale,max);
		var speedBounds=new BoundBox(new Vector3(),new Vector3());
		if (this.randomDirection){
			speedBounds.min=new Vector3(-1,-1,-1);
			speedBounds.max=new Vector3(1,1,1);
		}
		else{
			this._getSpeedBoundBox(speedBounds);
		};
		var maxSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var maxSpeedMin=maxSpeedBound.min;
		var maxSpeedMax=maxSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.y,maxSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.y,maxSpeedMax);
		Vector3.add(boundBox.min,maxSpeedMin,maxSpeedMin);
		Vector3.add(boundBox.max,maxSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
		var minSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var minSpeedMin=minSpeedBound.min;
		var minSpeedMax=minSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.x,minSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.x,minSpeedMax);
		Vector3.min(minSpeedBound.min,minSpeedMax,maxSpeedMin);
		Vector3.max(minSpeedBound.min,minSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destShape=destObject;
		destShape.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destShape=new this.constructor();
		this.cloneTo(destShape);
		return destShape;
	}

	return BaseShape;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.particleShuriKen.module.shape.ShapeUtils
var ShapeUtils=(function(){
	function ShapeUtils(){}
	__class(ShapeUtils,'laya.d3.core.particleShuriKen.module.shape.ShapeUtils');
	ShapeUtils._randomPointUnitArcCircle=function(arc,out,rand){
		var outE=out.elements;
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*arc;
		else
		angle=Math.random()*arc;
		outE[0]=Math.cos(angle);
		outE[1]=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitArcCircle=function(arc,out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitArcCircle(arc,out,rand);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
	}

	ShapeUtils._randomPointUnitCircle=function(out,rand){
		var outE=out.elements;
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*Math.PI *2;
		else
		angle=Math.random()*Math.PI *2;
		outE[0]=Math.cos(angle);
		outE[1]=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitCircle=function(out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitCircle(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
	}

	ShapeUtils._randomPointUnitSphere=function(out,rand){
		var outE=out.elements;
		var z=NaN;
		var a=NaN;
		if (rand){
			z=outE[2]=rand.getFloat()*2-1.0;
			a=rand.getFloat()*Math.PI *2;
			}else {
			z=outE[2]=Math.random()*2-1.0;
			a=Math.random()*Math.PI *2;
		};
		var r=Math.sqrt(1.0-z *z);
		outE[0]=r *Math.cos(a);
		outE[1]=r *Math.sin(a);
	}

	ShapeUtils._randomPointInsideUnitSphere=function(out,rand){
		var outE=out.elements;
		ShapeUtils._randomPointUnitSphere(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 3.0);
		else
		range=Math.pow(Math.random(),1.0 / 3.0);
		outE[0]=outE[0] *range;
		outE[1]=outE[1] *range;
		outE[2]=outE[2] *range;
	}

	ShapeUtils._randomPointInsideHalfUnitBox=function(out,rand){
		var outE=out.elements;
		if (rand){
			outE[0]=(rand.getFloat()-0.5);
			outE[1]=(rand.getFloat()-0.5);
			outE[2]=(rand.getFloat()-0.5);
			}else {
			outE[0]=(Math.random()-0.5);
			outE[1]=(Math.random()-0.5);
			outE[2]=(Math.random()-0.5);
		}
	}

	return ShapeUtils;
})()


/**
*<code>SizeOverLifetime</code> 类用于粒子的生命周期尺寸。
*/
//class laya.d3.core.particleShuriKen.module.SizeOverLifetime
var SizeOverLifetime=(function(){
	function SizeOverLifetime(size){
		/**@private */
		this._size=null;
		/**是否启用*/
		this.enbale=false;
		this._size=size;
	}

	__class(SizeOverLifetime,'laya.d3.core.particleShuriKen.module.SizeOverLifetime');
	var __proto=SizeOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destSizeOverLifetime=destObject;
		this._size.cloneTo(destSizeOverLifetime._size);
		destSizeOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destSize;
		switch (this._size.type){
			case 0:
				if (this._size.separateAxes)
					destSize=GradientSize.createByGradientSeparate(this._size.gradientX.clone(),this._size.gradientY.clone(),this._size.gradientZ.clone());
				else
				destSize=GradientSize.createByGradient(this._size.gradient.clone());
				break ;
			case 1:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoConstantSeparate(this._size.constantMinSeparate.clone(),this._size.constantMaxSeparate.clone());
				else
				destSize=GradientSize.createByRandomTwoConstant(this._size.constantMin,this._size.constantMax);
				break ;
			case 2:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoGradientSeparate(this._size.gradientXMin.clone(),this._size.gradientYMin.clone(),this._size.gradientZMin.clone(),this._size.gradientXMax.clone(),this._size.gradientYMax.clone(),this._size.gradientZMax.clone());
				else
				destSize=GradientSize.createByRandomTwoGradient(this._size.gradientMin.clone(),this._size.gradientMax.clone());
				break ;
			};
		var destSizeOverLifetime=new this.constructor(destSize);
		destSizeOverLifetime.enbale=this.enbale;
		return destSizeOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'size',function(){
		return this._size;
	});

	return SizeOverLifetime;
})()


/**
*<code>StartFrame</code> 类用于创建开始帧。
*/
//class laya.d3.core.particleShuriKen.module.StartFrame
var StartFrame=(function(){
	function StartFrame(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
	}

	__class(StartFrame,'laya.d3.core.particleShuriKen.module.StartFrame');
	var __proto=StartFrame.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destStartFrame=destObject;
		destStartFrame._type=this._type;
		destStartFrame._constant=this._constant;
		destStartFrame._constantMin=this._constantMin;
		destStartFrame._constantMax=this._constantMax;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destStartFrame=new this.constructor();
		this.cloneTo(destStartFrame);
		return destStartFrame;
	}

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*开始帧类型,0常量模式，1随机双常量模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	StartFrame.createByConstant=function(constant){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	StartFrame.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=1;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	return StartFrame;
})()


/**
*<code>TextureSheetAnimation</code> 类用于创建粒子帧动画。
*/
//class laya.d3.core.particleShuriKen.module.TextureSheetAnimation
var TextureSheetAnimation=(function(){
	function TextureSheetAnimation(frame,startFrame){
		/**@private */
		this._frame=null;
		/**@private */
		this._startFrame=null;
		/**纹理平铺。*/
		this.tiles=null;
		/**类型,0为whole sheet、1为singal row。*/
		this.type=0;
		/**是否随机行，type为1时有效。*/
		this.randomRow=false;
		/**行索引,type为1时有效。*/
		this.rowIndex=0;
		/**循环次数。*/
		this.cycles=0;
		/**UV通道类型,0为Noting,1为Everything,待补充,暂不支持。*/
		this.enableUVChannels=0;
		/**是否启用*/
		this.enable=false;
		this.tiles=new Vector2(1,1);
		this.type=0;
		this.randomRow=true;
		this.rowIndex=0;
		this.cycles=1;
		this.enableUVChannels=1;
		this._frame=frame;
		this._startFrame=startFrame;
	}

	__class(TextureSheetAnimation,'laya.d3.core.particleShuriKen.module.TextureSheetAnimation');
	var __proto=TextureSheetAnimation.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destTextureSheetAnimation=destObject;
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		this._frame.cloneTo(destTextureSheetAnimation._frame);
		this._startFrame.cloneTo(destTextureSheetAnimation._startFrame);
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrame;
		switch (this._frame.type){
			case 0:
				destFrame=FrameOverTime.createByConstant(this._frame.constant);
				break ;
			case 1:
				destFrame=FrameOverTime.createByOverTime(this._frame.frameOverTimeData.clone());
				break ;
			case 2:
				destFrame=FrameOverTime.createByRandomTwoConstant(this._frame.constantMin,this._frame.constantMax);
				break ;
			case 3:
				destFrame=FrameOverTime.createByRandomTwoOverTime(this._frame.frameOverTimeDataMin.clone(),this._frame.frameOverTimeDataMax.clone());
				break ;
			};
		var destStartFrame;
		switch (this._startFrame.type){
			case 0:
				destStartFrame=StartFrame.createByConstant(this._startFrame.constant);
				break ;
			case 1:
				destStartFrame=StartFrame.createByRandomTwoConstant(this._startFrame.constantMin,this._startFrame.constantMax);
				break ;
			};
		var destTextureSheetAnimation=new this.constructor(destFrame,destStartFrame);
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
		return destTextureSheetAnimation;
	}

	/**获取时间帧率。*/
	__getset(0,__proto,'frame',function(){
		return this._frame;
	});

	/**获取开始帧率。*/
	__getset(0,__proto,'startFrame',function(){
		return this._startFrame;
	});

	return TextureSheetAnimation;
})()


/**
*<code>VelocityOverLifetime</code> 类用于粒子的生命周期速度。
*/
//class laya.d3.core.particleShuriKen.module.VelocityOverLifetime
var VelocityOverLifetime=(function(){
	function VelocityOverLifetime(velocity){
		/**@private */
		this._velocity=null;
		/**是否启用*/
		this.enbale=false;
		/**速度空间,0为local,1为world。*/
		this.space=0;
		this._velocity=velocity;
	}

	__class(VelocityOverLifetime,'laya.d3.core.particleShuriKen.module.VelocityOverLifetime');
	var __proto=VelocityOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVelocityOverLifetime=destObject;
		this._velocity.cloneTo(destVelocityOverLifetime._velocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVelocity;
		switch(this._velocity.type){
			case 0:
				destVelocity=GradientVelocity.createByConstant(this._velocity.constant.clone());
				break ;
			case 1:
				destVelocity=GradientVelocity.createByGradient(this._velocity.gradientX.clone(),this._velocity.gradientY.clone(),this._velocity.gradientZ.clone());
				break ;
			case 2:
				destVelocity=GradientVelocity.createByRandomTwoConstant(this._velocity.constantMin.clone(),this._velocity.constantMax.clone());
				break ;
			case 3:
				destVelocity=GradientVelocity.createByRandomTwoGradient(this._velocity.gradientXMin.clone(),this._velocity.gradientYMin.clone(),this._velocity.gradientZMin.clone(),this._velocity.gradientXMax.clone(),this._velocity.gradientYMax.clone(),this._velocity.gradientZMax.clone());
				break ;
			};
		var destVelocityOverLifetime=new this.constructor(destVelocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
		return destVelocityOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	return VelocityOverLifetime;
})()


/**
*@private
*/
//class laya.d3.core.particleShuriKen.ShurikenParticleData
var ShurikenParticleData=(function(){
	function ShurikenParticleData(){}
	__class(ShurikenParticleData,'laya.d3.core.particleShuriKen.ShurikenParticleData');
	ShurikenParticleData._getStartLifetimeFromGradient=function(startLifeTimeGradient,emissionTime){
		for (var i=1,n=startLifeTimeGradient.gradientCount;i < n;i++){
			var key=startLifeTimeGradient.getKeyByIndex(i);
			if (key >=emissionTime){
				var lastKey=startLifeTimeGradient.getKeyByIndex(i-1);
				var age=(emissionTime-lastKey)/ (key-lastKey);
				return MathUtil.lerp(startLifeTimeGradient.getValueByIndex(i-1),startLifeTimeGradient.getValueByIndex(i),age)
			}
		}
		throw new Error("ShurikenParticleData: can't get value foam startLifeTimeGradient.");
	}

	ShurikenParticleData._randomInvertRoationArray=function(rotatonE,outE,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection){
			outE[0]=-rotatonE[0];
			outE[1]=-rotatonE[1];
			outE[2]=-rotatonE[2];
			}else {
			outE[0]=rotatonE[0];
			outE[1]=rotatonE[1];
			outE[2]=rotatonE[2];
		}
	}

	ShurikenParticleData._randomInvertRoation=function(rotaton,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection)
			rotaton=-rotaton;
		return rotaton;
	}

	ShurikenParticleData.create=function(particleSystem,particleRender,transform){
		var autoRandomSeed=particleSystem.autoRandomSeed;
		var rand=particleSystem._rand;
		var randomSeeds=particleSystem._randomSeeds;
		switch (particleSystem.startColorType){
			case 0:;
				var constantStartColorE=particleSystem.startColorConstant.elements;
				ShurikenParticleData.startColor[0]=constantStartColorE[0];
				ShurikenParticleData.startColor[1]=constantStartColorE[1];
				ShurikenParticleData.startColor[2]=constantStartColorE[2];
				ShurikenParticleData.startColor[3]=constantStartColorE[3];
				break ;
			case 2:
				if (autoRandomSeed){
					MathUtil.lerpVector4(particleSystem.startColorConstantMin.elements,particleSystem.startColorConstantMax.elements,Math.random(),ShurikenParticleData.startColor);
					}else {
					rand.seed=randomSeeds[3];
					MathUtil.lerpVector4(particleSystem.startColorConstantMin.elements,particleSystem.startColorConstantMax.elements,rand.getFloat(),ShurikenParticleData.startColor);
					randomSeeds[3]=rand.seed;
				}
				break ;
			};
		var colorOverLifetime=particleSystem.colorOverLifetime;
		if (colorOverLifetime && colorOverLifetime.enbale){
			var color=colorOverLifetime.color;
			switch (color.type){
				case 0:
					ShurikenParticleData.startColor[0]=ShurikenParticleData.startColor[0] *color.constant.x;
					ShurikenParticleData.startColor[1]=ShurikenParticleData.startColor[1] *color.constant.y;
					ShurikenParticleData.startColor[2]=ShurikenParticleData.startColor[2] *color.constant.z;
					ShurikenParticleData.startColor[3]=ShurikenParticleData.startColor[3] *color.constant.w;
					break ;
				case 2:;
					var colorRandom=NaN;
					if (autoRandomSeed){
						colorRandom=Math.random();
						}else {
						rand.seed=randomSeeds[10];
						colorRandom=rand.getFloat();
						randomSeeds[10]=rand.seed;
					};
					var minConstantColor=color.constantMin;
					var maxConstantColor=color.constantMax;
					ShurikenParticleData.startColor[0]=ShurikenParticleData.startColor[0] *MathUtil.lerp(minConstantColor.x,maxConstantColor.x,colorRandom);
					ShurikenParticleData.startColor[1]=ShurikenParticleData.startColor[1] *MathUtil.lerp(minConstantColor.y,maxConstantColor.y,colorRandom);
					ShurikenParticleData.startColor[2]=ShurikenParticleData.startColor[2] *MathUtil.lerp(minConstantColor.z,maxConstantColor.z,colorRandom);
					ShurikenParticleData.startColor[3]=ShurikenParticleData.startColor[3] *MathUtil.lerp(minConstantColor.w,maxConstantColor.w,colorRandom);
					break ;
				}
		};
		var particleSize=ShurikenParticleData.startSize;
		switch (particleSystem.startSizeType){
			case 0:
				if (particleSystem.threeDStartSize){
					var startSizeConstantSeparate=particleSystem.startSizeConstantSeparate;
					particleSize[0]=startSizeConstantSeparate.x;
					particleSize[1]=startSizeConstantSeparate.y;
					particleSize[2]=startSizeConstantSeparate.z;
					}else {
					particleSize[0]=particleSize[1]=particleSize[2]=particleSystem.startSizeConstant;
				}
				break ;
			case 2:
				if (particleSystem.threeDStartSize){
					var startSizeConstantMinSeparate=particleSystem.startSizeConstantMinSeparate;
					var startSizeConstantMaxSeparate=particleSystem.startSizeConstantMaxSeparate;
					if (autoRandomSeed){
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,Math.random());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,Math.random());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,rand.getFloat());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,rand.getFloat());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
					}else {
					if (autoRandomSeed){
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
				}
				break ;
			};
		var sizeOverLifetime=particleSystem.sizeOverLifetime;
		if (sizeOverLifetime && sizeOverLifetime.enbale && sizeOverLifetime.size.type===1){
			var size=sizeOverLifetime.size;
			if (size.separateAxes){
				if (autoRandomSeed){
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,Math.random());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,Math.random());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,rand.getFloat());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,rand.getFloat());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				}else {
				var randomSize=NaN;
				if (autoRandomSeed){
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				particleSize[0]=particleSize[0] *randomSize;
				particleSize[1]=particleSize[1] *randomSize;
				particleSize[2]=particleSize[2] *randomSize;
			}
		};
		var renderMode=particleRender.renderMode;
		if (renderMode!==1){
			switch (particleSystem.startRotationType){
				case 0:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantSeparate=particleSystem.startRotationConstantSeparate;
						var randomRotationE=ShurikenParticleData._tempVector30.elements;
						ShurikenParticleData._randomInvertRoationArray(startRotationConstantSeparate.elements,randomRotationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=randomRotationE[0];
						ShurikenParticleData.startRotation[1]=randomRotationE[1];
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-randomRotationE[2];
						else
						ShurikenParticleData.startRotation[2]=randomRotationE[2];
						}else {
						ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(particleSystem.startRotationConstant,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
					}
					break ;
				case 2:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantMinSeparate=particleSystem.startRotationConstantMinSeparate;
						var startRotationConstantMaxSeparate=particleSystem.startRotationConstantMaxSeparate;
						var lerpRoationE=ShurikenParticleData._tempVector30.elements;
						if (autoRandomSeed){
							lerpRoationE[0]=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,Math.random());
							lerpRoationE[1]=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,Math.random());
							lerpRoationE[2]=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,Math.random());
							}else {
							rand.seed=randomSeeds[5];
							lerpRoationE[0]=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,rand.getFloat());
							lerpRoationE[1]=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,rand.getFloat());
							lerpRoationE[2]=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,rand.getFloat());
							randomSeeds[5]=rand.seed;
						}
						ShurikenParticleData._randomInvertRoationArray(lerpRoationE,lerpRoationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=lerpRoationE[0];
						ShurikenParticleData.startRotation[1]=lerpRoationE[1];
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-lerpRoationE[2];
						else
						ShurikenParticleData.startRotation[2]=lerpRoationE[2];
						}else {
						if (autoRandomSeed){
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,Math.random()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							}else {
							rand.seed=randomSeeds[5];
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,rand.getFloat()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							randomSeeds[5]=rand.seed;
						}
					}
					break ;
				}
		}
		switch (particleSystem.startLifetimeType){
			case 0:
				ShurikenParticleData.startLifeTime=particleSystem.startLifetimeConstant;
				break ;
			case 1:
				ShurikenParticleData.startLifeTime=ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradient,particleSystem.emissionTime);
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			case 3:;
				var emissionTime=particleSystem.emissionTime;
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			}
		switch (particleSystem.startSpeedType){
			case 0:
				ShurikenParticleData.startSpeed=particleSystem.startSpeedConstant;
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[8];
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,rand.getFloat());
					randomSeeds[8]=rand.seed;
				}
				break ;
			};
		var textureSheetAnimation=particleSystem.textureSheetAnimation;
		var enableSheetAnimation=textureSheetAnimation && textureSheetAnimation.enable;
		if (enableSheetAnimation){
			var title=textureSheetAnimation.tiles;
			var titleX=title.x,titleY=title.y;
			var subU=1.0 / titleX,subV=1.0 / titleY;
			var startFrameCount=0;
			var startFrame=textureSheetAnimation.startFrame;
			switch (startFrame.type){
				case 0:
					startFrameCount=startFrame.constant;
					break ;
				case 1:
					if (autoRandomSeed){
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[14];
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,rand.getFloat());
						randomSeeds[14]=rand.seed;
					}
					break ;
				};
			var frame=textureSheetAnimation.frame;
			switch (frame.type){
				case 0:
					startFrameCount+=frame.constant;
					break ;
				case 2:
					if (autoRandomSeed){
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[15];
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,rand.getFloat());
						randomSeeds[15]=rand.seed;
					}
					break ;
				};
			var startRow=0;
			switch (textureSheetAnimation.type){
				case 0:
					startRow=Math.floor(startFrameCount / titleX);
					break ;
				case 1:
					if (textureSheetAnimation.randomRow){
						if (autoRandomSeed){
							startRow=Math.floor(Math.random()*titleY);
							}else {
							rand.seed=randomSeeds[13];
							startRow=Math.floor(rand.getFloat()*titleY);
							randomSeeds[13]=rand.seed;
						}
						}else {
						startRow=textureSheetAnimation.rowIndex;
					}
					break ;
				};
			var startCol=Math.floor(startFrameCount % titleX);
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=subU;
			ShurikenParticleData.startUVInfo[1]=subV;
			ShurikenParticleData.startUVInfo[2]=startCol *subU;
			ShurikenParticleData.startUVInfo[3]=startRow *subV;
			}else {
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=1.0;
			ShurikenParticleData.startUVInfo[1]=1.0;
			ShurikenParticleData.startUVInfo[2]=0.0;
			ShurikenParticleData.startUVInfo[3]=0.0;
		}
		switch (particleSystem.simulationSpace){
			case 0:;
				var positionE=transform.position.elements;
				ShurikenParticleData.simulationWorldPostion[0]=positionE[0];
				ShurikenParticleData.simulationWorldPostion[1]=positionE[1];
				ShurikenParticleData.simulationWorldPostion[2]=positionE[2];
				var rotationE=transform.rotation.elements;
				ShurikenParticleData.simulationWorldRotation[0]=rotationE[0];
				ShurikenParticleData.simulationWorldRotation[1]=rotationE[1];
				ShurikenParticleData.simulationWorldRotation[2]=rotationE[2];
				ShurikenParticleData.simulationWorldRotation[3]=rotationE[3];
				break ;
			case 1:
				break ;
			default :
				throw new Error("ShurikenParticleMaterial: SimulationSpace value is invalid.");
				break ;
			}
	}

	ShurikenParticleData.startLifeTime=NaN;
	ShurikenParticleData.startSpeed=NaN;
	__static(ShurikenParticleData,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'startColor',function(){return this.startColor=new Float32Array(4);},'startSize',function(){return this.startSize=new Float32Array(3);},'startRotation',function(){return this.startRotation=new Float32Array(3);},'startUVInfo',function(){return this.startUVInfo=new Float32Array(4);},'simulationWorldPostion',function(){return this.simulationWorldPostion=new Float32Array(3);},'simulationWorldRotation',function(){return this.simulationWorldRotation=new Float32Array(4);}
	]);
	return ShurikenParticleData;
})()


/**
*@private
*<code>PhasorSpriter3D</code> 类用于创建矢量笔刷。
*/
//class laya.d3.core.PhasorSpriter3D
var PhasorSpriter3D=(function(){
	function PhasorSpriter3D(){
		this._tempInt0=0;
		this._tempInt1=0;
		this._tempUint0=0;
		this._tempUint1=0;
		this._tempUint2=0;
		this._tempUint3=0;
		this._tempUint4=0;
		this._tempUint5=0;
		this._tempUint6=0;
		this._tempUint7=0;
		this._tempNumver0=NaN;
		this._tempNumver1=NaN;
		this._tempNumver2=NaN;
		this._tempNumver3=NaN;
		this._floatSizePerVer=7;
		//顶点结构为Position(3个float)+Color(4个float)
		this._defaultBufferSize=600 *this._floatSizePerVer;
		this._vb=null;
		this._posInVBData=0;
		this._ib=null;
		this._posInIBData=0;
		this._primitiveType=NaN;
		this._hasBegun=false;
		this._numVertsPerPrimitive=0;
		this._camera=null;
		this._sharderNameID=0;
		this._shader=null;
		/**@private */
		this._shaderCompile=null;
		this._vbData=new Float32Array(this._defaultBufferSize);
		this._ibData=new Uint16Array(this._defaultBufferSize);
		this._spriteShaderValue=new ValusArray();
		;
		this._vb=VertexBuffer3D.create(PhasorSpriter3D._vertexDeclaration,this._defaultBufferSize / this._floatSizePerVer,0x88E8);
		this._ib=IndexBuffer3D.create("ushort",this._defaultBufferSize,0x88E8);
		this._sharderNameID=Shader3D.nameKey.getID("LINE");
		this._shaderCompile=ShaderCompile3D._preCompileShader[this._sharderNameID];
	}

	__class(PhasorSpriter3D,'laya.d3.core.PhasorSpriter3D');
	var __proto=PhasorSpriter3D.prototype;
	__proto.line=function(startPosition,startColor,endPosition,endColor){
		if (!this._hasBegun || this._primitiveType!==0x0001)
			this.drawLinesException();
		if (this._posInVBData+2 *this._floatSizePerVer > this._vbData.length || this._posInIBData+2 > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(startPosition.x,startPosition.y,startPosition.z,startColor.x,startColor.y,startColor.z,startColor.w);
		this.addVertex(endPosition.x,endPosition.y,endPosition.z,endColor.x,endColor.y,endColor.z,endColor.w);
		this.addIndexes(this._tempUint0,this._tempUint0+1);
		return this;
	}

	__proto.circle=function(radius,numberOfPoints,r,g,b,a){
		if (!this._hasBegun || (this._primitiveType!==0x0001))
			this.drawLinesException();
		this._tempUint0=numberOfPoints *2;
		if (this._posInVBData+this._tempUint0 *this._floatSizePerVer > this._vbData.length || this._posInIBData+2 *this._tempUint0 > this._ibData.length)
			this.flush();
		this._tempUint1=this._posInVBData / this._floatSizePerVer;
		for (this._tempNumver0=0,this._tempInt0=0;this._tempNumver0 < 3.1416 *2;this._tempNumver0=this._tempNumver0+(3.1416 / numberOfPoints),this._tempInt0++){
			this.addVertex(Math.sin(this._tempNumver0)*radius,Math.cos(this._tempNumver0)*radius,0,r,g,b,a);
			if (this._tempInt0===0){
				this.addIndexes(this._tempUint1);
				}else if (this._tempInt0===this._tempUint0-1){
				this._tempUint2=this._tempUint1+this._tempInt0;
				this.addIndexes(this._tempUint2,this._tempUint2,this._tempUint1);
				}else {
				this._tempUint2=this._tempUint1+this._tempInt0;
				this.addIndexes(this._tempUint2,this._tempUint2);
			}
		}
		return this;
	}

	__proto.plane=function(positionX,positionY,positionZ,width,height,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+4 *this._floatSizePerVer > this._vbData.length || this._posInIBData+6 > this._ibData.length)
			this.flush();
		this._tempNumver0=width / 2;
		this._tempNumver1=height / 2;
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint2,this._tempUint2,this._tempUint1,this._tempUint0+3);
		return this;
	}

	__proto.box=function(positionX,positionY,positionZ,width,height,depth,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+8 *this._floatSizePerVer > this._vbData.length || this._posInIBData+36 > this._ibData.length)
			this.flush();
		this._tempNumver0=width / 2;
		this._tempNumver1=height / 2;
		this._tempNumver2=depth / 2;
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ+this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY+this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY+this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX+this._tempNumver0,positionY-this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this.addVertex(positionX-this._tempNumver0,positionY-this._tempNumver1,positionZ-this._tempNumver2,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this._tempUint3=this._tempUint0+3;
		this._tempUint4=this._tempUint0+4;
		this._tempUint5=this._tempUint0+5;
		this._tempUint6=this._tempUint0+6;
		this._tempUint7=this._tempUint0+7;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint2,this._tempUint2,this._tempUint1,this._tempUint3,
		this._tempUint4,this._tempUint5,this._tempUint6,this._tempUint6,this._tempUint5,this._tempUint7,
		this._tempUint5,this._tempUint0,this._tempUint7,this._tempUint7,this._tempUint0,this._tempUint2,
		this._tempUint1,this._tempUint4,this._tempUint3,this._tempUint3,this._tempUint4,this._tempUint6,
		this._tempUint5,this._tempUint4,this._tempUint0,this._tempUint0,this._tempUint4,this._tempUint1,
		this._tempUint2,this._tempUint3,this._tempUint7,this._tempUint7,this._tempUint3,this._tempUint6);
		return this;
	}

	__proto.cone=function(radius,length,Slices,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==0x0004)
			this.drawTrianglesException();
		if (this._posInVBData+(2 *Slices+2)*this._floatSizePerVer > this._vbData.length || this._posInIBData+6 *Slices > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData;
		this._tempUint1=this._posInVBData / this._floatSizePerVer;
		this._tempNumver0=Math.PI *2 / Slices;
		this.addVertexIndex(0,length,0,r,g,b,a,this._tempUint0);
		this.addVertexIndex(0,0,0,r,g,b,a,this._tempUint0+this._floatSizePerVer);
		this._tempInt0=2;
		this._tempNumver1=0;
		for (this._tempInt1=0;this._tempInt1 < Slices;this._tempInt1++){
			this._tempNumver2=Math.cos(this._tempNumver1);
			this._tempNumver3=Math.sin(this._tempNumver1);
			this.addVertexIndex(radius *this._tempNumver2,0,radius *this._tempNumver3,r,g,b,a,this._tempUint0+this._tempInt0 *this._floatSizePerVer);
			this.addIndexes(this._tempUint1,this._tempUint1+this._tempInt0);
			if (this._tempInt1==Slices-1)
				this.addIndexes(this._tempUint1+2);
			else
			this.addIndexes(this._tempUint1+this._tempInt0+1);
			this.addVertexIndex(radius *this._tempNumver2,0,radius *this._tempNumver3,r,g,b,a,this._tempUint0+(this._tempInt0+Slices)*this._floatSizePerVer);
			this.addIndexes(this._tempUint1+1);
			if (this._tempInt1==Slices-1)
				this.addIndexes(this._tempUint1+Slices+2);
			else
			this.addIndexes(this._tempUint1+this._tempInt0+Slices+1);
			this.addIndexes(this._tempUint1+this._tempInt0+Slices);
			this._tempInt0++;
			this._tempNumver1+=this._tempNumver0;
		}
		return this;
	}

	__proto.boundingBoxLine=function(minX,minY,minZ,maxX,maxY,maxZ,r,g,b,a){
		if (!this._hasBegun || this._primitiveType!==0x0001)
			this.drawLinesException();
		if (this._posInVBData+8 *this._floatSizePerVer > this._vbData.length || this._posInIBData+48 > this._ibData.length)
			this.flush();
		this._tempUint0=this._posInVBData / this._floatSizePerVer;
		this.addVertex(minX,maxY,maxZ,r,g,b,a);
		this.addVertex(maxX,maxY,maxZ,r,g,b,a);
		this.addVertex(minX,minY,maxZ,r,g,b,a);
		this.addVertex(maxX,minY,maxZ,r,g,b,a);
		this.addVertex(maxX,maxY,minZ,r,g,b,a);
		this.addVertex(minX,maxY,minZ,r,g,b,a);
		this.addVertex(maxX,minY,minZ,r,g,b,a);
		this.addVertex(minX,minY,minZ,r,g,b,a);
		this._tempUint1=this._tempUint0+1;
		this._tempUint2=this._tempUint0+2;
		this._tempUint3=this._tempUint0+3;
		this._tempUint4=this._tempUint0+4;
		this._tempUint5=this._tempUint0+5;
		this._tempUint6=this._tempUint0+6;
		this._tempUint7=this._tempUint0+7;
		this.addIndexes(this._tempUint0,this._tempUint1,this._tempUint1,this._tempUint3,this._tempUint3,this._tempUint2,this._tempUint2,this._tempUint0,
		this._tempUint4,this._tempUint5,this._tempUint5,this._tempUint7,this._tempUint7,this._tempUint6,this._tempUint6,this._tempUint4,
		this._tempUint5,this._tempUint0,this._tempUint0,this._tempUint2,this._tempUint2,this._tempUint7,this._tempUint7,this._tempUint5,
		this._tempUint1,this._tempUint4,this._tempUint4,this._tempUint6,this._tempUint6,this._tempUint3,this._tempUint3,this._tempUint1,
		this._tempUint5,this._tempUint4,this._tempUint4,this._tempUint1,this._tempUint1,this._tempUint0,this._tempUint0,this._tempUint5,
		this._tempUint2,this._tempUint3,this._tempUint3,this._tempUint6,this._tempUint6,this._tempUint7,this._tempUint7,this._tempUint2);
		return this;
	}

	__proto.addVertex=function(x,y,z,r,g,b,a){
		if (!this._hasBegun)
			this.addVertexIndexException();
		this._vbData[this._posInVBData]=x,this._vbData[this._posInVBData+1]=y,this._vbData[this._posInVBData+2]=z;
		this._vbData[this._posInVBData+3]=r,this._vbData[this._posInVBData+4]=g,this._vbData[this._posInVBData+5]=b,this._vbData[this._posInVBData+6]=a;
		this._posInVBData+=this._floatSizePerVer;
		return this;
	}

	__proto.addVertexIndex=function(x,y,z,r,g,b,a,index){
		if (!this._hasBegun)
			this.addVertexIndexException();
		this._vbData[index]=x,this._vbData[index+1]=y,this._vbData[index+2]=z;
		this._vbData[index+3]=r,this._vbData[index+4]=g,this._vbData[index+5]=b,this._vbData[index+6]=a;
		index+=this._floatSizePerVer;
		if (index > this._posInVBData)
			this._posInVBData=index;
		return this;
	}

	__proto.addIndexes=function(__indexes){
		var indexes=arguments;
		if (!this._hasBegun)
			this.addVertexIndexException();
		for (var i=0;i < indexes.length;i++){
			this._ibData[this._posInIBData]=indexes[i];
			this._posInIBData++;
		}
		return this;
	}

	__proto.begin=function(primitive,camera){
		if (this._hasBegun)
			this.beginException0();
		if (primitive!==0x0001 && primitive!==0x0004)
			this.beginException1();
		this._primitiveType=primitive;
		this._camera=camera;
		this._hasBegun=true;
		return this;
	}

	__proto.end=function(){
		if (!this._hasBegun)
			this.endException();
		this.flush();
		this._hasBegun=false;
		return this;
	}

	__proto.flush=function(){
		if (this._posInVBData===0)
			return;
		this._ib.setData(this._ibData);
		this._vb.setData(this._vbData);
		this._vb._bind();
		this._ib._bind();
		this._shader=this._shaderCompile.withCompile(0,0,0);
		this._shader.bind();
		this._shader.uploadAttributes(PhasorSpriter3D._vertexDeclaration.shaderValues.data,null);
		this._spriteShaderValue.setValue(1,(this._camera).projectionViewMatrix.elements);
		this._shader.uploadSpriteUniforms(this._spriteShaderValue.data);
		Stat.drawCall++;
		WebGL.mainContext.drawElements(this._primitiveType,this._posInIBData,0x1403,0);
		this._posInIBData=0;
		this._posInVBData=0;
	}

	__proto.addVertexIndexException=function(){
		throw new Error("请先调用begin()函数");
	}

	__proto.beginException0=function(){
		throw new Error("调用begin()前请确保已成功调用end()！");
	}

	__proto.beginException1=function(){
		throw new Error("只支持“LINES”和“TRIANGLES”两种基元！");
	}

	__proto.endException=function(){
		throw new Error("调用end()前请确保已成功调用begin()！");
	}

	__proto.drawLinesException=function(){
		throw new Error("您必须确保在此之前已调用begin()且使用“LINES”基元！");
	}

	__proto.drawTrianglesException=function(){
		throw new Error("您必须确保在此之前已调用begin()且使用“TRIANGLES”基元！");
	}

	__static(PhasorSpriter3D,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(28,[new VertexElement(0,"vector3",0),new VertexElement(12,"vector4",1)]);}
	]);
	return PhasorSpriter3D;
})()


/**
*@private
*<code>RenderElement</code> 类用于实现渲染物体。
*/
//class laya.d3.core.render.RenderElement
var RenderElement=(function(){
	function RenderElement(){
		/**@private */
		this._id=0;
		/**@private 类型0为默认，2为DynamicBatch。*/
		this._type=0;
		/**@private 排序ID。*/
		this._mainSortID=0;
		/**@private */
		this._render=null;
		/**@private 所属Sprite3D精灵。*/
		this._sprite3D=null;
		/**@private 渲染所用材质。*/
		this._material=null;
		/**@private 渲染元素。*/
		this._renderObj=null;
		/**@private */
		this._staticBatch=null;
		//...............临时...........................
		this._tempBatchIndexStart=0;
		//TODO:
		this._tempBatchIndexEnd=0;
		/**@private */
		this._canDynamicBatch=false;
		/**当前ShaderValue。*/
		this._shaderValue=null;
		this._onPreRenderFunction=null;
		/**@private */
		this._conchSubmesh=null;
		this._id=++RenderElement._uniqueIDCounter;
		this._canDynamicBatch=true;
		this._shaderValue=new ValusArray();
		if (Render.isConchNode){
			this._conchSubmesh=new ConchSubmesh();
		}
	}

	__class(RenderElement,'laya.d3.core.render.RenderElement');
	var __proto=RenderElement.prototype;
	/**
	*@private
	*/
	__proto.getDynamicBatchBakedVertexs=function(index){
		var byteSizeInFloat=4;
		var vb=this._renderObj._getVertexBuffer(index);
		var bakedVertexes=vb.getData().slice();
		var vertexDeclaration=vb.vertexDeclaration;
		var positionOffset=vertexDeclaration.getVertexElementByUsage(0).offset / byteSizeInFloat;
		var normalOffset=vertexDeclaration.getVertexElementByUsage(3).offset / byteSizeInFloat;
		var transform=this._sprite3D.transform;
		var worldMatrix=transform.worldMatrix;
		var rotation=transform.rotation;
		var vertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
		for (var i=0,n=bakedVertexes.length;i < n;i+=vertexFloatCount){
			var posOffset=i+positionOffset;
			var norOffset=i+normalOffset;
			Utils3D.transformVector3ArrayToVector3ArrayCoordinate(bakedVertexes,posOffset,worldMatrix,bakedVertexes,posOffset);
			Utils3D.transformVector3ArrayByQuat(bakedVertexes,norOffset,rotation,bakedVertexes,norOffset);
		}
		return bakedVertexes;
	}

	/**
	*@private
	*/
	__proto.getBakedIndices=function(){
		return this._renderObj._getIndexBuffer().getData();
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		(this._staticBatch)&& (this._staticBatch._manager._garbageCollection(this));
	}

	/**
	*获取唯一标识ID,通常用于识别。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	__getset(0,__proto,'renderObj',function(){
		return this._renderObj;
		},function(value){
		if (this._renderObj!==value){
			this._renderObj=value;
		}
	});

	RenderElement._uniqueIDCounter=0;
	return RenderElement;
})()


/**
*@private
*<code>RenderQuene</code> 类用于实现渲染队列。
*/
//class laya.d3.core.render.RenderQueue
var RenderQueue=(function(){
	function RenderQueue(scene){
		/**@private */
		this._id=0;
		/**@private */
		this._needSort=false;
		/**@private */
		this._renderElements=null;
		/**@private */
		this._renderableRenderObjects=null;
		/**@private */
		this._dynamicBatchCombineRenderElements=null;
		/**@private */
		this._finalElements=null;
		/**@private */
		this._scene=null;
		this._id=++RenderQueue._uniqueIDCounter;
		this._needSort=false;
		this._scene=scene;
		this._renderElements=[];
		this._renderableRenderObjects=[];
		this._dynamicBatchCombineRenderElements=[];
	}

	__class(RenderQueue,'laya.d3.core.render.RenderQueue');
	var __proto=RenderQueue.prototype;
	__proto._sortOpaqueFunc=function(a,b){
		if (a._render && b._render)
			return a._render._distanceForSort-b._render._distanceForSort;
		else
		return 0;
	}

	__proto._sortAlphaFunc=function(a,b){
		if (a._render && b._render)
			return b._render._distanceForSort-a._render._distanceForSort;
		else
		return 0;
	}

	/**
	*@private
	*/
	__proto._begainRenderElement=function(state,renderObj,material){
		if (renderObj._beforeRender(state)){
			return true;
		}
		return false;
	}

	/**
	*@private
	*/
	__proto._sortAlpha=function(cameraPos){
		RenderQueue._cameraPosition=cameraPos;
		this._finalElements.sort(this._sortAlphaFunc);
	}

	/**
	*@private
	*/
	__proto._sortOpaque=function(cameraPos){
		RenderQueue._cameraPosition=cameraPos;
		this._finalElements.sort(this._sortOpaqueFunc);
	}

	/**
	*@private
	*准备渲染队列。
	*@param state 渲染状态。
	*/
	__proto._preRender=function(state){
		this._finalElements=this._renderElements.concat(this._dynamicBatchCombineRenderElements);
	}

	/**
	*@private
	*渲染队列。
	*@param state 渲染状态。
	*/
	__proto._render=function(state,isTarget){
		var loopCount=Stat.loopCount;
		var scene=this._scene;
		var camera=state.camera;
		var cameraID=camera.id;
		var vbs;
		var vertexBuffer,vertexDeclaration,shader;
		var forceUploadParams=false;
		var lastStateMaterial,lastStateOwner;
		for (var i=0,n=this._finalElements.length;i < n;i++){
			var renderElement=this._finalElements[i];
			var renderObj,material,owner;
			if (renderElement._onPreRenderFunction !=null){
				renderElement._onPreRenderFunction.call(renderElement._sprite3D,state);
			}
			if (renderElement._type===0){
				state.owner=owner=renderElement._sprite3D;
				state.renderElement=renderElement;
				owner._preRenderUpdateComponents(state);
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,material)){
					vbs=renderObj._getVertexBuffers();
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (vbs){
						if (shader._uploadVertexBuffer!==vbs || forceUploadParams){
							for (var j=0;j < vbs.length;j++){
								var vb=vbs[j];
								shader.uploadAttributesX(vb.vertexDeclaration.shaderValues.data,vb);
							}
							shader._uploadVertexBuffer=vbs;
						}
						}else {
						if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
							shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
							shader._uploadVertexBuffer=vertexBuffer;
						}
					}
					if (shader._uploadScene!==scene || forceUploadParams){
						shader.uploadSceneUniforms(scene._shaderValues.data);
						shader._uploadScene=scene;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (lastStateMaterial!==material){
						material._setRenderStateBlendDepth();
						material._setRenderStateFrontFace(isTarget,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(isTarget,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
				owner._postRenderUpdateComponents(state);
				}else if (renderElement._type===2){
				var dynamicBatch=renderElement.renderObj;
				state.owner=owner=renderElement._sprite3D;
				state.renderElement=renderElement;
				state._batchIndexStart=renderElement._tempBatchIndexStart;
				state._batchIndexEnd=renderElement._tempBatchIndexEnd;
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,material)){
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
						shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
						shader._uploadVertexBuffer=vertexBuffer;
					}
					if (shader._uploadScene!==scene || forceUploadParams){
						shader.uploadSceneUniforms(scene._shaderValues.data);
						shader._uploadScene=scene;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (lastStateMaterial!==material){
						material._setRenderStateBlendDepth();
						material._setRenderStateFrontFace(isTarget,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(isTarget,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
			}
		}
	}

	/**
	*@private
	*渲染队列。
	*@param state 渲染状态。
	*/
	__proto._renderShadow=function(state,isOnePSSM){
		var loopCount=Stat.loopCount;
		var scene=this._scene;
		var camera=state.camera;
		var vertexBuffer,vertexDeclaration,shader;
		var forceUploadParams=false;
		var lastStateMaterial,lastStateOwner;
		for (var i=0,n=this._finalElements.length;i < n;i++){
			var renderElement=this._finalElements[i];
			var renderObj,material,owner;
			if (renderElement._type===0){
				state.owner=owner=renderElement._sprite3D;
				if (!isOnePSSM && (owner._projectionViewWorldUpdateCamera!==camera || owner._projectionViewWorldUpdateLoopCount!==Stat.loopCount)){
					owner._render._renderUpdate(state._projectionViewMatrix);
					owner._projectionViewWorldUpdateLoopCount=Stat.loopCount;
					owner._projectionViewWorldUpdateCamera=camera;
				}
				state.renderElement=renderElement;
				owner._preRenderUpdateComponents(state);
				renderObj=renderElement.renderObj,material=renderElement._material;
				if (this._begainRenderElement(state,renderObj,null)){
					vertexBuffer=renderObj._getVertexBuffer(0);
					vertexDeclaration=vertexBuffer.vertexDeclaration;
					shader=state._shader=material._getShader(scene._shaderDefineValue,vertexDeclaration.shaderDefineValue,owner._shaderDefineValue);
					forceUploadParams=shader.bind()|| (loopCount!==shader._uploadLoopCount);
					if (shader._uploadVertexBuffer!==vertexBuffer || forceUploadParams){
						shader.uploadAttributes(vertexDeclaration.shaderValues.data,null);
						shader._uploadVertexBuffer=vertexBuffer;
					}
					if (camera!==shader._uploadCamera || shader._uploadSprite3D!==owner || forceUploadParams){
						shader.uploadSpriteUniforms(owner._shaderValues.data);
						shader._uploadSprite3D=owner;
					}
					if (camera!==shader._uploadCamera || forceUploadParams){
						shader.uploadCameraUniforms(camera._shaderValues.data);
						shader._uploadCamera=camera;
					}
					if (shader._uploadMaterial!==material || forceUploadParams){
						material._upload();
						shader._uploadMaterial=material;
					}
					if (shader._uploadRenderElement!==renderElement || forceUploadParams){}
						if (lastStateMaterial!==material){
						material._setRenderStateFrontFace(false,owner.transform);
						lastStateMaterial=material;
						lastStateOwner=owner;
						}else {
						if (lastStateOwner!==owner){
							material._setRenderStateFrontFace(false,owner.transform);
							lastStateOwner=owner;
						}
					}
					renderObj._render(state);
					shader._uploadLoopCount=loopCount;
				}
				owner._postRenderUpdateComponents(state);
			}
		}
	}

	/**
	*清空队列中的渲染物体。
	*/
	__proto._clearRenderElements=function(){
		this._dynamicBatchCombineRenderElements.length=0;
		this._renderElements.length=0;
		this._needSort=true;
	}

	/**
	*添加渲染物体。
	*@param renderObj 渲染物体。
	*/
	__proto._addRenderElement=function(renderElement){
		this._renderElements.push(renderElement);
		this._needSort=true;
	}

	/**
	*添加动态批处理。
	*@param renderObj 动态批处理。
	*/
	__proto._addDynamicBatchElement=function(dynamicBatchElement){
		this._dynamicBatchCombineRenderElements.push(dynamicBatchElement);
	}

	/**
	*获取唯一标识ID(通常用于优化或识别)。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	RenderQueue._uniqueIDCounter=0;
	RenderQueue.OPAQUE=1;
	RenderQueue.TRANSPARENT=2;
	RenderQueue._cameraPosition=null;
	return RenderQueue;
})()


/**
*<code>RenderState</code> 类用于实现渲染状态。
*/
//class laya.d3.core.render.RenderState
var RenderState=(function(){
	function RenderState(){
		/**@private */
		this._staticBatch=null;
		/**@private */
		this._batchIndexStart=0;
		/**@private */
		this._batchIndexEnd=0;
		/**@private */
		this._viewMatrix=null;
		/**@private */
		this._projectionMatrix=null;
		/**@private */
		this._projectionViewMatrix=null;
		/**@private */
		this._viewport=null;
		/**@private */
		this._shader=null;
		/**距上一帧间隔时间。*/
		this.elapsedTime=NaN;
		/**当前场景。*/
		this.scene=null;
		/**当前渲染3D精灵。*/
		this.owner=null;
		/**当前渲染物体。*/
		this.renderElement=null;
		/**当前摄像机。*/
		this.camera=null;
	}

	__class(RenderState,'laya.d3.core.render.RenderState');
	RenderState.clientWidth=0;
	RenderState.clientHeight=0;
	return RenderState;
})()


//class laya.d3.core.scene.OctreeNode
var OctreeNode=(function(){
	function OctreeNode(scene,currentDepth){
		this._exactBox=null;
		this._relaxBox=null;
		this._scene=null;
		this._parent=null;
		this._currentDepth=0;
		this._boundingSphere=new BoundSphere(new Vector3(),0);
		this._corners=[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];
		this._boundingBoxCenter=new Vector3();
		this._children=__newvec(8);
		this._objects=[];
		this._tempBoundBoxCorners=[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];
		this._scene=scene;
		this._currentDepth=currentDepth;
	}

	__class(OctreeNode,'laya.d3.core.scene.OctreeNode');
	var __proto=OctreeNode.prototype;
	Laya.imps(__proto,{"laya.d3.core.scene.ITreeNode":true})
	__proto.init=function(center,treeSize){
		var min=new Vector3();
		var max=new Vector3();
		Vector3.scale(treeSize,-0.5,min);
		Vector3.scale(treeSize,0.5,max);
		Vector3.add(min,center,min);
		Vector3.add(max,center,max);
		this.exactBox=new BoundBox(min,max);
		this.relaxBox=new BoundBox(min,max);
	}

	__proto.addTreeNode=function(render){
		if (Collision.boxContainsBox(this._relaxBox,render.boundingBox)===1)
			this.addNodeDown(render,0);
		else
		this.addObject(render);
	}

	__proto.addChild=function(index){
		var child=this._children[index];
		if (child==null){
			child=new OctreeNode(this._scene,this._currentDepth+1);
			this._children[index]=child;
			child._parent=this;
			Vector3.subtract(this._exactBox.max,this._exactBox.min,OctreeNode.tempSize);
			Vector3.multiply(OctreeNode.tempSize,OctreeNode._octreeSplit[index],OctreeNode.tempCenter);
			Vector3.add(this._exactBox.min,OctreeNode.tempCenter,OctreeNode.tempCenter);
			Vector3.scale(OctreeNode.tempSize,0.25,OctreeNode.tempSize);
			var min=new Vector3();
			var max=new Vector3();
			Vector3.subtract(OctreeNode.tempCenter,OctreeNode.tempSize,min);
			Vector3.add(OctreeNode.tempCenter,OctreeNode.tempSize,max);
			child.exactBox=new BoundBox(min,max);
			Vector3.scale(OctreeNode.tempSize,OctreeNode.relax,OctreeNode.tempSize);
			var relaxMin=new Vector3();
			var relaxMax=new Vector3();
			Vector3.subtract(OctreeNode.tempCenter,OctreeNode.tempSize,relaxMin);
			Vector3.add(OctreeNode.tempCenter,OctreeNode.tempSize,relaxMax);
			child.relaxBox=new BoundBox(relaxMin,relaxMax);
		}
		return child;
	}

	__proto.addObject=function(object){
		object._treeNode=this;
		this._objects.push(object);
	}

	__proto.removeObject=function(object){
		if (object._treeNode !=this){
			console.log("OctreeNode::removeObject error");
			return false;
		};
		var index=this._objects.indexOf(object);
		if (index!==-1){
			this._objects.splice(index,1);
			return true;
		}
		return false;
	}

	__proto.clearObject=function(){
		this._objects.length=0;
	}

	__proto.addNodeUp=function(render,depth){
		if (this._parent && (Collision.boxContainsBox(this._exactBox,render.boundingBox)!==1)){
			this._parent.addNodeUp(render,depth-1);
		}else
		this.addNodeDown(render,depth);
	}

	__proto.addNodeDown=function(render,depth){
		if (depth < this._scene.treeLevel){
			var childIndex=this.inChildIndex(render.boundingBoxCenter);
			var child=this.addChild(childIndex);
			if (Collision.boxContainsBox(child._relaxBox,render.boundingBox)===1){
				child.addNodeDown(render,++depth);
			}else
			this.addObject(render);
			}else {
			this.addObject(render);
		}
	}

	__proto.inChildIndex=function(objectCenter){
		var z=objectCenter.z < this._boundingBoxCenter.z ? 0 :1;
		var y=objectCenter.y < this._boundingBoxCenter.y ? 0 :1;
		var x=objectCenter.x < this._boundingBoxCenter.x ? 0 :1;
		return z *4+y *2+x;
	}

	__proto.updateObject=function(render){
		if (Collision.boxContainsBox(this._relaxBox,render.boundingBox)===1){
			this.removeObject(render);
			render._treeNode=null;
			this.addNodeDown(render,this._currentDepth);
			}else if (this._parent){
			this.removeObject(render);
			render._treeNode=null;
			this._parent.addNodeUp(render,this._currentDepth-1);
		}
	}

	__proto.cullingObjects=function(boundFrustum,testVisible,flags,cameraPosition,projectionView){
		var i=0,j=0,n=0,m=0;
		var dynamicBatchManager=this._scene._dynamicBatchManager;
		for (i=0,n=this._objects.length;i < n;i++){
			var render=this._objects[i];
			if (Layer.isVisible(render._owner.layer.mask)&& render.enable){
				if (testVisible){
					Stat.treeSpriteCollision+=1;
					if (boundFrustum.containsBoundSphere(render.boundingSphere)===0)
						continue ;
				}
				render._renderUpdate(projectionView);
				render._distanceForSort=Vector3.distance(render.boundingSphere.center,cameraPosition)+render.sortingFudge;
				var renderElements=render._renderElements;
				for (j=0,m=renderElements.length;j < m;j++){
					var renderElement=renderElements[j];
					var staticBatch=renderElement._staticBatch;
					if (staticBatch && (staticBatch._material===renderElement._material)){
						staticBatch._addBatchRenderElement(renderElement);
						}else {
						var renderObj=renderElement.renderObj;
						if ((renderObj.triangleCount < 10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!render._owner.isStatic))
							dynamicBatchManager._addPrepareRenderElement(renderElement);
						else
						this._scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
					}
				}
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=boundFrustum.containsBoundBox(child._relaxBox);
				Stat.treeNodeCollision+=1;
				if (type===0)
					continue ;
				testVisibleChild=(type===2);
			}
			child.cullingObjects(boundFrustum,testVisibleChild,flags,cameraPosition,projectionView);
		}
	}

	/**
	*@private
	*/
	__proto.cullingShadowObjects=function(lightBoundFrustum,splitShadowQueues,testVisible,flags,scene){
		var i=0,j=0,n=0,m=0;
		var dynamicBatchManager=this._scene._dynamicBatchManager;
		for (i=0,n=this._objects.length;i < n;i++){
			var baseRender=this._objects[i];
			if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				if (testVisible && lightBoundFrustum[0].containsBoundSphere(baseRender.boundingSphere)===0)
					continue ;
				for (var k=1,kNum=lightBoundFrustum.length;k < kNum;k++){
					var shadowQueue=splitShadowQueues[k-1];
					if (lightBoundFrustum[k].containsBoundSphere(baseRender.boundingSphere)!==0){
						var renderElements=baseRender._renderElements;
						for (j=0,m=renderElements.length;j < m;j++)
						shadowQueue._addRenderElement(renderElements[j]);
					}
				}
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=lightBoundFrustum[0].containsBoundBox(child._relaxBox);
				if (type===0)
					continue ;
				testVisibleChild=(type===2);
			}
			child.cullingShadowObjects(lightBoundFrustum,splitShadowQueues,testVisibleChild,flags,scene);
		}
	}

	/**
	*@private
	*/
	__proto.cullingShadowObjectsOnePSSM=function(lightBoundFrustum,splitShadowQueues,lightViewProjectMatrix,testVisible,flags,scene){
		var shadowQueue=splitShadowQueues[0];
		var i=0,j=0,n=0,m=0;
		for (i=0,n=this._objects.length;i < n;i++){
			var baseRender=this._objects[i];
			if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				if (testVisible && lightBoundFrustum.containsBoundSphere(baseRender.boundingSphere)===0)
					continue ;
				baseRender._renderUpdate(lightViewProjectMatrix);
				var renderElements=baseRender._renderElements;
				for (j=0,m=renderElements.length;j < m;j++)
				shadowQueue._addRenderElement(renderElements[j]);
			}
		}
		for (i=0;i < 8;i++){
			var child=this._children[i];
			if (child==null)
				continue ;
			var testVisibleChild=testVisible;
			if (testVisible){
				var type=lightBoundFrustum.containsBoundBox(child._relaxBox);
				if (type===0)
					continue ;
				testVisibleChild=(type===2);
			}
			child.cullingShadowObjectsOnePSSM(lightBoundFrustum,splitShadowQueues,lightViewProjectMatrix,testVisibleChild,flags,scene);
		}
	}

	__proto.renderBoudingBox=function(linePhasor){
		this._renderBoudingBox(linePhasor);
		for (var i=0;i < 8;++i){
			var pChild=this._children[i];
			if (pChild){
				pChild.renderBoudingBox(linePhasor);
			}
		}
	}

	__proto.buildAllChild=function(depth){
		if (depth < this._scene.treeLevel){
			for (var i=0;i < 8;i++){
				var child=this.addChild(i);
				child.buildAllChild(depth+1);
			}
		}
	}

	__proto._renderBoudingBox=function(linePhasor){}
	__getset(0,__proto,'exactBox',function(){
		return this._exactBox;
		},function(value){
		this._exactBox=value;
		Vector3.add(value.min,value.max,this._boundingBoxCenter);
		Vector3.scale(this._boundingBoxCenter,0.5,this._boundingBoxCenter);
	});

	__getset(0,__proto,'relaxBox',function(){
		return this._relaxBox;
		},function(value){
		this._relaxBox=value;
		value.getCorners(this._corners);
		BoundSphere.createfromPoints(this._corners,this._boundingSphere);
	});

	OctreeNode.debugMode=false;
	OctreeNode.relax=1.15;
	OctreeNode.CHILDNUM=8;
	__static(OctreeNode,
	['tempVector0',function(){return this.tempVector0=new Vector3();},'tempSize',function(){return this.tempSize=new Vector3();},'tempCenter',function(){return this.tempCenter=new Vector3();},'_octreeSplit',function(){return this._octreeSplit=[new Vector3(0.250,0.250,0.250),new Vector3(0.750,0.250,0.250),new Vector3(0.250,0.750,0.250),new Vector3(0.750,0.750,0.250),new Vector3(0.250,0.250,0.750),new Vector3(0.750,0.250,0.750),new Vector3(0.250,0.750,0.750),new Vector3(0.750,0.750,0.750)];}
	]);
	return OctreeNode;
})()


/**
*@private
*<code>DynamicBatch</code> 类用于动态批处理。
*/
//class laya.d3.graphics.DynamicBatch
var DynamicBatch=(function(){
	function DynamicBatch(vertexDeclaration){
		this._vertexDeclaration=null;
		this._vertexDatas=null;
		this._indexDatas=null;
		this._vertexBuffer=null;
		this._indexBuffer=null;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
		this._combineRenderElements=null;
		this._materials=null;
		this._materialToRenderElementsOffsets=null;
		this._merageElements=null;
		this._combineRenderElementPool=null;
		this._combineRenderElementPoolIndex=0;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
		this._combineRenderElements=[];
		this._materialToRenderElementsOffsets=[];
		this._materials=[];
		this._merageElements=[];
		this._combineRenderElementPool=[];
		this._combineRenderElementPoolIndex=0;
		this._vertexDeclaration=vertexDeclaration;
	}

	__class(DynamicBatch,'laya.d3.graphics.DynamicBatch');
	var __proto=DynamicBatch.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true})
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer;
		else
		return null;
	}

	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	__proto._getCombineRenderElementFromPool=function(view,projection,projectionView){
		var renderElement=this._combineRenderElementPool[this._combineRenderElementPoolIndex++];
		if (!renderElement){
			this._combineRenderElementPool[this._combineRenderElementPoolIndex-1]=renderElement=new RenderElement();
			renderElement._sprite3D=new MeshSprite3D();
		}
		renderElement._sprite3D._render._renderUpdate(projectionView);
		return renderElement;
	}

	__proto._getRenderElement=function(view,projection,projectionView){
		if (!this._vertexDatas){
			this._vertexDatas=new Float32Array(this._vertexDeclaration.vertexStride / 4 *DynamicBatch.maxVertexCount);
			this._indexDatas=new Uint16Array(DynamicBatch.maxIndexCount);
			this._vertexBuffer=VertexBuffer3D.create(this._vertexDeclaration,DynamicBatch.maxVertexCount,0x88E8);
			this._indexBuffer=IndexBuffer3D.create("ushort",DynamicBatch.maxIndexCount,0x88E8);
		}
		this._merageElements.length=0;
		var curMerVerCount=0;
		var curIndexCount=0;
		for (var i=0,n=this._combineRenderElements.length;i < n;i++){
			var renderElement=this._combineRenderElements[i];
			var subVertexDatas=renderElement.getDynamicBatchBakedVertexs(0);
			var subIndexDatas=renderElement.getBakedIndices();
			var isInvert=renderElement._sprite3D.transform._isFrontFaceInvert;
			var indexOffset=curMerVerCount / (this._vertexDeclaration.vertexStride / 4);
			var indexStart=curIndexCount;
			var indexEnd=indexStart+subIndexDatas.length;
			renderElement._tempBatchIndexStart=indexStart;
			renderElement._tempBatchIndexEnd=indexEnd;
			this._indexDatas.set(subIndexDatas,curIndexCount);
			var k=0;
			if (isInvert){
				for (k=indexStart;k < indexEnd;k+=3){
					this._indexDatas[k]=indexOffset+this._indexDatas[k];
					var index1=this._indexDatas[k+1];
					var index2=this._indexDatas[k+2];
					this._indexDatas[k+1]=indexOffset+index2;
					this._indexDatas[k+2]=indexOffset+index1;
				}
				}else {
				for (k=indexStart;k < indexEnd;k+=3){
					this._indexDatas[k]=indexOffset+this._indexDatas[k];
					this._indexDatas[k+1]=indexOffset+this._indexDatas[k+1];
					this._indexDatas[k+2]=indexOffset+this._indexDatas[k+2];
				}
			}
			curIndexCount+=subIndexDatas.length;
			this._vertexDatas.set(subVertexDatas,curMerVerCount);
			curMerVerCount+=subVertexDatas.length;
		}
		this._vertexBuffer.setData(this._vertexDatas);
		this._indexBuffer.setData(this._indexDatas);
		this._combineRenderElementPoolIndex=0;
		for (i=0,n=this._materials.length;i < n;i++){
			var merageElement=this._getCombineRenderElementFromPool(view,projection,projectionView);
			merageElement._type=2;
			merageElement._staticBatch=null;
			merageElement.renderObj=this;
			var renderElementStartIndex=this._combineRenderElements[this._materialToRenderElementsOffsets[i]]._tempBatchIndexStart;
			var renderElementEndIndex=(i+1===this._materialToRenderElementsOffsets.length)? curIndexCount :this._combineRenderElements[this._materialToRenderElementsOffsets[i+1]]._tempBatchIndexStart;
			merageElement._tempBatchIndexStart=renderElementStartIndex;
			merageElement._tempBatchIndexEnd=renderElementEndIndex;
			merageElement._material=this._materials[i];
			this._merageElements.push(merageElement);
		}
	}

	__proto._addCombineRenderObjTest=function(renderElement){
		var renderObj=renderElement.renderObj;
		var indexCount=this._currentCombineIndexCount+renderObj._getIndexBuffer().indexCount;
		var vertexCount=this._currentCombineVertexCount+renderObj._getVertexBuffer().vertexCount;
		if (vertexCount > DynamicBatch.maxVertexCount || indexCount > DynamicBatch.maxIndexCount){
			return false;
		}
		return true;
	}

	__proto._addCombineRenderObj=function(renderElement){
		var renderObj=renderElement.renderObj;
		this._combineRenderElements.push(renderElement);
		this._currentCombineIndexCount=this._currentCombineIndexCount+renderObj._getIndexBuffer().indexCount;
		this._currentCombineVertexCount=this._currentCombineVertexCount+renderObj._getVertexBuffer().vertexCount;
	}

	__proto._addCombineMaterial=function(material){
		this._materials.push(material);
	}

	__proto._addMaterialToRenderElementOffset=function(offset){
		this._materialToRenderElementsOffsets.push(offset);
	}

	__proto._clearRenderElements=function(){
		this._combineRenderElements.length=0;
		this._materials.length=0;
		this._materialToRenderElementsOffsets.length=0;
		this._currentCombineVertexCount=0;
		this._currentCombineIndexCount=0;
	}

	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		this._getRenderElement(view,projection,projectionView);
		for (var i=0,n=this._materials.length;i < n;i++)
		scene.getRenderQueue(this._materials[i].renderQueue)._addDynamicBatchElement(this._merageElements[i]);
	}

	__proto._beforeRender=function(state){
		this._vertexBuffer._bind();
		this._indexBuffer._bind();
		return true;
	}

	__proto._render=function(state){
		var indexCount=state._batchIndexEnd-state._batchIndexStart;
		WebGL.mainContext.drawElements(0x0004,indexCount,0x1403,state._batchIndexStart *2);
		Stat.drawCall++;
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	/**NATIVE*/
	__proto._renderRuntime=function(conchGraphics3D,renderElement,state){}
	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	__getset(0,__proto,'triangleCount',function(){
		return this._indexBuffer.indexCount / 3;
	});

	__getset(0,__proto,'combineRenderElementsCount',function(){
		return this._combineRenderElements.length;
	});

	DynamicBatch.maxVertexCount=20000;
	DynamicBatch.maxIndexCount=40000;
	DynamicBatch.maxCombineTriangleCount=10;
	return DynamicBatch;
})()


/**
*@private
*<code>DynamicBatchManager</code> 类用于管理动态批处理。
*/
//class laya.d3.graphics.DynamicBatchManager
var DynamicBatchManager=(function(){
	function DynamicBatchManager(){
		this._dynamicBatches=null;
		this._prepareDynamicBatchCombineElements=null;
		this._dynamicBatches={};
		this._prepareDynamicBatchCombineElements=[];
	}

	__class(DynamicBatchManager,'laya.d3.graphics.DynamicBatchManager');
	var __proto=DynamicBatchManager.prototype;
	__proto.getDynamicBatch=function(_vertexDeclaration,number){
		var dynamicBatch;
		var key=_vertexDeclaration.id.toString()+number;
		if (!this._dynamicBatches[key]){
			this._dynamicBatches[key]=dynamicBatch=new DynamicBatch(_vertexDeclaration);
			}else {
			dynamicBatch=this._dynamicBatches[key];
		}
		return dynamicBatch;
	}

	/**需手动调用*/
	__proto._garbageCollection=function(){
		for (var key in this._dynamicBatches)
		if (this._dynamicBatches[key].combineRenderElementsCount===0)
			delete this._dynamicBatches[key];
	}

	__proto._addPrepareRenderElement=function(renderElement){
		this._prepareDynamicBatchCombineElements.push(renderElement);
	}

	/**@private */
	__proto._finishCombineDynamicBatch=function(scene){
		this._prepareDynamicBatchCombineElements.sort(DynamicBatchManager._sortPrepareDynamicBatch);
		var lastMaterial;
		var lastVertexDeclaration;
		var lastRenderElement;
		var lastBatchNumber=-1;
		var lastCanMerage=true;
		var curMaterial;
		var curRenderElement;
		var curDynamicBatch;
		var curbatchNumber=0;
		var laterAddMaterial;
		var laterAddRenderElement;
		var laterAddMatToElementOffset=-1;
		for (var i=0,n=this._prepareDynamicBatchCombineElements.length;i < n;i++){
			curRenderElement=this._prepareDynamicBatchCombineElements[i];
			var curDeclaration=curRenderElement.renderObj._getVertexBuffer(0).vertexDeclaration;
			var declarationChanged=(lastVertexDeclaration!==curDeclaration);
			declarationChanged && (curbatchNumber=0,lastVertexDeclaration=curDeclaration);
			var batchNumbrChanged=(curbatchNumber!==lastBatchNumber);
			batchNumbrChanged && (lastBatchNumber=curbatchNumber);
			if ((declarationChanged)|| batchNumbrChanged){
				curDynamicBatch=this.getDynamicBatch(curDeclaration,curbatchNumber);
				lastMaterial=null;
			}
			if (lastCanMerage){
				if (curDynamicBatch._addCombineRenderObjTest(curRenderElement)){
					curMaterial=curRenderElement._material;
					if (lastMaterial!==curMaterial){
						if (laterAddMaterial){
							scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
							laterAddMaterial=null;
							laterAddRenderElement=null;
							laterAddMatToElementOffset=-1;
						}
						laterAddMaterial=curMaterial;
						laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
						laterAddRenderElement=curRenderElement;
						lastMaterial=curMaterial;
						}else {
						if (laterAddMaterial){
							var lastRenderObj=laterAddRenderElement.renderObj;
							var curRenderObj=curRenderElement.renderObj;
							if (((lastRenderObj._getVertexBuffer().vertexCount+curRenderObj._getVertexBuffer().vertexCount)> DynamicBatch.maxVertexCount)|| ((lastRenderObj._getIndexBuffer().indexCount+curRenderObj._getIndexBuffer().indexCount)> DynamicBatch.maxIndexCount)){
								scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
								laterAddMaterial=curMaterial;
								laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
								laterAddRenderElement=curRenderElement;
								}else {
								curDynamicBatch._addCombineMaterial(laterAddMaterial);
								curDynamicBatch._addMaterialToRenderElementOffset(laterAddMatToElementOffset);
								curDynamicBatch._addCombineRenderObj(laterAddRenderElement);
								laterAddMaterial=null;
								laterAddRenderElement=null;
								laterAddMatToElementOffset=-1;
								curDynamicBatch._addCombineRenderObj(curRenderElement);
							}
							}else {
							curDynamicBatch._addCombineRenderObj(curRenderElement);
						}
					}
					lastCanMerage=true;
					}else {
					if (laterAddMaterial){
						scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
						laterAddMaterial=null;
						laterAddRenderElement=null;
						laterAddMatToElementOffset=-1;
					}
					curbatchNumber++;
					lastCanMerage=false;
				}
				}else {
				lastRenderElement=this._prepareDynamicBatchCombineElements[i-1];
				curDynamicBatch._addMaterialToRenderElementOffset(curDynamicBatch.combineRenderElementsCount);
				lastMaterial=lastRenderElement._material;
				curDynamicBatch._addCombineMaterial(lastMaterial);
				curDynamicBatch._addCombineRenderObj(lastRenderElement);
				lastCanMerage=true;
				curMaterial=curRenderElement._material;
				if (lastMaterial!==curMaterial){
					laterAddMaterial=curMaterial;
					laterAddMatToElementOffset=curDynamicBatch.combineRenderElementsCount;
					laterAddRenderElement=curRenderElement;
					}else {
					curDynamicBatch._addCombineRenderObj(curRenderElement);
				}
				lastMaterial=curMaterial;
			}
		}
		if (laterAddMaterial){
			scene.getRenderQueue(laterAddRenderElement._material.renderQueue)._addRenderElement(laterAddRenderElement);
			laterAddMaterial=null;
			laterAddRenderElement=null;
			laterAddMatToElementOffset=-1;
		}
		this._prepareDynamicBatchCombineElements.length=0;
	}

	__proto._clearRenderElements=function(){
		for (var key in this._dynamicBatches)
		this._dynamicBatches[key]._clearRenderElements();
	}

	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		for (var key in this._dynamicBatches){
			var dynamicBatch=this._dynamicBatches[key];
			(dynamicBatch.combineRenderElementsCount > 0)&& (dynamicBatch._addToRenderQueue(scene,view,projection,projectionView));
		}
	}

	__proto.dispose=function(){
		this._dynamicBatches=null;
	}

	DynamicBatchManager._sortPrepareDynamicBatch=function(a,b){
		return a._mainSortID-b._mainSortID;
	}

	return DynamicBatchManager;
})()


/**
*@private
*/
//class laya.d3.graphics.FrustumCulling
var FrustumCulling=(function(){
	function FrustumCulling(){}
	__class(FrustumCulling,'laya.d3.graphics.FrustumCulling');
	FrustumCulling.renderShadowObjectCulling=function(scene,lightFrustum,shadowQueues,lightViewProjectMatrix,nPSSMNum){
		var i=0,j=0,n=0,m=0;
		for (i=0,n=shadowQueues.length;i < n;i++){
			var quene=shadowQueues[i];
			(quene)&& (quene._clearRenderElements());
		};
		var frustumCullingObjects=scene._cullingRenders;
		var baseRender,shadowQueue,renderElements;
		if (nPSSMNum > 1){
			for (i=0,n=scene._cullingRendersLength;i < n;i++){
				baseRender=frustumCullingObjects[i];
				if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
					for (var k=1,kNum=lightFrustum.length;k < kNum;k++){
						shadowQueue=shadowQueues[k-1];
						if (lightFrustum[k].containsBoundSphere(baseRender.boundingSphere)!==0){
							renderElements=baseRender._renderElements;
							for (j=0,m=renderElements.length;j < m;j++)
							shadowQueue._addRenderElement(renderElements[j]);
						}
					}
				}
			}
			}else {
			for (i=0,n=scene._cullingRendersLength;i < n;i++){
				baseRender=frustumCullingObjects[i];
				if (baseRender.castShadow && Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
					if (lightFrustum[0].containsBoundSphere(baseRender.boundingSphere)!==0){
						baseRender._renderUpdate(lightViewProjectMatrix);
						shadowQueue=shadowQueues[0];
						renderElements=baseRender._renderElements;
						for (j=0,m=renderElements.length;j < m;j++)
						shadowQueue._addRenderElement(renderElements[j]);
					}
				}
			}
		}
	}

	FrustumCulling.renderShadowObjectCullingOctree=function(scene,lightFrustum,quenesResult,lightViewProjectMatrix,nPSSMNum){
		for (var i=0,n=quenesResult.length;i < n;i++){
			var quene=quenesResult[i];
			(quene)&& (quene._clearRenderElements());
		}
		if (nPSSMNum > 1){
			scene.treeRoot.cullingShadowObjects(lightFrustum,quenesResult,true,0,scene);
			}else {
			scene.treeRoot.cullingShadowObjectsOnePSSM(lightFrustum[0],quenesResult,lightViewProjectMatrix,true,0,scene);
		}
	}

	FrustumCulling.renderObjectCulling=function(boundFrustum,scene,camera,view,projection,projectionView){
		var i=0,n=0,j=0,m=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		var frustumCullingObjects=scene._cullingRenders;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		var cameraPosition=camera.transform.position;
		for (i=0,n=scene._cullingRendersLength;i < n;i++){
			var baseRender=frustumCullingObjects[i];
			if (Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable && (boundFrustum.containsBoundSphere(baseRender.boundingSphere)!==0)){
				baseRender._renderUpdate(projectionView);
				baseRender._distanceForSort=Vector3.distance(baseRender.boundingSphere.center,cameraPosition)+baseRender.sortingFudge;
				var renderElements=baseRender._renderElements;
				for (j=0,m=renderElements.length;j < m;j++){
					var renderElement=renderElements[j];
					var staticBatch=renderElement._staticBatch;
					if (staticBatch && (staticBatch._material===renderElement._material)){
						staticBatch._addBatchRenderElement(renderElement);
						}else {
						var renderObj=renderElement.renderObj;
						if ((renderObj.triangleCount < 10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!baseRender._owner.isStatic))
							dynamicBatchManager._addPrepareRenderElement(renderElement);
						else
						scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
					}
				}
			}
		}
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	FrustumCulling.renderObjectCullingOctree=function(boundFrustum,scene,camera,view,projection,projectionView){
		var i=0,n=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		scene._cullingRenders.length=0;
		scene.treeRoot.cullingObjects(boundFrustum,true,0,camera.transform.position,projectionView);
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	FrustumCulling.renderObjectCullingNoBoundFrustum=function(scene,camera,view,projection,projectionView){
		var i=0,n=0,j=0,m=0;
		var queues=scene._quenes;
		var dynamicBatchManager=scene._dynamicBatchManager;
		var frustumCullingObjects=scene._cullingRenders;
		for (i=0,n=queues.length;i < n;i++){
			var queue=queues[i];
			(queue)&& (queue._clearRenderElements());
		};
		var staticBatchManagers=StaticBatchManager._staticBatchManagers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clearRenderElements();
		dynamicBatchManager._clearRenderElements();
		var cameraPosition=camera.transform.position;
		for (i=0,n=scene._cullingRendersLength;i < n;i++){
			var baseRender=frustumCullingObjects[i];
			if (Layer.isVisible(baseRender._owner.layer.mask)&& baseRender.enable){
				baseRender._renderUpdate(projectionView);
				baseRender._distanceForSort=Vector3.distance(baseRender.boundingSphere.center,cameraPosition)+baseRender.sortingFudge;
				var renderElements=baseRender._renderElements;
				for (j=0,m=renderElements.length;j < m;j++){
					var renderElement=renderElements[j];
					var staticBatch=renderElement._staticBatch;
					if (staticBatch && (staticBatch._material===renderElement._material)){
						staticBatch._addBatchRenderElement(renderElement);
						}else {
						var renderObj=renderElement.renderObj;
						if ((renderObj.triangleCount < 10)&& (renderObj._vertexBufferCount===1)&& (renderObj._getIndexBuffer())&& (renderElement._material.renderQueue < 2)&& renderElement._canDynamicBatch && (!baseRender._owner.isStatic))
							dynamicBatchManager._addPrepareRenderElement(renderElement);
						else
						scene.getRenderQueue(renderElement._material.renderQueue)._addRenderElement(renderElement);
					}
				}
			}
		}
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._addToRenderQueue(scene,view,projection,projectionView);
		dynamicBatchManager._finishCombineDynamicBatch(scene);
		dynamicBatchManager._addToRenderQueue(scene,view,projection,projectionView);
	}

	return FrustumCulling;
})()


/**
*@private
*<code>StaticBatchManager</code> 类用于静态批处理管理的父类。
*/
//class laya.d3.graphics.StaticBatchManager
var StaticBatchManager=(function(){
	function StaticBatchManager(){
		/**@private */
		this._initBatchRenderElements=null;
		/**@private */
		this._staticBatches=null;
		this._initBatchRenderElements=[];
		this._staticBatches={};
	}

	__class(StaticBatchManager,'laya.d3.graphics.StaticBatchManager');
	var __proto=StaticBatchManager.prototype;
	/**
	*@private
	*/
	__proto._finishInit=function(){
		for (var key in this._staticBatches)
		this._staticBatches[key]._finishInit();
		this._initBatchRenderElements.length=0;
	}

	/**
	*@private
	*/
	__proto._initStaticBatchs=function(rootSprite){
		throw new Error("StaticBatchManager:must override this function.");
	}

	/**
	*@private
	*/
	__proto._addInitBatchSprite=function(renderableSprite3D){
		var renderElements=renderableSprite3D._render._renderElements;
		for (var i=0,n=renderElements.length;i < n;i++)
		this._initBatchRenderElements.push(renderElements[i]);
	}

	/**
	*@private
	*/
	__proto._clearRenderElements=function(){
		for (var key in this._staticBatches)
		this._staticBatches[key]._clearRenderElements();
	}

	/**
	*@private
	*/
	__proto._garbageCollection=function(renderElement){
		var staticBatch=renderElement._staticBatch;
		var initBatchRenderElements=staticBatch._initBatchRenderElements;
		var index=initBatchRenderElements.indexOf(renderElement);
		initBatchRenderElements.splice(index,1);
		if (initBatchRenderElements.length===0){
			staticBatch.dispose();
			delete this._staticBatches[staticBatch._key];
		}
	}

	/**
	*@private
	*/
	__proto._addToRenderQueue=function(scene,view,projection,projectionView){
		for (var key in this._staticBatches){
			var staticBatch=this._staticBatches[key];
			if (staticBatch._batchRenderElements.length > 0)
				staticBatch._updateToRenderQueue(scene,projectionView);
		}
	}

	__proto.dispose=function(){
		this._staticBatches=null;
	}

	StaticBatchManager._addToStaticBatchQueue=function(sprite3D){
		if ((sprite3D instanceof laya.d3.core.RenderableSprite3D ))
			(sprite3D)._addToInitStaticBatchManager();
		for (var i=0,n=sprite3D.numChildren;i < n;i++)
		StaticBatchManager._addToStaticBatchQueue(sprite3D._childs [i]);
	}

	StaticBatchManager.combine=function(staticBatchRoot,renderableSprite3Ds){
		var i=0,n=0,staticBatchManager;
		if (renderableSprite3Ds){
			for (i=0,n=renderableSprite3Ds.length;i < n;i++){
				var renderableSprite3D=renderableSprite3Ds[i];
				renderableSprite3D._addToInitStaticBatchManager();
			}
			}else {
			if (staticBatchRoot)
				StaticBatchManager._addToStaticBatchQueue(staticBatchRoot);
		}
		for (i=0,n=StaticBatchManager._staticBatchManagers.length;i < n;i++){
			staticBatchManager=StaticBatchManager._staticBatchManagers[i];
			staticBatchManager._initStaticBatchs(staticBatchRoot);
			staticBatchManager._finishInit();
		}
	}

	StaticBatchManager._staticBatchManagers=[];
	return StaticBatchManager;
})()


/**
*<code>StaticBatch</code> 类用于静态合并的父类,该类为抽象类。
*/
//class laya.d3.graphics.StaticBatch
var StaticBatch=(function(){
	function StaticBatch(key,manager,rootOwner){
		/**@private */
		this._combineRenderElementPoolIndex=0;
		/**@private */
		this._combineRenderElementPool=null;
		/**@private */
		this._initBatchRenderElements=null;
		/**@private */
		this._batchRenderElements=null;
		/**@private */
		this._material=null;
		/**@private */
		this._rootOwner=null;
		/**@private */
		this._key=null;
		/**@private */
		this._manager=null;
		this._key=key;
		this._manager=manager;
		this._combineRenderElementPoolIndex=0;
		this._combineRenderElementPool=[];
		this._initBatchRenderElements=[];
		this._batchRenderElements=[];
		this._rootOwner=rootOwner;
	}

	__class(StaticBatch,'laya.d3.graphics.StaticBatch');
	var __proto=StaticBatch.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true,"laya.resource.IDispose":true})
	/**
	*@private
	*/
	__proto._binarySearch=function(renderElement){
		var start=0;
		var end=this._batchRenderElements.length-1;
		var mid=0;
		while (start <=end){
			mid=Math.floor((start+end)/ 2);
			if (this._compareBatchRenderElement(this._batchRenderElements[mid],renderElement))
				end=mid-1;
			else
			start=mid+1;
		}
		return start;
	}

	/**
	*@private
	*/
	__proto._compareBatchRenderElement=function(a,b){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._getVertexDecLightMap=function(vertexDeclaration){
		if (vertexDeclaration===VertexPositionNormalTextureSkinSTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1SkinSTangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSkin.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalColorTextureSTangent.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1STangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNTBTexture.vertexDeclaration){
			return null;
			}else if (vertexDeclaration===VertexPositionNormalColorTexture.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1STangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTexture.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1.vertexDeclaration;
		}
		if (vertexDeclaration===VertexPositionNormalTextureSkinTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureSkin.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalColorTextureTangent.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNTBTexture.vertexDeclaration){
			return null;
			}else if (vertexDeclaration===VertexPositionNormalColorTexture.vertexDeclaration){
			return VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTextureTangent.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
			}else if (vertexDeclaration===VertexPositionNormalTexture.vertexDeclaration){
			return VertexPositionNormalTexture0Texture1.vertexDeclaration;
			}else {
			return vertexDeclaration;
		}
	}

	/**
	*@private
	*/
	__proto._getCombineRenderElementFromPool=function(){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._addBatchRenderElement=function(renderElement){
		this._batchRenderElements.splice(this._binarySearch(renderElement),0,renderElement);
	}

	/**
	*@private
	*/
	__proto._updateToRenderQueue=function(scene,projectionView){
		this._combineRenderElementPoolIndex=0;
		this._getRenderElement(scene.getRenderQueue(this._material.renderQueue)._renderElements,scene,projectionView);
	}

	/**
	*@private
	*/
	__proto._getRenderElement=function(mergeElements,scene,projectionView){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._finishInit=function(){
		throw new Error("StaticBatch:must override this function.");
	}

	/**
	*@private
	*/
	__proto._clearRenderElements=function(){
		this._batchRenderElements.length=0;
	}

	/**
	*@private
	*/
	__proto.dispose=function(){}
	//..................临时.................................
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		return null;
	}

	__proto._getIndexBuffer=function(){
		return null;
	}

	__proto._beforeRender=function(state){
		return true;
	}

	__proto._render=function(state){}
	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	/**NATIVE*/
	__proto._renderRuntime=function(conchGraphics3D,renderElement,state){}
	//..................临时.................................
	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	__getset(0,__proto,'triangleCount',function(){
		return 0;
	});

	StaticBatch.combine=function(staticBatchRoot){
		console.log("StaticBatch: discard property,please use StaticBatchManager.combine() function instead.");
		StaticBatchManager.combine(staticBatchRoot);
	}

	StaticBatch.maxBatchVertexCount=65535;
	return StaticBatch;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexDeclaration
var VertexDeclaration=(function(){
	function VertexDeclaration(vertexStride,vertexElements){
		this._id=0;
		this._shaderValues=null;
		this._shaderDefineValue=0;
		//private var _shaderAttribute:*;
		this._vertexStride=0;
		this._vertexElements=null;
		this._vertexElementsDic=null;
		this._conchVertexDeclaration=null;
		this._id=++VertexDeclaration._uniqueIDCounter;
		if (this._id > VertexDeclaration.maxVertexDeclaration)
			throw new Error("VertexDeclaration: VertexDeclaration count should not large than ",VertexDeclaration.maxVertexDeclaration);
		this._shaderValues=new ValusArray();
		this._vertexElementsDic={};
		this._vertexStride=vertexStride;
		this._vertexElements=vertexElements;
		if (Render.isConchNode){
			this._conchVertexDeclaration=new ConchVertexDeclare();
		}
		for (var i=0;i < vertexElements.length;i++){
			var vertexElement=vertexElements[i];
			var attributeName=vertexElement.elementUsage;
			this._vertexElementsDic[attributeName]=vertexElement;
			var value=[VertexDeclaration._getTypeSize(vertexElement.elementFormat)/ 4,0x1406,false,this._vertexStride,vertexElement.offset];
			this._shaderValues.setValue(attributeName,value);
			switch (attributeName){
				case 1:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_COLOR);
					break
				case 2:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_UV0);
					break ;
				case 15:
					this._addShaderDefine(ShaderCompile3D.SHADERDEFINE_UV1);
					break ;
				}
		}
		if (Render.isConchNode){
			var conchVertexElements=[];
			for (var ci=0,cn=vertexElements.length;ci < cn;ci++){
				var cVertexElement=vertexElements[ci];
				switch (cVertexElement.elementFormat){
					case "vector2":
						conchVertexElements.push({offset:cVertexElement.offset,elementFormat:0x8B50,elementUsage:cVertexElement.elementUsage});
						break ;
					case "vector3":
						conchVertexElements.push({offset:cVertexElement.offset,elementFormat:0x8B51,elementUsage:cVertexElement.elementUsage});
						break ;
					case "vector4":
						conchVertexElements.push({offset:cVertexElement.offset,elementFormat:0x8B52,elementUsage:cVertexElement.elementUsage});
						break ;
					}
			}
			this._conchVertexDeclaration.setDelcare(conchVertexElements);
		}
	}

	__class(VertexDeclaration,'laya.d3.graphics.VertexDeclaration');
	var __proto=VertexDeclaration.prototype;
	/**
	*增加Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._addShaderDefine=function(value){
		this._shaderDefineValue |=value;
		if (this._conchVertexDeclaration){
			this._conchVertexDeclaration.addShaderDefine(value);
		}
	}

	/**
	*移除Shader宏定义。
	*@param value 宏定义。
	*/
	__proto._removeShaderDefine=function(value){
		this._shaderDefineValue &=~value;
		if (this._conchVertexDeclaration){
			this._conchVertexDeclaration.removeShaderDefine(value)
		}
	}

	__proto.getVertexElements=function(){
		return this._vertexElements.slice();
	}

	__proto.getVertexElementByUsage=function(usage){
		return this._vertexElementsDic[usage];
	}

	__proto.unBinding=function(){}
	__getset(0,__proto,'shaderDefineValue',function(){
		return this._shaderDefineValue;
	});

	/**
	*获取唯一标识ID(通常用于优化或识别)。
	*@return 唯一标识ID
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	__getset(0,__proto,'vertexStride',function(){
		return this._vertexStride;
	});

	__getset(0,__proto,'shaderValues',function(){
		return this._shaderValues;
	});

	VertexDeclaration._getTypeSize=function(format){
		switch (format){
			case "single":
				return 4;
			case "vector2":
				return 8;
			case "vector3":
				return 12;
			case "vector4":
				return 16;
			case "color":
				return 4;
			case "byte4":
				return 4;
			case "short2":
				return 4;
			case "short4":
				return 8;
			case "normalizedshort2":
				return 4;
			case "normalizedshort4":
				return 8;
			case "halfvector2":
				return 4;
			case "halfvector4":
				return 8;
			}
		return 0;
	}

	VertexDeclaration.getVertexStride=function(vertexElements){
		var curStride=0;
		for (var i=0;i < vertexElements.Length;i++){
			var element=vertexElements[i];
			var stride=element.offset+VertexDeclaration._getTypeSize(element.elementFormat);
			if (curStride < stride){
				curStride=stride;
			}
		}
		return curStride;
	}

	VertexDeclaration._maxVertexDeclarationBit=1000;
	VertexDeclaration._uniqueIDCounter=1;
	__static(VertexDeclaration,
	['maxVertexDeclaration',function(){return this.maxVertexDeclaration=2147483647-Math.floor(2147483647 / 1000)*1000;}
	]);
	return VertexDeclaration;
})()


/**
*<code>VertexElement</code> 类用于创建顶点结构分配。
*/
//class laya.d3.graphics.VertexElement
var VertexElement=(function(){
	function VertexElement(offset,elementFormat,elementUsage){
		this.offset=0;
		this.elementFormat=null;
		this.elementUsage=0;
		this.offset=offset;
		this.elementFormat=elementFormat;
		this.elementUsage=elementUsage;
	}

	__class(VertexElement,'laya.d3.graphics.VertexElement');
	return VertexElement;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexElementFormat
var VertexElementFormat=(function(){
	function VertexElementFormat(){}
	__class(VertexElementFormat,'laya.d3.graphics.VertexElementFormat');
	VertexElementFormat.Single="single";
	VertexElementFormat.Vector2="vector2";
	VertexElementFormat.Vector3="vector3";
	VertexElementFormat.Vector4="vector4";
	VertexElementFormat.Color="color";
	VertexElementFormat.Byte4="byte4";
	VertexElementFormat.Short2="short2";
	VertexElementFormat.Short4="short4";
	VertexElementFormat.NormalizedShort2="normalizedshort2";
	VertexElementFormat.NormalizedShort4="normalizedshort4";
	VertexElementFormat.HalfVector2="halfvector2";
	VertexElementFormat.HalfVector4="halfvector4";
	return VertexElementFormat;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexElementUsage
var VertexElementUsage=(function(){
	function VertexElementUsage(){}
	__class(VertexElementUsage,'laya.d3.graphics.VertexElementUsage');
	VertexElementUsage.POSITION0=0;
	VertexElementUsage.COLOR0=1;
	VertexElementUsage.TEXTURECOORDINATE0=2;
	VertexElementUsage.NORMAL0=3;
	VertexElementUsage.BINORMAL0=4;
	VertexElementUsage.TANGENT0=5;
	VertexElementUsage.BLENDINDICES0=6;
	VertexElementUsage.BLENDWEIGHT0=7;
	VertexElementUsage.DEPTH0=8;
	VertexElementUsage.FOG0=9;
	VertexElementUsage.POINTSIZE0=10;
	VertexElementUsage.SAMPLE0=11;
	VertexElementUsage.TESSELLATEFACTOR0=12;
	VertexElementUsage.COLOR1=13;
	VertexElementUsage.NEXTTEXTURECOORDINATE0=14;
	VertexElementUsage.TEXTURECOORDINATE1=15;
	VertexElementUsage.NEXTTEXTURECOORDINATE1=16;
	VertexElementUsage.CORNERTEXTURECOORDINATE0=17;
	VertexElementUsage.VELOCITY0=18;
	VertexElementUsage.STARTCOLOR0=19;
	VertexElementUsage.STARTSIZE=20;
	VertexElementUsage.AGEADDSCALE0=21;
	VertexElementUsage.STARTROTATION=22;
	VertexElementUsage.ENDCOLOR0=23;
	VertexElementUsage.STARTLIFETIME=24;
	VertexElementUsage.TIME0=33;
	VertexElementUsage.SHAPEPOSITIONSTARTLIFETIME=30;
	VertexElementUsage.DIRECTIONTIME=32;
	VertexElementUsage.SIZEROTATION0=27;
	VertexElementUsage.RADIUS0=28;
	VertexElementUsage.RADIAN0=29;
	VertexElementUsage.STARTSPEED=31;
	VertexElementUsage.RANDOM0=34;
	VertexElementUsage.RANDOM1=35;
	VertexElementUsage.SIMULATIONWORLDPOSTION=36;
	VertexElementUsage.SIMULATIONWORLDROTATION=37;
	VertexElementUsage.TEXTURECOORDINATE0X=38;
	VertexElementUsage.TEXTURECOORDINATE0Y=39;
	return VertexElementUsage;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexGlitter
var VertexGlitter=(function(){
	function VertexGlitter(position,textureCoordinate,time){
		this._position=null;
		this._textureCoordinate0=null;
		this._time=NaN;
		this._position=position;
		this._textureCoordinate0=textureCoordinate;
		this._time=time;
	}

	__class(VertexGlitter,'laya.d3.graphics.VertexGlitter');
	var __proto=VertexGlitter.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexGlitter._vertexDeclaration;
	});

	__getset(1,VertexGlitter,'vertexDeclaration',function(){
		return VertexGlitter._vertexDeclaration;
	});

	__static(VertexGlitter,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(24,
		[new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector2",2),
		new VertexElement(20,"single",33)]);}
	]);
	return VertexGlitter;
})()


//class laya.d3.graphics.VertexPosition
var VertexPosition=(function(){
	function VertexPosition(position){
		this._position=null;
		this._position=position;
	}

	__class(VertexPosition,'laya.d3.graphics.VertexPosition');
	var __proto=VertexPosition.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPosition._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPosition,'vertexDeclaration',function(){
		return VertexPosition._vertexDeclaration;
	});

	__static(VertexPosition,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(12,[
		new VertexElement(0,"vector3",0)]);}
	]);
	return VertexPosition;
})()


//class laya.d3.graphics.VertexPositionNormal
var VertexPositionNormal=(function(){
	function VertexPositionNormal(position,normal){
		this._position=null;
		this._normal=null;
		this._position=position;
		this._normal=normal;
	}

	__class(VertexPositionNormal,'laya.d3.graphics.VertexPositionNormal');
	var __proto=VertexPositionNormal.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormal._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormal,'vertexDeclaration',function(){
		return VertexPositionNormal._vertexDeclaration;
	});

	__static(VertexPositionNormal,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(24,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3)]);}
	]);
	return VertexPositionNormal;
})()


/**
*<code>VertexPositionNormalColor</code> 类用于创建位置、法线、颜色顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColor
var VertexPositionNormalColor=(function(){
	function VertexPositionNormalColor(position,normal,color){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
	}

	__class(VertexPositionNormalColor,'laya.d3.graphics.VertexPositionNormalColor');
	var __proto=VertexPositionNormalColor.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColor._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColor,'vertexDeclaration',function(){
		return VertexPositionNormalColor._vertexDeclaration;
	});

	__static(VertexPositionNormalColor,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1)]);}
	]);
	return VertexPositionNormalColor;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkin
var VertexPositionNormalColorSkin=(function(){
	function VertexPositionNormalColorSkin(position,normal,color,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkin,'laya.d3.graphics.VertexPositionNormalColorSkin');
	var __proto=VertexPositionNormalColorSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkin,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6)]);}
	]);
	return VertexPositionNormalColorSkin;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkinSTangent
var VertexPositionNormalColorSkinSTangent=(function(){
	function VertexPositionNormalColorSkinSTangent(position,normal,color,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkinSTangent,'laya.d3.graphics.VertexPositionNormalColorSkinSTangent');
	var __proto=VertexPositionNormalColorSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6),
		new VertexElement(72,"vector4",5)]);}
	]);
	return VertexPositionNormalColorSkinSTangent;
})()


/**
*<code>VertexPositionNormalColorSkin</code> 类用于创建位置、法线、颜色、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSkinTangent
var VertexPositionNormalColorSkinTangent=(function(){
	function VertexPositionNormalColorSkinTangent(position,normal,color,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorSkinTangent,'laya.d3.graphics.VertexPositionNormalColorSkinTangent');
	var __proto=VertexPositionNormalColorSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(84,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6),
		new VertexElement(72,"vector3",5)]);}
	]);
	return VertexPositionNormalColorSkinTangent;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建位置、法线、颜色、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorSTangent
var VertexPositionNormalColorSTangent=(function(){
	function VertexPositionNormalColorSTangent(position,normal,color,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorSTangent,'laya.d3.graphics.VertexPositionNormalColorSTangent');
	var __proto=VertexPositionNormalColorSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector4",5)]);}
	]);
	return VertexPositionNormalColorSTangent;
})()


/**
*<code>VertexPositionNormalColorTangent</code> 类用于创建位置、法线、颜色、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTangent
var VertexPositionNormalColorTangent=(function(){
	function VertexPositionNormalColorTangent(position,normal,color,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTangent,'laya.d3.graphics.VertexPositionNormalColorTangent');
	var __proto=VertexPositionNormalColorTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(52,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector3",5)]);}
	]);
	return VertexPositionNormalColorTangent;
})()


/**
*<code>VertexPositionNormalColorTexture</code> 类用于创建位置、法线、颜色、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture
var VertexPositionNormalColorTexture=(function(){
	function VertexPositionNormalColorTexture(position,normal,color,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNormalColorTexture,'laya.d3.graphics.VertexPositionNormalColorTexture');
	var __proto=VertexPositionNormalColorTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTexture,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(48,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2)]);}
	]);
	return VertexPositionNormalColorTexture;
})()


/**
*<code>VertexPositionNormalColorTexture</code> 类用于创建位置、法线、颜色、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1
var VertexPositionNormalColorTexture0Texture1=(function(){
	function VertexPositionNormalColorTexture0Texture1(position,normal,color,textureCoordinate0,textureCoordinate1){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
	}

	__class(VertexPositionNormalColorTexture0Texture1,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1');
	var __proto=VertexPositionNormalColorTexture0Texture1.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Skin
var VertexPositionNormalColorTexture0Texture1Skin=(function(){
	function VertexPositionNormalColorTexture0Texture1Skin(position,normal,color,textureCoordinate0,textureCoordinate1,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Skin');
	var __proto=VertexPositionNormalColorTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15),
		new VertexElement(56,"vector4",7),
		new VertexElement(72,"vector4",6)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinSTangent
var VertexPositionNormalColorTexture0Texture1SkinSTangent=(function(){
	function VertexPositionNormalColorTexture0Texture1SkinSTangent(position,normal,color,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTexture0Texture1SkinSTangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinSTangent');
	var __proto=VertexPositionNormalColorTexture0Texture1SkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1SkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1SkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(104,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15),
		new VertexElement(56,"vector4",7),
		new VertexElement(72,"vector4",6),
		new VertexElement(88,"vector4",5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1SkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinTangent
var VertexPositionNormalColorTexture0Texture1SkinTangent=(function(){
	function VertexPositionNormalColorTexture0Texture1SkinTangent(){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalColorTexture0Texture1SkinTangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1SkinTangent');
	var __proto=VertexPositionNormalColorTexture0Texture1SkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalColorTexture0SkinTangent=function(position,normal,color,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1SkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1SkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(100,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15),
		new VertexElement(56,"vector4",7),
		new VertexElement(72,"vector4",6),
		new VertexElement(88,"vector3",5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1SkinTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1STangent
var VertexPositionNormalColorTexture0Texture1STangent=(function(){
	function VertexPositionNormalColorTexture0Texture1STangent(position,normal,color,textureCoordinate0,textureCoordinate1,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTexture0Texture1STangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1STangent');
	var __proto=VertexPositionNormalColorTexture0Texture1STangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1STangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1STangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1STangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1STangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15),
		new VertexElement(56,"vector4",5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1STangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Tangent
var VertexPositionNormalColorTexture0Texture1Tangent=(function(){
	function VertexPositionNormalColorTexture0Texture1Tangent(){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalColorTexture0Texture1Tangent,'laya.d3.graphics.VertexPositionNormalColorTexture0Texture1Tangent');
	var __proto=VertexPositionNormalColorTexture0Texture1Tangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalColorTexture0Tangent=function(position,normal,color,textureCoordinate0,textureCoordinate1,tangent){
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Tangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalColorTexture0Texture1Tangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTexture0Texture1Tangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTexture0Texture1Tangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(68,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector2",15),
		new VertexElement(56,"vector3",5)]);}
	]);
	return VertexPositionNormalColorTexture0Texture1Tangent;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkin
var VertexPositionNormalColorTextureSkin=(function(){
	function VertexPositionNormalColorTextureSkin(position,normal,color,textureCoordinate,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkin,'laya.d3.graphics.VertexPositionNormalColorTextureSkin');
	var __proto=VertexPositionNormalColorTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(80,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector4",7),
		new VertexElement(64,"vector4",6)]);}
	]);
	return VertexPositionNormalColorTextureSkin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkinSTangent
var VertexPositionNormalColorTextureSkinSTangent=(function(){
	function VertexPositionNormalColorTextureSkinSTangent(position,normal,color,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkinSTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSkinSTangent');
	var __proto=VertexPositionNormalColorTextureSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(96,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector4",7),
		new VertexElement(64,"vector4",6),
		new VertexElement(80,"vector4",5)]);}
	]);
	return VertexPositionNormalColorTextureSkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSkinTangent
var VertexPositionNormalColorTextureSkinTangent=(function(){
	function VertexPositionNormalColorTextureSkinTangent(position,normal,color,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalColorTextureSkinTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSkinTangent');
	var __proto=VertexPositionNormalColorTextureSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(92,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector4",7),
		new VertexElement(64,"vector4",6),
		new VertexElement(80,"vector3",5)]);}
	]);
	return VertexPositionNormalColorTextureSkinTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureSTangent
var VertexPositionNormalColorTextureSTangent=(function(){
	function VertexPositionNormalColorTextureSTangent(position,normal,color,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTextureSTangent,'laya.d3.graphics.VertexPositionNormalColorTextureSTangent');
	var __proto=VertexPositionNormalColorTextureSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(64,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector4",5)]);}
	]);
	return VertexPositionNormalColorTextureSTangent;
})()


/**
*<code>VertexPositionNormalColorTextureTangent</code> 类用于创建位置、法线、颜色、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalColorTextureTangent
var VertexPositionNormalColorTextureTangent=(function(){
	function VertexPositionNormalColorTextureTangent(position,normal,color,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._color=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._color=color;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalColorTextureTangent,'laya.d3.graphics.VertexPositionNormalColorTextureTangent');
	var __proto=VertexPositionNormalColorTextureTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'color',function(){
		return this._color;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalColorTextureTangent,'vertexDeclaration',function(){
		return VertexPositionNormalColorTextureTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalColorTextureTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(60,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",1),
		new VertexElement(40,"vector2",2),
		new VertexElement(48,"vector3",5)]);}
	]);
	return VertexPositionNormalColorTextureTangent;
})()


//class laya.d3.graphics.VertexPositionNormalSTangent
var VertexPositionNormalSTangent=(function(){
	function VertexPositionNormalSTangent(position,normal,tangent){
		this._position=null;
		this._normal=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalSTangent,'laya.d3.graphics.VertexPositionNormalSTangent');
	var __proto=VertexPositionNormalSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalSTangent._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormalSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector4",5)]);}
	]);
	return VertexPositionNormalSTangent;
})()


//class laya.d3.graphics.VertexPositionNormalTangent
var VertexPositionNormalTangent=(function(){
	function VertexPositionNormalTangent(position,normal,tangent){
		this._position=null;
		this._normal=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTangent,'laya.d3.graphics.VertexPositionNormalTangent');
	var __proto=VertexPositionNormalTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTangent._vertexDeclaration;
	});

	/*INTERFACE laya.d3.graphics.IVertex */
	__getset(1,VertexPositionNormalTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(36,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector3",5)]);}
	]);
	return VertexPositionNormalTangent;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture
var VertexPositionNormalTexture=(function(){
	function VertexPositionNormalTexture(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNormalTexture,'laya.d3.graphics.VertexPositionNormalTexture');
	var __proto=VertexPositionNormalTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTexture,'vertexDeclaration',function(){
		return VertexPositionNormalTexture._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(32,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2)]);}
	]);
	return VertexPositionNormalTexture;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1
var VertexPositionNormalTexture0Texture1=(function(){
	function VertexPositionNormalTexture0Texture1(position,normal,textureCoordinate0,textureCoordinate1){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
	}

	__class(VertexPositionNormalTexture0Texture1,'laya.d3.graphics.VertexPositionNormalTexture0Texture1');
	var __proto=VertexPositionNormalTexture0Texture1.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15)]);}
	]);
	return VertexPositionNormalTexture0Texture1;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1Skin
var VertexPositionNormalTexture0Texture1Skin=(function(){
	function VertexPositionNormalTexture0Texture1Skin(position,normal,textureCoordinate0,textureCoordinate1,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNormalTexture0Texture1Skin');
	var __proto=VertexPositionNormalTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(72,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6)]);}
	]);
	return VertexPositionNormalTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinSTangent
var VertexPositionNormalTexture0Texture1SkinSTangent=(function(){
	function VertexPositionNormalTexture0Texture1SkinSTangent(position,normal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTexture0Texture1SkinSTangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinSTangent');
	var __proto=VertexPositionNormalTexture0Texture1SkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1SkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1SkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6),
		new VertexElement(72,"vector4",5)]);}
	]);
	return VertexPositionNormalTexture0Texture1SkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinTangent
var VertexPositionNormalTexture0Texture1SkinTangent=(function(){
	function VertexPositionNormalTexture0Texture1SkinTangent(){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalTexture0Texture1SkinTangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1SkinTangent');
	var __proto=VertexPositionNormalTexture0Texture1SkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalTexture0SkinTangent=function(position,normal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNormalTexture0Texture1SkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1SkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1SkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(84,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15),
		new VertexElement(40,"vector4",7),
		new VertexElement(56,"vector4",6),
		new VertexElement(72,"vector3",5)]);}
	]);
	return VertexPositionNormalTexture0Texture1SkinTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1STangent
var VertexPositionNormalTexture0Texture1STangent=(function(){
	function VertexPositionNormalTexture0Texture1STangent(position,normal,textureCoordinate0,textureCoordinate1,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTexture0Texture1STangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1STangent');
	var __proto=VertexPositionNormalTexture0Texture1STangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1STangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1STangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1STangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1STangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15),
		new VertexElement(40,"vector4",5)]);}
	]);
	return VertexPositionNormalTexture0Texture1STangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTexture0Texture1Tangent
var VertexPositionNormalTexture0Texture1Tangent=(function(){
	function VertexPositionNormalTexture0Texture1Tangent(){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._tangent=null;
	}

	__class(VertexPositionNormalTexture0Texture1Tangent,'laya.d3.graphics.VertexPositionNormalTexture0Texture1Tangent');
	var __proto=VertexPositionNormalTexture0Texture1Tangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__proto.VertexPositionNormalTexture0Tangent=function(position,normal,textureCoordinate0,textureCoordinate1,tangent){
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
	}

	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Tangent._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(1,VertexPositionNormalTexture0Texture1Tangent,'vertexDeclaration',function(){
		return VertexPositionNormalTexture0Texture1Tangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTexture0Texture1Tangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(52,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15),
		new VertexElement(40,"vector3",5)]);}
	]);
	return VertexPositionNormalTexture0Texture1Tangent;
})()


/**
*<code>VertexPositionNormalColorTextureSkin</code> 类用于创建位置、法线、颜色、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkin
var VertexPositionNormalTextureSkin=(function(){
	function VertexPositionNormalTextureSkin(position,normal,textureCoordinate,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkin,'laya.d3.graphics.VertexPositionNormalTextureSkin');
	var __proto=VertexPositionNormalTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(64,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector4",7),
		new VertexElement(48,"vector4",6)]);}
	]);
	return VertexPositionNormalTextureSkin;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkinSTangent
var VertexPositionNormalTextureSkinSTangent=(function(){
	function VertexPositionNormalTextureSkinSTangent(position,normal,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkinSTangent,'laya.d3.graphics.VertexPositionNormalTextureSkinSTangent');
	var __proto=VertexPositionNormalTextureSkinSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkinSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkinSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(80,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector4",7),
		new VertexElement(48,"vector4",6),
		new VertexElement(64,"vector4",5)]);}
	]);
	return VertexPositionNormalTextureSkinSTangent;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSkinTangent
var VertexPositionNormalTextureSkinTangent=(function(){
	function VertexPositionNormalTextureSkinTangent(position,normal,textureCoordinate,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNormalTextureSkinTangent,'laya.d3.graphics.VertexPositionNormalTextureSkinTangent');
	var __proto=VertexPositionNormalTextureSkinTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSkinTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSkinTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSkinTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(76,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector4",7),
		new VertexElement(48,"vector4",6),
		new VertexElement(64,"vector3",5)]);}
	]);
	return VertexPositionNormalTextureSkinTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureSTangent
var VertexPositionNormalTextureSTangent=(function(){
	function VertexPositionNormalTextureSTangent(position,normal,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTextureSTangent,'laya.d3.graphics.VertexPositionNormalTextureSTangent');
	var __proto=VertexPositionNormalTextureSTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureSTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureSTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureSTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(48,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector4",5)]);}
	]);
	return VertexPositionNormalTextureSTangent;
})()


/**
*<code>VertexPositionNormalTextureTangent</code> 类用于创建位置、法线、纹理、切线顶点结构。
*/
//class laya.d3.graphics.VertexPositionNormalTextureTangent
var VertexPositionNormalTextureTangent=(function(){
	function VertexPositionNormalTextureTangent(position,normal,textureCoordinate,tangent){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._tangent=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
		this._tangent=tangent;
	}

	__class(VertexPositionNormalTextureTangent,'laya.d3.graphics.VertexPositionNormalTextureTangent');
	var __proto=VertexPositionNormalTextureTangent.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNormalTextureTangent._vertexDeclaration;
	});

	__getset(1,VertexPositionNormalTextureTangent,'vertexDeclaration',function(){
		return VertexPositionNormalTextureTangent._vertexDeclaration;
	});

	__static(VertexPositionNormalTextureTangent,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(44,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector3",5)]);}
	]);
	return VertexPositionNormalTextureTangent;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTexture
var VertexPositionNTBTexture=(function(){
	function VertexPositionNTBTexture(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNTBTexture,'laya.d3.graphics.VertexPositionNTBTexture');
	var __proto=VertexPositionNTBTexture.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTexture._vertexDeclaration;
	});

	__getset(1,VertexPositionNTBTexture,'vertexDeclaration',function(){
		return VertexPositionNTBTexture._vertexDeclaration;
	});

	__static(VertexPositionNTBTexture,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(56,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector3",5),
		new VertexElement(36,"vector3",4),
		new VertexElement(48,"vector2",2)]);}
	]);
	return VertexPositionNTBTexture;
})()


/**
*<code>VertexPositionNormalTextureSkin</code> 类用于创建位置、法线、纹理、骨骼索引、骨骼权重顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTexture0Texture1Skin
var VertexPositionNTBTexture0Texture1Skin=(function(){
	function VertexPositionNTBTexture0Texture1Skin(position,normal,binormal,textureCoordinate0,textureCoordinate1,tangent,blendIndex,blendWeight){
		this._position=null;
		this._normal=null;
		this._textureCoordinate0=null;
		this._textureCoordinate1=null;
		this._blendIndex=null;
		this._blendWeight=null;
		this._tangent=null;
		this.binormal=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate0=textureCoordinate0;
		this._textureCoordinate1=textureCoordinate1;
		this._tangent=tangent;
		binormal=binormal;
		this._blendIndex=blendIndex;
		this._blendWeight=blendWeight;
	}

	__class(VertexPositionNTBTexture0Texture1Skin,'laya.d3.graphics.VertexPositionNTBTexture0Texture1Skin');
	var __proto=VertexPositionNTBTexture0Texture1Skin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'tangent',function(){
		return this._tangent;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTexture0Texture1Skin._vertexDeclaration;
	});

	__getset(0,__proto,'textureCoordinate1',function(){
		return this._textureCoordinate1;
	});

	__getset(0,__proto,'blendIndex',function(){
		return this._blendIndex;
	});

	__getset(0,__proto,'blendWeight',function(){
		return this._blendWeight;
	});

	__getset(1,VertexPositionNTBTexture0Texture1Skin,'vertexDeclaration',function(){
		return VertexPositionNTBTexture0Texture1Skin._vertexDeclaration;
	});

	__static(VertexPositionNTBTexture0Texture1Skin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(96,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector3",5),
		new VertexElement(36,"vector3",4),
		new VertexElement(48,"vector2",2),
		new VertexElement(56,"vector2",15),
		new VertexElement(64,"vector4",7),
		new VertexElement(80,"vector4",6)]);}
	]);
	return VertexPositionNTBTexture0Texture1Skin;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、法线、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionNTBTextureSkin
var VertexPositionNTBTextureSkin=(function(){
	function VertexPositionNTBTextureSkin(position,normal,textureCoordinate){
		this._position=null;
		this._normal=null;
		this._textureCoordinate=null;
		this._position=position;
		this._normal=normal;
		this._textureCoordinate=textureCoordinate;
	}

	__class(VertexPositionNTBTextureSkin,'laya.d3.graphics.VertexPositionNTBTextureSkin');
	var __proto=VertexPositionNTBTextureSkin.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'textureCoordinate',function(){
		return this._textureCoordinate;
	});

	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionNTBTextureSkin._vertexDeclaration;
	});

	__getset(1,VertexPositionNTBTextureSkin,'vertexDeclaration',function(){
		return VertexPositionNTBTextureSkin._vertexDeclaration;
	});

	__static(VertexPositionNTBTextureSkin,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(88,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector3",5),
		new VertexElement(36,"vector3",4),
		new VertexElement(48,"vector2",2),
		new VertexElement(56,"vector4",7),
		new VertexElement(72,"vector4",6)]);}
	]);
	return VertexPositionNTBTextureSkin;
})()


/**
*<code>VertexPositionTerrain</code> 类用于创建位置、法线、纹理1、纹理2顶点结构。
*/
//class laya.d3.graphics.VertexPositionTerrain
var VertexPositionTerrain=(function(){
	function VertexPositionTerrain(position,normal,textureCoord0,textureCoord1){
		this._position=null;
		this._normal=null;
		this._textureCoord0=null;
		this._textureCoord1=null;
		this._position=position;
		this._normal=normal;
		this._textureCoord0=textureCoord0;
		this._textureCoord1=textureCoord1;
	}

	__class(VertexPositionTerrain,'laya.d3.graphics.VertexPositionTerrain');
	var __proto=VertexPositionTerrain.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoord0',function(){
		return this._textureCoord0;
	});

	__getset(0,__proto,'textureCoord1',function(){
		return this._textureCoord1;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	__getset(1,VertexPositionTerrain,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	__static(VertexPositionTerrain,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector3",3),
		new VertexElement(24,"vector2",2),
		new VertexElement(32,"vector2",15)]);}
	]);
	return VertexPositionTerrain;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、纹理顶点结构。
*/
//class laya.d3.graphics.VertexPositionTexture0
var VertexPositionTexture0=(function(){
	function VertexPositionTexture0(position,textureCoordinate0){
		this._position=null;
		this._textureCoordinate0=null;
		this._position=position;
		this._textureCoordinate0=textureCoordinate0;
	}

	__class(VertexPositionTexture0,'laya.d3.graphics.VertexPositionTexture0');
	var __proto=VertexPositionTexture0.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__getset(1,VertexPositionTexture0,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__static(VertexPositionTexture0,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(20,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector2",2)]);}
	]);
	return VertexPositionTexture0;
})()


/**
*<code>VertexShurikenParticle</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexShurikenParticleBillboard
var VertexShurikenParticleBillboard=(function(){
	function VertexShurikenParticleBillboard(cornerTextureCoordinate,positionStartLifeTime,velocity,startColor,startSize,startRotation0,startRotation1,startRotation2,ageAddScale,time,startSpeed,randoms0,randoms1,simulationWorldPostion){
		/**@private */
		this._cornerTextureCoordinate=null;
		/**@private */
		this._positionStartLifeTime=null;
		/**@private */
		this._velocity=null;
		/**@private */
		this._startColor=null;
		/**@private */
		this._startSize=null;
		/**@private */
		this._startRotation0=null;
		/**@private */
		this._startRotation1=null;
		/**@private */
		this._startRotation2=null;
		/**@private */
		this._startLifeTime=NaN;
		/**@private */
		this._time=NaN;
		/**@private */
		this._startSpeed=NaN;
		/**@private */
		this._randoms0=null;
		/**@private */
		this._randoms1=null;
		/**@private */
		this._simulationWorldPostion=null;
		this._cornerTextureCoordinate=cornerTextureCoordinate;
		this._positionStartLifeTime=positionStartLifeTime;
		this._velocity=velocity;
		this._startColor=startColor;
		this._startSize=startSize;
		this._startRotation0=startRotation0;
		this._startRotation1=startRotation1;
		this._startRotation2=startRotation2;
		this._startLifeTime=ageAddScale;
		this._time=time;
		this._startSpeed=startSpeed;
		this._randoms0=this.random0;
		this._randoms1=this.random1;
		this._simulationWorldPostion=simulationWorldPostion;
	}

	__class(VertexShurikenParticleBillboard,'laya.d3.graphics.VertexShurikenParticleBillboard');
	var __proto=VertexShurikenParticleBillboard.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'cornerTextureCoordinate',function(){
		return this._cornerTextureCoordinate;
	});

	__getset(0,__proto,'random1',function(){
		return this._randoms1;
	});

	__getset(0,__proto,'startRotation2',function(){
		return this._startRotation2;
	});

	__getset(0,__proto,'positionStartLifeTime',function(){
		return this._positionStartLifeTime;
	});

	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	__getset(0,__proto,'random0',function(){
		return this._randoms0;
	});

	__getset(0,__proto,'startSize',function(){
		return this._startSize;
	});

	__getset(0,__proto,'startColor',function(){
		return this._startColor;
	});

	__getset(0,__proto,'startRotation0',function(){
		return this._startRotation0;
	});

	__getset(0,__proto,'startRotation1',function(){
		return this._startRotation1;
	});

	__getset(0,__proto,'startLifeTime',function(){
		return this._startLifeTime;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'startSpeed',function(){
		return this._startSpeed;
	});

	__getset(0,__proto,'simulationWorldPostion',function(){
		return this._simulationWorldPostion;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexShurikenParticleBillboard._vertexDeclaration;
	});

	__getset(1,VertexShurikenParticleBillboard,'vertexDeclaration',function(){
		return VertexShurikenParticleBillboard._vertexDeclaration;
	});

	__static(VertexShurikenParticleBillboard,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(152,[
		new VertexElement(0,"vector4",17),
		new VertexElement(16,"vector4",30),
		new VertexElement(32,"vector4",32),
		new VertexElement(48,"vector4",19),
		new VertexElement(64,"vector3",20),
		new VertexElement(76,"vector3",22),
		new VertexElement(88,"single",31),
		new VertexElement(92,"vector4",34),
		new VertexElement(108,"vector4",35),
		new VertexElement(124,"vector3",36),
		new VertexElement(136,"vector4",37)]);}
	]);
	return VertexShurikenParticleBillboard;
})()


/**
*<code>VertexShurikenParticle</code> 类用于创建粒子顶点结构。
*/
//class laya.d3.graphics.VertexShurikenParticleMesh
var VertexShurikenParticleMesh=(function(){
	function VertexShurikenParticleMesh(cornerTextureCoordinate,positionStartLifeTime,velocity,startColor,startSize,startRotation0,startRotation1,startRotation2,ageAddScale,time,startSpeed,randoms0,randoms1,simulationWorldPostion){
		/**@private */
		this._cornerTextureCoordinate=null;
		/**@private */
		this._positionStartLifeTime=null;
		/**@private */
		this._velocity=null;
		/**@private */
		this._startColor=null;
		/**@private */
		this._startSize=null;
		/**@private */
		this._startRotation0=null;
		/**@private */
		this._startRotation1=null;
		/**@private */
		this._startRotation2=null;
		/**@private */
		this._startLifeTime=NaN;
		/**@private */
		this._time=NaN;
		/**@private */
		this._startSpeed=NaN;
		/**@private */
		this._randoms0=null;
		/**@private */
		this._randoms1=null;
		/**@private */
		this._simulationWorldPostion=null;
		this._cornerTextureCoordinate=cornerTextureCoordinate;
		this._positionStartLifeTime=positionStartLifeTime;
		this._velocity=velocity;
		this._startColor=startColor;
		this._startSize=startSize;
		this._startRotation0=startRotation0;
		this._startRotation1=startRotation1;
		this._startRotation2=startRotation2;
		this._startLifeTime=ageAddScale;
		this._time=time;
		this._startSpeed=startSpeed;
		this._randoms0=this.random0;
		this._randoms1=this.random1;
		this._simulationWorldPostion=simulationWorldPostion;
	}

	__class(VertexShurikenParticleMesh,'laya.d3.graphics.VertexShurikenParticleMesh');
	var __proto=VertexShurikenParticleMesh.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'cornerTextureCoordinate',function(){
		return this._cornerTextureCoordinate;
	});

	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	__getset(0,__proto,'position',function(){
		return this._positionStartLifeTime;
	});

	__getset(0,__proto,'random0',function(){
		return this._randoms0;
	});

	__getset(0,__proto,'startSize',function(){
		return this._startSize;
	});

	__getset(0,__proto,'startColor',function(){
		return this._startColor;
	});

	__getset(0,__proto,'startRotation0',function(){
		return this._startRotation0;
	});

	__getset(0,__proto,'startRotation1',function(){
		return this._startRotation1;
	});

	__getset(0,__proto,'random1',function(){
		return this._randoms1;
	});

	__getset(0,__proto,'startRotation2',function(){
		return this._startRotation2;
	});

	__getset(0,__proto,'startLifeTime',function(){
		return this._startLifeTime;
	});

	__getset(0,__proto,'time',function(){
		return this._time;
	});

	__getset(0,__proto,'startSpeed',function(){
		return this._startSpeed;
	});

	__getset(0,__proto,'simulationWorldPostion',function(){
		return this._simulationWorldPostion;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexShurikenParticleMesh._vertexDeclaration;
	});

	__getset(1,VertexShurikenParticleMesh,'vertexDeclaration',function(){
		return VertexShurikenParticleMesh._vertexDeclaration;
	});

	__static(VertexShurikenParticleMesh,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(172,[
		new VertexElement(0,"vector3",0),
		new VertexElement(12,"vector4",1),
		new VertexElement(28,"vector2",2),
		new VertexElement(36,"vector4",30),
		new VertexElement(52,"vector4",32),
		new VertexElement(68,"vector4",19),
		new VertexElement(84,"vector3",20),
		new VertexElement(96,"vector3",22),
		new VertexElement(108,"single",31),
		new VertexElement(112,"vector4",34),
		new VertexElement(128,"vector4",35),
		new VertexElement(144,"vector3",36),
		new VertexElement(156,"vector4",37)]);}
	]);
	return VertexShurikenParticleMesh;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV01
var LoadModelV01=(function(){
	function LoadModelV01(readData,version,mesh,materials,subMeshes,materialMap){
		/**@private */
		this._version=null;
		/**@private */
		this._strings=['BLOCK','DATA',"STRINGS"];
		/**@private */
		this._materials=null;
		/**@private */
		this._subMeshes=null;
		/**@private */
		this._materialMap=null;
		/**@private */
		this._readData=null;
		/**@private */
		this._mesh=null;
		/**@private */
		this._BLOCK={count:0};
		/**@private */
		this._DATA={offset:0,size:0};
		/**@private */
		this._STRINGS={offset:0,size:0};
		/**@private */
		this._shaderAttributes=null;
		this._mesh=mesh;
		this._materials=materials;
		this._subMeshes=subMeshes;
		this._materialMap=materialMap;
		this._version=version;
		this._onLoaded(readData);
	}

	__class(LoadModelV01,'laya.d3.loaders.LoadModelV01');
	var __proto=LoadModelV01.prototype;
	/**
	*@private
	*/
	__proto._onLoaded=function(readData){
		this._readData=readData;
		this.READ_BLOCK();
		for (var i=0;i < this._BLOCK.count;i++){
			var index=this._readData.getUint16();
			var blockName=this._strings[index];
			var fn=this["READ_"+blockName];
			if (fn==null)throw new Error("model file err,no this function:"+index+" "+blockName);
			if (!fn.call(this))break ;
		}
		return this._mesh;
	}

	__proto.onError=function(){}
	/**
	*@private
	*/
	__proto._readString=function(){
		return this._strings[this._readData.getUint16()];
	}

	__proto.READ_BLOCK=function(){
		var n=this._readData.getUint16();
		this._BLOCK.count=this._readData.getUint16();
		return true;
	}

	__proto.READ_DATA=function(){
		this._DATA.offset=this._readData.getUint32();
		this._DATA.size=this._readData.getUint32();
		return true;
	}

	__proto.READ_STRINGS=function(){
		this._STRINGS.offset=this._readData.getUint16();
		this._STRINGS.size=this._readData.getUint16();
		var ofs=this._readData.pos;
		this._readData.pos=this._STRINGS.offset+this._DATA.offset;
		for (var i=0;i < this._STRINGS.size;i++){
			this._strings[i]=this._readData.readUTFString();
		}
		this._readData.pos=ofs;
		return true;
	}

	__proto.READ_MATERIAL=function(){
		var i=0,n=0;
		var index=this._readData.getUint16();
		var shaderName=this._readString();
		var url=this._readString();
		if (url!=="null")
			this._materials[index]=Loader.getRes(this._materialMap[url]);
		else
		this._materials[index]=new BaseMaterial();
		return true;
	}

	__proto.READ_MESH=function(){
		var name=this._readString();
		switch (this._version){
			case "LAYAMODEL:01":
				console.log("Warning: The (.lm) file is converted by old fbxTools,please reConverted it use  lastest fbxTools version,later we will remove the  support of old version (.lm) support.");
				break ;
			case "LAYASKINANI:01":
			case "LAYAMODEL:02":;
				var arrayBuffer=this._readData.__getBuffer();
				var i=0,n=0;
				var bindPoseStart=this._readData.getUint32();
				var binPoseLength=this._readData.getUint32();
				var bindPoseDatas=new Float32Array(arrayBuffer.slice(bindPoseStart+this._DATA.offset,bindPoseStart+this._DATA.offset+binPoseLength));
				var inverseGlobalBindPoseStart=this._readData.getUint32();
				var inverseGlobalBinPoseLength=this._readData.getUint32();
				var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(inverseGlobalBindPoseStart+this._DATA.offset,inverseGlobalBindPoseStart+this._DATA.offset+inverseGlobalBinPoseLength));
				this.mesh._inverseBindPoses=[];
				for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
					var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
					this.mesh._inverseBindPoses.push(inverseGlobalBindPose);
				}
				break ;
			default :
				throw new Error("LoadModel:unknown version.");
			}
		return true;
	}

	__proto.READ_SUBMESH=function(){
		var className=this._readString();
		var material=this._readData.getUint8();
		var bufferAttribute=this._readString();
		this._shaderAttributes=bufferAttribute.match(LoadModelV01._attrReg);
		var ibofs=this._readData.getUint32();
		var ibsize=this._readData.getUint32();
		var vbIndicesofs=this._readData.getUint32();
		var vbIndicessize=this._readData.getUint32();
		var vbofs=this._readData.getUint32();
		var vbsize=this._readData.getUint32();
		var boneDicofs=this._readData.getUint32();
		var boneDicsize=this._readData.getUint32();
		var arrayBuffer=this._readData.__getBuffer();
		var submesh=new SubMesh(this._mesh);
		var vertexDeclaration=this._getVertexDeclaration();
		var vb=VertexBuffer3D.create(vertexDeclaration,vbsize / vertexDeclaration.vertexStride,0x88E4,true);
		var vbStart=vbofs+this._DATA.offset;
		var vbArrayBuffer=arrayBuffer.slice(vbStart,vbStart+vbsize);
		vb.setData(new Float32Array(vbArrayBuffer));
		submesh._vertexBuffer=vb;
		var vertexElements=vb.vertexDeclaration.getVertexElements();
		for (var i=0;i < vertexElements.length;i++)
		submesh._bufferUsage[(vertexElements [i]).elementUsage]=vb;
		var ib=IndexBuffer3D.create("ushort",ibsize / 2,0x88E4,true);
		var ibStart=ibofs+this._DATA.offset;
		var ibArrayBuffer=arrayBuffer.slice(ibStart,ibStart+ibsize);
		ib.setData(new Uint16Array(ibArrayBuffer));
		submesh._indexBuffer=ib;
		var boneDicArrayBuffer=arrayBuffer.slice(boneDicofs+this._DATA.offset,boneDicofs+this._DATA.offset+boneDicsize);
		submesh._boneIndicesList[0]=new Uint8Array(boneDicArrayBuffer);
		this._subMeshes.push(submesh);
		return true;
	}

	__proto.READ_DATAAREA=function(){
		return false;
	}

	__proto._getVertexDeclaration=function(){
		var position=false,normal=false,color=false,texcoord0=false,texcoord1=false,tangent=false,blendWeight=false,blendIndex=false;
		var binormal=false;
		for (var i=0;i < this._shaderAttributes.length;i+=8){
			switch (this._shaderAttributes[i]){
				case "POSITION":
					position=true;
					break ;
				case "NORMAL":
					normal=true;
					break ;
				case "COLOR":
					color=true;
					break ;
				case "UV":
					texcoord0=true;
					break ;
				case "UV1":
					texcoord1=true;
					break ;
				case "BLENDWEIGHT":
					blendWeight=true;
					break ;
				case "BLENDINDICES":
					blendIndex=true;
					break ;
				case "TANGENT":
					tangent=true;
					break ;
				case "BINORMAL":
					binormal=true;
					break ;
				}
		};
		var vertexDeclaration;
		if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
			vertexDeclaration=VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureSkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTextureSkin.vertexDeclaration;
		else if (position && normal && tangent && binormal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNTBTextureSkin.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTextureSkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTextureSkin.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorSkinTangent.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorSkin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalTexture0Texture1.vertexDeclaration;
		else if (position && normal && color && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent && binormal)
		vertexDeclaration=VertexPositionNTBTexture.vertexDeclaration;
		else if (position && normal && color && texcoord0)
		vertexDeclaration=VertexPositionNormalColorTexture.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0)
		vertexDeclaration=VertexPositionNormalTexture.vertexDeclaration;
		else if (position && normal && color && tangent)
		vertexDeclaration=VertexPositionNormalColorTangent.vertexDeclaration;
		else if (position && normal && color)
		vertexDeclaration=VertexPositionNormalColor.vertexDeclaration;
		return vertexDeclaration;
	}

	__getset(0,__proto,'mesh',function(){
		return this._mesh;
	});

	__static(LoadModelV01,
	['_attrReg',function(){return this._attrReg=new RegExp("(\\w+)|([:,;])","g");}
	]);
	return LoadModelV01;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV02
var LoadModelV02=(function(){
	function LoadModelV02(){}
	__class(LoadModelV02,'laya.d3.loaders.LoadModelV02');
	LoadModelV02.parse=function(readData,version,mesh,materials,subMeshes,materialMap){
		LoadModelV02._mesh=mesh;
		LoadModelV02._materials=materials;
		LoadModelV02._subMeshes=subMeshes;
		LoadModelV02._materialMap=materialMap;
		LoadModelV02._version=version;
		LoadModelV02._readData=readData;
		LoadModelV02.READ_DATA();
		LoadModelV02.READ_BLOCK();
		LoadModelV02.READ_STRINGS();
		for (var i=0,n=LoadModelV02._BLOCK.count;i < n;i++){
			LoadModelV02._readData.pos=LoadModelV02._BLOCK.blockStarts[i];
			var index=LoadModelV02._readData.getUint16();
			var blockName=LoadModelV02._strings[index];
			var fn=LoadModelV02["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
		LoadModelV02._strings.length=0;
		LoadModelV02._readData=null;
		LoadModelV02._version=null;
		LoadModelV02._mesh=null;
		LoadModelV02._materials=null;
		LoadModelV02._subMeshes=null;
		LoadModelV02._materialMap=null;
	}

	LoadModelV02._readString=function(){
		return LoadModelV02._strings[LoadModelV02._readData.getUint16()];
	}

	LoadModelV02.READ_DATA=function(){
		LoadModelV02._DATA.offset=LoadModelV02._readData.getUint32();
		LoadModelV02._DATA.size=LoadModelV02._readData.getUint32();
	}

	LoadModelV02.READ_BLOCK=function(){
		var count=LoadModelV02._BLOCK.count=LoadModelV02._readData.getUint16();
		var blockStarts=LoadModelV02._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV02._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV02._readData.getUint32());
			blockLengths.push(LoadModelV02._readData.getUint32());
		}
	}

	LoadModelV02.READ_STRINGS=function(){
		var offset=LoadModelV02._readData.getUint32();
		var count=LoadModelV02._readData.getUint16();
		var prePos=LoadModelV02._readData.pos;
		LoadModelV02._readData.pos=offset+LoadModelV02._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV02._strings[i]=LoadModelV02._readData.readUTFString();
		LoadModelV02._readData.pos=prePos;
	}

	LoadModelV02.READ_MATERIAL=function(){
		var i=0,n=0;
		var clasName=LoadModelV02._readString();
		var shaderName=LoadModelV02._readString();
		var url=LoadModelV02._readString();
		if (url!=="")
			LoadModelV02._materials.push(Loader.getRes(LoadModelV02._materialMap[url]));
		return true;
	}

	LoadModelV02.READ_MESH=function(){
		var name=LoadModelV02._readString();
		var arrayBuffer=LoadModelV02._readData.__getBuffer();
		var i=0,n=0;
		var vertexBufferCount=LoadModelV02._readData.getInt16();
		var offset=LoadModelV02._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV02._readData.getUint32();
			var vbLength=LoadModelV02._readData.getUint32();
			var vbDatas=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vbLength));
			var bufferAttribute=LoadModelV02._readString();
			var shaderAttributes=bufferAttribute.match(LoadModelV02._attrReg);
			var vertexDeclaration=LoadModelV02._getVertexDeclaration(shaderAttributes);
			var vertexBuffer=VertexBuffer3D.create(vertexDeclaration,(vbDatas.length *4)/ vertexDeclaration.vertexStride,0x88E4,true);
			vertexBuffer.setData(vbDatas);
			LoadModelV02._mesh._vertexBuffers.push(vertexBuffer);
		};
		var ibStart=offset+LoadModelV02._readData.getUint32();
		var ibLength=LoadModelV02._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=IndexBuffer3D.create("ushort",ibLength / 2,0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV02._mesh._indexBuffer=indexBuffer;
		var boneNames=LoadModelV02._mesh._boneNames=[];
		var boneCount=LoadModelV02._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV02._strings[LoadModelV02._readData.getUint16()];
		var bindPoseStart=LoadModelV02._readData.getUint32();
		var binPoseLength=LoadModelV02._readData.getUint32();
		var bindPoseDatas=new Float32Array(arrayBuffer.slice(offset+bindPoseStart,offset+bindPoseStart+binPoseLength));
		var inverseGlobalBindPoseStart=LoadModelV02._readData.getUint32();
		var inverseGlobalBinPoseLength=LoadModelV02._readData.getUint32();
		var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(offset+inverseGlobalBindPoseStart,offset+inverseGlobalBindPoseStart+inverseGlobalBinPoseLength));
		LoadModelV02._mesh._inverseBindPoses=[];
		for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
			LoadModelV02._mesh._inverseBindPoses.push(inverseGlobalBindPose);
		}
		LoadModelV02._mesh._skinnedDatas=new Float32Array(invGloBindPoseDatas.length*16);
		return true;
	}

	LoadModelV02.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV02._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV02._mesh);
		var vbIndex=LoadModelV02._readData.getInt16();
		var vbStart=LoadModelV02._readData.getUint32();
		var vbLength=LoadModelV02._readData.getUint32();
		submesh._vertexBuffer=LoadModelV02._mesh._vertexBuffers[vbIndex];
		submesh._vertexStart=vbStart;
		submesh._vertexCount=vbLength;
		var ibStart=LoadModelV02._readData.getUint32();
		var ibCount=LoadModelV02._readData.getUint32();
		var indexBuffer=LoadModelV02._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var offset=LoadModelV02._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV02._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV02._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV02._readData.getUint32();
			var boneDicofs=LoadModelV02._readData.getUint32();
			var boneDicsize=LoadModelV02._readData.getUint32();
			submesh._boneIndicesList[i]=new Uint8Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicsize));
		}
		LoadModelV02._subMeshes.push(submesh);
		return true;
	}

	LoadModelV02._getVertexDeclaration=function(shaderAttributes){
		var position=false,normal=false,color=false,texcoord0=false,texcoord1=false,tangent=false,blendWeight=false,blendIndex=false;
		var binormal=false;
		for (var i=0;i < shaderAttributes.length;i++){
			switch (shaderAttributes[i]){
				case "POSITION":
					position=true;
					break ;
				case "NORMAL":
					normal=true;
					break ;
				case "COLOR":
					color=true;
					break ;
				case "UV":
					texcoord0=true;
					break ;
				case "UV1":
					texcoord1=true;
					break ;
				case "BLENDWEIGHT":
					blendWeight=true;
					break ;
				case "BLENDINDICES":
					blendIndex=true;
					break ;
				case "TANGENT":
					tangent=true;
					break ;
				case "BINORMAL":
					binormal=true;
					break ;
				}
		};
		var vertexDeclaration;
		if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
			vertexDeclaration=VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Skin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureSkinTangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorTextureSkin.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalTextureSkinTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalTextureSkin.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex && tangent)
		vertexDeclaration=VertexPositionNormalColorSkinTangent.vertexDeclaration;
		else if (position && normal && color && blendWeight && blendIndex)
		vertexDeclaration=VertexPositionNormalColorSkin.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && color && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalColorTexture0Texture1.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1 && tangent)
		vertexDeclaration=VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration;
		else if (position && normal && texcoord0 && texcoord1)
		vertexDeclaration=VertexPositionNormalTexture0Texture1.vertexDeclaration;
		else if (position && normal && color && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalColorTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent && binormal)
		vertexDeclaration=VertexPositionNTBTexture.vertexDeclaration;
		else if (position && normal && color && texcoord0)
		vertexDeclaration=VertexPositionNormalColorTexture.vertexDeclaration;
		else if (position && normal && texcoord0 && tangent)
		vertexDeclaration=VertexPositionNormalTextureTangent.vertexDeclaration;
		else if (position && normal && texcoord0)
		vertexDeclaration=VertexPositionNormalTexture.vertexDeclaration;
		else if (position && normal && color && tangent)
		vertexDeclaration=VertexPositionNormalColorTangent.vertexDeclaration;
		else if (position && normal && color)
		vertexDeclaration=VertexPositionNormalColor.vertexDeclaration;
		return vertexDeclaration;
	}

	LoadModelV02._strings=[];
	LoadModelV02._readData=null;
	LoadModelV02._version=null;
	LoadModelV02._mesh=null;
	LoadModelV02._materials=null;
	LoadModelV02._subMeshes=null;
	LoadModelV02._materialMap=null;
	__static(LoadModelV02,
	['_attrReg',function(){return this._attrReg=new RegExp("(\\w+)|([:,;])","g");},'_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV02;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV03
var LoadModelV03=(function(){
	function LoadModelV03(){}
	__class(LoadModelV03,'laya.d3.loaders.LoadModelV03');
	LoadModelV03.parse=function(readData,version,mesh,subMeshes,materialMap){
		LoadModelV03._mesh=mesh;
		LoadModelV03._subMeshes=subMeshes;
		LoadModelV03._materialMap=materialMap;
		LoadModelV03._version=version;
		LoadModelV03._readData=readData;
		LoadModelV03.READ_DATA();
		LoadModelV03.READ_BLOCK();
		LoadModelV03.READ_STRINGS();
		for (var i=0,n=LoadModelV03._BLOCK.count;i < n;i++){
			LoadModelV03._readData.pos=LoadModelV03._BLOCK.blockStarts[i];
			var index=LoadModelV03._readData.getUint16();
			var blockName=LoadModelV03._strings[index];
			var fn=LoadModelV03["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call();
		}
		LoadModelV03._strings.length=0;
		LoadModelV03._readData=null;
		LoadModelV03._version=null;
		LoadModelV03._mesh=null;
		LoadModelV03._subMeshes=null;
		LoadModelV03._materialMap=null;
	}

	LoadModelV03._readString=function(){
		return LoadModelV03._strings[LoadModelV03._readData.getUint16()];
	}

	LoadModelV03.READ_DATA=function(){
		LoadModelV03._DATA.offset=LoadModelV03._readData.getUint32();
		LoadModelV03._DATA.size=LoadModelV03._readData.getUint32();
	}

	LoadModelV03.READ_BLOCK=function(){
		var count=LoadModelV03._BLOCK.count=LoadModelV03._readData.getUint16();
		var blockStarts=LoadModelV03._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV03._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV03._readData.getUint32());
			blockLengths.push(LoadModelV03._readData.getUint32());
		}
	}

	LoadModelV03.READ_STRINGS=function(){
		var offset=LoadModelV03._readData.getUint32();
		var count=LoadModelV03._readData.getUint16();
		var prePos=LoadModelV03._readData.pos;
		LoadModelV03._readData.pos=offset+LoadModelV03._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV03._strings[i]=LoadModelV03._readData.readUTFString();
		LoadModelV03._readData.pos=prePos;
	}

	LoadModelV03.READ_MESH=function(){
		var name=LoadModelV03._readString();
		var arrayBuffer=LoadModelV03._readData.__getBuffer();
		var i=0,n=0;
		var vertexBufferCount=LoadModelV03._readData.getInt16();
		var offset=LoadModelV03._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV03._readData.getUint32();
			var vbLength=LoadModelV03._readData.getUint32();
			var vbDatas=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vbLength));
			var bufferAttribute=LoadModelV03._readString();
			var vertexDeclaration;
			switch(LoadModelV03._version){
				case "LAYAMODEL:03":
					vertexDeclaration=LoadModelV03._vertexDeclarationMap_Discard[bufferAttribute];
					break ;
				case "LAYAMODEL:0301":
					vertexDeclaration=LoadModelV03._vertexDeclarationMap[bufferAttribute];
					break ;
				default :
					throw new Error("LoadModelV03: unknown version.");
				}
			if (!vertexDeclaration)
				throw new Error("LoadModelV03: unknown vertexDeclaration.");
			var vertexBuffer=VertexBuffer3D.create(vertexDeclaration,(vbDatas.length *4)/ vertexDeclaration.vertexStride,0x88E4,true);
			vertexBuffer.setData(vbDatas);
			LoadModelV03._mesh._vertexBuffers.push(vertexBuffer);
		};
		var ibStart=offset+LoadModelV03._readData.getUint32();
		var ibLength=LoadModelV03._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=IndexBuffer3D.create("ushort",ibLength / 2,0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV03._mesh._indexBuffer=indexBuffer;
		var boneNames=LoadModelV03._mesh._boneNames=[];
		var boneCount=LoadModelV03._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV03._strings[LoadModelV03._readData.getUint16()];
		LoadModelV03._readData.pos+=8;
		var inverseGlobalBindPoseStart=LoadModelV03._readData.getUint32();
		var inverseGlobalBinPoseLength=LoadModelV03._readData.getUint32();
		var invGloBindPoseDatas=new Float32Array(arrayBuffer.slice(offset+inverseGlobalBindPoseStart,offset+inverseGlobalBindPoseStart+inverseGlobalBinPoseLength));
		LoadModelV03._mesh._inverseBindPoses=[];
		for (i=0,n=invGloBindPoseDatas.length;i < n;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(invGloBindPoseDatas[i+0],invGloBindPoseDatas[i+1],invGloBindPoseDatas[i+2],invGloBindPoseDatas[i+3],invGloBindPoseDatas[i+4],invGloBindPoseDatas[i+5],invGloBindPoseDatas[i+6],invGloBindPoseDatas[i+7],invGloBindPoseDatas[i+8],invGloBindPoseDatas[i+9],invGloBindPoseDatas[i+10],invGloBindPoseDatas[i+11],invGloBindPoseDatas[i+12],invGloBindPoseDatas[i+13],invGloBindPoseDatas[i+14],invGloBindPoseDatas[i+15]);
			LoadModelV03._mesh._inverseBindPoses.push(inverseGlobalBindPose);
		}
		LoadModelV03._mesh._skinnedDatas=new Float32Array(invGloBindPoseDatas.length*16);
		return true;
	}

	LoadModelV03.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV03._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV03._mesh);
		var vbIndex=LoadModelV03._readData.getInt16();
		var vbStart=LoadModelV03._readData.getUint32();
		var vbLength=LoadModelV03._readData.getUint32();
		submesh._vertexBuffer=LoadModelV03._mesh._vertexBuffers[vbIndex];
		submesh._vertexStart=vbStart;
		submesh._vertexCount=vbLength;
		var ibStart=LoadModelV03._readData.getUint32();
		var ibCount=LoadModelV03._readData.getUint32();
		var indexBuffer=LoadModelV03._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var offset=LoadModelV03._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV03._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV03._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV03._readData.getUint32();
			var boneDicofs=LoadModelV03._readData.getUint32();
			var boneDicsize=LoadModelV03._readData.getUint32();
			boneIndicesList[i]=new Uint8Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicsize));
		}
		LoadModelV03._subMeshes.push(submesh);
		return true;
	}

	LoadModelV03._strings=[];
	LoadModelV03._readData=null;
	LoadModelV03._version=null;
	LoadModelV03._mesh=null;
	LoadModelV03._subMeshes=null;
	LoadModelV03._materialMap=null;
	__static(LoadModelV03,
	['_vertexDeclarationMap_Discard',function(){return this._vertexDeclarationMap_Discard={
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTexture0Texture1SkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,TANGENT,BINORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,":VertexPositionNTBTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTexture0Texture1SkinTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTextureSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTextureSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorSkinTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,TANGENT":VertexPositionNormalColorTexture0Texture1Tangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1":VertexPositionNormalColorTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,TANGENT":VertexPositionNormalTexture0Texture1Tangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1":VertexPositionNormalTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,TANGENT":VertexPositionNormalColorTextureTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT,BINORMAL":VertexPositionNTBTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV":VertexPositionNormalColorTexture.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT":VertexPositionNormalTextureTangent.vertexDeclaration,
			"POSITION,NORMAL,UV":VertexPositionNormalTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,TANGENT":VertexPositionNormalColorTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR":VertexPositionNormalColor.vertexDeclaration,
			"POSITION,NORMAL,TANGENT":VertexPositionNormalTangent.vertexDeclaration,
			"POSITION,NORMAL":VertexPositionNormal.vertexDeclaration,
			"POSITION,UV":VertexPositionTexture0.vertexDeclaration,
			"POSITION":VertexPosition.vertexDeclaration};},'_vertexDeclarationMap',function(){return this._vertexDeclarationMap={
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTexture0Texture1SkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,TANGENT,BINORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,":VertexPositionNTBTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTexture0Texture1SkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTexture0Texture1Skin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorTextureSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalTextureSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalTextureSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES,TANGENT":VertexPositionNormalColorSkinSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,BLENDWEIGHT,BLENDINDICES":VertexPositionNormalColorSkin.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1,TANGENT":VertexPositionNormalColorTexture0Texture1STangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,UV1":VertexPositionNormalColorTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1,TANGENT":VertexPositionNormalTexture0Texture1STangent.vertexDeclaration,
			"POSITION,NORMAL,UV,UV1":VertexPositionNormalTexture0Texture1.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV,TANGENT":VertexPositionNormalColorTextureSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT,BINORMAL":VertexPositionNTBTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,UV":VertexPositionNormalColorTexture.vertexDeclaration,
			"POSITION,NORMAL,UV,TANGENT":VertexPositionNormalTextureSTangent.vertexDeclaration,
			"POSITION,NORMAL,UV":VertexPositionNormalTexture.vertexDeclaration,
			"POSITION,NORMAL,COLOR,TANGENT":VertexPositionNormalColorSTangent.vertexDeclaration,
			"POSITION,NORMAL,COLOR":VertexPositionNormalColor.vertexDeclaration,
			"POSITION,NORMAL,TANGENT":VertexPositionNormalSTangent.vertexDeclaration,
			"POSITION,NORMAL":VertexPositionNormal.vertexDeclaration,
			"POSITION,UV":VertexPositionTexture0.vertexDeclaration,
			"POSITION":VertexPosition.vertexDeclaration};},'_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV03;
})()


/**
*...
*@author ...
*/
//class laya.d3.loaders.MeshReader
var MeshReader=(function(){
	function MeshReader(){}
	__class(MeshReader,'laya.d3.loaders.MeshReader');
	MeshReader.read=function(data,mesh,materials,subMeshes,materialMap){
		var readData=new Byte(data);
		readData.pos=0;
		var version=readData.readUTFString();
		switch (version){
			case "LAYAMODEL:01":
			case "LAYASKINANI:01":
				MeshReader._readVersion01(readData,version,mesh,materials,subMeshes,materialMap);
				break ;
			case "LAYAMODEL:02":
				LoadModelV02.parse(readData,version,mesh,materials,subMeshes,materialMap);
				break ;
			case "LAYAMODEL:03":
			case "LAYAMODEL:0301":
				LoadModelV03.parse(readData,version,mesh,subMeshes,materialMap);
				break ;
			default :
				throw new Error("MeshReader: unknown mesh version.");
			}
		mesh._setSubMeshes(subMeshes);
	}

	MeshReader._readVersion01=function(readData,version,mesh,materials,subMeshes,materialMap){
		new LoadModelV01(readData,version,mesh,materials,subMeshes,materialMap);
	}

	return MeshReader;
})()


/**
*<code>BoundBox</code> 类用于创建包围盒。
*/
//class laya.d3.math.BoundBox
var BoundBox=(function(){
	function BoundBox(min,max){
		/**最小顶点。*/
		this.min=null;
		/**最大顶点。*/
		this.max=null;
		this.min=min;
		this.max=max;
	}

	__class(BoundBox,'laya.d3.math.BoundBox');
	var __proto=BoundBox.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*获取包围盒的8个角顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		corners.length=8;
		var mine=this.min.elements;
		var maxe=this.max.elements;
		var minX=mine[0];
		var minY=mine[1];
		var minZ=mine[2];
		var maxX=maxe[0];
		var maxY=maxe[1];
		var maxZ=maxe[2];
		corners[0]=new Vector3(minX,maxY,maxZ);
		corners[1]=new Vector3(maxX,maxY,maxZ);
		corners[2]=new Vector3(maxX,minY,maxZ);
		corners[3]=new Vector3(minX,minY,maxZ);
		corners[4]=new Vector3(minX,maxY,minZ);
		corners[5]=new Vector3(maxX,maxY,minZ);
		corners[6]=new Vector3(maxX,minY,minZ);
		corners[7]=new Vector3(minX,minY,minZ);
	}

	__proto.toDefault=function(){
		this.min.toDefault();
		this.max.toDefault();
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.min.cloneTo(dest.min);
		this.max.cloneTo(dest.max);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundBox.createfromPoints=function(points,out){
		if (points==null)
			throw new Error("points");
		var min=out.min;
		var max=out.max;
		var minE=min.elements;
		minE[0]=Number.MAX_VALUE;
		minE[1]=Number.MAX_VALUE;
		minE[2]=Number.MAX_VALUE;
		var maxE=max.elements;
		maxE[0]=-Number.MAX_VALUE;
		maxE[1]=-Number.MAX_VALUE;
		maxE[2]=-Number.MAX_VALUE;
		for (var i=0,n=points.length;i < n;++i){
			Vector3.min(min,points[i],min);
			Vector3.max(max,points[i],max);
		}
	}

	BoundBox.merge=function(box1,box2,out){
		Vector3.min(box1.min,box2.min,out.min);
		Vector3.max(box1.max,box2.max,out.max);
	}

	return BoundBox;
})()


/**
*<code>BoundFrustum</code> 类用于创建锥截体。
*/
//class laya.d3.math.BoundFrustum
var BoundFrustum=(function(){
	function BoundFrustum(matrix){
		/**4x4矩阵*/
		this._matrix=null;
		/**近平面*/
		this._near=null;
		/**远平面*/
		this._far=null;
		/**左平面*/
		this._left=null;
		/**右平面*/
		this._right=null;
		/**顶平面*/
		this._top=null;
		/**底平面*/
		this._bottom=null;
		this._matrix=matrix;
		this._near=new Plane(new Vector3());
		this._far=new Plane(new Vector3());
		this._left=new Plane(new Vector3());
		this._right=new Plane(new Vector3());
		this._top=new Plane(new Vector3());
		this._bottom=new Plane(new Vector3());
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	}

	__class(BoundFrustum,'laya.d3.math.BoundFrustum');
	var __proto=BoundFrustum.prototype;
	/**
	*判断是否与其他锥截体相等。
	*@param other 锥截体。
	*/
	__proto.equalsBoundFrustum=function(other){
		return this._matrix.equalsOtherMatrix(other.matrix)
	}

	/**
	*判断是否与其他对象相等。
	*@param obj 对象。
	*/
	__proto.equalsObj=function(obj){
		if ((obj instanceof laya.d3.math.BoundFrustum )){
			var bf=obj;
			return this.equalsBoundFrustum(bf);
		}
		return false;
	}

	/**
	*获取锥截体的任意一平面。
	*0:近平面
	*1:远平面
	*2:左平面
	*3:右平面
	*4:顶平面
	*5:底平面
	*@param index 索引。
	*/
	__proto.getPlane=function(index){
		switch (index){
			case 0:
				return this._near;
			case 1:
				return this._far;
			case 2:
				return this._left;
			case 3:
				return this._right;
			case 4:
				return this._top;
			case 5:
				return this._bottom;
			default :
				return null;
			}
	}

	/**
	*锥截体的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._right).cloneTo(corners[0]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._right).cloneTo(corners[1]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._left).cloneTo(corners[2]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._left).cloneTo(corners[3]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._right).cloneTo(corners[4]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._right).cloneTo(corners[5]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._left).cloneTo(corners[6]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._left).cloneTo(corners[7]);
	}

	/**
	*与点的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param point 点。
	*/
	__proto.containsPoint=function(point){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=Collision.intersectsPlaneAndPoint(this._near,point);
					break ;
				case 1:
					planeResult=Collision.intersectsPlaneAndPoint(this._far,point);
					break ;
				case 2:
					planeResult=Collision.intersectsPlaneAndPoint(this._left,point);
					break ;
				case 3:
					planeResult=Collision.intersectsPlaneAndPoint(this._right,point);
					break ;
				case 4:
					planeResult=Collision.intersectsPlaneAndPoint(this._top,point);
					break ;
				case 5:
					planeResult=Collision.intersectsPlaneAndPoint(this._bottom,point);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return 0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return 2;
			default :
				return 1;
			}
	}

	/**
	*与包围盒的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param box 包围盒。
	*/
	__proto.containsBoundBox=function(box){
		var p=BoundFrustum._tempV30,n=BoundFrustum._tempV31;
		var plane;
		var result=1;
		for (var i=0;i < 6;i++){
			plane=this.getPlane(i);
			this._getBoxToPlanePVertexNVertex(box,plane.normal,p,n);
			if (Collision.intersectsPlaneAndPoint(plane,p)===Plane.PlaneIntersectionType_Back)
				return 0;
			if (Collision.intersectsPlaneAndPoint(plane,n)===Plane.PlaneIntersectionType_Back)
				result=2;
		}
		return result;
	}

	/**
	*与包围球的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param sphere 包围球。
	*/
	__proto.containsBoundSphere=function(sphere){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=Collision.intersectsPlaneAndSphere(this._near,sphere);
					break ;
				case 1:
					planeResult=Collision.intersectsPlaneAndSphere(this._far,sphere);
					break ;
				case 2:
					planeResult=Collision.intersectsPlaneAndSphere(this._left,sphere);
					break ;
				case 3:
					planeResult=Collision.intersectsPlaneAndSphere(this._right,sphere);
					break ;
				case 4:
					planeResult=Collision.intersectsPlaneAndSphere(this._top,sphere);
					break ;
				case 5:
					planeResult=Collision.intersectsPlaneAndSphere(this._bottom,sphere);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return 0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return 2;
			default :
				return 1;
			}
	}

	/**
	*@private
	*/
	__proto._getBoxToPlanePVertexNVertex=function(box,planeNormal,outP,outN){
		var boxMin=box.min;
		var boxMinE=boxMin.elements;
		var boxMax=box.max;
		var boxMaxE=boxMax.elements;
		var planeNorE=planeNormal.elements;
		var planeNorEX=planeNorE[0];
		var planeNorEY=planeNorE[1];
		var planeNorEZ=planeNorE[2];
		boxMin.cloneTo(outP);;
		var outPE=outP.elements;
		if (planeNorEX >=0)
			outPE[0]=boxMaxE[0];
		if (planeNorEY >=0)
			outPE[1]=boxMaxE[1];
		if (planeNorEZ >=0)
			outPE[2]=boxMaxE[2];
		boxMax.cloneTo(outN);
		var outNE=outN.elements;
		if (planeNorEX >=0)
			outNE[0]=boxMinE[0];
		if (planeNorEY >=0)
			outNE[1]=boxMinE[1];
		if (planeNorEZ >=0)
			outNE[2]=boxMinE[2];
	}

	/**
	*获取顶平面。
	*@return 顶平面。
	*/
	__getset(0,__proto,'top',function(){
		return this._top;
	});

	/**
	*设置描述矩阵。
	*@param matrix 描述矩阵。
	*/
	/**
	*获取描述矩阵。
	*@return 描述矩阵。
	*/
	__getset(0,__proto,'matrix',function(){
		return this._matrix;
		},function(matrix){
		this._matrix=matrix;
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	});

	/**
	*获取近平面。
	*@return 近平面。
	*/
	__getset(0,__proto,'near',function(){
		return this._near;
	});

	/**
	*获取远平面。
	*@return 远平面。
	*/
	__getset(0,__proto,'far',function(){
		return this._far;
	});

	/**
	*获取左平面。
	*@return 左平面。
	*/
	__getset(0,__proto,'left',function(){
		return this._left;
	});

	/**
	*获取右平面。
	*@return 右平面。
	*/
	__getset(0,__proto,'right',function(){
		return this._right;
	});

	/**
	*获取底平面。
	*@return 底平面。
	*/
	__getset(0,__proto,'bottom',function(){
		return this._bottom;
	});

	BoundFrustum._getPlanesFromMatrix=function(m,np,fp,lp,rp,tp,bp){
		var matrixE=m.elements;
		var m11=matrixE[0];
		var m12=matrixE[1];
		var m13=matrixE[2];
		var m14=matrixE[3];
		var m21=matrixE[4];
		var m22=matrixE[5];
		var m23=matrixE[6];
		var m24=matrixE[7];
		var m31=matrixE[8];
		var m32=matrixE[9];
		var m33=matrixE[10];
		var m34=matrixE[11];
		var m41=matrixE[12];
		var m42=matrixE[13];
		var m43=matrixE[14];
		var m44=matrixE[15];
		var nearNorE=np.normal.elements;
		nearNorE[0]=m14+m13;
		nearNorE[1]=m24+m23;
		nearNorE[2]=m34+m33;
		np.distance=m44+m43;
		np.normalize();
		var farNorE=fp.normal.elements;
		farNorE[0]=m14-m13;
		farNorE[1]=m24-m23;
		farNorE[2]=m34-m33;
		fp.distance=m44-m43;
		fp.normalize();
		var leftNorE=lp.normal.elements;
		leftNorE[0]=m14+m11;
		leftNorE[1]=m24+m21;
		leftNorE[2]=m34+m31;
		lp.distance=m44+m41;
		lp.normalize();
		var rightNorE=rp.normal.elements;
		rightNorE[0]=m14-m11;
		rightNorE[1]=m24-m21;
		rightNorE[2]=m34-m31;
		rp.distance=m44-m41;
		rp.normalize();
		var topNorE=tp.normal.elements;
		topNorE[0]=m14-m12;
		topNorE[1]=m24-m22;
		topNorE[2]=m34-m32;
		tp.distance=m44-m42;
		tp.normalize();
		var bottomNorE=bp.normal.elements;
		bottomNorE[0]=m14+m12;
		bottomNorE[1]=m24+m22;
		bottomNorE[2]=m34+m32;
		bp.distance=m44+m42;
		bp.normalize();
	}

	BoundFrustum._get3PlaneInterPoint=function(p1,p2,p3){
		var p1Nor=p1.normal;
		var p2Nor=p2.normal;
		var p3Nor=p3.normal;
		Vector3.cross(p2Nor,p3Nor,BoundFrustum._tempV30);
		Vector3.cross(p3Nor,p1Nor,BoundFrustum._tempV31);
		Vector3.cross(p1Nor,p2Nor,BoundFrustum._tempV32);
		var a=Vector3.dot(p1Nor,BoundFrustum._tempV30);
		var b=Vector3.dot(p2Nor,BoundFrustum._tempV31);
		var c=Vector3.dot(p3Nor,BoundFrustum._tempV32);
		Vector3.scale(BoundFrustum._tempV30,-p1.distance / a,BoundFrustum._tempV33);
		Vector3.scale(BoundFrustum._tempV31,-p2.distance / b,BoundFrustum._tempV34);
		Vector3.scale(BoundFrustum._tempV32,-p3.distance / c,BoundFrustum._tempV35);
		Vector3.add(BoundFrustum._tempV33,BoundFrustum._tempV34,BoundFrustum._tempV36);
		Vector3.add(BoundFrustum._tempV35,BoundFrustum._tempV36,BoundFrustum._tempV37);
		var v=BoundFrustum._tempV37;
		return v;
	}

	__static(BoundFrustum,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempV37',function(){return this._tempV37=new Vector3();}
	]);
	return BoundFrustum;
})()


/**
*<code>BoundSphere</code> 类用于创建包围球。
*/
//class laya.d3.math.BoundSphere
var BoundSphere=(function(){
	function BoundSphere(center,radius){
		/**包围球的中心。*/
		this.center=null;
		/**包围球的半径。*/
		this.radius=NaN;
		this.center=center;
		this.radius=radius;
	}

	__class(BoundSphere,'laya.d3.math.BoundSphere');
	var __proto=BoundSphere.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.toDefault=function(){
		this.center.toDefault();
		this.radius=0;
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉距离。
	*@param ray 射线。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayDistance=function(ray){
		return Collision.intersectsRayAndSphereRD(ray,this);
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉点。
	*@param ray 射线。
	*@param outPoint 交叉点。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayPoint=function(ray,outPoint){
		return Collision.intersectsRayAndSphereRP(ray,this,outPoint);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.center.cloneTo(dest.center);
		dest.radius=this.radius;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundSphere.createFromSubPoints=function(points,start,count,out){
		if (points==null){
			throw new Error("points");
		}
		if (start < 0 || start >=points.length){
			throw new Error("start"+start+"Must be in the range [0, "+(points.length-1)+"]");
		}
		if (count < 0 || (start+count)> points.length){
			throw new Error("count"+count+"Must be in the range <= "+points.length+"}");
		};
		var upperEnd=start+count;
		var center=BoundSphere._tempVector3;
		center.elements[0]=0;
		center.elements[1]=0;
		center.elements[2]=0;
		for (var i=start;i < upperEnd;++i){
			Vector3.add(points[i],center,center);
		};
		var outCenter=out.center;
		Vector3.scale(center,1 / count,outCenter);
		var radius=0.0;
		for (i=start;i < upperEnd;++i){
			var distance=Vector3.distanceSquared(outCenter,points[i]);
			if (distance > radius)
				radius=distance;
		}
		out.radius=Math.sqrt(radius);
	}

	BoundSphere.createfromPoints=function(points,out){
		if (points==null){
			throw new Error("points");
		}
		BoundSphere.createFromSubPoints(points,0,points.length,out);
	}

	__static(BoundSphere,
	['_tempVector3',function(){return this._tempVector3=new Vector3();}
	]);
	return BoundSphere;
})()


/**
*<code>Collision</code> 类用于检测碰撞。
*/
//class laya.d3.math.Collision
var Collision=(function(){
	/**
	*创建一个 <code>Collision</code> 实例。
	*/
	function Collision(){}
	__class(Collision,'laya.d3.math.Collision');
	Collision.distancePlaneToPoint=function(plane,point){
		var dot=Vector3.dot(plane.normal,point);
		return dot-plane.distance;
	}

	Collision.distanceBoxToPoint=function(box,point){
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var pointe=point.elements;
		var pointeX=pointe[0];
		var pointeY=pointe[1];
		var pointeZ=pointe[2];
		var distance=0;
		if (pointeX < boxMineX)
			distance+=(boxMineX-pointeX)*(boxMineX-pointeX);
		if (pointeX > boxMaxeX)
			distance+=(boxMaxeX-pointeX)*(boxMaxeX-pointeX);
		if (pointeY < boxMineY)
			distance+=(boxMineY-pointeY)*(boxMineY-pointeY);
		if (pointeY > boxMaxeY)
			distance+=(boxMaxeY-pointeY)*(boxMaxeY-pointeY);
		if (pointeZ < boxMineZ)
			distance+=(boxMineZ-pointeZ)*(boxMineZ-pointeZ);
		if (pointeZ > boxMaxeZ)
			distance+=(boxMaxeZ-pointeZ)*(boxMaxeZ-pointeZ);
		return Math.sqrt(distance);
	}

	Collision.distanceBoxToBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1MineX=box1Mine[0];
		var box1MineY=box1Mine[1];
		var box1MineZ=box1Mine[2];
		var box1Maxe=box1.max.elements;
		var box1MaxeX=box1Maxe[0];
		var box1MaxeY=box1Maxe[1];
		var box1MaxeZ=box1Maxe[2];
		var box2Mine=box2.min.elements;
		var box2MineX=box2Mine[0];
		var box2MineY=box2Mine[1];
		var box2MineZ=box2Mine[2];
		var box2Maxe=box2.max.elements;
		var box2MaxeX=box2Maxe[0];
		var box2MaxeY=box2Maxe[1];
		var box2MaxeZ=box2Maxe[2];
		var distance=0;
		var delta=NaN;
		if (box1MineX > box2MaxeX){
			delta=box1MineX-box2MaxeX;
			distance+=delta *delta;
			}else if (box2MineX > box1MaxeX){
			delta=box2MineX-box1MaxeX;
			distance+=delta *delta;
		}
		if (box1MineY > box2MaxeY){
			delta=box1MineY-box2MaxeY;
			distance+=delta *delta;
			}else if (box2MineY > box1MaxeY){
			delta=box2MineY-box1MaxeY;
			distance+=delta *delta;
		}
		if (box1MineZ > box2MaxeZ){
			delta=box1MineZ-box2MaxeZ;
			distance+=delta *delta;
			}else if (box2MineZ > box1MaxeZ){
			delta=box2MineZ-box1MaxeZ;
			distance+=delta *delta;
		}
		return Math.sqrt(distance);
	}

	Collision.distanceSphereToPoint=function(sphere,point){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere.center,point));
		distance-=sphere.radius;
		return Math.max(distance,0);
	}

	Collision.distanceSphereToSphere=function(sphere1,sphere2){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere1.center,sphere2.center));
		distance-=sphere1.radius+sphere2.radius;
		return Math.max(distance,0);
	}

	Collision.intersectsRayAndTriangleRD=function(ray,vertex1,vertex2,vertex3,out){
		var rayO=ray.origin;
		var rayOe=rayO.elements;
		var rayOeX=rayOe[0];
		var rayOeY=rayOe[1];
		var rayOeZ=rayOe[2];
		var rayD=ray.direction;
		var rayDe=rayD.elements;
		var rayDeX=rayDe[0];
		var rayDeY=rayDe[1];
		var rayDeZ=rayDe[2];
		var v1e=vertex1.elements;
		var v1eX=v1e[0];
		var v1eY=v1e[1];
		var v1eZ=v1e[2];
		var v2e=vertex2.elements;
		var v2eX=v2e[0];
		var v2eY=v2e[1];
		var v2eZ=v2e[2];
		var v3e=vertex3.elements;
		var v3eX=v3e[0];
		var v3eY=v3e[1];
		var v3eZ=v3e[2];
		var _tempV30e=Collision._tempV30.elements;
		var _tempV30eX=_tempV30e[0];
		var _tempV30eY=_tempV30e[1];
		var _tempV30eZ=_tempV30e[2];
		_tempV30eX=v2eX-v1eX;
		_tempV30eY=v2eY-v1eY;
		_tempV30eZ=v2eZ-v1eZ;
		var _tempV31e=Collision._tempV31.elements;
		var _tempV31eX=_tempV31e[0];
		var _tempV31eY=_tempV31e[1];
		var _tempV31eZ=_tempV31e[2];
		_tempV31eX=v3eX-v1eX;
		_tempV31eY=v3eY-v1eY;
		_tempV31eZ=v3eZ-v1eZ;
		var _tempV32e=Collision._tempV32.elements;
		var _tempV32eX=_tempV32e[0];
		var _tempV32eY=_tempV32e[1];
		var _tempV32eZ=_tempV32e[2];
		_tempV32eX=(rayDeY *_tempV31eZ)-(rayDeZ *_tempV31eY);
		_tempV32eY=(rayDeZ *_tempV31eX)-(rayDeX *_tempV31eZ);
		_tempV32eZ=(rayDeX *_tempV31eY)-(rayDeY *_tempV31eX);
		var determinant=(_tempV30eX *_tempV32eX)+(_tempV30eY *_tempV32eY)+(_tempV30eZ *_tempV32eZ);
		if (MathUtils3D.isZero(determinant)){
			out=0;
			return false;
		};
		var inversedeterminant=1 / determinant;
		var _tempV33e=Collision._tempV33.elements;
		var _tempV33eX=_tempV33e[0];
		var _tempV33eY=_tempV33e[1];
		var _tempV33eZ=_tempV33e[2];
		_tempV33eX=rayOeX-v1eX;
		_tempV33eY=rayOeY-v1eY;
		_tempV33eZ=rayOeZ-v1eZ;
		var triangleU=(_tempV33eX *_tempV32eX)+(_tempV33eY *_tempV32eY)+(_tempV33eZ *_tempV32eZ);
		triangleU *=inversedeterminant;
		if (triangleU < 0 || triangleU > 1){
			out=0;
			return false;
		};
		var _tempV34e=Collision._tempV34.elements;
		var _tempV34eX=_tempV34e[0];
		var _tempV34eY=_tempV34e[1];
		var _tempV34eZ=_tempV34e[2];
		_tempV34eX=(_tempV33eY *_tempV30eZ)-(_tempV33eZ *_tempV30eY);
		_tempV34eY=(_tempV33eZ *_tempV30eX)-(_tempV33eX *_tempV30eZ);
		_tempV34eZ=(_tempV33eX *_tempV30eY)-(_tempV33eY *_tempV30eX);
		var triangleV=((rayDeX *_tempV34eX)+(rayDeY *_tempV34eY))+(rayDeZ *_tempV34eZ);
		triangleV *=inversedeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			out=0;
			return false;
		};
		var raydistance=(_tempV31eX *_tempV34eX)+(_tempV31eY *_tempV34eY)+(_tempV31eZ *_tempV34eZ);
		raydistance *=inversedeterminant;
		if (raydistance < 0){
			out=0;
			return false;
		}
		out=raydistance;
		return true;
	}

	Collision.intersectsRayAndTriangleRP=function(ray,vertex1,vertex2,vertex3,out){
		var distance=NaN;
		if (!Collision.intersectsRayAndTriangleRD(ray,vertex1,vertex2,vertex3,distance)){
			out=Vector3.ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,out);
		return true;
	}

	Collision.intersectsRayAndPoint=function(ray,point){
		Vector3.subtract(ray.origin,point,Collision._tempV30);
		var b=Vector3.dot(Collision._tempV30,ray.direction);
		var c=Vector3.dot(Collision._tempV30,Collision._tempV30)-MathUtils3D.zeroTolerance;
		if (c > 0 && b > 0)
			return false;
		var discriminant=b *b-c;
		if (discriminant < 0)
			return false;
		return true;
	}

	Collision.intersectsRayAndRay=function(ray1,ray2,out){
		var ray1o=ray1.origin;
		var ray1oe=ray1o.elements;
		var ray1oeX=ray1oe[0];
		var ray1oeY=ray1oe[1];
		var ray1oeZ=ray1oe[2];
		var ray1d=ray1.direction;
		var ray1de=ray1d.elements;
		var ray1deX=ray1de[0];
		var ray1deY=ray1de[1];
		var ray1deZ=ray1de[2];
		var ray2o=ray2.origin;
		var ray2oe=ray2o.elements;
		var ray2oeX=ray2oe[0];
		var ray2oeY=ray2oe[1];
		var ray2oeZ=ray2oe[2];
		var ray2d=ray2.direction;
		var ray2de=ray2d.elements;
		var ray2deX=ray2de[0];
		var ray2deY=ray2de[1];
		var ray2deZ=ray2de[2];
		Vector3.cross(ray1d,ray2d,Collision._tempV30);
		var tempV3e=Collision._tempV30.elements;
		var denominator=Vector3.scalarLength(Collision._tempV30);
		if (MathUtils3D.isZero(denominator)){
			if (MathUtils3D.nearEqual(ray2oeX,ray1oeX)&& MathUtils3D.nearEqual(ray2oeY,ray1oeY)&& MathUtils3D.nearEqual(ray2oeZ,ray1oeZ)){
				out=Vector3.ZERO;
				return true;
			}
		}
		denominator=denominator *denominator;
		var m11=ray2oeX-ray1oeX;
		var m12=ray2oeY-ray1oeY;
		var m13=ray2oeZ-ray1oeZ;
		var m21=ray2deX;
		var m22=ray2deY;
		var m23=ray2deZ;
		var m31=tempV3e[0];
		var m32=tempV3e[1];
		var m33=tempV3e[2];
		var dets=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		m21=ray1deX;
		m22=ray1deY;
		m23=ray1deZ;
		var dett=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		var s=dets / denominator;
		var t=dett / denominator;
		Vector3.scale(ray1d,s,Collision._tempV30);
		Vector3.scale(ray2d,s,Collision._tempV31);
		Vector3.add(ray1o,Collision._tempV30,Collision._tempV32);
		Vector3.add(ray2o,Collision._tempV31,Collision._tempV33);
		var point1e=Collision._tempV32.elements;
		var point2e=Collision._tempV33.elements;
		if (!MathUtils3D.nearEqual(point2e[0],point1e[0])|| !MathUtils3D.nearEqual(point2e[1],point1e[1])|| !MathUtils3D.nearEqual(point2e[2],point1e[2])){
			out=Vector3.ZERO;
			return false;
		}
		out=Collision._tempV32;
		return true;
	}

	Collision.intersectsPlaneAndTriangle=function(plane,vertex1,vertex2,vertex3){
		var test1=Collision.intersectsPlaneAndPoint(plane,vertex1);
		var test2=Collision.intersectsPlaneAndPoint(plane,vertex2);
		var test3=Collision.intersectsPlaneAndPoint(plane,vertex3);
		if (test1==Plane.PlaneIntersectionType_Front && test2==Plane.PlaneIntersectionType_Front && test3==Plane.PlaneIntersectionType_Front)
			return Plane.PlaneIntersectionType_Front;
		if (test1==Plane.PlaneIntersectionType_Back && test2==Plane.PlaneIntersectionType_Back && test3==Plane.PlaneIntersectionType_Back)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsRayAndPlaneRD=function(ray,plane,out){
		var planeNor=plane.normal;
		var direction=Vector3.dot(planeNor,ray.direction);
		if (MathUtils3D.isZero(direction)){
			out=0;
			return false;
		};
		var position=Vector3.dot(planeNor,ray.origin);
		out=(-plane.distance-position)/ direction;
		if (out < 0){
			out=0;
			return false;
		}
		return true;
	}

	Collision.intersectsRayAndPlaneRP=function(ray,plane,out){
		var distance=NaN;
		if (!Collision.intersectsRayAndPlaneRD(ray,plane,distance)){
			out=Vector3.ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		out=Collision._tempV31;
		return true;
	}

	Collision.intersectsRayAndBoxRD=function(ray,box){
		var rayoe=ray.origin.elements;
		var rayoeX=rayoe[0];
		var rayoeY=rayoe[1];
		var rayoeZ=rayoe[2];
		var rayde=ray.direction.elements;
		var raydeX=rayde[0];
		var raydeY=rayde[1];
		var raydeZ=rayde[2];
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var out=0;
		var tmax=MathUtils3D.MaxValue;
		if (MathUtils3D.isZero(raydeX)){
			if (rayoeX < boxMineX || rayoeX > boxMaxeX){
				return-1;
			}
			}else {
			var inverse=1 / raydeX;
			var t1=(boxMineX-rayoeX)*inverse;
			var t2=(boxMaxeX-rayoeX)*inverse;
			if (t1 > t2){
				var temp=t1;
				t1=t2;
				t2=temp;
			}
			out=Math.max(t1,out);
			tmax=Math.min(t2,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeY)){
			if (rayoeY < boxMineY || rayoeY > boxMaxeY){
				return-1;
			}
			}else {
			var inverse1=1 / raydeY;
			var t3=(boxMineY-rayoeY)*inverse1;
			var t4=(boxMaxeY-rayoeY)*inverse1;
			if (t3 > t4){
				var temp1=t3;
				t3=t4;
				t4=temp1;
			}
			out=Math.max(t3,out);
			tmax=Math.min(t4,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeZ)){
			if (rayoeZ < boxMineZ || rayoeZ > boxMaxeZ){
				return-1;
			}
			}else {
			var inverse2=1 / raydeZ;
			var t5=(boxMineZ-rayoeZ)*inverse2;
			var t6=(boxMaxeZ-rayoeZ)*inverse2;
			if (t5 > t6){
				var temp2=t5;
				t5=t6;
				t6=temp2;
			}
			out=Math.max(t5,out);
			tmax=Math.min(t6,tmax);
			if (out > tmax){
				return-1;
			}
		}
		return out;
	}

	Collision.intersectsRayAndBoxRP=function(ray,box,out){
		var distance=Collision.intersectsRayAndBoxRD(ray,box);
		if (distance===-1){
			Vector3.ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		Collision._tempV31.cloneTo(out);
		return distance;
	}

	Collision.intersectsRayAndSphereRD=function(ray,sphere){
		var sphereR=sphere.radius;
		Vector3.subtract(ray.origin,sphere.center,Collision._tempV30);
		var b=Vector3.dot(Collision._tempV30,ray.direction);
		var c=Vector3.dot(Collision._tempV30,Collision._tempV30)-(sphereR *sphereR);
		if (c > 0 && b > 0){
			return-1;
		};
		var discriminant=b *b-c;
		if (discriminant < 0){
			return-1;
		};
		var distance=-b-Math.sqrt(discriminant);
		if (distance < 0)
			distance=0;
		return distance;
	}

	Collision.intersectsRayAndSphereRP=function(ray,sphere,out){
		var distance=Collision.intersectsRayAndSphereRD(ray,sphere);
		if (distance===-1){
			Vector3.ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,Collision._tempV30);
		Vector3.add(ray.origin,Collision._tempV30,Collision._tempV31);
		Collision._tempV31.cloneTo(out);
		return distance;
	}

	Collision.intersectsSphereAndTriangle=function(sphere,vertex1,vertex2,vertex3){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		Collision.closestPointPointTriangle(sphereC,vertex1,vertex2,vertex3,Collision._tempV30);
		Vector3.subtract(Collision._tempV30,sphereC,Collision._tempV31);
		var dot=Vector3.dot(Collision._tempV31,Collision._tempV31);
		return dot <=sphereR *sphereR;
	}

	Collision.intersectsPlaneAndPoint=function(plane,point){
		var distance=Vector3.dot(plane.normal,point)+plane.distance;
		if (distance > 0)
			return Plane.PlaneIntersectionType_Front;
		if (distance < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsPlaneAndPlane=function(plane1,plane2){
		Vector3.cross(plane1.normal,plane2.normal,Collision._tempV30);
		var denominator=Vector3.dot(Collision._tempV30,Collision._tempV30);
		if (MathUtils3D.isZero(denominator))
			return false;
		return true;
	}

	Collision.intersectsPlaneAndPlaneRL=function(plane1,plane2,line){
		var plane1nor=plane1.normal;
		var plane2nor=plane2.normal;
		Vector3.cross(plane1nor,plane2nor,Collision._tempV34);
		var denominator=Vector3.dot(Collision._tempV34,Collision._tempV34);
		if (MathUtils3D.isZero(denominator))
			return false;
		Vector3.scale(plane2nor,plane1.distance,Collision._tempV30);
		Vector3.scale(plane1nor,plane2.distance,Collision._tempV31);
		Vector3.subtract(Collision._tempV30,Collision._tempV31,Collision._tempV32);
		Vector3.cross(Collision._tempV32,Collision._tempV34,Collision._tempV33);
		Vector3.normalize(Collision._tempV34,Collision._tempV34);
		line=new Ray(Collision._tempV33,Collision._tempV34);
		return true;
	}

	Collision.intersectsPlaneAndBox=function(plane,box){
		var planeD=plane.distance;
		var planeNor=plane.normal;
		var planeNore=planeNor.elements;
		var planeNoreX=planeNore[0];
		var planeNoreY=planeNore[1];
		var planeNoreZ=planeNore[2];
		var boxMine=box.min.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMaxe=box.max.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		Collision._tempV30.elements[0]=(planeNoreX > 0)? boxMineX :boxMaxeX;
		Collision._tempV30.elements[1]=(planeNoreY > 0)? boxMineY :boxMaxeY;
		Collision._tempV30.elements[2]=(planeNoreZ > 0)? boxMineZ :boxMaxeZ;
		Collision._tempV31.elements[0]=(planeNoreX > 0)? boxMaxeX :boxMineX;
		Collision._tempV31.elements[1]=(planeNoreY > 0)? boxMaxeY :boxMineY;
		Collision._tempV31.elements[2]=(planeNoreZ > 0)? boxMaxeZ :boxMineZ;
		var distance=Vector3.dot(planeNor,Collision._tempV30);
		if (distance+planeD > 0)
			return Plane.PlaneIntersectionType_Front;
		distance=Vector3.dot(planeNor,Collision._tempV31);
		if (distance+planeD < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsPlaneAndSphere=function(plane,sphere){
		var sphereR=sphere.radius;
		var distance=Vector3.dot(plane.normal,sphere.center)+plane.distance;
		if (distance > sphereR)
			return Plane.PlaneIntersectionType_Front;
		if (distance <-sphereR)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	Collision.intersectsBoxAndBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1Maxe=box1.max.elements;
		var box2Mine=box2.min.elements;
		var box2Maxe=box2.max.elements;
		if (box1Mine[0] > box2Maxe[0] || box2Mine[0] > box1Maxe[0])
			return false;
		if (box1Mine[1] > box2Maxe[1] || box2Mine[1] > box1Maxe[1])
			return false;
		if (box1Mine[2] > box2Maxe[2] || box2Mine[2] > box1Maxe[2])
			return false;
		return true;
	}

	Collision.intersectsBoxAndSphere=function(box,sphere){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,box.min,box.max,Collision._tempV30);
		var distance=Vector3.distanceSquared(sphereC,Collision._tempV30);
		return distance <=sphereR *sphereR;
	}

	Collision.intersectsSphereAndSphere=function(sphere1,sphere2){
		var radiisum=sphere1.radius+sphere2.radius;
		return Vector3.distanceSquared(sphere1.center,sphere2.center)<=radiisum *radiisum;
	}

	Collision.boxContainsPoint=function(box,point){
		var boxMine=box.min.elements;
		var boxMaxe=box.max.elements;
		var pointe=point.elements;
		if (boxMine[0] <=pointe[0] && boxMaxe[0] >=pointe[0] && boxMine[1] <=pointe[1] && boxMaxe[1] >=pointe[1] && boxMine[2] <=pointe[2] && boxMaxe[2] >=pointe[2])
			return 1;
		return 0;
	}

	Collision.boxContainsBox=function(box1,box2){
		var box1Mine=box1.min.elements;
		var box1MineX=box1Mine[0];
		var box1MineY=box1Mine[1];
		var box1MineZ=box1Mine[2];
		var box1Maxe=box1.max.elements;
		var box1MaxeX=box1Maxe[0];
		var box1MaxeY=box1Maxe[1];
		var box1MaxeZ=box1Maxe[2];
		var box2Mine=box2.min.elements;
		var box2MineX=box2Mine[0];
		var box2MineY=box2Mine[1];
		var box2MineZ=box2Mine[2];
		var box2Maxe=box2.max.elements;
		var box2MaxeX=box2Maxe[0];
		var box2MaxeY=box2Maxe[1];
		var box2MaxeZ=box2Maxe[2];
		if (box1MaxeX < box2MineX || box1MineX > box2MaxeX)
			return 0;
		if (box1MaxeY < box2MineY || box1MineY > box2MaxeY)
			return 0;
		if (box1MaxeZ < box2MineZ || box1MineZ > box2MaxeZ)
			return 0;
		if (box1MineX <=box2MineX && box2MaxeX <=box2MaxeX && box1MineY <=box2MineY && box2MaxeY <=box1MaxeY && box1MineZ <=box2MineZ && box2MaxeZ <=box1MaxeZ){
			return 1;
		}
		return 2;
	}

	Collision.boxContainsSphere=function(box,sphere){
		var boxMin=box.min;
		var boxMine=boxMin.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMax=box.max;
		var boxMaxe=boxMax.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var sphereC=sphere.center;
		var sphereCe=sphereC.elements;
		var sphereCeX=sphereCe[0];
		var sphereCeY=sphereCe[1];
		var sphereCeZ=sphereCe[2];
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,boxMin,boxMax,Collision._tempV30);
		var distance=Vector3.distanceSquared(sphereC,Collision._tempV30);
		if (distance > sphereR *sphereR)
			return 0;
		if ((((boxMineX+sphereR <=sphereCeX)&& (sphereCeX <=boxMaxeX-sphereR))&& ((boxMaxeX-boxMineX > sphereR)&&
			(boxMineY+sphereR <=sphereCeY)))&& (((sphereCeY <=boxMaxeY-sphereR)&& (boxMaxeY-boxMineY > sphereR))&&
		(((boxMineZ+sphereR <=sphereCeZ)&& (sphereCeZ <=boxMaxeZ-sphereR))&& (boxMaxeZ-boxMineZ > sphereR))))
		return 1;
		return 2;
	}

	Collision.sphereContainsPoint=function(sphere,point){
		if (Vector3.distanceSquared(point,sphere.center)<=sphere.radius *sphere.radius)
			return 1;
		return 0;
	}

	Collision.sphereContainsTriangle=function(sphere,vertex1,vertex2,vertex3){
		var test1=Collision.sphereContainsPoint(sphere,vertex1);
		var test2=Collision.sphereContainsPoint(sphere,vertex2);
		var test3=Collision.sphereContainsPoint(sphere,vertex3);
		if (test1==1 && test2==1 && test3==1)
			return 1;
		if (Collision.intersectsSphereAndTriangle(sphere,vertex1,vertex2,vertex3))
			return 2;
		return 0;
	}

	Collision.sphereContainsBox=function(sphere,box){
		var sphereC=sphere.center;
		var sphereCe=sphereC.elements;
		var sphereCeX=sphereCe[0];
		var sphereCeY=sphereCe[1];
		var sphereCeZ=sphereCe[2];
		var sphereR=sphere.radius;
		var boxMin=box.min;
		var boxMine=boxMin.elements;
		var boxMineX=boxMine[0];
		var boxMineY=boxMine[1];
		var boxMineZ=boxMine[2];
		var boxMax=box.max;
		var boxMaxe=boxMax.elements;
		var boxMaxeX=boxMaxe[0];
		var boxMaxeY=boxMaxe[1];
		var boxMaxeZ=boxMaxe[2];
		var _tempV30e=Collision._tempV30.elements;
		var _tempV30eX=_tempV30e[0];
		var _tempV30eY=_tempV30e[1];
		var _tempV30eZ=_tempV30e[2];
		if (!Collision.intersectsBoxAndSphere(box,sphere))
			return 0;
		var radiusSquared=sphereR *sphereR;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(Collision._tempV30)> radiusSquared)
			return 2;
		return 1;
	}

	Collision.sphereContainsSphere=function(sphere1,sphere2){
		var sphere1R=sphere1.radius;
		var sphere2R=sphere2.radius;
		var distance=Vector3.distance(sphere1.center,sphere2.center);
		if (sphere1R+sphere2R < distance)
			return 0;
		if (sphere1R-sphere2R < distance)
			return 2;
		return 1;
	}

	Collision.closestPointPointTriangle=function(point,vertex1,vertex2,vertex3,out){
		Vector3.subtract(vertex2,vertex1,Collision._tempV30);
		Vector3.subtract(vertex3,vertex1,Collision._tempV31);
		Vector3.subtract(point,vertex1,Collision._tempV32);
		Vector3.subtract(point,vertex2,Collision._tempV33);
		Vector3.subtract(point,vertex3,Collision._tempV34);
		var d1=Vector3.dot(Collision._tempV30,Collision._tempV32);
		var d2=Vector3.dot(Collision._tempV31,Collision._tempV32);
		var d3=Vector3.dot(Collision._tempV30,Collision._tempV33);
		var d4=Vector3.dot(Collision._tempV31,Collision._tempV33);
		var d5=Vector3.dot(Collision._tempV30,Collision._tempV34);
		var d6=Vector3.dot(Collision._tempV31,Collision._tempV34);
		if (d1 <=0 && d2 <=0){
			vertex1.cloneTo(out);
			return;
		}
		if (d3 >=0 && d4 <=d3){
			vertex2.cloneTo(out);
			return;
		};
		var vc=d1 *d4-d3 *d2;
		if (vc <=0 && d1 >=0 && d3 <=0){
			var v=d1 / (d1-d3);
			Vector3.scale(Collision._tempV30,v,out);
			Vector3.add(vertex1,out,out);
			return;
		}
		if (d6 >=0 && d5 <=d6){
			vertex3.cloneTo(out);
			return;
		};
		var vb=d5 *d2-d1 *d6;
		if (vb <=0 && d2 >=0 && d6 <=0){
			var w=d2 / (d2-d6);
			Vector3.scale(Collision._tempV31,w,out);
			Vector3.add(vertex1,out,out);
			return;
		};
		var va=d3 *d6-d5 *d4;
		if (va <=0 && (d4-d3)>=0 && (d5-d6)>=0){
			var w3=(d4-d3)/ ((d4-d3)+(d5-d6));
			Vector3.subtract(vertex3,vertex2,out);
			Vector3.scale(out,w3,out);
			Vector3.add(vertex2,out,out);
			return;
		};
		var denom=1 / (va+vb+vc);
		var v2=vb *denom;
		var w2=vc *denom;
		Vector3.scale(Collision._tempV30,v2,Collision._tempV35);
		Vector3.scale(Collision._tempV31,w2,Collision._tempV36);
		Vector3.add(Collision._tempV35,Collision._tempV36,out);
		Vector3.add(vertex1,out,out);
	}

	Collision.closestPointPlanePoint=function(plane,point,out){
		var planeN=plane.normal;
		var t=Vector3.dot(planeN,point)-plane.distance;
		Vector3.scale(planeN,t,Collision._tempV30);
		Vector3.subtract(point,Collision._tempV30,out);
	}

	Collision.closestPointBoxPoint=function(box,point,out){
		Vector3.max(point,box.min,Collision._tempV30);
		Vector3.min(Collision._tempV30,box.max,out);
	}

	Collision.closestPointSpherePoint=function(sphere,point,out){
		var sphereC=sphere.center;
		Vector3.subtract(point,sphereC,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere.radius,out);
		Vector3.add(out,sphereC,out);
	}

	Collision.closestPointSphereSphere=function(sphere1,sphere2,out){
		var sphere1C=sphere1.center;
		Vector3.subtract(sphere2.center,sphere1C,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere1.radius,out);
		Vector3.add(out,sphere1C,out);
	}

	__static(Collision,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();}
	]);
	return Collision;
})()


/**
*<code>ContainmentType</code> 类用于定义空间物体位置关系。
*/
//class laya.d3.math.ContainmentType
var ContainmentType=(function(){
	function ContainmentType(){}
	__class(ContainmentType,'laya.d3.math.ContainmentType');
	ContainmentType.Disjoint=0;
	ContainmentType.Contains=1;
	ContainmentType.Intersects=2;
	return ContainmentType;
})()


/**
*<code>MathUtils</code> 类用于创建数学工具。
*/
//class laya.d3.math.MathUtils3D
var MathUtils3D=(function(){
	/**
	*创建一个 <code>MathUtils</code> 实例。
	*/
	function MathUtils3D(){}
	__class(MathUtils3D,'laya.d3.math.MathUtils3D');
	MathUtils3D.isZero=function(v){
		return Math.abs(v)< MathUtils3D.zeroTolerance;
	}

	MathUtils3D.nearEqual=function(n1,n2){
		if (MathUtils3D.isZero(n1-n2))
			return true;
		return false;
	}

	MathUtils3D.fastInvSqrt=function(value){
		if (MathUtils3D.isZero(value))
			return value;
		return 1.0 / Math.sqrt(value);
	}

	__static(MathUtils3D,
	['zeroTolerance',function(){return this.zeroTolerance=1e-6;},'MaxValue',function(){return this.MaxValue=3.40282347e+38;},'MinValue',function(){return this.MinValue=-3.40282347e+38;}
	]);
	return MathUtils3D;
})()


/**
*<code>Matrix3x3</code> 类用于创建3x3矩阵。
*/
//class laya.d3.math.Matrix3x3
var Matrix3x3=(function(){
	function Matrix3x3(){
		/**矩阵元素数组*/
		//this.elements=null;
		var e=this.elements=new Float32Array(9);
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	__class(Matrix3x3,'laya.d3.math.Matrix3x3');
	var __proto=Matrix3x3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*计算3x3矩阵的行列式
	*@return 矩阵的行列式
	*/
	__proto.determinant=function(){
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		return a00 *(a22 *a11-a12 *a21)+a01 *(-a22 *a10+a12 *a20)+a02 *(a21 *a10-a11 *a20);
	}

	/**
	*通过一个二维向量转换3x3矩阵
	*@param tra 转换向量
	*@param out 输出矩阵
	*/
	__proto.translate=function(trans,out){
		var e=out.elements;
		var f=this.elements;
		var g=trans.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var x=g[0],y=g[1];
		e[0]=a00;
		e[1]=a01;
		e[2]=a02;
		e[3]=a10;
		e[4]=a11;
		e[5]=a12;
		e[6]=x *a00+y *a10+a20;
		e[7]=x *a01+y *a11+a21;
		e[8]=x *a02+y *a12+a22;
	}

	/**
	*根据指定角度旋转3x3矩阵
	*@param rad 旋转角度
	*@param out 输出矩阵
	*/
	__proto.rotate=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var s=Math.sin(rad);
		var c=Math.cos(rad);
		e[0]=c *a00+s *a10;
		e[1]=c *a01+s *a11;
		e[2]=c *a02+s *a12;
		e[3]=c *a10-s *a00;
		e[4]=c *a11-s *a01;
		e[5]=c *a12-s *a02;
		e[6]=a20;
		e[7]=a21;
		e[8]=a22;
	}

	/**
	*根据制定缩放3x3矩阵
	*@param scale 缩放值
	*@param out 输出矩阵
	*/
	__proto.scale=function(scale,out){
		var e=out.elements;
		var f=this.elements;
		var g=scale.elements;
		var x=g[0],y=g[1];
		e[0]=x *f[0];
		e[1]=x *f[1];
		e[2]=x *f[2];
		e[3]=y *f[3];
		e[4]=y *f[4];
		e[5]=y *f[5];
		e[6]=f[6];
		e[7]=f[7];
		e[8]=f[8];
	}

	/**
	*计算3x3矩阵的逆矩阵
	*@param out 输出的逆矩阵
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b01=a22 *a11-a12 *a21;
		var b11=-a22 *a10+a12 *a20;
		var b21=a21 *a10-a11 *a20;
		var det=a00 *b01+a01 *b11+a02 *b21;
		if (!det){
			out=null;
		}
		det=1.0 / det;
		e[0]=b01 *det;
		e[1]=(-a22 *a01+a02 *a21)*det;
		e[2]=(a12 *a01-a02 *a11)*det;
		e[3]=b11 *det;
		e[4]=(a22 *a00-a02 *a20)*det;
		e[5]=(-a12 *a00+a02 *a10)*det;
		e[6]=b21 *det;
		e[7]=(-a21 *a00+a01 *a20)*det;
		e[8]=(a11 *a00-a01 *a10)*det;
	}

	/**
	*计算3x3矩阵的转置矩阵
	*@param out 输出矩阵
	*/
	__proto.transpose=function(out){
		var e=out.elements;
		var f=this.elements;
		if (out===this){
			var a01=f[1],a02=f[2],a12=f[5];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=a01;
			e[5]=f[7];
			e[6]=a02;
			e[7]=a12;
			}else {
			e[0]=f[0];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=f[1];
			e[4]=f[4];
			e[5]=f[7];
			e[6]=f[2];
			e[7]=f[5];
			e[8]=f[8];
		}
	}

	/**设置已有的矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 9;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	Matrix3x3.createFromTranslation=function(trans,out){
		var e=out.elements;
		var g=trans.elements;
		out[0]=1;
		out[1]=0;
		out[2]=0;
		out[3]=0;
		out[4]=1;
		out[5]=0;
		out[6]=g[0];
		out[7]=g[1];
		out[8]=1;
	}

	Matrix3x3.createFromRotation=function(rad,out){
		var e=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		e[0]=c;
		e[1]=s;
		e[2]=0;
		e[3]=-s;
		e[4]=c;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromScaling=function(scale,out){
		var e=out.elements;
		var g=scale.elements;
		e[0]=g[0];
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=g[1];
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromMatrix4x4=function(sou,out){
		out[0]=sou[0];
		out[1]=sou[1];
		out[2]=sou[2];
		out[3]=sou[4];
		out[4]=sou[5];
		out[5]=sou[6];
		out[6]=sou[8];
		out[7]=sou[9];
		out[8]=sou[10];
	}

	Matrix3x3.multiply=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b00=g[0],b01=g[1],b02=g[2];
		var b10=g[3],b11=g[4],b12=g[5];
		var b20=g[6],b21=g[7],b22=g[8];
		e[0]=b00 *a00+b01 *a10+b02 *a20;
		e[1]=b00 *a01+b01 *a11+b02 *a21;
		e[2]=b00 *a02+b01 *a12+b02 *a22;
		e[3]=b10 *a00+b11 *a10+b12 *a20;
		e[4]=b10 *a01+b11 *a11+b12 *a21;
		e[5]=b10 *a02+b11 *a12+b12 *a22;
		e[6]=b20 *a00+b21 *a10+b22 *a20;
		e[7]=b20 *a01+b21 *a11+b22 *a21;
		e[8]=b20 *a02+b21 *a12+b22 *a22;
	}

	Matrix3x3.lookAt=function(eye,target,up,out){
		Vector3.subtract(eye,target,Matrix3x3._tempV30);
		Vector3.normalize(Matrix3x3._tempV30,Matrix3x3._tempV30);
		Vector3.cross(up,Matrix3x3._tempV30,Matrix3x3._tempV31);
		Vector3.normalize(Matrix3x3._tempV31,Matrix3x3._tempV31);
		Vector3.cross(Matrix3x3._tempV30,Matrix3x3._tempV31,Matrix3x3._tempV32);
		var v0e=Matrix3x3._tempV30.elements;
		var v1e=Matrix3x3._tempV31.elements;
		var v2e=Matrix3x3._tempV32.elements;
		var me=out.elements;
		me[0]=v1e[0];
		me[3]=v1e[1];
		me[6]=v1e[2];
		me[1]=v2e[0];
		me[4]=v2e[1];
		me[7]=v2e[2];
		me[2]=v0e[0];
		me[5]=v0e[1];
		me[8]=v0e[2];
	}

	__static(Matrix3x3,
	['DEFAULT',function(){return this.DEFAULT=new Matrix3x3();},'_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();}
	]);
	return Matrix3x3;
})()


/**
*<code>Matrix4x4</code> 类用于创建4x4矩阵。
*/
//class laya.d3.math.Matrix4x4
var Matrix4x4=(function(){
	function Matrix4x4(m11,m12,m13,m14,m21,m22,m23,m24,m31,m32,m33,m34,m41,m42,m43,m44){
		/**矩阵元素数组*/
		//this.elements=null;
		(m11===void 0)&& (m11=1);
		(m12===void 0)&& (m12=0);
		(m13===void 0)&& (m13=0);
		(m14===void 0)&& (m14=0);
		(m21===void 0)&& (m21=0);
		(m22===void 0)&& (m22=1);
		(m23===void 0)&& (m23=0);
		(m24===void 0)&& (m24=0);
		(m31===void 0)&& (m31=0);
		(m32===void 0)&& (m32=0);
		(m33===void 0)&& (m33=1);
		(m34===void 0)&& (m34=0);
		(m41===void 0)&& (m41=0);
		(m42===void 0)&& (m42=0);
		(m43===void 0)&& (m43=0);
		(m44===void 0)&& (m44=1);
		var e=this.elements=new Float32Array(16);
		e[0]=m11;
		e[1]=m12;
		e[2]=m13;
		e[3]=m14;
		e[4]=m21;
		e[5]=m22;
		e[6]=m23;
		e[7]=m24;
		e[8]=m31;
		e[9]=m32;
		e[10]=m33;
		e[11]=m34;
		e[12]=m41;
		e[13]=m42;
		e[14]=m43;
		e[15]=m44;
	}

	__class(Matrix4x4,'laya.d3.math.Matrix4x4');
	var __proto=Matrix4x4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.getElementByRowColumn=function(row,column){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		return this.elements[(row *4)+column];
	}

	__proto.setElementByRowColumn=function(row,column,value){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		this.elements[(row *4)+column]=value;
	}

	/**
	*判断两个4x4矩阵的值是否相等。
	*@param other 4x4矩阵
	*/
	__proto.equalsOtherMatrix=function(other){
		var e=this.elements;
		var oe=other.elements;
		return (MathUtils3D.nearEqual(e[0],oe[0])&& MathUtils3D.nearEqual(e[1],oe[1])&& MathUtils3D.nearEqual(e[2],oe[2])&& MathUtils3D.nearEqual(e[3],oe[3])&& MathUtils3D.nearEqual(e[4],oe[4])&& MathUtils3D.nearEqual(e[5],oe[5])&& MathUtils3D.nearEqual(e[6],oe[6])&& MathUtils3D.nearEqual(e[7],oe[7])&& MathUtils3D.nearEqual(e[8],oe[8])&& MathUtils3D.nearEqual(e[9],oe[9])&& MathUtils3D.nearEqual(e[10],oe[10])&& MathUtils3D.nearEqual(e[11],oe[11])&& MathUtils3D.nearEqual(e[12],oe[12])&& MathUtils3D.nearEqual(e[13],oe[13])&& MathUtils3D.nearEqual(e[14],oe[14])&& MathUtils3D.nearEqual(e[15],oe[15]));
	}

	/**
	*分解矩阵为平移向量、旋转四元数、缩放向量。
	*@param translation 平移向量。
	*@param rotation 旋转四元数。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotScale=function(translation,rotation,scale){
		var rotationMatrix=Matrix4x4._tempMatrix4x4;
		if (this.decomposeTransRotMatScale(translation,rotationMatrix,scale)){
			Quaternion.createFromMatrix4x4(rotationMatrix,rotation);
			return true;
			}else {
			rotation.identity();
			return false;
		}
	}

	/**
	*分解矩阵为平移向量、旋转矩阵、缩放向量。
	*@param translation 平移向量。
	*@param rotationMatrix 旋转矩阵。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotMatScale=function(translation,rotationMatrix,scale){
		var e=this.elements;
		var te=translation.elements;
		var re=rotationMatrix.elements;
		var se=scale.elements;
		te[0]=e[12];
		te[1]=e[13];
		te[2]=e[14];
		var m11=e[0],m12=e[1],m13=e[2];
		var m21=e[4],m22=e[5],m23=e[6];
		var m31=e[8],m32=e[9],m33=e[10];
		var sX=se[0]=Math.sqrt((m11 *m11)+(m12 *m12)+(m13 *m13));
		var sY=se[1]=Math.sqrt((m21 *m21)+(m22 *m22)+(m23 *m23));
		var sZ=se[2]=Math.sqrt((m31 *m31)+(m32 *m32)+(m33 *m33));
		if (MathUtils3D.isZero(sX)|| MathUtils3D.isZero(sY)|| MathUtils3D.isZero(sZ)){
			re[1]=re[2]=re[3]=re[4]=re[6]=re[7]=re[8]=re[9]=re[11]=re[12]=re[13]=re[14]=0;
			re[0]=re[5]=re[10]=re[15]=1;
			return false;
		};
		var at=Matrix4x4._tempVector0;
		var atE=at.elements;
		atE[0]=m31 / sZ;
		atE[1]=m32 / sZ;
		atE[2]=m33 / sZ;
		var tempRight=Matrix4x4._tempVector1;
		var tempRightE=tempRight.elements;
		tempRightE[0]=m11 / sX;
		tempRightE[1]=m12 / sX;
		tempRightE[2]=m13 / sX;
		var up=Matrix4x4._tempVector2;
		Vector3.cross(at,tempRight,up);
		var right=Matrix4x4._tempVector1;
		Vector3.cross(up,at,right);
		re[3]=re[7]=re[11]=re[12]=re[13]=re[14]=0;
		re[15]=1;
		re[0]=right.x;
		re[1]=right.y;
		re[2]=right.z;
		re[4]=up.x;
		re[5]=up.y;
		re[6]=up.z;
		re[8]=at.x;
		re[9]=at.y;
		re[10]=at.z;
		((re[0] *m11+re[1] *m12+re[2] *m13)< 0.0)&& (se[0]=-sX);
		((re[4] *m21+re[5] *m22+re[6] *m23)< 0.0)&& (se[1]=-sY);
		((re[8] *m31+re[9] *m32+re[10] *m33)< 0.0)&& (se[2]=-sZ);
		return true;
	}

	/**
	*分解旋转矩阵的旋转为YawPitchRoll欧拉角。
	*@param out float yaw
	*@param out float pitch
	*@param out float roll
	*@return
	*/
	__proto.decomposeYawPitchRoll=function(yawPitchRoll){
		var yawPitchRollE=yawPitchRoll.elements;
		var pitch=Math.asin(-this.elements[9]);
		yawPitchRollE[1]=pitch;
		var test=Math.cos(pitch);
		if (test > MathUtils3D.zeroTolerance){
			yawPitchRollE[2]=Math.atan2(this.elements[1],this.elements[5]);
			yawPitchRollE[0]=Math.atan2(this.elements[8],this.elements[10]);
			}else {
			yawPitchRollE[2]=Math.atan2(-this.elements[4],this.elements[0]);
			yawPitchRollE[0]=0.0;
		}
	}

	/**归一化矩阵 */
	__proto.normalize=function(){
		var v=this.elements;
		var c=v[0],d=v[1],e=v[2],g=Math.sqrt(c *c+d *d+e *e);
		if (g){
			if (g==1)
				return;
			}else {
			v[0]=0;
			v[1]=0;
			v[2]=0;
			return;
		}
		g=1 / g;
		v[0]=c *g;
		v[1]=d *g;
		v[2]=e *g;
	}

	/**计算矩阵的转置矩阵*/
	__proto.transpose=function(){
		var e,t;
		e=this.elements;
		t=e[1];
		e[1]=e[4];
		e[4]=t;
		t=e[2];
		e[2]=e[8];
		e[8]=t;
		t=e[3];
		e[3]=e[12];
		e[12]=t;
		t=e[6];
		e[6]=e[9];
		e[9]=t;
		t=e[7];
		e[7]=e[13];
		e[13]=t;
		t=e[11];
		e[11]=e[14];
		e[14]=t;
		return this;
	}

	/**
	*计算一个矩阵的逆矩阵
	*@param out 输出矩阵
	*/
	__proto.invert=function(out){
		var ae=this.elements;
		var oe=out.elements;
		var a00=ae[0],a01=ae[1],a02=ae[2],a03=ae[3],a10=ae[4],a11=ae[5],a12=ae[6],a13=ae[7],a20=ae[8],a21=ae[9],a22=ae[10],a23=ae[11],a30=ae[12],a31=ae[13],a32=ae[14],a33=ae[15],
		b00=a00 *a11-a01 *a10,b01=a00 *a12-a02 *a10,b02=a00 *a13-a03 *a10,b03=a01 *a12-a02 *a11,b04=a01 *a13-a03 *a11,b05=a02 *a13-a03 *a12,b06=a20 *a31-a21 *a30,b07=a20 *a32-a22 *a30,b08=a20 *a33-a23 *a30,b09=a21 *a32-a22 *a31,b10=a21 *a33-a23 *a31,b11=a22 *a33-a23 *a32,
		det=b00 *b11-b01 *b10+b02 *b09+b03 *b08-b04 *b07+b05 *b06;
		if (Math.abs(det)===0.0){
			return;
		}
		det=1.0 / det;
		oe[0]=(a11 *b11-a12 *b10+a13 *b09)*det;
		oe[1]=(a02 *b10-a01 *b11-a03 *b09)*det;
		oe[2]=(a31 *b05-a32 *b04+a33 *b03)*det;
		oe[3]=(a22 *b04-a21 *b05-a23 *b03)*det;
		oe[4]=(a12 *b08-a10 *b11-a13 *b07)*det;
		oe[5]=(a00 *b11-a02 *b08+a03 *b07)*det;
		oe[6]=(a32 *b02-a30 *b05-a33 *b01)*det;
		oe[7]=(a20 *b05-a22 *b02+a23 *b01)*det;
		oe[8]=(a10 *b10-a11 *b08+a13 *b06)*det;
		oe[9]=(a01 *b08-a00 *b10-a03 *b06)*det;
		oe[10]=(a30 *b04-a31 *b02+a33 *b00)*det;
		oe[11]=(a21 *b02-a20 *b04-a23 *b00)*det;
		oe[12]=(a11 *b07-a10 *b09-a12 *b06)*det;
		oe[13]=(a00 *b09-a01 *b07+a02 *b06)*det;
		oe[14]=(a31 *b01-a30 *b03-a32 *b00)*det;
		oe[15]=(a20 *b03-a21 *b01+a22 *b00)*det;
	}

	/**设置矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[1]=e[2]=e[3]=e[4]=e[6]=e[7]=e[8]=e[9]=e[11]=e[12]=e[13]=e[14]=0;
		e[0]=e[5]=e[10]=e[15]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 16;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取平移向量。
	*@param out 平移向量。
	*/
	__proto.getTranslationVector=function(out){
		var me=this.elements;
		var te=out.elements;
		te[0]=me[12];
		te[1]=me[13];
		te[2]=me[14];
	}

	/**
	*设置平移向量。
	*@param translate 平移向量。
	*/
	__proto.setTranslationVector=function(translate){
		var me=this.elements;
		var ve=translate.elements;
		me[12]=ve[0];
		me[13]=ve[1];
		me[14]=ve[2];
	}

	/**
	*获取前向量。
	*@param out 前向量。
	*/
	__proto.getForward=function(out){
		var me=this.elements;
		var te=out.elements;
		te[0]=-me[8];
		te[1]=-me[9];
		te[2]=-me[10];
	}

	/**
	*设置前向量。
	*@param forward 前向量。
	*/
	__proto.setForward=function(forward){
		var me=this.elements;
		var ve=forward.elements;
		me[8]=-ve[0];
		me[9]=-ve[1];
		me[10]=-ve[2];
	}

	Matrix4x4.createRotationX=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[7]=oe[8]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[0]=oe[15]=1;
		oe[5]=oe[10]=c;
		oe[6]=s;
		oe[9]=-s;
	}

	Matrix4x4.createRotationY=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[3]=oe[4]=oe[6]=oe[7]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[5]=oe[15]=1;
		oe[0]=oe[10]=c;
		oe[2]=-s;
		oe[8]=s;
	}

	Matrix4x4.createRotationZ=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[2]=oe[3]=oe[6]=oe[7]=oe[8]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[10]=oe[15]=1;
		oe[0]=oe[5]=c;
		oe[1]=s;
		oe[4]=-s;
	}

	Matrix4x4.createRotationYawPitchRoll=function(yaw,pitch,roll,result){
		Quaternion.createFromYawPitchRoll(yaw,pitch,roll,Matrix4x4._tempQuaternion);
		Matrix4x4.createRotationQuaternion(Matrix4x4._tempQuaternion,result);
	}

	Matrix4x4.createRotationAxis=function(axis,angle,result){
		var axisE=axis.elements;
		var x=axisE[0];
		var y=axisE[1];
		var z=axisE[2];
		var cos=Math.cos(angle);
		var sin=Math.sin(angle);
		var xx=x *x;
		var yy=y *y;
		var zz=z *z;
		var xy=x *y;
		var xz=x *z;
		var yz=y *z;
		var resultE=result.elements;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=xx+(cos *(1.0-xx));
		resultE[1]=(xy-(cos *xy))+(sin *z);
		resultE[2]=(xz-(cos *xz))-(sin *y);
		resultE[4]=(xy-(cos *xy))-(sin *z);
		resultE[5]=yy+(cos *(1.0-yy));
		resultE[6]=(yz-(cos *yz))+(sin *x);
		resultE[8]=(xz-(cos *xz))+(sin *y);
		resultE[9]=(yz-(cos *yz))-(sin *x);
		resultE[10]=zz+(cos *(1.0-zz));
	}

	Matrix4x4.createRotationQuaternion=function(rotation,result){
		var rotationE=rotation.elements;
		var resultE=result.elements;
		var rotationX=rotationE[0];
		var rotationY=rotationE[1];
		var rotationZ=rotationE[2];
		var rotationW=rotationE[3];
		var xx=rotationX *rotationX;
		var yy=rotationY *rotationY;
		var zz=rotationZ *rotationZ;
		var xy=rotationX *rotationY;
		var zw=rotationZ *rotationW;
		var zx=rotationZ *rotationX;
		var yw=rotationY *rotationW;
		var yz=rotationY *rotationZ;
		var xw=rotationX *rotationW;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=1.0-(2.0 *(yy+zz));
		resultE[1]=2.0 *(xy+zw);
		resultE[2]=2.0 *(zx-yw);
		resultE[4]=2.0 *(xy-zw);
		resultE[5]=1.0-(2.0 *(zz+xx));
		resultE[6]=2.0 *(yz+xw);
		resultE[8]=2.0 *(zx+yw);
		resultE[9]=2.0 *(yz-xw);
		resultE[10]=1.0-(2.0 *(yy+xx));
	}

	Matrix4x4.createTranslate=function(trans,out){
		var te=trans.elements;
		var oe=out.elements;
		oe[4]=oe[8]=oe[1]=oe[9]=oe[2]=oe[6]=oe[3]=oe[7]=oe[11]=0;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=te[0];
		oe[13]=te[1];
		oe[14]=te[2];
	}

	Matrix4x4.createScaling=function(scale,out){
		var se=scale.elements;
		var oe=out.elements;
		oe[0]=se[0];
		oe[5]=se[1];
		oe[10]=se[2];
		oe[1]=oe[4]=oe[8]=oe[12]=oe[9]=oe[13]=oe[2]=oe[6]=oe[14]=oe[3]=oe[7]=oe[11]=0;
		oe[15]=1;
	}

	Matrix4x4.multiply=function(left,right,out){
		var i,e,a,b,ai0,ai1,ai2,ai3;
		e=out.elements;
		a=left.elements;
		b=right.elements;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		}
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			e[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			e[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			e[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	Matrix4x4.createFromQuaternion=function(rotation,out){
		var e=out.elements;
		var q=rotation.elements;
		var x=q[0],y=q[1],z=q[2],w=q[3];
		var x2=x+x;
		var y2=y+y;
		var z2=z+z;
		var xx=x *x2;
		var yx=y *x2;
		var yy=y *y2;
		var zx=z *x2;
		var zy=z *y2;
		var zz=z *z2;
		var wx=w *x2;
		var wy=w *y2;
		var wz=w *z2;
		e[0]=1-yy-zz;
		e[1]=yx+wz;
		e[2]=zx-wy;
		e[3]=0;
		e[4]=yx-wz;
		e[5]=1-xx-zz;
		e[6]=zy+wx;
		e[7]=0;
		e[8]=zx+wy;
		e[9]=zy-wx;
		e[10]=1-xx-yy;
		e[11]=0;
		e[12]=0;
		e[13]=0;
		e[14]=0;
		e[15]=1;
	}

	Matrix4x4.createAffineTransformation=function(trans,rot,scale,out){
		var te=trans.elements;
		var re=rot.elements;
		var se=scale.elements;
		var oe=out.elements;
		var x=re[0],y=re[1],z=re[2],w=re[3],x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=se[0],sy=se[1],sz=se[2];
		oe[0]=(1-(yy+zz))*sx;
		oe[1]=(xy+wz)*sx;
		oe[2]=(xz-wy)*sx;
		oe[3]=0;
		oe[4]=(xy-wz)*sy;
		oe[5]=(1-(xx+zz))*sy;
		oe[6]=(yz+wx)*sy;
		oe[7]=0;
		oe[8]=(xz+wy)*sz;
		oe[9]=(yz-wx)*sz;
		oe[10]=(1-(xx+yy))*sz;
		oe[11]=0;
		oe[12]=te[0];
		oe[13]=te[1];
		oe[14]=te[2];
		oe[15]=1;
	}

	Matrix4x4.createLookAt=function(eye,target,up,out){
		var oE=out.elements;
		var xaxis=Matrix4x4._tempVector0;
		var yaxis=Matrix4x4._tempVector1;
		var zaxis=Matrix4x4._tempVector2;
		Vector3.subtract(eye,target,zaxis);
		Vector3.normalize(zaxis,zaxis);
		Vector3.cross(up,zaxis,xaxis);
		Vector3.normalize(xaxis,xaxis);
		Vector3.cross(zaxis,xaxis,yaxis);
		out.identity();
		oE[0]=xaxis.x;
		oE[4]=xaxis.y;
		oE[8]=xaxis.z;
		oE[1]=yaxis.x;
		oE[5]=yaxis.y;
		oE[9]=yaxis.z;
		oE[2]=zaxis.x;
		oE[6]=zaxis.y;
		oE[10]=zaxis.z;
		oE[12]=-Vector3.dot(xaxis,eye);
		oE[13]=-Vector3.dot(yaxis,eye);
		oE[14]=-Vector3.dot(zaxis,eye);
	}

	Matrix4x4.createPerspective=function(fov,aspect,near,far,out){
		var oe=out.elements;
		var f=1.0 / Math.tan(fov / 2),nf=1 / (near-far);
		oe[0]=f / aspect;
		oe[5]=f;
		oe[10]=(far+near)*nf;
		oe[11]=-1;
		oe[14]=(2 *far *near)*nf;
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[7]=oe[8]=oe[9]=oe[12]=oe[13]=oe[15]=0;
	}

	Matrix4x4.createOrthoOffCenterRH=function(left,right,bottom,top,near,far,out){
		var oe=out.elements;
		var lr=1 / (left-right);
		var bt=1 / (bottom-top);
		var nf=1 / (near-far);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[7]=oe[8]=oe[9]=oe[11]=0;
		oe[15]=1;
		oe[0]=-2 *lr;
		oe[5]=-2 *bt;
		oe[10]=2 *nf;
		oe[12]=(left+right)*lr;
		oe[13]=(top+bottom)*bt;
		oe[14]=(far+near)*nf;
	}

	Matrix4x4.translation=function(v3,out){
		var ve=v3.elements;
		var oe=out.elements;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=ve[0];
		oe[13]=ve[1];
		oe[14]=ve[2];
	}

	__static(Matrix4x4,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();},'_tempVector0',function(){return this._tempVector0=new Vector3();},'_tempVector1',function(){return this._tempVector1=new Vector3();},'_tempVector2',function(){return this._tempVector2=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'DEFAULT',function(){return this.DEFAULT=new Matrix4x4();},'ZERO',function(){return this.ZERO=new Matrix4x4(
		0,0,0,0,
		0,0,0,0,
		0,0,0,0,
		0,0,0,0);}
	]);
	return Matrix4x4;
})()


/**
*<code>OrientedBoundBox</code> 类用于创建OBB包围盒。
*/
//class laya.d3.math.OrientedBoundBox
var OrientedBoundBox=(function(){
	function OrientedBoundBox(extents,transformation){
		/**每个轴长度的一半*/
		this.extents=null;
		/**这个矩阵表示包围盒的位置和缩放,它的平移向量表示该包围盒的中心*/
		this.transformation=null;
		this.extents=extents;
		this.transformation=transformation;
	}

	__class(OrientedBoundBox,'laya.d3.math.OrientedBoundBox');
	var __proto=OrientedBoundBox.prototype;
	/**
	*获取OBB包围盒的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		var xve=OrientedBoundBox._tempV30.elements;
		var yve=OrientedBoundBox._tempV31.elements;
		var zve=OrientedBoundBox._tempV32.elements;
		var extentsE=this.extents.elements;
		xve[0]=extentsE[0];
		xve[1]=xve[2]=0;
		yve[1]=extentsE[1];
		yve[0]=yve[2]=0;
		zve[2]=extentsE[2];
		zve[0]=zve[1]=0;
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV32,this.transformation,OrientedBoundBox._tempV32);
		var center=OrientedBoundBox._tempV33;
		this.transformation.getTranslationVector(center);
		corners.length=8;
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[2]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[3]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[4]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[5]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[6]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[7]);
	}

	/**
	*变换该包围盒的矩阵信息。
	*@param mat 矩阵
	*/
	__proto.transform=function(mat){
		Matrix4x4.multiply(this.transformation,mat,this.transformation);
	}

	/**
	*缩放该包围盒
	*@param scaling 各轴的缩放比。
	*/
	__proto.scale=function(scaling){
		Vector3.multiply(this.extents,scaling,this.extents);
	}

	/**
	*平移该包围盒。
	*@param translation 平移参数
	*/
	__proto.translate=function(translation){
		this.transformation.getTranslationVector(OrientedBoundBox._tempV30);
		Vector3.add(OrientedBoundBox._tempV30,translation,OrientedBoundBox._tempV31);
		this.transformation.setTranslationVector(OrientedBoundBox._tempV31);
	}

	/**
	*该包围盒的尺寸。
	*@param out 输出
	*/
	__proto.Size=function(out){
		Vector3.scale(this.extents,2,out);
	}

	/**
	*该包围盒需要考虑的尺寸
	*@param out 输出
	*/
	__proto.getSize=function(out){
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		var oe=out.elements;
		oe[0]=Vector3.scalarLength(OrientedBoundBox._tempV30);
		oe[1]=Vector3.scalarLength(OrientedBoundBox._tempV31);
		oe[2]=Vector3.scalarLength(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒需要考虑尺寸的平方
	*@param out 输出
	*/
	__proto.getSizeSquared=function(out){
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		var oe=out.elements;
		oe[0]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV30);
		oe[1]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV31);
		oe[2]=Vector3.scalarLengthSquared(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒的几何中心
	*/
	__proto.getCenter=function(center){
		this.transformation.getTranslationVector(center);
	}

	/**
	*该包围盒是否包含空间中一点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoint=function(point){
		var extentsE=this.extents.elements;
		var extentsEX=extentsE[0];
		var extentsEY=extentsE[1];
		var extentsEZ=extentsE[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var _tempV30e=OrientedBoundBox._tempV30.elements;
		var _tempV30ex=Math.abs(_tempV30e[0]);
		var _tempV30ey=Math.abs(_tempV30e[1]);
		var _tempV30ez=Math.abs(_tempV30e[2]);
		if (MathUtils3D.nearEqual(_tempV30ex,extentsEX)&& MathUtils3D.nearEqual(_tempV30ey,extentsEY)&& MathUtils3D.nearEqual(_tempV30ez,extentsEZ))
			return 2;
		if (_tempV30ex < extentsEX && _tempV30ey < extentsEY && _tempV30ez < extentsEZ)
			return 1;
		else
		return 0;
	}

	/**
	*该包围盒是否包含空间中多点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoints=function(points){
		var extentse=this.extents.elements;
		var extentsex=extentse[0];
		var extentsey=extentse[1];
		var extentsez=extentse[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		var containsAll=true;
		var containsAny=false;
		for (var i=0;i < points.length;i++){
			Vector3.transformCoordinate(points[i],OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
			var _tempV30e=OrientedBoundBox._tempV30.elements;
			var _tempV30ex=Math.abs(_tempV30e[0]);
			var _tempV30ey=Math.abs(_tempV30e[1]);
			var _tempV30ez=Math.abs(_tempV30e[2]);
			if (MathUtils3D.nearEqual(_tempV30ex,extentsex)&& MathUtils3D.nearEqual(_tempV30ey,extentsey)&& MathUtils3D.nearEqual(_tempV30ez,extentsez))
				containsAny=true;
			if (_tempV30ex < extentsex && _tempV30ey < extentsey && extentsez < _tempV30ez)
				containsAny=true;
			else
			containsAll=false;
		}
		if (containsAll)
			return 1;
		else if (containsAny)
		return 2;
		else
		return 0;
	}

	/**
	*该包围盒是否包含空间中一包围球
	*@param sphere 包围球
	*@param ignoreScale 是否考虑该包围盒的缩放
	*@return 返回位置关系
	*/
	__proto.containsSphere=function(sphere,ignoreScale){
		(ignoreScale===void 0)&& (ignoreScale=false);
		var extentsE=this.extents.elements;
		var extentsEX=extentsE[0];
		var extentsEY=extentsE[1];
		var extentsEZ=extentsE[2];
		var sphereR=sphere.radius;
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(sphere.center,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var locRadius=NaN;
		if (ignoreScale){
			locRadius=sphereR;
			}else {
			Vector3.scale(Vector3.UnitX,sphereR,OrientedBoundBox._tempV31);
			Vector3.TransformNormal(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
			locRadius=Vector3.scalarLength(OrientedBoundBox._tempV31);
		}
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV32);
		Vector3.Clamp(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,this.extents,OrientedBoundBox._tempV33);
		var distance=Vector3.distanceSquared(OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		if (distance > locRadius *locRadius)
			return 0;
		var tempV30e=OrientedBoundBox._tempV30.elements;
		var tempV30ex=tempV30e[0];
		var tempV30ey=tempV30e[1];
		var tempV30ez=tempV30e[2];
		var tempV32e=OrientedBoundBox._tempV32.elements;
		var tempV32ex=tempV32e[0];
		var tempV32ey=tempV32e[1];
		var tempV32ez=tempV32e[2];
		if ((((tempV32ex+locRadius <=tempV30ex)&& (tempV30ex <=extentsEX-locRadius))&& ((extentsEX-tempV32ex > locRadius)&& (tempV32ey+locRadius <=tempV30ey)))&& (((tempV30ey <=extentsEY-locRadius)&& (extentsEY-tempV32ey > locRadius))&& (((tempV32ez+locRadius <=tempV30ez)&& (tempV30ez <=extentsEZ-locRadius))&& (extentsEZ-tempV32ez > locRadius)))){
			return 1;
		}
		return 2;
	}

	/**
	*该包围盒是否包含空间中另一OBB包围盒
	*@param obb OBB包围盒
	*@return 返回位置关系
	*/
	__proto.containsOrientedBoundBox=function(obb){
		var i=0,k=0;
		obb.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=0)
			return cornersCheck;
		var sizeAe=this.extents.elements;
		obb.extents.cloneTo(OrientedBoundBox._tempV35);
		var sizeBe=OrientedBoundBox._tempV35.elements;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		OrientedBoundBox._getRows(obb.transformation,OrientedBoundBox._rows2);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 4;i++){
			for (k=0;k < 4;k++){
				if (i==3 || k==3){
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,0);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,0);
					}else {
					dotNumber=Vector3.dot(OrientedBoundBox._rows1[i],OrientedBoundBox._rows2[k]);
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,dotNumber);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(dotNumber));
				}
			}
		}
		obb.getCenter(OrientedBoundBox._tempV34);
		this.getCenter(OrientedBoundBox._tempV36);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV36,OrientedBoundBox._tempV30);
		var vsepAe=OrientedBoundBox._tempV31.elements;
		vsepAe[0]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[0]);
		vsepAe[1]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[1]);
		vsepAe[2]=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[2]);
		var _tempV32e=OrientedBoundBox._tempV32.elements;
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		for (i=0;i < 3;i++){
			_tempV32e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			_tempV32e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			_tempV32e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
			separation=Math.abs(vsepAe[i]);
			if (separation > extentA+extentB)
				return 0;
		}
		for (k=0;k < 3;k++){
			_tempV32e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			_tempV32e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			_tempV32e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			_tempV33e[0]=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			_tempV33e[1]=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			_tempV33e[2]=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV32);
			extentB=sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33));
			if (separation > extentA+extentB)
				return 0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+sizeBe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=sizeAe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return 0;
			}
		}
		return 2;
	}

	/**
	*该包围盒是否包含空间中一条线
	*@param point1 点1
	*@param point2 点2
	*@return 返回位置关系
	*/
	__proto.containsLine=function(point1,point2){
		OrientedBoundBox._corners[0]=point1;
		OrientedBoundBox._corners[1]=point2;
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=0)
			return cornersCheck;
		var extentsE=this.extents.elements;
		var extentsX=extentsE[0];
		var extentsY=extentsE[1];
		var extentsZ=extentsE[2];
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point1,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		Vector3.transformCoordinate(point2,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Vector3.scale(OrientedBoundBox._tempV32,0.5,OrientedBoundBox._tempV32);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,OrientedBoundBox._tempV33);
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		var _tempV33X=_tempV33e[0];
		var _tempV33Y=_tempV33e[1];
		var _tempV33Z=_tempV33e[2];
		var _tempV34e=OrientedBoundBox._tempV34.elements;
		var _tempV34X=_tempV34e[0]=Math.abs(_tempV33e[0]);
		var _tempV34Y=_tempV34e[1]=Math.abs(_tempV33e[1]);
		var _tempV34Z=_tempV34e[2]=Math.abs(_tempV33e[2]);
		var _tempV32e=OrientedBoundBox._tempV32.elements;
		var _tempV32X=_tempV32e[0];
		var _tempV32Y=_tempV32e[1];
		var _tempV32Z=_tempV32e[2];
		if (Math.abs(_tempV32X)> extentsX+_tempV34X)
			return 0;
		if (Math.abs(_tempV32Y)> extentsY+_tempV34Y)
			return 0;
		if (Math.abs(_tempV32Z)> extentsZ+_tempV34Z)
			return 0;
		if (Math.abs(_tempV32Y *_tempV33Z-_tempV32Z *_tempV33Y)> (extentsY *_tempV34Z+extentsZ *_tempV34Y))
			return 0;
		if (Math.abs(_tempV32X *_tempV33Z-_tempV32Z *_tempV33X)> (extentsX *_tempV34Z+extentsZ *_tempV34X))
			return 0;
		if (Math.abs(_tempV32X *_tempV33Y-_tempV32Y *_tempV33X)> (extentsX *_tempV34Y+extentsY *_tempV34X))
			return 0;
		return 2;
	}

	/**
	*该包围盒是否包含空间中另一OBB包围盒
	*@param box 包围盒
	*@return 返回位置关系
	*/
	__proto.containsBoundBox=function(box){
		var i=0,k=0;
		var min=box.min;
		var max=box.max;
		box.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=0)
			return cornersCheck;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV30);
		Vector3.subtract(max,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		var sizeAe=this.extents.elements;
		var sizeBe=OrientedBoundBox._tempV31.elements;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		this.transformation.invert(OrientedBoundBox._tempM0);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(OrientedBoundBox._tempM0.getElementByRowColumn(i,k)));
			}
		}
		this.getCenter(OrientedBoundBox._tempV35);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
		var vsepAe=OrientedBoundBox._tempV31.elements;
		vsepAe[0]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
		vsepAe[1]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
		vsepAe[2]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
		var _tempV33e=OrientedBoundBox._tempV33.elements;
		var _tempV34e=OrientedBoundBox._tempV34.elements;
		for (i=0;i < 3;i++){
			_tempV33e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			_tempV33e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			_tempV33e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
			separation=Math.abs(vsepAe[i]);
			if (separation > extentA+extentB)
				return 0;
		}
		for (k=0;k < 3;k++){
			_tempV33e[0]=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			_tempV33e[1]=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			_tempV33e[2]=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			_tempV34e[0]=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			_tempV34e[1]=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			_tempV34e[2]=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV33);
			extentB=sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV34));
			if (separation > extentA+extentB)
				return 0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+sizeAe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=sizeBe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return 0;
			}
		}
		return 2;
	}

	/**
	*该包围盒是否与空间中另一射线相交
	*@param ray
	*@param out
	*@return
	*/
	__proto.intersectsRay=function(ray,out){
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV30);
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.TransformNormal(ray.direction,OrientedBoundBox._tempM0,OrientedBoundBox._ray.direction);
		Vector3.transformCoordinate(ray.origin,OrientedBoundBox._tempM0,OrientedBoundBox._ray.origin);
		OrientedBoundBox._boxBound1.min=OrientedBoundBox._tempV30;
		OrientedBoundBox._boxBound1.max=this.extents;
		var intersects=Collision.intersectsRayAndBoxRP(OrientedBoundBox._ray,OrientedBoundBox._boxBound1,out);
		if (intersects!==-1)
			Vector3.transformCoordinate(out,this.transformation,out);
		return intersects;
	}

	__proto._getLocalCorners=function(corners){
		corners.length=8;
		var extentsE=this.extents.elements;
		OrientedBoundBox._tempV30.x=extentsE[0];
		OrientedBoundBox._tempV31.y=extentsE[1];
		OrientedBoundBox._tempV32.z=extentsE[2];
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV30,corners[2]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[3]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[4]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[5]);
		Vector3.scale(corners[0],-1,corners[6]);
		Vector3.subtract(OrientedBoundBox._tempV32,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV31,corners[7]);
	}

	/**
	*判断两个包围盒是否相等
	*@param obb obb包围盒
	*@return Boolean
	*/
	__proto.equals=function(obb){
		return this.extents==obb.extents && this.transformation==obb.transformation;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.extents.cloneTo(dest.extents);
		this.transformation.cloneTo(dest.transformation);
	}

	OrientedBoundBox.createByBoundBox=function(box,out){
		var min=box.min;
		var max=box.max;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var extents=OrientedBoundBox._tempV32.clone();
		var transformation=OrientedBoundBox._tempM0.clone();
		out.extents=extents;
		out.transformation=transformation;
	}

	OrientedBoundBox.createByMinAndMaxVertex=function(min,max){
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var obb=new OrientedBoundBox(OrientedBoundBox._tempV32,OrientedBoundBox._tempM0);
		return obb;
	}

	OrientedBoundBox._getRows=function(mat,out){
		out.length=3;
		var mate=mat.elements;
		var row0e=out[0].elements;
		row0e[0]=mate[0];
		row0e[1]=mate[1];
		row0e[2]=mate[2];
		var row1e=out[1].elements;
		row1e[0]=mate[4];
		row1e[1]=mate[5];
		row1e[2]=mate[6];
		var row2e=out[2].elements;
		row2e[0]=mate[8];
		row2e[1]=mate[9];
		row2e[2]=mate[10];
	}

	OrientedBoundBox.getObbtoObbMatrix4x4=function(a,b,noMatrixScaleApplied,out){
		var at=a.transformation;
		var bt=b.transformation;
		if (noMatrixScaleApplied){
			OrientedBoundBox._getRows(at,OrientedBoundBox._rows1);
			OrientedBoundBox._getRows(bt,OrientedBoundBox._rows2);
			for (var i=0;i < 3;i++){
				for (var k=0;k < 3;k++){
					out.setElementByRowColumn(i,k,Vector3.dot(OrientedBoundBox._rows2[i],OrientedBoundBox._rows1[k]));
				}
			}
			b.getCenter(OrientedBoundBox._tempV30);
			a.getCenter(OrientedBoundBox._tempV31);
			Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
			var AtoBMe=out.elements;
			AtoBMe[12]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
			AtoBMe[13]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
			AtoBMe[14]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
			AtoBMe[15]=1;
			}else {
			at.invert(OrientedBoundBox._tempM0);
			Matrix4x4.multiply(bt,OrientedBoundBox._tempM0,out);
		}
	}

	OrientedBoundBox.merge=function(a,b,noMatrixScaleApplied){
		var ae=a.extents;
		var at=a.transformation;
		OrientedBoundBox.getObbtoObbMatrix4x4(a,b,noMatrixScaleApplied,OrientedBoundBox._tempM0);
		b._getLocalCorners(OrientedBoundBox._corners);
		Vector3.transformCoordinate(OrientedBoundBox._corners[0],OrientedBoundBox._tempM0,OrientedBoundBox._corners[0]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[1],OrientedBoundBox._tempM0,OrientedBoundBox._corners[1]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[2],OrientedBoundBox._tempM0,OrientedBoundBox._corners[2]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[3],OrientedBoundBox._tempM0,OrientedBoundBox._corners[3]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[4],OrientedBoundBox._tempM0,OrientedBoundBox._corners[4]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[5],OrientedBoundBox._tempM0,OrientedBoundBox._corners[5]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[6],OrientedBoundBox._tempM0,OrientedBoundBox._corners[6]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[7],OrientedBoundBox._tempM0,OrientedBoundBox._corners[7]);
		Vector3.scale(ae,-1,OrientedBoundBox._boxBound1.min);
		ae.cloneTo(OrientedBoundBox._boxBound1.max);
		BoundBox.createfromPoints(OrientedBoundBox._corners,OrientedBoundBox._boxBound2);
		BoundBox.merge(OrientedBoundBox._boxBound2,OrientedBoundBox._boxBound1,OrientedBoundBox._boxBound3);
		var box3Min=OrientedBoundBox._boxBound3.min;
		var box3Max=OrientedBoundBox._boxBound3.max;
		Vector3.subtract(box3Max,box3Min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(box3Min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV32);
		Vector3.subtract(box3Max,OrientedBoundBox._tempV32,ae);
		Vector3.transformCoordinate(OrientedBoundBox._tempV32,at,OrientedBoundBox._tempV33);
	}

	__static(OrientedBoundBox,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempM0',function(){return this._tempM0=new Matrix4x4();},'_tempM1',function(){return this._tempM1=new Matrix4x4();},'_corners',function(){return this._corners=[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];},'_rows1',function(){return this._rows1=[new Vector3(),new Vector3(),new Vector3()];},'_rows2',function(){return this._rows2=[new Vector3(),new Vector3(),new Vector3()];},'_ray',function(){return this._ray=new Ray(new Vector3(),new Vector3());},'_boxBound1',function(){return this._boxBound1=new BoundBox(new Vector3(),new Vector3());},'_boxBound2',function(){return this._boxBound2=new BoundBox(new Vector3(),new Vector3());},'_boxBound3',function(){return this._boxBound3=new BoundBox(new Vector3(),new Vector3());}
	]);
	return OrientedBoundBox;
})()


/**
*<code>Plane</code> 类用于创建平面。
*/
//class laya.d3.math.Plane
var Plane=(function(){
	function Plane(normal,d){
		/**平面的向量*/
		this.normal=null;
		/**平面到坐标系原点的距离*/
		this.distance=NaN;
		(d===void 0)&& (d=0);
		this.normal=normal;
		this.distance=d;
	}

	__class(Plane,'laya.d3.math.Plane');
	var __proto=Plane.prototype;
	/**
	*更改平面法线向量的系数，使之成单位长度。
	*/
	__proto.normalize=function(){
		var normalE=this.normal.elements;
		var normalEX=normalE[0];
		var normalEY=normalE[1];
		var normalEZ=normalE[2];
		var magnitude=1 / Math.sqrt(normalEX *normalEX+normalEY *normalEY+normalEZ *normalEZ);
		normalE[0]=normalEX *magnitude;
		normalE[1]=normalEY *magnitude;
		normalE[2]=normalEZ *magnitude;
		this.distance *=magnitude;
	}

	Plane.createPlaneBy3P=function(point1,point2,point3){
		var point1e=point1.elements;
		var point2e=point2.elements;
		var point3e=point3.elements;
		var x1=point2e[0]-point1e[0];
		var y1=point2e[1]-point1e[1];
		var z1=point2e[2]-point1e[2];
		var x2=point3e[0]-point1e[0];
		var y2=point3e[1]-point1e[1];
		var z2=point3e[2]-point1e[2];
		var yz=(y1 *z2)-(z1 *y2);
		var xz=(z1 *x2)-(x1 *z2);
		var xy=(x1 *y2)-(y1 *x2);
		var invPyth=1 / (Math.sqrt((yz *yz)+(xz *xz)+(xy *xy)));
		var x=yz *invPyth;
		var y=xz *invPyth;
		var z=xy *invPyth;
		var TEMPVec3e=Plane._TEMPVec3.elements;
		TEMPVec3e[0]=x;
		TEMPVec3e[1]=y;
		TEMPVec3e[2]=z;
		var d=-((x *point1e[0])+(y *point1e[1])+(z *point1e[2]));
		var plane=new Plane(Plane._TEMPVec3,d);
		return plane;
	}

	Plane.PlaneIntersectionType_Back=0;
	Plane.PlaneIntersectionType_Front=1;
	Plane.PlaneIntersectionType_Intersecting=2;
	__static(Plane,
	['_TEMPVec3',function(){return this._TEMPVec3=new Vector3();}
	]);
	return Plane;
})()


/**
*<code>Quaternion</code> 类用于创建四元数。
*/
//class laya.d3.math.Quaternion
var Quaternion=(function(){
	function Quaternion(x,y,z,w){
		this.elements=new Float32Array(4);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=1);
		this.elements[0]=x;
		this.elements[1]=y;
		this.elements[2]=z;
		this.elements[3]=w;
	}

	__class(Quaternion,'laya.d3.math.Quaternion');
	var __proto=Quaternion.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*根据缩放值缩放四元数
	*@param scale 缩放值
	*@param out 输出四元数
	*/
	__proto.scaling=function(scaling,out){
		var e=out.elements;
		var f=this.elements;
		e[0]=f[0] *scaling;
		e[1]=f[1] *scaling;
		e[2]=f[2] *scaling;
		e[3]=f[3] *scaling;
	}

	/**
	*归一化四元数
	*@param out 输出四元数
	*/
	__proto.normalize=function(out){
		var e=out.elements;
		var f=this.elements;
		var x=f[0],y=f[1],z=f[2],w=f[3];
		var len=x *x+y *y+z *z+w *w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			e[0]=x *len;
			e[1]=y *len;
			e[2]=z *len;
			e[3]=w *len;
		}
	}

	/**
	*计算四元数的长度
	*@return 长度
	*/
	__proto.length=function(){
		var f=this.elements;
		var x=f[0],y=f[1],z=f[2],w=f[3];
		return Math.sqrt(x *x+y *y+z *z+w *w);
	}

	/**
	*根据绕X轴的角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateX=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		var bx=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+aw *bx;
		e[1]=ay *bw+az *bx;
		e[2]=az *bw-ay *bx;
		e[3]=aw *bw-ax *bx;
	}

	/**
	*根据绕Y轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateY=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],by=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw-az *by;
		e[1]=ay *bw+aw *by;
		e[2]=az *bw+ax *by;
		e[3]=aw *bw-ay *by;
	}

	/**
	*根据绕Z轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateZ=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],bz=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+ay *bz;
		e[1]=ay *bw-ax *bz;
		e[2]=az *bw+aw *bz;
		e[3]=aw *bw-az *bz;
	}

	/**
	*分解四元数到欧拉角（顺序为Yaw、Pitch、Roll），参考自http://xboxforums.create.msdn.com/forums/p/4574/23988.aspx#23988,问题绕X轴翻转超过±90度时有，会产生瞬间反转
	*@param quaternion 源四元数
	*@param out 欧拉角值
	*/
	__proto.getYawPitchRoll=function(out){
		Vector3.transformQuat(Vector3.ForwardRH,this,Quaternion.TEMPVector31);
		Vector3.transformQuat(Vector3.Up,this,Quaternion.TEMPVector32);
		var upe=Quaternion.TEMPVector32.elements;
		Quaternion.angleTo(Vector3.ZERO,Quaternion.TEMPVector31,Quaternion.TEMPVector33);
		var anglee=Quaternion.TEMPVector33.elements;
		if (anglee[0]==Math.PI / 2){
			anglee[1]=Quaternion.arcTanAngle(upe[2],upe[0]);
			anglee[2]=0;
			}else if (anglee[0]==-Math.PI / 2){
			anglee[1]=Quaternion.arcTanAngle(-upe[2],-upe[0]);
			anglee[2]=0;
			}else {
			Matrix4x4.createRotationY(-anglee[1],Quaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-anglee[0],Quaternion.TEMPMatrix1);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix0,Quaternion.TEMPVector32);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix1,Quaternion.TEMPVector32);
			anglee[2]=Quaternion.arcTanAngle(upe[1],-upe[0]);
		}
		if (anglee[1] <=-Math.PI)
			anglee[1]=Math.PI;
		if (anglee[2] <=-Math.PI)
			anglee[2]=Math.PI;
		if (anglee[1] >=Math.PI && anglee[2] >=Math.PI){
			anglee[1]=0;
			anglee[2]=0;
			anglee[0]=Math.PI-anglee[0];
		};
		var oe=out.elements;
		oe[0]=anglee[1];
		oe[1]=anglee[0];
		oe[2]=anglee[2];
	}

	/**
	*求四元数的逆
	*@param out 输出四元数
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a0=f[0],a1=f[1],a2=f[2],a3=f[3];
		var dot=a0 *a0+a1 *a1+a2 *a2+a3 *a3;
		var invDot=dot ? 1.0 / dot :0;
		e[0]=-a0 *invDot;
		e[1]=-a1 *invDot;
		e[2]=-a2 *invDot;
		e[3]=a3 *invDot;
	}

	/**
	*设置四元数为单位算数
	*@param out 输出四元数
	*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=0;
		e[1]=0;
		e[2]=0;
		e[3]=1;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 4;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	__proto.equals=function(b){
		var ae=this.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(ae[0],be[0])&& MathUtils3D.nearEqual(ae[1],be[1])&& MathUtils3D.nearEqual(ae[2],be[2])&& MathUtils3D.nearEqual(ae[3],be[3]);
	}

	/**
	*计算长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		var x=this.elements[0];
		var y=this.elements[1];
		var z=this.elements[2];
		var w=this.elements[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	/**
	*获取四元数的x值
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
	});

	/**
	*获取四元数的y值
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
	});

	/**
	*获取四元数的z值
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
	});

	/**
	*获取四元数的w值
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
	});

	Quaternion.createFromYawPitchRoll=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		var oe=out.elements;
		oe[0]=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		oe[1]=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		oe[2]=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		oe[3]=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	Quaternion.multiply=function(left,right,out){
		var le=left.elements;
		var re=right.elements;
		var oe=out.elements;
		var lx=le[0];
		var ly=le[1];
		var lz=le[2];
		var lw=le[3];
		var rx=re[0];
		var ry=re[1];
		var rz=re[2];
		var rw=re[3];
		var a=(ly *rz-lz *ry);
		var b=(lz *rx-lx *rz);
		var c=(lx *ry-ly *rx);
		var d=(lx *rx+ly *ry+lz *rz);
		oe[0]=(lx *rw+rx *lw)+a;
		oe[1]=(ly *rw+ry *lw)+b;
		oe[2]=(lz *rw+rz *lw)+c;
		oe[3]=lw *rw-d;
	}

	Quaternion.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Quaternion.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.elements[0]=Math.asin(Quaternion.TEMPVector30.y);
		angle.elements[1]=Quaternion.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Quaternion.createFromAxisAngle=function(axis,rad,out){
		var e=out.elements;
		var f=axis.elements;
		rad=rad *0.5;
		var s=Math.sin(rad);
		e[0]=s *f[0];
		e[1]=s *f[1];
		e[2]=s *f[2];
		e[3]=Math.cos(rad);
	}

	Quaternion.createFromMatrix3x3=function(sou,out){
		var e=out.elements;
		var f=sou.elements;
		var fTrace=f[0]+f[4]+f[8];
		var fRoot;
		if (fTrace > 0.0){
			fRoot=Math.sqrt(fTrace+1.0);
			e[3]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[0]=(f[5]-f[7])*fRoot;
			e[1]=(f[6]-f[2])*fRoot;
			e[2]=(f[1]-f[3])*fRoot;
			}else {
			var i=0;
			if (f[4] > f[0])
				i=1;
			if (f[8] > f[i *3+i])
				i=2;
			var j=(i+1)% 3;
			var k=(i+2)% 3;
			fRoot=Math.sqrt(f[i *3+i]-f[j *3+j]-f[k *3+k]+1.0);
			e[i]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[3]=(f[j *3+k]-f[k *3+j])*fRoot;
			e[j]=(f[j *3+i]+f[i *3+j])*fRoot;
			e[k]=(f[k *3+i]+f[i *3+k])*fRoot;
		}
		return;
	}

	Quaternion.createFromMatrix4x4=function(mat,out){
		var me=mat.elements;
		var oe=out.elements;
		var sqrt;
		var half;
		var scale=me[0]+me[5]+me[10];
		if (scale > 0.0){
			sqrt=Math.sqrt(scale+1.0);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(me[6]-me[9])*sqrt;
			oe[1]=(me[8]-me[2])*sqrt;
			oe[2]=(me[1]-me[4])*sqrt;
			}else if ((me[0] >=me[5])&& (me[0] >=me[10])){
			sqrt=Math.sqrt(1.0+me[0]-me[5]-me[10]);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(me[1]+me[4])*half;
			oe[2]=(me[2]+me[8])*half;
			oe[3]=(me[6]-me[9])*half;
			}else if (me[5] > me[10]){
			sqrt=Math.sqrt(1.0+me[5]-me[0]-me[10]);
			half=0.5 / sqrt;
			oe[0]=(me[4]+me[1])*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(me[9]+me[6])*half;
			oe[3]=(me[8]-me[2])*half;
			}else {
			sqrt=Math.sqrt(1.0+me[10]-me[0]-me[5]);
			half=0.5 / sqrt;
			oe[0]=(me[8]+me[2])*half;
			oe[1]=(me[9]+me[6])*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(me[1]-me[4])*half;
		}
	}

	Quaternion.slerp=function(left,right,t,out){
		var a=left.elements;
		var b=right.elements;
		var oe=out.elements;
		var ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=b[0],by=b[1],bz=b[2],bw=b[3];
		var omega,cosom,sinom,scale0,scale1;
		cosom=ax *bx+ay *by+az *bz+aw *bw;
		if (cosom < 0.0){
			cosom=-cosom;
			bx=-bx;
			by=-by;
			bz=-bz;
			bw=-bw;
		}
		if ((1.0-cosom)> 0.000001){
			omega=Math.acos(cosom);
			sinom=Math.sin(omega);
			scale0=Math.sin((1.0-t)*omega)/ sinom;
			scale1=Math.sin(t *omega)/ sinom;
			}else {
			scale0=1.0-t;
			scale1=t;
		}
		oe[0]=scale0 *ax+scale1 *bx;
		oe[1]=scale0 *ay+scale1 *by;
		oe[2]=scale0 *az+scale1 *bz;
		oe[3]=scale0 *aw+scale1 *bw;
		return oe;
	}

	Quaternion.lerp=function(left,right,t,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
		e[3]=aw+t *(g[3]-aw);
	}

	Quaternion.add=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
		e[3]=f[3]+g[3];
	}

	Quaternion.dot=function(left,right){
		var f=left.elements;
		var g=right.elements;
		return f[0] *g[0]+f[1] *g[1]+f[2] *g[2]+f[3] *g[3];
	}

	Quaternion.rotationLookAt=function(forward,up,out){
		Quaternion.lookAt(Vector3.ZERO,forward,up,out);
	}

	Quaternion.lookAt=function(eye,target,up,out){
		Matrix3x3.lookAt(eye,target,up,Quaternion._tempMatrix3x3);
		Quaternion.rotationMatrix(Quaternion._tempMatrix3x3,out);
	}

	Quaternion.invert=function(value,out){
		var vE=value.elements;
		var oE=out.elements;
		var lengthSq=value.lengthSquared();
		if (!MathUtils3D.isZero(lengthSq)){
			lengthSq=1.0 / lengthSq;
			oE[0]=-vE[0] *lengthSq;
			oE[1]=-vE[1] *lengthSq;
			oE[2]=-vE[2] *lengthSq;
			oE[3]=vE[3] *lengthSq;
		}
	}

	Quaternion.rotationMatrix=function(matrix3x3,out){
		var me=matrix3x3.elements;
		var m11=me[0];
		var m12=me[1];
		var m13=me[2];
		var m21=me[3];
		var m22=me[4];
		var m23=me[5];
		var m31=me[6];
		var m32=me[7];
		var m33=me[8];
		var oe=out.elements;
		var sqrt=NaN,half=NaN;
		var scale=m11+m22+m33;
		if (scale > 0){
			sqrt=Math.sqrt(scale+1);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(m23-m32)*sqrt;
			oe[1]=(m31-m13)*sqrt;
			oe[2]=(m12-m21)*sqrt;
			}else if ((m11 >=m22)&& (m11 >=m33)){
			sqrt=Math.sqrt(1+m11-m22-m33);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(m12+m21)*half;
			oe[2]=(m13+m31)*half;
			oe[3]=(m23-m32)*half;
			}else if (m22 > m33){
			sqrt=Math.sqrt(1+m22-m11-m33);
			half=0.5 / sqrt;
			oe[0]=(m21+m12)*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(m32+m23)*half;
			oe[3]=(m31-m13)*half;
			}else {
			sqrt=Math.sqrt(1+m33-m11-m22);
			half=0.5 / sqrt;
			oe[0]=(m31+m13)*half;
			oe[1]=(m32+m23)*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(m12-m21)*half;
		}
	}

	__static(Quaternion,
	['TEMPVector30',function(){return this.TEMPVector30=new Vector3();},'TEMPVector31',function(){return this.TEMPVector31=new Vector3();},'TEMPVector32',function(){return this.TEMPVector32=new Vector3();},'TEMPVector33',function(){return this.TEMPVector33=new Vector3();},'TEMPMatrix0',function(){return this.TEMPMatrix0=new Matrix4x4();},'TEMPMatrix1',function(){return this.TEMPMatrix1=new Matrix4x4();},'_tempMatrix3x3',function(){return this._tempMatrix3x3=new Matrix3x3();},'DEFAULT',function(){return this.DEFAULT=new Quaternion();},'NAN',function(){return this.NAN=new Quaternion(NaN,NaN,NaN,NaN);}
	]);
	return Quaternion;
})()


/**
*<code>Rand</code> 类用于通过32位无符号整型随机种子创建随机数。
*/
//class laya.d3.math.Rand
var Rand=(function(){
	function Rand(seed){
		this._temp=new Uint32Array(1);
		this.seeds=new Uint32Array(4);
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	}

	__class(Rand,'laya.d3.math.Rand');
	var __proto=Rand.prototype;
	/**
	*获取无符号32位整形随机数。
	*@return 无符号32位整形随机数。
	*/
	__proto.getUint=function(){
		this._temp[0]=this.seeds[0] ^ (this.seeds[0] << 11);
		this.seeds[0]=this.seeds[1];
		this.seeds[1]=this.seeds[2];
		this.seeds[2]=this.seeds[3];
		this.seeds[3]=(this.seeds[3] ^ (this.seeds[3] >>> 19))^ (this._temp[0] ^ (this._temp[0] >>> 8));
		return this.seeds[3];
	}

	/**
	*获取0到1之间的浮点随机数。
	*@return 0到1之间的浮点随机数。
	*/
	__proto.getFloat=function(){
		this.getUint();
		return (this.seeds[3] & 0x007FFFFF)*(1.0 / 8388607.0);
	}

	/**
	*获取-1到1之间的浮点随机数。
	*@return-1到1之间的浮点随机数。
	*/
	__proto.getSignedFloat=function(){
		return this.getFloat()*2.0-1.0;
	}

	/**
	*设置随机种子。
	*@param seed 随机种子。
	*/
	/**
	*获取随机种子。
	*@return 随机种子。
	*/
	__getset(0,__proto,'seed',function(){
		return this.seeds[0];
		},function(seed){
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	});

	Rand.getFloatFromInt=function(v){
		return (v & 0x007FFFFF)*(1.0 / 8388607.0)
	}

	Rand.getByteFromInt=function(v){
		return (v & 0x007FFFFF)>>> 15;
	}

	return Rand;
})()


/**
*<code>Ray</code> 类用于创建射线。
*/
//class laya.d3.math.Ray
var Ray=(function(){
	function Ray(origin,direction){
		/**原点*/
		this.origin=null;
		/**方向*/
		this.direction=null;
		this.origin=origin;
		this.direction=direction;
	}

	__class(Ray,'laya.d3.math.Ray');
	return Ray;
})()


/**
*<code>Vector2</code> 类用于创建二维向量。
*/
//class laya.d3.math.Vector2
var Vector2=(function(){
	function Vector2(x,y){
		this.elements=new Float32Array(2);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
	}

	__class(Vector2,'laya.d3.math.Vector2');
	var __proto=Vector2.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector2=destObject;
		var destE=destVector2.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector2=new this.constructor();
		this.cloneTo(destVector2);
		return destVector2;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	Vector2.scale=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		e[0]=f[0] *b;
		e[1]=f[1] *b;
	}

	__static(Vector2,
	['ZERO',function(){return this.ZERO=new Vector2(0.0,0.0);},'ONE',function(){return this.ONE=new Vector2(1.0,1.0);}
	]);
	return Vector2;
})()


/**
*<code>Vector3</code> 类用于创建三维向量。
*/
//class laya.d3.math.Vector3
var Vector3=(function(){
	function Vector3(x,y,z){
		this.elements=new Float32Array(3);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
		v[2]=z;
	}

	__class(Vector3,'laya.d3.math.Vector3');
	var __proto=Vector3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector3=destObject;
		var destE=destVector3.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector3=new this.constructor();
		this.cloneTo(destVector3);
		return destVector3;
	}

	__proto.toDefault=function(){
		this.elements[0]=0;
		this.elements[1]=0;
		this.elements[2]=0;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	Vector3.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return (x *x)+(y *y)+(z *z);
	}

	Vector3.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return Math.sqrt((x *x)+(y *y)+(z *z));
	}

	Vector3.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
	}

	Vector3.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
	}

	Vector3.transformQuat=function(source,rotation,out){
		var destination=out.elements;
		var se=source.elements;
		var re=rotation.elements;
		var x=se[0],y=se[1],z=se[2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		destination[0]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		destination[1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		destination[2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Vector3.scalarLength=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return Math.sqrt(x *x+y *y+z *z);
	}

	Vector3.scalarLengthSquared=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return x *x+y *y+z *z;
	}

	Vector3.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var x=se[0],y=se[1],z=se[2];
		var len=x *x+y *y+z *z;
		if (len > 0){
			len=1 / Math.sqrt(len);
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
		}
	}

	Vector3.multiply=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0] *g[0];
		e[1]=f[1] *g[1];
		e[2]=f[2] *g[2];
	}

	Vector3.scale=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		e[0]=f[0] *b;
		e[1]=f[1] *b;
		e[2]=f[2] *b;
	}

	Vector3.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
	}

	Vector3.transformV3ToV3=function(vector,transform,result){
		var intermediate=Vector3._tempVector4;
		Vector3.transformV3ToV4(vector,transform,intermediate);
		var intermediateElem=intermediate.elements;
		var resultElem=result.elements;
		resultElem[0]=intermediateElem[0];
		resultElem[1]=intermediateElem[1];
		resultElem[2]=intermediateElem[2];
	}

	Vector3.transformV3ToV4=function(vector,transform,result){
		var vectorElem=vector.elements;
		var vectorX=vectorElem[0];
		var vectorY=vectorElem[1];
		var vectorZ=vectorElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(vectorX *transformElem[0])+(vectorY *transformElem[4])+(vectorZ *transformElem[8])+transformElem[12];
		resultElem[1]=(vectorX *transformElem[1])+(vectorY *transformElem[5])+(vectorZ *transformElem[9])+transformElem[13];
		resultElem[2]=(vectorX *transformElem[2])+(vectorY *transformElem[6])+(vectorZ *transformElem[10])+transformElem[14];
		resultElem[3]=(vectorX *transformElem[3])+(vectorY *transformElem[7])+(vectorZ *transformElem[11])+transformElem[15];
	}

	Vector3.TransformNormal=function(normal,transform,result){
		var normalElem=normal.elements;
		var normalX=normalElem[0];
		var normalY=normalElem[1];
		var normalZ=normalElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(normalX *transformElem[0])+(normalY *transformElem[4])+(normalZ *transformElem[8]);
		resultElem[1]=(normalX *transformElem[1])+(normalY *transformElem[5])+(normalZ *transformElem[9]);
		resultElem[2]=(normalX *transformElem[2])+(normalY *transformElem[6])+(normalZ *transformElem[10]);
	}

	Vector3.transformCoordinate=function(coordinate,transform,result){
		var vectorElem=Vector3._tempVector4.elements;
		var coordinateElem=coordinate.elements;
		var coordinateX=coordinateElem[0];
		var coordinateY=coordinateElem[1];
		var coordinateZ=coordinateElem[2];
		var transformElem=transform.elements;
		vectorElem[0]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12];
		vectorElem[1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13];
		vectorElem[2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14];
		vectorElem[3]=1.0 / ((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		var resultElem=result.elements;
		resultElem[0]=vectorElem[0] *vectorElem[3];
		resultElem[1]=vectorElem[1] *vectorElem[3];
		resultElem[2]=vectorElem[2] *vectorElem[3];
	}

	Vector3.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
	}

	Vector3.add=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
	}

	Vector3.subtract=function(a,b,o){
		var oe=o.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
	}

	Vector3.cross=function(a,b,o){
		var ae=a.elements;
		var be=b.elements;
		var oe=o.elements;
		var ax=ae[0],ay=ae[1],az=ae[2],bx=be[0],by=be[1],bz=be[2];
		oe[0]=ay *bz-az *by;
		oe[1]=az *bx-ax *bz;
		oe[2]=ax *by-ay *bx;
	}

	Vector3.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2]);
		return r;
	}

	Vector3.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(Math.abs(ae[0]),Math.abs(be[0]))&& MathUtils3D.nearEqual(Math.abs(ae[1]),Math.abs(be[1]))&& MathUtils3D.nearEqual(Math.abs(ae[2]),Math.abs(be[2]));
	}

	__static(Vector3,
	['_tempVector4',function(){return this._tempVector4=new Vector4();},'ZERO',function(){return this.ZERO=new Vector3(0.0,0.0,0.0);},'ONE',function(){return this.ONE=new Vector3(1.0,1.0,1.0);},'NegativeUnitX',function(){return this.NegativeUnitX=new Vector3(-1,0,0);},'UnitX',function(){return this.UnitX=new Vector3(1,0,0);},'UnitY',function(){return this.UnitY=new Vector3(0,1,0);},'UnitZ',function(){return this.UnitZ=new Vector3(0,0,1);},'ForwardRH',function(){return this.ForwardRH=new Vector3(0,0,-1);},'ForwardLH',function(){return this.ForwardLH=new Vector3(0,0,1);},'Up',function(){return this.Up=new Vector3(0,1,0);},'NAN',function(){return this.NAN=new Vector3(NaN,NaN,NaN);}
	]);
	return Vector3;
})()


/**
*<code>Vector4</code> 类用于创建四维向量。
*/
//class laya.d3.math.Vector4
var Vector4=(function(){
	function Vector4(x,y,z,w){
		this.elements=new Float32Array(4);
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=0);
		var v=this.elements;
		v[0]=x;
		v[1]=y;
		v[2]=z;
		v[3]=w;
	}

	__class(Vector4,'laya.d3.math.Vector4');
	var __proto=Vector4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector4=destObject;
		var destE=destVector4.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
		destE[3]=s[3];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector4=new this.constructor();
		this.cloneTo(destVector4);
		return destVector4;
	}

	/**
	*求四维向量的长度。
	*@return 长度。
	*/
	__proto.length=function(){
		return Math.sqrt(this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w);
	}

	/**
	*求四维向量长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		return this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	/**
	*设置W轴坐标。
	*@param value W轴坐标。
	*/
	/**
	*获取W轴坐标。
	*@return W轴坐标。
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
		},function(value){
		this.elements[3]=value;
	});

	Vector4.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
		e[3]=aw+t *(g[3]-aw);
	}

	Vector4.transformByM4x4=function(vector4,m4x4,out){
		var ve=vector4.elements;
		var vx=ve[0];
		var vy=ve[1];
		var vz=ve[2];
		var vw=ve[3];
		var me=m4x4.elements;
		var oe=out.elements;
		oe[0]=vx *me[0]+vy *me[4]+vz *me[8]+vw *me[12];
		oe[1]=vx *me[1]+vy *me[5]+vz *me[9]+vw *me[13];
		oe[2]=vx *me[2]+vy *me[6]+vz *me[10]+vw *me[14];
		oe[3]=vx *me[3]+vy *me[7]+vz *me[11]+vw *me[15];
	}

	Vector4.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(Math.abs(ae[0]),Math.abs(be[0]))&& MathUtils3D.nearEqual(Math.abs(ae[1]),Math.abs(be[1]))&& MathUtils3D.nearEqual(Math.abs(ae[2]),Math.abs(be[2]))&& MathUtils3D.nearEqual(Math.abs(ae[3]),Math.abs(be[3]));
	}

	Vector4.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var len=/*if err,please use iflash.method.xmlLength()*/s.length();
		if (len > 0){
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
			oe[3]=se[3] *len;
		}
	}

	Vector4.add=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]+be[0];
		oe[1]=ae[1]+be[1];
		oe[2]=ae[2]+be[2];
		oe[3]=ae[3]+be[3];
	}

	Vector4.subtract=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
		oe[3]=ae[3]-be[3];
	}

	Vector4.multiply=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0] *be[0];
		oe[1]=ae[1] *be[1];
		oe[2]=ae[2] *be[2];
		oe[3]=ae[3] *be[3];
	}

	Vector4.scale=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		oe[0]=ae[0] *b;
		oe[1]=ae[1] *b;
		oe[2]=ae[2] *b;
		oe[3]=ae[3] *b;
	}

	Vector4.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var w=valuee[3];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var mineW=mine[3];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var maxeW=maxe[3];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		w=(w > maxeW)? maxeW :w;
		w=(w < mineW)? mineW :w;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
		oute[3]=w;
	}

	Vector4.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	Vector4.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return Math.sqrt((x *x)+(y *y)+(z *z)+(w *w));
	}

	Vector4.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2])+(ae[3] *be[3]);
		return r;
	}

	Vector4.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
		e[3]=Math.min(f[3],g[3]);
	}

	Vector4.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
		e[3]=Math.max(f[3],g[3]);
	}

	__static(Vector4,
	['ZERO',function(){return this.ZERO=new Vector4();},'ONE',function(){return this.ONE=new Vector4(1.0,1.0,1.0,1.0);},'UnitX',function(){return this.UnitX=new Vector4(1.0,0.0,0.0,0.0);},'UnitY',function(){return this.UnitY=new Vector4(0.0,1.0,0.0,0.0);},'UnitZ',function(){return this.UnitZ=new Vector4(0.0,0.0,1.0,0.0);},'UnitW',function(){return this.UnitW=new Vector4(0.0,0.0,0.0,1.0);}
	]);
	return Vector4;
})()


/**
*<code>Viewport</code> 类用于创建视口。
*/
//class laya.d3.math.Viewport
var Viewport=(function(){
	function Viewport(x,y,width,height){
		/**X轴坐标*/
		//this.x=NaN;
		/**Y轴坐标*/
		//this.y=NaN;
		/**宽度*/
		//this.width=NaN;
		/**高度*/
		//this.height=NaN;
		/**最小深度*/
		//this.minDepth=NaN;
		/**最大深度*/
		//this.maxDepth=NaN;
		this.minDepth=0.0;
		this.maxDepth=1.0;
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
	}

	__class(Viewport,'laya.d3.math.Viewport');
	var __proto=Viewport.prototype;
	/**
	*变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.project=function(source,matrix,out){
		Vector3.transformV3ToV3(source,matrix,out);
		var sourceEleme=source.elements;
		var matrixEleme=matrix.elements;
		var outEleme=out.elements;
		var a=(((sourceEleme[0] *matrixEleme[3])+(sourceEleme[1] *matrixEleme[7]))+(sourceEleme[2] *matrixEleme[11]))+matrixEleme[15];
		if (a!==1.0){
			outEleme[0]=outEleme[0] / a;
			outEleme[1]=outEleme[1] / a;
			outEleme[2]=outEleme[2] / a;
		}
		outEleme[0]=(((outEleme[0]+1.0)*0.5)*this.width)+this.x;
		outEleme[1]=(((-outEleme[1]+1.0)*0.5)*this.height)+this.y;
		outEleme[2]=(outEleme[2] *(this.maxDepth-this.minDepth))+this.minDepth;
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.unprojectFromMat=function(source,matrix,out){
		var sourceEleme=source.elements;
		var matrixEleme=matrix.elements;
		var outEleme=out.elements;
		outEleme[0]=(((sourceEleme[0]-this.x)/ (this.width))*2.0)-1.0;
		outEleme[1]=-((((sourceEleme[1]-this.y)/ (this.height))*2.0)-1.0);
		var halfDepth=(this.maxDepth-this.minDepth)/ 2;
		outEleme[2]=(sourceEleme[2]-this.minDepth-halfDepth)/ halfDepth;
		var a=(((outEleme[0] *matrixEleme[3])+(outEleme[1] *matrixEleme[7]))+(outEleme[2] *matrixEleme[11]))+matrixEleme[15];
		Vector3.transformV3ToV3(out,matrix,out);
		if (a!==1.0){
			outEleme[0]=outEleme[0] / a;
			outEleme[1]=outEleme[1] / a;
			outEleme[2]=outEleme[2] / a;
		}
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param projection 透视投影矩阵。
	*@param view 视图矩阵。
	*@param world 世界矩阵,可设置为null。
	*@param out 输出向量。
	*/
	__proto.unprojectFromWVP=function(source,projection,view,world,out){
		Matrix4x4.multiply(projection,view,Viewport._tempMatrix4x4);
		(world)&& (Matrix4x4.multiply(Viewport._tempMatrix4x4,world,Viewport._tempMatrix4x4));
		Viewport._tempMatrix4x4.invert(Viewport._tempMatrix4x4);
		this.unprojectFromMat(source,Viewport._tempMatrix4x4,out);
	}

	__static(Viewport,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();}
	]);
	return Viewport;
})()


/**
*<code>Sky</code> 类用于创建天空的父类，抽象类不允许实例。
*/
//class laya.d3.resource.models.Sky
var Sky=(function(){
	function Sky(){
		/**@private */
		//this.__ownerCamera=null;
		/**@private 透明混合度。 */
		this._alphaBlending=1.0;
		/**@private 颜色强度。 */
		this._colorIntensity=1.0;
		/**@private */
		//this._vertexBuffer=null;
		/**@private */
		//this._indexBuffer=null;
		/**@private */
		//this._sharderNameID=0;
		/**@private */
		//this._shader=null;
		/**@private */
		//this._shaderValue=null;
		/**@private */
		//this._shaderCompile=null;
		/**@private */
		//this._environmentDiffuse=null;
		/**@private */
		//this._environmentSpecular=null;
		/**@private */
		//this._conchSky=null;
		;
		this._shaderValue=new ValusArray();
		if (Render.isConchNode){
			this._conchSky=new ConchSkyMesh();
		}
	}

	__class(Sky,'laya.d3.resource.models.Sky');
	var __proto=Sky.prototype;
	/**
	*@private
	*/
	__proto._setEnvironmentDiffuse=function(){
		if (this._environmentDiffuse.loaded){
			this.__ownerCamera._shaderValues.setValue(7,this._environmentDiffuse);
			}else {
			this._environmentDiffuse.on("loaded",this,this._environmentDiffuseLoaded);
		}
	}

	/**
	*@private
	*/
	__proto._setEnvironmentSpecular=function(){
		if (this._environmentSpecular.loaded){
			var si=this._environmentSpecular['simLodInfo'];
			if (si && (si instanceof Float32Array))
				this.__ownerCamera._shaderValues.setValue(9,si);
			this.__ownerCamera._shaderValues.setValue(8,this._environmentSpecular);
			}else {
			this._environmentSpecular.on("loaded",this,this._environmentSpecularLoaded);
		}
	}

	/**
	*@private
	*/
	__proto._environmentDiffuseLoaded=function(){
		this.__ownerCamera._shaderValues.setValue(7,this._environmentDiffuse);
	}

	/**
	*@private
	*/
	__proto._environmentSpecularLoaded=function(){
		var si=this._environmentSpecular['simLodInfo'];
		if (si && (si instanceof Float32Array))
			this.__ownerCamera._shaderValues.setValue(9,si);
		this.__ownerCamera._shaderValues.setValue(8,this._environmentSpecular);
	}

	/**
	*@private
	*/
	__proto._render=function(state){}
	/**
	*销毁天空。
	*/
	__proto.destroy=function(){
		this.__ownerCamera=null;
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_ownerCamera',null,function(value){
		this.__ownerCamera=value;
		(this._environmentDiffuse)&& (this._setEnvironmentDiffuse());
		(this._environmentSpecular)&& (this._setEnvironmentSpecular());
	});

	/**
	*设置透明混合度。
	*@param value 透明混合度。
	*/
	/**
	*获取透明混合度。
	*@return 透明混合度。
	*/
	__getset(0,__proto,'alphaBlending',function(){
		return this._alphaBlending;
		},function(value){
		this._alphaBlending=value;
		if (this._alphaBlending < 0)
			this._alphaBlending=0;
		if (this._alphaBlending > 1)
			this._alphaBlending=1;
		if (this._conchSky){
			this._conchSky.setShaderValue(2,this._alphaBlending,2);
		}
	});

	__getset(0,__proto,'envDiffuseSHBlue',null,function(value){
		this.__ownerCamera._shaderValues.setValue(12,value);
	});

	/**
	*设置颜色强度。
	*@param value 颜色强度。
	*/
	/**
	*获取颜色强度。
	*@return 颜色强度。
	*/
	__getset(0,__proto,'colorIntensity',function(){
		return this._colorIntensity;
		},function(value){
		this._colorIntensity=value;
		if (this._colorIntensity < 0)
			this._colorIntensity=0;
		if (this._conchSky){
			this._conchSky.setShaderValue(1,this._colorIntensity,2);
		}
	});

	__getset(0,__proto,'envDiffuseSHGreen',null,function(value){
		this.__ownerCamera._shaderValues.setValue(11,value);
	});

	__getset(0,__proto,'envDiffuseSHRed',null,function(value){
		this.__ownerCamera._shaderValues.setValue(10,value);
	});

	/**
	*设置环境漫反射贴图。
	*@param value 环境漫反射贴图。
	*/
	/**
	*获取环境漫反射贴图。
	*@return 环境漫反射贴图。
	*/
	__getset(0,__proto,'environmentDiffuse',function(){
		return this._environmentDiffuse;
		},function(value){
		value.minFifter=0x2600;
		this._environmentDiffuse=value;
		(this.__ownerCamera)&& (this._setEnvironmentDiffuse());
	});

	/**
	*设置环境高光贴图。
	*@param value 环境高光贴图。
	*/
	/**
	*获取环境高光贴图。
	*@return 环境高光贴图。
	*/
	__getset(0,__proto,'environmentSpecular',function(){
		return this._environmentSpecular;
		},function(value){
		this._environmentSpecular=value;
		(this.__ownerCamera)&& (this._setEnvironmentSpecular());
	});

	Sky.MVPMATRIX=0;
	Sky.INTENSITY=1;
	Sky.ALPHABLENDING=2;
	Sky.DIFFUSETEXTURE=3;
	return Sky;
})()


/**
*<code>SubMesh</code> 类用于创建子网格数据模板。
*/
//class laya.d3.resource.models.SubMesh
var SubMesh=(function(){
	function SubMesh(mesh){
		/**@private */
		this._mesh=null;
		/**@private */
		this._boneIndicesList=null;
		/**@private */
		this._subIndexBufferStart=null;
		/**@private */
		this._subIndexBufferCount=null;
		/**@private */
		this._skinAnimationDatas=null;
		/**@private */
		this._bufferUsage=null;
		/**@private */
		this._indexInMesh=0;
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._vertexStart=0;
		/**@private */
		this._vertexCount=0;
		/**@private */
		this._indexBuffer=null;
		/**@private */
		this._indexStart=0;
		/**@private */
		this._indexCount=0;
		/**@private */
		this._indices=null;
		this._bufferUsage={};
		this._mesh=mesh;
		this._boneIndicesList=[];
		this._subIndexBufferStart=[];
		this._subIndexBufferCount=[];
	}

	__class(SubMesh,'laya.d3.resource.models.SubMesh');
	var __proto=SubMesh.prototype;
	Laya.imps(__proto,{"laya.d3.core.render.IRenderable":true,"laya.resource.IDispose":true})
	/**
	*@private
	*/
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer;
		else
		return null;
	}

	/**
	*@private
	*/
	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	/**
	*@private
	*/
	__proto._getStaticBatchBakedVertexs=function(batchOwnerTransform,owner){
		var byteSizeInFloat=4;
		var vertexBuffer=this._vertexBuffer;
		var vertexDeclaration=vertexBuffer.vertexDeclaration;
		var positionOffset=vertexDeclaration.getVertexElementByUsage(0).offset / byteSizeInFloat;
		var normalOffset=vertexDeclaration.getVertexElementByUsage(3).offset / byteSizeInFloat;
		var lightmapScaleOffset=owner.meshRender.lightmapScaleOffset;
		var i=0,n=0,bakedVertexes,bakedVertexFloatCount=0,lightingMapTexcoordOffset=0,uv1Element;
		var uv0Offset=0,oriVertexFloatCount=0;
		if (lightmapScaleOffset){
			uv1Element=vertexDeclaration.getVertexElementByUsage(15);
			if (uv1Element){
				bakedVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
				if (this._vertexCount > 0)
					bakedVertexes=vertexBuffer.getData().slice(this._vertexStart *bakedVertexFloatCount,(this._vertexStart+this._vertexCount)*bakedVertexFloatCount);
				else
				bakedVertexes=vertexBuffer.getData().slice();
				lightingMapTexcoordOffset=uv1Element.offset / byteSizeInFloat;
				}else {
				oriVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
				bakedVertexFloatCount=oriVertexFloatCount+2;
				if (this._vertexCount)
					bakedVertexes=new Float32Array(this._vertexCount *(vertexBuffer.vertexDeclaration.vertexStride / byteSizeInFloat+2));
				else
				bakedVertexes=new Float32Array(vertexBuffer.vertexCount *(vertexBuffer.vertexDeclaration.vertexStride / byteSizeInFloat+2));
				uv0Offset=vertexDeclaration.getVertexElementByUsage(2).offset / byteSizeInFloat;
				lightingMapTexcoordOffset=uv0Offset+2;
				var oriVertexes=vertexBuffer.getData();
				for (i=0,n=oriVertexes.length / oriVertexFloatCount;i < n;i++){
					var oriVertexOffset=0;
					if (this._vertexCount > 0)
						oriVertexOffset=(this._vertexStart+i)*oriVertexFloatCount;
					else
					oriVertexOffset=i *oriVertexFloatCount;
					var bakedVertexOffset=i *bakedVertexFloatCount;
					var j=0;
					for (j=0;j < lightingMapTexcoordOffset;j++)
					bakedVertexes[bakedVertexOffset+j]=oriVertexes[oriVertexOffset+j];
					for (j=lightingMapTexcoordOffset;j < oriVertexFloatCount;j++)
					bakedVertexes[bakedVertexOffset+j+2]=oriVertexes[oriVertexOffset+j];
				}
			}
			}else {
			bakedVertexFloatCount=vertexDeclaration.vertexStride / byteSizeInFloat;
			if (this._vertexCount)
				bakedVertexes=vertexBuffer.getData().slice(this._vertexStart *bakedVertexFloatCount,(this._vertexStart+this._vertexCount)*bakedVertexFloatCount);
			else
			bakedVertexes=vertexBuffer.getData().slice();
		}
		if (batchOwnerTransform){
			var rootMat=batchOwnerTransform.worldMatrix;
			var rootInvertMat=SubMesh._tempMatrix4x40;
			rootMat.invert(rootInvertMat);
			var result=SubMesh._tempMatrix4x41;
			var transform=owner.transform.worldMatrix;
			Matrix4x4.multiply(rootInvertMat,transform,result);
			}else {
			result=owner.transform.worldMatrix;
		};
		var rotation=SubMesh._tempQuaternion0;
		result.decomposeTransRotScale(SubMesh._tempVector30,rotation,SubMesh._tempVector31);
		for (i=0,n=bakedVertexes.length / bakedVertexFloatCount;i < n;i++){
			var posOffset=i *bakedVertexFloatCount+positionOffset;
			var norOffset=i *bakedVertexFloatCount+normalOffset;
			Utils3D.transformVector3ArrayToVector3ArrayCoordinate(bakedVertexes,posOffset,result,bakedVertexes,posOffset);
			Utils3D.transformVector3ArrayByQuat(bakedVertexes,norOffset,rotation,bakedVertexes,norOffset);
			if (lightmapScaleOffset){
				var lightingMapTexOffset=i *bakedVertexFloatCount+lightingMapTexcoordOffset;
				if (uv1Element){
					Utils3D.transformLightingMapTexcoordByUV1Array(bakedVertexes,lightingMapTexOffset,lightmapScaleOffset,bakedVertexes,lightingMapTexOffset);
					}else {
					var tex0Offset=i *oriVertexFloatCount+uv0Offset;
					Utils3D.transformLightingMapTexcoordByUV0Array(oriVertexes,tex0Offset,lightmapScaleOffset,bakedVertexes,lightingMapTexOffset);
				}
			}
		}
		return bakedVertexes;
	}

	/**
	*@private
	*/
	__proto._getVertexBuffers=function(){
		return null;
	}

	/**
	*@private
	*/
	__proto._beforeRender=function(state){
		this._vertexBuffer._bind();
		this._indexBuffer._bind();
		return true;
	}

	/**
	*@private
	*渲染。
	*@param state 渲染状态。
	*/
	__proto._render=function(state){
		var skinAnimationDatas;
		var indexCount=0;
		var renderElement=state.renderElement;
		if (this._indexCount > 1){
			var boneIndicesListCount=this._boneIndicesList.length;
			if (boneIndicesListCount > 1){
				for (var i=0;i < boneIndicesListCount;i++){
					skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
					if (skinAnimationDatas){
						renderElement._shaderValue.setValue(0,skinAnimationDatas[i]);
						state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
					}
					WebGL.mainContext.drawElements(0x0004,this._subIndexBufferCount[i],0x1403,this._subIndexBufferStart[i] *2);
				}
				Stat.drawCall+=boneIndicesListCount;
				}else {
				skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
				if (skinAnimationDatas){
					renderElement._shaderValue.setValue(0,skinAnimationDatas[0]);
					state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
				}
				WebGL.mainContext.drawElements(0x0004,this._indexCount,0x1403,this._indexStart *2);
				Stat.drawCall++;
			}
			indexCount=this._indexCount;
			}else {
			indexCount=this._indexBuffer.indexCount;
			skinAnimationDatas=renderElement._skinAnimationDatas || this._skinAnimationDatas;
			if (skinAnimationDatas){
				renderElement._shaderValue.setValue(0,skinAnimationDatas[0]);
				state._shader.uploadRenderElementUniforms(renderElement._shaderValue.data);
			}
			WebGL.mainContext.drawElements(0x0004,indexCount,0x1403,0);
			Stat.drawCall++;
		}
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@private
	*/
	__proto.getIndices=function(){
		if (this._indexCount > 0)
			return this._indices;
		else
		return this._indexBuffer.getData();
	}

	/**
	*<p>彻底清理资源。</p>
	*<p><b>注意：</b>会强制解锁清理。</p>
	*/
	__proto.dispose=function(){
		this._indexBuffer.destroy();
		this._vertexBuffer.destroy();
		this._mesh=null;
		this._boneIndicesList=null;
		this._subIndexBufferStart=null;
		this._subIndexBufferCount=null;
		this._skinAnimationDatas=null;
		this._bufferUsage=null;
		this._vertexBuffer=null;
		this._indexBuffer=null;
	}

	/**NATIVE*/
	__proto._renderRuntime=function(conchGraphics3D,renderElement,state){
		var material=renderElement._material,owner=renderElement._sprite3D;
		conchGraphics3D.drawSubmesh(renderElement._conchSubmesh,0,0x0004,0,this._indexBuffer.indexCount);
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_vertexBufferCount',function(){
		return 1;
	});

	/**
	*@private
	*/
	__getset(0,__proto,'triangleCount',function(){
		return this._indexBuffer.indexCount / 3;
	});

	__static(SubMesh,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_tempMatrix4x41',function(){return this._tempMatrix4x41=new Matrix4x4();}
	]);
	return SubMesh;
})()


/**
*@private
*<code>ShaderCompile</code> 类用于实现Shader编译。
*/
//class laya.webgl.utils.ShaderCompile
var ShaderCompile=(function(){
	var ShaderNode,InlcudeFile;
	function ShaderCompile(name,vs,ps,nameMap,defs){
		//this._nameMap=null;
		//this._VS=null;
		//this._PS=null;
		var _$this=this;
		function _compile (script){
			var includefiles=[];
			var top=new ShaderNode(includefiles);
			_$this._compileToTree(top,script.split('\n'),0,includefiles,defs);
			return top;
		};
		var startTime=Browser.now();
		this._VS=_compile(vs);
		this._PS=_compile(ps);
		this._nameMap=nameMap;
		if ((Browser.now()-startTime)> 2)
			console.log("ShaderCompile use time:"+(Browser.now()-startTime)+"  size:"+vs.length+"/"+ps.length);
	}

	__class(ShaderCompile,'laya.webgl.utils.ShaderCompile');
	var __proto=ShaderCompile.prototype;
	__proto._compileToTree=function(parent,lines,start,includefiles,defs){
		var node,preNode;
		var text,name,fname;
		var ofs=0,words,noUseNode;
		var i=0,n=0,j=0;
		for (i=start;i < lines.length;i++){
			text=lines[i];
			if (text.length < 1)continue ;
			ofs=text.indexOf("//");
			if (ofs===0)continue ;
			if (ofs >=0)text=text.substr(0,ofs);
			node=noUseNode || new ShaderNode(includefiles);
			noUseNode=null;
			node.text=text;
			node.noCompile=true;
			if ((ofs=text.indexOf("#"))>=0){
				name="#";
				for (j=ofs+1,n=text.length;j < n;j++){
					var c=text.charAt(j);
					if (c===' ' || c==='\t' || c==='?')break ;
					name+=c;
				}
				node.name=name;
				switch (name){
					case "#ifdef":
					case "#ifndef":
						node.src=text;
						node.noCompile=text.match(/[!&|()=<>]/)!=null;
						if (!node.noCompile){
							words=text.replace(/^\s*/,'').split(/\s+/);
							node.setCondition(words[1],name==="#ifdef" ? 1 :2);
							node.text="//"+node.text;
							}else {
							console.log("function():Boolean{return "+text.substr(ofs+node.name.length)+"}");
						}
						node.setParent(parent);
						parent=node;
						if (defs){
							words=text.substr(j).split(ShaderCompile._splitToWordExps3);
							for (j=0;j < words.length;j++){
								text=words[j];
								text.length && (defs[ text]=true);
							}
						}
						continue ;
					case "#if":
						node.src=text;
						node.noCompile=true;
						node.setParent(parent);
						parent=node;
						if (defs){
							words=text.substr(j).split(ShaderCompile._splitToWordExps3);
							for (j=0;j < words.length;j++){
								text=words[j];
								text.length && text!="defined" && (defs[ text]=true);
							}
						}
						continue ;
					case "#else":
						node.src=text;
						parent=parent.parent;
						preNode=parent.childs[parent.childs.length-1];
						if (!(node.noCompile=preNode.noCompile)){
							node.condition=preNode.condition;
							node.conditionType=preNode.conditionType==1 ? 2 :1;
							node.text="//"+node.text+" "+preNode.text+" "+node.conditionType;
						}
						node.setParent(parent);
						parent=node;
						continue ;
					case "#endif":
						parent=parent.parent;
						preNode=parent.childs[parent.childs.length-1];
						if (!(node.noCompile=preNode.noCompile)){
							node.text="//"+node.text;
						}
						node.setParent(parent);
						continue ;
					case "#include":
						words=ShaderCompile.splitToWords(text,null);
						var inlcudeFile=ShaderCompile.includes[words[1]];
						if (!inlcudeFile){
							throw "ShaderCompile error no this include file:"+words[1];
							return;
						}
						if ((ofs=words[0].indexOf("?"))< 0){
							node.setParent(parent);
							text=inlcudeFile.getWith(words[2]=='with' ? words[3] :null);
							this._compileToTree(node,text.split('\n'),0,includefiles,defs);
							node.text="";
							continue ;
						}
						node.setCondition(words[0].substr(ofs+1),1);
						node.text=inlcudeFile.getWith(words[2]=='with' ? words[3] :null);
						break ;
					case "#import":
						words=ShaderCompile.splitToWords(text,null);
						fname=words[1];
						includefiles.push({node:node,file:ShaderCompile.includes[fname],ofs:node.text.length});
						continue ;
					}
				}else {
				preNode=parent.childs[parent.childs.length-1];
				if (preNode && !preNode.name){
					includefiles.length > 0 && ShaderCompile.splitToWords(text,preNode);
					noUseNode=node;
					preNode.text+="\n"+text;
					continue ;
				}
				includefiles.length > 0 && ShaderCompile.splitToWords(text,node);
			}
			node.setParent(parent);
		}
	}

	__proto.createShader=function(define,shaderName,createShader){
		var defMap={};
		var defineStr="";
		if (define){
			for (var i in define){
				defineStr+="#define "+i+"\n";
				defMap[i]=true;
			}
		};
		var vs=this._VS.toscript(defMap,[]);
		var ps=this._PS.toscript(defMap,[]);
		return (createShader || Shader.create)(defineStr+vs.join('\n'),defineStr+ps.join('\n'),shaderName,this._nameMap);
	}

	ShaderCompile._parseOne=function(attributes,uniforms,words,i,word,b){
		var one={type:ShaderCompile.shaderParamsMap[words[i+1]],name:words[i+2],size:isNaN(parseInt(words[i+3]))? 1 :parseInt(words[i+3])};
		if (b){
			if (word=="attribute"){
				attributes.push(one);
				}else {
				uniforms.push(one);
			}
		}
		if (words[i+3]==':'){
			one.type=words[i+4];
			i+=2;
		}
		i+=2;
		return i;
	}

	ShaderCompile.addInclude=function(fileName,txt){
		if (!txt || txt.length===0)
			throw new Error("add shader include file err:"+fileName);
		if (ShaderCompile.includes[fileName])
			throw new Error("add shader include file err, has add:"+fileName);
		ShaderCompile.includes[fileName]=new InlcudeFile(txt);
	}

	ShaderCompile.preGetParams=function(vs,ps){
		var text=[vs,ps];
		var result={};
		var attributes=[];
		var uniforms=[];
		var definesInfo={};
		var definesName=[];
		result.attributes=attributes;
		result.uniforms=uniforms;
		result.defines=definesInfo;
		var i=0,n=0,one;
		for (var s=0;s < 2;s++){
			text[s]=text[s].replace(ShaderCompile._removeAnnotation,"");
			var words=text[s].match(ShaderCompile._reg);
			var tempelse;
			for (i=0,n=words.length;i < n;i++){
				var word=words[i];
				if (word !="attribute" && word !="uniform"){
					if (word=="#define"){
						word=words[++i];
						definesName[word]=1;
						continue ;
						}else if (word=="#ifdef"){
						tempelse=words[++i];
						var def=definesInfo[tempelse]=definesInfo[tempelse] || [];
						for (i++;i < n;i++){
							word=words[i];
							if (word !="attribute" && word !="uniform"){
								if (word=="#else"){
									for (i++;i < n;i++){
										word=words[i];
										if (word !="attribute" && word !="uniform"){
											if (word=="#endif"){
												break ;
											}
											continue ;
										}
										i=ShaderCompile._parseOne(attributes,uniforms,words,i,word,!definesName[tempelse]);
									}
								}
								continue ;
							}
							i=ShaderCompile._parseOne(attributes,uniforms,words,i,word,definesName[tempelse]);
						}
					}
					continue ;
				}
				i=ShaderCompile._parseOne(attributes,uniforms,words,i,word,true);
			}
		}
		return result;
	}

	ShaderCompile.splitToWords=function(str,block){
		var out=[];
		var c;
		var ofs=-1;
		var word;
		for (var i=0,n=str.length;i < n;i++){
			c=str.charAt(i);
			if (" \t=+-*/&%!<>()'\",;".indexOf(c)>=0){
				if (ofs >=0 && (i-ofs)> 1){
					word=str.substr(ofs,i-ofs);
					out.push(word);
				}
				if (c=='"' || c=="'"){
					var ofs2=str.indexOf(c,i+1);
					if (ofs2 < 0){
						throw "Sharder err:"+str;
						return;
					}
					out.push(str.substr(i+1,ofs2-i-1));
					i=ofs2;
					ofs=-1;
					continue ;
				}
				if (c=='(' && block && out.length > 0){
					word=out[out.length-1]+";";
					if ("vec4;main;".indexOf(word)< 0)
						block.useFuns+=word;
				}
				ofs=-1;
				continue ;
			}
			if (ofs < 0)ofs=i;
		}
		if (ofs < n && (n-ofs)> 1){
			word=str.substr(ofs,n-ofs);
			out.push(word);
		}
		return out;
	}

	ShaderCompile.IFDEF_NO=0;
	ShaderCompile.IFDEF_YES=1;
	ShaderCompile.IFDEF_ELSE=2;
	ShaderCompile.IFDEF_PARENT=3;
	ShaderCompile.includes={};
	__static(ShaderCompile,
	['_removeAnnotation',function(){return this._removeAnnotation=new RegExp("(/\\*([^*]|[\\r\\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/)|(//.*)","g");},'_reg',function(){return this._reg=new RegExp("(\".*\")|('.*')|([#\\w\\*-\\.+/()=<>{}\\\\]+)|([,;:\\\\])","g");},'_splitToWordExps',function(){return this._splitToWordExps=new RegExp("[(\".*\")]+|[('.*')]+|([ \\t=\\+\\-*/&%!<>!%\(\),;])","g");},'shaderParamsMap',function(){return this.shaderParamsMap={"float":0x1406,"int":0x1404,"bool":0x8B56,"vec2":0x8B50,"vec3":0x8B51,"vec4":0x8B52,"ivec2":0x8B53,"ivec3":0x8B54,"ivec4":0x8B55,"bvec2":0x8B57,"bvec3":0x8B58,"bvec4":0x8B59,"mat2":0x8B5A,"mat3":0x8B5B,"mat4":0x8B5C,"sampler2D":0x8B5E,"samplerCube":0x8B60};},'_splitToWordExps3',function(){return this._splitToWordExps3=new RegExp("[ \\t=\\+\\-*/&%!<>!%\(\),;\\|]","g");}
	]);
	ShaderCompile.__init$=function(){
		//class ShaderNode
		ShaderNode=(function(){
			function ShaderNode(includefiles){
				this.childs=[];
				this.text="";
				this.parent=null;
				this.name=null;
				this.noCompile=false;
				this.includefiles=null;
				this.condition=null;
				this.conditionType=0;
				this.useFuns="";
				this.z=0;
				this.src=null;
				this.includefiles=includefiles;
			}
			__class(ShaderNode,'');
			var __proto=ShaderNode.prototype;
			__proto.setParent=function(parent){
				parent.childs.push(this);
				this.z=parent.z+1;
				this.parent=parent;
			}
			__proto.setCondition=function(condition,type){
				if (condition){
					this.conditionType=type;
					condition=condition.replace(/(\s*$)/g,"");
					this.condition=function (){
						return this[condition];
					}
					this.condition.__condition=condition;
				}
			}
			__proto.toscript=function(def,out){
				return this._toscript(def,out,++ShaderNode.__id);
			}
			__proto._toscript=function(def,out,id){
				if (this.childs.length < 1 && !this.text)return out;
				var outIndex=out.length;
				if (this.condition){
					var ifdef=!!this.condition.call(def);
					this.conditionType===2 && (ifdef=!ifdef);
					if (!ifdef)return out;
				}
				this.text && out.push(this.text);
				this.childs.length > 0 && this.childs.forEach(function(o,index,arr){
					o._toscript(def,out,id);
				});
				if (this.includefiles.length > 0 && this.useFuns.length > 0){
					var funsCode;
					for (var i=0,n=this.includefiles.length;i < n;i++){
						if (this.includefiles[i].curUseID==id){
							continue ;
						}
						funsCode=this.includefiles[i].file.getFunsScript(this.useFuns);
						if (funsCode.length > 0){
							this.includefiles[i].curUseID=id;
							out[0]=funsCode+out[0];
						}
					}
				}
				return out;
			}
			ShaderNode.__id=1;
			return ShaderNode;
		})()
		//class InlcudeFile
		InlcudeFile=(function(){
			function InlcudeFile(txt){
				this.script=null;
				this.codes={};
				this.funs={};
				this.curUseID=-1;
				this.funnames="";
				this.script=txt;
				var begin=0,ofs=0,end=0;
				while (true){
					begin=txt.indexOf("#begin",begin);
					if (begin < 0)break ;
					end=begin+5;
					while (true){
						end=txt.indexOf("#end",end);
						if (end < 0)break ;
						if (txt.charAt(end+4)==='i')
							end+=5;
						else break ;
					}
					if (end < 0){
						throw "add include err,no #end:"+txt;
						return;
					}
					ofs=txt.indexOf('\n',begin);
					var words=ShaderCompile.splitToWords(txt.substr(begin,ofs-begin),null);
					if (words[1]=='code'){
						this.codes[words[2]]=txt.substr(ofs+1,end-ofs-1);
						}else if (words[1]=='function'){
						ofs=txt.indexOf("function",begin);
						ofs+="function".length;
						this.funs[words[3]]=txt.substr(ofs+1,end-ofs-1);
						this.funnames+=words[3]+";";
					}
					begin=end+1;
				}
			}
			__class(InlcudeFile,'');
			var __proto=InlcudeFile.prototype;
			__proto.getWith=function(name){
				var r=name ? this.codes[name] :this.script;
				if (!r){
					throw "get with error:"+name;
				}
				return r;
			}
			__proto.getFunsScript=function(funsdef){
				var r="";
				for (var i in this.funs){
					if (funsdef.indexOf(i+";")>=0){
						r+=this.funs[i];
					}
				}
				return r;
			}
			return InlcudeFile;
		})()
	}

	return ShaderCompile;
})()


/**
*@private
*/
//class laya.d3.shader.ShaderDefines
var ShaderDefines=(function(){
	function ShaderDefines(shaderdefines){
		/**@private [只读]*/
		this.defineCounter=0;
		/**@private [只读]*/
		this.defines=null;
		if (shaderdefines){
			this.defineCounter=shaderdefines.defineCounter;
			this.defines=shaderdefines.defines.slice();
			}else {
			this.defineCounter=0;
			this.defines=[];
		}
	}

	__class(ShaderDefines,'laya.d3.shader.ShaderDefines');
	var __proto=ShaderDefines.prototype;
	/**
	*@private
	*/
	__proto.registerDefine=function(name){
		var value=Math.pow(2,this.defineCounter++);
		this.defines[value]=name;
		return value;
	}

	return ShaderDefines;
})()


/**
*@private
*<code>ShaderInit</code> 类用于初始化内置Shader。
*/
//class laya.d3.shader.ShaderInit3D
var ShaderInit3D=(function(){
	/**
	*创建一个 <code>ShaderInit</code> 实例。
	*/
	function ShaderInit3D(){}
	__class(ShaderInit3D,'laya.d3.shader.ShaderInit3D');
	ShaderInit3D.__init__=function(){
		ShaderCompile3D._globalRegDefine("HIGHPRECISION",ShaderCompile3D.SHADERDEFINE_HIGHPRECISION);
		ShaderCompile3D._globalRegDefine("FOG",ShaderCompile3D.SHADERDEFINE_FOG);
		ShaderCompile3D._globalRegDefine("DIRECTIONLIGHT",ShaderCompile3D.SHADERDEFINE_DIRECTIONLIGHT);
		ShaderCompile3D._globalRegDefine("POINTLIGHT",ShaderCompile3D.SHADERDEFINE_POINTLIGHT);
		ShaderCompile3D._globalRegDefine("SPOTLIGHT",ShaderCompile3D.SHADERDEFINE_SPOTLIGHT);
		ShaderCompile3D._globalRegDefine("UV",ShaderCompile3D.SHADERDEFINE_UV0);
		ShaderCompile3D._globalRegDefine("COLOR",ShaderCompile3D.SHADERDEFINE_COLOR);
		ShaderCompile3D._globalRegDefine("UV1",ShaderCompile3D.SHADERDEFINE_UV1);
		ShaderCompile3D._globalRegDefine("CASTSHADOW",ParallelSplitShadowMap.SHADERDEFINE_CAST_SHADOW);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM1",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM2",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PSSM3",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF_NO",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF1",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF2",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
		ShaderCompile3D._globalRegDefine("SHADOWMAP_PCF3",ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
		ShaderCompile3D._globalRegDefine("DEPTHFOG",ShaderCompile3D.SAHDERDEFINE_DEPTHFOG);
		Shader3D.addInclude("LightHelper.glsl","\nstruct DirectionLight\n{\n vec3 Direction;\n vec3 Diffuse;\n};\n\nstruct PointLight\n{\n vec3 Diffuse;\n vec3 Attenuation;\n vec3 Position;\n float Range;\n};\n\nstruct SpotLight\n{\n vec3 Diffuse;\n vec3 Attenuation;\n vec3 Position;\n vec3 Direction;\n float Spot;\n float Range;\n};\n\n\nvec3 NormalSampleToWorldSpace(vec3 normalMapSample, vec3 unitNormal, vec3 tangent)\n{\n	vec3 normalT = 2.0*normalMapSample - 1.0;\n\n	// Build orthonormal basis.\n	vec3 N = normalize(unitNormal);\n	vec3 T = normalize(tangent- dot(tangent, N)*N);\n	vec3 B = cross(T, N);\n\n	mat3 TBN = mat3(T, B, N);\n\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN*normalT;\n\n	return bumpedNormal;\n}\n\n\nvoid  computeDirectionLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in DirectionLight dirLight,in vec3 ambinentColor,in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	dif=vec3(0.0);//不初始化在IOS中闪烁，PC中不会闪烁\n	amb=vec3(0.0);\n	spec=vec3(0.0);\n	vec3 lightVec=-normalize(dirLight.Direction);\n	\n	amb=matAmb*ambinentColor;\n	\n	float  diffuseFactor=dot(lightVec, normal);\n	\n	if(diffuseFactor>0.0)\n	{\n	   vec3 v = reflect(-lightVec, normal);\n	   float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n	   \n	   dif = diffuseFactor * matDif * dirLight.Diffuse;\n	   spec = specFactor * matSpe.rgb;\n	}\n	\n}\n\nvoid computePointLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in PointLight poiLight,in vec3 ambinentColor, in vec3 pos,in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	dif=vec3(0.0);\n	amb=vec3(0.0);\n	spec=vec3(0.0);\n	vec3 lightVec = poiLight.Position - pos;\n		\n	float d = length(lightVec);\n	\n	if( d > poiLight.Range )\n		return;\n		\n	lightVec /= d; \n	\n	amb = matAmb*ambinentColor;	\n\n	float diffuseFactor = dot(lightVec, normal);\n\n	if( diffuseFactor > 0.0 )\n	{\n		vec3 v= reflect(-lightVec, normal);\n		float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n					\n		dif = diffuseFactor * matDif * poiLight.Diffuse;\n		spec = specFactor * matSpe.rgb;\n	}\n\n	float attenuate = 1.0 / dot(poiLight.Attenuation, vec3(1.0, d, d*d));\n\n	dif *= attenuate;\n	spec*= attenuate;\n}\n\nvoid ComputeSpotLight(in vec3 matDif,in vec3 matAmb,in vec4 matSpe,in SpotLight spoLight,in vec3 ambinentColor,in vec3 pos, in vec3 normal,in vec3 toEye,out vec3 dif,out vec3 amb,out vec3 spec)\n{\n	amb = vec3(0.0);\n	dif =vec3(0.0);\n	spec= vec3(0.0);\n	vec3 lightVec = spoLight.Position - pos;\n		\n	float d = length(lightVec);\n	\n	if( d > spoLight.Range)\n		return;\n		\n	lightVec /= d; \n	\n	amb = matAmb*ambinentColor;	\n\n	float diffuseFactor = dot(lightVec, normal);\n\n	if(diffuseFactor > 0.0)\n	{\n		vec3 v= reflect(-lightVec, normal);\n		float specFactor = pow(max(dot(v, toEye), 0.0), matSpe.w);\n					\n		dif = diffuseFactor * matDif * spoLight.Diffuse;\n		spec = specFactor * matSpe.rgb;\n	}\n	\n	float spot = pow(max(dot(-lightVec, normalize(spoLight.Direction)), 0.0), spoLight.Spot);\n\n	float attenuate = spot/dot(spoLight.Attenuation, vec3(1.0, d, d*d));\n\n	amb *= spot;\n	dif *= attenuate;\n	spec*= attenuate;\n}\n\n");
		Shader3D.addInclude("Lighting.glsl","\nstruct DirectionLight\n{\n	vec3 Color;\n	vec3 Direction;\n};\n\nstruct PointLight\n{\n	vec3 Color;\n	vec3 Position;\n	float Range;\n};\n\nstruct SpotLight\n{\n	vec3 Color;\n	vec3 Position;\n	vec3 Direction;\n	float Spot;\n	float Range;\n};\n\n// U3D中使用衰减纹理,此函数模拟并非正确\n//float U3DAttenuation(in vec3 L,in float invLightRadius)\n//{\n//	float fRatio = clamp(length(L) * invLightRadius,0.0,1.0);\n//	fRatio *= fRatio;\n//	return 1.0 / (1.0 + 25.0 * fRatio)* clamp(4.0*(1.0 - fRatio),0.0,1.0); //fade to black as if 4 pixel texture\n//} \n\n// Same as Just Cause 2 and Crysis 2 (you can read GPU Pro 1 book for more information)\nfloat BasicAttenuation(in vec3 L,in float invLightRadius)\n{\n	vec3 distance = L * invLightRadius;\n	float attenuation = clamp(1.0 - dot(distance, distance),0.0,1.0); // Equals float attenuation = saturate(1.0f - dot(L, L) / (lightRadius *  lightRadius)); 	\n	return attenuation * attenuation;\n} \n\n// Inspired on http://fools.slindev.com/viewtopic.php?f=11&t=21&view=unread#unread	\nfloat NaturalAttenuation(in vec3 L,in float invLightRadius)\n{\n	float attenuationFactor = 30.0;\n	vec3 distance = L * invLightRadius;\n	float attenuation = dot(distance, distance); // Equals float attenuation = dot(L, L) / (lightRadius *  lightRadius);\n	attenuation = 1.0 / (attenuation * attenuationFactor + 1.0);\n	// Second we move down the function therewith it reaches zero at abscissa 1:\n	attenuationFactor = 1.0 / (attenuationFactor + 1.0); //attenuationFactor contains now the value we have to subtract\n	attenuation = max(attenuation - attenuationFactor, 0.0); // The max fixes a bug.\n	// Finally we expand the equation along the y-axis so that it starts with a function value of 1 again.\n	attenuation /= 1.0 - attenuationFactor;\n	return attenuation;\n} \n\nvoid LayaAirBlinnPhongLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir,in vec3 lightColor, in vec3 lightVec,out vec3 diffuseColor,out vec3 specularColor)\n{\n    mediump vec3 h = normalize(viewDir-lightVec);\n    lowp float ln = max (0.0, dot (-lightVec,normal));\n    float nh = max (0.0, dot (h,normal));\n	diffuseColor=lightColor * ln;\n	specularColor=lightColor *specColor*pow (nh, specColorIntensity*128.0) * gloss;\n}\n\nvoid LayaAirBlinnPhongDiectionLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in DirectionLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec=normalize(light.Direction);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec,diffuseColor,specularColor);\n}\n\nvoid LayaAirBlinnPhongPointLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in PointLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range )\n	//	return;\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec/length(lightVec),diffuseColor,specularColor);\n	float attenuate = BasicAttenuation(lightVec, 1.0/light.Range);\n	diffuseColor *= attenuate;\n	specularColor*= attenuate;\n}\n\nvoid LayaAirBlinnPhongSpotLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in SpotLight light,out vec3 diffuseColor,out vec3 specularColor)\n{\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range )\n	//	return;\n	vec3 normalLightVec=lightVec/length(lightVec);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,normalLightVec,diffuseColor,specularColor);\n	float spot = pow(max(dot(normalLightVec, normalize(light.Direction)), 0.0), light.Spot);\n	float attenuate = spot*BasicAttenuation(lightVec, 1.0/light.Range);\n	diffuseColor *= attenuate;\n	specularColor*= attenuate;\n}\n\nvec3 NormalSampleToWorldSpace(vec3 normalMapSample, vec3 unitNormal, vec3 tangent,vec3 binormal)\n{\n	vec3 normalT =vec3(2.0*normalMapSample.x - 1.0,1.0-2.0*normalMapSample.y,2.0*normalMapSample.z - 1.0);\n	\n	// Build orthonormal basis.\n	vec3 N = normalize(unitNormal);\n	vec3 T = normalize(tangent);\n	vec3 B = normalize(binormal);\n	mat3 TBN = mat3(T, B, N);\n	\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN*normalT;\n\n	return bumpedNormal;\n}\n\n\n");
		Shader3D.addInclude("ShadowHelper.glsl","uniform sampler2D u_shadowMap1;\nuniform sampler2D u_shadowMap2;\nuniform sampler2D u_shadowMap3;\nuniform vec2	  u_shadowPCFoffset;\nuniform vec4     u_shadowPSSMDistance;\nvec4 packDepth(const in float depth)\n{\n	const vec4 bitShift = vec4(256.0*256.0*256.0, 256.0*256.0, 256.0, 1.0);\n	const vec4 bitMask	= vec4(0.0, 1.0/256.0, 1.0/256.0, 1.0/256.0);\n	vec4 res = mod(depth*bitShift*vec4(255), vec4(256))/vec4(255);\n	res -= res.xxyz * bitMask;\n	return res;\n}\nfloat unpackDepth(const in vec4 rgbaDepth)\n{\n	const vec4 bitShift = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);\n	float depth = dot(rgbaDepth, bitShift);\n	return depth;\n}\nfloat tex2DPCF( sampler2D shadowMap,vec2 texcoord,vec2 invsize,float zRef )\n{\n	vec2 texelpos =texcoord / invsize;\n	vec2 lerps = fract( texelpos );\n	float sourcevals[4];\n	sourcevals[0] = float( unpackDepth(texture2D(shadowMap,texcoord)) > zRef );\n	sourcevals[1] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x,0))) > zRef );\n	sourcevals[2] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(0,invsize.y))) > zRef );\n	sourcevals[3] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x, invsize.y) )) > zRef );\n	return mix( mix(sourcevals[0],sourcevals[2],lerps.y),mix(sourcevals[1],sourcevals[3],lerps.y),lerps.x );\n}\nfloat getShadowPSSM3( sampler2D shadowMap1,sampler2D shadowMap2,sampler2D shadowMap3,mat4 lightShadowVP[4],vec4 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	nPSNum += int(posViewZ>pssmDistance.z);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	else if( nPSNum == 2 )\n	{\n		lightVP = lightShadowVP[3];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		} \n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		else if( nPSNum == 2 )\n		{\n			color = texture2D( shadowMap3,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM2( sampler2D shadowMap1,sampler2D shadowMap2,mat4 lightShadowVP[4],vec4 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM1( sampler2D shadowMap1,vec4 lightMVPPos,vec4 pssmDistance,vec2 shadowPCFOffset,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	if( posViewZ < pssmDistance.x )\n	{\n		vec3 vText = lightMVPPos.xyz / lightMVPPos.w;\n		float fMyZ = vText.z - zBias;\n		/*\n		bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n		bool bInFrustum = all( bInFrustumVec );\n		bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n		bool bFrustumTest = all( bFrustumTestVec );\n		*/\n		if ( fMyZ <= 1.0 ) \n		{\n			float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,fMyZ );\n			value = value/4.0;\n#endif\n#ifdef SHADOWMAP_PCF2		\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF1\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF_NO		\n			vec4 color = texture2D( shadowMap1,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n#endif\n		}\n	}\n	return value;\n}");
		Shader3D.addInclude("WaveFunction.glsl","\nuniform vec2 u_WaveInfoD[20];\nuniform vec4 u_WaveInfo[20];\n\nuniform float TEXWAVE_UV_SCALE ;//= 20.0; //每texwidth像素代表的实际距离\n/**\n	这里的计算都是\n*/\n\n/**\n* 计算一个波形\n*  开始计算的时候都按照z向上，最后输出的时候，颠倒一下。\n* @param tm {float} 毫秒\n*/\nvoid calcGerstnerWave(float curtm, vec3 pos, float deep, vec2 uvpos, out vec3 opos, out vec3 B, out vec3 T, out vec3 N, out float foamS){\n	float tm = curtm/1000.;\n	opos = pos;\n	vec3 wpos=vec3(0.);		//累加的位置\n	N=vec3(0.,0.,0.);	//输出的法线初始化一下\n	T=vec3(0.,0.,0.);\n	B=vec3(0.,0.,0.);\n	vec2 cD ;//= D;\n	//float deepAtt = max(0.,min(deep,1.0));\n	//A*=deepAtt; //TODO\n	\n	for( int i=0; i<4; i++){\n		cD = u_WaveInfoD[i];//vec2(wi.winfo[0],wi.winfo[1]);// wi.vDir;\n		float Q = u_WaveInfo[i].x;//wi.QorK;\n		float A = u_WaveInfo[i].y;//wi.A;\n		float W = u_WaveInfo[i].z;//wi.omega;\n		float P = u_WaveInfo[i].w;//wi.phi;\n		float dop = dot(cD,uvpos);\n		float c = cos(dop*W - tm*P);//TODO 优化\n		float s = sin(dop*W - tm*P);\n		float AWs = A*W*s;\n		float AWc = A*W*c;\n		float _QxyAWs = -Q*cD.x*cD.y*AWs;\n		\n		wpos += vec3(Q*A*cD.x*c,\n					Q*A*cD.y*c,\n					A*s);\n		N += vec3(-cD.x*AWc,\n				-cD.y*AWc,\n				Q*AWs);//记得最后1-\n		T += vec3(_QxyAWs,\n				Q*cD.y*cD.y*AWs,//记得1-\n				cD.y*AWc\n			);\n		B += vec3(Q*cD.x*cD.x*AWs,//记得1-\n				_QxyAWs,\n				cD.x*AWc\n			);\n		//float v1 = exp(-tan((dop*W - tm*P)/2.+1.07));//除2，+pi/2 这样正好能对齐\n#ifdef USE_FOAM		\n		float v1 = 0.5-sin((dop*W - tm*P)/1.+2.0)/2.;\n		foamS += pow(v1,9.)/4.;\n#endif\n	}\n	T.y=1.-T.y; B.x=1.-B.x;N.z=1.-N.z;\n	opos += vec3(wpos.x,wpos.z*min(deep/10.,1.),wpos.y);\n	//y和z交换一下。现在根据uv计算的位置，所以直接交换yz就行。其他情况下有问题么\n	T.xyz=T.xzy;\n	B.xyz=B.xzy;\n	N.xyz=N.xzy;\n}\n\n\nvoid calcWave(float curtm, vec2 uv, out vec3 B, out vec3 T, out vec3 N){\n	float tm = curtm/1000.;\n	N=vec3(0.,0.,0.);	//输出的法线初始化一下\n	vec2 uvpos = uv*TEXWAVE_UV_SCALE; //TODO 这个范围是什么 就是1？\n	uvpos.y*=-1.;\n	vec2 cD;// = D;\n	const int NumWaves = 4;\n	float scale = 1./float(NumWaves);\n	for( int i=0; i<NumWaves; i++){\n		cD = u_WaveInfoD[i];//vec2(wi.winfo[0],wi.winfo[1]);// wi.vDir;\n		float k = 1.5;//u_WaveInfo[i].x;//wi.QorK; TODO  不知道为什么，这个取u_WaveInfo[i].x，在mi3w上就会闪。测试发现实际值也传过来了，就是1.5\n		float A = u_WaveInfo[i].y;//wi.A;\n		float W = u_WaveInfo[i].z;//wi.omega;\n		float P = u_WaveInfo[i].w;//wi.phi;\n		\n		float dop = dot(cD,uvpos);\n		float c = cos(dop*W - tm*P);//TODO 优化\n		float s = sin(dop*W - tm*P);\n		/*\n		float AWs = A*W*s;\n		float AWc = A*W*c;\n		float _QxyAWs = -Q*cD.x*cD.y*AWs;\n		\n		N += vec3(-cD.x*AWc,\n				-cD.y*AWc,\n				Q*AWs);//记得最后1-\n		*/\n		float kWAc = scale*c;//k*W*A*c;  为了提高精度，这里只保留sin，cos部分，实际使用的时候再乘回来。\n		//float kWAc = k*W*A*c;  \n		N += vec3(\n			-kWAc*cD.x*pow((s+1.)/2.,k-1.),\n			-kWAc*cD.y*pow((s+1.)/2.,k-1.),\n			1.\n		);\n	}\n	//N.z=1.-N.z;\n	//y和z交换一下。现在根据uv计算的位置，所以直接交换yz就行。其他情况下有问题么\n	N.xyz=N.xzy;\n}\n");
		Shader3D.addInclude("BRDF.glsl","vec4 LayaAirBRDF(in vec3 diffuseColor, in vec3 specularColor, in float oneMinusReflectivity, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float perceptualRoughness = SmoothnessToPerceptualRoughness(smoothness);\n	vec3 halfDir = SafeNormalize(viewDir - lightDir);\n	\n	float nv = abs(dot(normal, viewDir));\n	\n	float nl = clamp(dot(normal,   -lightDir),  0.0, 1.0);\n	float nh = clamp(dot(normal,     halfDir),  0.0, 1.0);\n	float lv = clamp(dot(lightDir,   viewDir),  0.0, 1.0);\n	float lh = clamp(dot(lightDir,  -halfDir),  0.0, 1.0);\n	\n	float diffuseTerm = DisneyDiffuse(nv, nl, lh, perceptualRoughness) * nl;\n	\n	float roughness = PerceptualRoughnessToRoughness(perceptualRoughness);\n	\n	//#if UNITY_BRDF_GGX\n	float V = SmithJointGGXVisibilityTerm(nl, nv, roughness);\n	float D = GGXTerm(nh, roughness);\n	\n	float specularTerm = V * D * PI;\n	\n	specularTerm = sqrt(max(0.0001, specularTerm));\n	specularTerm = max(0.0, specularTerm * nl);\n	\n	vec4 color;\n	color.rgb = diffuseColor * (gi + lightColor * diffuseTerm) + specularTerm * lightColor * FresnelTerm (specularColor, lh);\n	\n	color.a = 1.0;\n	return color;\n}");
		Shader3D.addInclude("PBRUtils.glsl","struct DirectionLight\n{\n	vec3 Color;\n	vec3 Direction;\n};\n\nvec3 UnpackScaleNormal(in vec2 uv0)\n{\n	#ifdef NORMALTEXTURE\n		vec3 normalT;\n		vec4 normalMapSample = texture2D(u_NormalTexture, uv0);\n		normalT.x = 2.0 * normalMapSample.x - 1.0;\n		normalT.y = 1.0 - 2.0 * normalMapSample.y;\n		normalT.xy *= u_normalScale;\n		normalT.z = sqrt(1.0 - clamp(dot(normalT.xy, normalT.xy), 0.0, 1.0));\n		\n		vec3 T = normalize(v_Tangent);\n		vec3 B = normalize(v_Binormal);\n		vec3 N = normalize(v_Normal);\n		mat3 TBN = mat3(T, B, N);\n		\n		vec3 bumpedNormal = TBN * normalize(normalT);\n		return bumpedNormal;\n	#else\n		return normalize(v_Normal);\n	#endif\n}\n\nvec4 DielectricSpecularColor = vec4(0.220916301, 0.220916301, 0.220916301, 1.0 - 0.220916301);\n\nfloat PI = 3.14159265359;\n\nvec3 FresnelTerm (in vec3 F0, in float cosA)\n{\n	return F0 + (vec3(1.0) - F0) * pow(1.0 - cosA, 5.0);\n}\n\nfloat PerceptualRoughnessToRoughness(in float perceptualRoughness)\n{\n	return perceptualRoughness * perceptualRoughness;\n}\n\nfloat PerceptualRoughnessToSpecularPower(in float perceptualRoughness)\n{\n	float m = PerceptualRoughnessToRoughness(perceptualRoughness);\n	float sq = max(0.0001, m * m);\n	float n = (2.0 / sq) - 2.0;\n	n = max(n, 0.0001);\n	return n;\n}\n\nfloat RoughnessToPerceptualRoughness(in float roughness)\n{\n	return sqrt(roughness);\n}\n\nfloat SmoothnessToRoughness(in float smoothness)\n{\n	return (1.0 - smoothness) * (1.0 - smoothness);\n}\n\nfloat SmoothnessToPerceptualRoughness(in float smoothness)\n{\n	return (1.0 - smoothness);\n}\n\nvec3 SafeNormalize(in vec3 inVec)\n{\n	float dp3 = max(0.001,dot(inVec,inVec));\n	return inVec * (1.0 / sqrt(dp3));\n}\n\nfloat DisneyDiffuse(in float NdotV, in float NdotL, in float LdotH, in float perceptualRoughness)\n{\n	float fd90 = 0.5 + 2.0 * LdotH * LdotH * perceptualRoughness;\n	float lightScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotL,5.0));\n	float viewScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotV,5.0));\n\n	return lightScatter * viewScatter;\n}\n\nfloat SmithJointGGXVisibilityTerm (float NdotL, float NdotV, float roughness)\n{\n	float a = roughness;\n	float lambdaV = NdotL * (NdotV * (1.0 - a) + a);\n	float lambdaL = NdotV * (NdotL * (1.0 - a) + a);\n\n	return 0.5 / (lambdaV + lambdaL + 0.00001);\n}\n\nfloat GGXTerm (float NdotH, float roughness)\n{\n	float a2 = roughness * roughness;\n	float d = (NdotH * a2 - NdotH) * NdotH + 1.0;\n	return 0.31830988618 * a2 / (d * d + 0.0000001);\n}\n\nfloat OneMinusReflectivityFromMetallic(in float metallic)\n{\n	float oneMinusDielectricSpec = DielectricSpecularColor.a;\n	return oneMinusDielectricSpec - metallic * oneMinusDielectricSpec;\n}\n\nfloat SpecularStrength(vec3 specular)\n{\n    //(SHADER_TARGET < 30)return specular.r; \n    return max (max (specular.r, specular.g), specular.b);\n}\n\nvec3 DiffuseAndSpecularFromMetallic(in vec3 diffuseColor, in float metallic, out vec3 specularColor, out float oneMinusReflectivity)\n{\n	specularColor = mix(DielectricSpecularColor.rgb, diffuseColor, metallic);\n	oneMinusReflectivity = OneMinusReflectivityFromMetallic(metallic);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec3 EnergyConservationBetweenDiffuseAndSpecular(in vec3 diffuseColor, in vec3 specularColor, out float oneMinusReflectivity)\n{\n	oneMinusReflectivity = 1.0 - SpecularStrength(specularColor);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec4 Occlusion(in vec2 uv0){\n	#ifdef OCCLUSIONTEXTURE\n		vec4 occlusionTextureColor = texture2D(u_OcclusionTexture, uv0);\n		float occ = occlusionTextureColor.g;\n		float oneMinusT = 1.0 - u_occlusionStrength;\n		float lerpOneTo = oneMinusT + occ * u_occlusionStrength;\n		return occlusionTextureColor * lerpOneTo;\n	#else\n		return vec4(1.0);\n	#endif\n}\n\nvec2 ParallaxOffset(in vec3 viewDir){\n	#ifdef PARALLAXTEXTURE\n		float h = texture2D(u_ParallaxTexture, v_Texcoord0).g;\n		h = h * u_parallaxScale - u_parallaxScale / 2.0;\n		vec3 v = viewDir;\n		v.z += 0.42;\n		vec2 offset = h * (v.xy / v.z);\n		return v_Texcoord0 + offset;\n	#else\n		return v_Texcoord0;\n	#endif\n}\n\n");
		Shader3D.addInclude("PBRStandardLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRStandardLight(in vec3 diffuseColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float oneMinusReflectivity;\n	vec3 specularColor;\n	diffuseColor = DiffuseAndSpecularFromMetallic (diffuseColor, metallic, specularColor, oneMinusReflectivity);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	return color;\n}\n\nvec4 PBRStandardDiectionLight (in vec3 diffuseColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in vec3 gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRStandardLight(diffuseColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec2 MetallicGloss(in float diffuseTextureAlpha, in vec2 uv0)\n{\n	vec2 mg;\n	\n	#ifdef METALLICGLOSSTEXTURE\n		vec4 metallicGlossTextureColor = texture2D(u_MetallicGlossTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			mg.r = metallicGlossTextureColor.r;\n			mg.g = diffuseTextureAlpha;\n		#else\n		    mg = metallicGlossTextureColor.ra;\n		#endif\n		mg.g *= u_smoothnessScale;\n	#else\n		mg.r = u_metallic;\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			mg.g = diffuseTextureAlpha * u_smoothnessScale;\n		#else\n			mg.g = u_smoothness;\n		#endif\n	#endif\n	\n	return mg;\n}\n\n");
		Shader3D.addInclude("PBRSpecularLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRSpecularLight(in vec3 diffuseColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in vec3 gi)\n{\n	float oneMinusReflectivity;\n	diffuseColor = EnergyConservationBetweenDiffuseAndSpecular (diffuseColor, specularColor, oneMinusReflectivity);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	return color;\n}\n\nvec4 PBRSpecularDiectionLight (in vec3 diffuseColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in vec3 gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRSpecularLight(diffuseColor, specularColor, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec4 SpecularGloss(float diffuseTextureAlpha, in vec2 uv0)\n{\n    vec4 sg;\n	\n	#ifdef SPECULARTEXTURE\n		vec4 specularTextureColor = texture2D(u_SpecularTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			sg.rgb = specularTextureColor.rgb;\n			sg.a = diffuseTextureAlpha;\n		#else\n			sg = specularTextureColor;\n		#endif\n		sg.a *= u_smoothnessScale;\n	#else\n		sg.rgb = u_SpecularColor.rgb;\n		#ifdef SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA\n			sg.a = diffuseTextureAlpha * u_smoothnessScale;\n		#else\n			sg.a = u_smoothness;\n		#endif\n	#endif\n	\n    return sg;\n}\n\n");
		var vs,ps;
		var attributeMap={
			'a_Position':0,
			'a_Color':1,
			'a_Normal':3,
			'a_Texcoord0':2,
			'a_Texcoord1':15,
			'a_BoneWeights':7,
			'a_BoneIndices':6,
			'a_Tangent0':5};
		var uniformMap={
			'u_Bones':[0,0],
			'u_DiffuseTexture':[1,1],
			'u_SpecularTexture':[3,1],
			'u_NormalTexture':[2,1],
			'u_ReflectTexture':[5,1],
			'u_AlphaTestValue':[0,1],
			'u_DiffuseColor':[6,1],
			'u_MaterialSpecular':[8,1],
			'u_Shininess':[9,1],
			'u_MaterialReflect':[10,1],
			'u_TilingOffset':[11,1],
			'u_WorldMat':[0,2],
			'u_MvpMatrix':[1,2],
			'u_LightmapScaleOffset':[2,2],
			'u_LightMap':[3,2],
			'u_CameraPos':[0,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Color':[4,4],
			'u_DirectionLight.Direction':[3,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Color':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Color':[14,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]};
		var BLINNPHONG=Shader3D.nameKey.add("BLINNPHONG");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))||(defined(LIGHTMAP)&&defined(UV))\n	attribute vec2 a_Texcoord0;\n	varying vec2 v_Texcoord0;\n#endif\n\n#if defined(LIGHTMAP)&&defined(UV1)\n	attribute vec2 a_Texcoord1;\n#endif\n\n#ifdef LIGHTMAP\n	uniform vec4 u_LightmapScaleOffset;\n	varying vec2 v_LightMapUV;\n#endif\n\n#ifdef COLOR\n	attribute vec4 a_Color;\n	varying vec4 v_Color;\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal; \n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	uniform vec3 u_CameraPos;\n	varying vec3 v_ViewDir; \n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP))&&defined(NORMALMAP)\n	attribute vec4 a_Tangent0;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position=skinTransform*a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0=a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position=skinTransform*a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		mat3 worldMat;\n		#ifdef BONE\n			worldMat=mat3(u_WorldMat*skinTransform);\n		#else\n			worldMat=mat3(u_WorldMat);\n		#endif  \n		v_Normal=worldMat*a_Normal;//TODO:法线可以用\"魔法\"矩阵\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			v_Tangent=worldMat*a_Tangent0.xyz;\n			v_Binormal=cross(v_Normal,v_Tangent)*a_Tangent0.w;\n		#endif\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n		#ifdef BONE\n			v_PositionWorld=(u_WorldMat*position).xyz;\n		#else\n			v_PositionWorld=(u_WorldMat*a_Position).xyz;\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		v_ViewDir=u_CameraPos-v_PositionWorld;\n	#endif\n\n	#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n		v_Texcoord0=a_Texcoord0;\n		#ifdef TILINGOFFSET\n			v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n			v_Texcoord0=vec2(v_Texcoord0.x,1.0+v_Texcoord0.y);\n		#endif\n	#endif\n\n	#ifdef LIGHTMAP\n		#ifdef UV1\n			v_LightMapUV=vec2(a_Texcoord1.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,1.0+a_Texcoord1.y*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n		#else\n			v_LightMapUV=vec2(a_Texcoord0.x,a_Texcoord0.y-1.0)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n		#endif \n	#endif\n\n	#ifdef COLOR\n		v_Color=a_Color;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\nuniform vec4 u_DiffuseColor;\n\n#ifdef COLOR\n	varying vec4 v_Color;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	varying vec3 v_ViewDir; \n#endif\n\n#ifdef ALPHATEST\n	uniform float u_AlphaTestValue;\n#endif\n\n#ifdef DIFFUSEMAP\n	uniform sampler2D u_DiffuseTexture;\n#endif\n\n#ifdef REFLECTMAP\n	uniform samplerCube u_ReflectTexture;\n	uniform vec3 u_MaterialReflect;\n#endif\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n	varying vec2 v_Texcoord0;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform sampler2D u_LightMap;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	uniform vec3 u_MaterialSpecular;\n	uniform float u_Shininess;\n	#ifdef SPECULARMAP \n		uniform sampler2D u_SpecularTexture;\n	#endif\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	varying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n	uniform sampler2D u_NormalTexture;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n\n#if defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	varying vec3 v_PositionWorld;\n#endif\n\n#include \"ShadowHelper.glsl\"\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nvoid main_castShadow()\n{\n	//gl_FragColor=vec4(v_posViewZ,0.0,0.0,1.0);\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\nvoid main_normal()\n{\n	vec4 mainColor=u_DiffuseColor;\n	#ifdef DIFFUSEMAP\n		vec4 difTexColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n		mainColor=mainColor*difTexColor;\n	#endif \n	#ifdef COLOR\n		mainColor=mainColor*v_Color;\n	#endif \n    \n	#ifdef ALPHATEST\n		if(mainColor.a<u_AlphaTestValue)\n			discard;\n	#endif\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n		vec3 normal;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			vec3 normalMapSample = texture2D(u_NormalTexture, v_Texcoord0).rgb;\n			normal = normalize(NormalSampleToWorldSpace(normalMapSample, v_Normal, v_Tangent,v_Binormal));\n		#else\n			normal = normalize(v_Normal);\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		vec3 viewDir= normalize(v_ViewDir);\n		vec3 diffuse = vec3(0.0);\n		vec3 specular= vec3(0.0);\n		vec3 dif,spe;\n		#ifdef SPECULARMAP\n			vec3 gloss=texture2D(u_SpecularTexture, v_Texcoord0).rgb;\n		#else\n			#ifdef DIFFUSEMAP\n				vec3 gloss=vec3(difTexColor.a);\n			#else\n				vec3 gloss=vec3(1.0);\n			#endif\n		#endif\n	#endif\n\n	\n	#ifdef DIRECTIONLIGHT\n		LayaAirBlinnPhongDiectionLight(u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_DirectionLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n \n	#ifdef POINTLIGHT\n		LayaAirBlinnPhongPointLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_PointLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	#ifdef SPOTLIGHT\n		LayaAirBlinnPhongSpotLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_SpotLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	\n	vec3 finalDiffuse;\n	#ifdef LIGHTMAP\n		finalDiffuse=texture2D(u_LightMap, v_LightMapUV).rgb*2.0;\n		//float exponent = texture2D(u_LightMap, v_LightMapUV).a;\n		//finalDiffuse = texture2D(u_LightMap, v_LightMapUV).rgb;\n		//float ratio = pow(2.0, exponent * 255.0 - (128.0 + 8.0));\n		//finalDiffuse = finalDiffuse * 255.0 * ratio;	\n		//finalDiffuse = sqrt(finalDiffuse);\n	#else\n		finalDiffuse=vec3(0.0);\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		finalDiffuse+=diffuse;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor =vec4(mainColor.rgb*(u_AmbientColor + finalDiffuse)*shadowValue,mainColor.a);\n	#else\n		gl_FragColor =vec4(mainColor.rgb*(u_AmbientColor + finalDiffuse),mainColor.a);\n	#endif\n	\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		#ifdef RECEIVESHADOW\n			gl_FragColor.rgb+=specular*shadowValue;\n		#else\n			gl_FragColor.rgb+=specular;\n		#endif\n	#endif\n\n\n	#ifdef REFLECTMAP\n		vec3 incident = -viewDir;\n		vec3 reflectionVector = reflect(incident,normal);\n		vec3 reflectionColor  = textureCube(u_ReflectTexture,reflectionVector).rgb;\n		gl_FragColor.rgb += u_MaterialReflect*reflectionColor;\n	#endif\n	  \n	#ifdef FOG\n		float lerpFact=clamp((1.0/gl_FragCoord.w-u_FogStart)/u_FogRange,0.0,1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n		#else\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n	  main_normal();\n	#endif  \n}\n\n";
		var shaderCompile=ShaderCompile3D.add(BLINNPHONG,vs,ps,attributeMap,uniformMap);
		BlinnPhongMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		BlinnPhongMaterial.SHADERDEFINE_NORMALMAP=shaderCompile.registerMaterialDefine("NORMALMAP");
		BlinnPhongMaterial.SHADERDEFINE_SPECULARMAP=shaderCompile.registerMaterialDefine("SPECULARMAP");
		BlinnPhongMaterial.SHADERDEFINE_REFLECTMAP=shaderCompile.registerMaterialDefine("REFLECTMAP");
		BlinnPhongMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		BlinnPhongMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		attributeMap={
			'a_Position':0,
			'a_Color':1,
			'a_Normal':3,
			'a_Texcoord0':2,
			'a_Texcoord1':15,
			'a_TexcoordNext0':14,
			'a_BoneWeights':7,
			'a_BoneIndices':6,
			'a_Tangent0':5};
		uniformMap={
			'u_Bones':[0,0],
			'u_DiffuseTexture':[1,1],
			'u_SpecularTexture':[3,1],
			'u_NormalTexture':[2,1],
			'u_AmbientTexture':[5,1],
			'u_ReflectTexture':[6,1],
			'u_AlphaTestValue':[0,1],
			'u_Albedo':[7,1],
			'u_UVMatrix':[13,1],
			'u_UVAge':[14,1],
			'u_UVAniAge':[8,1],
			'u_MaterialDiffuse':[10,1],
			'u_MaterialAmbient':[9,1],
			'u_MaterialSpecular':[11,1],
			'u_MaterialReflect':[12,1],
			'u_TilingOffset':[15,1],
			'u_WorldMat':[0,2],
			'u_MvpMatrix':[1,2],
			'u_LightmapScaleOffset':[2,2],
			'u_LightMap':[3,2],
			'u_CameraPos':[0,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Diffuse':[4,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Attenuation':[7,4],
			'u_PointLight.Diffuse':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Attenuation':[13,4],
			'u_SpotLight.Diffuse':[14,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]};
		var SIMPLE=Shader3D.nameKey.add("SIMPLE");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\n\n\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))||(defined(LIGHTMAP)&&defined(UV))\nattribute vec2 a_Texcoord0;\nvarying vec2 v_Texcoord0;\n  #ifdef UVTRANSFORM \n  uniform mat4 u_UVMatrix;\n  #endif\n#endif\n\n#if defined(AMBIENTMAP)||(defined(LIGHTMAP)&&defined(UV1))\nattribute vec2 a_Texcoord1;\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\nuniform vec4 u_LightmapScaleOffset;\nvarying vec2 v_LightMapUV;\n#endif\n\n\n#ifdef COLOR\nattribute vec4 a_Color;\nvarying vec4 v_Color;\n#endif\n\n#ifdef BONE\nattribute vec4 a_BoneIndices;\nattribute vec4 a_BoneWeights;\nconst int c_MaxBoneCount = 24;\nuniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\nattribute vec3 a_Normal;\nvarying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP))&&defined(NORMALMAP)\nattribute vec3 a_Tangent0;\nvarying vec3 v_Tangent0;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\nuniform mat4 u_WorldMat;\nvarying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvoid main_castShadow()\n{\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	vec4 position=skinTransform*a_Position;\n	gl_Position = u_MvpMatrix * position;\n#else\n	gl_Position = u_MvpMatrix * a_Position;\n#endif\n \n//TODO没考虑UV动画呢\n#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n	v_Texcoord0=a_Texcoord0;\n#endif\n	v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	vec4 position=skinTransform*a_Position;\n	gl_Position = u_MvpMatrix * position;\n#else\n	gl_Position = u_MvpMatrix * a_Position;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	mat3 worldMat;\n	#ifdef BONE\n		worldMat=mat3(u_WorldMat*skinTransform);\n	#else\n		worldMat=mat3(u_WorldMat);\n	#endif  \n	v_Normal=worldMat*a_Normal;\n	#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n		v_Tangent0=worldMat*a_Tangent0;\n	#endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||defined(RECEIVESHADOW)\n	#ifdef BONE\n		v_PositionWorld=(u_WorldMat*position).xyz;\n	#else\n		v_PositionWorld=(u_WorldMat*a_Position).xyz;\n	#endif\n#endif\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))\n	v_Texcoord0=a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n		v_Texcoord0=vec2(v_Texcoord0.x,v_Texcoord0.y+1.0);\n	#endif\n	#ifdef UVTRANSFORM\n		v_Texcoord0=(u_UVMatrix*vec4(v_Texcoord0,0.0,1.0)).xy;\n	#endif\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\n	#ifdef SCALEOFFSETLIGHTINGMAPUV\n		#ifdef UV1\n			v_LightMapUV=vec2(a_Texcoord1.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,1.0+a_Texcoord1.y*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n		#else\n			v_LightMapUV=vec2(a_Texcoord0.x,a_Texcoord0.y-1.0)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n		#endif \n	#else\n		#ifdef UV1\n			v_LightMapUV=a_Texcoord1;\n		#else\n			v_LightMapUV=a_Texcoord0;\n		#endif \n	#endif \n#endif\n\n#ifdef COLOR\n	v_Color=a_Color;\n#endif\n\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.w;\n	#ifdef SHADOWMAP_PSSM1 \n		v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n	#endif\n#endif\n}\n\nvoid main()\n{\n#ifdef CASTSHADOW\n	main_castShadow();\n#else\n	main_normal();\n#endif\n}";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\nuniform vec4 u_Albedo;\n\n#ifdef ALPHATEST\nuniform float u_AlphaTestValue;\n#endif\n\n#ifdef DIFFUSEMAP\nuniform sampler2D u_DiffuseTexture;\n#endif\n\n#ifdef REFLECTMAP\nuniform samplerCube u_ReflectTexture;\nuniform vec3 u_MaterialReflect;\n#endif\n\n#if   defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(COLOR)&&defined(SPECULARMAP)||defined(NORMALMAP)))\nvarying vec2 v_Texcoord0;\n#endif\n\n#if defined(AMBIENTMAP)||defined(LIGHTMAP)\nvarying vec2 v_LightMapUV;\n#endif\n#ifdef AMBIENTMAP\nuniform sampler2D u_AmbientTexture;\n#endif\n#ifdef LIGHTMAP\nuniform sampler2D u_LightMap;\n#endif\n\n#ifdef COLOR\nvarying vec4 v_Color;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\nuniform vec3 u_MaterialDiffuse;\nuniform vec4 u_MaterialSpecular;\n  #if (defined(DIFFUSEMAP)||defined(COLOR))&&defined(SPECULARMAP) \n  uniform sampler2D u_SpecularTexture;\n  #endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(AMBIENTMAP)||defined(LIGHTMAP)\nuniform vec3 u_MaterialAmbient;\n#endif\n\n#if defined(FOG)||defined(DEPTHFOG)\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\nvarying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\nuniform sampler2D u_NormalTexture;\nvarying vec3 v_Tangent0;\n#endif\n\n#ifdef DIRECTIONLIGHT\nuniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\nuniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\nuniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)||(defined(RECEIVESHADOW)&&(defined(SHADOWMAP_PSM2)||defined(SHADOWMAP_PSM3)))\nuniform vec3 u_CameraPos;\n#endif\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(DEPTHFOG)||defined(REFLECTMAP)\nvarying vec3 v_PositionWorld;\n#endif\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\n\nvoid main_castShadow()\n{\n	//gl_FragColor=vec4(v_posViewZ,0.0,0.0,1.0);\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\nvoid main_normal()\n{\n#if defined(DIFFUSEMAP)&&!defined(COLOR)\n	gl_FragColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n#endif \n  \n#if defined(COLOR)&&!defined(DIFFUSEMAP)\n	gl_FragColor=v_Color;\n#endif \n  \n#if defined(DIFFUSEMAP)&&defined(COLOR)\n	vec4 texColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n	gl_FragColor=texColor*v_Color;\n#endif\n  \n#if !defined(DIFFUSEMAP)&&!defined(COLOR)\n	gl_FragColor=vec4(1.0,1.0,1.0,1.0);\n#endif \n    \n#ifdef ALPHATEST\n	if(gl_FragColor.a-u_AlphaTestValue<0.0)\n		discard;\n#endif\n  \n  \n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(REFLECTMAP)\n	vec3 normal;\n    #if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n		vec3 normalMapSample = texture2D(u_NormalTexture, v_Texcoord0).rgb;\n		normal = normalize(NormalSampleToWorldSpace(normalMapSample, v_Normal, v_Tangent0));\n	#else\n		normal = normalize(v_Normal);\n    #endif\n#endif\n	\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n  \n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||defined(REFLECTMAP)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n	\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef AMBIENTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb); \n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_AmbientTexture, v_LightMapUV).rgb); \n		#endif\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb); \n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb); \n		#endif\n	#endif\n#endif\n\ngl_FragColor=gl_FragColor*u_Albedo;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#if (defined(DIFFUSEMAP)||defined(COLOR))&&defined(SPECULARMAP)\n		specular =specular*texture2D(u_SpecularTexture, v_Texcoord0).rgb;\n    #endif\n	#ifdef RECEIVESHADOW\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular*shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular,gl_FragColor.a);\n	#endif\n#endif\n  \n#ifdef REFLECTMAP\n	vec3 incident = -toEye;\n	vec3 reflectionVector = reflect(incident,normal);\n	vec3 reflectionColor  = textureCube(u_ReflectTexture,reflectionVector).rgb;\n	gl_FragColor.rgb += u_MaterialReflect*reflectionColor;\n#endif\n  \n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	#ifdef ADDTIVEFOG\n		gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n	#else\n		gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n	#endif\n#endif\n#ifdef DEPTHFOG\n	float lerpFact = (-v_PositionWorld.y-u_FogStart)/u_FogRange;\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\nvoid main()\n{\n#ifdef CASTSHADOW		\n	main_castShadow();\n#else\n  main_normal();\n#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(SIMPLE,vs,ps,attributeMap,uniformMap);
		StandardMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		StandardMaterial.SHADERDEFINE_NORMALMAP=shaderCompile.registerMaterialDefine("NORMALMAP");
		StandardMaterial.SHADERDEFINE_SPECULARMAP=shaderCompile.registerMaterialDefine("SPECULARMAP");
		StandardMaterial.SHADERDEFINE_EMISSIVEMAP=shaderCompile.registerMaterialDefine("EMISSIVEMAP");
		StandardMaterial.SHADERDEFINE_AMBIENTMAP=shaderCompile.registerMaterialDefine("AMBIENTMAP");
		StandardMaterial.SHADERDEFINE_REFLECTMAP=shaderCompile.registerMaterialDefine("REFLECTMAP");
		StandardMaterial.SHADERDEFINE_UVTRANSFORM=shaderCompile.registerMaterialDefine("UVTRANSFORM");
		StandardMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		StandardMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		attributeMap={
			'a_Position':0,
			'a_Color':1};
		uniformMap={
			'u_MvpMatrix':[1,2]};
		var LINE=Shader3D.nameKey.add("LINE");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nattribute vec4 a_Color;\nvarying vec4 v_Color;\n\n\nvoid main()\n{\n  gl_Position = u_MvpMatrix * a_Position;\n  v_Color=a_Color;\n}";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nvarying vec4 v_Color;\n\nvoid main()\n{\n  gl_FragColor=v_Color; \n}\n\n";
		ShaderCompile3D.add(LINE,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_position':0,
			'a_normal':3,
			'tangent':5,
			'binormal':4,
			'uv':2,
			'a_BoneWeights':7,
			'a_BoneIndices':6,
			'a_Tangent0':5};
		uniformMap={
			'u_Bones':[0,0],
			'u_lodRect':[9,3],
			'irrad_mat_red':[10,3],
			'irrad_mat_green':[11,3],
			'irrad_mat_blue':[12,3],
			'u_hdrexposure':[13,3],
			'u_aoObjPos':[14,1],
			'texBaseColor':[1,1],
			'texNormal':[2,1],
			'texPbrInfo':[3,1],
			'texPrefilterdEnv':[8,3],
			'texHSNoise':[15,1],
			'texPrefilterDiff':[7,3],
			'u_AlphaTestValue':[0,1],
			'texBRDFLUT':[4,1],
			'u_UVAniAge':[5,1],
			'u_roughness':[6,1],
			'u_metaless':[7,1],
			'u_UVMatrix':[8,1],
			'u_UVAge':[9,1],
			'modelMatrix':[0,2],
			'mvp':[1,2],
			'cameraPosition':[0,3],
			'u_View':[1,3],
			'u_Project':[2,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Diffuse':[4,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Attenuation':[7,4],
			'u_PointLight.Diffuse':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Attenuation':[13,4],
			'u_SpotLight.Diffuse':[14,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]};
		var PBR=Shader3D.nameKey.add("PBR");
		vs="\nuniform mat4 modelMatrix;\n//uniform mat4 modelViewMatrix;\n//uniform mat4 projectionMatrix;\nuniform mat4 u_View;\nuniform mat4 u_Project;\nuniform mat4 mvp;\n//uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n\nattribute vec3 a_position;\nattribute vec3 a_normal;\n#ifdef HAS_TANGENT\nattribute vec3 tangent;\nattribute vec3 binormal;\n#endif\nattribute vec2 uv;\n#ifdef BONE\nattribute vec4 a_BoneIndices;\nattribute vec4 a_BoneWeights;\nconst int c_MaxBoneCount = 24;\nuniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying vec3 vLightDir;\nvarying vec3 vViewDir;\n#ifdef HAS_TANGENT\nvarying vec3 vWorldTangent;\nvarying vec3 vWorldBinormal;\n#endif\n\n#ifdef RECEIVESHADOW\nvarying float v_posViewZ;\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\nvoid main() {\n#ifdef BONE\n	mat4 skinTransform=mat4(0.0);\n	skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n	skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n	skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n	skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n	gl_Position = mvp*skinTransform*vec4(a_position,1.);\n	mat4 modelMat = modelMatrix*skinTransform;\n#else\n	gl_Position = mvp*vec4(a_position,1.);\n	mat4 modelMat = modelMatrix;\n#endif	\n	vWorldPos = modelMat*vec4(a_position,1.);\n\n#ifdef CASTSHADOW \n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		vUv = uv;\n	#endif	\n#else\n    vUv = uv;\n	vWorldNorm = normalize((modelMat*vec4(a_normal,0.0)).xyz);\n	#ifdef HAS_TANGENT\n	vWorldTangent = normalize((modelMat*vec4(tangent,0.0)).xyz);\n	vWorldBinormal = normalize((modelMat*vec4(binormal,0.0)).xyz);\n	#endif\n    \n    vViewDir = (vWorldPos.xyz-cameraPosition);//这个不能normalize。否则无法线性差值了\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.z;\n	#ifdef SHADOWMAP_PSSM1 \n		v_lightMVPPos = u_lightShadowVP[0] * vWorldPos;\n	#endif\n#endif	\n#endif\n}\n";
		ps="//#version 300 es\n\nprecision highp float;\nprecision lowp int;\n\nconst float PI = 3.14159265358979323846264;\nconst float _2PI = 6.2831853071796;\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\n#ifdef HAS_TANGENT\nvarying vec3 vWorldTangent;\nvarying vec3 vWorldBinormal;\n#endif\nvarying vec3 vViewDir;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\n//\nuniform sampler2D texBaseColor;\nuniform sampler2D texNormal;\n//预计算的贴图\nuniform sampler2D texPrefilterdEnv;\nuniform sampler2D texBRDFLUT;\nuniform sampler2D texPrefilterDiff;\n#ifdef HAS_PBRINFO\nuniform sampler2D texPbrInfo;   //Ao, Roughness, Metallic\n#endif\nuniform float u_hdrexposure;\nuniform float u_AlphaTestValue;\n\nuniform float u_roughness;\nuniform float u_metaless;\nconst float maxlv = 7.;	//现在只支持512分辨率的环境贴图\nconst int nmaxlv = 9;//\n							\nuniform mat4 irrad_mat_red;\nuniform mat4 irrad_mat_green;\nuniform mat4 irrad_mat_blue;							\n\nvec3 speccontrib = vec3(0.);\n\nconst float _maxu8 = 255.0;\nconst float _maxu16 = 65535.0;\nconst float _shift8 = 256.0;    //平移的话是*256而不是255\nvec2 _RGBAToU16(const in vec4 rgba){\n    return vec2((rgba.r*_maxu8+rgba.g*_maxu8*_shift8)/_maxu16, (rgba.b*_maxu8+rgba.a*_maxu8*_shift8)/_maxu16);\n}\nvec3 _RGBEToRGB( const in vec4 rgba ){\n    float f = pow(2.0, rgba.w * 255.0 - (128.0 + 8.0));\n    return rgba.rgb * (255.0 * f);\n}\n\nfloat saturate(float v){\n    return min(max(v,0.),1.);\n}\n\nvec4 tex2dLod(sampler2D tex, float u, float v, float lod){\n	vec2 uv = vec2(u,v);\n	uv+=mod(gl_FragCoord.xy-vec2(0.5),2.0)*vec2(128.,0.);\n	return texture2D(tex,uv,lod-16.);\n}\n\n/*\n* 对一个全景图进行采样。假设x轴指向中心。\n*/\nvec4 texPanorama(sampler2D tex, const in vec3 dir){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return texture2D(tex,vec2(envu,envv));\n}\n\nvec4 texPanoramaLod(sampler2D tex, const in vec3 dir, float lod){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return tex2dLod(tex,envu,envv,lod);\n}\n\n/*\n    计算sh光照。\n    使用level=2，所以需要9个系数。\n    https://cseweb.ucsd.edu/~ravir/papers/envmap/envmap.pdf\n*/\nfloat environment_exposure = 1.0;\nvec3 diff_sh9(vec3 dir){\n	vec4 shDir = vec4(dir.x,-dir.z,dir.y,1.0);\n  return max(vec3(0.0), vec3(\n	dot(shDir, irrad_mat_red * shDir),\n	dot(shDir, irrad_mat_green * shDir),\n	dot(shDir, irrad_mat_blue * shDir)\n	)) * environment_exposure;	\n}\n\n#ifdef HAS_TANGENT\nvec3 applyNormalTex( vec3 norm, vec3 surf_norm ) {\n    vec3 mapN = norm * 2.0 - 1.0;\n    //mapN.xy = normalScale * mapN.xy;\n    mat3 tsn = mat3( vWorldTangent, vWorldBinormal, surf_norm );\n    return normalize( tsn * mapN );\n}\n#endif\n\nvec4 pbrlight(vec3 normal, float rough, float NoV, vec3 R){\n    vec4 basecolor = texture2D(texBaseColor,vUv);\n	basecolor.rgb = pow(basecolor.rgb,vec3(2.2));\n	float metaless = 1.0; 	\n	const float ismetalinfov = (128./255.);\n	if(basecolor.a>=ismetalinfov){//这时候表示金属度\n		metaless = (basecolor.a-ismetalinfov)*2.;\n		basecolor.a = 1.0;\n	}else{\n		metaless = 0.;\n		basecolor.a = basecolor.a*2.0;\n	}\n	#ifdef FIX_METALESS\n	metaless = u_metaless;\n	#endif\n	#ifdef HAS_PBRINFO	\n	vec4 pbrinfo = texture2D(texPbrInfo, vUv);\n	metaless = pbrinfo.b;\n	rough = pbrinfo.g;\n	#endif\n    const vec3 nonmetalF0 =vec3(0.02);\n    vec3 F0 =  mix(nonmetalF0, basecolor.rgb, metaless);\n	\n    vec4 PrefilteredColor = texPanoramaLod(texPrefilterdEnv, R, rough*maxlv);\n    PrefilteredColor.rgb = _RGBEToRGB(PrefilteredColor);\n    vec4 EnvBRDF = texture2D(texBRDFLUT,vec2(rough , NoV));//TODO lod\n    vec2 rg = _RGBAToU16(EnvBRDF);    \n    speccontrib = (F0* rg.x + saturate( 50.0 * PrefilteredColor.g ) * rg.y);\n	vec3 color_spec = PrefilteredColor.rgb*speccontrib;\n	\n	vec3 color_diff=diff_sh9(normal);\n	vec3 outc =  color_diff*mix(basecolor.rgb,vec3(0.),metaless)*(vec3(1.0)-speccontrib)+color_spec;\n	#ifdef HAS_PBRINFO\n	outc*=pbrinfo.r;\n	#endif\n	return vec4(outc, basecolor.a);\n}\n\nvec3 oldlight(vec4 normal, float NoV, vec3 R){\n    vec4 basecolor = texture2D(texBaseColor,vUv);\n	const vec3 lightdir=normalize(vec3(1.,1.,0.));\n	const vec3 spcecol = vec3(1.,0.8,0.8);\n	const vec3 amb = vec3(0.5);\n	vec3 diffv =  (vec3(saturate(dot(lightdir,normal.xyz)))+amb);\n	//vec3 spec = spcecol* pow(saturate(dot(R,lightdir)),(1.-pbrinfo.g)*5.);\n	return diffv*basecolor.rgb;//+spec;\n}\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\nvarying float v_posViewZ;\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nvoid main() {\n#ifdef CASTSHADOW\n	gl_FragColor=packDepth(gl_FragCoord.w);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(texBaseColor,vUv).w;\n		if( alpha < u_AlphaTestValue ){\n			discard;\n		}\n	#endif\n#else\n\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,vWorldPos.xyz,v_posViewZ,0.0001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,vWorldPos.xyz,v_posViewZ,0.0001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.0001);\n		#endif\n	#endif	\n	\n    vec3 normal =  normalize(vWorldNorm);\n	vec4 normtex = texture2D( texNormal, vUv );\n	#ifdef HAS_TANGENT	\n	normal = applyNormalTex(normtex.xyz, normal);\n	#endif\n    vec3 view   = -normalize(vViewDir);\n    float NoV = saturate(dot( view, normal ));\n    vec3 R = 2. * NoV * normal - view;\n	float roughness = normtex.a;\n	#ifdef FIX_ROUGHNESS\n	roughness = u_roughness;\n	#endif\n	\n	vec4 pbrl = pbrlight(normal,roughness,NoV,R)*u_hdrexposure;\n    gl_FragColor.rgb =  pow(pbrl.rgb,vec3(0.45455));\n	//gl_FragColor.rgb = oldlight(normtex,NoV,R);\n	#ifdef RECEIVESHADOW\n	gl_FragColor.rgb *= max(shadowValue,0.7);\n	#endif\n	\n    gl_FragColor.a = pbrl.a;\n\n#endif\n}\n";
		shaderCompile=ShaderCompile3D.add(PBR,vs,ps,attributeMap,uniformMap);
		PBRMaterial.SHADERDEFINE_FIX_METALESS=shaderCompile.registerMaterialDefine("FIX_METALESS");
		PBRMaterial.SHADERDEFINE_FIX_ROUGHNESS=shaderCompile.registerMaterialDefine("FIX_ROUGHNESS");
		PBRMaterial.SHADERDEFINE_HAS_TANGENT=shaderCompile.registerMaterialDefine("HAS_TANGENT");
		PBRMaterial.SHADERDEFINE_HAS_PBRINFO=shaderCompile.registerMaterialDefine("HAS_PBRINFO");
		PBRMaterial.SHADERDEFINE_USE_GROUNDTRUTH=shaderCompile.registerMaterialDefine("USE_GROUNDTRUTH");
		PBRMaterial.SHADERDEFINE_TEST_CLIPZ=shaderCompile.registerMaterialDefine("CLIPZ");
		attributeMap={
			'a_Position':0,
			'a_Normal':3,
			'a_Tangent0':5,
			'a_Texcoord0':2,
			'a_BoneWeights':7,
			'a_BoneIndices':6
		};
		uniformMap={
			'u_Bones':[0,0],
			'u_MvpMatrix':[1,2],
			'u_WorldMat':[0,2],
			'u_CameraPos':[0,3],
			'u_AlphaTestValue':[0,1],
			'u_DiffuseColor':[7,1],
			'u_EmissionColor':[8,1],
			'u_DiffuseTexture':[1,1],
			'u_NormalTexture':[3,1],
			'u_ParallaxTexture':[4,1],
			'u_MetallicGlossTexture':[2,1],
			'u_OcclusionTexture':[5,1],
			'u_EmissionTexture':[6,1],
			'u_metallic':[9,1],
			'u_smoothness':[10,1],
			'u_smoothnessScale':[11,1],
			'u_occlusionStrength':[13,1],
			'u_normalScale':[14,1],
			'u_parallaxScale':[15,1],
			'u_TilingOffset':[17,1],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Color':[4,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]
		};
		var PBRStandard=Shader3D.nameKey.add("PBRStandard");
		vs="attribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\nuniform mat4 u_WorldMat;\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	mat3 worldMat;\n	#ifdef BONE\n		mat4 skinTransform = mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n		worldMat=mat3(u_WorldMat*skinTransform);\n		v_PositionWorld = (u_WorldMat * position).xyz;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n		worldMat = mat3(u_WorldMat);\n		v_PositionWorld = (u_WorldMat * a_Position).xyz;\n	#endif\n	\n	v_Normal = worldMat * a_Normal;\n	v_Tangent = worldMat * a_Tangent0.xyz;\n	v_Binormal = cross(v_Normal, v_Tangent) * a_Tangent0.w;\n  \n	v_Texcoord0 = a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n	#endif\n		v_Texcoord0=vec2(v_Texcoord0.x,1.0 + v_Texcoord0.y);\n  \n	v_ViewDir = u_CameraPos - v_PositionWorld;\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\n\nuniform vec4 u_AmbientColor;\nuniform vec4 u_DiffuseColor;\n\n#ifdef DIFFUSETEXTURE\n	uniform sampler2D u_DiffuseTexture;\n#endif\n#ifdef METALLICGLOSSTEXTURE\n	uniform sampler2D u_MetallicGlossTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\n#include \"PBRStandardLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nuniform DirectionLight u_DirectionLight;\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec2 mg;\n	#ifdef DIFFUSETEXTURE\n		vec4 diffuseTextureColor = texture2D(u_DiffuseTexture, uv0);\n		vec4 diffuseColor = diffuseTextureColor * u_DiffuseColor;\n		mg = MetallicGloss(diffuseTextureColor.a, uv0);\n	#else\n		vec4 diffuseColor = u_DiffuseColor;\n		mg = MetallicGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(diffuseColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n	\n	gl_FragColor = diffuseColor;\n	\n	vec3 normal = UnpackScaleNormal(uv0);\n  \n	vec3 gi = (u_AmbientColor * Occlusion(uv0)).rgb;\n  \n	vec4 color = PBRStandardDiectionLight(diffuseColor.rgb, mg.r, mg.g, normal, viewDir, u_DirectionLight, gi);\n	\n	color.a = diffuseColor.a;\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(PBRStandard,vs,ps,attributeMap,uniformMap);
		PBRStandardMaterial.SHADERDEFINE_DIFFUSETEXTURE=shaderCompile.registerMaterialDefine("DIFFUSETEXTURE");
		PBRStandardMaterial.SHADERDEFINE_METALLICGLOSSTEXTURE=shaderCompile.registerMaterialDefine("METALLICGLOSSTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA=shaderCompile.registerMaterialDefine("SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA");
		PBRStandardMaterial.SHADERDEFINE_NORMALTEXTURE=shaderCompile.registerMaterialDefine("NORMALTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_PARALLAXTEXTURE=shaderCompile.registerMaterialDefine("PARALLAXTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_OCCLUSIONTEXTURE=shaderCompile.registerMaterialDefine("OCCLUSIONTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_EMISSION=shaderCompile.registerMaterialDefine("EMISSION");
		PBRStandardMaterial.SHADERDEFINE_EMISSIONTEXTURE=shaderCompile.registerMaterialDefine("EMISSIONTEXTURE");
		PBRStandardMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		attributeMap={
			'a_Position':0,
			'a_Normal':3,
			'a_Tangent0':5,
			'a_Texcoord0':2,
			'a_BoneWeights':7,
			'a_BoneIndices':6
		};
		uniformMap={
			'u_Bones':[0,0],
			'u_MvpMatrix':[1,2],
			'u_WorldMat':[0,2],
			'u_CameraPos':[0,3],
			'u_AlphaTestValue':[0,1],
			'u_DiffuseColor':[7,1],
			'u_SpecularColor':[8,1],
			'u_EmissionColor':[9,1],
			'u_DiffuseTexture':[1,1],
			'u_NormalTexture':[3,1],
			'u_ParallaxTexture':[4,1],
			'u_SpecularTexture':[2,1],
			'u_OcclusionTexture':[5,1],
			'u_EmissionTexture':[6,1],
			'u_smoothness':[10,1],
			'u_smoothnessScale':[11,1],
			'u_occlusionStrength':[13,1],
			'u_normalScale':[14,1],
			'u_parallaxScale':[15,1],
			'u_TilingOffset':[17,1],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Color':[4,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]
		};
		var PBRSpecular=Shader3D.nameKey.add("PBRSpecular");
		vs="attribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\nuniform mat4 u_WorldMat;\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	#ifdef BONE\n		mat4 skinTransform=mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n		v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	mat3 worldMat;\n	#ifdef BONE\n		mat4 skinTransform = mat4(0.0);\n		skinTransform += u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		vec4 position = skinTransform * a_Position;\n		gl_Position = u_MvpMatrix * position;\n		worldMat=mat3(u_WorldMat*skinTransform);\n		v_PositionWorld = (u_WorldMat * position).xyz;\n	#else\n		gl_Position = u_MvpMatrix * a_Position;\n		worldMat = mat3(u_WorldMat);\n		v_PositionWorld = (u_WorldMat * a_Position).xyz;\n	#endif\n	\n	v_Normal = worldMat * a_Normal;\n	v_Tangent = worldMat * a_Tangent0.xyz;\n	v_Binormal = cross(v_Normal, v_Tangent) * a_Tangent0.w;\n  \n	v_Texcoord0 = a_Texcoord0;\n	#ifdef TILINGOFFSET\n		v_Texcoord0=(vec2(v_Texcoord0.x,v_Texcoord0.y-1.0)*u_TilingOffset.xy)+u_TilingOffset.zw;\n	#endif\n		v_Texcoord0=vec2(v_Texcoord0.x,1.0 + v_Texcoord0.y);\n  \n	v_ViewDir = u_CameraPos - v_PositionWorld;\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\n\nuniform vec4 u_AmbientColor;\nuniform vec4 u_DiffuseColor;\nuniform vec4 u_SpecularColor;\n\n#ifdef DIFFUSETEXTURE\n	uniform sampler2D u_DiffuseTexture;\n#endif\n#ifdef SPECULARTEXTURE\n	uniform sampler2D u_SpecularTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\n#include \"PBRSpecularLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nuniform DirectionLight u_DirectionLight;\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec4 sg;\n	#ifdef DIFFUSETEXTURE\n		vec4 diffuseTextureColor = texture2D(u_DiffuseTexture, uv0);\n		vec4 diffuseColor = diffuseTextureColor * u_DiffuseColor;\n		sg = SpecularGloss(diffuseTextureColor.a, uv0);\n	#else\n		vec4 diffuseColor = u_DiffuseColor;\n		sg = SpecularGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(diffuseColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n  \n	vec3 normal = UnpackScaleNormal(uv0);\n	\n	vec3 gi = (u_AmbientColor * Occlusion(uv0)).rgb;\n	\n	//float a = (sg.r+sg.g+sg.b) / 3.0;\n  \n	vec4 color = PBRSpecularDiectionLight(diffuseColor.rgb, sg.rgb, sg.a, normal,viewDir, u_DirectionLight, gi);\n	\n	color.a = diffuseColor.a;\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		shaderCompile=ShaderCompile3D.add(PBRSpecular,vs,ps,attributeMap,uniformMap);
		PBRSpecularMaterial.SHADERDEFINE_DIFFUSETEXTURE=shaderCompile.registerMaterialDefine("DIFFUSETEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_SPECULARTEXTURE=shaderCompile.registerMaterialDefine("SPECULARTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA=shaderCompile.registerMaterialDefine("SMOOTHNESSSOURCE_DIFFUSETEXTURE_ALPHA");
		PBRSpecularMaterial.SHADERDEFINE_NORMALTEXTURE=shaderCompile.registerMaterialDefine("NORMALTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_PARALLAXTEXTURE=shaderCompile.registerMaterialDefine("PARALLAXTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_OCCLUSIONTEXTURE=shaderCompile.registerMaterialDefine("OCCLUSIONTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_EMISSION=shaderCompile.registerMaterialDefine("EMISSION");
		PBRSpecularMaterial.SHADERDEFINE_EMISSIONTEXTURE=shaderCompile.registerMaterialDefine("EMISSIONTEXTURE");
		PBRSpecularMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		attributeMap={
			'a_position':0,
			'a_normal':3,
			'uv':2};
		uniformMap={
			'irrad_mat_red':[10,3],
			'irrad_mat_green':[11,3],
			'irrad_mat_blue':[12,3],
			'u_hdrexposure':[13,3],
			'texBaseColor':[1,1],
			'texNormal':[2,1],
			'texSky':[11,1],
			'texUnderWater':[3,1],
			'texPrefilterdEnv':[8,3],
			'texPrefilterDiff':[7,3],
			'texWaterDisp':[4,1],
			'texWaveDetail':[9,1],
			'texDeepColor':[10,1],
			'texWaterInfo':[16,1],
			'texFoam':[17,1],
			'GEOWAVE_UV_SCALE':[18,1],
			'modelMatrix':[0,2],
			'mvp':[1,2],
			'cameraPosition':[0,3],
			'u_curTm':[8,1],
			'u_scrsize':[15,1],
			'u_WaveInfoD':[13,1],
			'u_WaveInfo':[12,1],
			'u_WaveMainDir':[14,1],
			'u_DeepScale':[20,1],
			'u_SeaColor':[19,1],
			'u_View':[1,3],
			'u_Project':[2,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Diffuse':[4,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Attenuation':[7,4],
			'u_PointLight.Diffuse':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Attenuation':[13,4],
			'u_SpotLight.Diffuse':[14,4]};
		var Water=Shader3D.nameKey.add("Water");
		vs="\nuniform mat4 modelMatrix;\n//uniform mat4 modelViewMatrix;\n//uniform mat4 projectionMatrix;\nuniform mat4 u_View;\nuniform mat4 u_Project;\nuniform mat4 mvp;\n//uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\nuniform float u_curTm;\n\nattribute vec3 a_position;\nattribute vec3 a_normal;\nattribute vec2 uv;\n//uniform sampler2D texWaterDisp;\n#ifdef USE_VERTEX_DEEPINFO\n#else\nuniform sampler2D texWaterInfo;\nvarying vec4 vWaterInfo;\nuniform float u_DeepScale;//texWaterInfo.r*vDeepScale\n#endif\nuniform float u_WaveMainDir;	//主波方向\nuniform float GEOWAVE_UV_SCALE ;//= 100.0;\n\n\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec3 vWorldTan;\nvarying vec3 vWorldBin;\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying vec3 vLightDir;\nvarying vec3 vViewDir;\nvarying vec3 vDisp;\nvarying float fDeep;\nvarying mat2 matUVTrans;\nvarying float fFoam;\n\nconst float PI = 3.14159265358979323846264;\n\n#include \"WaveFunction.glsl\"\n\nvec2 getPosFromUV(vec2 uv){\n	return uv*50.;\n}\n\nvoid main() {\n	vec3 pos = a_position;\n    vUv = uv;\n	\n	//vDisp = texture2D(texWaterDisp,uv).rgb;\n	//vec3 disp = vDisp;\n	\n	//TODO 这里有个潜规则。\n	float tt = pos.y; pos.y=pos.z; pos.z=-tt;\n	\n	#ifdef USE_VERTEX_DEEPINFO\n	fDeep = -pos.y;\n	pos.y=0.0;\n	#else\n	vWaterInfo = texture2D(texWaterInfo,uv);\n	fDeep = vWaterInfo.r*u_DeepScale;\n	#endif\n	\n	\n	//计算波形\n	mat4 modelMat = modelMatrix;\n	vec3 opos, T,B,N;\n	float foams=0.;\n	vec2 uvpos = uv*GEOWAVE_UV_SCALE+vec2(modelMat[3][0],0.);//TODO 如果有旋转缩放怎么办\n	calcGerstnerWave(u_curTm, pos,fDeep, uvpos,opos,B,T,N,foams);\n	fFoam = foams;\n	gl_Position = mvp*vec4(opos,1.);\n	vWorldPos = modelMat*vec4(opos,1.);\n\n	vWorldNorm = normalize((modelMatrix*vec4(N,0.0)).xyz);\n	vWorldTan = normalize((modelMatrix*vec4(T,0.0)).xyz);\n	vWorldBin = normalize((modelMatrix*vec4(B,0.0)).xyz);\n    vViewDir = vWorldPos.xyz-cameraPosition; //这个不能取normalize，否则会引入非线性\n	\n	float s = sin(u_WaveMainDir);\n	float c = cos(u_WaveMainDir);\n	matUVTrans = mat2(c,-s,s,c);\n}\n";
		ps="//#version 300 es\n\nprecision highp float;\nprecision lowp int;\n\nconst float PI = 3.14159265358979323846264;\nconst float _2PI = 6.2831853071796;\nvarying vec2 vUv;\nvarying vec3 vWorldNorm;\nvarying vec3 vWorldTan;\nvarying vec3 vWorldBin;\nvarying vec3 vViewDir;//入射。pos-cam\nvarying vec4 vViewPos;\nvarying vec4 vWorldPos;\nvarying float fDeep;\nvarying mat2 matUVTrans;\n#ifdef USE_VERTEX_DEEPINFO\n#else\nvarying vec4 vWaterInfo;\n#endif\nmat3 matTBNOff;//\n\n//\nuniform sampler2D texBaseColor;\nuniform sampler2D texNormal;\n#ifdef CUBE_ENV\nuniform samplerCube texSky;\n#else\nuniform sampler2D texSky;\n#endif\nuniform sampler2D texUnderWater;\nuniform sampler2D texWaveDetail;\n//uniform sampler2D texDeepColor;\nuniform sampler2D texFoam;\nvarying float fFoam;\nuniform float u_curTm;\nuniform vec2 u_scrsize;\nuniform vec3 u_SeaColor;//\n\nconst int NumTexWaves=4;\nconst float Amp_over_L = 0.01;\n//const vec3 SEA_COLOR1 = vec3(0.0292,0.672,0.7467);//大洋\n//const vec3 SEA_COLOR2 = vec3(0,0.927,0.43);//近海\n\nconst float _maxu8 = 255.0;\nconst float _maxu16 = 65535.0;\nconst float _shift8 = 256.0;    //平移的话是*256而不是255\nvec2 _RGBAToU16(const in vec4 rgba){\n    return vec2((rgba.r*_maxu8+rgba.g*_maxu8*_shift8)/_maxu16, (rgba.b*_maxu8+rgba.a*_maxu8*_shift8)/_maxu16);\n}\nvec3 _RGBEToRGB( const in vec4 rgba ){\n    float f = pow(2.0, rgba.w * 255.0 - (128.0 + 8.0));\n    return rgba.rgb * (255.0 * f);\n}\n\nfloat saturate(float v){\n    return min(max(v,0.),1.);\n}\n\n/*\n	各种 ToneMap\n*/\n//Reinhard\nvec3 ReinhardToneMapping(vec3 color, float adapted_lum) {\n    const float MIDDLE_GREY = 1.;\n    color *= MIDDLE_GREY / adapted_lum;\n    return color / (1.0 + color);\n}\n\n//CE2\nvec3 CEToneMapping(vec3 color, float adapted_lum){\n    return 1. - exp(-adapted_lum * color);\n}\n\n//UC2\nvec3 F1(vec3 x){\n	const float A = 0.22;\n	const float B = 0.30;\n	const float C = 0.10;\n	const float D = 0.20;\n	const float E = 0.01;\n	const float F = 0.30;\n \n	return ((x * (A * x + C * B) + D * E) / (x * (A * x + B) + D * F)) - E / F;\n}\n\nvec3 Uncharted2ToneMapping(vec3 color, float adapted_lum){\n	const vec3 WHITE = vec3(11.2);\n	return F1(1.6 * adapted_lum * color) / F1(WHITE);\n}\n\n//ACES\nvec3 ACESToneMapping(vec3 color, float adapted_lum){\n	const float A = 2.51;\n	const float B = 0.03;\n	const float C = 2.43;\n	const float D = 0.59;\n	const float E = 0.14;\n\n	color *= adapted_lum;\n	return (color * (A * color + B)) / (color * (C * color + D) + E);\n}\n\n/*\n* 对一个全景图进行采样。假设x轴指向中心。\n*/\nvec4 texPanorama(sampler2D tex, const in vec3 dir){\n	float envu = atan(dir.z,dir.x)/_2PI+0.5; 	\n	float envv = acos(dir.y)/PI;//(1.0-dir.y)/2.0;\n	return texture2D(tex,vec2(envu,envv));\n}\n\n/*\n	与位于0点的测试棒的相交测试交点\n	这个是瞎写的，只是为了测试\n*/\nbool hitClydiner(vec3 pos, vec3 dir, out vec3 hitpos, out vec3 hitnormal){\n	const float r = 0.5;\n	float a = dir.x*dir.x+dir.z*dir.z;\n	float b = 2.*dir.x*pos.x+2.*dir.z*pos.z;\n	float c = pos.x*pos.x+pos.z*pos.z-r*r;\n	float d = b*b-4.*a*c;\n	if(d>=0.0){\n		float t = (-b+sqrt(d))/2./a;\n		t =min(t, (-b-sqrt(d))/2./a);\n		hitpos = pos+dir*t;\n		return true;\n	}\n	/*\n	vec3 v1 = normalize(cross(dir,vec3(0.,1.,0.)));//公垂线\n	float dist = dot(pos,v1);//最短距离\n	if(abs(dist)<r){\n		return true;\n	}\n	*/\n	return false;\n}\n\n///* 根据散射公式来计算某个方向的颜色 *///\n//\nfloat phase_function(float costheta, float g, float g2){\n	return 1.5*( (1.0-g2) / (2.0+g2) ) * (1.0+costheta*costheta) / pow(1.0+g2-2.0*g*costheta, 1.5);	\n}\n\nconst float _density = .2;\nconst vec3 _vLightDir=vec3(0.,-1.,0.);//必须是规格化的\nconst int _SAMPLENUM = 20;\nconst float _K1 = 1.0;\nconst float _g = -0.93;\n//\nvec3 calcScatter(vec3 start, vec3 dir, vec3 end){\n	float len = length(end-start);\n	float costheta = dot(dir,_vLightDir);\n	float g2 = _g*_g;\n	float K = _K1*len*_density*phase_function(costheta,_g,g2);\n	//用分段的方式来积分\n	float dlen = len/float(_SAMPLENUM);//距离平分\n	float ddeep = (start.y-end.y)/float(_SAMPLENUM);//深度平分\n	float sum=0.;\n	for( int i=0; i<_SAMPLENUM; i++){\n		float fi = float(i);\n		float v1 = exp(-_density*(dlen+ddeep)*fi);//TODO 应该可以用分析法计算出来\n		sum += v1;\n	}\n	return vec3(K*sum);\n}\n///* 根据散射公式来计算某个方向的亮度  END *///\n\nconst float cDeep = -2.;	//假设水的深度\nvec3 getShuiDiColor(vec3 pos, vec3 dir, vec3 normal){\n	//一个无限大的水底，黑白格纹理。纹理长度为1米\n	float t = ( cDeep-pos.y )/dir.y;\n	if(t<0.) return vec3(1.,0.,0.);//TEST\n	bool bhit = false;\n	vec3 hitpos;\n	vec3 hitcolor;\n	vec3 hn;\n	if(hitClydiner(pos,dir,hitpos,hn) && hitpos.y>cDeep && hitpos.y<pos.y){\n		bhit=true;\n		hitcolor = vec3(.8,.8,.8);\n\n	}else\n	{\n		hitpos = pos+dir*t;\n		vec3 hp = floor(hitpos);\n		float a = mod((hp.x+hp.z),2.);\n		hitcolor = (a<.9)?vec3(0.,0.,0.):vec3(1.,1.,1.);\n		//hitcolor = texture2D(texUnderWater,hitpos.xz/10.).rgb;\n	}\n	\n	float l = length(hitpos-pos);\n	//return texture2D(texDeepColor,vec2(min(max(l/400.,0.),1.),0.5)).rgb;\n	//return SEA_COLOR1*calcScatter(pos,dir,hitpos);\n	float left = pow(0.8,l);//假设透过率为80%，则到达水底的时候的光强。\n	return mix(hitcolor,u_SeaColor,1.-left);\n}\n\n/*\n	view已经normalize了\n*/\nvec3 getRefractColor(vec3 view,vec3 normal){\n	vec3 T = refract(-view, normal, 0.7);\n	return getShuiDiColor(vWorldPos.xyz,T,normal); \n}\n\nvec4 calcWaterC(vec3 view, vec3 normal, float von, vec3 R, float rough){\n	/*\n	只有浪顶的法线向下，也就是波形形成了交叠的时候，才会这样，所以要通过参数控制避免出现这种情况，而不是在这里保护。\n	if(dot(R,vec3(0.,1.,0.))<0.){\n		R = -R;\n	}\n	*/\n	//vec3 refr = getRefractColor(-view,normal);\n#ifdef USE_REFR_TEX	\n	vec3 refr = texture2D(texUnderWater, gl_FragCoord.xy/u_scrsize+normal.xz/8.).rgb;\n#else\n	vec3 refr = u_SeaColor;\n#endif\n	float F0=0.02;\n	//菲涅尔，越大反射越强\n	float f =  F0+(1.0-F0)*exp2((-5.55473*von-6.98316)*von);\n	//float f = F0+(1.0-F0)*pow(1.-von,5.);\n	//能看到水底的程度。反射剩余的*水中的衰减\n	//float a = (1.-f)*(1.-deepk);\n#ifdef CUBE_ENV\n	vec4 reflc = textureCube(texSky,R);\n#else\n	vec4 reflc = texPanorama(texSky, R);\n#endif\n#ifdef HDR_ENV\n	vec3 refl = _RGBEToRGB(reflc)*f;\n#else\n	vec3 refl = reflc.rgb*f;\n#endif\n	//return vec4(refl*(1.-rough),1.);\n	\n	//vec3 refl = reflc.rgb*f;\n	vec3 final = mix(refr, u_SeaColor, min(fDeep/10.,1.))+refl*(max(0.,1.-rough));\n#ifdef HDR_ENV\n	final = ACESToneMapping(final,1.);//TODO 这个要uniform传入\n#endif\n	return vec4(final,f);\n}\n\nvoid main() {\n    vec3 normal =  normalize(vWorldNorm);\n	//如果uv=1为100米，希望每个细节纹理表示20米的小波形，则uv缩放是 100/20。细节纹理内部也要用这个值，即pos=uv*20\n	vec2 ruv = matUVTrans*vUv;\n	vec3 detailNorm = texture2D(texWaveDetail,fract(ruv*5.)).rgb*2.-vec3(1.);//TODO uv怎么算\n	float texNormScale = 2.*PI*float(NumTexWaves)*Amp_over_L*2.5;\n	detailNorm *= vec3(texNormScale,1.,texNormScale);\n	//旋转\n	//细节纹理来自rendertarget，因此需要颠倒z\n	\n	matTBNOff = mat3(matUVTrans[0][0],0.,matUVTrans[1][0],\n	0.,1.,0.,\n	matUVTrans[0][1],0.,matUVTrans[1][1]\n	);\n	\n	/*\n	matTBNOff = mat3(0.,0.,1.,\n	0.,1.,0.,\n	-1.,0.,0.\n	);\n	*/\n\n    mat3 tsn = mat3( vWorldBin, normal, vWorldTan);	\n    //normal = normalize(tsn * matTBNOff * detailNorm);\n	normal = normalize(tsn * detailNorm); //这个应该更正确。因为本身方向就是根据uv算的，如果是静态图片才需要转换。\n	//vec4 normtex = texture2D( texNormal, vUv );\n    vec3 view   = -normalize(vViewDir);//view 是指向camera的\n    float NoV = saturate(dot( view, normal ));\n    //vec3 R = 2. * NoV * normal - view;\n	\n#ifdef USE_FOAM	\n	vec4 foamc = (texture2D(texFoam,vUv*50.)+texture2D(texFoam,vUv*20.))/2.;\n	float nearcoast = 1.-min(fDeep/10.,1.);// 1.-vWaterInfo.r;\n	float foams = (nearcoast/4.+fFoam)*2.*nearcoast;\n#else\n	float foams =0.;\n#endif\n	\n	vec3 R = reflect(-view,normal);\n	vec4 wc = calcWaterC(view, normal,NoV,R, foams);\n\n	gl_FragColor.rgb = wc.rgb;//normalize(detailNorm).rrr;//((normal)+vec3(0.0))/1.;//normalize(normal).rgb;//texture2D(texWaveDetail,vUv).rgb;// fracColor * texture2D(texUnderWater, vUv*20.0).rgb;// vec3(1.0);//pbrl.rgb;\n    gl_FragColor.a = 1.0;//wc.a;\n#ifdef USE_FOAM\n	gl_FragColor.rgb = mix(gl_FragColor.rgb,vec3(1.),foamc.a*foams);\n	gl_FragColor.a = foamc.r;\n#endif\n	//if(mod(vUv.x*100.,1.0)<0.02 || mod(vUv.y*100.,1.0)<0.02) gl_FragColor.rgb=vec3(0.5,.5,.5);\n	//gl_FragColor.rgb = detailNorm;\n}\n";
		shaderCompile=ShaderCompile3D.add(Water,vs,ps,attributeMap,uniformMap);
		WaterMaterial.SHADERDEFINE_CUBE_ENV=shaderCompile.registerMaterialDefine("CUBE_ENV");
		WaterMaterial.SHADERDEFINE_HDR_ENV=shaderCompile.registerMaterialDefine("HDR_ENV");
		WaterMaterial.SHADERDEFINE_SHOW_NORMAL=shaderCompile.registerMaterialDefine("SHOW_NORMAL");
		WaterMaterial.SHADERDEFINE_USEVERTEXHEIGHT=shaderCompile.registerMaterialDefine("USE_VERTEX_DEEPINFO");
		WaterMaterial.SHADERDEFINE_USE_FOAM=shaderCompile.registerMaterialDefine("USE_FOAM");
		WaterMaterial.SHADERDEFINE_USE_REFRACT_TEX=shaderCompile.registerMaterialDefine("USE_REFR_TEX");
		attributeMap={
			'a_CornerTextureCoordinate':17,
			'a_MeshPosition':0,
			'a_MeshColor':1,
			'a_MeshTextureCoordinate':2,
			'a_ShapePositionStartLifeTime':30,
			'a_DirectionTime':32,
			'a_StartColor':19,
			'a_EndColor':23,
			'a_StartSize':20,
			'a_StartRotation0':22,
			'a_StartSpeed':31,
			'a_Random0':34,
			'a_Random1':35,
			'a_SimulationWorldPostion':36,
			'a_SimulationWorldRotation':37};
		uniformMap={
			'u_Tintcolor':[2,1],
			'u_TilingOffset':[3,1],
			'u_texture':[1,1],
			'u_WorldPosition':[0,2],
			'u_WorldRotation':[1,2],
			'u_PositionScale':[4,2],
			'u_SizeScale':[5,2],
			'u_ScalingMode':[6,2],
			'u_Gravity':[7,2],
			'u_ThreeDStartRotation':[8,2],
			'u_StretchedBillboardLengthScale':[9,2],
			'u_StretchedBillboardSpeedScale':[10,2],
			'u_SimulationSpace':[11,2],
			'u_CurrentTime':[12,2],
			'u_ColorOverLifeGradientAlphas':[22,2],
			'u_ColorOverLifeGradientColors':[23,2],
			'u_MaxColorOverLifeGradientAlphas':[24,2],
			'u_MaxColorOverLifeGradientColors':[25,2],
			'u_VOLVelocityConst':[13,2],
			'u_VOLVelocityGradientX':[14,2],
			'u_VOLVelocityGradientY':[15,2],
			'u_VOLVelocityGradientZ':[16,2],
			'u_VOLVelocityConstMax':[17,2],
			'u_VOLVelocityGradientMaxX':[18,2],
			'u_VOLVelocityGradientMaxY':[19,2],
			'u_VOLVelocityGradientMaxZ':[20,2],
			'u_VOLSpaceType':[21,2],
			'u_SOLSizeGradient':[26,2],
			'u_SOLSizeGradientX':[27,2],
			'u_SOLSizeGradientY':[28,2],
			'u_SOLSizeGradientZ':[29,2],
			'u_SOLSizeGradientMax':[30,2],
			'u_SOLSizeGradientMaxX':[31,2],
			'u_SOLSizeGradientMaxY':[32,2],
			'u_SOLSizeGradientMaxZ':[33,2],
			'u_ROLAngularVelocityConst':[34,2],
			'u_ROLAngularVelocityConstSeprarate':[35,2],
			'u_ROLAngularVelocityGradient':[36,2],
			'u_ROLAngularVelocityGradientX':[37,2],
			'u_ROLAngularVelocityGradientY':[38,2],
			'u_ROLAngularVelocityGradientZ':[39,2],
			'u_ROLAngularVelocityGradientW':[40,2],
			'u_ROLAngularVelocityConstMax':[41,2],
			'u_ROLAngularVelocityConstMaxSeprarate':[42,2],
			'u_ROLAngularVelocityGradientMax':[43,2],
			'u_ROLAngularVelocityGradientMaxX':[44,2],
			'u_ROLAngularVelocityGradientMaxY':[45,2],
			'u_ROLAngularVelocityGradientMaxZ':[46,2],
			'u_ROLAngularVelocityGradientMaxW':[47,2],
			'u_TSACycles':[48,2],
			'u_TSASubUVLength':[49,2],
			'u_TSAGradientUVs':[50,2],
			'u_TSAMaxGradientUVs':[51,2],
			'u_CameraPosition':[0,3],
			'u_CameraDirection':[5,3],
			'u_CameraUp':[6,3],
			'u_View':[1,3],
			'u_Projection':[2,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4]};
		var PARTICLESHURIKEN=Shader3D.nameKey.add("PARTICLESHURIKEN");
		vs="#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\n#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n	attribute vec4 a_CornerTextureCoordinate;\n#endif\n#ifdef RENDERMODE_MESH\n	attribute vec3 a_MeshPosition;\n	attribute vec4 a_MeshColor;\n	attribute vec2 a_MeshTextureCoordinate;\n	varying vec4 v_MeshColor;\n#endif\n\nattribute vec4 a_ShapePositionStartLifeTime;\nattribute vec4 a_DirectionTime;\nattribute vec4 a_StartColor;\nattribute vec3 a_StartSize;\nattribute vec3 a_StartRotation0;\nattribute float a_StartSpeed;\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n  attribute vec4 a_Random0;\n#endif\n#if defined(TEXTURESHEETANIMATIONRANDOMCURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  attribute vec4 a_Random1;\n#endif\nattribute vec3 a_SimulationWorldPostion;\nattribute vec4 a_SimulationWorldRotation;\n\nvarying float v_Discard;\nvarying vec4 v_Color;\n#ifdef DIFFUSEMAP\n	varying vec2 v_TextureCoordinate;\n#endif\n\nuniform float u_CurrentTime;\nuniform vec3 u_Gravity;\n\nuniform vec3 u_WorldPosition;\nuniform vec4 u_WorldRotation;\nuniform bool u_ThreeDStartRotation;\nuniform int u_ScalingMode;\nuniform vec3 u_PositionScale;\nuniform vec3 u_SizeScale;\nuniform mat4 u_View;\nuniform mat4 u_Projection;\n\n#ifdef STRETCHEDBILLBOARD\n	uniform vec3 u_CameraPosition;\n#endif\nuniform vec3 u_CameraDirection;//TODO:只有几种广告牌模式需要用\nuniform vec3 u_CameraUp;\n\nuniform  float u_StretchedBillboardLengthScale;\nuniform  float u_StretchedBillboardSpeedScale;\nuniform int u_SimulationSpace;\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  int  u_VOLSpaceType;\n#endif\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)\n  uniform  vec3 u_VOLVelocityConst;\n#endif\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  vec2 u_VOLVelocityGradientX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientZ[4];//x为key,y为速度\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n  uniform  vec3 u_VOLVelocityConstMax;\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n  uniform  vec2 u_VOLVelocityGradientMaxX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxZ[4];//x为key,y为速度\n#endif\n\n#ifdef COLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n#ifdef RANDOMCOLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n  uniform  vec4 u_MaxColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_MaxColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n\n\n#if defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMERANDOMCURVES)\n  uniform  vec2 u_SOLSizeGradient[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVES\n  uniform  vec2 u_SOLSizeGradientMax[4];//x为key,y为尺寸\n#endif\n#if defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\n  uniform  vec2 u_SOLSizeGradientX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientZ[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n  uniform  vec2 u_SOLSizeGradientMaxX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxZ[4];//x为key,y为尺寸\n#endif\n\n\n#ifdef ROTATIONOVERLIFETIME\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  float u_ROLAngularVelocityConst;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  float u_ROLAngularVelocityConstMax;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradient[4];//x为key,y为旋转\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMax[4];//x为key,y为旋转\n  #endif\n#endif\n#ifdef ROTATIONOVERLIFETIMESEPERATE\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  vec4 u_ROLAngularVelocityConstSeprarate;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  vec4 u_ROLAngularVelocityConstMaxSeprarate;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradientX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientZ[4];\n	uniform  vec2 u_ROLAngularVelocityGradientW[4];\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMaxX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxZ[4];\n	uniform  vec2 u_ROLAngularVelocityGradientMaxW[4];\n  #endif\n#endif\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\n  uniform  float u_TSACycles;\n  uniform  vec2 u_TSASubUVLength;\n  uniform  vec2 u_TSAGradientUVs[4];//x为key,y为frame\n#endif\n#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n  uniform  vec2 u_TSAMaxGradientUVs[4];//x为key,y为frame\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvec3 rotationByEuler(in vec3 vector,in vec3 rot)\n{\n	float halfRoll = rot.z * 0.5;\n    float halfPitch = rot.x * 0.5;\n	float halfYaw = rot.y * 0.5;\n\n	float sinRoll = sin(halfRoll);\n	float cosRoll = cos(halfRoll);\n	float sinPitch = sin(halfPitch);\n	float cosPitch = cos(halfPitch);\n	float sinYaw = sin(halfYaw);\n	float cosYaw = cos(halfYaw);\n\n	float quaX = (cosYaw * sinPitch * cosRoll) + (sinYaw * cosPitch * sinRoll);\n	float quaY = (sinYaw * cosPitch * cosRoll) - (cosYaw * sinPitch * sinRoll);\n	float quaZ = (cosYaw * cosPitch * sinRoll) - (sinYaw * sinPitch * cosRoll);\n	float quaW = (cosYaw * cosPitch * cosRoll) + (sinYaw * sinPitch * sinRoll);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\n//假定axis已经归一化\nvec3 rotationByAxis(in vec3 vector,in vec3 axis, in float angle)\n{\n	float halfAngle = angle * 0.5;\n	float sin = sin(halfAngle);\n	\n	float quaX = axis.x * sin;\n	float quaY = axis.y * sin;\n	float quaZ = axis.z * sin;\n	float quaW = cos(halfAngle);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\nvec3 rotationByQuaternions(in vec3 v,in vec4 q) \n{\n	return v + 2.0 * cross(q.xyz, cross(q.xyz, v) + q.w * v);\n}\n\n \n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\nfloat getCurValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float curValue;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientNumber=gradientNumbers[i-1];\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			curValue=mix(lastGradientNumber.y,gradientNumber.y,age);\n			break;\n		}\n	}\n	return curValue;\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\nfloat getTotalValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float totalValue=0.0;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		vec2 lastGradientNumber=gradientNumbers[i-1];\n		float lastValue=lastGradientNumber.y;\n		\n		if(key>=normalizedAge){\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			totalValue+=(lastValue+mix(lastValue,gradientNumber.y,age))/2.0*a_ShapePositionStartLifeTime.w*(normalizedAge-lastKey);\n			break;\n		}\n		else{\n			totalValue+=(lastValue+gradientNumber.y)/2.0*a_ShapePositionStartLifeTime.w*(key-lastGradientNumber.x);\n		}\n	}\n	return totalValue;\n}\n#endif\n\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)\nvec4 getColorFromGradient(in vec2 gradientAlphas[4],in vec4 gradientColors[4],in float normalizedAge)\n{\n	vec4 overTimeColor;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientAlpha=gradientAlphas[i];\n		float alphaKey=gradientAlpha.x;\n		if(alphaKey>=normalizedAge)\n		{\n			vec2 lastGradientAlpha=gradientAlphas[i-1];\n			float lastAlphaKey=lastGradientAlpha.x;\n			float age=(normalizedAge-lastAlphaKey)/(alphaKey-lastAlphaKey);\n			overTimeColor.a=mix(lastGradientAlpha.y,gradientAlpha.y,age);\n			break;\n		}\n	}\n	\n	for(int i=1;i<4;i++)\n	{\n		vec4 gradientColor=gradientColors[i];\n		float colorKey=gradientColor.x;\n		if(colorKey>=normalizedAge)\n		{\n			vec4 lastGradientColor=gradientColors[i-1];\n			float lastColorKey=lastGradientColor.x;\n			float age=(normalizedAge-lastColorKey)/(colorKey-lastColorKey);\n			overTimeColor.rgb=mix(gradientColors[i-1].yzw,gradientColor.yzw,age);\n			break;\n		}\n	}\n	return overTimeColor;\n}\n#endif\n\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\nfloat getFrameFromGradient(in vec2 gradientFrames[4],in float normalizedAge)\n{\n	float overTimeFrame;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientFrame=gradientFrames[i];\n		float key=gradientFrame.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientFrame=gradientFrames[i-1];\n			float lastKey=lastGradientFrame.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			overTimeFrame=mix(lastGradientFrame.y,gradientFrame.y,age);\n			break;\n		}\n	}\n	return floor(overTimeFrame);\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\nvec3 computeParticleLifeVelocity(in float normalizedAge)\n{\n  vec3 outLifeVelocity;\n  #ifdef VELOCITYOVERLIFETIMECONSTANT\n	 outLifeVelocity=u_VOLVelocityConst; \n  #endif\n  #ifdef VELOCITYOVERLIFETIMECURVE\n     outLifeVelocity= vec3(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n	 outLifeVelocity=mix(u_VOLVelocityConst,u_VOLVelocityConstMax,vec3(a_Random1.y,a_Random1.z,a_Random1.w)); \n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n     outLifeVelocity=vec3(mix(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y),\n	                 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z),\n					 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n  #endif\n					\n  return outLifeVelocity;\n} \n#endif\n\nvec3 computeParticlePosition(in vec3 startVelocity, in vec3 lifeVelocity,in float age,in float normalizedAge,vec3 gravityVelocity,vec4 worldRotation)\n{\n   vec3 startPosition;\n   vec3 lifePosition;\n   #if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	#ifdef VELOCITYOVERLIFETIMECONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMECURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n	#endif\n	\n	vec3 finalPosition;\n	if(u_VOLSpaceType==0){\n	  if(u_ScalingMode!=2)\n	   finalPosition =rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition),worldRotation);\n	  else\n	   finalPosition =rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition,worldRotation);\n	}\n	else{\n	  if(u_ScalingMode!=2)\n	    finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation)+lifePosition;\n	  else\n	    finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation)+lifePosition;\n	}\n  #else\n	 startPosition=startVelocity*age;\n	 vec3 finalPosition;\n	 if(u_ScalingMode!=2)\n	   finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation);\n	 else\n	   finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation);\n  #endif\n  \n  if(u_SimulationSpace==0)\n    finalPosition=finalPosition+a_SimulationWorldPostion;\n  else if(u_SimulationSpace==1) \n    finalPosition=finalPosition+u_WorldPosition;\n  \n  finalPosition+=0.5*gravityVelocity*age;\n \n  return  finalPosition;\n}\n\n\nvec4 computeParticleColor(in vec4 color,in float normalizedAge)\n{\n	#ifdef COLOROVERLIFETIME\n	  color*=getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge);\n	#endif\n	\n	#ifdef RANDOMCOLOROVERLIFETIME\n	  color*=mix(getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge),getColorFromGradient(u_MaxColorOverLifeGradientAlphas,u_MaxColorOverLifeGradientColors,normalizedAge),a_Random0.y);\n	#endif\n\n    return color;\n}\n\nvec2 computeParticleSizeBillbard(in vec2 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec2(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec2(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n\n#ifdef RENDERMODE_MESH\nvec3 computeParticleSizeMesh(in vec3 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec3(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec3(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z)\n		,mix(getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxZ,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n#endif\n\nfloat computeParticleRotationFloat(in float rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConstSeprarate.z*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConstSeprarate.z,u_ROLAngularVelocityConstMaxSeprarate.z,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n\n#if defined(RENDERMODE_MESH)&&(defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE))\nvec3 computeParticleRotationMesh(in vec3 rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			vec3 ageRot=u_ROLAngularVelocityConstSeprarate*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=vec3(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge));\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			vec3 ageRot=mix(u_ROLAngularVelocityConstSeprarate,u_ROLAngularVelocityConstMaxSeprarate,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=vec3(mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxX,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxY,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n#endif\n\nvec2 computeParticleUV(in vec2 uv,in float normalizedAge)\n{ \n	#ifdef TEXTURESHEETANIMATIONCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float frame=getFrameFromGradient(u_TSAGradientUVs,cycleNormalizedAge-floor(cycleNormalizedAge));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float uvNormalizedAge=cycleNormalizedAge-floor(cycleNormalizedAge);\n	    float frame=floor(mix(getFrameFromGradient(u_TSAGradientUVs,uvNormalizedAge),getFrameFromGradient(u_TSAMaxGradientUVs,uvNormalizedAge),a_Random1.x));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	return uv;\n}\n\nvoid main()\n{\n	float age = u_CurrentTime - a_DirectionTime.w;\n	float normalizedAge = age/a_ShapePositionStartLifeTime.w;\n	vec3 lifeVelocity;\n	if(normalizedAge<1.0){ \n	vec3 startVelocity=a_DirectionTime.xyz*a_StartSpeed;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n		lifeVelocity= computeParticleLifeVelocity(normalizedAge);//计算粒子生命周期速度\n	#endif \n	vec3 gravityVelocity=u_Gravity*age;\n	\n	vec4 worldRotation;\n	if(u_SimulationSpace==0)\n		worldRotation=a_SimulationWorldRotation;\n	else\n		worldRotation=u_WorldRotation;\n	\n	vec3 center=computeParticlePosition(startVelocity, lifeVelocity, age, normalizedAge,gravityVelocity,worldRotation);//计算粒子位置\n   \n   \n   #ifdef SPHERHBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        vec3 cameraUpVector =normalize(u_CameraUp);//TODO:是否外面归一化\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n        vec3 upVector = normalize(cross(sideVector,u_CameraDirection));\n	    corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,computeParticleRotationFloat(a_StartRotation0.z,age,normalizedAge));\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,rotation);\n			}\n			else{\n				float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n				float c = cos(rot);\n				float s = sin(rot);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,a_StartRotation0);\n			}\n			else{\n				float c = cos(a_StartRotation0.x);\n				float s = sin(a_StartRotation0.x);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#endif\n   #endif\n   \n   #ifdef STRETCHEDBILLBOARD\n	vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n	vec3 velocity;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	    if(u_VOLSpaceType==0)\n		  velocity=rotationByQuaternions(u_SizeScale*(startVelocity+lifeVelocity),worldRotation)+gravityVelocity;\n	    else\n		  velocity=rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+lifeVelocity+gravityVelocity;\n    #else\n	    velocity= rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+gravityVelocity;\n    #endif	\n		vec3 cameraUpVector = normalize(velocity);\n		vec3 direction = normalize(center-u_CameraPosition);\n        vec3 sideVector = normalize(cross(direction,normalize(velocity)));\n		\n		sideVector=u_SizeScale.xzy*sideVector;\n		cameraUpVector=length(vec3(u_SizeScale.x,0.0,0.0))*cameraUpVector;\n		\n	    vec2 size=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		\n	    const mat2 rotaionZHalfPI=mat2(0.0, -1.0, 1.0, 0.0);\n	    corner=rotaionZHalfPI*corner;\n	    corner.y=corner.y-abs(corner.y);\n		\n	    float speed=length(velocity);//TODO:\n	    center +=sign(u_SizeScale.x)*(sign(u_StretchedBillboardLengthScale)*size.x*corner.x*sideVector+(speed*u_StretchedBillboardSpeedScale+size.y*u_StretchedBillboardLengthScale)*corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef HORIZONTALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector=vec3(0.0,0.0,1.0);\n	    const vec3 sideVector = vec3(-1.0,0.0,0.0);\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef VERTICALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector =vec3(0.0,1.0,0.0);\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef RENDERMODE_MESH\n	    vec3 size=computeParticleSizeMesh(a_StartSize,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,-computeParticleRotationFloat(a_StartRotation0.z, age,normalizedAge));\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,rotation),worldRotation);\n			}\n			else{\n				float angle=computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n				if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0)\n				{\n					center+= (rotationByQuaternions(rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),angle),worldRotation));//已验证\n				}\n				else\n				{\n					#ifdef SHAPE\n						center+= u_SizeScale.xzy*(rotationByQuaternions(rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),angle),worldRotation));\n					#else\n						if(u_SimulationSpace==0)\n							center+=rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle);//已验证\n						else if(u_SimulationSpace==1)\n							center+=rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle),worldRotation);//已验证\n					#endif\n				}\n					\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,a_StartRotation0),worldRotation);//已验证\n			}\n			else{\n				if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0){\n					if(u_SimulationSpace==0)\n						center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x);\n					else if(u_SimulationSpace==1)\n						center+= (rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x),worldRotation));//已验证\n				}\n				else{\n					#ifdef SHAPE\n						if(u_SimulationSpace==0)\n							center+= u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x),worldRotation);	\n					#else\n						if(u_SimulationSpace==0)\n							center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x),worldRotation);//已验证\n					#endif\n				}\n			}\n		#endif\n		v_MeshColor=a_MeshColor;\n   #endif\n   \n    gl_Position=u_Projection*u_View*vec4(center,1.0);\n    v_Color = computeParticleColor(a_StartColor, normalizedAge);\n	#ifdef DIFFUSEMAP\n		#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n			v_TextureCoordinate =computeParticleUV(a_CornerTextureCoordinate.zw, normalizedAge);\n		#endif\n		#ifdef RENDERMODE_MESH\n			v_TextureCoordinate =computeParticleUV(a_MeshTextureCoordinate, normalizedAge);\n		#endif\n		\n		#ifdef TILINGOFFSET\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y)*u_TilingOffset.xy+vec2(u_TilingOffset.z,-u_TilingOffset.w);//需要特殊处理\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y);//需要特殊处理\n		#endif\n	#endif\n    v_Discard=0.0;\n	  \n	#ifdef FOG\n		v_PositionWorld=center;\n	#endif\n   }\n   else\n	{\n		v_Discard=1.0;\n	}\n}\n\n";
		ps="#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\nvarying float v_Discard;\nvarying vec4 v_Color;\nvarying vec2 v_TextureCoordinate;\nuniform sampler2D u_texture;\nuniform vec4 u_Tintcolor;\n\n#ifdef RENDERMODE_MESH\n	varying vec4 v_MeshColor;\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n	uniform vec3 u_CameraPosition;\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\nvoid main()\n{	\n	#ifdef RENDERMODE_MESH\n		gl_FragColor=v_MeshColor;\n	#else\n		gl_FragColor=vec4(1.0);	\n	#endif\n		\n	#ifdef DIFFUSEMAP\n		if(v_Discard!=0.0)\n			discard;\n		#ifdef TINTCOLOR\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*v_Color;\n		#endif\n	#else\n		#ifdef TINTCOLOR\n			gl_FragColor*=u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=v_Color;\n		#endif\n	#endif\n	\n	#ifdef FOG\n		vec3 toEye=u_CameraPosition-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n		\n		float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n		#else\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n		#endif\n	#endif\n}";
		shaderCompile=ShaderCompile3D.add(PARTICLESHURIKEN,vs,ps,attributeMap,uniformMap);
		ShurikenParticleMaterial.SHADERDEFINE_DIFFUSEMAP=shaderCompile.registerMaterialDefine("DIFFUSEMAP");
		ShurikenParticleMaterial.SHADERDEFINE_TINTCOLOR=shaderCompile.registerMaterialDefine("TINTCOLOR");
		ShurikenParticleMaterial.SHADERDEFINE_ADDTIVEFOG=shaderCompile.registerMaterialDefine("ADDTIVEFOG");
		ShurikenParticleMaterial.SHADERDEFINE_TILINGOFFSET=shaderCompile.registerMaterialDefine("TILINGOFFSET");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_BILLBOARD=shaderCompile.registerSpriteDefine("SPHERHBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_STRETCHEDBILLBOARD=shaderCompile.registerSpriteDefine("STRETCHEDBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_HORIZONTALBILLBOARD=shaderCompile.registerSpriteDefine("HORIZONTALBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_VERTICALBILLBOARD=shaderCompile.registerSpriteDefine("VERTICALBILLBOARD");
		ShuriKenParticle3D.SHADERDEFINE_COLOROVERLIFETIME=shaderCompile.registerSpriteDefine("COLOROVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_RANDOMCOLOROVERLIFETIME=shaderCompile.registerSpriteDefine("RANDOMCOLOROVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECONSTANT=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMECONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCONSTANT=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMERANDOMCONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCURVE=shaderCompile.registerSpriteDefine("VELOCITYOVERLIFETIMERANDOMCURVE");
		ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONCURVE=shaderCompile.registerSpriteDefine("TEXTURESHEETANIMATIONCURVE");
		ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONRANDOMCURVE=shaderCompile.registerSpriteDefine("TEXTURESHEETANIMATIONRANDOMCURVE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIME=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIME");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMESEPERATE=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMESEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECONSTANT=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMECONSTANT");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCONSTANTS=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMERANDOMCONSTANTS");
		ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCURVES=shaderCompile.registerSpriteDefine("ROTATIONOVERLIFETIMERANDOMCURVES");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMECURVE");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVESEPERATE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMECURVESEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVES=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMERANDOMCURVES");
		ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVESSEPERATE=shaderCompile.registerSpriteDefine("SIZEOVERLIFETIMERANDOMCURVESSEPERATE");
		ShuriKenParticle3D.SHADERDEFINE_RENDERMODE_MESH=shaderCompile.registerSpriteDefine("RENDERMODE_MESH");
		ShuriKenParticle3D.SHADERDEFINE_SHAPE=shaderCompile.registerSpriteDefine("SHAPE");
		attributeMap={
			'a_Position':0,
			'a_Texcoord0':2,
			'a_Time':33};
		uniformMap={
			'u_Texture':[1,1],
			'u_Albedo':[2,1],
			'u_Color':[3,1],
			'u_CurrentTime':[2,2],
			'u_Duration':[3,2],
			'u_MvpMatrix':[1,2]};
		var GLITTER=Shader3D.nameKey.add("GLITTER");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\nattribute float a_Time;\n\nuniform mat4 u_MvpMatrix;\nuniform  float u_CurrentTime;\nuniform  vec4 u_Color;\nuniform float u_Duration;\n\nvarying vec2 v_Texcoord;\nvarying vec4 v_Color;\n\n\nvoid main()\n{\n  gl_Position = u_MvpMatrix * a_Position;\n  \n  float age = u_CurrentTime-a_Time;\n  float normalizedAge = clamp(age / u_Duration,0.0,1.0);\n   \n  v_Texcoord=a_Texcoord0;\n  \n  v_Color=u_Color;\n  v_Color.a*=1.0-normalizedAge;\n}\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform vec4 u_Albedo;\nuniform sampler2D u_Texture;\n\nvarying vec2 v_Texcoord;\nvarying vec4 v_Color;\n\n\nvoid main()\n{	\n  gl_FragColor=texture2D(u_Texture, v_Texcoord)*v_Color;\n  gl_FragColor=gl_FragColor*u_Albedo;\n}\n\n";
		shaderCompile=ShaderCompile3D.add(GLITTER,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':0};
		uniformMap={
			'u_Intensity':[1,1],
			'u_AlphaBlending':[2,1],
			'u_CubeTexture':[3,1],
			'u_MvpMatrix':[4,3]};
		var skyBox=Shader3D.nameKey.add("SkyBox");
		vs="attribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nvarying vec3 v_Texcoord;\n\n\nvoid main()\n{\n  gl_Position = (u_MvpMatrix*a_Position).xyww;\n  v_Texcoord=a_Position.xyz;\n}\n";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nuniform float u_Intensity;\nuniform float u_AlphaBlending;\nuniform samplerCube u_CubeTexture;\n\nvarying vec3 v_Texcoord;\n\n\nvoid main()\n{	\n  gl_FragColor=vec4(textureCube(u_CubeTexture, v_Texcoord).rgb*u_Intensity,u_AlphaBlending);\n}\n\n";
		ShaderCompile3D.add(skyBox,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':0,
			'a_Texcoord0':2};
		uniformMap={
			'u_Intensity':[1,1],
			'u_AlphaBlending':[2,1],
			'u_texture':[3,1],
			'u_MvpMatrix':[4,3]};
		var skyDome=Shader3D.nameKey.add("SkyDome");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\nuniform mat4 u_MvpMatrix;\nvarying vec2 v_Texcoord;\n\n\nvoid main()\n{\n  gl_Position = (u_MvpMatrix*a_Position).xyww;\n  v_Texcoord = a_Texcoord0;\n}\n";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nuniform float u_Intensity;\nuniform float u_AlphaBlending;\nuniform sampler2D u_texture;\n\nvarying vec2 v_Texcoord;\n\n\nvoid main()\n{	\n  gl_FragColor=vec4(texture2D(u_texture, v_Texcoord).rgb*u_Intensity,u_AlphaBlending);\n}\n\n";
		ShaderCompile3D.add(skyDome,vs,ps,attributeMap,uniformMap);
		attributeMap={
			'a_Position':0,
			'a_Normal':3,
			'a_Texcoord0':2,
			'a_Texcoord1':15};
		uniformMap={
			'u_MvpMatrix':[1,2],
			'u_WorldMat':[0,2],
			'u_LightmapScaleOffset':[2,2],
			'u_LightMap':[3,2],
			'u_SplatAlphaTexture':[0,1],
			'u_NormalTexture':[1,1],
			'u_DiffuseTexture1':[2,1],
			'u_DiffuseTexture2':[3,1],
			'u_DiffuseTexture3':[4,1],
			'u_DiffuseTexture4':[5,1],
			'u_DiffuseScale1':[6,1],
			'u_DiffuseScale2':[7,1],
			'u_DiffuseScale3':[8,1],
			'u_DiffuseScale4':[9,1],
			'u_MaterialDiffuse':[11,1],
			'u_MaterialAmbient':[10,1],
			'u_MaterialSpecular':[12,1],
			'u_CameraPos':[0,3],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Diffuse':[4,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Attenuation':[7,4],
			'u_PointLight.Diffuse':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Attenuation':[13,4],
			'u_SpotLight.Diffuse':[14,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]};
		var terrain=Shader3D.nameKey.add("Terrain");
		vs="attribute vec4 a_Position;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef LIGHTMAP\n	uniform vec4 u_LightmapScaleOffset;\n	varying vec2 v_LightMapUV;\n#endif\n\nattribute vec2 a_Texcoord0;\nattribute vec2 a_Texcoord1;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\nuniform mat4 u_MvpMatrix;\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n	v_Texcoord0=a_Texcoord0;\n	v_Texcoord1=a_Texcoord1;\n	\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	v_Normal=a_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	v_PositionWorld=(u_WorldMat*a_Position).xyz;\n#endif\n\n#ifdef LIGHTMAP\n	//这个地方使用a_Normal 并不是真的代表normal，其实凑巧法线图的uv正好是符合 light_Map的UV\n	v_LightMapUV=vec2(a_Normal.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,(a_Normal.y-1.0)*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n#endif\n\n#ifdef RECEIVESHADOW\n	v_posViewZ = gl_Position.w;\n	#ifdef SHADOWMAP_PSSM1\n		v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n	#endif\n#endif\n\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	uniform vec3 u_MaterialDiffuse;\n	uniform vec4 u_MaterialSpecular;\n	uniform vec3 u_CameraPos;\n	varying vec3 v_Normal;\n	varying vec3 v_PositionWorld;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	uniform vec3 u_MaterialAmbient;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\nuniform sampler2D u_SplatAlphaTexture;\nuniform sampler2D u_NormalTexture;\nuniform sampler2D u_DiffuseTexture1;\nuniform sampler2D u_DiffuseTexture2;\nuniform sampler2D u_DiffuseTexture3;\nuniform sampler2D u_DiffuseTexture4;\nuniform vec2 u_DiffuseScale1;\nuniform vec2 u_DiffuseScale2;\nuniform vec2 u_DiffuseScale3;\nuniform vec2 u_DiffuseScale4;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\n\n#ifdef LIGHTMAP\n	uniform sampler2D u_LightMap;\n	varying vec2 v_LightMapUV;\n#endif\n\nvoid main()\n{\n#ifdef DETAIL_NUM1\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz;\n#endif\n#ifdef DETAIL_NUM2\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-splatAlpha.r) + color2.xyz * splatAlpha.r;\n#endif\n#ifdef DETAIL_NUM3\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord1/u_DiffuseScale3);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-(splatAlpha.r+splatAlpha.g)) + color2.xyz * splatAlpha.r + color3.xyz * splatAlpha.g;\n#endif\n#ifdef DETAIL_NUM4\n	vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord1/u_DiffuseScale1);\n	vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord1/u_DiffuseScale2);\n	vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord1/u_DiffuseScale3);\n	vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord1/u_DiffuseScale4);\n	vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n	gl_FragColor.xyz = color1.xyz * (1.0-(splatAlpha.r+splatAlpha.g+splatAlpha.b))+ color2.xyz * splatAlpha.r + color3.xyz * splatAlpha.g + color4.xyz * splatAlpha.b;\n#endif\n	gl_FragColor.w = splatAlpha.a;\n		\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n    vec3 normal = texture2D(u_NormalTexture,v_Normal.xy).xyz;\n	normal = normal*2.0 - vec3(1.0);\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n	#else\n		#if defined(RECEIVESHADOW)\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n		#endif\n	#endif\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#ifdef RECEIVESHADOW\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular * shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular, gl_FragColor.a);\n	#endif\n#endif\n\n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\n";
		var terrainCompile3D=ShaderCompile3D.add(terrain,vs,ps,attributeMap,uniformMap);
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM1=terrainCompile3D.registerMaterialDefine("DETAIL_NUM1");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM2=terrainCompile3D.registerMaterialDefine("DETAIL_NUM2");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM4=terrainCompile3D.registerMaterialDefine("DETAIL_NUM4");
		TerrainMaterial.SHADERDEFINE_DETAIL_NUM3=terrainCompile3D.registerMaterialDefine("DETAIL_NUM3");
		attributeMap={
			'a_Position':0,
			'a_Normal':3,
			'a_Texcoord0':2
		};
		uniformMap={
			'u_MvpMatrix':[1,2],
			'u_WorldMat':[0,2],
			'u_CameraPos':[0,3],
			'u_LightmapScaleOffset':[2,2],
			'u_LightMap':[3,2],
			'u_SplatAlphaTexture':[0,1],
			'u_DiffuseTexture1':[1,1],
			'u_DiffuseTexture2':[2,1],
			'u_DiffuseTexture3':[3,1],
			'u_DiffuseTexture4':[4,1],
			'u_DiffuseTexture5':[5,1],
			'u_DiffuseScaleOffset1':[6,1],
			'u_DiffuseScaleOffset2':[7,1],
			'u_DiffuseScaleOffset3':[8,1],
			'u_DiffuseScaleOffset4':[9,1],
			'u_DiffuseScaleOffset5':[10,1],
			'u_MaterialAlbedo':[14,1],
			'u_MaterialDiffuse':[12,1],
			'u_MaterialAmbient':[11,1],
			'u_MaterialSpecular':[13,1],
			'u_FogStart':[1,4],
			'u_FogRange':[2,4],
			'u_FogColor':[0,4],
			'u_DirectionLight.Direction':[3,4],
			'u_DirectionLight.Diffuse':[4,4],
			'u_PointLight.Position':[5,4],
			'u_PointLight.Range':[6,4],
			'u_PointLight.Attenuation':[7,4],
			'u_PointLight.Diffuse':[8,4],
			'u_SpotLight.Position':[9,4],
			'u_SpotLight.Direction':[10,4],
			'u_SpotLight.Range':[12,4],
			'u_SpotLight.Spot':[11,4],
			'u_SpotLight.Attenuation':[13,4],
			'u_SpotLight.Diffuse':[14,4],
			'u_AmbientColor':[21,4],
			'u_shadowMap1':[18,4],
			'u_shadowMap2':[19,4],
			'u_shadowMap3':[20,4],
			'u_shadowPSSMDistance':[15,4],
			'u_lightShadowVP':[16,4],
			'u_shadowPCFoffset':[17,4]
		};
		var extendTerrainShader=Shader3D.nameKey.add("ExtendTerrain");
		vs="attribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\n\nvarying vec2 v_Texcoord0;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform vec4 u_LightmapScaleOffset;\n#endif\n\n#ifdef RECEIVESHADOW\n	varying float v_posViewZ;\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n#endif\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n  \n	v_Texcoord0 = a_Texcoord0;\n  \n	#ifdef LIGHTMAP\n		v_LightMapUV = vec2(a_Texcoord0.x*u_LightmapScaleOffset.x+u_LightmapScaleOffset.z,(a_Texcoord0.y-1.0)*u_LightmapScaleOffset.y+u_LightmapScaleOffset.w);\n	#endif\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_Normal = a_Normal;\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n		v_PositionWorld=(u_WorldMat*a_Position).xyz;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1\n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"LightHelper.glsl\";\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	uniform vec3 u_MaterialDiffuse;\n	uniform vec4 u_MaterialSpecular;\n	uniform vec3 u_CameraPos;\n	varying vec3 v_Normal;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\n\nuniform sampler2D u_SplatAlphaTexture;\n\nuniform sampler2D u_DiffuseTexture1;\nuniform sampler2D u_DiffuseTexture2;\nuniform sampler2D u_DiffuseTexture3;\nuniform sampler2D u_DiffuseTexture4;\nuniform sampler2D u_DiffuseTexture5;\n\nuniform vec4 u_DiffuseScaleOffset1;\nuniform vec4 u_DiffuseScaleOffset2;\nuniform vec4 u_DiffuseScaleOffset3;\nuniform vec4 u_DiffuseScaleOffset4;\nuniform vec4 u_DiffuseScaleOffset5;\n\nvarying vec2 v_Texcoord0;\n\nuniform vec3 u_MaterialAmbient;\nuniform vec4 u_MaterialAlbedo;\n\n#ifdef LIGHTMAP\n	uniform sampler2D u_LightMap;\n	varying vec2 v_LightMapUV;\n#endif\n\nvoid main()\n{\n	#ifdef ExtendTerrain_DETAIL_NUM1\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r;\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM2\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r + color2.xyz * (1.0 - splatAlpha.r);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM3\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * (1.0 - splatAlpha.r - splatAlpha.g);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM4\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM5\n		vec4 splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		vec4 color5 = texture2D(u_DiffuseTexture5, v_Texcoord0 * u_DiffuseScaleOffset5.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * splatAlpha.a + color5.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b - splatAlpha.a);\n	#endif\n		gl_FragColor.w = splatAlpha.a;\n		\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n    vec3 normal = v_Normal;\n	vec3 diffuse = vec3(0.0);\n	vec3 ambient = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	vec3 dif, amb, spe;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	computeDirectionLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_DirectionLight,u_AmbientColor,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	computePointLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_PointLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	ComputeSpotLight(u_MaterialDiffuse,u_MaterialAmbient,u_MaterialSpecular,u_SpotLight,u_AmbientColor,v_PositionWorld,normal,toEye, dif, amb, spe);\n	diffuse+=dif;\n	ambient+=amb;\n	specular+=spe;\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n#endif\n\n#ifdef LIGHTMAP\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n	#else\n		#if defined(RECEIVESHADOW)		\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient+texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue);\n			//vec3 tColor= u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb * shadowValue + mix(vec3(0.15,0.15,0.15),vec3(0.0),shadowValue);\n			//gl_FragColor.rgb*=tColor;\n		#else\n			gl_FragColor.rgb=gl_FragColor.rgb*(u_MaterialAmbient + texture2D(u_LightMap, v_LightMapUV).rgb);\n		#endif\n	#endif\n#endif\n\ngl_FragColor=gl_FragColor*u_MaterialAlbedo;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#ifdef RECEIVESHADOW\n		gl_FragColor = vec4( gl_FragColor.rgb*(ambient + diffuse*shadowValue) + specular * shadowValue,gl_FragColor.a);\n	#else\n		gl_FragColor =vec4( gl_FragColor.rgb*(ambient + diffuse) + specular, gl_FragColor.a);\n	#endif\n#endif\n\n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\n\n\n\n\n";
		var extendTerrainCompile3D=ShaderCompile3D.add(extendTerrainShader,vs,ps,attributeMap,uniformMap);
		extendTerrainCompile3D.addSpriteDefines(RenderableSprite3D.shaderDefines);
		extendTerrainCompile3D.addSpriteDefines(ExtendTerrainMaterial.shaderDefines);
		attributeMap={
			'a_Position':0,
			'a_Color' :1,
			'a_Texcoord0X':38,
			'a_Texcoord0Y':39
		};
		uniformMap={
			'u_VMatrix':[1,3],
			'u_PMatrix':[2,3],
			'u_MainTexture':[1,1],
			'u_MainColor':[2,1]
		};
		var trailShader=Shader3D.nameKey.add("Trail");
		vs="attribute vec4 a_Position;\nattribute vec4 a_Color;\nattribute float a_Texcoord0X;\nattribute float a_Texcoord0Y;\n\nuniform mat4 u_VMatrix;\nuniform mat4 u_PMatrix;\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nvoid main()\n{\n	gl_Position = u_PMatrix * u_VMatrix * a_Position;\n	\n	v_Texcoord0 = vec2(a_Texcoord0X, a_Texcoord0Y);\n	\n	v_Color = a_Color;\n}\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform sampler2D u_MainTexture;\nuniform vec4 u_MainColor;\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nvoid main()\n{	\n	vec4 color = u_MainColor * v_Color;\n	//#ifdef MAINTEXTURE\n	//	vec4 mainTextureColor = texture2D(u_MainTexture, v_Texcoord0);\n	//	color *= mainTextureColor;\n	//#endif\n	gl_FragColor = color;\n}\n\n";
		var trailCompile3D=ShaderCompile3D.add(trailShader,vs,ps,attributeMap,uniformMap);
		TrailMaterial.SHADERDEFINE_MAINTEXTURE=trailCompile3D.registerMaterialDefine("MAINTEXTURE");
	}

	return ShaderInit3D;
})()


/**
*@private
*<code>Shader3D</code> 主要用数组的方式保存shader变量定义，后期合并ShaderValue不使用for in，性能较高。
*/
//class laya.d3.shader.ValusArray
var ValusArray=(function(){
	function ValusArray(){
		this._data=null;
		this._data=[];
	}

	__class(ValusArray,'laya.d3.shader.ValusArray');
	var __proto=ValusArray.prototype;
	__proto.setValue=function(name,value){
		this._data[name]=value;
	}

	__getset(0,__proto,'data',function(){
		return this._data;
	});

	return ValusArray;
})()


/**
*...
*@author ...
*/
//class laya.d3.shadowMap.ParallelSplitShadowMap
var ParallelSplitShadowMap=(function(){
	function ParallelSplitShadowMap(){
		/**@private */
		//this.lastNearPlane=NaN;
		/**@private */
		//this.lastFieldOfView=NaN;
		/**@private */
		//this.lastAspectRatio=NaN;
		/**@private */
		this._currentPSSM=-1;
		/**@private */
		this._numberOfPSSM=3;
		/**@private */
		this._maxDistance=200.0;
		/**@private */
		this._ratioOfDistance=1.0 / this._numberOfPSSM;
		/**@private */
		this._statesDirty=true;
		/**@private */
		this._lightCulling=null;
		/**@private */
		this._renderTarget=null;
		/**@private */
		this._lightVPMatrix=null;
		/**@private */
		this._lightCameras=null;
		/**@private */
		this._shadowQuenes=null;
		/**@private */
		this._shadowMapTextureSize=1024;
		/**@private */
		this._scene=null;
		/**@private */
		this._PCFType=0;
		/**@private */
		this._shaderValueLightVP=null;
		/**@private */
		this._shaderValueVPs=null;
		this._spiltDistance=new Array(3+1);
		this._globalParallelLightDir=new Vector3(0,-1,0);
		this._boundingSphere=new Array(3+1);
		this._boundingBox=new Array(3+1);
		this._frustumPos=new Array((3+1)*4);
		this._uniformDistance=new Array(3+1);
		this._logDistance=new Array(3+1);
		this._dimension=new Array(3+1);
		this._tempLookAt3=new Vector3();
		this._tempLookAt4=new Vector4();
		this._tempValue=new Vector4();
		this._tempPos=new Vector3();
		this._tempLightUp=new Vector3();
		this._tempMin=new Vector4();
		this._tempMax=new Vector4();
		this._tempMatrix44=new Matrix4x4;
		this._splitFrustumCulling=new BoundFrustum(Matrix4x4.DEFAULT);
		this._tempScaleMatrix44=new Matrix4x4;
		this._shadowPCFOffset=new Vector2(1.0 / 1024.0,1.0 / 1024.0);
		this._shaderValueDistance=new Vector4();
		var i=0;
		for (i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		for (i=0;i < this._dimension.length;i++){
			this._dimension[i]=new Vector2();
		}
		for (i=0;i < this._frustumPos.length;i++){
			this._frustumPos[i]=new Vector3();
		}
		for (i=0;i < this._boundingBox.length;i++){
			this._boundingBox[i]=new BoundBox(new Vector3(),new Vector3());
		}
		for (i=0;i < this._boundingSphere.length;i++){
			this._boundingSphere[i]=new BoundSphere(new Vector3(),0.0);
		}
		Matrix4x4.createScaling(new Vector3(0.5,0.5,1.0),this._tempScaleMatrix44);
		this._tempScaleMatrix44.elements[12]=0.5;
		this._tempScaleMatrix44.elements[13]=0.5;
	}

	__class(ParallelSplitShadowMap,'laya.d3.shadowMap.ParallelSplitShadowMap');
	var __proto=ParallelSplitShadowMap.prototype;
	__proto.setInfo=function(scene,maxDistance,globalParallelDir,shadowMapTextureSize,numberOfPSSM,PCFType){
		if (numberOfPSSM > 3){
			this._numberOfPSSM=3;
		}
		this._scene=scene;
		this._maxDistance=maxDistance;
		this.PSSMNum=numberOfPSSM;
		this._globalParallelLightDir=globalParallelDir;
		this._ratioOfDistance=1.0 / this._numberOfPSSM;
		for (var i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		this._shadowMapTextureSize=shadowMapTextureSize;
		this._shadowPCFOffset.x=1.0 / this._shadowMapTextureSize;
		this._shadowPCFOffset.y=1.0 / this._shadowMapTextureSize;
		this.setPCFType(PCFType);
		this._statesDirty=true;
	}

	__proto.setPCFType=function(PCFtype){
		this._PCFType=PCFtype;
		switch (this._PCFType){
			case 0:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 1:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 2:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 3:
				this._scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1);
				this._scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2);
				break ;
			}
	}

	__proto.getPCFType=function(){
		return this._PCFType;
	}

	__proto.setFarDistance=function(value){
		if (this._maxDistance !=value){
			this._maxDistance=value;
			this._statesDirty=true;
		}
	}

	__proto.getFarDistance=function(){
		return this._maxDistance;
	}

	__proto._setGlobalParallelLightDir=function(dir){
		this._globalParallelLightDir=dir;
	}

	__proto.getGlobalParallelLightDir=function(){
		return this._globalParallelLightDir;
	}

	__proto.getCurrentPSSM=function(){
		return this._currentPSSM;
	}

	__proto.getLightCamera=function(index){
		return this._lightCameras[index];
	}

	/**
	*@private
	*/
	__proto._beginSampler=function(index,sceneCamera){
		if (index < 0 || index > this._numberOfPSSM)
			throw new Error("ParallelSplitShadowMap: beginSample invalid index");
		this._currentPSSM=index;
		this._update(sceneCamera);
	}

	/**
	*@private
	*/
	__proto.endSampler=function(sceneCamera){
		this._currentPSSM=-1;
	}

	/**
	*@private
	*/
	__proto._calcAllLightCameraInfo=function(sceneCamera){
		if (this._numberOfPSSM===1){
			this._beginSampler(0,sceneCamera);
			this.endSampler(sceneCamera);
			}else {
			for (var i=0,n=this._numberOfPSSM+1;i < n;i++){
				this._beginSampler(i,sceneCamera);
				this.endSampler(sceneCamera);
			}
		}
	}

	/**
	*@private
	*/
	__proto._recalculate=function(nearPlane,fieldOfView,aspectRatio){
		this._calcSplitDistance(nearPlane);
		this._calcBoundingBox(fieldOfView,aspectRatio);
		this._rebuildRenderInfo();
	}

	/**
	*@private
	*/
	__proto._update=function(sceneCamera){
		var nearPlane=sceneCamera.nearPlane;
		var fieldOfView=sceneCamera.fieldOfView;
		var aspectRatio=(sceneCamera).aspectRatio;
		if (this._statesDirty || this.lastNearPlane!==nearPlane || this.lastFieldOfView!==fieldOfView || this.lastAspectRatio!==aspectRatio){
			this._recalculate(nearPlane,fieldOfView,aspectRatio);
			this._uploadShaderValue();
			this._statesDirty=false;
			this.lastNearPlane=nearPlane;
			this.lastFieldOfView=fieldOfView;
			this.lastAspectRatio=aspectRatio;
		}
		this._calcLightViewProject(sceneCamera);
	}

	/**
	*@private
	*/
	__proto._uploadShaderValue=function(){
		var scene=this._scene;
		switch (this._numberOfPSSM){
			case 1:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 2:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 3:
				scene.addShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1);
				scene.removeShaderDefine(laya.d3.shadowMap.ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2);
				break ;
			};
		var sceneSV=scene._shaderValues;
		sceneSV.setValue(15,this._shaderValueDistance.elements);
		sceneSV.setValue(16,this._shaderValueLightVP);
		sceneSV.setValue(17,this._shadowPCFOffset.elements);
		switch (this._numberOfPSSM){
			case 3:
				sceneSV.setValue(18,this.getRenderTarget(1));
				sceneSV.setValue(19,this.getRenderTarget(2));
				sceneSV.setValue(20,this.getRenderTarget(3));
				break ;
			case 2:
				sceneSV.setValue(18,this.getRenderTarget(1));
				sceneSV.setValue(19,this.getRenderTarget(2));
				break ;
			case 1:
				sceneSV.setValue(18,this.getRenderTarget(1));
				break ;
			}
	}

	/**
	*@private
	*/
	__proto._calcSplitDistance=function(nearPlane){
		var far=this._maxDistance;
		var invNumberOfPSSM=1.0 / this._numberOfPSSM;
		var i=0;
		for (i=0;i <=this._numberOfPSSM;i++){
			this._uniformDistance[i]=nearPlane+(far-nearPlane)*i *invNumberOfPSSM;
		};
		var farDivNear=far / nearPlane;
		for (i=0;i <=this._numberOfPSSM;i++){
			var n=Math.pow(farDivNear,i *invNumberOfPSSM);
			this._logDistance[i]=nearPlane *n;
		}
		for (i=0;i <=this._numberOfPSSM;i++){
			this._spiltDistance[i]=this._uniformDistance[i] *this._ratioOfDistance+this._logDistance[i] *(1.0-this._ratioOfDistance);
		}
		this._shaderValueDistance.x=this._spiltDistance[1];
		this._shaderValueDistance.y=this._spiltDistance[2];
		this._shaderValueDistance.z=this._spiltDistance[3];
		this._shaderValueDistance.w=this._spiltDistance[4];
	}

	/**
	*@private
	*/
	__proto._calcBoundingBox=function(fieldOfView,aspectRatio){
		var fov=3.1415926 *fieldOfView / 180.0;
		var halfTanValue=Math.tan(fov / 2.0);
		var height=NaN;
		var width=NaN;
		var distance=NaN;
		var i=0;
		for (i=0;i <=this._numberOfPSSM;i++){
			distance=this._spiltDistance[i];
			height=distance *halfTanValue;
			width=height *aspectRatio;
			var temp=this._frustumPos[i *4+0].elements;
			temp[0]=-width;
			temp[1]=-height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+1].elements;
			temp[0]=width;
			temp[1]=-height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+2].elements;
			temp[0]=-width;
			temp[1]=height;
			temp[2]=-distance;
			temp=this._frustumPos[i *4+3].elements;
			temp[0]=width;
			temp[1]=height;
			temp[2]=-distance;
			temp=this._dimension[i].elements;
			temp[0]=width;
			temp[1]=height;
		};
		var d;
		var min;
		var max;
		var center;
		for (i=1;i <=this._numberOfPSSM;i++){
			d=this._dimension[i].elements;
			min=this._boundingBox[i].min.elements;
			min[0]=-d[0];
			min[1]=-d[1];
			min[2]=-this._spiltDistance[i];
			max=this._boundingBox[i].max.elements;
			max[0]=d[0];
			max[1]=d[1];
			max[2]=-this._spiltDistance[i-1];
			center=this._boundingSphere[i].center.elements;
			center[0]=(min[0]+max[0])*0.5;
			center[1]=(min[1]+max[1])*0.5;
			center[2]=(min[2]+max[2])*0.5;
			this._boundingSphere[i].radius=Math.sqrt(Math.pow(max[0]-min[0],2)+Math.pow(max[1]-min[1],2)+Math.pow(max[2]-min[2],2))*0.5;
		}
		min=this._boundingBox[0].min.elements;
		d=this._dimension[this._numberOfPSSM].elements;
		min[0]=-d[0];
		min[1]=-d[1];
		min[2]=-this._spiltDistance[this._numberOfPSSM];
		max=this._boundingBox[0].max.elements;
		max[0]=d[0];
		max[1]=d[1];
		max[2]=-this._spiltDistance[0];
		center=this._boundingSphere[0].center.elements;
		center[0]=(min[0]+max[0])*0.5;
		center[1]=(min[1]+max[1])*0.5;
		center[2]=(min[2]+max[2])*0.5;
		this._boundingSphere[0].radius=Math.sqrt(Math.pow(max[0]-min[0],2)+Math.pow(max[1]-min[1],2)+Math.pow(max[2]-min[2],2))*0.5;
	}

	__proto.calcSplitFrustum=function(sceneCamera){
		if (this._currentPSSM > 0){
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[this._currentPSSM-1],this._spiltDistance[this._currentPSSM],this._tempMatrix44);
			}else {
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[0],this._spiltDistance[this._numberOfPSSM],this._tempMatrix44);
		}
		Matrix4x4.multiply(this._tempMatrix44,(sceneCamera).viewMatrix,this._tempMatrix44);
		this._splitFrustumCulling.matrix=this._tempMatrix44;
	}

	/**
	*@private
	*/
	__proto._rebuildRenderInfo=function(){
		var nNum=this._numberOfPSSM+1;
		var i=0;
		if (this._renderTarget==null){
			this._renderTarget=__newvec(nNum);
			this._renderTarget[0]=null;
			for (i=1;i < nNum;i++){
				this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,0x1908,0x1401,0x81A5,false,false,0x2600,0x2600);
			}
			}else if (this._renderTarget.length !=nNum){
			this.disposeAllRenderTarget();
			this._renderTarget.length=nNum;
			this._renderTarget[0]=null;
			for (i=1;i < nNum;i++){
				this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,0x1908,0x1401,0x81A5,false,false,0x2600,0x2600);
			}
			}else {
			for (i=1;i < nNum;i++){
				if (this._renderTarget[i]==null || this._renderTarget[i].width !=this._shadowMapTextureSize || this._renderTarget[i].height !=this._shadowMapTextureSize){
					if (this._renderTarget[i] !=null){
						this._renderTarget[i].destroy();
					}
					this._renderTarget[i]=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,0x1908,0x1401,0x81A5,false,false,0x2600,0x2600);
				}
			}
		}
		if (this._lightCulling==null || this._lightCulling.length !=nNum){
			if (this._lightCulling){
				this._lightCulling.length=nNum;
				}else {
				this._lightCulling=__newvec(nNum);
			}
			for (i=0;i < this._lightCulling.length;i++){
				this._lightCulling[i]=new BoundFrustum(Matrix4x4.DEFAULT);
			}
		}
		if (this._lightVPMatrix==null || this._lightVPMatrix.length !=nNum){
			if (this._lightVPMatrix){
				this._lightVPMatrix.length=nNum;
				}else {
				this._lightVPMatrix=__newvec(nNum);
			}
			for (i=0;i < this._lightVPMatrix.length;i++){
				this._lightVPMatrix[i]=new Matrix4x4();
			}
		}
		if (this._lightCameras==null || this._lightCameras.length !=nNum){
			if (this._lightCameras){
				this._lightCameras.length=nNum;
				}else {
				this._lightCameras=__newvec(nNum);
			}
			for (i=0;i < this._lightCameras.length;i++){
				this._lightCameras[i]=new Camera();
				this._lightCameras[i].name="lightCamera"+i;
			}
		}
		if (this._shadowQuenes==null || this._shadowQuenes.length !=this._numberOfPSSM){
			if (this._shadowQuenes){
				this._shadowQuenes.length=this._numberOfPSSM;
				}else {
				this._shadowQuenes=__newvec(this._numberOfPSSM);
			}
			for (i=0;i < this._shadowQuenes.length;i++){
				this._shadowQuenes[i]=new RenderQueue(this._scene);
			}
		}
		if (this._shaderValueVPs==null || this._shaderValueVPs.length !=nNum){
			if (this._shaderValueVPs){
				this._shaderValueVPs.length=nNum;
				}else {
				this._shaderValueVPs=__newvec(nNum);
			}
			this._shaderValueLightVP=new Float32Array(nNum *16);
			for (i=0;i < nNum;i++){
				this._shaderValueVPs[i]=new Float32Array(this._shaderValueLightVP.buffer,i *64);
			}
		}
	}

	/**
	*@private
	*/
	__proto._calcLightViewProject=function(sceneCamera){
		var boundSphere=this._boundingSphere[this._currentPSSM];
		var cameraMatViewInv=sceneCamera.transform.worldMatrix;
		var radius=boundSphere.radius;
		boundSphere.center.cloneTo(this._tempLookAt3);
		Vector3.transformV3ToV4(this._tempLookAt3,cameraMatViewInv,this._tempLookAt4);
		var lookAt3Element=this._tempLookAt3.elements;
		var lookAt4Element=this._tempLookAt4.elements;
		lookAt3Element[0]=lookAt4Element[0];
		lookAt3Element[1]=lookAt4Element[1];
		lookAt3Element[2]=lookAt4Element[2];
		var lightUpElement=this._tempLightUp.elements;
		var sceneCameraDir=sceneCamera.forward.elements;
		lightUpElement[0]=sceneCameraDir[0];
		lightUpElement[1]=1.0;
		lightUpElement[2]=sceneCameraDir[2];
		Vector3.normalize(this._tempLightUp,this._tempLightUp);
		Vector3.scale(this._globalParallelLightDir,boundSphere.radius *4,this._tempPos);
		Vector3.subtract(this._tempLookAt3,this._tempPos,this._tempPos);
		var curLightCamera=this._lightCameras[this._currentPSSM];
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		var tempMaxElements=this._tempMax.elements;
		var tempMinElements=this._tempMin.elements;
		tempMaxElements[0]=tempMaxElements[1]=tempMaxElements[2]=-100000.0;
		tempMaxElements[3]=1.0;
		tempMinElements[0]=tempMinElements[1]=tempMinElements[2]=100000.0;
		tempMinElements[3]=1.0;
		Matrix4x4.multiply(curLightCamera.viewMatrix,cameraMatViewInv,this._tempMatrix44);
		var tempValueElement=this._tempValue.elements;
		var corners=[];
		corners.length=8;
		this._boundingBox[this._currentPSSM].getCorners(corners);
		for (var i=0;i < 8;i++){
			var frustumPosElements=corners[i].elements;
			tempValueElement[0]=frustumPosElements[0];
			tempValueElement[1]=frustumPosElements[1];
			tempValueElement[2]=frustumPosElements[2];
			tempValueElement[3]=1.0;
			Vector4.transformByM4x4(this._tempValue,this._tempMatrix44,this._tempValue);
			tempMinElements[0]=(tempValueElement[0] < tempMinElements[0])? tempValueElement[0] :tempMinElements[0];
			tempMinElements[1]=(tempValueElement[1] < tempMinElements[1])? tempValueElement[1] :tempMinElements[1];
			tempMinElements[2]=(tempValueElement[2] < tempMinElements[2])? tempValueElement[2] :tempMinElements[2];
			tempMaxElements[0]=(tempValueElement[0] > tempMaxElements[0])? tempValueElement[0] :tempMaxElements[0];
			tempMaxElements[1]=(tempValueElement[1] > tempMaxElements[1])? tempValueElement[1] :tempMaxElements[1];
			tempMaxElements[2]=(tempValueElement[2] > tempMaxElements[2])? tempValueElement[2] :tempMaxElements[2];
		}
		Vector4.add(this._tempMax,this._tempMin,this._tempValue);
		tempValueElement[0] *=0.5;
		tempValueElement[1] *=0.5;
		tempValueElement[2] *=0.5;
		tempValueElement[3]=1;
		Vector4.transformByM4x4(this._tempValue,curLightCamera.transform.worldMatrix,this._tempValue);
		var distance=Math.abs(-this._tempMax.z);
		var farPlane=distance > this._maxDistance ? distance :this._maxDistance;
		Vector3.scale(this._globalParallelLightDir,farPlane,this._tempPos);
		var tempPosElement=this._tempPos.elements;
		tempPosElement[0]=tempValueElement[0]-tempPosElement[0];
		tempPosElement[1]=tempValueElement[1]-tempPosElement[1];
		tempPosElement[2]=tempValueElement[2]-tempPosElement[2];
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		Matrix4x4.createOrthoOffCenterRH(tempMinElements[0],tempMaxElements[0],tempMinElements[1],tempMaxElements[1],1.0,farPlane+0.5 *(tempMaxElements[2]-tempMinElements[2]),curLightCamera.projectionMatrix);
		curLightCamera.projectionViewMatrix.cloneTo(this._lightVPMatrix[this._currentPSSM]);
		this._lightCulling[this._currentPSSM].matrix=this._lightVPMatrix[this._currentPSSM];
		ParallelSplitShadowMap.multiplyMatrixOutFloat32Array(this._tempScaleMatrix44,this._lightVPMatrix[this._currentPSSM],this._shaderValueVPs[this._currentPSSM]);
	}

	__proto.getLightFrustumCulling=function(currentPSSM){
		return this._lightCulling[currentPSSM];
	}

	__proto.getSplitFrustumCulling=function(){
		return this._splitFrustumCulling;
	}

	__proto.getSplitDistance=function(index){
		return this._spiltDistance[index];
	}

	__proto.setShadowMapTextureSize=function(size){
		if (size!==this._shadowMapTextureSize){
			this._shadowMapTextureSize=size;
			this._shadowPCFOffset.x=1 / this._shadowMapTextureSize;
			this._shadowPCFOffset.y=1 / this._shadowMapTextureSize;
			this._statesDirty=true;
		}
	}

	__proto.getShadowMapTextureSize=function(){
		return this._shadowMapTextureSize;
	}

	__proto.beginRenderTarget=function(index){
		this._renderTarget[index].start();
	}

	__proto.endRenderTarget=function(index){
		this._renderTarget[index].end();
	}

	__proto.getRenderTarget=function(index){
		return this._renderTarget[index];
	}

	__proto.disposeAllRenderTarget=function(){
		for (var i=0,n=this._numberOfPSSM+1;i < n;i++){
			if (this._renderTarget[i]){
				this._renderTarget[i].destroy();
				this._renderTarget[i]=null;
			}
		}
	}

	__getset(0,__proto,'PSSMNum',function(){
		return this._numberOfPSSM;
		},function(value){
		value=value > 0 ? value :1;
		value=value <=3 ? value :3;
		if (this._numberOfPSSM !=value){
			this._numberOfPSSM=value;
			this._ratioOfDistance=1.0 / this._numberOfPSSM;
			this._statesDirty=true;
		}
	});

	ParallelSplitShadowMap.multiplyMatrixOutFloat32Array=function(left,right,out){
		var i,a,b,ai0,ai1,ai2,ai3;
		a=left.elements;
		b=right.elements;
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			out[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			out[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			out[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			out[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	ParallelSplitShadowMap.SHADERDEFINE_RECEIVE_SHADOW=0x1;
	ParallelSplitShadowMap.SHADERDEFINE_CAST_SHADOW=0x200;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM1=0x400;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM2=0x800;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PSSM3=0x1000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF_NO=0x2000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF1=0x4000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF2=0x8000;
	ParallelSplitShadowMap.SHADERDEFINE_SHADOW_PCF3=0x10000;
	ParallelSplitShadowMap.MAX_PSSM_COUNT=3;
	return ParallelSplitShadowMap;
})()


/**
*<code>TerrainLeaf</code> Terrain的叶子节点
*/
//class laya.d3.terrain.TerrainLeaf
var TerrainLeaf=(function(){
	function TerrainLeaf(){
		this._boundingSphere=null;
		this._boundingBox=null;
		this._sizeOfY=null;
		this._currentLODLevel=0;
		this._lastDistanceToEye=NaN;
		this._originalBoundingSphere=null;
		this._originalBoundingBox=null;
		this._originalBoundingBoxCorners=null;
		this._bUseStrip=false;
		this._gridSize=NaN;
		this._beginGridX=0;
		//针对整个大地形的偏移
		this._beginGridZ=0;
		//针对整个大地形的偏移
		this._LODError=null;
		TerrainLeaf.__init__();
		this._currentLODLevel=0;
	}

	__class(TerrainLeaf,'laya.d3.terrain.TerrainLeaf');
	var __proto=TerrainLeaf.prototype;
	__proto.calcVertextNorml=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight,normal){
		var dZ=0,dX=0;
		dX=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		normal.x=-dX;
		normal.y=6;
		normal.z=-dZ;
		Vector3.normalize(normal,normal);
	}

	__proto.calcVertextNormlUV=function(x,z,terrainWidth,terrainHeight,normal){
		normal.x=x / terrainWidth;
		normal.y=z / terrainHeight;
		normal.z=z / terrainHeight;
	}

	__proto.calcVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight,cameraCoordinateInverse){
		if (cameraCoordinateInverse==true && !TerrainLeaf.__ADAPT_MATRIX__){
			TerrainLeaf.__ADAPT_MATRIX__=new Matrix4x4();
			var mat=new Matrix4x4();
			Matrix4x4.createRotationY(Math.PI,TerrainLeaf.__ADAPT_MATRIX__);
			Matrix4x4.createTranslate(new Vector3(0,0,(heightDataHeight-1)*girdSize),mat);
			Matrix4x4.multiply(mat,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__ADAPT_MATRIX__);
			TerrainLeaf.__ADAPT_MATRIX_INV__=new Matrix4x4();
			TerrainLeaf.__ADAPT_MATRIX__.invert(TerrainLeaf.__ADAPT_MATRIX_INV__);
		}
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var minY=2147483647;
		var maxY=-2147483648;
		var normal=new Vector3();
		for (var i=0,s=TerrainLeaf.LEAF_GRID_NUM+1;i < s;i++){
			for (var j=0,s1=TerrainLeaf.LEAF_GRID_NUM+1;j < s1;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+i)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=terrainHeightData[(this._beginGridZ+i)*(heighDataWidth)+(this._beginGridX+j)];
				minY=TerrainLeaf.__VECTOR3__.y < minY ? TerrainLeaf.__VECTOR3__.y :minY;
				maxY=TerrainLeaf.__VECTOR3__.y > maxY ? TerrainLeaf.__VECTOR3__.y :maxY;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				this.calcVertextNormlUV(this._beginGridX+j,this._beginGridZ+i,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+i)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+i;
				nNum++;
			}
		}
		this._sizeOfY=new Vector2(minY-1,maxY+1);
		this.calcLODErrors(terrainHeightData,heighDataWidth,heightDataHeight);
		this.calcOriginalBoudingBoxAndSphere();
	}

	__proto.calcSkirtVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight){
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var i=0,j=0,s=TerrainLeaf.LEAF_GRID_NUM+1;
		var normal=new Vector3();
		var hZIndex=0;
		var hXIndex=0;
		var h=0;
		var zh=0;
		var xh=0;
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[this._beginGridZ *heighDataWidth+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+0)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=(this._beginGridZ-1);
					}else {
					hZIndex=this._beginGridZ;
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*(heighDataWidth)+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM;
					}else {
					hZIndex=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM+1);
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+0)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+0)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX;
					}else {
					hXIndex=(this._beginGridX-1);
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM+1;
					}else {
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM;
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
	}

	__proto.calcOriginalBoudingBoxAndSphere=function(){
		var min=new Vector3(this._beginGridX *this._gridSize,this._sizeOfY.x,this._beginGridZ *this._gridSize);
		var max=new Vector3((this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize,this._sizeOfY.y,(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize);
		if (TerrainLeaf.__ADAPT_MATRIX__){
			Vector3.transformV3ToV3(min,TerrainLeaf.__ADAPT_MATRIX__,min);
			Vector3.transformV3ToV3(max,TerrainLeaf.__ADAPT_MATRIX__,max);
		}
		this._originalBoundingBox=new BoundBox(min,max);
		var size=new Vector3();
		Vector3.subtract(max,min,size);
		Vector3.scale(size,0.5,size);
		var center=new Vector3();
		Vector3.add(min,size,center);
		this._originalBoundingSphere=new BoundSphere(center,Vector3.scalarLength(size));
		this._originalBoundingBoxCorners=__newvec(8,null);
		this._originalBoundingBox.getCorners(this._originalBoundingBoxCorners);
		this._boundingBox=new BoundBox(new Vector3(-0.5,-0.5,-0.5),new Vector3(0.5,0.5,0.5));
		this._boundingSphere=new BoundSphere(new Vector3(0,0,0),1);
	}

	__proto.calcLeafBoudingBox=function(worldMatrix){
		for (var i=0;i < 8;i++){
			Vector3.transformCoordinate(this._originalBoundingBoxCorners[i],worldMatrix,BaseRender._tempBoundBoxCorners[i]);
		}
		BoundBox.createfromPoints(BaseRender._tempBoundBoxCorners,this._boundingBox);
	}

	__proto.calcLeafBoudingSphere=function(worldMatrix,maxScale){
		Vector3.transformCoordinate(this._originalBoundingSphere.center,worldMatrix,this._boundingSphere.center);
		this._boundingSphere.radius=this._originalBoundingSphere.radius *maxScale;
	}

	__proto.calcLODErrors=function(terrainHeightData,heighDataWidth,heightDataHeight){
		this._LODError=new Float32Array(TerrainLeaf._maxLODLevel+1);
		var step=1;
		for (var i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
			var maxError=0;
			for (var y=0,n1=TerrainLeaf.LEAF_GRID_NUM;y < n1;y+=step){
				for (var x=0,n2=TerrainLeaf.LEAF_GRID_NUM;x < n2;x+=step){
					var z00=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)];
					var z10=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)+step];
					var z01=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)];
					var z11=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)+step];
					for (var j=0;j < step;j++){
						var ys=j / step;
						for (var k=0;k < step;k++){
							var xs=k / step;
							var z=terrainHeightData[(this._beginGridZ+y+j)*heighDataWidth+(this._beginGridX+x)+k];
							var iz=(xs+ys <=1)? (z00+(z10-z00)*xs+(z01-z00)*ys):(z11+(z01-z11)*(1-xs)+(z10-z11)*(1-ys));
							var error=Math.abs(iz-z);
							maxError=Math.max(maxError,error);
						}
					}
				}
			}
			step *=2;
			this._LODError[i]=maxError;
		}
	}

	__proto.determineLod=function(eyePos,perspectiveFactor,tolerance,tolerAndPerspectiveChanged){
		var nDistanceToEye=Vector3.distance(eyePos,this._boundingSphere.center);
		var n=TerrainLeaf._maxLODLevel;
		if (!tolerAndPerspectiveChanged){
			if (this._lastDistanceToEye==nDistanceToEye){
				return this._currentLODLevel;
				}else if (this._lastDistanceToEye > nDistanceToEye){
				n=this._currentLODLevel;
			}
		}
		for (var i=n;i >=1;i--){
			if (Terrain.LOD_DISTANCE_FACTOR *this._LODError[i] / nDistanceToEye *perspectiveFactor < tolerance){
				this._currentLODLevel=i;
				break ;
			}
		}
		this._lastDistanceToEye=nDistanceToEye;
		return this._currentLODLevel;
	}

	TerrainLeaf.__init__=function(){
		if (!TerrainLeaf._bInit){
			var nLeafNum=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM);
			TerrainLeaf._planeLODIndex=__newvec(nLeafNum);
			var i=0,j=0,k=0,n=0,n1=0,nOffset=0;
			var nOriginIndexArray=null,nTempIndex=null;
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._planeLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._planeLODIndex[0][i]=TerrainLeaf.calcPlaneLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._planeLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._planeLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._skirtLODIndex=__newvec(nLeafNum);
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._skirtLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._skirtLODIndex[0][i]=TerrainLeaf.calcSkirtLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._skirtLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._skirtLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._bInit=true;
		}
	}

	TerrainLeaf.getPlaneLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._planeLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.getSkirtLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._skirtLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.calcPlaneLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *nLODGridNum *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
			for (var j=0;j < TerrainLeaf.LEAF_GRID_NUM;j+=nGridSpace){
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
			}
		}
		return indexBuffer;
	}

	TerrainLeaf.calcSkirtLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nSkirtIndexOffset=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *4 *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var j=0;j < 4;j++){
			for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
			}
			nSkirtIndexOffset+=nGridNumAddOne *2;
		}
		return indexBuffer;
	}

	TerrainLeaf.getHeightFromTerrainHeightData=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight){
		x=x < 0 ? 0 :x;
		x=(x >=heighDataWidth)? heighDataWidth-1 :x;
		z=z < 0 ? 0 :z;
		z=(z >=heightDataHeight)? heightDataHeight-1 :z;
		return terrainHeightData[z *heighDataWidth+x];
	}

	TerrainLeaf.CHUNK_GRID_NUM=64;
	TerrainLeaf.LEAF_GRID_NUM=32;
	TerrainLeaf.__ADAPT_MATRIX__=null;
	TerrainLeaf.__ADAPT_MATRIX_INV__=null;
	TerrainLeaf._planeLODIndex=null;
	TerrainLeaf._skirtLODIndex=null;
	TerrainLeaf._bInit=false;
	__static(TerrainLeaf,
	['LEAF_PLANE_VERTEXT_COUNT',function(){return this.LEAF_PLANE_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*(TerrainLeaf.LEAF_GRID_NUM+1);},'LEAF_SKIRT_VERTEXT_COUNT',function(){return this.LEAF_SKIRT_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*2 *4;},'LEAF_VERTEXT_COUNT',function(){return this.LEAF_VERTEXT_COUNT=TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT+TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;},'LEAF_PLANE_MAX_INDEX_COUNT',function(){return this.LEAF_PLANE_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *TerrainLeaf.LEAF_GRID_NUM *6;},'LEAF_SKIRT_MAX_INDEX_COUNT',function(){return this.LEAF_SKIRT_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *4 *6;},'LEAF_MAX_INDEX_COUNT',function(){return this.LEAF_MAX_INDEX_COUNT=TerrainLeaf.LEAF_PLANE_MAX_INDEX_COUNT+TerrainLeaf.LEAF_SKIRT_MAX_INDEX_COUNT;},'__VECTOR3__',function(){return this.__VECTOR3__=new Vector3();},'_maxLODLevel',function(){return this._maxLODLevel=Math.log2(TerrainLeaf.LEAF_GRID_NUM);}
	]);
	return TerrainLeaf;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.ChunkInfo
var ChunkInfo=(function(){
	function ChunkInfo(){
		this.alphaMap=null;
		this.detailID=null;
		this.normalMap=null;
		;
	}

	__class(ChunkInfo,'laya.d3.terrain.unit.ChunkInfo');
	return ChunkInfo;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.DetailTextureInfo
var DetailTextureInfo=(function(){
	function DetailTextureInfo(){
		this.diffuseTexture=null;
		this.normalTexture=null;
		this.scale=null;
		this.offset=null;
		;
	}

	__class(DetailTextureInfo,'laya.d3.terrain.unit.DetailTextureInfo');
	return DetailTextureInfo;
})()


/**
*<code>MaterialInfo</code> 类用于描述地形材质信息。
*/
//class laya.d3.terrain.unit.MaterialInfo
var MaterialInfo=(function(){
	function MaterialInfo(){
		this.ambientColor=null;
		this.diffuseColor=null;
		this.specularColor=null;
		;
	}

	__class(MaterialInfo,'laya.d3.terrain.unit.MaterialInfo');
	return MaterialInfo;
})()


/**
*<code>Physics</code> 类用于简单物理检测。
*/
//class laya.d3.utils.Physics
var Physics=(function(){
	/**
	*创建一个 <code>Physics</code> 实例。
	*/
	function Physics(){}
	__class(Physics,'laya.d3.utils.Physics');
	Physics.__init__=function(){
		var maxCount=31;
		Physics._layerCollsionMatrix.length=maxCount;
		for (var i=0;i < maxCount;i++){
			var collArray=[];
			var count=maxCount-i;
			collArray.length=count;
			for (var j=0;j < count;j++)
			if (j===count-1)
				collArray[j]=true;
			else
			collArray[j]=false;
			Physics._layerCollsionMatrix[i]=collArray;
		}
	}

	Physics.setLayerCollision=function(layer1,layer2,collison){
		Physics._layerCollsionMatrix[layer1.number][(31-1)-layer2.number]=collison;
	}

	Physics.getLayerCollision=function(layer1,layer2){
		return Physics._layerCollsionMatrix[layer1.number][(31-1)-layer2.number];
	}

	Physics.setColliderCollision=function(collider1,collider2,collsion){
		if (collsion){
			delete collider1._ignoreCollisonMap[collider2.id];
			delete collider2._ignoreCollisonMap[collider1.id];
			}else {
			collider1._ignoreCollisonMap[collider2.id]=collider2;
			collider2._ignoreCollisonMap[collider1.id]=collider1;
		}
	}

	Physics.getIColliderCollision=function(collider1,collider2){
		return collider1._ignoreCollisonMap[collider2.id] ? true :false;
	}

	Physics.rayCast=function(ray,outHitInfo,distance,layer){
		(distance===void 0)&& (distance=1.79e+308);
		(layer===void 0)&& (layer=0);
		Physics._outHitAllInfo.length=0;
		var colliders=Layer.getLayerByNumber(layer)._colliders;
		for (var i=0,n=colliders.length;i < n;i++){
			var collider=colliders[i];
			if (collider.enable){
				collider.raycast(ray,Physics._outHitInfo,distance);
				if (Physics._outHitInfo.distance!==-1 && Physics._outHitInfo.distance <=distance){
					var outHit=new RaycastHit();
					Physics._outHitInfo.cloneTo(outHit);
					Physics._outHitAllInfo.push(outHit);
				}
			}
		}
		if (Physics._outHitAllInfo.length==0){
			outHitInfo.sprite3D=null;
			outHitInfo.distance=-1;
			return;
		};
		var minDistance=Number.MAX_VALUE;
		var minIndex=0;
		for (var j=0;j < Physics._outHitAllInfo.length;j++){
			if (Physics._outHitAllInfo[j].distance < minDistance){
				minDistance=Physics._outHitAllInfo[j].distance;
				minIndex=j;
			}
		}
		Physics._outHitAllInfo[minIndex].cloneTo(outHitInfo);
	}

	Physics.rayCastAll=function(ray,outHitAllInfo,distance,layer){
		(distance===void 0)&& (distance=1.79e+308);
		(layer===void 0)&& (layer=0);
		outHitAllInfo.length=0;
		var colliders=Layer.getLayerByNumber(layer)._colliders;
		for (var i=0,n=colliders.length;i < n;i++){
			var collider=colliders[i];
			if (collider.enable){
				Physics._outHitInfo.distance=-1;
				Physics._outHitInfo.sprite3D=null;
				collider.raycast(ray,Physics._outHitInfo,distance);
				if (Physics._outHitInfo.distance!==-1 && Physics._outHitInfo.distance <=distance){
					var outHit=new RaycastHit();
					Physics._outHitInfo.cloneTo(outHit);
					outHitAllInfo.push(outHit);
				}
			}
		}
	}

	Physics._outHitAllInfo=[];
	Physics._layerCollsionMatrix=[];
	__static(Physics,
	['_outHitInfo',function(){return this._outHitInfo=new RaycastHit();},'collisionManager',function(){return this.collisionManager=new CollisionManager();},'gravity',function(){return this.gravity=new Vector3(0,-9.81,0);}
	]);
	return Physics;
})()


/**
*<code>Picker</code> 类用于创建拾取。
*/
//class laya.d3.utils.Picker
var Picker=(function(){
	/**
	*创建一个 <code>Picker</code> 实例。
	*/
	function Picker(){}
	__class(Picker,'laya.d3.utils.Picker');
	Picker.calculateCursorRay=function(point,viewPort,projectionMatrix,viewMatrix,world,out){
		var x=point.elements[0];
		var y=point.elements[1];
		var nearSource=Picker._tempVector30;
		var nerSourceE=nearSource.elements;
		nerSourceE[0]=x;
		nerSourceE[1]=y;
		nerSourceE[2]=viewPort.minDepth;
		var farSource=Picker._tempVector31;
		var farSourceE=farSource.elements;
		farSourceE[0]=x;
		farSourceE[1]=y;
		farSourceE[2]=viewPort.maxDepth;
		var nearPoint=out.origin;
		var farPoint=Picker._tempVector32;
		viewPort.unprojectFromWVP(nearSource,projectionMatrix,viewMatrix,world,nearPoint);
		viewPort.unprojectFromWVP(farSource,projectionMatrix,viewMatrix,world,farPoint);
		var outDire=out.direction.elements;
		outDire[0]=farPoint.x-nearPoint.x;
		outDire[1]=farPoint.y-nearPoint.y;
		outDire[2]=farPoint.z-nearPoint.z;
		Vector3.normalize(out.direction,out.direction);
	}

	Picker.rayIntersectsPositionsAndIndices=function(ray,vertexDatas,vertexDeclaration,indices,outHitInfo){
		var vertexStrideFloatCount=vertexDeclaration.vertexStride / 4;
		var positionVertexElementOffset=vertexDeclaration.getVertexElementByUsage(0).offset / 4;
		var closestIntersection=Number.MAX_VALUE;
		var closestTriangleVertexIndex1=-1;
		var closestTriangleVertexIndex2=-1;
		var closestTriangleVertexIndex3=-1;
		for (var j=0;j < indices.length;j+=3){
			var vertex1=Picker._tempVector35;
			var vertex1E=vertex1.elements;
			var vertex1Index=indices[j] *vertexStrideFloatCount;
			var vertex1PositionIndex=vertex1Index+positionVertexElementOffset;
			vertex1E[0]=vertexDatas[vertex1PositionIndex];
			vertex1E[1]=vertexDatas[vertex1PositionIndex+1];
			vertex1E[2]=vertexDatas[vertex1PositionIndex+2];
			var vertex2=Picker._tempVector36;
			var vertex2E=vertex2.elements;
			var vertex2Index=indices[j+1] *vertexStrideFloatCount;
			var vertex2PositionIndex=vertex2Index+positionVertexElementOffset;
			vertex2E[0]=vertexDatas[vertex2PositionIndex];
			vertex2E[1]=vertexDatas[vertex2PositionIndex+1];
			vertex2E[2]=vertexDatas[vertex2PositionIndex+2];
			var vertex3=Picker._tempVector37;
			var vertex3E=vertex3.elements;
			var vertex3Index=indices[j+2] *vertexStrideFloatCount;
			var vertex3PositionIndex=vertex3Index+positionVertexElementOffset;
			vertex3E[0]=vertexDatas[vertex3PositionIndex];
			vertex3E[1]=vertexDatas[vertex3PositionIndex+1];
			vertex3E[2]=vertexDatas[vertex3PositionIndex+2];
			var intersection=laya.d3.utils.Picker.rayIntersectsTriangle(ray,vertex1,vertex2,vertex3);
			if (!isNaN(intersection)&& intersection < closestIntersection){
				closestIntersection=intersection;
				closestTriangleVertexIndex1=vertex1Index;
				closestTriangleVertexIndex2=vertex2Index;
				closestTriangleVertexIndex3=vertex3Index;
			}
		}
		if (closestIntersection!==Number.MAX_VALUE){
			outHitInfo.distance=closestIntersection;
			Vector3.scale(ray.direction,closestIntersection,outHitInfo.position);
			Vector3.add(ray.origin,outHitInfo.position,outHitInfo.position);
			var trianglePositions=outHitInfo.trianglePositions;
			var position0=trianglePositions[0];
			var position1=trianglePositions[1];
			var position2=trianglePositions[2];
			var position0E=position0.elements;
			var position1E=position1.elements;
			var position2E=position2.elements;
			var closestVertex1PositionIndex=closestTriangleVertexIndex1+positionVertexElementOffset;
			position0E[0]=vertexDatas[closestVertex1PositionIndex];
			position0E[1]=vertexDatas[closestVertex1PositionIndex+1];
			position0E[2]=vertexDatas[closestVertex1PositionIndex+2];
			var closestVertex2PositionIndex=closestTriangleVertexIndex2+positionVertexElementOffset;
			position1E[0]=vertexDatas[closestVertex2PositionIndex];
			position1E[1]=vertexDatas[closestVertex2PositionIndex+1];
			position1E[2]=vertexDatas[closestVertex2PositionIndex+2];
			var closestVertex3PositionIndex=closestTriangleVertexIndex3+positionVertexElementOffset;
			position2E[0]=vertexDatas[closestVertex3PositionIndex];
			position2E[1]=vertexDatas[closestVertex3PositionIndex+1];
			position2E[2]=vertexDatas[closestVertex3PositionIndex+2];
			var normalVertexElement=vertexDeclaration.getVertexElementByUsage(3);
			if (normalVertexElement){
				var normalVertexElementOffset=normalVertexElement.offset / 4;
				var triangleNormals=outHitInfo.triangleNormals;
				var normal0=triangleNormals[0];
				var normal1=triangleNormals[1];
				var normal2=triangleNormals[2];
				var normal0E=normal0.elements;
				var normal1E=normal1.elements;
				var normal2E=normal2.elements;
				var closestVertex1NormalIndex=closestTriangleVertexIndex1+normalVertexElementOffset;
				normal0E[0]=vertexDatas[closestVertex1NormalIndex];
				normal0E[1]=vertexDatas[closestVertex1NormalIndex+1];
				normal0E[2]=vertexDatas[closestVertex1NormalIndex+2];
				var closestVertex2NormalIndex=closestTriangleVertexIndex2+normalVertexElementOffset;
				normal1E[0]=vertexDatas[closestVertex2NormalIndex];
				normal1E[1]=vertexDatas[closestVertex2NormalIndex+1];
				normal1E[2]=vertexDatas[closestVertex2NormalIndex+2];
				var closestVertex3NormalIndex=closestTriangleVertexIndex3+normalVertexElementOffset;
				normal2E[0]=vertexDatas[closestVertex3NormalIndex];
				normal2E[1]=vertexDatas[closestVertex3NormalIndex+1];
				normal2E[2]=vertexDatas[closestVertex3NormalIndex+2];
			}
			return true;
			}else {
			outHitInfo.position.toDefault();
			outHitInfo.distance=Number.MAX_VALUE;
			outHitInfo.trianglePositions[0].toDefault();
			outHitInfo.trianglePositions[1].toDefault();
			outHitInfo.trianglePositions[2].toDefault();
			outHitInfo.triangleNormals[0].toDefault();
			outHitInfo.triangleNormals[1].toDefault();
			outHitInfo.triangleNormals[2].toDefault();
			return false;
		}
	}

	Picker.rayIntersectsTriangle=function(ray,vertex1,vertex2,vertex3){
		var result;
		var edge1=Picker._tempVector30,edge2=Picker._tempVector31;
		Vector3.subtract(vertex2,vertex1,edge1);
		Vector3.subtract(vertex3,vertex1,edge2);
		var directionCrossEdge2=Picker._tempVector32;
		Vector3.cross(ray.direction,edge2,directionCrossEdge2);
		var determinant;
		determinant=Vector3.dot(edge1,directionCrossEdge2);
		if (determinant >-Number.MIN_VALUE && determinant < Number.MIN_VALUE){
			result=Number.NaN;
			return result;
		};
		var inverseDeterminant=1.0 / determinant;
		var distanceVector=Picker._tempVector33;
		Vector3.subtract(ray.origin,vertex1,distanceVector);
		var triangleU;
		triangleU=Vector3.dot(distanceVector,directionCrossEdge2);
		triangleU *=inverseDeterminant;
		if (triangleU < 0 || triangleU > 1){
			result=Number.NaN;
			return result;
		};
		var distanceCrossEdge1=Picker._tempVector34;
		Vector3.cross(distanceVector,edge1,distanceCrossEdge1);
		var triangleV;
		triangleV=Vector3.dot(ray.direction,distanceCrossEdge1);
		triangleV *=inverseDeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			result=Number.NaN;
			return result;
		};
		var rayDistance;
		rayDistance=Vector3.dot(edge2,distanceCrossEdge1);
		rayDistance *=inverseDeterminant;
		if (rayDistance < 0){
			result=Number.NaN;
			return result;
		}
		result=rayDistance;
		return result;
	}

	__static(Picker,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempVector34',function(){return this._tempVector34=new Vector3();},'_tempVector35',function(){return this._tempVector35=new Vector3();},'_tempVector36',function(){return this._tempVector36=new Vector3();},'_tempVector37',function(){return this._tempVector37=new Vector3();}
	]);
	return Picker;
})()


/**
*...
*@author ...
*/
//class laya.d3.utils.RaycastHit
var RaycastHit=(function(){
	function RaycastHit(){
		this.distance=NaN;
		this.trianglePositions=null;
		this.triangleNormals=null;
		this.position=null;
		this.sprite3D=null;
		this.distance=-1;
		this.trianglePositions=[new Vector3(),new Vector3(),new Vector3()];
		this.trianglePositions.length=3;
		this.triangleNormals=[new Vector3(),new Vector3(),new Vector3()];
		this.triangleNormals.length=3;
		this.position=new Vector3();
	}

	__class(RaycastHit,'laya.d3.utils.RaycastHit');
	var __proto=RaycastHit.prototype;
	__proto.cloneTo=function(dec){
		dec.distance=this.distance;
		this.trianglePositions[0].cloneTo(dec.trianglePositions[0]);
		this.trianglePositions[1].cloneTo(dec.trianglePositions[1]);
		this.trianglePositions[2].cloneTo(dec.trianglePositions[2]);
		this.triangleNormals[0].cloneTo(dec.triangleNormals[0]);
		this.triangleNormals[1].cloneTo(dec.triangleNormals[1]);
		this.triangleNormals[2].cloneTo(dec.triangleNormals[2]);
		this.position.cloneTo(dec.position);
		dec.sprite3D=this.sprite3D;
	}

	return RaycastHit;
})()


//class laya.d3.utils.Size
var Size=(function(){
	function Size(width,height){
		this._width=0;
		this._height=0;
		this._width=width;
		this._height=height;
	}

	__class(Size,'laya.d3.utils.Size');
	var __proto=Size.prototype;
	__getset(0,__proto,'width',function(){
		if (this._width===-1)
			return RenderState.clientWidth;
		return this._width;
	});

	__getset(0,__proto,'height',function(){
		if (this._height===-1)
			return RenderState.clientHeight;
		return this._height;
	});

	__getset(1,Size,'fullScreen',function(){
		return new Size(-1,-1);
	});

	return Size;
})()


/**
*<code>Utils3D</code> 类用于创建3D工具。
*/
//class laya.d3.utils.Utils3D
var Utils3D=(function(){
	function Utils3D(){}
	__class(Utils3D,'laya.d3.utils.Utils3D');
	Utils3D._rotationTransformScaleSkinAnimation=function(tx,ty,tz,qx,qy,qz,qw,sx,sy,sz,outArray,outOffset){
		var re=Utils3D._tempArray16_0;
		var se=Utils3D._tempArray16_1;
		var tse=Utils3D._tempArray16_2;
		var x2=qx+qx;
		var y2=qy+qy;
		var z2=qz+qz;
		var xx=qx *x2;
		var yx=qy *x2;
		var yy=qy *y2;
		var zx=qz *x2;
		var zy=qz *y2;
		var zz=qz *z2;
		var wx=qw *x2;
		var wy=qw *y2;
		var wz=qw *z2;
		re[15]=1;
		re[0]=1-yy-zz;
		re[1]=yx+wz;
		re[2]=zx-wy;
		re[4]=yx-wz;
		re[5]=1-xx-zz;
		re[6]=zy+wx;
		re[8]=zx+wy;
		re[9]=zy-wx;
		re[10]=1-xx-yy;
		se[15]=1;
		se[0]=sx;
		se[5]=sy;
		se[10]=sz;
		var i,a,b,e,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=re[i];
			ai1=re[i+4];
			ai2=re[i+8];
			ai3=re[i+12];
			tse[i]=ai0;
			tse[i+4]=ai1;
			tse[i+8]=ai2;
			tse[i+12]=ai0 *tx+ai1 *ty+ai2 *tz+ai3;
		}
		for (i=0;i < 4;i++){
			ai0=tse[i];
			ai1=tse[i+4];
			ai2=tse[i+8];
			ai3=tse[i+12];
			outArray[i+outOffset]=ai0 *se[0]+ai1 *se[1]+ai2 *se[2]+ai3 *se[3];
			outArray[i+outOffset+4]=ai0 *se[4]+ai1 *se[5]+ai2 *se[6]+ai3 *se[7];
			outArray[i+outOffset+8]=ai0 *se[8]+ai1 *se[9]+ai2 *se[10]+ai3 *se[11];
			outArray[i+outOffset+12]=ai0 *se[12]+ai1 *se[13]+ai2 *se[14]+ai3 *se[15];
		}
	}

	Utils3D._createNodeByJson=function(rootNode,nodeData,node,innerResouMap){
		if (!node){
			switch (nodeData.type){
				case "Sprite3D":
					node=new Sprite3D();
					break ;
				case "MeshSprite3D":
					node=new MeshSprite3D();
					break ;
				case "SkinnedMeshSprite3D":
					node=new SkinnedMeshSprite3D();
					break ;
				case "ShuriKenParticle3D":
					node=new ShuriKenParticle3D();
					break ;
				case "Terrain":
					node=new Terrain();
					break ;
				case "Camera":
					node=new Camera();
					break ;
				case "DirectionLight":
					node=new DirectionLight();
					break ;
				default :
					throw new Error("Utils3D:unidentified class type in (.lh) file.");
				}
		};
		var props=nodeData.props;
		if (props)
			for (var key in props)
		node[key]=props[key];
		var customProps=nodeData.customProps;
		if (customProps){
			if ((node instanceof laya.d3.core.Sprite3D )){
				node._parseBaseCustomProps(customProps);
				node._parseCustomProps(rootNode,innerResouMap,customProps,nodeData);
				node._parseCustomComponent(rootNode,innerResouMap,nodeData.components);
				}else {
				node._parseCustomProps(rootNode,innerResouMap,customProps,nodeData);
			}
		};
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._createNodeByJson(rootNode,childData[i],null,innerResouMap)
				node.addChild(child);
			}
		}
		return node;
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxix=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas,boneIndexToMesh){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFast=function(inverGlobalBindPose,bonesDatas,outAnimationDatas,boneIndexToMesh){
		for (var i=0,n=inverGlobalBindPose.length;i < n;i++)
		laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxixOld=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+7],curData[offset+8],curData[offset+9],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+0],curData[offset+1],curData[offset+2],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFastOld=function(inverGlobalBindPose,bonesDatas,outAnimationDatas){
		var n=inverGlobalBindPose.length;
		for (var i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeRootAnimationData=function(bones,curData,animationDatas){
		for (var i=0,offset=0,matOffset=0,boneLength=bones.length;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++)
		laya.d3.utils.Utils3D.createAffineTransformationArray(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],animationDatas,matOffset);
	}

	Utils3D.transformVector3ArrayByQuat=function(sourceArray,sourceOffset,rotation,outArray,outOffset){
		var re=rotation.elements;
		var x=sourceArray[sourceOffset],y=sourceArray[sourceOffset+1],z=sourceArray[sourceOffset+2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		outArray[outOffset]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		outArray[outOffset+1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		outArray[outOffset+2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.mulMatrixByArray=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		if (outArray===rightArray){
			rightArray=Utils3D._tempArray16_3;
			for (i=0;i < 16;++i){
				rightArray[i]=outArray[outOffset+i];
			}
			rightOffset=0;
		}
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayFast=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayAndMatrixFast=function(leftArray,leftOffset,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0LeftOffset=leftOffset;
		var ai1LeftOffset=leftOffset+4;
		var ai2LeftOffset=leftOffset+8;
		var ai3LeftOffset=leftOffset+12;
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftArray[ai0LeftOffset+i];
			ai1=leftArray[ai1LeftOffset+i];
			ai2=leftArray[ai2LeftOffset+i];
			ai3=leftArray[ai3LeftOffset+i];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.createAffineTransformationArray=function(tX,tY,tZ,rX,rY,rZ,rW,sX,sY,sZ,outArray,outOffset){
		var x2=rX+rX,y2=rY+rY,z2=rZ+rZ;
		var xx=rX *x2,xy=rX *y2,xz=rX *z2,yy=rY *y2,yz=rY *z2,zz=rZ *z2;
		var wx=rW *x2,wy=rW *y2,wz=rW *z2;
		outArray[outOffset+0]=(1-(yy+zz))*sX;
		outArray[outOffset+1]=(xy+wz)*sX;
		outArray[outOffset+2]=(xz-wy)*sX;
		outArray[outOffset+3]=0;
		outArray[outOffset+4]=(xy-wz)*sY;
		outArray[outOffset+5]=(1-(xx+zz))*sY;
		outArray[outOffset+6]=(yz+wx)*sY;
		outArray[outOffset+7]=0;
		outArray[outOffset+8]=(xz+wy)*sZ;
		outArray[outOffset+9]=(yz-wx)*sZ;
		outArray[outOffset+10]=(1-(xx+yy))*sZ;
		outArray[outOffset+11]=0;
		outArray[outOffset+12]=tX;
		outArray[outOffset+13]=tY;
		outArray[outOffset+14]=tZ;
		outArray[outOffset+15]=1;
	}

	Utils3D.transformVector3ArrayToVector3ArrayCoordinate=function(source,sourceOffset,transform,result,resultOffset){
		var vectorElem=Utils3D._tempArray4_0;
		var coordinateX=source[sourceOffset+0];
		var coordinateY=source[sourceOffset+1];
		var coordinateZ=source[sourceOffset+2];
		var transformElem=transform.elements;
		vectorElem[0]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12];
		vectorElem[1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13];
		vectorElem[2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14];
		vectorElem[3]=1.0 / ((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		result[resultOffset+0]=vectorElem[0] *vectorElem[3];
		result[resultOffset+1]=vectorElem[1] *vectorElem[3];
		result[resultOffset+2]=vectorElem[2] *vectorElem[3];
	}

	Utils3D.transformLightingMapTexcoordByUV0Array=function(source,sourceOffset,lightingMapScaleOffset,result,resultOffset){
		var lightingMapScaleOffsetE=lightingMapScaleOffset.elements;
		result[resultOffset+0]=source[sourceOffset+0] *lightingMapScaleOffsetE[0]+lightingMapScaleOffsetE[2];
		result[resultOffset+1]=(source[sourceOffset+1]-1.0)*lightingMapScaleOffsetE[1]+lightingMapScaleOffsetE[3];
	}

	Utils3D.transformLightingMapTexcoordByUV1Array=function(source,sourceOffset,lightingMapScaleOffset,result,resultOffset){
		var lightingMapScaleOffsetE=lightingMapScaleOffset.elements;
		result[resultOffset+0]=source[sourceOffset+0] *lightingMapScaleOffsetE[0]+lightingMapScaleOffsetE[2];
		result[resultOffset+1]=1.0+source[sourceOffset+1] *lightingMapScaleOffsetE[1]+lightingMapScaleOffsetE[3];
	}

	Utils3D.getURLVerion=function(url){
		var index=url.indexOf("?");
		return index >=0 ? url.substr(index):null;
	}

	Utils3D._quaternionCreateFromYawPitchRollArray=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		out[0]=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		out[1]=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		out[2]=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		out[3]=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	Utils3D._createAffineTransformationArray=function(trans,rot,scale,outE){
		var x=rot[0],y=rot[1],z=rot[2],w=rot[3],x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=scale[0],sy=scale[1],sz=scale[2];
		outE[0]=(1-(yy+zz))*sx;
		outE[1]=(xy+wz)*sx;
		outE[2]=(xz-wy)*sx;
		outE[3]=0;
		outE[4]=(xy-wz)*sy;
		outE[5]=(1-(xx+zz))*sy;
		outE[6]=(yz+wx)*sy;
		outE[7]=0;
		outE[8]=(xz+wy)*sz;
		outE[9]=(yz-wx)*sz;
		outE[10]=(1-(xx+yy))*sz;
		outE[11]=0;
		outE[12]=trans[0];
		outE[13]=trans[1];
		outE[14]=trans[2];
		outE[15]=1;
	}

	Utils3D._mulMatrixArray=function(leftMatrixE,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftMatrixE[i];
			ai1=leftMatrixE[i+4];
			ai2=leftMatrixE[i+8];
			ai3=leftMatrixE[i+12];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.getYawPitchRoll=function(quaternion,out){
		Utils3D.transformQuat(Vector3.ForwardRH,quaternion,Quaternion.TEMPVector31);
		Utils3D.transformQuat(Vector3.Up,quaternion,Quaternion.TEMPVector32);
		var upe=Quaternion.TEMPVector32.elements;
		Utils3D.angleTo(Vector3.ZERO,Quaternion.TEMPVector31,Quaternion.TEMPVector33);
		var anglee=Quaternion.TEMPVector33.elements;
		if (anglee[0]==Math.PI / 2){
			anglee[1]=Utils3D.arcTanAngle(upe[2],upe[0]);
			anglee[2]=0;
			}else if (anglee[0]==-Math.PI / 2){
			anglee[1]=Utils3D.arcTanAngle(-upe[2],-upe[0]);
			anglee[2]=0;
			}else {
			Matrix4x4.createRotationY(-anglee[1],Quaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-anglee[0],Quaternion.TEMPMatrix1);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix0,Quaternion.TEMPVector32);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix1,Quaternion.TEMPVector32);
			anglee[2]=Utils3D.arcTanAngle(upe[1],-upe[0]);
		}
		if (anglee[1] <=-Math.PI)
			anglee[1]=Math.PI;
		if (anglee[2] <=-Math.PI)
			anglee[2]=Math.PI;
		if (anglee[1] >=Math.PI && anglee[2] >=Math.PI){
			anglee[1]=0;
			anglee[2]=0;
			anglee[0]=Math.PI-anglee[0];
		}
		out[0]=anglee[1];
		out[1]=anglee[0];
		out[2]=anglee[2];
	}

	Utils3D.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Utils3D.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.elements[0]=Math.asin(Quaternion.TEMPVector30.y);
		angle.elements[1]=Utils3D.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Utils3D.transformQuat=function(source,rotation,out){
		var destination=out.elements;
		var se=source.elements;
		var re=rotation;
		var x=se[0],y=se[1],z=se[2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		destination[0]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		destination[1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		destination[2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.quaterionNormalize=function(f,e){
		var x=f[0],y=f[1],z=f[2],w=f[3];
		var len=x *x+y *y+z *z+w *w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			e[0]=x *len;
			e[1]=y *len;
			e[2]=z *len;
			e[3]=w *len;
		}
	}

	Utils3D.matrix4x4MultiplyFFF=function(a,b,e){
		var i,e,a,b,ai0,ai1,ai2,ai3;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		}
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			e[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			e[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			e[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	Utils3D.matrix4x4MultiplyMFM=function(left,right,out){
		Utils3D.matrix4x4MultiplyFFF(left.elements,right,out.elements);
	}

	__static(Utils3D,
	['_typeToFunO',function(){return this._typeToFunO={"INT16":"writeInt16","SHORT":"writeInt16","UINT16":"writeUint16","UINT32":"writeUint32","FLOAT32":"writeFloat32","INT":"writeInt32","UINT":"writeUint32","BYTE":"writeByte","STRING":"writeUTFString"};},'_tempVector3_0',function(){return this._tempVector3_0=new Vector3();},'_tempVector3_1',function(){return this._tempVector3_1=new Vector3();},'_tempVector3_2',function(){return this._tempVector3_2=new Vector3();},'_tempVector3_3',function(){return this._tempVector3_3=new Vector3();},'_tempVector3_4',function(){return this._tempVector3_4=new Vector3();},'_tempVector3_5',function(){return this._tempVector3_5=new Vector3();},'_tempVector3_6',function(){return this._tempVector3_6=new Vector3();},'_tempArray4_0',function(){return this._tempArray4_0=new Float32Array(4);},'_tempArray16_0',function(){return this._tempArray16_0=new Float32Array(16);},'_tempArray16_1',function(){return this._tempArray16_1=new Float32Array(16);},'_tempArray16_2',function(){return this._tempArray16_2=new Float32Array(16);},'_tempArray16_3',function(){return this._tempArray16_3=new Float32Array(16);}
	]);
	return Utils3D;
})()


/**
*<code>Laya3D</code> 类用于初始化3D设置。
*/
//class Laya3D
var Laya3D=(function(){
	/**
	*创建一个 <code>Laya3D</code> 实例。
	*/
	function Laya3D(){}
	__class(Laya3D,'Laya3D');
	Laya3D._changeWebGLSize=function(width,height){
		WebGL.onStageResize(width,height);
		RenderState.clientWidth=width;
		RenderState.clientHeight=height;
	}

	Laya3D.__init__=function(){
		var createMap=LoaderManager.createMap;
		createMap["lh"]=[Sprite3D,"SPRITE3DHIERARCHY"];
		createMap["ls"]=[Scene,"SPRITE3DHIERARCHY"];
		createMap["lm"]=[Mesh,"MESH"];
		createMap["lmat"]=[StandardMaterial,"MATERIAL"];
		createMap["lpbr"]=[PBRMaterial,"MATERIAL"];
		createMap["ltc"]=[TextureCube,"TEXTURECUBE"];
		createMap["jpg"]=[Texture2D,"nativeimage"];
		createMap["jpeg"]=[Texture2D,"nativeimage"];
		createMap["png"]=[Texture2D,"nativeimage"];
		createMap["pkm"]=[Texture2D,"arraybuffer"];
		createMap["lsani"]=[AnimationTemplet,"arraybuffer"];
		createMap["lrani"]=[AnimationTemplet,"arraybuffer"];
		createMap["raw"]=[DataTexture2D,"arraybuffer"];
		createMap["mipmaps"]=[DataTexture2D,"arraybuffer"];
		createMap["thdata"]=[TerrainHeightData,"arraybuffer"];
		createMap["lt"]=[TerrainRes,"TERRAIN"];
		createMap["lani"]=[AnimationClip,"arraybuffer"];
		createMap["lav"]=[Avatar,"json"];
		createMap["ani"]=[AnimationTemplet,"arraybuffer"];
		Loader.parserMap["SPRITE3DHIERARCHY"]=Laya3D._loadHierarchy;
		Loader.parserMap["MESH"]=Laya3D._loadMesh;
		Loader.parserMap["MATERIAL"]=Laya3D._loadMaterial;
		Loader.parserMap["TEXTURECUBE"]=Laya3D._loadTextureCube;
		Loader.parserMap["TERRAIN"]=Laya3D._loadTerrain;
		Laya3D._innerFirstLevelLoaderManager.on("error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerSecondLevelLoaderManager.on("error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerThirdLevelLoaderManager.on("error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerFourthLevelLoaderManager.on("error",null,Laya3D._eventLoadManagerError);
	}

	Laya3D.READ_BLOCK=function(){
		Laya3D._readData.pos+=4;
		return true;
	}

	Laya3D.READ_DATA=function(){
		Laya3D._DATA.offset=Laya3D._readData.getUint32();
		Laya3D._DATA.size=Laya3D._readData.getUint32();
		return true;
	}

	Laya3D.READ_STRINGS=function(){
		var materialUrls=[];
		var _STRINGS={offset:0,size:0};
		_STRINGS.offset=Laya3D._readData.getUint16();
		_STRINGS.size=Laya3D._readData.getUint16();
		var ofs=Laya3D._readData.pos;
		Laya3D._readData.pos=_STRINGS.offset+Laya3D._DATA.offset;
		for (var i=0;i < _STRINGS.size;i++){
			var string=Laya3D._readData.readUTFString();
			if (string.lastIndexOf(".lmat")!==-1 || string.lastIndexOf(".lpbr")!==-1)
				materialUrls.push(string);
		}
		return materialUrls;
	}

	Laya3D._eventLoadManagerError=function(msg){
		Laya.loader.event("error",msg);
	}

	Laya3D._addHierarchyInnerUrls=function(urls,urlMap,urlVersion,hierarchyBasePath,path,clas){
		var formatSubUrl=URL.formatURL(path,hierarchyBasePath);
		(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
		urls.push({url:formatSubUrl,clas:clas});
		urlMap[path]=formatSubUrl;
	}

	Laya3D._getSprite3DHierarchyInnerUrls=function(node,firstLevelUrls,secondLevelUrls,fourthLelUrls,urlMap,urlVersion,hierarchyBasePath){
		var i=0,n=0;
		var customProps;
		switch (node.type){
			case "Scene":;
				var lightmaps=node.customProps.lightmaps;
				for (i=0,n=lightmaps.length;i < n;i++){
					var lightMap=lightmaps[i].replace("exr","png");
					Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,lightMap,Texture2D);
				}
				break ;
			case "MeshSprite3D":
			case "SkinnedMeshSprite3D":;
				var meshPath;
				if (node.instanceParams){
					meshPath=node.instanceParams.loadPath;
					(meshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,meshPath,Mesh));
					}else {
					customProps=node.customProps;
					meshPath=customProps.meshPath;
					(meshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,meshPath,Mesh));
					var materials=customProps.materials;
					if (materials)
						for (i=0,n=materials.length;i < n;i++){
						var mat=materials[i];
						var clasPaths=mat.type.split('.');
						var clas=Browser.window;
						clasPaths.forEach(function(cls){
							clas=clas[cls];
						});
						if (typeof(clas)=='function')Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,mat.path,clas);
						else {
							throw('_getSprite3DHierarchyInnerUrls 错误: '+mat.type+' 不是类');
						}
					}
				}
				break ;
			case "ShuriKenParticle3D":
				customProps=node.customProps;
				var parMeshPath=customProps.meshPath;
				(parMeshPath)&& (Laya3D._addHierarchyInnerUrls(firstLevelUrls,urlMap,urlVersion,hierarchyBasePath,parMeshPath,Mesh));
				var materialData=customProps.material;
				if (materialData){
					Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,materialData.path,ShurikenParticleMaterial);
					}else {
					var materialPath=customProps.materialPath;
					if (materialPath){
						Laya3D._addHierarchyInnerUrls(secondLevelUrls,urlMap,urlVersion,hierarchyBasePath,materialPath,ShurikenParticleMaterial);
						}else {
						var texturePath=customProps.texturePath;
						if (texturePath)
							Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,texturePath,Texture2D);
					}
				}
				break ;
			case "Terrain":
				Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,node.customProps.dataPath,TerrainRes);
				break ;
			};
		var components=node.components;
		for (var k in components){
			var component=components[k];
			switch (k){
				case "Animator":;
					var avatarPath=component.avatarPath;
					if (avatarPath){
						Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,avatarPath,Avatar);
						}else {
						var avatarData=component.avatar;
						(avatarData)&& (Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,avatarData.path,Avatar));
					};
					var clipPaths=component.clipPaths;
					for (i=0,n=clipPaths.length;i < n;i++)
					Laya3D._addHierarchyInnerUrls(fourthLelUrls,urlMap,urlVersion,hierarchyBasePath,clipPaths[i],AnimationClip);
					break ;
				}
		};
		var children=node.child;
		for (i=0,n=children.length;i < n;i++)
		Laya3D._getSprite3DHierarchyInnerUrls(children[i],firstLevelUrls,secondLevelUrls,fourthLelUrls,urlMap,urlVersion,hierarchyBasePath);
	}

	Laya3D._loadHierarchy=function(loader){
		loader.on("loaded",null,Laya3D._onHierarchylhLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,"json",false,null,true);
	}

	Laya3D._onHierarchylhLoaded=function(loader,group,lhData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var hierarchyBasePath=URL.getPath(URL.formatURL(url));
			var firstLevUrls=[];
			var secondLevUrls=[];
			var forthLevUrls=[];
			var urlMap={};
			Laya3D._getSprite3DHierarchyInnerUrls(lhData,firstLevUrls,secondLevUrls,forthLevUrls,urlMap,urlVersion,hierarchyBasePath);
			var urlCount=firstLevUrls.length+secondLevUrls.length+forthLevUrls.length;
			var totalProcessCount=urlCount+1;
			var weight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,weight,1.0);
			if (forthLevUrls.length > 0){
				var processCeil=urlCount / totalProcessCount;
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight,processCeil],false);
				Laya3D._innerFourthLevelLoaderManager.create(forthLevUrls,Handler.create(null,Laya3D._onHierarchyInnerForthLevResouLoaded,[loader,group,processHandler,lhData,urlMap,firstLevUrls,secondLevUrls,weight+processCeil *forthLevUrls.length,processCeil]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerForthLevResouLoaded(loader,group,null,lhData,urlMap,firstLevUrls,secondLevUrls,weight,processCeil);
			}
		}
	}

	Laya3D._onHierarchyInnerForthLevResouLoaded=function(loader,group,processHandler,lhData,urlMap,firstLevUrls,secondLevUrls,processOffset,processCeil){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			(processHandler)&& (processHandler.recover());
			if (secondLevUrls.length > 0){
				var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
				Laya3D._innerSecondLevelLoaderManager.create(secondLevUrls,Handler.create(null,Laya3D._onHierarchyInnerSecondLevResouLoaded,[loader,group,process,lhData,urlMap,firstLevUrls,processOffset+processCeil *secondLevUrls.length,processCeil]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerSecondLevResouLoaded(loader,group,null,lhData,urlMap,firstLevUrls,processOffset,processCeil);
			}
		}
	}

	Laya3D._onHierarchyInnerSecondLevResouLoaded=function(loader,group,processHandler,lhData,urlMap,firstLevUrls,processOffset,processCeil){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			(processHandler)&& (processHandler.recover());
			if (firstLevUrls.length > 0){
				var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
				Laya3D._innerFirstLevelLoaderManager.create(firstLevUrls,Handler.create(null,Laya3D._onHierarchyInnerFirstLevResouLoaded,[loader,process,lhData,urlMap,]),processHandler,null,null,1,true,group);
				}else {
				Laya3D._onHierarchyInnerFirstLevResouLoaded(loader,null,lhData,urlMap);
			}
		}
	}

	Laya3D._onHierarchyInnerFirstLevResouLoaded=function(loader,processHandler,lhData,urlMap){
		(processHandler)&& (processHandler.recover());
		loader.endLoad([lhData,urlMap]);
	}

	Laya3D._loadTerrain=function(loader){
		loader.on("loaded",null,Laya3D._onTerrainLtLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,"json",false,null,true);
	}

	Laya3D._onTerrainLtLoaded=function(loader,group,ltData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var terrainBasePath=URL.getPath(URL.formatURL(url));
			var heightMapURL,textureURLs=[];
			var urlMap={};
			var formatUrl;
			var i=0,n=0,count=0;
			var heightData=ltData.heightData;
			heightMapURL=heightData.url;
			formatUrl=URL.formatURL(heightMapURL,terrainBasePath);
			(urlVersion)&& (formatUrl=formatUrl+urlVersion);
			urlMap[heightMapURL]=formatUrl;
			heightMapURL=formatUrl;
			var detailTextures=ltData.detailTexture;
			for (i=0,n=detailTextures.length;i < n;i++)
			textureURLs.push({url:detailTextures[i].diffuse});
			var normalMaps=ltData.normalMap;
			for (i=0,n=normalMaps.length;i < n;i++)
			textureURLs.push({url:normalMaps[i]});
			var alphaMaps=ltData.alphaMap;
			for (i=0,n=alphaMaps.length;i < n;i++)
			textureURLs.push({url:alphaMaps[i],params:[false,false,0x1908,true]});
			for (i=0,n=textureURLs.length;i < n;i++){
				var subUrl=textureURLs[i].url;
				formatUrl=URL.formatURL(subUrl,terrainBasePath);
				(urlVersion)&& (formatUrl=formatUrl+urlVersion);
				textureURLs[i].url=formatUrl;
				urlMap[subUrl]=formatUrl;
			};
			var texsUrlCount=textureURLs.length;
			var totalProcessCount=texsUrlCount+2;
			var weight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,weight,1.0);
			var loadInfo={heightMapLoaded:false,texturesLoaded:false};
			var hmProcessHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight,weight],false);
			Laya3D._innerFourthLevelLoaderManager.create(heightMapURL,Handler.create(null,Laya3D._onTerrainHeightMapLoaded,[loader,hmProcessHandler,ltData,urlMap,loadInfo]),hmProcessHandler,null,[heightData.numX,heightData.numZ,heightData.bitType,heightData.value],1,true,group);
			var texsProcessHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight *2,texsUrlCount / totalProcessCount],false);
			Laya3D._innerFourthLevelLoaderManager.create(textureURLs,Handler.create(null,Laya3D._onTerrainTexturesLoaded,[loader,texsProcessHandler,ltData,urlMap,loadInfo]),texsProcessHandler,null,null,1,true,group);
		}
	}

	Laya3D._onTerrainHeightMapLoaded=function(loader,processHandler,ltData,urlMap,loadInfo){
		loadInfo.heightMapLoaded=true;
		if (loadInfo.texturesLoaded){
			loader.endLoad([ltData,urlMap]);
			processHandler.recover();
		}
	}

	Laya3D._onTerrainTexturesLoaded=function(loader,processHandler,ltData,urlMap,loadInfo){
		loadInfo.texturesLoaded=true;
		if (loadInfo.heightMapLoaded){
			loader.endLoad([ltData,urlMap]);
			processHandler.recover();
		}
	}

	Laya3D._loadMesh=function(loader){
		loader.on("loaded",null,Laya3D._onMeshLmLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,"arraybuffer",false,null,true);
	}

	Laya3D._onMeshLmLoaded=function(loader,group,lmData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var meshBasePath=URL.getPath(URL.formatURL(url));
			var urls;
			var urlMap={};
			var formatSubUrl;
			var i=0,n=0,count=0;
			Laya3D._readData=new Byte(lmData);
			Laya3D._readData.pos=0;
			var version=Laya3D._readData.readUTFString();
			switch (version){
				case "LAYAMODEL:02":
				case "LAYAMODEL:03":
				case "LAYAMODEL:0301":;
					var dataOffset=Laya3D._readData.getUint32();
					Laya3D._readData.pos=Laya3D._readData.pos+4;
					count=Laya3D._readData.getUint16();
					Laya3D._readData.pos=Laya3D._readData.pos+count *8;
					var offset=Laya3D._readData.getUint32();
					count=Laya3D._readData.getUint16();
					Laya3D._readData.pos=dataOffset+offset;
					urls=[];
					for (i=0;i < count;i++){
						var string=Laya3D._readData.readUTFString();
						if (string.lastIndexOf(".lmat")!==-1)
							urls.push(string);
					}
					break ;
				default :
					Laya3D.READ_BLOCK();
					for (i=0;i < 2;i++){
						var index=Laya3D._readData.getUint16();
						var blockName=Laya3D._strings[index];
						var fn=Laya3D["READ_"+blockName];
						if (fn==null)throw new Error("model file err,no this function:"+index+" "+blockName);
						if (i===1)
							urls=fn.call();
						else
						fn.call()
					}
				}
			for (i=0,n=urls.length;i < n;i++){
				var subUrl=urls[i];
				formatSubUrl=URL.formatURL(subUrl,meshBasePath);
				(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
				urls[i]=formatSubUrl;
				urlMap[subUrl]=formatSubUrl;
			}
			if (urls.length > 0){
				var urlCount=1;
				var totalProcessCount=urlCount+1;
				var lmatWeight=1 / totalProcessCount;
				Laya3D._onProcessChange(loader,0,lmatWeight,1.0);
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,lmatWeight,urlCount / totalProcessCount],false);
				Laya3D._innerSecondLevelLoaderManager.create(urls,Handler.create(null,Laya3D._onMeshMateialLoaded,[loader,processHandler,lmData,urlMap]),processHandler,null,null,1,true,group);
				}else {
				loader.endLoad([lmData,urlMap]);
			}
		}
	}

	Laya3D._onMeshMateialLoaded=function(loader,processHandler,lmData,urlMap){
		loader.endLoad([lmData,urlMap]);
		processHandler.recover();
	}

	Laya3D._getMaterialTexturePath=function(path,urlVersion,materialBath){
		var extenIndex=path.length-4;
		if (path.indexOf(".dds")==extenIndex || path.indexOf(".tga")==extenIndex || path.indexOf(".exr")==extenIndex || path.indexOf(".DDS")==extenIndex || path.indexOf(".TGA")==extenIndex || path.indexOf(".EXR")==extenIndex)
			path=path.substr(0,extenIndex)+".png";
		path=URL.formatURL(path,materialBath);
		(urlVersion)&& (path=path+urlVersion);
		return path;
	}

	Laya3D._loadMaterial=function(loader){
		loader.on("loaded",null,Laya3D._onMaterilLmatLoaded,[loader,loader._class._getGroup()]);
		loader.load(loader.url,"json",false,null,true);
	}

	Laya3D._onMaterilLmatLoaded=function(loader,group,lmatData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var url=loader.url;
			var urlVersion=Utils3D.getURLVerion(url);
			var materialBasePath=URL.getPath(URL.formatURL(url));
			var urls=[];
			var urlMap={};
			var customProps=lmatData.customProps;
			var formatSubUrl;
			var version=lmatData.version;
			if (version){
				switch (version){
					case "LAYAMATERIAL:01":;
						var textures=lmatData.props.textures;
						for (var i=0,n=textures.length;i < n;i++){
							var tex=textures[i];
							var path=tex.path;
							if (path){
								var extenIndex=path.length-4;
								if (path.indexOf(".exr")==extenIndex || path.indexOf(".EXR")==extenIndex)
									path=path.substr(0,extenIndex)+".png";
								formatSubUrl=URL.formatURL(path,materialBasePath);
								(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
								urls.push({url:formatSubUrl,params:tex.params});
								urlMap[path]=formatSubUrl;
							}
						}
						break ;
					default :
						throw new Error("Laya3D:unkonwn version.");
					}
				}else {
				var diffuseTexture=customProps.diffuseTexture.texture2D;
				if (diffuseTexture){
					formatSubUrl=Laya3D._getMaterialTexturePath(diffuseTexture,urlVersion,materialBasePath);
					urls.push(formatSubUrl);
					urlMap[diffuseTexture]=formatSubUrl;
				}
				if (customProps.normalTexture){
					var normalTexture=customProps.normalTexture.texture2D;
					if (normalTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(normalTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[normalTexture]=formatSubUrl;
					}
				}
				if (customProps.specularTexture){
					var specularTexture=customProps.specularTexture.texture2D;
					if (specularTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(specularTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[specularTexture]=formatSubUrl;
					}
				}
				if (customProps.emissiveTexture){
					var emissiveTexture=customProps.emissiveTexture.texture2D;
					if (emissiveTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(emissiveTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[emissiveTexture]=formatSubUrl;
					}
				}
				if (customProps.ambientTexture){
					var ambientTexture=customProps.ambientTexture.texture2D;
					if (ambientTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(ambientTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[ambientTexture]=formatSubUrl;
					}
				}
				if (customProps.reflectTexture){
					var reflectTexture=customProps.reflectTexture.texture2D;
					if (reflectTexture){
						formatSubUrl=Laya3D._getMaterialTexturePath(reflectTexture,urlVersion,materialBasePath);
						urls.push(formatSubUrl);
						urlMap[reflectTexture]=formatSubUrl;
					}
				}
			};
			var urlCount=urls.length;
			var totalProcessCount=urlCount+1;
			var lmatWeight=1 / totalProcessCount;
			Laya3D._onProcessChange(loader,0,lmatWeight,1.0);
			if (urlCount > 0){
				var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,lmatWeight,urlCount / totalProcessCount],false);
				Laya3D._innerFourthLevelLoaderManager.create(urls,Handler.create(null,Laya3D._onMateialTexturesLoaded,[loader,processHandler,lmatData,urlMap]),processHandler,Texture2D,null,1,true,group);
				}else {
				Laya3D._onMateialTexturesLoaded(loader,null,lmatData,null);
			}
		}
	}

	Laya3D._onMateialTexturesLoaded=function(loader,processHandler,lmatData,urlMap){
		loader.endLoad([lmatData,urlMap]);
		(processHandler)&& (processHandler.recover());
	}

	Laya3D._loadTextureCube=function(loader){
		loader.on("loaded",null,Laya3D._onTextureCubeLtcLoaded,[loader]);
		loader.load(loader.url,"json",false,null,true);
	}

	Laya3D._onTextureCubeLtcLoaded=function(loader,ltcData){
		if (loader._class.destroyed){
			loader.endLoad();
			}else {
			var ltcBasePath=URL.getPath(URL.formatURL(loader.url));
			var urls=[URL.formatURL(ltcData.px,ltcBasePath),URL.formatURL(ltcData.nx,ltcBasePath),URL.formatURL(ltcData.py,ltcBasePath),URL.formatURL(ltcData.ny,ltcBasePath),URL.formatURL(ltcData.pz,ltcBasePath),URL.formatURL(ltcData.nz,ltcBasePath)];
			var ltcWeight=1.0 / 7.0;
			Laya3D._onProcessChange(loader,0,ltcWeight,1.0);
			var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,ltcWeight,6 / 7],false);
			Laya3D._innerFourthLevelLoaderManager.load(urls,Handler.create(null,Laya3D._onTextureCubeImagesLoaded,[loader,urls,processHandler]),processHandler,"nativeimage");
		}
	}

	Laya3D._onTextureCubeImagesLoaded=function(loader,urls,processHandler){
		var images=[];
		images.length=6;
		for (var i=0;i < 6;i++){
			var url=urls[i];
			images[i]=Loader.getRes(url);
			Loader.clearRes(url);
		}
		loader.endLoad(images);
		processHandler.recover();
	}

	Laya3D._onProcessChange=function(loader,offset,weight,process){
		process=offset+process *weight;
		(process < 1.0)&& (loader.event("progress",process));
	}

	Laya3D.init=function(width,height,antialias,alpha,premultipliedAlpha,stencil){
		(antialias===void 0)&& (antialias=false);
		(alpha===void 0)&& (alpha=false);
		(premultipliedAlpha===void 0)&& (premultipliedAlpha=true);
		(stencil===void 0)&& (stencil=true);
		RunDriver.update3DLoop=function (){
			CollisionManager._triggerCollision();
		}
		Config.isAntialias=antialias;
		Config.isAlpha=alpha;
		Config.premultipliedAlpha=premultipliedAlpha;
		Config.isStencil=stencil;
		if (!Render.isConchNode && !WebGL.enable()){
			alert("Laya3D init error,must support webGL!");
			return;
		}
		RunDriver.changeWebGLSize=Laya3D._changeWebGLSize;
		Render.is3DMode=true;
		Laya.init(width,height);
		Layer.__init__();
		Physics.__init__();
		ShaderInit3D.__init__();
		MeshSprite3D.__init__();
		AnimationNode.__init__();
		Laya3D.__init__();
		AtlasResourceManager.maxTextureCount=2;
		if (Laya3D.debugMode || OctreeNode.debugMode)
			Laya3D._debugPhasorSprite=new PhasorSpriter3D();
	}

	Laya3D.HIERARCHY="SPRITE3DHIERARCHY";
	Laya3D.MESH="MESH";
	Laya3D.MATERIAL="MATERIAL";
	Laya3D.PBRMATERIAL="PBRMTL";
	Laya3D.TEXTURECUBE="TEXTURECUBE";
	Laya3D.TERRAIN="TERRAIN";
	Laya3D._readData=null;
	Laya3D._debugPhasorSprite=null;
	Laya3D.debugMode=false;
	__static(Laya3D,
	['_DATA',function(){return this._DATA={offset:0,size:0};},'_strings',function(){return this._strings=['BLOCK','DATA',"STRINGS"];},'_innerFirstLevelLoaderManager',function(){return this._innerFirstLevelLoaderManager=new LoaderManager();},'_innerSecondLevelLoaderManager',function(){return this._innerSecondLevelLoaderManager=new LoaderManager();},'_innerThirdLevelLoaderManager',function(){return this._innerThirdLevelLoaderManager=new LoaderManager();},'_innerFourthLevelLoaderManager',function(){return this._innerFourthLevelLoaderManager=new LoaderManager();}
	]);
	return Laya3D;
})()


/**
*<code>LayoutStyle</code> 是一个布局样式类。
*/
//class laya.ui.LayoutStyle
var LayoutStyle=(function(){
	function LayoutStyle(){
		/**一个布尔值，表示是否有效。*/
		this.enable=false;
		this.top=NaN;
		this.bottom=NaN;
		this.left=NaN;
		this.right=NaN;
		this.centerX=NaN;
		this.centerY=NaN;
		this.anchorX=NaN;
		this.anchorY=NaN;
	}

	__class(LayoutStyle,'laya.ui.LayoutStyle');
	__static(LayoutStyle,
	['EMPTY',function(){return this.EMPTY=new LayoutStyle();}
	]);
	return LayoutStyle;
})()


/**
*<code>Styles</code> 定义了组件常用的样式属性。
*/
//class laya.ui.Styles
var Styles=(function(){
	function Styles(){}
	__class(Styles,'laya.ui.Styles');
	Styles.labelColor="#000000";
	Styles.buttonStateNum=3;
	Styles.scrollBarMinNum=15;
	Styles.scrollBarDelayTime=500;
	__static(Styles,
	['defaultSizeGrid',function(){return this.defaultSizeGrid=[4,4,4,4,0];},'labelPadding',function(){return this.labelPadding=[2,2,2,2];},'inputLabelPadding',function(){return this.inputLabelPadding=[1,1,1,3];},'buttonLabelColors',function(){return this.buttonLabelColors=["#32556b","#32cc6b","#ff0000","#C0C0C0"];},'comboBoxItemColors',function(){return this.comboBoxItemColors=["#5e95b6","#ffffff","#000000","#8fa4b1","#ffffff"];}
	]);
	return Styles;
})()


/**
*<code>UIUtils</code> 是文本工具集。
*/
//class laya.ui.UIUtils
var UIUtils=(function(){
	function UIUtils(){}
	__class(UIUtils,'laya.ui.UIUtils');
	UIUtils.fillArray=function(arr,str,type){
		var temp=arr.concat();
		if (str){
			var a=str.split(",");
			for (var i=0,n=Math.min(temp.length,a.length);i < n;i++){
				var value=a[i];
				temp[i]=(value=="true" ? true :(value=="false" ? false :value));
				if (type !=null)temp[i]=type(value);
			}
		}
		return temp;
	}

	UIUtils.toColor=function(color){
		return Utils.toHexColor(color);
	}

	UIUtils.gray=function(traget,isGray){
		(isGray===void 0)&& (isGray=true);
		if (isGray){
			UIUtils.addFilter(traget,UIUtils.grayFilter);
			}else {
			UIUtils.clearFilter(traget,ColorFilter);
		}
	}

	UIUtils.addFilter=function(target,filter){
		var filters=target.filters || [];
		filters.push(filter);
		target.filters=filters;
	}

	UIUtils.clearFilter=function(target,filterType){
		var filters=target.filters;
		if (filters !=null && filters.length > 0){
			for (var i=filters.length-1;i >-1;i--){
				var filter=filters[i];
				if (Laya.__typeof(filter,filterType))filters.splice(i,1);
			}
			target.filters=filters;
		}
	}

	UIUtils._getReplaceStr=function(word){
		return UIUtils.escapeSequence[word];
	}

	UIUtils.adptString=function(str){
		return str.replace(/\\(\w)/g,UIUtils._getReplaceStr);
	}

	UIUtils.getBindFun=function(value){
		var fun=UIUtils._funMap.get(value);
		if (fun==null){
			var temp="\""+value+"\"";
			temp=temp.replace(/^"\${|}"$/g,"").replace(/\${/g,"\"+").replace(/}/g,"+\"");
			var str="(function(data){if(data==null)return;with(data){try{\nreturn "+temp+"\n}catch(e){}}})";
			fun=Browser.window.eval(str);
			UIUtils._funMap.set(value,fun);
		}
		return fun;
	}

	__static(UIUtils,
	['grayFilter',function(){return this.grayFilter=new ColorFilter([0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0,0,0,1,0]);},'escapeSequence',function(){return this.escapeSequence={"\\n":"\n","\\t":"\t"};},'_funMap',function(){return this._funMap=new WeakObject();}
	]);
	return UIUtils;
})()


//class laya.filters.webgl.FilterActionGL
var FilterActionGL=(function(){
	function FilterActionGL(){}
	__class(FilterActionGL,'laya.filters.webgl.FilterActionGL');
	var __proto=FilterActionGL.prototype;
	Laya.imps(__proto,{"laya.filters.IFilterActionGL":true})
	__proto.setValue=function(shader){}
	__proto.setValueMix=function(shader){}
	__proto.apply3d=function(scope,sprite,context,x,y){return null;}
	__proto.apply=function(srcCanvas){return null;}
	__getset(0,__proto,'typeMix',function(){
		return 0;
	});

	return FilterActionGL;
})()


//class laya.webgl.atlas.AtlasGrid
var AtlasGrid=(function(){
	var TexRowInfo,TexMergeTexSize;
	function AtlasGrid(width,height,atlasID){
		this._atlasID=0;
		this._width=0;
		this._height=0;
		this._texCount=0;
		this._rowInfo=null;
		this._cells=null;
		this._failSize=new TexMergeTexSize();
		(width===void 0)&& (width=0);
		(height===void 0)&& (height=0);
		(atlasID===void 0)&& (atlasID=0);
		this._cells=null;
		this._rowInfo=null;
		this._init(width,height);
		this._atlasID=atlasID;
	}

	__class(AtlasGrid,'laya.webgl.atlas.AtlasGrid');
	var __proto=AtlasGrid.prototype;
	//------------------------------------------------------------------------------
	__proto.getAltasID=function(){
		return this._atlasID;
	}

	//------------------------------------------------------------------------------
	__proto.setAltasID=function(atlasID){
		if (atlasID >=0){
			this._atlasID=atlasID;
		}
	}

	//------------------------------------------------------------------
	__proto.addTex=function(type,width,height){
		var result=this._get(width,height);
		if (result.ret==false){
			return result;
		}
		this._fill(result.x,result.y,width,height,type);
		this._texCount++;
		return result;
	}

	//------------------------------------------------------------------------------
	__proto._release=function(){
		if (this._cells !=null){
			this._cells.length=0;
			this._cells=null;
		}
		if (this._rowInfo){
			this._rowInfo.length=0;
			this._rowInfo=null;
		}
	}

	//------------------------------------------------------------------------------
	__proto._init=function(width,height){
		this._width=width;
		this._height=height;
		this._release();
		if (this._width==0)return false;
		this._cells=new Uint8Array(this._width *this._height*3);
		this._rowInfo=__newvec(this._height);
		for (var i=0;i < this._height;i++){
			this._rowInfo[i]=new TexRowInfo();
		}
		this._clear();
		return true;
	}

	//------------------------------------------------------------------
	__proto._get=function(width,height){
		var pFillInfo=new MergeFillInfo();
		if (width >=this._failSize.width && height >=this._failSize.height){
			return pFillInfo;
		};
		var rx=-1;
		var ry=-1;
		var nWidth=this._width;
		var nHeight=this._height;
		var pCellBox=this._cells;
		for (var y=0;y < nHeight;y++){
			if (this._rowInfo[y].spaceCount < width)continue ;
			for (var x=0;x < nWidth;){
				var tm=(y *nWidth+x)*3;
				if (pCellBox[tm] !=0 || pCellBox[tm+1] < width || pCellBox[tm+2] < height){
					x+=pCellBox[tm+1];
					continue ;
				}
				rx=x;
				ry=y;
				for (var xx=0;xx < width;xx++){
					if (pCellBox[3*xx+tm+2] < height){
						rx=-1;
						break ;
					}
				}
				if (rx < 0){
					x+=pCellBox[tm+1];
					continue ;
				}
				pFillInfo.ret=true;
				pFillInfo.x=rx;
				pFillInfo.y=ry;
				return pFillInfo;
			}
		}
		return pFillInfo;
	}

	//------------------------------------------------------------------
	__proto._fill=function(x,y,w,h,type){
		var nWidth=this._width;
		var nHeghit=this._height;
		this._check((x+w)<=nWidth && (y+h)<=nHeghit);
		for (var yy=y;yy < (h+y);++yy){
			this._check(this._rowInfo[yy].spaceCount >=w);
			this._rowInfo[yy].spaceCount-=w;
			for (var xx=0;xx < w;xx++){
				var tm=(x+yy *nWidth+xx)*3;
				this._check(this._cells[tm]==0);
				this._cells[tm]=type;
				this._cells[tm+1]=w;
				this._cells[tm+2]=h;
			}
		}
		if (x > 0){
			for (yy=0;yy < h;++yy){
				var s=0;
				for (xx=x-1;xx >=0;--xx,++s){
					if (this._cells[((y+yy)*nWidth+xx)*3] !=0)break ;
				}
				for (xx=s;xx > 0;--xx){
					this._cells[((y+yy)*nWidth+x-xx)*3+1]=xx;
					this._check(xx > 0);
				}
			}
		}
		if (y > 0){
			for (xx=x;xx < (x+w);++xx){
				s=0;
				for (yy=y-1;yy >=0;--yy,s++){
					if (this._cells[(xx+yy *nWidth)*3] !=0)break ;
				}
				for (yy=s;yy > 0;--yy){
					this._cells[(xx+(y-yy)*nWidth)*3+2]=yy;
					this._check(yy > 0);
				}
			}
		}
	}

	__proto._check=function(ret){
		if (ret==false){
			console.log("xtexMerger 错误啦");
		}
	}

	//------------------------------------------------------------------
	__proto._clear=function(){
		this._texCount=0;
		for (var y=0;y < this._height;y++){
			this._rowInfo[y].spaceCount=this._width;
		}
		for (var i=0;i < this._height;i++){
			for (var j=0;j < this._width;j++){
				var tm=(i *this._width+j)*3;
				this._cells[tm]=0;
				this._cells[tm+1]=this._width-j;
				this._cells[tm+2]=this._width-i;
			}
		}
		this._failSize.width=this._width+1;
		this._failSize.height=this._height+1;
	}

	AtlasGrid.__init$=function(){
		//------------------------------------------------------------------------------
		//class TexRowInfo
		TexRowInfo=(function(){
			function TexRowInfo(){
				this.spaceCount=0;
			}
			__class(TexRowInfo,'');
			return TexRowInfo;
		})()
		//------------------------------------------------------------------------------
		//class TexMergeTexSize
		TexMergeTexSize=(function(){
			function TexMergeTexSize(){
				this.width=0;
				this.height=0;
			}
			__class(TexMergeTexSize,'');
			return TexMergeTexSize;
		})()
	}

	return AtlasGrid;
})()


//class laya.webgl.atlas.AtlasResourceManager
var AtlasResourceManager=(function(){
	function AtlasResourceManager(width,height,gridSize,maxTexNum){
		this._currentAtlasCount=0;
		this._maxAtlaserCount=0;
		this._width=0;
		this._height=0;
		this._gridSize=0;
		this._gridNumX=0;
		this._gridNumY=0;
		this._init=false;
		this._curAtlasIndex=0;
		this._setAtlasParam=false;
		this._atlaserArray=null;
		this._needGC=false;
		this._setAtlasParam=true;
		this._width=width;
		this._height=height;
		this._gridSize=gridSize;
		this._maxAtlaserCount=maxTexNum;
		this._gridNumX=width / gridSize;
		this._gridNumY=height / gridSize;
		this._curAtlasIndex=0;
		this._atlaserArray=[];
	}

	__class(AtlasResourceManager,'laya.webgl.atlas.AtlasResourceManager');
	var __proto=AtlasResourceManager.prototype;
	__proto.setAtlasParam=function(width,height,gridSize,maxTexNum){
		if (this._setAtlasParam==true){
			AtlasResourceManager._sid_=0;
			this._width=width;
			this._height=height;
			this._gridSize=gridSize;
			this._maxAtlaserCount=maxTexNum;
			this._gridNumX=width / gridSize;
			this._gridNumY=height / gridSize;
			this._curAtlasIndex=0;
			this.freeAll();
			return true;
			}else {
			console.log("设置大图合集参数错误，只能在开始页面设置各种参数");
			throw-1;
			return false;
		}
		return false;
	}

	//添加 图片到大图集
	__proto.pushData=function(texture){
		var bitmap=texture.bitmap;
		var nWebGLImageIndex=-1;
		var curAtlas=null;
		var i=0,n=0,altasIndex=0;
		for (i=0,n=this._atlaserArray.length;i < n;i++){
			altasIndex=(this._curAtlasIndex+i)% n;
			curAtlas=this._atlaserArray[altasIndex];
			nWebGLImageIndex=curAtlas.findBitmapIsExist(bitmap);
			if (nWebGLImageIndex !=-1){
				break ;
			}
		}
		if (nWebGLImageIndex !=-1){
			var offset=curAtlas.InAtlasWebGLImagesOffsetValue[nWebGLImageIndex];
			offsetX=offset[0];
			offsetY=offset[1];
			curAtlas.addToAtlas(texture,offsetX,offsetY);
			return true;
			}else {
			var tex=texture;
			this._setAtlasParam=false;
			var bFound=false;
			var nImageGridX=(Math.ceil((texture.bitmap.width+2)/ this._gridSize));
			var nImageGridY=(Math.ceil((texture.bitmap.height+2)/ this._gridSize));
			var bSuccess=false;
			for (var k=0;k < 2;k++){
				var maxAtlaserCount=this._maxAtlaserCount;
				for (i=0;i < maxAtlaserCount;i++){
					altasIndex=(this._curAtlasIndex+i)% maxAtlaserCount;
					(this._atlaserArray.length-1 >=altasIndex)|| (this._atlaserArray.push(new Atlaser(this._gridNumX,this._gridNumY,this._width,this._height,AtlasResourceManager._sid_++)));
					var atlas=this._atlaserArray[altasIndex];
					var offsetX=0,offsetY=0;
					var fillInfo=atlas.addTex(1,nImageGridX,nImageGridY);
					if (fillInfo.ret){
						offsetX=fillInfo.x *this._gridSize+1;
						offsetY=fillInfo.y *this._gridSize+1;
						bitmap.lock=true;
						atlas.addToAtlasTexture((bitmap),offsetX,offsetY);
						atlas.addToAtlas(texture,offsetX,offsetY);
						bSuccess=true;
						this._curAtlasIndex=altasIndex;
						break ;
					}
				}
				if (bSuccess)
					break ;
				this._atlaserArray.push(new Atlaser(this._gridNumX,this._gridNumY,this._width,this._height,AtlasResourceManager._sid_++));
				this._needGC=true;
				this.garbageCollection();
				this._curAtlasIndex=this._atlaserArray.length-1;
			}
			if (!bSuccess){
				console.log(">>>AtlasManager pushData error");
			}
			return bSuccess;
		}
	}

	__proto.addToAtlas=function(tex){
		laya.webgl.atlas.AtlasResourceManager.instance.pushData(tex);
	}

	/**
	*回收大图合集,不建议手动调用
	*@return
	*/
	__proto.garbageCollection=function(){
		if (this._needGC===true){
			var n=this._atlaserArray.length-this._maxAtlaserCount;
			for (var i=0;i < n;i++){
				this._atlaserArray[i].dispose();
				console.log("AtlasResourceManager:Dispose the inner Atlas。");
			}
			console.log(">>>>altas garbageCollection ="+n);
			this._atlaserArray.splice(0,n);
			this._needGC=false;
		}
		return true;
	}

	__proto.freeAll=function(){
		for (var i=0,n=this._atlaserArray.length;i < n;i++){
			this._atlaserArray[i].dispose();
		}
		this._atlaserArray.length=0;
		this._curAtlasIndex=0;
	}

	__proto.getAtlaserCount=function(){
		return this._atlaserArray.length;
	}

	__proto.getAtlaserByIndex=function(index){
		return this._atlaserArray[index];
	}

	__getset(1,AtlasResourceManager,'instance',function(){
		if (!AtlasResourceManager._Instance){
			AtlasResourceManager._Instance=new AtlasResourceManager(laya.webgl.atlas.AtlasResourceManager.atlasTextureWidth,laya.webgl.atlas.AtlasResourceManager.atlasTextureHeight,16,laya.webgl.atlas.AtlasResourceManager.maxTextureCount);
		}
		return AtlasResourceManager._Instance;
	});

	__getset(1,AtlasResourceManager,'enabled',function(){
		return Config.atlasEnable;
	});

	__getset(1,AtlasResourceManager,'atlasLimitWidth',function(){
		return AtlasResourceManager._atlasLimitWidth;
		},function(value){
		AtlasResourceManager._atlasLimitWidth=value;
	});

	__getset(1,AtlasResourceManager,'atlasLimitHeight',function(){
		return AtlasResourceManager._atlasLimitHeight;
		},function(value){
		AtlasResourceManager._atlasLimitHeight=value;
	});

	AtlasResourceManager._enable=function(){
		Config.atlasEnable=true;
	}

	AtlasResourceManager._disable=function(){
		Config.atlasEnable=false;
	}

	AtlasResourceManager.__init__=function(){
		AtlasResourceManager.atlasTextureWidth=2048;
		AtlasResourceManager.atlasTextureHeight=2048;
		AtlasResourceManager.maxTextureCount=6;
		AtlasResourceManager.atlasLimitWidth=512;
		AtlasResourceManager.atlasLimitHeight=512;
	}

	AtlasResourceManager._atlasLimitWidth=0;
	AtlasResourceManager._atlasLimitHeight=0;
	AtlasResourceManager.gridSize=16;
	AtlasResourceManager.atlasTextureWidth=0;
	AtlasResourceManager.atlasTextureHeight=0;
	AtlasResourceManager.maxTextureCount=0;
	AtlasResourceManager._atlasRestore=0;
	AtlasResourceManager.BOARDER_TYPE_NO=0;
	AtlasResourceManager.BOARDER_TYPE_RIGHT=1;
	AtlasResourceManager.BOARDER_TYPE_LEFT=2;
	AtlasResourceManager.BOARDER_TYPE_BOTTOM=4;
	AtlasResourceManager.BOARDER_TYPE_TOP=8;
	AtlasResourceManager.BOARDER_TYPE_ALL=15;
	AtlasResourceManager._sid_=0;
	AtlasResourceManager._Instance=null;
	return AtlasResourceManager;
})()


//class laya.webgl.atlas.MergeFillInfo
var MergeFillInfo=(function(){
	function MergeFillInfo(){
		this.x=0;
		this.y=0;
		this.ret=false;
		this.ret=false;
		this.x=0;
		this.y=0;
	}

	__class(MergeFillInfo,'laya.webgl.atlas.MergeFillInfo');
	return MergeFillInfo;
})()


;
//class laya.webgl.canvas.BlendMode
var BlendMode=(function(){
	function BlendMode(){}
	__class(BlendMode,'laya.webgl.canvas.BlendMode');
	BlendMode._init_=function(gl){
		BlendMode.fns=[BlendMode.BlendNormal,BlendMode.BlendAdd,BlendMode.BlendMultiply,BlendMode.BlendScreen,BlendMode.BlendOverlay,BlendMode.BlendLight,BlendMode.BlendMask,BlendMode.BlendDestinationOut];
		BlendMode.targetFns=[BlendMode.BlendNormalTarget,BlendMode.BlendAddTarget,BlendMode.BlendMultiplyTarget,BlendMode.BlendScreenTarget,BlendMode.BlendOverlayTarget,BlendMode.BlendLightTarget,BlendMode.BlendMask,BlendMode.BlendDestinationOut];
	}

	BlendMode.BlendNormal=function(gl){
		gl.blendFunc(1,0x0303);
	}

	BlendMode.BlendAdd=function(gl){
		gl.blendFunc(1,0x0304);
	}

	BlendMode.BlendMultiply=function(gl){
		gl.blendFunc(0x0306,0x0303);
	}

	BlendMode.BlendScreen=function(gl){
		gl.blendFunc(1,1);
	}

	BlendMode.BlendOverlay=function(gl){
		gl.blendFunc(1,0x0301);
	}

	BlendMode.BlendLight=function(gl){
		gl.blendFunc(1,1);
	}

	BlendMode.BlendNormalTarget=function(gl){
		gl.blendFunc(1,0x0303);
	}

	BlendMode.BlendAddTarget=function(gl){
		gl.blendFunc(1,0x0304);
	}

	BlendMode.BlendMultiplyTarget=function(gl){
		gl.blendFunc(0x0306,0x0303);
	}

	BlendMode.BlendScreenTarget=function(gl){
		gl.blendFunc(1,1);
	}

	BlendMode.BlendOverlayTarget=function(gl){
		gl.blendFunc(1,0x0301);
	}

	BlendMode.BlendLightTarget=function(gl){
		gl.blendFunc(1,1);
	}

	BlendMode.BlendMask=function(gl){
		gl.blendFunc(0,0x0302);
	}

	BlendMode.BlendDestinationOut=function(gl){
		gl.blendFunc(0,0);
	}

	BlendMode.activeBlendFunction=null;
	BlendMode.NORMAL="normal";
	BlendMode.ADD="add";
	BlendMode.MULTIPLY="multiply";
	BlendMode.SCREEN="screen";
	BlendMode.LIGHT="light";
	BlendMode.OVERLAY="overlay";
	BlendMode.DESTINATIONOUT="destination-out";
	BlendMode.fns=[];
	BlendMode.targetFns=[];
	__static(BlendMode,
	['NAMES',function(){return this.NAMES=["normal","add","multiply","screen","overlay","light","mask","destination-out"];},'TOINT',function(){return this.TOINT={"normal":0,"add":1,"multiply":2,"screen":3 ,"lighter":1,"overlay":4,"light":5,"mask":6,"destination-out":7};}
	]);
	return BlendMode;
})()


//class laya.webgl.canvas.DrawStyle
var DrawStyle=(function(){
	function DrawStyle(value){
		this._color=Color.create("black");
		this.setValue(value);
	}

	__class(DrawStyle,'laya.webgl.canvas.DrawStyle');
	var __proto=DrawStyle.prototype;
	__proto.setValue=function(value){
		if (value){
			if ((typeof value=='string')){
				this._color=Color.create(value);
				return;
			}
			if ((value instanceof laya.utils.Color )){
				this._color=value;
				return;
			}
		}
	}

	__proto.reset=function(){
		this._color=Color.create("black");
	}

	__proto.equal=function(value){
		if ((typeof value=='string'))return this._color.strColor===value;
		if ((value instanceof laya.utils.Color ))return this._color.numColor===(value).numColor;
		return false;
	}

	__proto.toColorStr=function(){
		return this._color.strColor;
	}

	DrawStyle.create=function(value){
		if (value){
			var color;
			if ((typeof value=='string'))color=Color.create(value);
			else if ((value instanceof laya.utils.Color ))color=value;
			if (color){
				return color._drawStyle || (color._drawStyle=new DrawStyle(value));
			}
		}
		return null;
	}

	__static(DrawStyle,
	['DEFAULT',function(){return this.DEFAULT=new DrawStyle("#000000");}
	]);
	return DrawStyle;
})()


//class laya.webgl.canvas.Path
var Path=(function(){
	function Path(){
		this._x=0;
		this._y=0;
		//this._rect=null;
		//this.ib=null;
		//this.vb=null;
		this.dirty=false;
		//this.geomatrys=null;
		//this._curGeomatry=null;
		this.offset=0;
		this.count=0;
		this.geoStart=0;
		this.tempArray=[];
		this.closePath=false;
		this.geomatrys=[];
		var gl=WebGL.mainContext;
		this.ib=IndexBuffer2D.create(0x88E8);
		this.vb=VertexBuffer2D.create(5);
	}

	__class(Path,'laya.webgl.canvas.Path');
	var __proto=Path.prototype;
	__proto.addPoint=function(pointX,pointY){
		this.tempArray.push(pointX,pointY);
	}

	__proto.getEndPointX=function(){
		return this.tempArray[this.tempArray.length-2];
	}

	__proto.getEndPointY=function(){
		return this.tempArray[this.tempArray.length-1];
	}

	__proto.polygon=function(x,y,points,color,borderWidth,borderColor){
		var geo;
		this.geomatrys.push(this._curGeomatry=geo=new Polygon(x,y,points,color,borderWidth,borderColor));
		if (!color)geo.fill=false;
		if (borderColor==undefined)geo.borderWidth=0;
		return geo;
	}

	__proto.setGeomtry=function(shape){
		this.geomatrys.push(this._curGeomatry=shape);
	}

	__proto.drawLine=function(x,y,points,width,color){
		var geo;
		if (this.closePath){
			this.geomatrys.push(this._curGeomatry=geo=new LoopLine(x,y,points,width,color));
			}else {
			this.geomatrys.push(this._curGeomatry=geo=new Line(x,y,points,width,color));
		}
		geo.fill=false;
		return geo;
	}

	__proto.update=function(){
		var si=this.ib._byteLength;
		var len=this.geomatrys.length;
		this.offset=si;
		for (var i=this.geoStart;i < len;i++){
			this.geomatrys[i].getData(this.ib,this.vb,this.vb._byteLength / 20);
		}
		this.geoStart=len;
		this.count=(this.ib._byteLength-si)/ CONST3D2D.BYTES_PIDX;
	}

	__proto.reset=function(){
		this.vb.clear();
		this.ib.clear();
		this.offset=this.count=this.geoStart=0;
		this.geomatrys.length=0;
	}

	__proto.recover=function(){
		this._curGeomatry=null;
		this.vb.destory();
		this.vb=null;
		this.ib.destory();
		this.ib=null;
	}

	return Path;
})()


//class laya.webgl.canvas.save.SaveBase
var SaveBase=(function(){
	function SaveBase(){
		//this._valueName=null;
		//this._value=null;
		//this._dataObj=null;
		//this._newSubmit=false;
	}

	__class(SaveBase,'laya.webgl.canvas.save.SaveBase');
	var __proto=SaveBase.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){return false;}
	__proto.restore=function(context){
		this._dataObj[this._valueName]=this._value;
		SaveBase._cache[SaveBase._cache._length++]=this;
		this._newSubmit && (context._curSubmit=Submit.RENDERBASE,context._renderKey=0);
	}

	SaveBase._createArray=function(){
		var value=[];
		value._length=0;
		return value;
	}

	SaveBase._init=function(){
		var namemap=SaveBase._namemap={};
		namemap[0x1]="ALPHA";
		namemap[0x2]="fillStyle";
		namemap[0x8]="font";
		namemap[0x100]="lineWidth";
		namemap[0x200]="strokeStyle";
		namemap[0x2000]="_mergeID";
		namemap[0x400]=namemap[0x800]=namemap[0x1000]=[];
		namemap[0x4000]="textBaseline";
		namemap[0x8000]="textAlign";
		namemap[0x10000]="_nBlendType";
		namemap[0x100000]="shader";
		namemap[0x200000]="filters";
		return namemap;
	}

	SaveBase.save=function(context,type,dataObj,newSubmit){
		if ((context._saveMark._saveuse & type)!==type){
			context._saveMark._saveuse |=type;
			var cache=SaveBase._cache;
			var o=cache._length > 0 ? cache[--cache._length] :(new SaveBase());
			o._value=dataObj[o._valueName=SaveBase._namemap[type]];
			o._dataObj=dataObj;
			o._newSubmit=newSubmit;
			var _save=context._save;
			_save[_save._length++]=o;
		}
	}

	__static(SaveBase,
	['_cache',function(){return this._cache=laya.webgl.canvas.save.SaveBase._createArray();},'_namemap',function(){return this._namemap=SaveBase._init();}
	]);
	return SaveBase;
})()


//class laya.webgl.canvas.save.SaveClipRect
var SaveClipRect=(function(){
	function SaveClipRect(){
		//this._clipSaveRect=null;
		//this._submitScissor=null;
		this._clipRect=new Rectangle();
	}

	__class(SaveClipRect,'laya.webgl.canvas.save.SaveClipRect');
	var __proto=SaveClipRect.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){return false;}
	__proto.restore=function(context){
		context._clipRect=this._clipSaveRect;
		SaveClipRect._cache[SaveClipRect._cache._length++]=this;
		this._submitScissor.submitLength=context._submits._length-this._submitScissor.submitIndex;
		context._curSubmit=Submit.RENDERBASE;
		context._renderKey=0;
	}

	SaveClipRect.save=function(context,submitScissor){
		if ((context._saveMark._saveuse & 0x20000)==0x20000)return;
		context._saveMark._saveuse |=0x20000;
		var cache=SaveClipRect._cache;
		var o=cache._length > 0 ? cache[--cache._length] :(new SaveClipRect());
		o._clipSaveRect=context._clipRect;
		context._clipRect=o._clipRect.copyFrom(context._clipRect);
		o._submitScissor=submitScissor;
		var _save=context._save;
		_save[_save._length++]=o;
	}

	__static(SaveClipRect,
	['_cache',function(){return this._cache=SaveBase._createArray();}
	]);
	return SaveClipRect;
})()


//class laya.webgl.canvas.save.SaveClipRectStencil
var SaveClipRectStencil=(function(){
	function SaveClipRectStencil(){
		//this._clipSaveRect=null;
		//this._saveMatrix=null;
		this._contextX=0;
		this._contextY=0;
		//this._submitStencil=null;
		this._clipRect=new Rectangle();
		this._rect=new Rectangle();
		this._matrix=new Matrix();
	}

	__class(SaveClipRectStencil,'laya.webgl.canvas.save.SaveClipRectStencil');
	var __proto=SaveClipRectStencil.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){return false;}
	__proto.restore=function(context){
		SubmitStencil.restore(context,this._rect,this._saveMatrix,this._contextX,this._contextY);
		context._clipRect=this._clipSaveRect;
		context._curMat=this._saveMatrix;
		context._x=this._contextX;
		context._y=this._contextY;
		SaveClipRectStencil._cache[SaveClipRectStencil._cache._length++]=this;
		context._curSubmit=Submit.RENDERBASE;
	}

	SaveClipRectStencil.save=function(context,submitStencil,x,y,width,height,clipX,clipY,clipWidth,clipHeight){
		if ((context._saveMark._saveuse & 0x40000)==0x40000)return;
		context._saveMark._saveuse |=0x40000;
		var cache=SaveClipRectStencil._cache;
		var o=cache._length > 0 ? cache[--cache._length] :(new SaveClipRectStencil());
		o._clipSaveRect=context._clipRect;
		o._clipRect.setTo(clipX,clipY,clipWidth,clipHeight);
		context._clipRect=o._clipRect;
		o._rect.x=x;
		o._rect.y=y;
		o._rect.width=width;
		o._rect.height=height;
		o._contextX=context._x;
		o._contextY=context._y;
		o._saveMatrix=context._curMat;
		context._curMat.copyTo(o._matrix);
		context._curMat=o._matrix;
		o._submitStencil=submitStencil;
		var _save=context._save;
		_save[_save._length++]=o;
	}

	__static(SaveClipRectStencil,
	['_cache',function(){return this._cache=SaveBase._createArray();}
	]);
	return SaveClipRectStencil;
})()


//class laya.webgl.canvas.save.SaveMark
var SaveMark=(function(){
	function SaveMark(){
		this._saveuse=0;
		//this._preSaveMark=null;
		;
	}

	__class(SaveMark,'laya.webgl.canvas.save.SaveMark');
	var __proto=SaveMark.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){
		return true;
	}

	__proto.restore=function(context){
		context._saveMark=this._preSaveMark;
		SaveMark._no[SaveMark._no._length++]=this;
	}

	SaveMark.Create=function(context){
		var no=SaveMark._no;
		var o=no._length > 0 ? no[--no._length] :(new SaveMark());
		o._saveuse=0;
		o._preSaveMark=context._saveMark;
		context._saveMark=o;
		return o;
	}

	__static(SaveMark,
	['_no',function(){return this._no=SaveBase._createArray();}
	]);
	return SaveMark;
})()


//class laya.webgl.canvas.save.SaveTransform
var SaveTransform=(function(){
	function SaveTransform(){
		//this._savematrix=null;
		this._matrix=new Matrix();
	}

	__class(SaveTransform,'laya.webgl.canvas.save.SaveTransform');
	var __proto=SaveTransform.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){return false;}
	__proto.restore=function(context){
		context._curMat=this._savematrix;
		SaveTransform._no[SaveTransform._no._length++]=this;
	}

	SaveTransform.save=function(context){
		var _saveMark=context._saveMark;
		if ((_saveMark._saveuse & 0x800)===0x800)return;
		_saveMark._saveuse |=0x800;
		var no=SaveTransform._no;
		var o=no._length > 0 ? no[--no._length] :(new SaveTransform());
		o._savematrix=context._curMat;
		context._curMat=context._curMat.copyTo(o._matrix);
		var _save=context._save;
		_save[_save._length++]=o;
	}

	__static(SaveTransform,
	['_no',function(){return this._no=SaveBase._createArray();}
	]);
	return SaveTransform;
})()


//class laya.webgl.canvas.save.SaveTranslate
var SaveTranslate=(function(){
	function SaveTranslate(){
		//this._x=NaN;
		//this._y=NaN;
	}

	__class(SaveTranslate,'laya.webgl.canvas.save.SaveTranslate');
	var __proto=SaveTranslate.prototype;
	Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
	__proto.isSaveMark=function(){return false;}
	__proto.restore=function(context){
		var mat=context._curMat;
		context._x=this._x;
		context._y=this._y;
		SaveTranslate._no[SaveTranslate._no._length++]=this;
	}

	SaveTranslate.save=function(context){
		var no=SaveTranslate._no;
		var o=no._length > 0 ? no[--no._length] :(new Sav