# Awesome Learning Resources

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/lauragift21/awesome-learning-resources) ![license](https://img.shields.io/github/license/mashape/apistatus.svg)

[Preview on the web](https://nicedoc.io/lauragift21/awesome-learning-resources)

## Table of Contents

- [Awesome Learning Resources](#awesome-learning-resources)
  - [Table of Contents](#table-of-contents)
  - [Agile](#agile)
  - [Android](#android)
  - [Angular](#angular)
  - [APEX](#apex)
  - [BASH](#bash)
  - [BOOTSTRAP](#bootstrap)
  - [C#](#c)
  - [Career](#career)
  - [CSS](#css)
  - [Computer Vision](#computer-vision)
  - [Data Science](#data-science)
  - [Deep Learning](#deep-learning)
  - [Developer Blog](#developer-blog)
  - [Developer Stories](#developer-stories)
  - [Django](#django)
  - [Elixir](#elixir)
  - [Flutter](#flutter)
  - [Flask](#flask)
  - [Git and GitHub](#git-and-github)
  - [Golang](#golang)
  - [GraphQL](#graphql)
  - [Hugo](#hugo)
  - [Hacking](#hacking)
  - [InfoSec](#infosec)
  - [Ionic](#ionic)
  - [JavaScript](#javascript)
  - [Java](#java)
  - [Kotlin](#kotlin)
  - [Laravel](#laravel)
  - [Machine Learning](#machine-learning)
  - [Malware Analysis](#malware-analysis)
  - [Markdown](#markdown)
  - [NodeJS](#nodejs)
  - [PHP](#php)
  - [PLSQL](#plsql)
  - [Podcasts](#podcasts)
  - [PWA](#pwa)
  - [Python](#python)
  - [ReactJS](#reactjs)
  - [React Native](#react-native)
  - [Ruby](#ruby)
  - [Ruby on Rails](#ruby-on-rails)
  - [Rust](#rust)
  - [Serverless](#serverless)
  - [Sick Picks](#sick-picks)
  - [Startups](#startups)
  - [Svelte](#svelte)
  - [Swift](#swift)
  - [TensorFlow](#tensorflow)
  - [Twilio](#twilio)
  - [Typescript](#typescript)
  - [Voice](#voice)
  - [Vue](#vue)
  - [Women in Tech](#women-in-tech)
  - [XML](#xml)

## Agile

- [Manifesto for Agile Software Development](https://agilemanifesto.org/)
- [Martin Fowler's website](https://martinfowler.com/)
- [Understanding the Agile methodology](https://linchpinseo.com/the-agile-method/)
- [Agile ceremonies](https://www.atlassian.com/agile/scrum/ceremonies)
- [Agile user stories](https://zepel.io/agile/user-stories/)
- [The Agile Idea](https://www.manning.com/books/the-agile-idea)

## Android

- [What is Android](https://www.android.com/what-is-android/)
- [Android 10](https://www.android.com/android-10/)
- [Android Open Source Project](https://source.android.com/)
- [Getting Started and be an Android Developer](https://developer.android.com/guide/slices/getting-started)
- [Introduction](https://developer.android.com/guide)
- [Build your first app](https://developer.android.com/training/basics/firstapp)
- [Whats New? AndroidX](https://developer.android.com/jetpack/androidx)
- [Migrate to AndroidX](https://developer.android.com/jetpack/androidx/migrate)
- [Learn Android](https://www.tutlane.com/tutorial/android)

## Angular

- [Official Angular Quickstart](https://angular.io/guide/quickstart)
- [Angular's Source Code](https://github.com/angular/angular) Maintained by Google
- [Angular Console](https://angularconsole.com/) A nifty UI for the Angular CLI
- [Angular Material](https://material.angular.io/) Angular implementation of Google's Material design
- [Sample Angular Starter App](https://github.com/duluca/lemon-mart)
- [John Papa's Blog](https://johnpapa.net/)
- [Angular2+ Version Upgrade Guide](https://update.angular.io/)
- [AngularJS to Angular2+ Migration Guide](https://angular.io/guide/upgrade)
- [Angular in Depth](https://indepth.dev/angular/)
- [NGRX](https://ngrx.io/)
- [DevProjects - Free Real-World Angular Projects](https://www.codementor.io/projects/angular)

## APEX

- [Ask TOM](https://asktom.oracle.com/pls/apex/f?p=100:1000::::::)
- [Oracle APEX Community](https://community.oracle.com/community/technology_network_community/database/developer-tools/application_express)
- [APEX World](https://apex.world/ords/f?p=APEX_WORLD:HOME)
- [Oracle LiveSQL](https://livesql.oracle.com/apex/livesql/file/index.html)
- [APEX Office Hours](https://asktom.oracle.com/pls/apex/f?p=100:551:::NO:551:P551_CLASS_ID:744:)
- [Maxime Tremblay's Blog](https://max-tremblay.blogspot.com/)
- [Explorer UK](https://explorer.uk.com/blog/)
- [Talk APEX](https://www.talkapex.com/)
- [Joel Kallman's Blog](https://joelkallman.blogspot.com/)
- [Oracle APEX Website](https://apex.oracle.com/)

## BASH

- [Bash Manual](https://www.gnu.org/savannah-checkouts/gnu/bash/manual/bash.html)
- [Bash Programming](https://tldp.org/HOWTO/Bash-Prog-Intro-HOWTO.html)
- [Shell Scripting MIT](https://missing.csail.mit.edu/2020/shell-tools/)
- [Shell Scripting Project-Based](https://www.udemy.com/course/linux-shell-scripting-projects/)
- [Practice Bash](https://www.hackerrank.com/domains/shell)

## BOOTSTRAP

- [W3Schools](https://www.w3schools.com/bootstrap4/)
- [Website Setup](https://websitesetup.org/bootstrap-tutorial-for-beginners/)
- [Bootstrapious](https://bootstrapious.com/blog)
- [Tutorials Point](https://www.tutorialspoint.com/bootstrap/index.htm)
- [Bootstrap Tutorial Series](https://github.com/SonarSystems/Bootstrap-4-Tutorial-Series)
- [Hackr.io](https://hackr.io/tutorials/learn-bootstrap)
- [Tabler](https://preview.tabler.io)
- [Bootstrap Tutorial - Tutlane](https://www.tutlane.com/tutorial/bootstrap)
- [Bootstrap 5 Cheat Sheet](https://bootstrap-cheatsheet.themeselection.com/)

## C#

- [Channel9](https://channel9.msdn.com/Series/CSharp-Fundamentals-for-Absolute-Beginners)
- [Eduonix](https://www.eduonix.com/courses/Software-Development/Learn-C-Sharp-Programming-From-Scratch)
- [Tutorials Point](https://www.tutorialspoint.com/csharp)
- [Zetcode](https://zetcode.com/lang/csharp/)
- [Tim Corey](https://www.youtube.com/channel/UC-ptWR16ITQyYOglXyQmpzw)
- [W3Schools](https://www.w3schools.com/cs/default.asp)
- [Tutlane](https://www.tutlane.com/tutorial/csharp)
- [Tiny C# Projects](https://www.manning.com/books/tiny-c-sharp-projects)

## Career

- [Career Paths in Tech](https://online.maryville.edu/online-bachelors-degrees/management-information-systems/careers/)

## CSS

- [Marksheet.io](https://marksheet.io/)
- [Mozilla Developer Network](https://developer.mozilla.org/en-US/docs/Web/CSS)
- [Codrops CSS Reference](https://tympanus.net/codrops/css_reference/)
- [W3Schools](https://www.w3schools.com/)
- [CSS Tricks](https://css-tricks.com)
- [10 great CSS animation resources](https://www.creativebloq.com/advice/5-great-css-animation-resources)
- [Chen's Blog](https://www.chenhuijing.com/)
- [Smashing Magazine](https://www.smashingmagazine.com/)
- [30 Sec of CSS](https://atomiks.github.io/30-seconds-of-css/)
- [CSS Reference](https://cssreference.io/)
- [CSS Grid by Wes Bos](https://cssgrid.io/)
- [CSS Flexbox by Wes Bos](https://flexbox.io/)
- [Alligator.IO CSS Page](https://alligator.io/css)
- [CSS Images](https://coding-artist.teachable.com/)
- [Learn CSS Layouts](https://learnlayout.com/)
- [Learn HTML & CSS](https://learn.shayhowe.com/)
- [Flexbox Froggy](https://flexboxfroggy.com/)
- [CSS Grid](https://cssgridgarden.com/)
- [CSS Flexbox - freeCodeCamp](https://learn.freecodecamp.org/responsive-web-design/css-flexbox/)
- [CSS Grid - freeCodeCamp](https://learn.freecodecamp.org/responsive-web-design/css-grid/)
- [CSS Testing - QuirksMode.org](https://www.quirksmode.org/css/)
- [Flexbox Froggy](https://flexboxfroggy.com/)
- [CSS Diner](https://flukeout.github.io/)
- [Pure CSS Loaders](https://loading.io/css/)
- [CSSBattle](https://cssbattle.dev/)

## Computer Vision

- [Udacity Introduction to Computer Vision](https://www.udacity.com/course/introduction-to-computer-vision--ud810)
- [A Gentle Introduction to Computer Vision](https://machinelearningmastery.com/what-is-computer-vision/)
- [Coursera Computer Vision Basics](https://www.coursera.org/learn/computer-vision-basics)
- [PyImageSearch Blog](https://www.pyimagesearch.com/)

## Data Science

- [DataCamp](https://www.datacamp.com/)
- [New Coder](https://newcoder.io/)
- [Data Analysis in Python with Pandas](https://www.youtube.com/playlist?list=PL5-da3qGB5ICCsgW1MxlZ0Hq8LL5U3u9y)
- [The Quartz Guide to Bad data](https://github.com/Quartz/bad-data-guide)
- [Analytics Vidhya](https://www.analyticsvidhya.com/blog/2019/01/learning-path-data-scientist-machine-learning-2019/)
- [Alison](https://alison.com/courses/data-science)
- [Automate the boring stuff with Python](https://automatetheboringstuff.com)
- [Sololearn](https://www.sololearn.com/Course/data-science/)
- [FreeCodeCamp](https://www.freecodecamp.org/learn/data-analysis-with-python/data-analysis-with-python-course/)
- [Applied Ai](https://www.appliedaicourse.com/?gclid=Cj0KCQjwwY-LBhD6ARIsACvT72M2c1Yo3CFYoPpIEP4_omxJRbT4MzHk3vqcUw93xcy6asjPfGWn2R0aAq3NEALw_wcB)
- [Coursera](https://www.coursera.org/professional-certificates/ibm-data-science)
- [Scaler Blogs](https://www.scaler.com/blog/category/data-science-business-analytics/)


## Deep Learning

- [Deep Learning Specialization (instructor : Andrew Ng) on Coursera](https://www.coursera.org/specializations/deep-learning)
- [Udacity Intro to Tensorflow for Deep Learning](https://www.udacity.com/course/intro-to-tensorflow-for-deep-learning--ud187)
- [Udacity Intro to Deep Learning with PyTorch](https://www.udacity.com/course/deep-learning-pytorch--ud188)

## Developer Blog

- [Adebiyi Adedotun](https://medium.com/@adebiyiadedotun9/)
- [Alistapart](https://alistapart.com)
- [Assortment.io](https://assortment.io/)
- [Ayo Isaiah](https://freshman.tech/)
- [Backticks & Tildes](https://medium.com/backticks-tildes)
- [bitsofcode](https://bitsofco.de)
- [catlin.red](https://catalin.red/)
- [Creative Bloq](https://www.creativebloq.com/)
- [David Heinemeier Hansson (DHH)](https://medium.com/@dhh)
- [David Walsh](https://davidwalsh.name)
- [Flavio Copes](https://flaviocopes.com/)
- [Gift Egwuenu](https://giftegwuenu.com)
- [Jake Archibald](https://jakearchibald.com/)
- [Harry Cresswell](https://harrycresswell.com/articles/)
- [Mark Dotto Blog](https://markdotto.com)
- [Martin Fowler](https://martinfowler.com/)
- [Monica Powell](https://www.aboutmonica.com/)
- [Raymond Camden](https://raymondcamden.com)
- [Shay Howe](https://learn.shayhowe.com/)
- [Tania Rascia](https://www.taniarascia.com/)
- [Todd Motto](https://toddmotto.com/)
- [Zell's Blog](https://zellwk.com/blog)
- [Dan Abramov Blog](https://overreacted.io/)
- [Web Development Reading List](https://wdrl.info)
- [Developer Roadmap](https://roadmap.sh)
- [CodeWall](https://codewall.co.uk)
- [Joshua Comeau](https://joshwcomeau.com/)
- [Sara Soueidan](https://sarasoueidan.com/)
- [Robin Weiruch](https://robinwieruch.de/)
- [Wes Bos](https://wesbos.com/)

## Developer Stories

- [My #100DaysofCode Experience — The Good, The Bad and The Ugly](https://code.likeagirl.io/my-100daysofcode-experience-the-good-the-bad-and-the-ugly-ee1263131f15)
- [Advice From A 19 Year Old Girl & Software Developer](https://medium.com/@lydiahallie/advice-from-a-19-y-o-girl-software-developer-88737bcc6be5)
- [Becoming an intermediate developer, keeping up with the Wars](https://hackernoon.com/becoming-intermediate-developer-keeping-up-with-the-wars-87bb518b40da)
- [How to relocate to Germany: IT Specialists sharing their experience](https://zerotoonesearch.com/relocation-to-germany-success-stories/)

## Django

- [Django Girls](https://tutorial.djangogirls.org/)
- [Official Django Tutorials](https://docs.djangoproject.com/en/3.0/intro/tutorial01/)
- [Classy Class-Based Views](https://ccbv.co.uk/)
- [How To Tango With Django 1.7](https://www.tangowithdjango.com/book17/)

## Elixir

- [Elixir School](https://elixirschool.com/)
- [Learn Elixir in Y minutes](https://learnxinyminutes.com/docs/elixir)
- [Mocks and Explicit Contracts](https://blog.plataformatec.com.br/2015/10/mocks-and-explicit-contracts/)
- [Elixir Forum](https://elixirforum.com/)
- [Joy of Elixir](https://joyofelixir.com/toc.html)

## Flutter

- [Introduction to Flutter Development Using Dart](https://www.appbrewery.co/p/intro-to-flutter)
- [Flutter Course - Full Tutorial for Beginners](https://www.youtube.com/watch?v=pTJJsmejUOQ)
- [Flutter: Learning Resources for Beginners](https://dev.to/nitya/flutter-learning-resources-for-beginners-5719)
- [Flutter Tutorial by The Net Ninja](https://www.youtube.com/watch?v=1ukSR1GRtMU)
- [Example Flutter theme](https://startflutter.com/)
- [Example Flutter UI](https://fluttersourcecode.com/)
- [The Complete Free Flutter Course by Ovidius Mazuru](https://www.youtube.com/channel/UCJW25d8mW8ciz0DQC-5XNsQ/featured)
- [Flutter Documentation](https://flutter.dev/docs)

## Flask

- [Flask Official Documentation](https://flask.palletsprojects.com/en/1.1.x/)
- [Flask Tutorial](https://www.tutorialspoint.com/flask/index.htm)
- [Python Flask Tutorials](https://coreyms.com/development/python/python-flask-tutorials-full-series)
- [The Flask Mega Tutorial by Miguel Grinberg](https://blog.miguelgrinberg.com/post/the-flask-mega-tutorial-part-i-hello-world)
- [Data Structures For Python Developers with Flask](https://www.youtube.com/watch?v=74NW-84BqbA)

## Git and GitHub

- [The official github guides](https://guides.github.com/)
- [GitHub Learning Lab](https://lab.github.com/)
- [GitHub Training](https://www.youtube.com/user/GitHubGuides)
- [Git and GitHub by freecodecamp.org](https://www.youtube.com/watch?v=vR-y_2zWrIE&list=PLWKjhJtqVAbkFiqHnNaxpOPhh9tSWMXIF)
- [Get to know Git by scotch.io (Premium content)](https://scotch.io/courses/get-to-know-git)
- [Git and GitHub for beginners (Traversy Media)](https://www.youtube.com/watch?v=SWYqp7iY_Tc)
- [Git and GitHub commands (a list)](https://github.com/joshnh/Git-Commands)
- [Pro Git](https://git-scm.com/book/en/v2)
- [Git In The Trenches](https://cbx33.github.io/gitt/intro.html)
- [How to Write a Git Commit Message](https://chris.beams.io/posts/git-commit/)
- [Git Hooks](https://githooks.com/)

## Golang

- [1000+ Go exercises, examples, and quizzes](https://github.com/inancgumus/learngo)
- [A Tour of Go](https://tour.golang.org/welcome/1)
- [Dasar Pemrograman Golang](https://dasarpemrogramangolang.novalagung.com/)
- [Go by Example](https://gobyexample.com/)
- [Go Crash Course](https://www.youtube.com/watch?v=SqrbIlUwR0U)
- [Go for Javascript Developers](https://www.pazams.com/Go-for-Javascript-Developers/)
- [Golang Tutorials](https://golangtutorials.blogspot.com/2011/05/table-of-contents.html)
- [Learn Go in Y minutes](https://learnxinyminutes.com/docs/go/)
- [In-depth and Illustrated Go Tutorials](https://blog.learngoprogramming.com)
- [Basic Middleware in Go](https://medium.com/@budimanokky93/basic-middleware-in-golang-9536faa41874)

## GraphQL

- [What is GraphQL?](https://medium.freecodecamp.org/so-whats-this-graphql-thing-i-keep-hearing-about-baf4d36c20cf)
- [Intro to GraphQL](https://blog.apollographql.com/the-basics-of-graphql-in-5-links-9e1dc4cac055)
- [GraphQL Explained](https://blog.apollographql.com/graphql-explained-5844742f195e)
- [GraphQL vs REST overview](https://philsturgeon.uk/api/2017/01/24/graphql-vs-rest-overview/)
- [From REST to GraphQL](https://0x2a.sh/from-rest-to-graphql-b4e95e94c26b)
- [Authorization in GraphQL](https://blog.apollographql.com/authorization-in-graphql-452b1c402a9)
- [Authentication and Authorization in GraphQL](https://speakerdeck.com/unicodeveloper/authentication-and-authorization-in-graphql?slide=6)
- [HowToGraphQL](https://www.howtographql.com)
- [GraphQL with React Tutorial](https://www.thenetninja.co.uk/courses/graphql-node-react-tutorial)

## Hugo

- [Hugo in Action](https://www.manning.com/books/hugo-in-action)

## Hacking

- [Awesome Hacking](https://github.com/NetanMangal/Awesome-Hacking)

## InfoSec

- [awesome-infosec](https://github.com/onlurking/awesome-infosec)
- [SecLists](https://github.com/danielmiessler/SecLists)
- [OWASP Top 10](https://www.owasp.org/index.php/Top_10-2017_Top_10)
- [Beggining with Reverse Engineering](https://beginners.re/)
- [CTF field guide](https://trailofbits.github.io/ctf/)
- [Metasploit unleashed](https://www.offensive-security.com/metasploit-unleashed/)
- [Infosec Institute](https://resources.infosecinstitute.com/)

## Ionic

- [Ionic Tutorials & Courses](https://hackr.io/tutorials/learn-ionic)
- [Learn Ionic Fast](https://ionicacademy.com/)
- [Ionic Tutorial](https://www.tutorialspoint.com/ionic/index.htm)

## JavaScript

- [FreeCodeCamp](https://freecodecamp.com)
- [The Odin Project](https://www.theodinproject.com/)
- [Fun Fun Function](https://www.youtube.com/channel/UCO1cgjhGzsSYb1rsB4bFe4Q)
- [The Coding Train](https://www.youtube.com/user/shiffman/videos)
- [CodeSchool](https://www.codeschool.com/learn/javascript)
- [Egghead](https://egghead.io)
- [Ally.io](https://allyjs.io/)
- [How to code in JavaScript Digital Ocean](https://www.digitalocean.com/community/tutorial_series/how-to-code-in-javascript)
- [Codeburst.io](https://codeburst.io/)
- [Hackernoon](https://hackernoon.com/)
- [YDKJS](https://github.com/getify/You-Dont-Know-JS)
- [JavaScript in 14 minutes](https://jgthms.com/javascript-in-14-minutes/)
- [Scotch.io](https://scotch.io)
- [ES6 Overview in 350 Bullet Points](https://github.com/bevacqua/es6)
- [Setup Continuous Integration with Travis CI in Your Nodejs App](https://www.giftegwuenu.com/setup-continuous-integration-with-travis-ci-in-your-nodejs-app/)
- [Javascript 30 by Wes Bos](https://javascript30.com/)
- [ES6 for Everyone by Wes Bos](https://es6.io/)
- [Alligator.io Javascript page](https://alligator.io/js/)
- [JavaScript.info](https://javascript.info/)
- [Object Oriented JavaScript](https://www.thenetninja.co.uk/courses/object-oriented-javascript-tutorial)
- [Learn X in Y minutes: JavaScript](https://learnxinyminutes.com/docs/javascript/)
- [CSX Structured JavaScript Learning Journey - Codesmith](https://csx.codesmith.io/)
- [Dev.to JavaScript](https://dev.to/t/javascript)
- [JavaScript Garden](https://bonsaiden.github.io/JavaScript-Garden/)
- [Codecademy: Introduction to JavaScript](https://www.codecademy.com/learn/introduction-to-javascript)
- [Eloquent JavaScript](https://eloquentjavascript.net/)
- [Mozilla's JavaScript Guide](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide)
- [JavaScript for Cats](http://jsforcats.com/)
- [Beginner JavaScript by Wes Bos](https://beginnerjavascript.com/)
- [The Modern JavaScript Tutorial](https://javascript.info/)
- [trekhleb/javascript-algorithms](https://github.com/trekhleb/javascript-algorithms)
- [Beginner's Series to JavaScript](https://www.youtube.com/playlist?list=PLlrxD0HtieHhW0NCG7M536uHGOtJ95Ut2)
- [learn-js](https://www.learn-js.org/)
- [JavaScript Online](https://learnjavascript.online/)
- [DevProjects - Free Real-World JavaScript Projects](https://www.codementor.io/projects/javascript)
- [FullStack Open](https://fullstackopen.com/en/)
- [JavaScript Tutorial](https://www.javascripttutorial.net/)
- [Scaler Topics - JavaScript Tutorial](https://www.scaler.com/topics/javascript/)
- [Learn Javascript The Hard Way](https://learnjsthehardway.com/)

## Java
- [Scaler Topics](https://www.scaler.com/topics/java/)

## Kotlin

- [Kotlin Coding Puzzles](https://github.com/igorwojda/kotlin-coding-puzzle) Set of programming challenges thats helps to improve whiteboard coding and problem-solving skills.
- [Kotlin by Reddit](https://www.reddit.com/r/Kotlin/)
- [Kotlin Academy](https://blog.kotlin-academy.com/)
- [Kotlin by Hackr.io](https://hackr.io/tutorials/learn-kotlin)
- [Kotlin for Android](https://antonioleiva.com/kotlin/)
- [Programming Kotlin](https://www.packtpub.com/application-development/programming-kotlin)
- [Kotlin bootcamp](https://developer.android.com/courses/kotlin-bootcamp/overview#lesson_1_get_started)
- [DevProjects - Free Real-World Mobile Apps Projects](https://www.codementor.io/projects/mobile)

## Laravel

[list-of-21-artisan-make-commands-with-parameters](https://quickadminpanel.com/blog/list-of-21-artisan-make-commands-with-parameters/)

## Machine Learning

- [Fast.ai](https://course.fast.ai/)
- [Andrew Ng’s Machine Learning course](https://www.coursera.org/learn/machine-learning)
- [Kaggle](https://www.kaggle.com/)
- [Topal](https://www.toptal.com/machine-learning/machine-learning-theory-an-introductory-primer)
- [MonkeyLearn](https://monkeylearn.com/blog/gentle-guide-to-machine-learning/)
- [An Introduction to Statistical Learning with Applications in R](https://www-bcf.usc.edu/~gareth/ISL/)
- [Machine learning mastery](https://machinelearningmastery.com/blog/)
- [Intro to Deep Learning with PyTorch](https://www.udacity.com/course/deep-learning-pytorch--ud188)
- [MACHINE LEARNING - Teori, Studi Kasus dan Implementasi Menggunakan Python](https://ibnu.daqiqil.id/buku-machine-learning/)

## Malware Analysis

- [Malware Analyst's Cookbook and DVD: Tools and Techniques for Fighting Malicious Code](https://www.amazon.com/Malware-Analysts-Cookbook-DVD-Techniques/dp/0470613033)
- [Practical Malware Analysis](https://www.amazon.com/Practical-Malware-Analysis-Hands-Dissecting/dp/1593272901/ref=pd_sbs_14_t_0/136-7474712-7650215?_encoding=UTF8&pd_rd_i=1593272901&pd_rd_r=f8f8d7e2-f2b5-4ac7-91ce-e0355affe59a&pd_rd_w=a0873&pd_rd_wg=u2f3a&pf_rd_p=5cfcfe89-300f-47d2-b1ad-a4e27203a02a&pf_rd_r=6Q3PYAT9CC9304D9BFY4&psc=1&refRID=6Q3PYAT9CC9304D9BFY4)
- [Exploit writing Tutorial](https://www.corelan.be/index.php/2009/07/19/exploit-writing-tutorial-part-1-stack-based-overflows/)
- [Shell code database](http://shell-storm.org/shellcode/)

## Markdown

- [Learn Markdown in Y minutes](https://learnxinyminutes.com/docs/markdown/)
- [Markdown Tutorial](https://www.markdowntutorial.com/)
- [Markdown lessons](https://commonmark.org/help/tutorial/)
- [Mastering Markdown](https://masteringmarkdown.com/)
- [Markdown Cheat Sheet](https://markdownguide.org/cheat-sheet)
- [Make a README](https://www.makeareadme.com/)

## NodeJS

- [Learn Node by Wes Bos](https://learnnode.com/)
- [Alligator.IO Node Page](https://alligator.io/nodejs/)
- [The Art of Node](https://github.com/maxogden/art-of-node)
- [You don't know Node.js](https://github.com/azat-co/you-dont-know-node)
- [The Node Way](https://thenodeway.io/)
- [Teach Yourself Node.js In Ten Steps](https://ponyfoo.com/articles/teach-yourself-nodejs-in-10-steps)
- [Learn the Node.js Runtime Itself](https://medium.freecodecamp.org/before-you-bury-yourself-in-packages-learn-the-node-js-runtime-itself-f9031fbd8b69)
- [Microsoft Node.js Guidelines](https://github.com/Microsoft/nodejs-guidelines)
- [Offline Installation of npm Packages](https://addyosmani.com/blog/using-npm-offline/)
- [Using npm as a build tool](https://www.keithcirkel.co.uk/how-to-use-npm-as-a-build-tool/)
- [How to Get Node.js Logging Right](https://blog.risingstack.com/node-js-logging-tutorial/)
- [Node.js Testing with Jest](https://github.com/facebook/jest)
- [Node.js Testing with Mocha](https://mochajs.org/)
- [Error Handling in Node.js](https://www.joyent.com/node-js/production/design/errors)
- [Error Handling Best Practices in Node.js](https://goldbergyoni.com/checklist-best-practices-of-node-js-error-handling/)
- [Node.js Security Checklist](https://blog.risingstack.com/node-js-security-checklist/)
- [13 Best Practices for Node.js Security](https://nodewebapps.com/2017/01/03/13-security-best-practices-for-your-web-application/)
- [Node.js Production Checklist](https://goldbergyoni.com/checklist-best-practice-of-node-js-in-production/)
- [Debugging Node.js Apps in Production](https://blog.risingstack.com/node-js-war-stories-solving-issues-in-production-2/)
- [Node.js Performance Tips](https://www.smashingmagazine.com/2018/06/nodejs-tools-techniques-performance-servers/)
- [Measuring HTTP Timings with Node.js](https://blog.risingstack.com/measuring-http-timings-node-js/)
- [Advanced Node.js(videos)](https://onedrive.live.com/?authkey=%21ANbPcuk7XxY1hPY&id=9F66D67EBC33737F%2133343&cid=9F66D67EBC33737F)
- [Node.js Interview Questions and Answers](https://blog.risingstack.com/node-js-interview-questions-and-answers-2017/)
- [Tutorialspoint](https://www.tutorialspoint.com/nodejs/)
- [A Roadmap for Node.js Security](https://nodesecroadmap.fyi/)
- [Server-side Development with NodeJS, Express and MongoDB](https://www.coursera.org/learn/server-side-nodejs)
- [Awesome Node.JS (A-Z) Youtube Lecture](https://www.youtube.com/watch?v=rSHL_lYY_Xc&list=PLatXnLy-YGQexU9sktggQbw7tq815yGbR)
- [Nodejs.dev](https://nodejs.dev)
- [Beginner's Series to Node.js](https://www.youtube.com/playlist?list=PLlrxD0HtieHje-_287YJKhY8tDeSItwtg)
- [Build JavaScript applications with Node.js](https://docs.microsoft.com/learn/paths/build-javascript-applications-nodejs/?wt.mc_id=nodebeginner-ch9-cxa)
- [DevProjects - Free Real-World Node.js Projects](https://www.codementor.io/projects/nodejs)

## PHP

- [7 days challenge](https://www.guru99.com/php-tutorials.html)
- [The right way](https://phptherightway.com/)
- [In site learn](https://www.learn-php.org/)
- [Complete macos PHP setup](https://getgrav.org/blog/macos-mojave-apache-multiple-php-versions)
- [Laravel framework](https://laravel.com)
- [Laracasts](https://laracasts.com/)
- [PHP Tutorial](https://www.tutorialspoint.com/php/index.htm)
- [DevProjects - Free Real-World PHP Projects](https://www.codementor.io/projects/php)
- [Laravel Interview Questions](https://www.interviewbit.com/laravel-interview-questions/)

## PLSQL

- [TechOnTheNet](https://www.techonthenet.com/oracle/index.php)
- [Tutorials Point](https://www.tutorialspoint.com/plsql/)
- [Oracle Database Development Guide](https://docs.oracle.com/database/121/ADFNS/toc.htm)

## Podcasts

- [Behind the Tech](https://behindthetech.libsynpro.com/)
- [CodeNewbie](https://www.codenewbie.org/podcast)
- [Syntax](https://syntax.fm/)
- [Software Engineering Daily](https://dev.to/sedaily)
- [The Freecodecamp Podcast](https://freecodecamp.libsyn.com/)
- [Indie Hackers](https://www.indiehackers.com/podcast)
- [Rework](https://rework.fm/)
- [Darknet Diaries](https://darknetdiaries.com)
- [Developer Tea](https://spec.fm/podcasts/developer-tea)
- [ForLoop Pod](https://podcast.forloop.africa/)
- [Soft Skills Engineering](https://softskills.audio/)
- [Free Code Camp](https://freecodecamp.libsyn.com/)
- [Full Stack Radio](https://www.fullstackradio.com/)
- [The Women in Tech Show](https://thewomenintechshow.com/)
- [Front End Happy Hour](https://frontendhappyhour.com/)
- [Laravel Podcast](https://www.laravelpodcast.com/)
- [Laracast Snippet](https://laracasts.com/podcast)
- [Pursuit Podcast](https://pursuit.tech/)
- [Battle Tactics for Your Sexist Workplace](https://www.kuow.org/podcasts/battle-tactics/)
- [Women in Tech](https://podcast.womenintechshow.com/episodes)
- [Masters Of Scale](https://mastersofscale.com)
- [Shop talk show](https://shoptalkshow.com)
- [Hanselminutes](https://www.hanselminutes.com/)- Fresh Tech Talk from Fresh Faces
- [This Week In Tech](https://twit.tv/shows/this-week-in-tech)
- [JS Party](https://changelog.com/jsparty)
- [My Life As A Software Engineer](https://anchor.fm/mylifeasasoftwareengineer/)
- [The Cynical Developer](https://cynicaldeveloper.com/)

## PWA

- [The Complete Guide to Progressive Web Apps](https://flaviocopes.com/what-is-a-progressive-web-app/)
- [A Beginner's Guide to Service Workers](https://medium.com/samsung-internet-dev/a-beginners-guide-to-service-workers-f76abf1960f6)
- [Progressive Web Application Codelab](https://codelabs.developers.google.com/codelabs/your-first-pwapp/#0)
- [4 important points to know about Progressive Web Apps (PWA)](https://medium.com/@deepusnath/4-points-to-keep-in-mind-before-introducing-progressive-web-apps-pwa-to-your-team-8dc66bcf6011)
- [PWA (Progressive Web App) Tutorial](https://www.thenetninja.co.uk/courses/progressive-web-app-tutorial)

## Python

- [Learn Python the Hard Way](https://learnpythonthehardway.org/)
- [CS50's Web Programming with Python and JavaScript](https://www.edx.org/course/cs50s-web-programming-with-python-and-javascript)
- [Automate the Boring Stuff with Python](https://automatetheboringstuff.com/)
- [Think Python 2nd Edition](https://greenteapress.com/wp/think-python-2e/)
- [Python Tips](https://book.pythontips.com/en/latest/index.html)
- [Inside The Python Virtual Machine](https://leanpub.com/insidethepythonvirtualmachine/read)
- [CodingBat - Python](https://codingbat.com/python)
- [Python for Fun](https://www.openbookproject.net/py4fun/)
- [A Byte of Python](https://python.swaroopch.com/)
- [Learn Python 3 By Code Academy](https://www.codecademy.com/learn/learn-python-3)
- [ Python tutorials for beginners ](https://www.youtube.com/watch?v=aqvDTCpNRek&list=PLu0W_9lII9agICnT8t4iYVSZ3eykIAOME)
- [ Python OOP](https://www.programiz.com/python-programming/object-oriented-programming)
- [Full-Stack Python](https://www.fullstackpython.com/table-of-contents.html)
- [Python Tutorials](https://realpython.com/)
- [Algorithms and Data Structures with Python](https://jooseph.com/collections/802?utm_source=reddit.com&utm_medium=referral&utm_campaign=r%2Flearnprogramming)
- [Python Tutorial - Tutlane](https://www.tutlane.com/tutorial/python)
- [DevProjects - Free Real-World Python Projects](https://www.codementor.io/projects/python)
- [ItsMyCode - Learn Python Programming](https://itsmycode.com/category/python/)
- [Scaler Topics - Python Tutorials](https://www.scaler.com/topics/python/)


## ReactJS

- [React for Beginners by Wes Bos](https://reactforbeginners.com/)
- [Learn React](https://scrimba.com/course/glearnreact)
- [The React BootCamp](https://scrimba.com/course/greact)
- [Fullstack Advanced React and GraphQL by Wes Bos](https://advancedreact.com/)
- [Alligator.IO React Page](https://alligator.io/react/)
- [Egghead.io](https://egghead.io/browse/frameworks/react)
- [Frontend Masters](https://frontendmasters.com/learn/react/)
- [Roadmap to becoming a React developer](https://github.com/adam-golab/react-developer-roadmap)
- [fullstackreact](https://www.fullstackreact.com/)
- [The Road to learn React](https://roadtoreact.com/)
- [React Fundamentals by Tyler Mcginnis](https://tylermcginnis.com/courses/react-fundamentals/)
- [Hooks Guide](https://www.hooks.guide/)
- [Overreacted by Dan Abramov](https://overreacted.io/)
- [React & Firebase](https://www.thenetninja.co.uk/courses/react-redux-firebase-app-tutorial)
- [React Hooks & Context Tutorial](https://www.thenetninja.co.uk/courses/react-context-hooks-tutorial)
- [React & Redux Complete Tutorial](https://www.thenetninja.co.uk/courses/react-redux-complete-tutorial)
- [React Tutorials by React Community](http://reactjs.co/)
- [Pure React](https://www.daveceddia.com/pure-react/)
- [React Handbook](https://www.flaviocopes.com/page/react-handbook/)
- [React Enlightenment](https://www.reactenlightenment.com)
- [React Hooks in Action](https://www.manning.com/books/react-hooks-in-action)
- [Develop Live Project on React & Spring Boot with Payment Integration & BarCode Scanner](https://www.manning.com/liveproject/online-booking-systems-for-a-salon-and-day-spa-using-spring-boot-and-reactjs?a_aid=muthuishere&a_bid=4f5b6535)
- [Epic React by Kent C Dodds](https://epicreact.dev/)

## React Native

- [InstaMobile Blog](https://www.instamobile.io/blog/)
- [BootDey React Native Snippets](https://www.bootdey.com/react-native-snippets)
- [Awesome React Native](https://www.awesome-react-native.com/)
- [UI Libraries](https://blog.bitsrc.io/11-react-native-component-libraries-you-should-know-in-2018-71d2a8e33312)
- [The State Of React Native](https://www.youtube.com/watch?v=plTTFqbEiEE)
- [DevProjects - Free Real-World React Native Projects](https://www.codementor.io/projects/react-native)

## Ruby

- [Learn Ruby the Hard Way](https://learnrubythehardway.org/book/)
- [The Ruby Reference](https://rubyreferences.github.io/rubyref/)
- [Ada Developers Academy Jump Start](https://github.com/Ada-Developers-Academy/jump-start)
- [App Academy Open](https://open.appacademy.io/)
- [DevProjects - Free Real-World Ruby Projects](https://www.codementor.io/projects/ruby)

## Ruby on Rails

- [Official Rails Website](https://rubyonrails.org/)
- [David Heinemeier Hansson](https://www.youtube.com/channel/UCUkM9uMpWatT7gVWShgtKFw)
- [GoRails](https://gorails.com/)
- [Rails Screen Casts](https://railscasts.com/)
- [Agile Web Development with Rails 5](https://books.google.co.za/books/about/Agile_Web_Development_with_Rails_5.html?id=ySyjDAEACAAJ&source=kp_book_description&redir_esc=y)
- [Ruby on Rails Tutorial: Learn Web Development with Rails](https://www.goodreads.com/book/show/13705557-ruby-on-rails-tutorial)

## Rust

- [Rust by Example](https://doc.rust-lang.org/stable/rust-by-example/index.html)
- [The Rust Programming Language (Book)](https://doc.rust-lang.org/book/)

## Serverless

- [Serverless](https://serverless.com/)
- [genezio](https://genez.io/?utm_source=awesome-serverless-github&utm_medium=website&utm_campaign=awesome-serverless)
- [Awesome Serverless Papers](https://github.com/penghuima/awesome-serverless-papers)
- [The Power of Serverless](https://thepowerofserverless.info/resources.html)
- [Awesome Serverless](https://github.com/anaibol/awesome-serverless)
- [A Cloud Guru](https://acloud.guru/courses)
- [AWS Fundamentals: Building Serverless Applications](https://www.coursera.org/learn/aws-fundamentals-building-serverless-applications)
- [DynamoDB Book](https://www.dynamodbbook.com/)
- [The Serverless Handbook](https://serverlesshandbook.dev/)

## Sick Picks

- [100 Tips to Becoming a better Developer](https://blog.thefirehoseproject.com/posts/100-essential-lessons-for-those-who-want-to-learn-to-code-in-2017/)
- [Super Cool Illustrations](https://undraw.co/illustrations)
- [A coder's guide to APIs](https://www.creativebloq.com/features/a-coders-guide-to-apis)
- [Why Coding Style Matters](https://www.smashingmagazine.com/2012/10/why-coding-style-matters/)
- [Google Styleguide](https://google.github.io/styleguide/htmlcssguide.html)
- [Github Styleguide](https://primer.github.io/)
- [Want To Become A Multi-Millionaire? Do These 15 Things Immediately.](https://journal.thriveglobal.com/want-to-become-a-multi-millionaire-do-these-15-things-immediately-e1e779a6978f?inf_contact_key=9c2f4a1eb788da91821800290cd23e49be1b7aeb634626a9fe8293d8a0fdb204)
- [Interruption is Not Collaboration](https://m.signalvnoise.com/interruption-is-not-collaboration-8dfb20731569)
- [Emoji Cheat Sheet](https://www.webpagefx.com/tools/emoji-cheat-sheet/)
- [UiGradient](https://uigradients.com)
- [FlatUIColor Picker](https://www.flatuicolorpicker.com/)
- [The Stocks](https://thestocks.im/)
- [Front-End Developer Handbook 2018](https://frontendmasters.gitbooks.io)
- [Everything about Static Web Applications](https://www.thenewdynamic.org/articles/)
- [Array Explorer](https://sdras.github.io/array-explorer/)
- [Object Explorer](https://sdras.github.io/object-explorer/)
- [Create VSCode Theme Extension](https://css-tricks.com/creating-a-vs-code-theme/)
- [30 Seconds of Interviews](https://30secondsofinterviews.org/)
- [Andela Learning Digest](https://learning-digest.andela.com/)
- [DevTube](https://dev.tube/)
- [Make Front-End Shit Again](https://makefrontendshitagain.party/)
- [Learn algorithms from Tushar Roy for jobs](https://github.com/mission-peace)
- [Refactoring, write awesome code](https://sourcemaking.com/refactoring)
- [Remove Background from Images](https://www.remove.bg/)
- [Creative Coding Experiments Blog](https://tympanus.net/codrops/)
- [CanIUse](https://caniuse.com/)
- [Clean Code JavaScript](https://github.com/ryanmcdermott/clean-code-javascript)
- [Cool Tech Confrence Talks](https://www.youtube.com/channel/UCtxCXg-UvSnTKPOzLH4wJaQ)

## Startups

- [Stripe Atlas](https://stripe.com/atlas/guides)
- [YCombinator Startup school](https://www.startupschool.org/?utm_source=yc&utm_campaign=ycdc_header)
- [Stanford CS183F Lectures with YCombinator](https://youtu.be/5ZXU84_sGXo?list=PLoROMvodv4rNpMrTeeh-627Lajh6uSUgY)

## Svelte

- [Svelte and Sapper in Action (Book)](https://www.manning.com/books/svelte-and-sapper-in-action)
- [The Svelte Handbook (Book)](https://flaviocopes.com/page/ebooks/)
- [Web Development Simplified with Svelte](https://objectcomputing.com/resources/publications/sett/july-2019-web-dev-simplified-with-svelte)
- [Rethinking Reactivity](https://www.youtube.com/watch?v=AdNJ3fydeao)
- [The Return of 'Write Less, Do More'](https://www.youtube.com/watch?v=BzX4aTRPzno)
- [Simplify Web App Development with Svelte](https://www.youtube.com/watch?v=PXOE7oZyaBA)

## Swift

- [iOS and Swift for Beginners](https://www.raywenderlich.com/ios/paths/learn)
- [The Complete iOS App Development Bootcamp](https://www.udemy.com/course/ios-13-app-development-bootcamp/)
- [Become an iOS Developer](https://www.udacity.com/course/ios-developer-nanodegree--nd003)
- [How to learn Swift programming for free in 2020](https://www.hackingwithswift.com/articles/2/how-to-learn-swift-programming-for-free)
- [Learn Swift - Tutlane](https://www.tutlane.com/tutorial/swift)
- [DevProjects - Free Read-World Swift Projects](https://www.codementor.io/projects/swift)

## TensorFlow

- [Introduction for TensorFlow for Deep Learning](https://www.udacity.com/course/intro-to-tensorflow-for-deep-learning--ud187)

## Twilio

- [Twilio Official Tutorial](https://www.twilio.com/docs/tutorials)

## Typescript

- [Typescript Deep Dive (Book)](https://github.com/basarat/typescript-book)
- [Typescript Wiki](https://github.com/Microsoft/TypeScript/wiki)
- [Typescript Handbook](https://github.com/Microsoft/TypeScript-Handbook/blob/master/pages)
- [Complete Typing Guide](https://blog.angular-university.io/typescript-2-type-system-how-do-type-definitions-work-in-npm-when-to-use-types-and-why-what-are-compiler-opt-in-types/)
- [Starter Template for Typescript and Node.js](https://github.com/Microsoft/TypeScript-Node-Starter)
- [Typescript Debugging in VSCode](https://fettblog.eu/typescript-node-visual-studio-code/)
- [Using Jest for Typescript Testing](https://github.com/kulshekhar/ts-jest)
- [Typescript Exercises](https://github.com/mdevils/typescript-exercises)

## Voice

- [Alexa Skills Kit Tutorials](https://developer.amazon.com/en-US/alexa/alexa-skills-kit/tutorials)
- [Build Actions for the Google Assistant](https://codelabs.developers.google.com/codelabs/actions-1/)

## Vue

- [Egghead.io](https://egghead.io/browse/frameworks/vue)
- [Front End Masters](https://frontendmasters.com/courses/vue/)
- [Routing and Route Protection in Server-Rendered Vue Apps Using Nuxt.js](https://css-tricks.com/routing-route-protection-server-rendered-vue-apps-using-nuxt-js/#comment-1615086)
- [Guide to Learning Vue](https://css-tricks.com/guides/vue/)
- [Made with Vue.js](https://madewithvuejs.com/)
- [Awesome Vue](https://github.com/vuejs/awesome-vue)
- [4 Awesome Things You Can Do with the Vue.js CLI](https://www.telerik.com/blogs/4-awesome-things-you-can-do-with-the-vuejs-cli)
- [Vue.js Cookbook](https://vuejs.org/v2/cookbook/)
- [From Zero to Hero with Vue - But first, why Vue?](https://medium.freecodecamp.org/from-zero-to-hero-with-vue-why-vue-8c7e981b494)
- [Vue Mastery - Multiple Free Classes](https://www.vuemastery.com/)
- [Laravel Cast - Learn Vue 2 Step by Step](https://laracasts.com/series/learn-vue-2-step-by-step)
- [Vue Cheatsheet](https://marozed.ma/vue-cheatsheet/)
- [Vue School](https://vueschool.io/)
- [Vue Curated](https://curated.vuejs.org/)
- [Vue Screencasts](https://www.youtube.com/channel/UCJasK7cAgRz1RGMJCoRLXXQ/)
- [DevProjects - Free Real-World Vue Projects](https://www.codementor.io/projects/vue)

## Women in Tech

- [Vue Vixens](https://vuevixens.org/)
- [PyLadies](https://www.pyladies.com/)
- [Girls Who Code](https://girlswhocode.com/)
- [Women Who Code](https://www.womenwhocode.com)
- [Ladies of Code](https://www.ladiesofcode.com/)
- [Women in Tech](https://www.womenintech.co.uk/)
- [Tech Ladies](https://www.hiretechladies.com/)
- [Women TechMakers](https://www.womentechmakers.com/)
- [Ladybug Podcast - Women in Tech](https://ladybug.dev/)

## XML

- [W3](https://www.w3.org/XML)
