<?php

namespace App\Http\Controllers\Articles;

use App\Http\Controllers\Controller;
use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AuthoredArticles extends Controller
{
    public function __construct()
    {
        $this->middleware([Authenticate::class, EnsureEmailIsVerified::class]);
    }

    public function __invoke(Request $request): View
    {
        return view('users.articles', [
            'articles' => $request->user()
                ->articles()
                ->orderByDesc('submitted_at')
                ->orderByDesc('created_at')
                ->paginate(10),
        ]);
    }
}
