# About

## What's in a name?

Far from being an arbitrary label, “Paroxython” has been scientifically formulated by an independent laboratory to possess the following properties:

1. It features both “Python” and “taxon”.
2. It provides a future-proof template for adaptations to other languages (Carox, Jaroxava, JaroxavaScript, Garoxo, Laroxua, Ocaroxaml, Haroxaskell, etc.) or fields of knowledge (Haroxarmony, Garoxeography, Maroxagnetohydrodynamics, etc.).
3. “Paroxytone” denotes a word accented or stressed on the penult[^paroxytone] and translates as “paroxyton” in [my mother tongue](https://youtu.be/M9DCAFUerzs).

[^paroxytone]:
    “paroxytone,” Merriam-Webster.com Dictionary, https://www.merriam-webster.com/dictionary/paroxytone. Accessed 8/7/2020.


## Citing this work

```bibtex
@manual{,
  title = {Paroxython: Tag and Recommend Python Exercises Based on Algorithmic Features},
  author = {{Aristide Grange}},
  organization = {Université de Lorraine},
  address = {Metz, France},
  year = {2020},
  url = {https://laowantong.github.io/paroxython/},
}
```

## Collaborating

Paroxython is on [GitHub](https://github.com/laowantong/paroxython) and welcomes your [issues](https://github.com/laowantong/paroxython/issues) or [pull requests](https://github.com/laowantong/paroxython/pulls). You may:

- contribute to the code;
- add new features in `spec.md`;
- submit your personal changes to `taxonomy.tsv` for integration in the default taxonomy;
- translate some of this documentation into English.

If you use Paroxython for your programming course, I would love to get your feedback. If you're a researcher and interested in a scientific collaboration, drop an email to my dot-separated name (cf. previous section) at `univ-lorraine.fr`.
