 
using System;
using System.Configuration;

namespace Common.Utility
{
	/// <summary>
	/// web.config操作类
	/// </summary>
	public sealed class ConfigHelper
	{
		/// <summary>
		/// 得到AppSettings中的配置字符串信息
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public static string GetConfigString(string key)
		{
            string CacheKey = "AppSettings-" + key;
            object objModel = DataCache.GetCache(CacheKey);
            if (objModel == null)
            {
                try
                {
                    objModel = ConfigurationManager.AppSettings[key]; 
                    if (objModel != null)
                    {                        
                        DataCache.SetCache(CacheKey, objModel, DateTime.Now.AddMinutes(180), TimeSpan.Zero);
                    }
                }
                catch
                { }
            }
            return objModel.ToString();
		}

		/// <summary>
		/// 得到AppSettings中的配置Bool信息
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public static bool GetConfigBool(string key)
		{
			bool result = false;
			string cfgVal = GetConfigString(key);
			if(null != cfgVal && string.Empty != cfgVal)
			{
				try
				{
					result = bool.Parse(cfgVal);
				}
				catch(FormatException)
				{
					// Ignore format exceptions.
				}
			}
			return result;
		}
		/// <summary>
		/// 得到AppSettings中的配置Decimal信息
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public static decimal GetConfigDecimal(string key)
		{
			decimal result = 0;
			string cfgVal = GetConfigString(key);
			if(null != cfgVal && string.Empty != cfgVal)
			{
				try
				{
					result = decimal.Parse(cfgVal);
				}
				catch(FormatException)
				{
					// Ignore format exceptions.
				}
			}

			return result;
		}
		/// <summary>
		/// 得到AppSettings中的配置int信息
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public static int GetConfigInt(string key)
		{
			int result = 0;
			string cfgVal = GetConfigString(key);
			if(null != cfgVal && string.Empty != cfgVal)
			{
				try
				{
					result = int.Parse(cfgVal);
				}
				catch(FormatException)
				{
					// Ignore format exceptions.
				}
			}

			return result;
		}

        #region 添加　AppConfig
        /// <summary>
        /// 设置AppConfig
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="val">值</param>
        public static void AddAppConfig(string key, string val)
        {
            ConfigurationManager.AppSettings.Add(key, val);
        }
        #endregion
        
        #region 更新　AppConfig
        /// <summary>
        /// 设置AppConfig
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="val">值</param>
        public static void SetAppConfig(string key,string val)
        {           
            ConfigurationManager.AppSettings.Set(key, val);
            string CacheKey = "AppSettings-" + key;
          //  DotNet.Common.DataCache.SetCache(CacheKey, val, DateTime.Now.AddMinutes(180), TimeSpan.Zero);
        }
        #endregion

        #region 移除　AppConfig
        /// <summary>
        /// Remove AppConfig
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="val">值</param>
        public static void RemoveAppConfig(string key)
        {
            ConfigurationManager.AppSettings.Remove(key);
        }
        #endregion

        #region 得到AppSettings中的配置字符串信息
        /// <summary>
        /// 得到AppSettings中的配置字符串信息
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
       
        #endregion

        #region 得到AppSettings中的配置字符串信息 没有缓存
        /// <summary>
        /// 得到AppSettings中的配置字符串信息 没有缓存
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetNoCacheConfig(string key)
        {            
            return ConfigurationManager.AppSettings[key].ToString();
        }

        #endregion





    }

}
