
using System;
using System.IO;
using System.Data;
using System.Collections;
using System.Text.RegularExpressions;
using System.Web.UI;
using System.Collections.Generic;
using System.Text;
using System.Drawing.Printing;
using System.Drawing.Imaging;

namespace Utilities
{
    /// <summary>
    /// Utility ժҪ˵
    /// </summary>
    public class Utility : Page
    {

        #region ת
        /// <summary>
        /// ضobjStringֵ,objΪnullʱؿֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>ַ</returns>
        public static string ToObjectString(object obj)
        {
            return null == obj ? String.Empty : obj.ToString();
        }

        /// <summary>
        /// תΪֵ(Int32),תʧܷ-1
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Int32ֵ</returns>
        public static int ToInt(object obj)
        {
            try
            {
                return int.Parse(ToObjectString(obj));
            }
            catch
            { return -1; }
        }

        /// <summary>
        /// תΪֵ(Int32)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Int32ֵ</returns>
        public static int ToInt(object obj, int returnValue)
        {
            try
            {
                return int.Parse(ToObjectString(obj));
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// תΪֵ(Long),תʧܷ-1
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Longֵ</returns>
        public static long ToLong(object obj)
        {
            try
            {
                return long.Parse(ToObjectString(obj));
            }
            catch
            { return -1L; }
        }
        /// <summary>
        /// תΪֵ(Long)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Longֵ</returns>
        public static long ToLong(object obj, long returnValue)
        {
            try
            {
                return long.Parse(ToObjectString(obj));
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// תΪֵ(Decimal),תʧܷ-1
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Decimalֵ</returns>
        public static decimal ToDecimal(object obj)
        {
            try
            {
                return decimal.Parse(ToObjectString(obj));
            }
            catch
            { return -1M; }
        }

        /// <summary>
        /// תΪֵ(Decimal)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Decimalֵ</returns>
        public static decimal ToDecimal(object obj, decimal returnValue)
        {
            try
            {
                return decimal.Parse(ToObjectString(obj));
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// תΪֵ(Double),תʧܷ-1
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Doubleֵ</returns>
        public static double ToDouble(object obj)
        {
            try
            {
                return double.Parse(ToObjectString(obj));
            }
            catch
            { return -1; }
        }

        /// <summary>
        /// תΪֵ(Double)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Doubleֵ</returns>
        public static double ToDouble(object obj, double returnValue)
        {
            try
            {
                return double.Parse(ToObjectString(obj));
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// תΪֵ(Float),תʧܷ-1
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Floatֵ</returns>
        public static float ToFloat(object obj)
        {
            try
            {
                return float.Parse(ToObjectString(obj));
            }
            catch
            { return -1; }
        }

        /// <summary>
        /// תΪֵ(Float)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Floatֵ</returns>
        public static float ToFloat(object obj, float returnValue)
        {
            try
            {
                return float.Parse(ToObjectString(obj));
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// תΪֵ(DateTime),תʧܷNow
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>DateTimeֵ</returns>
        public static DateTime ToDateTime(object obj)
        {
            try
            {
                DateTime dt = DateTime.Parse(ToObjectString(obj));
                if (dt > DateTime.MinValue && DateTime.MaxValue > dt)
                    return dt;
                return DateTime.Now;
            }
            catch
            { return DateTime.Now; }
        }

        /// <summary>
        /// תΪֵ(DateTime)͡
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>DateTimeֵ</returns>
        public static DateTime ToDateTime(object obj, DateTime returnValue)
        {
            try
            {
                DateTime dt = DateTime.Parse(ToObjectString(obj));
                if (dt > DateTime.MinValue && DateTime.MaxValue > dt)
                    return dt;
                return returnValue;
            }
            catch
            { return returnValue; }
        }
        /// <summary>
        /// Booleanתbyte,תʧܷ0
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Byteֵ</returns>
        public static byte ToByteByBool(object obj)
        {
            string text = ToObjectString(obj).Trim();
            if (text == string.Empty)
                return 0;
            else
            {
                try
                {
                    return (byte)(text.ToLower() == "true" ? 1 : 0);
                }
                catch
                {
                    return 0;
                }
            }
        }

        /// <summary>
        /// Booleanתbyte
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Byteֵ</returns>
        public static byte ToByteByBool(object obj, byte returnValue)
        {
            string text = ToObjectString(obj).Trim();
            if (text == string.Empty)
                return returnValue;
            else
            {
                try
                {
                    return (byte)(text.ToLower() == "true" ? 1 : 0);
                }
                catch
                {
                    return returnValue;
                }
            }
        }
        /// <summary>
        /// byteתBoolean,תʧܷfalse
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Booleanֵ</returns>
        public static bool ToBoolByByte(object obj)
        {
            try
            {
                string s = ToObjectString(obj).ToLower();
                return s == "1" || s == "true" ? true : false;
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// byteתBoolean
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="returnValue">תʧܷظֵ</param>
        /// <returns>Booleanֵ</returns>
        public static bool ToBoolByByte(object obj, bool returnValue)
        {
            try
            {
                string s = ToObjectString(obj).ToLower();
                return s == "1" || s == "true" ? true : false;
            }
            catch
            {
                return returnValue;
            }
        }
        #endregion

        #region ж
        /// <summary>
        /// жıobjǷΪֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Booleanֵ</returns>
        public static bool IsEmpty(string obj)
        {
            return ToObjectString(obj).Trim() == String.Empty ? true : false;
        }

        /// <summary>
        /// ж϶ǷΪȷֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Boolean</returns>
        public static bool IsDateTime(object obj)
        {
            try
            {
                DateTime dt = DateTime.Parse(ToObjectString(obj));
                if (dt > DateTime.MinValue && DateTime.MaxValue > dt)
                    return true;
                return false;
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ж϶ǷΪȷInt32ֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Int32ֵ</returns>
        public static bool IsInt(object obj)
        {
            try
            {
                int.Parse(ToObjectString(obj));
                return true;
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ж϶ǷΪȷLongֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Longֵ</returns>
        public static bool IsLong(object obj)
        {
            try
            {
                long.Parse(ToObjectString(obj));
                return true;
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ж϶ǷΪȷFloatֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Floatֵ</returns>
        public static bool IsFloat(object obj)
        {
            try
            {
                float.Parse(ToObjectString(obj));
                return true;
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ж϶ǷΪȷDoubleֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Doubleֵ</returns>
        public static bool IsDouble(object obj)
        {
            try
            {
                double.Parse(ToObjectString(obj));
                return true;
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ж϶ǷΪȷDecimalֵ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>Decimalֵ</returns>
        public static bool IsDecimal(object obj)
        {
            try
            {
                decimal.Parse(ToObjectString(obj));
                return true;
            }
            catch
            { return false; }
        }
        #endregion

        #region ݲ
        /// <summary>
        /// ȥַпո
        /// </summary>
        /// <param name="text">ַ</param>
        /// <returns>ַ</returns>
        public static string StringTrimAll(string text)
        {
            string _text = ToObjectString(text);
            string returnText = String.Empty;
            char[] chars = _text.ToCharArray();
            for (int i = 0; i < chars.Length; i++)
            {
                if (chars[i].ToString() != string.Empty)
                    returnText += chars[i].ToString();
            }
            return returnText;
        }

        /// <summary>
        /// ȥֵַпո
        /// </summary>
        /// <param name="numricString">ֵַ</param>
        /// <returns>String</returns>
        public static string NumricTrimAll(string numricString)
        {
            string text = ToObjectString(numricString).Trim();
            string returnText = String.Empty;
            char[] chars = text.ToCharArray();
            for (int i = 0; i < chars.Length; i++)
            {
                if (chars[i].ToString() == "+" || chars[i].ToString() == "-" || IsDouble(chars[i].ToString()))
                    returnText += chars[i].ToString();
            }
            return returnText;
        }

        /// <summary>
        /// вƥ
        /// </summary>
        /// <param name="array"></param>
        /// <param name="obj"></param>
        /// <returns>Boolean</returns>
        public static bool ArrayFind(Array array, object obj)
        {
            bool b = false;
            foreach (object obj1 in array)
            {
                if (obj.Equals(obj1))
                {
                    b = true;
                    break;
                }
            }
            return b;
        }

        /// <summary>
        /// вƥַ
        /// </summary>
        /// <param name="array"></param>
        /// <param name="obj"></param>
        /// <param name="unUpLower">ǷԴСд</param>
        /// <returns>Boolean</returns>
        public static bool ArrayFind(Array array, string obj, bool unUpLower)
        {
            bool b = false;
            foreach (string obj1 in array)
            {
                if (!unUpLower)
                {
                    if (obj.Trim().Equals(obj1.ToString().Trim()))
                    {
                        b = true;
                        break;
                    }
                }
                else
                {
                    if (obj.Trim().ToUpper().Equals(obj1.ToString().Trim().ToUpper()))
                    {
                        b = true;
                        break;
                    }
                }
            }
            return b;
        }
        /// <summary>
        /// 滻ַеĵš
        /// </summary>
        /// <param name="inputString">ַ</param>
        /// <returns>String</returns>
        public static string ReplaceInvertedComma(string inputString)
        {
            return inputString.Replace("'", "''");
        }


        /// <summary>
        /// жֽǷֵͬ.
        /// </summary>
        /// <param name="bytea">ֽ1</param>
        /// <param name="byteb">ֽ2</param>
        /// <returns>Boolean</returns>
        public static bool CompareByteArray(byte[] bytea, byte[] byteb)
        {
            if (null == bytea || null == byteb)
            {
                return false;
            }
            else
            {
                int aLength = bytea.Length;
                int bLength = byteb.Length;
                if (aLength != bLength)
                    return false;
                else
                {
                    bool compare = true;
                    for (int index = 0; index < aLength; index++)
                    {
                        if (bytea[index].CompareTo(byteb[index]) != 0)
                        {
                            compare = false;
                            break;
                        }
                    }
                    return compare;
                }
            }
        }


        /// <summary>
        /// ɡ
        /// </summary>
        /// <param name="inputText">ַ</param>
        /// <returns>DateTime</returns>
        public static string BuildDate(string inputText)
        {
            try
            {
                return DateTime.Parse(inputText).ToShortDateString();
            }
            catch
            {
                string text = NumricTrimAll(inputText);
                string year = DateTime.Now.Year.ToString();
                string month = DateTime.Now.Month.ToString();
                string day = DateTime.Now.Day.ToString();
                int length = text.Length;
                if (length == 0)
                    return String.Empty;
                else
                {
                    if (length <= 2)
                        day = text;
                    else if (length <= 4)
                    {
                        month = text.Substring(0, 2);
                        day = text.Substring(2, length - 2);
                    }
                    else if (length <= 6)
                    {
                        year = text.Substring(0, 4);
                        month = text.Substring(4, length - 4);
                    }
                    else if (length > 6)
                    {
                        year = text.Substring(0, 4);
                        month = text.Substring(4, 2);
                        day = text.Substring(6, length - 6);
                    }
                    try
                    {
                        return DateTime.Parse(year + "-" + month + "-" + day).ToShortDateString();
                    }
                    catch
                    {
                        return String.Empty;
                    }
                }
            }
        }



        /// <summary>
        /// ļǷʵڡ
        /// </summary>
        /// <param name="path">ļȫ·</param>
        /// <returns>Boolean</returns>
        public static bool IsFileExists(string path)
        {
            try
            {
                return File.Exists(path);
            }
            catch
            { return false; }
        }

        /// <summary>
        /// Ŀ¼Ƿʵڡ
        /// </summary>
        /// <param name="path">Ŀ¼·.</param>
        /// <returns>Boolean</returns>
        public static bool IsDirectoryExists(string path)
        {
            try
            {
                return Directory.Exists(Path.GetDirectoryName(path));
            }
            catch
            { return false; }
        }

        /// <summary>
        /// ļǷƥС
        /// </summary>
        /// <param name="fi">Ŀļ.</param>
        /// <param name="lineText">Ҫҵı.</param>
        /// <param name="lowerUpper">ǷִСд.</param>
        /// <returns>Boolean</returns>
        public static bool FindLineTextFromFile(FileInfo fi, string lineText, bool lowerUpper)
        {
            bool b = false;
            try
            {
                if (fi.Exists)
                {
                    StreamReader sr = new StreamReader(fi.FullName);
                    string g = "";
                    do
                    {
                        g = sr.ReadLine();
                        if (lowerUpper)
                        {
                            if (ToObjectString(g).Trim() == ToObjectString(lineText).Trim())
                            {
                                b = true;
                                break;
                            }
                        }
                        else
                        {
                            if (ToObjectString(g).Trim().ToLower() == ToObjectString(lineText).Trim().ToLower())
                            {
                                b = true;
                                break;
                            }
                        }
                    }
                    while (sr.Peek() != -1);
                    sr.Close();
                }
            }
            catch
            { b = false; }
            return b;
        }


        /// <summary>
        /// жϸӼϵǷȷ
        /// </summary>
        /// <param name="table">ݱ</param>
        /// <param name="columnName">Ӽ</param>
        /// <param name="parentColumnName"></param>
        /// <param name="inputString">Ӽֵ</param>
        /// <param name="compareString">ֵ</param>
        /// <returns></returns>
        public static bool IsRightParent(DataTable table, string columnName, string parentColumnName, string inputString, string compareString)
        {
            ArrayList array = new ArrayList();
            SearchChild(array, table, columnName, parentColumnName, inputString, compareString);
            return array.Count == 0;
        }

        // ڲ
        private static void SearchChild(ArrayList array, DataTable table, string columnName, string parentColumnName, string inputString, string compareString)
        {
            DataView view = new DataView(table);
            view.RowFilter = parentColumnName + "='" + ReplaceInvertedComma(inputString.Trim()) + "'";//ҳеࡣ
                                                                                                      //ұеݵIDǷcompareStringȣȷ false;ȼ
            for (int index = 0; index < view.Count; index++)
            {
                if (Utility.ToObjectString(view[index][columnName]).ToLower() == compareString.Trim().ToLower())
                {
                    array.Add("1");
                    break;
                }
                else
                {
                    SearchChild(array, table, columnName, parentColumnName, Utility.ToObjectString(view[index][columnName]), compareString);
                }
            }
        }

        #endregion

        #region 

        /// <summary>
        /// ʽַͣ
        /// </summary>
        /// <param name="dtime"></param>
        /// <param name="s">ռ</param>
        /// <returns></returns>
        public static String Fomatdate(DateTime dtime, String s)
        {
            String datestr = "";
            datestr = dtime.Year.ToString() + s + dtime.Month.ToString().PadLeft(2, '0') + s + dtime.Day.ToString().PadLeft(2, '0');
            return datestr;
        }

        /// <summary>
        /// ڲ
        /// </summary>
        /// <param name="sdmin">ʼ</param>
        /// <param name="sdmax"></param>
        /// <returns>ڲΪʧ</returns>
		public static int Datediff(DateTime sdmin, DateTime sdmax)
        {
            try
            {
                double i = 0;
                while (sdmin.AddDays(i) < sdmax)
                {
                    i++;
                }
                return Utility.ToInt(i);
            }
            catch
            {
                return -1;
            }
        }

        /// <summary>
        /// ڲ
        /// </summary>
        /// <param name="sdmin">ʼ</param>
        /// <param name="sdmax"></param>
        /// <returns>ڲΪʧ</returns>
		public static int Datediff(String sdmin, String sdmax)
        {
            try
            {
                DateTime dmin;
                DateTime dmax;
                dmin = DateTime.Parse(sdmin);
                dmax = DateTime.Parse(sdmax);
                double i = 0;
                while (dmin.AddDays(i) < dmax)
                {
                    i++;
                }
                return Utility.ToInt(i);
            }
            catch
            {
                return -1;
            }
        }

        #endregion

        #region תû

        /// <summary>
        /// ûַתΪɻС滻Html롢Σݿַȥβհסİȫ롣
        /// </summary>
        /// <param name="inputString">ûַ</param>
        public static string ConvertStr(string inputString)
        {
            string retVal = inputString;
            //retVal=retVal.Replace("&","&amp;"); 
            retVal = retVal.Replace("\"", "&quot;");
            retVal = retVal.Replace("<", "&lt;");
            retVal = retVal.Replace(">", "&gt;");
            retVal = retVal.Replace(" ", "&nbsp;");
            retVal = retVal.Replace("  ", "&nbsp;&nbsp;");
            retVal = retVal.Replace("\t", "&nbsp;&nbsp;");
            retVal = retVal.Replace("\r", "<br>");
            return retVal;
        }

        public static string InputText(string inputString)
        {
            string retVal = inputString;
            retVal = ConvertStr(retVal);
            retVal = retVal.Replace("[url]", "");
            retVal = retVal.Replace("[/url]", "");
            return retVal;
        }


        /// <summary>
        /// htmlʾҳ
        /// </summary>
        /// <param name="inputString"></param>
        /// <returns></returns>
		public static string OutputText(string inputString)
        {
            string retVal = System.Web.HttpUtility.HtmlDecode(inputString);
            retVal = retVal.Replace("<br>", "");
            retVal = retVal.Replace("&amp", "&;");
            retVal = retVal.Replace("&quot;", "\"");
            retVal = retVal.Replace("&lt;", "<");
            retVal = retVal.Replace("&gt;", ">");
            retVal = retVal.Replace("&nbsp;", " ");
            retVal = retVal.Replace("&nbsp;&nbsp;", "  ");
            return retVal;
        }

        public static string ToUrl(string inputString)
        {
            string retVal = inputString;
            retVal = ConvertStr(retVal);
            return Regex.Replace(retVal, @"\[url](?<x>[^\]]*)\[/url]", @"<a href=""$1"" target=""_blank"">$1</a>", RegexOptions.IgnoreCase);
        }

        public static string GetSafeCode(string str)
        {
            str = str.Replace("'", "");
            str = str.Replace(char.Parse("34"), ' ');
            str = str.Replace(";", "");
            return str;
        }

        #endregion


        //#region 

        ///// <summary>
        ///// ˵alertԻ
        ///// </summary>
        ///// <param name="str_Message">ʾϢ,ӣ"!"</param>
        ///// <param name="page">Page</param>
        //public static void Alert(string str_Message,Page page)
        //{
        //    page.RegisterStartupScript("","<script>alert('"+str_Message+"');</script>");
        //}
        ///// <summary>
        ///// ˵alertԻ
        ///// </summary>
        ///// <param name="str_Ctl_Name">ýؼIdֵ,磺txt_Name</param>
        ///// <param name="str_Message">ʾϢ,ӣ"!"</param>
        ///// <param name="page">Page</param>
        //public static void Alert(string str_Ctl_Name,string str_Message,Page page)
        //{
        //    page.RegisterStartupScript("","<script>alert('"+str_Message+"');document.forms(0)."+str_Ctl_Name+".focus(); document.forms(0)."+str_Ctl_Name+".select();</script>");
        //}
        ///// <summary>
        ///// ˵confirmԻ,úи׶,ŵӦ¼,Ŀǰûƽ
        ///// </summary>
        ///// <param name="str_Message">ʾϢ,ӣ"Ƿȷɾ!"</param>
        ///// <param name="btn">BottonťIdֵ,磺btn_Flow</param>
        ///// <param name="page">Page</param>
        //public static void Confirm(string str_Message,string btn,Page page)
        //{
        //    page.RegisterStartupScript("","<script> if (confirm('"+str_Message+"')==true){document.forms(0)."+btn+".click();}</script>");
        //}
        ///// <summary>
        /////  ˵confirmԻ,ѯû׼תӦȷ͡ȡʱĲ
        ///// </summary>
        ///// <param name="str_Message">ʾϢ磺"ɹ,\"ȷ\"ťд,\"ȡ\"޸"</param>
        ///// <param name="btn_Redirect_Flow">"ȷ"ťidֵ</param>
        ///// <param name="btn_Redirect_Self">"ȡ"ťidֵ</param>
        ///// <param name="page">Page</param>
        //public static void Confirm(string str_Message,string btn_Redirect_Flow,string btn_Redirect_Self,Page page)
        //{
        //    page.RegisterStartupScript("","<script> if (confirm('"+str_Message+"')==true){document.forms(0)."+btn_Redirect_Flow+".click();}else{document.forms(0)."+btn_Redirect_Self+".click();}</script>");
        //}

        //#endregion


        /// <summary>
        /// ð󶨵DataGridDataTableļ¼粻ӿ
        /// </summary>
        /// <param name="myDataTable">ݱ</param>
        /// <param name="intPageCount">DataGridҳʱÿҳ</param>
        public static void SetTableRows(DataTable myDataTable, int intPageCount)
        {
            try
            {
                int intTemp = myDataTable.Rows.Count % intPageCount;
                if ((myDataTable.Rows.Count == 0) || (intTemp != 0))
                {
                    for (int i = 0; i < (intPageCount - intTemp); i++)
                    {
                        DataRow myDataRow = myDataTable.NewRow();
                        myDataTable.Rows.Add(myDataRow);
                    }
                }
            }
            catch
            {
                throw;
            }
        }


        public static string GetGuid(string guid)
        {
            return guid.Replace("-", "");
        }

        public static string ReadConfig(string filePath)
        {
            return System.Configuration.ConfigurationManager.AppSettings[filePath];
        }

        #region   ַӢĽȡ
        /// <summary>   
        /// ȡıӢַȣӢһ
        /// </summary>
        /// <param name="str">ȡַ</param>
        /// <param name="length">㳤ȵַ</param>
        /// <returns>string</returns>
        public static string GetSubString(string str, int length)
        {
            string temp = str;
            int j = 0;
            int k = 0;
            for (int i = 0; i < temp.Length; i++)
            {
                if (Regex.IsMatch(temp.Substring(i, 1), @"[\u4e00-\u9fa5]+"))
                {
                    j += 2;
                }
                else
                {
                    j += 1;
                }
                if (j <= length)
                {
                    k += 1;
                }
                if (j > length)
                {
                    return temp.Substring(0, k) + "...";
                }
            }
            return temp;
        }
        #endregion

   
        //һStreamб汨 
        //LocalReportRenderὫҳΪStream
        private List<Stream> m_streams;
        //ṩStreamĺLocalReportRenderĵ
        private Stream CreateStream(string name, string fileNameExtension, Encoding encoding, string mimeType, bool willSeek)

        {
            int pos = 3;
            //ҪݱΪļʹFileStream
            Stream stream = new MemoryStream();
            m_streams.Add(stream);
            return stream;
        }

        //¼ǰӡڼҳ 
        private int m_currentPageIndex;

        private void PrintPage(object sender, PrintPageEventArgs ev)
        {
          int  pos = 6;
            //MetafileEMFWMFʽͼΣ
            //ǰ潫ΪEMFͼθʽ
            m_streams[m_currentPageIndex].Position = 0;
            Metafile pageImage = new Metafile(m_streams[m_currentPageIndex]);
            //ָǷӡ
            ev.PageSettings.Landscape = false;
            //Graphicsʵָ˴ӡ
            ev.Graphics.DrawImage(pageImage, ev.PageBounds);
            m_streams[m_currentPageIndex].Close();
            m_currentPageIndex++;
            //ǷҪӡ
            ev.HasMorePages = (m_currentPageIndex < m_streams.Count);
        }

       
    }
}


