tags: environment

# 01.系统初始化和全局变量

## 若你的服务器是新机，或者只是开了虚拟机来学习使用，可以执行该文档的操作

## 但如果你想在已经投入使用了的生产环境服务器、或者公司服务器上面执行该文档，请慎重！！！请慎重！！！请慎重！！！

## 环境支持

centos 7.0+

## 主机名

+ 设置永久主机名称，然后重新登录:

```
hostnamectl set-hostname server1 # 将 server1 替换为当前主机名
```

+ 设置的主机名保存在 `/etc/hostname` 文件中；
+ 如果 DNS 不支持解析主机名称，则需要修改每台机器的 `/etc/hosts` 文件，添加主机名和 IP 的对应关系：

``` bash
cat >> /etc/hosts <<EOF
172.16.0.6 server01         #192.168.0.148 修改成 server1 的内网ip
EOF
```

## 添加 docker 账户

在每台机器上添加 docker 账户：

``` bash
useradd -m docker
```

## 将可执行文件路径 /opt/docker/bin 添加到 PATH 变量中

在每台机器上添加环境变量：

``` bash
echo 'PATH=/opt/docker/bin:$PATH' >>/etc/profile
echo 'export PATH' >>/etc/profile
source /etc/profile
```

## 安装依赖包

在每台机器上安装依赖包：

CentOS:

``` bash
yum -y install gcc gcc-c++ autoconf automake make  zlib-devel  pcre-devel openssl openssl-devel epel-release conntrack ipvsadm ipset jq iptables curl sysstat libseccomp
/usr/sbin/modprobe ip_vs
```

+ ipvs 依赖 ipset；

## 关闭防火墙

在每台机器上关闭防火墙，清理防火墙规则，设置默认转发策略：

注意： 如果使用的是华为云，在网络主机那一台，禁止执行，否则导致其余服务器无法上网。

``` bash
systemctl stop firewalld
systemctl disable firewalld
iptables -F && iptables -X && iptables -F -t nat && iptables -X -t nat
iptables -P FORWARD ACCEPT
```

## 关闭 swap 分区

如果开启了 swap 分区，kubelet 会启动失败(可以通过将参数 --fail-swap-on 设置为 false 来忽略 swap on)，故需要在每台机器上关闭
swap 分区。同时注释 `/etc/fstab` 中相应的条目，防止开机自动挂载 swap 分区：

``` bash
swapoff -a
sed -i '/ swap / s/^\(.*\)$/#\1/g' /etc/fstab 
```

## 关闭 SELinux

关闭 SELinux，否则后续 K8S 挂载目录时可能报错 `Permission denied`：

``` bash
setenforce 0
sed -i 's/^SELINUX=.*/SELINUX=disabled/' /etc/selinux/config
```

## 关闭 dnsmasq（可选）

linux 系统开启了 dnsmasq 后(如 GUI 环境)，将系统 DNS Server 设置为 127.0.0.1，这会导致 docker 容器无法解析域名，需要关闭它：

``` bash
systemctl stop dnsmasq
systemctl disable dnsmasq
```

## 加载内核模块

``` bash
modprobe br_netfilter
```

## 设置系统时区

``` bash
# 调整系统 TimeZone
timedatectl set-timezone Asia/Shanghai

# 将当前的 UTC 时间写入硬件时钟
timedatectl set-local-rtc 0

# 重启依赖于系统时间的服务
systemctl restart rsyslog 
systemctl restart crond
```

## 更新系统时间

``` bash
ntpdate cn.pool.ntp.org
```

## 关闭无关的服务

``` bash
systemctl stop postfix && systemctl disable postfix
```

## 设置 rsyslogd 和 systemd journald

systemd 的 journald 是 Centos 7 缺省的日志记录工具，它记录了所有系统、内核、Service Unit 的日志。

相比 systemd，journald 记录的日志有如下优势：

1. 可以记录到内存或文件系统；(默认记录到内存，对应的位置为 /run/log/jounal)
1. 可以限制占用的磁盘空间、保证磁盘剩余空间；
1. 可以限制日志文件大小、保存的时间；

journald 默认将日志转发给 rsyslog，这会导致日志写了多份，/var/log/messages 中包含了太多无关日志，不方便后续查看，同时也影响系统性能。

``` bash
mkdir -p /var/log/journal # 持久化保存日志的目录
mkdir -p /etc/systemd/journald.conf.d

cat > /etc/systemd/journald.conf.d/99-prophet.conf <<EOF
[Journal]
# 持久化保存到磁盘
Storage=persistent

# 压缩历史日志
Compress=yes

SyncIntervalSec=5m
RateLimitInterval=30s
RateLimitBurst=1000

# 最大占用空间 10G
SystemMaxUse=2G

# 单日志文件最大 200M
SystemMaxFileSize=200M

# 日志保存时间 2 周
MaxRetentionSec=2week

# 不将日志转发到 syslog
ForwardToSyslog=no
EOF

systemctl restart systemd-journald
```

## 升级内核

``` bash
rpm -Uvh http://www.elrepo.org/elrepo-release-7.0-3.el7.elrepo.noarch.rpm
# 安装完成后检查 /boot/grub2/grub.cfg 中对应内核 menuentry 中是否包含 initrd16 配置，如果没有，再安装一次！
yum --enablerepo=elrepo-kernel install -y kernel-lt
# 设置开机从新内核启动
grub2-set-default 0
```

以下命令：
重启机器后执行！！！
重启机器后执行！！！
重启机器后执行！！！
安装内核源文件（可选，在升级完内核并重启机器后执行）:

``` bash
yum erase kernel-headers -y
yum --enablerepo=elrepo-kernel install -y kernel-lt-devel-$(uname -r) kernel-lt-headers-$(uname -r)
```

## 关闭 NUMA

``` bash
cp /etc/default/grub{,.bak}
vim /etc/default/grub # 在 GRUB_CMDLINE_LINUX 一行添加 `numa=off` 参数，如下所示：
diff /etc/default/grub.bak /etc/default/grub
6c6
< GRUB_CMDLINE_LINUX="crashkernel=auto rd.lvm.lv=centos/root rhgb quiet"
---
> GRUB_CMDLINE_LINUX="crashkernel=auto rd.lvm.lv=centos/root rhgb quiet numa=off"
```

重新生成 grub2 配置文件：

``` bash
cp /boot/grub2/grub.cfg{,.bak}
grub2-mkconfig -o /boot/grub2/grub.cfg
```

## 参考

1. 系统内核相关参数参考：https://docs.openshift.com/enterprise/3.2/admin_guide/overcommit.html
