# 3.10.0 2023年07月09日14:38:57
## build
- spring-boot-starter-parent -> 2.7.13
- spring-cloud-dependencies.version>2021.0.8
- spring-cloud-alibaba-dependencies.version>2021.0.5.0
- nacos.version>2.2.4
- hutool.version>5.8.20
- druid.version>1.2.18
- mybatis-plus.version>3.5.3.1
- dynamic.datasource.version>3.6.1

## refactor
- 组织名称校验时，只判断同一级别下的组织是否重名
- 岗位名称校验唯一性时，只判断同一级别下的岗位是否重名

## fix
- 修改获取IP的方法，便于获取本地iP
- 初始化的租户表数据错误，导致启动后无法正常登录
- 字段connectType的注释和数据，修改为{SYSTEM:系统;CUSTOM:自定义}


# 3.9.0 2022年12月02日22:17:26
## build
- spring-boot > 2.7.6
- nacos.version > 2.1.2
- spring-boot-admin.version>2.7.7
- jasypt.version>3.0.4
- aliyun-java-sdk-core.version>4.6.2
- esdk-obs-java.version>3.22.3.1
- qiniu-java-sdk.version>7.12.0
- gson.version>2.8.9
- jsoup.version>1.15.3
- JustAuth.version>1.16.5
- okhttp3.version>4.10.0
- mybatis.version>3.5.10
- mybatis-spring.version>2.0.7
- dynamic.datasource.version>3.5.2
- jasypt.version>3.0.4
- lombok.version>1.18.24
- tencentcloud-sdk-java.version>3.1.548
- aliyun-java-sdk-core.version>4.6.2
- aliyun-dysmsapi.version>2.0.22
- bce-java-sdk.version>0.10.217
- ip2region.version>2.6.5

## refactor
- lamp-sms: 腾讯和阿里短信发送适配新版本api
- lamp-authority: 登录日志获取浏览器、操作系统等信息方式变更
- lamp-util: spring.factories 文件替换为 org.springframework.boot.autoconfigure.AutoConfiguration.imports
- lamp-log-starter: 适配 ip2region.version 2.6.5
- lamp-cloud-starter: 优化 OkHttpClient 配置
- lamp-echo-starter: 启动时扫描指定包名下需要回显的实体类，优化echo首次回显慢的问题
- lamp-echo-starter: 回显集合数据时，转换为普通类型进行查询

## fix
- 解决 @Async 使用时， ThreadLocal会有问题


# 3.8.2 2022年11月21日14:31:38
## build
- spring-boot-starter-parent > 2.6.13
- spring-cloud-dependencies > 2021.0.5
- spring-cloud-alibaba-dependencies > 2021.0.4.0
- nacos.version>2.1.1
- spring-boot-admin.version>2.6.9
- hutool.version>5.8.10

## refactor:
- 数据权限支持 DataScopeHelper.startDataScope 方式开启

# 3.8.1 2022年09月05日09:27:50
## feat
- NONE、COLUMN、SCHEMA、DATASOURCE模式适配SQL Server
- NONE、COLUMN、DATASOURCE模式适配Oracle
- 调整SCHEMA拦截器
- 新增 mysql.yml、oracle.yml、sqlserver.yml 3个配置文件，根据数据库类型任选其一
- 删除表名、字段名中的转义字符
- 修改file、appendix表中的size字段为size_
- xml中 sysedate()、now() 函数变更为服务器时间
- xml中 true改为1，false改为0
- SqlCondition 修改为 Condition
- 新增lamp-saas-mode模块
- 新增Oracle和SQL Server的sql脚本文件
- 新增最新版本的PDManer源文件

# 3.8.0 2022年08月28日14:10:41
## feat
- NONE、COLUMN、SCHEMA模式适配SQL Server
- NONE、COLUMN模式适配Oracle
- 调整SCHEMA拦截器
- mysql.yml 重命名为 database.yml， 并优化该文件的内容
- 删除表名、字段名中的转义字符
- 修改file、appendix表中的size字段为size_
- xml中 sysedate()、now() 函数变更为服务器时间
- xml中 true改为1，false改为0
- SqlCondition 修改为 Condition

# 3.7.0 2022年05月30日10:29:0
## build
1. 依赖升级
   ```
   spring-boot 2.6.8
   spring-cloud-dependencies.version>2021.0.2
   spring-boot-admin.version>2.6.7
   hutool.version>5.8.1
   fastjson.version>1.2.83
   ```
2. 拆分boot模块为 boot和mvc模块
3. 将annotation模块中的部分model移动到core模块
4. 删除废弃的RemoteData和相关代码
5. 将代码中的字符串lamp替换为常量

## feat
1. 用户和岗位表新增创建人所属机构字段，并在新增数就是给与赋值

## refactor
1. swagger version 调整到 bootstrap.yml 中
2. 废弃lamp-util项目中的lamp-security-starter模块（lamp-security-sdk + lamp-userinfo-sdk = lamp-security-starter模块）
3. 新增lamp-security-sdk模块
4. 新增lamp-userinfo-sdk模块
5. 重构lamp-data-scope-sdk模块，使其解耦不在依赖业务服务的模块
6. 新增lamp-model模块，用于存放业务相关的公共实体和VO
7. 重构lamp-tenant-datasource-init模块，使其解耦
8. 废弃lamp-tenant-datasource模块
9. Echo 重命名为 EchoApi
10. DictionaryType 重命名为 EchoDictType
11. 优化lamp-cloud项目依赖，便于各个服务能独立编译。编译顺序为：lamp-dependencies 、lamp-public 、 lamp-authority、 lamp-msg、lamp-file、lamp-tenant、lamp-oauth
12. @DS("#thread.tenant")修改为@DS(DsConstant.BASE_TENANT)、@DS(DsConstant.EXTEND_TENANT)
13. 新增租户时，表结构和初始数据 脚本调整
14. tenant服务 和 msg服务 启动时，默认连接2个库
15. 调整sql适配3.x的表结构
16. 优化机构管理页面布局
17. 优化角色资源维护页面显示是否默认数据权限标识

## fix
- 修复升级导致的序列化规则失效导致的bug
- 枚举类型空字符串时，报错的bug
- 修复机构类型枚举参数和字典值不匹配
- 修复角色资源维护页面可正常显示资源类型

# 3.6.2 2022年04月09日18:05:33
## build:
```
spring.boot.version>2.6.6
spring.cloud.version>2021.0.1
spring-cloud-alibaba-dependencies.version>2021.0.1.0
spring-boot-admin.version>2.6.6
dynamic.datasource.version>3.5.1
fastjson.version>1.2.80

"ant-design-vue": "3.1.1",
"typescript": "^4.6.3",
"vite": "^2.9.1",
```
## feat
- (BasicTree): 支持设置加载中
- (BasicTable): 表格编辑支持AutoComplete
- (BasicTable): 表单新增name属性。 配置name后，可以解决同一个页面有多个表单且存在相同字段时， 生成的组件字段的id相同的问题


## refactor
- 优化FormItem组件，使得更好的支持required属性
- CollapseContainer 支持手动触发展开关闭


## fix:
- (BasicTable): 修复表格编辑时 Checkbox 组件无法正常取消勾选
- (lamp-cloud): 修复员工的部门未正确设置时，数据权限接口报错
- (lamp-web-pro): 已经存在rules时，required不生效
- (lamp-web-pro): ApiTreeSelect修复 fieldNames
- (lamp-web-pro): 使用了Table的页面去除控制台警告： "Warning: [ant-design-vue: Table] `column.slots` is deprecated. Please use `v-slot:headerCell` `v-slot:bodyCell` instead"
- (lamp-web-pro): 修复Dropdown组件placement属性警告
- (lamp-web-pro): 修复同一个页面使用多个表单时，表单id一致导致的 警告


# 3.6.1 2022年3月10日21:36:31
## build:
```
spring.boot.version>2.5.10
hutool.version>5.7.22
gateway.version>3.0.7
nacos.version>2.0.4
mysql.version>8.0.28
mybatis.version>3.5.9
mybatisplus.version>3.5.1
```
## fix
- 升级gateway版本，修复 [CVE-2022-22947](https://tanzu.vmware.com/security/cve-2022-22947)
- 修复 因为升级mybatis plus导致的不兼容语法

# 3.6.0 2022年01月27日17:21:55
## build:
```
spring-boot-admin.version>2.6.2
hutool.version>5.7.20
```

## feat:
- lamp-cloud-plus：新增全流程数据权限功能。包括：数据权限配置、数据权限授权、数据权限校验、数据权限sql拦截（基于注解动态拼接条件）等全流程！

## refactor
- lamp-web-plus：优化前端角色绑定用户页面交互和性能
- lamp-web-plus：请求拦截器默认携带Path和gray_version参数
- lamp-web-plus：优化菜单管理页面布局和样式



# 3.5.8 2022年1月16日20:02:23
## build
```
spring-boot-admin.version>2.6.1
hutool.version>5.7.19
fastjson.version>1.2.79
lombok.version>1.18.22
caffeine.version>2.9.3
```
## refactor:
- 优化feign拦截器
- 优化注释
## fix:
- 无默认值导致查询租户数据报错
- 字符串常量写错


# 3.5.7 2021年12月27日09:39:27
## build
```
spring.boot.version>2.5.8
spring-boot-admin.version>2.5.5
hutool.version>5.7.18
logback.version > 1.2.9
```
## fix
- 升级logback解决漏洞：CVE-2021-42550

# 3.5.6 2021年12月14日
## build: 3.5.6
```
hutool.version>5.7.17
aliyun-java-sdk-core.version>4.5.30
qiniu-java-sdk.version>7.9.0
```

## fix
- lamp-cloud: 排除第三方依赖的log4j
- lamp-boot: 排除第三方依赖的log4j
- lamp-cloud: 修复 dozer 转换实体报错   （感谢 @一刻 提交的issues）
- lamp-boot: 修复 dozer 转换实体报错   （感谢 @一刻 提交的issues）
- lamp-boot:  swagger配置文件默认值错误  （感谢 @一刻 提交的issues）
- lamp-job: 修复漏提静态文件导致的页面显示不全  （感谢 @一刻 提交的issues）


# 3.5.5 2021年11月28日23:34:30
## build 
- lamp-util依赖升级
```
spring.boot.version>2.5.7
spring-boot-admin.version>2.5.4
hutool.version>5.7.16
```
- lamp-web-plus 依赖升级
```
yarn -> pnpm
moment -> dayjs
vue -> 3.2.22
ant-design-vue > 3.0
```
## refactor
- lamp-cloud: 调整TraceFilter执行顺序,便于网关其他过滤器记录日志信息
- lamp-cloud: 优化RouterMeta，支持前端自定义key
- lamp-cloud: 优化地区爬取接口爬取数据乱码问题
- lamp-cloud: 优化地区爬取接口无法爬取市下面无县的数据
- lamp-cloud: 树结构基础实体新增 addChildren 方法
- lamp-cloud: 优化swagger 聚合结构，使得忽略web socket服务

## fix
- lamp-util: 有请求头参数含有中文时，异步feign调用报错
- lamp-cloud: 修复树型结构无法获取正确拼接层级结构的bug
- lamp-web-plus: 修复树形页面高度固定导致的bug
- lamp-web-plus: 解决TableAction组件Dropdown因为权限导致分割线显示错误的问题
- lamp-web-plus: 修复列表页数据传递到编辑页，数据被误修改的问题

# 3.5.4 2021年11月4日09:04:28
## build
- lamp-util: 依赖升级
```
spring.boot.version>2.5.6
spring-boot-admin.version>2.5.3
mysql.version>8.0.27
hutool.version>5.7.15
```

## feat 
- lamp-web-plus: 包管理器由`yarn`改为 `pnpm`
- lamp-web-plus: 删除`node_modules`和`yarn.lock`，全局安装`pnpm`
- lamp-web-plus: 执行`pnpm install`

## ✨ Features
- lamp-web-plus: `.env`文件中的`VITE_PROXY`配置支持单引号
- lamp-web-plus: 移除 build 过程中的警告
- lamp-cloud: 删除网关无用代码
- lamp-cloud: 调整nacos中mysql.yml的url配置

## fix
- lamp-web-plus: 左侧菜单混合模式 在动态更改路由时，左侧显示的菜单没有实时更新
- lamp-web-plus: 全局日期格式化缺少秒(大多数场景日期格式都需要携带秒！)
- lamp-web-plus: 上传文件报错的bug
- 其他bug


# 3.5.3 2021年10月11日21:03:18
## build 依赖
```
# lamp-cloud
spring.boot.version>2.5.5
spring.cloud.version>2020.0.4
spring-boot-admin.version>2.5.2
hutool.version>5.7.14
druid.version>1.2.8
mybatisplus.version>3.4.3.4
transmittable-thread-local.version>2.12.2

# lamp-web-plus
vue: ^3.2.19
vite: ^2.6.3
axios: ^0.22.0
```
## feat 新增
- lamp-util: 完善验证工具类 ValidatorUtil
- lamp-web-plus: 动态路由 Tab打开数量控制，超出限制自动关闭起始Tab (#1256)
- lamp-web-plus:  动态路由 component 属性支持以 / 开头或者以 .vue 和 .tsx 结尾
- lamp-web-plus:  布局路由 LAYOUT 或 IFRAME 忽略大小写。 并且在通过component找不到页面时打印警告，并返回404页面
- lamp-web-plus:  隐藏面包屑应交给 hideBreadcrumb 参数，而非hideMenu 参数

## fix 修复
- lamp-oauth: 保存日志返回值错误
- lamp-file: 文件上传接口，返回的url地址拼接错误
- lamp-authority: 重置密码接口，无需校验当前密码
- lamp-web-plus: 去除 fixedHeight 固定主体区域高度 限制
- lamp-utils: 修复按日期查询时，能正确查询开始时间的0点-结束时间24点的数据


# 3.5.2 2021年09月18日10:35:14
## build: 依赖
```
spring.cloud.version>2020.0.4
spring.boot.version>2.5.5
mybatisplus.version>3.4.3.4
hutool.version>5.7.13
```
## feat:
- 附件回显支持list
- 在执行sql时，忽略 租户插件自动拼接租户编码的表 (仅 COLUMN 模式有效)
- **lamp-web-plus** `.env`文件中的`VITE_PROXY`配置支持单引号
- 优化lamp-boot无用的依赖

## fix:
- 修复token过期后，无法自动退回登录页面的bug
- 修复错误的注释描述
- 角色维护时，只有数据范围选择了 自定义 时，才保存机构信息
- **lamp-web-plus BasicTable**
  - 修复可编辑单元格某些情况下无法提交的问题
  - 修复`inset`属性不起作用的问题
  - 修复`useTable`与`BasicTable`实例的`reload`方法`await`表现不一致的问题
- **lamp-web-plus BasicModal**
  - 修复点击遮罩、按下`Esc`键都不能关闭`Modal`的问题
  - 修复点击关闭按钮、最大化按钮旁边的空白区域也会导致`Modal`关闭的问题
- **lamp-web-plus BasicTree** 修复节点插槽不起作用的问题
- **lamp-web-plus 其它** 修复多标签在某些情况下关闭页签不会跳转路由的问题


# 3.5.1 2021年08月31日
## build: 依赖
```
spring.boot.version > 2.5.4
mybatisplus.version > 3.4.3.1
antisamy.version>1.6.4
hutool.version>5.7.10
```

## feat: 新增
- seata 1.4.2 的配置
- 用户管理页面，头像回显功能完善
- 新增可配置选项： 在执行sql时，忽略 租户插件自动拼接租户编码的表 (仅 COLUMN 模式有效)
- 新增可配置选项：分页插件支持更多的配置参数

## refactor： 增强
- 注释完善
- 默认的Controller分页查询，支持更多的扩展参数

## fix: 修复
- 实时获取文件访问地址失败时，忽略报错
- token 过期后，统一返回401状态码，使页面自动跳转到重新登录
- 排除slf4j冲突jar，解决控制台启动警告


# 3.5.0 2021年08月17日21:22:33

## build: 依赖

```
nacos -> 2.0.3
seata -> 1.4.2
aliyun-java-sdk-core.version > 4.5.25
aliyun-java-sdk-dysmsapi.version>2.1.0
bce-java-sdk.version>0.10.174
aliyun-sdk-oss.version>3.13.0
hutool.version>5.7.8
fastjson.version>1.2.78
spring-boot-admin.version>2.5.0
caffeine.version>2.9.2
protostuff.version>1.7.4
```

## feat: 新增
- 按阿里规范，调整代码
- 认证服务：开发环境 免密码 和 免验证码 登录配置开关，方便开发、测试环境调试
- 文件服务：本地存储支持设置bucket参数，用于区分环境
- 权限服务+lamp-web-plus： 新增个人中心页面，支持修改个人基本信息 + 修改头像 + 修改个人密码 + 个人登录日志查看
- lamp-core： 新增 ArgumentAssert 断言工具类， 废弃 BizAssert， 新增ArgumentException异常
- lamp-wep-plus: 文件管理 支持客户端控制上传附件时传递的参数
- 消息服务+lamp-web-plus： 新增 websocket 示例代码
- 生产配置：提供 演示环境 nginx 配置，仅供参考
- 生产配置：nacos中配置文件调整
- 消息服务+lamp-web-plus： 完善通知公告页面，完善右上角小铃铛功能
- lamp-core：同步最新版 EnumDeserializer 代码
- 消息服务+lamp-web-plus： 完善通知公告和右上角小铃铛通知中心
- 认证服务：隐藏不需要暴露给前端使用的接口文档

## refactor： 增强

- lamp-databases：Wraps.getDbField 方法根据实体类的 field 名获取表的 column 名支持TableId， 并优化异常时提示
- lamp-boot： 新增 PageParams.buildPage(Class<?> entityClazz)、和 public PageParams(long current, long
  size)，原 PageParams.buildPage() 方法不再支持排序，避免sql注入风险。

# fix: 修复

- 文件服务： 查询fastdfs存储时，返回的文件访问url错误异常
- 修改项目包名时，误将 common 替换成 topmon
- 修复path类型的参数，在swagger中的显示方式
- 文件服务: 修复公开资源文件的url地址拼接问题
- 消息服务：删除消息的入参格式调整为json
- 租户服务：删除租户的入参格式调整为json


# 3.4.0 2021年07月26日22:46:42
## build 依赖
```
guava.version > 30.1.1-jre
```
- lamp-util 项目的 com.tangyh.basic 包修改为 top.tangyh.basic
- lamp-boot 项目的 com.tangyh.lamp 包修改为 top.tangyh.lamp
- lamp-cloud 项目的 com.tangyh.lamp 包修改为 top.tangyh.lamp

## feat: 新增
- 使用自己的域名作为groupId, 并将lamp-util发布到 maven 官方中央仓库，方便开发者快速上手

## refactor: 优化
- 修复代码生成器生成的分页列表页面直接回显枚举、字典等字段

## fix: 修复
- 修复代码生成器生成的新增/编译页面赋值逻辑覆盖默认值的问题
- lamp-boot项目错误的依赖了lamp-cloud项目的api模块


# 3.3.0 2021年07月24日00:32:53

## build: 依赖升级
```
spring.boot.version > 2.5.3
spring.cloud.version > 2020.0.3
spring-cloud-alibaba-dependencies.version > 2021.1
sentinel.version > 1.8.2
qiniu.version > 7.8.0
hutool.version > 5.7.5
minio.version > 8.2.2
```

## feat: 新增
- 废弃 zipkin-client
- 废弃 hystrix 改用 sentinel
- 用 spring-cloud-starter-loadbalancer 代替 ribbon
- 文件中心支持 七牛云OSS、 华为云OSS
- 新增附件sdk lamp-file-sdk， 用于业务表保存、查询业务附件
- 短信模板配置 和 短信任务发送 支持创蓝短信商
- 同一个前端表单有多个查询同样数据源的ApiSelect组件时，只发起一次请求。
- 后端获取枚举接口改为启动时，采用静态扫描方式。
- 新增ClassUtils工具类，提供批量静态扫描源码以及jar中指定包下的class类，且支持通配符和分隔符。
- 集合工具类CollHelper新增 List 转 MultiMap 的方法
- 枚举接口 BaseEnum 新增扩展接口 getExtra，并调整枚举序列化类EnumSerializer，使得实现了BaseEnum的类字段能返回extra属性
- xss 支持过滤 embed、objec、meta、link、expression、vbscript等标签 @杨慕义

## refactor： 重构优化
- lamp-cloud-starter 灰度策略组件重写
- FeignClient 全局 fallback处理器重写
- yml中配置的灰度发布元数据参数 grayversion 改为 gray_version, 并支持通过配置文件指定是否启用
- 重构短信动态参数解析正则表达式，由原map结构改成list结构， 兼容创蓝、腾讯云等顺序参数和相同变量名参数。
- 完全重构文件中心，支持同时启用 本地、FastDFS、MinIO、阿里云、七牛云、华为云混合上传。并支持上传时由客户端（前端）指定选择存储类型
- 文件中心废弃 c_attachment 表，新增 c_file(文件上传记录) 表，所有业务服务新增 c_appendix (业务附件表)
- minio docker脚本适配最新版
- 调整租户管理页面租户头像字段，适配新的附件上传流程
- 调整附件管理页面，适配新的附件上传流程
- 调整消息中心富文本编辑框，适配新的附件上传接口
- 调整oauth服务的 enumLists 接口为 enumList
- 优化网关swagger聚合文档类：SwaggerResourceConfig， 只从已正常运行的服务中获取文档。

## fix： 修复

- 修复NONE模式，无法登录的问题
- 获取枚举接口，错误的返回文件中心的枚举值
- 修复在线用户接口，可以查到所有租户的在线用户

# 3.2.5 2021年07月13日20:09:30

## build: 依赖升级

```
  spring.boot.version>2.3.12.RELEASE
  spring.cloud.version>Hoxton.SR12
  nacos.version>2.0.2
  druid.version>1.2.6
  mybatis.version>3.5.7
  mybatisplus.version>3.4.3.1
  knife4j.version>2.0.9
  hutool.version>5.7.3
```

## feat:

- 增加 SCHEMA + 字段 混合模式： SCHEMA_COLUMN
- 增加 数据源 + 字段 混合模式：DATASOURCE_COLUMN

> 适用于一个连锁店多个分门店、一个集团多个分子公司、一个商户多个售货机 等场景

- Echo模块支持内存缓存，默认关闭。

## fix:

- 新增租户时，初始化的菜单图标使用ant design样式

## refactor:

- Echo注解取消method字段。
- 调整 LoadService接口 单一职责，删除findNameByIds方法。

> 可以通过新增多个实现类来替代method和findNameByIds的功能

# 3.2.4 2021年07月07日12:46:50

- feat: 发送短信页面，发送状态支持多选查询
- refactor: 规范工作流接口地址和请求方式
- fix: 修复角色id非空判断异常
- refactor: PageController query、handler*等方法的优化，使得每个方法职责更加明确
- feat: 增加cache模块启动加载日志
- refactor: 网关增加熔断日志
- fix: 去除MioIO的启动默认加载配置
- fix: 修复 WriteInterceptor 空指针
- fix: 修复统一分页参数处理方法handleFetchParams，选择了时间区间参数时，无法传递普通参数的问题

# 3.2.3 2021年06月28日00:34:15

- RedisOps、CachePlusOps新增scan、unlink、scanUnlink等接口，并优化del接口
- CacheKeyBuilder 新增getPattern接口
- SysLogAspect过滤记录ServletRequest、ServletResponse参数
- PageController分页查询接口调整
- 将banner.txt、spy.properties等文件抽取到lamp-common项目
- ContextUtil 调整为`TransmittableThreadLocal`, 支持父子线程变量传递
- 新增全局的异步任务线程池配置 `ThreadPoolTaskExecutor`
- 组织删除时，有用户禁止删除
- 调整部分restful风格接口，方便前端调用
- 机构名称、资源编码唯一性校验
- 角色、用户、菜单、字典、操作日志、在线用户等接口调整
- 新增参数批量查询接口
- 重构附件上传、下载等功能实现，调整部分接口的uri地址和请求方式
- 支持通过配置控制 是否调用删除附件接口时，是否物理删除文件系统中的文件
- lamp-web-plus新增：延迟批量回显图片的组件（支持MinIO和Local)
- 优化消息中心、短信模板、短信中心相关功能实现
- 重新设计项目架构图
- 提供基于CentOS 8部署jdk、jenkins、docker、lamp-cloud的文档。
- 完善jenkins以jar方式部署lamp-cloud项目的 部署文档、Jenkinsfile配置文件、nginx配置文件，并提供https访问解决方案
- 提供用户、岗位导入模板
- 演示地址变更为：
  - 后端使用lamp-cloud-plus，前端使用lamp-web-plus。演示地址： https://pro.tangyh.top
  - 后端使用lamp-cloud-plus，前端使用lamp-web。演示地址： https://pro.tangyh.top/lamp-web
  - 后端使用lamp-boot-plus， 前端使用lamp-web-plus。演示地址： https://boot.tangyh.top
  - 后端使用lamp-boot-plus， 前端使用lamp-web。演示地址： https://boot.tangyh.top/lamp-web

# 3.2.2 2021年05月25日11:03:48

- fix(core):  枚举值传""和 null时报错的bug
- fix(lamp-file): 修复附件下载报错
- fix(lamp-generator): 修复代码生成器生成树型页面重复字段的问题
- refactor(boot): 优化PoiController，导出和导出预览功能，使得子类更容易重写导出数据
- refactor(authority): 完善用户、岗位管理导入、导出功能， 支持下载模板、导出预览、直接导出
- refactor: 组织名、岗位名、用户账号唯一性校验
- feat(lamp-web-plus): 完善组织、岗位、用户模块页面的CRUD功能，并优化导入、导出组件
- feat(lamp-samples): 新增示例项目，提供常见用法的示例。（如： None模式多数据源配置、分布式事务解决方案、缓存使用、数据回显、前后端统一验证等）

# 3.2.1 2021年05月17日15:32:55
- feat: 增强mybatis plus的 行级(column) 租户插件(TenantLineInnerInterceptor) 支持where条件后拼接多个租户id
- feat(log): 优化logback配置文件，并让开发和其他环境更好的使用不同的日志配置 （新增defaults-async.xml、defaults-sync.xml）
- feat(authority): 岗位管理导入参数验证
- feat: 前端lamp-web-plus项目完成数据源管理、租户管理、全局用户管理、组织管理页面的对接
- feat: lamp-generator-plus项目支持前端lamp-web-plus项目生成代码
- fix(core): 修复枚举类型反序列化报错
- fix(org): 修复根组织的tree_path字段问题
- fix(boot): 导出excel时，标题为设置导致的bug
- fix(activiti): 修复工作流在线预览报错
- refactor(boot): DeleteController 调整delete接口的参数接收方式
- refactor(bootstrap.yml): 调整配置文件中NACOS_ID为NACOS_NAMESPACE
- refactor(authority): 优化组织管理新增修改接口
- refactor(tenant): 优化全局用户CRUD功能并修复查询bug、支持多选条件查询
- refactor(oauth): 字典、枚举查询接口调整为post格式
- refactor(tenant)：优化租户功能

# 3.2.0 2021年04月18日17:20:32

- build: 📣📣📣 升级为jdk11，不向下兼容（想继续使用jdk8 需要自行调整几个配置的版本）
- build: 调整项目依赖
  ```
    spring.boot.version>2.3.12.RELEASE
    fastjson.version>1.2.76
    transmittable-thread-local.version>2.12.1
    lombok.version>1.18.20
    hutool.version>5.6.3
    caffeine.version>3.0.1
  ```
- refactor: 🎉🎉🎉 validator模块 新增自定义注解（NotEmptyPattern）、优化验证规则格式
- feat: 🎉🎉🎉 lamp-web-plus前端项目，新增formValidateService.ts组件1.0版本(还有优化空间)，集成了后端validator模块，真正意义上实现了表单前后端统一校验！
- refactor: 优化uid+databases模块：不在需要@Resource注解、命名规范化
- feat: cache模块支持 protostuff 序列化
- perf: 优化 cache模块 RedisOps 类相关API
- fix: cache模块修复一系列 bug
- fix: 修复登录日志统计接口bug
- fix: 修改jwt解析时设置解析token时允许的误差为5分钟，解决服务器时间不一致导致的解析token失败！
- build: 废弃zuul

# 3.1.2 2021年03月27日23:30:07

- build: 调整项目依赖
- feat: 新增lamp-all模块，聚合lamp-util项目所有的模块，方便业务服务快速依赖
- feat: lamp-web-plus 页面完善
- feat: 支持MinIO
- feat: URI 权限支持动态修改nacos中配置，实现启用禁用
- fix: RedisOps 修复缓存穿透的bug
- feat: RedisOps 优化hGetAll方法
- build: lamp-injection-starter 模块重构为lamp-echo-starter, 部分反射出来的字段和注解数据加入缓存， 废弃原来的内存缓存
- feat: lamp-echo-starter模块新增EchoVO和LoadService接口， 使用方式变更
- refactor: 回显字典的查询接口逻辑调整
- refactor: 字典的CRUD方法重构，并调整缓存存储方式。
- refactor: 调整表的注释

# 3.1.1 2021年03月10日20:32:54

- feat: 前端项目集成 vue-vben-admin(vue3.x + vite 2.x)
- feat: 首页统计接口增加用户数统计
- build: 依赖升级
  ```
  spring.boot.version>2.3.9.RELEASE 
  spring.cloud.version>Hoxton.SR12
  spring-cloud-alibaba-dependencies.version>2.2.5.RELEASE 
  nacos.version>1.4.1 
  druid.version>1.2.5 
  mybatisplus.version>3.4.2 
  hutool.version>5.5.9
  lombok.version>1.18.18
  ```

# 3.1.0-PRE.1 2021年01月29日17:48:05

- feat: 支持动态配置验证码类型和属性，并支持热更新
- fix: 自定义数据权限时， 不在查询子组织
- feat: 新增 xxFileView 的 Dockerfile 和 启动脚本
- feat: 新增通过feign远程调用时，无需校验URI权限 #70
- feat: json格式提交 RemoteData 字段增加两种传参格式 (sex:xxx 和 sex:{key:xxx})   #70
- feat: 统一无效登录、无效权限等情况的错误码为401、403
- 新增基于 vue-admin-beautiful 二次开发的全新前端项目： lamp-web-beautiful 预览版

# 3.0.2 2021年01月11日09:43:54

- Controller返回值增加全局返回对象包装配置类 (AbstractGlobalResponseBodyAdvice)
- DATASOURCE模式新增lamp-tenant-datasource-init模块用于处理租户模式启动和运行时打加载数据源
  （原lamp-tenant-datasource模块只由tenant服务依赖，lamp-tenant-datasource-init由其他服务依赖））
- 新增lamp-common-api模块，存放公共API
- 修复修改用户密码的bug #fix I2ATCU
- 新增基于xxl-job改造的定时任务项目
- DATASOURCE模式适配lamp-job项目

# 3.0.1 2020-12-16 16:02

- 支持优雅停机
- 简化BaseConfig中全局jackson配置
- jwt 配置坐标由原来 `authentication.xxx` 切换成 `lamp.authentication.xxx`
- 修复 LampMetaObjectHandler 在修改时注入修改人id没有判断类型的bug
- 优化项目依赖
- 完善文档、优化配置文件、优化sql脚本、优化启动项目脚本
- 代码生成器支持lamp-boot项目

# 3.0.0 (2020-12-07 18:00:00)
## 项目结构调整
- 项目名改动：

  | 原开源项目 | 现开源项目 |  原会员项目 | 现会员项目 | 备注 |
    |---|---|---|---|---|
  | zuihou-admin-cloud | lamp-cloud | zuihou-cloud-plus | lamp-cloud-plus | 微服务版 | 
  | zuihou-admin-boot | lamp-boot | zuihou-boot-plus | lamp-boot-plus | 单体版 |
  | zuihou-commons | lamp-util | zuihou-commons-plus | lamp-util-plus | 业务无关的工具集 | 
  | zuihou-generator | lamp-generator | zuihou-generator-plus | lamp-generator-plus | 代码生成器 |
  | zuihou-ui | lamp-web | zuihou-ui | lamp-web-plus | 租户管理后台 | 
  | zuihou-admin-ui | lamp-web | zuihou-admin-ui | lamp-web-plus | 运营管理后台（3.0以后：zuihou-ui和zuihou-admin-ui合并为lamp-web） | 
- 配置文件中配置的登录账号和密码修改为：lamp/lamp
- zuihou-ui 和 zuihou-admin-ui 的功能合并到 lamp-web
- common.yml、mysql.yml 等配置文件调整， 适配SpringBoot2.3.6
- zuihou-order 更名为 lamp-example
- zuihou-msgs 更名为 lamp-msg
- 废弃 lamp-j2cache-starter， 全面使用 lamp-cache-stater；
- lamp-util(原zuihou-commons) 项目新增 lamp-annotation 模块， 将系统中常用的注解、model、枚举等抽离出来，降低多模块业务系统依赖耦合性
- 废弃jobs服务，3.0.1版本独立定时服务为单独的项目。为什么废弃？
  1. xxl-job的代码质量太差，大量代码不符合代码扫描器的规范！！！ 
  2. 定时服务调度器是一个独立的跟业务无关的项目，不宜跟业务项目放在一起; 
  3. 采用的xxl-job版本过低; 

## 数据库调整
- 使用PDMan整理表结构，并制作关系图
- create_user 字段改成 created_by、 update_user 改成 updated_by
- 大量表的字段重命名
- 数据字典表的数据重置；c_common_dictionary + c_common_dictionary_item 合并为一张表： c_dictionary
- 关于状态字段根据业务含义统一命名为: state、status
  - 如（隐藏、显示），（是、否），（可用、不可用）、(启用、禁用) 等字段用 state
  - 如 OrderedStatus, ShippingStatus,ReceiptedStatus 等字段用 status
- 数据库表名、表结构全面按照规范重建

## 代码&功能调整
- 版本升级：
    ```
    spring.boot.version > 2.3.6.RELEASE
    spring.cloud.version > Hoxton.SR9
    spring-cloud-alibaba-dependencies.version > 2.2.3.RELEASE
    seata.version > 1.3.0
    nacos.version > 1.4.0
    spring-boot-admin.version > 2.3.1
    knife4j.version -> 2.0.8
    springfox.swagger.version -> 2.10.5
    swagger-models.version -> 1.5.22
    druid.version -> 1.2.3
    mysql.version -> 8.0.22
    mybatis.version -> 3.5.6
    mybatis-spring.version -> 2.0.6
    mybatisplus.version -> 3.4.1
    transmittable-thread-local.version -> 2.12.0
    fastjson.version > 1.2.75
    commons-io.version > 2.8.0
    lombok.version > 1.18.16
    hutool.version > 5.5.2
    antisamy.version > 1.5.10
    caffeine.version > 2.8.6
    maven-source-plugin.version > 3.2.1
    maven-javadoc-plugin.version > 3.2.0
    ```
- 废弃全系统中@Autowired注入方式， 全部换成构造器注入！
- SuperCacheServiceImpl 中默认的缓存采用CacheOps。
- swagger自动配置支持通过`;`号配置多个包
- 修复若干FindBugs Plugin、Alibaba Java Coding Guidelines plugin扫描的问题代码    
- PageParams#map 改成  PageParams#extra
- 原zuihou-log-starter模块， com.github.lamp.log.logback.zuihou-defaults.xml 改名为： com.tangyh.basic.log.logback.defaults.xml
- 原来命名为 My* 的类更名为 Lamp* 
- 不符合规范的抽象类、工具类等类名按照阿里扫描规范、FindBugs规范重构    
- 默认的数据库ID生成方式调整为HUTOOL的工具类
- R 删除 getIsError() 方法(前端使用isError判断的改成!isSuccess)， 新增errorMsg(记录原生的报错信息)。   
- 废弃CodeGenerate、AbstractDistributedLock、QueueConstants类
- 优化InjectionCore、ValidatorConfiguration
- LampMetaObjectHandler 逻辑增强，支持未继承基类的实体注入id、创建人、创建时间、修改人、修改时间
- pom文件中 `<relativePath>../</relativePath>` 调整为 `<relativePath>../pom.xml</relativePath>`
- 原zuihou-msgs服务中的包名、类名中涉及`Msgs`的全部替换成`Msg`     
- user表增加字段： salt， 密码修改为salt + sha256算法
- c_resource（原c_auth_resource）表的资源编码调整为3级：服务:功能:操作点  如：authority:org:add、authority:org:update
- 内置0000租户新增内置4个角色5个账号
- 资源编码参考shiro实现支持`:*,;`等通配符。 冒号作为权限分隔符，星号匹配任意字符串，逗号指定多个权限，分号支持配置多个编码。
- 重写登录、退出、清除缓存接口逻辑  
- 修复消息中心发送全部用户时的bug
- 修复数据源模式测试连接无法关闭数据源链接的bug
- 数据字典表合并为一张， 并重写前端后端代码
- lamp-web中新增在线用户功能页面
- lamp-web前端项目支持全局配置 左侧菜单是否可以同时展开多个
- lamp-web 中 VUE_APP_IS_MULTI_TENANT 参数变更为 VUE_APP_IS_MULTI_TENANT_TYPE
- lamp-web 中 e-icon-picker 组件支持svg图标
- 后端调整字典查询接口（`/dictionary/codes`），方便前端获取字典数据时可以控制多个属性
- 前端项目中大写命名的文件，统一改成小写开头 

# 2.7.0 (2020-11-05 23:30)
- fix: 修复任务启动后，更新任务触发时间，不生效  fix:29
- fix: redis持久化策略不影响全局配置
- feat: 合并ContextHandlerInterceptor、TenantContextHandlerInterceptor、MdcHandlerInterceptor 为 HeaderThreadLocalInterceptor， 专门用于处理请求头中的参数封装到ThreadLocal
- feat: TokenContextFilter支持单独配置忽略tenant、忽略token
- feat: IgnoreTokenProperties 重命名为 IgnoreProperties，并将原来的配置`ignore.token.url`改成`zuihou.ignore.xxx`
- feat: 废弃无用的单元测试
- feat: apache的StringUtils替换为hutool的StrUtil
- feat: xss-starter相关功能支持通过配置文件配置
- feat: SysLog注解支持获取当前线程上下文中的参数.  用法 #threadLocal.name
- feat: 数据注入代码结构、注释优化
- feat: 数据注入支持忽略注入指定字段
    ```
    injectionCore.injection(user, "org", "nation");
    ```
- feat: 代码注释完善若干、代码逻辑优化若干、修复bug若干

# 2.6.0  (2020年10月22日 20:40:00)
- 新增工作流Activiti服务 及 相关例子 （暂不支持DATASOURCE模式）
- 新增符合redis原生命令方法名的操作类：RedisOps
- 重构 zuihou-cache-starter 模块， 为3.x版本全面替换缓存方案做准备。
  - 新增缓存统一操作类： CacheOps、CachePlusOps 。 目前有基于Redis和Caffeine的2种实现方式
  - 统一缓存Key工具类： CacheKey，内部封装了key的前缀（固定值）、后缀（动态参数）、有效期
  - 支持缓存空对象
- 修复租户初始化链接时方法的无本地事务问题
- 修复参数管理可以新增相同key的参数的bug
- 修复字典管理可以新增相同类型的字典和相同编码字典项的bug
- 数据注入支持注入逗号分割的多个字典（数据库存: code1,code2  注入后，返回： name1,name2)
- 修复缓存的key没有拼接租户编码，导致角色配置权限后清理缓存失效的bug
- mysql 的 dockerfile 新增密码永不过期的配置
- 优化模糊查询类型转换器，相关方法抽取出来
- URI权限控制，新增判断角色和权限的方法
- SuperCacheController 类新增重置缓存和清理缓存的方法
- 岗位管理支持时间区间查询
- 分页参数对象PageParams，新增偏移量方法
- 认证服务众多Controller合并
- 优化代码若干、修复bug若干、编写bug若干
- COLUMN模式新建租户时，增加菜单项
- 菜单图标换成： e-icon-picker 
- 修复登录页面记住密码输入框背景色很黑的bug

# 2.5.2 升级日志  (2020年09月27日19:35:30)
- 依赖升级 knife4j.version -> 2.0.5 jjwt.version -> 0.11.2 hutool.version -> 5.4.2
- 新增UidGenerator，基于Snowflake算法的唯一ID生成器。支持自定义workerId位数和初始化策略,从而适用于docker等虚拟化环境下实例自动重启、漂移等场景。
- 修复定时任务服务启动bug
- 修复升级 mybatis-plus 3.4.0 后， 和数据权限拦截器冲突产生的bug
- 缓存key增加租户编码，防止多租户缓存冲突  fix #23
- 修复COLUMN模式新增租户时，创建的内置的管理员无法登录的bug
- 修复DATASOURCE模式影响的网关启动时报错的bug
- BeanPlusUtil 移动到 zuihou-boot ，并支持IPage
- 修复租户禁用后，还能登录zuihou-ui的bug 
- zuihou-ui 菜单管理页面支持配置svg图标
- zuihou-ui 修复多级路由的显示、样式等问题
- zuihou-ui 左侧菜单支持显示svg图标
- zuihou-ui 优化404页面
- 完善源码中的注释、文档、错误打印的日志、删除无用代码等若干项
- zuihou-admin-boot项目 的启动端口调整成 8760， 方便前端调用
- zuihou-admin-boot项目 的租户库调整成 zuihou_boot ，方便与 cloud 区分开。

# 2.5.1 升级日志 (2020年09月05日19:35:30)
- 升级依赖 mybatisplus.version -> 3.4.0 mybatis.version -> 3.5.5 mybatis-spring.version -> 2.0.5 p6spy.version -> 3.9.1
- 独立租户服务(zuihou-tenant-server)，需要租户模式(zuihou-admin-ui)的就启动租户服务(TenantApplication)。zuihou_none模式和不需要新增租户的无需启动，使得租户功能、权限功能最小化 💥💥💥 
- 新增租户时，DATASOURCE模式支持指定任意数据库作为租户的数据源 🎉🎉🎉
- 支持每个服务的租户库独立数据库 （之前的版本默认都是zuihou_base_xxxx) 🎉🎉🎉
- 将DATASOURCE模式 zuihou-authority-server/src/main/resources/sqls/ 下的初始化租户库脚本，分散到各个服务 🎉🎉🎉
- 将SCHEMA模式 zuihou-authority-server/src/main/resources/sqls/ 下的初始化租户库脚本，调整到租户服务 🎉🎉🎉
- 修复新增数据源时，网关服务无法动态新增数据源的bug
- 修复升级版本后DATASOURCE模式无法使用p6spy打印sql的bug
- 新增TenantP6SpyLogger：用于 p6spy 在输出的sql日志中，打印当前租户、当前用户ID、当前数据源连接url
- 修复p6spy配置文件配置项使用错误的bug
- 修复p6spy批量操作打印SQL日志重复的问题
- 优化mybatis plus升级后提示的过时代码
- SCHEMA、COLUMN模式实现插件调整成 MP 3.4.0 版本最新插件
- 优化 SuperCacheServiceImpl 类几个批量操作方法的逻辑
- 升级docs/dockerfile/ 下的 mysql8 和 nacos脚本，使得 nacos 升级到1.3.1并完全支持mysql8 🎉🎉🎉
- 新增租户时，内置超级管理员(admin)，用于维护、管理整个SaaS平台，拥有一切权利，能登录到任意的租户系统中，查看其数据。 🎉🎉🎉
- 优化登录接口性能（查询租户、应用、用户表走缓存）
- SuperCacheService 新增getByKey方法 
- 修复 AttachmentController#findAttachmentByBiz 接口和父类接口冲突
- 修复地区管理查询数据的bug
- 优化重置用户密码功能
- 用户表新增readonly字段
- org表新增类型字段，用于区分单位或者部门
- 修复限流功能设置了有效期时的bug
- 新增zuihou-public公共模块，将zuihou-common(业务公共包)、zuihou-tenant-datasource(数据源模式插件包)等跟业务相关的工具类、插件、业务公共类等移到该模块下
- 修复shells/linux/start.sh启动脚本参数位置错误的bug
- 修复代码不完全兼容NONE模式的bug
- SCHEMA、DATASOURCE 模式各个服务链接的库和描述 | 后台服务 | 项目名 | 启动时连接的库 | 运行时租户库 | 功能描述 |  
|---|---|---|---|---| | 认证服务 | zuihou-oauth | zuihou_defaults | zuihou_base_{tenant} | 负责登录、用户必备的数据接口 | | 权限服务 | zuihou-authority | zuihou_defaults | zuihou_base_{tenant} | 权限、公共、组织架构等基础功能。 后期考虑更名为 zuihou-base(欢迎提建议) |
  | 文件服务 | zuihou-file | zuihou_defaults | zuihou_base_{tenant} | 负责文件上传、下载等功能 | | 消息服务 | zuihou-msgs | zuihou_defaults | zuihou_base_{tenant} | 负责站内信、消息、短信、邮件等功能 |
  | 租户服务 | zuihou-tenant | zuihou_defaults | zuihou_defaults | 负责租户模式管理租户 | | 网关服务 | zuihou-gate | zuihou_defaults | zuihou_extend_{tenant} | 负责统一路由、认证、限流等 |
  | 订单服务 | zuihou-order | zuihou_defaults | zuihou_extend_{tenant} | 演示用 | | 演示服务 | zuihou-demo | zuihou_defaults | zuihou_extend_{tenant} | 演示用 |
  | 定时服务 | zuihou-jobs | zuihou_defaults | zuihou_base_{tenant}、zuihou_extend_{tenant} | 负责定时任务 |

# 2.5.0 升级日志（2020年08月10日20:28:56）
1.
 ```
 spring-boot-maven-plugin.version -> 2.2.9
 spring-boot-admin.version -> 2.2.4
 dynamic.datasource.version -> 3.2.0
 mysql.version>8.0.21
 easypoi.version>4.2.0
 hutool.version>5.3.10
 caffeine.version>2.8.5
 ```
2. 优化SpringCloud（zuihou-cloud-starter）相关功能
3. 新增限流功能
4. 新增IP黑名单功能
5. 修复zuihou-jobs-server无法显示图标的bug

# 2.4.1 升级日志 （2020年08月03日07:54:43）
1. 用户信息返回给前端时，忽略密码字段
2. 修复zuihou-ui - 用户管理 - 修改用户信息时，会将用户密码多次修改的bug
3. 修复zuihou-ui - 用户管理 - 新增单独的修改密码功能
4. 修复zuihou-admin-ui - 全局用户 切换企业为租户后，修改用户时，无法回显企业的bug
5. 修复zuihou-admin-ui - 全局用户 修改页面无法正常回显企业的bug
5. 优化zuihou-admin-ui - 全局用户 修改页面去除密码修改功能。
6. 新增zuihou-admin-ui - 全局用户 新增独立的修改密码功能
7. 优化批量替换项目名&包名&前缀的Shells脚本（支持Linux&Mac） (位于docs/批量替换项目脚本)
8. 新增基于Java代码实现的批量替换项目名&包名&前缀的方法（支持Window&Linux&Mac）(位于docs/批量替换项目脚本) （感谢 @☜☞E牛仔 贡献）
9. 修复删除租户时，无法删除所有服务的数据库的bug

# 2020年07月13日14:27:27 升级日志

1. 新增批量替换项目名&包名&前缀的Shells脚本（支持Linux&Mac）    (会员版才有)
2. 完整的项目讲解视频                                        (会员版才有)
3. 优化代码若干 & 删除无用代码和注释掉的代码若干 & 完善代码注释若干
4. 调整了nacos中的所有配置文件
5. 优化整个项目所有的枚举类型（删除枚举类型上标记的@JsonFormat(shape = JsonFormat.Shape.OBJECT) ）
6. 废弃zuihou-sacn-stater模块
7. 修复通用短信验证码发送的bug
8. 修复zuihou-admin-ui上传租户头像报错和无法修改头像成功的bug
9. 修复zipkin + seata整合时冲突报错 10.废弃SystemApi模块 11.依赖升级 spring.boot.version -> 2.2.7.RELEASE spring.cloud.version -> Hoxton.SR3 dynamic.datasource.version -> 3.1.0
   mybatis.version -> 3.5.4 mybatis-spring.version -> 2.0.4 mybatisplus.version -> 3.3.2 p6spy.version -> 3.9.0
   fastjson.version -> 1.2.72  (修复安全漏洞） druid.version -> 1.1.22   (修复编译时，IDEA的警告） knife4j.version -> 2.0.4
   swagger.version -> 1.5.22 hutool.version -> 5.3.9 jjwt.version -> 0.11.1

### zuihou-gateway-server
1. 优化gateway网关的熔断配置
2. AccessFilter为TokenContextFilter

### zuihou-injection-starter
1. 修改 InjectionFieldPo 和 InjectionField 类的 feign 字段为 apiClass，使得字段命名更加合理
2. InjectionField注解类新增dictType属性，解决字典类型数据注入bug
3. 修复自动注入器注入字典类型的数据时，无法区分不同字典类型的值

### zuihou-validator-starter
1. 修复表单统一验证模块不支持Restful风格 + BaseController接口的验证规则获取bug
2. com.github.zuihou.validator.config.EnableFormValidator 注解移动到 com.github.zuihou.validator.annotation.EnableFormValidator

### zuihou-databases
1. 优化SCHEMA模式全局拦截器代码功能和可读性
2. 优化非DATASOURCE模式数据源配置
3. 优化分页插件每次查询最大500条的限制
4. PageParams类的 getPage() 方法修改成 buildPage()，并支持多字段排序
5. 删除 MultiTenantInterceptor ，新增 ReplaceSql
6. 新增MasterDatabaseConfiguration， 优化NONE、SCHEMA、COLUMN模式的数据源配置和事务配置
7. 修复NONE、SCHEMA、COLUMN模式事务失效的bug

### zuihou-core
1. 新增JsonUtil工具类（jackson）

### zuihou-boot
1. 优化枚举字段反序列化全局配置类：EnumDeserializer, 提高可读性和性能
2. 新增枚举类型字段的全局序列化配置类：EnumSerializer， 实现了BaseEnum接口的枚举按照规范序列化
3. 优化 BaseConfig 类中全局的 ObjectMapper 配置
3. 优化LocalDateTime类型参数的Jackson反序列化规则
4. 优化LocalDateTime、Date、LocalDate、LocalTime等日期类型表单参数传递时的转换规则
5. 全局统一异常的状态码修改为400
6. 优化PageController类handlerWrapper方法的逻辑

### zuihou-cloud-starter
1. 优化服务远程调用时，请求头和线程变量的传递
2. 新增全局的支持负载均衡策略、请求头和LocalThread参数传递的LbRestTemplate
3. 新增全局的熔断回调， @FeignClient 注解无需单独配置 fallback 和 fallbackFactory 即可实现回调

### zuihou-swagger2-starter
1. 使得通过 zuihou.swaggger.enabled 可以全局禁用swagger功能
2. 优化SwaggerProperties类的配置和默认值

### zuihou-log-starter
1. 为了减少zuihou-log-starter模块体积，将ip2region.db移动到oauth服务。
2. 修复操作日志根据参数控制是否记录请求参数的bug

### 定时任务
1. 修复分布式定时执行器运行重置任务时，找不到sql脚本的bug

### 代码生成器
1. 优化代码生成器配置若干
2. 修复代码生成器生成的代码导包不正确和缺少配置的bug 3，修复代码生成器生成配置类和Controller类错误的bug 4，优化代码生成器使得生成代码时，可以使用模糊查询同时生成多张表 5，完善代码生成后的提示信息 6, 支持生成租户数据源动态新增消息队列监听类

# 升级日志 2020年04月26日23:14:24
0. spring.cloud.version -> Hoxton.SR3
1. spring.boot.version -> 2.2.6.RELEASE
2. spring-cloud-alibaba -> 2.2.1.RELEASE
3. seata.version -> 1.2.0
4. fastjson.version -> 1.2.68
5. j2cache.version -> 2.8.2-release
6. jjwt.version -> 0.9.1
7. hutool.version -> 5.3.1
8. 支持 nacos 1.2.1
9. 支持 seata 1.2.0
10. 优化数据权限逻辑
11. 修复删除资源时执行删除SQL的bug
12. 修复查询缓存数据时，查询到为null的数据的会报NPE的bug
13. 同步 nacos 和 seata 的脚本
14. 修复RoleAuthorityServiceImpl类的方法 无事务注解
15. 优化项目配置，使得任意模式完美支持 seata
16. 优化若干代码
17. 调整开发文档兼容当前最新版本代码

# 升级日志 2020年04月19日14:44:46
新增：
1. 网关新增客户端认证校验
2. 新增分布式定时任务执行器（现在同时支持单机定时执行和分布式定时执行）

优化：
1. 优化代码生成器模版文件，减少依赖项
2. 优化 Swagger自动配置项，支持设置认证参数
3. 废弃zuihou-config模块，合并到zuihou-cloud-starter模块中
4. zuihou-admin-ui全局用户查询体验
5. 多数据源模式独立成插件，使用时自由插拔
6. 优化mq、scan等配置
7. 优化tenant模块包名

修复：
1. zuihou-admin-ui无法新增运营后台账号的bug

# 升级日志 2020年04月05日23:33:23
新增：
1. 新增认证服务（zuihou-oauth-server：负责登录、获取用户所有权限、资源、菜单等功能）
2. 参照SpringSecurity原理，调整 认证服务登录、刷新token等 接口相关逻辑
3. 参照SpringSecurity原理，新增 zuihou-security-starter 模块，实现 URI权限配置 和 鉴权
4. 新增 租户模式 支持**多数据源模式**：动态增减数据源，一个租户一个库一个数据源（不开源）
5. 多数据源模式相关代码和配置，调整成一键切换模式（不开源）
6. 新增多数据源模式完美支持**分布式事务** （seata 1.0.0） （不开源）
7. 新增删除租户时，删除租户数据和数据库的接口,并删除该租户的数据源
8. 新增记录在线用户功能 & 主动T人下线功能

优化：
1. 重写token生成规则和方法
2. 优化用户登录逻辑，根据配置决定是否限制用户重复登录、多端登录。
3. 登录日志改成发布事件的方式。
4. 移除 zuihou-shiro-starter 和 zuihou-user-starter 模块
5. 移除 zuihou-zuul-* 模块中没用的几个模块
6. 优化swagger配置，支持接口认证等参数
7. 配置文件调整：zuihou.database.bizDatabase -> zuihou.database.tenantDatabasePrefix
8. 将分散在各个服务的枚举接口(/enums)合并到 Oauth 服务，前端在登录之后，一次性拉取存放在前端缓存中。
9. 日志统一存储路径： logging.file.path 移动到 `src/main/filters/config-dev.properties` 统一配置
10. 将租户模块相关代码独立到权限服务的 `zuihou-tenant-**` 模块中，降低代码耦合度，增强系统的独立性。（有条件的朋友，完全可以将租户模块独立成一个服务）
11. 将非租户模式、字段租户模式、SCHEMA/数据源租户模式的数据库脚本区分开。
12. 简化租户后台系统相关接口逻辑 (zuihou-admin-ui)
13. 废除之前的配置在Controller层的声明式事务配置，采用注解配置事务，调整事务控制到service层，通过注解来控制事务，原因是兼容多数据源模式。
14. SuperCacheServiceImpl 相关方法加上事务注解。
15. SuperCacheServiceImpl 相关操作缓存的方法去除@Cache注解，采用cacheChanel方式，防止子类this调用时，无法使用缓存的bug
16. 拆分上下文拦截器，将租户信息、MDC分离到 拦截器TenantContextHandlerInterceptor(封装租户相关请求头)、MdcHandlerInterceptor(封装日志相关线程变量)
17. 优化操作日志相关配置，实现根据条件实例不同的bean
18. 简化order和demo服务的分布式事务配置 
19. SpringUtils类增加发布事件的静态方法
20. 废弃IgnoreTokenConfig,调整为配置文件方式： IgnoreTokenProperties

修复
1. 修复UserQuery构造方法报NPE的bug
2. 完善租户模块相关功能，并修复一个弱智bug

## 模式介绍
| 租户模式 | 描述 | 优点 | 缺点  | 
|---|---|---|---|
| NONE（非租户模式) | 没有租户 | 简单、适合独立系统 | 缺少租户系统的优点 | 
| COLUMN（字段模式) | 租户共用一个数据库，在业务表中增加字段来区分 | 简单、不复杂、开发无感知 | 数据隔离性差、安全性差、数据备份和恢复困难、 | 
| SCHEMA（独立schema) | 每个租户独立一个 数据库(schema)，执行sql时，动态在表名前增加schema | 简单、开发无感知、数据隔离性好 | 配置文件中必须配置数据库的root账号、不支持复杂sql和 sql嵌套自定义函数 | 
| DATASOURCE(独立数据源) | 每个租户独立一个 数据库(数据源)，执行代码时，动态切换数据源 | 可独立部署数据库，数据隔离性好、扩展性高、故障影响小 | 相对复杂、开发需要注意切换数据源时的事务问题、需要较多的数据库 |

| 模式\描述  | 表中有无租户字段 | 实体类中有无租户字段 | 分布式事务| 有几个数据库 |  
|---|---|---|---|---|
| NONE | 无 | 无 | 支持 | zuihou_defaults | 
| COLUMN | 有 | 无 | 支持 | zuihou_defaults |
| SCHEMA | 无 | 无 | 暂时不支持 | zuihou_defaults、zuihou_base_{tenant} |
| DATASOURCE | 无 | 无 | 支持 | zuihou_defaults、zuihou_base_{tenant} |

## 升级指南：
1. 更新 zuihou-admin-cloud， 待依赖更新完毕后，根据IDEA提示，删除zuihou-zuul-base、zuihou-zuul-authentication、zuihou-zuul-ratelimit 等模块
2. 若要更新zuihou-commons（该项目已经发布中央仓库，若不想看源码，可以不用管），待依赖更新完毕后，根据IDEA提示，删除zuihou-user-starter、zuihou-shiro-starter等模块
3. 编译项目
4. 重新导入 数据库脚本      (数据库改动较大，请务必重新执行，执行时，看着： docs/sql/脚本说明.md 根据自身情况导入脚本)
5. 重新导入 nacos 配置文件  (配置文件改动很大，删除合并了很多配置)
6. 启动项目

# 升级日志 2020年03月12日16:26:52
## 新增
0.新增 Base、Delete、Poi、Save、Update、Query等6个功能的Controller接口，方便业务方并提供默认实现SuperSimpleController、SuperNoPoiController、SuperController、SuperCacheController。
1.新增 SuperCacheController、SuperCacheService、SuperCacheServiceImpl 一套默认使用缓存的基类
2.新增 SuperController、SuperService、SuperServiceImpl 一套无缓存基类，用于区分上面的3个基类 
3.新增 手动查询当前登录用户、角色、岗位、组织信息。（原来只能用过 @LoginUser SysUser 方式注入）
4.新增 项目功能兼容mysql 8.0.19 （nacos使用 mysql8 需要修改nacos官方源码中驱动的版本号，并自行编译！！！）
5.前端项目：所有的分页查询请求改成POST、分页切换页面时记忆历史选中项目、点击表格一行的任意位置即为勾选、默认创建时间支持排序、所有表格head筛选改成后端筛选。
6.操作日志记录支持DB存储和FILE存储2种选择，并重新定义日志格式，支持应用名、端口号、租户ID、用户ID、日志链路ID等信息
7.多租户模式支持配置成 租户字段模式
8.用户管理页面支持导出、导入校验功能
9.新增new LbqWrapper(entity);方法，当entity中有类型为RemoteData的字段时，key为空也忽略拼接该字段。

## 优化
0.依赖升级：springboot -> 2.2.5、 mysql -> 8.0.18、lombok -> 1.18.12、 fastjson -> 1.2.66、 mybatis-> 3.5.3、guava -> 22.0、 hutool -> 5.2.1、knife4j -> 2.0.2
1.完全独立zuihou-commons包，并优化相关配置，使得完美兼容cloud和boot项目
2.zuihou-commons相关jar发布至正式仓库。
3.优化代码生成器，兼容新增的几个基类（Super*）
4.废弃zuihou-api模块，将 zuihou-*-api 模块移动到 zuihou-* 模块下，方便部署编译
5.废弃原 BaseController 基类，并将原来写的所有代码，继承了全新的基类。
6.谨遵约定大于配置原则，优化zuihou-user-stater、zuihou-scan-stater使得选择Feign、Service、Rabbit模式时，其他模式的实现类完全不初始化
7.原来pom里面的配置移动到src/main/filters/config-ENV.properties
8.记录操作日志优化，支持开关、继承覆盖。
9.原zuihou-config下存放的配置文件移动到third-party/nacos/clientConfig
10.新增清理指定时段内的操作日志和登录日志的方法

## 修复
0.修复MultiTenantInterceptor拦截器类，无法替换部分复杂SQL表名的bug
1.zuihou-admin-ui 刷新页面后，切换菜单时控制台报错。

## zuihou-admin-cloud项目 代码更新升级指引：
0.以下几点只适用于在1.x版本中没有改动代码或者改动较少的情况，若对原来项目的代码该多较大，请重新找一个目录clone项目
1.在IDEA2019.3中，点击 Update Projects ,勾选： Merge the incoming changes into the current branch 后点OK
2.等代码更新完毕后，在文件资源管理器中将`zuihou-commons`、`zuihou-backend`、`zuihou-dependencies`3个文件夹直接删除。

## 配置文件变更（包含但不限于以下配置）：
0.nacos中 commmon.yml 新增：
```
zuihou:
  log:
    enabled: true
    type: DB
```
1.nacos中 zuihou-order-server.yml 和 zuihou-demo-server.yml: 修改
```
zuihou:
  database:
    multiTenantType: NONE       # 修改前：     isMultiTenant: false

```
2.nacos中 mysql.yml: 修改
```
zuihou:
  database:
    multiTenantType: SCHEMA   # 修改前：isMultiTenant: true  
```
3.项目中：zuihou-admin-cloud/zuihou-dependencies/pom.xml 中 profiles 相关的配置移动到了 zuihou-admin-cloud/src/main/filters/config-dev.properties
```
nacos.ip=127.0.0.1
nacos.port=8848
nacos.namespace=b16f7baf-56e7-4f4e-a26c-425ee0668016
seata.namespace=
```
4.原来存放在 zuihou-commons/src/main/resources 中的nacos配置文件，移动到了 third-party/nacos/clientConfig

## 为什么要将zuihou-commons模块独立出来？
    1.工具代码和业务代码存放在一个工程，复制项目时，会增加冗余代码。
    2.zuihou-commons项目下的所有模块均为独立的工具包，她的用途不局限于zuihou-admin-cloud和zuihou-admin-boot2个项目，而是适合任意SpringBoot或者SpringCloud项目

## 为何要将项目拆分成这么多子模块？
    这是高内聚低耦合的最佳体现
    增强代码的可读性、复用性、可维护性和易变更性
    模块内部的代码，相互之间的联系越强，内聚就越高， 模块的独立性就越好。 一个模块应该尽量的独立，去完成独立的功能！
    如果有代码非得引入到独立的模块，建议拆分成多模块！低内聚的代码，不好维护，代码也不够健壮

# 升级日志 2020年02月27日11:31:14
## 新增
1. zuihou-ui 增加公共导出excel组件
2. 代码生成器：支持导入、导出、导出预览、分页查询、翻页勾选、行级勾选等方法
3. 代码生成器: 支持字段生成 枚举、字典 类型的字段
4. SuperController 新增自定义查询列表方法

## 优化
1. 优化代码生成器匹配最新的后端代码: 树形、列表、编辑、导出预览、导入页面
2. 优化 SuperCacheServiceImpl 缓存相关配置

## 修复
1. 修复zuihou-admin-ui 项目密码错误时报错的bug
2. 修复logback日志无法打印debug级别到控制台的bug
3. 修复定时任务重置租户数据时，会误删除内置租户数据的bug

# 升级日志 2020年02月19日23:03:01
## 新增
1. 新增 SuperService、SuperCacheServiceImpl 类，增加缓存的支持
2. 新增 SuperMapper 类，增加 updateAllById 和 insertBatchSomeColumn 方法
3. 新增 QueryWrap 类，对MP提供的 QueryWrapper 类增强， 并优化 LbqWrapper 类 
4. 重写 SpringCache 的 cacheResolver，使得 注解模式 支持子类 重写缓存key 
5. 新增 首页右上角显示我的消息 功能
6. 调整 代码生成器初始化工程的结构和pom依赖， 生成后端代码使用最新的 Super* 父类接口, 并且生成的后端代码支持导入、导出功能

## 优化
1. 优化 操作日志，使得能够记录 SuperController 类的日志，并支持子类 重写操作日志描述
2. 优化 父类 BaseController2 重命名为 SupperController， 完善方法：CRUD、导入、导出、Excel预览、分页（支持排序、日期区间查询），完善操作日志(@SysLog)的支持
3. 调整用户（c_auth_user)相关类 继承新增的 Super* 接口，并联合前端调整接口后，测试通过
4. 优化 WriteInterceptor 写入权限拦截器，使之能根据nacos中参数，动态启用禁用，便于管理员在演示环境临时修改数据。

## 修复
1. 修复 zuihou-ui 消息发送 页面的bug
2. zuihou-ui 附件列表页面 鼠标移到文件名列时正确显示手形鼠标 

# 升级日志 2020年02月13日18:28:30
1. 升级 Alibaba Cloud 2.2.0.RELEASE
2. 修复 数据自动注入器 注入远程调用的数据类型擦除的bug
3. 新增 ribbon自定义负载均衡规则 实现简单的灰度发布
4. 完善父类控制器：BaseController2，新增模板方法：CRUD、导入、导出、预览、分页（排序） 
5. 分页接口由原来的GET请求修改成POST请求，并用PageParams对象包裹，方便传参 
6. 调整 zuihou-commons 下各组主键的依赖关系和代码位置。 
7. 模块 zuihou-common 移动到 zuihou-backend 包下，用于存放业务相关公共代码。 
8. 新增 zuihou-boot 模块用于存放 SpringBoot 相关配置，并将 zuihou-core 模块中 base 包下的代码移动到 zuihou-boot。
9. zuihou-openfeign-starter 重命名为 zuihou-cloud-stater 用于存放 SpringCloud 相关配置。
10. 修复 LbqWrapper#nested 方法参数为空时的一个bug
11. 完善各个模块之间依赖关系、将Pom依赖调整为最小依赖。
12. 调整登录接口的返回值
13. Order和Demo 服务中 seata 相关配置移动到 zuihou-order/demo-server.yml 配置文件中， 并通过参数控制是否启用 

# 升级日志 2020年02月12日15:54:39
1. 修复数据权限拦截器执行顺序不对导致的 数据bug <a href="https://gitee.com/zuihou111/zuihou-admin-cloud/issues/I197PH"> # fix I197PH </a>
2. 用户表增加 民族、学历、职位状态等 数据字典类型的字段， 并对接前后端页面
3. 修复定时发送短信接口报错的bug
4. 将业务代码中一些过时的方法替换成 hutool的相关方法
5. 委婉修复Jobs服务，首次启动报错的问题 （其实这个报错不算bug，但为了让大家减少疑惑，就调整了一下）
6. 优化代码生成器生成代码的可读性
7. 修改系统前后端交互时，拉取枚举和字典字段的方式为实时拉取。（原来是登录时拉取后缓存在前端，有数据不一致的bug）
8. 操作日志记录支持 SpEL 表达式 
9. 代码生成器支持识别 注解上用 feign 模式
10. 优化部分过时、无用、bug代码
11. 系统中涉及树形结构的相关接口优化

# 升级日志 2020年02月03日15:59:19
1. 唯一Id生成器换成 hutool 的 IdUtil
2. 关联字段数据注入工具（zuihou-injection-starter） 增加guava本地缓存，加快注入速度， 完善注释。
3. 使用MP提供的自定义枚举类型转换器，修复 数据库中枚举字段的值不存在时，报错的bug
4. 使用hutool工具类优化操作日志记录的异常消息
5. 标记core下的一些工具类为过时，拥抱Hutool 6，新增 参数管理 相关功能，用于配置系统全局参数或租户个性化参数。 7，修复 关联字段数据注入工具 缓存查询的一个bug
8. 代码生成器相关bug修复，并新增 前端页面生成 功能。

#升级日志 2020年01月28日17:42:42
1. 修复 bug    <a href="https://github.com/zuihou/zuihou-ui/issues/3"># fix 3</a> 
2. 升级SpringBoot 版本至 2.2.4
3. 升级MybatisPlus 版本至 3.3.1
4. 升级spring  版本至 5.2.3
5. 代码生成器支持 生成父类为 TreeEntity 类的结构
6. 代码生成器支持 解析数据库注释中的 @InjectionField 类型
7. 关联字段数据注入工具（原名zuihou-remote-data-starer） 重命名为： zuihou-injection-starter。 用于优雅解决跨服务、垮库、跨表的关联字段 数据回显问题。
8. 修复dozer-starter的配置读取无法使用通配符的bug。 并考虑项目中废弃 dozer ，采用hutool 的BeanUtil 作为JavaBean 的转换工具。
9. 岗位/用户 管理页面组织字段采用 数据注入工具 回显数据
10. 修复短信管理删除时，不会级联删除的bug
11. gateway 新增重定向接口兼容zuul 的swagger地址
12. gateway swagger文档地址返回调优
13. 修复 前端页面访问错误路径时，无法跳转到404 的bug
14. 增加自定义表单校验规则，使得能正常检验 RemoteData 类型的字段的 @NotEmpty @NotNull @Length 等检验注解

# 升级日志 2020年01月21日
0，定时任务 增加重置演示环境数据功能
1，完善地区相关接口，并优化地区表结构
2，对接 地区 相关前端页面
3，新增 数据字典相关方法
4，新增 爬虫，用于从国家统计局爬取全国的省市区数据
5，新增 数据聚合工具（zuihou-injection-starter), 用于解决跨库、跨表、跨服务的 关联数据 回显之痛。支持对静态数据属性(数据字典)、动态主键数据等进行自动注入和转化。
6，新增 树形基础实体TreeEntity， 使得实体支持树状结构
7，新增 Mybatis自定义类型处理器，使得Mybatis 能够将数据库中的字段解析成Java中的自定义类型

# 升级日志 2020年01月16日11:35:48
1. 升级 zipkin-server 到 2.19.2 ，并修改项目配置，使得兼容新版本，并完善使用文档
2. 代码生成器 增加 创建新服务 的功能
3. 代码生成器 支持实体中id字段名称任意命名，且不强制继承父类实体 
4. MetaObjectHandler 支持任意名称的Id字段自动注入， 并优化其代码可读性
5. 同步 zuihou-admin-boot 和 zuihou-admin-cloud 项目之间的代码，并部署到新的测试线
6. 优化 jobs项目的配置
7. 新增rabbitmq起步依赖便于项目 动态控制 是否启用rabbitmq
8. 修复 bug # fix 8 
9. 优化&完善文档：  在线文档
10. 修改 zuihou-ui 和 zuihou-admin-ui 配置，使得开发环境无需 nginx 也能自由切换 zuihou-admin-boot / zuihou-admin-cloud

# 升级日志 2020年01月09日
1. 完善数据字典相关接口对接
2. 重构数据源配置 BaseDbConfiguration
3. 让项目的租户模式变成可配置模式（包括 zuihou-ui 支持配置）。  
4. 解决 p6spy 打印 为 null 的sql语句
5. 将配置文件中过时的配置(logging.path等)升级为 最新版本的配置 
6. 用于测试 分布式事务(seata) 的2个服务取消多租户配置，并将分布式事务调试通过
7. 修复 zuihou-admin-ui 运行报错 ： `Cannot read property 'range' of null`
   解决方案： "babel-eslint": 降级为 "8.0.1" 
8. 统一 zuihou-admin-ui 的接口调用返回值
9. 记录更加详细的登录日志（登录失败原因等） 

# 升级日志 2020年01月02日22:15:50
1. 完善系统API&应用模块表结构、前后端对接等
2. 操作日志中模块描述记录得更加人性化
3. 优化&修复 前后端项目bug、代码功能不健全、命名不规范等若干
4. 消息中心接口完善&前后端对接
5. 删除附件统计相关无用接口
6. seata-all 相关版本升级到 1.0.0. 完善demo&test服务对seata-server的支持 (对本项目中采用的SaaS方案. 还存在一些问题）
7. 升级 SpringCloud 版本为 Hoxton.SR1
8. 升级 SpringBoot 版本为 2.2.2.RELEASE
9. 升级 mybatis-plus 版本为 3.3.0 （升级后发现官方分页查询的bug. 又回滚到3.2.0）
10. 升级 Alibaba Cloud 版本为 2.1.1.RELEASE
11. 升级Alibaba Cloud 版本为 2.1.1.RELEASE后.  zuihou-j2cache-starter 存在无法读取nacos中配置的bug. 已修复
12. 升级 knife4j 版本为 2.0.1   
13. 升级 hutool 版本为 5.1.0
14. 升级大部分依赖jar的版本为最新稳定

# 升级日志 2019年12月18日09:42:07
1. 删除 服务表以及相关代码
2. 新增 系统api接口表 以及相关接口
3. 修改 应用表相关字段. 并重新生成代码
4. 新增 应用-系统api 关联表. 用于外部应用的api授权。
5. 新增 zuihou-scan-starter 起步依赖. 实现自动扫描服务的所有api接口.  并提供2种实现方式（feign or rabbitmq）
6. 升级 swagger-bootstrap-ui 1.9.6 为 knife4j 2.0.0 

# 升级日志 2019年12月03日11:59:38-2019年12月04日18:22:12
1. 优化根据ip查询地区的方法
2. 增加swagger全局参数
3. 完善gateway相关核心功能. 目前使用gateway能正常登陆和解析token等
4. 调整Mybatis拦截器. 控制演示环境的写入权限控制。防止数据被 乱删乱改。 想要在演示环境测试增删改功能的.  请新增租户和账号后测试
5. zuihou-admin-cloud的兄弟项目：zuihou-admin-boot 初次提交. 是在本项目基础上去除微服务部分。 目的：简化开发、部署、方便小型项目快速建站 地址： https://github.com/zuihou/zuihou-admin-boot

# 升级日志 2019年12月02日
1. 完善用户中心（修改头像、登录时间、账号信息、修改密码等）相关接口对接
2. 完善用户管理的用户信息修改相关接口
3. 修复jobs服务启动报错
4. 统一jobs服务的logback日志配置
5. 完善启动文档&脚本
6. 修复文件服务在window系统下返回路径错误的bug
7. 发布启动教学视频

# 2019年11月26日00:11:56 升级日志
1. 同步最新的sql脚本、nacos脚本到源码相应文件中
2. 租户运营后台升级：

- 租户运营后台新增租户时. 对租户编码进行校验
- 格式化租户运营后台代码中不规范的代码
3. 租户后台升级：

- 对接短信中心的前端页面 
- 优化短信中心后台表结构与相关程序 （还差定时发送和查看详情）
- 对接附件列表前端页面
- 部署第三方文件预览接口. 并与本系统完成对接
- 解决异步下载文件时. 后端发生异常时前端能正确提示. 以及下载正常时. 实现异步下载
- 单独增大 文件服务 的ribbon超时时间. 与业务系统的超时时间区分开（附件上传比较耗时. 故可以根据自己服务器网络情况适当调整. 演示服务器网络差. 故调的比较大）

# 2019年10月20日23:46:29
1. 新增全新UI： https://github.com/zuihou/zuihou-ui
2. 对接新UI的验证码 + 登录 + 动态获取路由
3. 新增登录日志表
4. 修改权限库多张表的结构（zuihou_authority_new.sql)  
5. 修改了nacos中的配置文件 common.yml 、zuihou-authority-server-dev.yml
6. 完善代码生成器
7. 修复 zuihou-jobs-server 启动失败的bug
8. 项目文档程序员节5折(10月24日)： https://www.kancloud.cn/zuihou/zuihou-admin-cloud 

# 2019年10月18日11:04:22
1. 删除zuihou-redis-starter
2. 新增zuihou-j2cache-starter（封装2级缓存：j2cache.  并修复了官方的starter中. 无法从nacos中读取配置文件的 bug）
3. 如何配置2级redis缓存的开关？ 请参考： `zuihou-j2cache-starter/README.md`
4. 修改了nacos中 redis.yml 的配置. 详情请看  `zuihou-config/src/main/resources/redis.yml`  或者 `third-party/nacos/nacos_config_export_2019-10-18 11_02_43.zip`
5. 权限服务(zuihou-authority-server)中 资源. 菜单 已经加入j2cache 
6. 合并北城的PR. 修复了 zuihou-admin-ui 切换 nav 会退出的bug。

待完善：
1. j2cache 默认提供的序列化策略. 对本项目来说都不太友好. 暂时先用fst.  后面考虑自定义序列化策略!
2. fst 缺点：增删改字段后. 反序列化报错
3. json 缺点：不支持LocalDateTime

# 2019年09月20日14:31:08
1. 新增链路监控模块 zuihou-zipkin . 用mysql作为存储.  rabbitmq作为采集方式 
2. 封装了一个可插拔起步依赖： zuihou-zipkin-client-starter 给各个需要采集调用信息的服务使用（可通过配置文件控制是否采集）
3. 将 zuihou-monitor 服务和 zuihou-zipkin 服务的配置统一抽离到naocs
4. third-party/nacos/nacos_config_export_x.zip 目录下的nacos的配置. 将原来的 数据库名 nacos_test 修改成 zuihou_nacos
4. third-party/seata/nacos_config_export_x.zip 目录下的seata的配置. 将原来的 数据库名 seata 修改成 zuihou_seata

# 2019年09月06日23:56:20
1. mybatis plus 升级为3.2.0.  并将insert update select时. 字段策略分别修改
2. 响应 MP 要求. 在开发环境增加 p6spy . 用于打印 sql语句
3. 抽取整个项目的logback配置文件的公共部分. 到zuihou-log-starter模块. 并针对开发环境和其他环境配置不同的日志格式和等级。 
4. 开发环境增加控制台高亮日志、控制台SQL语句、控制台SQL执行分析；正式环境等增加异步日志输入. 以提高TPS
5. 修复spring-boot-admin项目无法正确读取各个项目的远程日志的bug

# 2019年08月15日16:04:13
1. 在zuihou-order-server、zuihou-demo-server集成 阿里开源的分布式事务中间件seata-server 0.7.1  （官方指出当前版本不适用于生产. 故在此作为演示学习使用）
2. Eureka 注册中心废除.  用Nacos替换
3. 项目中的配置文件.  统一到Nacos配置中心
4. 调试zuihou-gateway-server启动成功

# 2019年08月08日22:35:17
1. 新增 断点续传/分片上传/秒传功能 前后端代码

# 2019年07月23日11:28:31
1. 在zuihou-databases模块中增加 数据权限 拦截器`DataScopeInterceptor`
   ```
   使用方法（参考AuthorityAutoConfiguration、FileAutoConfiguration）：
   1) 继承BaseDbConfiguration类
   2）覆盖getDataScopeInterceptor()方法. 返回以下其中一种
       new DataScopeInterceptor((userId) -> SpringUtil.getBean(UserApi.class).getDataScopeById(userId)); 
       new DataScopeInterceptor((userId) -> SpringUtil.getBean(UserService.class).getDataScopeById(userId)); 
   3）自定义查询方法上加上参数 new DataScope()   (参考AttachmentMapper.page 、 StationMapper.findStationPage)
   ```
2. 对官方的Wrappers.lambdaQuery(entity) 进行扩展 .  参考：Wraps.lbQ(entity)
   ```
       1) 字符串类型默认like查询
       2) 字符串类型字段不想用like 查询的的. 调用 ignore(Entity::set字段) 方法排除. 然后在调用eq等自己想要的方法 
       3）对参数中有 % _ 的特殊符号的参数进行 转义。
       4）参考：TestResource.testWrapper
       5）Resource build = Resource.builder().code("123%456").name("nide %z").build();
          LbqWrapper<Resource> ignore = Wraps.lbQ(build).ignore(Resource::setCode).eq(Resource::getCode.  build.getCode());
   ```  

# 2019年07月08日23:12:04
1. 重构项目依赖结构
2. 新增zuihou-dependencies项目. 用于管理所有项目的pom版本
3. 依赖结构为：
   ```        
    zuihou-dependencies <- zuihou-commons <- zuihou-backend <- zuihou-support <- zuihou-frontend(后期废除)
   ```
4. docker 启动命令    
    ```
    docker run -idt -p  8768:8768 -p 8767:8767 --name zuihou-jobs-server --restart=always \
        -e EUREKA_IP=172.17.229.167 \
            -e MYSQL_IP=172.17.229.167 \
            -e NGINX_IP=127.0.0.1 \
        -m 384m --memory-swap=512m \
        -v /data/docker-data/projects/:/projects \
        zuihou-jobs-server:201907120926   
    ```


## 统一升级版本号

mvn versions:set -DnewVersion="3.10.0" -DskipTests -DgenerateBackupPoms=false

mvn versions:set -DnewVersion="3.10.0-SNAPSHOT" -DskipTests -DgenerateBackupPoms=false


## 打标签
```
git tag 3.10.0

git push origin --tags
```
