/*
 Navicat Premium Data Transfer

 Source Server         : 172.26.3.67_lamp
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 172.26.3.67:1521
 Source Schema         : LAMP_EXTEND_0000

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 02/09/2022 10:18:38
*/


-- ----------------------------
-- Table structure for E_BLOCK_LIST
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_BLOCK_LIST";
CREATE TABLE "LAMP_EXTEND_0000"."E_BLOCK_LIST" (
  "ID" NUMBER(20) NOT NULL ,
  "IP" VARCHAR2(20 BYTE) ,
  "REQUEST_URI" VARCHAR2(255 BYTE) ,
  "REQUEST_METHOD" VARCHAR2(10 BYTE) ,
  "LIMIT_START" VARCHAR2(8 BYTE) ,
  "LIMIT_END" VARCHAR2(8 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 0 ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."IP" IS '阻止访问ip';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."REQUEST_URI" IS '请求URI';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."REQUEST_METHOD" IS '请求方法;
如果为ALL则表示对所有方法生效';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."LIMIT_START" IS '限制时间起';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."LIMIT_END" IS '限制时间止';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_BLOCK_LIST"."UPDATED_BY" IS '修改人';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_BLOCK_LIST" IS '黑名单';

-- ----------------------------
-- Table structure for E_MSG
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_MSG";
CREATE TABLE "LAMP_EXTEND_0000"."E_MSG" (
  "ID" NUMBER(20) NOT NULL ,
  "BIZ_ID" VARCHAR2(64 BYTE) ,
  "BIZ_TYPE" VARCHAR2(64 BYTE) ,
  "MSG_TYPE" VARCHAR2(20 BYTE) NOT NULL ,
  "TITLE" VARCHAR2(255 BYTE) ,
  "CONTENT" CLOB ,
  "AUTHOR" VARCHAR2(50 BYTE) ,
  "HANDLER_URL" VARCHAR2(255 BYTE) ,
  "HANDLER_PARAMS" VARCHAR2(500 BYTE) ,
  "IS_SINGLE_HANDLE" NUMBER(1) DEFAULT 1 ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."BIZ_ID" IS '业务ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."BIZ_TYPE" IS '业务类型;
#MsgBizType{USER_LOCK:账号锁定;USER_REG:账号申请;WORK_APPROVAL:考勤审批;}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."MSG_TYPE" IS '消息类型;
#MsgType{WAIT:待办;NOTIFY:通知;PUBLICITY:公告;WARN:预警;}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."TITLE" IS '标题';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."CONTENT" IS '内容';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."AUTHOR" IS '发布人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."HANDLER_URL" IS '处理地址;
以http开头时直接跳转，否则与#c_application表拼接后跳转http可带参数';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."HANDLER_PARAMS" IS '处理参数';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."IS_SINGLE_HANDLE" IS '是否单人处理';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG"."UPDATED_BY" IS '最后修改人';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_MSG" IS '消息表';

-- ----------------------------
-- Table structure for E_MSG_RECEIVE
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE";
CREATE TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" (
  "ID" NUMBER(20) NOT NULL ,
  "MSG_ID" NUMBER(20) NOT NULL ,
  "USER_ID" NUMBER(20) NOT NULL ,
  "IS_READ" NUMBER(1) DEFAULT 0 ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."MSG_ID" IS '消息ID;
#msg';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."USER_ID" IS '接收人ID;
#c_user';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."IS_READ" IS '是否已读';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_MSG_RECEIVE"."UPDATED_BY" IS '最后修改人';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" IS '消息接收表';

-- ----------------------------
-- Table structure for E_RATE_LIMITER
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_RATE_LIMITER";
CREATE TABLE "LAMP_EXTEND_0000"."E_RATE_LIMITER" (
  "ID" NUMBER(20) NOT NULL ,
  "COUNT" NUMBER(10) DEFAULT 0 ,
  "REQUEST_URI" VARCHAR2(255 BYTE) ,
  "REQUEST_METHOD" VARCHAR2(10 BYTE) ,
  "LIMIT_START" VARCHAR2(8 BYTE) ,
  "LIMIT_END" VARCHAR2(8 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 0 ,
  "INTERVAL_SEC" NUMBER(20) DEFAULT 0 ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."COUNT" IS '次数';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."REQUEST_URI" IS '请求URI';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."REQUEST_METHOD" IS '请求方法;
如果为ALL则表示对所有方法生效';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."LIMIT_START" IS '限制时间起';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."LIMIT_END" IS '限制时间止';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."INTERVAL_SEC" IS '时间窗口';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_RATE_LIMITER"."UPDATED_BY" IS '修改人';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_RATE_LIMITER" IS '限流';

-- ----------------------------
-- Table structure for E_SMS_SEND_STATUS
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS";
CREATE TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" (
  "ID" NUMBER(20) NOT NULL ,
  "TASK_ID" NUMBER(20) NOT NULL ,
  "SEND_STATUS" VARCHAR2(10 BYTE) NOT NULL ,
  "TEL_NUM" VARCHAR2(20 BYTE) NOT NULL ,
  "BIZ_ID" VARCHAR2(255 BYTE) ,
  "EXT" VARCHAR2(255 BYTE) ,
  "CODE" VARCHAR2(255 BYTE) ,
  "MESSAGE" VARCHAR2(500 BYTE) ,
  "FEE" NUMBER(10) ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."TASK_ID" IS '任务ID;
#e_sms_task';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."SEND_STATUS" IS '发送状态;
#SendStatus{WAITING:等待发送;SUCCESS:发送成功;FAIL:发送失败}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."TEL_NUM" IS '接收者手机
单个手机号;
阿里：发送回执ID,可根据该ID查询具体的发送状态  腾讯：sid 标识本次发送id，标识一次短信下发记录  百度：requestId 短信发送请求唯一流水ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."BIZ_ID" IS '发送回执ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."EXT" IS '发送返回;
阿里：RequestId 请求ID  腾讯：ext：用户的session内容，腾讯server回包中会原样返回   百度：无';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."CODE" IS '状态码;阿里：返回OK代表请求成功,其他错误码详见错误码列表  腾讯：0表示成功(计费依据)，非0表示失败  百度：1000 表示成功';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."MESSAGE" IS '状态码的描述';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."FEE" IS '短信计费的条数;腾讯专用';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" IS '短信发送状态';

-- ----------------------------
-- Table structure for E_SMS_TASK
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_SMS_TASK";
CREATE TABLE "LAMP_EXTEND_0000"."E_SMS_TASK" (
  "ID" NUMBER(20) NOT NULL ,
  "TEMPLATE_ID" NUMBER(20) NOT NULL ,
  "STATUS" VARCHAR2(10 BYTE) ,
  "SOURCE_TYPE" VARCHAR2(10 BYTE) ,
  "TOPIC" VARCHAR2(255 BYTE) ,
  "TEMPLATE_PARAMS" VARCHAR2(500 BYTE) ,
  "SEND_TIME" DATE ,
  "CONTENT" VARCHAR2(500 BYTE) ,
  "DRAFT" NUMBER(1) DEFAULT 0 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."ID" IS '短信记录ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."TEMPLATE_ID" IS '短信模板;@Echo(api = SMS_TEMPLATE_ID_CLASS)#e_sms_template';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."STATUS" IS '执行状态;
(手机号具体发送状态看sms_send_status表) 
#TaskStatus{WAITING:等待执行;SUCCESS:执行成功;FAIL:执行失败}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."SOURCE_TYPE" IS '发送渠道;#SourceType{APP:应用;SERVICE:服务}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."TOPIC" IS '主题';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."TEMPLATE_PARAMS" IS '参数;
需要封装为{‘key’:’value’, ...}格式且key必须有序';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."CONTENT" IS '发送内容;
需要封装正确格式化: 您好，张三，您有一个新的快递。';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."DRAFT" IS '是否草稿';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TASK"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_SMS_TASK" IS '发送任务';

-- ----------------------------
-- Table structure for E_SMS_TEMPLATE
-- ----------------------------
DROP TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE";
CREATE TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" (
  "ID" NUMBER(20) NOT NULL ,
  "PROVIDER_TYPE" VARCHAR2(10 BYTE) NOT NULL ,
  "APP_ID" VARCHAR2(255 BYTE) NOT NULL ,
  "APP_SECRET" VARCHAR2(255 BYTE) NOT NULL ,
  "URL" VARCHAR2(255 BYTE) ,
  "NAME" VARCHAR2(255 BYTE) ,
  "CONTENT" VARCHAR2(255 BYTE) NOT NULL ,
  "TEMPLATE_PARAMS" VARCHAR2(255 BYTE) NOT NULL ,
  "TEMPLATE_CODE" VARCHAR2(50 BYTE) NOT NULL ,
  "SIGN_NAME" VARCHAR2(100 BYTE) ,
  "TEMPLATE_DESCRIBE" VARCHAR2(255 BYTE) ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE 
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."ID" IS '模板ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."PROVIDER_TYPE" IS '供应商类型;
#ProviderType{ALI:OK,阿里云短信;TENCENT:0,腾讯云短信;BAIDU:1000,百度云短信}';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."APP_ID" IS '应用ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."APP_SECRET" IS '应用密码';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."URL" IS 'SMS服务域名;
百度、其他厂商会用';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."NAME" IS '模板名称';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."CONTENT" IS '模板内容';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."TEMPLATE_PARAMS" IS '模板参数';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."TEMPLATE_CODE" IS '模板编码';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."SIGN_NAME" IS '签名';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."TEMPLATE_DESCRIBE" IS '备注';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "LAMP_EXTEND_0000"."E_SMS_TEMPLATE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" IS '短信模板';

-- ----------------------------
-- Primary Key structure for table E_BLOCK_LIST
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_BLOCK_LIST" ADD CONSTRAINT "SYS_C0014525" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_BLOCK_LIST
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_BLOCK_LIST" ADD CONSTRAINT "SYS_C0014524" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_MSG
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG" ADD CONSTRAINT "SYS_C0014528" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_MSG
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG" ADD CONSTRAINT "SYS_C0014526" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG" ADD CONSTRAINT "SYS_C0014527" CHECK ("MSG_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_MSG_RECEIVE
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014532" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_MSG_RECEIVE
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014529" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014530" CHECK ("MSG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014531" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_RATE_LIMITER
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_RATE_LIMITER" ADD CONSTRAINT "SYS_C0014534" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_RATE_LIMITER
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_RATE_LIMITER" ADD CONSTRAINT "SYS_C0014533" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_SMS_SEND_STATUS
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014539" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_SEND_STATUS
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014535" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014536" CHECK ("TASK_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014537" CHECK ("SEND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014538" CHECK ("TEL_NUM" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table E_SMS_SEND_STATUS
-- ----------------------------
CREATE INDEX "LAMP_EXTEND_0000"."TASK_ID_TEL_NUM"
  ON "LAMP_EXTEND_0000"."E_SMS_SEND_STATUS" ("TEL_NUM" ASC, "TASK_ID" ASC)
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table E_SMS_TASK
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TASK" ADD CONSTRAINT "SYS_C0014542" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_TASK
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TASK" ADD CONSTRAINT "SYS_C0014540" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TASK" ADD CONSTRAINT "SYS_C0014541" CHECK ("TEMPLATE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table E_SMS_TASK
-- ----------------------------
CREATE INDEX "LAMP_EXTEND_0000"."TEMPATE_ID_TOPIC_CONTENT"
  ON "LAMP_EXTEND_0000"."E_SMS_TASK" ("TEMPLATE_ID" ASC, "CONTENT" ASC, "TOPIC" ASC) LOCAL
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table E_SMS_TEMPLATE
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014550" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_TEMPLATE
-- ----------------------------
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014543" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014544" CHECK ("PROVIDER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014545" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014546" CHECK ("APP_SECRET" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014547" CHECK ("CONTENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014548" CHECK ("TEMPLATE_PARAMS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_EXTEND_0000"."E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014549" CHECK ("TEMPLATE_CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
