/*
 Navicat Premium Data Transfer

 Source Server         : 172.26.3.67(oracle)
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 172.26.3.67:1521
 Source Schema         : LAMP_COLUMN

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 30/08/2022 16:09:40
*/


-- ----------------------------
-- Table structure for C_APPENDIX
-- ----------------------------
DROP TABLE "C_APPENDIX";
CREATE TABLE "C_APPENDIX" (
  "ID" NUMBER(20,0) NOT NULL,
  "BIZ_ID" NUMBER(20,0) DEFAULT 0  NOT NULL,
  "BIZ_TYPE" VARCHAR2(255 BYTE) NOT NULL,
  "FILE_TYPE" VARCHAR2(255 BYTE),
  "BUCKET" VARCHAR2(255 BYTE),
  "PATH" VARCHAR2(255 BYTE),
  "ORIGINAL_FILE_NAME" VARCHAR2(255 BYTE),
  "CONTENT_TYPE" VARCHAR2(255 BYTE),
  "SIZE_" NUMBER(20,0) DEFAULT 0,
  "CREATE_TIME" DATE NOT NULL,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE NOT NULL,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_APPENDIX"."ID" IS 'ID';
COMMENT ON COLUMN "C_APPENDIX"."BIZ_ID" IS '业务id';
COMMENT ON COLUMN "C_APPENDIX"."BIZ_TYPE" IS '业务类型';
COMMENT ON COLUMN "C_APPENDIX"."FILE_TYPE" IS '文件类型';
COMMENT ON COLUMN "C_APPENDIX"."BUCKET" IS '桶';
COMMENT ON COLUMN "C_APPENDIX"."PATH" IS '文件相对地址';
COMMENT ON COLUMN "C_APPENDIX"."ORIGINAL_FILE_NAME" IS '原始文件名';
COMMENT ON COLUMN "C_APPENDIX"."CONTENT_TYPE" IS '文件类型';
COMMENT ON COLUMN "C_APPENDIX"."SIZE_" IS '大小';
COMMENT ON COLUMN "C_APPENDIX"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_APPENDIX"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_APPENDIX"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "C_APPENDIX"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "C_APPENDIX"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_APPENDIX" IS '业务附件';

-- ----------------------------
-- Records of C_APPENDIX
-- ----------------------------

-- ----------------------------
-- Table structure for C_APPLICATION
-- ----------------------------
DROP TABLE "C_APPLICATION";
CREATE TABLE "C_APPLICATION" (
  "ID" NUMBER(20,0) NOT NULL,
  "CLIENT_ID" VARCHAR2(24 BYTE),
  "CLIENT_SECRET" VARCHAR2(32 BYTE),
  "WEBSITE" VARCHAR2(100 BYTE),
  "NAME" VARCHAR2(255 BYTE) NOT NULL,
  "ICON" VARCHAR2(255 BYTE),
  "APP_TYPE" VARCHAR2(10 BYTE),
  "DESCRIBE_" VARCHAR2(200 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 1,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_APPLICATION"."ID" IS 'ID';
COMMENT ON COLUMN "C_APPLICATION"."CLIENT_ID" IS '客户端ID';
COMMENT ON COLUMN "C_APPLICATION"."CLIENT_SECRET" IS '客户端密码';
COMMENT ON COLUMN "C_APPLICATION"."WEBSITE" IS '官网';
COMMENT ON COLUMN "C_APPLICATION"."NAME" IS '应用名称';
COMMENT ON COLUMN "C_APPLICATION"."ICON" IS '应用图标';
COMMENT ON COLUMN "C_APPLICATION"."APP_TYPE" IS '类型;
#{SERVER:服务应用;APP:手机应用;PC:PC网页应用;WAP:手机网页应用}';
COMMENT ON COLUMN "C_APPLICATION"."DESCRIBE_" IS '备注';
COMMENT ON COLUMN "C_APPLICATION"."STATE" IS '状态';
COMMENT ON COLUMN "C_APPLICATION"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_APPLICATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_APPLICATION"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_APPLICATION"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_APPLICATION"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_APPLICATION" IS '应用';

-- ----------------------------
-- Records of C_APPLICATION
-- ----------------------------
INSERT INTO "C_APPLICATION" VALUES ('1', 'lamp_web_plus', 'lamp_web_plus_secret', 'https://tangyh.top', 'lamp快速开发平台', NULL, 'PC', '内置', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_APPLICATION" VALUES ('2', 'lamp_web', 'lamp_web_secret', 'https://tangyh.top', 'lamp快速开发平台', NULL, 'PC', '内置', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for C_AREA
-- ----------------------------
DROP TABLE "C_AREA";
CREATE TABLE "C_AREA" (
  "ID" NUMBER(20,0) NOT NULL,
  "CODE" VARCHAR2(64 BYTE) NOT NULL,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL,
  "FULL_NAME" VARCHAR2(255 BYTE),
  "SORT_VALUE" NUMBER(10,0) DEFAULT 1,
  "LONGITUDE" VARCHAR2(255 BYTE),
  "LATITUDE" VARCHAR2(255 BYTE),
  "LEVEL_" VARCHAR2(10 BYTE),
  "SOURCE_" VARCHAR2(255 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 0,
  "PARENT_ID" NUMBER(20,0) DEFAULT 0,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_AREA"."ID" IS 'id';
COMMENT ON COLUMN "C_AREA"."CODE" IS '编码';
COMMENT ON COLUMN "C_AREA"."LABEL" IS '名称';
COMMENT ON COLUMN "C_AREA"."FULL_NAME" IS '全名';
COMMENT ON COLUMN "C_AREA"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "C_AREA"."LONGITUDE" IS '经度';
COMMENT ON COLUMN "C_AREA"."LATITUDE" IS '维度';
COMMENT ON COLUMN "C_AREA"."LEVEL_" IS '行政区级;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.AREA_LEVEL)';
COMMENT ON COLUMN "C_AREA"."SOURCE_" IS '数据来源';
COMMENT ON COLUMN "C_AREA"."STATE" IS '状态';
COMMENT ON COLUMN "C_AREA"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "C_AREA"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_AREA"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_AREA"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_AREA"."UPDATED_BY" IS '更新人';
COMMENT ON COLUMN "C_AREA"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_AREA" IS '地区表';

-- ----------------------------
-- Records of C_AREA
-- ----------------------------

-- ----------------------------
-- Table structure for C_DATASOURCE_CONFIG
-- ----------------------------
DROP TABLE "C_DATASOURCE_CONFIG";
CREATE TABLE "C_DATASOURCE_CONFIG" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" VARCHAR2(255 BYTE) NOT NULL,
  "USERNAME" VARCHAR2(255 BYTE) NOT NULL,
  "PASSWORD" VARCHAR2(255 BYTE) NOT NULL,
  "URL" VARCHAR2(255 BYTE) NOT NULL,
  "DRIVER_CLASS_NAME" VARCHAR2(255 BYTE) NOT NULL,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."ID" IS '主键ID';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."NAME" IS '名称';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."USERNAME" IS '账号';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."PASSWORD" IS '密码';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."URL" IS '链接';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."DRIVER_CLASS_NAME" IS '驱动';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "C_DATASOURCE_CONFIG"."UPDATED_BY" IS '修改人';
COMMENT ON TABLE "C_DATASOURCE_CONFIG" IS '数据源';

-- ----------------------------
-- Records of C_DATASOURCE_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for C_DICTIONARY
-- ----------------------------
DROP TABLE "C_DICTIONARY";
CREATE TABLE "C_DICTIONARY" (
  "ID" NUMBER(20,0) NOT NULL,
  "TYPE" VARCHAR2(255 BYTE) NOT NULL,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL,
  "CODE" VARCHAR2(64 BYTE) NOT NULL,
  "NAME" VARCHAR2(64 BYTE) NOT NULL,
  "STATE" NUMBER(1,0) DEFAULT 1,
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "SORT_VALUE" NUMBER(10,0) DEFAULT 1,
  "ICON" VARCHAR2(255 BYTE),
  "CSS_STYLE" VARCHAR2(255 BYTE),
  "CSS_CLASS" VARCHAR2(255 BYTE),
  "READONLY_" NUMBER(1,0) DEFAULT 0,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_DICTIONARY"."ID" IS 'ID';
COMMENT ON COLUMN "C_DICTIONARY"."TYPE" IS '类型';
COMMENT ON COLUMN "C_DICTIONARY"."LABEL" IS '类型标签';
COMMENT ON COLUMN "C_DICTIONARY"."CODE" IS '编码';
COMMENT ON COLUMN "C_DICTIONARY"."NAME" IS '名称';
COMMENT ON COLUMN "C_DICTIONARY"."STATE" IS '状态';
COMMENT ON COLUMN "C_DICTIONARY"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_DICTIONARY"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "C_DICTIONARY"."ICON" IS '图标';
COMMENT ON COLUMN "C_DICTIONARY"."CSS_STYLE" IS 'css样式';
COMMENT ON COLUMN "C_DICTIONARY"."CSS_CLASS" IS 'css;class';
COMMENT ON COLUMN "C_DICTIONARY"."READONLY_" IS '内置';
COMMENT ON COLUMN "C_DICTIONARY"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_DICTIONARY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_DICTIONARY"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_DICTIONARY"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_DICTIONARY"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_DICTIONARY" IS '字典项';

-- ----------------------------
-- Records of C_DICTIONARY
-- ----------------------------
INSERT INTO "C_DICTIONARY" VALUES ('1', 'AREA_LEVEL', '行政区划', '01', '国家', '1', NULL, '1', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('2', 'AREA_LEVEL', '行政区划', '02', '省份/直辖市', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('3', 'AREA_LEVEL', '行政区划', '03', '地市', '1', NULL, '3', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('4', 'AREA_LEVEL', '行政区划', '04', '区县', '1', NULL, '4', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('5', 'AREA_LEVEL', '行政区划', '05', '乡镇', '1', NULL, '5', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('10', 'EDUCATION', '学历', '01', '小学', '1', NULL, '1', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('11', 'EDUCATION', '学历', '02', '中学', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('12', 'EDUCATION', '学历', '03', '高中', '1', NULL, '3', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('13', 'EDUCATION', '学历', '04', '专科', '1', NULL, '4', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('14', 'EDUCATION', '学历', '05', '本科', '1', NULL, '5', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('15', 'EDUCATION', '学历', '06', '硕士', '1', NULL, '6', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('16', 'EDUCATION', '学历', '07', '博士', '1', NULL, '7', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('17', 'EDUCATION', '学历', '08', '博士后', '1', NULL, '8', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('29', 'EDUCATION', '学历', '20', '其他', '1', NULL, '20', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('40', 'ORG_TYPE', '机构类型', '01', '单位', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('41', 'ORG_TYPE', '机构类型', '02', '部门', '1', NULL, '2', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('43', 'NATION', '民族', '01', '汉族', '1', NULL, '0', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('44', 'NATION', '民族', '02', '壮族', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('45', 'NATION', '民族', '03', '满族', '1', NULL, '2', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('46', 'NATION', '民族', '04', '回族', '1', NULL, '3', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('47', 'NATION', '民族', '05', '苗族', '1', NULL, '4', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('48', 'NATION', '民族', '06', '维吾尔族', '1', NULL, '5', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('49', 'NATION', '民族', '07', '土家族', '1', NULL, '6', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('50', 'NATION', '民族', '08', '彝族', '1', NULL, '7', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('51', 'NATION', '民族', '09', '蒙古族', '1', NULL, '8', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('52', 'NATION', '民族', '10', '藏族', '1', NULL, '9', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('53', 'NATION', '民族', '11', '布依族', '1', NULL, '10', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('54', 'NATION', '民族', '12', '侗族', '1', NULL, '11', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('55', 'NATION', '民族', '13', '瑶族', '1', NULL, '12', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('56', 'NATION', '民族', '14', '朝鲜族', '1', NULL, '13', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('57', 'NATION', '民族', '15', '白族', '1', NULL, '14', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('58', 'NATION', '民族', '16', '哈尼族', '1', NULL, '15', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('59', 'NATION', '民族', '17', '哈萨克族', '1', NULL, '16', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('60', 'NATION', '民族', '18', '黎族', '1', NULL, '17', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('61', 'NATION', '民族', '19', '傣族', '1', NULL, '18', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('62', 'NATION', '民族', '20', '畲族', '1', NULL, '19', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('63', 'NATION', '民族', '21', '傈僳族', '1', NULL, '20', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('64', 'NATION', '民族', '22', '仡佬族', '1', NULL, '21', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('65', 'NATION', '民族', '23', '东乡族', '1', NULL, '22', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('66', 'NATION', '民族', '24', '高山族', '1', NULL, '23', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('67', 'NATION', '民族', '25', '拉祜族', '1', NULL, '24', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('68', 'NATION', '民族', '26', '水族', '1', NULL, '25', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('69', 'NATION', '民族', '27', '佤族', '1', NULL, '26', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('70', 'NATION', '民族', '28', '纳西族', '1', NULL, '27', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('71', 'NATION', '民族', '29', '羌族', '1', NULL, '28', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('72', 'NATION', '民族', '30', '土族', '1', NULL, '29', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('73', 'NATION', '民族', '31', '仫佬族', '1', NULL, '30', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('74', 'NATION', '民族', '32', '锡伯族', '1', NULL, '31', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('75', 'NATION', '民族', '33', '柯尔克孜族', '1', NULL, '32', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('76', 'NATION', '民族', '34', '达斡尔族', '1', NULL, '33', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('77', 'NATION', '民族', '35', '景颇族', '1', NULL, '34', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('78', 'NATION', '民族', '36', '毛南族', '1', NULL, '35', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('79', 'NATION', '民族', '37', '撒拉族', '1', NULL, '36', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('80', 'NATION', '民族', '38', '塔吉克族', '1', NULL, '37', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('81', 'NATION', '民族', '39', '阿昌族', '1', NULL, '38', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('82', 'NATION', '民族', '40', '普米族', '1', NULL, '39', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('83', 'NATION', '民族', '41', '鄂温克族', '1', NULL, '40', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('84', 'NATION', '民族', '42', '怒族', '1', NULL, '41', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('85', 'NATION', '民族', '43', '京族', '1', NULL, '42', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('86', 'NATION', '民族', '44', '基诺族', '1', NULL, '43', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('87', 'NATION', '民族', '45', '德昂族', '1', NULL, '44', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('88', 'NATION', '民族', '46', '保安族', '1', NULL, '45', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('89', 'NATION', '民族', '47', '俄罗斯族', '1', NULL, '46', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('90', 'NATION', '民族', '48', '裕固族', '1', NULL, '47', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('91', 'NATION', '民族', '49', '乌兹别克族', '1', NULL, '48', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('92', 'NATION', '民族', '50', '门巴族', '1', NULL, '49', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('93', 'NATION', '民族', '51', '鄂伦春族', '1', NULL, '50', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('94', 'NATION', '民族', '52', '独龙族', '1', NULL, '51', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('95', 'NATION', '民族', '53', '塔塔尔族', '1', NULL, '52', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('96', 'NATION', '民族', '54', '赫哲族', '1', NULL, '53', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('97', 'NATION', '民族', '55', '珞巴族', '1', NULL, '54', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('98', 'NATION', '民族', '56', '布朗族', '1', NULL, '55', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('99', 'NATION', '民族', '57', '其他', '1', NULL, '100', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('110', 'POSITION_STATUS', '职位状态', '01', '在职', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('111', 'POSITION_STATUS', '职位状态', '02', '请假', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('112', 'POSITION_STATUS', '职位状态', '03', '离职', '1', NULL, '3', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486198107023605760', 'RESOURCE_TYPE', '资源类型', '20', '菜单', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486198623417925632', 'RESOURCE_DATA_SCOPE', '数据范围', '01', '全部', '1', NULL, '1', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486198858865180672', 'ROLE_CATEGORY', '角色类别', '10', '功能角色', '1', NULL, '1', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486198996287356928', 'RESOURCE_TYPE', '资源类型', '60', '数据', '1', NULL, '6', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199651718660096', 'RESOURCE_DATA_SCOPE', '数据范围', '02', '本单位及子级', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199679237488640', 'RESOURCE_DATA_SCOPE', '数据范围', '03', '本单位', '1', NULL, '3', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199726792507392', 'RESOURCE_DATA_SCOPE', '数据范围', '04', '本部门及子级', '1', NULL, '4', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199753644441600', 'RESOURCE_DATA_SCOPE', '数据范围', '05', '本部门', '1', NULL, '5', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199809227358208', 'RESOURCE_DATA_SCOPE', '数据范围', '06', '个人', '1', NULL, '6', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486199838218387456', 'RESOURCE_DATA_SCOPE', '数据范围', '07', '自定义', '1', NULL, '7', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486200233623814144', 'ROLE_CATEGORY', '角色类别', '20', '桌面角色', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_DICTIONARY" VALUES ('1486200358744096768', 'ROLE_CATEGORY', '角色类别', '30', '数据角色', '1', NULL, '3', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for C_FILE
-- ----------------------------
DROP TABLE "C_FILE";
CREATE TABLE "C_FILE" (
  "ID" NUMBER(20,0) NOT NULL,
  "BIZ_TYPE" VARCHAR2(255 BYTE) NOT NULL,
  "FILE_TYPE" VARCHAR2(255 BYTE),
  "STORAGE_TYPE" VARCHAR2(255 BYTE),
  "BUCKET" VARCHAR2(255 BYTE),
  "PATH" VARCHAR2(255 BYTE),
  "URL" VARCHAR2(255 BYTE),
  "UNIQUE_FILE_NAME" VARCHAR2(255 BYTE),
  "FILE_MD5" VARCHAR2(255 BYTE),
  "ORIGINAL_FILE_NAME" VARCHAR2(255 BYTE),
  "CONTENT_TYPE" VARCHAR2(255 BYTE),
  "SUFFIX" VARCHAR2(255 BYTE),
  "SIZE_" NUMBER(20,0) DEFAULT 0,
  "CREATE_TIME" DATE NOT NULL,
  "CREATED_BY" NUMBER(20,0) NOT NULL,
  "UPDATE_TIME" DATE NOT NULL,
  "UPDATED_BY" NUMBER(20,0) NOT NULL,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_FILE"."ID" IS 'ID';
COMMENT ON COLUMN "C_FILE"."BIZ_TYPE" IS '业务类型';
COMMENT ON COLUMN "C_FILE"."FILE_TYPE" IS '文件类型';
COMMENT ON COLUMN "C_FILE"."STORAGE_TYPE" IS '存储类型
LOCAL;FAST_DFS MIN_IO ALI';
COMMENT ON COLUMN "C_FILE"."BUCKET" IS '桶';
COMMENT ON COLUMN "C_FILE"."PATH" IS '文件相对地址';
COMMENT ON COLUMN "C_FILE"."URL" IS '文件访问地址';
COMMENT ON COLUMN "C_FILE"."UNIQUE_FILE_NAME" IS '唯一文件名';
COMMENT ON COLUMN "C_FILE"."FILE_MD5" IS '文件md5';
COMMENT ON COLUMN "C_FILE"."ORIGINAL_FILE_NAME" IS '原始文件名';
COMMENT ON COLUMN "C_FILE"."CONTENT_TYPE" IS '文件类型';
COMMENT ON COLUMN "C_FILE"."SUFFIX" IS '后缀';
COMMENT ON COLUMN "C_FILE"."SIZE_" IS '大小';
COMMENT ON COLUMN "C_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_FILE"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_FILE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "C_FILE"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "C_FILE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_FILE" IS '增量文件上传日志';

-- ----------------------------
-- Records of C_FILE
-- ----------------------------

-- ----------------------------
-- Table structure for C_LOGIN_LOG
-- ----------------------------
DROP TABLE "C_LOGIN_LOG";
CREATE TABLE "C_LOGIN_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "REQUEST_IP" VARCHAR2(50 BYTE),
  "USER_ID" NUMBER(20,0),
  "USER_NAME" VARCHAR2(50 BYTE),
  "ACCOUNT" VARCHAR2(30 BYTE),
  "DESCRIPTION" VARCHAR2(255 BYTE),
  "LOGIN_DATE" CHAR(10 BYTE),
  "UA" CLOB,
  "BROWSER" VARCHAR2(255 BYTE),
  "BROWSER_VERSION" VARCHAR2(255 BYTE),
  "OPERATING_SYSTEM" VARCHAR2(255 BYTE),
  "LOCATION" VARCHAR2(255 BYTE),
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_LOGIN_LOG"."ID" IS '主键';
COMMENT ON COLUMN "C_LOGIN_LOG"."REQUEST_IP" IS '登录IP';
COMMENT ON COLUMN "C_LOGIN_LOG"."USER_ID" IS '登录人ID';
COMMENT ON COLUMN "C_LOGIN_LOG"."USER_NAME" IS '登录人姓名';
COMMENT ON COLUMN "C_LOGIN_LOG"."ACCOUNT" IS '登录人账号';
COMMENT ON COLUMN "C_LOGIN_LOG"."DESCRIPTION" IS '登录描述';
COMMENT ON COLUMN "C_LOGIN_LOG"."LOGIN_DATE" IS '登录时间';
COMMENT ON COLUMN "C_LOGIN_LOG"."UA" IS '浏览器请求头';
COMMENT ON COLUMN "C_LOGIN_LOG"."BROWSER" IS '浏览器名称';
COMMENT ON COLUMN "C_LOGIN_LOG"."BROWSER_VERSION" IS '浏览器版本';
COMMENT ON COLUMN "C_LOGIN_LOG"."OPERATING_SYSTEM" IS '操作系统';
COMMENT ON COLUMN "C_LOGIN_LOG"."LOCATION" IS '登录地点';
COMMENT ON COLUMN "C_LOGIN_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_LOGIN_LOG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_LOGIN_LOG"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_LOGIN_LOG" IS '登录日志';

-- ----------------------------
-- Records of C_LOGIN_LOG
-- ----------------------------
INSERT INTO "C_LOGIN_LOG" VALUES ('1564443934950686720', '127.0.0.1', '3', '平台管理员', 'lamp_pt', '登录成功', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', 'Chrome', '92.0.4515.107', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 10:44:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564409725762666496', '127.0.0.1', '3', '平台管理员', 'lamp_pt', '登录成功', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', 'Chrome', '92.0.4515.107', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 08:28:38', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564231629960904704', '127.0.0.1', '3', '平台管理员', 'lamp_pt', '登录成功', '2022-08-29', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', 'Chrome', '92.0.4515.107', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-29 20:40:57', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564456527077572608', '127.0.0.1', '1', '内置管理员', 'lampAdmin', '验证码不正确', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', 'Chrome', '104.0.5112.102', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 11:34:36', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564456542206427136', '127.0.0.1', '1', '内置管理员', 'lampAdmin', '登录成功', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', 'Chrome', '104.0.5112.102', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 11:34:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564461973712666624', '127.0.0.1', '1564456408345214976', '内置超级管理员', 'lampAdmin', '登录成功', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', 'Chrome', '104.0.5112.102', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 11:56:15', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_LOGIN_LOG" VALUES ('1564448165317312512', '127.0.0.1', '3', '平台管理员', 'lamp_pt', '登录成功', '2022-08-30', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', 'Chrome', '92.0.4515.107', 'Mac OS X', '0|0|0|内网IP|内网IP', TO_DATE('2022-08-30 11:01:23', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');

-- ----------------------------
-- Table structure for C_MENU
-- ----------------------------
DROP TABLE "C_MENU";
CREATE TABLE "C_MENU" (
  "ID" NUMBER(20,0) NOT NULL,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL,
  "RESOURCE_TYPE" CHAR(2 BYTE),
  "TREE_GRADE" NUMBER(10,0),
  "TREE_PATH" VARCHAR2(512 BYTE),
  "DESCRIBE_" VARCHAR2(200 BYTE),
  "IS_GENERAL" NUMBER(1,0) DEFAULT 0,
  "PATH" VARCHAR2(255 BYTE),
  "COMPONENT" VARCHAR2(255 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 1,
  "SORT_VALUE" NUMBER(10,0) DEFAULT 1,
  "ICON" VARCHAR2(255 BYTE),
  "GROUP_" VARCHAR2(20 BYTE),
  "DATA_SCOPE" CHAR(2 BYTE),
  "CUSTOM_CLASS" VARCHAR2(255 BYTE),
  "IS_DEF" NUMBER(1,0) DEFAULT 0,
  "PARENT_ID" NUMBER(20,0) DEFAULT 0,
  "READONLY_" NUMBER(1,0) DEFAULT 0,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_MENU"."ID" IS 'ID';
COMMENT ON COLUMN "C_MENU"."LABEL" IS '名称';
COMMENT ON COLUMN "C_MENU"."RESOURCE_TYPE" IS '资源类型;[20-菜单 60-数据];@Echo(api = DICTIONARY_ITEM_FEIGN_CLASS,dictType = EchoDictType.RESOURCE_TYPE)';
COMMENT ON COLUMN "C_MENU"."TREE_GRADE" IS '树层级';
COMMENT ON COLUMN "C_MENU"."TREE_PATH" IS '树路径';
COMMENT ON COLUMN "C_MENU"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_MENU"."IS_GENERAL" IS '通用菜单;True表示无需分配所有人就可以访问的';
COMMENT ON COLUMN "C_MENU"."PATH" IS '路径';
COMMENT ON COLUMN "C_MENU"."COMPONENT" IS '组件';
COMMENT ON COLUMN "C_MENU"."STATE" IS '状态';
COMMENT ON COLUMN "C_MENU"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "C_MENU"."ICON" IS '菜单图标';
COMMENT ON COLUMN "C_MENU"."GROUP_" IS '分组';
COMMENT ON COLUMN "C_MENU"."DATA_SCOPE" IS '数据范围;[01-全部 02-本单位及子级 03-本单位 04-本部门 05-本部门及子级 06-个人 07-自定义]';
COMMENT ON COLUMN "C_MENU"."CUSTOM_CLASS" IS '实现类';
COMMENT ON COLUMN "C_MENU"."IS_DEF" IS '是否默认';
COMMENT ON COLUMN "C_MENU"."PARENT_ID" IS '父级菜单ID';
COMMENT ON COLUMN "C_MENU"."READONLY_" IS '内置';
COMMENT ON COLUMN "C_MENU"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_MENU"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_MENU"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_MENU"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_MENU"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_MENU" IS '菜单';

-- ----------------------------
-- Records of C_MENU
-- ----------------------------
INSERT INTO "C_MENU" VALUES ('10', '租户设置', '20', '0', ',', NULL, '0', '/tenant', 'Layout', '1', '10', 'ant-design:group-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('20', '工作台', '20', '0', ',', NULL, '0', '/workbench', 'Layout', '1', '20', 'ant-design:dashboard-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('30', '组织管理', '20', '0', ',', NULL, '0', '/org', 'Layout', '1', '30', 'ant-design:cluster-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('40', '资源中心', '20', '0', ',', NULL, '0', '/resources', 'Layout', '1', '40', 'ant-design:cloud-server-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('50', '流程管理', '20', '0', ',', NULL, '0', '/activiti', 'Layout', '1', '50', 'tabler:chart-dots', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('60', '系统设置', '20', '0', ',', NULL, '0', '/system', 'Layout', '1', '60', 'ant-design:setting-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('70', '网关管理', '20', '0', ',', NULL, '0', '/gateway', 'Layout', '1', '70', 'ant-design:sliders-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('80', '开发者管理', '20', '0', ',', NULL, '0', '/developer', 'Layout', '1', '80', 'ant-design:bug-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('90', '了解lamp', '20', '0', ',', NULL, '1', '/community', 'Layout', '1', '90', 'ant-design:github-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('100', '更多功能', '20', '0', ',', NULL, '1', '/more', 'Layout', '1', '100', 'ant-design:appstore-add-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('110', '租户管理', '20', '1', ',10,', NULL, '0', '/tenant/tenant', 'lamp/tenant/tenant/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '10', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('111', '超级用户', '20', '1', ',10,', NULL, '0', '/tenant/user', 'lamp/tenant/user/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '10', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('112', '数据源配置', '20', '1', ',10,', NULL, '0', '/tenant/datasourceConfig', 'lamp/tenant/datasourceConfig/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '10', '0', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('120', '通知公告', '20', '1', ',20,', NULL, '0', '/workbench/notice', 'lamp/workbench/notice/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('121', '待我审批', '20', '1', ',20,', NULL, '0', '/workbench/todo', 'lamp/workbench/todo/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('122', '我已审批', '20', '1', ',20,', NULL, '0', '/workbench/done', 'lamp/workbench/done/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('123', '我发起的', '20', '1', ',20,', NULL, '0', '/workbench/started', 'lamp/workbench/started/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('130', '机构管理', '20', '1', ',30,', NULL, '0', '/org/org', 'lamp/org/org/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('131', '岗位管理', '20', '1', ',30,', NULL, '0', '/org/station', 'lamp/org/station/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('132', '用户管理', '20', '1', ',30,', NULL, '0', '/org/user', 'lamp/org/user/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('140', '消息中心', '20', '1', ',40,', NULL, '0', '/resources/msg', 'lamp/resources/msg/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('141', '短信模版', '20', '1', ',40,', NULL, '0', '/resources/smsTemplate', 'lamp/resources/smsTemplate/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('142', '短信中心', '20', '1', ',40,', NULL, '0', '/resources/sms', 'lamp/resources/sms/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('143', '附件管理', '20', '1', ',40,', NULL, '0', '/resources/attachment', 'lamp/resources/attachment/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('150', '流程部署', '20', '1', ',50,', NULL, '0', '/activiti/deploymentManager', 'lamp/activiti/deploymentManager/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('151', '模型管理', '20', '1', ',50,', NULL, '0', '/activiti/modelManager', 'lamp/activiti/modelManager/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('152', '请假流程', '20', '1', ',50,', NULL, '0', '/activiti/level', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('153', '请假管理', '20', '2', ',50,152,', NULL, '0', '/activiti/leave/instant', 'lamp/activiti/leave/instantManager/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '152', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('154', '请假任务', '20', '2', ',50,152,', NULL, '0', '/activiti/leave/ruTask', 'lamp/activiti/leave/ruTask/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '152', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('155', '报销流程', '20', '1', ',50,', NULL, '0', '/activiti/reimbursement', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('156', '报销管理', '20', '2', ',50,155,', NULL, '0', '/activiti/reimbursement/instantManager', 'lamp/activiti/reimbursement/instantManager/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '155', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('157', '报销任务', '20', '2', ',50,155,', NULL, '0', '/activiti/reimbursement/ruTask', 'lamp/activiti/reimbursement/ruTask/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '155', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('160', '菜单管理', '20', '1', ',60,', NULL, '0', '/system/menu', 'lamp/system/menu/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('161', '角色管理', '20', '1', ',60,', NULL, '0', '/system/role', 'lamp/system/role/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('162', '字典管理', '20', '1', ',60,', NULL, '0', '/system/dictionary', 'lamp/system/dictionary/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('163', '地区管理', '20', '1', ',60,', NULL, '0', '/system/area', 'lamp/system/area/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('164', '参数管理', '20', '1', ',60,', NULL, '0', '/system/parameter', 'lamp/system/parameter/index', '1', '50', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('165', '操作日志', '20', '1', ',60,', NULL, '0', '/system/optLog', 'lamp/system/optLog/index', '1', '60', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('166', '登录日志', '20', '1', ',60,', NULL, '0', '/system/loginLog', 'lamp/system/loginLog/index', '1', '70', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('167', '在线用户', '20', '1', ',60,', NULL, '0', '/system/online', 'lamp/system/online/index', '1', '80', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('168', '应用管理', '20', '1', ',60,', NULL, '0', '/system/application', 'lamp/system/application/index', '1', '90', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('180', '限流规则', '20', '1', ',70,', NULL, '0', '/gateway/ratelimiter', 'lamp/gateway/ratelimiter/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '70', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('181', '阻止访问', '20', '1', ',70,', NULL, '0', '/gateway/blocklist', 'lamp/gateway/blocklist/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '70', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('190', '定时任务', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8767/xxl-job-admin', 'Layout', '1', '10', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('191', '接口文档', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8760/api/gate/doc.html', 'Layout', '1', '20', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('192', 'nacos', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8848/nacos', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('193', '服务监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8762/lamp-monitor', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('194', '数据库监控', '20', '1', ',80,', NULL, '0', '/developer/db', 'lamp/developer/db/index', '1', '50', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('195', '缓存监控', '20', '1', ',80,', NULL, '0', 'https://github.com/junegunn/redis-stat', 'Layout', '1', '60', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('196', 'zipkin监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8772/zipkin', 'Layout', '1', '70', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('197', 'SkyWalking监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:12080', 'Layout', '1', '80', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('210', '在线文档', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud', 'Layout', '1', '10', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('211', '会员版', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003629', 'Layout', '1', '20', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('212', '获取源码', '20', '1', ',90,', NULL, '1', 'https://github.com/zuihou', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('213', '问题反馈', '20', '1', ',90,', NULL, '1', 'https://github.com/dromara/lamp-cloud/issues', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('214', '更新日志', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/1465302', 'Layout', '1', '50', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('215', '蓝图', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003640', 'Layout', '1', '60', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('220', '多级菜单', '20', '1', ',100,', NULL, '1', '/more/multiMenu', 'Layout', '1', '1', NULL, NULL, NULL, NULL, NULL, '100', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('221', '菜单1-1', '20', '2', ',100,220,', NULL, '1', '/more/multiMenu/menu1-1', 'Layout', '1', '1', NULL, NULL, NULL, NULL, NULL, '220', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('222', '菜单1-1-1', '20', '3', ',100,220,221,', NULL, '1', '/more/multiMenu/menu1-1/menu1-1-1', 'lamp/more/multiMenu/menu1-1/menu1-1-1/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '221', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('223', '菜单1-1-2', '20', '3', ',100,220,221,', NULL, '1', '/more/multiMenu/menu1-1/menu1-1-2', 'lamp/more/multiMenu/menu1-1/menu1-1-2/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '221', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('224', '菜单1-2', '20', '2', ',100,220,', NULL, '1', '/more/multiMenu/menu1-2', 'lamp/more/multiMenu/menu1-2/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '220', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201050779090944', '查看全部', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '1', NULL, NULL, '01', NULL, '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201491877265408', '查看本单位及子单位', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '2', NULL, NULL, '02', NULL, '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201562119274496', '查看本单位', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '3', NULL, NULL, '06', NULL, '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201715840516096', '查看本部门及子部门', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '4', NULL, NULL, '04', NULL, '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201804327747584', '查看本部门', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '5', NULL, NULL, '05', NULL, '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201872350969856', '查看个人', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '6', NULL, NULL, '06', NULL, '1', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486201971705643008', '查看自定义数据', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '7', NULL, NULL, '07', 'DATA_SCOPE_MY_TEST', '0', '132', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486619304207056896', '查看全部', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '1', NULL, NULL, '01', NULL, '0', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486619392048365568', '查看本单位及子单位', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '2', NULL, NULL, '02', NULL, '0', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486620313587286016', '查看本单位', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '3', NULL, NULL, '03', NULL, '0', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486620425789112320', '查看本部门及子部门', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '4', NULL, NULL, '04', NULL, '0', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486620477806870528', '查看本部门', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '5', NULL, NULL, '05', NULL, '0', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_MENU" VALUES ('1486620546081751040', '查看个人', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '6', NULL, NULL, '06', NULL, '1', '131', '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for C_OPT_LOG
-- ----------------------------
DROP TABLE "C_OPT_LOG";
CREATE TABLE "C_OPT_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "REQUEST_IP" VARCHAR2(50 BYTE),
  "TYPE" VARCHAR2(5 BYTE),
  "USER_NAME" VARCHAR2(50 BYTE),
  "DESCRIPTION" VARCHAR2(255 BYTE),
  "CLASS_PATH" VARCHAR2(255 BYTE),
  "ACTION_METHOD" VARCHAR2(50 BYTE),
  "REQUEST_URI" VARCHAR2(50 BYTE),
  "HTTP_METHOD" VARCHAR2(10 BYTE),
  "START_TIME" DATE,
  "FINISH_TIME" DATE,
  "CONSUMING_TIME" NUMBER(20,0),
  "UA" VARCHAR2(500 BYTE),
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_OPT_LOG"."ID" IS '主键';
COMMENT ON COLUMN "C_OPT_LOG"."REQUEST_IP" IS '操作IP';
COMMENT ON COLUMN "C_OPT_LOG"."TYPE" IS '日志类型;
#LogType{OPT:操作类型;EX:异常类型}';
COMMENT ON COLUMN "C_OPT_LOG"."USER_NAME" IS '操作人';
COMMENT ON COLUMN "C_OPT_LOG"."DESCRIPTION" IS '操作描述';
COMMENT ON COLUMN "C_OPT_LOG"."CLASS_PATH" IS '类路径';
COMMENT ON COLUMN "C_OPT_LOG"."ACTION_METHOD" IS '请求方法';
COMMENT ON COLUMN "C_OPT_LOG"."REQUEST_URI" IS '请求地址';
COMMENT ON COLUMN "C_OPT_LOG"."HTTP_METHOD" IS '请求类型;
#HttpMethod{GET:GET请求;POST:POST请求;PUT:PUT请求;DELETE:DELETE请求;PATCH:PATCH请求;TRACE:TRACE请求;HEAD:HEAD请求;OPTIONS:OPTIONS请求;}';
COMMENT ON COLUMN "C_OPT_LOG"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "C_OPT_LOG"."FINISH_TIME" IS '完成时间';
COMMENT ON COLUMN "C_OPT_LOG"."CONSUMING_TIME" IS '消耗时间';
COMMENT ON COLUMN "C_OPT_LOG"."UA" IS '浏览器';
COMMENT ON COLUMN "C_OPT_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_OPT_LOG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_OPT_LOG"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_OPT_LOG" IS '系统日志';

-- ----------------------------
-- Records of C_OPT_LOG
-- ----------------------------
INSERT INTO "C_OPT_LOG" VALUES ('1564236272317235201', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:59:23', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '128', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564236273609080832', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:59:23', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '439', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564237562053132288', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 21:04:19', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:04:31', 'SYYYY-MM-DD HH24:MI:SS'), '11888', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:04:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261133399883777', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564299543174971392', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 01:10:43', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 01:10:49', 'SYYYY-MM-DD HH24:MI:SS'), '5310', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 01:10:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564409735585726464', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 08:28:40', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:28:40', 'SYYYY-MM-DD HH24:MI:SS'), '147', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:28:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564409736412004352', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 08:28:40', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '528', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564409737464774656', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '49', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564410700317589504', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 08:32:30', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:32:30', 'SYYYY-MM-DD HH24:MI:SS'), '52', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:32:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564410701043204096', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 08:32:30', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '496', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564410702792228864', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '34', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564442221883686912', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:37:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '273', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564442223443968000', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '78', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564442258210553856', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 10:37:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:37:54', 'SYYYY-MM-DD HH24:MI:SS'), '29', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:37:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564448191854673920', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '180', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564462021225742336', '127.0.0.1', 'OPT', '内置超级管理员', '用户-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.UserController', 'page', '/user/page', 'POST', TO_DATE('2022-08-30 11:56:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:26', 'SYYYY-MM-DD HH24:MI:SS'), '734', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:26', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462034924339200', '127.0.0.1', 'OPT', '内置超级管理员', '短信模板-批量查询', 'top.tangyh.lamp.sms.controller.SmsTemplateController', 'query', '/smsTemplate/query', 'POST', TO_DATE('2022-08-30 11:56:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462057850404864', '127.0.0.1', 'OPT', '内置超级管理员', '消息中心-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.msg.controller.MsgController', 'page', '/msg/page', 'POST', TO_DATE('2022-08-30 11:56:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:35', 'SYYYY-MM-DD HH24:MI:SS'), '92', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:35', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462097062952960', '127.0.0.1', 'OPT', '内置超级管理员', '角色-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.RoleController', 'page', '/role/page', 'POST', TO_DATE('2022-08-30 11:56:44', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:44', 'SYYYY-MM-DD HH24:MI:SS'), '290', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:44', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462105833242624', '127.0.0.1', 'OPT', '内置超级管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), '221', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564233611635326976', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '281', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564233612302221312', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '44', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564233612553879552', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '506', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564234893473349632', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '124', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564268992145653760', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 23:09:06', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 23:09:25', 'SYYYY-MM-DD HH24:MI:SS'), '18256', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 23:09:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564268995954081792', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 23:09:07', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 23:09:26', 'SYYYY-MM-DD HH24:MI:SS'), '18111', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 23:09:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564462105816465408', '127.0.0.1', 'OPT', '内置超级管理员', '菜单-查询系统所有的菜单', 'top.tangyh.lamp.authority.controller.auth.MenuController', 'allTree', '/menu/tree', 'POST', TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), '296', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:46', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462117493407744', '127.0.0.1', 'OPT', '内置超级管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 11:56:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:49', 'SYYYY-MM-DD HH24:MI:SS'), '151', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462578912985088', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:58:39', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:58:39', 'SYYYY-MM-DD HH24:MI:SS'), '251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:58:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462580481654784', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:58:39', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '207', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564462581190492160', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '36', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462581190492161', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '41', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564469943934648320', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:27:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '5298', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564469943964008448', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:27:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '4884', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564471186555928576', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:32:51', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:32:51', 'SYYYY-MM-DD HH24:MI:SS'), '745', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:32:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564471186560122880', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:32:51', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:32:51', 'SYYYY-MM-DD HH24:MI:SS'), '745', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:32:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564472438949937152', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:37:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:37:50', 'SYYYY-MM-DD HH24:MI:SS'), '170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:37:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564472440732516352', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:37:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:37:51', 'SYYYY-MM-DD HH24:MI:SS'), '180', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:37:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564473697182416896', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '164', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564473698881110016', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '156', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564231691688476672', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:41:11', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:41:11', 'SYYYY-MM-DD HH24:MI:SS'), '314', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:41:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564231693672382464', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:41:12', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:41:12', 'SYYYY-MM-DD HH24:MI:SS'), '80', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:41:12', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564231743509102592', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:41:24', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:41:24', 'SYYYY-MM-DD HH24:MI:SS'), '32', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:41:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564234875689500672', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:53:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:53:51', 'SYYYY-MM-DD HH24:MI:SS'), '1186', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:53:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564234893779533824', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:53:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '437', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564234895272706048', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '34', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564236174933884928', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 20:58:55', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:59:00', 'SYYYY-MM-DD HH24:MI:SS'), '5246', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:59:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564443940042571776', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '372', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564444734347280384', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:47:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:47:45', 'SYYYY-MM-DD HH24:MI:SS'), '179', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:47:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564445196773490688', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:49:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:49:35', 'SYYYY-MM-DD HH24:MI:SS'), '194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:49:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564445992764309504', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:52:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:52:45', 'SYYYY-MM-DD HH24:MI:SS'), '201', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:52:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564446455052107776', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:54:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:54:35', 'SYYYY-MM-DD HH24:MI:SS'), '202', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:54:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564447251269419008', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:57:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:57:45', 'SYYYY-MM-DD HH24:MI:SS'), '227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:57:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564461978649362432', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '103', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564461979844739072', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '543', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564461990577963008', '127.0.0.1', 'OPT', '内置超级管理员', '组织-查询系统所有的组织树', 'top.tangyh.lamp.authority.controller.core.OrgController', 'tree', '/org/tree', 'GET', TO_DATE('2022-08-30 11:56:19', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:19', 'SYYYY-MM-DD HH24:MI:SS'), '237', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:19', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462008001101824', '127.0.0.1', 'OPT', '内置超级管理员', '岗位-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.core.StationController', 'page', '/station/page', 'POST', TO_DATE('2022-08-30 11:56:23', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:23', 'SYYYY-MM-DD HH24:MI:SS'), '184', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:23', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462015760564224', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:56:25', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:25', 'SYYYY-MM-DD HH24:MI:SS'), '192', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:56:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564462035104694272', '127.0.0.1', 'OPT', '内置超级管理员', '短信发送-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.sms.controller.SmsTaskController', 'page', '/smsTask/page', 'POST', TO_DATE('2022-08-30 11:56:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1045', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564462040754421760', '127.0.0.1', 'OPT', '内置超级管理员', '短信模板-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.sms.controller.SmsTemplateController', 'page', '/smsTemplate/page', 'POST', TO_DATE('2022-08-30 11:56:31', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:31', 'SYYYY-MM-DD HH24:MI:SS'), '243', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:31', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564239061307097088', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 21:10:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '959', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564241410385772544', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 21:19:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:19:49', 'SYYYY-MM-DD HH24:MI:SS'), '793', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:19:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564260082747703296', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 22:33:51', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:34:00', 'SYYYY-MM-DD HH24:MI:SS'), '9019', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:34:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564330135346216960', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 03:12:17', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 03:12:22', 'SYYYY-MM-DD HH24:MI:SS'), '5328', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 03:12:22', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564448191879839744', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '151', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564448194111209472', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:01:30', 'SYYYY-MM-DD HH24:MI:SS'), '759', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:01:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564449437055451136', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:06:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:06:26', 'SYYYY-MM-DD HH24:MI:SS'), '196', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:06:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564450711167565824', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:11:30', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:11:30', 'SYYYY-MM-DD HH24:MI:SS'), '182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:11:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564451953742708736', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:16:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:16:26', 'SYYYY-MM-DD HH24:MI:SS'), '206', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:16:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564453211849359360', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:21:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:21:26', 'SYYYY-MM-DD HH24:MI:SS'), '191', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:21:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564454589049077760', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:26:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:26:54', 'SYYYY-MM-DD HH24:MI:SS'), '188', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:26:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564455733808857088', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:31:27', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:31:27', 'SYYYY-MM-DD HH24:MI:SS'), '471', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:31:27', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564456552490860544', '127.0.0.1', 'OPT', '内置管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:34:42', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:34:42', 'SYYYY-MM-DD HH24:MI:SS'), '54', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:34:42', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564456553124200448', '127.0.0.1', 'OPT', '内置管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:34:42', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '395', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564456555246518272', '127.0.0.1', 'OPT', '内置管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '26', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564456986542604288', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:36:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:36:26', 'SYYYY-MM-DD HH24:MI:SS'), '172', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:36:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564457695564529664', '127.0.0.1', 'OPT', '内置管理员', '组织-查询系统所有的组织树', 'top.tangyh.lamp.authority.controller.core.OrgController', 'tree', '/org/tree', 'GET', TO_DATE('2022-08-30 11:39:15', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:39:15', 'SYYYY-MM-DD HH24:MI:SS'), '254', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:39:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564457710689189888', '127.0.0.1', 'OPT', '内置管理员', '岗位-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.core.StationController', 'page', '/station/page', 'POST', TO_DATE('2022-08-30 11:39:18', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:39:19', 'SYYYY-MM-DD HH24:MI:SS'), '246', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:39:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564457718905831424', '127.0.0.1', 'OPT', '内置管理员', '用户-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.UserController', 'page', '/user/page', 'POST', TO_DATE('2022-08-30 11:39:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:39:21', 'SYYYY-MM-DD HH24:MI:SS'), '610', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:39:21', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564458240912130048', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:41:25', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:41:25', 'SYYYY-MM-DD HH24:MI:SS'), '213', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:41:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564459499119443968', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:46:25', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:46:25', 'SYYYY-MM-DD HH24:MI:SS'), '172', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:46:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564236272317235200', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 20:59:23', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564239058228477952', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 21:10:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:10:28', 'SYYYY-MM-DD HH24:MI:SS'), '146', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:10:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564239061579726848', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564240184780783616', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 21:14:56', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:14:56', 'SYYYY-MM-DD HH24:MI:SS'), '109', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:14:56', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564240187691630592', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 21:14:56', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:14:57', 'SYYYY-MM-DD HH24:MI:SS'), '877', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:14:57', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564240191831408640', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 21:14:58', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:14:58', 'SYYYY-MM-DD HH24:MI:SS'), '44', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:14:58', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564241409865678848', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 21:19:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 21:19:48', 'SYYYY-MM-DD HH24:MI:SS'), '60', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 21:19:48', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564256781905952768', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 22:20:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:20:53', 'SYYYY-MM-DD HH24:MI:SS'), '5687', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:20:53', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261133399883776', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '210', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261134230355968', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '432', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261224193982464', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-29 22:38:32', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '419', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261225326444544', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '47', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564261229650771968', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-29 22:38:34', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-29 22:38:34', 'SYYYY-MM-DD HH24:MI:SS'), '29', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-29 22:38:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564284237400506368', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 00:09:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 00:09:59', 'SYYYY-MM-DD HH24:MI:SS'), '5320', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 00:09:59', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564314834869157888', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 02:11:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 02:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '5330', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 02:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564353047583260672', '127.0.0.1', 'EX', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 04:13:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 04:43:20', 'SYYYY-MM-DD HH24:MI:SS'), '1793771', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 04:43:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564443939069493248', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '72', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564447713183924224', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 10:59:35', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 10:59:35', 'SYYYY-MM-DD HH24:MI:SS'), '183', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 10:59:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564460757716828160', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 11:51:25', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:51:25', 'SYYYY-MM-DD HH24:MI:SS'), '211', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 11:51:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564462046676779008', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.file.controller.FileController', 'page', '/file/page', 'POST', TO_DATE('2022-08-30 11:56:32', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 11:56:32', 'SYYYY-MM-DD HH24:MI:SS'), '57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 11:56:32', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564499094880124928', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 14:23:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:45', 'SYYYY-MM-DD HH24:MI:SS'), '311', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:23:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564499096620761088', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:23:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '678', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564499098977959936', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564499108947820544', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '126', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564499110822674432', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:23:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '807', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564499112739471360', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 14:23:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:23:50', 'SYYYY-MM-DD HH24:MI:SS'), '76', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:23:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564519155061751808', '127.0.0.1', 'OPT', '平台管理员', '菜单-查询系统所有的菜单', 'top.tangyh.lamp.authority.controller.auth.MenuController', 'allTree', '/menu/tree', 'POST', TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '141', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519155875446784', '127.0.0.1', 'OPT', '平台管理员', '菜单-查询系统所有的菜单', 'top.tangyh.lamp.authority.controller.auth.MenuController', 'allTree', '/menu/tree', 'POST', TO_DATE('2022-08-30 15:43:10', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '18541', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519157754494976', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '49', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519157817409536', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:43:10', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '18925', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519158148759552', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '318', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519462772670464', '127.0.0.1', 'OPT', '内置超级管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '253', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564519480019648512', '127.0.0.1', 'OPT', '内置超级管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:44:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:46', 'SYYYY-MM-DD HH24:MI:SS'), '166', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:44:46', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564520415982780416', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:48:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:48:29', 'SYYYY-MM-DD HH24:MI:SS'), '216', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:48:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564520684007194624', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:49:32', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:49:33', 'SYYYY-MM-DD HH24:MI:SS'), '180', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:49:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564521674013933568', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:53:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:53:29', 'SYYYY-MM-DD HH24:MI:SS'), '191', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:53:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564496067444080640', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:11:43', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:11:43', 'SYYYY-MM-DD HH24:MI:SS'), '859', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:11:44', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564496297023504384', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:12:38', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:12:38', 'SYYYY-MM-DD HH24:MI:SS'), '363', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:12:38', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564497321767469056', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:16:42', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:16:43', 'SYYYY-MM-DD HH24:MI:SS'), '506', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:16:43', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564497558506569728', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:17:38', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:17:39', 'SYYYY-MM-DD HH24:MI:SS'), '1095', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:17:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564498596852662272', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:21:46', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:21:47', 'SYYYY-MM-DD HH24:MI:SS'), '306', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:21:47', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564498831523971072', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:22:42', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:22:43', 'SYYYY-MM-DD HH24:MI:SS'), '333', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:22:43', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564501611907121152', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:33:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:33:45', 'SYYYY-MM-DD HH24:MI:SS'), '284', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:33:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564501625328893952', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:33:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:33:49', 'SYYYY-MM-DD HH24:MI:SS'), '347', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:33:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564502871108485120', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:38:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:38:46', 'SYYYY-MM-DD HH24:MI:SS'), '394', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:38:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564502886048595968', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:38:49', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:38:49', 'SYYYY-MM-DD HH24:MI:SS'), '487', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:38:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564504128736985088', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:43:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:43:46', 'SYYYY-MM-DD HH24:MI:SS'), '345', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:43:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564505386671669248', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:48:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:48:45', 'SYYYY-MM-DD HH24:MI:SS'), '331', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:48:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564506645940142080', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:53:45', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:53:46', 'SYYYY-MM-DD HH24:MI:SS'), '387', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:53:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564508021478916096', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:59:13', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:59:14', 'SYYYY-MM-DD HH24:MI:SS'), '352', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 14:59:14', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564509343368347648', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:04:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:04:29', 'SYYYY-MM-DD HH24:MI:SS'), '305', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:04:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564509715067568128', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:05:57', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:05:57', 'SYYYY-MM-DD HH24:MI:SS'), '495', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:05:57', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564515750838796288', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:29:56', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:29:56', 'SYYYY-MM-DD HH24:MI:SS'), '505', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:29:56', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564516781253459968', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:34:01', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:34:02', 'SYYYY-MM-DD HH24:MI:SS'), '738', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:34:02', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564516808851980288', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '246', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564516811427282944', '127.0.0.1', 'OPT', '平台管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '113', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564493276596142080', '127.0.0.1', 'OPT', '内置超级管理员', '用户-查询:1564456408345214976', 'top.tangyh.lamp.authority.controller.auth.UserController', 'get', '/user/1564456408345214976', 'GET', TO_DATE('2022-08-30 14:00:38', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:00:38', 'SYYYY-MM-DD HH24:MI:SS'), '366', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:00:38', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564515789095043072', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564517944174575616', '127.0.0.1', 'OPT', '内置超级管理员', '字典类型-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.common.DictionaryController', 'page', '/dictionary/page', 'POST', TO_DATE('2022-08-30 15:38:39', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:38:39', 'SYYYY-MM-DD HH24:MI:SS'), '617', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:38:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564517945034407936', '127.0.0.1', 'OPT', '内置超级管理员', '字典类型-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.common.DictionaryController', 'page', '/dictionary/page', 'POST', TO_DATE('2022-08-30 15:38:39', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:38:40', 'SYYYY-MM-DD HH24:MI:SS'), '826', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:38:40', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564517990920093696', '127.0.0.1', 'OPT', '内置超级管理员', '参数配置-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.common.ParameterController', 'page', '/parameter/page', 'POST', TO_DATE('2022-08-30 15:38:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:38:51', 'SYYYY-MM-DD HH24:MI:SS'), '493', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:38:51', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518000843816960', '127.0.0.1', 'OPT', '内置超级管理员', '地区表-级联查询地区', 'top.tangyh.lamp.authority.controller.common.AreaController', 'linkageQuery', '/area/linkage', 'GET', TO_DATE('2022-08-30 15:38:53', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:38:53', 'SYYYY-MM-DD HH24:MI:SS'), '151', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:38:53', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518023233011712', '127.0.0.1', 'OPT', '内置超级管理员', '参数配置-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.common.ParameterController', 'page', '/parameter/page', 'POST', TO_DATE('2022-08-30 15:38:58', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:38:58', 'SYYYY-MM-DD HH24:MI:SS'), '499', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:38:58', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518047870353408', '127.0.0.1', 'OPT', '内置超级管理员', '登录日志-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.common.LoginLogController', 'page', '/loginLog/page', 'POST', TO_DATE('2022-08-30 15:39:03', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:39:04', 'SYYYY-MM-DD HH24:MI:SS'), '653', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:39:04', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518074550321152', '127.0.0.1', 'OPT', '内置超级管理员', '应用-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ApplicationController', 'page', '/application/page', 'POST', TO_DATE('2022-08-30 15:39:10', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:39:10', 'SYYYY-MM-DD HH24:MI:SS'), '497', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:39:10', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518167819059200', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:39:32', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:39:33', 'SYYYY-MM-DD HH24:MI:SS'), '251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:39:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564518172436987904', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:39:34', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:39:34', 'SYYYY-MM-DD HH24:MI:SS'), '298', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:39:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564488804864098304', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '212', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564488805904285696', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '172', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564490062391934976', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564490064115793920', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '166', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564491321450692608', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '167', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564491322360856576', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564492579020472320', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '159', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564492580740136960', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '155', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519203271081984', '127.0.0.1', 'OPT', '平台管理员', '菜单-查询系统所有的菜单', 'top.tangyh.lamp.authority.controller.auth.MenuController', 'allTree', '/menu/tree', 'POST', TO_DATE('2022-08-30 15:43:02', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '37589', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519204428709888', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:43:02', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '37776', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519233994358784', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:43:47', 'SYYYY-MM-DD HH24:MI:SS'), '18874', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:43:47', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519388906782720', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:44:23', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:24', 'SYYYY-MM-DD HH24:MI:SS'), '444', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:44:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519400726331392', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:44:26', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:27', 'SYYYY-MM-DD HH24:MI:SS'), '198', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:44:27', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519408355770368', '127.0.0.1', 'OPT', '平台管理员', '资源-分页列表查询:第1页, 显示20行', 'top.tangyh.lamp.authority.controller.auth.ResourceController', 'page', '/resource/page', 'POST', TO_DATE('2022-08-30 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), '397', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564519425921515520', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:44:32', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:33', 'SYYYY-MM-DD HH24:MI:SS'), '192', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:44:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564519461518573568', '127.0.0.1', 'OPT', '内置超级管理员', '菜单-查询系统所有的菜单', 'top.tangyh.lamp.authority.controller.auth.MenuController', 'allTree', '/menu/tree', 'POST', TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '156', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564515789338312704', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '341', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564516804485709824', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:34:07', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '259', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564516807253950464', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '83', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564500484490788864', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 14:29:16', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 14:29:17', 'SYYYY-MM-DD HH24:MI:SS'), '491', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 14:29:17', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564510436043259904', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:08:48', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:08:49', 'SYYYY-MM-DD HH24:MI:SS'), '1021', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:08:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564510566989430784', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:09:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:09:21', 'SYYYY-MM-DD HH24:MI:SS'), '281', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:09:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564511826157240320', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:14:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:14:21', 'SYYYY-MM-DD HH24:MI:SS'), '385', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:14:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564513084024815616', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:19:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:19:21', 'SYYYY-MM-DD HH24:MI:SS'), '357', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:19:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564514341816893440', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:24:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:24:20', 'SYYYY-MM-DD HH24:MI:SS'), '334', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:24:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564515600485580800', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 15:29:20', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:29:21', 'SYYYY-MM-DD HH24:MI:SS'), '394', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 15:29:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564515788365234176', '127.0.0.1', 'OPT', '内置超级管理员', '文件实时上传-根据文件id，获取文件临时的访问路径', 'top.tangyh.lamp.file.controller.FileController', 'findUrlById', '/file/anyone/findUrlById', 'POST', TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), '183', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564474955402313728', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '157', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564474957101006848', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '152', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564476213630599168', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '152', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564476215362846720', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564477471871467520', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '150', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564477473633075200', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '150', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564478730162667520', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '160', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564478731873943552', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '153', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564479988617445376', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '203', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564479990311944192', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '176', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564481246698930176', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '166', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564481248418594816', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '161', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564482505044656128', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:17:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:17:50', 'SYYYY-MM-DD HH24:MI:SS'), '178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:17:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564482508626591744', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:17:51', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:17:51', 'SYYYY-MM-DD HH24:MI:SS'), '158', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:17:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564483763109363712', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:22:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:22:50', 'SYYYY-MM-DD HH24:MI:SS'), '149', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:22:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564483973487263744', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:23:40', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:23:40', 'SYYYY-MM-DD HH24:MI:SS'), '155', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:23:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564485022008737792', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:27:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:27:50', 'SYYYY-MM-DD HH24:MI:SS'), '305', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:27:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564485035669585920', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:27:53', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:27:53', 'SYYYY-MM-DD HH24:MI:SS'), '150', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:27:53', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG" VALUES ('1564486279607877632', '127.0.0.1', 'OPT', '内置超级管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:32:50', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:32:50', 'SYYYY-MM-DD HH24:MI:SS'), '149', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.102 Safari/537.36 Edg/104.0.1293.70', TO_DATE('2022-08-30 13:32:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG" VALUES ('1564486296821301248', '127.0.0.1', 'OPT', '平台管理员', '我的消息-全量查询我的消息:第1页, 显示5行', 'top.tangyh.lamp.msg.controller.MyMsgController', 'myMsg', '/anyone/myMsg', 'POST', TO_DATE('2022-08-30 13:32:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-08-30 13:32:54', 'SYYYY-MM-DD HH24:MI:SS'), '159', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36', TO_DATE('2022-08-30 13:32:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');

-- ----------------------------
-- Table structure for C_OPT_LOG_EXT
-- ----------------------------
DROP TABLE "C_OPT_LOG_EXT";
CREATE TABLE "C_OPT_LOG_EXT" (
  "ID" NUMBER(20,0) NOT NULL,
  "PARAMS" CLOB,
  "RESULT" CLOB,
  "EX_DETAIL" CLOB,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_OPT_LOG_EXT"."ID" IS '主键';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."PARAMS" IS '请求参数';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."RESULT" IS '返回值';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."EX_DETAIL" IS '异常描述';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_OPT_LOG_EXT"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_OPT_LOG_EXT" IS '系统日志扩展';

-- ----------------------------
-- Records of C_OPT_LOG_EXT
-- ----------------------------
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564236272317235201', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777964057","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564236273609080832', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564237562053132288', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 21:04:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261133399883777', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661783891379","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564299543174971392', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 01:10:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564409735585726464', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661819320880","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 08:28:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564409736412004352', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564409737464774656', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661819321386","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 08:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564410700317589504', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661819550950","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 08:32:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564410701043204096', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564410702792228864', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661819551542","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 08:32:31', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564442221883686912', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564442223443968000', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661827066650","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 10:37:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564442258210553856', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661827074943","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 10:37:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564448191854673920', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661828489583","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564457710689189888', '[{"model":{"name":null,"orgId":null,"state":null,"describe":null,"createdOrgId":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:39:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564233611635326976', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777329673","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564233612302221312', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777329878","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564233612553879552', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:48:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564234893473349632', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777635334","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564268992145653760', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 23:09:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564268995954081792', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661785766002","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 23:09:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564459499119443968', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:46:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564460757716828160', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:51:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564461978649362432', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661831776611","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564461979844739072', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:16', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564461990577963008', '[null, null]', '{"code":0,"data":[],"msg":"ok","path":null,"extra":null,"timestamp":"1661831779506","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:56:19', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462008001101824', '[{"model":{"name":null,"orgId":null,"state":null,"describe":null,"createdOrgId":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:23', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462015760564224', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462021225742336', '[{"model":{"account":null,"name":null,"orgId":null,"stationId":null,"readonly":null,"email":null,"mobile":null,"sex":null,"state":null,"avatar":null,"nation":null,"education":null,"positionStatus":null,"workDescribe":null,"passwordErrorLastTime":null,"passwordErrorNum":null,"passwordExpireTime":null,"password":null,"salt":null,"lastLoginTime":null,"createdOrgId":null,"scope":null,"roleId":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:26', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462034924339200', '[{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"echoMap":{},"providerType":null,"appId":null,"appSecret":null,"url":null,"name":null,"content":null,"templateParams":null,"templateCode":null,"signName":null,"templateDescribe":null}]', '{"code":0,"data":[],"msg":"ok","path":null,"extra":null,"timestamp":"1661831790075","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564231691688476672', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:41:12', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564231693672382464', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661776872443","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:41:12', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564231743509102592', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661776884325","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:41:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564234875689500672', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:53:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564234893779533824', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564234895272706048', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777635767","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:53:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564236174933884928', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 20:59:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564443940042571776', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564444734347280384', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:47:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564445196773490688', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:49:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564445992764309504', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:52:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564446455052107776', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:54:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564447251269419008', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:57:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564457718905831424', '[{"model":{"account":null,"name":null,"orgId":null,"stationId":null,"readonly":null,"email":null,"mobile":null,"sex":null,"state":null,"avatar":null,"nation":null,"education":null,"positionStatus":null,"workDescribe":null,"passwordErrorLastTime":null,"passwordErrorNum":null,"passwordExpireTime":null,"password":null,"salt":null,"lastLoginTime":null,"createdOrgId":null,"scope":null,"roleId":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:39:21', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564458240912130048', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:41:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564239061307097088', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564241410385772544', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 21:19:49', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564260082747703296', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 22:34:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564330135346216960', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 03:12:22', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564448191879839744', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661828489552","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564448194111209472', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:01:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564449437055451136', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:06:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564450711167565824', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:11:30', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564451953742708736', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:16:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564453211849359360', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:21:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564454589049077760', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:26:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564455733808857088', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:31:27', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564456552490860544', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661830482965","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:34:42', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564456553124200448', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564456555246518272', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661830483623","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564456986542604288', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:36:26', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564457695564529664', '[null, null]', '{"code":0,"data":[],"msg":"ok","path":null,"extra":null,"timestamp":"1661830755495","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:39:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564236272317235200', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661777964057","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 20:59:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564239058228477952', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661778628208","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 21:10:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564239061579726848', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661778629086","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 21:10:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564240184780783616', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661778896805","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 21:14:56', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564240187691630592', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 21:14:57', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564240191831408640', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661778898562","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 21:14:58', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564241409865678848', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661779188966","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 21:19:48', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564256781905952768', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 22:20:53', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261133399883776', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661783891379","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261134230355968', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 22:38:11', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261224193982464', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261225326444544', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661783913341","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 22:38:33', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564261229650771968', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661783914368","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-29 22:38:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564284237400506368', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 00:09:59', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564314834869157888', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 02:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564353047583260672', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, 'org.mybatis.spring.MyBatisSystemException: nested exception is org.apache.ibatis.exceptions.PersistenceException:
### Error querying database.  Cause: org.springframework.jdbc.CannotGetJdbcConnectionException: Failed to obtain JDBC Connection; nested exception is com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
### The error may exist in file [/Users/tangyh/github/lamp-boot/lamp-msg/lamp-msg-biz/target/classes/mapper_msg/ext/MsgMapper.xml]
### The error may involve top.tangyh.lamp.msg.dao.MsgMapper.page_mpCount
### The error occurred while executing a query
### Cause: org.springframework.jdbc.CannotGetJdbcConnectionException: Failed to obtain JDBC Connection; nested exception is com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
	at org.mybatis.spring.MyBatisExceptionTranslator.translateExceptionIfPossible(MyBatisExceptionTranslator.java:96)
	at org.mybatis.spring.SqlSessionTemplate$SqlSessionInterceptor.invoke(SqlSessionTemplate.java:441)
	at com.sun.proxy.$Proxy160.selectList(Unknown Source)
	at org.mybatis.spring.SqlSessionTemplate.selectList(SqlSessionTemplate.java:224)
	at com.baomidou.mybatisplus.core.override.MybatisMapperMethod.executeForIPage(MybatisMapperMethod.java:121)
	at com.baomidou.mybatisplus.core.override.MybatisMapperMethod.execute(MybatisMapperMethod.java:85)
	at com.baomidou.mybatisplus.core.override.MybatisMapperProxy$PlainMethodInvoker.invoke(MybatisMapperProxy.java:148)
	at com.baomidou.mybatisplus.core.override.MybatisMapperProxy.invoke(MybatisMapperProxy.java:89)
	at com.sun.proxy.$Proxy243.page(Unknown Source)
	at jdk.internal.reflect.GeneratedMethodAccessor428.invoke(Unknown Source)
	at java.base/jdk.internal.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
	at java.base/java.lang.reflect.Method.invoke(Method.java:566)
	at org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:344)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:198)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:163)
	at org.springframework.dao.support.PersistenceExceptionTranslationInterceptor.invoke(PersistenceExceptionTranslationInterceptor.java:137)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:186)
	at org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:215)
	at com.sun.proxy.$Proxy244.page(Unknown Source)
	at top.tangyh.lamp.msg.service.impl.MsgServiceImpl.page(MsgServiceImpl.java:50)
	at top.tangyh.lamp.msg.service.impl.MsgServiceImpl$$FastClassBySpringCGLIB$$887250e6.invoke(<generated>)
	at org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:218)
	at org.springframework.aop.framework.CglibAopProxy.invokeMethod(CglibAopProxy.java:386)
	at org.springframework.aop.framework.CglibAopProxy.access$000(CglibAopProxy.java:85)
	at org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:704)
	at top.tangyh.lamp.msg.service.impl.MsgServiceImpl$$EnhancerBySpringCGLIB$$5b3f57d0.page(<generated>)
	at top.tangyh.lamp.msg.controller.MyMsgController.myMsg(MyMsgController.java:53)
	at top.tangyh.lamp.msg.controller.MyMsgController$$FastClassBySpringCGLIB$$2b3c05e2.invoke(<generated>)
	at org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:218)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:793)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:163)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.validation.beanvalidation.MethodValidationInterceptor.invoke(MethodValidationInterceptor.java:123)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:186)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.aop.aspectj.AspectJAfterThrowingAdvice.invoke(AspectJAfterThrowingAdvice.java:64)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:175)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.aop.framework.adapter.AfterReturningAdviceInterceptor.invoke(AfterReturningAdviceInterceptor.java:57)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:175)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.aop.framework.adapter.MethodBeforeAdviceInterceptor.invoke(MethodBeforeAdviceInterceptor.java:58)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:175)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:97)
	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:186)
	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.proceed(CglibAopProxy.java:763)
	at org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:708)
	at top.tangyh.lamp.msg.controller.MyMsgController$$EnhancerBySpringCGLIB$$7d457fb1.myMsg(<generated>)
	at java.base/jdk.internal.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
	at java.base/jdk.internal.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)
	at java.base/jdk.internal.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
	at java.base/java.lang.reflect.Method.invoke(Method.java:566)
	at org.springframework.web.method.support.InvocableHandlerMethod.doInvoke(InvocableHandlerMethod.java:205)
	at org.springframework.web.method.support.InvocableHandlerMethod.invokeForRequest(InvocableHandlerMethod.java:150)
	at org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod.invokeAndHandle(ServletInvocableHandlerMethod.java:117)
	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.invokeHandlerMethod(RequestMappingHandlerAdapter.java:895)
	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.handleInternal(RequestMappingHandlerAdapter.java:808)
	at org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter.handle(AbstractHandlerMethodAdapter.java:87)
	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:1067)
	at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:963)
	at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:1006)
	at org.springframework.web.servlet.FrameworkServlet.doPost(FrameworkServlet.java:909)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:517)
	at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:883)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:584)
	at io.undertow.servlet.handlers.ServletHandler.handleRequest(ServletHandler.java:74)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:129)
	at org.springframework.web.filter.CorsFilter.doFilterInternal(CorsFilter.java:91)
	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:117)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at com.alibaba.druid.support.http.WebStatFilter.doFilter(WebStatFilter.java:124)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at top.tangyh.basic.xss.filter.XssFilter.doFilter(XssFilter.java:66)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)
	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:117)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)
	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:117)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetricsFilter.doFilterInternal(WebMvcMetricsFilter.java:96)
	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:117)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)
	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:117)
	at io.undertow.servlet.core.ManagedFilter.doFilter(ManagedFilter.java:61)
	at io.undertow.servlet.handlers.FilterHandler$FilterChainImpl.doFilter(FilterHandler.java:131)
	at io.undertow.servlet.handlers.FilterHandler.handleRequest(FilterHandler.java:84)
	at io.undertow.servlet.handlers.security.ServletSecurityRoleHandler.handleRequest(ServletSecurityRoleHandler.java:62)
	at io.undertow.servlet.handlers.ServletChain$1.handleRequest(ServletChain.java:68)
	at io.undertow.servlet.handlers.ServletDispatchingHandler.handleRequest(ServletDispatchingHandler.java:36)
	at io.undertow.servlet.handlers.RedirectDirHandler.handleRequest(RedirectDirHandler.java:68)
	at io.undertow.servlet.handlers.security.SSLInformationAssociationHandler.handleRequest(SSLInformationAssociationHandler.java:117)
	at io.undertow.servlet.handlers.security.ServletAuthenticationCallHandler.handleRequest(ServletAuthenticationCallHandler.java:57)
	at io.undertow.server.handlers.PredicateHandler.handleRequest(PredicateHandler.java:43)
	at io.undertow.security.handlers.AbstractConfidentialityHandler.handleRequest(AbstractConfidentialityHandler.java:46)
	at io.undertow.servlet.handlers.security.ServletConfidentialityConstraintHandler.handleRequest(ServletConfidentialityConstraintHandler.java:64)
	at io.undertow.security.handlers.AuthenticationMechanismsHandler.handleRequest(AuthenticationMechanismsHandler.java:60)
	at io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler.handleRequest(CachedAuthenticatedSessionHandler.java:77)
	at io.undertow.security.handlers.AbstractSecurityContextAssociationHandler.handleRequest(AbstractSecurityContextAssociationHandler.java:43)
	at io.undertow.server.handlers.PredicateHandler.handleRequest(PredicateHandler.java:43)
	at io.undertow.servlet.handlers.SendErrorPageHandler.handleRequest(SendErrorPageHandler.java:52)
	at io.undertow.server.handlers.PredicateHandler.handleRequest(PredicateHandler.java:43)
	at io.undertow.servlet.handlers.ServletInitialHandler.handleFirstRequest(ServletInitialHandler.java:275)
	at io.undertow.servlet.handlers.ServletInitialHandler.access$100(ServletInitialHandler.java:79)
	at io.undertow.servlet.handlers.ServletInitialHandler$2.call(ServletInitialHandler.java:134)
	at io.undertow.servlet.handlers.ServletInitialHandler$2.call(ServletInitialHandler.java:131)
	at io.undertow.servlet.core.ServletRequestContextThreadSetupAction$1.call(ServletRequestContextThreadSetupAction.java:48)
	at io.undertow.servlet.core.ContextClassLoaderSetupAction$1.call(ContextClassLoaderSetupAction.java:43)
	at io.undertow.servlet.handlers.ServletInitialHandler.dispatchRequest(ServletInitialHandler.java:255)
	at io.undertow.servlet.handlers.ServletInitialHandler.access$000(ServletInitialHandler.java:79)
	at io.undertow.servlet.handlers.ServletInitialHandler$1.handleRequest(ServletInitialHandler.java:100)
	at io.undertow.server.Connectors.executeRootHandler(Connectors.java:387)
	at io.undertow.server.HttpServerExchange$1.run(HttpServerExchange.java:852)
	at org.jboss.threads.ContextClassLoaderSavingRunnable.run(ContextClassLoaderSavingRunnable.java:35)
	at org.jboss.threads.EnhancedQueueExecutor.safeRun(EnhancedQueueExecutor.java:2019)
	at org.jboss.threads.EnhancedQueueExecutor$ThreadBody.doRunTask(EnhancedQueueExecutor.java:1558)
	at org.jboss.threads.EnhancedQueueExecutor$ThreadBody.run(EnhancedQueueExecutor.java:1449)
	at org.xnio.XnioWorker$WorkerThreadFactory$1$1.run(XnioWorker.java:1280)
	at java.base/java.lang.Thread.run(Thread.java:834)
Caused by: org.apache.ibatis.exceptions.PersistenceException:
### Error querying database.  Cause: org.springframework.jdbc.CannotGetJdbcConnectionException: Failed to obtain JDBC Connection; nested exception is com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
### The error may exist in file [/Users/tangyh/github/lamp-boot/lamp-msg/lamp-msg-biz/target/classes/mapper_msg/ext/MsgMapper.xml]
### The error may involve top.tangyh.lamp.msg.dao.MsgMapper.page_mpCount
### The error occurred while executing a query
### Cause: org.springframework.jdbc.CannotGetJdbcConnectionException: Failed to obtain JDBC Connection; nested exception is com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
	at org.apache.ibatis.exceptions.ExceptionFactory.wrapException(ExceptionFactory.java:30)
	at org.apache.ibatis.session.defaults.DefaultSqlSession.selectList(DefaultSqlSession.java:153)
	at org.apache.ibatis.session.defaults.DefaultSqlSession.selectList(DefaultSqlSession.java:145)
	at org.apache.ibatis.session.defaults.DefaultSqlSession.selectList(DefaultSqlSession.java:140)
	at jdk.internal.reflect.GeneratedMethodAccessor397.invoke(Unknown Source)
	at java.base/jdk.internal.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
	at java.base/java.lang.reflect.Method.invoke(Method.java:566)
	at org.mybatis.spring.SqlSessionTemplate$SqlSessionInterceptor.invoke(SqlSessionTemplate.java:427)
	... 125 more
Caused by: org.springframework.jdbc.CannotGetJdbcConnectionException: Failed to obtain JDBC Connection; nested exception is com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
	at org.springframework.jdbc.datasource.DataSourceUtils.getConnection(DataSourceUtils.java:83)
	at org.mybatis.spring.transaction.SpringManagedTransaction.openConnection(SpringManagedTransaction.java:80)
	at org.mybatis.spring.transaction.SpringManagedTransaction.getConnection(SpringManagedTransaction.java:67)
	at org.apache.ibatis.executor.BaseExecutor.getConnection(BaseExecutor.java:337)
	at org.apache.ibatis.executor.SimpleExecutor.prepareStatement(SimpleExecutor.java:86)
	at org.apache.ibatis.executor.SimpleExecutor.doQuery(SimpleExecutor.java:62)
	at org.apache.ibatis.executor.BaseExecutor.queryFromDatabase(BaseExecutor.java:325)
	at org.apache.ibatis.executor.BaseExecutor.query(BaseExecutor.java:156)
	at com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor.willDoQuery(PaginationInnerInterceptor.java:135)
	at com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor.intercept(MybatisPlusInterceptor.java:75)
	at org.apache.ibatis.plugin.Plugin.invoke(Plugin.java:62)
	at com.sun.proxy.$Proxy362.query(Unknown Source)
	at org.apache.ibatis.session.defaults.DefaultSqlSession.selectList(DefaultSqlSession.java:151)
	... 131 more
Caused by: com.alibaba.druid.pool.GetConnectionTimeoutException: wait millis 60003, active 0, maxActive 200, creating 1, createElapseMillis 120152
	at com.alibaba.druid.pool.DruidDataSource.getConnectionInternal(DruidDataSource.java:1775)
	at com.alibaba.druid.pool.DruidDataSource.getConnectionDirect(DruidDataSource.java:1427)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5059)
	at com.alibaba.druid.filter.FilterAdapter.dataSource_getConnection(FilterAdapter.java:2756)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5055)
	at com.alibaba.druid.filter.logging.LogFilter.dataSource_getConnection(LogFilter.java:917)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5055)
	at com.alibaba.druid.filter.stat.StatFilter.dataSource_getConnection(StatFilter.java:726)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5055)
	at com.alibaba.druid.filter.FilterAdapter.dataSource_getConnection(FilterAdapter.java:2756)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5055)
	at com.alibaba.druid.filter.logging.LogFilter.dataSource_getConnection(LogFilter.java:917)
	at com.alibaba.druid.filter.FilterChainImpl.dataSource_connect(FilterChainImpl.java:5055)
	at com.alibaba.druid.pool.DruidDataSource.getConnection(DruidDataSource.java:1405)
	at com.alibaba.druid.pool.DruidDataSource.getConnection(DruidDataSource.java:1397)
	at com.alibaba.druid.pool.DruidDataSource.getConnection(DruidDataSource.java:100)
	at org.springframework.jdbc.datasource.DataSourceUtils.fetchConnection(DataSourceUtils.java:159)
	at org.springframework.jdbc.datasource.DataSourceUtils.doGetConnection(DataSourceUtils.java:117)
	at org.springframework.jdbc.datasource.DataSourceUtils.getConnection(DataSourceUtils.java:80)
	... 143 more
', TO_DATE('2022-08-30 04:43:25', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564443939069493248', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661827475683","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 10:44:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564447713183924224', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 10:59:35', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462035104694272', '[{"model":{"templateId":null,"status":null,"sourceType":null,"telNum":null,"topic":null,"templateParams":null,"sendTime":null,"content":null,"draft":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462040754421760', '[{"model":{"providerType":null,"appId":null,"appSecret":null,"url":null,"name":null,"content":null,"templateParams":null,"templateCode":null,"signName":null,"templateDescribe":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:31', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462046676779008', '[{"model":{"bizType":null,"fileType":null,"storageType":null,"bucket":null,"path":null,"url":null,"uniqueFileName":null,"fileMd5":null,"originalFileName":null,"contentType":null,"suffix":null,"size":null,"id":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:32', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462057850404864', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:35', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462097062952960', '[{"model":{"name":null,"code":null,"describe":null,"state":null,"readonly":null,"category":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:44', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462105816465408', '[]', '{"code":0,"data":[{"id":"1564456404956217344","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"工作台","parentId":"0","sortValue":20,"children":[{"id":"1564456404956217350","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"通知公告","parentId":"1564456404956217344","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/notice","component":"lamp/workbench/notice/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217351","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"待我审批","parentId":"1564456404956217344","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/todo","component":"lamp/workbench/todo/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217352","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"我已审批","parentId":"1564456404956217344","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/done","component":"lamp/workbench/done/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217353","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"我发起的","parentId":"1564456404956217344","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/started","component":"lamp/workbench/started/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench","component":"Layout","state":true,"icon":"fa fa-tachometer","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217345","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"组织管理","parentId":"0","sortValue":30,"children":[{"id":"1564456404956217354","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"机构管理","parentId":"1564456404956217345","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/org","component":"lamp/org/org/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217355","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"岗位管理","parentId":"1564456404956217345","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/station","component":"lamp/org/station/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217356","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"用户管理","parentId":"1564456404956217345","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/user","component":"lamp/org/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org","component":"Layout","state":true,"icon":"fa fa-users","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217346","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"资源中心","parentId":"0","sortValue":40,"children":[{"id":"1564456404956217357","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"消息中心","parentId":"1564456404956217346","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/msg","component":"lamp/resources/msg/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217358","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"短信模版","parentId":"1564456404956217346","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/smsTemplate","component":"lamp/resources/smsTemplate/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217359","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"短信中心","parentId":"1564456404956217346","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/sms","component":"lamp/resources/sms/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217360","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"附件管理","parentId":"1564456404956217346","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/attachment","component":"lamp/resources/attachment/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources","component":"Layout","state":true,"icon":"fa fa-cloud","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217347","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"流程管理","parentId":"0","sortValue":50,"children":[{"id":"1564456405463728128","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"流程部署","parentId":"1564456404956217347","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/deploymentManager","component":"lamp/activiti/deploymentManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405484699648","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"模型管理","parentId":"1564456404956217347","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/modelManager","component":"lamp/activiti/modelManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217361","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假流程","parentId":"1564456404956217347","sortValue":30,"children":[{"id":"1564456405522448384","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假管理","parentId":"1564456404956217361","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/instant","component":"lamp/activiti/leave/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405535031296","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假任务","parentId":"1564456404956217361","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/ruTask","component":"lamp/activiti/leave/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217362","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销流程","parentId":"1564456404956217347","sortValue":40,"children":[{"id":"1564456405551808512","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销管理","parentId":"1564456404956217362","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/instantManager","component":"lamp/activiti/reimbursement/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405568585728","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销任务","parentId":"1564456404956217362","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/ruTask","component":"lamp/activiti/reimbursement/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement","component":"lamp/activiti/reimbursement/Index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti","component":"Layout","state":true,"icon":"fa fa-retweet","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217348","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"系统设置","parentId":"0","sortValue":60,"children":[{"id":"1564456404956217363","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"菜单管理","parentId":"1564456404956217348","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/menu","component":"lamp/system/menu/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217364","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"角色管理","parentId":"1564456404956217348","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/role","component":"lamp/system/role/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217365","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"字典管理","parentId":"1564456404956217348","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/dictionary","component":"lamp/system/dictionary/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217366","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"地区管理","parentId":"1564456404956217348","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/area","component":"lamp/system/area/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217367","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"参数管理","parentId":"1564456404956217348","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/parameter","component":"lamp/system/parameter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217368","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"操作日志","parentId":"1564456404956217348","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/optLog","component":"lamp/system/optLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217369","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"登录日志","parentId":"1564456404956217348","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/loginLog","component":"lamp/system/loginLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404960411648","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"在线用户","parentId":"1564456404956217348","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/online","component":"lamp/system/online/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404960411649","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"应用管理","parentId":"1564456404956217348","sortValue":90,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/application","component":"lamp/system/application/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/system","component":"Layout","state":true,"icon":"fa fa-gears","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217349","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"网关管理","parentId":"0","sortValue":70,"children":[{"id":"1564456405694414848","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"限流规则","parentId":"1564456404956217349","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/ratelimiter","component":"lamp/gateway/ratelimiter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405706997760","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"阻止访问","parentId":"1564456404956217349","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/blocklist","component":"lamp/gateway/blocklist/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway","component":"Layout","state":true,"icon":"fa fa-sort-amount-asc","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"msg":"ok","path":null,"extra":null,"timestamp":"1661831806973","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:56:47', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462117493407744', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"1564456404956217347","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462581190492161', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661831920320","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564469943934648320', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564471186555928576', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:32:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564481248418594816', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564482505044656128', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:17:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564482508626591744', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:17:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564483763109363712', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:22:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564483973487263744', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:23:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564471186560122880', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:32:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564485022008737792', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:27:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564485035669585920', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:27:53', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564486279607877632', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:32:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564486296821301248', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:32:54', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499094880124928', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661840625856","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 14:23:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499096620761088', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499098977959936', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661840626838","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 14:23:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499108947820544', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661840629212","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499110822674432', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564499112739471360', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661840630118","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 14:23:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564515600485580800', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:29:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564515750838796288', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:29:57', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564515788365234176', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661844605895","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:30:05', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564516781253459968', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:34:02', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564516808851980288', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564516811427282944', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661844849815","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:34:09', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564493276596142080', '[1564456408345214976]', '{"code":0,"data":{"id":"1564456408345214976","createTime":"2022-08-30 11:34:08","createdBy":"3","updateTime":"2022-08-30 11:34:08","updatedBy":"3","echoMap":{},"account":"lampAdmin","name":"内置超级管理员","orgId":null,"stationId":null,"readonly":true,"email":null,"mobile":null,"sex":{"code":"M","desc":"男"},"state":true,"avatar":"cnrhVkzwxjPwAaCfPbdc.png","nation":null,"education":null,"positionStatus":null,"workDescribe":null,"passwordErrorLastTime":null,"passwordErrorNum":0,"passwordExpireTime":null,"password":"1ff8b82251ae49316ce60e22a3dcc1689243a983718b033855248de3d9c65e9b","salt":"epv6f6rfbyrntlhirv57","lastLoginTime":"2022-08-30 11:56:15","createdOrgId":null},"msg":"ok","path":null,"extra":null,"timestamp":"1661839238667","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 14:00:38', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564496067444080640', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:11:44', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564496297023504384', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:12:38', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564497321767469056', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:16:43', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564497558506569728', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:17:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564498596852662272', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:21:47', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564498831523971072', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:22:43', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564515789095043072', '[[null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661844606073","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564517944174575616', '[{"model":{"type":"NATION","label":null,"code":null,"name":null,"state":null,"describe":null,"sortValue":null,"icon":null,"cssStyle":null,"cssClass":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:38:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518000843816960', '[0]', '{"code":0,"data":[],"msg":"ok","path":null,"extra":null,"timestamp":"1661845133393","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:38:53', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518023233011712', '[{"model":{"key":null,"value":null,"name":null,"describe":null,"state":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:38:58', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518047870353408', '[{"model":{"id":null,"createTime":null,"createdBy":null,"requestIp":null,"userId":null,"userName":null,"account":null,"description":null,"loginDate":null,"ua":null,"browser":null,"browserVersion":null,"operatingSystem":null,"location":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:39:04', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518074550321152', '[{"model":{"clientId":null,"clientSecret":null,"website":null,"name":null,"icon":null,"appType":null,"describe":null,"state":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:39:10', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462105833242624', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"0","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:56:47', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462578912985088', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:58:39', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462580481654784', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564462581190492160', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661831920320","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 11:58:40', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518167819059200', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:39:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564518172436987904', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:39:34', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519157754494976', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661845409224","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519462772670464', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"0","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519480019648512', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"1564456404960411648","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:46', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564520415982780416', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:48:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564520684007194624', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:49:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564521674013933568', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:53:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564488804864098304', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564488805904285696', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:42:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564490062391934976', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564490064115793920', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:47:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564491321450692608', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564491322360856576', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:52:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564492579020472320', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564492580740136960', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:57:52', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519203271081984', '[]', '{"code":0,"data":[{"id":"10","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户设置","parentId":"0","sortValue":10,"children":[{"id":"112","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据源配置","parentId":"10","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/datasourceConfig","component":"lamp/tenant/datasourceConfig/index","state":true,"icon":null,"group":null,"readonly":false,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"110","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户管理","parentId":"10","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/tenant","component":"lamp/tenant/tenant/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"111","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"超级用户","parentId":"10","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/user","component":"lamp/tenant/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant","component":"Layout","state":true,"icon":"ant-design:group-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"20","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"工作台","parentId":"0","sortValue":20,"children":[{"id":"120","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"通知公告","parentId":"20","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/notice","component":"lamp/workbench/notice/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"121","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"待我审批","parentId":"20","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/todo","component":"lamp/workbench/todo/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"122","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我已审批","parentId":"20","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/done","component":"lamp/workbench/done/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"123","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我发起的","parentId":"20","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/started","component":"lamp/workbench/started/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench","component":"Layout","state":true,"icon":"ant-design:dashboard-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"30","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"组织管理","parentId":"0","sortValue":30,"children":[{"id":"130","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"机构管理","parentId":"30","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/org","component":"lamp/org/org/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"131","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"岗位管理","parentId":"30","sortValue":20,"children":[{"id":"1486619304207056896","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"131","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486619392048365568","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"131","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620313587286016","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"131","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"03","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620425789112320","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"131","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620477806870528","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"131","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620546081751040","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"131","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,131,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/station","component":"lamp/org/station/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"132","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"用户管理","parentId":"30","sortValue":30,"children":[{"id":"1486201050779090944","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"132","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201491877265408","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"132","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201562119274496","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"132","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201715840516096","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"132","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201804327747584","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"132","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201872350969856","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"132","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201971705643008","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看自定义数据","parentId":"132","sortValue":7,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"07","customClass":"DATA_SCOPE_MY_TEST","isDef":false,"treeGrade":2,"treePath":",30,132,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/user","component":"lamp/org/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org","component":"Layout","state":true,"icon":"ant-design:cluster-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"40","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"资源中心","parentId":"0","sortValue":40,"children":[{"id":"140","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"消息中心","parentId":"40","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/msg","component":"lamp/resources/msg/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"141","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信模版","parentId":"40","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/smsTemplate","component":"lamp/resources/smsTemplate/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"142","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信中心","parentId":"40","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/sms","component":"lamp/resources/sms/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"143","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"附件管理","parentId":"40","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/attachment","component":"lamp/resources/attachment/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources","component":"Layout","state":true,"icon":"ant-design:cloud-server-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"50","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程管理","parentId":"0","sortValue":50,"children":[{"id":"150","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程部署","parentId":"50","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/deploymentManager","component":"lamp/activiti/deploymentManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"151","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"模型管理","parentId":"50","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/modelManager","component":"lamp/activiti/modelManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"152","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假流程","parentId":"50","sortValue":30,"children":[{"id":"153","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假管理","parentId":"152","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/instant","component":"lamp/activiti/leave/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"},{"id":"154","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假任务","parentId":"152","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/ruTask","component":"lamp/activiti/leave/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/level","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"155","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销流程","parentId":"50","sortValue":40,"children":[{"id":"156","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销管理","parentId":"155","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/instantManager","component":"lamp/activiti/reimbursement/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"},{"id":"157","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销任务","parentId":"155","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/ruTask","component":"lamp/activiti/reimbursement/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti","component":"Layout","state":true,"icon":"tabler:chart-dots","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"60","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"系统设置","parentId":"0","sortValue":60,"children":[{"id":"160","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单管理","parentId":"60","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/menu","component":"lamp/system/menu/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"161","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"角色管理","parentId":"60","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/role","component":"lamp/system/role/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"162","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"字典管理","parentId":"60","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/dictionary","component":"lamp/system/dictionary/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"163","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"地区管理","parentId":"60","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/area","component":"lamp/system/area/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"164","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"参数管理","parentId":"60","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/parameter","component":"lamp/system/parameter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"165","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"操作日志","parentId":"60","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/optLog","component":"lamp/system/optLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"166","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"登录日志","parentId":"60","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/loginLog","component":"lamp/system/loginLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"167","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线用户","parentId":"60","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/online","component":"lamp/system/online/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"168","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"应用管理","parentId":"60","sortValue":90,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/application","component":"lamp/system/application/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/system","component":"Layout","state":true,"icon":"ant-design:setting-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"70","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"网关管理","parentId":"0","sortValue":70,"children":[{"id":"180","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"限流规则","parentId":"70","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/ratelimiter","component":"lamp/gateway/ratelimiter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"},{"id":"181","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"阻止访问","parentId":"70","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/blocklist","component":"lamp/gateway/blocklist/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway","component":"Layout","state":true,"icon":"ant-design:sliders-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"80","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"开发者管理","parentId":"0","sortValue":80,"children":[{"id":"190","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"定时任务","parentId":"80","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8767/xxl-job-admin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"191","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"接口文档","parentId":"80","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8760/api/gate/doc.html","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"192","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"nacos","parentId":"80","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8848/nacos","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"193","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"服务监控","parentId":"80","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8762/lamp-monitor","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"194","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据库监控","parentId":"80","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer/db","component":"lamp/developer/db/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"195","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"缓存监控","parentId":"80","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"https://github.com/junegunn/redis-stat","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"196","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"zipkin监控","parentId":"80","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8772/zipkin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"197","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"SkyWalking监控","parentId":"80","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:12080","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer","component":"Layout","state":true,"icon":"ant-design:bug-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"90","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"了解lamp","parentId":"0","sortValue":90,"children":[{"id":"210","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线文档","parentId":"90","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"211","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"会员版","parentId":"90","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003629","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"212","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"获取源码","parentId":"90","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/zuihou","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"213","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"问题反馈","parentId":"90","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/dromara/lamp-cloud/issues","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"214","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更新日志","parentId":"90","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/1465302","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"215","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"蓝图","parentId":"90","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003640","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/community","component":"Layout","state":true,"icon":"ant-design:github-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"100","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更多功能","parentId":"0","sortValue":100,"children":[{"id":"220","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"多级菜单","parentId":"100","sortValue":1,"children":[{"id":"221","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1","parentId":"220","sortValue":1,"children":[{"id":"222","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-1","parentId":"221","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-1","component":"lamp/more/multiMenu/menu1-1/menu1-1-1/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"},{"id":"223","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-2","parentId":"221","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-2","component":"lamp/more/multiMenu/menu1-1/menu1-1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"},{"id":"224","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-2","parentId":"220","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-2","component":"lamp/more/multiMenu/menu1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",100,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more","component":"Layout","state":true,"icon":"ant-design:appstore-add-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","}],"msg":"ok","path":null,"extra":null,"timestamp":"1661845420075","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519204428709888', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"0","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:43:40', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519233994358784', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"0","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:43:47', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519388906782720', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"167","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:24', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519400726331392', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"166","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:27', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519408355770368', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"167","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519425921515520', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:44:33', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519461518573568', '[]', '{"code":0,"data":[{"id":"1564456404956217344","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"工作台","parentId":"0","sortValue":20,"children":[{"id":"1564456404956217350","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"通知公告","parentId":"1564456404956217344","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/notice","component":"lamp/workbench/notice/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217351","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"待我审批","parentId":"1564456404956217344","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/todo","component":"lamp/workbench/todo/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217352","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"我已审批","parentId":"1564456404956217344","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/done","component":"lamp/workbench/done/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217353","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"我发起的","parentId":"1564456404956217344","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/started","component":"lamp/workbench/started/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench","component":"Layout","state":true,"icon":"fa fa-tachometer","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217345","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"组织管理","parentId":"0","sortValue":30,"children":[{"id":"1564456404956217354","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"机构管理","parentId":"1564456404956217345","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/org","component":"lamp/org/org/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217355","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"岗位管理","parentId":"1564456404956217345","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/station","component":"lamp/org/station/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217356","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"用户管理","parentId":"1564456404956217345","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/user","component":"lamp/org/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org","component":"Layout","state":true,"icon":"fa fa-users","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217346","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"资源中心","parentId":"0","sortValue":40,"children":[{"id":"1564456404956217357","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"消息中心","parentId":"1564456404956217346","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/msg","component":"lamp/resources/msg/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217358","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"短信模版","parentId":"1564456404956217346","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/smsTemplate","component":"lamp/resources/smsTemplate/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217359","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"短信中心","parentId":"1564456404956217346","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/sms","component":"lamp/resources/sms/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217360","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"附件管理","parentId":"1564456404956217346","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/attachment","component":"lamp/resources/attachment/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources","component":"Layout","state":true,"icon":"fa fa-cloud","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217347","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"流程管理","parentId":"0","sortValue":50,"children":[{"id":"1564456405463728128","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"流程部署","parentId":"1564456404956217347","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/deploymentManager","component":"lamp/activiti/deploymentManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405484699648","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"模型管理","parentId":"1564456404956217347","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/modelManager","component":"lamp/activiti/modelManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217361","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假流程","parentId":"1564456404956217347","sortValue":30,"children":[{"id":"1564456405522448384","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假管理","parentId":"1564456404956217361","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/instant","component":"lamp/activiti/leave/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405535031296","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"请假任务","parentId":"1564456404956217361","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/ruTask","component":"lamp/activiti/leave/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217362","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销流程","parentId":"1564456404956217347","sortValue":40,"children":[{"id":"1564456405551808512","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销管理","parentId":"1564456404956217362","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/instantManager","component":"lamp/activiti/reimbursement/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405568585728","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"报销任务","parentId":"1564456404956217362","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/ruTask","component":"lamp/activiti/reimbursement/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement","component":"lamp/activiti/reimbursement/Index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti","component":"Layout","state":true,"icon":"fa fa-retweet","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217348","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"系统设置","parentId":"0","sortValue":60,"children":[{"id":"1564456404956217363","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"菜单管理","parentId":"1564456404956217348","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/menu","component":"lamp/system/menu/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217364","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"角色管理","parentId":"1564456404956217348","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/role","component":"lamp/system/role/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217365","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"字典管理","parentId":"1564456404956217348","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/dictionary","component":"lamp/system/dictionary/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217366","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"地区管理","parentId":"1564456404956217348","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/area","component":"lamp/system/area/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217367","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"参数管理","parentId":"1564456404956217348","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/parameter","component":"lamp/system/parameter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217368","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"操作日志","parentId":"1564456404956217348","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/optLog","component":"lamp/system/optLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217369","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"登录日志","parentId":"1564456404956217348","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/loginLog","component":"lamp/system/loginLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404960411648","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"在线用户","parentId":"1564456404956217348","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/online","component":"lamp/system/online/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404960411649","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"应用管理","parentId":"1564456404956217348","sortValue":90,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/application","component":"lamp/system/application/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/system","component":"Layout","state":true,"icon":"fa fa-gears","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456404956217349","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"网关管理","parentId":"0","sortValue":70,"children":[{"id":"1564456405694414848","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"限流规则","parentId":"1564456404956217349","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/ratelimiter","component":"lamp/gateway/ratelimiter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null},{"id":"1564456405706997760","createTime":"2022-08-30 11:34:07","createdBy":"3","updateTime":"2022-08-30 11:34:07","updatedBy":"3","label":"阻止访问","parentId":"1564456404956217349","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/blocklist","component":"lamp/gateway/blocklist/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway","component":"Layout","state":true,"icon":"fa fa-sort-amount-asc","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":false,"treeGrade":null,"treePath":null}],"msg":"ok","path":null,"extra":null,"timestamp":"1661845481645","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:44:41', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564515789338312704', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:30:06', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564516804485709824', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564516807253950464', '[[null,null,null,null]]', '{"code":0,"data":{},"msg":"ok","path":null,"extra":null,"timestamp":"1661844848820","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564517945034407936', '[{"model":{"type":"NATION","label":null,"code":null,"name":null,"state":null,"describe":null,"sortValue":null,"icon":null,"cssStyle":null,"cssClass":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:38:40', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564517990920093696', '[{"model":{"key":null,"value":null,"name":null,"describe":null,"state":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:38:51', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519155061751808', '[]', '{"code":0,"data":[{"id":"10","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户设置","parentId":"0","sortValue":10,"children":[{"id":"112","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据源配置","parentId":"10","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/datasourceConfig","component":"lamp/tenant/datasourceConfig/index","state":true,"icon":null,"group":null,"readonly":false,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"110","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户管理","parentId":"10","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/tenant","component":"lamp/tenant/tenant/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"111","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"超级用户","parentId":"10","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/user","component":"lamp/tenant/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant","component":"Layout","state":true,"icon":"ant-design:group-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"20","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"工作台","parentId":"0","sortValue":20,"children":[{"id":"120","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"通知公告","parentId":"20","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/notice","component":"lamp/workbench/notice/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"121","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"待我审批","parentId":"20","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/todo","component":"lamp/workbench/todo/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"122","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我已审批","parentId":"20","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/done","component":"lamp/workbench/done/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"123","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我发起的","parentId":"20","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/started","component":"lamp/workbench/started/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench","component":"Layout","state":true,"icon":"ant-design:dashboard-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"30","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"组织管理","parentId":"0","sortValue":30,"children":[{"id":"130","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"机构管理","parentId":"30","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/org","component":"lamp/org/org/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"131","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"岗位管理","parentId":"30","sortValue":20,"children":[{"id":"1486619304207056896","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"131","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486619392048365568","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"131","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620313587286016","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"131","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"03","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620425789112320","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"131","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620477806870528","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"131","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620546081751040","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"131","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,131,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/station","component":"lamp/org/station/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"132","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"用户管理","parentId":"30","sortValue":30,"children":[{"id":"1486201050779090944","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"132","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201491877265408","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"132","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201562119274496","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"132","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201715840516096","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"132","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201804327747584","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"132","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201872350969856","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"132","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201971705643008","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看自定义数据","parentId":"132","sortValue":7,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"07","customClass":"DATA_SCOPE_MY_TEST","isDef":false,"treeGrade":2,"treePath":",30,132,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/user","component":"lamp/org/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org","component":"Layout","state":true,"icon":"ant-design:cluster-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"40","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"资源中心","parentId":"0","sortValue":40,"children":[{"id":"140","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"消息中心","parentId":"40","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/msg","component":"lamp/resources/msg/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"141","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信模版","parentId":"40","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/smsTemplate","component":"lamp/resources/smsTemplate/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"142","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信中心","parentId":"40","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/sms","component":"lamp/resources/sms/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"143","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"附件管理","parentId":"40","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/attachment","component":"lamp/resources/attachment/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources","component":"Layout","state":true,"icon":"ant-design:cloud-server-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"50","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程管理","parentId":"0","sortValue":50,"children":[{"id":"150","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程部署","parentId":"50","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/deploymentManager","component":"lamp/activiti/deploymentManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"151","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"模型管理","parentId":"50","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/modelManager","component":"lamp/activiti/modelManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"152","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假流程","parentId":"50","sortValue":30,"children":[{"id":"153","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假管理","parentId":"152","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/instant","component":"lamp/activiti/leave/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"},{"id":"154","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假任务","parentId":"152","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/ruTask","component":"lamp/activiti/leave/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/level","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"155","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销流程","parentId":"50","sortValue":40,"children":[{"id":"156","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销管理","parentId":"155","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/instantManager","component":"lamp/activiti/reimbursement/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"},{"id":"157","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销任务","parentId":"155","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/ruTask","component":"lamp/activiti/reimbursement/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti","component":"Layout","state":true,"icon":"tabler:chart-dots","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"60","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"系统设置","parentId":"0","sortValue":60,"children":[{"id":"160","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单管理","parentId":"60","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/menu","component":"lamp/system/menu/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"161","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"角色管理","parentId":"60","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/role","component":"lamp/system/role/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"162","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"字典管理","parentId":"60","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/dictionary","component":"lamp/system/dictionary/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"163","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"地区管理","parentId":"60","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/area","component":"lamp/system/area/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"164","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"参数管理","parentId":"60","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/parameter","component":"lamp/system/parameter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"165","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"操作日志","parentId":"60","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/optLog","component":"lamp/system/optLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"166","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"登录日志","parentId":"60","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/loginLog","component":"lamp/system/loginLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"167","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线用户","parentId":"60","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/online","component":"lamp/system/online/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"168","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"应用管理","parentId":"60","sortValue":90,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/application","component":"lamp/system/application/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/system","component":"Layout","state":true,"icon":"ant-design:setting-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"70","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"网关管理","parentId":"0","sortValue":70,"children":[{"id":"180","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"限流规则","parentId":"70","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/ratelimiter","component":"lamp/gateway/ratelimiter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"},{"id":"181","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"阻止访问","parentId":"70","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/blocklist","component":"lamp/gateway/blocklist/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway","component":"Layout","state":true,"icon":"ant-design:sliders-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"80","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"开发者管理","parentId":"0","sortValue":80,"children":[{"id":"190","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"定时任务","parentId":"80","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8767/xxl-job-admin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"191","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"接口文档","parentId":"80","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8760/api/gate/doc.html","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"192","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"nacos","parentId":"80","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8848/nacos","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"193","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"服务监控","parentId":"80","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8762/lamp-monitor","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"194","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据库监控","parentId":"80","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer/db","component":"lamp/developer/db/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"195","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"缓存监控","parentId":"80","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"https://github.com/junegunn/redis-stat","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"196","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"zipkin监控","parentId":"80","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8772/zipkin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"197","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"SkyWalking监控","parentId":"80","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:12080","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer","component":"Layout","state":true,"icon":"ant-design:bug-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"90","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"了解lamp","parentId":"0","sortValue":90,"children":[{"id":"210","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线文档","parentId":"90","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"211","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"会员版","parentId":"90","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003629","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"212","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"获取源码","parentId":"90","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/zuihou","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"213","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"问题反馈","parentId":"90","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/dromara/lamp-cloud/issues","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"214","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更新日志","parentId":"90","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/1465302","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"215","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"蓝图","parentId":"90","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003640","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/community","component":"Layout","state":true,"icon":"ant-design:github-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"100","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更多功能","parentId":"0","sortValue":100,"children":[{"id":"220","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"多级菜单","parentId":"100","sortValue":1,"children":[{"id":"221","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1","parentId":"220","sortValue":1,"children":[{"id":"222","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-1","parentId":"221","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-1","component":"lamp/more/multiMenu/menu1-1/menu1-1-1/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"},{"id":"223","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-2","parentId":"221","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-2","component":"lamp/more/multiMenu/menu1-1/menu1-1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"},{"id":"224","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-2","parentId":"220","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-2","component":"lamp/more/multiMenu/menu1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",100,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more","component":"Layout","state":true,"icon":"ant-design:appstore-add-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","}],"msg":"ok","path":null,"extra":null,"timestamp":"1661845408563","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519155875446784', '[]', '{"code":0,"data":[{"id":"10","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户设置","parentId":"0","sortValue":10,"children":[{"id":"112","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据源配置","parentId":"10","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/datasourceConfig","component":"lamp/tenant/datasourceConfig/index","state":true,"icon":null,"group":null,"readonly":false,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"110","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"租户管理","parentId":"10","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/tenant","component":"lamp/tenant/tenant/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"},{"id":"111","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"超级用户","parentId":"10","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant/user","component":"lamp/tenant/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",10,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/tenant","component":"Layout","state":true,"icon":"ant-design:group-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"20","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"工作台","parentId":"0","sortValue":20,"children":[{"id":"120","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"通知公告","parentId":"20","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/notice","component":"lamp/workbench/notice/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"121","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"待我审批","parentId":"20","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/todo","component":"lamp/workbench/todo/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"122","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我已审批","parentId":"20","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/done","component":"lamp/workbench/done/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"},{"id":"123","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"我发起的","parentId":"20","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench/started","component":"lamp/workbench/started/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",20,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/workbench","component":"Layout","state":true,"icon":"ant-design:dashboard-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"30","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"组织管理","parentId":"0","sortValue":30,"children":[{"id":"130","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"机构管理","parentId":"30","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/org","component":"lamp/org/org/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"131","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"岗位管理","parentId":"30","sortValue":20,"children":[{"id":"1486619304207056896","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"131","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486619392048365568","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"131","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620313587286016","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"131","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"03","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620425789112320","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"131","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620477806870528","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"131","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,131,"},{"id":"1486620546081751040","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"131","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,131,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/station","component":"lamp/org/station/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"},{"id":"132","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"用户管理","parentId":"30","sortValue":30,"children":[{"id":"1486201050779090944","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看全部","parentId":"132","sortValue":1,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"01","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201491877265408","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位及子单位","parentId":"132","sortValue":2,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"02","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201562119274496","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本单位","parentId":"132","sortValue":3,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201715840516096","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门及子部门","parentId":"132","sortValue":4,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"04","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201804327747584","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看本部门","parentId":"132","sortValue":5,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"05","customClass":null,"isDef":false,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201872350969856","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看个人","parentId":"132","sortValue":6,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"06","customClass":null,"isDef":true,"treeGrade":2,"treePath":",30,132,"},{"id":"1486201971705643008","createTime":"2022-08-29 00:00:00","createdBy":"2","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"查看自定义数据","parentId":"132","sortValue":7,"children":null,"describe":null,"resourceType":"60","isGeneral":false,"path":null,"component":null,"state":true,"icon":null,"group":null,"readonly":true,"dataScope":"07","customClass":"DATA_SCOPE_MY_TEST","isDef":false,"treeGrade":2,"treePath":",30,132,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org/user","component":"lamp/org/user/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",30,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/org","component":"Layout","state":true,"icon":"ant-design:cluster-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"40","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"资源中心","parentId":"0","sortValue":40,"children":[{"id":"140","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"消息中心","parentId":"40","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/msg","component":"lamp/resources/msg/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"141","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信模版","parentId":"40","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/smsTemplate","component":"lamp/resources/smsTemplate/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"142","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"短信中心","parentId":"40","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/sms","component":"lamp/resources/sms/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"},{"id":"143","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"附件管理","parentId":"40","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources/attachment","component":"lamp/resources/attachment/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",40,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/resources","component":"Layout","state":true,"icon":"ant-design:cloud-server-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"50","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程管理","parentId":"0","sortValue":50,"children":[{"id":"150","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"流程部署","parentId":"50","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/deploymentManager","component":"lamp/activiti/deploymentManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"151","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"模型管理","parentId":"50","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/modelManager","component":"lamp/activiti/modelManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"152","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假流程","parentId":"50","sortValue":30,"children":[{"id":"153","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假管理","parentId":"152","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/instant","component":"lamp/activiti/leave/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"},{"id":"154","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"请假任务","parentId":"152","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/leave/ruTask","component":"lamp/activiti/leave/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,152,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/level","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"},{"id":"155","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销流程","parentId":"50","sortValue":40,"children":[{"id":"156","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销管理","parentId":"155","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/instantManager","component":"lamp/activiti/reimbursement/instantManager/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"},{"id":"157","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"报销任务","parentId":"155","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement/ruTask","component":"lamp/activiti/reimbursement/ruTask/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",50,155,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti/reimbursement","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",50,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/activiti","component":"Layout","state":true,"icon":"tabler:chart-dots","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"60","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"系统设置","parentId":"0","sortValue":60,"children":[{"id":"160","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单管理","parentId":"60","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/menu","component":"lamp/system/menu/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"161","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"角色管理","parentId":"60","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/role","component":"lamp/system/role/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"162","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"字典管理","parentId":"60","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/dictionary","component":"lamp/system/dictionary/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"163","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"地区管理","parentId":"60","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/area","component":"lamp/system/area/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"164","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"参数管理","parentId":"60","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/parameter","component":"lamp/system/parameter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"165","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"操作日志","parentId":"60","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/optLog","component":"lamp/system/optLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"166","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"登录日志","parentId":"60","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/loginLog","component":"lamp/system/loginLog/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"167","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线用户","parentId":"60","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/online","component":"lamp/system/online/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"},{"id":"168","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"应用管理","parentId":"60","sortValue":90,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/system/application","component":"lamp/system/application/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",60,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/system","component":"Layout","state":true,"icon":"ant-design:setting-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"70","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"网关管理","parentId":"0","sortValue":70,"children":[{"id":"180","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"限流规则","parentId":"70","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/ratelimiter","component":"lamp/gateway/ratelimiter/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"},{"id":"181","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"阻止访问","parentId":"70","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway/blocklist","component":"lamp/gateway/blocklist/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",70,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/gateway","component":"Layout","state":true,"icon":"ant-design:sliders-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"80","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"开发者管理","parentId":"0","sortValue":80,"children":[{"id":"190","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"定时任务","parentId":"80","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8767/xxl-job-admin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"191","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"接口文档","parentId":"80","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8760/api/gate/doc.html","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"192","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"nacos","parentId":"80","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8848/nacos","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"193","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"服务监控","parentId":"80","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8762/lamp-monitor","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"194","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"数据库监控","parentId":"80","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer/db","component":"lamp/developer/db/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"195","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"缓存监控","parentId":"80","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"https://github.com/junegunn/redis-stat","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"196","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"zipkin监控","parentId":"80","sortValue":70,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:8772/zipkin","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"},{"id":"197","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"SkyWalking监控","parentId":"80","sortValue":80,"children":null,"describe":null,"resourceType":"20","isGeneral":false,"path":"http://127.0.0.1:12080","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",80,"}],"describe":null,"resourceType":"20","isGeneral":false,"path":"/developer","component":"Layout","state":true,"icon":"ant-design:bug-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"90","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"了解lamp","parentId":"0","sortValue":90,"children":[{"id":"210","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"在线文档","parentId":"90","sortValue":10,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"211","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"会员版","parentId":"90","sortValue":20,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003629","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"212","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"2","label":"获取源码","parentId":"90","sortValue":30,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/zuihou","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"213","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"问题反馈","parentId":"90","sortValue":40,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://github.com/dromara/lamp-cloud/issues","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"214","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更新日志","parentId":"90","sortValue":50,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/1465302","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"},{"id":"215","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"蓝图","parentId":"90","sortValue":60,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003640","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",90,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/community","component":"Layout","state":true,"icon":"ant-design:github-filled","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","},{"id":"100","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"更多功能","parentId":"0","sortValue":100,"children":[{"id":"220","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"多级菜单","parentId":"100","sortValue":1,"children":[{"id":"221","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1","parentId":"220","sortValue":1,"children":[{"id":"222","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-1","parentId":"221","sortValue":1,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-1","component":"lamp/more/multiMenu/menu1-1/menu1-1-1/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"},{"id":"223","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-1-2","parentId":"221","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1/menu1-1-2","component":"lamp/more/multiMenu/menu1-1/menu1-1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":3,"treePath":",100,220,221,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-1","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"},{"id":"224","createTime":"2022-08-29 00:00:00","createdBy":"1","updateTime":"2022-08-29 00:00:00","updatedBy":"1","label":"菜单1-2","parentId":"220","sortValue":2,"children":null,"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu/menu1-2","component":"lamp/more/multiMenu/menu1-2/index","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":2,"treePath":",100,220,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more/multiMenu","component":"Layout","state":true,"icon":null,"group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":1,"treePath":",100,"}],"describe":null,"resourceType":"20","isGeneral":true,"path":"/more","component":"Layout","state":true,"icon":"ant-design:appstore-add-outlined","group":null,"readonly":true,"dataScope":null,"customClass":null,"isDef":null,"treeGrade":0,"treePath":","}],"msg":"ok","path":null,"extra":null,"timestamp":"1661845408769","errorMsg":"","isSuccess":true}', NULL, TO_DATE('2022-08-30 15:43:28', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519157817409536', '[{"model":{"id":null,"createTime":null,"createdBy":null,"updateTime":null,"updatedBy":null,"code":null,"name":null,"menuId":"0","describe":null,"readonly":null},"size":"20","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564519158148759552', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:43:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564500484490788864', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:29:17', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564501611907121152', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:33:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564501625328893952', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:33:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564502871108485120', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:38:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564502886048595968', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:38:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564504128736985088', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:43:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564505386671669248', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:48:45', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564506645940142080', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:53:46', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564508021478916096', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 14:59:14', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564509343368347648', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:04:29', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564509715067568128', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:05:57', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564510436043259904', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:08:49', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564510566989430784', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:09:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564511826157240320', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:14:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564513084024815616', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:19:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564514341816893440', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 15:24:21', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564469943964008448', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:27:55', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564472438949937152', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:37:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564472440732516352', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:37:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564473697182416896', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564473698881110016', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564474955402313728', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564474957101006848', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564476213630599168', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564476215362846720', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:52:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564477471871467520', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564477473633075200', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 12:57:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564478730162667520', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564478731873943552', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:02:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564479988617445376', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564479990311944192', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:07:50', 'SYYYY-MM-DD HH24:MI:SS'), '3', '0000');
INSERT INTO "C_OPT_LOG_EXT" VALUES ('1564481246698930176', '[{"model":{"userId":null,"isRead":null,"msgType":null,"bizType":null,"content":null,"title":null,"author":null},"size":"5","current":"1","sort":"id","order":"descending","extra":{}}]', NULL, NULL, TO_DATE('2022-08-30 13:12:50', 'SYYYY-MM-DD HH24:MI:SS'), '1564456408345214976', '3333');

-- ----------------------------
-- Table structure for C_ORG
-- ----------------------------
DROP TABLE "C_ORG";
CREATE TABLE "C_ORG" (
  "ID" NUMBER(20,0) NOT NULL,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL,
  "TYPE_" CHAR(2 BYTE),
  "ABBREVIATION" VARCHAR2(255 BYTE),
  "PARENT_ID" NUMBER(20,0) DEFAULT 0,
  "TREE_PATH" VARCHAR2(255 BYTE),
  "SORT_VALUE" NUMBER(10,0) DEFAULT 1,
  "STATE" NUMBER(1,0) DEFAULT 1,
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_ORG"."ID" IS 'ID';
COMMENT ON COLUMN "C_ORG"."LABEL" IS '名称';
COMMENT ON COLUMN "C_ORG"."TYPE_" IS '类型;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.ORG_TYPE)';
COMMENT ON COLUMN "C_ORG"."ABBREVIATION" IS '简称';
COMMENT ON COLUMN "C_ORG"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "C_ORG"."TREE_PATH" IS '树结构';
COMMENT ON COLUMN "C_ORG"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "C_ORG"."STATE" IS '状态';
COMMENT ON COLUMN "C_ORG"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_ORG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_ORG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_ORG"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "C_ORG"."UPDATED_BY" IS '修改人';
COMMENT ON COLUMN "C_ORG"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_ORG" IS '组织';

-- ----------------------------
-- Records of C_ORG
-- ----------------------------

-- ----------------------------
-- Table structure for C_PARAMETER
-- ----------------------------
DROP TABLE "C_PARAMETER";
CREATE TABLE "C_PARAMETER" (
  "ID" NUMBER(20,0) NOT NULL,
  "KEY_" VARCHAR2(255 BYTE) NOT NULL,
  "VALUE" VARCHAR2(255 BYTE) NOT NULL,
  "NAME" VARCHAR2(255 BYTE) NOT NULL,
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 1,
  "READONLY_" NUMBER(1,0) DEFAULT 0,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_PARAMETER"."ID" IS 'ID';
COMMENT ON COLUMN "C_PARAMETER"."KEY_" IS '参数键';
COMMENT ON COLUMN "C_PARAMETER"."VALUE" IS '参数值';
COMMENT ON COLUMN "C_PARAMETER"."NAME" IS '参数名称';
COMMENT ON COLUMN "C_PARAMETER"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_PARAMETER"."STATE" IS '状态';
COMMENT ON COLUMN "C_PARAMETER"."READONLY_" IS '内置';
COMMENT ON COLUMN "C_PARAMETER"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_PARAMETER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_PARAMETER"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_PARAMETER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_PARAMETER"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_PARAMETER" IS '参数配置';

-- ----------------------------
-- Records of C_PARAMETER
-- ----------------------------
INSERT INTO "C_PARAMETER" VALUES ('1', 'LoginPolicy', 'MANY', '登录策略', 'ONLY_ONE:一个用户只能登录一次; MANY:用户可以任意登录; ONLY_ONE_CLIENT:一个用户在一个应用只能登录一次', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_PARAMETER" VALUES ('1564456407929978880', 'LoginPolicy', 'MANY', '登录策略', 'ONLY_ONE:一个用户只能登录一次; MANY:用户可以任意登录; ONLY_ONE_CLIENT:一个用户在一个应用只能登录一次', '1', '1', '3', TO_DATE('2022-08-30 11:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 11:34:08', 'SYYYY-MM-DD HH24:MI:SS'), '3333');

-- ----------------------------
-- Table structure for C_RESOURCE
-- ----------------------------
DROP TABLE "C_RESOURCE";
CREATE TABLE "C_RESOURCE" (
  "ID" NUMBER(20,0) NOT NULL,
  "CODE" VARCHAR2(500 BYTE),
  "NAME" VARCHAR2(255 BYTE) NOT NULL,
  "MENU_ID" NUMBER(20,0),
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "READONLY_" NUMBER(1,0) DEFAULT 1,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_RESOURCE"."ID" IS 'ID';
COMMENT ON COLUMN "C_RESOURCE"."CODE" IS '编码';
COMMENT ON COLUMN "C_RESOURCE"."NAME" IS '名称';
COMMENT ON COLUMN "C_RESOURCE"."MENU_ID" IS '菜单;#c_menu';
COMMENT ON COLUMN "C_RESOURCE"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_RESOURCE"."READONLY_" IS '内置';
COMMENT ON COLUMN "C_RESOURCE"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_RESOURCE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_RESOURCE"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_RESOURCE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_RESOURCE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_RESOURCE" IS '资源';

-- ----------------------------
-- Records of C_RESOURCE
-- ----------------------------
INSERT INTO "C_RESOURCE" VALUES ('1', 'authority:menu:add', '新增', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('2', 'authority:menu:edit', '编辑', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('3', 'authority:menu:delete', '删除', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('4', 'authority:menu:view;authority:resource:view', '查看', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('5', 'authority:menu:import', '导入', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('6', 'authority:menu:export', '导出', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('7', 'authority:resource:add', '新增', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('8', 'authority:resource:edit', '编辑', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('9', 'authority:resource:delete', '删除', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872440', 'tenant:tenant:add', '新增', '110', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872445', 'tenant:tenant:edit', '编辑', '110', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872450', 'tenant:tenant:delete', '删除', '110', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872455', 'tenant:tenant:view', '查看', '110', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872460', 'tenant:tenant:initConnect;tenant:datasourceConfig:view', '初始化', '110', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872467', 'tenant:user:add', '新增', '111', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872472', 'tenant:user:edit', '编辑', '111', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872477', 'tenant:user:delete', '删除', '111', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872484', 'tenant:user:view;tenant:tenant:view', '查看', '111', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872491', 'authority:org:add', '新增', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872496', 'authority:org:edit', '编辑', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872501', 'authority:org:delete', '删除', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872506', 'authority:org:view', '查看', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872513', 'authority:station:add', '新增', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872518', 'authority:station:edit', '编辑', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872523', 'authority:station:delete', '删除', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872528', 'authority:station:view;authority:org:view', '查看', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872537', 'authority:user:add', '新增', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872542', 'authority:user:edit', '编辑', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872547', 'authority:user:delete', '删除', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872552', 'authority:user:view;authority:station:view;authority:org:view', '查看', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872557', 'authority:user:resetPassword', '重置密码', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872562', 'authority:user:updateState', '修改状态', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872569', 'msg:msg:add;authority:user:view;authority:role:view', '新增', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872574', 'msg:msg:edit;authority:user:view;authority:role:view', '编辑', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872579', 'msg:msg:delete', '删除', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872584', 'msg:msg:view', '查看', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872589', 'msg:msg:mark', '标记已读', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872596', 'authority:org:import', '导入', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872601', 'authority:org:export', '导出', '130', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872610', 'authority:station:import', '导入', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872615', 'authority:station:export', '导出', '131', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872622', 'authority:user:import', '导入', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872627', 'authority:user:export', '导出', '132', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872646', 'msg:msg:export', '导出', '140', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872657', 'msg:sms:add', '新增', '142', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872662', 'msg:sms:edit', '编辑', '142', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872667', 'msg:sms:delete', '删除', '142', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872672', 'msg:sms:view;msg:smsTemplate:view', '查看', '142', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872679', 'msg:smsTemplate:add', '新增', '141', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872684', 'msg:smsTemplate:edit', '编辑', '141', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872689', 'msg:smsTemplate:delete', '删除', '141', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872694', 'msg:smsTemplate:view', '查看', '141', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872703', 'file:attachment:add', '新增', '143', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872708', 'file:attachment:edit', '编辑', '143', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872713', 'file:attachment:delete', '删除', '143', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872718', 'file:attachment:view', '查看', '143', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872723', 'file:attachment:download', '下载', '143', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872736', 'authority:role:add;authority:org:view', '新增', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872741', 'authority:role:edit;authority:org:view', '编辑', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872746', 'authority:role:delete', '删除', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872751', 'authority:role:view', '查看', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872756', 'authority:role:config;authority:user:view', '配置权限', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872761', 'authority:role:auth;authority:menu:view;authority:resource:view', '授权', '161', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872768', 'authority:dictionary:add', '新增', '162', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872773', 'authority:dictionary:edit', '编辑', '162', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872778', 'authority:dictionary:delete', '删除', '162', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872783', 'authority:dictionary:view', '查看', '162', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872790', 'authority:area:add', '新增', '163', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872795', 'authority:area:edit', '编辑', '163', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872800', 'authority:area:delete', '删除', '163', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872805', 'authority:area:view', '查看', '163', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872812', 'authority:parameter:add', '新增', '164', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872817', 'authority:parameter:edit', '编辑', '164', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872822', 'authority:parameter:delete', '删除', '164', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872827', 'authority:parameter:view', '查看', '164', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872838', 'authority:optLog:delete', '删除', '165', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872843', 'authority:optLog:view', '查看', '165', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872850', 'authority:loginLog:delete', '删除', '166', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872857', 'authority:loginLog:view', '查看', '166', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872864', 'authority:online:view', '查看', '167', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872869', 'authority:online:delete', '删除', '167', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872876', 'authority:application:add', '新增', '168', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872881', 'authority:application:edit', '编辑', '168', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872886', 'authority:application:delete', '删除', '168', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('25938183673872891', 'authority:application:view', '查看', '168', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('26578833880645891', 'tenant:datasourceConfig:add', '新增', '112', NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('26578833880645896', 'tenant:datasourceConfig:edit', '编辑', '112', NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('26578833880645901', 'tenant:datasourceConfig:delete', '删除', '112', NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('26578833880645906', 'tenant:datasourceConfig:view', '查看', '112', NULL, '1', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_RESOURCE" VALUES ('1400107570902859776', 'authority:resource:view', '查看', '160', NULL, '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for C_ROLE
-- ----------------------------
DROP TABLE "C_ROLE";
CREATE TABLE "C_ROLE" (
  "ID" NUMBER(20,0) NOT NULL,
  "CATEGORY" CHAR(2 BYTE),
  "NAME" VARCHAR2(30 BYTE) NOT NULL,
  "CODE" VARCHAR2(20 BYTE),
  "DESCRIBE_" VARCHAR2(100 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 1,
  "READONLY_" NUMBER(1,0) DEFAULT 0,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_ROLE"."ID" IS 'ID';
COMMENT ON COLUMN "C_ROLE"."CATEGORY" IS '角色类别;[10-功能角色 20-桌面角色 30-数据角色]';
COMMENT ON COLUMN "C_ROLE"."NAME" IS '名称';
COMMENT ON COLUMN "C_ROLE"."CODE" IS '编码';
COMMENT ON COLUMN "C_ROLE"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_ROLE"."STATE" IS '状态';
COMMENT ON COLUMN "C_ROLE"."READONLY_" IS '内置角色';
COMMENT ON COLUMN "C_ROLE"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_ROLE"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_ROLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_ROLE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_ROLE" IS '角色';

-- ----------------------------
-- Records of C_ROLE
-- ----------------------------
INSERT INTO "C_ROLE" VALUES ('1', '10', '超级管理员', 'SUPER_ADMIN', '内置管理员(二次开发必须保留)', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_ROLE" VALUES ('2', '10', '平台管理员', 'PT_ADMIN', '内置运营专用平台管理员(二次开发必须保留)', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_ROLE" VALUES ('3', '10', '普通管理员', 'GENERAL_ADMIN', '演示用的', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_ROLE" VALUES ('4', '10', '普通用户', 'NORMAL', '演示用的', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for C_ROLE_AUTHORITY
-- ----------------------------
DROP TABLE "C_ROLE_AUTHORITY";
CREATE TABLE "C_ROLE_AUTHORITY" (
  "ID" NUMBER(20,0) NOT NULL,
  "AUTHORITY_ID" NUMBER(20,0) NOT NULL,
  "AUTHORITY_TYPE" VARCHAR2(10 BYTE) NOT NULL,
  "ROLE_ID" NUMBER(20,0) NOT NULL,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."ID" IS '主键';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."AUTHORITY_ID" IS '资源id;
#c_resource #c_menu';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."AUTHORITY_TYPE" IS '权限类型;
#AuthorizeType{MENU:菜单;RESOURCE:资源;}';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."ROLE_ID" IS '角色id;
#c_role';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_ROLE_AUTHORITY"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_ROLE_AUTHORITY" IS '角色的资源';

-- ----------------------------
-- Records of C_ROLE_AUTHORITY
-- ----------------------------
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645921', '1', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645922', '25938183673872761', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645923', '25938183673872506', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645924', '2', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645925', '26578833880645906', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645926', '3', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645927', '25938183673872891', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645928', '4', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645929', '5', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645930', '6', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645931', '7', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645932', '25938183673872496', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645933', '8', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645934', '9', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645935', '25938183673872881', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645936', '10', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645937', '25938183673872627', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645938', '25938183673872756', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645939', '25938183673872501', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645940', '25938183673872886', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645941', '26578833880645891', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645942', '25938183673872746', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645943', '25938183673872491', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645944', '25938183673872876', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645945', '25938183673872622', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645946', '25938183673872751', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645947', '25938183673872736', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645948', '25938183673872864', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645949', '26578833880645896', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645950', '25938183673872610', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645951', '26578833880645901', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645952', '25938183673872484', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645953', '25938183673872741', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645954', '25938183673872869', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645955', '25938183673872615', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645956', '25938183673872472', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645957', '25938183673872601', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645958', '25938183673872857', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645959', '25938183673872477', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645960', '25938183673872850', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645961', '25938183673872467', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645962', '25938183673872723', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645963', '25938183673872596', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645964', '25938183673872584', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645965', '25938183673872713', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645966', '25938183673872843', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645967', '25938183673872460', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645968', '25938183673872589', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645969', '25938183673872718', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645970', '25938183673872450', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645971', '25938183673872579', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645972', '25938183673872708', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645973', '25938183673872838', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645974', '25938183673872455', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645975', '25938183673872440', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645976', '25938183673872569', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645977', '25938183673872827', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645978', '25938183673872445', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645979', '25938183673872574', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645980', '25938183673872703', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645981', '25938183673872689', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645982', '25938183673872817', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645983', '25938183673872562', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645984', '25938183673872694', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645985', '25938183673872822', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645986', '25938183673872552', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645987', '25938183673872684', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645988', '25938183673872812', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645989', '25938183673872557', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645990', '25938183673872672', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645991', '25938183673872800', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645992', '25938183673872547', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645993', '25938183673872805', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645994', '25938183673872679', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645995', '25938183673872537', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645996', '25938183673872667', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645997', '25938183673872795', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645998', '25938183673872542', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880645999', '25938183673872528', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646000', '25938183673872657', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646001', '25938183673872662', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646002', '25938183673872790', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646003', '25938183673872778', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646004', '25938183673872523', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646005', '25938183673872783', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646006', '25938183673872768', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646007', '25938183673872513', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646008', '25938183673872773', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646009', '25938183673872518', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646010', '25938183673872646', 'RESOURCE', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646011', '130', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646012', '131', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646013', '132', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646014', '10', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646015', '140', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646016', '141', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646017', '142', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646018', '143', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646019', '20', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646020', '150', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646021', '151', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646022', '152', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646023', '153', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646024', '154', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646025', '155', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646026', '156', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646027', '157', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646028', '30', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646029', '160', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646030', '161', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646031', '162', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646032', '163', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646033', '164', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646034', '165', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646035', '166', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646036', '167', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646037', '40', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646038', '168', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646039', '50', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646040', '180', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646041', '181', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646042', '60', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646043', '190', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646044', '191', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646045', '192', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646046', '193', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646047', '194', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646048', '195', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646049', '196', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646050', '197', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646051', '70', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646052', '80', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646053', '210', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646054', '211', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646055', '212', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646056', '213', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646057', '214', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646058', '215', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646059', '90', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646060', '220', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646061', '221', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646062', '222', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646063', '223', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646064', '224', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646065', '100', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646066', '110', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646067', '111', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646068', '112', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646069', '120', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646070', '121', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646071', '122', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('26578833880646072', '123', 'MENU', '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633784', '25938183673872761', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633785', '1', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633786', '2', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633787', '25938183673872506', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633788', '25938183673872891', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633789', '3', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633790', '4', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633791', '5', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633792', '6', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633793', '7', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633794', '8', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633795', '25938183673872496', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633796', '25938183673872881', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633797', '9', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633799', '25938183673872627', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633800', '25938183673872756', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633801', '25938183673872501', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633802', '25938183673872886', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633803', '25938183673872746', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633804', '25938183673872491', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633805', '25938183673872876', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633806', '25938183673872622', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633807', '25938183673872751', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633808', '25938183673872864', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633809', '25938183673872736', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633810', '25938183673872610', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633811', '25938183673872869', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633812', '25938183673872741', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633813', '25938183673872615', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633814', '25938183673872857', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633815', '25938183673872601', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633816', '25938183673872850', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633817', '25938183673872723', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633818', '25938183673872596', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633819', '25938183673872584', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633820', '25938183673872713', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633821', '25938183673872843', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633822', '25938183673872589', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633823', '25938183673872718', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633824', '25938183673872579', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633825', '25938183673872708', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633826', '25938183673872838', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633827', '25938183673872569', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633828', '25938183673872827', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633829', '25938183673872574', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633830', '25938183673872703', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633831', '25938183673872817', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633832', '25938183673872689', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633833', '25938183673872562', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633834', '25938183673872822', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633835', '25938183673872694', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633836', '25938183673872552', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633837', '25938183673872812', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633838', '25938183673872684', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633839', '25938183673872557', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633840', '25938183673872800', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633841', '25938183673872672', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633842', '25938183673872547', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633843', '25938183673872805', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633844', '25938183673872679', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633845', '25938183673872537', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633846', '25938183673872795', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633847', '25938183673872667', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633848', '25938183673872542', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633849', '25938183673872528', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633850', '25938183673872657', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633851', '25938183673872790', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633852', '25938183673872662', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633853', '25938183673872778', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633854', '25938183673872523', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633855', '25938183673872783', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633856', '25938183673872768', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633857', '25938183673872513', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633858', '25938183673872773', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633859', '25938183673872646', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633860', '25938183673872518', 'RESOURCE', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633861', '130', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633862', '131', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633863', '132', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633864', '140', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633865', '141', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633866', '142', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633867', '143', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633868', '20', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633869', '150', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633870', '151', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633871', '152', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633872', '153', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633873', '154', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633874', '155', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633875', '156', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633876', '157', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633877', '30', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633878', '160', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633879', '161', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633880', '162', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633881', '163', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633882', '164', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633883', '165', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633884', '166', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633885', '167', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633886', '40', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633887', '168', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633888', '50', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633889', '180', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633890', '181', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633891', '60', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633900', '70', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633902', '120', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633903', '121', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633904', '122', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633905', '123', 'MENU', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633954', '25938183673872569', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633955', '25938183673872506', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633956', '25938183673872574', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633957', '25938183673872703', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633958', '25938183673872496', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633959', '25938183673872689', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633960', '25938183673872562', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633961', '25938183673872627', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633962', '25938183673872501', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633963', '25938183673872694', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633964', '25938183673872552', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633965', '25938183673872491', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633966', '25938183673872684', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633967', '25938183673872557', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633968', '25938183673872622', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633969', '25938183673872672', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633970', '25938183673872610', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633971', '25938183673872547', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633972', '25938183673872615', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633973', '25938183673872679', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633974', '25938183673872601', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633975', '25938183673872537', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633976', '25938183673872667', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633977', '25938183673872542', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633978', '25938183673872528', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633979', '25938183673872657', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633980', '25938183673872723', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633981', '25938183673872596', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633982', '25938183673872662', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633983', '25938183673872584', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633984', '25938183673872713', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633985', '25938183673872523', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633986', '25938183673872589', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633987', '25938183673872718', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633988', '25938183673872513', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633989', '25938183673872579', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633990', '25938183673872708', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633991', '25938183673872518', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633992', '25938183673872646', 'RESOURCE', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633993', '130', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633994', '131', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633995', '132', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633996', '140', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633997', '141', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633998', '142', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228633999', '143', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634000', '20', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634001', '150', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634002', '151', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634003', '152', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634004', '153', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634005', '154', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634006', '155', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634007', '156', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634008', '157', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634009', '30', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634010', '40', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634011', '50', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634012', '120', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634013', '121', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634014', '122', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('28369762228634015', '123', 'MENU', '3', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401793578031644672', '25938183673872491', 'RESOURCE', '1401106547731333120', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401793578031644673', '130', 'MENU', '1401106547731333120', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401793578035838976', '30', 'MENU', '1401106547731333120', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401796782312128512', '25938183673872440', 'RESOURCE', '1401105465810616320', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401796782312128513', '25938183673872445', 'RESOURCE', '1401105465810616320', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401796782312128514', '10', 'MENU', '1401105465810616320', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401796782312128515', '110', 'MENU', '1401105465810616320', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022011469824', '224', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022019858432', '100', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022019858433', '220', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022019858434', '221', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022019858435', '222', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401882022024052736', '223', 'MENU', '1401107652259348480', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401884591014281216', '25938183673872460', 'RESOURCE', '1401884493064699904', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1401884591014281217', '110', 'MENU', '1401884493064699904', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1408620582760611840', '20', 'MENU', '1408618647575855104', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1408620582773194752', '120', 'MENU', '1408618647575855104', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1408620582802554880', '121', 'MENU', '1408618647575855104', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1408620582802554881', '122', 'MENU', '1408618647575855104', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826061230080', '25938183673872601', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826090590208', '25938183673872537', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826098978816', '25938183673872506', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826103173120', '25938183673872542', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826107367424', '25938183673872496', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826115756032', '25938183673872528', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826119950336', '25938183673872562', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826124144640', '25938183673872627', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826128338944', '25938183673872596', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826132533248', '25938183673872501', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826136727552', '25938183673872552', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826136727553', '25938183673872491', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826145116160', '25938183673872523', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826153504768', '25938183673872557', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826157699072', '25938183673872622', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826166087680', '25938183673872513', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826174476288', '25938183673872610', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826178670592', '25938183673872547', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826182864896', '25938183673872518', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826187059200', '25938183673872615', 'RESOURCE', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826191253504', '130', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826195447808', '131', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826199642112', '132', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826203836416', '50', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826203836417', '20', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826216419328', '120', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826216419329', '152', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826224807936', '121', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826224807937', '153', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826229002240', '122', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826233196544', '154', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826233196545', '123', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826237390848', '155', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826241585152', '156', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826241585153', '157', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486319826245779456', '30', 'MENU', '4', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486321523068239872', '132', 'MENU', '0', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486321523076628480', '1486201050779090944', 'MENU', '0', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1486321523085017088', '30', 'MENU', '0', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1533464117128462336', '1486201491877265408', 'MENU', '1486215142227050496', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1533464117132656640', '131', 'MENU', '1486215142227050496', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1533464117132656641', '1486620477806870528', 'MENU', '1486215142227050496', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1533464117136850944', '132', 'MENU', '1486215142227050496', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');
INSERT INTO "C_ROLE_AUTHORITY" VALUES ('1533464117136850945', '30', 'MENU', '1486215142227050496', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', '0000');

-- ----------------------------
-- Table structure for C_ROLE_ORG
-- ----------------------------
DROP TABLE "C_ROLE_ORG";
CREATE TABLE "C_ROLE_ORG" (
  "ID" NUMBER(20,0) NOT NULL,
  "ROLE_ID" NUMBER(20,0) NOT NULL,
  "ORG_ID" NUMBER(20,0) NOT NULL,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_ROLE_ORG"."ID" IS 'ID';
COMMENT ON COLUMN "C_ROLE_ORG"."ROLE_ID" IS '角色;#c_role';
COMMENT ON COLUMN "C_ROLE_ORG"."ORG_ID" IS '部门;#c_org';
COMMENT ON COLUMN "C_ROLE_ORG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_ROLE_ORG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_ROLE_ORG"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_ROLE_ORG" IS '角色组织关系';

-- ----------------------------
-- Records of C_ROLE_ORG
-- ----------------------------

-- ----------------------------
-- Table structure for C_STATION
-- ----------------------------
DROP TABLE "C_STATION";
CREATE TABLE "C_STATION" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" VARCHAR2(255 BYTE) NOT NULL,
  "ORG_ID" NUMBER(20,0),
  "STATE" NUMBER(1,0) DEFAULT 1,
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "CREATED_ORG_ID" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_STATION"."ID" IS 'ID';
COMMENT ON COLUMN "C_STATION"."NAME" IS '名称';
COMMENT ON COLUMN "C_STATION"."ORG_ID" IS '组织;#c_org;@Echo(api = ORG_ID_CLASS,  beanClass = Org.class)';
COMMENT ON COLUMN "C_STATION"."STATE" IS '状态';
COMMENT ON COLUMN "C_STATION"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "C_STATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_STATION"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_STATION"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "C_STATION"."UPDATED_BY" IS '修改人';
COMMENT ON COLUMN "C_STATION"."CREATED_ORG_ID" IS '创建者所属机构';
COMMENT ON COLUMN "C_STATION"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_STATION" IS '岗位';

-- ----------------------------
-- Records of C_STATION
-- ----------------------------

-- ----------------------------
-- Table structure for C_TENANT
-- ----------------------------
DROP TABLE "C_TENANT";
CREATE TABLE "C_TENANT" (
  "ID" NUMBER(20,0) NOT NULL,
  "CODE" VARCHAR2(255 BYTE) NOT NULL,
  "NAME" VARCHAR2(255 BYTE),
  "TYPE" VARCHAR2(10 BYTE),
  "CONNECT_TYPE" VARCHAR2(10 BYTE),
  "STATUS" VARCHAR2(10 BYTE),
  "READONLY_" NUMBER(1,0) DEFAULT 0,
  "DUTY" VARCHAR2(50 BYTE),
  "EXPIRATION_TIME" DATE,
  "LOGO" VARCHAR2(255 BYTE),
  "DESCRIBE_" VARCHAR2(255 BYTE),
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_TENANT"."ID" IS '主键ID';
COMMENT ON COLUMN "C_TENANT"."CODE" IS '企业编码';
COMMENT ON COLUMN "C_TENANT"."NAME" IS '企业名称';
COMMENT ON COLUMN "C_TENANT"."TYPE" IS '类型;
#{CREATE:创建;REGISTER:注册}';
COMMENT ON COLUMN "C_TENANT"."CONNECT_TYPE" IS '链接类型;
#TenantConnectTypeEnum{SYSTEM:系统;CUSTOM:自定义}';
COMMENT ON COLUMN "C_TENANT"."STATUS" IS '状态;
#{NORMAL:正常;WAIT_INIT:待初始化;FORBIDDEN:禁用;WAITING:待审核;REFUSE:拒绝;DELETE:已删除}';
COMMENT ON COLUMN "C_TENANT"."READONLY_" IS '内置';
COMMENT ON COLUMN "C_TENANT"."DUTY" IS '责任人';
COMMENT ON COLUMN "C_TENANT"."EXPIRATION_TIME" IS '有效期;
为空表示永久';
COMMENT ON COLUMN "C_TENANT"."LOGO" IS 'logo地址';
COMMENT ON COLUMN "C_TENANT"."DESCRIBE_" IS '企业简介';
COMMENT ON COLUMN "C_TENANT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_TENANT"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "C_TENANT"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "C_TENANT"."UPDATED_BY" IS '修改人';
COMMENT ON TABLE "C_TENANT" IS '企业';

-- ----------------------------
-- Records of C_TENANT
-- ----------------------------
INSERT INTO "C_TENANT" VALUES ('1', '0000', '最后内置的运营&超级租户', 'CREATE', 'SYSTEM', 'NORMAL', '1', '最后', NULL, NULL, '内置租户,用于测试租户系统所有功能, 用于管理整个系统.请勿删除', NULL, '1', NULL, '1');
INSERT INTO "C_TENANT" VALUES ('1564456337822187520', '3333', '3', 'CREATE', 'SYSTEM', 'NORMAL', '0', NULL, NULL, NULL, NULL, TO_DATE('2022-08-30 11:33:51', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 11:33:51', 'SYYYY-MM-DD HH24:MI:SS'), '3');

-- ----------------------------
-- Table structure for C_TENANT_DATASOURCE_CONFIG
-- ----------------------------
DROP TABLE "C_TENANT_DATASOURCE_CONFIG";
CREATE TABLE "C_TENANT_DATASOURCE_CONFIG" (
  "ID" NUMBER(20,0) NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DATASOURCE_CONFIG_ID" NUMBER(20,0) NOT NULL,
  "DB_PREFIX" VARCHAR2(100 BYTE) NOT NULL,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."ID" IS 'ID';
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."TENANT_ID" IS '租户id';
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."DATASOURCE_CONFIG_ID" IS '数据源id';
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."DB_PREFIX" IS '数据库前缀';
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_TENANT_DATASOURCE_CONFIG"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "C_TENANT_DATASOURCE_CONFIG" IS '租户数据源关系';

-- ----------------------------
-- Records of C_TENANT_DATASOURCE_CONFIG
-- ----------------------------

-- ----------------------------
-- Table structure for C_USER
-- ----------------------------
DROP TABLE "C_USER";
CREATE TABLE "C_USER" (
  "ID" NUMBER(20,0) NOT NULL,
  "ACCOUNT" VARCHAR2(30 BYTE) NOT NULL,
  "NAME" VARCHAR2(50 BYTE) NOT NULL,
  "ORG_ID" NUMBER(20,0),
  "STATION_ID" NUMBER(20,0),
  "READONLY" NUMBER(1,0) DEFAULT 0  NOT NULL,
  "EMAIL" VARCHAR2(255 BYTE),
  "MOBILE" VARCHAR2(20 BYTE),
  "SEX" VARCHAR2(1 BYTE) DEFAULT 'M',
  "STATE" NUMBER(1,0) DEFAULT 1,
  "AVATAR" VARCHAR2(255 BYTE),
  "NATION" CHAR(2 BYTE),
  "EDUCATION" CHAR(2 BYTE),
  "POSITION_STATUS" CHAR(2 BYTE),
  "WORK_DESCRIBE" VARCHAR2(255 BYTE),
  "PASSWORD_ERROR_LAST_TIME" DATE,
  "PASSWORD_ERROR_NUM" NUMBER(10,0) DEFAULT 0,
  "PASSWORD_EXPIRE_TIME" DATE,
  "PASSWORD" VARCHAR2(64 BYTE) NOT NULL,
  "SALT" VARCHAR2(20 BYTE) NOT NULL,
  "LAST_LOGIN_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "CREATED_ORG_ID" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_USER"."ID" IS 'ID';
COMMENT ON COLUMN "C_USER"."ACCOUNT" IS '账号';
COMMENT ON COLUMN "C_USER"."NAME" IS '姓名';
COMMENT ON COLUMN "C_USER"."ORG_ID" IS '组织;#c_org;@Echo(api = ORG_ID_CLASS,  beanClass = Org.class)';
COMMENT ON COLUMN "C_USER"."STATION_ID" IS '岗位;#c_station;@Echo(api = STATION_ID_CLASS)';
COMMENT ON COLUMN "C_USER"."READONLY" IS '内置';
COMMENT ON COLUMN "C_USER"."EMAIL" IS '邮箱';
COMMENT ON COLUMN "C_USER"."MOBILE" IS '手机';
COMMENT ON COLUMN "C_USER"."SEX" IS '性别;
#Sex{W:女;M:男;N:未知}';
COMMENT ON COLUMN "C_USER"."STATE" IS '状态';
COMMENT ON COLUMN "C_USER"."AVATAR" IS '头像';
COMMENT ON COLUMN "C_USER"."NATION" IS '民族;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.NATION)';
COMMENT ON COLUMN "C_USER"."EDUCATION" IS '学历;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.EDUCATION)';
COMMENT ON COLUMN "C_USER"."POSITION_STATUS" IS '职位状态;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.POSITION_STATUS)';
COMMENT ON COLUMN "C_USER"."WORK_DESCRIBE" IS '工作描述';
COMMENT ON COLUMN "C_USER"."PASSWORD_ERROR_LAST_TIME" IS '最后一次输错密码时间';
COMMENT ON COLUMN "C_USER"."PASSWORD_ERROR_NUM" IS '密码错误次数';
COMMENT ON COLUMN "C_USER"."PASSWORD_EXPIRE_TIME" IS '密码过期时间';
COMMENT ON COLUMN "C_USER"."PASSWORD" IS '密码';
COMMENT ON COLUMN "C_USER"."SALT" IS '密码盐';
COMMENT ON COLUMN "C_USER"."LAST_LOGIN_TIME" IS '最后登录时间';
COMMENT ON COLUMN "C_USER"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "C_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_USER"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "C_USER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "C_USER"."CREATED_ORG_ID" IS '创建者所属机构';
COMMENT ON COLUMN "C_USER"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_USER" IS '用户';

-- ----------------------------
-- Records of C_USER
-- ----------------------------
INSERT INTO "C_USER" VALUES ('1', 'lampAdmin', '内置管理员', '1', '1', '1', '15217781234@qq.com', '15217781234', NULL, '1', '17e420c250804efe904a09a33796d5a10.jpg', '01', '01', '01', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', TO_DATE('2022-08-30 11:34:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_USER" VALUES ('2', 'lamp', '超级管理员', '1533406176778125312', '1', '0', '5', '3', NULL, '1', '20180414165815.jpg', '02', '04', '03', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_USER" VALUES ('3', 'lamp_pt', '平台管理员', '1', '1', '0', '2', '3', NULL, '1', 'a3b10296862e40edb811418d64455d00.jpeg', '05', '06', '02', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', TO_DATE('2022-08-30 11:01:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_USER" VALUES ('4', 'general', '普通管理员', '1415864608656195584', '1', '0', NULL, NULL, 'N', '1', NULL, '01', '01', '01', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');
INSERT INTO "C_USER" VALUES ('5', 'normal', '普通用户', '1533438004188676096', '1', '0', NULL, NULL, 'M', '1', NULL, '02', '02', '02', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0000');

-- ----------------------------
-- Table structure for C_USER_ROLE
-- ----------------------------
DROP TABLE "C_USER_ROLE";
CREATE TABLE "C_USER_ROLE" (
  "ID" NUMBER(20,0) NOT NULL,
  "ROLE_ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "C_USER_ROLE"."ID" IS 'ID';
COMMENT ON COLUMN "C_USER_ROLE"."ROLE_ID" IS '角色;#c_role';
COMMENT ON COLUMN "C_USER_ROLE"."USER_ID" IS '用户;#c_user';
COMMENT ON COLUMN "C_USER_ROLE"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "C_USER_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "C_USER_ROLE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "C_USER_ROLE" IS '角色分配;账号角色绑定';

-- ----------------------------
-- Records of C_USER_ROLE
-- ----------------------------
INSERT INTO "C_USER_ROLE" VALUES ('1', '1', '1', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_USER_ROLE" VALUES ('2', '1', '2', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_USER_ROLE" VALUES ('3', '2', '3', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_USER_ROLE" VALUES ('4', '3', '4', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');
INSERT INTO "C_USER_ROLE" VALUES ('5', '4', '5', '1', TO_DATE('2022-08-29 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '0000');

-- ----------------------------
-- Table structure for E_BLOCK_LIST
-- ----------------------------
DROP TABLE "E_BLOCK_LIST";
CREATE TABLE "E_BLOCK_LIST" (
  "ID" NUMBER(20,0) NOT NULL,
  "IP" VARCHAR2(20 BYTE),
  "REQUEST_URI" VARCHAR2(255 BYTE),
  "REQUEST_METHOD" VARCHAR2(10 BYTE),
  "LIMIT_START" VARCHAR2(8 BYTE),
  "LIMIT_END" VARCHAR2(8 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 0,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_BLOCK_LIST"."ID" IS 'ID';
COMMENT ON COLUMN "E_BLOCK_LIST"."IP" IS '阻止访问ip';
COMMENT ON COLUMN "E_BLOCK_LIST"."REQUEST_URI" IS '请求URI';
COMMENT ON COLUMN "E_BLOCK_LIST"."REQUEST_METHOD" IS '请求方法;
如果为ALL则表示对所有方法生效';
COMMENT ON COLUMN "E_BLOCK_LIST"."LIMIT_START" IS '限制时间起';
COMMENT ON COLUMN "E_BLOCK_LIST"."LIMIT_END" IS '限制时间止';
COMMENT ON COLUMN "E_BLOCK_LIST"."STATE" IS '状态';
COMMENT ON COLUMN "E_BLOCK_LIST"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_BLOCK_LIST"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "E_BLOCK_LIST"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "E_BLOCK_LIST"."UPDATED_BY" IS '修改人';
COMMENT ON COLUMN "E_BLOCK_LIST"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_BLOCK_LIST" IS '黑名单';

-- ----------------------------
-- Records of E_BLOCK_LIST
-- ----------------------------

-- ----------------------------
-- Table structure for E_MSG
-- ----------------------------
DROP TABLE "E_MSG";
CREATE TABLE "E_MSG" (
  "ID" NUMBER(20,0) NOT NULL,
  "BIZ_ID" VARCHAR2(64 BYTE),
  "BIZ_TYPE" VARCHAR2(64 BYTE),
  "MSG_TYPE" VARCHAR2(20 BYTE) NOT NULL,
  "TITLE" VARCHAR2(255 BYTE),
  "CONTENT" CLOB,
  "AUTHOR" VARCHAR2(50 BYTE),
  "HANDLER_URL" VARCHAR2(255 BYTE),
  "HANDLER_PARAMS" VARCHAR2(500 BYTE),
  "IS_SINGLE_HANDLE" NUMBER(1,0) DEFAULT 1,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_MSG"."ID" IS 'ID';
COMMENT ON COLUMN "E_MSG"."BIZ_ID" IS '业务ID';
COMMENT ON COLUMN "E_MSG"."BIZ_TYPE" IS '业务类型;
#MsgBizType{USER_LOCK:账号锁定;USER_REG:账号申请;WORK_APPROVAL:考勤审批;}';
COMMENT ON COLUMN "E_MSG"."MSG_TYPE" IS '消息类型;
#MsgType{WAIT:待办;NOTIFY:通知;PUBLICITY:公告;WARN:预警;}';
COMMENT ON COLUMN "E_MSG"."TITLE" IS '标题';
COMMENT ON COLUMN "E_MSG"."CONTENT" IS '内容';
COMMENT ON COLUMN "E_MSG"."AUTHOR" IS '发布人';
COMMENT ON COLUMN "E_MSG"."HANDLER_URL" IS '处理地址;
以http开头时直接跳转，否则与#c_application表拼接后跳转http可带参数';
COMMENT ON COLUMN "E_MSG"."HANDLER_PARAMS" IS '处理参数';
COMMENT ON COLUMN "E_MSG"."IS_SINGLE_HANDLE" IS '是否单人处理';
COMMENT ON COLUMN "E_MSG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_MSG"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "E_MSG"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "E_MSG"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "E_MSG"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_MSG" IS '消息表';

-- ----------------------------
-- Records of E_MSG
-- ----------------------------

-- ----------------------------
-- Table structure for E_MSG_RECEIVE
-- ----------------------------
DROP TABLE "E_MSG_RECEIVE";
CREATE TABLE "E_MSG_RECEIVE" (
  "ID" NUMBER(20,0) NOT NULL,
  "MSG_ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "IS_READ" NUMBER(1,0) DEFAULT 0,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_MSG_RECEIVE"."ID" IS 'ID';
COMMENT ON COLUMN "E_MSG_RECEIVE"."MSG_ID" IS '消息ID;
#msg';
COMMENT ON COLUMN "E_MSG_RECEIVE"."USER_ID" IS '接收人ID;
#c_user';
COMMENT ON COLUMN "E_MSG_RECEIVE"."IS_READ" IS '是否已读';
COMMENT ON COLUMN "E_MSG_RECEIVE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_MSG_RECEIVE"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "E_MSG_RECEIVE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "E_MSG_RECEIVE"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "E_MSG_RECEIVE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_MSG_RECEIVE" IS '消息接收表';

-- ----------------------------
-- Records of E_MSG_RECEIVE
-- ----------------------------

-- ----------------------------
-- Table structure for E_RATE_LIMITER
-- ----------------------------
DROP TABLE "E_RATE_LIMITER";
CREATE TABLE "E_RATE_LIMITER" (
  "ID" NUMBER(20,0) NOT NULL,
  "COUNT" NUMBER(10,0) DEFAULT 0,
  "REQUEST_URI" VARCHAR2(255 BYTE),
  "REQUEST_METHOD" VARCHAR2(10 BYTE),
  "LIMIT_START" VARCHAR2(8 BYTE),
  "LIMIT_END" VARCHAR2(8 BYTE),
  "STATE" NUMBER(1,0) DEFAULT 0,
  "INTERVAL_SEC" NUMBER(20,0) DEFAULT 0,
  "CREATE_TIME" DATE,
  "CREATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_RATE_LIMITER"."ID" IS 'ID';
COMMENT ON COLUMN "E_RATE_LIMITER"."COUNT" IS '次数';
COMMENT ON COLUMN "E_RATE_LIMITER"."REQUEST_URI" IS '请求URI';
COMMENT ON COLUMN "E_RATE_LIMITER"."REQUEST_METHOD" IS '请求方法;
如果为ALL则表示对所有方法生效';
COMMENT ON COLUMN "E_RATE_LIMITER"."LIMIT_START" IS '限制时间起';
COMMENT ON COLUMN "E_RATE_LIMITER"."LIMIT_END" IS '限制时间止';
COMMENT ON COLUMN "E_RATE_LIMITER"."STATE" IS '状态';
COMMENT ON COLUMN "E_RATE_LIMITER"."INTERVAL_SEC" IS '时间窗口';
COMMENT ON COLUMN "E_RATE_LIMITER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_RATE_LIMITER"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "E_RATE_LIMITER"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "E_RATE_LIMITER"."UPDATED_BY" IS '修改人';
COMMENT ON COLUMN "E_RATE_LIMITER"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_RATE_LIMITER" IS '限流';

-- ----------------------------
-- Records of E_RATE_LIMITER
-- ----------------------------

-- ----------------------------
-- Table structure for E_SMS_SEND_STATUS
-- ----------------------------
DROP TABLE "E_SMS_SEND_STATUS";
CREATE TABLE "E_SMS_SEND_STATUS" (
  "ID" NUMBER(20,0) NOT NULL,
  "TASK_ID" NUMBER(20,0) NOT NULL,
  "SEND_STATUS" VARCHAR2(10 BYTE) NOT NULL,
  "TEL_NUM" VARCHAR2(20 BYTE) NOT NULL,
  "BIZ_ID" VARCHAR2(255 BYTE),
  "EXT" VARCHAR2(255 BYTE),
  "CODE" VARCHAR2(255 BYTE),
  "MESSAGE" VARCHAR2(500 BYTE),
  "FEE" NUMBER(10,0),
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."ID" IS 'ID';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."TASK_ID" IS '任务ID;
#e_sms_task';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."SEND_STATUS" IS '发送状态;
#SendStatus{WAITING:等待发送;SUCCESS:发送成功;FAIL:发送失败}';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."TEL_NUM" IS '接收者手机
单个手机号;
阿里：发送回执ID,可根据该ID查询具体的发送状态  腾讯：sid 标识本次发送id，标识一次短信下发记录  百度：requestId 短信发送请求唯一流水ID';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."BIZ_ID" IS '发送回执ID';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."EXT" IS '发送返回;
阿里：RequestId 请求ID  腾讯：ext：用户的session内容，腾讯server回包中会原样返回   百度：无';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."CODE" IS '状态码;阿里：返回OK代表请求成功,其他错误码详见错误码列表  腾讯：0表示成功(计费依据)，非0表示失败  百度：1000 表示成功';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."MESSAGE" IS '状态码的描述';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."FEE" IS '短信计费的条数;腾讯专用';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "E_SMS_SEND_STATUS"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_SMS_SEND_STATUS" IS '短信发送状态';

-- ----------------------------
-- Records of E_SMS_SEND_STATUS
-- ----------------------------

-- ----------------------------
-- Table structure for E_SMS_TASK
-- ----------------------------
DROP TABLE "E_SMS_TASK";
CREATE TABLE "E_SMS_TASK" (
  "ID" NUMBER(20,0) NOT NULL,
  "TEMPLATE_ID" NUMBER(20,0) NOT NULL,
  "STATUS" VARCHAR2(10 BYTE),
  "SOURCE_TYPE" VARCHAR2(10 BYTE),
  "TOPIC" VARCHAR2(255 BYTE),
  "TEMPLATE_PARAMS" VARCHAR2(500 BYTE),
  "SEND_TIME" DATE,
  "CONTENT" VARCHAR2(500 BYTE),
  "DRAFT" NUMBER(1,0) DEFAULT 0,
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_SMS_TASK"."ID" IS '短信记录ID';
COMMENT ON COLUMN "E_SMS_TASK"."TEMPLATE_ID" IS '短信模板;@Echo(api = SMS_TEMPLATE_ID_CLASS)#e_sms_template';
COMMENT ON COLUMN "E_SMS_TASK"."STATUS" IS '执行状态;
(手机号具体发送状态看sms_send_status表)
#TaskStatus{WAITING:等待执行;SUCCESS:执行成功;FAIL:执行失败}';
COMMENT ON COLUMN "E_SMS_TASK"."SOURCE_TYPE" IS '发送渠道;#SourceType{APP:应用;SERVICE:服务}';
COMMENT ON COLUMN "E_SMS_TASK"."TOPIC" IS '主题';
COMMENT ON COLUMN "E_SMS_TASK"."TEMPLATE_PARAMS" IS '参数;
需要封装为{‘key’:’value’, ...}格式且key必须有序';
COMMENT ON COLUMN "E_SMS_TASK"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "E_SMS_TASK"."CONTENT" IS '发送内容;
需要封装正确格式化: 您好，张三，您有一个新的快递。';
COMMENT ON COLUMN "E_SMS_TASK"."DRAFT" IS '是否草稿';
COMMENT ON COLUMN "E_SMS_TASK"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "E_SMS_TASK"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_SMS_TASK"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "E_SMS_TASK"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "E_SMS_TASK"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_SMS_TASK" IS '发送任务';

-- ----------------------------
-- Records of E_SMS_TASK
-- ----------------------------

-- ----------------------------
-- Table structure for E_SMS_TEMPLATE
-- ----------------------------
DROP TABLE "E_SMS_TEMPLATE";
CREATE TABLE "E_SMS_TEMPLATE" (
  "ID" NUMBER(20,0) NOT NULL,
  "PROVIDER_TYPE" VARCHAR2(10 BYTE) NOT NULL,
  "APP_ID" VARCHAR2(255 BYTE) NOT NULL,
  "APP_SECRET" VARCHAR2(255 BYTE) NOT NULL,
  "URL" VARCHAR2(255 BYTE),
  "NAME" VARCHAR2(255 BYTE),
  "CONTENT" VARCHAR2(255 BYTE) NOT NULL,
  "TEMPLATE_PARAMS" VARCHAR2(255 BYTE) NOT NULL,
  "TEMPLATE_CODE" VARCHAR2(50 BYTE) NOT NULL,
  "SIGN_NAME" VARCHAR2(100 BYTE),
  "TEMPLATE_DESCRIBE" VARCHAR2(255 BYTE),
  "CREATED_BY" NUMBER(20,0),
  "CREATE_TIME" DATE,
  "UPDATED_BY" NUMBER(20,0),
  "UPDATE_TIME" DATE,
  "TENANT_CODE" VARCHAR2(20 BYTE)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "E_SMS_TEMPLATE"."ID" IS '模板ID';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."PROVIDER_TYPE" IS '供应商类型;
#ProviderType{ALI:OK,阿里云短信;TENCENT:0,腾讯云短信;BAIDU:1000,百度云短信}';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."APP_ID" IS '应用ID';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."APP_SECRET" IS '应用密码';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."URL" IS 'SMS服务域名;
百度、其他厂商会用';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."NAME" IS '模板名称';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."CONTENT" IS '模板内容';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."TEMPLATE_PARAMS" IS '模板参数';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."TEMPLATE_CODE" IS '模板编码';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."SIGN_NAME" IS '签名';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."TEMPLATE_DESCRIBE" IS '备注';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."UPDATED_BY" IS '最后修改人';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "E_SMS_TEMPLATE"."TENANT_CODE" IS '租户编码';
COMMENT ON TABLE "E_SMS_TEMPLATE" IS '短信模板';

-- ----------------------------
-- Records of E_SMS_TEMPLATE
-- ----------------------------

-- ----------------------------
-- Table structure for UNDO_LOG
-- ----------------------------
DROP TABLE "UNDO_LOG";
CREATE TABLE "UNDO_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "BRANCH_ID" NUMBER(20,0) NOT NULL,
  "XID" VARCHAR2(100 BYTE) NOT NULL,
  "CONTEXT" VARCHAR2(128 BYTE) NOT NULL,
  "ROLLBACK_INFO" CLOB NOT NULL,
  "LOG_STATUS" NUMBER(10,0) NOT NULL,
  "LOG_CREATED" DATE,
  "LOG_MODIFIED" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "UNDO_LOG"."ID" IS 'increment;id';
COMMENT ON COLUMN "UNDO_LOG"."BRANCH_ID" IS 'branch;transaction id';
COMMENT ON COLUMN "UNDO_LOG"."XID" IS 'global;transaction id';
COMMENT ON COLUMN "UNDO_LOG"."CONTEXT" IS 'undo_log;context,such as serialization';
COMMENT ON COLUMN "UNDO_LOG"."ROLLBACK_INFO" IS 'rollback;info';
COMMENT ON COLUMN "UNDO_LOG"."LOG_STATUS" IS '0:normal;status,1:defense status';
COMMENT ON COLUMN "UNDO_LOG"."LOG_CREATED" IS 'create;datetime';
COMMENT ON COLUMN "UNDO_LOG"."LOG_MODIFIED" IS 'modify;datetime';
COMMENT ON TABLE "UNDO_LOG" IS 'AT;transaction mode undo table';

-- ----------------------------
-- Records of UNDO_LOG
-- ----------------------------

-- ----------------------------
-- Table structure for WORKER_NODE
-- ----------------------------
DROP TABLE "WORKER_NODE";
CREATE TABLE "WORKER_NODE" (
  "ID" NUMBER(20,0) NOT NULL,
  "HOST_NAME" VARCHAR2(64 BYTE) NOT NULL,
  "PORT" VARCHAR2(64 BYTE) NOT NULL,
  "TYPE" NUMBER(10,0) NOT NULL,
  "LAUNCH_DATE" DATE NOT NULL,
  "MODIFIED" DATE,
  "CREATED" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "WORKER_NODE"."ID" IS 'auto;increment id';
COMMENT ON COLUMN "WORKER_NODE"."HOST_NAME" IS '主机名';
COMMENT ON COLUMN "WORKER_NODE"."PORT" IS '端口';
COMMENT ON COLUMN "WORKER_NODE"."TYPE" IS '节点类型:;ACTUAL 或者 CONTAINER';
COMMENT ON COLUMN "WORKER_NODE"."LAUNCH_DATE" IS '上线日期';
COMMENT ON COLUMN "WORKER_NODE"."MODIFIED" IS '修改时间';
COMMENT ON COLUMN "WORKER_NODE"."CREATED" IS '创建时间';
COMMENT ON TABLE "WORKER_NODE" IS 'DB;WorkerID Assigner for UID Generator';

-- ----------------------------
-- Records of WORKER_NODE
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table C_APPENDIX
-- ----------------------------
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014153" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_APPENDIX
-- ----------------------------
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014148" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014149" CHECK ("BIZ_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014150" CHECK ("BIZ_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014151" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_APPENDIX" ADD CONSTRAINT "SYS_C0014152" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_APPLICATION
-- ----------------------------
ALTER TABLE "C_APPLICATION" ADD CONSTRAINT "SYS_C0014177" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_APPLICATION
-- ----------------------------
ALTER TABLE "C_APPLICATION" ADD CONSTRAINT "SYS_C0014175" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_APPLICATION" ADD CONSTRAINT "SYS_C0014176" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_APPLICATION
-- ----------------------------
CREATE UNIQUE INDEX "UK_CLIENT_ID"
  ON "C_APPLICATION" ("CLIENT_ID" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_AREA
-- ----------------------------
ALTER TABLE "C_AREA" ADD CONSTRAINT "SYS_C0014181" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_AREA
-- ----------------------------
ALTER TABLE "C_AREA" ADD CONSTRAINT "SYS_C0014178" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_AREA" ADD CONSTRAINT "SYS_C0014179" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_AREA" ADD CONSTRAINT "SYS_C0014180" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_AREA
-- ----------------------------
CREATE UNIQUE INDEX "UK_AREA_CODE"
  ON "C_AREA" ("CODE" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_DATASOURCE_CONFIG
-- ----------------------------
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014160" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_DATASOURCE_CONFIG
-- ----------------------------
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014154" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014155" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014156" CHECK ("USERNAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014157" CHECK ("PASSWORD" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014158" CHECK ("URL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014159" CHECK ("DRIVER_CLASS_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_DICTIONARY
-- ----------------------------
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014187" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_DICTIONARY
-- ----------------------------
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014182" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014183" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014184" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014185" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_DICTIONARY" ADD CONSTRAINT "SYS_C0014186" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_DICTIONARY
-- ----------------------------
CREATE UNIQUE INDEX "UK_TYPE_CODE"
  ON "C_DICTIONARY" ("TENANT_CODE" ASC, "CODE" ASC, "TYPE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_FILE
-- ----------------------------
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014194" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_FILE
-- ----------------------------
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014188" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014189" CHECK ("BIZ_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014190" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014191" CHECK ("CREATED_BY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014192" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_FILE" ADD CONSTRAINT "SYS_C0014193" CHECK ("UPDATED_BY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_LOGIN_LOG
-- ----------------------------
ALTER TABLE "C_LOGIN_LOG" ADD CONSTRAINT "SYS_C0014196" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_LOGIN_LOG
-- ----------------------------
ALTER TABLE "C_LOGIN_LOG" ADD CONSTRAINT "SYS_C0014195" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_MENU
-- ----------------------------
ALTER TABLE "C_MENU" ADD CONSTRAINT "SYS_C0014199" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_MENU
-- ----------------------------
ALTER TABLE "C_MENU" ADD CONSTRAINT "SYS_C0014197" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_MENU" ADD CONSTRAINT "SYS_C0014198" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_OPT_LOG
-- ----------------------------
ALTER TABLE "C_OPT_LOG" ADD CONSTRAINT "SYS_C0014201" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_OPT_LOG
-- ----------------------------
ALTER TABLE "C_OPT_LOG" ADD CONSTRAINT "SYS_C0014200" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_OPT_LOG_EXT
-- ----------------------------
ALTER TABLE "C_OPT_LOG_EXT" ADD CONSTRAINT "SYS_C0014203" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_OPT_LOG_EXT
-- ----------------------------
ALTER TABLE "C_OPT_LOG_EXT" ADD CONSTRAINT "SYS_C0014202" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_ORG
-- ----------------------------
ALTER TABLE "C_ORG" ADD CONSTRAINT "SYS_C0014206" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ORG
-- ----------------------------
ALTER TABLE "C_ORG" ADD CONSTRAINT "SYS_C0014204" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ORG" ADD CONSTRAINT "SYS_C0014205" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ORG
-- ----------------------------
CREATE INDEX "FU_ORG_PATH"
  ON "C_ORG" ("TREE_PATH" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);
CREATE UNIQUE INDEX "UK_ORG_NAME"
  ON "C_ORG" ("LABEL" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_PARAMETER
-- ----------------------------
ALTER TABLE "C_PARAMETER" ADD CONSTRAINT "SYS_C0014211" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_PARAMETER
-- ----------------------------
ALTER TABLE "C_PARAMETER" ADD CONSTRAINT "SYS_C0014207" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_PARAMETER" ADD CONSTRAINT "SYS_C0014208" CHECK ("KEY_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_PARAMETER" ADD CONSTRAINT "SYS_C0014209" CHECK ("VALUE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_PARAMETER" ADD CONSTRAINT "SYS_C0014210" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_PARAMETER
-- ----------------------------
CREATE UNIQUE INDEX "UK_PARAM_KEY"
  ON "C_PARAMETER" ("KEY_" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_RESOURCE
-- ----------------------------
ALTER TABLE "C_RESOURCE" ADD CONSTRAINT "SYS_C0014214" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_RESOURCE
-- ----------------------------
ALTER TABLE "C_RESOURCE" ADD CONSTRAINT "SYS_C0014212" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_RESOURCE" ADD CONSTRAINT "SYS_C0014213" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_RESOURCE
-- ----------------------------
CREATE UNIQUE INDEX "UK_RES_CODE"
  ON "C_RESOURCE" ("CODE" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE
-- ----------------------------
ALTER TABLE "C_ROLE" ADD CONSTRAINT "SYS_C0014217" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE
-- ----------------------------
ALTER TABLE "C_ROLE" ADD CONSTRAINT "SYS_C0014215" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE" ADD CONSTRAINT "SYS_C0014216" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE
-- ----------------------------
CREATE UNIQUE INDEX "UK_ROLE_CODE"
  ON "C_ROLE" ("CODE" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE_AUTHORITY
-- ----------------------------
ALTER TABLE "C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014222" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE_AUTHORITY
-- ----------------------------
ALTER TABLE "C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014218" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014219" CHECK ("AUTHORITY_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014220" CHECK ("AUTHORITY_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014221" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE_AUTHORITY
-- ----------------------------
CREATE UNIQUE INDEX "UK_ROLE_AUTHORITY"
  ON "C_ROLE_AUTHORITY" ("TENANT_CODE" ASC, "ROLE_ID" ASC, "AUTHORITY_TYPE" ASC, "AUTHORITY_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE_ORG
-- ----------------------------
ALTER TABLE "C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014226" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE_ORG
-- ----------------------------
ALTER TABLE "C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014223" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014224" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014225" CHECK ("ORG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE_ORG
-- ----------------------------
CREATE UNIQUE INDEX "UK_ROLE_ORG"
  ON "C_ROLE_ORG" ("TENANT_CODE" ASC, "ROLE_ID" ASC, "ORG_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_STATION
-- ----------------------------
ALTER TABLE "C_STATION" ADD CONSTRAINT "SYS_C0014229" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_STATION
-- ----------------------------
ALTER TABLE "C_STATION" ADD CONSTRAINT "SYS_C0014227" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_STATION" ADD CONSTRAINT "SYS_C0014228" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_STATION
-- ----------------------------
CREATE UNIQUE INDEX "UK_STATION_NAME"
  ON "C_STATION" ("NAME" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_TENANT
-- ----------------------------
ALTER TABLE "C_TENANT" ADD CONSTRAINT "SYS_C0014163" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_TENANT
-- ----------------------------
ALTER TABLE "C_TENANT" ADD CONSTRAINT "SYS_C0014161" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_TENANT" ADD CONSTRAINT "SYS_C0014162" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_TENANT
-- ----------------------------
CREATE UNIQUE INDEX "UK_CODE"
  ON "C_TENANT" ("CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_TENANT_DATASOURCE_CONFIG
-- ----------------------------
ALTER TABLE "C_TENANT_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014168" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_TENANT_DATASOURCE_CONFIG
-- ----------------------------
ALTER TABLE "C_TENANT_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014164" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_TENANT_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014165" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_TENANT_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014166" CHECK ("DATASOURCE_CONFIG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_TENANT_DATASOURCE_CONFIG" ADD CONSTRAINT "SYS_C0014167" CHECK ("DB_PREFIX" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_TENANT_DATASOURCE_CONFIG
-- ----------------------------
CREATE UNIQUE INDEX "UK_TENAN_APPLICATION"
  ON "C_TENANT_DATASOURCE_CONFIG" ("TENANT_ID" ASC, "DB_PREFIX" ASC, "DATASOURCE_CONFIG_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_USER
-- ----------------------------
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014236" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_USER
-- ----------------------------
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014230" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014231" CHECK ("ACCOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014232" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014233" CHECK ("READONLY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014234" CHECK ("PASSWORD" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER" ADD CONSTRAINT "SYS_C0014235" CHECK ("SALT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_USER
-- ----------------------------
CREATE UNIQUE INDEX "UK_USER_ACCOUNT"
  ON "C_USER" ("ACCOUNT" ASC, "TENANT_CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_USER_ROLE
-- ----------------------------
ALTER TABLE "C_USER_ROLE" ADD CONSTRAINT "SYS_C0014240" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_USER_ROLE
-- ----------------------------
ALTER TABLE "C_USER_ROLE" ADD CONSTRAINT "SYS_C0014237" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER_ROLE" ADD CONSTRAINT "SYS_C0014238" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "C_USER_ROLE" ADD CONSTRAINT "SYS_C0014239" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_USER_ROLE
-- ----------------------------
CREATE UNIQUE INDEX "UK_USER_ROLE"
  ON "C_USER_ROLE" ("TENANT_CODE" ASC, "USER_ID" ASC, "ROLE_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table E_BLOCK_LIST
-- ----------------------------
ALTER TABLE "E_BLOCK_LIST" ADD CONSTRAINT "SYS_C0014242" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_BLOCK_LIST
-- ----------------------------
ALTER TABLE "E_BLOCK_LIST" ADD CONSTRAINT "SYS_C0014241" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_MSG
-- ----------------------------
ALTER TABLE "E_MSG" ADD CONSTRAINT "SYS_C0014245" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_MSG
-- ----------------------------
ALTER TABLE "E_MSG" ADD CONSTRAINT "SYS_C0014243" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_MSG" ADD CONSTRAINT "SYS_C0014244" CHECK ("MSG_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_MSG_RECEIVE
-- ----------------------------
ALTER TABLE "E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014249" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_MSG_RECEIVE
-- ----------------------------
ALTER TABLE "E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014246" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014247" CHECK ("MSG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_MSG_RECEIVE" ADD CONSTRAINT "SYS_C0014248" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_RATE_LIMITER
-- ----------------------------
ALTER TABLE "E_RATE_LIMITER" ADD CONSTRAINT "SYS_C0014251" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_RATE_LIMITER
-- ----------------------------
ALTER TABLE "E_RATE_LIMITER" ADD CONSTRAINT "SYS_C0014250" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table E_SMS_SEND_STATUS
-- ----------------------------
ALTER TABLE "E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014256" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_SEND_STATUS
-- ----------------------------
ALTER TABLE "E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014252" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014253" CHECK ("TASK_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014254" CHECK ("SEND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_SEND_STATUS" ADD CONSTRAINT "SYS_C0014255" CHECK ("TEL_NUM" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table E_SMS_SEND_STATUS
-- ----------------------------
CREATE INDEX "TASK_ID_TEL_NUM"
  ON "E_SMS_SEND_STATUS" ("TEL_NUM" ASC, "TASK_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table E_SMS_TASK
-- ----------------------------
ALTER TABLE "E_SMS_TASK" ADD CONSTRAINT "SYS_C0014259" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_TASK
-- ----------------------------
ALTER TABLE "E_SMS_TASK" ADD CONSTRAINT "SYS_C0014257" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TASK" ADD CONSTRAINT "SYS_C0014258" CHECK ("TEMPLATE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table E_SMS_TASK
-- ----------------------------
CREATE INDEX "TEMPATE_ID_TOPIC_CONTENT"
  ON "E_SMS_TASK" ("TEMPLATE_ID" ASC, "CONTENT" ASC, "TOPIC" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table E_SMS_TEMPLATE
-- ----------------------------
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014267" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table E_SMS_TEMPLATE
-- ----------------------------
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014260" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014261" CHECK ("PROVIDER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014262" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014263" CHECK ("APP_SECRET" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014264" CHECK ("CONTENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014265" CHECK ("TEMPLATE_PARAMS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "E_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C0014266" CHECK ("TEMPLATE_CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table UNDO_LOG
-- ----------------------------
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014274" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table UNDO_LOG
-- ----------------------------
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014268" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014269" CHECK ("BRANCH_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014270" CHECK ("XID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014271" CHECK ("CONTEXT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014272" CHECK ("ROLLBACK_INFO" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "UNDO_LOG" ADD CONSTRAINT "SYS_C0014273" CHECK ("LOG_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table UNDO_LOG
-- ----------------------------
CREATE UNIQUE INDEX "UX_UNDO_LOG"
  ON "UNDO_LOG" ("BRANCH_ID" ASC, "XID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table WORKER_NODE
-- ----------------------------
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014174" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table WORKER_NODE
-- ----------------------------
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014169" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014170" CHECK ("HOST_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014171" CHECK ("PORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014172" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "WORKER_NODE" ADD CONSTRAINT "SYS_C0014173" CHECK ("LAUNCH_DATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
