/*
 Navicat Premium Data Transfer

 Source Server         : 172.26.3.67_lamp
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 172.26.3.67:1521
 Source Schema         : LAMP_BASE_0000

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 02/09/2022 10:18:26
*/


-- ----------------------------
-- Table structure for C_APPENDIX
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_APPENDIX";
CREATE TABLE "LAMP_BASE_0000"."C_APPENDIX" (
  "ID" NUMBER(20) NOT NULL ,
  "BIZ_ID" NUMBER(20) DEFAULT 0  NOT NULL ,
  "BIZ_TYPE" VARCHAR2(255 BYTE) NOT NULL ,
  "FILE_TYPE" VARCHAR2(255 BYTE) ,
  "BUCKET" VARCHAR2(255 BYTE) ,
  "PATH" VARCHAR2(255 BYTE) ,
  "ORIGINAL_FILE_NAME" VARCHAR2(255 BYTE) ,
  "CONTENT_TYPE" VARCHAR2(255 BYTE) ,
  "SIZE_" NUMBER(20) DEFAULT 0 ,
  "CREATE_TIME" DATE NOT NULL ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE NOT NULL ,
  "UPDATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."BIZ_ID" IS '业务id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."BIZ_TYPE" IS '业务类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."FILE_TYPE" IS '文件类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."BUCKET" IS '桶';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."PATH" IS '文件相对地址';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."ORIGINAL_FILE_NAME" IS '原始文件名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."CONTENT_TYPE" IS '文件类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."SIZE_" IS '大小';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPENDIX"."UPDATED_BY" IS '最后修改人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_APPENDIX" IS '业务附件';

-- ----------------------------
-- Table structure for C_APPLICATION
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_APPLICATION";
CREATE TABLE "LAMP_BASE_0000"."C_APPLICATION" (
  "ID" NUMBER(20) NOT NULL ,
  "CLIENT_ID" VARCHAR2(24 BYTE) ,
  "CLIENT_SECRET" VARCHAR2(32 BYTE) ,
  "WEBSITE" VARCHAR2(100 BYTE) ,
  "NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "ICON" VARCHAR2(255 BYTE) ,
  "APP_TYPE" VARCHAR2(10 BYTE) ,
  "DESCRIBE_" VARCHAR2(200 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."CLIENT_ID" IS '客户端ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."CLIENT_SECRET" IS '客户端密码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."WEBSITE" IS '官网';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."NAME" IS '应用名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."ICON" IS '应用图标';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."APP_TYPE" IS '类型;
#{SERVER:服务应用;APP:手机应用;PC:PC网页应用;WAP:手机网页应用}';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."DESCRIBE_" IS '备注';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_APPLICATION"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_APPLICATION" IS '应用';

-- ----------------------------
-- Records of C_APPLICATION
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_APPLICATION" VALUES ('1', 'lamp_web_plus', 'lamp_web_plus_secret', 'https://tangyh.top', 'lamp快速开发平台', NULL, 'PC', '内置', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_APPLICATION" VALUES ('2', 'lamp_web', 'lamp_web_secret', 'https://tangyh.top', 'lamp快速开发平台', NULL, 'PC', '内置', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_AREA
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_AREA";
CREATE TABLE "LAMP_BASE_0000"."C_AREA" (
  "ID" NUMBER(20) NOT NULL ,
  "CODE" VARCHAR2(64 BYTE) NOT NULL ,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL ,
  "FULL_NAME" VARCHAR2(255 BYTE) ,
  "SORT_VALUE" NUMBER(10) DEFAULT 1 ,
  "LONGITUDE" VARCHAR2(255 BYTE) ,
  "LATITUDE" VARCHAR2(255 BYTE) ,
  "LEVEL_" VARCHAR2(10 BYTE) ,
  "SOURCE_" VARCHAR2(255 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 0 ,
  "PARENT_ID" NUMBER(20) DEFAULT 0 ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."ID" IS 'id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."CODE" IS '编码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."LABEL" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."FULL_NAME" IS '全名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."LONGITUDE" IS '经度';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."LATITUDE" IS '维度';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."LEVEL_" IS '行政区级;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.AREA_LEVEL)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."SOURCE_" IS '数据来源';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_AREA"."UPDATED_BY" IS '更新人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_AREA" IS '地区表';

-- ----------------------------
-- Table structure for C_DICTIONARY
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_DICTIONARY";
CREATE TABLE "LAMP_BASE_0000"."C_DICTIONARY" (
  "ID" NUMBER(20) NOT NULL ,
  "TYPE" VARCHAR2(255 BYTE) NOT NULL ,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL ,
  "CODE" VARCHAR2(64 BYTE) NOT NULL ,
  "NAME" VARCHAR2(64 BYTE) NOT NULL ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "DESCRIBE_" VARCHAR2(255 BYTE) ,
  "SORT_VALUE" NUMBER(10) DEFAULT 1 ,
  "ICON" VARCHAR2(255 BYTE) ,
  "CSS_STYLE" VARCHAR2(255 BYTE) ,
  "CSS_CLASS" VARCHAR2(255 BYTE) ,
  "READONLY_" NUMBER(1) DEFAULT 0 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."TYPE" IS '类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."LABEL" IS '类型标签';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."CODE" IS '编码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."NAME" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."ICON" IS '图标';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."CSS_STYLE" IS 'css样式';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."CSS_CLASS" IS 'css;class';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."READONLY_" IS '内置';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_DICTIONARY"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_DICTIONARY" IS '字典项';

-- ----------------------------
-- Records of C_DICTIONARY
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1', 'AREA_LEVEL', '行政区划', '01', '国家', '1', NULL, '1', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('2', 'AREA_LEVEL', '行政区划', '02', '省份/直辖市', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('3', 'AREA_LEVEL', '行政区划', '03', '地市', '1', NULL, '3', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('4', 'AREA_LEVEL', '行政区划', '04', '区县', '1', NULL, '4', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('5', 'AREA_LEVEL', '行政区划', '05', '乡镇', '1', NULL, '5', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('10', 'EDUCATION', '学历', '01', '小学', '1', NULL, '1', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('11', 'EDUCATION', '学历', '02', '中学', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('12', 'EDUCATION', '学历', '03', '高中', '1', NULL, '3', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('13', 'EDUCATION', '学历', '04', '专科', '1', NULL, '4', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('14', 'EDUCATION', '学历', '05', '本科', '1', NULL, '5', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('15', 'EDUCATION', '学历', '06', '硕士', '1', NULL, '6', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('16', 'EDUCATION', '学历', '07', '博士', '1', NULL, '7', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('17', 'EDUCATION', '学历', '08', '博士后', '1', NULL, '8', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('29', 'EDUCATION', '学历', '20', '其他', '1', NULL, '20', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('40', 'ORG_TYPE', '机构类型', '01', '单位', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('41', 'ORG_TYPE', '机构类型', '02', '部门', '1', NULL, '2', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('43', 'NATION', '民族', '01', '汉族', '1', NULL, '0', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('44', 'NATION', '民族', '02', '壮族', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('45', 'NATION', '民族', '03', '满族', '1', NULL, '2', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('46', 'NATION', '民族', '04', '回族', '1', NULL, '3', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('47', 'NATION', '民族', '05', '苗族', '1', NULL, '4', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('48', 'NATION', '民族', '06', '维吾尔族', '1', NULL, '5', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('49', 'NATION', '民族', '07', '土家族', '1', NULL, '6', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('50', 'NATION', '民族', '08', '彝族', '1', NULL, '7', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('51', 'NATION', '民族', '09', '蒙古族', '1', NULL, '8', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('52', 'NATION', '民族', '10', '藏族', '1', NULL, '9', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('53', 'NATION', '民族', '11', '布依族', '1', NULL, '10', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('54', 'NATION', '民族', '12', '侗族', '1', NULL, '11', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('55', 'NATION', '民族', '13', '瑶族', '1', NULL, '12', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('56', 'NATION', '民族', '14', '朝鲜族', '1', NULL, '13', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('57', 'NATION', '民族', '15', '白族', '1', NULL, '14', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('58', 'NATION', '民族', '16', '哈尼族', '1', NULL, '15', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('59', 'NATION', '民族', '17', '哈萨克族', '1', NULL, '16', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('60', 'NATION', '民族', '18', '黎族', '1', NULL, '17', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('61', 'NATION', '民族', '19', '傣族', '1', NULL, '18', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('62', 'NATION', '民族', '20', '畲族', '1', NULL, '19', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('63', 'NATION', '民族', '21', '傈僳族', '1', NULL, '20', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('64', 'NATION', '民族', '22', '仡佬族', '1', NULL, '21', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('65', 'NATION', '民族', '23', '东乡族', '1', NULL, '22', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('66', 'NATION', '民族', '24', '高山族', '1', NULL, '23', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('67', 'NATION', '民族', '25', '拉祜族', '1', NULL, '24', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('68', 'NATION', '民族', '26', '水族', '1', NULL, '25', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('69', 'NATION', '民族', '27', '佤族', '1', NULL, '26', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('70', 'NATION', '民族', '28', '纳西族', '1', NULL, '27', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('71', 'NATION', '民族', '29', '羌族', '1', NULL, '28', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('72', 'NATION', '民族', '30', '土族', '1', NULL, '29', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('73', 'NATION', '民族', '31', '仫佬族', '1', NULL, '30', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('74', 'NATION', '民族', '32', '锡伯族', '1', NULL, '31', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('75', 'NATION', '民族', '33', '柯尔克孜族', '1', NULL, '32', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('76', 'NATION', '民族', '34', '达斡尔族', '1', NULL, '33', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('77', 'NATION', '民族', '35', '景颇族', '1', NULL, '34', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('78', 'NATION', '民族', '36', '毛南族', '1', NULL, '35', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('79', 'NATION', '民族', '37', '撒拉族', '1', NULL, '36', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('80', 'NATION', '民族', '38', '塔吉克族', '1', NULL, '37', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('81', 'NATION', '民族', '39', '阿昌族', '1', NULL, '38', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('82', 'NATION', '民族', '40', '普米族', '1', NULL, '39', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('83', 'NATION', '民族', '41', '鄂温克族', '1', NULL, '40', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('84', 'NATION', '民族', '42', '怒族', '1', NULL, '41', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('85', 'NATION', '民族', '43', '京族', '1', NULL, '42', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('86', 'NATION', '民族', '44', '基诺族', '1', NULL, '43', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('87', 'NATION', '民族', '45', '德昂族', '1', NULL, '44', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('88', 'NATION', '民族', '46', '保安族', '1', NULL, '45', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('89', 'NATION', '民族', '47', '俄罗斯族', '1', NULL, '46', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('90', 'NATION', '民族', '48', '裕固族', '1', NULL, '47', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('91', 'NATION', '民族', '49', '乌兹别克族', '1', NULL, '48', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('92', 'NATION', '民族', '50', '门巴族', '1', NULL, '49', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('93', 'NATION', '民族', '51', '鄂伦春族', '1', NULL, '50', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('94', 'NATION', '民族', '52', '独龙族', '1', NULL, '51', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('95', 'NATION', '民族', '53', '塔塔尔族', '1', NULL, '52', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('96', 'NATION', '民族', '54', '赫哲族', '1', NULL, '53', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('97', 'NATION', '民族', '55', '珞巴族', '1', NULL, '54', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('98', 'NATION', '民族', '56', '布朗族', '1', NULL, '55', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('99', 'NATION', '民族', '57', '其他', '1', NULL, '100', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('110', 'POSITION_STATUS', '职位状态', '01', '在职', '1', NULL, '1', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('111', 'POSITION_STATUS', '职位状态', '02', '请假', '1', NULL, '2', NULL, NULL, NULL, '1', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('112', 'POSITION_STATUS', '职位状态', '03', '离职', '1', NULL, '3', NULL, NULL, NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486198107023605760', 'RESOURCE_TYPE', '资源类型', '20', '菜单', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486198623417925632', 'RESOURCE_DATA_SCOPE', '数据范围', '01', '全部', '1', NULL, '1', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486198858865180672', 'ROLE_CATEGORY', '角色类别', '10', '功能角色', '1', NULL, '1', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486198996287356928', 'RESOURCE_TYPE', '资源类型', '60', '数据', '1', NULL, '6', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199651718660096', 'RESOURCE_DATA_SCOPE', '数据范围', '02', '本单位及子级', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199679237488640', 'RESOURCE_DATA_SCOPE', '数据范围', '03', '本单位', '1', NULL, '3', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199726792507392', 'RESOURCE_DATA_SCOPE', '数据范围', '04', '本部门及子级', '1', NULL, '4', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199753644441600', 'RESOURCE_DATA_SCOPE', '数据范围', '05', '本部门', '1', NULL, '5', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199809227358208', 'RESOURCE_DATA_SCOPE', '数据范围', '06', '个人', '1', NULL, '6', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486199838218387456', 'RESOURCE_DATA_SCOPE', '数据范围', '07', '自定义', '1', NULL, '7', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486200233623814144', 'ROLE_CATEGORY', '角色类别', '20', '桌面角色', '1', NULL, '2', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_DICTIONARY" VALUES ('1486200358744096768', 'ROLE_CATEGORY', '角色类别', '30', '数据角色', '1', NULL, '3', NULL, NULL, NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_FILE
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_FILE";
CREATE TABLE "LAMP_BASE_0000"."C_FILE" (
  "ID" NUMBER(20) NOT NULL ,
  "BIZ_TYPE" VARCHAR2(255 BYTE) NOT NULL ,
  "FILE_TYPE" VARCHAR2(255 BYTE) ,
  "STORAGE_TYPE" VARCHAR2(255 BYTE) ,
  "BUCKET" VARCHAR2(255 BYTE) ,
  "PATH" VARCHAR2(255 BYTE) ,
  "URL" VARCHAR2(255 BYTE) ,
  "UNIQUE_FILE_NAME" VARCHAR2(255 BYTE) ,
  "FILE_MD5" VARCHAR2(255 BYTE) ,
  "ORIGINAL_FILE_NAME" VARCHAR2(255 BYTE) ,
  "CONTENT_TYPE" VARCHAR2(255 BYTE) ,
  "SUFFIX" VARCHAR2(255 BYTE) ,
  "SIZE_" NUMBER(20) DEFAULT 0 ,
  "CREATE_TIME" DATE NOT NULL ,
  "CREATED_BY" NUMBER(20) NOT NULL ,
  "UPDATE_TIME" DATE NOT NULL ,
  "UPDATED_BY" NUMBER(20) NOT NULL
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."BIZ_TYPE" IS '业务类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."FILE_TYPE" IS '文件类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."STORAGE_TYPE" IS '存储类型
LOCAL;FAST_DFS MIN_IO ALI';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."BUCKET" IS '桶';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."PATH" IS '文件相对地址';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."URL" IS '文件访问地址';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."UNIQUE_FILE_NAME" IS '唯一文件名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."FILE_MD5" IS '文件md5';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."ORIGINAL_FILE_NAME" IS '原始文件名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."CONTENT_TYPE" IS '文件类型';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."SUFFIX" IS '后缀';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."SIZE_" IS '大小';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."UPDATE_TIME" IS '最后修改时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_FILE"."UPDATED_BY" IS '最后修改人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_FILE" IS '增量文件上传日志';

-- ----------------------------
-- Table structure for C_LOGIN_LOG
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_LOGIN_LOG";
CREATE TABLE "LAMP_BASE_0000"."C_LOGIN_LOG" (
  "ID" NUMBER(20) NOT NULL ,
  "REQUEST_IP" VARCHAR2(50 BYTE) ,
  "USER_ID" NUMBER(20) ,
  "USER_NAME" VARCHAR2(50 BYTE) ,
  "ACCOUNT" VARCHAR2(30 BYTE) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "LOGIN_DATE" CHAR(10 BYTE) ,
  "UA" CLOB ,
  "BROWSER" VARCHAR2(255 BYTE) ,
  "BROWSER_VERSION" VARCHAR2(255 BYTE) ,
  "OPERATING_SYSTEM" VARCHAR2(255 BYTE) ,
  "LOCATION" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."ID" IS '主键';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."REQUEST_IP" IS '登录IP';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."USER_ID" IS '登录人ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."USER_NAME" IS '登录人姓名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."ACCOUNT" IS '登录人账号';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."DESCRIPTION" IS '登录描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."LOGIN_DATE" IS '登录时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."UA" IS '浏览器请求头';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."BROWSER" IS '浏览器名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."BROWSER_VERSION" IS '浏览器版本';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."OPERATING_SYSTEM" IS '操作系统';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."LOCATION" IS '登录地点';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_LOGIN_LOG"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_LOGIN_LOG" IS '登录日志';

-- ----------------------------
-- Table structure for C_MENU
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_MENU";
CREATE TABLE "LAMP_BASE_0000"."C_MENU" (
  "ID" NUMBER(20) NOT NULL ,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL ,
  "RESOURCE_TYPE" CHAR(2 BYTE) ,
  "TREE_GRADE" NUMBER(10) ,
  "TREE_PATH" VARCHAR2(512 BYTE) ,
  "DESCRIBE_" VARCHAR2(200 BYTE) ,
  "IS_GENERAL" NUMBER(1) DEFAULT 0 ,
  "PATH" VARCHAR2(255 BYTE) ,
  "COMPONENT" VARCHAR2(255 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "SORT_VALUE" NUMBER(10) DEFAULT 1 ,
  "ICON" VARCHAR2(255 BYTE) ,
  "GROUP_" VARCHAR2(20 BYTE) ,
  "DATA_SCOPE" CHAR(2 BYTE) ,
  "CUSTOM_CLASS" VARCHAR2(255 BYTE) ,
  "IS_DEF" NUMBER(1) DEFAULT 0 ,
  "PARENT_ID" NUMBER(20) DEFAULT 0 ,
  "READONLY_" NUMBER(1) DEFAULT 0 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."LABEL" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."RESOURCE_TYPE" IS '资源类型;[20-菜单 60-数据];@Echo(api = DICTIONARY_ITEM_FEIGN_CLASS,dictType = EchoDictType.RESOURCE_TYPE)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."TREE_GRADE" IS '树层级';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."TREE_PATH" IS '树路径';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."IS_GENERAL" IS '通用菜单;True表示无需分配所有人就可以访问的';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."PATH" IS '路径';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."COMPONENT" IS '组件';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."ICON" IS '菜单图标';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."GROUP_" IS '分组';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."DATA_SCOPE" IS '数据范围;[01-全部 02-本单位及子级 03-本单位 04-本部门 05-本部门及子级 06-个人 07-自定义]';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."CUSTOM_CLASS" IS '实现类';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."IS_DEF" IS '是否默认';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."PARENT_ID" IS '父级菜单ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."READONLY_" IS '内置';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_MENU"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_MENU" IS '菜单';

-- ----------------------------
-- Records of C_MENU
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('223', '菜单1-1-2', '20', '3', ',100,220,221,', NULL, '1', '/more/multiMenu/menu1-1/menu1-1-2', 'lamp/more/multiMenu/menu1-1/menu1-1-2/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '221', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('224', '菜单1-2', '20', '2', ',100,220,', NULL, '1', '/more/multiMenu/menu1-2', 'lamp/more/multiMenu/menu1-2/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '220', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201050779090944', '查看全部', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '1', NULL, NULL, '01', NULL, '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201491877265408', '查看本单位及子单位', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '2', NULL, NULL, '02', NULL, '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201562119274496', '查看本单位', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '3', NULL, NULL, '06', NULL, '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201715840516096', '查看本部门及子部门', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '4', NULL, NULL, '04', NULL, '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201804327747584', '查看本部门', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '5', NULL, NULL, '05', NULL, '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201872350969856', '查看个人', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '6', NULL, NULL, '06', NULL, '1', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486201971705643008', '查看自定义数据', '60', '2', ',30,132,', NULL, '0', NULL, NULL, '1', '7', NULL, NULL, '07', 'DATA_SCOPE_MY_TEST', '0', '132', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486619304207056896', '查看全部', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '1', NULL, NULL, '01', NULL, '0', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486619392048365568', '查看本单位及子单位', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '2', NULL, NULL, '02', NULL, '0', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486620313587286016', '查看本单位', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '3', NULL, NULL, '03', NULL, '0', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486620425789112320', '查看本部门及子部门', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '4', NULL, NULL, '04', NULL, '0', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486620477806870528', '查看本部门', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '5', NULL, NULL, '05', NULL, '0', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('1486620546081751040', '查看个人', '60', '2', ',30,131,', NULL, '0', NULL, NULL, '1', '6', NULL, NULL, '06', NULL, '1', '131', '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('10', '租户设置', '20', '0', ',', NULL, '0', '/tenant', 'Layout', '1', '10', 'ant-design:group-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('20', '工作台', '20', '0', ',', NULL, '0', '/workbench', 'Layout', '1', '20', 'ant-design:dashboard-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('30', '组织管理', '20', '0', ',', NULL, '0', '/org', 'Layout', '1', '30', 'ant-design:cluster-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('40', '资源中心', '20', '0', ',', NULL, '0', '/resources', 'Layout', '1', '40', 'ant-design:cloud-server-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('50', '流程管理', '20', '0', ',', NULL, '0', '/activiti', 'Layout', '1', '50', 'tabler:chart-dots', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('60', '系统设置', '20', '0', ',', NULL, '0', '/system', 'Layout', '1', '60', 'ant-design:setting-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('70', '网关管理', '20', '0', ',', NULL, '0', '/gateway', 'Layout', '1', '70', 'ant-design:sliders-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('80', '开发者管理', '20', '0', ',', NULL, '0', '/developer', 'Layout', '1', '80', 'ant-design:bug-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('90', '了解lamp', '20', '0', ',', NULL, '1', '/community', 'Layout', '1', '90', 'ant-design:github-filled', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('100', '更多功能', '20', '0', ',', NULL, '1', '/more', 'Layout', '1', '100', 'ant-design:appstore-add-outlined', NULL, NULL, NULL, NULL, '0', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('110', '租户管理', '20', '1', ',10,', NULL, '0', '/tenant/tenant', 'lamp/tenant/tenant/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '10', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('111', '超级用户', '20', '1', ',10,', NULL, '0', '/tenant/user', 'lamp/tenant/user/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '10', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('112', '数据源配置', '20', '1', ',10,', NULL, '0', '/tenant/datasourceConfig', 'lamp/tenant/datasourceConfig/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '10', '0', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('120', '通知公告', '20', '1', ',20,', NULL, '0', '/workbench/notice', 'lamp/workbench/notice/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('121', '待我审批', '20', '1', ',20,', NULL, '0', '/workbench/todo', 'lamp/workbench/todo/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('122', '我已审批', '20', '1', ',20,', NULL, '0', '/workbench/done', 'lamp/workbench/done/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('123', '我发起的', '20', '1', ',20,', NULL, '0', '/workbench/started', 'lamp/workbench/started/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '20', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('130', '机构管理', '20', '1', ',30,', NULL, '0', '/org/org', 'lamp/org/org/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('131', '岗位管理', '20', '1', ',30,', NULL, '0', '/org/station', 'lamp/org/station/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('132', '用户管理', '20', '1', ',30,', NULL, '0', '/org/user', 'lamp/org/user/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '30', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('140', '消息中心', '20', '1', ',40,', NULL, '0', '/resources/msg', 'lamp/resources/msg/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('141', '短信模版', '20', '1', ',40,', NULL, '0', '/resources/smsTemplate', 'lamp/resources/smsTemplate/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('142', '短信中心', '20', '1', ',40,', NULL, '0', '/resources/sms', 'lamp/resources/sms/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('143', '附件管理', '20', '1', ',40,', NULL, '0', '/resources/attachment', 'lamp/resources/attachment/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '40', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('150', '流程部署', '20', '1', ',50,', NULL, '0', '/activiti/deploymentManager', 'lamp/activiti/deploymentManager/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('151', '模型管理', '20', '1', ',50,', NULL, '0', '/activiti/modelManager', 'lamp/activiti/modelManager/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('152', '请假流程', '20', '1', ',50,', NULL, '0', '/activiti/level', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('153', '请假管理', '20', '2', ',50,152,', NULL, '0', '/activiti/leave/instant', 'lamp/activiti/leave/instantManager/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '152', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('154', '请假任务', '20', '2', ',50,152,', NULL, '0', '/activiti/leave/ruTask', 'lamp/activiti/leave/ruTask/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '152', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('155', '报销流程', '20', '1', ',50,', NULL, '0', '/activiti/reimbursement', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '50', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('156', '报销管理', '20', '2', ',50,155,', NULL, '0', '/activiti/reimbursement/instantManager', 'lamp/activiti/reimbursement/instantManager/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '155', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('157', '报销任务', '20', '2', ',50,155,', NULL, '0', '/activiti/reimbursement/ruTask', 'lamp/activiti/reimbursement/ruTask/index', '1', '2', NULL, NULL, NULL, NULL, NULL, '155', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('160', '菜单管理', '20', '1', ',60,', NULL, '0', '/system/menu', 'lamp/system/menu/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('161', '角色管理', '20', '1', ',60,', NULL, '0', '/system/role', 'lamp/system/role/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('162', '字典管理', '20', '1', ',60,', NULL, '0', '/system/dictionary', 'lamp/system/dictionary/index', '1', '30', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('163', '地区管理', '20', '1', ',60,', NULL, '0', '/system/area', 'lamp/system/area/index', '1', '40', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('164', '参数管理', '20', '1', ',60,', NULL, '0', '/system/parameter', 'lamp/system/parameter/index', '1', '50', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('165', '操作日志', '20', '1', ',60,', NULL, '0', '/system/optLog', 'lamp/system/optLog/index', '1', '60', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('166', '登录日志', '20', '1', ',60,', NULL, '0', '/system/loginLog', 'lamp/system/loginLog/index', '1', '70', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('167', '在线用户', '20', '1', ',60,', NULL, '0', '/system/online', 'lamp/system/online/index', '1', '80', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('168', '应用管理', '20', '1', ',60,', NULL, '0', '/system/application', 'lamp/system/application/index', '1', '90', NULL, NULL, NULL, NULL, NULL, '60', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('180', '限流规则', '20', '1', ',70,', NULL, '0', '/gateway/ratelimiter', 'lamp/gateway/ratelimiter/index', '1', '10', NULL, NULL, NULL, NULL, NULL, '70', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('181', '阻止访问', '20', '1', ',70,', NULL, '0', '/gateway/blocklist', 'lamp/gateway/blocklist/index', '1', '20', NULL, NULL, NULL, NULL, NULL, '70', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('190', '定时任务', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8767/xxl-job-admin', 'Layout', '1', '10', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('191', '接口文档', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8760/api/gate/doc.html', 'Layout', '1', '20', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('192', 'nacos', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8848/nacos', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('193', '服务监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8762/lamp-monitor', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('194', '数据库监控', '20', '1', ',80,', NULL, '0', '/developer/db', 'lamp/developer/db/index', '1', '50', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('195', '缓存监控', '20', '1', ',80,', NULL, '0', 'https://github.com/junegunn/redis-stat', 'Layout', '1', '60', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('196', 'zipkin监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:8772/zipkin', 'Layout', '1', '70', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('197', 'SkyWalking监控', '20', '1', ',80,', NULL, '0', 'http://127.0.0.1:12080', 'Layout', '1', '80', NULL, NULL, NULL, NULL, NULL, '80', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('210', '在线文档', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud', 'Layout', '1', '10', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('211', '会员版', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003629', 'Layout', '1', '20', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('212', '获取源码', '20', '1', ',90,', NULL, '1', 'https://github.com/zuihou', 'Layout', '1', '30', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('213', '问题反馈', '20', '1', ',90,', NULL, '1', 'https://github.com/dromara/lamp-cloud/issues', 'Layout', '1', '40', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('214', '更新日志', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/1465302', 'Layout', '1', '50', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('215', '蓝图', '20', '1', ',90,', NULL, '1', 'https://www.kancloud.cn/zuihou/zuihou-admin-cloud/2003640', 'Layout', '1', '60', NULL, NULL, NULL, NULL, NULL, '90', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('220', '多级菜单', '20', '1', ',100,', NULL, '1', '/more/multiMenu', 'Layout', '1', '1', NULL, NULL, NULL, NULL, NULL, '100', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('221', '菜单1-1', '20', '2', ',100,220,', NULL, '1', '/more/multiMenu/menu1-1', 'Layout', '1', '1', NULL, NULL, NULL, NULL, NULL, '220', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_MENU" VALUES ('222', '菜单1-1-1', '20', '3', ',100,220,221,', NULL, '1', '/more/multiMenu/menu1-1/menu1-1-1', 'lamp/more/multiMenu/menu1-1/menu1-1-1/index', '1', '1', NULL, NULL, NULL, NULL, NULL, '221', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_OPT_LOG
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_OPT_LOG";
CREATE TABLE "LAMP_BASE_0000"."C_OPT_LOG" (
  "ID" NUMBER(20) NOT NULL ,
  "REQUEST_IP" VARCHAR2(50 BYTE) ,
  "TYPE" VARCHAR2(5 BYTE) ,
  "USER_NAME" VARCHAR2(50 BYTE) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "CLASS_PATH" VARCHAR2(255 BYTE) ,
  "ACTION_METHOD" VARCHAR2(50 BYTE) ,
  "REQUEST_URI" VARCHAR2(50 BYTE) ,
  "HTTP_METHOD" VARCHAR2(10 BYTE) ,
  "START_TIME" DATE ,
  "FINISH_TIME" DATE ,
  "CONSUMING_TIME" NUMBER(20) ,
  "UA" VARCHAR2(500 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."ID" IS '主键';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."REQUEST_IP" IS '操作IP';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."TYPE" IS '日志类型;
#LogType{OPT:操作类型;EX:异常类型}';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."USER_NAME" IS '操作人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."DESCRIPTION" IS '操作描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."CLASS_PATH" IS '类路径';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."ACTION_METHOD" IS '请求方法';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."REQUEST_URI" IS '请求地址';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."HTTP_METHOD" IS '请求类型;
#HttpMethod{GET:GET请求;POST:POST请求;PUT:PUT请求;DELETE:DELETE请求;PATCH:PATCH请求;TRACE:TRACE请求;HEAD:HEAD请求;OPTIONS:OPTIONS请求;}';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."FINISH_TIME" IS '完成时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."CONSUMING_TIME" IS '消耗时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."UA" IS '浏览器';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_OPT_LOG" IS '系统日志';

-- ----------------------------
-- Table structure for C_OPT_LOG_EXT
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_OPT_LOG_EXT";
CREATE TABLE "LAMP_BASE_0000"."C_OPT_LOG_EXT" (
  "ID" NUMBER(20) NOT NULL ,
  "PARAMS" CLOB ,
  "RESULT" CLOB ,
  "EX_DETAIL" CLOB ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."ID" IS '主键';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."PARAMS" IS '请求参数';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."RESULT" IS '返回值';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."EX_DETAIL" IS '异常描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_OPT_LOG_EXT"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_OPT_LOG_EXT" IS '系统日志扩展';

-- ----------------------------
-- Table structure for C_ORG
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_ORG";
CREATE TABLE "LAMP_BASE_0000"."C_ORG" (
  "ID" NUMBER(20) NOT NULL ,
  "LABEL" VARCHAR2(255 BYTE) NOT NULL ,
  "TYPE_" CHAR(2 BYTE) ,
  "ABBREVIATION" VARCHAR2(255 BYTE) ,
  "PARENT_ID" NUMBER(20) DEFAULT 0 ,
  "TREE_PATH" VARCHAR2(255 BYTE) ,
  "SORT_VALUE" NUMBER(10) DEFAULT 1 ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "DESCRIBE_" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."LABEL" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."TYPE_" IS '类型;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.ORG_TYPE)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."ABBREVIATION" IS '简称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."PARENT_ID" IS '父ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."TREE_PATH" IS '树结构';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."SORT_VALUE" IS '排序';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ORG"."UPDATED_BY" IS '修改人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_ORG" IS '组织';

-- ----------------------------
-- Table structure for C_PARAMETER
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_PARAMETER";
CREATE TABLE "LAMP_BASE_0000"."C_PARAMETER" (
  "ID" NUMBER(20) NOT NULL ,
  "KEY_" VARCHAR2(255 BYTE) NOT NULL ,
  "VALUE" VARCHAR2(255 BYTE) NOT NULL ,
  "NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "DESCRIBE_" VARCHAR2(255 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "READONLY_" NUMBER(1) DEFAULT 0 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."KEY_" IS '参数键';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."VALUE" IS '参数值';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."NAME" IS '参数名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."READONLY_" IS '内置';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_PARAMETER"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_PARAMETER" IS '参数配置';

-- ----------------------------
-- Records of C_PARAMETER
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_PARAMETER" VALUES ('1', 'LoginPolicy', 'MANY', '登录策略', 'ONLY_ONE:一个用户只能登录一次; MANY:用户可以任意登录; ONLY_ONE_CLIENT:一个用户在一个应用只能登录一次', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_RESOURCE
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_RESOURCE";
CREATE TABLE "LAMP_BASE_0000"."C_RESOURCE" (
  "ID" NUMBER(20) NOT NULL ,
  "CODE" VARCHAR2(500 BYTE) ,
  "NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "MENU_ID" NUMBER(20) ,
  "DESCRIBE_" VARCHAR2(255 BYTE) ,
  "READONLY_" NUMBER(1) DEFAULT 1 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."CODE" IS '编码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."NAME" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."MENU_ID" IS '菜单;#c_menu';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."READONLY_" IS '内置';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_RESOURCE"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_RESOURCE" IS '资源';

-- ----------------------------
-- Records of C_RESOURCE
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('1', 'authority:menu:add', '新增', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('2', 'authority:menu:edit', '编辑', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('3', 'authority:menu:delete', '删除', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('4', 'authority:menu:view;authority:resource:view', '查看', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('5', 'authority:menu:import', '导入', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('6', 'authority:menu:export', '导出', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('7', 'authority:resource:add', '新增', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('8', 'authority:resource:edit', '编辑', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('9', 'authority:resource:delete', '删除', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872440', 'tenant:tenant:add', '新增', '110', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872445', 'tenant:tenant:edit', '编辑', '110', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872450', 'tenant:tenant:delete', '删除', '110', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872455', 'tenant:tenant:view', '查看', '110', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872460', 'tenant:tenant:initConnect;tenant:datasourceConfig:view', '初始化', '110', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872467', 'tenant:user:add', '新增', '111', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872472', 'tenant:user:edit', '编辑', '111', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872477', 'tenant:user:delete', '删除', '111', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872484', 'tenant:user:view;tenant:tenant:view', '查看', '111', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872491', 'authority:org:add', '新增', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872496', 'authority:org:edit', '编辑', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872501', 'authority:org:delete', '删除', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872506', 'authority:org:view', '查看', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872513', 'authority:station:add', '新增', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872518', 'authority:station:edit', '编辑', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872523', 'authority:station:delete', '删除', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872528', 'authority:station:view;authority:org:view', '查看', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872537', 'authority:user:add', '新增', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872542', 'authority:user:edit', '编辑', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872547', 'authority:user:delete', '删除', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872552', 'authority:user:view;authority:station:view;authority:org:view', '查看', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872557', 'authority:user:resetPassword', '重置密码', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872562', 'authority:user:updateState', '修改状态', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872569', 'msg:msg:add;authority:user:view;authority:role:view', '新增', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872574', 'msg:msg:edit;authority:user:view;authority:role:view', '编辑', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872579', 'msg:msg:delete', '删除', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872584', 'msg:msg:view', '查看', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872589', 'msg:msg:mark', '标记已读', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872596', 'authority:org:import', '导入', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872601', 'authority:org:export', '导出', '130', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872610', 'authority:station:import', '导入', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872615', 'authority:station:export', '导出', '131', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872622', 'authority:user:import', '导入', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872627', 'authority:user:export', '导出', '132', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872646', 'msg:msg:export', '导出', '140', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872657', 'msg:sms:add', '新增', '142', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872662', 'msg:sms:edit', '编辑', '142', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872667', 'msg:sms:delete', '删除', '142', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872672', 'msg:sms:view;msg:smsTemplate:view', '查看', '142', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872679', 'msg:smsTemplate:add', '新增', '141', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872684', 'msg:smsTemplate:edit', '编辑', '141', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872689', 'msg:smsTemplate:delete', '删除', '141', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872694', 'msg:smsTemplate:view', '查看', '141', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872703', 'file:attachment:add', '新增', '143', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872708', 'file:attachment:edit', '编辑', '143', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872713', 'file:attachment:delete', '删除', '143', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872718', 'file:attachment:view', '查看', '143', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872723', 'file:attachment:download', '下载', '143', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872736', 'authority:role:add;authority:org:view', '新增', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872741', 'authority:role:edit;authority:org:view', '编辑', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872746', 'authority:role:delete', '删除', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872751', 'authority:role:view', '查看', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872756', 'authority:role:config;authority:user:view', '配置权限', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872761', 'authority:role:auth;authority:menu:view;authority:resource:view', '授权', '161', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872768', 'authority:dictionary:add', '新增', '162', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872773', 'authority:dictionary:edit', '编辑', '162', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872778', 'authority:dictionary:delete', '删除', '162', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872783', 'authority:dictionary:view', '查看', '162', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872790', 'authority:area:add', '新增', '163', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872795', 'authority:area:edit', '编辑', '163', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872800', 'authority:area:delete', '删除', '163', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872805', 'authority:area:view', '查看', '163', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872812', 'authority:parameter:add', '新增', '164', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872817', 'authority:parameter:edit', '编辑', '164', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872822', 'authority:parameter:delete', '删除', '164', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872827', 'authority:parameter:view', '查看', '164', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872838', 'authority:optLog:delete', '删除', '165', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872843', 'authority:optLog:view', '查看', '165', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872850', 'authority:loginLog:delete', '删除', '166', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872857', 'authority:loginLog:view', '查看', '166', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872864', 'authority:online:view', '查看', '167', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872869', 'authority:online:delete', '删除', '167', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872876', 'authority:application:add', '新增', '168', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872881', 'authority:application:edit', '编辑', '168', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872886', 'authority:application:delete', '删除', '168', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('25938183673872891', 'authority:application:view', '查看', '168', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('26578833880645891', 'tenant:datasourceConfig:add', '新增', '112', NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('26578833880645896', 'tenant:datasourceConfig:edit', '编辑', '112', NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('26578833880645901', 'tenant:datasourceConfig:delete', '删除', '112', NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('26578833880645906', 'tenant:datasourceConfig:view', '查看', '112', NULL, '1', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_RESOURCE" VALUES ('1400107570902859776', 'authority:resource:view', '查看', '160', NULL, '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_ROLE
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_ROLE";
CREATE TABLE "LAMP_BASE_0000"."C_ROLE" (
  "ID" NUMBER(20) NOT NULL ,
  "CATEGORY" CHAR(2 BYTE) ,
  "NAME" VARCHAR2(30 BYTE) NOT NULL ,
  "CODE" VARCHAR2(20 BYTE) ,
  "DESCRIBE_" VARCHAR2(100 BYTE) ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "READONLY_" NUMBER(1) DEFAULT 0 ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."CATEGORY" IS '角色类别;[10-功能角色 20-桌面角色 30-数据角色]';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."NAME" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."CODE" IS '编码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."READONLY_" IS '内置角色';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_ROLE" IS '角色';

-- ----------------------------
-- Records of C_ROLE
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_ROLE" VALUES ('1', '10', '超级管理员', 'SUPER_ADMIN', '内置管理员(二次开发必须保留)', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_ROLE" VALUES ('2', '10', '平台管理员', 'PT_ADMIN', '内置运营专用平台管理员(二次开发必须保留)', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_ROLE" VALUES ('3', '10', '普通管理员', 'GENERAL_ADMIN', '演示用的', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_ROLE" VALUES ('4', '10', '普通用户', 'NORMAL', '演示用的', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_ROLE" VALUES ('1486215142227050496', '30', 'TEST', 'TEST', NULL, '1', '0', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Table structure for C_ROLE_AUTHORITY
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY";
CREATE TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" (
  "ID" NUMBER(20) NOT NULL ,
  "AUTHORITY_ID" NUMBER(20) NOT NULL ,
  "AUTHORITY_TYPE" VARCHAR2(10 BYTE) NOT NULL ,
  "ROLE_ID" NUMBER(20) NOT NULL ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."ID" IS '主键';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."AUTHORITY_ID" IS '资源id;
#c_resource #c_menu';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."AUTHORITY_TYPE" IS '权限类型;
#AuthorizeType{MENU:菜单;RESOURCE:资源;}';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."ROLE_ID" IS '角色id;
#c_role';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_AUTHORITY"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" IS '角色的资源';

-- ----------------------------
-- Records of C_ROLE_AUTHORITY
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633793', '7', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633794', '8', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633795', '25938183673872496', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633796', '25938183673872881', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633797', '9', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633799', '25938183673872627', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633800', '25938183673872756', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633801', '25938183673872501', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633802', '25938183673872886', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633803', '25938183673872746', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633804', '25938183673872491', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633805', '25938183673872876', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633806', '25938183673872622', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633807', '25938183673872751', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633808', '25938183673872864', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633809', '25938183673872736', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633810', '25938183673872610', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633811', '25938183673872869', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633812', '25938183673872741', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633813', '25938183673872615', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633814', '25938183673872857', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633815', '25938183673872601', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633816', '25938183673872850', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633817', '25938183673872723', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633818', '25938183673872596', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633819', '25938183673872584', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633820', '25938183673872713', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633821', '25938183673872843', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633822', '25938183673872589', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633823', '25938183673872718', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633824', '25938183673872579', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633825', '25938183673872708', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633826', '25938183673872838', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633827', '25938183673872569', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633828', '25938183673872827', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633829', '25938183673872574', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633830', '25938183673872703', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633831', '25938183673872817', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633832', '25938183673872689', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633833', '25938183673872562', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633834', '25938183673872822', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633835', '25938183673872694', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633836', '25938183673872552', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633837', '25938183673872812', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633838', '25938183673872684', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633839', '25938183673872557', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633840', '25938183673872800', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633841', '25938183673872672', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633842', '25938183673872547', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633843', '25938183673872805', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633844', '25938183673872679', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633845', '25938183673872537', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633846', '25938183673872795', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633847', '25938183673872667', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633848', '25938183673872542', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633849', '25938183673872528', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633850', '25938183673872657', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633851', '25938183673872790', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633852', '25938183673872662', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633853', '25938183673872778', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633854', '25938183673872523', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633855', '25938183673872783', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633856', '25938183673872768', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633857', '25938183673872513', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633858', '25938183673872773', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633859', '25938183673872646', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633860', '25938183673872518', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633861', '130', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633862', '131', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633863', '132', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633864', '140', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633865', '141', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633866', '142', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633867', '143', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633868', '20', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633869', '150', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633870', '151', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633871', '152', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633872', '153', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633873', '154', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633874', '155', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633875', '156', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633876', '157', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633877', '30', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633878', '160', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633879', '161', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633880', '162', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633881', '163', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633882', '164', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633883', '165', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633884', '166', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633885', '167', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633886', '40', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633887', '168', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633888', '50', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633889', '180', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633890', '181', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633891', '60', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633900', '70', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633902', '120', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633903', '121', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633904', '122', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633905', '123', 'MENU', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633954', '25938183673872569', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633955', '25938183673872506', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633956', '25938183673872574', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633957', '25938183673872703', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633958', '25938183673872496', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633959', '25938183673872689', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633960', '25938183673872562', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633961', '25938183673872627', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633962', '25938183673872501', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633963', '25938183673872694', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633964', '25938183673872552', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633965', '25938183673872491', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633966', '25938183673872684', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633967', '25938183673872557', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633968', '25938183673872622', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633969', '25938183673872672', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633970', '25938183673872610', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633971', '25938183673872547', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633972', '25938183673872615', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633973', '25938183673872679', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633974', '25938183673872601', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633975', '25938183673872537', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633976', '25938183673872667', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633977', '25938183673872542', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633978', '25938183673872528', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633979', '25938183673872657', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633980', '25938183673872723', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633981', '25938183673872596', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633982', '25938183673872662', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633983', '25938183673872584', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633984', '25938183673872713', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633985', '25938183673872523', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633986', '25938183673872589', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633987', '25938183673872718', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633988', '25938183673872513', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633989', '25938183673872579', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633990', '25938183673872708', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633991', '25938183673872518', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633992', '25938183673872646', 'RESOURCE', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633993', '130', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633994', '131', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633995', '132', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633996', '140', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633997', '141', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633998', '142', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633999', '143', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634000', '20', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634001', '150', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634002', '151', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634003', '152', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634004', '153', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634005', '154', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634006', '155', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634007', '156', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634008', '157', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634009', '30', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634010', '40', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634011', '50', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634012', '120', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634013', '121', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634014', '122', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228634015', '123', 'MENU', '3', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401793578031644672', '25938183673872491', 'RESOURCE', '1401106547731333120', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401793578031644673', '130', 'MENU', '1401106547731333120', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401793578035838976', '30', 'MENU', '1401106547731333120', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401796782312128512', '25938183673872440', 'RESOURCE', '1401105465810616320', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401796782312128513', '25938183673872445', 'RESOURCE', '1401105465810616320', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401796782312128514', '10', 'MENU', '1401105465810616320', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401796782312128515', '110', 'MENU', '1401105465810616320', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022011469824', '224', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022019858432', '100', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022019858433', '220', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022019858434', '221', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022019858435', '222', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401882022024052736', '223', 'MENU', '1401107652259348480', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401884591014281216', '25938183673872460', 'RESOURCE', '1401884493064699904', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1401884591014281217', '110', 'MENU', '1401884493064699904', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1408620582760611840', '20', 'MENU', '1408618647575855104', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1408620582773194752', '120', 'MENU', '1408618647575855104', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1408620582802554880', '121', 'MENU', '1408618647575855104', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1408620582802554881', '122', 'MENU', '1408618647575855104', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826061230080', '25938183673872601', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826090590208', '25938183673872537', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826098978816', '25938183673872506', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826103173120', '25938183673872542', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826107367424', '25938183673872496', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826115756032', '25938183673872528', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826119950336', '25938183673872562', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826124144640', '25938183673872627', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826128338944', '25938183673872596', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826132533248', '25938183673872501', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826136727552', '25938183673872552', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826136727553', '25938183673872491', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826145116160', '25938183673872523', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826153504768', '25938183673872557', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826157699072', '25938183673872622', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826166087680', '25938183673872513', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826174476288', '25938183673872610', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826178670592', '25938183673872547', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826182864896', '25938183673872518', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826187059200', '25938183673872615', 'RESOURCE', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826191253504', '130', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826195447808', '131', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826199642112', '132', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826203836416', '50', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826203836417', '20', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826216419328', '120', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826216419329', '152', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826224807936', '121', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826224807937', '153', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826229002240', '122', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826233196544', '154', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826233196545', '123', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826237390848', '155', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826241585152', '156', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826241585153', '157', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486319826245779456', '30', 'MENU', '4', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486321523068239872', '132', 'MENU', '0', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486321523076628480', '1486201050779090944', 'MENU', '0', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1486321523085017088', '30', 'MENU', '0', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1533464117128462336', '1486201491877265408', 'MENU', '1486215142227050496', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1533464117132656640', '131', 'MENU', '1486215142227050496', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1533464117132656641', '1486620477806870528', 'MENU', '1486215142227050496', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1533464117136850944', '132', 'MENU', '1486215142227050496', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('1533464117136850945', '30', 'MENU', '1486215142227050496', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645921', '1', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645922', '25938183673872761', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645923', '25938183673872506', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645924', '2', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645925', '26578833880645906', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645926', '3', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645927', '25938183673872891', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645928', '4', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645929', '5', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645930', '6', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645931', '7', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645932', '25938183673872496', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645933', '8', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645934', '9', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645935', '25938183673872881', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645936', '10', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645937', '25938183673872627', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645938', '25938183673872756', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645939', '25938183673872501', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645940', '25938183673872886', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645941', '26578833880645891', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645942', '25938183673872746', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645943', '25938183673872491', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645944', '25938183673872876', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645945', '25938183673872622', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645946', '25938183673872751', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645947', '25938183673872736', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645948', '25938183673872864', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645949', '26578833880645896', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645950', '25938183673872610', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645951', '26578833880645901', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645952', '25938183673872484', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645953', '25938183673872741', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645954', '25938183673872869', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645955', '25938183673872615', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645956', '25938183673872472', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645957', '25938183673872601', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645958', '25938183673872857', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645959', '25938183673872477', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645960', '25938183673872850', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645961', '25938183673872467', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645962', '25938183673872723', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645963', '25938183673872596', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645964', '25938183673872584', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645965', '25938183673872713', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645966', '25938183673872843', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645967', '25938183673872460', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645968', '25938183673872589', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645969', '25938183673872718', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645970', '25938183673872450', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645971', '25938183673872579', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645972', '25938183673872708', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645973', '25938183673872838', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645974', '25938183673872455', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645975', '25938183673872440', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645976', '25938183673872569', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645977', '25938183673872827', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645978', '25938183673872445', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645979', '25938183673872574', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645980', '25938183673872703', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645981', '25938183673872689', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645982', '25938183673872817', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645983', '25938183673872562', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645984', '25938183673872694', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645985', '25938183673872822', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645986', '25938183673872552', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645987', '25938183673872684', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645988', '25938183673872812', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645989', '25938183673872557', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645990', '25938183673872672', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645991', '25938183673872800', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645992', '25938183673872547', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645993', '25938183673872805', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645994', '25938183673872679', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645995', '25938183673872537', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645996', '25938183673872667', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645997', '25938183673872795', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645998', '25938183673872542', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880645999', '25938183673872528', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646000', '25938183673872657', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646001', '25938183673872662', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646002', '25938183673872790', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646003', '25938183673872778', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646004', '25938183673872523', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646005', '25938183673872783', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646006', '25938183673872768', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646007', '25938183673872513', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646008', '25938183673872773', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646009', '25938183673872518', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646010', '25938183673872646', 'RESOURCE', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646011', '130', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646012', '131', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646013', '132', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646014', '10', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646015', '140', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646016', '141', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646017', '142', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646018', '143', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646019', '20', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646020', '150', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646021', '151', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646022', '152', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646023', '153', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646024', '154', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646025', '155', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646026', '156', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646027', '157', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646028', '30', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646029', '160', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646030', '161', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646031', '162', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646032', '163', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646033', '164', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646034', '165', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646035', '166', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646036', '167', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646037', '40', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646038', '168', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646039', '50', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646040', '180', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646041', '181', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646042', '60', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646043', '190', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646044', '191', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646045', '192', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646046', '193', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646047', '194', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646048', '195', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646049', '196', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646050', '197', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646051', '70', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646052', '80', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646053', '210', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646054', '211', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646055', '212', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646056', '213', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646057', '214', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646058', '215', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646059', '90', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646060', '220', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646061', '221', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646062', '222', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646063', '223', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646064', '224', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646065', '100', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646066', '110', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646067', '111', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646068', '112', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646069', '120', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646070', '121', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646071', '122', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('26578833880646072', '123', 'MENU', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633784', '25938183673872761', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633785', '1', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633786', '2', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633787', '25938183673872506', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633788', '25938183673872891', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633789', '3', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633790', '4', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633791', '5', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
INSERT INTO "LAMP_BASE_0000"."C_ROLE_AUTHORITY" VALUES ('28369762228633792', '6', 'RESOURCE', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2');
COMMIT;

-- ----------------------------
-- Table structure for C_ROLE_ORG
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_ROLE_ORG";
CREATE TABLE "LAMP_BASE_0000"."C_ROLE_ORG" (
  "ID" NUMBER(20) NOT NULL ,
  "ROLE_ID" NUMBER(20) NOT NULL ,
  "ORG_ID" NUMBER(20) NOT NULL ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_ORG"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_ORG"."ROLE_ID" IS '角色;#c_role';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_ORG"."ORG_ID" IS '部门;#c_org';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_ORG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_ROLE_ORG"."CREATED_BY" IS '创建人';
COMMENT ON TABLE "LAMP_BASE_0000"."C_ROLE_ORG" IS '角色组织关系';

-- ----------------------------
-- Table structure for C_STATION
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_STATION";
CREATE TABLE "LAMP_BASE_0000"."C_STATION" (
  "ID" NUMBER(20) NOT NULL ,
  "NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "ORG_ID" NUMBER(20) ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "DESCRIBE_" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "CREATED_ORG_ID" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."NAME" IS '名称';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."ORG_ID" IS '组织;#c_org;@Echo(api = ORG_ID_CLASS,  beanClass = Org.class)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."DESCRIBE_" IS '描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."CREATED_BY" IS '创建人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."UPDATED_BY" IS '修改人';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_STATION"."CREATED_ORG_ID" IS '创建者所属机构';
COMMENT ON TABLE "LAMP_BASE_0000"."C_STATION" IS '岗位';

-- ----------------------------
-- Table structure for C_USER
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_USER";
CREATE TABLE "LAMP_BASE_0000"."C_USER" (
  "ID" NUMBER(20) NOT NULL ,
  "ACCOUNT" VARCHAR2(30 BYTE) NOT NULL ,
  "NAME" VARCHAR2(50 BYTE) NOT NULL ,
  "ORG_ID" NUMBER(20) ,
  "STATION_ID" NUMBER(20) ,
  "READONLY" NUMBER(1) DEFAULT 0  NOT NULL ,
  "EMAIL" VARCHAR2(255 BYTE) ,
  "MOBILE" VARCHAR2(20 BYTE) ,
  "SEX" VARCHAR2(1 BYTE) DEFAULT 'M' ,
  "STATE" NUMBER(1) DEFAULT 1 ,
  "AVATAR" VARCHAR2(255 BYTE) ,
  "NATION" CHAR(2 BYTE) ,
  "EDUCATION" CHAR(2 BYTE) ,
  "POSITION_STATUS" CHAR(2 BYTE) ,
  "WORK_DESCRIBE" VARCHAR2(255 BYTE) ,
  "PASSWORD_ERROR_LAST_TIME" DATE ,
  "PASSWORD_ERROR_NUM" NUMBER(10) DEFAULT 0 ,
  "PASSWORD_EXPIRE_TIME" DATE ,
  "PASSWORD" VARCHAR2(64 BYTE) NOT NULL ,
  "SALT" VARCHAR2(20 BYTE) NOT NULL ,
  "LAST_LOGIN_TIME" DATE ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE ,
  "UPDATED_BY" NUMBER(20) ,
  "UPDATE_TIME" DATE ,
  "CREATED_ORG_ID" NUMBER(20)
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."ACCOUNT" IS '账号';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."NAME" IS '姓名';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."ORG_ID" IS '组织;#c_org;@Echo(api = ORG_ID_CLASS,  beanClass = Org.class)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."STATION_ID" IS '岗位;#c_station;@Echo(api = STATION_ID_CLASS)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."READONLY" IS '内置';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."EMAIL" IS '邮箱';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."MOBILE" IS '手机';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."SEX" IS '性别;
#Sex{W:女;M:男;N:未知}';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."STATE" IS '状态';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."AVATAR" IS '头像';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."NATION" IS '民族;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.NATION)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."EDUCATION" IS '学历;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.EDUCATION)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."POSITION_STATUS" IS '职位状态;
@Echo(api = DICTIONARY_ITEM_CLASS,  dictType = EchoDictType.POSITION_STATUS)';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."WORK_DESCRIBE" IS '工作描述';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."PASSWORD_ERROR_LAST_TIME" IS '最后一次输错密码时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."PASSWORD_ERROR_NUM" IS '密码错误次数';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."PASSWORD_EXPIRE_TIME" IS '密码过期时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."PASSWORD" IS '密码';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."SALT" IS '密码盐';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."LAST_LOGIN_TIME" IS '最后登录时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."CREATED_BY" IS '创建人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."UPDATED_BY" IS '更新人id';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER"."CREATED_ORG_ID" IS '创建者所属机构';
COMMENT ON TABLE "LAMP_BASE_0000"."C_USER" IS '用户';

-- ----------------------------
-- Records of C_USER
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('1', 'lampAdmin', '内置管理员', '1', '1', '1', '15217781234@qq.com', '15217781234', NULL, '1', '17e420c250804efe904a09a33796d5a10.jpg', '01', '01', '01', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', NULL, '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1');
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('2', 'lamp', '超级管理员', '1533406176778125312', '1', '0', '5', '3', NULL, '1', '20180414165815.jpg', '02', '04', '03', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', NULL, '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1');
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('3', 'lamp_pt', '平台管理员', '1', '1', '0', '2', '3', NULL, '1', 'a3b10296862e40edb811418d64455d00.jpeg', '05', '06', '02', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', NULL, '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1');
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('4', 'general', '普通管理员', '1415864608656195584', '1', '0', NULL, NULL, 'N', '1', NULL, '01', '01', '01', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', NULL, '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1');
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('5', 'normal', '普通用户', '1533438004188676096', '1', '0', NULL, NULL, 'M', '1', NULL, '02', '02', '02', '不想上班!', NULL, '0', NULL, '0d70cc96860681487869a0304139d3410044298da40fe5b2d7acff76f83d79c8', 'ki5pj8dv44i14yu4nbhh', NULL, '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1');
INSERT INTO "LAMP_BASE_0000"."C_USER" VALUES ('1555436685574012928', '3', '33', '1415864548283383808', '1555436596864483328', '0', NULL, NULL, 'M', '1', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '1b12ff98684867e1e36f68fbadc7ea16b1c0ea8bbf497fca20600f3f5fa695fc', 'wq47giqfr7r8x5bnowrn', NULL, '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '1533406176778125312');
COMMIT;

-- ----------------------------
-- Table structure for C_USER_ROLE
-- ----------------------------
DROP TABLE "LAMP_BASE_0000"."C_USER_ROLE";
CREATE TABLE "LAMP_BASE_0000"."C_USER_ROLE" (
  "ID" NUMBER(20) NOT NULL ,
  "ROLE_ID" NUMBER(20) NOT NULL ,
  "USER_ID" NUMBER(20) NOT NULL ,
  "CREATED_BY" NUMBER(20) ,
  "CREATE_TIME" DATE
)
TABLESPACE "USERS"
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER_ROLE"."ID" IS 'ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER_ROLE"."ROLE_ID" IS '角色;#c_role';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER_ROLE"."USER_ID" IS '用户;#c_user';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER_ROLE"."CREATED_BY" IS '创建人ID';
COMMENT ON COLUMN "LAMP_BASE_0000"."C_USER_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON TABLE "LAMP_BASE_0000"."C_USER_ROLE" IS '角色分配;账号角色绑定';

-- ----------------------------
-- Records of C_USER_ROLE
-- ----------------------------
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('1', '1', '1', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('2', '1', '2', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('3', '2', '3', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('4', '3', '4', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('5', '4', '5', '1', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
INSERT INTO "LAMP_BASE_0000"."C_USER_ROLE" VALUES ('1533405569933639680', '1486215142227050496', '2', '2', TO_DATE('2022-08-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'));
COMMIT;

-- ----------------------------
-- Primary Key structure for table C_APPENDIX
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014457" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_APPENDIX
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014452" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014453" CHECK ("BIZ_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014454" CHECK ("BIZ_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014455" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_APPENDIX" ADD CONSTRAINT "SYS_C0014456" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_APPLICATION
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_APPLICATION" ADD CONSTRAINT "SYS_C0014460" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_APPLICATION
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_APPLICATION" ADD CONSTRAINT "SYS_C0014458" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_APPLICATION" ADD CONSTRAINT "SYS_C0014459" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_APPLICATION
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_CLIENT_ID"
  ON "LAMP_BASE_0000"."C_APPLICATION" ("CLIENT_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_AREA
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_AREA" ADD CONSTRAINT "SYS_C0014464" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_AREA
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_AREA" ADD CONSTRAINT "SYS_C0014461" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_AREA" ADD CONSTRAINT "SYS_C0014462" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_AREA" ADD CONSTRAINT "SYS_C0014463" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_AREA
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_AREA_CODE"
  ON "LAMP_BASE_0000"."C_AREA" ("CODE" ASC) LOCAL
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_DICTIONARY
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014470" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_DICTIONARY
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014465" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014466" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014467" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014468" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_DICTIONARY" ADD CONSTRAINT "SYS_C0014469" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_DICTIONARY
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_TYPE_CODE"
  ON "LAMP_BASE_0000"."C_DICTIONARY" ("CODE" ASC, "TYPE" ASC) LOCAL
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_FILE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014477" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_FILE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014471" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014472" CHECK ("BIZ_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014473" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014474" CHECK ("CREATED_BY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014475" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_FILE" ADD CONSTRAINT "SYS_C0014476" CHECK ("UPDATED_BY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_LOGIN_LOG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_LOGIN_LOG" ADD CONSTRAINT "SYS_C0014479" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_LOGIN_LOG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_LOGIN_LOG" ADD CONSTRAINT "SYS_C0014478" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_MENU
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_MENU" ADD CONSTRAINT "SYS_C0014482" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_MENU
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_MENU" ADD CONSTRAINT "SYS_C0014480" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_MENU" ADD CONSTRAINT "SYS_C0014481" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_OPT_LOG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_OPT_LOG" ADD CONSTRAINT "SYS_C0014484" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_OPT_LOG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_OPT_LOG" ADD CONSTRAINT "SYS_C0014483" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_OPT_LOG_EXT
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_OPT_LOG_EXT" ADD CONSTRAINT "SYS_C0014486" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_OPT_LOG_EXT
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_OPT_LOG_EXT" ADD CONSTRAINT "SYS_C0014485" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table C_ORG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ORG" ADD CONSTRAINT "SYS_C0014489" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ORG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ORG" ADD CONSTRAINT "SYS_C0014487" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ORG" ADD CONSTRAINT "SYS_C0014488" CHECK ("LABEL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ORG
-- ----------------------------
CREATE INDEX "LAMP_BASE_0000"."FU_ORG_PATH"
  ON "LAMP_BASE_0000"."C_ORG" ("TREE_PATH" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_ORG_NAME"
  ON "LAMP_BASE_0000"."C_ORG" ("LABEL" ASC)
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_PARAMETER
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_PARAMETER" ADD CONSTRAINT "SYS_C0014494" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_PARAMETER
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_PARAMETER" ADD CONSTRAINT "SYS_C0014490" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_PARAMETER" ADD CONSTRAINT "SYS_C0014491" CHECK ("KEY_" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_PARAMETER" ADD CONSTRAINT "SYS_C0014492" CHECK ("VALUE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_PARAMETER" ADD CONSTRAINT "SYS_C0014493" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_PARAMETER
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_PARAM_KEY"
  ON "LAMP_BASE_0000"."C_PARAMETER" ("KEY_" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_RESOURCE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_RESOURCE" ADD CONSTRAINT "SYS_C0014497" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_RESOURCE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_RESOURCE" ADD CONSTRAINT "SYS_C0014495" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_RESOURCE" ADD CONSTRAINT "SYS_C0014496" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_RESOURCE
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_RES_CODE"
  ON "LAMP_BASE_0000"."C_RESOURCE" ("CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE" ADD CONSTRAINT "SYS_C0014500" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE" ADD CONSTRAINT "SYS_C0014498" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE" ADD CONSTRAINT "SYS_C0014499" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_ROLE_CODE"
  ON "LAMP_BASE_0000"."C_ROLE" ("CODE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE_AUTHORITY
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014505" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE_AUTHORITY
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014501" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014502" CHECK ("AUTHORITY_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014503" CHECK ("AUTHORITY_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ADD CONSTRAINT "SYS_C0014504" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE_AUTHORITY
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_ROLE_AUTHORITY"
  ON "LAMP_BASE_0000"."C_ROLE_AUTHORITY" ("AUTHORITY_ID" ASC, "ROLE_ID" ASC, "AUTHORITY_TYPE" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_ROLE_ORG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014509" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_ROLE_ORG
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014506" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014507" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_ROLE_ORG" ADD CONSTRAINT "SYS_C0014508" CHECK ("ORG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_ROLE_ORG
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_ROLE_ORG"
  ON "LAMP_BASE_0000"."C_ROLE_ORG" ("ROLE_ID" ASC, "ORG_ID" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_STATION
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_STATION" ADD CONSTRAINT "SYS_C0014512" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_STATION
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_STATION" ADD CONSTRAINT "SYS_C0014510" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_STATION" ADD CONSTRAINT "SYS_C0014511" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_STATION
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_STATION_NAME"
  ON "LAMP_BASE_0000"."C_STATION" ("NAME" ASC) LOCAL
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_USER
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014519" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_USER
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014513" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014514" CHECK ("ACCOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014515" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014516" CHECK ("READONLY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014517" CHECK ("PASSWORD" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER" ADD CONSTRAINT "SYS_C0014518" CHECK ("SALT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_USER
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_USER_ACCOUNT"
  ON "LAMP_BASE_0000"."C_USER" ("ACCOUNT" ASC)
  LOGGING
  TABLESPACE "USERS"
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table C_USER_ROLE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_USER_ROLE" ADD CONSTRAINT "SYS_C0014523" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table C_USER_ROLE
-- ----------------------------
ALTER TABLE "LAMP_BASE_0000"."C_USER_ROLE" ADD CONSTRAINT "SYS_C0014520" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER_ROLE" ADD CONSTRAINT "SYS_C0014521" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "LAMP_BASE_0000"."C_USER_ROLE" ADD CONSTRAINT "SYS_C0014522" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table C_USER_ROLE
-- ----------------------------
CREATE UNIQUE INDEX "LAMP_BASE_0000"."UK_USER_ROLE"
  ON "LAMP_BASE_0000"."C_USER_ROLE" ("USER_ID" ASC, "ROLE_ID" ASC) LOCAL
  LOGGING
  ONLINE
  TABLESPACE "USERS"
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536
  NEXT 1048576
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
