# 使用docker运行项目

## 1，验证docker安装是否成功
```
docker version

Client: Docker Engine - Community
 Version:           18.09.0
 API version:       1.39
 Go version:        go1.10.4
 Git commit:        4d60db4
 Built:             Wed Nov  7 00:46:51 2018
 OS/Arch:           linux/amd64
 Experimental:      false

Server: Docker Engine - Community
 Engine:
  Version:          18.09.0
  API version:      1.39 (minimum version 1.12)
  Go version:       go1.10.4
  Git commit:       4d60db4
  Built:            Wed Nov  7 00:52:55 2018
  OS/Arch:          linux/amd64
  Experimental:     false
```

2-5 步骤可以根据自己的需求忽略，若已经有现成的中间件，直接跳到第6步

## 2.0 初始化路径: （可选）
```
mkdir -p /data/dockerfile/
mkdir -p /data/docker-data/mysql-data/
mkdir -p /data/docker-data/redis-data/
mkdir -p /data/docker-data/rabbitmq-data/
```
将 docs/dockerfile/* 下的所有文件 复制到 /data/dockerfile/

## 2，使用docker启动 mysql （可选）
- vim start.sh 修改数据库密码，端口，数据存放路径
```
    -v /data/docker-data/mysql-data/:/var/lib/mysql \   # /data/docker-data/mysql-data/ 路径修改成宿主机的路径
    -p 3218:3306 \                                      # 3218 外部访问的端口
    -e MYSQL_ROOT_PASSWORD="root" \                     # 数据库访问密码
```
- 启动
```
cd /data/dockerfile/mysql
./start.sh
``` 

## 3，使用docker启动 redis（可选）
- 生产使用的redis，强烈建议将 密码和默认端口 修改了， 否则非常容易被挖矿
- vim start.sh 修改 dump.rdb 文件的存放路径
```
    -v /data/docker-data/redis-data/:/data               #  /data/docker-data/redis-data/ 路径修改成宿主机的路径
```
- vim start.sh 修改redis.conf 
```
port 16379                                               # redis 端口
requirepass SbtyMveYNfLzTks7H0apCmyStPzWJqjy             # redis 密码
```
- 启动
```
cd /data/dockerfile/redis
./start.sh
``` 

## 4，使用docker启动 rabbitmq（可选）
- 修改 初始密码账号、路径
```
-e RABBITMQ_DEFAULT_USER=zuihou -e RABBITMQ_DEFAULT_PASS=zuihou \       # 账号密码    
    -v /data/docker-data/rabbitmq-data/:/var/rabbitmq/lib \             #  /data/docker-data/rabbitmq-data/ 路径修改成宿主机的路径
```
- 启动
```
cd /data/dockerfile/rabbitmq
./start.sh
``` 
## 5，使用docker启动 nginx （可选）
- vim start.sh 修改端口号和 宿主机路径
```
-p 10000:10000                                           # 修改外部访问的端口
-v /data/docker-data/projects/:/projects \               # /data/docker-data/projects/ 修改静态资源的路径
```
- 将 zuihou.conf 文件中的所有 localhost 替换成宿主机的内网ip。 如： 192.168.1.1
- 启动
```
cd /data/dockerfile/nginx
./start.sh
``` 
## 6，将jar制作成镜像
```
1, 先到项目`跟目录`将整个项目编译一次： clean install -DskipTests=true -T8 -f pom.xml

cd zuihou-backend/zuihou-authority/zuihou-authority-server
docker build --build-arg JAR_FILE=target/zuihou-authority-server.jar -t zuihou-authority-server:v1 .

cd zuihou-backend/zuihou-msgs/zuihou-msgs-server
docker build -t zuihou-msgs-server:v1 .

cd zuihou-backend/zuihou-file/zuihou-file-server
docker build -t zuihou-file-server:v1 .

cd zuihou-backend/zuihou-gateway/zuihou-zuul-server
docker build -t zuihou-zuul-server:v1 .

cd zuihou-backend/zuihou-jobs/zuihou-jobs-server
docker build -t zuihou-jobs-server:v1 .
```

## 7，使用docker启动项目
```
1, 确保： nacos mysql redis 全部启动， 并且nacos 里面的redis mysql 等ip改成自己的ip （切记，使用docker时，所有的IP都不能为127.0.0.1）
2, 在nacos 里面新建  zuihou-authority-server-docker.yml ,并将所有zuihou-authority-server-dev.yml 里面的配置复制过去，修改docker环境和dev环境的差异部分部分。

docker run -idt  --name zuihou-authority-server --restart=always \
        -e NACOS_IP=192.168.1.34 \
        -e NACOS_PORT=8848 \
        -e LOCAL_IP=192.168.1.34 \
        -e NACOS_ID=b16f7baf-56e7-4f4e-a26c-425ee0668016 \
        -p 8764:8764 \
        -v /data/:/data \
        zuihou-authority-server:v1 

docker run -idt  --name zuihou-zuul-server --restart=always \
        -e NACOS_IP=192.168.1.34 \
        -e NACOS_PORT=8848 \
        -e LOCAL_IP=192.168.1.34 \
        -e NACOS_ID=b16f7baf-56e7-4f4e-a26c-425ee0668016 \
        -p 8760:8760 \
        -v /data/:/data \
        zuihou-zuul-server:v1 

docker run -idt  --name zuihou-msgs-server --restart=always \
        -e NACOS_IP=192.168.1.34 \
        -e NACOS_PORT=8848 \
        -e LOCAL_IP=192.168.1.34 \
        -e NACOS_ID=b16f7baf-56e7-4f4e-a26c-425ee0668016 \
        -p 8768:8768 \
        -v /data/:/data \
        zuihou-msgs-server:v1 

docker run -idt  --name zuihou-file-server --restart=always \
        -e NACOS_IP=192.168.1.34 \
        -e NACOS_PORT=8848 \
        -e LOCAL_IP=192.168.1.34 \
        -e NACOS_ID=b16f7baf-56e7-4f4e-a26c-425ee0668016 \
        -p 8765:8765 \
        -v /data/:/data \
        zuihou-file-server:v1 

docker run -idt  --name zuihou-jobs-server --restart=always \
        -e MYSQL_IP=192.168.1.34 \
        -p 8767:8767 \
        -v /data/:/data \
        zuihou-jobs-server:v1 

```

## 8， docker 启动nacos ，连接自己的数据库
      - PREFER_HOST_MODE=hostname
      - MODE=standalone
      - SPRING_DATASOURCE_PLATFORM=mysql
      - MYSQL_MASTER_SERVICE_HOST=mysql-master
      - MYSQL_MASTER_SERVICE_DB_NAME=nacos_devtest
      - MYSQL_MASTER_SERVICE_PORT=3306
      - MYSQL_SLAVE_SERVICE_HOST=mysql-slave
      - MYSQL_SLAVE_SERVICE_PORT=3305
      - MYSQL_MASTER_SERVICE_USER=nacos
      - MYSQL_MASTER_SERVICE_PASSWORD=nacos
      
docker run -idt  --name zuihou-nacos --restart=always \
        -e JVM_XMS=512m -e JVM_XMX=512m -e JVM_XMN=384m \
        -e PREFER_HOST_MODE=hostname -e MODE=standalone -e SPRING_DATASOURCE_PLATFORM=mysql \ 
        -e MYSQL_DATABASE_NUM=1 \
        -e MYSQL_MASTER_SERVICE_HOST=192.168.0.33 -e MYSQL_MASTER_SERVICE_DB_NAME=nacos_test -e MYSQL_MASTER_SERVICE_PORT=3306 \
        -e MYSQL_MASTER_SERVICE_USER=root -e MYSQL_MASTER_SERVICE_PASSWORD=r!o@o#t$>?.123 \
        -p 8848:8848 \
        -v ./standalone-logs/:/home/nacos/logs \
        -v ./init.d/custom.properties:/home/nacos/init.d/custom.properties \
        nacos/nacos-server:1.1.3
        







