import './globals.css'

import {
  ClerkProvider,
  SignIn,
  SignInButton,
  SignedIn,
  SignedOut,
  UserButton,
} from '@clerk/nextjs'
import { Inter, Outfit } from 'next/font/google'

import { Container } from '@/components/atoms/container'
import type { Metadata } from 'next'
import { Navbar } from '@/components/organisms/Navbar'
import React from 'react'
import { SonnerToaster } from '@/components/molecules/Toaster/SonnerToaster'
import { TRPCReactProvider } from '@/trpc/clients/client'
import { Toaster } from '@/components/molecules/Toaster/Toaster'
import { cn } from '@/utils/styles'
import { dark } from '@clerk/themes'

const inter = Outfit({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'nexusxai',
  description: 'Generated by create next app',
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <ClerkProvider
      appearance={{
        baseTheme: dark,
      }}
    >
      <TRPCReactProvider>
        <html lang="en">
          <body className={cn(inter.className, 'bg-white')}>
            <Navbar />
            <Container>{children}</Container>
            <Toaster />
            <SonnerToaster />
          </body>
        </html>
      </TRPCReactProvider>
    </ClerkProvider>
  )
}
