//eslint-disable-next-line
import { DefaultTheme } from 'styled-components'
import defaultBgImage from 'assets/backgrounds/main-bg.jpg'
import defaultBgImageSecondary from 'assets/backgrounds/main_bg_secondary.jpeg'

const darkTheme: DefaultTheme = {
  body: {
    backgroundImage: defaultBgImage,
    backgroundColorPrimary:
      'linear-gradient(265.15deg, rgba(76, 166, 248, 1) -32.37%, rgba(33, 82, 243, 1) 100%)',
    boxShadow: '0px 4px 40px rgba(0, 0, 0, 0.8)',
    backgroundColorSecondary: 'rgba(0, 0, 0, 0.2)',
    backdropFilter: 'blur(100px)',
    textColorPrimary: 'rgba(255, 255, 255)',
    textColorSecondary: 'rgba(255,255,255, 0.8)',
    textColorTertiary: '#000',
    border: 'none',
    backgroundImageSecondary: defaultBgImageSecondary,
    testVariableColor: 'var(--color-brand-blue)',
    iconColor: 'rgb(255, 255, 255)',
    mainNavColorActive: 'var(--content-content-primary, #FFF)',
    mainNavColor: 'var(--content-content-tertiary, rgba(255, 255, 255, 0.6))',
    breadCrumbsColor: 'rgba(255, 255, 255, 0.80)',
    breadCrumbsBg: 'rgba(255, 255, 255, 0.1)',
    commandBorderColor: ' 1px solid var(--basic-foreground-white-2, rgba(255, 255, 255, 0.2))',
    placeHolderColor: 'rgba(255, 255, 255, 0.4)',
    cardBgColor: 'rgba(0, 0, 0, 0.2)',
    secondaryBorder: 'none',
    humanMessageBgColor: 'var(--basic-foreground-white-1, rgba(255, 255, 255, 0.1))',
    replyBoxBgColor: 'rgba(0, 0, 0, 0.4)',
    secondaryIconColor: 'rgb(255, 255, 255)',
    tertiaryIconColor: 'rgb(130,130,130)',
    avatarDropDownColor:
      'linear-gradient(0deg, rgba(255, 255, 255, 0.10) 0%, rgba(255, 255, 255, 0.10) 100%), linear-gradient(225deg, rgba(76, 166, 248, 0.10) 0%, rgba(33, 82, 243, 0.10) 100%);',
    detailCardBackgroundColor: 'rgba(0, 0, 0, 0.2)',
    toolkitCardBgColorPrimary: 'linear-gradient(180deg, #000000 0%, rgba(0, 0, 0, 0.4) 100%)',
    toolkitCardBgColorSecondary: 'rgba(0, 0, 0, 0.8)',
    toolkitCardBgColorTertiary: '#000',
    teamChatCardSelectedColor: 'rgba(250, 250, 250, 0.3)',
    componentsWrapperBg: 'rgba(255, 255, 255, 0.1)',
    componentsSecondaryWrapperBg: 'rgba(255, 255, 255, 0.1)',
    textareaBorder: 'none',
    textAreaBgColor: 'rgba(255, 255, 255, 0.2)',
    dropdownBgColor: 'transparent',
    dataLoaderCardBorder: '#48ecf0',
    tableBackgroundColor: 'rgba(0, 0, 0, 0.1)',
    sliderBackgroundColor: 'var(--color-transparent-white-01)',
    dropdownSecondaryBgColor: 'rgba(0, 0, 0, 0.7)',
    commandMenuBackgroundColor: ' var(--basic-foreground-black-1, rgba(0, 0, 0, 0.1))',
    warningToastTextColor: 'rgb(110,110,110)',
    sessionDropdownBorder: 'none',
    tagColor: 'gradient_blue',
  },
  typography: {
    contentPrimary: '#FFF',
    contentSecondary: 'rgba(255, 255, 255, 0.8)',
    contentTertiary: 'rgba(255, 255, 255, 0.6)',
    contentQuaternary: 'rgba(255, 255, 255, 0.4)',
  },
  heading: {
    contentPrimary: '#FFF',
    contentSecondary: 'rgba(255, 255, 255, 0.9)',
    contentTertiary: 'rgba(255, 255, 255, 0.4)',
  },
  button: {
    primary: {
      color: '#fff',
      bgColor: '#111',
      hoverBgColor: 'rgba(0, 0, 0, 0.5)',
      pressedBgColor: 'rgba(0, 0, 0, 0.7)',
      pressedBorderColor: 'rgba(0, 0, 0, 0.2)',
    },
    secondary: {
      color: 'rgba(0, 0, 0, 0.7)',
      bgColor: 'rgba(255, 255, 255, 0.6)',
      hoverBgColor: 'rgba(255, 255, 255, 0.3)',
      pressedBgColor: 'rgba(255, 255, 255, 0.6)',
      pressedBorderColor: 'rgba(255, 255, 255, 0.2)',
    },
    tertiary: {
      color: '#fff',
      bgColor: 'transparent',
      hoverBgColor: 'rgba(255, 255, 255, 0.2)',
      pressedBgColor: 'rgba(255, 255, 255, 0.2)',
      pressedBorderColor: 'rgba(255, 255, 255, 0.1)',
    },
  },
  textFiled: {
    primary: {
      bgColor: 'rgba(255, 255, 255, 0.3)',
      color: '#fff',
      borderColor: 'transparent',
      activeBoxShadow: '0px 2px 4px 0px rgba(0, 0, 0, 0.25)',
      activeBorderColor: 'rgba(0, 0, 0, 0.2)',
      activeBgColor: 'rgba(255, 255, 255, 0.3)',
      errorBorderColor: '#e44258',
      errorColor: '#e44258',
    },
  },
  tabs: {
    color: 'rgba(255, 255, 255, 0.6)',
    hoverBgColor: 'rgba(0, 0, 0, 0.2)',
    activeColor: '#fff',
    activeBgColor: 'rgba(0, 0, 0, 0.5)',
    borderColor: 'Transparent',
  },
}

const lightTheme: DefaultTheme = {
  body: {
    backgroundImage: defaultBgImage,
    backgroundColorPrimary: 'rgb(253,252,250)',
    backgroundColorSecondary: 'rgb(255, 255, 255)',
    boxShadow: '0px 4px 40px rgba(0, 0, 0, 0.8)',
    backdropFilter: 'blur(50px);',
    textColorPrimary: 'rgb(0, 0, 0)',
    textColorSecondary: 'rgb(110,110,110)',
    textColorTertiary: 'rgb(255, 255, 255)',
    border: '1px solid #acacad',
    backgroundImageSecondary: defaultBgImageSecondary,
    testVariableColor: 'var(--color-highlight_blue)',
    iconColor: '#000',
    mainNavColorActive: 'rgb(80,80,80)',
    mainNavColor: 'rgb(193,193,193)',
    breadCrumbsColor: 'rgb(91,91,91)',
    breadCrumbsBg: 'rgb(253,252,250)',
    commandBorderColor: '1px solid rgb(126,126,126)',
    placeHolderColor: 'rgb(187,187,187)',
    cardBgColor: 'rgb(253,252,250)',
    secondaryBorder: '1px solid lightGray',
    tertiaryIconColor: 'rgb(130,130,130)',
    humanMessageBgColor: 'rgb(240,240,240)',
    replyBoxBgColor: 'rgb(194,194,194)',
    secondaryIconColor: 'rgb(255, 255, 255)',
    avatarDropDownColor: 'rgb(255, 255, 255)',
    detailCardBackgroundColor: 'rgba(0,0,0,0.2)',
    toolkitCardBgColorPrimary: 'rgb(253,252,250)',
    toolkitCardBgColorSecondary: 'rgb(253,252,250)',
    toolkitCardBgColorTertiary: '#f3f3f3',
    teamChatCardSelectedColor: 'rgb(217,217,217)',
    componentsWrapperBg: '#F5F5F7',
    componentsSecondaryWrapperBg: 'rgb(253,252,250)',
    textareaBorder: 'rgba(0, 0, 0, 0.1)',
    textAreaBgColor: 'rgba(255, 255, 255, 1)',
    dropdownBgColor: 'rgba(255, 255, 255, 1)',
    dataLoaderCardBorder: '#000',
    tableBackgroundColor: 'rgb(220,220,220)',
    sliderBackgroundColor: 'rgba(0, 0, 0, 0.1)',
    dropdownSecondaryBgColor: 'rgb(253,252,250)',
    commandMenuBackgroundColor: '#F5F5F7',
    warningToastTextColor: 'rgb(110,110,110)',
    sessionDropdownBorder: '2px solid #cccccc',
    tagColor: 'white',
  },
  typography: {
    contentPrimary: 'rgb(0,0,0)',
    contentSecondary: 'rgb(110,110,110)',
    contentTertiary: '#000000CC',
    contentQuaternary: 'rgb(189,189,189)',
  },
  heading: {
    contentPrimary: 'rgb(0,0,0)',
    contentSecondary: 'rgb(49,49,49)',
    contentTertiary: 'rgb(172,172, 173)',
  },
  button: {
    primary: {
      color: '#fff',
      bgColor: '#111',
      hoverBgColor: 'rgba(0, 0, 0, 0.5)',
      pressedBgColor: 'rgba(0, 0, 0, 0.7)',
      pressedBorderColor: 'rgba(0, 0, 0, 0.2)',
    },
    secondary: {
      color: '#000000CC',
      bgColor: '#F5F5F7',
      hoverBgColor: 'rgba(0, 0, 0, 0.2)',
      pressedBgColor: 'rgba(0, 0, 0, 0.7)',
      pressedBorderColor: '#000000',
    },
    tertiary: {
      color: 'rgba(0, 0, 0, 0.7)',
      bgColor: 'transparent',
      hoverBgColor: 'rgba(0, 0, 0, 0.1)',
      pressedBgColor: 'rgba(255, 255, 255, 0.2)',
      pressedBorderColor: 'rgba(255, 255, 255, 0.1)',
    },
  },
  textFiled: {
    primary: {
      bgColor: '#FFF',
      color: '#000',
      borderColor: 'rgba(0, 0, 0, 0.1)',
      activeBoxShadow: '0px 2px 4px 0px rgba(0, 0, 0, 0.25)',
      activeBorderColor: '#000',
      activeBgColor: 'rgba(255, 255, 255, 0.3)',
      errorBorderColor: '#ef5533',
      errorColor: '#ef5533',
    },
  },
  tabs: {
    color: '#0000004D',
    hoverBgColor: 'rgba(0, 0, 0, 0.2)',
    activeColor: '#000',
    activeBgColor: '#fff',
    borderColor: '#000',
  },
}

export { lightTheme, darkTheme }
