import GPTLogo from 'assets/models/openai.jpg'
import ClaudeLogo from 'assets/models/claude-ai-icon.webp'

export const SUBNETS = [
  {
    name: 'Subnet 18',
    logo: 'https://avatars.githubusercontent.com/u/135083020?s=48&v=4',
    apis: [
      {
        name: 'davinci-002',
        logo: GPTLogo,
        description: 'Replacement for the GPT-3 curie and davinci base models.',
      },
      {
        name: 'gpt-4-1106-preview',
        logo: GPTLogo,
        description:
          'GPT-4 Turbo preview model featuring improved instruction following, JSON mode, reproducible outputs, parallel function calling, and more. Returns a maximum of 4,096 output tokens. This is a preview model.',
      },
      {
        name: 'gpt-4-turbo-preview',
        logo: GPTLogo,
        description: 'GPT-4 Turbo preview model. Currently points to gpt-4-0125-preview.',
      },
      {
        name: 'gpt-4-0125-preview',
        logo: GPTLogo,
        description:
          'GPT-4 Turbo preview model intended to reduce cases of “laziness” where the model doesn’t complete a task. Returns a maximum of 4,096 output tokens.',
      },
      {
        name: 'babbage-002',
        logo: GPTLogo,
        description: 'Replacement for the GPT-3 ada and babbage base models.',
      },
      { name: 'gpt-4', logo: GPTLogo, description: 'Currently points to gpt-4-0613.' },
      {
        name: 'gpt-4-0613',
        logo: GPTLogo,
        description:
          'Snapshot of gpt-4 from June 13th 2023 with improved function calling support.',
      },
      {
        name: 'gpt-3.5-turbo-16k',
        logo: GPTLogo,
        description: 'Currently points to gpt-3.5-turbo-16k-0613.',
      },
      {
        name: 'gpt-3.5-turbo-1106',
        logo: GPTLogo,
        description:
          'GPT-3.5 Turbo model with improved instruction following, JSON mode, reproducible outputs, parallel function calling, and more. Returns a maximum of 4,096 output tokens.',
      },
      {
        name: 'gpt-3.5-turbo-instruct',
        logo: GPTLogo,
        description:
          'Similar capabilities as GPT-3 era models. Compatible with legacy Completions endpoint and not Chat Completions.',
      },
      {
        name: 'gpt-3.5-turbo-0125',
        logo: GPTLogo,
        description:
          'The latest GPT-3.5 Turbo model with higher accuracy at responding in requested formats and a fix for a bug which caused a text encoding issue for non-English language function calls. Returns a maximum of 4,096 output tokens.',
      },
      {
        name: 'gpt-3.5-turbo',
        logo: GPTLogo,
        description: 'Currently points to gpt-3.5-turbo-0125.',
      },
      {
        name: 'gpt-4-turbo-2024-04-09',
        logo: GPTLogo,
        description:
          'GPT-4 Turbo with Vision model. Vision requests can now use JSON mode and function calling. gpt-4-turbo currently points to this version.',
      },
      {
        name: 'gpt-4-turbo',
        logo: GPTLogo,
        description:
          'The latest GPT-4 Turbo model with vision capabilities. Vision requests can now use JSON mode and function calling. Currently points to gpt-4-turbo-2024-04-09.',
      },
      {
        name: 'gpt-3.5-turbo-0613',
        logo: GPTLogo,
        description:
          'Snapshot of gpt-3.5-turbo from June 13th 2023. Will be deprecated on June 13, 2024.',
      },
      {
        name: 'gpt-4o',
        logo: GPTLogo,
        description:
          'Most advanced, multimodal flagship model that’s cheaper and faster than GPT-4 Turbo. Currently points to gpt-4o-2024-05-13.',
      },
      {
        name: 'gpt-4o-2024-05-13',
        logo: GPTLogo,
        description: 'gpt-4o currently points to this version.',
      },
      {
        name: 'claude-3-opus-20240229',
        logo: ClaudeLogo,
        description:
          "Claude's most powerful model, delivering state-of-the-art performance on highly complex tasks and demonstrating fluency and human-like understanding.",
      },
      {
        name: 'claude-3-sonnet-20240229',
        logo: ClaudeLogo,
        description:
          "Claude's most balanced model between intelligence and speed, a great choice for enterprise workloads and scaled AI deployments",
      },
      {
        name: 'claude-3-haiku-20240307',
        logo: ClaudeLogo,
        description:
          "Claude's fastest and most compact model, designed for near-instant responsiveness and seamless AI experiences that mimic human interactions",
      },
    ],
  },
  {
    name: 'Subnet 22',
    logo: 'https://avatars.githubusercontent.com/u/128653940?s=48&v=4',
    apis: [
      {
        name: 'Twitter Search',
        logo: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMwAAADACAMAAAB/Pny7AAAAaVBMVEUAAAD////8/PwEBATr6+siIiKqqqr5+flYWFji4uKfn5/x8fH29vaxsbHf398cHByMjIzExMTY2NhEREQwMDDOzs6GhoZTU1MqKipmZmY/Pz9hYWEVFRWTk5M5OTm8vLxvb293d3dLS0ueSXRsAAAJ2klEQVR4nO1cC3eqMAxuKVrloYKKrynq//+Rax5IcQ5RN6nn9LvnbLuINaFNmnxNFMLDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8PDw8Pjb6H6FuABdJD1NXXUXwzS9bPufYp6RRB1889/gxLrQSteHH/6R+N0RJEO27B4afB5RKOkmz+Stg1m8k+JbEP69ewKMSt4m/Eok/Pfyv0rZjoIfldGz54c1jyCdSYDHHt5fo/NKDFIZZs2492TI4upGVjDyPnqXQ5AiPNSojJGpYB+MfCxBsv5w6IodJIpDGhGmDz5OJ7DMWTZr2clCLT58bjZoDKRpsczPv6L0L9ir0n0ZDIZWwilhsmJZ49PjdElMZqYccPT/8j86ycPSlpUyb75Skrrb/yEY91rWqSgy5tDonluPtf8C4+Ny185qBjIx81mFtM73zwvAGXMhiwGxL5cVWIVkxcYDrorAwHQKUQLDOL9/fv/Gubz9wm5suG6cbkIUJukEI/MjdEFldE96AJAszGIZ1/1RYVmg8uls3s17zmO6U1B1E8KocQhp6cJ1m7F7Ycl7TfLQ2e5NpUuw57SIWMfuwRk0Ci2JcMuJG1SkOyObHjDaox+Hg2tJ4DZSDSQIG2IrIqY1n/RIfsxWE3I+GT6WsD9AmDPnpYcwdibpNmEhhJjrHjVZdHgaoWpKbf/KW874KFvebFr2z6UmC9xymTeYdmslxxcPhHR/TF2Mc3NGMSo19RmTJFa2iKfwvwa3AWuMXu/6gXGfGcBBgIya9qH2c8BSWtuY+5fVMlY/q5krE2cRUpBWnAVW6ac27QEaaBLynG3CfpdoKjOS9ptwk1Dm/ny7upRYj2k/EVONp383v8Doqo6SCORjGQj2m0g2vkpJtFR00hTUgQJjBO6iK8oYWtf15GAAqZAUm5zI1NT4NhVFNPsxacq1ewbClgIkmmmamXqIG08uvEm1JZZnqRwRReYhPOEcptGumt8Q067zXIhrlcRiE5xAsfXriwzCHo12fGyuYePYBMyZjH88eTN/4qE5jPYfwmHAOm7xE1cDqeNy4UkuuX4M0jbxLzBRAPhyrQIFpO5J1k0XpoOmY86XGuzYReI6jtiMAAUZB2yE6itHSSk3EbLyZVH242ZeEsH7NrcgZFlk1CQZmJLW7ZdSFaeCnsCVjknMOWC3+4QYNPYY5CmZTO2VDOMRJGAvlxecXAZZL0lMHewLuFRG7mbQdogJZbdyq1XVXCJQb9b0wIAiVY5JWqW2YCo84oS2LIy80xaJJWDymA2QEEaMhnWZeKlzULjaGdRInEQVCcwLiojMEjD1AZclC3iPmBKCqKdrxK5Pi3HKzdnhWDilyyQP3hzI3+V2wCTlkqaPojY7nI3/UERzwLaXKVaA6aSjPMaMgOC2Y9b+8sPnOLaT1m5zYH8nBwOeY3Fxz6l7IqIz59q3hzzsCpIw2nhBKZfQTuB9pAgKWqjodyGdiFchXio4/YSEyjggu0jrJgM5KDEYskEm1ljoIvDtl8BJuGYMCWwbSwl4sY1JGMR5Qmua0PHrMy2pk3/PONIVNs5j9NQVJggObex7Eash5CO6iB5Rx3JX4A2DgrwJfDm9gtzMht3Q+XbwCDtJ2+OZiPxAOSlMq53wthHBFaj6bjJEnpP3FL82HFn3zhkzCLZvLkRv6RNczL6gG2GAPbBeXEQ2tauoEoA44Bs+zlTAyRTSExGvhW23COuEoierknrBcSJU25jLanCYmR7lO5BmNwGY864aEYuXDwwuUFAuwoioNE/TzaNSGDBLNNy3fZ+pwAL66QxpURrt7BjpqCv+oUnMWTWclgz4yB+odFt69OnuGcBck85SNOFfVWsU1p/4Qf5Z1G5LpNYXhYahjF4CmpeyD5GFSPoXFclnJN6DuD3EWM3KmH6AIVAxpWuC1KbuQ0cAILdUE3aB6gjRiFW0l5ym0amVmIODUTgR5jNaCw540Rrj5sp2XZ5YXI/YGZWHFImeUjqWMedID6cnAEnEDmeQ8OTPme0jnQ5jxLMyPQVAT3TOHGhMyUAtwG9FiUeygSw+y9KjVNjVQkguEoAq/4dVkYs4IAJJM3msK3kXBRvmY2iKgG8Z+0oiUYyTVMqNMFkBoK0hNbcVU3QKpY4f5Fyc2pUTcVCnUnFnu/ZP2M9aS14Qe4uODqqDIg+5BOY8FBdFBkRzRpzm4vg05RvdDMbYEITvXJYlVzCj7pKQFl754JOnWXem8B3sK9Ok+CY7HJAs9EB9mDki8aSGo255KQfWdugsGQzQKu+at6ozjVlKWwCECqg0dWdXPPPoEvB7EtYXIk2LTkdqIM05KVTOgWduBakmfjxxMUl4Wx6/dqZc//40u+Arm+eUdtadrgerldAIQCRyTLeX9NiqmoqCYhJw2vox+ncBg86HNk7SYjjhHS5ET0qqC5NKCW7DtKocSB0p7YRsMv5FPaX06QFU2Z0CsjAKgEKF0YO+YBzzhv/r32NUFwjr4M04wSolDMoF24sMyihnVAeBs73Rukv/jzFnJLVBAdMxjlwhoBWaLeDXHIQ3HZvpKkaAKoELLlP5OiSY2MT6gXYbZHzNrL8vRQWtM5I46RZyom5jdYQmfbu0ZTVLN7SZwZLajvm7s7muc2aU55s0L8261JyxtLWN0LbClczW7kNXB7xDgVBWl/KKEWH4lRmJvP2bkY0k4jay9DnqUtUDVUC8ILusVsDjX/NjQ10eHFPlGlGjviquw4eCNakvedLDW5DiUHEK2d8ogvtt0NNGhpY2Nwk55zbZP11N5oNfM99I+Gxg+3CDSeMXzRWQFsvcZuajvqYGapWwowEe+k7l5B9RTUBbY+2p9gtPPWw0Di45DUmH+DAD9a5TfUWmOMUv+UBmLQetAFPG3B/wkl01kWJ3YS0sXu5KUiD7Fr2VFwzqk4t9pWb7gCFfUA4oXmzAvpMffR6//aZUUjj4f6iea/rKAPQUZprgqb1E1B43IlHBifx9r1zxdwKZYndAdwsF9c0COgLf9gDAV2VlUFd/CM5oqril6pKwMKA29TKW/2Q/4hV9UU65eGxcmu69USO+AcBTec2wf5964xpFaxayJ7pG0EWFwk2nUUN5PSI8KTtPRE06kJe+blmcUjnuDhY6gYSZgvHi3cpU7Vn3wn6fwdM5ZwJwwYCvhQw9/kGDJhRkZPDc88PbexYlaDTWPxHUCn1DrNR3LGI9OTTPCQmMUP5EzxXcLb7hoYBJaZVpAjfkfHKdnCpgL4NoAT+fW6KJCTsXmuBgVLOsA3pGxqFR7vRaGV+YP/bC+MYY9uOWrAZPfB9T89K8K/jX3+ah4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4fH5+IbiYhbRutxSIMAAAAASUVORK5CYII=',
        description:
          'Provides access to the latest Twitter posts, allowing users to stay updated with recent tweets.',
      },
      {
        name: 'Google Search',
        logo: 'data:image/png;base64,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',
        description:
          "Enables web searching using Google's powerful search engine to find a wide range of information online.",
      },
      {
        name: 'Writing',
        logo: 'data:image/png;base64,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',
        description:
          'Offers a focused chat interface without web search capabilities, ideal for distraction-free writing.',
      },
      {
        name: 'Discord Search',
        logo: 'data:image/png;base64,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',
        description:
          'Allows users to search through Discord Bittensor channels for specific discussions and content.',
      },
      {
        name: 'Bittensor Docs',
        logo: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAAAflBMVEUdHR3///8AAAAaGhqurq4wMDDX19f09PQYGBiVlZUhISHr6+sWFhYNDQ0ZGRn39/c8PDx9fX3Q0NBWVlZNTU01NTW2tracnJxCQkImJibv7+9fX19ra2vk5OTAwMARERF1dXWHh4eNjY1kZGSWlpalpaXIyMg/Pz/U1NRISEiGQfHFAAALO0lEQVR4nO2dW2OqvBKGIZHD0kQEBATlpLVf+///4Aat2pYAIUe0+73pRbsWPjJJJpPJjGFKl2PH56N/CHebyEqXy2VqRZtdePCP59h25D/ekPY/e56Tx8d9hEEjjEu0hhAarZqfa1Ti6y+i/THOHc+T9jmkEHpOlsf+J2oASvdK1Sfolg0p+vTjPHOkYIondHJ7UW0aODTM9oMTNZibamHn4s1WMOHKLo5bDLBLDfeQ2/y77bGwV2I/kkjCVRBXUWNyDHQ3NYYdVXEgElIYoRPE/obt5XVe5caPA2HmKogwb41TAN4NsjXXXMxHE0HoBcnBwjzG2RXC1iEJREyu/IReUW8NTD9v0gpiY1sX/Iy8hF5c7Vyxr+8h5O6qmJeRk3BxipAsvgsjik4LjYRxaKG1RL5Wa2SFsSbCIEyl810Z0zDQQOj4xgS3jE8QGT7z+shKuEiBKr4LI0hZhyMb4cceiFrdaeWC/YcywvxtiRXztcLLNxY3ZzphVmyVGuhDEGyLTD6hXeNSC1+rEte2bMIi1PQCr4IgLKQSZmdLxwj8Lmydp1nqJELbVz6FduUCf5KlTiEs9kA33kVgP8VS6QmzJNI3xfxUGSX0lkpNaPupzE3ENKGU3lJpCYMTVOFl02oNT7TOOCXhewh1LhJdQRi+iyR8383HQm9COzpEKsLCmh9gg2hRTak0hLHgOJooIUyz+R8n9M5a/bQhQXAej1ONEjrJbAFbxGR07z9G6CXz8GP6BJKxtzhGeJ43YIN45iOMZ2yiV0EwMt0MExYSovWiBfHwojFI+D7LdfC3kDW49A8RztGTIWnYuxkgDMLnAGwQh2Li/YT2af5j8CZ46t9M9RJm/sx2E0OC0O/dEvcSJunzADaIaTKVsIieZRBehaK+NaOH0N7PJSZDq3LfMxTJhJk/d2etK9AzFMmEs/dGSerxUImEhaU/8DtdLnnPTyK0Q92hezbhkDQUCYRZ/Yw22grUhKFIIHyGDQVZxG1GlzDfPttC8VC57Z4SdwnfntVGW4G3ccKP5bPaaCu47KQzdAj3zzmP3oT3Y4SLZ7bRVuB33s0vQid9xrX+u9zUGSR8Qn/0t4A/RBgYzzzNXAWNYIDwaSIzQ0JhP2H8VPv6PsE07iUU8AqheE3+DD9f4nfChcV3VA9RCVNLtNLJn2NtLciE3onrFSJshSf/33khVnE1HRGdPCJhHHG8wnX5WZ0F3QH5KYag3zr6NhIfhF7F8Qqx5VOmRkxWvZz+cVD1eIkPwoL9lALi00LabdCKwctCu8dG8U7o1cz+GiyryVmf1HL2LF+8W99f4p0w2LK+Qgh9KQPwKrYDMLS9OzZ3woSRrxmDlURA843RC7lH+W+E+YF1X4gZc+jptDqwmRY+3L72G2FhMTps7obrzs6YFoyfC96Dp1+EzpH5FfryLpq3psUaFsNH5wch8zzzfV6WoIR5O3efa74IY9ZXWPr9H49fMcfxwi3p7Uq48hkJoTWWsMOj9w1H6Bb7q2+EwYbxu0JbeWt9sxTyxKbdTfCNMGYNz6CDND4vTvmC71/JUhfCVcUcJJU1DD37X8m5H8fV6k5oR4xGCtOjFL7MXkTcGXVuZN8JC1YjhWniOVQynSzLaP4wy+2P4rgTcTkHFDdC58gcJU1Pb/9odMyz5oOfj8fRv6yr/X9ATNo1uCz6LWHOvK1o1kNAJ7s1vTg5pGN/iHEpKuyOLmdtLaEt/zAGfC0qeVEt1R1PYvtK6Ck4jQH3ZXMVh6WqqCxYeBdCh32toH/WN8fArlRdc8eVcyHMWB2aCfpOaGa1ouMRd5NdCHMF500/CE2vVpT3CPILIbPLNuVRv9xXRWlzreNmmB7rvmLSo34RemoyyNvteUP4qeBhvwmVDI1mRfxsCR0VM1uH0GSOfE0RRE5DqOTb7BLmSpaMZqoxlEw0BEJTxfBvpxrDrJU8qUsYqPhmcd0QKpm4CYSeiiTWct8Qsu5+J4lEqMJM3aghVJJrSSBUkn4FsWk4ShYmEqGSgQgcw9ZGqGiZMpQsFkTClZrlwlBz8YBIqCKTFZwN5kOnaQ/SRYiPhhLXQiOhbzAf0E2SNsLyYKhJR9RGiELjU0nZGW2E609joyRioo0QbozoxQkjgzUHY5r0EVrG9NxGFmkjbPgYMv8YpI9w+X9CQdJJ+Prj8PXn0tdfD1/fp3l9v/T19xavvz98/T3+68dpXj/WpjFeqoQw1hjzVkNoazy3UEPoaDx7UkHYnj1pOz9UQng5P9R1BqyE8HIGrGRB1EWIjxpzMZQQXnIxNOXTKCLM9eVEKSG85kTpyWtTQ3jNa9OSm6iI8JqbqCW/VBHhNb9UQ46wOsJcT563MsJbnrfqXH11hLdcfbX3LVQS3u5bqLwzo/gdft2Z4br3RCkthI97Txx312ilhfBxd439/iH9w7QQ3u8fst8hpX8YiVBy3a3vd0g57gFTikgo+WDv+z1g+Y4bmVDuodD3u9zs9/Gpn0YilDs2ft7HZ66pQCsSYSZ32/azpgJ7XQxKAUINm0zuwd7PuhgcNZToBAgVUDKpB3u/a5uw16ehU6duavtMqUPjd30a9hpDdAKE2guezGOvTo0hjjpRVCpPXULzXSJht04UR60vGkFEqLUk9YJep9aX7LkGEIoOrkJpUw2pXhtHzT0aYUIhG4kDkVRzj6duIoVgSShb9yHrgh6xbiJf7ctx4apL6MiqcE+ufclXv3RUcEnoOpWfpCD21C/lrUE7JhSuuoiBlDbRfTVouesIjz33QFoxKiD8mL23jrDsct6QWDbLCw5AUE2hm/prQcuu5w3RgWCojQseV1uBqcpD9byl12QHnz3VhhOBDx6qyS6/rn4J6+666BWRwPlmuK6+/N4IEBi1nT3KKjtZfv4PiDSd4d4IKvpbQAwif1EEdqNgUYdQKN9ofws1PUpc/CheJnp/Mdaj5A/0mfkDvYJev9/TH+jZ9fp91/5A77zX73/4B3pY/oE+pH+gl+zr9wP+Az2d/0Bf7j/QW920T09EeOov799PaAZP00kPhYRoMwUhY5se9UK7oW5aQ4Tmu5pKsZxC1mC7sEHCp9hmEDcU1IRmzN2hQLYgGOlVNEI4fw+1xxulJ/SSeSOCZKwZ0xih6SQzNlQIktGefaOE7Wn7XBEhOI+30xonbJPe5rloIEzTEI2GsNnzzxERkff0TISz9G6GPZmphOZ7OLOdBoQhZeNTSkIzOEElhWwotYanAWebidC0/XQ+lopSn7obGjWhmSXRXGI3ZZT0bng5CJspVUryy3SB/ZSei1MIG0sV0UqLUy6gt9DJhGZ2tnQH/LF1prfQ6YSNpYZafTgIwqldQacSmnaN9U04Ja4nd5ScTGhmxVbTa4RgW0yzUDZC08zfljpGI16+sTSPZiE0zY+98knVBYy9o9kITXORKjVVCFLCnRSphKbjG6oaxBkQGf7oXl44YRsTT5EKb3yN0qGYtkTCZvMfWtIZ18gKuXqbcxE2w/EUIZlbDoSiE+sAFENoenG1c2UxIndXxbyt23kJ2/zXemtIiP5DbGzrgr81PT9hm4yeHCzB8TiErUMS8POJITTbHrHHLcaivAAX4+2xYHFgCBJE2KyPQexvgABIF4ONHwfM699vCSNstAriKgJcSc0IgKiKA+KlBUaJJGy0sltzZXuVzctrjdMWiWcKJ2zk5Pai2kzL4IYIA7CpFnYuzDjvEk/YyHOyPPY/G5PDpTvMCd2ygUOffpxnjoipsyMphBd5npPH9T7CX/3E0Rp+xc2bn2tU4usvon0d544nBe4ieYR3OXZ8PvqHcLeJrHS5XKZWtNmFB/94jm3xRtnR/wAbq8DZQjmglQAAAABJRU5ErkJggg==',
        description:
          'Provides access to Bittensor developer documentation, supporting developers in using and integrating Bittensor technologies.',
      },
      {
        name: 'Bittensor Subnets',
        logo: 'https://cdn-icons-png.flaticon.com/512/319/319559.png',
        description:
          'Enables management and configuration of Bittensor Subnets, facilitating network customization and control.',
      },
      {
        name: 'Subnet Source Code',
        logo: 'data:image/png;base64,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',
        description:
          'Grants access to the source code of various subnets, allowing for in-depth study and modifications.',
      },
      {
        name: 'Google News Search',
        logo: 'data:image/jpeg;base64,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',
        description:
          'Searches for the latest news articles via Google, keeping users informed about current global events.',
      },
      {
        name: 'Google Image Search',
        logo: 'data:image/png;base64,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',
        description:
          'Searches for images through Google, providing a vast database of images for various uses.',
      },
      {
        name: 'Bing Search',
        logo: 'data:image/jpeg;base64,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',
        description:
          "Provides web search capabilities using Microsoft's Bing search engine, offering an alternative to Google Search.",
      },
      {
        name: 'Wikipedia Search',
        logo: 'data:image/jpeg;base64,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',
        description:
          'Allows users to search for content on Wikipedia, the free encyclopedia, to gather information on a multitude of topics.',
      },
      {
        name: 'Youtube Search',
        logo: 'data:image/png;base64,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',
        description:
          'Enables searching for videos on YouTube, helping users find content ranging from educational to entertainment videos.',
      },
      {
        name: 'ArXiv Search',
        logo: 'data:image/png;base64,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',
        description:
          'Facilitates the search for academic papers on ArXiv, supporting educational and research activities.',
      },
      {
        name: 'Reddit Search',
        logo: 'data:image/png;base64,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',
        description:
          'Allows users to search through Reddit for specific content, discussions, and community insights.',
      },
      {
        name: 'Hacker News Search',
        logo: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAAAe1BMVEX7ZR7////7WAD7Yxn7aCH+6OD7cTb7VQD7XAD+4tn7VAD7YRT7Xwz7cDP+5d3/9fL9wa7+z8D+2s/7d0D9qo78jGP9u6b8hVj+0cP7bS78g1T+3tP9xbP8f077ekb+2Mz8nHv9tZ78k23+7uj9r5b/+fb8o4T8lnH8m3l4HjGPAAAD10lEQVR4nO3b6XaiUBAEYIQYVMhmjNn39f2fcJhkMkIVClxITjenvt+GY6cEKe8likREREREREREREREREREREREREREREREnEnIgMca7m2GS/ZJHnysSzyUhRHz1QSdZWGHSnI80kvwP2tIi2d8X4dp2JFmazjQUeCBBpY/DRRikuFxHkxEWIQ4HSZEivB5MfRbDZSdU4jnASFyhKHn8/DSa3xv84AQZ8cDnc4/ILkbIESO8MpMhFEUX/QPkSJc2onw7zd17xCTBI9wauHb/r/4pm+IFOFJ/DNvNRAn0PEs4gNcmoqw5rusY4gU4Y2tCAuzXiEmEf51ZizCYsIXfI/XHUKk83g9+7m3Gip+DQ8x2cO/NThglL+Fh0gRrixOGKXUom5bhkgRvpq7zHziFtU2RIrQSmtCi8OwECnCZ0v3a2XZFU64bPVpowifjEZYnIlLHPGuRYh0Uzu1UnxZchoSIkUYUp9/S3zSPUSKsMudwq/jFnXfGCL9V+7M3a+VcYtqCpH+KRc2vwu/8U8RTSFShNZaE5o94oi7q3pyAC+315oQtajdIVKEkfEIiwlpGWNXiHQWWmxNKD7qcOmgCB0MGOUP7UOks/DFw4S8FrU9RIzQaGtC3KK2rXMm+/DCN7O33FUptqhtIeJP5WZbE+IWVR8iRfjuJMKaFlUfIkZouDUhblF1IdKrLLcmRF9zdYsQGKHp1oS4RR1QiBRhm98D7IibV5Li++ormpukKbwzBksRRcgp20YtCkPECI0tF7YQ7w6RIrTfmhC1qGpIGOGxi1vuqhRbVDnEDHdvuLmbKaEWVQ4RI3x0GGHNWtRmtyiehU5aE8rOYMLNuYa3M15aE6IW9X29xGpvZJNld9SivkPE29YPpxEWIcL1ZPJ1uuF6oZlNlt3R1/rXJRN/+rezybK72l+acPtTyE5NM2j9epXz9qe2+xlswhZVXDWxdjhrTYha1HuOO+BMPFLRA7aoeQpLN/5aE8LNYAew/23PeYTcotbVynHsPsKaFlWRu4+waFEfOwb02ZoQPxe1MYLPaFTTojZsbrLsLp1vGdBta0LZ7ZYJrW6y7A5/lfnHzXJhM1oo/OK5NSHe0Tcx9Whaf7wXf2Lr0bT+6JEYY4+m9cdrUcYeTeuvcS3KPXo2zfomy87wWjOqC+knnHA6tg+pJhwBTeifJvRPE/qnCf3ThP5pQv80oX+a0D9N6J8m9E8T+qcJ/dOE/mlC/zShf5rQP03onyb0TxP6pwn904QjsDedlxyejORZkrK4YoQDioiIiIiIiIiIiIiIiIiIiIiIiIiImPAHjo4qhIxb0xcAAAAASUVORK5CYII=',
        description:
          'Searches for content on Hacker News, a social news website focusing on computer science and entrepreneurship.',
      },
      {
        name: 'Generate images',
        logo: 'data:image/png;base64,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',
        description:
          'Provides tools for image generation, enabling users to create images through AI-driven processes.',
      },
    ],
  },
  {
    name: 'Subnet 23',
    logo: 'https://images.spr.so/cdn-cgi/imagedelivery/j42No7y-dcokJuNgXeA0ig/07dfc443-14b4-4172-af2f-ba14796c50d6/NicheTensor_icon/w=1920,quality=80,fit=scale-down',
    apis: [
      {
        name: 'AnimeV3',
        description: `This model is excellent for creating detailed illustrations and animated images, perfect for artists and animators.`,
        icon: '🌀',
        logo: null,
      },
      {
        name: 'JuggernautXL',
        description:
          'A high-quality image generation model designed to produce exceptionally detailed and realistic images.',
        icon: '⚔️',
        logo: null,
      },
      {
        name: 'RealitiesEdgeXL',
        description:
          'A fast and efficient model for generating realistic pictures, ideal for quick rendering of high-fidelity images.',
        icon: '🏞️',
        logo: null,
      },
      {
        name: 'DreamShaperXL',
        description:
          'A powerful model for transforming images, capable of modifying and enhancing photos in complex ways.',
        icon: '🌙',
        logo: null,
      },
    ],
  },
]

export const SDK_DATA = [
  {
    name: 'Node.js',
    logo: 'data:image/png;base64,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',
    code: `
    const { Datura } = require('@datura/node')

    const datura = new Datura({
      apiKey: '<insert-api-key-here>',
      appId: '<insert-application-id-here>',
      consumerId: '<insert-consumer-id-here>'
    })
    
    // Declare the Unified API you want to use
    const { crm } = datura
    
    // Override consumerId serviceId as declared in initial configuration for this operation.
    const response = await crm.contactsAll({
      // serviceId: 'salesforce', // optional
      limit: 10
    })
    
    `,
  },
  {
    name: 'PHP',
    logo: 'data:image/png;base64,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',
    code: `
    <?php
    require('vendor/autoload.php');
    
    use Datura\\Client\\Datura;
    use Datura\\Client\\DaturaConfiguration;
    
    $config = new Datura('<insert-api-key-here>', '<insert-application-id-here>', '<insert-consumer-id-here>');
    $datura = new Datura($config);
    
    $response = $datura->getCrmApi()->contactsAll(false, null, null, null, null, 1);
    
    ?>
    
    `,
  },
  {
    name: '.NET',
    logo: 'data:image/jpeg;base64,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',
    code: `
    using Datura.Api;
    using Datura.Client;
    using Datura.Model;
    
    namespace Example
    {
        public class CompaniesAllExample
        {
            public static void Main()
            {
                Configuration config = new Configuration();
                // Configure API key authorization: apiKey
                config.AddApiKey("Authorization", "API_KEY");
                config.AddApiKeyPrefix("Authorization", "Bearer");
    
                var apiInstance = new CrmApi(config);
                var raw = false;  // bool? | Include raw response. Mostly used for debugging purposes (optional)  (default to false)
                var consumerId = "CONSUMER_ID";  // string | ID of the consumer which you want to get or push data from (optional)
                var appId = "APP_ID";  // string | The ID of your Unify application (optional)
                var serviceId = "salesforce";  // string | Provide the service id you want to call (e.g., pipedrive). [See the full list in the connector section.](#section/Connectors) Only needed when a consumer has activated multiple integrations for a Unified API. (optional)
    
                try
                {
                    Console.WriteLine("Calling Datura");
                    // List companies
                    GetCompaniesResponse result = apiInstance.CompaniesAll(raw, consumerId, appId, serviceId);
                    Console.WriteLine("Success", result);
                }
                catch (ApiException e)
                {
                    Console.WriteLine("Exception when calling CrmApi.CompaniesAll: " + e.Message);
                    Console.WriteLine("Status Code: " + e.ErrorCode);
                    Console.WriteLine("Detail: " + e.ErrorContent);
                }
            }
        }
    }
    
    `,
  },
  {
    name: 'Python',
    logo: 'data:image/jpeg;base64,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',
    code: `
    import datura
    from datura.api import crm_api
    from datura.model.contacts_sort import ContactsSort
    from datura.model.sort_direction import SortDirection
    from pprint import pprint
    
    configuration = datura.Configuration()
    
    configuration.api_key['apiKey'] = '<insert-api-key-here>'
    configuration.api_key_prefix['apiKey'] = 'Bearer'
    
    with datura.ApiClient(configuration) as api_client:
        # Create an instance of the API class
        api_instance = crm_api.CrmApi(api_client)
        raw = False
        consumer_id = '<insert-consumer-id-here>'
        app_id = '<insert-application-id-here>'
        service_id = '<insert-service-id-here>'
        limit = 20
    
        sort = ContactsSort(
            by="name",
            direction=SortDirection("asc"),
        ) 
        
    
        try:
            # List contacts
            api_response = api_instance.contacts_all(raw=raw, consumer_id=consumer_id, app_id=app_id, service_id=service_id, limit=limit, sort=sort)
            pprint(api_response)
        except datura.ApiException as e:
            print("Exception when calling CrmApi->contacts_all: %s
    " % e)
    `,
  },
]
