export const chipStyles = {
  maxWidth: '100%',
  fontFamily: `Inter, -apple-system, BlinkMacSystemFont, "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji"`,
  display: 'inline-flex',
  alignItems: 'center',
  justifyContent: 'center',
  height: '32px',
  color: 'rgb(34, 51, 84)',
  backgroundColor: 'rgba(34, 51, 84, 0.1)',
  whiteSpace: 'nowrap',
  cursor: 'default',
  outline: '0px',
  textDecoration: 'none',
  border: '0px',
  padding: '10px',
  verticalAlign: 'middle',
  boxSizing: 'border-box',
  borderRadius: '0px 10px',
  fontSize: '14px',
  marginTop: '-18px',
  position: 'absolute',
  right: '0px',
}

export const borderBoxStyles = {
  color: 'rgb(34, 51, 84)',
  transition: 'box-shadow 300ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
  borderRadius: '10px',
  overflow: 'hidden',
  boxShadow: 'none',
  background: '',
  padding: '18px',
  position: 'relative',
  width: '100%',
}

export const buttonStyles = {
  background: 'transparent',
  color: 'rgba(34, 51, 84, 0.7)',
  borderRadius: '10px',
  boxShadow: 'none',
  border: '1px solid rgba(34, 51, 84, 0.7)',
  '&:hover': {
    background: 'transparent',
    boxShadow: 'none',
  },
}

export const black = '#000000'
export const white = 'rgb(255, 255, 255)'
