"""Add assigned_account_id in  user_account_access table

Revision ID: f1d5bc37bceb
Revises: 29f8e16f34db
Create Date: 2024-05-28 15:01:07.211417

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'f1d5bc37bceb'
down_revision: Union[str, None] = '29f8e16f34db'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('user_account_access', sa.Column('assigned_account_id', sa.UUID(), nullable=True))
    op.create_index(op.f('ix_user_account_access_assigned_account_id'), 'user_account_access', ['assigned_account_id'], unique=False)
    op.create_foreign_key('fk_assigned_account_id', 'user_account_access', 'account', ['assigned_account_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('fk_assigned_account_id', 'user_account_access', type_='foreignkey')
    op.drop_index(op.f('ix_user_account_access_assigned_account_id'), table_name='user_account_access')
    op.drop_column('user_account_access', 'assigned_account_id')
    # ### end Alembic commands ###
