"""Template Pod relation

Revision ID: 8ee8b2ab331f
Revises: aa2dd6264fd3
Create Date: 2024-06-07 10:07:32.210936

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '8ee8b2ab331f'
down_revision: Union[str, None] = 'aa2dd6264fd3'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('pod', sa.Column('template', sa.UUID(), nullable=True))
    op.create_index(op.f('ix_pod_template'), 'pod', ['template'], unique=False)
    op.create_foreign_key(None, 'pod', 'template', ['template'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'pod', type_='foreignkey')
    op.drop_index(op.f('ix_pod_template'), table_name='pod')
    op.drop_column('pod', 'template')
    # ### end Alembic commands ###
