"""Add user_account_access table

Revision ID: 29f8e16f34db
Revises: 
Create Date: 2024-05-28 14:27:22.559514

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '29f8e16f34db'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('user_account_access',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('assigned_user_id', sa.UUID(), nullable=True),
    sa.Column('account_id', sa.UUID(), nullable=True),
    sa.Column('is_deleted', sa.Boolean(), nullable=True),
    sa.Column('created_by', sa.UUID(), nullable=True),
    sa.Column('modified_by', sa.UUID(), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), nullable=False),
    sa.Column('updated_on', sa.DateTime(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['account_id'], ['account.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['assigned_user_id'], ['user.id'], name='fk_assigned_user_id', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by'], ['user.id'], name='fk_created_by', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['modified_by'], ['user.id'], name='fk_modified_by', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_user_account_access_assigned_user_id'), 'user_account_access', ['assigned_user_id'], unique=False)
    op.create_index(op.f('ix_user_account_access_created_by'), 'user_account_access', ['created_by'], unique=False)
    op.create_index(op.f('ix_user_account_access_id'), 'user_account_access', ['id'], unique=False)
    op.create_index(op.f('ix_user_account_access_is_deleted'), 'user_account_access', ['is_deleted'], unique=False)
    op.create_index(op.f('ix_user_account_access_modified_by'), 'user_account_access', ['modified_by'], unique=False)
    op.alter_column('run_log', 'toolkit_id',
               existing_type=sa.VARCHAR(length=255),
               type_=sa.UUID(),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('run_log', 'toolkit_id',
               existing_type=sa.UUID(),
               type_=sa.VARCHAR(length=255),
               existing_nullable=True)
    op.drop_index(op.f('ix_user_account_access_modified_by'), table_name='user_account_access')
    op.drop_index(op.f('ix_user_account_access_is_deleted'), table_name='user_account_access')
    op.drop_index(op.f('ix_user_account_access_id'), table_name='user_account_access')
    op.drop_index(op.f('ix_user_account_access_created_by'), table_name='user_account_access')
    op.drop_index(op.f('ix_user_account_access_assigned_user_id'), table_name='user_account_access')
    op.drop_table('user_account_access')
    # ### end Alembic commands ###
