<p align="center">
  <a href="https://l3agi.com//#gh-light-mode-only">
    <img src="./apps/ui/src/assets/images/l3_logo.png" alt="L3AGI logo" width="150px" height="150px"/>
  </a>
</p>

<p align="center"><i>Open-source tool that enables AI Assistants to collaborate together as effectively as human teams.</i></p>
    
<h3 align="center">
	<a href="https://l3agi.com?utm_medium=community&utm_source=github">Try Our Cloud</a>
	<span> | </span>
	<a href="./docs/basic.md">Docs</a>
	<span> | </span>
	<a href="https://discord.gg/FcVZKcaRCV">Community Discord</a>
</h3>

<p align="center">
<a href="https://github.com/l3vels/L3AGI/fork" target="blank">
<img src="https://img.shields.io/github/forks/l3vels/L3AGI?style=for-the-badge" alt="L3AGI forks"/>
</a>

<a href="https://github.com/l3vels/L3AGI/stargazers" target="blank">
<img src="https://img.shields.io/github/stars/l3vels/L3AGI?style=for-the-badge" alt="L3AGI stars"/>
</a>
<a href='https://github.com/l3vels/L3AGI/releases'>
<img src='https://img.shields.io/github/release/l3vels/L3AGI?&label=Latest&style=for-the-badge'>
</a>

</p>

<p align="center"><b>Follow L3AGI </b></p>

<p align="center">
<a href="https://twitter.com/l3velshq" target="blank">
<img src="https://img.shields.io/twitter/follow/l3vels?label=Follow: l3vels&style=social" alt="Follow L3AGI"/>
</a>
<a href="https://www.reddit.com/r/L3AGI/" target="_blank"><img src="https://img.shields.io/twitter/url?label=/r/L3AGI&logo=reddit&style=social&url=https://github.com/l3vels/L3AGI"/></a>

<a href="https://discord.gg/FcVZKcaRCV" target="blank">
<img src="https://img.shields.io/discord/1085735429426401340?label=Join%20L3AGI&logo=discord&style=social" alt="Join L3AGI Discord Community"/>
</a>
<a href="https://www.youtube.com/@L3AGI" target="_blank"><img src="https://img.shields.io/twitter/url?label=Youtube&logo=youtube&style=social&url=https://github.com/l3vels/L3AGI"/></a>
</p>

<p align="center"><b>Connect with the Creators </b></p>

<p align="center">
<a href="https://twitter.com/gigch_eth" target="blank">
<img src="https://img.shields.io/twitter/follow/gigch_eth?label=Follow: Giga&style=social" alt="Follow Chkhikvadze"/>
</a>
<a href="https://twitter.com/EduardoFaraday" target="blank">
<img src="https://img.shields.io/twitter/follow/EduardoFaraday?label=Follow: EduardoFaraday&style=social" alt="Follow EduardoFaraday"/>
</a>
<a href="https://twitter.com/MOkradze" target="blank">
<img src="https://img.shields.io/twitter/follow/MOkradze?label=Follow: MOkradze&style=social" alt="Follow Okradze"/>
</a>
</p>

Of course! Here's the revised "Features" section with the requested emojis and in its entirety:

---

## ✨ Features

<a href="https://youtu.be/R2hYNONKwKI" target="_blank" rel="noopener noreferrer">
    <img src="docs/assets/playYTFeatures.png" alt="Watch the video">
</a>

L3AGI offers a robust set of functionalities that empower you to design, supervise, and execute both autonomous AI Assistants and Teams of Assistants. Here's what sets us apart:

- **🤖 Team Of Assistants**: L3AGI pioneers in facilitating the creation and management of Teams of AI Assistants. These are groups of individual AI Assistants that collaborate seamlessly for more complex tasks and simulations.

- **🔧 Autonomous AI Assistants**: Design and oversee standalone AI Assistants that act autonomously based on their configuration.

- **🧠 Assistant Memory**: Equip your AI Assistants with the ability to retain and recall information, enabling them to make more informed decisions.

- **🔗 Data Sources & Integration**:
  - Connect your AI Assistants to an array of data sources for efficient information retrieval and processing.
  - Integrate VectorDBs for enhanced data management and querying capabilities.
  - Employ the LlamaIndex (GPT Index) to boost the data framework for your LLM application.

<table align="center" border="0">
  <tr>
    <td align="center"><img src="./apps/ui/src/assets/images/postgres.png" width="50px"><br>Postgres</td>
    <td align="center"><img src="./apps/ui/src/assets/images/mySql.png" width="50px"><br>Mysql</td>
    <td align="center"><img src="./apps/ui/src/assets/images/uploadFile.png" width="50px"><br>Files</td>
    <td align="center"><img src="./apps/ui/src/assets/images/web_black.png" width="50px"><br>WebPage</td>
    <td align="center"><img src="./apps/ui/src/assets/images/notionLogo.png" width="50px"><br>Notion</td>
    <td align="center"><img src="./apps/ui/src/assets/images/google_analytics.png" width="50px"><br>Google Analytics</td>
    <td align="center"><img src="./apps/ui/src/assets/images/firebase.svg" width="50px"><br>Firebase</td>
  </tr>
</table>

- **🛠 Toolkits**: Empower your AI Assistants with our curated sets of tools, tailor-made for specific tasks.

<table align="center" border="0">
  <tr>
    <td align="center"><img src="./apps/ui/src/assets/tools/google.png" width="35px"><br>SERP</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/webscrapping.png" width="35px"><br>Web Scraper</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/DuckDuckGo.png" width="35px"><br>DuckDuckGo</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/bing.png" width="35px"><br>Bing</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/wikipedia.png" width="35px"><br>Wikipedia</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/arxiv.jpeg" width="35px"><br>Arxiv</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/openweather.svg" width="35px"><br>OpenWeather</td>
  </tr>
  <tr>
    <td align="center"><img src="./apps/ui/src/assets/tools/chart.png" width="35px"><br>Charts</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/twilio.png" width="35px"><br>Twilio</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/twitter.png" width="35px"><br>Twitter</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/instagram.webp" width="35px"><br>Instagram</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/slack.png" width="35px"><br>Slack</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/gmail.png" width="35px"><br>Gmail</td>
    <td align="center"><img src="./apps/ui/src/assets/tools/googleCalendar.png" width="35px"><br>Google Calendar</td>
  </tr>
</table>

- **📊 Chart Generator**: Turn your data into insightful visualizations with our intuitive chart generator.

- **📄 Report Generator**: Streamline report creation with our user-friendly report generator tool.

- **🌐 Community Building**: Engage with a dynamic community to collectively enhance and refine your AI Assistants.

- **🖥 User Interface (UI)**: Utilize our sleek, user-friendly interface for building and managing your AI Assistants and their teams.

- **📡 APIs**: Robust APIs ensure smooth integration of L3AGI with other systems and support advanced customizations for your specific needs.

## 🚀 Roadmap [here](https://github.com/orgs/l3vels/projects/1)

<br>

## ⚡ Quick Start

<a href="https://youtu.be/-dFJiypmCJA" target="_blank" rel="noopener noreferrer">
    <img src="docs/assets/quickstart.png" alt="Watch the video">
</a>

### Pre-requisites

- Docker 🐳
- Docker Compose

1. **Clone the repository:**

   ```bash
   git clone https://github.com/l3vels/L3AGI.git
   ```

2. **Navigate to the project directory:**

   ```bash
   cd L3AGI
   ```

3. **Setup Git Hooks**

   ```bash
   chmod +x setup.sh
   ./setup.sh
   ```

4. **Create `.env` file from `.env.example` in `apps/server` directory and configure**
   - **Configure `Azure Web PubSub` using [our guide here](docs/azure.md)**
5. **Create `.env` file from `.env.example` in `zep` directory and configure**

6. 🐳 **Run Docker Compose:**

   ```bash
   docker-compose up --build
   ```

   This will build and start both the React UI and FastAPI services.

## Access the Services

- **React UI**: Open `http://localhost:3000` in your browser.
- **FastAPI Server**: Open `http://localhost:4000` in your browser or API client.

## Directory Structure

```
.
├── apps/
│ ├── ui/ # React UI Application
│ └── server/ # Python FastAPI Server
└── docker-compose.yml # Main Docker Compose File
```

## Tech Stack

![Python](https://img.shields.io/badge/python-3670A0?style=for-the-badge&logo=python&logoColor=ffdd54)
![FastAPI](https://img.shields.io/badge/FastAPI-009688?style=for-the-badge&logo=FastAPI&logoColor=white)
![SQLAlchemy](https://img.shields.io/badge/SQLAlchemy-6f7f6f?style=for-the-badge&logo=SQLAlchemy&logoColor=white)
![LangChain](https://img.shields.io/badge/LangChain-b7d019?style=for-the-badge&logo=LangChain&logoColor=white)
![Zep](https://img.shields.io/badge/Zep-7e56c2?style=for-the-badge&logo=zep&logoColor=white)
![Postgres](https://img.shields.io/badge/PostgreSQL-316192?style=for-the-badge&logo=postgresql&logoColor=white)

![React](https://img.shields.io/badge/React-20232A?style=for-the-badge&logo=react&logoColor=61DAFB)
![TypeScript](https://img.shields.io/badge/TypeScript-007ACC?style=for-the-badge&logo=typescript&logoColor=white)
![Vite](https://img.shields.io/badge/Vite-B73BFE?style=for-the-badge&logo=vite&logoColor=FFD62E)
![ESLint](https://img.shields.io/badge/eslint-3A33D1?style=for-the-badge&logo=eslint&logoColor=white)
![Prettier](https://img.shields.io/badge/prettier-1A2C34?style=for-the-badge&logo=prettier&logoColor=F7BA3E)

![GitHub Actions](https://img.shields.io/badge/github%20actions-%232671E5.svg?style=for-the-badge&logo=githubactions&logoColor=white)
![Microsoft Azure](https://img.shields.io/badge/Microsoft_Azure-0089D6?style=for-the-badge&logo=microsoft-azure&logoColor=white)
![AWS](https://img.shields.io/badge/Amazon_AWS-232F3E?style=for-the-badge&logo=amazon-aws&logoColor=white)

## L3AGI Architecture

<details>
  <summary>Database Schema</summary>
  
  ![DB ERD](docs/assets/ERD.jpg)
</details>

<br/>

## Troubleshooting

- If you encounter issues when starting the services, ensure Docker and Docker Compose are installed and up to date.
- Check the logs for any service-specific errors.

## 🚧 In Progress!

This initiative is currently in its developmental phase and might have some inconsistencies. We value your patience and comprehension. Should you face any challenges, kindly consult our list of existing issues first. If you can't find a relevant one, please open a new issue explaining the concern you faced. Your backing means a lot to us! Thank you!

## Contributors

[![Chkhikvadze](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/10281306?v=4&w=50&h=50&mask=circle)](https://github.com/Chkhikvadze)
[![Okradze](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/22216909?v=4&w=50&h=50&mask=circle)](https://github.com/okradze)
[![Levanion](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/91427080?v=4&w=50&h=50&mask=circle)](https://github.com/levanion)
[![Bakhutashvili](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/85249145?v=4&w=50&h=50&mask=circle)](https://github.com/DavitBakhutashvili)
[![Theiskaa](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/59066341?v=4&w=50&h=50&mask=circle)](https://github.com/theiskaa)
[![edufaraday](https://images.weserv.nl/?url=https://avatars.githubusercontent.com/u/56274334?v=4&w=50&h=50&mask=circle)](https://github.com/edufaraday)
