# Contributing to L3AGI
<p align="center">
  <a href="https://l3agi.com//#gh-light-mode-only">
    <img src="./apps/ui/src/assets/images/l3_logo.png" alt="L3AGI logo" width="150px" height="150px"/>
  </a>
</p>

First off, thank you for considering contributing to L3AGI. It's people like you that make L3AGI] such a great tool.

## Getting Started

- Make sure you've read the [README.md](README.md) for general information on the project.
- Check the project's open issues; starting with a bug report or a feature request is always a good idea.
  
## Ways to Contribute

1. **Reporting Bugs**: If you find a bug, look for existing issues on the topic. If you can't find one, create a new one.
2. **Suggesting Enhancements**: If you have an idea to enhance the project, create a feature request issue.
3. **Pull Requests**: Improve the project by submitting pull requests. Whether it's fixing a bug, adding new features, or updating documentation, your contributions are welcome!

## Pull Request Guidelines

- Before submitting a pull request, please ensure there's a corresponding issue.
- Fork the repository and create your branch from `main` (or the current main branch).
- Ensure the test suite passes (if there are tests).
- Write a good commit message.

## Code of Conduct

By participating, you are expected to uphold our [Code of Conduct](CODE_OF_CONDUCT.md). Please report unacceptable behavior to [giga@l3vels.xyz].

## Need help?

If you have questions, feel free to ask. Create an issue or [contact us directly](mailto:[giga@l3vels.xyz]).

## Closing Notes

Again, thank you for your contributions! Open source projects live by the contributions of their community. Your time and dedication are much appreciated!

