import Card from "@/components/home/card";
import Layout from "@/components/layout/index";
import Balancer from "react-wrap-balancer";
import { motion } from "framer-motion";
import { DEPLOY_URL, FADE_DOWN_ANIMATION_VARIANTS } from "@/lib/constants";
import { Github, Twitter } from "@/components/shared/icons";

import WebVitals from "@/components/home/web-vitals";
import ComponentGrid from "@/components/home/component-grid";
import Image from "next/image";

export default function Home() {
  return (
    <Layout>
      <motion.div
        className="max-w-xl px-5 xl:px-0"
        initial="hidden"
        animate="show"
        viewport={{ once: true }}
        variants={{
          hidden: {},
          show: {
            transition: {
              staggerChildren: 0.15,
            },
          },
        }}
      >
        <motion.a
          variants={FADE_DOWN_ANIMATION_VARIANTS}
          href="https://twitter.com/kyegomez"
          target="_blank"
          rel="noreferrer"
          className="mx-auto mb-5 flex max-w-fit items-center justify-center space-x-2 overflow-hidden rounded-full bg-blue-100 px-7 py-2 transition-colors hover:bg-blue-200"
        >
          <Twitter className="h-5 w-5 text-[#1d9bf0]" />
          <p className="text-sm font-semibold text-[#1d9bf0]">
            Explore The Domain
          </p>
        </motion.a>
        <motion.h1
          className="bg-gradient-to-br from-black to-stone-500 bg-clip-text text-center font-display text-4xl font-bold tracking-[-0.02em] text-transparent drop-shadow-sm md:text-7xl md:leading-[5rem]"
          variants={FADE_DOWN_ANIMATION_VARIANTS}
        >
          <Balancer>The Domain</Balancer>
        </motion.h1>
        <motion.p
          className="mt-6 text-center text-gray-500 md:text-xl"
          variants={FADE_DOWN_ANIMATION_VARIANTS}
        >
          <Balancer>
           An interface with your digital data spirit.
          </Balancer>
        </motion.p>
        <motion.div
          className="mx-auto mt-6 flex items-center justify-center space-x-5"
          variants={FADE_DOWN_ANIMATION_VARIANTS}
        >
          <a
            className="group flex max-w-fit items-center justify-center space-x-2 rounded-full border border-black bg-black px-5 py-2 text-sm text-white transition-colors hover:bg-white hover:text-black"
            href={DEPLOY_URL}
            target="_blank"
            rel="noopener noreferrer"
          >
            <svg
              className="h-4 w-4 group-hover:text-black"
              viewBox="0 0 24 24"
              fill="currentColor"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M12 4L20 20H4L12 4Z"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
              />
            </svg>
            <p>Deploy to Vercel</p>
          </a>
          <a
            className="flex max-w-fit items-center justify-center space-x-2 rounded-full border border-gray-300 bg-white px-5 py-2 text-sm text-gray-600 shadow-md transition-colors hover:border-gray-800"
            href="https://github.com/kyegomez/The-Domain"
            target="_blank"
            rel="noopener noreferrer"
          >
            <Github />
            <p>Star on GitHub</p>
          </a>
        </motion.div>
      </motion.div>
      <div className="my-10 grid w-full max-w-screen-xl animate-[slide-down-fade_0.5s_ease-in-out] grid-cols-1 gap-5 px-5 md:grid-cols-3 xl:px-0">
        {features.map(({ title, description, demo, large }) => (
          <Card
            key={title}
            title={title}
            description={description}
            demo={demo}
            large={large}
          />
        ))}
      </div>
    </Layout>
  );
}

const features = [
  {
    title: "Seamless Data Interaction",
    description: "Use simple conversation to interact with your data and tools - no complex syntax needed!",
    demo: <WebVitals />,
    large: true,
  },
  {
    title: "10x Faster Insights",
    description: "Experience lightning-fast results by querying data conversationally, making your decision-making process more efficient.",
    demo: <WebVitals />,
  },
  {
    title: "Data Security",
    description: "We prioritize your data's security. The Domain is built with top-notch security features to protect your data.",
    demo: <WebVitals />,
  },
  {
    title: "All-New Multi-Modality Models",
    description: "The Domain isn't restricted to just textual models, The Domain offers models that can understand images, videos, audio and much more",
    demo: <WebVitals />,
  },
  {
    title: "Swarms",
    description: "Unleash the power of multiple agents working together seamlessly to complete your ambitious tasks!",
    demo: <WebVitals />,
  },
  {
    title: "100s of tools",
    description: "Integrate your favorite apps and ingest data to The Domain and allow Swarms and Friends to automate your activities for you!",
    demo: <WebVitals />,
  },
  {
    title: "Deep Personalization",
    description: "Models on The Domain are fine-tuned on your own data to deliver a seamless and personalized experience.",
    demo: <WebVitals />,
  },
  {
    title: "Multi-Modal WorkPlace Search",
    description: "Search through company documents from dozens of apps and data types seamlessly.",
    demo: <WebVitals />,
  },
  {
    title: "Open-Source",
    description: "Deploy in 1 click and contribute!",
    demo: (
      <a href={DEPLOY_URL}>
        {/* eslint-disable-next-line @next/next/no-img-element */}
        <img
          src="https://vercel.com/button"
          alt="Deploy with Vercel"
          width={120}
        />
      </a>
    ),
  },
  {
    title: "Multi-Modal AI Tools",
    description: "Leverage advanced AI tools without the need for complex coding skills.",
    demo: (
      <div className="flex items-center justify-center space-x-20">
        <Image alt="AI logo" src="/ai.webp" width={50} height={50} />
        <Image alt="ML logo" src="/ml.svg" width={50} height={50} />
      </div>
    ),
  },
  {
    title: "Extensive App Integration",
    description: "Quickly link up hundreds of apps via connectors and APIs, making your work more streamlined.",
    demo: <ComponentGrid />,
  },
];
