import { IconCheck, IconTrash, IconX } from "@tabler/icons-react";
import { FC, useState } from "react";
import { SidebarButton } from "./SidebarButton";

interface Props {
  onClearConversations: () => void;
}

export const ClearConversations: FC<Props> = ({ onClearConversations }) => {
  const [isConfirming, setIsConfirming] = useState<boolean>(false);

  const handleClearConversations = () => {
    onClearConversations();
    setIsConfirming(false);
  };

  return isConfirming ? (
    <div className="flex hover:bg-[#343541] py-2 px-2 rounded-md cursor-pointer w-full items-center">
      <IconTrash size={16} />

      <div className="ml-2 flex-1 text-left text-white">Are you sure?</div>

      <div className="flex w-[40px]">
        <IconCheck
          className="ml-auto min-w-[20px] text-neutral-400 hover:text-neutral-100"
          size={18}
          onClick={(e) => {
            e.stopPropagation();
            handleClearConversations();
          }}
        />

        <IconX
          className="ml-auto min-w-[20px] text-neutral-400 hover:text-neutral-100"
          size={18}
          onClick={(e) => {
            e.stopPropagation();
            setIsConfirming(false);
          }}
        />
      </div>
    </div>
  ) : (
    <SidebarButton
      text="Clear conversations"
      icon={<IconTrash size={16} />}
      onClick={() => setIsConfirming(true)}
    />
  );
};
