# Internationalization

The default language of <b>Element UI SaaS Extend</b> is Chinese, If you wish to use another language, you'll need to do some i18n configuration.

```javascript
import Vue from "vue";
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import locale from "element-ui/lib/locale/lang/en.js";
Vue.use(ElementUI, { locale });

import "element-ui-saas-extend/lib/theme-chalk/index.css";
import ElementUISaaSExtend from "element-ui-saas-extend";
import locale from "element-ui-saas-extend/lib/locale/en.js";
Vue.use(ElementUISaaSExtend, { locale });
```

### Import via CDN

```html
<script src="//unpkg.com/vue"></script>
<script src="//unpkg.com/element-ui"></script>
<script src="//unpkg.com/element-ui-saas-extend"></script>
<script src="//unpkg.com/element-ui/lib/umd/locale/en.js"></script>
<script src="//unpkg.com/element-ui-saas-extend/lib/locale/en.js"></script>

<script>
  ELEMENT.locale(ELEMENT.lang.en);
  ElementUISaaSExtend.locale(ElementUISaaSExtend.lang["zhCN"]);
</script>
```

### Currently ships with the following languages:

* Simplified Chinese (zh-CN)
* English (en)