'use client'

import { usePathname } from 'next/navigation'
import Link from 'next/link'

const navData = [
  {
    name: 'Component',
    href: '/components',
  },
  {
    name: 'Templates',
    href: '/templates',
  },
]

export default function Nav() {
  const pathname = usePathname()

  const button = `  min-h-[3rem] px-4 active:scale-105 scale-110 active:transition-all duration-50 active:bg-white/10 hover:bg-white/10 flex justify-center items-center rounded-xl`
  return (
    <>
      <div className=" w-full outerSans flex  text-xl font-bold border-b-2 border-gray-600  ">
        <div className="w-full container mx-auto">
          <div className="flex justify-between items-center px-4 pt-6 md:pb-6">
            <div className="flex ">
              <Link href="/" passHref>
                <button className={`gradientText hero-title text-[50px] font-bold leading-none `}>
                  <h1>dev.UI</h1>
                </button>
              </Link>
            </div>
            <nav className="hidden md:flex space-x-10 items-center">
              {navData.map((n) => {
                return (
                  <Link key={n.name} href={n.href} passHref>
                    <button
                      type="button"
                      className={`${button} ${
                        pathname?.includes(n.href) && 'bg-white/10'
                      } text-[25px] cursor-pointer`}
                    >
                      {n.name}
                    </button>
                  </Link>
                )
              })}
            </nav>

            <a
              title="Github link Dev.Ui"
              href="https://github.com/kumard3/dev.ui"
              target="_blank"
              rel="noreferrer"
              aria-label="Github"
            >
              <svg
                fill="white"
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 30 30"
                width="40px"
                height="40px"
              >
                <path d="M15,3C8.373,3,3,8.373,3,15c0,5.623,3.872,10.328,9.092,11.63C12.036,26.468,12,26.28,12,26.047v-2.051 c-0.487,0-1.303,0-1.508,0c-0.821,0-1.551-0.353-1.905-1.009c-0.393-0.729-0.461-1.844-1.435-2.526 c-0.289-0.227-0.069-0.486,0.264-0.451c0.615,0.174,1.125,0.596,1.605,1.222c0.478,0.627,0.703,0.769,1.596,0.769 c0.433,0,1.081-0.025,1.691-0.121c0.328-0.833,0.895-1.6,1.588-1.962c-3.996-0.411-5.903-2.399-5.903-5.098 c0-1.162,0.495-2.286,1.336-3.233C9.053,10.647,8.706,8.73,9.435,8c1.798,0,2.885,1.166,3.146,1.481C13.477,9.174,14.461,9,15.495,9 c1.036,0,2.024,0.174,2.922,0.483C18.675,9.17,19.763,8,21.565,8c0.732,0.731,0.381,2.656,0.102,3.594 c0.836,0.945,1.328,2.066,1.328,3.226c0,2.697-1.904,4.684-5.894,5.097C18.199,20.49,19,22.1,19,23.313v2.734 c0,0.104-0.023,0.179-0.035,0.268C23.641,24.676,27,20.236,27,15C27,8.373,21.627,3,15,3z" />
              </svg>
            </a>
          </div>
          <div className="justify-center  flex py-4 md:hidden sm:py-0">
            <nav className="flex md:hidden w-full justify-around items-center">
              {navData.map((n) => {
                return (
                  <Link key={n.name} href={n.href} passHref>
                    <button className={`${button} text-xl md:text-2xl cursor-pointer`}>
                      {n.name}
                    </button>
                  </Link>
                )
              })}
            </nav>
          </div>
        </div>
      </div>
    </>
  )
}

// bg-[#EF404A]
