/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	kudov1beta1 "github.com/kudobuilder/kudo/pkg/apis/kudo/v1beta1"
	versioned "github.com/kudobuilder/kudo/pkg/client/clientset/versioned"
	internalinterfaces "github.com/kudobuilder/kudo/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/kudobuilder/kudo/pkg/client/listers/kudo/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// OperatorVersionInformer provides access to a shared informer and lister for
// OperatorVersions.
type OperatorVersionInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.OperatorVersionLister
}

type operatorVersionInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewOperatorVersionInformer constructs a new informer for OperatorVersion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewOperatorVersionInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredOperatorVersionInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredOperatorVersionInformer constructs a new informer for OperatorVersion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredOperatorVersionInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KudoV1beta1().OperatorVersions(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KudoV1beta1().OperatorVersions(namespace).Watch(context.TODO(), options)
			},
		},
		&kudov1beta1.OperatorVersion{},
		resyncPeriod,
		indexers,
	)
}

func (f *operatorVersionInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredOperatorVersionInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *operatorVersionInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&kudov1beta1.OperatorVersion{}, f.defaultInformer)
}

func (f *operatorVersionInformer) Lister() v1beta1.OperatorVersionLister {
	return v1beta1.NewOperatorVersionLister(f.Informer().GetIndexer())
}
